<?php

use App\Http\Controllers\Admin\DriverManagementController;
use App\Http\Controllers\Api\AcceptRideController;
use App\Http\Controllers\Api\ActiveRideController;
use App\Http\Controllers\Api\CancelRideController;
use App\Http\Controllers\Api\DriverReachController;
use App\Http\Controllers\Api\OtpController;
use App\Http\Controllers\Api\PendingRideController;
use App\Http\Controllers\Api\StartRideController;
use App\Http\Controllers\Api\UpcomingRideController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/
Route::group(['middleware' => ['log.api']], function () {
    Route::post('/driver/login', [App\Http\Controllers\Api\DriverAuthController::class, 'login']);
});
//API Call Like this  -> https://cyberbahntas.com/vaigaitaxi/api/driver/end-ride

Route::group(['middleware' => ['log.api', 'auth:api_driver']], function () {
    Route::post('/driver-status', [DriverManagementController::class, 'updateLocation']);

    Route::post('/driver/pending-rides', [PendingRideController::class, 'pendingRides']);
    Route::post('/driver/upcoming-rides', [UpcomingRideController::class, 'upcomingRides']);

    Route::post('/driver/accept-ride', [AcceptRideController::class, 'acceptRide']);
    Route::post('/driver/verifyOtp', [OtpController::class, 'verifyOtp']);
    Route::post('/driver/start-ride', [StartRideController::class, 'StartRide']);
    Route::post('/driver/end-ride', [StartRideController::class, 'EndRide']);
    // Route::post('/driver/trip-details', [StartRideController::class, 'getTripDetails']);
    Route::post('/driver/driverdeparture', [DriverReachController::class, 'driverdeparture']);
    Route::post('/driver/driverreached/{id}', [DriverReachController::class, 'driverreached']);
    Route::post('/driver/activenow', [ActiveRideController::class, 'activenow']);
    Route::post('/driver/cancelride', [CancelRideController::class, 'cancelRide']);
});
