
@extends('admin.adminmaster')

@section('style1')
<link href="{{asset('public/admin_assets/plugins/datatables.net-bs5/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet">
<link href="{{asset('public/admin_assets/plugins/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css')}}" rel="stylesheet">
<link href="{{asset('public/admin_assets/plugins/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css')}}" rel="stylesheet">
<style>
.containerbutton {
    display: flex;
    justify-content: flex-end; /* Aligns button to the right */
    margin-bottom: 10px; /* Optional: Space between button and table */
}
</style>

@endsection






@section('contentarea')

<div id="datatable" class="mb-5">

    @if (session('status'))
    <div class="alert alert-success">{{ session('status') }}</div>
    @endif
    
    <h4>Permission</h4>
    <div class="containerbutton">
      
    <a href="{{route('admin.permissions.create') }}" class="btn btn-outline-theme">Add Permission</a>
    </div>
    <div class="card">
    <div class="card-body">
    <table id="datatableDefault" class="table text-nowrap w-100">
    <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Name</th>
                                    <th width="40%">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($permissions as $permission)
                                <tr>
                                    <td>{{ $permission->id }}</td>
                                    <td>{{ $permission->name }}</td>
                                    <td>
                                        @can('update permission')
                                        <a href="{{ route('admin.permissions.edit',$permission->id) }}" class="btn btn-success">Edit</a>
                                        @endcan

                                        @can('delete permission')
                                        <form action="{{ route('admin.permissions.destroy', $permission->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger mx-2">Delete</button>
                                        </form>
                                    @endcan
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
    </table>
    </div>
    <div class="card-arrow">
    <div class="card-arrow-top-left"></div>
    <div class="card-arrow-top-right"></div>
    <div class="card-arrow-bottom-left"></div>
    <div class="card-arrow-bottom-right"></div>
    </div>
    <div class="hljs-container">
    <pre><code class="xml" data-url="assets/data/table-plugins/code-1.json"></code></pre>
    </div>
    </div>
    </div>
    </div>
    @endsection

    @section('script1')




    <script src="{{ asset('public/admin_assets/plugins/datatables.net/js/dataTables.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-bs5/js/dataTables.bootstrap5.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-buttons/js/dataTables.buttons.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-buttons/js/buttons.colVis.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-buttons/js/buttons.flash.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-buttons/js/buttons.html5.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-buttons/js/buttons.print.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-buttons-bs5/js/buttons.bootstrap5.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-responsive/js/dataTables.responsive.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-responsive-bs5/js/responsive.bootstrap5.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/js/demo/table-plugins.demo.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>



    @endsection