@extends('admin.layout.adminmaster')

@section('style1')

        

        <style>
            .containerbutton {
                display: flex;
                justify-content: flex-end;
                /* Aligns button to the right */
                margin-bottom: 10px;
                /* Optional: Space between button and table */
            }
            .header-container {
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                    }


            

            .tblsearch {
                width: 100%;
                margin: 4px auto 0px auto;
                height: 30px;
                padding-left: 6px;
            }

            a {
                color: #5b5959;
            }
        </style>

@endsection











@section('contentarea')

<h4>Vehicle Management</h4>

<div class="row">
    <div class="header-container">

<div class="col-xl-8">
    <div class="typeahead__container mb-1">

        <div class="typeahead__field">
            <div class="typeahead__query input-group">
                <input class="form-control customsearch" id="customsearch" placeholder="search here.."
                    autocomplete="off">
            </div>
        </div>
    </div>
</div>

<div class="containerbutton">
    <a href="{{route('admin.VehicleManagement-create') }}" class="btn btn-warning">New Vehicle</a>
</div>
</div>
</div>



        <table id="listAjaxDataTable" class="table text-nowrap w-100  mb-3">
            <thead>
                <tr>
                    <th data-ftcol="sno" > S.No </th>
                    <th data-ftcol="BrandName">Car Brand</th>
                    <th data-ftcol="car_model">Car Model</th>
                    <th data-ftcol="CarType">Car Type</th>
                    <th data-ftcol="fuel_type">Fuel Type</th>
                    <th data-ftcol="seat_capacity">Seat Capacity</th>
                    <th data-ftcol="status">Status</th>
                    <th data-ftcol="actions"> Action </th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>




   
   

@endsection

@section('script1')


<script src="{{ asset('public/admin_assets/js/jquery.min.js') }}"></script>




<script>
    $(document).ready(function() {

            var reorderStart = -1; 
        $('th').on("click", function(event) {
            if ($(event.target).is("input") || $(event.target).is("select")) {
                event.stopImmediatePropagation();
            }
        });
        var sno = 1;
        var dataTablecol = [
            {
                "name": "serial_no",
                "searchable": false,
                "sortable": true,
                render: function(data, type, row, meta) {
                    return meta.row + meta.settings._iDisplayStart + 1;
                }
            },

            {
                    "searchable": true,
                    "sortable": false,
                    data: 'BrandName',
                    name: 'BrandName',


               },
            {
                    "searchable": true,
                    "sortable": false,
                    data: 'car_model',
                    name: 'car_model',


               },

               {
                    "searchable": true,
                    "sortable": false,
                    data: 'CarType',
                    name: 'CarType',


               },
            {
                    "searchable": true,
                    "sortable": false,
                    data: 'fuel_type',
                    name: 'fuel_type',


               },
            {
                    "searchable": true,
                    "sortable": false,
                    data: 'seat_capacity',
                    name: 'seat_capacity',


               },

               

            {
                data: 'status',
                name: 'status',
                searchable: true,
                orderable: false,
                render: function(data, type, row) {
                let checked = row.status == 1 ? 'checked' : '';
                return `
                    <div class="form-check form-switch">
                        <input type="checkbox" class="form-check-input status-toggle"
                               id="statusSwitch${row.id}" data-id="${row.id}" ${checked}>
                        <label class="form-check-label" for="statusSwitch${row.id}">
                            ${row.status == 1 ? 'Active' : 'Inactive'}
                        </label>
                    </div>`;
            }
            },


            {
                "searchable": false,
                "sortable": false,
                data: 'id',
                render: function(data, type, row, meta) {
                    var url = "{{ route('admin.VehicleManagement') }}";
                  

                    var editLink = '<a class="" href="' + url + '/' + data + '/edit" title="Edit">' +
                        '<i class="mdi mdi-account-edit" style="color: rgb(0, 157, 255); font-size: 20px"></i>' +
                        '</a>';

                    var viewLink = '<a class="" href="' + url + '/' + data + '/view" title="View">' +
                        '<i class="mdi mdi-eye" style="color: #009378; font-size: 20px"></i>' +
                        '</a>';

                    var deleteLink = '<a data-id="' + data + '" class="deleteRow" href="#" title="Delete">' +
                        '<i class="mdi mdi-delete" style="color: red; font-size: 20px;"></i>' +
                        '</a>';

                    var result = editLink + '&nbsp;' + viewLink + '&nbsp;' + deleteLink;
                    return result;
                }
            },
            
        ];
        var listAjaxDataTable = $('#listAjaxDataTable').DataTable({
            // "order": [
            //     [0, "desc"]
            // ],
            "processing": true,
            "serverSide": true,
            "colReorder": true,
            "columns": dataTablecol,
            "ordering": false,
            "bAutoWidth": false,
            // "dom": 'ltpr',
            "dom": " <'row'<'col-sm-12 mt-3'tr>><'row'<'col-sm-2'l><'col-sm-6'i><'col-sm-4'p>>",
            "drawCallback": function(settings) {
                var response = settings.json;
                if (response.recordsTotal > 0) {
                    $('#exportreport').show();
                } else {
                    $('#exportreport').hide();
                }
            },
            "ajax": DataTable.pipeline({
                url: "{{ route('admin.VehicleManagement-dataindex') }}",
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                pages: 5 // number of pages to cache
            }),
        });
               
        $('#customsearch').on('keyup change', function () {
                let value = $(this).val();
                listAjaxDataTable.search(value).draw();
            });




            

        $('table').on('click', '.deleteRow', function(e) {
            e.preventDefault();
            $chId = $(this).data('id');
            var k = confirm("Are you sure to Delete this record.");
            if (k == true) {
                $.ajax({
                    url: "{{ route('admin.VehicleManagement') }}/" + $chId,
                    method: "DELETE",
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    error: function(data) {
                        toastr.error("Error Occured. Please Try Again Later.");
                    },
                    success: function(result) {
                        result = JSON.stringify(result)
                        result = JSON.parse(result);
                        if (result.status == 200) {
                            toastr.success("Deleted Successfully");
                            listAjaxDataTable.clearPipeline().draw();
                        } else {
                            toastr.error("Error Occured. Please Try Again Later.");
                        }
                    }
                });
            }
        });


        $(document).on('change', '.status-toggle', function () {
    let checkbox = $(this);
    let id = checkbox.data('id');
    let status = checkbox.is(':checked') ? 1 : 0;

    let message = status === 1 
        ? "Are you sure you want to activate this driver?" 
        : "Are you sure you want to deactivate this driver?";

    if (confirm(message)) {
        $.ajax({
            url: "{{ route('admin.vehicleupdate-status') }}",
            type: "POST",
            data: {
                _token: '{{ csrf_token() }}',
                id: id,
                status: status
            },
            success: function (response) {
                let label = checkbox.closest('.form-check').find('label');
                label.text(status === 1 ? 'Active' : 'Inactive');
                toastr.success(response.message || 'Status updated');

            },
            error: function () {
                toastr.error('Failed to update status');
                checkbox.prop('checked', !status); // rollback toggle on error
            }
        });
    } else {
        checkbox.prop('checked', !status); // rollback toggle if cancelled
    }
});

       
        
        });
</script>

@endsection