@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="container mt-4">

    <h2 class="mb-4">Driver Report</h2>

    <form method="GET" action="{{ route('admin.DriverReport-index') }}" class="row g-3 mb-4">
        <div class="col-md-3">
            <label for="from_date" class="form-label">From Date</label>
            <input type="date" id="from_date" name="from_date" value="{{ request('from_date') }}" class="form-control">
        </div>
        <div class="col-md-3">
            <label for="to_date" class="form-label">To Date</label>
            <input type="date" id="to_date" name="to_date" value="{{ request('to_date') }}" class="form-control">
        </div>
        <div class="col-md-3 align-self-end">
            <button type="submit" class="btn btn-primary">Search</button>
            <a href="{{ route('admin.DriverReport-index') }}" class="btn btn-secondary ms-2">Clear</a>
        </div>
    </form>

    <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th scope="col">Driver Name</th>
                    <th scope="col">Total Trips</th>
                    <th scope="col">Total Amount (based on km)</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($driverReports as $report)
                    <tr>
                        <td>{{ $report['driver_name'] }}</td>
                        <td>{{ $report['trip_count'] }}</td>
                        <td>₹ {{ number_format($report['total_amount'], 2) }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="3" class="text-center text-muted">No data available for the selected dates.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

</div>
@endsection

