@extends('admin.layout.adminmaster')

@section('style1')
<style>
    #map {
        height: 500px;
        width: 100%;
        margin-top: 20px;
        border: 1px solid #ddd;
        border-radius: 4px;
    }
    .pac-container {
        z-index: 1051 !important;
    }
  
</style>
@endsection

@section('contentarea')
<div class="container mt-4">
    <h4>Route Picker</h4>
    <form action="{{ route('admin.BookingManagement-store') }}" method="POST" enctype="multipart/form-data" name="booking_form" id="booking_form" onsubmit="return validateForm();">
        @csrf

        <div class="row g-2">
            <div class="mb-3 col-md-4">
                <label for="notify_driver" class="form-label">Notify Driver</label>
                <select id="notify_driver" class="form-select" name="notify_driver" onchange="toggleDriverRequirement()">
                    <option value="" disabled selected>---Select Notify Driver(s)--</option>
                    <option value="single">Single</option>
                    <option value="all">All</option>
                </select>        
            </div>

            <div class="mb-3 col-md-4">
                <label for="cartype" class="form-label">Cartype Type</label>
                <select id="cartype" class="form-select" name="cartype">
                    <option value="" disabled selected>---Select cartype(s)--</option>
                    @foreach($cartype as $cartypes)
                    <option value="{{ $cartypes->id }}">{{ $cartypes->car_type }}</option>
                   @endforeach
                </select>        
            </div>
            
            <div class="mb-3 col-md-4">
                <label for="traveltype" class="form-label">package Type</label>
                <select id="traveltype" class="form-select" name="traveltype">
                    <option value="" disabled selected>---Select traveltype(s)--</option>
                    @foreach($traveltype as $traveltypes)
                    <option value="{{ $traveltypes->id }}">{{ $traveltypes->package_name }}</option>
                   @endforeach
                </select>        
            </div>
        </div>

        <input type="hidden" name="driver_id" id="driver_id">
       <div class="row g-2">

        <div class="mb-3 col-md-6">
                <label  class="form-label">Radius KM</label>
                <select id="radiuskm" class="form-select" name="radiuskm">
                    <option value="" disabled selected>---Select radiuskm(s)--</option>
                    <option value="3"> 3 KM</option>
                    <option value="5"> 5 KM</option>
                    <option value="7"> 7 KM</option>
                    <option value="10"> 10 KM</option>
                 
                </select>        
            </div>


        <div class="mb-3 col-md-6" >
    <label class="form-label">Vehicle A/C Type</label>
    <div class="mt-2 d-flex align-items-center gap-4">
        <div class="form-check form-check-inline">
            <input type="radio" class="form-check-input" id="vehicleAc" name="vehicle_ac_type" value="AC" checked>
            <label class="form-check-label" for="vehicleAc">A/C</label>
        </div>
        <div class="form-check form-check-inline">
            <input type="radio" class="form-check-input" id="vehicleNonAc" name="vehicle_ac_type" value="Non-AC">
            <label class="form-check-label" for="vehicleNonAc">Non A/C</label>
        </div>
    </div>
</div>


</div>


    
        <div class="row g-2">
            <div class="mb-3 col-md-6">
                <label for="customer_name" class="form-label">Customer Name</label>
                <input type="text" id="customer_name" name="customer_name" class="form-control">
            </div>
            <div class="mb-3 col-md-6">
                <label for="phone" class="form-label">Phone Number</label>
                <input class="form-control" type="text" id="phone"  name="phone" autocomplete="new-phone">
            </div>
        </div>

        <div class="row g-2">
            

                <div class="col-md-6">
                    <label class="form-label">From Location</label>
                    <input type="text" id="fromAddress" name="from_address" class="form-control" placeholder="Enter starting location">
                    <input type="hidden" id="fromLatitude" name="from_latitude">
                    <input type="hidden" id="fromLongitude" name="from_longitude">
                </div>
                <div class="col-md-6">
                    <label class="form-label">To Location</label>
                    <input type="text" id="toAddress" name="to_address" class="form-control" placeholder="Enter destination location">
                    <input type="hidden" id="toLatitude" name="to_latitude">
                    <input type="hidden" id="toLongitude" name="to_longitude">
                </div>
                

            </div>
        

        <div id="map"></div>

        <div class="mt-4 mb-3" style="float: right">
            <button type="submit" class="btn btn-primary">Save Route</button>
        </div>
    </form>
</div>
@endsection
@section('script1')
<script>
    let drivers = @json($drivers);
    let map;
    let fromMarker;
    let toMarker;
    let directionsService;
    let directionsRenderer;
    let fromAutocomplete;
    let toAutocomplete;
    let fromLocation = null;
    let toLocation = null;
    let geocoder;
    let selectedDriverMarker = null;

    function initMap() {
        const initialLocation = { lat: 9.9252, lng: 78.1198 };

        map = new google.maps.Map(document.getElementById("map"), {
            center: initialLocation,
            zoom: 13,
            streetViewControl: false,
            mapTypeControlOptions: {
                style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
                position: google.maps.ControlPosition.TOP_RIGHT
            }
        });

        geocoder = new google.maps.Geocoder();
        directionsService = new google.maps.DirectionsService();
        directionsRenderer = new google.maps.DirectionsRenderer({
            map: map,
            suppressMarkers: true,
            polylineOptions: {
                strokeColor: "#3a86ff",
                strokeOpacity: 0.8,
                strokeWeight: 5
            }
        });

        fromAutocomplete = new google.maps.places.Autocomplete(
            document.getElementById("fromAddress"),
            { fields: ["formatted_address", "geometry", "address_components"], componentRestrictions: { country: "in" } }
        );

        toAutocomplete = new google.maps.places.Autocomplete(
            document.getElementById("toAddress"),
            { fields: ["formatted_address", "geometry", "address_components"], componentRestrictions: { country: "in" } }
        );

        fromAutocomplete.addListener("place_changed", function () {
            const place = fromAutocomplete.getPlace();

            if (!place.geometry) {
                alert("No details available for input: '" + place.name + "'");
                return;
            }

            fromLocation = place.geometry.location;
            updateFromLocation(place.geometry.location, place.formatted_address);
            updateFormFields();
            updateRoute();

            if (window.fromLocationCircle) {
                window.fromLocationCircle.setMap(null);
            }

          // Initial radius fallback if nothing is selected yet (default: 3 km)
            let initialRadius = 3000;

            window.fromLocationCircle = new google.maps.Circle({
                strokeColor: "#007bff",
                strokeOpacity: 0.8,
                strokeWeight: 2,
                fillColor: "#007bff",
                fillOpacity: 0.2,
                map: map,
                center: fromLocation, // Make sure this is defined and valid
                radius: initialRadius
            });


            document.getElementById('radiuskm').addEventListener('change', function () {
                let selectedKm = parseFloat(this.value); // get selected value (in KM)
                if (!isNaN(selectedKm) && window.fromLocationCircle) {
                    let radiusInMeters = selectedKm * 1000;
                    window.fromLocationCircle.setRadius(radiusInMeters);
                    window.fromLocationCircle.setVisible(true); // ensure it's visible
                }
            });



            // map.panTo(fromLocation);
            // map.fitBounds(window.fromLocationCircle.getBounds());

            map.panTo(fromLocation);

            // Fit bounds to the circle
            map.fitBounds(window.fromLocationCircle.getBounds());

            // Optional: Adjust zoom if too close
            google.maps.event.addListenerOnce(map, 'bounds_changed', function () {
                const desiredZoom = 18; // Zoom level for 3km radius visibility
                if (map.getZoom() > desiredZoom) {
                    // map.setZoom(desiredZoom);
                }
            });


            fetch("{{ route('admin.getNearbyDrivers') }}", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": '{{ csrf_token() }}',
                },
                body: JSON.stringify({
                    latitude: fromLocation.lat(),
                    longitude: fromLocation.lng()
                })
            })
                .then(res => res.json())
                .then(drivers => {
                    drivers.forEach(driver => {
                        const marker = new google.maps.Marker({
                            position: { lat: parseFloat(driver.latitude), lng: parseFloat(driver.longitude) },
                            map: map,
                            icon: {
                                url: "https://img.icons8.com/emoji/48/oncoming-taxi.png",
                                scaledSize: new google.maps.Size(32, 32)
                            },
                            title: driver.driver_name
                        });

                        marker.addListener('click', () => {
                            selectDriverFromMap(driver.id, marker);
                        });
                    });
                })
                .catch(error => {
                    console.error("Error fetching nearby drivers:", error);
                });

            // ✅ Safe parsing of address_components
           if (place.address_components) {
    let country = '', state = '', city = '', district = '';

    place.address_components.forEach(component => {
        const types = component.types;

        if (types.includes('country')) {
            country = component.long_name;
        }
        if (types.includes('administrative_area_level_1')) {
            state = component.long_name;
        }
        if (types.includes('administrative_area_level_3')) {
            district = component.long_name;
        }
        if (types.includes('locality')) {
            city = component.long_name;
        }
    });

    console.log('From Location Details:', { country, state, district, city });
}

        });

        toAutocomplete.addListener("place_changed", function () {
            const place = toAutocomplete.getPlace();

            if (!place.geometry) {
                alert("No details available for input: '" + place.name + "'");
                return;
            }

            toLocation = place.geometry.location;
            updateToLocation(place.geometry.location, place.formatted_address);
            updateFormFields();
            updateRoute();

            // ✅ Safe parsing of address_components
           if (place.address_components) {
    let country = '', state = '', city = '', district = '';

    place.address_components.forEach(component => {
        const types = component.types;

        if (types.includes('country')) {
            country = component.long_name;
        }
        if (types.includes('administrative_area_level_1')) {
            state = component.long_name;
        }
        if (types.includes('administrative_area_level_3')) {
            district = component.long_name;
        }
        if (types.includes('locality')) {
            city = component.long_name;
        }
    });

    console.log('From Location Details:', { country, state, district, city });
}

        });

        map.addListener("click", function (e) {
            geocoder.geocode({ location: e.latLng }, (results, status) => {
                if (status === "OK" && results[0]) {
                    const address = results[0].formatted_address;

                    if (!fromLocation) {
                        fromLocation = e.latLng;
                        updateFromLocation(e.latLng, address);
                        document.getElementById("fromAddress").value = address;
                    } else if (!toLocation) {
                        toLocation = e.latLng;
                        updateToLocation(e.latLng, address);
                        document.getElementById("toAddress").value = address;
                    } else {
                        fromLocation = e.latLng;
                        toLocation = null;
                        updateFromLocation(e.latLng, address);
                        document.getElementById("fromAddress").value = address;
                        document.getElementById("toAddress").value = "";
                        if (toMarker) {
                            toMarker.setMap(null);
                            toMarker = null;
                        }
                    }

                    updateFormFields();
                    updateRoute();
                }
            });
        });

        // If prefilled
        const fromLat = document.getElementById("fromLatitude").value;
        const fromLng = document.getElementById("fromLongitude").value;
        if (fromLat && fromLng) {
            fromLocation = new google.maps.LatLng(parseFloat(fromLat), parseFloat(fromLng));
            updateFromLocation(fromLocation, document.getElementById("fromAddress").value);
        }

        const toLat = document.getElementById("toLatitude").value;
        const toLng = document.getElementById("toLongitude").value;
        if (toLat && toLng) {
            toLocation = new google.maps.LatLng(parseFloat(toLat), parseFloat(toLng));
            updateToLocation(toLocation, document.getElementById("toAddress").value);
        }

        if (fromLocation && toLocation) {
            updateRoute();
        }

        // Static driver markers
        drivers.forEach(driver => {
            const marker = new google.maps.Marker({
                position: {
                    lat: parseFloat(driver.current_latitude),
                    lng: parseFloat(driver.current_longitude)
                },
                map: map,
                icon: {
                    url: "https://img.icons8.com/emoji/48/oncoming-taxi.png",
                    scaledSize: new google.maps.Size(32, 32)
                },
                title: 'Driver ID: ' + driver.id
            });

            marker.addListener('click', () => {
                selectDriverFromMap(driver.id, marker);
            });
        });
    }

    function selectDriverFromMap(driverId, marker) {
        document.getElementById('driver_id').value = driverId;

        if (selectedDriverMarker) {
            selectedDriverMarker.setIcon({
                url: "https://img.icons8.com/emoji/48/oncoming-taxi.png",
                scaledSize: new google.maps.Size(32, 32)
            });
        }

        marker.setIcon({
            url: "https://maps.google.com/mapfiles/ms/icons/blue-dot.png",
            scaledSize: new google.maps.Size(40, 40)
        });

        selectedDriverMarker = marker;
    }

    function validateForm() {
        const notifyType = document.getElementById('notify_driver').value;
        const driverId = document.getElementById('driver_id').value;

        if (notifyType === 'single' && !driverId) {
            alert('You selected single driver notification. Please select a driver on the map.');
            return false;
        }

        return true;
    }

    function toggleDriverRequirement() {
        const type = document.getElementById('notify_driver').value;
        const driverIdField = document.getElementById('driver_id');

        if (type === 'all') {
            driverIdField.value = '';
            const fromLat = document.getElementById('fromLatitude').value;
        const fromLng = document.getElementById('fromLongitude').value;
            fetchAllOnlineDrivers();
        } else {
            if (window.driverMarkers) {
                window.driverMarkers.forEach(marker => marker.setMap(null));
                window.driverMarkers = [];
            }
        }
    }

 

    function updateFromLocation(location, address = null) {
        if (fromMarker) fromMarker.setMap(null);

        fromMarker = new google.maps.Marker({
            position: location,
            map: map,
            title: "From Location",
            draggable: true,
            icon: {
                url: "http://maps.google.com/mapfiles/ms/icons/green-dot.png",
                scaledSize: new google.maps.Size(32, 32)
            }
        });

        fromMarker.addListener("dragend", function () {
            geocoder.geocode({ location: fromMarker.getPosition() }, (results, status) => {
                if (status === "OK" && results[0]) {
                    document.getElementById("fromAddress").value = results[0].formatted_address;
                    updateFormFields();
                    updateRoute();
                }
            });
        });

        if (!toLocation) {
            map.setCenter(location);
            map.setZoom(15);
        }
    }

    function updateToLocation(location, address = null) {
        if (toMarker) toMarker.setMap(null);

        toMarker = new google.maps.Marker({
            position: location,
            map: map,
            title: "To Location",
            draggable: true,
            icon: {
                url: "http://maps.google.com/mapfiles/ms/icons/red-dot.png",
                scaledSize: new google.maps.Size(32, 32)
            }
        });

        toMarker.addListener("dragend", function () {
            geocoder.geocode({ location: toMarker.getPosition() }, (results, status) => {
                if (status === "OK" && results[0]) {
                    document.getElementById("toAddress").value = results[0].formatted_address;
                    updateFormFields();
                    updateRoute();
                }
            });
        });

        if (fromLocation) {
            const bounds = new google.maps.LatLngBounds();
            bounds.extend(fromLocation);
            bounds.extend(location);
            map.fitBounds(bounds);
        }
    }

    function updateRoute() {
        if (!fromLocation || !toLocation) return;

        directionsService.route(
            {
                origin: fromLocation,
                destination: toLocation,
                travelMode: google.maps.TravelMode.DRIVING,
                provideRouteAlternatives: true
            },
            (response, status) => {
                if (status === "OK") {
                    directionsRenderer.setDirections(response);
                } else {
                    alert("Directions request failed due to " + status);
                }
            }
        );
    }

    function updateFormFields() {
        if (fromLocation) {
            document.getElementById("fromLatitude").value = fromLocation.lat();
            document.getElementById("fromLongitude").value = fromLocation.lng();
        }

        if (toLocation) {
            document.getElementById("toLatitude").value = toLocation.lat();
            document.getElementById("toLongitude").value = toLocation.lng();
        }
    }

    document.getElementById("fromAddress").addEventListener("keypress", function (e) {
        if (e.key === "Enter") e.preventDefault();
    });

    document.getElementById("toAddress").addEventListener("keypress", function (e) {
        if (e.key === "Enter") e.preventDefault();
    });
    


</script>

<script src="https://maps.googleapis.com/maps/api/js?key={{ $googleMapsApiKey }}&libraries=places&callback=initMap" async defer></script>


@endsection
