"use strict";
var __getOwnPropNames = Object.getOwnPropertyNames;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};

// node_modules/picocolors/picocolors.js
var require_picocolors = __commonJS({
  "node_modules/picocolors/picocolors.js"(exports2, module2) {
    var tty = require("tty");
    var isColorSupported = !("NO_COLOR" in process.env || process.argv.includes("--no-color")) && ("FORCE_COLOR" in process.env || process.argv.includes("--color") || process.platform === "win32" || tty.isatty(1) && process.env.TERM !== "dumb" || "CI" in process.env);
    var formatter = (open, close, replace = open) => (input) => {
      let string = "" + input;
      let index = string.indexOf(close, open.length);
      return ~index ? open + replaceClose(string, close, replace, index) + close : open + string + close;
    };
    var replaceClose = (string, close, replace, index) => {
      let start = string.substring(0, index) + replace;
      let end = string.substring(index + close.length);
      let nextIndex = end.indexOf(close);
      return ~nextIndex ? start + replaceClose(end, close, replace, nextIndex) : start + end;
    };
    var createColors = (enabled = isColorSupported) => ({
      isColorSupported: enabled,
      reset: enabled ? (s) => `\x1B[0m${s}\x1B[0m` : String,
      bold: enabled ? formatter("\x1B[1m", "\x1B[22m", "\x1B[22m\x1B[1m") : String,
      dim: enabled ? formatter("\x1B[2m", "\x1B[22m", "\x1B[22m\x1B[2m") : String,
      italic: enabled ? formatter("\x1B[3m", "\x1B[23m") : String,
      underline: enabled ? formatter("\x1B[4m", "\x1B[24m") : String,
      inverse: enabled ? formatter("\x1B[7m", "\x1B[27m") : String,
      hidden: enabled ? formatter("\x1B[8m", "\x1B[28m") : String,
      strikethrough: enabled ? formatter("\x1B[9m", "\x1B[29m") : String,
      black: enabled ? formatter("\x1B[30m", "\x1B[39m") : String,
      red: enabled ? formatter("\x1B[31m", "\x1B[39m") : String,
      green: enabled ? formatter("\x1B[32m", "\x1B[39m") : String,
      yellow: enabled ? formatter("\x1B[33m", "\x1B[39m") : String,
      blue: enabled ? formatter("\x1B[34m", "\x1B[39m") : String,
      magenta: enabled ? formatter("\x1B[35m", "\x1B[39m") : String,
      cyan: enabled ? formatter("\x1B[36m", "\x1B[39m") : String,
      white: enabled ? formatter("\x1B[37m", "\x1B[39m") : String,
      gray: enabled ? formatter("\x1B[90m", "\x1B[39m") : String,
      bgBlack: enabled ? formatter("\x1B[40m", "\x1B[49m") : String,
      bgRed: enabled ? formatter("\x1B[41m", "\x1B[49m") : String,
      bgGreen: enabled ? formatter("\x1B[42m", "\x1B[49m") : String,
      bgYellow: enabled ? formatter("\x1B[43m", "\x1B[49m") : String,
      bgBlue: enabled ? formatter("\x1B[44m", "\x1B[49m") : String,
      bgMagenta: enabled ? formatter("\x1B[45m", "\x1B[49m") : String,
      bgCyan: enabled ? formatter("\x1B[46m", "\x1B[49m") : String,
      bgWhite: enabled ? formatter("\x1B[47m", "\x1B[49m") : String
    });
    module2.exports = createColors();
    module2.exports.createColors = createColors;
  }
});

// node_modules/postcss/lib/tokenize.js
var require_tokenize = __commonJS({
  "node_modules/postcss/lib/tokenize.js"(exports2, module2) {
    "use strict";
    var SINGLE_QUOTE = "'".charCodeAt(0);
    var DOUBLE_QUOTE = '"'.charCodeAt(0);
    var BACKSLASH = "\\".charCodeAt(0);
    var SLASH = "/".charCodeAt(0);
    var NEWLINE = "\n".charCodeAt(0);
    var SPACE = " ".charCodeAt(0);
    var FEED = "\f".charCodeAt(0);
    var TAB = "	".charCodeAt(0);
    var CR = "\r".charCodeAt(0);
    var OPEN_SQUARE = "[".charCodeAt(0);
    var CLOSE_SQUARE = "]".charCodeAt(0);
    var OPEN_PARENTHESES = "(".charCodeAt(0);
    var CLOSE_PARENTHESES = ")".charCodeAt(0);
    var OPEN_CURLY = "{".charCodeAt(0);
    var CLOSE_CURLY = "}".charCodeAt(0);
    var SEMICOLON = ";".charCodeAt(0);
    var ASTERISK = "*".charCodeAt(0);
    var COLON = ":".charCodeAt(0);
    var AT = "@".charCodeAt(0);
    var RE_AT_END = /[\t\n\f\r "#'()/;[\\\]{}]/g;
    var RE_WORD_END = /[\t\n\f\r !"#'():;@[\\\]{}]|\/(?=\*)/g;
    var RE_BAD_BRACKET = /.[\r\n"'(/\\]/;
    var RE_HEX_ESCAPE = /[\da-f]/i;
    module2.exports = function tokenizer(input, options = {}) {
      let css = input.css.valueOf();
      let ignore = options.ignoreErrors;
      let code, next, quote, content, escape;
      let escaped, escapePos, prev, n, currentToken;
      let length = css.length;
      let pos = 0;
      let buffer = [];
      let returned = [];
      function position() {
        return pos;
      }
      function unclosed(what) {
        throw input.error("Unclosed " + what, pos);
      }
      function endOfFile() {
        return returned.length === 0 && pos >= length;
      }
      function nextToken(opts) {
        if (returned.length)
          return returned.pop();
        if (pos >= length)
          return;
        let ignoreUnclosed = opts ? opts.ignoreUnclosed : false;
        code = css.charCodeAt(pos);
        switch (code) {
          case NEWLINE:
          case SPACE:
          case TAB:
          case CR:
          case FEED: {
            next = pos;
            do {
              next += 1;
              code = css.charCodeAt(next);
            } while (code === SPACE || code === NEWLINE || code === TAB || code === CR || code === FEED);
            currentToken = ["space", css.slice(pos, next)];
            pos = next - 1;
            break;
          }
          case OPEN_SQUARE:
          case CLOSE_SQUARE:
          case OPEN_CURLY:
          case CLOSE_CURLY:
          case COLON:
          case SEMICOLON:
          case CLOSE_PARENTHESES: {
            let controlChar = String.fromCharCode(code);
            currentToken = [controlChar, controlChar, pos];
            break;
          }
          case OPEN_PARENTHESES: {
            prev = buffer.length ? buffer.pop()[1] : "";
            n = css.charCodeAt(pos + 1);
            if (prev === "url" && n !== SINGLE_QUOTE && n !== DOUBLE_QUOTE && n !== SPACE && n !== NEWLINE && n !== TAB && n !== FEED && n !== CR) {
              next = pos;
              do {
                escaped = false;
                next = css.indexOf(")", next + 1);
                if (next === -1) {
                  if (ignore || ignoreUnclosed) {
                    next = pos;
                    break;
                  } else {
                    unclosed("bracket");
                  }
                }
                escapePos = next;
                while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
                  escapePos -= 1;
                  escaped = !escaped;
                }
              } while (escaped);
              currentToken = ["brackets", css.slice(pos, next + 1), pos, next];
              pos = next;
            } else {
              next = css.indexOf(")", pos + 1);
              content = css.slice(pos, next + 1);
              if (next === -1 || RE_BAD_BRACKET.test(content)) {
                currentToken = ["(", "(", pos];
              } else {
                currentToken = ["brackets", content, pos, next];
                pos = next;
              }
            }
            break;
          }
          case SINGLE_QUOTE:
          case DOUBLE_QUOTE: {
            quote = code === SINGLE_QUOTE ? "'" : '"';
            next = pos;
            do {
              escaped = false;
              next = css.indexOf(quote, next + 1);
              if (next === -1) {
                if (ignore || ignoreUnclosed) {
                  next = pos + 1;
                  break;
                } else {
                  unclosed("string");
                }
              }
              escapePos = next;
              while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
                escapePos -= 1;
                escaped = !escaped;
              }
            } while (escaped);
            currentToken = ["string", css.slice(pos, next + 1), pos, next];
            pos = next;
            break;
          }
          case AT: {
            RE_AT_END.lastIndex = pos + 1;
            RE_AT_END.test(css);
            if (RE_AT_END.lastIndex === 0) {
              next = css.length - 1;
            } else {
              next = RE_AT_END.lastIndex - 2;
            }
            currentToken = ["at-word", css.slice(pos, next + 1), pos, next];
            pos = next;
            break;
          }
          case BACKSLASH: {
            next = pos;
            escape = true;
            while (css.charCodeAt(next + 1) === BACKSLASH) {
              next += 1;
              escape = !escape;
            }
            code = css.charCodeAt(next + 1);
            if (escape && code !== SLASH && code !== SPACE && code !== NEWLINE && code !== TAB && code !== CR && code !== FEED) {
              next += 1;
              if (RE_HEX_ESCAPE.test(css.charAt(next))) {
                while (RE_HEX_ESCAPE.test(css.charAt(next + 1))) {
                  next += 1;
                }
                if (css.charCodeAt(next + 1) === SPACE) {
                  next += 1;
                }
              }
            }
            currentToken = ["word", css.slice(pos, next + 1), pos, next];
            pos = next;
            break;
          }
          default: {
            if (code === SLASH && css.charCodeAt(pos + 1) === ASTERISK) {
              next = css.indexOf("*/", pos + 2) + 1;
              if (next === 0) {
                if (ignore || ignoreUnclosed) {
                  next = css.length;
                } else {
                  unclosed("comment");
                }
              }
              currentToken = ["comment", css.slice(pos, next + 1), pos, next];
              pos = next;
            } else {
              RE_WORD_END.lastIndex = pos + 1;
              RE_WORD_END.test(css);
              if (RE_WORD_END.lastIndex === 0) {
                next = css.length - 1;
              } else {
                next = RE_WORD_END.lastIndex - 2;
              }
              currentToken = ["word", css.slice(pos, next + 1), pos, next];
              buffer.push(currentToken);
              pos = next;
            }
            break;
          }
        }
        pos++;
        return currentToken;
      }
      function back(token) {
        returned.push(token);
      }
      return {
        back,
        endOfFile,
        nextToken,
        position
      };
    };
  }
});

// node_modules/postcss/lib/terminal-highlight.js
var require_terminal_highlight = __commonJS({
  "node_modules/postcss/lib/terminal-highlight.js"(exports2, module2) {
    "use strict";
    var pico = require_picocolors();
    var tokenizer = require_tokenize();
    var Input;
    function registerInput(dependant) {
      Input = dependant;
    }
    var HIGHLIGHT_THEME = {
      ";": pico.yellow,
      ":": pico.yellow,
      "(": pico.cyan,
      ")": pico.cyan,
      "[": pico.yellow,
      "]": pico.yellow,
      "{": pico.yellow,
      "}": pico.yellow,
      "at-word": pico.cyan,
      "brackets": pico.cyan,
      "call": pico.cyan,
      "class": pico.yellow,
      "comment": pico.gray,
      "hash": pico.magenta,
      "string": pico.green
    };
    function getTokenType([type, value], processor) {
      if (type === "word") {
        if (value[0] === ".") {
          return "class";
        }
        if (value[0] === "#") {
          return "hash";
        }
      }
      if (!processor.endOfFile()) {
        let next = processor.nextToken();
        processor.back(next);
        if (next[0] === "brackets" || next[0] === "(")
          return "call";
      }
      return type;
    }
    function terminalHighlight(css) {
      let processor = tokenizer(new Input(css), { ignoreErrors: true });
      let result = "";
      while (!processor.endOfFile()) {
        let token = processor.nextToken();
        let color = HIGHLIGHT_THEME[getTokenType(token, processor)];
        if (color) {
          result += token[1].split(/\r?\n/).map((i) => color(i)).join("\n");
        } else {
          result += token[1];
        }
      }
      return result;
    }
    terminalHighlight.registerInput = registerInput;
    module2.exports = terminalHighlight;
  }
});

// node_modules/postcss/lib/css-syntax-error.js
var require_css_syntax_error = __commonJS({
  "node_modules/postcss/lib/css-syntax-error.js"(exports2, module2) {
    "use strict";
    var pico = require_picocolors();
    var terminalHighlight = require_terminal_highlight();
    var CssSyntaxError = class _CssSyntaxError extends Error {
      constructor(message, line, column, source, file, plugin) {
        super(message);
        this.name = "CssSyntaxError";
        this.reason = message;
        if (file) {
          this.file = file;
        }
        if (source) {
          this.source = source;
        }
        if (plugin) {
          this.plugin = plugin;
        }
        if (typeof line !== "undefined" && typeof column !== "undefined") {
          if (typeof line === "number") {
            this.line = line;
            this.column = column;
          } else {
            this.line = line.line;
            this.column = line.column;
            this.endLine = column.line;
            this.endColumn = column.column;
          }
        }
        this.setMessage();
        if (Error.captureStackTrace) {
          Error.captureStackTrace(this, _CssSyntaxError);
        }
      }
      setMessage() {
        this.message = this.plugin ? this.plugin + ": " : "";
        this.message += this.file ? this.file : "<css input>";
        if (typeof this.line !== "undefined") {
          this.message += ":" + this.line + ":" + this.column;
        }
        this.message += ": " + this.reason;
      }
      showSourceCode(color) {
        if (!this.source)
          return "";
        let css = this.source;
        if (color == null)
          color = pico.isColorSupported;
        if (terminalHighlight) {
          if (color)
            css = terminalHighlight(css);
        }
        let lines = css.split(/\r?\n/);
        let start = Math.max(this.line - 3, 0);
        let end = Math.min(this.line + 2, lines.length);
        let maxWidth = String(end).length;
        let mark, aside;
        if (color) {
          let { bold, gray, red } = pico.createColors(true);
          mark = (text) => bold(red(text));
          aside = (text) => gray(text);
        } else {
          mark = aside = (str) => str;
        }
        return lines.slice(start, end).map((line, index) => {
          let number = start + 1 + index;
          let gutter = " " + (" " + number).slice(-maxWidth) + " | ";
          if (number === this.line) {
            let spacing = aside(gutter.replace(/\d/g, " ")) + line.slice(0, this.column - 1).replace(/[^\t]/g, " ");
            return mark(">") + aside(gutter) + line + "\n " + spacing + mark("^");
          }
          return " " + aside(gutter) + line;
        }).join("\n");
      }
      toString() {
        let code = this.showSourceCode();
        if (code) {
          code = "\n\n" + code + "\n";
        }
        return this.name + ": " + this.message + code;
      }
    };
    module2.exports = CssSyntaxError;
    CssSyntaxError.default = CssSyntaxError;
  }
});

// node_modules/postcss/lib/symbols.js
var require_symbols = __commonJS({
  "node_modules/postcss/lib/symbols.js"(exports2, module2) {
    "use strict";
    module2.exports.isClean = Symbol("isClean");
    module2.exports.my = Symbol("my");
  }
});

// node_modules/postcss/lib/stringifier.js
var require_stringifier = __commonJS({
  "node_modules/postcss/lib/stringifier.js"(exports2, module2) {
    "use strict";
    var DEFAULT_RAW = {
      after: "\n",
      beforeClose: "\n",
      beforeComment: "\n",
      beforeDecl: "\n",
      beforeOpen: " ",
      beforeRule: "\n",
      colon: ": ",
      commentLeft: " ",
      commentRight: " ",
      emptyBody: "",
      indent: "    ",
      semicolon: false
    };
    function capitalize(str) {
      return str[0].toUpperCase() + str.slice(1);
    }
    var Stringifier = class {
      constructor(builder) {
        this.builder = builder;
      }
      atrule(node, semicolon) {
        let name = "@" + node.name;
        let params = node.params ? this.rawValue(node, "params") : "";
        if (typeof node.raws.afterName !== "undefined") {
          name += node.raws.afterName;
        } else if (params) {
          name += " ";
        }
        if (node.nodes) {
          this.block(node, name + params);
        } else {
          let end = (node.raws.between || "") + (semicolon ? ";" : "");
          this.builder(name + params + end, node);
        }
      }
      beforeAfter(node, detect) {
        let value;
        if (node.type === "decl") {
          value = this.raw(node, null, "beforeDecl");
        } else if (node.type === "comment") {
          value = this.raw(node, null, "beforeComment");
        } else if (detect === "before") {
          value = this.raw(node, null, "beforeRule");
        } else {
          value = this.raw(node, null, "beforeClose");
        }
        let buf = node.parent;
        let depth = 0;
        while (buf && buf.type !== "root") {
          depth += 1;
          buf = buf.parent;
        }
        if (value.includes("\n")) {
          let indent = this.raw(node, null, "indent");
          if (indent.length) {
            for (let step = 0; step < depth; step++)
              value += indent;
          }
        }
        return value;
      }
      block(node, start) {
        let between = this.raw(node, "between", "beforeOpen");
        this.builder(start + between + "{", node, "start");
        let after;
        if (node.nodes && node.nodes.length) {
          this.body(node);
          after = this.raw(node, "after");
        } else {
          after = this.raw(node, "after", "emptyBody");
        }
        if (after)
          this.builder(after);
        this.builder("}", node, "end");
      }
      body(node) {
        let last = node.nodes.length - 1;
        while (last > 0) {
          if (node.nodes[last].type !== "comment")
            break;
          last -= 1;
        }
        let semicolon = this.raw(node, "semicolon");
        for (let i = 0; i < node.nodes.length; i++) {
          let child = node.nodes[i];
          let before = this.raw(child, "before");
          if (before)
            this.builder(before);
          this.stringify(child, last !== i || semicolon);
        }
      }
      comment(node) {
        let left = this.raw(node, "left", "commentLeft");
        let right = this.raw(node, "right", "commentRight");
        this.builder("/*" + left + node.text + right + "*/", node);
      }
      decl(node, semicolon) {
        let between = this.raw(node, "between", "colon");
        let string = node.prop + between + this.rawValue(node, "value");
        if (node.important) {
          string += node.raws.important || " !important";
        }
        if (semicolon)
          string += ";";
        this.builder(string, node);
      }
      document(node) {
        this.body(node);
      }
      raw(node, own, detect) {
        let value;
        if (!detect)
          detect = own;
        if (own) {
          value = node.raws[own];
          if (typeof value !== "undefined")
            return value;
        }
        let parent = node.parent;
        if (detect === "before") {
          if (!parent || parent.type === "root" && parent.first === node) {
            return "";
          }
          if (parent && parent.type === "document") {
            return "";
          }
        }
        if (!parent)
          return DEFAULT_RAW[detect];
        let root = node.root();
        if (!root.rawCache)
          root.rawCache = {};
        if (typeof root.rawCache[detect] !== "undefined") {
          return root.rawCache[detect];
        }
        if (detect === "before" || detect === "after") {
          return this.beforeAfter(node, detect);
        } else {
          let method = "raw" + capitalize(detect);
          if (this[method]) {
            value = this[method](root, node);
          } else {
            root.walk((i) => {
              value = i.raws[own];
              if (typeof value !== "undefined")
                return false;
            });
          }
        }
        if (typeof value === "undefined")
          value = DEFAULT_RAW[detect];
        root.rawCache[detect] = value;
        return value;
      }
      rawBeforeClose(root) {
        let value;
        root.walk((i) => {
          if (i.nodes && i.nodes.length > 0) {
            if (typeof i.raws.after !== "undefined") {
              value = i.raws.after;
              if (value.includes("\n")) {
                value = value.replace(/[^\n]+$/, "");
              }
              return false;
            }
          }
        });
        if (value)
          value = value.replace(/\S/g, "");
        return value;
      }
      rawBeforeComment(root, node) {
        let value;
        root.walkComments((i) => {
          if (typeof i.raws.before !== "undefined") {
            value = i.raws.before;
            if (value.includes("\n")) {
              value = value.replace(/[^\n]+$/, "");
            }
            return false;
          }
        });
        if (typeof value === "undefined") {
          value = this.raw(node, null, "beforeDecl");
        } else if (value) {
          value = value.replace(/\S/g, "");
        }
        return value;
      }
      rawBeforeDecl(root, node) {
        let value;
        root.walkDecls((i) => {
          if (typeof i.raws.before !== "undefined") {
            value = i.raws.before;
            if (value.includes("\n")) {
              value = value.replace(/[^\n]+$/, "");
            }
            return false;
          }
        });
        if (typeof value === "undefined") {
          value = this.raw(node, null, "beforeRule");
        } else if (value) {
          value = value.replace(/\S/g, "");
        }
        return value;
      }
      rawBeforeOpen(root) {
        let value;
        root.walk((i) => {
          if (i.type !== "decl") {
            value = i.raws.between;
            if (typeof value !== "undefined")
              return false;
          }
        });
        return value;
      }
      rawBeforeRule(root) {
        let value;
        root.walk((i) => {
          if (i.nodes && (i.parent !== root || root.first !== i)) {
            if (typeof i.raws.before !== "undefined") {
              value = i.raws.before;
              if (value.includes("\n")) {
                value = value.replace(/[^\n]+$/, "");
              }
              return false;
            }
          }
        });
        if (value)
          value = value.replace(/\S/g, "");
        return value;
      }
      rawColon(root) {
        let value;
        root.walkDecls((i) => {
          if (typeof i.raws.between !== "undefined") {
            value = i.raws.between.replace(/[^\s:]/g, "");
            return false;
          }
        });
        return value;
      }
      rawEmptyBody(root) {
        let value;
        root.walk((i) => {
          if (i.nodes && i.nodes.length === 0) {
            value = i.raws.after;
            if (typeof value !== "undefined")
              return false;
          }
        });
        return value;
      }
      rawIndent(root) {
        if (root.raws.indent)
          return root.raws.indent;
        let value;
        root.walk((i) => {
          let p = i.parent;
          if (p && p !== root && p.parent && p.parent === root) {
            if (typeof i.raws.before !== "undefined") {
              let parts = i.raws.before.split("\n");
              value = parts[parts.length - 1];
              value = value.replace(/\S/g, "");
              return false;
            }
          }
        });
        return value;
      }
      rawSemicolon(root) {
        let value;
        root.walk((i) => {
          if (i.nodes && i.nodes.length && i.last.type === "decl") {
            value = i.raws.semicolon;
            if (typeof value !== "undefined")
              return false;
          }
        });
        return value;
      }
      rawValue(node, prop) {
        let value = node[prop];
        let raw = node.raws[prop];
        if (raw && raw.value === value) {
          return raw.raw;
        }
        return value;
      }
      root(node) {
        this.body(node);
        if (node.raws.after)
          this.builder(node.raws.after);
      }
      rule(node) {
        this.block(node, this.rawValue(node, "selector"));
        if (node.raws.ownSemicolon) {
          this.builder(node.raws.ownSemicolon, node, "end");
        }
      }
      stringify(node, semicolon) {
        if (!this[node.type]) {
          throw new Error(
            "Unknown AST node type " + node.type + ". Maybe you need to change PostCSS stringifier."
          );
        }
        this[node.type](node, semicolon);
      }
    };
    module2.exports = Stringifier;
    Stringifier.default = Stringifier;
  }
});

// node_modules/postcss/lib/stringify.js
var require_stringify = __commonJS({
  "node_modules/postcss/lib/stringify.js"(exports2, module2) {
    "use strict";
    var Stringifier = require_stringifier();
    function stringify(node, builder) {
      let str = new Stringifier(builder);
      str.stringify(node);
    }
    module2.exports = stringify;
    stringify.default = stringify;
  }
});

// node_modules/postcss/lib/node.js
var require_node = __commonJS({
  "node_modules/postcss/lib/node.js"(exports2, module2) {
    "use strict";
    var { isClean, my } = require_symbols();
    var CssSyntaxError = require_css_syntax_error();
    var Stringifier = require_stringifier();
    var stringify = require_stringify();
    function cloneNode(obj, parent) {
      let cloned = new obj.constructor();
      for (let i in obj) {
        if (!Object.prototype.hasOwnProperty.call(obj, i)) {
          continue;
        }
        if (i === "proxyCache")
          continue;
        let value = obj[i];
        let type = typeof value;
        if (i === "parent" && type === "object") {
          if (parent)
            cloned[i] = parent;
        } else if (i === "source") {
          cloned[i] = value;
        } else if (Array.isArray(value)) {
          cloned[i] = value.map((j) => cloneNode(j, cloned));
        } else {
          if (type === "object" && value !== null)
            value = cloneNode(value);
          cloned[i] = value;
        }
      }
      return cloned;
    }
    var Node = class {
      constructor(defaults = {}) {
        this.raws = {};
        this[isClean] = false;
        this[my] = true;
        for (let name in defaults) {
          if (name === "nodes") {
            this.nodes = [];
            for (let node of defaults[name]) {
              if (typeof node.clone === "function") {
                this.append(node.clone());
              } else {
                this.append(node);
              }
            }
          } else {
            this[name] = defaults[name];
          }
        }
      }
      addToError(error) {
        error.postcssNode = this;
        if (error.stack && this.source && /\n\s{4}at /.test(error.stack)) {
          let s = this.source;
          error.stack = error.stack.replace(
            /\n\s{4}at /,
            `$&${s.input.from}:${s.start.line}:${s.start.column}$&`
          );
        }
        return error;
      }
      after(add) {
        this.parent.insertAfter(this, add);
        return this;
      }
      assign(overrides = {}) {
        for (let name in overrides) {
          this[name] = overrides[name];
        }
        return this;
      }
      before(add) {
        this.parent.insertBefore(this, add);
        return this;
      }
      cleanRaws(keepBetween) {
        delete this.raws.before;
        delete this.raws.after;
        if (!keepBetween)
          delete this.raws.between;
      }
      clone(overrides = {}) {
        let cloned = cloneNode(this);
        for (let name in overrides) {
          cloned[name] = overrides[name];
        }
        return cloned;
      }
      cloneAfter(overrides = {}) {
        let cloned = this.clone(overrides);
        this.parent.insertAfter(this, cloned);
        return cloned;
      }
      cloneBefore(overrides = {}) {
        let cloned = this.clone(overrides);
        this.parent.insertBefore(this, cloned);
        return cloned;
      }
      error(message, opts = {}) {
        if (this.source) {
          let { end, start } = this.rangeBy(opts);
          return this.source.input.error(
            message,
            { column: start.column, line: start.line },
            { column: end.column, line: end.line },
            opts
          );
        }
        return new CssSyntaxError(message);
      }
      getProxyProcessor() {
        return {
          get(node, prop) {
            if (prop === "proxyOf") {
              return node;
            } else if (prop === "root") {
              return () => node.root().toProxy();
            } else {
              return node[prop];
            }
          },
          set(node, prop, value) {
            if (node[prop] === value)
              return true;
            node[prop] = value;
            if (prop === "prop" || prop === "value" || prop === "name" || prop === "params" || prop === "important" || /* c8 ignore next */
            prop === "text") {
              node.markDirty();
            }
            return true;
          }
        };
      }
      markDirty() {
        if (this[isClean]) {
          this[isClean] = false;
          let next = this;
          while (next = next.parent) {
            next[isClean] = false;
          }
        }
      }
      next() {
        if (!this.parent)
          return void 0;
        let index = this.parent.index(this);
        return this.parent.nodes[index + 1];
      }
      positionBy(opts, stringRepresentation) {
        let pos = this.source.start;
        if (opts.index) {
          pos = this.positionInside(opts.index, stringRepresentation);
        } else if (opts.word) {
          stringRepresentation = this.toString();
          let index = stringRepresentation.indexOf(opts.word);
          if (index !== -1)
            pos = this.positionInside(index, stringRepresentation);
        }
        return pos;
      }
      positionInside(index, stringRepresentation) {
        let string = stringRepresentation || this.toString();
        let column = this.source.start.column;
        let line = this.source.start.line;
        for (let i = 0; i < index; i++) {
          if (string[i] === "\n") {
            column = 1;
            line += 1;
          } else {
            column += 1;
          }
        }
        return { column, line };
      }
      prev() {
        if (!this.parent)
          return void 0;
        let index = this.parent.index(this);
        return this.parent.nodes[index - 1];
      }
      rangeBy(opts) {
        let start = {
          column: this.source.start.column,
          line: this.source.start.line
        };
        let end = this.source.end ? {
          column: this.source.end.column + 1,
          line: this.source.end.line
        } : {
          column: start.column + 1,
          line: start.line
        };
        if (opts.word) {
          let stringRepresentation = this.toString();
          let index = stringRepresentation.indexOf(opts.word);
          if (index !== -1) {
            start = this.positionInside(index, stringRepresentation);
            end = this.positionInside(index + opts.word.length, stringRepresentation);
          }
        } else {
          if (opts.start) {
            start = {
              column: opts.start.column,
              line: opts.start.line
            };
          } else if (opts.index) {
            start = this.positionInside(opts.index);
          }
          if (opts.end) {
            end = {
              column: opts.end.column,
              line: opts.end.line
            };
          } else if (typeof opts.endIndex === "number") {
            end = this.positionInside(opts.endIndex);
          } else if (opts.index) {
            end = this.positionInside(opts.index + 1);
          }
        }
        if (end.line < start.line || end.line === start.line && end.column <= start.column) {
          end = { column: start.column + 1, line: start.line };
        }
        return { end, start };
      }
      raw(prop, defaultType) {
        let str = new Stringifier();
        return str.raw(this, prop, defaultType);
      }
      remove() {
        if (this.parent) {
          this.parent.removeChild(this);
        }
        this.parent = void 0;
        return this;
      }
      replaceWith(...nodes) {
        if (this.parent) {
          let bookmark = this;
          let foundSelf = false;
          for (let node of nodes) {
            if (node === this) {
              foundSelf = true;
            } else if (foundSelf) {
              this.parent.insertAfter(bookmark, node);
              bookmark = node;
            } else {
              this.parent.insertBefore(bookmark, node);
            }
          }
          if (!foundSelf) {
            this.remove();
          }
        }
        return this;
      }
      root() {
        let result = this;
        while (result.parent && result.parent.type !== "document") {
          result = result.parent;
        }
        return result;
      }
      toJSON(_, inputs) {
        let fixed = {};
        let emitInputs = inputs == null;
        inputs = inputs || /* @__PURE__ */ new Map();
        let inputsNextIndex = 0;
        for (let name in this) {
          if (!Object.prototype.hasOwnProperty.call(this, name)) {
            continue;
          }
          if (name === "parent" || name === "proxyCache")
            continue;
          let value = this[name];
          if (Array.isArray(value)) {
            fixed[name] = value.map((i) => {
              if (typeof i === "object" && i.toJSON) {
                return i.toJSON(null, inputs);
              } else {
                return i;
              }
            });
          } else if (typeof value === "object" && value.toJSON) {
            fixed[name] = value.toJSON(null, inputs);
          } else if (name === "source") {
            let inputId = inputs.get(value.input);
            if (inputId == null) {
              inputId = inputsNextIndex;
              inputs.set(value.input, inputsNextIndex);
              inputsNextIndex++;
            }
            fixed[name] = {
              end: value.end,
              inputId,
              start: value.start
            };
          } else {
            fixed[name] = value;
          }
        }
        if (emitInputs) {
          fixed.inputs = [...inputs.keys()].map((input) => input.toJSON());
        }
        return fixed;
      }
      toProxy() {
        if (!this.proxyCache) {
          this.proxyCache = new Proxy(this, this.getProxyProcessor());
        }
        return this.proxyCache;
      }
      toString(stringifier = stringify) {
        if (stringifier.stringify)
          stringifier = stringifier.stringify;
        let result = "";
        stringifier(this, (i) => {
          result += i;
        });
        return result;
      }
      warn(result, text, opts) {
        let data = { node: this };
        for (let i in opts)
          data[i] = opts[i];
        return result.warn(text, data);
      }
      get proxyOf() {
        return this;
      }
    };
    module2.exports = Node;
    Node.default = Node;
  }
});

// node_modules/postcss/lib/declaration.js
var require_declaration = __commonJS({
  "node_modules/postcss/lib/declaration.js"(exports2, module2) {
    "use strict";
    var Node = require_node();
    var Declaration = class extends Node {
      constructor(defaults) {
        if (defaults && typeof defaults.value !== "undefined" && typeof defaults.value !== "string") {
          defaults = { ...defaults, value: String(defaults.value) };
        }
        super(defaults);
        this.type = "decl";
      }
      get variable() {
        return this.prop.startsWith("--") || this.prop[0] === "$";
      }
    };
    module2.exports = Declaration;
    Declaration.default = Declaration;
  }
});

// node_modules/source-map-js/lib/base64.js
var require_base64 = __commonJS({
  "node_modules/source-map-js/lib/base64.js"(exports2) {
    var intToCharMap = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".split("");
    exports2.encode = function(number) {
      if (0 <= number && number < intToCharMap.length) {
        return intToCharMap[number];
      }
      throw new TypeError("Must be between 0 and 63: " + number);
    };
    exports2.decode = function(charCode) {
      var bigA = 65;
      var bigZ = 90;
      var littleA = 97;
      var littleZ = 122;
      var zero = 48;
      var nine = 57;
      var plus = 43;
      var slash = 47;
      var littleOffset = 26;
      var numberOffset = 52;
      if (bigA <= charCode && charCode <= bigZ) {
        return charCode - bigA;
      }
      if (littleA <= charCode && charCode <= littleZ) {
        return charCode - littleA + littleOffset;
      }
      if (zero <= charCode && charCode <= nine) {
        return charCode - zero + numberOffset;
      }
      if (charCode == plus) {
        return 62;
      }
      if (charCode == slash) {
        return 63;
      }
      return -1;
    };
  }
});

// node_modules/source-map-js/lib/base64-vlq.js
var require_base64_vlq = __commonJS({
  "node_modules/source-map-js/lib/base64-vlq.js"(exports2) {
    var base64 = require_base64();
    var VLQ_BASE_SHIFT = 5;
    var VLQ_BASE = 1 << VLQ_BASE_SHIFT;
    var VLQ_BASE_MASK = VLQ_BASE - 1;
    var VLQ_CONTINUATION_BIT = VLQ_BASE;
    function toVLQSigned(aValue) {
      return aValue < 0 ? (-aValue << 1) + 1 : (aValue << 1) + 0;
    }
    function fromVLQSigned(aValue) {
      var isNegative = (aValue & 1) === 1;
      var shifted = aValue >> 1;
      return isNegative ? -shifted : shifted;
    }
    exports2.encode = function base64VLQ_encode(aValue) {
      var encoded = "";
      var digit;
      var vlq = toVLQSigned(aValue);
      do {
        digit = vlq & VLQ_BASE_MASK;
        vlq >>>= VLQ_BASE_SHIFT;
        if (vlq > 0) {
          digit |= VLQ_CONTINUATION_BIT;
        }
        encoded += base64.encode(digit);
      } while (vlq > 0);
      return encoded;
    };
    exports2.decode = function base64VLQ_decode(aStr, aIndex, aOutParam) {
      var strLen = aStr.length;
      var result = 0;
      var shift = 0;
      var continuation, digit;
      do {
        if (aIndex >= strLen) {
          throw new Error("Expected more digits in base 64 VLQ value.");
        }
        digit = base64.decode(aStr.charCodeAt(aIndex++));
        if (digit === -1) {
          throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
        }
        continuation = !!(digit & VLQ_CONTINUATION_BIT);
        digit &= VLQ_BASE_MASK;
        result = result + (digit << shift);
        shift += VLQ_BASE_SHIFT;
      } while (continuation);
      aOutParam.value = fromVLQSigned(result);
      aOutParam.rest = aIndex;
    };
  }
});

// node_modules/source-map-js/lib/util.js
var require_util = __commonJS({
  "node_modules/source-map-js/lib/util.js"(exports2) {
    function getArg(aArgs, aName, aDefaultValue) {
      if (aName in aArgs) {
        return aArgs[aName];
      } else if (arguments.length === 3) {
        return aDefaultValue;
      } else {
        throw new Error('"' + aName + '" is a required argument.');
      }
    }
    exports2.getArg = getArg;
    var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/;
    var dataUrlRegexp = /^data:.+\,.+$/;
    function urlParse(aUrl) {
      var match = aUrl.match(urlRegexp);
      if (!match) {
        return null;
      }
      return {
        scheme: match[1],
        auth: match[2],
        host: match[3],
        port: match[4],
        path: match[5]
      };
    }
    exports2.urlParse = urlParse;
    function urlGenerate(aParsedUrl) {
      var url = "";
      if (aParsedUrl.scheme) {
        url += aParsedUrl.scheme + ":";
      }
      url += "//";
      if (aParsedUrl.auth) {
        url += aParsedUrl.auth + "@";
      }
      if (aParsedUrl.host) {
        url += aParsedUrl.host;
      }
      if (aParsedUrl.port) {
        url += ":" + aParsedUrl.port;
      }
      if (aParsedUrl.path) {
        url += aParsedUrl.path;
      }
      return url;
    }
    exports2.urlGenerate = urlGenerate;
    var MAX_CACHED_INPUTS = 32;
    function lruMemoize(f) {
      var cache = [];
      return function(input) {
        for (var i = 0; i < cache.length; i++) {
          if (cache[i].input === input) {
            var temp = cache[0];
            cache[0] = cache[i];
            cache[i] = temp;
            return cache[0].result;
          }
        }
        var result = f(input);
        cache.unshift({
          input,
          result
        });
        if (cache.length > MAX_CACHED_INPUTS) {
          cache.pop();
        }
        return result;
      };
    }
    var normalize = lruMemoize(function normalize2(aPath) {
      var path = aPath;
      var url = urlParse(aPath);
      if (url) {
        if (!url.path) {
          return aPath;
        }
        path = url.path;
      }
      var isAbsolute = exports2.isAbsolute(path);
      var parts = [];
      var start = 0;
      var i = 0;
      while (true) {
        start = i;
        i = path.indexOf("/", start);
        if (i === -1) {
          parts.push(path.slice(start));
          break;
        } else {
          parts.push(path.slice(start, i));
          while (i < path.length && path[i] === "/") {
            i++;
          }
        }
      }
      for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
        part = parts[i];
        if (part === ".") {
          parts.splice(i, 1);
        } else if (part === "..") {
          up++;
        } else if (up > 0) {
          if (part === "") {
            parts.splice(i + 1, up);
            up = 0;
          } else {
            parts.splice(i, 2);
            up--;
          }
        }
      }
      path = parts.join("/");
      if (path === "") {
        path = isAbsolute ? "/" : ".";
      }
      if (url) {
        url.path = path;
        return urlGenerate(url);
      }
      return path;
    });
    exports2.normalize = normalize;
    function join(aRoot, aPath) {
      if (aRoot === "") {
        aRoot = ".";
      }
      if (aPath === "") {
        aPath = ".";
      }
      var aPathUrl = urlParse(aPath);
      var aRootUrl = urlParse(aRoot);
      if (aRootUrl) {
        aRoot = aRootUrl.path || "/";
      }
      if (aPathUrl && !aPathUrl.scheme) {
        if (aRootUrl) {
          aPathUrl.scheme = aRootUrl.scheme;
        }
        return urlGenerate(aPathUrl);
      }
      if (aPathUrl || aPath.match(dataUrlRegexp)) {
        return aPath;
      }
      if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
        aRootUrl.host = aPath;
        return urlGenerate(aRootUrl);
      }
      var joined = aPath.charAt(0) === "/" ? aPath : normalize(aRoot.replace(/\/+$/, "") + "/" + aPath);
      if (aRootUrl) {
        aRootUrl.path = joined;
        return urlGenerate(aRootUrl);
      }
      return joined;
    }
    exports2.join = join;
    exports2.isAbsolute = function(aPath) {
      return aPath.charAt(0) === "/" || urlRegexp.test(aPath);
    };
    function relative(aRoot, aPath) {
      if (aRoot === "") {
        aRoot = ".";
      }
      aRoot = aRoot.replace(/\/$/, "");
      var level = 0;
      while (aPath.indexOf(aRoot + "/") !== 0) {
        var index = aRoot.lastIndexOf("/");
        if (index < 0) {
          return aPath;
        }
        aRoot = aRoot.slice(0, index);
        if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
          return aPath;
        }
        ++level;
      }
      return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
    }
    exports2.relative = relative;
    var supportsNullProto = function() {
      var obj = /* @__PURE__ */ Object.create(null);
      return !("__proto__" in obj);
    }();
    function identity(s) {
      return s;
    }
    function toSetString(aStr) {
      if (isProtoString(aStr)) {
        return "$" + aStr;
      }
      return aStr;
    }
    exports2.toSetString = supportsNullProto ? identity : toSetString;
    function fromSetString(aStr) {
      if (isProtoString(aStr)) {
        return aStr.slice(1);
      }
      return aStr;
    }
    exports2.fromSetString = supportsNullProto ? identity : fromSetString;
    function isProtoString(s) {
      if (!s) {
        return false;
      }
      var length = s.length;
      if (length < 9) {
        return false;
      }
      if (s.charCodeAt(length - 1) !== 95 || s.charCodeAt(length - 2) !== 95 || s.charCodeAt(length - 3) !== 111 || s.charCodeAt(length - 4) !== 116 || s.charCodeAt(length - 5) !== 111 || s.charCodeAt(length - 6) !== 114 || s.charCodeAt(length - 7) !== 112 || s.charCodeAt(length - 8) !== 95 || s.charCodeAt(length - 9) !== 95) {
        return false;
      }
      for (var i = length - 10; i >= 0; i--) {
        if (s.charCodeAt(i) !== 36) {
          return false;
        }
      }
      return true;
    }
    function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
      var cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0 || onlyCompareOriginal) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports2.compareByOriginalPositions = compareByOriginalPositions;
    function compareByOriginalPositionsNoSource(mappingA, mappingB, onlyCompareOriginal) {
      var cmp;
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0 || onlyCompareOriginal) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports2.compareByOriginalPositionsNoSource = compareByOriginalPositionsNoSource;
    function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
      var cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0 || onlyCompareGenerated) {
        return cmp;
      }
      cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports2.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;
    function compareByGeneratedPositionsDeflatedNoLine(mappingA, mappingB, onlyCompareGenerated) {
      var cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0 || onlyCompareGenerated) {
        return cmp;
      }
      cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports2.compareByGeneratedPositionsDeflatedNoLine = compareByGeneratedPositionsDeflatedNoLine;
    function strcmp(aStr1, aStr2) {
      if (aStr1 === aStr2) {
        return 0;
      }
      if (aStr1 === null) {
        return 1;
      }
      if (aStr2 === null) {
        return -1;
      }
      if (aStr1 > aStr2) {
        return 1;
      }
      return -1;
    }
    function compareByGeneratedPositionsInflated(mappingA, mappingB) {
      var cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports2.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;
    function parseSourceMapInput(str) {
      return JSON.parse(str.replace(/^\)]}'[^\n]*\n/, ""));
    }
    exports2.parseSourceMapInput = parseSourceMapInput;
    function computeSourceURL(sourceRoot, sourceURL, sourceMapURL) {
      sourceURL = sourceURL || "";
      if (sourceRoot) {
        if (sourceRoot[sourceRoot.length - 1] !== "/" && sourceURL[0] !== "/") {
          sourceRoot += "/";
        }
        sourceURL = sourceRoot + sourceURL;
      }
      if (sourceMapURL) {
        var parsed = urlParse(sourceMapURL);
        if (!parsed) {
          throw new Error("sourceMapURL could not be parsed");
        }
        if (parsed.path) {
          var index = parsed.path.lastIndexOf("/");
          if (index >= 0) {
            parsed.path = parsed.path.substring(0, index + 1);
          }
        }
        sourceURL = join(urlGenerate(parsed), sourceURL);
      }
      return normalize(sourceURL);
    }
    exports2.computeSourceURL = computeSourceURL;
  }
});

// node_modules/source-map-js/lib/array-set.js
var require_array_set = __commonJS({
  "node_modules/source-map-js/lib/array-set.js"(exports2) {
    var util = require_util();
    var has = Object.prototype.hasOwnProperty;
    var hasNativeMap = typeof Map !== "undefined";
    function ArraySet() {
      this._array = [];
      this._set = hasNativeMap ? /* @__PURE__ */ new Map() : /* @__PURE__ */ Object.create(null);
    }
    ArraySet.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
      var set = new ArraySet();
      for (var i = 0, len = aArray.length; i < len; i++) {
        set.add(aArray[i], aAllowDuplicates);
      }
      return set;
    };
    ArraySet.prototype.size = function ArraySet_size() {
      return hasNativeMap ? this._set.size : Object.getOwnPropertyNames(this._set).length;
    };
    ArraySet.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
      var sStr = hasNativeMap ? aStr : util.toSetString(aStr);
      var isDuplicate = hasNativeMap ? this.has(aStr) : has.call(this._set, sStr);
      var idx = this._array.length;
      if (!isDuplicate || aAllowDuplicates) {
        this._array.push(aStr);
      }
      if (!isDuplicate) {
        if (hasNativeMap) {
          this._set.set(aStr, idx);
        } else {
          this._set[sStr] = idx;
        }
      }
    };
    ArraySet.prototype.has = function ArraySet_has(aStr) {
      if (hasNativeMap) {
        return this._set.has(aStr);
      } else {
        var sStr = util.toSetString(aStr);
        return has.call(this._set, sStr);
      }
    };
    ArraySet.prototype.indexOf = function ArraySet_indexOf(aStr) {
      if (hasNativeMap) {
        var idx = this._set.get(aStr);
        if (idx >= 0) {
          return idx;
        }
      } else {
        var sStr = util.toSetString(aStr);
        if (has.call(this._set, sStr)) {
          return this._set[sStr];
        }
      }
      throw new Error('"' + aStr + '" is not in the set.');
    };
    ArraySet.prototype.at = function ArraySet_at(aIdx) {
      if (aIdx >= 0 && aIdx < this._array.length) {
        return this._array[aIdx];
      }
      throw new Error("No element indexed by " + aIdx);
    };
    ArraySet.prototype.toArray = function ArraySet_toArray() {
      return this._array.slice();
    };
    exports2.ArraySet = ArraySet;
  }
});

// node_modules/source-map-js/lib/mapping-list.js
var require_mapping_list = __commonJS({
  "node_modules/source-map-js/lib/mapping-list.js"(exports2) {
    var util = require_util();
    function generatedPositionAfter(mappingA, mappingB) {
      var lineA = mappingA.generatedLine;
      var lineB = mappingB.generatedLine;
      var columnA = mappingA.generatedColumn;
      var columnB = mappingB.generatedColumn;
      return lineB > lineA || lineB == lineA && columnB >= columnA || util.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
    }
    function MappingList() {
      this._array = [];
      this._sorted = true;
      this._last = { generatedLine: -1, generatedColumn: 0 };
    }
    MappingList.prototype.unsortedForEach = function MappingList_forEach(aCallback, aThisArg) {
      this._array.forEach(aCallback, aThisArg);
    };
    MappingList.prototype.add = function MappingList_add(aMapping) {
      if (generatedPositionAfter(this._last, aMapping)) {
        this._last = aMapping;
        this._array.push(aMapping);
      } else {
        this._sorted = false;
        this._array.push(aMapping);
      }
    };
    MappingList.prototype.toArray = function MappingList_toArray() {
      if (!this._sorted) {
        this._array.sort(util.compareByGeneratedPositionsInflated);
        this._sorted = true;
      }
      return this._array;
    };
    exports2.MappingList = MappingList;
  }
});

// node_modules/source-map-js/lib/source-map-generator.js
var require_source_map_generator = __commonJS({
  "node_modules/source-map-js/lib/source-map-generator.js"(exports2) {
    var base64VLQ = require_base64_vlq();
    var util = require_util();
    var ArraySet = require_array_set().ArraySet;
    var MappingList = require_mapping_list().MappingList;
    function SourceMapGenerator(aArgs) {
      if (!aArgs) {
        aArgs = {};
      }
      this._file = util.getArg(aArgs, "file", null);
      this._sourceRoot = util.getArg(aArgs, "sourceRoot", null);
      this._skipValidation = util.getArg(aArgs, "skipValidation", false);
      this._ignoreInvalidMapping = util.getArg(aArgs, "ignoreInvalidMapping", false);
      this._sources = new ArraySet();
      this._names = new ArraySet();
      this._mappings = new MappingList();
      this._sourcesContents = null;
    }
    SourceMapGenerator.prototype._version = 3;
    SourceMapGenerator.fromSourceMap = function SourceMapGenerator_fromSourceMap(aSourceMapConsumer, generatorOps) {
      var sourceRoot = aSourceMapConsumer.sourceRoot;
      var generator = new SourceMapGenerator(Object.assign(generatorOps || {}, {
        file: aSourceMapConsumer.file,
        sourceRoot
      }));
      aSourceMapConsumer.eachMapping(function(mapping) {
        var newMapping = {
          generated: {
            line: mapping.generatedLine,
            column: mapping.generatedColumn
          }
        };
        if (mapping.source != null) {
          newMapping.source = mapping.source;
          if (sourceRoot != null) {
            newMapping.source = util.relative(sourceRoot, newMapping.source);
          }
          newMapping.original = {
            line: mapping.originalLine,
            column: mapping.originalColumn
          };
          if (mapping.name != null) {
            newMapping.name = mapping.name;
          }
        }
        generator.addMapping(newMapping);
      });
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var sourceRelative = sourceFile;
        if (sourceRoot !== null) {
          sourceRelative = util.relative(sourceRoot, sourceFile);
        }
        if (!generator._sources.has(sourceRelative)) {
          generator._sources.add(sourceRelative);
        }
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          generator.setSourceContent(sourceFile, content);
        }
      });
      return generator;
    };
    SourceMapGenerator.prototype.addMapping = function SourceMapGenerator_addMapping(aArgs) {
      var generated = util.getArg(aArgs, "generated");
      var original = util.getArg(aArgs, "original", null);
      var source = util.getArg(aArgs, "source", null);
      var name = util.getArg(aArgs, "name", null);
      if (!this._skipValidation) {
        if (this._validateMapping(generated, original, source, name) === false) {
          return;
        }
      }
      if (source != null) {
        source = String(source);
        if (!this._sources.has(source)) {
          this._sources.add(source);
        }
      }
      if (name != null) {
        name = String(name);
        if (!this._names.has(name)) {
          this._names.add(name);
        }
      }
      this._mappings.add({
        generatedLine: generated.line,
        generatedColumn: generated.column,
        originalLine: original != null && original.line,
        originalColumn: original != null && original.column,
        source,
        name
      });
    };
    SourceMapGenerator.prototype.setSourceContent = function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
      var source = aSourceFile;
      if (this._sourceRoot != null) {
        source = util.relative(this._sourceRoot, source);
      }
      if (aSourceContent != null) {
        if (!this._sourcesContents) {
          this._sourcesContents = /* @__PURE__ */ Object.create(null);
        }
        this._sourcesContents[util.toSetString(source)] = aSourceContent;
      } else if (this._sourcesContents) {
        delete this._sourcesContents[util.toSetString(source)];
        if (Object.keys(this._sourcesContents).length === 0) {
          this._sourcesContents = null;
        }
      }
    };
    SourceMapGenerator.prototype.applySourceMap = function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
      var sourceFile = aSourceFile;
      if (aSourceFile == null) {
        if (aSourceMapConsumer.file == null) {
          throw new Error(
            `SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, or the source map's "file" property. Both were omitted.`
          );
        }
        sourceFile = aSourceMapConsumer.file;
      }
      var sourceRoot = this._sourceRoot;
      if (sourceRoot != null) {
        sourceFile = util.relative(sourceRoot, sourceFile);
      }
      var newSources = new ArraySet();
      var newNames = new ArraySet();
      this._mappings.unsortedForEach(function(mapping) {
        if (mapping.source === sourceFile && mapping.originalLine != null) {
          var original = aSourceMapConsumer.originalPositionFor({
            line: mapping.originalLine,
            column: mapping.originalColumn
          });
          if (original.source != null) {
            mapping.source = original.source;
            if (aSourceMapPath != null) {
              mapping.source = util.join(aSourceMapPath, mapping.source);
            }
            if (sourceRoot != null) {
              mapping.source = util.relative(sourceRoot, mapping.source);
            }
            mapping.originalLine = original.line;
            mapping.originalColumn = original.column;
            if (original.name != null) {
              mapping.name = original.name;
            }
          }
        }
        var source = mapping.source;
        if (source != null && !newSources.has(source)) {
          newSources.add(source);
        }
        var name = mapping.name;
        if (name != null && !newNames.has(name)) {
          newNames.add(name);
        }
      }, this);
      this._sources = newSources;
      this._names = newNames;
      aSourceMapConsumer.sources.forEach(function(sourceFile2) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile2);
        if (content != null) {
          if (aSourceMapPath != null) {
            sourceFile2 = util.join(aSourceMapPath, sourceFile2);
          }
          if (sourceRoot != null) {
            sourceFile2 = util.relative(sourceRoot, sourceFile2);
          }
          this.setSourceContent(sourceFile2, content);
        }
      }, this);
    };
    SourceMapGenerator.prototype._validateMapping = function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource, aName) {
      if (aOriginal && typeof aOriginal.line !== "number" && typeof aOriginal.column !== "number") {
        var message = "original.line and original.column are not numbers -- you probably meant to omit the original mapping entirely and only map the generated position. If so, pass null for the original mapping instead of an object with empty or null values.";
        if (this._ignoreInvalidMapping) {
          if (typeof console !== "undefined" && console.warn) {
            console.warn(message);
          }
          return false;
        } else {
          throw new Error(message);
        }
      }
      if (aGenerated && "line" in aGenerated && "column" in aGenerated && aGenerated.line > 0 && aGenerated.column >= 0 && !aOriginal && !aSource && !aName) {
        return;
      } else if (aGenerated && "line" in aGenerated && "column" in aGenerated && aOriginal && "line" in aOriginal && "column" in aOriginal && aGenerated.line > 0 && aGenerated.column >= 0 && aOriginal.line > 0 && aOriginal.column >= 0 && aSource) {
        return;
      } else {
        var message = "Invalid mapping: " + JSON.stringify({
          generated: aGenerated,
          source: aSource,
          original: aOriginal,
          name: aName
        });
        if (this._ignoreInvalidMapping) {
          if (typeof console !== "undefined" && console.warn) {
            console.warn(message);
          }
          return false;
        } else {
          throw new Error(message);
        }
      }
    };
    SourceMapGenerator.prototype._serializeMappings = function SourceMapGenerator_serializeMappings() {
      var previousGeneratedColumn = 0;
      var previousGeneratedLine = 1;
      var previousOriginalColumn = 0;
      var previousOriginalLine = 0;
      var previousName = 0;
      var previousSource = 0;
      var result = "";
      var next;
      var mapping;
      var nameIdx;
      var sourceIdx;
      var mappings = this._mappings.toArray();
      for (var i = 0, len = mappings.length; i < len; i++) {
        mapping = mappings[i];
        next = "";
        if (mapping.generatedLine !== previousGeneratedLine) {
          previousGeneratedColumn = 0;
          while (mapping.generatedLine !== previousGeneratedLine) {
            next += ";";
            previousGeneratedLine++;
          }
        } else {
          if (i > 0) {
            if (!util.compareByGeneratedPositionsInflated(mapping, mappings[i - 1])) {
              continue;
            }
            next += ",";
          }
        }
        next += base64VLQ.encode(mapping.generatedColumn - previousGeneratedColumn);
        previousGeneratedColumn = mapping.generatedColumn;
        if (mapping.source != null) {
          sourceIdx = this._sources.indexOf(mapping.source);
          next += base64VLQ.encode(sourceIdx - previousSource);
          previousSource = sourceIdx;
          next += base64VLQ.encode(mapping.originalLine - 1 - previousOriginalLine);
          previousOriginalLine = mapping.originalLine - 1;
          next += base64VLQ.encode(mapping.originalColumn - previousOriginalColumn);
          previousOriginalColumn = mapping.originalColumn;
          if (mapping.name != null) {
            nameIdx = this._names.indexOf(mapping.name);
            next += base64VLQ.encode(nameIdx - previousName);
            previousName = nameIdx;
          }
        }
        result += next;
      }
      return result;
    };
    SourceMapGenerator.prototype._generateSourcesContent = function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
      return aSources.map(function(source) {
        if (!this._sourcesContents) {
          return null;
        }
        if (aSourceRoot != null) {
          source = util.relative(aSourceRoot, source);
        }
        var key = util.toSetString(source);
        return Object.prototype.hasOwnProperty.call(this._sourcesContents, key) ? this._sourcesContents[key] : null;
      }, this);
    };
    SourceMapGenerator.prototype.toJSON = function SourceMapGenerator_toJSON() {
      var map = {
        version: this._version,
        sources: this._sources.toArray(),
        names: this._names.toArray(),
        mappings: this._serializeMappings()
      };
      if (this._file != null) {
        map.file = this._file;
      }
      if (this._sourceRoot != null) {
        map.sourceRoot = this._sourceRoot;
      }
      if (this._sourcesContents) {
        map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
      }
      return map;
    };
    SourceMapGenerator.prototype.toString = function SourceMapGenerator_toString() {
      return JSON.stringify(this.toJSON());
    };
    exports2.SourceMapGenerator = SourceMapGenerator;
  }
});

// node_modules/source-map-js/lib/binary-search.js
var require_binary_search = __commonJS({
  "node_modules/source-map-js/lib/binary-search.js"(exports2) {
    exports2.GREATEST_LOWER_BOUND = 1;
    exports2.LEAST_UPPER_BOUND = 2;
    function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare, aBias) {
      var mid = Math.floor((aHigh - aLow) / 2) + aLow;
      var cmp = aCompare(aNeedle, aHaystack[mid], true);
      if (cmp === 0) {
        return mid;
      } else if (cmp > 0) {
        if (aHigh - mid > 1) {
          return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
        }
        if (aBias == exports2.LEAST_UPPER_BOUND) {
          return aHigh < aHaystack.length ? aHigh : -1;
        } else {
          return mid;
        }
      } else {
        if (mid - aLow > 1) {
          return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
        }
        if (aBias == exports2.LEAST_UPPER_BOUND) {
          return mid;
        } else {
          return aLow < 0 ? -1 : aLow;
        }
      }
    }
    exports2.search = function search(aNeedle, aHaystack, aCompare, aBias) {
      if (aHaystack.length === 0) {
        return -1;
      }
      var index = recursiveSearch(
        -1,
        aHaystack.length,
        aNeedle,
        aHaystack,
        aCompare,
        aBias || exports2.GREATEST_LOWER_BOUND
      );
      if (index < 0) {
        return -1;
      }
      while (index - 1 >= 0) {
        if (aCompare(aHaystack[index], aHaystack[index - 1], true) !== 0) {
          break;
        }
        --index;
      }
      return index;
    };
  }
});

// node_modules/source-map-js/lib/quick-sort.js
var require_quick_sort = __commonJS({
  "node_modules/source-map-js/lib/quick-sort.js"(exports2) {
    function SortTemplate(comparator) {
      function swap(ary, x, y) {
        var temp = ary[x];
        ary[x] = ary[y];
        ary[y] = temp;
      }
      function randomIntInRange(low, high) {
        return Math.round(low + Math.random() * (high - low));
      }
      function doQuickSort(ary, comparator2, p, r) {
        if (p < r) {
          var pivotIndex = randomIntInRange(p, r);
          var i = p - 1;
          swap(ary, pivotIndex, r);
          var pivot = ary[r];
          for (var j = p; j < r; j++) {
            if (comparator2(ary[j], pivot, false) <= 0) {
              i += 1;
              swap(ary, i, j);
            }
          }
          swap(ary, i + 1, j);
          var q = i + 1;
          doQuickSort(ary, comparator2, p, q - 1);
          doQuickSort(ary, comparator2, q + 1, r);
        }
      }
      return doQuickSort;
    }
    function cloneSort(comparator) {
      let template = SortTemplate.toString();
      let templateFn = new Function(`return ${template}`)();
      return templateFn(comparator);
    }
    var sortCache = /* @__PURE__ */ new WeakMap();
    exports2.quickSort = function(ary, comparator, start = 0) {
      let doQuickSort = sortCache.get(comparator);
      if (doQuickSort === void 0) {
        doQuickSort = cloneSort(comparator);
        sortCache.set(comparator, doQuickSort);
      }
      doQuickSort(ary, comparator, start, ary.length - 1);
    };
  }
});

// node_modules/source-map-js/lib/source-map-consumer.js
var require_source_map_consumer = __commonJS({
  "node_modules/source-map-js/lib/source-map-consumer.js"(exports2) {
    var util = require_util();
    var binarySearch = require_binary_search();
    var ArraySet = require_array_set().ArraySet;
    var base64VLQ = require_base64_vlq();
    var quickSort = require_quick_sort().quickSort;
    function SourceMapConsumer(aSourceMap, aSourceMapURL) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = util.parseSourceMapInput(aSourceMap);
      }
      return sourceMap.sections != null ? new IndexedSourceMapConsumer(sourceMap, aSourceMapURL) : new BasicSourceMapConsumer(sourceMap, aSourceMapURL);
    }
    SourceMapConsumer.fromSourceMap = function(aSourceMap, aSourceMapURL) {
      return BasicSourceMapConsumer.fromSourceMap(aSourceMap, aSourceMapURL);
    };
    SourceMapConsumer.prototype._version = 3;
    SourceMapConsumer.prototype.__generatedMappings = null;
    Object.defineProperty(SourceMapConsumer.prototype, "_generatedMappings", {
      configurable: true,
      enumerable: true,
      get: function() {
        if (!this.__generatedMappings) {
          this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__generatedMappings;
      }
    });
    SourceMapConsumer.prototype.__originalMappings = null;
    Object.defineProperty(SourceMapConsumer.prototype, "_originalMappings", {
      configurable: true,
      enumerable: true,
      get: function() {
        if (!this.__originalMappings) {
          this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__originalMappings;
      }
    });
    SourceMapConsumer.prototype._charIsMappingSeparator = function SourceMapConsumer_charIsMappingSeparator(aStr, index) {
      var c = aStr.charAt(index);
      return c === ";" || c === ",";
    };
    SourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      throw new Error("Subclasses must implement _parseMappings");
    };
    SourceMapConsumer.GENERATED_ORDER = 1;
    SourceMapConsumer.ORIGINAL_ORDER = 2;
    SourceMapConsumer.GREATEST_LOWER_BOUND = 1;
    SourceMapConsumer.LEAST_UPPER_BOUND = 2;
    SourceMapConsumer.prototype.eachMapping = function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
      var context = aContext || null;
      var order = aOrder || SourceMapConsumer.GENERATED_ORDER;
      var mappings;
      switch (order) {
        case SourceMapConsumer.GENERATED_ORDER:
          mappings = this._generatedMappings;
          break;
        case SourceMapConsumer.ORIGINAL_ORDER:
          mappings = this._originalMappings;
          break;
        default:
          throw new Error("Unknown order of iteration.");
      }
      var sourceRoot = this.sourceRoot;
      var boundCallback = aCallback.bind(context);
      var names = this._names;
      var sources = this._sources;
      var sourceMapURL = this._sourceMapURL;
      for (var i = 0, n = mappings.length; i < n; i++) {
        var mapping = mappings[i];
        var source = mapping.source === null ? null : sources.at(mapping.source);
        source = util.computeSourceURL(sourceRoot, source, sourceMapURL);
        boundCallback({
          source,
          generatedLine: mapping.generatedLine,
          generatedColumn: mapping.generatedColumn,
          originalLine: mapping.originalLine,
          originalColumn: mapping.originalColumn,
          name: mapping.name === null ? null : names.at(mapping.name)
        });
      }
    };
    SourceMapConsumer.prototype.allGeneratedPositionsFor = function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
      var line = util.getArg(aArgs, "line");
      var needle = {
        source: util.getArg(aArgs, "source"),
        originalLine: line,
        originalColumn: util.getArg(aArgs, "column", 0)
      };
      needle.source = this._findSourceIndex(needle.source);
      if (needle.source < 0) {
        return [];
      }
      var mappings = [];
      var index = this._findMapping(
        needle,
        this._originalMappings,
        "originalLine",
        "originalColumn",
        util.compareByOriginalPositions,
        binarySearch.LEAST_UPPER_BOUND
      );
      if (index >= 0) {
        var mapping = this._originalMappings[index];
        if (aArgs.column === void 0) {
          var originalLine = mapping.originalLine;
          while (mapping && mapping.originalLine === originalLine) {
            mappings.push({
              line: util.getArg(mapping, "generatedLine", null),
              column: util.getArg(mapping, "generatedColumn", null),
              lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
            });
            mapping = this._originalMappings[++index];
          }
        } else {
          var originalColumn = mapping.originalColumn;
          while (mapping && mapping.originalLine === line && mapping.originalColumn == originalColumn) {
            mappings.push({
              line: util.getArg(mapping, "generatedLine", null),
              column: util.getArg(mapping, "generatedColumn", null),
              lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
            });
            mapping = this._originalMappings[++index];
          }
        }
      }
      return mappings;
    };
    exports2.SourceMapConsumer = SourceMapConsumer;
    function BasicSourceMapConsumer(aSourceMap, aSourceMapURL) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = util.parseSourceMapInput(aSourceMap);
      }
      var version = util.getArg(sourceMap, "version");
      var sources = util.getArg(sourceMap, "sources");
      var names = util.getArg(sourceMap, "names", []);
      var sourceRoot = util.getArg(sourceMap, "sourceRoot", null);
      var sourcesContent = util.getArg(sourceMap, "sourcesContent", null);
      var mappings = util.getArg(sourceMap, "mappings");
      var file = util.getArg(sourceMap, "file", null);
      if (version != this._version) {
        throw new Error("Unsupported version: " + version);
      }
      if (sourceRoot) {
        sourceRoot = util.normalize(sourceRoot);
      }
      sources = sources.map(String).map(util.normalize).map(function(source) {
        return sourceRoot && util.isAbsolute(sourceRoot) && util.isAbsolute(source) ? util.relative(sourceRoot, source) : source;
      });
      this._names = ArraySet.fromArray(names.map(String), true);
      this._sources = ArraySet.fromArray(sources, true);
      this._absoluteSources = this._sources.toArray().map(function(s) {
        return util.computeSourceURL(sourceRoot, s, aSourceMapURL);
      });
      this.sourceRoot = sourceRoot;
      this.sourcesContent = sourcesContent;
      this._mappings = mappings;
      this._sourceMapURL = aSourceMapURL;
      this.file = file;
    }
    BasicSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
    BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer;
    BasicSourceMapConsumer.prototype._findSourceIndex = function(aSource) {
      var relativeSource = aSource;
      if (this.sourceRoot != null) {
        relativeSource = util.relative(this.sourceRoot, relativeSource);
      }
      if (this._sources.has(relativeSource)) {
        return this._sources.indexOf(relativeSource);
      }
      var i;
      for (i = 0; i < this._absoluteSources.length; ++i) {
        if (this._absoluteSources[i] == aSource) {
          return i;
        }
      }
      return -1;
    };
    BasicSourceMapConsumer.fromSourceMap = function SourceMapConsumer_fromSourceMap(aSourceMap, aSourceMapURL) {
      var smc = Object.create(BasicSourceMapConsumer.prototype);
      var names = smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
      var sources = smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
      smc.sourceRoot = aSourceMap._sourceRoot;
      smc.sourcesContent = aSourceMap._generateSourcesContent(
        smc._sources.toArray(),
        smc.sourceRoot
      );
      smc.file = aSourceMap._file;
      smc._sourceMapURL = aSourceMapURL;
      smc._absoluteSources = smc._sources.toArray().map(function(s) {
        return util.computeSourceURL(smc.sourceRoot, s, aSourceMapURL);
      });
      var generatedMappings = aSourceMap._mappings.toArray().slice();
      var destGeneratedMappings = smc.__generatedMappings = [];
      var destOriginalMappings = smc.__originalMappings = [];
      for (var i = 0, length = generatedMappings.length; i < length; i++) {
        var srcMapping = generatedMappings[i];
        var destMapping = new Mapping();
        destMapping.generatedLine = srcMapping.generatedLine;
        destMapping.generatedColumn = srcMapping.generatedColumn;
        if (srcMapping.source) {
          destMapping.source = sources.indexOf(srcMapping.source);
          destMapping.originalLine = srcMapping.originalLine;
          destMapping.originalColumn = srcMapping.originalColumn;
          if (srcMapping.name) {
            destMapping.name = names.indexOf(srcMapping.name);
          }
          destOriginalMappings.push(destMapping);
        }
        destGeneratedMappings.push(destMapping);
      }
      quickSort(smc.__originalMappings, util.compareByOriginalPositions);
      return smc;
    };
    BasicSourceMapConsumer.prototype._version = 3;
    Object.defineProperty(BasicSourceMapConsumer.prototype, "sources", {
      get: function() {
        return this._absoluteSources.slice();
      }
    });
    function Mapping() {
      this.generatedLine = 0;
      this.generatedColumn = 0;
      this.source = null;
      this.originalLine = null;
      this.originalColumn = null;
      this.name = null;
    }
    var compareGenerated = util.compareByGeneratedPositionsDeflatedNoLine;
    function sortGenerated(array, start) {
      let l = array.length;
      let n = array.length - start;
      if (n <= 1) {
        return;
      } else if (n == 2) {
        let a = array[start];
        let b = array[start + 1];
        if (compareGenerated(a, b) > 0) {
          array[start] = b;
          array[start + 1] = a;
        }
      } else if (n < 20) {
        for (let i = start; i < l; i++) {
          for (let j = i; j > start; j--) {
            let a = array[j - 1];
            let b = array[j];
            if (compareGenerated(a, b) <= 0) {
              break;
            }
            array[j - 1] = b;
            array[j] = a;
          }
        }
      } else {
        quickSort(array, compareGenerated, start);
      }
    }
    BasicSourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      var generatedLine = 1;
      var previousGeneratedColumn = 0;
      var previousOriginalLine = 0;
      var previousOriginalColumn = 0;
      var previousSource = 0;
      var previousName = 0;
      var length = aStr.length;
      var index = 0;
      var cachedSegments = {};
      var temp = {};
      var originalMappings = [];
      var generatedMappings = [];
      var mapping, str, segment, end, value;
      let subarrayStart = 0;
      while (index < length) {
        if (aStr.charAt(index) === ";") {
          generatedLine++;
          index++;
          previousGeneratedColumn = 0;
          sortGenerated(generatedMappings, subarrayStart);
          subarrayStart = generatedMappings.length;
        } else if (aStr.charAt(index) === ",") {
          index++;
        } else {
          mapping = new Mapping();
          mapping.generatedLine = generatedLine;
          for (end = index; end < length; end++) {
            if (this._charIsMappingSeparator(aStr, end)) {
              break;
            }
          }
          str = aStr.slice(index, end);
          segment = [];
          while (index < end) {
            base64VLQ.decode(aStr, index, temp);
            value = temp.value;
            index = temp.rest;
            segment.push(value);
          }
          if (segment.length === 2) {
            throw new Error("Found a source, but no line and column");
          }
          if (segment.length === 3) {
            throw new Error("Found a source and line, but no column");
          }
          mapping.generatedColumn = previousGeneratedColumn + segment[0];
          previousGeneratedColumn = mapping.generatedColumn;
          if (segment.length > 1) {
            mapping.source = previousSource + segment[1];
            previousSource += segment[1];
            mapping.originalLine = previousOriginalLine + segment[2];
            previousOriginalLine = mapping.originalLine;
            mapping.originalLine += 1;
            mapping.originalColumn = previousOriginalColumn + segment[3];
            previousOriginalColumn = mapping.originalColumn;
            if (segment.length > 4) {
              mapping.name = previousName + segment[4];
              previousName += segment[4];
            }
          }
          generatedMappings.push(mapping);
          if (typeof mapping.originalLine === "number") {
            let currentSource = mapping.source;
            while (originalMappings.length <= currentSource) {
              originalMappings.push(null);
            }
            if (originalMappings[currentSource] === null) {
              originalMappings[currentSource] = [];
            }
            originalMappings[currentSource].push(mapping);
          }
        }
      }
      sortGenerated(generatedMappings, subarrayStart);
      this.__generatedMappings = generatedMappings;
      for (var i = 0; i < originalMappings.length; i++) {
        if (originalMappings[i] != null) {
          quickSort(originalMappings[i], util.compareByOriginalPositionsNoSource);
        }
      }
      this.__originalMappings = [].concat(...originalMappings);
    };
    BasicSourceMapConsumer.prototype._findMapping = function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName, aColumnName, aComparator, aBias) {
      if (aNeedle[aLineName] <= 0) {
        throw new TypeError("Line must be greater than or equal to 1, got " + aNeedle[aLineName]);
      }
      if (aNeedle[aColumnName] < 0) {
        throw new TypeError("Column must be greater than or equal to 0, got " + aNeedle[aColumnName]);
      }
      return binarySearch.search(aNeedle, aMappings, aComparator, aBias);
    };
    BasicSourceMapConsumer.prototype.computeColumnSpans = function SourceMapConsumer_computeColumnSpans() {
      for (var index = 0; index < this._generatedMappings.length; ++index) {
        var mapping = this._generatedMappings[index];
        if (index + 1 < this._generatedMappings.length) {
          var nextMapping = this._generatedMappings[index + 1];
          if (mapping.generatedLine === nextMapping.generatedLine) {
            mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
            continue;
          }
        }
        mapping.lastGeneratedColumn = Infinity;
      }
    };
    BasicSourceMapConsumer.prototype.originalPositionFor = function SourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, "line"),
        generatedColumn: util.getArg(aArgs, "column")
      };
      var index = this._findMapping(
        needle,
        this._generatedMappings,
        "generatedLine",
        "generatedColumn",
        util.compareByGeneratedPositionsDeflated,
        util.getArg(aArgs, "bias", SourceMapConsumer.GREATEST_LOWER_BOUND)
      );
      if (index >= 0) {
        var mapping = this._generatedMappings[index];
        if (mapping.generatedLine === needle.generatedLine) {
          var source = util.getArg(mapping, "source", null);
          if (source !== null) {
            source = this._sources.at(source);
            source = util.computeSourceURL(this.sourceRoot, source, this._sourceMapURL);
          }
          var name = util.getArg(mapping, "name", null);
          if (name !== null) {
            name = this._names.at(name);
          }
          return {
            source,
            line: util.getArg(mapping, "originalLine", null),
            column: util.getArg(mapping, "originalColumn", null),
            name
          };
        }
      }
      return {
        source: null,
        line: null,
        column: null,
        name: null
      };
    };
    BasicSourceMapConsumer.prototype.hasContentsOfAllSources = function BasicSourceMapConsumer_hasContentsOfAllSources() {
      if (!this.sourcesContent) {
        return false;
      }
      return this.sourcesContent.length >= this._sources.size() && !this.sourcesContent.some(function(sc) {
        return sc == null;
      });
    };
    BasicSourceMapConsumer.prototype.sourceContentFor = function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      if (!this.sourcesContent) {
        return null;
      }
      var index = this._findSourceIndex(aSource);
      if (index >= 0) {
        return this.sourcesContent[index];
      }
      var relativeSource = aSource;
      if (this.sourceRoot != null) {
        relativeSource = util.relative(this.sourceRoot, relativeSource);
      }
      var url;
      if (this.sourceRoot != null && (url = util.urlParse(this.sourceRoot))) {
        var fileUriAbsPath = relativeSource.replace(/^file:\/\//, "");
        if (url.scheme == "file" && this._sources.has(fileUriAbsPath)) {
          return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)];
        }
        if ((!url.path || url.path == "/") && this._sources.has("/" + relativeSource)) {
          return this.sourcesContent[this._sources.indexOf("/" + relativeSource)];
        }
      }
      if (nullOnMissing) {
        return null;
      } else {
        throw new Error('"' + relativeSource + '" is not in the SourceMap.');
      }
    };
    BasicSourceMapConsumer.prototype.generatedPositionFor = function SourceMapConsumer_generatedPositionFor(aArgs) {
      var source = util.getArg(aArgs, "source");
      source = this._findSourceIndex(source);
      if (source < 0) {
        return {
          line: null,
          column: null,
          lastColumn: null
        };
      }
      var needle = {
        source,
        originalLine: util.getArg(aArgs, "line"),
        originalColumn: util.getArg(aArgs, "column")
      };
      var index = this._findMapping(
        needle,
        this._originalMappings,
        "originalLine",
        "originalColumn",
        util.compareByOriginalPositions,
        util.getArg(aArgs, "bias", SourceMapConsumer.GREATEST_LOWER_BOUND)
      );
      if (index >= 0) {
        var mapping = this._originalMappings[index];
        if (mapping.source === needle.source) {
          return {
            line: util.getArg(mapping, "generatedLine", null),
            column: util.getArg(mapping, "generatedColumn", null),
            lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
          };
        }
      }
      return {
        line: null,
        column: null,
        lastColumn: null
      };
    };
    exports2.BasicSourceMapConsumer = BasicSourceMapConsumer;
    function IndexedSourceMapConsumer(aSourceMap, aSourceMapURL) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = util.parseSourceMapInput(aSourceMap);
      }
      var version = util.getArg(sourceMap, "version");
      var sections = util.getArg(sourceMap, "sections");
      if (version != this._version) {
        throw new Error("Unsupported version: " + version);
      }
      this._sources = new ArraySet();
      this._names = new ArraySet();
      var lastOffset = {
        line: -1,
        column: 0
      };
      this._sections = sections.map(function(s) {
        if (s.url) {
          throw new Error("Support for url field in sections not implemented.");
        }
        var offset = util.getArg(s, "offset");
        var offsetLine = util.getArg(offset, "line");
        var offsetColumn = util.getArg(offset, "column");
        if (offsetLine < lastOffset.line || offsetLine === lastOffset.line && offsetColumn < lastOffset.column) {
          throw new Error("Section offsets must be ordered and non-overlapping.");
        }
        lastOffset = offset;
        return {
          generatedOffset: {
            // The offset fields are 0-based, but we use 1-based indices when
            // encoding/decoding from VLQ.
            generatedLine: offsetLine + 1,
            generatedColumn: offsetColumn + 1
          },
          consumer: new SourceMapConsumer(util.getArg(s, "map"), aSourceMapURL)
        };
      });
    }
    IndexedSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
    IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer;
    IndexedSourceMapConsumer.prototype._version = 3;
    Object.defineProperty(IndexedSourceMapConsumer.prototype, "sources", {
      get: function() {
        var sources = [];
        for (var i = 0; i < this._sections.length; i++) {
          for (var j = 0; j < this._sections[i].consumer.sources.length; j++) {
            sources.push(this._sections[i].consumer.sources[j]);
          }
        }
        return sources;
      }
    });
    IndexedSourceMapConsumer.prototype.originalPositionFor = function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, "line"),
        generatedColumn: util.getArg(aArgs, "column")
      };
      var sectionIndex = binarySearch.search(
        needle,
        this._sections,
        function(needle2, section2) {
          var cmp = needle2.generatedLine - section2.generatedOffset.generatedLine;
          if (cmp) {
            return cmp;
          }
          return needle2.generatedColumn - section2.generatedOffset.generatedColumn;
        }
      );
      var section = this._sections[sectionIndex];
      if (!section) {
        return {
          source: null,
          line: null,
          column: null,
          name: null
        };
      }
      return section.consumer.originalPositionFor({
        line: needle.generatedLine - (section.generatedOffset.generatedLine - 1),
        column: needle.generatedColumn - (section.generatedOffset.generatedLine === needle.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
        bias: aArgs.bias
      });
    };
    IndexedSourceMapConsumer.prototype.hasContentsOfAllSources = function IndexedSourceMapConsumer_hasContentsOfAllSources() {
      return this._sections.every(function(s) {
        return s.consumer.hasContentsOfAllSources();
      });
    };
    IndexedSourceMapConsumer.prototype.sourceContentFor = function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        var content = section.consumer.sourceContentFor(aSource, true);
        if (content || content === "") {
          return content;
        }
      }
      if (nullOnMissing) {
        return null;
      } else {
        throw new Error('"' + aSource + '" is not in the SourceMap.');
      }
    };
    IndexedSourceMapConsumer.prototype.generatedPositionFor = function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        if (section.consumer._findSourceIndex(util.getArg(aArgs, "source")) === -1) {
          continue;
        }
        var generatedPosition = section.consumer.generatedPositionFor(aArgs);
        if (generatedPosition) {
          var ret = {
            line: generatedPosition.line + (section.generatedOffset.generatedLine - 1),
            column: generatedPosition.column + (section.generatedOffset.generatedLine === generatedPosition.line ? section.generatedOffset.generatedColumn - 1 : 0)
          };
          return ret;
        }
      }
      return {
        line: null,
        column: null
      };
    };
    IndexedSourceMapConsumer.prototype._parseMappings = function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      this.__generatedMappings = [];
      this.__originalMappings = [];
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        var sectionMappings = section.consumer._generatedMappings;
        for (var j = 0; j < sectionMappings.length; j++) {
          var mapping = sectionMappings[j];
          var source = section.consumer._sources.at(mapping.source);
          source = util.computeSourceURL(section.consumer.sourceRoot, source, this._sourceMapURL);
          this._sources.add(source);
          source = this._sources.indexOf(source);
          var name = null;
          if (mapping.name) {
            name = section.consumer._names.at(mapping.name);
            this._names.add(name);
            name = this._names.indexOf(name);
          }
          var adjustedMapping = {
            source,
            generatedLine: mapping.generatedLine + (section.generatedOffset.generatedLine - 1),
            generatedColumn: mapping.generatedColumn + (section.generatedOffset.generatedLine === mapping.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
            originalLine: mapping.originalLine,
            originalColumn: mapping.originalColumn,
            name
          };
          this.__generatedMappings.push(adjustedMapping);
          if (typeof adjustedMapping.originalLine === "number") {
            this.__originalMappings.push(adjustedMapping);
          }
        }
      }
      quickSort(this.__generatedMappings, util.compareByGeneratedPositionsDeflated);
      quickSort(this.__originalMappings, util.compareByOriginalPositions);
    };
    exports2.IndexedSourceMapConsumer = IndexedSourceMapConsumer;
  }
});

// node_modules/source-map-js/lib/source-node.js
var require_source_node = __commonJS({
  "node_modules/source-map-js/lib/source-node.js"(exports2) {
    var SourceMapGenerator = require_source_map_generator().SourceMapGenerator;
    var util = require_util();
    var REGEX_NEWLINE = /(\r?\n)/;
    var NEWLINE_CODE = 10;
    var isSourceNode = "$$$isSourceNode$$$";
    function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
      this.children = [];
      this.sourceContents = {};
      this.line = aLine == null ? null : aLine;
      this.column = aColumn == null ? null : aColumn;
      this.source = aSource == null ? null : aSource;
      this.name = aName == null ? null : aName;
      this[isSourceNode] = true;
      if (aChunks != null)
        this.add(aChunks);
    }
    SourceNode.fromStringWithSourceMap = function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
      var node = new SourceNode();
      var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
      var remainingLinesIndex = 0;
      var shiftNextLine = function() {
        var lineContents = getNextLine();
        var newLine = getNextLine() || "";
        return lineContents + newLine;
        function getNextLine() {
          return remainingLinesIndex < remainingLines.length ? remainingLines[remainingLinesIndex++] : void 0;
        }
      };
      var lastGeneratedLine = 1, lastGeneratedColumn = 0;
      var lastMapping = null;
      aSourceMapConsumer.eachMapping(function(mapping) {
        if (lastMapping !== null) {
          if (lastGeneratedLine < mapping.generatedLine) {
            addMappingWithCode(lastMapping, shiftNextLine());
            lastGeneratedLine++;
            lastGeneratedColumn = 0;
          } else {
            var nextLine = remainingLines[remainingLinesIndex] || "";
            var code = nextLine.substr(0, mapping.generatedColumn - lastGeneratedColumn);
            remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn - lastGeneratedColumn);
            lastGeneratedColumn = mapping.generatedColumn;
            addMappingWithCode(lastMapping, code);
            lastMapping = mapping;
            return;
          }
        }
        while (lastGeneratedLine < mapping.generatedLine) {
          node.add(shiftNextLine());
          lastGeneratedLine++;
        }
        if (lastGeneratedColumn < mapping.generatedColumn) {
          var nextLine = remainingLines[remainingLinesIndex] || "";
          node.add(nextLine.substr(0, mapping.generatedColumn));
          remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn);
          lastGeneratedColumn = mapping.generatedColumn;
        }
        lastMapping = mapping;
      }, this);
      if (remainingLinesIndex < remainingLines.length) {
        if (lastMapping) {
          addMappingWithCode(lastMapping, shiftNextLine());
        }
        node.add(remainingLines.splice(remainingLinesIndex).join(""));
      }
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          if (aRelativePath != null) {
            sourceFile = util.join(aRelativePath, sourceFile);
          }
          node.setSourceContent(sourceFile, content);
        }
      });
      return node;
      function addMappingWithCode(mapping, code) {
        if (mapping === null || mapping.source === void 0) {
          node.add(code);
        } else {
          var source = aRelativePath ? util.join(aRelativePath, mapping.source) : mapping.source;
          node.add(new SourceNode(
            mapping.originalLine,
            mapping.originalColumn,
            source,
            code,
            mapping.name
          ));
        }
      }
    };
    SourceNode.prototype.add = function SourceNode_add(aChunk) {
      if (Array.isArray(aChunk)) {
        aChunk.forEach(function(chunk) {
          this.add(chunk);
        }, this);
      } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
        if (aChunk) {
          this.children.push(aChunk);
        }
      } else {
        throw new TypeError(
          "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
        );
      }
      return this;
    };
    SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
      if (Array.isArray(aChunk)) {
        for (var i = aChunk.length - 1; i >= 0; i--) {
          this.prepend(aChunk[i]);
        }
      } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
        this.children.unshift(aChunk);
      } else {
        throw new TypeError(
          "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
        );
      }
      return this;
    };
    SourceNode.prototype.walk = function SourceNode_walk(aFn) {
      var chunk;
      for (var i = 0, len = this.children.length; i < len; i++) {
        chunk = this.children[i];
        if (chunk[isSourceNode]) {
          chunk.walk(aFn);
        } else {
          if (chunk !== "") {
            aFn(chunk, {
              source: this.source,
              line: this.line,
              column: this.column,
              name: this.name
            });
          }
        }
      }
    };
    SourceNode.prototype.join = function SourceNode_join(aSep) {
      var newChildren;
      var i;
      var len = this.children.length;
      if (len > 0) {
        newChildren = [];
        for (i = 0; i < len - 1; i++) {
          newChildren.push(this.children[i]);
          newChildren.push(aSep);
        }
        newChildren.push(this.children[i]);
        this.children = newChildren;
      }
      return this;
    };
    SourceNode.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
      var lastChild = this.children[this.children.length - 1];
      if (lastChild[isSourceNode]) {
        lastChild.replaceRight(aPattern, aReplacement);
      } else if (typeof lastChild === "string") {
        this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
      } else {
        this.children.push("".replace(aPattern, aReplacement));
      }
      return this;
    };
    SourceNode.prototype.setSourceContent = function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
      this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
    };
    SourceNode.prototype.walkSourceContents = function SourceNode_walkSourceContents(aFn) {
      for (var i = 0, len = this.children.length; i < len; i++) {
        if (this.children[i][isSourceNode]) {
          this.children[i].walkSourceContents(aFn);
        }
      }
      var sources = Object.keys(this.sourceContents);
      for (var i = 0, len = sources.length; i < len; i++) {
        aFn(util.fromSetString(sources[i]), this.sourceContents[sources[i]]);
      }
    };
    SourceNode.prototype.toString = function SourceNode_toString() {
      var str = "";
      this.walk(function(chunk) {
        str += chunk;
      });
      return str;
    };
    SourceNode.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
      var generated = {
        code: "",
        line: 1,
        column: 0
      };
      var map = new SourceMapGenerator(aArgs);
      var sourceMappingActive = false;
      var lastOriginalSource = null;
      var lastOriginalLine = null;
      var lastOriginalColumn = null;
      var lastOriginalName = null;
      this.walk(function(chunk, original) {
        generated.code += chunk;
        if (original.source !== null && original.line !== null && original.column !== null) {
          if (lastOriginalSource !== original.source || lastOriginalLine !== original.line || lastOriginalColumn !== original.column || lastOriginalName !== original.name) {
            map.addMapping({
              source: original.source,
              original: {
                line: original.line,
                column: original.column
              },
              generated: {
                line: generated.line,
                column: generated.column
              },
              name: original.name
            });
          }
          lastOriginalSource = original.source;
          lastOriginalLine = original.line;
          lastOriginalColumn = original.column;
          lastOriginalName = original.name;
          sourceMappingActive = true;
        } else if (sourceMappingActive) {
          map.addMapping({
            generated: {
              line: generated.line,
              column: generated.column
            }
          });
          lastOriginalSource = null;
          sourceMappingActive = false;
        }
        for (var idx = 0, length = chunk.length; idx < length; idx++) {
          if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
            generated.line++;
            generated.column = 0;
            if (idx + 1 === length) {
              lastOriginalSource = null;
              sourceMappingActive = false;
            } else if (sourceMappingActive) {
              map.addMapping({
                source: original.source,
                original: {
                  line: original.line,
                  column: original.column
                },
                generated: {
                  line: generated.line,
                  column: generated.column
                },
                name: original.name
              });
            }
          } else {
            generated.column++;
          }
        }
      });
      this.walkSourceContents(function(sourceFile, sourceContent) {
        map.setSourceContent(sourceFile, sourceContent);
      });
      return { code: generated.code, map };
    };
    exports2.SourceNode = SourceNode;
  }
});

// node_modules/source-map-js/source-map.js
var require_source_map = __commonJS({
  "node_modules/source-map-js/source-map.js"(exports2) {
    exports2.SourceMapGenerator = require_source_map_generator().SourceMapGenerator;
    exports2.SourceMapConsumer = require_source_map_consumer().SourceMapConsumer;
    exports2.SourceNode = require_source_node().SourceNode;
  }
});

// node_modules/nanoid/non-secure/index.cjs
var require_non_secure = __commonJS({
  "node_modules/nanoid/non-secure/index.cjs"(exports2, module2) {
    var urlAlphabet = "useandom-26T198340PX75pxJACKVERYMINDBUSHWOLF_GQZbfghjklqvwyzrict";
    var customAlphabet = (alphabet, defaultSize = 21) => {
      return (size = defaultSize) => {
        let id = "";
        let i = size;
        while (i--) {
          id += alphabet[Math.random() * alphabet.length | 0];
        }
        return id;
      };
    };
    var nanoid = (size = 21) => {
      let id = "";
      let i = size;
      while (i--) {
        id += urlAlphabet[Math.random() * 64 | 0];
      }
      return id;
    };
    module2.exports = { nanoid, customAlphabet };
  }
});

// node_modules/postcss/lib/previous-map.js
var require_previous_map = __commonJS({
  "node_modules/postcss/lib/previous-map.js"(exports2, module2) {
    "use strict";
    var { SourceMapConsumer, SourceMapGenerator } = require_source_map();
    var { existsSync, readFileSync } = require("fs");
    var { dirname, join } = require("path");
    function fromBase64(str) {
      if (Buffer) {
        return Buffer.from(str, "base64").toString();
      } else {
        return window.atob(str);
      }
    }
    var PreviousMap = class {
      constructor(css, opts) {
        if (opts.map === false)
          return;
        this.loadAnnotation(css);
        this.inline = this.startWith(this.annotation, "data:");
        let prev = opts.map ? opts.map.prev : void 0;
        let text = this.loadMap(opts.from, prev);
        if (!this.mapFile && opts.from) {
          this.mapFile = opts.from;
        }
        if (this.mapFile)
          this.root = dirname(this.mapFile);
        if (text)
          this.text = text;
      }
      consumer() {
        if (!this.consumerCache) {
          this.consumerCache = new SourceMapConsumer(this.text);
        }
        return this.consumerCache;
      }
      decodeInline(text) {
        let baseCharsetUri = /^data:application\/json;charset=utf-?8;base64,/;
        let baseUri = /^data:application\/json;base64,/;
        let charsetUri = /^data:application\/json;charset=utf-?8,/;
        let uri = /^data:application\/json,/;
        if (charsetUri.test(text) || uri.test(text)) {
          return decodeURIComponent(text.substr(RegExp.lastMatch.length));
        }
        if (baseCharsetUri.test(text) || baseUri.test(text)) {
          return fromBase64(text.substr(RegExp.lastMatch.length));
        }
        let encoding = text.match(/data:application\/json;([^,]+),/)[1];
        throw new Error("Unsupported source map encoding " + encoding);
      }
      getAnnotationURL(sourceMapString) {
        return sourceMapString.replace(/^\/\*\s*# sourceMappingURL=/, "").trim();
      }
      isMap(map) {
        if (typeof map !== "object")
          return false;
        return typeof map.mappings === "string" || typeof map._mappings === "string" || Array.isArray(map.sections);
      }
      loadAnnotation(css) {
        let comments = css.match(/\/\*\s*# sourceMappingURL=/gm);
        if (!comments)
          return;
        let start = css.lastIndexOf(comments.pop());
        let end = css.indexOf("*/", start);
        if (start > -1 && end > -1) {
          this.annotation = this.getAnnotationURL(css.substring(start, end));
        }
      }
      loadFile(path) {
        this.root = dirname(path);
        if (existsSync(path)) {
          this.mapFile = path;
          return readFileSync(path, "utf-8").toString().trim();
        }
      }
      loadMap(file, prev) {
        if (prev === false)
          return false;
        if (prev) {
          if (typeof prev === "string") {
            return prev;
          } else if (typeof prev === "function") {
            let prevPath = prev(file);
            if (prevPath) {
              let map = this.loadFile(prevPath);
              if (!map) {
                throw new Error(
                  "Unable to load previous source map: " + prevPath.toString()
                );
              }
              return map;
            }
          } else if (prev instanceof SourceMapConsumer) {
            return SourceMapGenerator.fromSourceMap(prev).toString();
          } else if (prev instanceof SourceMapGenerator) {
            return prev.toString();
          } else if (this.isMap(prev)) {
            return JSON.stringify(prev);
          } else {
            throw new Error(
              "Unsupported previous source map format: " + prev.toString()
            );
          }
        } else if (this.inline) {
          return this.decodeInline(this.annotation);
        } else if (this.annotation) {
          let map = this.annotation;
          if (file)
            map = join(dirname(file), map);
          return this.loadFile(map);
        }
      }
      startWith(string, start) {
        if (!string)
          return false;
        return string.substr(0, start.length) === start;
      }
      withContent() {
        return !!(this.consumer().sourcesContent && this.consumer().sourcesContent.length > 0);
      }
    };
    module2.exports = PreviousMap;
    PreviousMap.default = PreviousMap;
  }
});

// node_modules/postcss/lib/input.js
var require_input = __commonJS({
  "node_modules/postcss/lib/input.js"(exports2, module2) {
    "use strict";
    var { SourceMapConsumer, SourceMapGenerator } = require_source_map();
    var { fileURLToPath, pathToFileURL } = require("url");
    var { isAbsolute, resolve } = require("path");
    var { nanoid } = require_non_secure();
    var terminalHighlight = require_terminal_highlight();
    var CssSyntaxError = require_css_syntax_error();
    var PreviousMap = require_previous_map();
    var fromOffsetCache = Symbol("fromOffsetCache");
    var sourceMapAvailable = Boolean(SourceMapConsumer && SourceMapGenerator);
    var pathAvailable = Boolean(resolve && isAbsolute);
    var Input = class {
      constructor(css, opts = {}) {
        if (css === null || typeof css === "undefined" || typeof css === "object" && !css.toString) {
          throw new Error(`PostCSS received ${css} instead of CSS string`);
        }
        this.css = css.toString();
        if (this.css[0] === "\uFEFF" || this.css[0] === "\uFFFE") {
          this.hasBOM = true;
          this.css = this.css.slice(1);
        } else {
          this.hasBOM = false;
        }
        if (opts.from) {
          if (!pathAvailable || /^\w+:\/\//.test(opts.from) || isAbsolute(opts.from)) {
            this.file = opts.from;
          } else {
            this.file = resolve(opts.from);
          }
        }
        if (pathAvailable && sourceMapAvailable) {
          let map = new PreviousMap(this.css, opts);
          if (map.text) {
            this.map = map;
            let file = map.consumer().file;
            if (!this.file && file)
              this.file = this.mapResolve(file);
          }
        }
        if (!this.file) {
          this.id = "<input css " + nanoid(6) + ">";
        }
        if (this.map)
          this.map.file = this.from;
      }
      error(message, line, column, opts = {}) {
        let result, endLine, endColumn;
        if (line && typeof line === "object") {
          let start = line;
          let end = column;
          if (typeof start.offset === "number") {
            let pos = this.fromOffset(start.offset);
            line = pos.line;
            column = pos.col;
          } else {
            line = start.line;
            column = start.column;
          }
          if (typeof end.offset === "number") {
            let pos = this.fromOffset(end.offset);
            endLine = pos.line;
            endColumn = pos.col;
          } else {
            endLine = end.line;
            endColumn = end.column;
          }
        } else if (!column) {
          let pos = this.fromOffset(line);
          line = pos.line;
          column = pos.col;
        }
        let origin = this.origin(line, column, endLine, endColumn);
        if (origin) {
          result = new CssSyntaxError(
            message,
            origin.endLine === void 0 ? origin.line : { column: origin.column, line: origin.line },
            origin.endLine === void 0 ? origin.column : { column: origin.endColumn, line: origin.endLine },
            origin.source,
            origin.file,
            opts.plugin
          );
        } else {
          result = new CssSyntaxError(
            message,
            endLine === void 0 ? line : { column, line },
            endLine === void 0 ? column : { column: endColumn, line: endLine },
            this.css,
            this.file,
            opts.plugin
          );
        }
        result.input = { column, endColumn, endLine, line, source: this.css };
        if (this.file) {
          if (pathToFileURL) {
            result.input.url = pathToFileURL(this.file).toString();
          }
          result.input.file = this.file;
        }
        return result;
      }
      fromOffset(offset) {
        let lastLine, lineToIndex;
        if (!this[fromOffsetCache]) {
          let lines = this.css.split("\n");
          lineToIndex = new Array(lines.length);
          let prevIndex = 0;
          for (let i = 0, l = lines.length; i < l; i++) {
            lineToIndex[i] = prevIndex;
            prevIndex += lines[i].length + 1;
          }
          this[fromOffsetCache] = lineToIndex;
        } else {
          lineToIndex = this[fromOffsetCache];
        }
        lastLine = lineToIndex[lineToIndex.length - 1];
        let min = 0;
        if (offset >= lastLine) {
          min = lineToIndex.length - 1;
        } else {
          let max = lineToIndex.length - 2;
          let mid;
          while (min < max) {
            mid = min + (max - min >> 1);
            if (offset < lineToIndex[mid]) {
              max = mid - 1;
            } else if (offset >= lineToIndex[mid + 1]) {
              min = mid + 1;
            } else {
              min = mid;
              break;
            }
          }
        }
        return {
          col: offset - lineToIndex[min] + 1,
          line: min + 1
        };
      }
      mapResolve(file) {
        if (/^\w+:\/\//.test(file)) {
          return file;
        }
        return resolve(this.map.consumer().sourceRoot || this.map.root || ".", file);
      }
      origin(line, column, endLine, endColumn) {
        if (!this.map)
          return false;
        let consumer = this.map.consumer();
        let from = consumer.originalPositionFor({ column, line });
        if (!from.source)
          return false;
        let to;
        if (typeof endLine === "number") {
          to = consumer.originalPositionFor({ column: endColumn, line: endLine });
        }
        let fromUrl;
        if (isAbsolute(from.source)) {
          fromUrl = pathToFileURL(from.source);
        } else {
          fromUrl = new URL(
            from.source,
            this.map.consumer().sourceRoot || pathToFileURL(this.map.mapFile)
          );
        }
        let result = {
          column: from.column,
          endColumn: to && to.column,
          endLine: to && to.line,
          line: from.line,
          url: fromUrl.toString()
        };
        if (fromUrl.protocol === "file:") {
          if (fileURLToPath) {
            result.file = fileURLToPath(fromUrl);
          } else {
            throw new Error(`file: protocol is not available in this PostCSS build`);
          }
        }
        let source = consumer.sourceContentFor(from.source);
        if (source)
          result.source = source;
        return result;
      }
      toJSON() {
        let json = {};
        for (let name of ["hasBOM", "css", "file", "id"]) {
          if (this[name] != null) {
            json[name] = this[name];
          }
        }
        if (this.map) {
          json.map = { ...this.map };
          if (json.map.consumerCache) {
            json.map.consumerCache = void 0;
          }
        }
        return json;
      }
      get from() {
        return this.file || this.id;
      }
    };
    module2.exports = Input;
    Input.default = Input;
    if (terminalHighlight && terminalHighlight.registerInput) {
      terminalHighlight.registerInput(Input);
    }
  }
});

// node_modules/postcss/lib/map-generator.js
var require_map_generator = __commonJS({
  "node_modules/postcss/lib/map-generator.js"(exports2, module2) {
    "use strict";
    var { SourceMapConsumer, SourceMapGenerator } = require_source_map();
    var { dirname, relative, resolve, sep } = require("path");
    var { pathToFileURL } = require("url");
    var Input = require_input();
    var sourceMapAvailable = Boolean(SourceMapConsumer && SourceMapGenerator);
    var pathAvailable = Boolean(dirname && resolve && relative && sep);
    var MapGenerator = class {
      constructor(stringify, root, opts, cssString) {
        this.stringify = stringify;
        this.mapOpts = opts.map || {};
        this.root = root;
        this.opts = opts;
        this.css = cssString;
        this.originalCSS = cssString;
        this.usesFileUrls = !this.mapOpts.from && this.mapOpts.absolute;
        this.memoizedFileURLs = /* @__PURE__ */ new Map();
        this.memoizedPaths = /* @__PURE__ */ new Map();
        this.memoizedURLs = /* @__PURE__ */ new Map();
      }
      addAnnotation() {
        let content;
        if (this.isInline()) {
          content = "data:application/json;base64," + this.toBase64(this.map.toString());
        } else if (typeof this.mapOpts.annotation === "string") {
          content = this.mapOpts.annotation;
        } else if (typeof this.mapOpts.annotation === "function") {
          content = this.mapOpts.annotation(this.opts.to, this.root);
        } else {
          content = this.outputFile() + ".map";
        }
        let eol = "\n";
        if (this.css.includes("\r\n"))
          eol = "\r\n";
        this.css += eol + "/*# sourceMappingURL=" + content + " */";
      }
      applyPrevMaps() {
        for (let prev of this.previous()) {
          let from = this.toUrl(this.path(prev.file));
          let root = prev.root || dirname(prev.file);
          let map;
          if (this.mapOpts.sourcesContent === false) {
            map = new SourceMapConsumer(prev.text);
            if (map.sourcesContent) {
              map.sourcesContent = null;
            }
          } else {
            map = prev.consumer();
          }
          this.map.applySourceMap(map, from, this.toUrl(this.path(root)));
        }
      }
      clearAnnotation() {
        if (this.mapOpts.annotation === false)
          return;
        if (this.root) {
          let node;
          for (let i = this.root.nodes.length - 1; i >= 0; i--) {
            node = this.root.nodes[i];
            if (node.type !== "comment")
              continue;
            if (node.text.indexOf("# sourceMappingURL=") === 0) {
              this.root.removeChild(i);
            }
          }
        } else if (this.css) {
          this.css = this.css.replace(/\n*?\/\*#[\S\s]*?\*\/$/gm, "");
        }
      }
      generate() {
        this.clearAnnotation();
        if (pathAvailable && sourceMapAvailable && this.isMap()) {
          return this.generateMap();
        } else {
          let result = "";
          this.stringify(this.root, (i) => {
            result += i;
          });
          return [result];
        }
      }
      generateMap() {
        if (this.root) {
          this.generateString();
        } else if (this.previous().length === 1) {
          let prev = this.previous()[0].consumer();
          prev.file = this.outputFile();
          this.map = SourceMapGenerator.fromSourceMap(prev, {
            ignoreInvalidMapping: true
          });
        } else {
          this.map = new SourceMapGenerator({
            file: this.outputFile(),
            ignoreInvalidMapping: true
          });
          this.map.addMapping({
            generated: { column: 0, line: 1 },
            original: { column: 0, line: 1 },
            source: this.opts.from ? this.toUrl(this.path(this.opts.from)) : "<no source>"
          });
        }
        if (this.isSourcesContent())
          this.setSourcesContent();
        if (this.root && this.previous().length > 0)
          this.applyPrevMaps();
        if (this.isAnnotation())
          this.addAnnotation();
        if (this.isInline()) {
          return [this.css];
        } else {
          return [this.css, this.map];
        }
      }
      generateString() {
        this.css = "";
        this.map = new SourceMapGenerator({
          file: this.outputFile(),
          ignoreInvalidMapping: true
        });
        let line = 1;
        let column = 1;
        let noSource = "<no source>";
        let mapping = {
          generated: { column: 0, line: 0 },
          original: { column: 0, line: 0 },
          source: ""
        };
        let lines, last;
        this.stringify(this.root, (str, node, type) => {
          this.css += str;
          if (node && type !== "end") {
            mapping.generated.line = line;
            mapping.generated.column = column - 1;
            if (node.source && node.source.start) {
              mapping.source = this.sourcePath(node);
              mapping.original.line = node.source.start.line;
              mapping.original.column = node.source.start.column - 1;
              this.map.addMapping(mapping);
            } else {
              mapping.source = noSource;
              mapping.original.line = 1;
              mapping.original.column = 0;
              this.map.addMapping(mapping);
            }
          }
          lines = str.match(/\n/g);
          if (lines) {
            line += lines.length;
            last = str.lastIndexOf("\n");
            column = str.length - last;
          } else {
            column += str.length;
          }
          if (node && type !== "start") {
            let p = node.parent || { raws: {} };
            let childless = node.type === "decl" || node.type === "atrule" && !node.nodes;
            if (!childless || node !== p.last || p.raws.semicolon) {
              if (node.source && node.source.end) {
                mapping.source = this.sourcePath(node);
                mapping.original.line = node.source.end.line;
                mapping.original.column = node.source.end.column - 1;
                mapping.generated.line = line;
                mapping.generated.column = column - 2;
                this.map.addMapping(mapping);
              } else {
                mapping.source = noSource;
                mapping.original.line = 1;
                mapping.original.column = 0;
                mapping.generated.line = line;
                mapping.generated.column = column - 1;
                this.map.addMapping(mapping);
              }
            }
          }
        });
      }
      isAnnotation() {
        if (this.isInline()) {
          return true;
        }
        if (typeof this.mapOpts.annotation !== "undefined") {
          return this.mapOpts.annotation;
        }
        if (this.previous().length) {
          return this.previous().some((i) => i.annotation);
        }
        return true;
      }
      isInline() {
        if (typeof this.mapOpts.inline !== "undefined") {
          return this.mapOpts.inline;
        }
        let annotation = this.mapOpts.annotation;
        if (typeof annotation !== "undefined" && annotation !== true) {
          return false;
        }
        if (this.previous().length) {
          return this.previous().some((i) => i.inline);
        }
        return true;
      }
      isMap() {
        if (typeof this.opts.map !== "undefined") {
          return !!this.opts.map;
        }
        return this.previous().length > 0;
      }
      isSourcesContent() {
        if (typeof this.mapOpts.sourcesContent !== "undefined") {
          return this.mapOpts.sourcesContent;
        }
        if (this.previous().length) {
          return this.previous().some((i) => i.withContent());
        }
        return true;
      }
      outputFile() {
        if (this.opts.to) {
          return this.path(this.opts.to);
        } else if (this.opts.from) {
          return this.path(this.opts.from);
        } else {
          return "to.css";
        }
      }
      path(file) {
        if (this.mapOpts.absolute)
          return file;
        if (file.charCodeAt(0) === 60)
          return file;
        if (/^\w+:\/\//.test(file))
          return file;
        let cached = this.memoizedPaths.get(file);
        if (cached)
          return cached;
        let from = this.opts.to ? dirname(this.opts.to) : ".";
        if (typeof this.mapOpts.annotation === "string") {
          from = dirname(resolve(from, this.mapOpts.annotation));
        }
        let path = relative(from, file);
        this.memoizedPaths.set(file, path);
        return path;
      }
      previous() {
        if (!this.previousMaps) {
          this.previousMaps = [];
          if (this.root) {
            this.root.walk((node) => {
              if (node.source && node.source.input.map) {
                let map = node.source.input.map;
                if (!this.previousMaps.includes(map)) {
                  this.previousMaps.push(map);
                }
              }
            });
          } else {
            let input = new Input(this.originalCSS, this.opts);
            if (input.map)
              this.previousMaps.push(input.map);
          }
        }
        return this.previousMaps;
      }
      setSourcesContent() {
        let already = {};
        if (this.root) {
          this.root.walk((node) => {
            if (node.source) {
              let from = node.source.input.from;
              if (from && !already[from]) {
                already[from] = true;
                let fromUrl = this.usesFileUrls ? this.toFileUrl(from) : this.toUrl(this.path(from));
                this.map.setSourceContent(fromUrl, node.source.input.css);
              }
            }
          });
        } else if (this.css) {
          let from = this.opts.from ? this.toUrl(this.path(this.opts.from)) : "<no source>";
          this.map.setSourceContent(from, this.css);
        }
      }
      sourcePath(node) {
        if (this.mapOpts.from) {
          return this.toUrl(this.mapOpts.from);
        } else if (this.usesFileUrls) {
          return this.toFileUrl(node.source.input.from);
        } else {
          return this.toUrl(this.path(node.source.input.from));
        }
      }
      toBase64(str) {
        if (Buffer) {
          return Buffer.from(str).toString("base64");
        } else {
          return window.btoa(unescape(encodeURIComponent(str)));
        }
      }
      toFileUrl(path) {
        let cached = this.memoizedFileURLs.get(path);
        if (cached)
          return cached;
        if (pathToFileURL) {
          let fileURL = pathToFileURL(path).toString();
          this.memoizedFileURLs.set(path, fileURL);
          return fileURL;
        } else {
          throw new Error(
            "`map.absolute` option is not available in this PostCSS build"
          );
        }
      }
      toUrl(path) {
        let cached = this.memoizedURLs.get(path);
        if (cached)
          return cached;
        if (sep === "\\") {
          path = path.replace(/\\/g, "/");
        }
        let url = encodeURI(path).replace(/[#?]/g, encodeURIComponent);
        this.memoizedURLs.set(path, url);
        return url;
      }
    };
    module2.exports = MapGenerator;
  }
});

// node_modules/postcss/lib/comment.js
var require_comment = __commonJS({
  "node_modules/postcss/lib/comment.js"(exports2, module2) {
    "use strict";
    var Node = require_node();
    var Comment = class extends Node {
      constructor(defaults) {
        super(defaults);
        this.type = "comment";
      }
    };
    module2.exports = Comment;
    Comment.default = Comment;
  }
});

// node_modules/postcss/lib/container.js
var require_container = __commonJS({
  "node_modules/postcss/lib/container.js"(exports2, module2) {
    "use strict";
    var { isClean, my } = require_symbols();
    var Declaration = require_declaration();
    var Comment = require_comment();
    var Node = require_node();
    var parse;
    var Rule;
    var AtRule;
    var Root;
    function cleanSource(nodes) {
      return nodes.map((i) => {
        if (i.nodes)
          i.nodes = cleanSource(i.nodes);
        delete i.source;
        return i;
      });
    }
    function markDirtyUp(node) {
      node[isClean] = false;
      if (node.proxyOf.nodes) {
        for (let i of node.proxyOf.nodes) {
          markDirtyUp(i);
        }
      }
    }
    var Container = class _Container extends Node {
      append(...children) {
        for (let child of children) {
          let nodes = this.normalize(child, this.last);
          for (let node of nodes)
            this.proxyOf.nodes.push(node);
        }
        this.markDirty();
        return this;
      }
      cleanRaws(keepBetween) {
        super.cleanRaws(keepBetween);
        if (this.nodes) {
          for (let node of this.nodes)
            node.cleanRaws(keepBetween);
        }
      }
      each(callback) {
        if (!this.proxyOf.nodes)
          return void 0;
        let iterator = this.getIterator();
        let index, result;
        while (this.indexes[iterator] < this.proxyOf.nodes.length) {
          index = this.indexes[iterator];
          result = callback(this.proxyOf.nodes[index], index);
          if (result === false)
            break;
          this.indexes[iterator] += 1;
        }
        delete this.indexes[iterator];
        return result;
      }
      every(condition) {
        return this.nodes.every(condition);
      }
      getIterator() {
        if (!this.lastEach)
          this.lastEach = 0;
        if (!this.indexes)
          this.indexes = {};
        this.lastEach += 1;
        let iterator = this.lastEach;
        this.indexes[iterator] = 0;
        return iterator;
      }
      getProxyProcessor() {
        return {
          get(node, prop) {
            if (prop === "proxyOf") {
              return node;
            } else if (!node[prop]) {
              return node[prop];
            } else if (prop === "each" || typeof prop === "string" && prop.startsWith("walk")) {
              return (...args) => {
                return node[prop](
                  ...args.map((i) => {
                    if (typeof i === "function") {
                      return (child, index) => i(child.toProxy(), index);
                    } else {
                      return i;
                    }
                  })
                );
              };
            } else if (prop === "every" || prop === "some") {
              return (cb) => {
                return node[prop](
                  (child, ...other) => cb(child.toProxy(), ...other)
                );
              };
            } else if (prop === "root") {
              return () => node.root().toProxy();
            } else if (prop === "nodes") {
              return node.nodes.map((i) => i.toProxy());
            } else if (prop === "first" || prop === "last") {
              return node[prop].toProxy();
            } else {
              return node[prop];
            }
          },
          set(node, prop, value) {
            if (node[prop] === value)
              return true;
            node[prop] = value;
            if (prop === "name" || prop === "params" || prop === "selector") {
              node.markDirty();
            }
            return true;
          }
        };
      }
      index(child) {
        if (typeof child === "number")
          return child;
        if (child.proxyOf)
          child = child.proxyOf;
        return this.proxyOf.nodes.indexOf(child);
      }
      insertAfter(exist, add) {
        let existIndex = this.index(exist);
        let nodes = this.normalize(add, this.proxyOf.nodes[existIndex]).reverse();
        existIndex = this.index(exist);
        for (let node of nodes)
          this.proxyOf.nodes.splice(existIndex + 1, 0, node);
        let index;
        for (let id in this.indexes) {
          index = this.indexes[id];
          if (existIndex < index) {
            this.indexes[id] = index + nodes.length;
          }
        }
        this.markDirty();
        return this;
      }
      insertBefore(exist, add) {
        let existIndex = this.index(exist);
        let type = existIndex === 0 ? "prepend" : false;
        let nodes = this.normalize(add, this.proxyOf.nodes[existIndex], type).reverse();
        existIndex = this.index(exist);
        for (let node of nodes)
          this.proxyOf.nodes.splice(existIndex, 0, node);
        let index;
        for (let id in this.indexes) {
          index = this.indexes[id];
          if (existIndex <= index) {
            this.indexes[id] = index + nodes.length;
          }
        }
        this.markDirty();
        return this;
      }
      normalize(nodes, sample) {
        if (typeof nodes === "string") {
          nodes = cleanSource(parse(nodes).nodes);
        } else if (typeof nodes === "undefined") {
          nodes = [];
        } else if (Array.isArray(nodes)) {
          nodes = nodes.slice(0);
          for (let i of nodes) {
            if (i.parent)
              i.parent.removeChild(i, "ignore");
          }
        } else if (nodes.type === "root" && this.type !== "document") {
          nodes = nodes.nodes.slice(0);
          for (let i of nodes) {
            if (i.parent)
              i.parent.removeChild(i, "ignore");
          }
        } else if (nodes.type) {
          nodes = [nodes];
        } else if (nodes.prop) {
          if (typeof nodes.value === "undefined") {
            throw new Error("Value field is missed in node creation");
          } else if (typeof nodes.value !== "string") {
            nodes.value = String(nodes.value);
          }
          nodes = [new Declaration(nodes)];
        } else if (nodes.selector) {
          nodes = [new Rule(nodes)];
        } else if (nodes.name) {
          nodes = [new AtRule(nodes)];
        } else if (nodes.text) {
          nodes = [new Comment(nodes)];
        } else {
          throw new Error("Unknown node type in node creation");
        }
        let processed = nodes.map((i) => {
          if (!i[my])
            _Container.rebuild(i);
          i = i.proxyOf;
          if (i.parent)
            i.parent.removeChild(i);
          if (i[isClean])
            markDirtyUp(i);
          if (typeof i.raws.before === "undefined") {
            if (sample && typeof sample.raws.before !== "undefined") {
              i.raws.before = sample.raws.before.replace(/\S/g, "");
            }
          }
          i.parent = this.proxyOf;
          return i;
        });
        return processed;
      }
      prepend(...children) {
        children = children.reverse();
        for (let child of children) {
          let nodes = this.normalize(child, this.first, "prepend").reverse();
          for (let node of nodes)
            this.proxyOf.nodes.unshift(node);
          for (let id in this.indexes) {
            this.indexes[id] = this.indexes[id] + nodes.length;
          }
        }
        this.markDirty();
        return this;
      }
      push(child) {
        child.parent = this;
        this.proxyOf.nodes.push(child);
        return this;
      }
      removeAll() {
        for (let node of this.proxyOf.nodes)
          node.parent = void 0;
        this.proxyOf.nodes = [];
        this.markDirty();
        return this;
      }
      removeChild(child) {
        child = this.index(child);
        this.proxyOf.nodes[child].parent = void 0;
        this.proxyOf.nodes.splice(child, 1);
        let index;
        for (let id in this.indexes) {
          index = this.indexes[id];
          if (index >= child) {
            this.indexes[id] = index - 1;
          }
        }
        this.markDirty();
        return this;
      }
      replaceValues(pattern, opts, callback) {
        if (!callback) {
          callback = opts;
          opts = {};
        }
        this.walkDecls((decl) => {
          if (opts.props && !opts.props.includes(decl.prop))
            return;
          if (opts.fast && !decl.value.includes(opts.fast))
            return;
          decl.value = decl.value.replace(pattern, callback);
        });
        this.markDirty();
        return this;
      }
      some(condition) {
        return this.nodes.some(condition);
      }
      walk(callback) {
        return this.each((child, i) => {
          let result;
          try {
            result = callback(child, i);
          } catch (e) {
            throw child.addToError(e);
          }
          if (result !== false && child.walk) {
            result = child.walk(callback);
          }
          return result;
        });
      }
      walkAtRules(name, callback) {
        if (!callback) {
          callback = name;
          return this.walk((child, i) => {
            if (child.type === "atrule") {
              return callback(child, i);
            }
          });
        }
        if (name instanceof RegExp) {
          return this.walk((child, i) => {
            if (child.type === "atrule" && name.test(child.name)) {
              return callback(child, i);
            }
          });
        }
        return this.walk((child, i) => {
          if (child.type === "atrule" && child.name === name) {
            return callback(child, i);
          }
        });
      }
      walkComments(callback) {
        return this.walk((child, i) => {
          if (child.type === "comment") {
            return callback(child, i);
          }
        });
      }
      walkDecls(prop, callback) {
        if (!callback) {
          callback = prop;
          return this.walk((child, i) => {
            if (child.type === "decl") {
              return callback(child, i);
            }
          });
        }
        if (prop instanceof RegExp) {
          return this.walk((child, i) => {
            if (child.type === "decl" && prop.test(child.prop)) {
              return callback(child, i);
            }
          });
        }
        return this.walk((child, i) => {
          if (child.type === "decl" && child.prop === prop) {
            return callback(child, i);
          }
        });
      }
      walkRules(selector, callback) {
        if (!callback) {
          callback = selector;
          return this.walk((child, i) => {
            if (child.type === "rule") {
              return callback(child, i);
            }
          });
        }
        if (selector instanceof RegExp) {
          return this.walk((child, i) => {
            if (child.type === "rule" && selector.test(child.selector)) {
              return callback(child, i);
            }
          });
        }
        return this.walk((child, i) => {
          if (child.type === "rule" && child.selector === selector) {
            return callback(child, i);
          }
        });
      }
      get first() {
        if (!this.proxyOf.nodes)
          return void 0;
        return this.proxyOf.nodes[0];
      }
      get last() {
        if (!this.proxyOf.nodes)
          return void 0;
        return this.proxyOf.nodes[this.proxyOf.nodes.length - 1];
      }
    };
    Container.registerParse = (dependant) => {
      parse = dependant;
    };
    Container.registerRule = (dependant) => {
      Rule = dependant;
    };
    Container.registerAtRule = (dependant) => {
      AtRule = dependant;
    };
    Container.registerRoot = (dependant) => {
      Root = dependant;
    };
    module2.exports = Container;
    Container.default = Container;
    Container.rebuild = (node) => {
      if (node.type === "atrule") {
        Object.setPrototypeOf(node, AtRule.prototype);
      } else if (node.type === "rule") {
        Object.setPrototypeOf(node, Rule.prototype);
      } else if (node.type === "decl") {
        Object.setPrototypeOf(node, Declaration.prototype);
      } else if (node.type === "comment") {
        Object.setPrototypeOf(node, Comment.prototype);
      } else if (node.type === "root") {
        Object.setPrototypeOf(node, Root.prototype);
      }
      node[my] = true;
      if (node.nodes) {
        node.nodes.forEach((child) => {
          Container.rebuild(child);
        });
      }
    };
  }
});

// node_modules/postcss/lib/document.js
var require_document = __commonJS({
  "node_modules/postcss/lib/document.js"(exports2, module2) {
    "use strict";
    var Container = require_container();
    var LazyResult;
    var Processor;
    var Document = class extends Container {
      constructor(defaults) {
        super({ type: "document", ...defaults });
        if (!this.nodes) {
          this.nodes = [];
        }
      }
      toResult(opts = {}) {
        let lazy = new LazyResult(new Processor(), this, opts);
        return lazy.stringify();
      }
    };
    Document.registerLazyResult = (dependant) => {
      LazyResult = dependant;
    };
    Document.registerProcessor = (dependant) => {
      Processor = dependant;
    };
    module2.exports = Document;
    Document.default = Document;
  }
});

// node_modules/postcss/lib/warn-once.js
var require_warn_once = __commonJS({
  "node_modules/postcss/lib/warn-once.js"(exports2, module2) {
    "use strict";
    var printed = {};
    module2.exports = function warnOnce(message) {
      if (printed[message])
        return;
      printed[message] = true;
      if (typeof console !== "undefined" && console.warn) {
        console.warn(message);
      }
    };
  }
});

// node_modules/postcss/lib/warning.js
var require_warning = __commonJS({
  "node_modules/postcss/lib/warning.js"(exports2, module2) {
    "use strict";
    var Warning = class {
      constructor(text, opts = {}) {
        this.type = "warning";
        this.text = text;
        if (opts.node && opts.node.source) {
          let range = opts.node.rangeBy(opts);
          this.line = range.start.line;
          this.column = range.start.column;
          this.endLine = range.end.line;
          this.endColumn = range.end.column;
        }
        for (let opt in opts)
          this[opt] = opts[opt];
      }
      toString() {
        if (this.node) {
          return this.node.error(this.text, {
            index: this.index,
            plugin: this.plugin,
            word: this.word
          }).message;
        }
        if (this.plugin) {
          return this.plugin + ": " + this.text;
        }
        return this.text;
      }
    };
    module2.exports = Warning;
    Warning.default = Warning;
  }
});

// node_modules/postcss/lib/result.js
var require_result = __commonJS({
  "node_modules/postcss/lib/result.js"(exports2, module2) {
    "use strict";
    var Warning = require_warning();
    var Result = class {
      constructor(processor, root, opts) {
        this.processor = processor;
        this.messages = [];
        this.root = root;
        this.opts = opts;
        this.css = void 0;
        this.map = void 0;
      }
      toString() {
        return this.css;
      }
      warn(text, opts = {}) {
        if (!opts.plugin) {
          if (this.lastPlugin && this.lastPlugin.postcssPlugin) {
            opts.plugin = this.lastPlugin.postcssPlugin;
          }
        }
        let warning = new Warning(text, opts);
        this.messages.push(warning);
        return warning;
      }
      warnings() {
        return this.messages.filter((i) => i.type === "warning");
      }
      get content() {
        return this.css;
      }
    };
    module2.exports = Result;
    Result.default = Result;
  }
});

// node_modules/postcss/lib/at-rule.js
var require_at_rule = __commonJS({
  "node_modules/postcss/lib/at-rule.js"(exports2, module2) {
    "use strict";
    var Container = require_container();
    var AtRule = class extends Container {
      constructor(defaults) {
        super(defaults);
        this.type = "atrule";
      }
      append(...children) {
        if (!this.proxyOf.nodes)
          this.nodes = [];
        return super.append(...children);
      }
      prepend(...children) {
        if (!this.proxyOf.nodes)
          this.nodes = [];
        return super.prepend(...children);
      }
    };
    module2.exports = AtRule;
    AtRule.default = AtRule;
    Container.registerAtRule(AtRule);
  }
});

// node_modules/postcss/lib/root.js
var require_root = __commonJS({
  "node_modules/postcss/lib/root.js"(exports2, module2) {
    "use strict";
    var Container = require_container();
    var LazyResult;
    var Processor;
    var Root = class extends Container {
      constructor(defaults) {
        super(defaults);
        this.type = "root";
        if (!this.nodes)
          this.nodes = [];
      }
      normalize(child, sample, type) {
        let nodes = super.normalize(child);
        if (sample) {
          if (type === "prepend") {
            if (this.nodes.length > 1) {
              sample.raws.before = this.nodes[1].raws.before;
            } else {
              delete sample.raws.before;
            }
          } else if (this.first !== sample) {
            for (let node of nodes) {
              node.raws.before = sample.raws.before;
            }
          }
        }
        return nodes;
      }
      removeChild(child, ignore) {
        let index = this.index(child);
        if (!ignore && index === 0 && this.nodes.length > 1) {
          this.nodes[1].raws.before = this.nodes[index].raws.before;
        }
        return super.removeChild(child);
      }
      toResult(opts = {}) {
        let lazy = new LazyResult(new Processor(), this, opts);
        return lazy.stringify();
      }
    };
    Root.registerLazyResult = (dependant) => {
      LazyResult = dependant;
    };
    Root.registerProcessor = (dependant) => {
      Processor = dependant;
    };
    module2.exports = Root;
    Root.default = Root;
    Container.registerRoot(Root);
  }
});

// node_modules/postcss/lib/list.js
var require_list = __commonJS({
  "node_modules/postcss/lib/list.js"(exports2, module2) {
    "use strict";
    var list = {
      comma(string) {
        return list.split(string, [","], true);
      },
      space(string) {
        let spaces = [" ", "\n", "	"];
        return list.split(string, spaces);
      },
      split(string, separators, last) {
        let array = [];
        let current = "";
        let split = false;
        let func = 0;
        let inQuote = false;
        let prevQuote = "";
        let escape = false;
        for (let letter of string) {
          if (escape) {
            escape = false;
          } else if (letter === "\\") {
            escape = true;
          } else if (inQuote) {
            if (letter === prevQuote) {
              inQuote = false;
            }
          } else if (letter === '"' || letter === "'") {
            inQuote = true;
            prevQuote = letter;
          } else if (letter === "(") {
            func += 1;
          } else if (letter === ")") {
            if (func > 0)
              func -= 1;
          } else if (func === 0) {
            if (separators.includes(letter))
              split = true;
          }
          if (split) {
            if (current !== "")
              array.push(current.trim());
            current = "";
            split = false;
          } else {
            current += letter;
          }
        }
        if (last || current !== "")
          array.push(current.trim());
        return array;
      }
    };
    module2.exports = list;
    list.default = list;
  }
});

// node_modules/postcss/lib/rule.js
var require_rule = __commonJS({
  "node_modules/postcss/lib/rule.js"(exports2, module2) {
    "use strict";
    var Container = require_container();
    var list = require_list();
    var Rule = class extends Container {
      constructor(defaults) {
        super(defaults);
        this.type = "rule";
        if (!this.nodes)
          this.nodes = [];
      }
      get selectors() {
        return list.comma(this.selector);
      }
      set selectors(values) {
        let match = this.selector ? this.selector.match(/,\s*/) : null;
        let sep = match ? match[0] : "," + this.raw("between", "beforeOpen");
        this.selector = values.join(sep);
      }
    };
    module2.exports = Rule;
    Rule.default = Rule;
    Container.registerRule(Rule);
  }
});

// node_modules/postcss/lib/parser.js
var require_parser = __commonJS({
  "node_modules/postcss/lib/parser.js"(exports2, module2) {
    "use strict";
    var Declaration = require_declaration();
    var tokenizer = require_tokenize();
    var Comment = require_comment();
    var AtRule = require_at_rule();
    var Root = require_root();
    var Rule = require_rule();
    var SAFE_COMMENT_NEIGHBOR = {
      empty: true,
      space: true
    };
    function findLastWithPosition(tokens) {
      for (let i = tokens.length - 1; i >= 0; i--) {
        let token = tokens[i];
        let pos = token[3] || token[2];
        if (pos)
          return pos;
      }
    }
    var Parser = class {
      constructor(input) {
        this.input = input;
        this.root = new Root();
        this.current = this.root;
        this.spaces = "";
        this.semicolon = false;
        this.createTokenizer();
        this.root.source = { input, start: { column: 1, line: 1, offset: 0 } };
      }
      atrule(token) {
        let node = new AtRule();
        node.name = token[1].slice(1);
        if (node.name === "") {
          this.unnamedAtrule(node, token);
        }
        this.init(node, token[2]);
        let type;
        let prev;
        let shift;
        let last = false;
        let open = false;
        let params = [];
        let brackets = [];
        while (!this.tokenizer.endOfFile()) {
          token = this.tokenizer.nextToken();
          type = token[0];
          if (type === "(" || type === "[") {
            brackets.push(type === "(" ? ")" : "]");
          } else if (type === "{" && brackets.length > 0) {
            brackets.push("}");
          } else if (type === brackets[brackets.length - 1]) {
            brackets.pop();
          }
          if (brackets.length === 0) {
            if (type === ";") {
              node.source.end = this.getPosition(token[2]);
              node.source.end.offset++;
              this.semicolon = true;
              break;
            } else if (type === "{") {
              open = true;
              break;
            } else if (type === "}") {
              if (params.length > 0) {
                shift = params.length - 1;
                prev = params[shift];
                while (prev && prev[0] === "space") {
                  prev = params[--shift];
                }
                if (prev) {
                  node.source.end = this.getPosition(prev[3] || prev[2]);
                  node.source.end.offset++;
                }
              }
              this.end(token);
              break;
            } else {
              params.push(token);
            }
          } else {
            params.push(token);
          }
          if (this.tokenizer.endOfFile()) {
            last = true;
            break;
          }
        }
        node.raws.between = this.spacesAndCommentsFromEnd(params);
        if (params.length) {
          node.raws.afterName = this.spacesAndCommentsFromStart(params);
          this.raw(node, "params", params);
          if (last) {
            token = params[params.length - 1];
            node.source.end = this.getPosition(token[3] || token[2]);
            node.source.end.offset++;
            this.spaces = node.raws.between;
            node.raws.between = "";
          }
        } else {
          node.raws.afterName = "";
          node.params = "";
        }
        if (open) {
          node.nodes = [];
          this.current = node;
        }
      }
      checkMissedSemicolon(tokens) {
        let colon = this.colon(tokens);
        if (colon === false)
          return;
        let founded = 0;
        let token;
        for (let j = colon - 1; j >= 0; j--) {
          token = tokens[j];
          if (token[0] !== "space") {
            founded += 1;
            if (founded === 2)
              break;
          }
        }
        throw this.input.error(
          "Missed semicolon",
          token[0] === "word" ? token[3] + 1 : token[2]
        );
      }
      colon(tokens) {
        let brackets = 0;
        let token, type, prev;
        for (let [i, element] of tokens.entries()) {
          token = element;
          type = token[0];
          if (type === "(") {
            brackets += 1;
          }
          if (type === ")") {
            brackets -= 1;
          }
          if (brackets === 0 && type === ":") {
            if (!prev) {
              this.doubleColon(token);
            } else if (prev[0] === "word" && prev[1] === "progid") {
              continue;
            } else {
              return i;
            }
          }
          prev = token;
        }
        return false;
      }
      comment(token) {
        let node = new Comment();
        this.init(node, token[2]);
        node.source.end = this.getPosition(token[3] || token[2]);
        node.source.end.offset++;
        let text = token[1].slice(2, -2);
        if (/^\s*$/.test(text)) {
          node.text = "";
          node.raws.left = text;
          node.raws.right = "";
        } else {
          let match = text.match(/^(\s*)([^]*\S)(\s*)$/);
          node.text = match[2];
          node.raws.left = match[1];
          node.raws.right = match[3];
        }
      }
      createTokenizer() {
        this.tokenizer = tokenizer(this.input);
      }
      decl(tokens, customProperty) {
        let node = new Declaration();
        this.init(node, tokens[0][2]);
        let last = tokens[tokens.length - 1];
        if (last[0] === ";") {
          this.semicolon = true;
          tokens.pop();
        }
        node.source.end = this.getPosition(
          last[3] || last[2] || findLastWithPosition(tokens)
        );
        node.source.end.offset++;
        while (tokens[0][0] !== "word") {
          if (tokens.length === 1)
            this.unknownWord(tokens);
          node.raws.before += tokens.shift()[1];
        }
        node.source.start = this.getPosition(tokens[0][2]);
        node.prop = "";
        while (tokens.length) {
          let type = tokens[0][0];
          if (type === ":" || type === "space" || type === "comment") {
            break;
          }
          node.prop += tokens.shift()[1];
        }
        node.raws.between = "";
        let token;
        while (tokens.length) {
          token = tokens.shift();
          if (token[0] === ":") {
            node.raws.between += token[1];
            break;
          } else {
            if (token[0] === "word" && /\w/.test(token[1])) {
              this.unknownWord([token]);
            }
            node.raws.between += token[1];
          }
        }
        if (node.prop[0] === "_" || node.prop[0] === "*") {
          node.raws.before += node.prop[0];
          node.prop = node.prop.slice(1);
        }
        let firstSpaces = [];
        let next;
        while (tokens.length) {
          next = tokens[0][0];
          if (next !== "space" && next !== "comment")
            break;
          firstSpaces.push(tokens.shift());
        }
        this.precheckMissedSemicolon(tokens);
        for (let i = tokens.length - 1; i >= 0; i--) {
          token = tokens[i];
          if (token[1].toLowerCase() === "!important") {
            node.important = true;
            let string = this.stringFrom(tokens, i);
            string = this.spacesFromEnd(tokens) + string;
            if (string !== " !important")
              node.raws.important = string;
            break;
          } else if (token[1].toLowerCase() === "important") {
            let cache = tokens.slice(0);
            let str = "";
            for (let j = i; j > 0; j--) {
              let type = cache[j][0];
              if (str.trim().indexOf("!") === 0 && type !== "space") {
                break;
              }
              str = cache.pop()[1] + str;
            }
            if (str.trim().indexOf("!") === 0) {
              node.important = true;
              node.raws.important = str;
              tokens = cache;
            }
          }
          if (token[0] !== "space" && token[0] !== "comment") {
            break;
          }
        }
        let hasWord = tokens.some((i) => i[0] !== "space" && i[0] !== "comment");
        if (hasWord) {
          node.raws.between += firstSpaces.map((i) => i[1]).join("");
          firstSpaces = [];
        }
        this.raw(node, "value", firstSpaces.concat(tokens), customProperty);
        if (node.value.includes(":") && !customProperty) {
          this.checkMissedSemicolon(tokens);
        }
      }
      doubleColon(token) {
        throw this.input.error(
          "Double colon",
          { offset: token[2] },
          { offset: token[2] + token[1].length }
        );
      }
      emptyRule(token) {
        let node = new Rule();
        this.init(node, token[2]);
        node.selector = "";
        node.raws.between = "";
        this.current = node;
      }
      end(token) {
        if (this.current.nodes && this.current.nodes.length) {
          this.current.raws.semicolon = this.semicolon;
        }
        this.semicolon = false;
        this.current.raws.after = (this.current.raws.after || "") + this.spaces;
        this.spaces = "";
        if (this.current.parent) {
          this.current.source.end = this.getPosition(token[2]);
          this.current.source.end.offset++;
          this.current = this.current.parent;
        } else {
          this.unexpectedClose(token);
        }
      }
      endFile() {
        if (this.current.parent)
          this.unclosedBlock();
        if (this.current.nodes && this.current.nodes.length) {
          this.current.raws.semicolon = this.semicolon;
        }
        this.current.raws.after = (this.current.raws.after || "") + this.spaces;
        this.root.source.end = this.getPosition(this.tokenizer.position());
      }
      freeSemicolon(token) {
        this.spaces += token[1];
        if (this.current.nodes) {
          let prev = this.current.nodes[this.current.nodes.length - 1];
          if (prev && prev.type === "rule" && !prev.raws.ownSemicolon) {
            prev.raws.ownSemicolon = this.spaces;
            this.spaces = "";
          }
        }
      }
      // Helpers
      getPosition(offset) {
        let pos = this.input.fromOffset(offset);
        return {
          column: pos.col,
          line: pos.line,
          offset
        };
      }
      init(node, offset) {
        this.current.push(node);
        node.source = {
          input: this.input,
          start: this.getPosition(offset)
        };
        node.raws.before = this.spaces;
        this.spaces = "";
        if (node.type !== "comment")
          this.semicolon = false;
      }
      other(start) {
        let end = false;
        let type = null;
        let colon = false;
        let bracket = null;
        let brackets = [];
        let customProperty = start[1].startsWith("--");
        let tokens = [];
        let token = start;
        while (token) {
          type = token[0];
          tokens.push(token);
          if (type === "(" || type === "[") {
            if (!bracket)
              bracket = token;
            brackets.push(type === "(" ? ")" : "]");
          } else if (customProperty && colon && type === "{") {
            if (!bracket)
              bracket = token;
            brackets.push("}");
          } else if (brackets.length === 0) {
            if (type === ";") {
              if (colon) {
                this.decl(tokens, customProperty);
                return;
              } else {
                break;
              }
            } else if (type === "{") {
              this.rule(tokens);
              return;
            } else if (type === "}") {
              this.tokenizer.back(tokens.pop());
              end = true;
              break;
            } else if (type === ":") {
              colon = true;
            }
          } else if (type === brackets[brackets.length - 1]) {
            brackets.pop();
            if (brackets.length === 0)
              bracket = null;
          }
          token = this.tokenizer.nextToken();
        }
        if (this.tokenizer.endOfFile())
          end = true;
        if (brackets.length > 0)
          this.unclosedBracket(bracket);
        if (end && colon) {
          if (!customProperty) {
            while (tokens.length) {
              token = tokens[tokens.length - 1][0];
              if (token !== "space" && token !== "comment")
                break;
              this.tokenizer.back(tokens.pop());
            }
          }
          this.decl(tokens, customProperty);
        } else {
          this.unknownWord(tokens);
        }
      }
      parse() {
        let token;
        while (!this.tokenizer.endOfFile()) {
          token = this.tokenizer.nextToken();
          switch (token[0]) {
            case "space":
              this.spaces += token[1];
              break;
            case ";":
              this.freeSemicolon(token);
              break;
            case "}":
              this.end(token);
              break;
            case "comment":
              this.comment(token);
              break;
            case "at-word":
              this.atrule(token);
              break;
            case "{":
              this.emptyRule(token);
              break;
            default:
              this.other(token);
              break;
          }
        }
        this.endFile();
      }
      precheckMissedSemicolon() {
      }
      raw(node, prop, tokens, customProperty) {
        let token, type;
        let length = tokens.length;
        let value = "";
        let clean = true;
        let next, prev;
        for (let i = 0; i < length; i += 1) {
          token = tokens[i];
          type = token[0];
          if (type === "space" && i === length - 1 && !customProperty) {
            clean = false;
          } else if (type === "comment") {
            prev = tokens[i - 1] ? tokens[i - 1][0] : "empty";
            next = tokens[i + 1] ? tokens[i + 1][0] : "empty";
            if (!SAFE_COMMENT_NEIGHBOR[prev] && !SAFE_COMMENT_NEIGHBOR[next]) {
              if (value.slice(-1) === ",") {
                clean = false;
              } else {
                value += token[1];
              }
            } else {
              clean = false;
            }
          } else {
            value += token[1];
          }
        }
        if (!clean) {
          let raw = tokens.reduce((all, i) => all + i[1], "");
          node.raws[prop] = { raw, value };
        }
        node[prop] = value;
      }
      rule(tokens) {
        tokens.pop();
        let node = new Rule();
        this.init(node, tokens[0][2]);
        node.raws.between = this.spacesAndCommentsFromEnd(tokens);
        this.raw(node, "selector", tokens);
        this.current = node;
      }
      spacesAndCommentsFromEnd(tokens) {
        let lastTokenType;
        let spaces = "";
        while (tokens.length) {
          lastTokenType = tokens[tokens.length - 1][0];
          if (lastTokenType !== "space" && lastTokenType !== "comment")
            break;
          spaces = tokens.pop()[1] + spaces;
        }
        return spaces;
      }
      // Errors
      spacesAndCommentsFromStart(tokens) {
        let next;
        let spaces = "";
        while (tokens.length) {
          next = tokens[0][0];
          if (next !== "space" && next !== "comment")
            break;
          spaces += tokens.shift()[1];
        }
        return spaces;
      }
      spacesFromEnd(tokens) {
        let lastTokenType;
        let spaces = "";
        while (tokens.length) {
          lastTokenType = tokens[tokens.length - 1][0];
          if (lastTokenType !== "space")
            break;
          spaces = tokens.pop()[1] + spaces;
        }
        return spaces;
      }
      stringFrom(tokens, from) {
        let result = "";
        for (let i = from; i < tokens.length; i++) {
          result += tokens[i][1];
        }
        tokens.splice(from, tokens.length - from);
        return result;
      }
      unclosedBlock() {
        let pos = this.current.source.start;
        throw this.input.error("Unclosed block", pos.line, pos.column);
      }
      unclosedBracket(bracket) {
        throw this.input.error(
          "Unclosed bracket",
          { offset: bracket[2] },
          { offset: bracket[2] + 1 }
        );
      }
      unexpectedClose(token) {
        throw this.input.error(
          "Unexpected }",
          { offset: token[2] },
          { offset: token[2] + 1 }
        );
      }
      unknownWord(tokens) {
        throw this.input.error(
          "Unknown word",
          { offset: tokens[0][2] },
          { offset: tokens[0][2] + tokens[0][1].length }
        );
      }
      unnamedAtrule(node, token) {
        throw this.input.error(
          "At-rule without name",
          { offset: token[2] },
          { offset: token[2] + token[1].length }
        );
      }
    };
    module2.exports = Parser;
  }
});

// node_modules/postcss/lib/parse.js
var require_parse = __commonJS({
  "node_modules/postcss/lib/parse.js"(exports2, module2) {
    "use strict";
    var Container = require_container();
    var Parser = require_parser();
    var Input = require_input();
    function parse(css, opts) {
      let input = new Input(css, opts);
      let parser = new Parser(input);
      try {
        parser.parse();
      } catch (e) {
        if (process.env.NODE_ENV !== "production") {
          if (e.name === "CssSyntaxError" && opts && opts.from) {
            if (/\.scss$/i.test(opts.from)) {
              e.message += "\nYou tried to parse SCSS with the standard CSS parser; try again with the postcss-scss parser";
            } else if (/\.sass/i.test(opts.from)) {
              e.message += "\nYou tried to parse Sass with the standard CSS parser; try again with the postcss-sass parser";
            } else if (/\.less$/i.test(opts.from)) {
              e.message += "\nYou tried to parse Less with the standard CSS parser; try again with the postcss-less parser";
            }
          }
        }
        throw e;
      }
      return parser.root;
    }
    module2.exports = parse;
    parse.default = parse;
    Container.registerParse(parse);
  }
});

// node_modules/postcss/lib/lazy-result.js
var require_lazy_result = __commonJS({
  "node_modules/postcss/lib/lazy-result.js"(exports2, module2) {
    "use strict";
    var { isClean, my } = require_symbols();
    var MapGenerator = require_map_generator();
    var stringify = require_stringify();
    var Container = require_container();
    var Document = require_document();
    var warnOnce = require_warn_once();
    var Result = require_result();
    var parse = require_parse();
    var Root = require_root();
    var TYPE_TO_CLASS_NAME = {
      atrule: "AtRule",
      comment: "Comment",
      decl: "Declaration",
      document: "Document",
      root: "Root",
      rule: "Rule"
    };
    var PLUGIN_PROPS = {
      AtRule: true,
      AtRuleExit: true,
      Comment: true,
      CommentExit: true,
      Declaration: true,
      DeclarationExit: true,
      Document: true,
      DocumentExit: true,
      Once: true,
      OnceExit: true,
      postcssPlugin: true,
      prepare: true,
      Root: true,
      RootExit: true,
      Rule: true,
      RuleExit: true
    };
    var NOT_VISITORS = {
      Once: true,
      postcssPlugin: true,
      prepare: true
    };
    var CHILDREN = 0;
    function isPromise(obj) {
      return typeof obj === "object" && typeof obj.then === "function";
    }
    function getEvents(node) {
      let key = false;
      let type = TYPE_TO_CLASS_NAME[node.type];
      if (node.type === "decl") {
        key = node.prop.toLowerCase();
      } else if (node.type === "atrule") {
        key = node.name.toLowerCase();
      }
      if (key && node.append) {
        return [
          type,
          type + "-" + key,
          CHILDREN,
          type + "Exit",
          type + "Exit-" + key
        ];
      } else if (key) {
        return [type, type + "-" + key, type + "Exit", type + "Exit-" + key];
      } else if (node.append) {
        return [type, CHILDREN, type + "Exit"];
      } else {
        return [type, type + "Exit"];
      }
    }
    function toStack(node) {
      let events;
      if (node.type === "document") {
        events = ["Document", CHILDREN, "DocumentExit"];
      } else if (node.type === "root") {
        events = ["Root", CHILDREN, "RootExit"];
      } else {
        events = getEvents(node);
      }
      return {
        eventIndex: 0,
        events,
        iterator: 0,
        node,
        visitorIndex: 0,
        visitors: []
      };
    }
    function cleanMarks(node) {
      node[isClean] = false;
      if (node.nodes)
        node.nodes.forEach((i) => cleanMarks(i));
      return node;
    }
    var postcss = {};
    var LazyResult = class _LazyResult {
      constructor(processor, css, opts) {
        this.stringified = false;
        this.processed = false;
        let root;
        if (typeof css === "object" && css !== null && (css.type === "root" || css.type === "document")) {
          root = cleanMarks(css);
        } else if (css instanceof _LazyResult || css instanceof Result) {
          root = cleanMarks(css.root);
          if (css.map) {
            if (typeof opts.map === "undefined")
              opts.map = {};
            if (!opts.map.inline)
              opts.map.inline = false;
            opts.map.prev = css.map;
          }
        } else {
          let parser = parse;
          if (opts.syntax)
            parser = opts.syntax.parse;
          if (opts.parser)
            parser = opts.parser;
          if (parser.parse)
            parser = parser.parse;
          try {
            root = parser(css, opts);
          } catch (error) {
            this.processed = true;
            this.error = error;
          }
          if (root && !root[my]) {
            Container.rebuild(root);
          }
        }
        this.result = new Result(processor, root, opts);
        this.helpers = { ...postcss, postcss, result: this.result };
        this.plugins = this.processor.plugins.map((plugin) => {
          if (typeof plugin === "object" && plugin.prepare) {
            return { ...plugin, ...plugin.prepare(this.result) };
          } else {
            return plugin;
          }
        });
      }
      async() {
        if (this.error)
          return Promise.reject(this.error);
        if (this.processed)
          return Promise.resolve(this.result);
        if (!this.processing) {
          this.processing = this.runAsync();
        }
        return this.processing;
      }
      catch(onRejected) {
        return this.async().catch(onRejected);
      }
      finally(onFinally) {
        return this.async().then(onFinally, onFinally);
      }
      getAsyncError() {
        throw new Error("Use process(css).then(cb) to work with async plugins");
      }
      handleError(error, node) {
        let plugin = this.result.lastPlugin;
        try {
          if (node)
            node.addToError(error);
          this.error = error;
          if (error.name === "CssSyntaxError" && !error.plugin) {
            error.plugin = plugin.postcssPlugin;
            error.setMessage();
          } else if (plugin.postcssVersion) {
            if (process.env.NODE_ENV !== "production") {
              let pluginName = plugin.postcssPlugin;
              let pluginVer = plugin.postcssVersion;
              let runtimeVer = this.result.processor.version;
              let a = pluginVer.split(".");
              let b = runtimeVer.split(".");
              if (a[0] !== b[0] || parseInt(a[1]) > parseInt(b[1])) {
                console.error(
                  "Unknown error from PostCSS plugin. Your current PostCSS version is " + runtimeVer + ", but " + pluginName + " uses " + pluginVer + ". Perhaps this is the source of the error below."
                );
              }
            }
          }
        } catch (err) {
          if (console && console.error)
            console.error(err);
        }
        return error;
      }
      prepareVisitors() {
        this.listeners = {};
        let add = (plugin, type, cb) => {
          if (!this.listeners[type])
            this.listeners[type] = [];
          this.listeners[type].push([plugin, cb]);
        };
        for (let plugin of this.plugins) {
          if (typeof plugin === "object") {
            for (let event in plugin) {
              if (!PLUGIN_PROPS[event] && /^[A-Z]/.test(event)) {
                throw new Error(
                  `Unknown event ${event} in ${plugin.postcssPlugin}. Try to update PostCSS (${this.processor.version} now).`
                );
              }
              if (!NOT_VISITORS[event]) {
                if (typeof plugin[event] === "object") {
                  for (let filter in plugin[event]) {
                    if (filter === "*") {
                      add(plugin, event, plugin[event][filter]);
                    } else {
                      add(
                        plugin,
                        event + "-" + filter.toLowerCase(),
                        plugin[event][filter]
                      );
                    }
                  }
                } else if (typeof plugin[event] === "function") {
                  add(plugin, event, plugin[event]);
                }
              }
            }
          }
        }
        this.hasListener = Object.keys(this.listeners).length > 0;
      }
      async runAsync() {
        this.plugin = 0;
        for (let i = 0; i < this.plugins.length; i++) {
          let plugin = this.plugins[i];
          let promise = this.runOnRoot(plugin);
          if (isPromise(promise)) {
            try {
              await promise;
            } catch (error) {
              throw this.handleError(error);
            }
          }
        }
        this.prepareVisitors();
        if (this.hasListener) {
          let root = this.result.root;
          while (!root[isClean]) {
            root[isClean] = true;
            let stack = [toStack(root)];
            while (stack.length > 0) {
              let promise = this.visitTick(stack);
              if (isPromise(promise)) {
                try {
                  await promise;
                } catch (e) {
                  let node = stack[stack.length - 1].node;
                  throw this.handleError(e, node);
                }
              }
            }
          }
          if (this.listeners.OnceExit) {
            for (let [plugin, visitor] of this.listeners.OnceExit) {
              this.result.lastPlugin = plugin;
              try {
                if (root.type === "document") {
                  let roots = root.nodes.map(
                    (subRoot) => visitor(subRoot, this.helpers)
                  );
                  await Promise.all(roots);
                } else {
                  await visitor(root, this.helpers);
                }
              } catch (e) {
                throw this.handleError(e);
              }
            }
          }
        }
        this.processed = true;
        return this.stringify();
      }
      runOnRoot(plugin) {
        this.result.lastPlugin = plugin;
        try {
          if (typeof plugin === "object" && plugin.Once) {
            if (this.result.root.type === "document") {
              let roots = this.result.root.nodes.map(
                (root) => plugin.Once(root, this.helpers)
              );
              if (isPromise(roots[0])) {
                return Promise.all(roots);
              }
              return roots;
            }
            return plugin.Once(this.result.root, this.helpers);
          } else if (typeof plugin === "function") {
            return plugin(this.result.root, this.result);
          }
        } catch (error) {
          throw this.handleError(error);
        }
      }
      stringify() {
        if (this.error)
          throw this.error;
        if (this.stringified)
          return this.result;
        this.stringified = true;
        this.sync();
        let opts = this.result.opts;
        let str = stringify;
        if (opts.syntax)
          str = opts.syntax.stringify;
        if (opts.stringifier)
          str = opts.stringifier;
        if (str.stringify)
          str = str.stringify;
        let map = new MapGenerator(str, this.result.root, this.result.opts);
        let data = map.generate();
        this.result.css = data[0];
        this.result.map = data[1];
        return this.result;
      }
      sync() {
        if (this.error)
          throw this.error;
        if (this.processed)
          return this.result;
        this.processed = true;
        if (this.processing) {
          throw this.getAsyncError();
        }
        for (let plugin of this.plugins) {
          let promise = this.runOnRoot(plugin);
          if (isPromise(promise)) {
            throw this.getAsyncError();
          }
        }
        this.prepareVisitors();
        if (this.hasListener) {
          let root = this.result.root;
          while (!root[isClean]) {
            root[isClean] = true;
            this.walkSync(root);
          }
          if (this.listeners.OnceExit) {
            if (root.type === "document") {
              for (let subRoot of root.nodes) {
                this.visitSync(this.listeners.OnceExit, subRoot);
              }
            } else {
              this.visitSync(this.listeners.OnceExit, root);
            }
          }
        }
        return this.result;
      }
      then(onFulfilled, onRejected) {
        if (process.env.NODE_ENV !== "production") {
          if (!("from" in this.opts)) {
            warnOnce(
              "Without `from` option PostCSS could generate wrong source map and will not find Browserslist config. Set it to CSS file path or to `undefined` to prevent this warning."
            );
          }
        }
        return this.async().then(onFulfilled, onRejected);
      }
      toString() {
        return this.css;
      }
      visitSync(visitors, node) {
        for (let [plugin, visitor] of visitors) {
          this.result.lastPlugin = plugin;
          let promise;
          try {
            promise = visitor(node, this.helpers);
          } catch (e) {
            throw this.handleError(e, node.proxyOf);
          }
          if (node.type !== "root" && node.type !== "document" && !node.parent) {
            return true;
          }
          if (isPromise(promise)) {
            throw this.getAsyncError();
          }
        }
      }
      visitTick(stack) {
        let visit = stack[stack.length - 1];
        let { node, visitors } = visit;
        if (node.type !== "root" && node.type !== "document" && !node.parent) {
          stack.pop();
          return;
        }
        if (visitors.length > 0 && visit.visitorIndex < visitors.length) {
          let [plugin, visitor] = visitors[visit.visitorIndex];
          visit.visitorIndex += 1;
          if (visit.visitorIndex === visitors.length) {
            visit.visitors = [];
            visit.visitorIndex = 0;
          }
          this.result.lastPlugin = plugin;
          try {
            return visitor(node.toProxy(), this.helpers);
          } catch (e) {
            throw this.handleError(e, node);
          }
        }
        if (visit.iterator !== 0) {
          let iterator = visit.iterator;
          let child;
          while (child = node.nodes[node.indexes[iterator]]) {
            node.indexes[iterator] += 1;
            if (!child[isClean]) {
              child[isClean] = true;
              stack.push(toStack(child));
              return;
            }
          }
          visit.iterator = 0;
          delete node.indexes[iterator];
        }
        let events = visit.events;
        while (visit.eventIndex < events.length) {
          let event = events[visit.eventIndex];
          visit.eventIndex += 1;
          if (event === CHILDREN) {
            if (node.nodes && node.nodes.length) {
              node[isClean] = true;
              visit.iterator = node.getIterator();
            }
            return;
          } else if (this.listeners[event]) {
            visit.visitors = this.listeners[event];
            return;
          }
        }
        stack.pop();
      }
      walkSync(node) {
        node[isClean] = true;
        let events = getEvents(node);
        for (let event of events) {
          if (event === CHILDREN) {
            if (node.nodes) {
              node.each((child) => {
                if (!child[isClean])
                  this.walkSync(child);
              });
            }
          } else {
            let visitors = this.listeners[event];
            if (visitors) {
              if (this.visitSync(visitors, node.toProxy()))
                return;
            }
          }
        }
      }
      warnings() {
        return this.sync().warnings();
      }
      get content() {
        return this.stringify().content;
      }
      get css() {
        return this.stringify().css;
      }
      get map() {
        return this.stringify().map;
      }
      get messages() {
        return this.sync().messages;
      }
      get opts() {
        return this.result.opts;
      }
      get processor() {
        return this.result.processor;
      }
      get root() {
        return this.sync().root;
      }
      get [Symbol.toStringTag]() {
        return "LazyResult";
      }
    };
    LazyResult.registerPostcss = (dependant) => {
      postcss = dependant;
    };
    module2.exports = LazyResult;
    LazyResult.default = LazyResult;
    Root.registerLazyResult(LazyResult);
    Document.registerLazyResult(LazyResult);
  }
});

// node_modules/postcss/lib/no-work-result.js
var require_no_work_result = __commonJS({
  "node_modules/postcss/lib/no-work-result.js"(exports2, module2) {
    "use strict";
    var MapGenerator = require_map_generator();
    var stringify = require_stringify();
    var warnOnce = require_warn_once();
    var parse = require_parse();
    var Result = require_result();
    var NoWorkResult = class {
      constructor(processor, css, opts) {
        css = css.toString();
        this.stringified = false;
        this._processor = processor;
        this._css = css;
        this._opts = opts;
        this._map = void 0;
        let root;
        let str = stringify;
        this.result = new Result(this._processor, root, this._opts);
        this.result.css = css;
        let self2 = this;
        Object.defineProperty(this.result, "root", {
          get() {
            return self2.root;
          }
        });
        let map = new MapGenerator(str, root, this._opts, css);
        if (map.isMap()) {
          let [generatedCSS, generatedMap] = map.generate();
          if (generatedCSS) {
            this.result.css = generatedCSS;
          }
          if (generatedMap) {
            this.result.map = generatedMap;
          }
        } else {
          map.clearAnnotation();
          this.result.css = map.css;
        }
      }
      async() {
        if (this.error)
          return Promise.reject(this.error);
        return Promise.resolve(this.result);
      }
      catch(onRejected) {
        return this.async().catch(onRejected);
      }
      finally(onFinally) {
        return this.async().then(onFinally, onFinally);
      }
      sync() {
        if (this.error)
          throw this.error;
        return this.result;
      }
      then(onFulfilled, onRejected) {
        if (process.env.NODE_ENV !== "production") {
          if (!("from" in this._opts)) {
            warnOnce(
              "Without `from` option PostCSS could generate wrong source map and will not find Browserslist config. Set it to CSS file path or to `undefined` to prevent this warning."
            );
          }
        }
        return this.async().then(onFulfilled, onRejected);
      }
      toString() {
        return this._css;
      }
      warnings() {
        return [];
      }
      get content() {
        return this.result.css;
      }
      get css() {
        return this.result.css;
      }
      get map() {
        return this.result.map;
      }
      get messages() {
        return [];
      }
      get opts() {
        return this.result.opts;
      }
      get processor() {
        return this.result.processor;
      }
      get root() {
        if (this._root) {
          return this._root;
        }
        let root;
        let parser = parse;
        try {
          root = parser(this._css, this._opts);
        } catch (error) {
          this.error = error;
        }
        if (this.error) {
          throw this.error;
        } else {
          this._root = root;
          return root;
        }
      }
      get [Symbol.toStringTag]() {
        return "NoWorkResult";
      }
    };
    module2.exports = NoWorkResult;
    NoWorkResult.default = NoWorkResult;
  }
});

// node_modules/postcss/lib/processor.js
var require_processor = __commonJS({
  "node_modules/postcss/lib/processor.js"(exports2, module2) {
    "use strict";
    var NoWorkResult = require_no_work_result();
    var LazyResult = require_lazy_result();
    var Document = require_document();
    var Root = require_root();
    var Processor = class {
      constructor(plugins = []) {
        this.version = "8.4.38";
        this.plugins = this.normalize(plugins);
      }
      normalize(plugins) {
        let normalized = [];
        for (let i of plugins) {
          if (i.postcss === true) {
            i = i();
          } else if (i.postcss) {
            i = i.postcss;
          }
          if (typeof i === "object" && Array.isArray(i.plugins)) {
            normalized = normalized.concat(i.plugins);
          } else if (typeof i === "object" && i.postcssPlugin) {
            normalized.push(i);
          } else if (typeof i === "function") {
            normalized.push(i);
          } else if (typeof i === "object" && (i.parse || i.stringify)) {
            if (process.env.NODE_ENV !== "production") {
              throw new Error(
                "PostCSS syntaxes cannot be used as plugins. Instead, please use one of the syntax/parser/stringifier options as outlined in your PostCSS runner documentation."
              );
            }
          } else {
            throw new Error(i + " is not a PostCSS plugin");
          }
        }
        return normalized;
      }
      process(css, opts = {}) {
        if (!this.plugins.length && !opts.parser && !opts.stringifier && !opts.syntax) {
          return new NoWorkResult(this, css, opts);
        } else {
          return new LazyResult(this, css, opts);
        }
      }
      use(plugin) {
        this.plugins = this.plugins.concat(this.normalize([plugin]));
        return this;
      }
    };
    module2.exports = Processor;
    Processor.default = Processor;
    Root.registerProcessor(Processor);
    Document.registerProcessor(Processor);
  }
});

// node_modules/postcss/lib/fromJSON.js
var require_fromJSON = __commonJS({
  "node_modules/postcss/lib/fromJSON.js"(exports2, module2) {
    "use strict";
    var Declaration = require_declaration();
    var PreviousMap = require_previous_map();
    var Comment = require_comment();
    var AtRule = require_at_rule();
    var Input = require_input();
    var Root = require_root();
    var Rule = require_rule();
    function fromJSON(json, inputs) {
      if (Array.isArray(json))
        return json.map((n) => fromJSON(n));
      let { inputs: ownInputs, ...defaults } = json;
      if (ownInputs) {
        inputs = [];
        for (let input of ownInputs) {
          let inputHydrated = { ...input, __proto__: Input.prototype };
          if (inputHydrated.map) {
            inputHydrated.map = {
              ...inputHydrated.map,
              __proto__: PreviousMap.prototype
            };
          }
          inputs.push(inputHydrated);
        }
      }
      if (defaults.nodes) {
        defaults.nodes = json.nodes.map((n) => fromJSON(n, inputs));
      }
      if (defaults.source) {
        let { inputId, ...source } = defaults.source;
        defaults.source = source;
        if (inputId != null) {
          defaults.source.input = inputs[inputId];
        }
      }
      if (defaults.type === "root") {
        return new Root(defaults);
      } else if (defaults.type === "decl") {
        return new Declaration(defaults);
      } else if (defaults.type === "rule") {
        return new Rule(defaults);
      } else if (defaults.type === "comment") {
        return new Comment(defaults);
      } else if (defaults.type === "atrule") {
        return new AtRule(defaults);
      } else {
        throw new Error("Unknown node type: " + json.type);
      }
    }
    module2.exports = fromJSON;
    fromJSON.default = fromJSON;
  }
});

// node_modules/postcss/lib/postcss.js
var require_postcss = __commonJS({
  "node_modules/postcss/lib/postcss.js"(exports2, module2) {
    "use strict";
    var CssSyntaxError = require_css_syntax_error();
    var Declaration = require_declaration();
    var LazyResult = require_lazy_result();
    var Container = require_container();
    var Processor = require_processor();
    var stringify = require_stringify();
    var fromJSON = require_fromJSON();
    var Document = require_document();
    var Warning = require_warning();
    var Comment = require_comment();
    var AtRule = require_at_rule();
    var Result = require_result();
    var Input = require_input();
    var parse = require_parse();
    var list = require_list();
    var Rule = require_rule();
    var Root = require_root();
    var Node = require_node();
    function postcss(...plugins) {
      if (plugins.length === 1 && Array.isArray(plugins[0])) {
        plugins = plugins[0];
      }
      return new Processor(plugins);
    }
    postcss.plugin = function plugin(name, initializer) {
      let warningPrinted = false;
      function creator(...args) {
        if (console && console.warn && !warningPrinted) {
          warningPrinted = true;
          console.warn(
            name + ": postcss.plugin was deprecated. Migration guide:\nhttps://evilmartians.com/chronicles/postcss-8-plugin-migration"
          );
          if (process.env.LANG && process.env.LANG.startsWith("cn")) {
            console.warn(
              name + ": \u91CC\u9762 postcss.plugin \u88AB\u5F03\u7528. \u8FC1\u79FB\u6307\u5357:\nhttps://www.w3ctech.com/topic/2226"
            );
          }
        }
        let transformer = initializer(...args);
        transformer.postcssPlugin = name;
        transformer.postcssVersion = new Processor().version;
        return transformer;
      }
      let cache;
      Object.defineProperty(creator, "postcss", {
        get() {
          if (!cache)
            cache = creator();
          return cache;
        }
      });
      creator.process = function(css, processOpts, pluginOpts) {
        return postcss([creator(pluginOpts)]).process(css, processOpts);
      };
      return creator;
    };
    postcss.stringify = stringify;
    postcss.parse = parse;
    postcss.fromJSON = fromJSON;
    postcss.list = list;
    postcss.comment = (defaults) => new Comment(defaults);
    postcss.atRule = (defaults) => new AtRule(defaults);
    postcss.decl = (defaults) => new Declaration(defaults);
    postcss.rule = (defaults) => new Rule(defaults);
    postcss.root = (defaults) => new Root(defaults);
    postcss.document = (defaults) => new Document(defaults);
    postcss.CssSyntaxError = CssSyntaxError;
    postcss.Declaration = Declaration;
    postcss.Container = Container;
    postcss.Processor = Processor;
    postcss.Document = Document;
    postcss.Comment = Comment;
    postcss.Warning = Warning;
    postcss.AtRule = AtRule;
    postcss.Result = Result;
    postcss.Input = Input;
    postcss.Rule = Rule;
    postcss.Root = Root;
    postcss.Node = Node;
    LazyResult.registerPostcss(postcss);
    module2.exports = postcss;
    postcss.default = postcss;
  }
});

// node_modules/postcss-import/lib/join-media.js
var require_join_media = __commonJS({
  "node_modules/postcss-import/lib/join-media.js"(exports2, module2) {
    "use strict";
    var startsWithKeywordRegexp = /^(all|not|only|print|screen)/i;
    module2.exports = function(parentMedia, childMedia) {
      if (!parentMedia.length && childMedia.length)
        return childMedia;
      if (parentMedia.length && !childMedia.length)
        return parentMedia;
      if (!parentMedia.length && !childMedia.length)
        return [];
      const media = [];
      parentMedia.forEach((parentItem) => {
        const parentItemStartsWithKeyword = startsWithKeywordRegexp.test(parentItem);
        childMedia.forEach((childItem) => {
          const childItemStartsWithKeyword = startsWithKeywordRegexp.test(childItem);
          if (parentItem !== childItem) {
            if (childItemStartsWithKeyword && !parentItemStartsWithKeyword) {
              media.push(`${childItem} and ${parentItem}`);
            } else {
              media.push(`${parentItem} and ${childItem}`);
            }
          }
        });
      });
      return media;
    };
  }
});

// node_modules/postcss-import/lib/join-layer.js
var require_join_layer = __commonJS({
  "node_modules/postcss-import/lib/join-layer.js"(exports2, module2) {
    "use strict";
    module2.exports = function(parentLayer, childLayer) {
      if (!parentLayer.length && childLayer.length)
        return childLayer;
      if (parentLayer.length && !childLayer.length)
        return parentLayer;
      if (!parentLayer.length && !childLayer.length)
        return [];
      return parentLayer.concat(childLayer);
    };
  }
});

// node_modules/resolve/lib/homedir.js
var require_homedir = __commonJS({
  "node_modules/resolve/lib/homedir.js"(exports2, module2) {
    "use strict";
    var os = require("os");
    module2.exports = os.homedir || function homedir() {
      var home = process.env.HOME;
      var user = process.env.LOGNAME || process.env.USER || process.env.LNAME || process.env.USERNAME;
      if (process.platform === "win32") {
        return process.env.USERPROFILE || process.env.HOMEDRIVE + process.env.HOMEPATH || home || null;
      }
      if (process.platform === "darwin") {
        return home || (user ? "/Users/" + user : null);
      }
      if (process.platform === "linux") {
        return home || (process.getuid() === 0 ? "/root" : user ? "/home/" + user : null);
      }
      return home || null;
    };
  }
});

// node_modules/resolve/lib/caller.js
var require_caller = __commonJS({
  "node_modules/resolve/lib/caller.js"(exports2, module2) {
    module2.exports = function() {
      var origPrepareStackTrace = Error.prepareStackTrace;
      Error.prepareStackTrace = function(_, stack2) {
        return stack2;
      };
      var stack = new Error().stack;
      Error.prepareStackTrace = origPrepareStackTrace;
      return stack[2].getFileName();
    };
  }
});

// node_modules/path-parse/index.js
var require_path_parse = __commonJS({
  "node_modules/path-parse/index.js"(exports2, module2) {
    "use strict";
    var isWindows = process.platform === "win32";
    var splitWindowsRe = /^(((?:[a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/]+[^\\\/]+)?[\\\/]?)(?:[^\\\/]*[\\\/])*)((\.{1,2}|[^\\\/]+?|)(\.[^.\/\\]*|))[\\\/]*$/;
    var win32 = {};
    function win32SplitPath(filename) {
      return splitWindowsRe.exec(filename).slice(1);
    }
    win32.parse = function(pathString) {
      if (typeof pathString !== "string") {
        throw new TypeError(
          "Parameter 'pathString' must be a string, not " + typeof pathString
        );
      }
      var allParts = win32SplitPath(pathString);
      if (!allParts || allParts.length !== 5) {
        throw new TypeError("Invalid path '" + pathString + "'");
      }
      return {
        root: allParts[1],
        dir: allParts[0] === allParts[1] ? allParts[0] : allParts[0].slice(0, -1),
        base: allParts[2],
        ext: allParts[4],
        name: allParts[3]
      };
    };
    var splitPathRe = /^((\/?)(?:[^\/]*\/)*)((\.{1,2}|[^\/]+?|)(\.[^.\/]*|))[\/]*$/;
    var posix = {};
    function posixSplitPath(filename) {
      return splitPathRe.exec(filename).slice(1);
    }
    posix.parse = function(pathString) {
      if (typeof pathString !== "string") {
        throw new TypeError(
          "Parameter 'pathString' must be a string, not " + typeof pathString
        );
      }
      var allParts = posixSplitPath(pathString);
      if (!allParts || allParts.length !== 5) {
        throw new TypeError("Invalid path '" + pathString + "'");
      }
      return {
        root: allParts[1],
        dir: allParts[0].slice(0, -1),
        base: allParts[2],
        ext: allParts[4],
        name: allParts[3]
      };
    };
    if (isWindows)
      module2.exports = win32.parse;
    else
      module2.exports = posix.parse;
    module2.exports.posix = posix.parse;
    module2.exports.win32 = win32.parse;
  }
});

// node_modules/resolve/lib/node-modules-paths.js
var require_node_modules_paths = __commonJS({
  "node_modules/resolve/lib/node-modules-paths.js"(exports2, module2) {
    var path = require("path");
    var parse = path.parse || require_path_parse();
    var getNodeModulesDirs = function getNodeModulesDirs2(absoluteStart, modules) {
      var prefix = "/";
      if (/^([A-Za-z]:)/.test(absoluteStart)) {
        prefix = "";
      } else if (/^\\\\/.test(absoluteStart)) {
        prefix = "\\\\";
      }
      var paths = [absoluteStart];
      var parsed = parse(absoluteStart);
      while (parsed.dir !== paths[paths.length - 1]) {
        paths.push(parsed.dir);
        parsed = parse(parsed.dir);
      }
      return paths.reduce(function(dirs, aPath) {
        return dirs.concat(modules.map(function(moduleDir) {
          return path.resolve(prefix, aPath, moduleDir);
        }));
      }, []);
    };
    module2.exports = function nodeModulesPaths(start, opts, request) {
      var modules = opts && opts.moduleDirectory ? [].concat(opts.moduleDirectory) : ["node_modules"];
      if (opts && typeof opts.paths === "function") {
        return opts.paths(
          request,
          start,
          function() {
            return getNodeModulesDirs(start, modules);
          },
          opts
        );
      }
      var dirs = getNodeModulesDirs(start, modules);
      return opts && opts.paths ? dirs.concat(opts.paths) : dirs;
    };
  }
});

// node_modules/resolve/lib/normalize-options.js
var require_normalize_options = __commonJS({
  "node_modules/resolve/lib/normalize-options.js"(exports2, module2) {
    module2.exports = function(x, opts) {
      return opts || {};
    };
  }
});

// node_modules/function-bind/implementation.js
var require_implementation = __commonJS({
  "node_modules/function-bind/implementation.js"(exports2, module2) {
    "use strict";
    var ERROR_MESSAGE = "Function.prototype.bind called on incompatible ";
    var slice = Array.prototype.slice;
    var toStr = Object.prototype.toString;
    var funcType = "[object Function]";
    module2.exports = function bind(that) {
      var target = this;
      if (typeof target !== "function" || toStr.call(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
      }
      var args = slice.call(arguments, 1);
      var bound;
      var binder = function() {
        if (this instanceof bound) {
          var result = target.apply(
            this,
            args.concat(slice.call(arguments))
          );
          if (Object(result) === result) {
            return result;
          }
          return this;
        } else {
          return target.apply(
            that,
            args.concat(slice.call(arguments))
          );
        }
      };
      var boundLength = Math.max(0, target.length - args.length);
      var boundArgs = [];
      for (var i = 0; i < boundLength; i++) {
        boundArgs.push("$" + i);
      }
      bound = Function("binder", "return function (" + boundArgs.join(",") + "){ return binder.apply(this,arguments); }")(binder);
      if (target.prototype) {
        var Empty = function Empty2() {
        };
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
      }
      return bound;
    };
  }
});

// node_modules/function-bind/index.js
var require_function_bind = __commonJS({
  "node_modules/function-bind/index.js"(exports2, module2) {
    "use strict";
    var implementation = require_implementation();
    module2.exports = Function.prototype.bind || implementation;
  }
});

// node_modules/has/src/index.js
var require_src = __commonJS({
  "node_modules/has/src/index.js"(exports2, module2) {
    "use strict";
    var bind = require_function_bind();
    module2.exports = bind.call(Function.call, Object.prototype.hasOwnProperty);
  }
});

// node_modules/is-core-module/core.json
var require_core = __commonJS({
  "node_modules/is-core-module/core.json"(exports2, module2) {
    module2.exports = {
      assert: true,
      "node:assert": [">= 14.18 && < 15", ">= 16"],
      "assert/strict": ">= 15",
      "node:assert/strict": ">= 16",
      async_hooks: ">= 8",
      "node:async_hooks": [">= 14.18 && < 15", ">= 16"],
      buffer_ieee754: ">= 0.5 && < 0.9.7",
      buffer: true,
      "node:buffer": [">= 14.18 && < 15", ">= 16"],
      child_process: true,
      "node:child_process": [">= 14.18 && < 15", ">= 16"],
      cluster: ">= 0.5",
      "node:cluster": [">= 14.18 && < 15", ">= 16"],
      console: true,
      "node:console": [">= 14.18 && < 15", ">= 16"],
      constants: true,
      "node:constants": [">= 14.18 && < 15", ">= 16"],
      crypto: true,
      "node:crypto": [">= 14.18 && < 15", ">= 16"],
      _debug_agent: ">= 1 && < 8",
      _debugger: "< 8",
      dgram: true,
      "node:dgram": [">= 14.18 && < 15", ">= 16"],
      diagnostics_channel: [">= 14.17 && < 15", ">= 15.1"],
      "node:diagnostics_channel": [">= 14.18 && < 15", ">= 16"],
      dns: true,
      "node:dns": [">= 14.18 && < 15", ">= 16"],
      "dns/promises": ">= 15",
      "node:dns/promises": ">= 16",
      domain: ">= 0.7.12",
      "node:domain": [">= 14.18 && < 15", ">= 16"],
      events: true,
      "node:events": [">= 14.18 && < 15", ">= 16"],
      freelist: "< 6",
      fs: true,
      "node:fs": [">= 14.18 && < 15", ">= 16"],
      "fs/promises": [">= 10 && < 10.1", ">= 14"],
      "node:fs/promises": [">= 14.18 && < 15", ">= 16"],
      _http_agent: ">= 0.11.1",
      "node:_http_agent": [">= 14.18 && < 15", ">= 16"],
      _http_client: ">= 0.11.1",
      "node:_http_client": [">= 14.18 && < 15", ">= 16"],
      _http_common: ">= 0.11.1",
      "node:_http_common": [">= 14.18 && < 15", ">= 16"],
      _http_incoming: ">= 0.11.1",
      "node:_http_incoming": [">= 14.18 && < 15", ">= 16"],
      _http_outgoing: ">= 0.11.1",
      "node:_http_outgoing": [">= 14.18 && < 15", ">= 16"],
      _http_server: ">= 0.11.1",
      "node:_http_server": [">= 14.18 && < 15", ">= 16"],
      http: true,
      "node:http": [">= 14.18 && < 15", ">= 16"],
      http2: ">= 8.8",
      "node:http2": [">= 14.18 && < 15", ">= 16"],
      https: true,
      "node:https": [">= 14.18 && < 15", ">= 16"],
      inspector: ">= 8",
      "node:inspector": [">= 14.18 && < 15", ">= 16"],
      "inspector/promises": [">= 19"],
      "node:inspector/promises": [">= 19"],
      _linklist: "< 8",
      module: true,
      "node:module": [">= 14.18 && < 15", ">= 16"],
      net: true,
      "node:net": [">= 14.18 && < 15", ">= 16"],
      "node-inspect/lib/_inspect": ">= 7.6 && < 12",
      "node-inspect/lib/internal/inspect_client": ">= 7.6 && < 12",
      "node-inspect/lib/internal/inspect_repl": ">= 7.6 && < 12",
      os: true,
      "node:os": [">= 14.18 && < 15", ">= 16"],
      path: true,
      "node:path": [">= 14.18 && < 15", ">= 16"],
      "path/posix": ">= 15.3",
      "node:path/posix": ">= 16",
      "path/win32": ">= 15.3",
      "node:path/win32": ">= 16",
      perf_hooks: ">= 8.5",
      "node:perf_hooks": [">= 14.18 && < 15", ">= 16"],
      process: ">= 1",
      "node:process": [">= 14.18 && < 15", ">= 16"],
      punycode: ">= 0.5",
      "node:punycode": [">= 14.18 && < 15", ">= 16"],
      querystring: true,
      "node:querystring": [">= 14.18 && < 15", ">= 16"],
      readline: true,
      "node:readline": [">= 14.18 && < 15", ">= 16"],
      "readline/promises": ">= 17",
      "node:readline/promises": ">= 17",
      repl: true,
      "node:repl": [">= 14.18 && < 15", ">= 16"],
      smalloc: ">= 0.11.5 && < 3",
      _stream_duplex: ">= 0.9.4",
      "node:_stream_duplex": [">= 14.18 && < 15", ">= 16"],
      _stream_transform: ">= 0.9.4",
      "node:_stream_transform": [">= 14.18 && < 15", ">= 16"],
      _stream_wrap: ">= 1.4.1",
      "node:_stream_wrap": [">= 14.18 && < 15", ">= 16"],
      _stream_passthrough: ">= 0.9.4",
      "node:_stream_passthrough": [">= 14.18 && < 15", ">= 16"],
      _stream_readable: ">= 0.9.4",
      "node:_stream_readable": [">= 14.18 && < 15", ">= 16"],
      _stream_writable: ">= 0.9.4",
      "node:_stream_writable": [">= 14.18 && < 15", ">= 16"],
      stream: true,
      "node:stream": [">= 14.18 && < 15", ">= 16"],
      "stream/consumers": ">= 16.7",
      "node:stream/consumers": ">= 16.7",
      "stream/promises": ">= 15",
      "node:stream/promises": ">= 16",
      "stream/web": ">= 16.5",
      "node:stream/web": ">= 16.5",
      string_decoder: true,
      "node:string_decoder": [">= 14.18 && < 15", ">= 16"],
      sys: [">= 0.4 && < 0.7", ">= 0.8"],
      "node:sys": [">= 14.18 && < 15", ">= 16"],
      "test/reporters": [">= 19.9", ">= 20"],
      "node:test/reporters": [">= 19.9", ">= 20"],
      "node:test": [">= 16.17 && < 17", ">= 18"],
      timers: true,
      "node:timers": [">= 14.18 && < 15", ">= 16"],
      "timers/promises": ">= 15",
      "node:timers/promises": ">= 16",
      _tls_common: ">= 0.11.13",
      "node:_tls_common": [">= 14.18 && < 15", ">= 16"],
      _tls_legacy: ">= 0.11.3 && < 10",
      _tls_wrap: ">= 0.11.3",
      "node:_tls_wrap": [">= 14.18 && < 15", ">= 16"],
      tls: true,
      "node:tls": [">= 14.18 && < 15", ">= 16"],
      trace_events: ">= 10",
      "node:trace_events": [">= 14.18 && < 15", ">= 16"],
      tty: true,
      "node:tty": [">= 14.18 && < 15", ">= 16"],
      url: true,
      "node:url": [">= 14.18 && < 15", ">= 16"],
      util: true,
      "node:util": [">= 14.18 && < 15", ">= 16"],
      "util/types": ">= 15.3",
      "node:util/types": ">= 16",
      "v8/tools/arguments": ">= 10 && < 12",
      "v8/tools/codemap": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/consarray": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/csvparser": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/logreader": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/profile_view": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/splaytree": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      v8: ">= 1",
      "node:v8": [">= 14.18 && < 15", ">= 16"],
      vm: true,
      "node:vm": [">= 14.18 && < 15", ">= 16"],
      wasi: [">= 13.4 && < 13.5", ">= 20"],
      "node:wasi": ">= 20",
      worker_threads: ">= 11.7",
      "node:worker_threads": [">= 14.18 && < 15", ">= 16"],
      zlib: ">= 0.5",
      "node:zlib": [">= 14.18 && < 15", ">= 16"]
    };
  }
});

// node_modules/is-core-module/index.js
var require_is_core_module = __commonJS({
  "node_modules/is-core-module/index.js"(exports2, module2) {
    "use strict";
    var has = require_src();
    function specifierIncluded(current, specifier) {
      var nodeParts = current.split(".");
      var parts = specifier.split(" ");
      var op = parts.length > 1 ? parts[0] : "=";
      var versionParts = (parts.length > 1 ? parts[1] : parts[0]).split(".");
      for (var i = 0; i < 3; ++i) {
        var cur = parseInt(nodeParts[i] || 0, 10);
        var ver = parseInt(versionParts[i] || 0, 10);
        if (cur === ver) {
          continue;
        }
        if (op === "<") {
          return cur < ver;
        }
        if (op === ">=") {
          return cur >= ver;
        }
        return false;
      }
      return op === ">=";
    }
    function matchesRange(current, range) {
      var specifiers = range.split(/ ?&& ?/);
      if (specifiers.length === 0) {
        return false;
      }
      for (var i = 0; i < specifiers.length; ++i) {
        if (!specifierIncluded(current, specifiers[i])) {
          return false;
        }
      }
      return true;
    }
    function versionIncluded(nodeVersion, specifierValue) {
      if (typeof specifierValue === "boolean") {
        return specifierValue;
      }
      var current = typeof nodeVersion === "undefined" ? process.versions && process.versions.node : nodeVersion;
      if (typeof current !== "string") {
        throw new TypeError(typeof nodeVersion === "undefined" ? "Unable to determine current node version" : "If provided, a valid node version is required");
      }
      if (specifierValue && typeof specifierValue === "object") {
        for (var i = 0; i < specifierValue.length; ++i) {
          if (matchesRange(current, specifierValue[i])) {
            return true;
          }
        }
        return false;
      }
      return matchesRange(current, specifierValue);
    }
    var data = require_core();
    module2.exports = function isCore(x, nodeVersion) {
      return has(data, x) && versionIncluded(nodeVersion, data[x]);
    };
  }
});

// node_modules/resolve/lib/async.js
var require_async = __commonJS({
  "node_modules/resolve/lib/async.js"(exports2, module2) {
    var fs = require("fs");
    var getHomedir = require_homedir();
    var path = require("path");
    var caller = require_caller();
    var nodeModulesPaths = require_node_modules_paths();
    var normalizeOptions = require_normalize_options();
    var isCore = require_is_core_module();
    var realpathFS = process.platform !== "win32" && fs.realpath && typeof fs.realpath.native === "function" ? fs.realpath.native : fs.realpath;
    var homedir = getHomedir();
    var defaultPaths = function() {
      return [
        path.join(homedir, ".node_modules"),
        path.join(homedir, ".node_libraries")
      ];
    };
    var defaultIsFile = function isFile(file, cb) {
      fs.stat(file, function(err, stat) {
        if (!err) {
          return cb(null, stat.isFile() || stat.isFIFO());
        }
        if (err.code === "ENOENT" || err.code === "ENOTDIR")
          return cb(null, false);
        return cb(err);
      });
    };
    var defaultIsDir = function isDirectory(dir, cb) {
      fs.stat(dir, function(err, stat) {
        if (!err) {
          return cb(null, stat.isDirectory());
        }
        if (err.code === "ENOENT" || err.code === "ENOTDIR")
          return cb(null, false);
        return cb(err);
      });
    };
    var defaultRealpath = function realpath(x, cb) {
      realpathFS(x, function(realpathErr, realPath) {
        if (realpathErr && realpathErr.code !== "ENOENT")
          cb(realpathErr);
        else
          cb(null, realpathErr ? x : realPath);
      });
    };
    var maybeRealpath = function maybeRealpath2(realpath, x, opts, cb) {
      if (opts && opts.preserveSymlinks === false) {
        realpath(x, cb);
      } else {
        cb(null, x);
      }
    };
    var defaultReadPackage = function defaultReadPackage2(readFile, pkgfile, cb) {
      readFile(pkgfile, function(readFileErr, body) {
        if (readFileErr)
          cb(readFileErr);
        else {
          try {
            var pkg = JSON.parse(body);
            cb(null, pkg);
          } catch (jsonErr) {
            cb(null);
          }
        }
      });
    };
    var getPackageCandidates = function getPackageCandidates2(x, start, opts) {
      var dirs = nodeModulesPaths(start, opts, x);
      for (var i = 0; i < dirs.length; i++) {
        dirs[i] = path.join(dirs[i], x);
      }
      return dirs;
    };
    module2.exports = function resolve(x, options, callback) {
      var cb = callback;
      var opts = options;
      if (typeof options === "function") {
        cb = opts;
        opts = {};
      }
      if (typeof x !== "string") {
        var err = new TypeError("Path must be a string.");
        return process.nextTick(function() {
          cb(err);
        });
      }
      opts = normalizeOptions(x, opts);
      var isFile = opts.isFile || defaultIsFile;
      var isDirectory = opts.isDirectory || defaultIsDir;
      var readFile = opts.readFile || fs.readFile;
      var realpath = opts.realpath || defaultRealpath;
      var readPackage = opts.readPackage || defaultReadPackage;
      if (opts.readFile && opts.readPackage) {
        var conflictErr = new TypeError("`readFile` and `readPackage` are mutually exclusive.");
        return process.nextTick(function() {
          cb(conflictErr);
        });
      }
      var packageIterator = opts.packageIterator;
      var extensions = opts.extensions || [".js"];
      var includeCoreModules = opts.includeCoreModules !== false;
      var basedir = opts.basedir || path.dirname(caller());
      var parent = opts.filename || basedir;
      opts.paths = opts.paths || defaultPaths();
      var absoluteStart = path.resolve(basedir);
      maybeRealpath(
        realpath,
        absoluteStart,
        opts,
        function(err2, realStart) {
          if (err2)
            cb(err2);
          else
            init(realStart);
        }
      );
      var res;
      function init(basedir2) {
        if (/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/.test(x)) {
          res = path.resolve(basedir2, x);
          if (x === "." || x === ".." || x.slice(-1) === "/")
            res += "/";
          if (/\/$/.test(x) && res === basedir2) {
            loadAsDirectory(res, opts.package, onfile);
          } else
            loadAsFile(res, opts.package, onfile);
        } else if (includeCoreModules && isCore(x)) {
          return cb(null, x);
        } else
          loadNodeModules(x, basedir2, function(err2, n, pkg) {
            if (err2)
              cb(err2);
            else if (n) {
              return maybeRealpath(realpath, n, opts, function(err3, realN) {
                if (err3) {
                  cb(err3);
                } else {
                  cb(null, realN, pkg);
                }
              });
            } else {
              var moduleError = new Error("Cannot find module '" + x + "' from '" + parent + "'");
              moduleError.code = "MODULE_NOT_FOUND";
              cb(moduleError);
            }
          });
      }
      function onfile(err2, m, pkg) {
        if (err2)
          cb(err2);
        else if (m)
          cb(null, m, pkg);
        else
          loadAsDirectory(res, function(err3, d, pkg2) {
            if (err3)
              cb(err3);
            else if (d) {
              maybeRealpath(realpath, d, opts, function(err4, realD) {
                if (err4) {
                  cb(err4);
                } else {
                  cb(null, realD, pkg2);
                }
              });
            } else {
              var moduleError = new Error("Cannot find module '" + x + "' from '" + parent + "'");
              moduleError.code = "MODULE_NOT_FOUND";
              cb(moduleError);
            }
          });
      }
      function loadAsFile(x2, thePackage, callback2) {
        var loadAsFilePackage = thePackage;
        var cb2 = callback2;
        if (typeof loadAsFilePackage === "function") {
          cb2 = loadAsFilePackage;
          loadAsFilePackage = void 0;
        }
        var exts = [""].concat(extensions);
        load(exts, x2, loadAsFilePackage);
        function load(exts2, x3, loadPackage) {
          if (exts2.length === 0)
            return cb2(null, void 0, loadPackage);
          var file = x3 + exts2[0];
          var pkg = loadPackage;
          if (pkg)
            onpkg(null, pkg);
          else
            loadpkg(path.dirname(file), onpkg);
          function onpkg(err2, pkg_, dir) {
            pkg = pkg_;
            if (err2)
              return cb2(err2);
            if (dir && pkg && opts.pathFilter) {
              var rfile = path.relative(dir, file);
              var rel = rfile.slice(0, rfile.length - exts2[0].length);
              var r = opts.pathFilter(pkg, x3, rel);
              if (r)
                return load(
                  [""].concat(extensions.slice()),
                  path.resolve(dir, r),
                  pkg
                );
            }
            isFile(file, onex);
          }
          function onex(err2, ex) {
            if (err2)
              return cb2(err2);
            if (ex)
              return cb2(null, file, pkg);
            load(exts2.slice(1), x3, pkg);
          }
        }
      }
      function loadpkg(dir, cb2) {
        if (dir === "" || dir === "/")
          return cb2(null);
        if (process.platform === "win32" && /^\w:[/\\]*$/.test(dir)) {
          return cb2(null);
        }
        if (/[/\\]node_modules[/\\]*$/.test(dir))
          return cb2(null);
        maybeRealpath(realpath, dir, opts, function(unwrapErr, pkgdir) {
          if (unwrapErr)
            return loadpkg(path.dirname(dir), cb2);
          var pkgfile = path.join(pkgdir, "package.json");
          isFile(pkgfile, function(err2, ex) {
            if (!ex)
              return loadpkg(path.dirname(dir), cb2);
            readPackage(readFile, pkgfile, function(err3, pkgParam) {
              if (err3)
                cb2(err3);
              var pkg = pkgParam;
              if (pkg && opts.packageFilter) {
                pkg = opts.packageFilter(pkg, pkgfile);
              }
              cb2(null, pkg, dir);
            });
          });
        });
      }
      function loadAsDirectory(x2, loadAsDirectoryPackage, callback2) {
        var cb2 = callback2;
        var fpkg = loadAsDirectoryPackage;
        if (typeof fpkg === "function") {
          cb2 = fpkg;
          fpkg = opts.package;
        }
        maybeRealpath(realpath, x2, opts, function(unwrapErr, pkgdir) {
          if (unwrapErr)
            return cb2(unwrapErr);
          var pkgfile = path.join(pkgdir, "package.json");
          isFile(pkgfile, function(err2, ex) {
            if (err2)
              return cb2(err2);
            if (!ex)
              return loadAsFile(path.join(x2, "index"), fpkg, cb2);
            readPackage(readFile, pkgfile, function(err3, pkgParam) {
              if (err3)
                return cb2(err3);
              var pkg = pkgParam;
              if (pkg && opts.packageFilter) {
                pkg = opts.packageFilter(pkg, pkgfile);
              }
              if (pkg && pkg.main) {
                if (typeof pkg.main !== "string") {
                  var mainError = new TypeError("package \u201C" + pkg.name + "\u201D `main` must be a string");
                  mainError.code = "INVALID_PACKAGE_MAIN";
                  return cb2(mainError);
                }
                if (pkg.main === "." || pkg.main === "./") {
                  pkg.main = "index";
                }
                loadAsFile(path.resolve(x2, pkg.main), pkg, function(err4, m, pkg2) {
                  if (err4)
                    return cb2(err4);
                  if (m)
                    return cb2(null, m, pkg2);
                  if (!pkg2)
                    return loadAsFile(path.join(x2, "index"), pkg2, cb2);
                  var dir = path.resolve(x2, pkg2.main);
                  loadAsDirectory(dir, pkg2, function(err5, n, pkg3) {
                    if (err5)
                      return cb2(err5);
                    if (n)
                      return cb2(null, n, pkg3);
                    loadAsFile(path.join(x2, "index"), pkg3, cb2);
                  });
                });
                return;
              }
              loadAsFile(path.join(x2, "/index"), pkg, cb2);
            });
          });
        });
      }
      function processDirs(cb2, dirs) {
        if (dirs.length === 0)
          return cb2(null, void 0);
        var dir = dirs[0];
        isDirectory(path.dirname(dir), isdir);
        function isdir(err2, isdir2) {
          if (err2)
            return cb2(err2);
          if (!isdir2)
            return processDirs(cb2, dirs.slice(1));
          loadAsFile(dir, opts.package, onfile2);
        }
        function onfile2(err2, m, pkg) {
          if (err2)
            return cb2(err2);
          if (m)
            return cb2(null, m, pkg);
          loadAsDirectory(dir, opts.package, ondir);
        }
        function ondir(err2, n, pkg) {
          if (err2)
            return cb2(err2);
          if (n)
            return cb2(null, n, pkg);
          processDirs(cb2, dirs.slice(1));
        }
      }
      function loadNodeModules(x2, start, cb2) {
        var thunk = function() {
          return getPackageCandidates(x2, start, opts);
        };
        processDirs(
          cb2,
          packageIterator ? packageIterator(x2, start, thunk, opts) : thunk()
        );
      }
    };
  }
});

// node_modules/resolve/lib/core.json
var require_core2 = __commonJS({
  "node_modules/resolve/lib/core.json"(exports2, module2) {
    module2.exports = {
      assert: true,
      "node:assert": [">= 14.18 && < 15", ">= 16"],
      "assert/strict": ">= 15",
      "node:assert/strict": ">= 16",
      async_hooks: ">= 8",
      "node:async_hooks": [">= 14.18 && < 15", ">= 16"],
      buffer_ieee754: ">= 0.5 && < 0.9.7",
      buffer: true,
      "node:buffer": [">= 14.18 && < 15", ">= 16"],
      child_process: true,
      "node:child_process": [">= 14.18 && < 15", ">= 16"],
      cluster: ">= 0.5",
      "node:cluster": [">= 14.18 && < 15", ">= 16"],
      console: true,
      "node:console": [">= 14.18 && < 15", ">= 16"],
      constants: true,
      "node:constants": [">= 14.18 && < 15", ">= 16"],
      crypto: true,
      "node:crypto": [">= 14.18 && < 15", ">= 16"],
      _debug_agent: ">= 1 && < 8",
      _debugger: "< 8",
      dgram: true,
      "node:dgram": [">= 14.18 && < 15", ">= 16"],
      diagnostics_channel: [">= 14.17 && < 15", ">= 15.1"],
      "node:diagnostics_channel": [">= 14.18 && < 15", ">= 16"],
      dns: true,
      "node:dns": [">= 14.18 && < 15", ">= 16"],
      "dns/promises": ">= 15",
      "node:dns/promises": ">= 16",
      domain: ">= 0.7.12",
      "node:domain": [">= 14.18 && < 15", ">= 16"],
      events: true,
      "node:events": [">= 14.18 && < 15", ">= 16"],
      freelist: "< 6",
      fs: true,
      "node:fs": [">= 14.18 && < 15", ">= 16"],
      "fs/promises": [">= 10 && < 10.1", ">= 14"],
      "node:fs/promises": [">= 14.18 && < 15", ">= 16"],
      _http_agent: ">= 0.11.1",
      "node:_http_agent": [">= 14.18 && < 15", ">= 16"],
      _http_client: ">= 0.11.1",
      "node:_http_client": [">= 14.18 && < 15", ">= 16"],
      _http_common: ">= 0.11.1",
      "node:_http_common": [">= 14.18 && < 15", ">= 16"],
      _http_incoming: ">= 0.11.1",
      "node:_http_incoming": [">= 14.18 && < 15", ">= 16"],
      _http_outgoing: ">= 0.11.1",
      "node:_http_outgoing": [">= 14.18 && < 15", ">= 16"],
      _http_server: ">= 0.11.1",
      "node:_http_server": [">= 14.18 && < 15", ">= 16"],
      http: true,
      "node:http": [">= 14.18 && < 15", ">= 16"],
      http2: ">= 8.8",
      "node:http2": [">= 14.18 && < 15", ">= 16"],
      https: true,
      "node:https": [">= 14.18 && < 15", ">= 16"],
      inspector: ">= 8",
      "node:inspector": [">= 14.18 && < 15", ">= 16"],
      "inspector/promises": [">= 19"],
      "node:inspector/promises": [">= 19"],
      _linklist: "< 8",
      module: true,
      "node:module": [">= 14.18 && < 15", ">= 16"],
      net: true,
      "node:net": [">= 14.18 && < 15", ">= 16"],
      "node-inspect/lib/_inspect": ">= 7.6 && < 12",
      "node-inspect/lib/internal/inspect_client": ">= 7.6 && < 12",
      "node-inspect/lib/internal/inspect_repl": ">= 7.6 && < 12",
      os: true,
      "node:os": [">= 14.18 && < 15", ">= 16"],
      path: true,
      "node:path": [">= 14.18 && < 15", ">= 16"],
      "path/posix": ">= 15.3",
      "node:path/posix": ">= 16",
      "path/win32": ">= 15.3",
      "node:path/win32": ">= 16",
      perf_hooks: ">= 8.5",
      "node:perf_hooks": [">= 14.18 && < 15", ">= 16"],
      process: ">= 1",
      "node:process": [">= 14.18 && < 15", ">= 16"],
      punycode: ">= 0.5",
      "node:punycode": [">= 14.18 && < 15", ">= 16"],
      querystring: true,
      "node:querystring": [">= 14.18 && < 15", ">= 16"],
      readline: true,
      "node:readline": [">= 14.18 && < 15", ">= 16"],
      "readline/promises": ">= 17",
      "node:readline/promises": ">= 17",
      repl: true,
      "node:repl": [">= 14.18 && < 15", ">= 16"],
      smalloc: ">= 0.11.5 && < 3",
      _stream_duplex: ">= 0.9.4",
      "node:_stream_duplex": [">= 14.18 && < 15", ">= 16"],
      _stream_transform: ">= 0.9.4",
      "node:_stream_transform": [">= 14.18 && < 15", ">= 16"],
      _stream_wrap: ">= 1.4.1",
      "node:_stream_wrap": [">= 14.18 && < 15", ">= 16"],
      _stream_passthrough: ">= 0.9.4",
      "node:_stream_passthrough": [">= 14.18 && < 15", ">= 16"],
      _stream_readable: ">= 0.9.4",
      "node:_stream_readable": [">= 14.18 && < 15", ">= 16"],
      _stream_writable: ">= 0.9.4",
      "node:_stream_writable": [">= 14.18 && < 15", ">= 16"],
      stream: true,
      "node:stream": [">= 14.18 && < 15", ">= 16"],
      "stream/consumers": ">= 16.7",
      "node:stream/consumers": ">= 16.7",
      "stream/promises": ">= 15",
      "node:stream/promises": ">= 16",
      "stream/web": ">= 16.5",
      "node:stream/web": ">= 16.5",
      string_decoder: true,
      "node:string_decoder": [">= 14.18 && < 15", ">= 16"],
      sys: [">= 0.4 && < 0.7", ">= 0.8"],
      "node:sys": [">= 14.18 && < 15", ">= 16"],
      "node:test": [">= 16.17 && < 17", ">= 18"],
      timers: true,
      "node:timers": [">= 14.18 && < 15", ">= 16"],
      "timers/promises": ">= 15",
      "node:timers/promises": ">= 16",
      _tls_common: ">= 0.11.13",
      "node:_tls_common": [">= 14.18 && < 15", ">= 16"],
      _tls_legacy: ">= 0.11.3 && < 10",
      _tls_wrap: ">= 0.11.3",
      "node:_tls_wrap": [">= 14.18 && < 15", ">= 16"],
      tls: true,
      "node:tls": [">= 14.18 && < 15", ">= 16"],
      trace_events: ">= 10",
      "node:trace_events": [">= 14.18 && < 15", ">= 16"],
      tty: true,
      "node:tty": [">= 14.18 && < 15", ">= 16"],
      url: true,
      "node:url": [">= 14.18 && < 15", ">= 16"],
      util: true,
      "node:util": [">= 14.18 && < 15", ">= 16"],
      "util/types": ">= 15.3",
      "node:util/types": ">= 16",
      "v8/tools/arguments": ">= 10 && < 12",
      "v8/tools/codemap": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/consarray": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/csvparser": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/logreader": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/profile_view": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/splaytree": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      v8: ">= 1",
      "node:v8": [">= 14.18 && < 15", ">= 16"],
      vm: true,
      "node:vm": [">= 14.18 && < 15", ">= 16"],
      wasi: ">= 13.4 && < 13.5",
      worker_threads: ">= 11.7",
      "node:worker_threads": [">= 14.18 && < 15", ">= 16"],
      zlib: ">= 0.5",
      "node:zlib": [">= 14.18 && < 15", ">= 16"]
    };
  }
});

// node_modules/resolve/lib/core.js
var require_core3 = __commonJS({
  "node_modules/resolve/lib/core.js"(exports2, module2) {
    "use strict";
    var isCoreModule = require_is_core_module();
    var data = require_core2();
    var core = {};
    for (mod in data) {
      if (Object.prototype.hasOwnProperty.call(data, mod)) {
        core[mod] = isCoreModule(mod);
      }
    }
    var mod;
    module2.exports = core;
  }
});

// node_modules/resolve/lib/is-core.js
var require_is_core = __commonJS({
  "node_modules/resolve/lib/is-core.js"(exports2, module2) {
    var isCoreModule = require_is_core_module();
    module2.exports = function isCore(x) {
      return isCoreModule(x);
    };
  }
});

// node_modules/resolve/lib/sync.js
var require_sync = __commonJS({
  "node_modules/resolve/lib/sync.js"(exports2, module2) {
    var isCore = require_is_core_module();
    var fs = require("fs");
    var path = require("path");
    var getHomedir = require_homedir();
    var caller = require_caller();
    var nodeModulesPaths = require_node_modules_paths();
    var normalizeOptions = require_normalize_options();
    var realpathFS = process.platform !== "win32" && fs.realpathSync && typeof fs.realpathSync.native === "function" ? fs.realpathSync.native : fs.realpathSync;
    var homedir = getHomedir();
    var defaultPaths = function() {
      return [
        path.join(homedir, ".node_modules"),
        path.join(homedir, ".node_libraries")
      ];
    };
    var defaultIsFile = function isFile(file) {
      try {
        var stat = fs.statSync(file, { throwIfNoEntry: false });
      } catch (e) {
        if (e && (e.code === "ENOENT" || e.code === "ENOTDIR"))
          return false;
        throw e;
      }
      return !!stat && (stat.isFile() || stat.isFIFO());
    };
    var defaultIsDir = function isDirectory(dir) {
      try {
        var stat = fs.statSync(dir, { throwIfNoEntry: false });
      } catch (e) {
        if (e && (e.code === "ENOENT" || e.code === "ENOTDIR"))
          return false;
        throw e;
      }
      return !!stat && stat.isDirectory();
    };
    var defaultRealpathSync = function realpathSync(x) {
      try {
        return realpathFS(x);
      } catch (realpathErr) {
        if (realpathErr.code !== "ENOENT") {
          throw realpathErr;
        }
      }
      return x;
    };
    var maybeRealpathSync = function maybeRealpathSync2(realpathSync, x, opts) {
      if (opts && opts.preserveSymlinks === false) {
        return realpathSync(x);
      }
      return x;
    };
    var defaultReadPackageSync = function defaultReadPackageSync2(readFileSync, pkgfile) {
      var body = readFileSync(pkgfile);
      try {
        var pkg = JSON.parse(body);
        return pkg;
      } catch (jsonErr) {
      }
    };
    var getPackageCandidates = function getPackageCandidates2(x, start, opts) {
      var dirs = nodeModulesPaths(start, opts, x);
      for (var i = 0; i < dirs.length; i++) {
        dirs[i] = path.join(dirs[i], x);
      }
      return dirs;
    };
    module2.exports = function resolveSync(x, options) {
      if (typeof x !== "string") {
        throw new TypeError("Path must be a string.");
      }
      var opts = normalizeOptions(x, options);
      var isFile = opts.isFile || defaultIsFile;
      var readFileSync = opts.readFileSync || fs.readFileSync;
      var isDirectory = opts.isDirectory || defaultIsDir;
      var realpathSync = opts.realpathSync || defaultRealpathSync;
      var readPackageSync = opts.readPackageSync || defaultReadPackageSync;
      if (opts.readFileSync && opts.readPackageSync) {
        throw new TypeError("`readFileSync` and `readPackageSync` are mutually exclusive.");
      }
      var packageIterator = opts.packageIterator;
      var extensions = opts.extensions || [".js"];
      var includeCoreModules = opts.includeCoreModules !== false;
      var basedir = opts.basedir || path.dirname(caller());
      var parent = opts.filename || basedir;
      opts.paths = opts.paths || defaultPaths();
      var absoluteStart = maybeRealpathSync(realpathSync, path.resolve(basedir), opts);
      if (/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/.test(x)) {
        var res = path.resolve(absoluteStart, x);
        if (x === "." || x === ".." || x.slice(-1) === "/")
          res += "/";
        var m = loadAsFileSync(res) || loadAsDirectorySync(res);
        if (m)
          return maybeRealpathSync(realpathSync, m, opts);
      } else if (includeCoreModules && isCore(x)) {
        return x;
      } else {
        var n = loadNodeModulesSync(x, absoluteStart);
        if (n)
          return maybeRealpathSync(realpathSync, n, opts);
      }
      var err = new Error("Cannot find module '" + x + "' from '" + parent + "'");
      err.code = "MODULE_NOT_FOUND";
      throw err;
      function loadAsFileSync(x2) {
        var pkg = loadpkg(path.dirname(x2));
        if (pkg && pkg.dir && pkg.pkg && opts.pathFilter) {
          var rfile = path.relative(pkg.dir, x2);
          var r = opts.pathFilter(pkg.pkg, x2, rfile);
          if (r) {
            x2 = path.resolve(pkg.dir, r);
          }
        }
        if (isFile(x2)) {
          return x2;
        }
        for (var i = 0; i < extensions.length; i++) {
          var file = x2 + extensions[i];
          if (isFile(file)) {
            return file;
          }
        }
      }
      function loadpkg(dir) {
        if (dir === "" || dir === "/")
          return;
        if (process.platform === "win32" && /^\w:[/\\]*$/.test(dir)) {
          return;
        }
        if (/[/\\]node_modules[/\\]*$/.test(dir))
          return;
        var pkgfile = path.join(maybeRealpathSync(realpathSync, dir, opts), "package.json");
        if (!isFile(pkgfile)) {
          return loadpkg(path.dirname(dir));
        }
        var pkg = readPackageSync(readFileSync, pkgfile);
        if (pkg && opts.packageFilter) {
          pkg = opts.packageFilter(
            pkg,
            /*pkgfile,*/
            dir
          );
        }
        return { pkg, dir };
      }
      function loadAsDirectorySync(x2) {
        var pkgfile = path.join(maybeRealpathSync(realpathSync, x2, opts), "/package.json");
        if (isFile(pkgfile)) {
          try {
            var pkg = readPackageSync(readFileSync, pkgfile);
          } catch (e) {
          }
          if (pkg && opts.packageFilter) {
            pkg = opts.packageFilter(
              pkg,
              /*pkgfile,*/
              x2
            );
          }
          if (pkg && pkg.main) {
            if (typeof pkg.main !== "string") {
              var mainError = new TypeError("package \u201C" + pkg.name + "\u201D `main` must be a string");
              mainError.code = "INVALID_PACKAGE_MAIN";
              throw mainError;
            }
            if (pkg.main === "." || pkg.main === "./") {
              pkg.main = "index";
            }
            try {
              var m2 = loadAsFileSync(path.resolve(x2, pkg.main));
              if (m2)
                return m2;
              var n2 = loadAsDirectorySync(path.resolve(x2, pkg.main));
              if (n2)
                return n2;
            } catch (e) {
            }
          }
        }
        return loadAsFileSync(path.join(x2, "/index"));
      }
      function loadNodeModulesSync(x2, start) {
        var thunk = function() {
          return getPackageCandidates(x2, start, opts);
        };
        var dirs = packageIterator ? packageIterator(x2, start, thunk, opts) : thunk();
        for (var i = 0; i < dirs.length; i++) {
          var dir = dirs[i];
          if (isDirectory(path.dirname(dir))) {
            var m2 = loadAsFileSync(dir);
            if (m2)
              return m2;
            var n2 = loadAsDirectorySync(dir);
            if (n2)
              return n2;
          }
        }
      }
    };
  }
});

// node_modules/resolve/index.js
var require_resolve = __commonJS({
  "node_modules/resolve/index.js"(exports2, module2) {
    var async = require_async();
    async.core = require_core3();
    async.isCore = require_is_core();
    async.sync = require_sync();
    module2.exports = async;
  }
});

// node_modules/postcss-import/lib/resolve-id.js
var require_resolve_id = __commonJS({
  "node_modules/postcss-import/lib/resolve-id.js"(exports2, module2) {
    "use strict";
    var resolve = require_resolve();
    var moduleDirectories = ["web_modules", "node_modules"];
    function resolveModule(id, opts) {
      return new Promise((res, rej) => {
        resolve(id, opts, (err, path) => err ? rej(err) : res(path));
      });
    }
    module2.exports = function(id, base, options) {
      const paths = options.path;
      const resolveOpts = {
        basedir: base,
        moduleDirectory: moduleDirectories.concat(options.addModulesDirectories),
        paths,
        extensions: [".css"],
        packageFilter: function processPackage(pkg) {
          if (pkg.style)
            pkg.main = pkg.style;
          else if (!pkg.main || !/\.css$/.test(pkg.main))
            pkg.main = "index.css";
          return pkg;
        },
        preserveSymlinks: false
      };
      return resolveModule(`./${id}`, resolveOpts).catch(() => resolveModule(id, resolveOpts)).catch(() => {
        if (paths.indexOf(base) === -1)
          paths.unshift(base);
        throw new Error(
          `Failed to find '${id}'
  in [
    ${paths.join(",\n        ")}
  ]`
        );
      });
    };
  }
});

// node_modules/pify/index.js
var require_pify = __commonJS({
  "node_modules/pify/index.js"(exports2, module2) {
    "use strict";
    var processFn = function(fn, P, opts) {
      return function() {
        var that = this;
        var args = new Array(arguments.length);
        for (var i = 0; i < arguments.length; i++) {
          args[i] = arguments[i];
        }
        return new P(function(resolve, reject) {
          args.push(function(err, result) {
            if (err) {
              reject(err);
            } else if (opts.multiArgs) {
              var results = new Array(arguments.length - 1);
              for (var i2 = 1; i2 < arguments.length; i2++) {
                results[i2 - 1] = arguments[i2];
              }
              resolve(results);
            } else {
              resolve(result);
            }
          });
          fn.apply(that, args);
        });
      };
    };
    var pify = module2.exports = function(obj, P, opts) {
      if (typeof P !== "function") {
        opts = P;
        P = Promise;
      }
      opts = opts || {};
      opts.exclude = opts.exclude || [/.+Sync$/];
      var filter = function(key) {
        var match = function(pattern) {
          return typeof pattern === "string" ? key === pattern : pattern.test(key);
        };
        return opts.include ? opts.include.some(match) : !opts.exclude.some(match);
      };
      var ret = typeof obj === "function" ? function() {
        if (opts.excludeMain) {
          return obj.apply(this, arguments);
        }
        return processFn(obj, P, opts).apply(this, arguments);
      } : {};
      return Object.keys(obj).reduce(function(ret2, key) {
        var x = obj[key];
        ret2[key] = typeof x === "function" && filter(key) ? processFn(x, P, opts) : x;
        return ret2;
      }, ret);
    };
    pify.all = pify;
  }
});

// node_modules/read-cache/index.js
var require_read_cache = __commonJS({
  "node_modules/read-cache/index.js"(exports2, module2) {
    var fs = require("fs");
    var path = require("path");
    var pify = require_pify();
    var stat = pify(fs.stat);
    var readFile = pify(fs.readFile);
    var resolve = path.resolve;
    var cache = /* @__PURE__ */ Object.create(null);
    function convert(content, encoding) {
      if (Buffer.isEncoding(encoding)) {
        return content.toString(encoding);
      }
      return content;
    }
    module2.exports = function(path2, encoding) {
      path2 = resolve(path2);
      return stat(path2).then(function(stats) {
        var item = cache[path2];
        if (item && item.mtime.getTime() === stats.mtime.getTime()) {
          return convert(item.content, encoding);
        }
        return readFile(path2).then(function(data) {
          cache[path2] = {
            mtime: stats.mtime,
            content: data
          };
          return convert(data, encoding);
        });
      }).catch(function(err) {
        cache[path2] = null;
        return Promise.reject(err);
      });
    };
    module2.exports.sync = function(path2, encoding) {
      path2 = resolve(path2);
      try {
        var stats = fs.statSync(path2);
        var item = cache[path2];
        if (item && item.mtime.getTime() === stats.mtime.getTime()) {
          return convert(item.content, encoding);
        }
        var data = fs.readFileSync(path2);
        cache[path2] = {
          mtime: stats.mtime,
          content: data
        };
        return convert(data, encoding);
      } catch (err) {
        cache[path2] = null;
        throw err;
      }
    };
    module2.exports.get = function(path2, encoding) {
      path2 = resolve(path2);
      if (cache[path2]) {
        return convert(cache[path2].content, encoding);
      }
      return null;
    };
    module2.exports.clear = function() {
      cache = /* @__PURE__ */ Object.create(null);
    };
  }
});

// node_modules/postcss-import/lib/data-url.js
var require_data_url = __commonJS({
  "node_modules/postcss-import/lib/data-url.js"(exports2, module2) {
    "use strict";
    var dataURLRegexp = /^data:text\/css;base64,/i;
    function isValid(url) {
      return dataURLRegexp.test(url);
    }
    function contents(url) {
      return Buffer.from(url.slice(21), "base64").toString();
    }
    module2.exports = {
      isValid,
      contents
    };
  }
});

// node_modules/postcss-import/lib/load-content.js
var require_load_content = __commonJS({
  "node_modules/postcss-import/lib/load-content.js"(exports2, module2) {
    "use strict";
    var readCache = require_read_cache();
    var dataURL = require_data_url();
    module2.exports = (filename) => {
      if (dataURL.isValid(filename)) {
        return dataURL.contents(filename);
      }
      return readCache(filename, "utf-8");
    };
  }
});

// node_modules/postcss-import/lib/process-content.js
var require_process_content = __commonJS({
  "node_modules/postcss-import/lib/process-content.js"(exports2, module2) {
    "use strict";
    var path = require("path");
    var sugarss;
    module2.exports = function processContent(result, content, filename, options, postcss) {
      const { plugins } = options;
      const ext = path.extname(filename);
      const parserList = [];
      if (ext === ".sss") {
        if (!sugarss) {
          try {
            sugarss = require("sugarss");
          } catch {
          }
        }
        if (sugarss)
          return runPostcss(postcss, content, filename, plugins, [sugarss]);
      }
      if (result.opts.syntax?.parse) {
        parserList.push(result.opts.syntax.parse);
      }
      if (result.opts.parser)
        parserList.push(result.opts.parser);
      parserList.push(null);
      return runPostcss(postcss, content, filename, plugins, parserList);
    };
    function runPostcss(postcss, content, filename, plugins, parsers, index) {
      if (!index)
        index = 0;
      return postcss(plugins).process(content, {
        from: filename,
        parser: parsers[index]
      }).catch((err) => {
        index++;
        if (index === parsers.length)
          throw err;
        return runPostcss(postcss, content, filename, plugins, parsers, index);
      });
    }
  }
});

// node_modules/postcss-value-parser/lib/parse.js
var require_parse2 = __commonJS({
  "node_modules/postcss-value-parser/lib/parse.js"(exports2, module2) {
    var openParentheses = "(".charCodeAt(0);
    var closeParentheses = ")".charCodeAt(0);
    var singleQuote = "'".charCodeAt(0);
    var doubleQuote = '"'.charCodeAt(0);
    var backslash = "\\".charCodeAt(0);
    var slash = "/".charCodeAt(0);
    var comma = ",".charCodeAt(0);
    var colon = ":".charCodeAt(0);
    var star = "*".charCodeAt(0);
    var uLower = "u".charCodeAt(0);
    var uUpper = "U".charCodeAt(0);
    var plus = "+".charCodeAt(0);
    var isUnicodeRange = /^[a-f0-9?-]+$/i;
    module2.exports = function(input) {
      var tokens = [];
      var value = input;
      var next, quote, prev, token, escape, escapePos, whitespacePos, parenthesesOpenPos;
      var pos = 0;
      var code = value.charCodeAt(pos);
      var max = value.length;
      var stack = [{ nodes: tokens }];
      var balanced = 0;
      var parent;
      var name = "";
      var before = "";
      var after = "";
      while (pos < max) {
        if (code <= 32) {
          next = pos;
          do {
            next += 1;
            code = value.charCodeAt(next);
          } while (code <= 32);
          token = value.slice(pos, next);
          prev = tokens[tokens.length - 1];
          if (code === closeParentheses && balanced) {
            after = token;
          } else if (prev && prev.type === "div") {
            prev.after = token;
            prev.sourceEndIndex += token.length;
          } else if (code === comma || code === colon || code === slash && value.charCodeAt(next + 1) !== star && (!parent || parent && parent.type === "function" && parent.value !== "calc")) {
            before = token;
          } else {
            tokens.push({
              type: "space",
              sourceIndex: pos,
              sourceEndIndex: next,
              value: token
            });
          }
          pos = next;
        } else if (code === singleQuote || code === doubleQuote) {
          next = pos;
          quote = code === singleQuote ? "'" : '"';
          token = {
            type: "string",
            sourceIndex: pos,
            quote
          };
          do {
            escape = false;
            next = value.indexOf(quote, next + 1);
            if (~next) {
              escapePos = next;
              while (value.charCodeAt(escapePos - 1) === backslash) {
                escapePos -= 1;
                escape = !escape;
              }
            } else {
              value += quote;
              next = value.length - 1;
              token.unclosed = true;
            }
          } while (escape);
          token.value = value.slice(pos + 1, next);
          token.sourceEndIndex = token.unclosed ? next : next + 1;
          tokens.push(token);
          pos = next + 1;
          code = value.charCodeAt(pos);
        } else if (code === slash && value.charCodeAt(pos + 1) === star) {
          next = value.indexOf("*/", pos);
          token = {
            type: "comment",
            sourceIndex: pos,
            sourceEndIndex: next + 2
          };
          if (next === -1) {
            token.unclosed = true;
            next = value.length;
            token.sourceEndIndex = next;
          }
          token.value = value.slice(pos + 2, next);
          tokens.push(token);
          pos = next + 2;
          code = value.charCodeAt(pos);
        } else if ((code === slash || code === star) && parent && parent.type === "function" && parent.value === "calc") {
          token = value[pos];
          tokens.push({
            type: "word",
            sourceIndex: pos - before.length,
            sourceEndIndex: pos + token.length,
            value: token
          });
          pos += 1;
          code = value.charCodeAt(pos);
        } else if (code === slash || code === comma || code === colon) {
          token = value[pos];
          tokens.push({
            type: "div",
            sourceIndex: pos - before.length,
            sourceEndIndex: pos + token.length,
            value: token,
            before,
            after: ""
          });
          before = "";
          pos += 1;
          code = value.charCodeAt(pos);
        } else if (openParentheses === code) {
          next = pos;
          do {
            next += 1;
            code = value.charCodeAt(next);
          } while (code <= 32);
          parenthesesOpenPos = pos;
          token = {
            type: "function",
            sourceIndex: pos - name.length,
            value: name,
            before: value.slice(parenthesesOpenPos + 1, next)
          };
          pos = next;
          if (name === "url" && code !== singleQuote && code !== doubleQuote) {
            next -= 1;
            do {
              escape = false;
              next = value.indexOf(")", next + 1);
              if (~next) {
                escapePos = next;
                while (value.charCodeAt(escapePos - 1) === backslash) {
                  escapePos -= 1;
                  escape = !escape;
                }
              } else {
                value += ")";
                next = value.length - 1;
                token.unclosed = true;
              }
            } while (escape);
            whitespacePos = next;
            do {
              whitespacePos -= 1;
              code = value.charCodeAt(whitespacePos);
            } while (code <= 32);
            if (parenthesesOpenPos < whitespacePos) {
              if (pos !== whitespacePos + 1) {
                token.nodes = [
                  {
                    type: "word",
                    sourceIndex: pos,
                    sourceEndIndex: whitespacePos + 1,
                    value: value.slice(pos, whitespacePos + 1)
                  }
                ];
              } else {
                token.nodes = [];
              }
              if (token.unclosed && whitespacePos + 1 !== next) {
                token.after = "";
                token.nodes.push({
                  type: "space",
                  sourceIndex: whitespacePos + 1,
                  sourceEndIndex: next,
                  value: value.slice(whitespacePos + 1, next)
                });
              } else {
                token.after = value.slice(whitespacePos + 1, next);
                token.sourceEndIndex = next;
              }
            } else {
              token.after = "";
              token.nodes = [];
            }
            pos = next + 1;
            token.sourceEndIndex = token.unclosed ? next : pos;
            code = value.charCodeAt(pos);
            tokens.push(token);
          } else {
            balanced += 1;
            token.after = "";
            token.sourceEndIndex = pos + 1;
            tokens.push(token);
            stack.push(token);
            tokens = token.nodes = [];
            parent = token;
          }
          name = "";
        } else if (closeParentheses === code && balanced) {
          pos += 1;
          code = value.charCodeAt(pos);
          parent.after = after;
          parent.sourceEndIndex += after.length;
          after = "";
          balanced -= 1;
          stack[stack.length - 1].sourceEndIndex = pos;
          stack.pop();
          parent = stack[balanced];
          tokens = parent.nodes;
        } else {
          next = pos;
          do {
            if (code === backslash) {
              next += 1;
            }
            next += 1;
            code = value.charCodeAt(next);
          } while (next < max && !(code <= 32 || code === singleQuote || code === doubleQuote || code === comma || code === colon || code === slash || code === openParentheses || code === star && parent && parent.type === "function" && parent.value === "calc" || code === slash && parent.type === "function" && parent.value === "calc" || code === closeParentheses && balanced));
          token = value.slice(pos, next);
          if (openParentheses === code) {
            name = token;
          } else if ((uLower === token.charCodeAt(0) || uUpper === token.charCodeAt(0)) && plus === token.charCodeAt(1) && isUnicodeRange.test(token.slice(2))) {
            tokens.push({
              type: "unicode-range",
              sourceIndex: pos,
              sourceEndIndex: next,
              value: token
            });
          } else {
            tokens.push({
              type: "word",
              sourceIndex: pos,
              sourceEndIndex: next,
              value: token
            });
          }
          pos = next;
        }
      }
      for (pos = stack.length - 1; pos; pos -= 1) {
        stack[pos].unclosed = true;
        stack[pos].sourceEndIndex = value.length;
      }
      return stack[0].nodes;
    };
  }
});

// node_modules/postcss-value-parser/lib/walk.js
var require_walk = __commonJS({
  "node_modules/postcss-value-parser/lib/walk.js"(exports2, module2) {
    module2.exports = function walk(nodes, cb, bubble) {
      var i, max, node, result;
      for (i = 0, max = nodes.length; i < max; i += 1) {
        node = nodes[i];
        if (!bubble) {
          result = cb(node, i, nodes);
        }
        if (result !== false && node.type === "function" && Array.isArray(node.nodes)) {
          walk(node.nodes, cb, bubble);
        }
        if (bubble) {
          cb(node, i, nodes);
        }
      }
    };
  }
});

// node_modules/postcss-value-parser/lib/stringify.js
var require_stringify2 = __commonJS({
  "node_modules/postcss-value-parser/lib/stringify.js"(exports2, module2) {
    function stringifyNode(node, custom) {
      var type = node.type;
      var value = node.value;
      var buf;
      var customResult;
      if (custom && (customResult = custom(node)) !== void 0) {
        return customResult;
      } else if (type === "word" || type === "space") {
        return value;
      } else if (type === "string") {
        buf = node.quote || "";
        return buf + value + (node.unclosed ? "" : buf);
      } else if (type === "comment") {
        return "/*" + value + (node.unclosed ? "" : "*/");
      } else if (type === "div") {
        return (node.before || "") + value + (node.after || "");
      } else if (Array.isArray(node.nodes)) {
        buf = stringify(node.nodes, custom);
        if (type !== "function") {
          return buf;
        }
        return value + "(" + (node.before || "") + buf + (node.after || "") + (node.unclosed ? "" : ")");
      }
      return value;
    }
    function stringify(nodes, custom) {
      var result, i;
      if (Array.isArray(nodes)) {
        result = "";
        for (i = nodes.length - 1; ~i; i -= 1) {
          result = stringifyNode(nodes[i], custom) + result;
        }
        return result;
      }
      return stringifyNode(nodes, custom);
    }
    module2.exports = stringify;
  }
});

// node_modules/postcss-value-parser/lib/unit.js
var require_unit = __commonJS({
  "node_modules/postcss-value-parser/lib/unit.js"(exports2, module2) {
    var minus = "-".charCodeAt(0);
    var plus = "+".charCodeAt(0);
    var dot = ".".charCodeAt(0);
    var exp = "e".charCodeAt(0);
    var EXP = "E".charCodeAt(0);
    function likeNumber(value) {
      var code = value.charCodeAt(0);
      var nextCode;
      if (code === plus || code === minus) {
        nextCode = value.charCodeAt(1);
        if (nextCode >= 48 && nextCode <= 57) {
          return true;
        }
        var nextNextCode = value.charCodeAt(2);
        if (nextCode === dot && nextNextCode >= 48 && nextNextCode <= 57) {
          return true;
        }
        return false;
      }
      if (code === dot) {
        nextCode = value.charCodeAt(1);
        if (nextCode >= 48 && nextCode <= 57) {
          return true;
        }
        return false;
      }
      if (code >= 48 && code <= 57) {
        return true;
      }
      return false;
    }
    module2.exports = function(value) {
      var pos = 0;
      var length = value.length;
      var code;
      var nextCode;
      var nextNextCode;
      if (length === 0 || !likeNumber(value)) {
        return false;
      }
      code = value.charCodeAt(pos);
      if (code === plus || code === minus) {
        pos++;
      }
      while (pos < length) {
        code = value.charCodeAt(pos);
        if (code < 48 || code > 57) {
          break;
        }
        pos += 1;
      }
      code = value.charCodeAt(pos);
      nextCode = value.charCodeAt(pos + 1);
      if (code === dot && nextCode >= 48 && nextCode <= 57) {
        pos += 2;
        while (pos < length) {
          code = value.charCodeAt(pos);
          if (code < 48 || code > 57) {
            break;
          }
          pos += 1;
        }
      }
      code = value.charCodeAt(pos);
      nextCode = value.charCodeAt(pos + 1);
      nextNextCode = value.charCodeAt(pos + 2);
      if ((code === exp || code === EXP) && (nextCode >= 48 && nextCode <= 57 || (nextCode === plus || nextCode === minus) && nextNextCode >= 48 && nextNextCode <= 57)) {
        pos += nextCode === plus || nextCode === minus ? 3 : 2;
        while (pos < length) {
          code = value.charCodeAt(pos);
          if (code < 48 || code > 57) {
            break;
          }
          pos += 1;
        }
      }
      return {
        number: value.slice(0, pos),
        unit: value.slice(pos)
      };
    };
  }
});

// node_modules/postcss-value-parser/lib/index.js
var require_lib = __commonJS({
  "node_modules/postcss-value-parser/lib/index.js"(exports2, module2) {
    var parse = require_parse2();
    var walk = require_walk();
    var stringify = require_stringify2();
    function ValueParser(value) {
      if (this instanceof ValueParser) {
        this.nodes = parse(value);
        return this;
      }
      return new ValueParser(value);
    }
    ValueParser.prototype.toString = function() {
      return Array.isArray(this.nodes) ? stringify(this.nodes) : "";
    };
    ValueParser.prototype.walk = function(cb, bubble) {
      walk(this.nodes, cb, bubble);
      return this;
    };
    ValueParser.unit = require_unit();
    ValueParser.walk = walk;
    ValueParser.stringify = stringify;
    module2.exports = ValueParser;
  }
});

// node_modules/postcss-import/lib/parse-statements.js
var require_parse_statements = __commonJS({
  "node_modules/postcss-import/lib/parse-statements.js"(exports2, module2) {
    "use strict";
    var valueParser = require_lib();
    var { stringify } = valueParser;
    function split(params, start) {
      const list = [];
      const last = params.reduce((item, node, index) => {
        if (index < start)
          return "";
        if (node.type === "div" && node.value === ",") {
          list.push(item);
          return "";
        }
        return item + stringify(node);
      }, "");
      list.push(last);
      return list;
    }
    module2.exports = function(result, styles) {
      const statements = [];
      let nodes = [];
      styles.each((node) => {
        let stmt;
        if (node.type === "atrule") {
          if (node.name === "import")
            stmt = parseImport(result, node);
          else if (node.name === "media")
            stmt = parseMedia(result, node);
          else if (node.name === "charset")
            stmt = parseCharset(result, node);
        }
        if (stmt) {
          if (nodes.length) {
            statements.push({
              type: "nodes",
              nodes,
              media: [],
              layer: []
            });
            nodes = [];
          }
          statements.push(stmt);
        } else
          nodes.push(node);
      });
      if (nodes.length) {
        statements.push({
          type: "nodes",
          nodes,
          media: [],
          layer: []
        });
      }
      return statements;
    };
    function parseMedia(result, atRule) {
      const params = valueParser(atRule.params).nodes;
      return {
        type: "media",
        node: atRule,
        media: split(params, 0),
        layer: []
      };
    }
    function parseCharset(result, atRule) {
      if (atRule.prev()) {
        return result.warn("@charset must precede all other statements", {
          node: atRule
        });
      }
      return {
        type: "charset",
        node: atRule,
        media: [],
        layer: []
      };
    }
    function parseImport(result, atRule) {
      let prev = atRule.prev();
      if (prev) {
        do {
          if (prev.type !== "comment" && (prev.type !== "atrule" || prev.name !== "import" && prev.name !== "charset" && !(prev.name === "layer" && !prev.nodes))) {
            return result.warn(
              "@import must precede all other statements (besides @charset or empty @layer)",
              { node: atRule }
            );
          }
          prev = prev.prev();
        } while (prev);
      }
      if (atRule.nodes) {
        return result.warn(
          "It looks like you didn't end your @import statement correctly. Child nodes are attached to it.",
          { node: atRule }
        );
      }
      const params = valueParser(atRule.params).nodes;
      const stmt = {
        type: "import",
        node: atRule,
        media: [],
        layer: []
      };
      if (!params.length || (params[0].type !== "string" || !params[0].value) && (params[0].type !== "function" || params[0].value !== "url" || !params[0].nodes.length || !params[0].nodes[0].value)) {
        return result.warn(`Unable to find uri in '${atRule.toString()}'`, {
          node: atRule
        });
      }
      if (params[0].type === "string")
        stmt.uri = params[0].value;
      else
        stmt.uri = params[0].nodes[0].value;
      stmt.fullUri = stringify(params[0]);
      let remainder = params;
      if (remainder.length > 2) {
        if ((remainder[2].type === "word" || remainder[2].type === "function") && remainder[2].value === "layer") {
          if (remainder[1].type !== "space") {
            return result.warn("Invalid import layer statement", { node: atRule });
          }
          if (remainder[2].nodes) {
            stmt.layer = [stringify(remainder[2].nodes)];
          } else {
            stmt.layer = [""];
          }
          remainder = remainder.slice(2);
        }
      }
      if (remainder.length > 2) {
        if (remainder[1].type !== "space") {
          return result.warn("Invalid import media statement", { node: atRule });
        }
        stmt.media = split(remainder, 2);
      }
      return stmt;
    }
  }
});

// node_modules/postcss-import/lib/assign-layer-names.js
var require_assign_layer_names = __commonJS({
  "node_modules/postcss-import/lib/assign-layer-names.js"(exports2, module2) {
    "use strict";
    module2.exports = function(layer, node, state, options) {
      layer.forEach((layerPart, i) => {
        if (layerPart.trim() === "") {
          if (options.nameLayer) {
            layer[i] = options.nameLayer(state.anonymousLayerCounter++, state.rootFilename).toString();
          } else {
            throw node.error(
              `When using anonymous layers in @import you must also set the "nameLayer" plugin option`
            );
          }
        }
      });
    };
  }
});

// node_modules/postcss-import/index.js
var require_postcss_import = __commonJS({
  "node_modules/postcss-import/index.js"(exports2, module2) {
    "use strict";
    var path = require("path");
    var joinMedia = require_join_media();
    var joinLayer = require_join_layer();
    var resolveId = require_resolve_id();
    var loadContent = require_load_content();
    var processContent = require_process_content();
    var parseStatements = require_parse_statements();
    var assignLayerNames = require_assign_layer_names();
    var dataURL = require_data_url();
    function AtImport(options) {
      options = {
        root: process.cwd(),
        path: [],
        skipDuplicates: true,
        resolve: resolveId,
        load: loadContent,
        plugins: [],
        addModulesDirectories: [],
        nameLayer: null,
        ...options
      };
      options.root = path.resolve(options.root);
      if (typeof options.path === "string")
        options.path = [options.path];
      if (!Array.isArray(options.path))
        options.path = [];
      options.path = options.path.map((p) => path.resolve(options.root, p));
      return {
        postcssPlugin: "postcss-import",
        Once(styles, { result, atRule, postcss }) {
          const state = {
            importedFiles: {},
            hashFiles: {},
            rootFilename: null,
            anonymousLayerCounter: 0
          };
          if (styles.source?.input?.file) {
            state.rootFilename = styles.source.input.file;
            state.importedFiles[styles.source.input.file] = {};
          }
          if (options.plugins && !Array.isArray(options.plugins)) {
            throw new Error("plugins option must be an array");
          }
          if (options.nameLayer && typeof options.nameLayer !== "function") {
            throw new Error("nameLayer option must be a function");
          }
          return parseStyles(result, styles, options, state, [], []).then(
            (bundle) => {
              applyRaws(bundle);
              applyMedia(bundle);
              applyStyles(bundle, styles);
            }
          );
          function applyRaws(bundle) {
            bundle.forEach((stmt, index) => {
              if (index === 0)
                return;
              if (stmt.parent) {
                const { before } = stmt.parent.node.raws;
                if (stmt.type === "nodes")
                  stmt.nodes[0].raws.before = before;
                else
                  stmt.node.raws.before = before;
              } else if (stmt.type === "nodes") {
                stmt.nodes[0].raws.before = stmt.nodes[0].raws.before || "\n";
              }
            });
          }
          function applyMedia(bundle) {
            bundle.forEach((stmt) => {
              if (!stmt.media.length && !stmt.layer.length || stmt.type === "charset") {
                return;
              }
              if (stmt.layer.length > 1) {
                assignLayerNames(stmt.layer, stmt.node, state, options);
              }
              if (stmt.type === "import") {
                const parts = [stmt.fullUri];
                const media = stmt.media.join(", ");
                if (stmt.layer.length) {
                  const layerName = stmt.layer.join(".");
                  let layerParams = "layer";
                  if (layerName) {
                    layerParams = `layer(${layerName})`;
                  }
                  parts.push(layerParams);
                }
                if (media) {
                  parts.push(media);
                }
                stmt.node.params = parts.join(" ");
              } else if (stmt.type === "media") {
                if (stmt.layer.length) {
                  const layerNode = atRule({
                    name: "layer",
                    params: stmt.layer.join("."),
                    source: stmt.node.source
                  });
                  if (stmt.parentMedia?.length) {
                    const mediaNode = atRule({
                      name: "media",
                      params: stmt.parentMedia.join(", "),
                      source: stmt.node.source
                    });
                    mediaNode.append(layerNode);
                    layerNode.append(stmt.node);
                    stmt.node = mediaNode;
                  } else {
                    layerNode.append(stmt.node);
                    stmt.node = layerNode;
                  }
                } else {
                  stmt.node.params = stmt.media.join(", ");
                }
              } else {
                const { nodes } = stmt;
                const { parent } = nodes[0];
                let outerAtRule;
                let innerAtRule;
                if (stmt.media.length && stmt.layer.length) {
                  const mediaNode = atRule({
                    name: "media",
                    params: stmt.media.join(", "),
                    source: parent.source
                  });
                  const layerNode = atRule({
                    name: "layer",
                    params: stmt.layer.join("."),
                    source: parent.source
                  });
                  mediaNode.append(layerNode);
                  innerAtRule = layerNode;
                  outerAtRule = mediaNode;
                } else if (stmt.media.length) {
                  const mediaNode = atRule({
                    name: "media",
                    params: stmt.media.join(", "),
                    source: parent.source
                  });
                  innerAtRule = mediaNode;
                  outerAtRule = mediaNode;
                } else if (stmt.layer.length) {
                  const layerNode = atRule({
                    name: "layer",
                    params: stmt.layer.join("."),
                    source: parent.source
                  });
                  innerAtRule = layerNode;
                  outerAtRule = layerNode;
                }
                parent.insertBefore(nodes[0], outerAtRule);
                nodes.forEach((node) => {
                  node.parent = void 0;
                });
                nodes[0].raws.before = nodes[0].raws.before || "\n";
                innerAtRule.append(nodes);
                stmt.type = "media";
                stmt.node = outerAtRule;
                delete stmt.nodes;
              }
            });
          }
          function applyStyles(bundle, styles2) {
            styles2.nodes = [];
            bundle.forEach((stmt) => {
              if (["charset", "import", "media"].includes(stmt.type)) {
                stmt.node.parent = void 0;
                styles2.append(stmt.node);
              } else if (stmt.type === "nodes") {
                stmt.nodes.forEach((node) => {
                  node.parent = void 0;
                  styles2.append(node);
                });
              }
            });
          }
          function parseStyles(result2, styles2, options2, state2, media, layer) {
            const statements = parseStatements(result2, styles2);
            return Promise.resolve(statements).then((stmts) => {
              return stmts.reduce((promise, stmt) => {
                return promise.then(() => {
                  stmt.media = joinMedia(media, stmt.media || []);
                  stmt.parentMedia = media;
                  stmt.layer = joinLayer(layer, stmt.layer || []);
                  if (stmt.type !== "import" || /^(?:[a-z]+:)?\/\//i.test(stmt.uri)) {
                    return;
                  }
                  if (options2.filter && !options2.filter(stmt.uri)) {
                    return;
                  }
                  return resolveImportId(result2, stmt, options2, state2);
                });
              }, Promise.resolve());
            }).then(() => {
              let charset;
              const imports = [];
              const bundle = [];
              function handleCharset(stmt) {
                if (!charset)
                  charset = stmt;
                else if (stmt.node.params.toLowerCase() !== charset.node.params.toLowerCase()) {
                  throw new Error(
                    `Incompatable @charset statements:
  ${stmt.node.params} specified in ${stmt.node.source.input.file}
  ${charset.node.params} specified in ${charset.node.source.input.file}`
                  );
                }
              }
              statements.forEach((stmt) => {
                if (stmt.type === "charset")
                  handleCharset(stmt);
                else if (stmt.type === "import") {
                  if (stmt.children) {
                    stmt.children.forEach((child, index) => {
                      if (child.type === "import")
                        imports.push(child);
                      else if (child.type === "charset")
                        handleCharset(child);
                      else
                        bundle.push(child);
                      if (index === 0)
                        child.parent = stmt;
                    });
                  } else
                    imports.push(stmt);
                } else if (stmt.type === "media" || stmt.type === "nodes") {
                  bundle.push(stmt);
                }
              });
              return charset ? [charset, ...imports.concat(bundle)] : imports.concat(bundle);
            });
          }
          function resolveImportId(result2, stmt, options2, state2) {
            if (dataURL.isValid(stmt.uri)) {
              return loadImportContent(result2, stmt, stmt.uri, options2, state2).then(
                (result3) => {
                  stmt.children = result3;
                }
              );
            }
            const atRule2 = stmt.node;
            let sourceFile;
            if (atRule2.source?.input?.file) {
              sourceFile = atRule2.source.input.file;
            }
            const base = sourceFile ? path.dirname(atRule2.source.input.file) : options2.root;
            return Promise.resolve(options2.resolve(stmt.uri, base, options2)).then((paths) => {
              if (!Array.isArray(paths))
                paths = [paths];
              return Promise.all(
                paths.map((file) => {
                  return !path.isAbsolute(file) ? resolveId(file, base, options2) : file;
                })
              );
            }).then((resolved) => {
              resolved.forEach((file) => {
                result2.messages.push({
                  type: "dependency",
                  plugin: "postcss-import",
                  file,
                  parent: sourceFile
                });
              });
              return Promise.all(
                resolved.map((file) => {
                  return loadImportContent(result2, stmt, file, options2, state2);
                })
              );
            }).then((result3) => {
              stmt.children = result3.reduce((result4, statements) => {
                return statements ? result4.concat(statements) : result4;
              }, []);
            });
          }
          function loadImportContent(result2, stmt, filename, options2, state2) {
            const atRule2 = stmt.node;
            const { media, layer } = stmt;
            assignLayerNames(layer, atRule2, state2, options2);
            if (options2.skipDuplicates) {
              if (state2.importedFiles[filename]?.[media]?.[layer]) {
                return;
              }
              if (!state2.importedFiles[filename]) {
                state2.importedFiles[filename] = {};
              }
              if (!state2.importedFiles[filename][media]) {
                state2.importedFiles[filename][media] = {};
              }
              state2.importedFiles[filename][media][layer] = true;
            }
            return Promise.resolve(options2.load(filename, options2)).then(
              (content) => {
                if (content.trim() === "") {
                  result2.warn(`${filename} is empty`, { node: atRule2 });
                  return;
                }
                if (state2.hashFiles[content]?.[media]?.[layer]) {
                  return;
                }
                return processContent(
                  result2,
                  content,
                  filename,
                  options2,
                  postcss
                ).then((importedResult) => {
                  const styles2 = importedResult.root;
                  result2.messages = result2.messages.concat(importedResult.messages);
                  if (options2.skipDuplicates) {
                    const hasImport = styles2.some((child) => {
                      return child.type === "atrule" && child.name === "import";
                    });
                    if (!hasImport) {
                      if (!state2.hashFiles[content]) {
                        state2.hashFiles[content] = {};
                      }
                      if (!state2.hashFiles[content][media]) {
                        state2.hashFiles[content][media] = {};
                      }
                      state2.hashFiles[content][media][layer] = true;
                    }
                  }
                  return parseStyles(result2, styles2, options2, state2, media, layer);
                });
              }
            );
          }
        }
      };
    }
    AtImport.postcss = true;
    module2.exports = AtImport;
  }
});

// node_modules/node-releases/data/processed/envs.json
var require_envs = __commonJS({
  "node_modules/node-releases/data/processed/envs.json"(exports2, module2) {
    module2.exports = [{ name: "nodejs", version: "0.2.0", date: "2011-08-26", lts: false, security: false, v8: "2.3.8.0" }, { name: "nodejs", version: "0.3.0", date: "2011-08-26", lts: false, security: false, v8: "2.5.1.0" }, { name: "nodejs", version: "0.4.0", date: "2011-08-26", lts: false, security: false, v8: "3.1.2.0" }, { name: "nodejs", version: "0.5.0", date: "2011-08-26", lts: false, security: false, v8: "3.1.8.25" }, { name: "nodejs", version: "0.6.0", date: "2011-11-04", lts: false, security: false, v8: "3.6.6.6" }, { name: "nodejs", version: "0.7.0", date: "2012-01-17", lts: false, security: false, v8: "3.8.6.0" }, { name: "nodejs", version: "0.8.0", date: "2012-06-22", lts: false, security: false, v8: "3.11.10.10" }, { name: "nodejs", version: "0.9.0", date: "2012-07-20", lts: false, security: false, v8: "3.11.10.15" }, { name: "nodejs", version: "0.10.0", date: "2013-03-11", lts: false, security: false, v8: "3.14.5.8" }, { name: "nodejs", version: "0.11.0", date: "2013-03-28", lts: false, security: false, v8: "3.17.13.0" }, { name: "nodejs", version: "0.12.0", date: "2015-02-06", lts: false, security: false, v8: "3.28.73.0" }, { name: "nodejs", version: "4.0.0", date: "2015-09-08", lts: false, security: false, v8: "4.5.103.30" }, { name: "nodejs", version: "4.1.0", date: "2015-09-17", lts: false, security: false, v8: "4.5.103.33" }, { name: "nodejs", version: "4.2.0", date: "2015-10-12", lts: "Argon", security: false, v8: "4.5.103.35" }, { name: "nodejs", version: "4.3.0", date: "2016-02-09", lts: "Argon", security: false, v8: "4.5.103.35" }, { name: "nodejs", version: "4.4.0", date: "2016-03-08", lts: "Argon", security: false, v8: "4.5.103.35" }, { name: "nodejs", version: "4.5.0", date: "2016-08-16", lts: "Argon", security: false, v8: "4.5.103.37" }, { name: "nodejs", version: "4.6.0", date: "2016-09-27", lts: "Argon", security: true, v8: "4.5.103.37" }, { name: "nodejs", version: "4.7.0", date: "2016-12-06", lts: "Argon", security: false, v8: "4.5.103.43" }, { name: "nodejs", version: "4.8.0", date: "2017-02-21", lts: "Argon", security: false, v8: "4.5.103.45" }, { name: "nodejs", version: "4.9.0", date: "2018-03-28", lts: "Argon", security: true, v8: "4.5.103.53" }, { name: "nodejs", version: "5.0.0", date: "2015-10-29", lts: false, security: false, v8: "4.6.85.28" }, { name: "nodejs", version: "5.1.0", date: "2015-11-17", lts: false, security: false, v8: "4.6.85.31" }, { name: "nodejs", version: "5.2.0", date: "2015-12-09", lts: false, security: false, v8: "4.6.85.31" }, { name: "nodejs", version: "5.3.0", date: "2015-12-15", lts: false, security: false, v8: "4.6.85.31" }, { name: "nodejs", version: "5.4.0", date: "2016-01-06", lts: false, security: false, v8: "4.6.85.31" }, { name: "nodejs", version: "5.5.0", date: "2016-01-21", lts: false, security: false, v8: "4.6.85.31" }, { name: "nodejs", version: "5.6.0", date: "2016-02-09", lts: false, security: false, v8: "4.6.85.31" }, { name: "nodejs", version: "5.7.0", date: "2016-02-23", lts: false, security: false, v8: "4.6.85.31" }, { name: "nodejs", version: "5.8.0", date: "2016-03-09", lts: false, security: false, v8: "4.6.85.31" }, { name: "nodejs", version: "5.9.0", date: "2016-03-16", lts: false, security: false, v8: "4.6.85.31" }, { name: "nodejs", version: "5.10.0", date: "2016-04-01", lts: false, security: false, v8: "4.6.85.31" }, { name: "nodejs", version: "5.11.0", date: "2016-04-21", lts: false, security: false, v8: "4.6.85.31" }, { name: "nodejs", version: "5.12.0", date: "2016-06-23", lts: false, security: false, v8: "4.6.85.32" }, { name: "nodejs", version: "6.0.0", date: "2016-04-26", lts: false, security: false, v8: "5.0.71.35" }, { name: "nodejs", version: "6.1.0", date: "2016-05-05", lts: false, security: false, v8: "5.0.71.35" }, { name: "nodejs", version: "6.2.0", date: "2016-05-17", lts: false, security: false, v8: "5.0.71.47" }, { name: "nodejs", version: "6.3.0", date: "2016-07-06", lts: false, security: false, v8: "5.0.71.52" }, { name: "nodejs", version: "6.4.0", date: "2016-08-12", lts: false, security: false, v8: "5.0.71.60" }, { name: "nodejs", version: "6.5.0", date: "2016-08-26", lts: false, security: false, v8: "5.1.281.81" }, { name: "nodejs", version: "6.6.0", date: "2016-09-14", lts: false, security: false, v8: "5.1.281.83" }, { name: "nodejs", version: "6.7.0", date: "2016-09-27", lts: false, security: true, v8: "5.1.281.83" }, { name: "nodejs", version: "6.8.0", date: "2016-10-12", lts: false, security: false, v8: "5.1.281.84" }, { name: "nodejs", version: "6.9.0", date: "2016-10-18", lts: "Boron", security: false, v8: "5.1.281.84" }, { name: "nodejs", version: "6.10.0", date: "2017-02-21", lts: "Boron", security: false, v8: "5.1.281.93" }, { name: "nodejs", version: "6.11.0", date: "2017-06-06", lts: "Boron", security: false, v8: "5.1.281.102" }, { name: "nodejs", version: "6.12.0", date: "2017-11-06", lts: "Boron", security: false, v8: "5.1.281.108" }, { name: "nodejs", version: "6.13.0", date: "2018-02-10", lts: "Boron", security: false, v8: "5.1.281.111" }, { name: "nodejs", version: "6.14.0", date: "2018-03-28", lts: "Boron", security: true, v8: "5.1.281.111" }, { name: "nodejs", version: "6.15.0", date: "2018-11-27", lts: "Boron", security: true, v8: "5.1.281.111" }, { name: "nodejs", version: "6.16.0", date: "2018-12-26", lts: "Boron", security: false, v8: "5.1.281.111" }, { name: "nodejs", version: "6.17.0", date: "2019-02-28", lts: "Boron", security: true, v8: "5.1.281.111" }, { name: "nodejs", version: "7.0.0", date: "2016-10-25", lts: false, security: false, v8: "5.4.500.36" }, { name: "nodejs", version: "7.1.0", date: "2016-11-08", lts: false, security: false, v8: "5.4.500.36" }, { name: "nodejs", version: "7.2.0", date: "2016-11-22", lts: false, security: false, v8: "5.4.500.43" }, { name: "nodejs", version: "7.3.0", date: "2016-12-20", lts: false, security: false, v8: "5.4.500.45" }, { name: "nodejs", version: "7.4.0", date: "2017-01-04", lts: false, security: false, v8: "5.4.500.45" }, { name: "nodejs", version: "7.5.0", date: "2017-01-31", lts: false, security: false, v8: "5.4.500.48" }, { name: "nodejs", version: "7.6.0", date: "2017-02-21", lts: false, security: false, v8: "5.5.372.40" }, { name: "nodejs", version: "7.7.0", date: "2017-02-28", lts: false, security: false, v8: "5.5.372.41" }, { name: "nodejs", version: "7.8.0", date: "2017-03-29", lts: false, security: false, v8: "5.5.372.43" }, { name: "nodejs", version: "7.9.0", date: "2017-04-11", lts: false, security: false, v8: "5.5.372.43" }, { name: "nodejs", version: "7.10.0", date: "2017-05-02", lts: false, security: false, v8: "5.5.372.43" }, { name: "nodejs", version: "8.0.0", date: "2017-05-30", lts: false, security: false, v8: "5.8.283.41" }, { name: "nodejs", version: "8.1.0", date: "2017-06-08", lts: false, security: false, v8: "5.8.283.41" }, { name: "nodejs", version: "8.2.0", date: "2017-07-19", lts: false, security: false, v8: "5.8.283.41" }, { name: "nodejs", version: "8.3.0", date: "2017-08-08", lts: false, security: false, v8: "6.0.286.52" }, { name: "nodejs", version: "8.4.0", date: "2017-08-15", lts: false, security: false, v8: "6.0.286.52" }, { name: "nodejs", version: "8.5.0", date: "2017-09-12", lts: false, security: false, v8: "6.0.287.53" }, { name: "nodejs", version: "8.6.0", date: "2017-09-26", lts: false, security: false, v8: "6.0.287.53" }, { name: "nodejs", version: "8.7.0", date: "2017-10-11", lts: false, security: false, v8: "6.1.534.42" }, { name: "nodejs", version: "8.8.0", date: "2017-10-24", lts: false, security: false, v8: "6.1.534.42" }, { name: "nodejs", version: "8.9.0", date: "2017-10-31", lts: "Carbon", security: false, v8: "6.1.534.46" }, { name: "nodejs", version: "8.10.0", date: "2018-03-06", lts: "Carbon", security: false, v8: "6.2.414.50" }, { name: "nodejs", version: "8.11.0", date: "2018-03-28", lts: "Carbon", security: true, v8: "6.2.414.50" }, { name: "nodejs", version: "8.12.0", date: "2018-09-10", lts: "Carbon", security: false, v8: "6.2.414.66" }, { name: "nodejs", version: "8.13.0", date: "2018-11-20", lts: "Carbon", security: false, v8: "6.2.414.72" }, { name: "nodejs", version: "8.14.0", date: "2018-11-27", lts: "Carbon", security: true, v8: "6.2.414.72" }, { name: "nodejs", version: "8.15.0", date: "2018-12-26", lts: "Carbon", security: false, v8: "6.2.414.75" }, { name: "nodejs", version: "8.16.0", date: "2019-04-16", lts: "Carbon", security: false, v8: "6.2.414.77" }, { name: "nodejs", version: "8.17.0", date: "2019-12-17", lts: "Carbon", security: true, v8: "6.2.414.78" }, { name: "nodejs", version: "9.0.0", date: "2017-10-31", lts: false, security: false, v8: "6.2.414.32" }, { name: "nodejs", version: "9.1.0", date: "2017-11-07", lts: false, security: false, v8: "6.2.414.32" }, { name: "nodejs", version: "9.2.0", date: "2017-11-14", lts: false, security: false, v8: "6.2.414.44" }, { name: "nodejs", version: "9.3.0", date: "2017-12-12", lts: false, security: false, v8: "6.2.414.46" }, { name: "nodejs", version: "9.4.0", date: "2018-01-10", lts: false, security: false, v8: "6.2.414.46" }, { name: "nodejs", version: "9.5.0", date: "2018-01-31", lts: false, security: false, v8: "6.2.414.46" }, { name: "nodejs", version: "9.6.0", date: "2018-02-21", lts: false, security: false, v8: "6.2.414.46" }, { name: "nodejs", version: "9.7.0", date: "2018-03-01", lts: false, security: false, v8: "6.2.414.46" }, { name: "nodejs", version: "9.8.0", date: "2018-03-07", lts: false, security: false, v8: "6.2.414.46" }, { name: "nodejs", version: "9.9.0", date: "2018-03-21", lts: false, security: false, v8: "6.2.414.46" }, { name: "nodejs", version: "9.10.0", date: "2018-03-28", lts: false, security: true, v8: "6.2.414.46" }, { name: "nodejs", version: "9.11.0", date: "2018-04-04", lts: false, security: false, v8: "6.2.414.46" }, { name: "nodejs", version: "10.0.0", date: "2018-04-24", lts: false, security: false, v8: "6.6.346.24" }, { name: "nodejs", version: "10.1.0", date: "2018-05-08", lts: false, security: false, v8: "6.6.346.27" }, { name: "nodejs", version: "10.2.0", date: "2018-05-23", lts: false, security: false, v8: "6.6.346.32" }, { name: "nodejs", version: "10.3.0", date: "2018-05-29", lts: false, security: false, v8: "6.6.346.32" }, { name: "nodejs", version: "10.4.0", date: "2018-06-06", lts: false, security: false, v8: "6.7.288.43" }, { name: "nodejs", version: "10.5.0", date: "2018-06-20", lts: false, security: false, v8: "6.7.288.46" }, { name: "nodejs", version: "10.6.0", date: "2018-07-04", lts: false, security: false, v8: "6.7.288.46" }, { name: "nodejs", version: "10.7.0", date: "2018-07-18", lts: false, security: false, v8: "6.7.288.49" }, { name: "nodejs", version: "10.8.0", date: "2018-08-01", lts: false, security: false, v8: "6.7.288.49" }, { name: "nodejs", version: "10.9.0", date: "2018-08-15", lts: false, security: false, v8: "6.8.275.24" }, { name: "nodejs", version: "10.10.0", date: "2018-09-06", lts: false, security: false, v8: "6.8.275.30" }, { name: "nodejs", version: "10.11.0", date: "2018-09-19", lts: false, security: false, v8: "6.8.275.32" }, { name: "nodejs", version: "10.12.0", date: "2018-10-10", lts: false, security: false, v8: "6.8.275.32" }, { name: "nodejs", version: "10.13.0", date: "2018-10-30", lts: "Dubnium", security: false, v8: "6.8.275.32" }, { name: "nodejs", version: "10.14.0", date: "2018-11-27", lts: "Dubnium", security: true, v8: "6.8.275.32" }, { name: "nodejs", version: "10.15.0", date: "2018-12-26", lts: "Dubnium", security: false, v8: "6.8.275.32" }, { name: "nodejs", version: "10.16.0", date: "2019-05-28", lts: "Dubnium", security: false, v8: "6.8.275.32" }, { name: "nodejs", version: "10.17.0", date: "2019-10-22", lts: "Dubnium", security: false, v8: "6.8.275.32" }, { name: "nodejs", version: "10.18.0", date: "2019-12-17", lts: "Dubnium", security: true, v8: "6.8.275.32" }, { name: "nodejs", version: "10.19.0", date: "2020-02-05", lts: "Dubnium", security: true, v8: "6.8.275.32" }, { name: "nodejs", version: "10.20.0", date: "2020-03-26", lts: "Dubnium", security: false, v8: "6.8.275.32" }, { name: "nodejs", version: "10.21.0", date: "2020-06-02", lts: "Dubnium", security: true, v8: "6.8.275.32" }, { name: "nodejs", version: "10.22.0", date: "2020-07-21", lts: "Dubnium", security: false, v8: "6.8.275.32" }, { name: "nodejs", version: "10.23.0", date: "2020-10-27", lts: "Dubnium", security: false, v8: "6.8.275.32" }, { name: "nodejs", version: "10.24.0", date: "2021-02-23", lts: "Dubnium", security: true, v8: "6.8.275.32" }, { name: "nodejs", version: "11.0.0", date: "2018-10-23", lts: false, security: false, v8: "7.0.276.28" }, { name: "nodejs", version: "11.1.0", date: "2018-10-30", lts: false, security: false, v8: "7.0.276.32" }, { name: "nodejs", version: "11.2.0", date: "2018-11-15", lts: false, security: false, v8: "7.0.276.38" }, { name: "nodejs", version: "11.3.0", date: "2018-11-27", lts: false, security: true, v8: "7.0.276.38" }, { name: "nodejs", version: "11.4.0", date: "2018-12-07", lts: false, security: false, v8: "7.0.276.38" }, { name: "nodejs", version: "11.5.0", date: "2018-12-18", lts: false, security: false, v8: "7.0.276.38" }, { name: "nodejs", version: "11.6.0", date: "2018-12-26", lts: false, security: false, v8: "7.0.276.38" }, { name: "nodejs", version: "11.7.0", date: "2019-01-17", lts: false, security: false, v8: "7.0.276.38" }, { name: "nodejs", version: "11.8.0", date: "2019-01-24", lts: false, security: false, v8: "7.0.276.38" }, { name: "nodejs", version: "11.9.0", date: "2019-01-30", lts: false, security: false, v8: "7.0.276.38" }, { name: "nodejs", version: "11.10.0", date: "2019-02-14", lts: false, security: false, v8: "7.0.276.38" }, { name: "nodejs", version: "11.11.0", date: "2019-03-05", lts: false, security: false, v8: "7.0.276.38" }, { name: "nodejs", version: "11.12.0", date: "2019-03-14", lts: false, security: false, v8: "7.0.276.38" }, { name: "nodejs", version: "11.13.0", date: "2019-03-28", lts: false, security: false, v8: "7.0.276.38" }, { name: "nodejs", version: "11.14.0", date: "2019-04-10", lts: false, security: false, v8: "7.0.276.38" }, { name: "nodejs", version: "11.15.0", date: "2019-04-30", lts: false, security: false, v8: "7.0.276.38" }, { name: "nodejs", version: "12.0.0", date: "2019-04-23", lts: false, security: false, v8: "7.4.288.21" }, { name: "nodejs", version: "12.1.0", date: "2019-04-29", lts: false, security: false, v8: "7.4.288.21" }, { name: "nodejs", version: "12.2.0", date: "2019-05-07", lts: false, security: false, v8: "7.4.288.21" }, { name: "nodejs", version: "12.3.0", date: "2019-05-21", lts: false, security: false, v8: "7.4.288.27" }, { name: "nodejs", version: "12.4.0", date: "2019-06-04", lts: false, security: false, v8: "7.4.288.27" }, { name: "nodejs", version: "12.5.0", date: "2019-06-26", lts: false, security: false, v8: "7.5.288.22" }, { name: "nodejs", version: "12.6.0", date: "2019-07-03", lts: false, security: false, v8: "7.5.288.22" }, { name: "nodejs", version: "12.7.0", date: "2019-07-23", lts: false, security: false, v8: "7.5.288.22" }, { name: "nodejs", version: "12.8.0", date: "2019-08-06", lts: false, security: false, v8: "7.5.288.22" }, { name: "nodejs", version: "12.9.0", date: "2019-08-20", lts: false, security: false, v8: "7.6.303.29" }, { name: "nodejs", version: "12.10.0", date: "2019-09-04", lts: false, security: false, v8: "7.6.303.29" }, { name: "nodejs", version: "12.11.0", date: "2019-09-25", lts: false, security: false, v8: "7.7.299.11" }, { name: "nodejs", version: "12.12.0", date: "2019-10-11", lts: false, security: false, v8: "7.7.299.13" }, { name: "nodejs", version: "12.13.0", date: "2019-10-21", lts: "Erbium", security: false, v8: "7.7.299.13" }, { name: "nodejs", version: "12.14.0", date: "2019-12-17", lts: "Erbium", security: true, v8: "7.7.299.13" }, { name: "nodejs", version: "12.15.0", date: "2020-02-05", lts: "Erbium", security: true, v8: "7.7.299.13" }, { name: "nodejs", version: "12.16.0", date: "2020-02-11", lts: "Erbium", security: false, v8: "7.8.279.23" }, { name: "nodejs", version: "12.17.0", date: "2020-05-26", lts: "Erbium", security: false, v8: "7.8.279.23" }, { name: "nodejs", version: "12.18.0", date: "2020-06-02", lts: "Erbium", security: true, v8: "7.8.279.23" }, { name: "nodejs", version: "12.19.0", date: "2020-10-06", lts: "Erbium", security: false, v8: "7.8.279.23" }, { name: "nodejs", version: "12.20.0", date: "2020-11-24", lts: "Erbium", security: false, v8: "7.8.279.23" }, { name: "nodejs", version: "12.21.0", date: "2021-02-23", lts: "Erbium", security: true, v8: "7.8.279.23" }, { name: "nodejs", version: "12.22.0", date: "2021-03-30", lts: "Erbium", security: false, v8: "7.8.279.23" }, { name: "nodejs", version: "13.0.0", date: "2019-10-22", lts: false, security: false, v8: "7.8.279.17" }, { name: "nodejs", version: "13.1.0", date: "2019-11-05", lts: false, security: false, v8: "7.8.279.17" }, { name: "nodejs", version: "13.2.0", date: "2019-11-21", lts: false, security: false, v8: "7.9.317.23" }, { name: "nodejs", version: "13.3.0", date: "2019-12-03", lts: false, security: false, v8: "7.9.317.25" }, { name: "nodejs", version: "13.4.0", date: "2019-12-17", lts: false, security: true, v8: "7.9.317.25" }, { name: "nodejs", version: "13.5.0", date: "2019-12-18", lts: false, security: false, v8: "7.9.317.25" }, { name: "nodejs", version: "13.6.0", date: "2020-01-07", lts: false, security: false, v8: "7.9.317.25" }, { name: "nodejs", version: "13.7.0", date: "2020-01-21", lts: false, security: false, v8: "7.9.317.25" }, { name: "nodejs", version: "13.8.0", date: "2020-02-05", lts: false, security: true, v8: "7.9.317.25" }, { name: "nodejs", version: "13.9.0", date: "2020-02-18", lts: false, security: false, v8: "7.9.317.25" }, { name: "nodejs", version: "13.10.0", date: "2020-03-04", lts: false, security: false, v8: "7.9.317.25" }, { name: "nodejs", version: "13.11.0", date: "2020-03-12", lts: false, security: false, v8: "7.9.317.25" }, { name: "nodejs", version: "13.12.0", date: "2020-03-26", lts: false, security: false, v8: "7.9.317.25" }, { name: "nodejs", version: "13.13.0", date: "2020-04-14", lts: false, security: false, v8: "7.9.317.25" }, { name: "nodejs", version: "13.14.0", date: "2020-04-29", lts: false, security: false, v8: "7.9.317.25" }, { name: "nodejs", version: "14.0.0", date: "2020-04-21", lts: false, security: false, v8: "8.1.307.30" }, { name: "nodejs", version: "14.1.0", date: "2020-04-29", lts: false, security: false, v8: "8.1.307.31" }, { name: "nodejs", version: "14.2.0", date: "2020-05-05", lts: false, security: false, v8: "8.1.307.31" }, { name: "nodejs", version: "14.3.0", date: "2020-05-19", lts: false, security: false, v8: "8.1.307.31" }, { name: "nodejs", version: "14.4.0", date: "2020-06-02", lts: false, security: true, v8: "8.1.307.31" }, { name: "nodejs", version: "14.5.0", date: "2020-06-30", lts: false, security: false, v8: "8.3.110.9" }, { name: "nodejs", version: "14.6.0", date: "2020-07-20", lts: false, security: false, v8: "8.4.371.19" }, { name: "nodejs", version: "14.7.0", date: "2020-07-29", lts: false, security: false, v8: "8.4.371.19" }, { name: "nodejs", version: "14.8.0", date: "2020-08-11", lts: false, security: false, v8: "8.4.371.19" }, { name: "nodejs", version: "14.9.0", date: "2020-08-27", lts: false, security: false, v8: "8.4.371.19" }, { name: "nodejs", version: "14.10.0", date: "2020-09-08", lts: false, security: false, v8: "8.4.371.19" }, { name: "nodejs", version: "14.11.0", date: "2020-09-15", lts: false, security: true, v8: "8.4.371.19" }, { name: "nodejs", version: "14.12.0", date: "2020-09-22", lts: false, security: false, v8: "8.4.371.19" }, { name: "nodejs", version: "14.13.0", date: "2020-09-29", lts: false, security: false, v8: "8.4.371.19" }, { name: "nodejs", version: "14.14.0", date: "2020-10-15", lts: false, security: false, v8: "8.4.371.19" }, { name: "nodejs", version: "14.15.0", date: "2020-10-27", lts: "Fermium", security: false, v8: "8.4.371.19" }, { name: "nodejs", version: "14.16.0", date: "2021-02-23", lts: "Fermium", security: true, v8: "8.4.371.19" }, { name: "nodejs", version: "14.17.0", date: "2021-05-11", lts: "Fermium", security: false, v8: "8.4.371.23" }, { name: "nodejs", version: "14.18.0", date: "2021-09-28", lts: "Fermium", security: false, v8: "8.4.371.23" }, { name: "nodejs", version: "14.19.0", date: "2022-02-01", lts: "Fermium", security: false, v8: "8.4.371.23" }, { name: "nodejs", version: "14.20.0", date: "2022-07-07", lts: "Fermium", security: true, v8: "8.4.371.23" }, { name: "nodejs", version: "14.21.0", date: "2022-11-01", lts: "Fermium", security: false, v8: "8.4.371.23" }, { name: "nodejs", version: "15.0.0", date: "2020-10-20", lts: false, security: false, v8: "8.6.395.16" }, { name: "nodejs", version: "15.1.0", date: "2020-11-04", lts: false, security: false, v8: "8.6.395.17" }, { name: "nodejs", version: "15.2.0", date: "2020-11-10", lts: false, security: false, v8: "8.6.395.17" }, { name: "nodejs", version: "15.3.0", date: "2020-11-24", lts: false, security: false, v8: "8.6.395.17" }, { name: "nodejs", version: "15.4.0", date: "2020-12-09", lts: false, security: false, v8: "8.6.395.17" }, { name: "nodejs", version: "15.5.0", date: "2020-12-22", lts: false, security: false, v8: "8.6.395.17" }, { name: "nodejs", version: "15.6.0", date: "2021-01-14", lts: false, security: false, v8: "8.6.395.17" }, { name: "nodejs", version: "15.7.0", date: "2021-01-25", lts: false, security: false, v8: "8.6.395.17" }, { name: "nodejs", version: "15.8.0", date: "2021-02-02", lts: false, security: false, v8: "8.6.395.17" }, { name: "nodejs", version: "15.9.0", date: "2021-02-18", lts: false, security: false, v8: "8.6.395.17" }, { name: "nodejs", version: "15.10.0", date: "2021-02-23", lts: false, security: true, v8: "8.6.395.17" }, { name: "nodejs", version: "15.11.0", date: "2021-03-03", lts: false, security: false, v8: "8.6.395.17" }, { name: "nodejs", version: "15.12.0", date: "2021-03-17", lts: false, security: false, v8: "8.6.395.17" }, { name: "nodejs", version: "15.13.0", date: "2021-03-31", lts: false, security: false, v8: "8.6.395.17" }, { name: "nodejs", version: "15.14.0", date: "2021-04-06", lts: false, security: false, v8: "8.6.395.17" }, { name: "nodejs", version: "16.0.0", date: "2021-04-20", lts: false, security: false, v8: "9.0.257.17" }, { name: "nodejs", version: "16.1.0", date: "2021-05-04", lts: false, security: false, v8: "9.0.257.24" }, { name: "nodejs", version: "16.2.0", date: "2021-05-19", lts: false, security: false, v8: "9.0.257.25" }, { name: "nodejs", version: "16.3.0", date: "2021-06-03", lts: false, security: false, v8: "9.0.257.25" }, { name: "nodejs", version: "16.4.0", date: "2021-06-23", lts: false, security: false, v8: "9.1.269.36" }, { name: "nodejs", version: "16.5.0", date: "2021-07-14", lts: false, security: false, v8: "9.1.269.38" }, { name: "nodejs", version: "16.6.0", date: "2021-07-29", lts: false, security: true, v8: "9.2.230.21" }, { name: "nodejs", version: "16.7.0", date: "2021-08-18", lts: false, security: false, v8: "9.2.230.21" }, { name: "nodejs", version: "16.8.0", date: "2021-08-25", lts: false, security: false, v8: "9.2.230.21" }, { name: "nodejs", version: "16.9.0", date: "2021-09-07", lts: false, security: false, v8: "9.3.345.16" }, { name: "nodejs", version: "16.10.0", date: "2021-09-22", lts: false, security: false, v8: "9.3.345.19" }, { name: "nodejs", version: "16.11.0", date: "2021-10-08", lts: false, security: false, v8: "9.4.146.19" }, { name: "nodejs", version: "16.12.0", date: "2021-10-20", lts: false, security: false, v8: "9.4.146.19" }, { name: "nodejs", version: "16.13.0", date: "2021-10-26", lts: "Gallium", security: false, v8: "9.4.146.19" }, { name: "nodejs", version: "16.14.0", date: "2022-02-08", lts: "Gallium", security: false, v8: "9.4.146.24" }, { name: "nodejs", version: "16.15.0", date: "2022-04-26", lts: "Gallium", security: false, v8: "9.4.146.24" }, { name: "nodejs", version: "16.16.0", date: "2022-07-07", lts: "Gallium", security: true, v8: "9.4.146.24" }, { name: "nodejs", version: "16.17.0", date: "2022-08-16", lts: "Gallium", security: false, v8: "9.4.146.26" }, { name: "nodejs", version: "16.18.0", date: "2022-10-12", lts: "Gallium", security: false, v8: "9.4.146.26" }, { name: "nodejs", version: "16.19.0", date: "2022-12-13", lts: "Gallium", security: false, v8: "9.4.146.26" }, { name: "nodejs", version: "16.20.0", date: "2023-03-28", lts: "Gallium", security: false, v8: "9.4.146.26" }, { name: "nodejs", version: "17.0.0", date: "2021-10-19", lts: false, security: false, v8: "9.5.172.21" }, { name: "nodejs", version: "17.1.0", date: "2021-11-09", lts: false, security: false, v8: "9.5.172.25" }, { name: "nodejs", version: "17.2.0", date: "2021-11-30", lts: false, security: false, v8: "9.6.180.14" }, { name: "nodejs", version: "17.3.0", date: "2021-12-17", lts: false, security: false, v8: "9.6.180.15" }, { name: "nodejs", version: "17.4.0", date: "2022-01-18", lts: false, security: false, v8: "9.6.180.15" }, { name: "nodejs", version: "17.5.0", date: "2022-02-10", lts: false, security: false, v8: "9.6.180.15" }, { name: "nodejs", version: "17.6.0", date: "2022-02-22", lts: false, security: false, v8: "9.6.180.15" }, { name: "nodejs", version: "17.7.0", date: "2022-03-09", lts: false, security: false, v8: "9.6.180.15" }, { name: "nodejs", version: "17.8.0", date: "2022-03-22", lts: false, security: false, v8: "9.6.180.15" }, { name: "nodejs", version: "17.9.0", date: "2022-04-07", lts: false, security: false, v8: "9.6.180.15" }, { name: "nodejs", version: "18.0.0", date: "2022-04-18", lts: false, security: false, v8: "10.1.124.8" }, { name: "nodejs", version: "18.1.0", date: "2022-05-03", lts: false, security: false, v8: "10.1.124.8" }, { name: "nodejs", version: "18.2.0", date: "2022-05-17", lts: false, security: false, v8: "10.1.124.8" }, { name: "nodejs", version: "18.3.0", date: "2022-06-02", lts: false, security: false, v8: "10.2.154.4" }, { name: "nodejs", version: "18.4.0", date: "2022-06-16", lts: false, security: false, v8: "10.2.154.4" }, { name: "nodejs", version: "18.5.0", date: "2022-07-06", lts: false, security: true, v8: "10.2.154.4" }, { name: "nodejs", version: "18.6.0", date: "2022-07-13", lts: false, security: false, v8: "10.2.154.13" }, { name: "nodejs", version: "18.7.0", date: "2022-07-26", lts: false, security: false, v8: "10.2.154.13" }, { name: "nodejs", version: "18.8.0", date: "2022-08-24", lts: false, security: false, v8: "10.2.154.13" }, { name: "nodejs", version: "18.9.0", date: "2022-09-07", lts: false, security: false, v8: "10.2.154.15" }, { name: "nodejs", version: "18.10.0", date: "2022-09-28", lts: false, security: false, v8: "10.2.154.15" }, { name: "nodejs", version: "18.11.0", date: "2022-10-13", lts: false, security: false, v8: "10.2.154.15" }, { name: "nodejs", version: "18.12.0", date: "2022-10-25", lts: "Hydrogen", security: false, v8: "10.2.154.15" }, { name: "nodejs", version: "18.13.0", date: "2023-01-05", lts: "Hydrogen", security: false, v8: "10.2.154.23" }, { name: "nodejs", version: "18.14.0", date: "2023-02-01", lts: "Hydrogen", security: false, v8: "10.2.154.23" }, { name: "nodejs", version: "18.15.0", date: "2023-03-05", lts: "Hydrogen", security: false, v8: "10.2.154.26" }, { name: "nodejs", version: "18.16.0", date: "2023-04-12", lts: "Hydrogen", security: false, v8: "10.2.154.26" }, { name: "nodejs", version: "19.0.0", date: "2022-10-17", lts: false, security: false, v8: "10.7.193.13" }, { name: "nodejs", version: "19.1.0", date: "2022-11-14", lts: false, security: false, v8: "10.7.193.20" }, { name: "nodejs", version: "19.2.0", date: "2022-11-29", lts: false, security: false, v8: "10.8.168.20" }, { name: "nodejs", version: "19.3.0", date: "2022-12-14", lts: false, security: false, v8: "10.8.168.21" }, { name: "nodejs", version: "19.4.0", date: "2023-01-05", lts: false, security: false, v8: "10.8.168.25" }, { name: "nodejs", version: "19.5.0", date: "2023-01-24", lts: false, security: false, v8: "10.8.168.25" }, { name: "nodejs", version: "19.6.0", date: "2023-02-01", lts: false, security: false, v8: "10.8.168.25" }, { name: "nodejs", version: "19.7.0", date: "2023-02-21", lts: false, security: false, v8: "10.8.168.25" }, { name: "nodejs", version: "19.8.0", date: "2023-03-14", lts: false, security: false, v8: "10.8.168.25" }, { name: "nodejs", version: "19.9.0", date: "2023-04-10", lts: false, security: false, v8: "10.8.168.25" }, { name: "nodejs", version: "20.0.0", date: "2023-04-17", lts: false, security: false, v8: "11.3.244.4" }, { name: "nodejs", version: "20.1.0", date: "2023-05-03", lts: false, security: false, v8: "11.3.244.8" }, { name: "nodejs", version: "20.2.0", date: "2023-05-16", lts: false, security: false, v8: "11.3.244.8" }, { name: "nodejs", version: "20.3.0", date: "2023-06-08", lts: false, security: false, v8: "11.3.244.8" }, { name: "nodejs", version: "20.4.0", date: "2023-07-04", lts: false, security: false, v8: "11.3.244.8" }];
  }
});

// node_modules/caniuse-lite/data/browsers.js
var require_browsers = __commonJS({
  "node_modules/caniuse-lite/data/browsers.js"(exports2, module2) {
    module2.exports = { A: "ie", B: "edge", C: "firefox", D: "chrome", E: "safari", F: "opera", G: "ios_saf", H: "op_mini", I: "android", J: "bb", K: "op_mob", L: "and_chr", M: "and_ff", N: "ie_mob", O: "and_uc", P: "samsung", Q: "and_qq", R: "baidu", S: "kaios" };
  }
});

// node_modules/caniuse-lite/dist/unpacker/browsers.js
var require_browsers2 = __commonJS({
  "node_modules/caniuse-lite/dist/unpacker/browsers.js"(exports2, module2) {
    module2.exports.browsers = require_browsers();
  }
});

// node_modules/caniuse-lite/data/browserVersions.js
var require_browserVersions = __commonJS({
  "node_modules/caniuse-lite/data/browserVersions.js"(exports2, module2) {
    module2.exports = { "0": "112", "1": "113", "2": "114", "3": "115", "4": "116", "5": "117", "6": "118", "7": "119", "8": "120", "9": "121", A: "10", B: "11", C: "12", D: "7", E: "8", F: "9", G: "15", H: "80", I: "125", J: "4", K: "6", L: "13", M: "14", N: "16", O: "17", P: "18", Q: "79", R: "81", S: "83", T: "84", U: "85", V: "86", W: "87", X: "88", Y: "89", Z: "90", a: "91", b: "92", c: "93", d: "94", e: "95", f: "96", g: "97", h: "98", i: "99", j: "100", k: "101", l: "102", m: "103", n: "104", o: "105", p: "106", q: "107", r: "108", s: "109", t: "110", u: "20", v: "21", w: "22", x: "23", y: "24", z: "111", AB: "122", BB: "123", CB: "124", DB: "5", EB: "19", FB: "25", GB: "26", HB: "27", IB: "28", JB: "29", KB: "30", LB: "31", MB: "32", NB: "33", OB: "34", PB: "35", QB: "36", RB: "37", SB: "38", TB: "39", UB: "40", VB: "41", WB: "42", XB: "43", YB: "44", ZB: "45", aB: "46", bB: "47", cB: "48", dB: "49", eB: "50", fB: "51", gB: "52", hB: "53", iB: "54", jB: "55", kB: "56", lB: "57", mB: "58", nB: "60", oB: "62", pB: "63", qB: "64", rB: "65", sB: "66", tB: "67", uB: "68", vB: "69", wB: "70", xB: "71", yB: "72", zB: "73", "0B": "74", "1B": "75", "2B": "76", "3B": "77", "4B": "78", "5B": "126", "6B": "11.1", "7B": "12.1", "8B": "15.5", "9B": "16.0", AC: "17.0", BC: "3", CC: "59", DC: "61", EC: "82", FC: "127", GC: "128", HC: "3.2", IC: "10.1", JC: "15.2-15.3", KC: "15.4", LC: "16.1", MC: "16.2", NC: "16.3", OC: "16.4", PC: "16.5", QC: "17.1", RC: "17.2", SC: "17.3", TC: "17.4", UC: "17.5", VC: "17.6", WC: "11.5", XC: "4.2-4.3", YC: "5.5", ZC: "2", aC: "129", bC: "3.5", cC: "3.6", dC: "3.1", eC: "5.1", fC: "6.1", gC: "7.1", hC: "9.1", iC: "13.1", jC: "14.1", kC: "15.1", lC: "15.6", mC: "16.6", nC: "TP", oC: "9.5-9.6", pC: "10.0-10.1", qC: "10.5", rC: "10.6", sC: "11.6", tC: "4.0-4.1", uC: "5.0-5.1", vC: "6.0-6.1", wC: "7.0-7.1", xC: "8.1-8.4", yC: "9.0-9.2", zC: "9.3", "0C": "10.0-10.2", "1C": "10.3", "2C": "11.0-11.2", "3C": "11.3-11.4", "4C": "12.0-12.1", "5C": "12.2-12.5", "6C": "13.0-13.1", "7C": "13.2", "8C": "13.3", "9C": "13.4-13.7", AD: "14.0-14.4", BD: "14.5-14.8", CD: "15.0-15.1", DD: "15.6-15.8", ED: "16.6-16.7", FD: "all", GD: "2.1", HD: "2.2", ID: "2.3", JD: "4.1", KD: "4.4", LD: "4.4.3-4.4.4", MD: "5.0-5.4", ND: "6.2-6.4", OD: "7.2-7.4", PD: "8.2", QD: "9.2", RD: "11.1-11.2", SD: "12.0", TD: "13.0", UD: "14.0", VD: "15.0", WD: "18.0", XD: "19.0", YD: "14.9", ZD: "13.52", aD: "2.5", bD: "3.0-3.1" };
  }
});

// node_modules/caniuse-lite/dist/unpacker/browserVersions.js
var require_browserVersions2 = __commonJS({
  "node_modules/caniuse-lite/dist/unpacker/browserVersions.js"(exports2, module2) {
    module2.exports.browserVersions = require_browserVersions();
  }
});

// node_modules/caniuse-lite/data/agents.js
var require_agents = __commonJS({
  "node_modules/caniuse-lite/data/agents.js"(exports2, module2) {
    module2.exports = { A: { A: { K: 0, D: 0, E: 0.0239157, F: 0.0597892, A: 0, B: 0.55006, YC: 0 }, B: "ms", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "YC", "K", "D", "E", "F", "A", "B", "", "", ""], E: "IE", F: { YC: 962323200, K: 998870400, D: 1161129600, E: 1237420800, F: 1300060800, A: 1346716800, B: 1381968e3 } }, B: { A: { "0": 7682e-6, "1": 0.015364, "2": 0.015364, "3": 7682e-6, "4": 7682e-6, "5": 0.011523, "6": 0.011523, "7": 0.019205, "8": 0.042251, "9": 0.042251, C: 0, L: 0, M: 0, G: 0, N: 0, O: 3841e-6, P: 0.034569, Q: 0, H: 0, R: 0, S: 0, T: 0, U: 0, V: 0, W: 0, X: 0, Y: 0, Z: 0, a: 0, b: 0.011523, c: 0, d: 0, e: 0, f: 0, g: 0, h: 0, i: 0, j: 0, k: 0, l: 0, m: 0, n: 0, o: 0, p: 0, q: 3841e-6, r: 7682e-6, s: 0.069138, t: 7682e-6, z: 7682e-6, AB: 0.280393, BB: 3.02671, CB: 1.35587, I: 0 }, B: "webkit", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "C", "L", "M", "G", "N", "O", "P", "Q", "H", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "AB", "BB", "CB", "I", "", "", ""], E: "Edge", F: { "0": 1680825600, "1": 1683158400, "2": 1685664e3, "3": 1689897600, "4": 1692576e3, "5": 1694649600, "6": 1697155200, "7": 1698969600, "8": 1701993600, "9": 1706227200, C: 1438128e3, L: 1447286400, M: 1470096e3, G: 1491868800, N: 1508198400, O: 1525046400, P: 1542067200, Q: 1579046400, H: 1581033600, R: 1586736e3, S: 1590019200, T: 1594857600, U: 1598486400, V: 1602201600, W: 1605830400, X: 161136e4, Y: 1614816e3, Z: 1618358400, a: 1622073600, b: 1626912e3, c: 1630627200, d: 1632441600, e: 1634774400, f: 1637539200, g: 1641427200, h: 1643932800, i: 1646265600, j: 1649635200, k: 1651190400, l: 1653955200, m: 1655942400, n: 1659657600, o: 1661990400, p: 1664755200, q: 1666915200, r: 1670198400, s: 1673481600, t: 1675900800, z: 1678665600, AB: 1708732800, BB: 1711152e3, CB: 1713398400, I: 1715990400 }, D: { C: "ms", L: "ms", M: "ms", G: "ms", N: "ms", O: "ms", P: "ms" } }, C: { A: { "0": 0, "1": 7682e-6, "2": 0, "3": 0.372577, "4": 0, "5": 7682e-6, "6": 0.099866, "7": 3841e-6, "8": 0.011523, "9": 0.011523, ZC: 0, BC: 0, J: 7682e-6, DB: 0, K: 0, D: 0, E: 0, F: 0, A: 0, B: 0.011523, C: 0, L: 0, M: 0, G: 0, N: 0, O: 0, P: 0, EB: 0, u: 0, v: 0, w: 0, x: 0, y: 0, FB: 0, GB: 0, HB: 0, IB: 0, JB: 0, KB: 0, LB: 0, MB: 0, NB: 0, OB: 0, PB: 0, QB: 0, RB: 0, SB: 0, TB: 0, UB: 0, VB: 0, WB: 0, XB: 7682e-6, YB: 7682e-6, ZB: 7682e-6, aB: 0, bB: 0, cB: 0, dB: 0, eB: 7682e-6, fB: 0, gB: 0.049933, hB: 7682e-6, iB: 7682e-6, jB: 0, kB: 0.019205, lB: 0, mB: 0, CC: 3841e-6, nB: 0, DC: 0, oB: 0, pB: 0, qB: 0, rB: 0, sB: 0, tB: 0, uB: 0, vB: 0, wB: 0, xB: 0, yB: 0, zB: 0, "0B": 0, "1B": 0, "2B": 0, "3B": 0, "4B": 0.015364, Q: 0, H: 0, R: 0, EC: 0, S: 0, T: 0, U: 0, V: 0, W: 0, X: 7682e-6, Y: 0, Z: 0, a: 0, b: 0, c: 0, d: 3841e-6, e: 0, f: 0, g: 0, h: 0, i: 0, j: 0, k: 0, l: 0.026887, m: 0.107548, n: 7682e-6, o: 0, p: 0, q: 0, r: 3841e-6, s: 7682e-6, t: 0, z: 0, AB: 0.019205, BB: 0.049933, CB: 1.04475, I: 0.530058, "5B": 3841e-6, FC: 0, GC: 0, aC: 0, bC: 0, cC: 0 }, B: "moz", C: ["ZC", "BC", "bC", "cC", "J", "DB", "K", "D", "E", "F", "A", "B", "C", "L", "M", "G", "N", "O", "P", "EB", "u", "v", "w", "x", "y", "FB", "GB", "HB", "IB", "JB", "KB", "LB", "MB", "NB", "OB", "PB", "QB", "RB", "SB", "TB", "UB", "VB", "WB", "XB", "YB", "ZB", "aB", "bB", "cB", "dB", "eB", "fB", "gB", "hB", "iB", "jB", "kB", "lB", "mB", "CC", "nB", "DC", "oB", "pB", "qB", "rB", "sB", "tB", "uB", "vB", "wB", "xB", "yB", "zB", "0B", "1B", "2B", "3B", "4B", "Q", "H", "R", "EC", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "AB", "BB", "CB", "I", "5B", "FC", "GC", "aC"], E: "Firefox", F: { "0": 1681171200, "1": 1683590400, "2": 1686009600, "3": 1688428800, "4": 1690848e3, "5": 1693267200, "6": 1695686400, "7": 1698105600, "8": 1700524800, "9": 1702944e3, ZC: 1161648e3, BC: 1213660800, bC: 124632e4, cC: 1264032e3, J: 1300752e3, DB: 1308614400, K: 1313452800, D: 1317081600, E: 1317081600, F: 1320710400, A: 1324339200, B: 1327968e3, C: 1331596800, L: 1335225600, M: 1338854400, G: 1342483200, N: 1346112e3, O: 1349740800, P: 1353628800, EB: 1357603200, u: 1361232e3, v: 1364860800, w: 1368489600, x: 1372118400, y: 1375747200, FB: 1379376e3, GB: 1386633600, HB: 1391472e3, IB: 1395100800, JB: 1398729600, KB: 1402358400, LB: 1405987200, MB: 1409616e3, NB: 1413244800, OB: 1417392e3, PB: 1421107200, QB: 1424736e3, RB: 1428278400, SB: 1431475200, TB: 1435881600, UB: 1439251200, VB: 144288e4, WB: 1446508800, XB: 1450137600, YB: 1453852800, ZB: 1457395200, aB: 1461628800, bB: 1465257600, cB: 1470096e3, dB: 1474329600, eB: 1479168e3, fB: 1485216e3, gB: 1488844800, hB: 149256e4, iB: 1497312e3, jB: 1502150400, kB: 1506556800, lB: 1510617600, mB: 1516665600, CC: 1520985600, nB: 1525824e3, DC: 1529971200, oB: 1536105600, pB: 1540252800, qB: 1544486400, rB: 154872e4, sB: 1552953600, tB: 1558396800, uB: 1562630400, vB: 1567468800, wB: 1571788800, xB: 1575331200, yB: 1578355200, zB: 1581379200, "0B": 1583798400, "1B": 1586304e3, "2B": 1588636800, "3B": 1591056e3, "4B": 1593475200, Q: 1595894400, H: 1598313600, R: 1600732800, EC: 1603152e3, S: 1605571200, T: 1607990400, U: 1611619200, V: 1614038400, W: 1616457600, X: 1618790400, Y: 1622505600, Z: 1626134400, a: 1628553600, b: 1630972800, c: 1633392e3, d: 1635811200, e: 1638835200, f: 1641859200, g: 1644364800, h: 1646697600, i: 1649116800, j: 1651536e3, k: 1653955200, l: 1656374400, m: 1658793600, n: 1661212800, o: 1663632e3, p: 1666051200, q: 1668470400, r: 1670889600, s: 1673913600, t: 1676332800, z: 1678752e3, AB: 1705968e3, BB: 1708387200, CB: 1710806400, I: 1713225600, "5B": 1715644800, FC: null, GC: null, aC: null } }, D: { A: { "0": 0.03841, "1": 0.07682, "2": 0.092184, "3": 0.053774, "4": 0.203573, "5": 0.119071, "6": 0.103707, "7": 0.134435, "8": 0.257347, "9": 0.472443, J: 0, DB: 0, K: 0, D: 0, E: 0, F: 0, A: 0, B: 0, C: 0, L: 0, M: 0, G: 0, N: 0, O: 0, P: 0, EB: 0, u: 0, v: 0, w: 0, x: 0, y: 0, FB: 0, GB: 0, HB: 0, IB: 0, JB: 0, KB: 0, LB: 0, MB: 0, NB: 0, OB: 7682e-6, PB: 0, QB: 0, RB: 0, SB: 0.019205, TB: 0, UB: 0, VB: 0, WB: 0, XB: 0, YB: 0, ZB: 0, aB: 0, bB: 7682e-6, cB: 0.023046, dB: 0.026887, eB: 7682e-6, fB: 0, gB: 0, hB: 7682e-6, iB: 0, jB: 0, kB: 0.011523, lB: 0, mB: 7682e-6, CC: 0, nB: 0, DC: 3841e-6, oB: 0, pB: 3841e-6, qB: 0, rB: 0, sB: 0.026887, tB: 3841e-6, uB: 0, vB: 0.030728, wB: 0.061456, xB: 3841e-6, yB: 3841e-6, zB: 0.011523, "0B": 7682e-6, "1B": 7682e-6, "2B": 7682e-6, "3B": 0.015364, "4B": 0.015364, Q: 0.122912, H: 0.011523, R: 0.023046, S: 0.03841, T: 7682e-6, U: 0.023046, V: 0.149799, W: 0.072979, X: 0.019205, Y: 0.011523, Z: 0.011523, a: 0.042251, b: 0.015364, c: 0.026887, d: 0.042251, e: 0.011523, f: 0.011523, g: 0.015364, h: 0.072979, i: 0.030728, j: 0.145958, k: 0.26887, l: 0.145958, m: 0.284234, n: 0.184368, o: 0.03841, p: 0.03841, q: 0.026887, r: 0.046092, s: 1.52488, t: 0.026887, z: 0.03841, AB: 1.27905, BB: 12.1606, CB: 4.72443, I: 0.030728, "5B": 7682e-6, FC: 0, GC: 0 }, B: "webkit", C: ["", "", "", "", "", "", "J", "DB", "K", "D", "E", "F", "A", "B", "C", "L", "M", "G", "N", "O", "P", "EB", "u", "v", "w", "x", "y", "FB", "GB", "HB", "IB", "JB", "KB", "LB", "MB", "NB", "OB", "PB", "QB", "RB", "SB", "TB", "UB", "VB", "WB", "XB", "YB", "ZB", "aB", "bB", "cB", "dB", "eB", "fB", "gB", "hB", "iB", "jB", "kB", "lB", "mB", "CC", "nB", "DC", "oB", "pB", "qB", "rB", "sB", "tB", "uB", "vB", "wB", "xB", "yB", "zB", "0B", "1B", "2B", "3B", "4B", "Q", "H", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "AB", "BB", "CB", "I", "5B", "FC", "GC"], E: "Chrome", F: { "0": 1680566400, "1": 1682985600, "2": 1685404800, "3": 1689724800, "4": 1692057600, "5": 1694476800, "6": 1696896e3, "7": 1698710400, "8": 1701993600, "9": 1705968e3, J: 1264377600, DB: 1274745600, K: 1283385600, D: 1287619200, E: 1291248e3, F: 1296777600, A: 1299542400, B: 1303862400, C: 1307404800, L: 1312243200, M: 1316131200, G: 1316131200, N: 1319500800, O: 1323734400, P: 1328659200, EB: 1332892800, u: 133704e4, v: 1340668800, w: 1343692800, x: 1348531200, y: 1352246400, FB: 1357862400, GB: 1361404800, HB: 1364428800, IB: 1369094400, JB: 1374105600, KB: 1376956800, LB: 1384214400, MB: 1389657600, NB: 1392940800, OB: 1397001600, PB: 1400544e3, QB: 1405468800, RB: 1409011200, SB: 141264e4, TB: 1416268800, UB: 1421798400, VB: 1425513600, WB: 1429401600, XB: 143208e4, YB: 1437523200, ZB: 1441152e3, aB: 1444780800, bB: 1449014400, cB: 1453248e3, dB: 1456963200, eB: 1460592e3, fB: 1464134400, gB: 1469059200, hB: 1472601600, iB: 1476230400, jB: 1480550400, kB: 1485302400, lB: 1489017600, mB: 149256e4, CC: 1496707200, nB: 1500940800, DC: 1504569600, oB: 1508198400, pB: 1512518400, qB: 1516752e3, rB: 1520294400, sB: 1523923200, tB: 1527552e3, uB: 1532390400, vB: 1536019200, wB: 1539648e3, xB: 1543968e3, yB: 154872e4, zB: 1552348800, "0B": 1555977600, "1B": 1559606400, "2B": 1564444800, "3B": 1568073600, "4B": 1571702400, Q: 1575936e3, H: 1580860800, R: 1586304e3, S: 1589846400, T: 1594684800, U: 1598313600, V: 1601942400, W: 1605571200, X: 1611014400, Y: 1614556800, Z: 1618272e3, a: 1621987200, b: 1626739200, c: 1630368e3, d: 1632268800, e: 1634601600, f: 1637020800, g: 1641340800, h: 1643673600, i: 1646092800, j: 1648512e3, k: 1650931200, l: 1653350400, m: 1655769600, n: 1659398400, o: 1661817600, p: 1664236800, q: 1666656e3, r: 166968e4, s: 1673308800, t: 1675728e3, z: 1678147200, AB: 1708387200, BB: 1710806400, CB: 1713225600, I: 1715644800, "5B": null, FC: null, GC: null } }, E: { A: { J: 0, DB: 0, K: 0, D: 0, E: 7682e-6, F: 3841e-6, A: 0, B: 0, C: 0, L: 7682e-6, M: 0.03841, G: 7682e-6, dC: 0, HC: 0, eC: 0, fC: 0, gC: 0, hC: 7682e-6, IC: 0, "6B": 7682e-6, "7B": 0.015364, iC: 0.065297, jC: 0.096025, kC: 0.034569, JC: 0.011523, KC: 0.026887, "8B": 0.034569, lC: 0.245824, "9B": 0.030728, LC: 0.049933, MC: 0.046092, NC: 0.107548, OC: 0.034569, PC: 0.065297, mC: 0.361054, AC: 0.042251, QC: 0.092184, RC: 0.142117, SC: 0.418669, TC: 1.15614, UC: 7682e-6, VC: 0, nC: 0 }, B: "webkit", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "dC", "HC", "J", "DB", "eC", "K", "fC", "D", "gC", "E", "F", "hC", "A", "IC", "B", "6B", "C", "7B", "L", "iC", "M", "jC", "G", "kC", "JC", "KC", "8B", "lC", "9B", "LC", "MC", "NC", "OC", "PC", "mC", "AC", "QC", "RC", "SC", "TC", "UC", "VC", "nC", ""], E: "Safari", F: { dC: 1205798400, HC: 1226534400, J: 1244419200, DB: 1275868800, eC: 131112e4, K: 1343174400, fC: 13824e5, D: 13824e5, gC: 1410998400, E: 1413417600, F: 1443657600, hC: 1458518400, A: 1474329600, IC: 1490572800, B: 1505779200, "6B": 1522281600, C: 1537142400, "7B": 1553472e3, L: 1568851200, iC: 1585008e3, M: 1600214400, jC: 1619395200, G: 1632096e3, kC: 1635292800, JC: 1639353600, KC: 1647216e3, "8B": 1652745600, lC: 1658275200, "9B": 1662940800, LC: 1666569600, MC: 1670889600, NC: 1674432e3, OC: 1679875200, PC: 1684368e3, mC: 1690156800, AC: 1695686400, QC: 1698192e3, RC: 1702252800, SC: 1705881600, TC: 1709596800, UC: 1715558400, VC: null, nC: null } }, F: { A: { F: 0, B: 0, C: 0, G: 0, N: 0, O: 0, P: 0, EB: 0, u: 0, v: 0, w: 0, x: 0, y: 0, FB: 0, GB: 0, HB: 0, IB: 0, JB: 0, KB: 0, LB: 0, MB: 0, NB: 0, OB: 0, PB: 0, QB: 0, RB: 0, SB: 0, TB: 0, UB: 3841e-6, VB: 0, WB: 0, XB: 0, YB: 0, ZB: 0, aB: 0.015364, bB: 0, cB: 0, dB: 0, eB: 0, fB: 0, gB: 0, hB: 0, iB: 0, jB: 0, kB: 0, lB: 0, mB: 0, nB: 0, oB: 0, pB: 0, qB: 0, rB: 0, sB: 0, tB: 0, uB: 0, vB: 0, wB: 0, xB: 0, yB: 0, zB: 0, "0B": 0, "1B": 0, "2B": 0, "3B": 0, "4B": 0, Q: 0, H: 0, R: 0, EC: 0, S: 0, T: 0, U: 0, V: 0, W: 0, X: 0, Y: 0, Z: 0, a: 0, b: 0, c: 0, d: 0, e: 0.046092, f: 0, g: 0, h: 0, i: 0, j: 0, k: 0, l: 0.03841, m: 0, n: 0, o: 0, p: 7682e-6, q: 0.564627, r: 0.291916, s: 0.11523, t: 0, oC: 0, pC: 0, qC: 0, rC: 0, "6B": 0, WC: 0, sC: 0, "7B": 0 }, B: "webkit", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "F", "oC", "pC", "qC", "rC", "B", "6B", "WC", "sC", "C", "7B", "G", "N", "O", "P", "EB", "u", "v", "w", "x", "y", "FB", "GB", "HB", "IB", "JB", "KB", "LB", "MB", "NB", "OB", "PB", "QB", "RB", "SB", "TB", "UB", "VB", "WB", "XB", "YB", "ZB", "aB", "bB", "cB", "dB", "eB", "fB", "gB", "hB", "iB", "jB", "kB", "lB", "mB", "nB", "oB", "pB", "qB", "rB", "sB", "tB", "uB", "vB", "wB", "xB", "yB", "zB", "0B", "1B", "2B", "3B", "4B", "Q", "H", "R", "EC", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "", "", ""], E: "Opera", F: { F: 1150761600, oC: 1223424e3, pC: 1251763200, qC: 1267488e3, rC: 1277942400, B: 1292457600, "6B": 1302566400, WC: 1309219200, sC: 1323129600, C: 1323129600, "7B": 1352073600, G: 1372723200, N: 1377561600, O: 1381104e3, P: 1386288e3, EB: 1390867200, u: 1393891200, v: 1399334400, w: 1401753600, x: 1405987200, y: 1409616e3, FB: 1413331200, GB: 1417132800, HB: 1422316800, IB: 1425945600, JB: 1430179200, KB: 1433808e3, LB: 1438646400, MB: 1442448e3, NB: 1445904e3, OB: 1449100800, PB: 1454371200, QB: 1457308800, RB: 146232e4, SB: 1465344e3, TB: 1470096e3, UB: 1474329600, VB: 1477267200, WB: 1481587200, XB: 1486425600, YB: 1490054400, ZB: 1494374400, aB: 1498003200, bB: 1502236800, cB: 1506470400, dB: 1510099200, eB: 1515024e3, fB: 1517961600, gB: 1521676800, hB: 1525910400, iB: 1530144e3, jB: 1534982400, kB: 1537833600, lB: 1543363200, mB: 1548201600, nB: 1554768e3, oB: 1561593600, pB: 1566259200, qB: 1570406400, rB: 1573689600, sB: 1578441600, tB: 1583971200, uB: 1587513600, vB: 1592956800, wB: 1595894400, xB: 1600128e3, yB: 1603238400, zB: 161352e4, "0B": 1612224e3, "1B": 1616544e3, "2B": 1619568e3, "3B": 1623715200, "4B": 1627948800, Q: 1631577600, H: 1633392e3, R: 1635984e3, EC: 1638403200, S: 1642550400, T: 1644969600, U: 1647993600, V: 1650412800, W: 1652745600, X: 1654646400, Y: 1657152e3, Z: 1660780800, a: 1663113600, b: 1668816e3, c: 1668643200, d: 1671062400, e: 1675209600, f: 1677024e3, g: 1679529600, h: 1681948800, i: 1684195200, j: 1687219200, k: 1690329600, l: 1692748800, m: 1696204800, n: 169992e4, o: 169992e4, p: 1702944e3, q: 1707264e3, r: 1710115200, s: 1711497600, t: 1716336e3 }, D: { F: "o", B: "o", C: "o", oC: "o", pC: "o", qC: "o", rC: "o", "6B": "o", WC: "o", sC: "o", "7B": "o" } }, G: { A: { E: 0, HC: 0, tC: 0, XC: 291444e-8, uC: 291444e-8, vC: 72861e-7, wC: 0.0116578, xC: 291444e-8, yC: 72861e-7, zC: 0.0364305, "0C": 72861e-7, "1C": 0.0582888, "2C": 0.0495455, "3C": 0.0145722, "4C": 0.0116578, "5C": 0.237527, "6C": 437166e-8, "7C": 0.0480882, "8C": 0.0116578, "9C": 0.0451738, AD: 0.112206, BD: 0.135521, CD: 0.0626604, JC: 0.0714037, KC: 0.0816043, "8B": 0.102005, DD: 0.902019, "9B": 0.211297, LC: 0.44008, MC: 0.20984, NC: 0.371591, OC: 0.0772326, PC: 0.161751, ED: 1.27652, AC: 0.153008, QC: 0.282701, RC: 0.378877, SC: 2.74249, TC: 6.17424, UC: 0.0568316, VC: 0 }, B: "webkit", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "HC", "tC", "XC", "uC", "vC", "wC", "E", "xC", "yC", "zC", "0C", "1C", "2C", "3C", "4C", "5C", "6C", "7C", "8C", "9C", "AD", "BD", "CD", "JC", "KC", "8B", "DD", "9B", "LC", "MC", "NC", "OC", "PC", "ED", "AC", "QC", "RC", "SC", "TC", "UC", "VC", "", ""], E: "Safari on iOS", F: { HC: 1270252800, tC: 1283904e3, XC: 1299628800, uC: 1331078400, vC: 1359331200, wC: 1394409600, E: 1410912e3, xC: 1413763200, yC: 1442361600, zC: 1458518400, "0C": 1473724800, "1C": 1490572800, "2C": 1505779200, "3C": 1522281600, "4C": 1537142400, "5C": 1553472e3, "6C": 1568851200, "7C": 1572220800, "8C": 1580169600, "9C": 1585008e3, AD: 1600214400, BD: 1619395200, CD: 1632096e3, JC: 1639353600, KC: 1647216e3, "8B": 1652659200, DD: 1658275200, "9B": 1662940800, LC: 1666569600, MC: 1670889600, NC: 1674432e3, OC: 1679875200, PC: 1684368e3, ED: 1690156800, AC: 1694995200, QC: 1698192e3, RC: 1702252800, SC: 1705881600, TC: 1709596800, UC: 1715558400, VC: null } }, H: { A: { FD: 0.09 }, B: "o", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "FD", "", "", ""], E: "Opera Mini", F: { FD: 1426464e3 } }, I: { A: { BC: 0, J: 566628e-10, I: 0.564305, GD: 0, HD: 0, ID: 0, JD: 113326e-9, XC: 339977e-9, KD: 0, LD: 141657e-8 }, B: "webkit", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "GD", "HD", "ID", "BC", "J", "JD", "XC", "KD", "LD", "I", "", "", ""], E: "Android Browser", F: { GD: 1256515200, HD: 1274313600, ID: 1291593600, BC: 1298332800, J: 1318896e3, JD: 1341792e3, XC: 1374624e3, KD: 1386547200, LD: 1401667200, I: 1715731200 } }, J: { A: { D: 0, A: 0 }, B: "webkit", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "D", "A", "", "", ""], E: "Blackberry Browser", F: { D: 1325376e3, A: 1359504e3 } }, K: { A: { A: 0, B: 0, C: 0, H: 1.23418, "6B": 0, WC: 0, "7B": 0 }, B: "o", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "A", "B", "6B", "WC", "C", "7B", "H", "", "", ""], E: "Opera Mobile", F: { A: 1287100800, B: 1300752e3, "6B": 1314835200, WC: 1318291200, C: 1330300800, "7B": 1349740800, H: 1709769600 }, D: { H: "webkit" } }, L: { A: { I: 41.8185 }, B: "webkit", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "I", "", "", ""], E: "Chrome for Android", F: { I: 1715731200 } }, M: { A: { "5B": 0.301791 }, B: "moz", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "5B", "", "", ""], E: "Firefox for Android", F: { "5B": 1715644800 } }, N: { A: { A: 0, B: 0 }, B: "ms", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "A", "B", "", "", ""], E: "IE Mobile", F: { A: 1340150400, B: 1353456e3 } }, O: { A: { "8B": 0.886896 }, B: "webkit", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "8B", "", "", ""], E: "UC Browser for Android", F: { "8B": 1710115200 }, D: { "8B": "webkit" } }, P: { A: { J: 0.140685, u: 0.0216438, v: 0.0649313, w: 0.0649313, x: 0.216438, y: 1.88301, MD: 0.0108219, ND: 0, OD: 0.0432875, PD: 0, QD: 0, IC: 0, RD: 0.0108219, SD: 0, TD: 0.0108219, UD: 0, VD: 0, "9B": 0, AC: 0.0216438, WD: 0.0108219, XD: 0.0324657 }, B: "webkit", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "J", "MD", "ND", "OD", "PD", "QD", "IC", "RD", "SD", "TD", "UD", "VD", "9B", "AC", "WD", "XD", "u", "v", "w", "x", "y", "", "", ""], E: "Samsung Internet", F: { J: 1461024e3, MD: 1481846400, ND: 1509408e3, OD: 1528329600, PD: 1546128e3, QD: 1554163200, IC: 1567900800, RD: 1582588800, SD: 1593475200, TD: 1605657600, UD: 1618531200, VD: 1629072e3, "9B": 1640736e3, AC: 1651708800, WD: 1659657600, XD: 1667260800, u: 1677369600, v: 1684454400, w: 1689292800, x: 1697587200, y: 1711497600 } }, Q: { A: { YD: 0.283314 }, B: "webkit", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "YD", "", "", ""], E: "QQ Browser", F: { YD: 1710288e3 } }, R: { A: { ZD: 0 }, B: "webkit", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "ZD", "", "", ""], E: "Baidu Browser", F: { ZD: 1710201600 } }, S: { A: { aD: 0.073908, bD: 0 }, B: "moz", C: ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "aD", "bD", "", "", ""], E: "KaiOS Browser", F: { aD: 1527811200, bD: 1631664e3 } } };
  }
});

// node_modules/caniuse-lite/dist/unpacker/agents.js
var require_agents2 = __commonJS({
  "node_modules/caniuse-lite/dist/unpacker/agents.js"(exports2, module2) {
    "use strict";
    var browsers = require_browsers2().browsers;
    var versions = require_browserVersions2().browserVersions;
    var agentsData = require_agents();
    function unpackBrowserVersions(versionsData) {
      return Object.keys(versionsData).reduce((usage, version) => {
        usage[versions[version]] = versionsData[version];
        return usage;
      }, {});
    }
    module2.exports.agents = Object.keys(agentsData).reduce((map, key) => {
      let versionsData = agentsData[key];
      map[browsers[key]] = Object.keys(versionsData).reduce((data, entry) => {
        if (entry === "A") {
          data.usage_global = unpackBrowserVersions(versionsData[entry]);
        } else if (entry === "C") {
          data.versions = versionsData[entry].reduce((list, version) => {
            if (version === "") {
              list.push(null);
            } else {
              list.push(versions[version]);
            }
            return list;
          }, []);
        } else if (entry === "D") {
          data.prefix_exceptions = unpackBrowserVersions(versionsData[entry]);
        } else if (entry === "E") {
          data.browser = versionsData[entry];
        } else if (entry === "F") {
          data.release_date = Object.keys(versionsData[entry]).reduce(
            (map2, key2) => {
              map2[versions[key2]] = versionsData[entry][key2];
              return map2;
            },
            {}
          );
        } else {
          data.prefix = versionsData[entry];
        }
        return data;
      }, {});
      return map;
    }, {});
  }
});

// node_modules/node-releases/data/release-schedule/release-schedule.json
var require_release_schedule = __commonJS({
  "node_modules/node-releases/data/release-schedule/release-schedule.json"(exports2, module2) {
    module2.exports = { "v0.8": { start: "2012-06-25", end: "2014-07-31" }, "v0.10": { start: "2013-03-11", end: "2016-10-31" }, "v0.12": { start: "2015-02-06", end: "2016-12-31" }, v4: { start: "2015-09-08", lts: "2015-10-12", maintenance: "2017-04-01", end: "2018-04-30", codename: "Argon" }, v5: { start: "2015-10-29", maintenance: "2016-04-30", end: "2016-06-30" }, v6: { start: "2016-04-26", lts: "2016-10-18", maintenance: "2018-04-30", end: "2019-04-30", codename: "Boron" }, v7: { start: "2016-10-25", maintenance: "2017-04-30", end: "2017-06-30" }, v8: { start: "2017-05-30", lts: "2017-10-31", maintenance: "2019-01-01", end: "2019-12-31", codename: "Carbon" }, v9: { start: "2017-10-01", maintenance: "2018-04-01", end: "2018-06-30" }, v10: { start: "2018-04-24", lts: "2018-10-30", maintenance: "2020-05-19", end: "2021-04-30", codename: "Dubnium" }, v11: { start: "2018-10-23", maintenance: "2019-04-22", end: "2019-06-01" }, v12: { start: "2019-04-23", lts: "2019-10-21", maintenance: "2020-11-30", end: "2022-04-30", codename: "Erbium" }, v13: { start: "2019-10-22", maintenance: "2020-04-01", end: "2020-06-01" }, v14: { start: "2020-04-21", lts: "2020-10-27", maintenance: "2021-10-19", end: "2023-04-30", codename: "Fermium" }, v15: { start: "2020-10-20", maintenance: "2021-04-01", end: "2021-06-01" }, v16: { start: "2021-04-20", lts: "2021-10-26", maintenance: "2022-10-18", end: "2023-09-11", codename: "Gallium" }, v17: { start: "2021-10-19", maintenance: "2022-04-01", end: "2022-06-01" }, v18: { start: "2022-04-19", lts: "2022-10-25", maintenance: "2023-10-18", end: "2025-04-30", codename: "Hydrogen" }, v19: { start: "2022-10-18", maintenance: "2023-04-01", end: "2023-06-01" }, v20: { start: "2023-04-18", lts: "2023-10-24", maintenance: "2024-10-22", end: "2026-04-30", codename: "" } };
  }
});

// node_modules/electron-to-chromium/versions.js
var require_versions = __commonJS({
  "node_modules/electron-to-chromium/versions.js"(exports2, module2) {
    module2.exports = {
      "0.20": "39",
      "0.21": "41",
      "0.22": "41",
      "0.23": "41",
      "0.24": "41",
      "0.25": "42",
      "0.26": "42",
      "0.27": "43",
      "0.28": "43",
      "0.29": "43",
      "0.30": "44",
      "0.31": "45",
      "0.32": "45",
      "0.33": "45",
      "0.34": "45",
      "0.35": "45",
      "0.36": "47",
      "0.37": "49",
      "1.0": "49",
      "1.1": "50",
      "1.2": "51",
      "1.3": "52",
      "1.4": "53",
      "1.5": "54",
      "1.6": "56",
      "1.7": "58",
      "1.8": "59",
      "2.0": "61",
      "2.1": "61",
      "3.0": "66",
      "3.1": "66",
      "4.0": "69",
      "4.1": "69",
      "4.2": "69",
      "5.0": "73",
      "6.0": "76",
      "6.1": "76",
      "7.0": "78",
      "7.1": "78",
      "7.2": "78",
      "7.3": "78",
      "8.0": "80",
      "8.1": "80",
      "8.2": "80",
      "8.3": "80",
      "8.4": "80",
      "8.5": "80",
      "9.0": "83",
      "9.1": "83",
      "9.2": "83",
      "9.3": "83",
      "9.4": "83",
      "10.0": "85",
      "10.1": "85",
      "10.2": "85",
      "10.3": "85",
      "10.4": "85",
      "11.0": "87",
      "11.1": "87",
      "11.2": "87",
      "11.3": "87",
      "11.4": "87",
      "11.5": "87",
      "12.0": "89",
      "12.1": "89",
      "12.2": "89",
      "13.0": "91",
      "13.1": "91",
      "13.2": "91",
      "13.3": "91",
      "13.4": "91",
      "13.5": "91",
      "13.6": "91",
      "14.0": "93",
      "14.1": "93",
      "14.2": "93",
      "15.0": "94",
      "15.1": "94",
      "15.2": "94",
      "15.3": "94",
      "15.4": "94",
      "15.5": "94",
      "16.0": "96",
      "16.1": "96",
      "16.2": "96",
      "17.0": "98",
      "17.1": "98",
      "17.2": "98",
      "17.3": "98",
      "17.4": "98",
      "18.0": "100",
      "18.1": "100",
      "18.2": "100",
      "18.3": "100",
      "19.0": "102",
      "19.1": "102",
      "20.0": "104",
      "20.1": "104",
      "20.2": "104",
      "20.3": "104",
      "21.0": "106",
      "21.1": "106",
      "21.2": "106",
      "21.3": "106",
      "21.4": "106",
      "22.0": "108",
      "22.1": "108",
      "22.2": "108",
      "22.3": "108",
      "23.0": "110",
      "23.1": "110",
      "23.2": "110",
      "23.3": "110",
      "24.0": "112",
      "24.1": "112",
      "24.2": "112",
      "24.3": "112",
      "24.4": "112",
      "24.5": "112",
      "24.6": "112",
      "24.7": "112",
      "24.8": "112",
      "25.0": "114",
      "25.1": "114",
      "25.2": "114",
      "25.3": "114",
      "25.4": "114",
      "25.5": "114",
      "25.6": "114",
      "25.7": "114",
      "25.8": "114",
      "25.9": "114",
      "26.0": "116",
      "26.1": "116",
      "26.2": "116",
      "26.3": "116",
      "26.4": "116",
      "27.0": "118",
      "28.0": "119"
    };
  }
});

// node_modules/browserslist/error.js
var require_error = __commonJS({
  "node_modules/browserslist/error.js"(exports2, module2) {
    function BrowserslistError(message) {
      this.name = "BrowserslistError";
      this.message = message;
      this.browserslist = true;
      if (Error.captureStackTrace) {
        Error.captureStackTrace(this, BrowserslistError);
      }
    }
    BrowserslistError.prototype = Error.prototype;
    module2.exports = BrowserslistError;
  }
});

// node_modules/browserslist/parse.js
var require_parse3 = __commonJS({
  "node_modules/browserslist/parse.js"(exports2, module2) {
    var AND_REGEXP = /^\s+and\s+(.*)/i;
    var OR_REGEXP = /^(?:,\s*|\s+or\s+)(.*)/i;
    function flatten(array) {
      if (!Array.isArray(array))
        return [array];
      return array.reduce(function(a, b) {
        return a.concat(flatten(b));
      }, []);
    }
    function find(string, predicate) {
      for (var n = 1, max = string.length; n <= max; n++) {
        var parsed = string.substr(-n, n);
        if (predicate(parsed, n, max)) {
          return string.slice(0, -n);
        }
      }
      return "";
    }
    function matchQuery(all, query) {
      var node = { query };
      if (query.indexOf("not ") === 0) {
        node.not = true;
        query = query.slice(4);
      }
      for (var name in all) {
        var type = all[name];
        var match = query.match(type.regexp);
        if (match) {
          node.type = name;
          for (var i = 0; i < type.matches.length; i++) {
            node[type.matches[i]] = match[i + 1];
          }
          return node;
        }
      }
      node.type = "unknown";
      return node;
    }
    function matchBlock(all, string, qs) {
      var node;
      return find(string, function(parsed, n, max) {
        if (AND_REGEXP.test(parsed)) {
          node = matchQuery(all, parsed.match(AND_REGEXP)[1]);
          node.compose = "and";
          qs.unshift(node);
          return true;
        } else if (OR_REGEXP.test(parsed)) {
          node = matchQuery(all, parsed.match(OR_REGEXP)[1]);
          node.compose = "or";
          qs.unshift(node);
          return true;
        } else if (n === max) {
          node = matchQuery(all, parsed.trim());
          node.compose = "or";
          qs.unshift(node);
          return true;
        }
        return false;
      });
    }
    module2.exports = function parse(all, queries) {
      if (!Array.isArray(queries))
        queries = [queries];
      return flatten(
        queries.map(function(block) {
          var qs = [];
          do {
            block = matchBlock(all, block, qs);
          } while (block);
          return qs;
        })
      );
    };
  }
});

// node_modules/caniuse-lite/dist/lib/statuses.js
var require_statuses = __commonJS({
  "node_modules/caniuse-lite/dist/lib/statuses.js"(exports2, module2) {
    module2.exports = {
      1: "ls",
      // WHATWG Living Standard
      2: "rec",
      // W3C Recommendation
      3: "pr",
      // W3C Proposed Recommendation
      4: "cr",
      // W3C Candidate Recommendation
      5: "wd",
      // W3C Working Draft
      6: "other",
      // Non-W3C, but reputable
      7: "unoff"
      // Unofficial, Editor's Draft or W3C "Note"
    };
  }
});

// node_modules/caniuse-lite/dist/lib/supported.js
var require_supported = __commonJS({
  "node_modules/caniuse-lite/dist/lib/supported.js"(exports2, module2) {
    module2.exports = {
      y: 1 << 0,
      n: 1 << 1,
      a: 1 << 2,
      p: 1 << 3,
      u: 1 << 4,
      x: 1 << 5,
      d: 1 << 6
    };
  }
});

// node_modules/caniuse-lite/dist/unpacker/feature.js
var require_feature = __commonJS({
  "node_modules/caniuse-lite/dist/unpacker/feature.js"(exports2, module2) {
    "use strict";
    var statuses = require_statuses();
    var supported = require_supported();
    var browsers = require_browsers2().browsers;
    var versions = require_browserVersions2().browserVersions;
    var MATH2LOG = Math.log(2);
    function unpackSupport(cipher) {
      let stats = Object.keys(supported).reduce((list, support) => {
        if (cipher & supported[support])
          list.push(support);
        return list;
      }, []);
      let notes = cipher >> 7;
      let notesArray = [];
      while (notes) {
        let note = Math.floor(Math.log(notes) / MATH2LOG) + 1;
        notesArray.unshift(`#${note}`);
        notes -= Math.pow(2, note - 1);
      }
      return stats.concat(notesArray).join(" ");
    }
    function unpackFeature(packed) {
      let unpacked = {
        status: statuses[packed.B],
        title: packed.C,
        shown: packed.D
      };
      unpacked.stats = Object.keys(packed.A).reduce((browserStats, key) => {
        let browser = packed.A[key];
        browserStats[browsers[key]] = Object.keys(browser).reduce(
          (stats, support) => {
            let packedVersions = browser[support].split(" ");
            let unpacked2 = unpackSupport(support);
            packedVersions.forEach((v) => stats[versions[v]] = unpacked2);
            return stats;
          },
          {}
        );
        return browserStats;
      }, {});
      return unpacked;
    }
    module2.exports = unpackFeature;
    module2.exports.default = unpackFeature;
  }
});

// node_modules/caniuse-lite/dist/unpacker/region.js
var require_region = __commonJS({
  "node_modules/caniuse-lite/dist/unpacker/region.js"(exports2, module2) {
    "use strict";
    var browsers = require_browsers2().browsers;
    function unpackRegion(packed) {
      return Object.keys(packed).reduce((list, browser) => {
        let data = packed[browser];
        list[browsers[browser]] = Object.keys(data).reduce((memo, key) => {
          let stats = data[key];
          if (key === "_") {
            stats.split(" ").forEach((version) => memo[version] = null);
          } else {
            memo[key] = stats;
          }
          return memo;
        }, {});
        return list;
      }, {});
    }
    module2.exports = unpackRegion;
    module2.exports.default = unpackRegion;
  }
});

// node_modules/browserslist/node.js
var require_node2 = __commonJS({
  "node_modules/browserslist/node.js"(exports2, module2) {
    var feature = require_feature().default;
    var region = require_region().default;
    var path = require("path");
    var fs = require("fs");
    var BrowserslistError = require_error();
    var IS_SECTION = /^\s*\[(.+)]\s*$/;
    var CONFIG_PATTERN = /^browserslist-config-/;
    var SCOPED_CONFIG__PATTERN = /@[^/]+\/browserslist-config(-|$|\/)/;
    var TIME_TO_UPDATE_CANIUSE = 6 * 30 * 24 * 60 * 60 * 1e3;
    var FORMAT = "Browserslist config should be a string or an array of strings with browser queries";
    var dataTimeChecked = false;
    var filenessCache = {};
    var configCache = {};
    function checkExtend(name) {
      var use = " Use `dangerousExtend` option to disable.";
      if (!CONFIG_PATTERN.test(name) && !SCOPED_CONFIG__PATTERN.test(name)) {
        throw new BrowserslistError(
          "Browserslist config needs `browserslist-config-` prefix. " + use
        );
      }
      if (name.replace(/^@[^/]+\//, "").indexOf(".") !== -1) {
        throw new BrowserslistError(
          "`.` not allowed in Browserslist config name. " + use
        );
      }
      if (name.indexOf("node_modules") !== -1) {
        throw new BrowserslistError(
          "`node_modules` not allowed in Browserslist config." + use
        );
      }
    }
    function isFile(file) {
      if (file in filenessCache) {
        return filenessCache[file];
      }
      var result = fs.existsSync(file) && fs.statSync(file).isFile();
      if (!process.env.BROWSERSLIST_DISABLE_CACHE) {
        filenessCache[file] = result;
      }
      return result;
    }
    function eachParent(file, callback) {
      var dir = isFile(file) ? path.dirname(file) : file;
      var loc = path.resolve(dir);
      do {
        var result = callback(loc);
        if (typeof result !== "undefined")
          return result;
      } while (loc !== (loc = path.dirname(loc)));
      return void 0;
    }
    function check(section) {
      if (Array.isArray(section)) {
        for (var i = 0; i < section.length; i++) {
          if (typeof section[i] !== "string") {
            throw new BrowserslistError(FORMAT);
          }
        }
      } else if (typeof section !== "string") {
        throw new BrowserslistError(FORMAT);
      }
    }
    function pickEnv(config, opts) {
      if (typeof config !== "object")
        return config;
      var name;
      if (typeof opts.env === "string") {
        name = opts.env;
      } else if (process.env.BROWSERSLIST_ENV) {
        name = process.env.BROWSERSLIST_ENV;
      } else if (process.env.NODE_ENV) {
        name = process.env.NODE_ENV;
      } else {
        name = "production";
      }
      if (opts.throwOnMissing) {
        if (name && name !== "defaults" && !config[name]) {
          throw new BrowserslistError(
            "Missing config for Browserslist environment `" + name + "`"
          );
        }
      }
      return config[name] || config.defaults;
    }
    function parsePackage(file) {
      var config = JSON.parse(
        fs.readFileSync(file).toString().replace(/^\uFEFF/m, "")
      );
      if (config.browserlist && !config.browserslist) {
        throw new BrowserslistError(
          "`browserlist` key instead of `browserslist` in " + file
        );
      }
      var list = config.browserslist;
      if (Array.isArray(list) || typeof list === "string") {
        list = { defaults: list };
      }
      for (var i in list) {
        check(list[i]);
      }
      return list;
    }
    function latestReleaseTime(agents) {
      var latest = 0;
      for (var name in agents) {
        var dates = agents[name].releaseDate || {};
        for (var key in dates) {
          if (latest < dates[key]) {
            latest = dates[key];
          }
        }
      }
      return latest * 1e3;
    }
    function normalizeStats(data, stats) {
      if (!data) {
        data = {};
      }
      if (stats && "dataByBrowser" in stats) {
        stats = stats.dataByBrowser;
      }
      if (typeof stats !== "object")
        return void 0;
      var normalized = {};
      for (var i in stats) {
        var versions = Object.keys(stats[i]);
        if (versions.length === 1 && data[i] && data[i].versions.length === 1) {
          var normal = data[i].versions[0];
          normalized[i] = {};
          normalized[i][normal] = stats[i][versions[0]];
        } else {
          normalized[i] = stats[i];
        }
      }
      return normalized;
    }
    function normalizeUsageData(usageData, data) {
      for (var browser in usageData) {
        var browserUsage = usageData[browser];
        if ("0" in browserUsage) {
          var versions = data[browser].versions;
          browserUsage[versions[versions.length - 1]] = browserUsage[0];
          delete browserUsage[0];
        }
      }
    }
    module2.exports = {
      loadQueries: function loadQueries(ctx, name) {
        if (!ctx.dangerousExtend && !process.env.BROWSERSLIST_DANGEROUS_EXTEND) {
          checkExtend(name);
        }
        var queries = require(require.resolve(name, { paths: [".", ctx.path] }));
        if (queries) {
          if (Array.isArray(queries)) {
            return queries;
          } else if (typeof queries === "object") {
            if (!queries.defaults)
              queries.defaults = [];
            return pickEnv(queries, ctx, name);
          }
        }
        throw new BrowserslistError(
          "`" + name + "` config exports not an array of queries or an object of envs"
        );
      },
      loadStat: function loadStat(ctx, name, data) {
        if (!ctx.dangerousExtend && !process.env.BROWSERSLIST_DANGEROUS_EXTEND) {
          checkExtend(name);
        }
        var stats = require(require.resolve(
          path.join(name, "browserslist-stats.json"),
          { paths: ["."] }
        ));
        return normalizeStats(data, stats);
      },
      getStat: function getStat(opts, data) {
        var stats;
        if (opts.stats) {
          stats = opts.stats;
        } else if (process.env.BROWSERSLIST_STATS) {
          stats = process.env.BROWSERSLIST_STATS;
        } else if (opts.path && path.resolve && fs.existsSync) {
          stats = eachParent(opts.path, function(dir) {
            var file = path.join(dir, "browserslist-stats.json");
            return isFile(file) ? file : void 0;
          });
        }
        if (typeof stats === "string") {
          try {
            stats = JSON.parse(fs.readFileSync(stats));
          } catch (e) {
            throw new BrowserslistError("Can't read " + stats);
          }
        }
        return normalizeStats(data, stats);
      },
      loadConfig: function loadConfig(opts) {
        if (process.env.BROWSERSLIST) {
          return process.env.BROWSERSLIST;
        } else if (opts.config || process.env.BROWSERSLIST_CONFIG) {
          var file = opts.config || process.env.BROWSERSLIST_CONFIG;
          if (path.basename(file) === "package.json") {
            return pickEnv(parsePackage(file), opts);
          } else {
            return pickEnv(module2.exports.readConfig(file), opts);
          }
        } else if (opts.path) {
          return pickEnv(module2.exports.findConfig(opts.path), opts);
        } else {
          return void 0;
        }
      },
      loadCountry: function loadCountry(usage, country, data) {
        var code = country.replace(/[^\w-]/g, "");
        if (!usage[code]) {
          var compressed;
          try {
            compressed = require("caniuse-lite/data/regions/" + code + ".js");
          } catch (e) {
            throw new BrowserslistError("Unknown region name `" + code + "`.");
          }
          var usageData = region(compressed);
          normalizeUsageData(usageData, data);
          usage[country] = {};
          for (var i in usageData) {
            for (var j in usageData[i]) {
              usage[country][i + " " + j] = usageData[i][j];
            }
          }
        }
      },
      loadFeature: function loadFeature(features, name) {
        name = name.replace(/[^\w-]/g, "");
        if (features[name])
          return;
        var compressed;
        try {
          compressed = require("caniuse-lite/data/features/" + name + ".js");
        } catch (e) {
          throw new BrowserslistError("Unknown feature name `" + name + "`.");
        }
        var stats = feature(compressed).stats;
        features[name] = {};
        for (var i in stats) {
          features[name][i] = {};
          for (var j in stats[i]) {
            features[name][i][j] = stats[i][j];
          }
        }
      },
      parseConfig: function parseConfig(string) {
        var result = { defaults: [] };
        var sections = ["defaults"];
        string.toString().replace(/#[^\n]*/g, "").split(/\n|,/).map(function(line) {
          return line.trim();
        }).filter(function(line) {
          return line !== "";
        }).forEach(function(line) {
          if (IS_SECTION.test(line)) {
            sections = line.match(IS_SECTION)[1].trim().split(" ");
            sections.forEach(function(section) {
              if (result[section]) {
                throw new BrowserslistError(
                  "Duplicate section " + section + " in Browserslist config"
                );
              }
              result[section] = [];
            });
          } else {
            sections.forEach(function(section) {
              result[section].push(line);
            });
          }
        });
        return result;
      },
      readConfig: function readConfig(file) {
        if (!isFile(file)) {
          throw new BrowserslistError("Can't read " + file + " config");
        }
        return module2.exports.parseConfig(fs.readFileSync(file));
      },
      findConfig: function findConfig(from) {
        from = path.resolve(from);
        var passed = [];
        var resolved = eachParent(from, function(dir) {
          if (dir in configCache) {
            return configCache[dir];
          }
          passed.push(dir);
          var config = path.join(dir, "browserslist");
          var pkg = path.join(dir, "package.json");
          var rc = path.join(dir, ".browserslistrc");
          var pkgBrowserslist;
          if (isFile(pkg)) {
            try {
              pkgBrowserslist = parsePackage(pkg);
            } catch (e) {
              if (e.name === "BrowserslistError")
                throw e;
              console.warn(
                "[Browserslist] Could not parse " + pkg + ". Ignoring it."
              );
            }
          }
          if (isFile(config) && pkgBrowserslist) {
            throw new BrowserslistError(
              dir + " contains both browserslist and package.json with browsers"
            );
          } else if (isFile(rc) && pkgBrowserslist) {
            throw new BrowserslistError(
              dir + " contains both .browserslistrc and package.json with browsers"
            );
          } else if (isFile(config) && isFile(rc)) {
            throw new BrowserslistError(
              dir + " contains both .browserslistrc and browserslist"
            );
          } else if (isFile(config)) {
            return module2.exports.readConfig(config);
          } else if (isFile(rc)) {
            return module2.exports.readConfig(rc);
          } else {
            return pkgBrowserslist;
          }
        });
        if (!process.env.BROWSERSLIST_DISABLE_CACHE) {
          passed.forEach(function(dir) {
            configCache[dir] = resolved;
          });
        }
        return resolved;
      },
      clearCaches: function clearCaches() {
        dataTimeChecked = false;
        filenessCache = {};
        configCache = {};
        this.cache = {};
      },
      oldDataWarning: function oldDataWarning(agentsObj) {
        if (dataTimeChecked)
          return;
        dataTimeChecked = true;
        if (process.env.BROWSERSLIST_IGNORE_OLD_DATA)
          return;
        var latest = latestReleaseTime(agentsObj);
        var halfYearAgo = Date.now() - TIME_TO_UPDATE_CANIUSE;
        if (latest !== 0 && latest < halfYearAgo) {
          console.warn(
            "Browserslist: caniuse-lite is outdated. Please run:\n  npx update-browserslist-db@latest\n  Why you should do it regularly: https://github.com/browserslist/update-db#readme"
          );
        }
      },
      currentNode: function currentNode() {
        return "node " + process.versions.node;
      },
      env: process.env
    };
  }
});

// node_modules/browserslist/index.js
var require_browserslist = __commonJS({
  "node_modules/browserslist/index.js"(exports2, module2) {
    var jsReleases = require_envs();
    var agents = require_agents2().agents;
    var jsEOL = require_release_schedule();
    var path = require("path");
    var e2c = require_versions();
    var BrowserslistError = require_error();
    var parse = require_parse3();
    var env = require_node2();
    var YEAR = 365.259641 * 24 * 60 * 60 * 1e3;
    var ANDROID_EVERGREEN_FIRST = "37";
    var OP_MOB_BLINK_FIRST = 14;
    function isVersionsMatch(versionA, versionB) {
      return (versionA + ".").indexOf(versionB + ".") === 0;
    }
    function isEolReleased(name) {
      var version = name.slice(1);
      return browserslist.nodeVersions.some(function(i) {
        return isVersionsMatch(i, version);
      });
    }
    function normalize(versions) {
      return versions.filter(function(version) {
        return typeof version === "string";
      });
    }
    function normalizeElectron(version) {
      var versionToUse = version;
      if (version.split(".").length === 3) {
        versionToUse = version.split(".").slice(0, -1).join(".");
      }
      return versionToUse;
    }
    function nameMapper(name) {
      return function mapName(version) {
        return name + " " + version;
      };
    }
    function getMajor(version) {
      return parseInt(version.split(".")[0]);
    }
    function getMajorVersions(released, number) {
      if (released.length === 0)
        return [];
      var majorVersions = uniq(released.map(getMajor));
      var minimum = majorVersions[majorVersions.length - number];
      if (!minimum) {
        return released;
      }
      var selected = [];
      for (var i = released.length - 1; i >= 0; i--) {
        if (minimum > getMajor(released[i]))
          break;
        selected.unshift(released[i]);
      }
      return selected;
    }
    function uniq(array) {
      var filtered = [];
      for (var i = 0; i < array.length; i++) {
        if (filtered.indexOf(array[i]) === -1)
          filtered.push(array[i]);
      }
      return filtered;
    }
    function fillUsage(result, name, data) {
      for (var i in data) {
        result[name + " " + i] = data[i];
      }
    }
    function generateFilter(sign, version) {
      version = parseFloat(version);
      if (sign === ">") {
        return function(v) {
          return parseFloat(v) > version;
        };
      } else if (sign === ">=") {
        return function(v) {
          return parseFloat(v) >= version;
        };
      } else if (sign === "<") {
        return function(v) {
          return parseFloat(v) < version;
        };
      } else {
        return function(v) {
          return parseFloat(v) <= version;
        };
      }
    }
    function generateSemverFilter(sign, version) {
      version = version.split(".").map(parseSimpleInt);
      version[1] = version[1] || 0;
      version[2] = version[2] || 0;
      if (sign === ">") {
        return function(v) {
          v = v.split(".").map(parseSimpleInt);
          return compareSemver(v, version) > 0;
        };
      } else if (sign === ">=") {
        return function(v) {
          v = v.split(".").map(parseSimpleInt);
          return compareSemver(v, version) >= 0;
        };
      } else if (sign === "<") {
        return function(v) {
          v = v.split(".").map(parseSimpleInt);
          return compareSemver(version, v) > 0;
        };
      } else {
        return function(v) {
          v = v.split(".").map(parseSimpleInt);
          return compareSemver(version, v) >= 0;
        };
      }
    }
    function parseSimpleInt(x) {
      return parseInt(x);
    }
    function compare(a, b) {
      if (a < b)
        return -1;
      if (a > b)
        return 1;
      return 0;
    }
    function compareSemver(a, b) {
      return compare(parseInt(a[0]), parseInt(b[0])) || compare(parseInt(a[1] || "0"), parseInt(b[1] || "0")) || compare(parseInt(a[2] || "0"), parseInt(b[2] || "0"));
    }
    function semverFilterLoose(operator, range) {
      range = range.split(".").map(parseSimpleInt);
      if (typeof range[1] === "undefined") {
        range[1] = "x";
      }
      switch (operator) {
        case "<=":
          return function(version) {
            version = version.split(".").map(parseSimpleInt);
            return compareSemverLoose(version, range) <= 0;
          };
        case ">=":
        default:
          return function(version) {
            version = version.split(".").map(parseSimpleInt);
            return compareSemverLoose(version, range) >= 0;
          };
      }
    }
    function compareSemverLoose(version, range) {
      if (version[0] !== range[0]) {
        return version[0] < range[0] ? -1 : 1;
      }
      if (range[1] === "x") {
        return 0;
      }
      if (version[1] !== range[1]) {
        return version[1] < range[1] ? -1 : 1;
      }
      return 0;
    }
    function resolveVersion(data, version) {
      if (data.versions.indexOf(version) !== -1) {
        return version;
      } else if (browserslist.versionAliases[data.name][version]) {
        return browserslist.versionAliases[data.name][version];
      } else {
        return false;
      }
    }
    function normalizeVersion(data, version) {
      var resolved = resolveVersion(data, version);
      if (resolved) {
        return resolved;
      } else if (data.versions.length === 1) {
        return data.versions[0];
      } else {
        return false;
      }
    }
    function filterByYear(since, context) {
      since = since / 1e3;
      return Object.keys(agents).reduce(function(selected, name) {
        var data = byName(name, context);
        if (!data)
          return selected;
        var versions = Object.keys(data.releaseDate).filter(function(v) {
          var date = data.releaseDate[v];
          return date !== null && date >= since;
        });
        return selected.concat(versions.map(nameMapper(data.name)));
      }, []);
    }
    function cloneData(data) {
      return {
        name: data.name,
        versions: data.versions,
        released: data.released,
        releaseDate: data.releaseDate
      };
    }
    function byName(name, context) {
      name = name.toLowerCase();
      name = browserslist.aliases[name] || name;
      if (context.mobileToDesktop && browserslist.desktopNames[name]) {
        var desktop = browserslist.data[browserslist.desktopNames[name]];
        if (name === "android") {
          return normalizeAndroidData(cloneData(browserslist.data[name]), desktop);
        } else {
          var cloned = cloneData(desktop);
          cloned.name = name;
          return cloned;
        }
      }
      return browserslist.data[name];
    }
    function normalizeAndroidVersions(androidVersions, chromeVersions) {
      var iFirstEvergreen = chromeVersions.indexOf(ANDROID_EVERGREEN_FIRST);
      return androidVersions.filter(function(version) {
        return /^(?:[2-4]\.|[34]$)/.test(version);
      }).concat(chromeVersions.slice(iFirstEvergreen));
    }
    function normalizeAndroidData(android, chrome) {
      android.released = normalizeAndroidVersions(android.released, chrome.released);
      android.versions = normalizeAndroidVersions(android.versions, chrome.versions);
      android.released.forEach(function(v) {
        if (android.releaseDate[v] === void 0) {
          android.releaseDate[v] = chrome.releaseDate[v];
        }
      });
      return android;
    }
    function checkName(name, context) {
      var data = byName(name, context);
      if (!data)
        throw new BrowserslistError("Unknown browser " + name);
      return data;
    }
    function unknownQuery(query) {
      return new BrowserslistError(
        "Unknown browser query `" + query + "`. Maybe you are using old Browserslist or made typo in query."
      );
    }
    function filterJumps(list, name, nVersions, context) {
      var jump = 1;
      switch (name) {
        case "android":
          if (context.mobileToDesktop)
            return list;
          var released = browserslist.data.chrome.released;
          jump = released.length - released.indexOf(ANDROID_EVERGREEN_FIRST);
          break;
        case "op_mob":
          var latest = browserslist.data.op_mob.released.slice(-1)[0];
          jump = getMajor(latest) - OP_MOB_BLINK_FIRST + 1;
          break;
        default:
          return list;
      }
      if (nVersions <= jump) {
        return list.slice(-1);
      }
      return list.slice(jump - 1 - nVersions);
    }
    function isSupported(flags, withPartial) {
      return typeof flags === "string" && (flags.indexOf("y") >= 0 || withPartial && flags.indexOf("a") >= 0);
    }
    function resolve(queries, context) {
      return parse(QUERIES, queries).reduce(function(result, node, index) {
        if (node.not && index === 0) {
          throw new BrowserslistError(
            "Write any browsers query (for instance, `defaults`) before `" + node.query + "`"
          );
        }
        var type = QUERIES[node.type];
        var array = type.select.call(browserslist, context, node).map(function(j) {
          var parts = j.split(" ");
          if (parts[1] === "0") {
            return parts[0] + " " + byName(parts[0], context).versions[0];
          } else {
            return j;
          }
        });
        if (node.compose === "and") {
          if (node.not) {
            return result.filter(function(j) {
              return array.indexOf(j) === -1;
            });
          } else {
            return result.filter(function(j) {
              return array.indexOf(j) !== -1;
            });
          }
        } else {
          if (node.not) {
            var filter = {};
            array.forEach(function(j) {
              filter[j] = true;
            });
            return result.filter(function(j) {
              return !filter[j];
            });
          }
          return result.concat(array);
        }
      }, []);
    }
    function prepareOpts(opts) {
      if (typeof opts === "undefined")
        opts = {};
      if (typeof opts.path === "undefined") {
        opts.path = path.resolve ? path.resolve(".") : ".";
      }
      return opts;
    }
    function prepareQueries(queries, opts) {
      if (typeof queries === "undefined" || queries === null) {
        var config = browserslist.loadConfig(opts);
        if (config) {
          queries = config;
        } else {
          queries = browserslist.defaults;
        }
      }
      return queries;
    }
    function checkQueries(queries) {
      if (!(typeof queries === "string" || Array.isArray(queries))) {
        throw new BrowserslistError(
          "Browser queries must be an array or string. Got " + typeof queries + "."
        );
      }
    }
    var cache = {};
    function browserslist(queries, opts) {
      opts = prepareOpts(opts);
      queries = prepareQueries(queries, opts);
      checkQueries(queries);
      var context = {
        ignoreUnknownVersions: opts.ignoreUnknownVersions,
        dangerousExtend: opts.dangerousExtend,
        mobileToDesktop: opts.mobileToDesktop,
        path: opts.path,
        env: opts.env
      };
      env.oldDataWarning(browserslist.data);
      var stats = env.getStat(opts, browserslist.data);
      if (stats) {
        context.customUsage = {};
        for (var browser in stats) {
          fillUsage(context.customUsage, browser, stats[browser]);
        }
      }
      var cacheKey = JSON.stringify([queries, context]);
      if (cache[cacheKey])
        return cache[cacheKey];
      var result = uniq(resolve(queries, context)).sort(function(name1, name2) {
        name1 = name1.split(" ");
        name2 = name2.split(" ");
        if (name1[0] === name2[0]) {
          var version1 = name1[1].split("-")[0];
          var version2 = name2[1].split("-")[0];
          return compareSemver(version2.split("."), version1.split("."));
        } else {
          return compare(name1[0], name2[0]);
        }
      });
      if (!env.env.BROWSERSLIST_DISABLE_CACHE) {
        cache[cacheKey] = result;
      }
      return result;
    }
    browserslist.parse = function(queries, opts) {
      opts = prepareOpts(opts);
      queries = prepareQueries(queries, opts);
      checkQueries(queries);
      return parse(QUERIES, queries);
    };
    browserslist.cache = {};
    browserslist.data = {};
    browserslist.usage = {
      global: {},
      custom: null
    };
    browserslist.defaults = ["> 0.5%", "last 2 versions", "Firefox ESR", "not dead"];
    browserslist.aliases = {
      fx: "firefox",
      ff: "firefox",
      ios: "ios_saf",
      explorer: "ie",
      blackberry: "bb",
      explorermobile: "ie_mob",
      operamini: "op_mini",
      operamobile: "op_mob",
      chromeandroid: "and_chr",
      firefoxandroid: "and_ff",
      ucandroid: "and_uc",
      qqandroid: "and_qq"
    };
    browserslist.desktopNames = {
      and_chr: "chrome",
      and_ff: "firefox",
      ie_mob: "ie",
      android: "chrome"
      // has extra processing logic
    };
    browserslist.versionAliases = {};
    browserslist.clearCaches = env.clearCaches;
    browserslist.parseConfig = env.parseConfig;
    browserslist.readConfig = env.readConfig;
    browserslist.findConfig = env.findConfig;
    browserslist.loadConfig = env.loadConfig;
    browserslist.coverage = function(browsers, stats) {
      var data;
      if (typeof stats === "undefined") {
        data = browserslist.usage.global;
      } else if (stats === "my stats") {
        var opts = {};
        opts.path = path.resolve ? path.resolve(".") : ".";
        var customStats = env.getStat(opts);
        if (!customStats) {
          throw new BrowserslistError("Custom usage statistics was not provided");
        }
        data = {};
        for (var browser in customStats) {
          fillUsage(data, browser, customStats[browser]);
        }
      } else if (typeof stats === "string") {
        if (stats.length > 2) {
          stats = stats.toLowerCase();
        } else {
          stats = stats.toUpperCase();
        }
        env.loadCountry(browserslist.usage, stats, browserslist.data);
        data = browserslist.usage[stats];
      } else {
        if ("dataByBrowser" in stats) {
          stats = stats.dataByBrowser;
        }
        data = {};
        for (var name in stats) {
          for (var version in stats[name]) {
            data[name + " " + version] = stats[name][version];
          }
        }
      }
      return browsers.reduce(function(all, i) {
        var usage = data[i];
        if (usage === void 0) {
          usage = data[i.replace(/ \S+$/, " 0")];
        }
        return all + (usage || 0);
      }, 0);
    };
    function nodeQuery(context, node) {
      var matched = browserslist.nodeVersions.filter(function(i) {
        return isVersionsMatch(i, node.version);
      });
      if (matched.length === 0) {
        if (context.ignoreUnknownVersions) {
          return [];
        } else {
          throw new BrowserslistError(
            "Unknown version " + node.version + " of Node.js"
          );
        }
      }
      return ["node " + matched[matched.length - 1]];
    }
    function sinceQuery(context, node) {
      var year = parseInt(node.year);
      var month = parseInt(node.month || "01") - 1;
      var day = parseInt(node.day || "01");
      return filterByYear(Date.UTC(year, month, day, 0, 0, 0), context);
    }
    function coverQuery(context, node) {
      var coverage = parseFloat(node.coverage);
      var usage = browserslist.usage.global;
      if (node.place) {
        if (node.place.match(/^my\s+stats$/i)) {
          if (!context.customUsage) {
            throw new BrowserslistError("Custom usage statistics was not provided");
          }
          usage = context.customUsage;
        } else {
          var place;
          if (node.place.length === 2) {
            place = node.place.toUpperCase();
          } else {
            place = node.place.toLowerCase();
          }
          env.loadCountry(browserslist.usage, place, browserslist.data);
          usage = browserslist.usage[place];
        }
      }
      var versions = Object.keys(usage).sort(function(a, b) {
        return usage[b] - usage[a];
      });
      var coveraged = 0;
      var result = [];
      var version;
      for (var i = 0; i < versions.length; i++) {
        version = versions[i];
        if (usage[version] === 0)
          break;
        coveraged += usage[version];
        result.push(version);
        if (coveraged >= coverage)
          break;
      }
      return result;
    }
    var QUERIES = {
      last_major_versions: {
        matches: ["versions"],
        regexp: /^last\s+(\d+)\s+major\s+versions?$/i,
        select: function(context, node) {
          return Object.keys(agents).reduce(function(selected, name) {
            var data = byName(name, context);
            if (!data)
              return selected;
            var list = getMajorVersions(data.released, node.versions);
            list = list.map(nameMapper(data.name));
            list = filterJumps(list, data.name, node.versions, context);
            return selected.concat(list);
          }, []);
        }
      },
      last_versions: {
        matches: ["versions"],
        regexp: /^last\s+(\d+)\s+versions?$/i,
        select: function(context, node) {
          return Object.keys(agents).reduce(function(selected, name) {
            var data = byName(name, context);
            if (!data)
              return selected;
            var list = data.released.slice(-node.versions);
            list = list.map(nameMapper(data.name));
            list = filterJumps(list, data.name, node.versions, context);
            return selected.concat(list);
          }, []);
        }
      },
      last_electron_major_versions: {
        matches: ["versions"],
        regexp: /^last\s+(\d+)\s+electron\s+major\s+versions?$/i,
        select: function(context, node) {
          var validVersions = getMajorVersions(Object.keys(e2c), node.versions);
          return validVersions.map(function(i) {
            return "chrome " + e2c[i];
          });
        }
      },
      last_node_major_versions: {
        matches: ["versions"],
        regexp: /^last\s+(\d+)\s+node\s+major\s+versions?$/i,
        select: function(context, node) {
          return getMajorVersions(browserslist.nodeVersions, node.versions).map(
            function(version) {
              return "node " + version;
            }
          );
        }
      },
      last_browser_major_versions: {
        matches: ["versions", "browser"],
        regexp: /^last\s+(\d+)\s+(\w+)\s+major\s+versions?$/i,
        select: function(context, node) {
          var data = checkName(node.browser, context);
          var validVersions = getMajorVersions(data.released, node.versions);
          var list = validVersions.map(nameMapper(data.name));
          list = filterJumps(list, data.name, node.versions, context);
          return list;
        }
      },
      last_electron_versions: {
        matches: ["versions"],
        regexp: /^last\s+(\d+)\s+electron\s+versions?$/i,
        select: function(context, node) {
          return Object.keys(e2c).slice(-node.versions).map(function(i) {
            return "chrome " + e2c[i];
          });
        }
      },
      last_node_versions: {
        matches: ["versions"],
        regexp: /^last\s+(\d+)\s+node\s+versions?$/i,
        select: function(context, node) {
          return browserslist.nodeVersions.slice(-node.versions).map(function(version) {
            return "node " + version;
          });
        }
      },
      last_browser_versions: {
        matches: ["versions", "browser"],
        regexp: /^last\s+(\d+)\s+(\w+)\s+versions?$/i,
        select: function(context, node) {
          var data = checkName(node.browser, context);
          var list = data.released.slice(-node.versions).map(nameMapper(data.name));
          list = filterJumps(list, data.name, node.versions, context);
          return list;
        }
      },
      unreleased_versions: {
        matches: [],
        regexp: /^unreleased\s+versions$/i,
        select: function(context) {
          return Object.keys(agents).reduce(function(selected, name) {
            var data = byName(name, context);
            if (!data)
              return selected;
            var list = data.versions.filter(function(v) {
              return data.released.indexOf(v) === -1;
            });
            list = list.map(nameMapper(data.name));
            return selected.concat(list);
          }, []);
        }
      },
      unreleased_electron_versions: {
        matches: [],
        regexp: /^unreleased\s+electron\s+versions?$/i,
        select: function() {
          return [];
        }
      },
      unreleased_browser_versions: {
        matches: ["browser"],
        regexp: /^unreleased\s+(\w+)\s+versions?$/i,
        select: function(context, node) {
          var data = checkName(node.browser, context);
          return data.versions.filter(function(v) {
            return data.released.indexOf(v) === -1;
          }).map(nameMapper(data.name));
        }
      },
      last_years: {
        matches: ["years"],
        regexp: /^last\s+(\d*.?\d+)\s+years?$/i,
        select: function(context, node) {
          return filterByYear(Date.now() - YEAR * node.years, context);
        }
      },
      since_y: {
        matches: ["year"],
        regexp: /^since (\d+)$/i,
        select: sinceQuery
      },
      since_y_m: {
        matches: ["year", "month"],
        regexp: /^since (\d+)-(\d+)$/i,
        select: sinceQuery
      },
      since_y_m_d: {
        matches: ["year", "month", "day"],
        regexp: /^since (\d+)-(\d+)-(\d+)$/i,
        select: sinceQuery
      },
      popularity: {
        matches: ["sign", "popularity"],
        regexp: /^(>=?|<=?)\s*(\d+|\d+\.\d+|\.\d+)%$/,
        select: function(context, node) {
          var popularity = parseFloat(node.popularity);
          var usage = browserslist.usage.global;
          return Object.keys(usage).reduce(function(result, version) {
            if (node.sign === ">") {
              if (usage[version] > popularity) {
                result.push(version);
              }
            } else if (node.sign === "<") {
              if (usage[version] < popularity) {
                result.push(version);
              }
            } else if (node.sign === "<=") {
              if (usage[version] <= popularity) {
                result.push(version);
              }
            } else if (usage[version] >= popularity) {
              result.push(version);
            }
            return result;
          }, []);
        }
      },
      popularity_in_my_stats: {
        matches: ["sign", "popularity"],
        regexp: /^(>=?|<=?)\s*(\d+|\d+\.\d+|\.\d+)%\s+in\s+my\s+stats$/,
        select: function(context, node) {
          var popularity = parseFloat(node.popularity);
          if (!context.customUsage) {
            throw new BrowserslistError("Custom usage statistics was not provided");
          }
          var usage = context.customUsage;
          return Object.keys(usage).reduce(function(result, version) {
            var percentage = usage[version];
            if (percentage == null) {
              return result;
            }
            if (node.sign === ">") {
              if (percentage > popularity) {
                result.push(version);
              }
            } else if (node.sign === "<") {
              if (percentage < popularity) {
                result.push(version);
              }
            } else if (node.sign === "<=") {
              if (percentage <= popularity) {
                result.push(version);
              }
            } else if (percentage >= popularity) {
              result.push(version);
            }
            return result;
          }, []);
        }
      },
      popularity_in_config_stats: {
        matches: ["sign", "popularity", "config"],
        regexp: /^(>=?|<=?)\s*(\d+|\d+\.\d+|\.\d+)%\s+in\s+(\S+)\s+stats$/,
        select: function(context, node) {
          var popularity = parseFloat(node.popularity);
          var stats = env.loadStat(context, node.config, browserslist.data);
          if (stats) {
            context.customUsage = {};
            for (var browser in stats) {
              fillUsage(context.customUsage, browser, stats[browser]);
            }
          }
          if (!context.customUsage) {
            throw new BrowserslistError("Custom usage statistics was not provided");
          }
          var usage = context.customUsage;
          return Object.keys(usage).reduce(function(result, version) {
            var percentage = usage[version];
            if (percentage == null) {
              return result;
            }
            if (node.sign === ">") {
              if (percentage > popularity) {
                result.push(version);
              }
            } else if (node.sign === "<") {
              if (percentage < popularity) {
                result.push(version);
              }
            } else if (node.sign === "<=") {
              if (percentage <= popularity) {
                result.push(version);
              }
            } else if (percentage >= popularity) {
              result.push(version);
            }
            return result;
          }, []);
        }
      },
      popularity_in_place: {
        matches: ["sign", "popularity", "place"],
        regexp: /^(>=?|<=?)\s*(\d+|\d+\.\d+|\.\d+)%\s+in\s+((alt-)?\w\w)$/,
        select: function(context, node) {
          var popularity = parseFloat(node.popularity);
          var place = node.place;
          if (place.length === 2) {
            place = place.toUpperCase();
          } else {
            place = place.toLowerCase();
          }
          env.loadCountry(browserslist.usage, place, browserslist.data);
          var usage = browserslist.usage[place];
          return Object.keys(usage).reduce(function(result, version) {
            var percentage = usage[version];
            if (percentage == null) {
              return result;
            }
            if (node.sign === ">") {
              if (percentage > popularity) {
                result.push(version);
              }
            } else if (node.sign === "<") {
              if (percentage < popularity) {
                result.push(version);
              }
            } else if (node.sign === "<=") {
              if (percentage <= popularity) {
                result.push(version);
              }
            } else if (percentage >= popularity) {
              result.push(version);
            }
            return result;
          }, []);
        }
      },
      cover: {
        matches: ["coverage"],
        regexp: /^cover\s+(\d+|\d+\.\d+|\.\d+)%$/i,
        select: coverQuery
      },
      cover_in: {
        matches: ["coverage", "place"],
        regexp: /^cover\s+(\d+|\d+\.\d+|\.\d+)%\s+in\s+(my\s+stats|(alt-)?\w\w)$/i,
        select: coverQuery
      },
      supports: {
        matches: ["supportType", "feature"],
        regexp: /^(?:(fully|partially) )?supports\s+([\w-]+)$/,
        select: function(context, node) {
          env.loadFeature(browserslist.cache, node.feature);
          var withPartial = node.supportType !== "fully";
          var features = browserslist.cache[node.feature];
          var result = [];
          for (var name in features) {
            var data = byName(name, context);
            var checkDesktop = context.mobileToDesktop && name in browserslist.desktopNames && isSupported(features[name][data.released.slice(-1)[0]], withPartial);
            data.versions.forEach(function(version) {
              var flags = features[name][version];
              if (flags === void 0 && checkDesktop) {
                flags = features[browserslist.desktopNames[name]][version];
              }
              if (isSupported(flags, withPartial)) {
                result.push(name + " " + version);
              }
            });
          }
          return result;
        }
      },
      electron_range: {
        matches: ["from", "to"],
        regexp: /^electron\s+([\d.]+)\s*-\s*([\d.]+)$/i,
        select: function(context, node) {
          var fromToUse = normalizeElectron(node.from);
          var toToUse = normalizeElectron(node.to);
          var from = parseFloat(node.from);
          var to = parseFloat(node.to);
          if (!e2c[fromToUse]) {
            throw new BrowserslistError("Unknown version " + from + " of electron");
          }
          if (!e2c[toToUse]) {
            throw new BrowserslistError("Unknown version " + to + " of electron");
          }
          return Object.keys(e2c).filter(function(i) {
            var parsed = parseFloat(i);
            return parsed >= from && parsed <= to;
          }).map(function(i) {
            return "chrome " + e2c[i];
          });
        }
      },
      node_range: {
        matches: ["from", "to"],
        regexp: /^node\s+([\d.]+)\s*-\s*([\d.]+)$/i,
        select: function(context, node) {
          return browserslist.nodeVersions.filter(semverFilterLoose(">=", node.from)).filter(semverFilterLoose("<=", node.to)).map(function(v) {
            return "node " + v;
          });
        }
      },
      browser_range: {
        matches: ["browser", "from", "to"],
        regexp: /^(\w+)\s+([\d.]+)\s*-\s*([\d.]+)$/i,
        select: function(context, node) {
          var data = checkName(node.browser, context);
          var from = parseFloat(normalizeVersion(data, node.from) || node.from);
          var to = parseFloat(normalizeVersion(data, node.to) || node.to);
          function filter(v) {
            var parsed = parseFloat(v);
            return parsed >= from && parsed <= to;
          }
          return data.released.filter(filter).map(nameMapper(data.name));
        }
      },
      electron_ray: {
        matches: ["sign", "version"],
        regexp: /^electron\s*(>=?|<=?)\s*([\d.]+)$/i,
        select: function(context, node) {
          var versionToUse = normalizeElectron(node.version);
          return Object.keys(e2c).filter(generateFilter(node.sign, versionToUse)).map(function(i) {
            return "chrome " + e2c[i];
          });
        }
      },
      node_ray: {
        matches: ["sign", "version"],
        regexp: /^node\s*(>=?|<=?)\s*([\d.]+)$/i,
        select: function(context, node) {
          return browserslist.nodeVersions.filter(generateSemverFilter(node.sign, node.version)).map(function(v) {
            return "node " + v;
          });
        }
      },
      browser_ray: {
        matches: ["browser", "sign", "version"],
        regexp: /^(\w+)\s*(>=?|<=?)\s*([\d.]+)$/,
        select: function(context, node) {
          var version = node.version;
          var data = checkName(node.browser, context);
          var alias = browserslist.versionAliases[data.name][version];
          if (alias)
            version = alias;
          return data.released.filter(generateFilter(node.sign, version)).map(function(v) {
            return data.name + " " + v;
          });
        }
      },
      firefox_esr: {
        matches: [],
        regexp: /^(firefox|ff|fx)\s+esr$/i,
        select: function() {
          return ["firefox 115"];
        }
      },
      opera_mini_all: {
        matches: [],
        regexp: /(operamini|op_mini)\s+all/i,
        select: function() {
          return ["op_mini all"];
        }
      },
      electron_version: {
        matches: ["version"],
        regexp: /^electron\s+([\d.]+)$/i,
        select: function(context, node) {
          var versionToUse = normalizeElectron(node.version);
          var chrome = e2c[versionToUse];
          if (!chrome) {
            throw new BrowserslistError(
              "Unknown version " + node.version + " of electron"
            );
          }
          return ["chrome " + chrome];
        }
      },
      node_major_version: {
        matches: ["version"],
        regexp: /^node\s+(\d+)$/i,
        select: nodeQuery
      },
      node_minor_version: {
        matches: ["version"],
        regexp: /^node\s+(\d+\.\d+)$/i,
        select: nodeQuery
      },
      node_patch_version: {
        matches: ["version"],
        regexp: /^node\s+(\d+\.\d+\.\d+)$/i,
        select: nodeQuery
      },
      current_node: {
        matches: [],
        regexp: /^current\s+node$/i,
        select: function(context) {
          return [env.currentNode(resolve, context)];
        }
      },
      maintained_node: {
        matches: [],
        regexp: /^maintained\s+node\s+versions$/i,
        select: function(context) {
          var now = Date.now();
          var queries = Object.keys(jsEOL).filter(function(key) {
            return now < Date.parse(jsEOL[key].end) && now > Date.parse(jsEOL[key].start) && isEolReleased(key);
          }).map(function(key) {
            return "node " + key.slice(1);
          });
          return resolve(queries, context);
        }
      },
      phantomjs_1_9: {
        matches: [],
        regexp: /^phantomjs\s+1.9$/i,
        select: function() {
          return ["safari 5"];
        }
      },
      phantomjs_2_1: {
        matches: [],
        regexp: /^phantomjs\s+2.1$/i,
        select: function() {
          return ["safari 6"];
        }
      },
      browser_version: {
        matches: ["browser", "version"],
        regexp: /^(\w+)\s+(tp|[\d.]+)$/i,
        select: function(context, node) {
          var version = node.version;
          if (/^tp$/i.test(version))
            version = "TP";
          var data = checkName(node.browser, context);
          var alias = normalizeVersion(data, version);
          if (alias) {
            version = alias;
          } else {
            if (version.indexOf(".") === -1) {
              alias = version + ".0";
            } else {
              alias = version.replace(/\.0$/, "");
            }
            alias = normalizeVersion(data, alias);
            if (alias) {
              version = alias;
            } else if (context.ignoreUnknownVersions) {
              return [];
            } else {
              throw new BrowserslistError(
                "Unknown version " + version + " of " + node.browser
              );
            }
          }
          return [data.name + " " + version];
        }
      },
      browserslist_config: {
        matches: [],
        regexp: /^browserslist config$/i,
        select: function(context) {
          return browserslist(void 0, context);
        }
      },
      extends: {
        matches: ["config"],
        regexp: /^extends (.+)$/i,
        select: function(context, node) {
          return resolve(env.loadQueries(context, node.config), context);
        }
      },
      defaults: {
        matches: [],
        regexp: /^defaults$/i,
        select: function(context) {
          return resolve(browserslist.defaults, context);
        }
      },
      dead: {
        matches: [],
        regexp: /^dead$/i,
        select: function(context) {
          var dead = [
            "Baidu >= 0",
            "ie <= 11",
            "ie_mob <= 11",
            "bb <= 10",
            "op_mob <= 12.1",
            "samsung 4"
          ];
          return resolve(dead, context);
        }
      },
      unknown: {
        matches: [],
        regexp: /^(\w+)$/i,
        select: function(context, node) {
          if (byName(node.query, context)) {
            throw new BrowserslistError(
              "Specify versions in Browserslist query for browser " + node.query
            );
          } else {
            throw unknownQuery(node.query);
          }
        }
      }
    };
    (function() {
      for (var name in agents) {
        var browser = agents[name];
        browserslist.data[name] = {
          name,
          versions: normalize(agents[name].versions),
          released: normalize(agents[name].versions.slice(0, -3)),
          releaseDate: agents[name].release_date
        };
        fillUsage(browserslist.usage.global, name, browser.usage_global);
        browserslist.versionAliases[name] = {};
        for (var i = 0; i < browser.versions.length; i++) {
          var full = browser.versions[i];
          if (!full)
            continue;
          if (full.indexOf("-") !== -1) {
            var interval = full.split("-");
            for (var j = 0; j < interval.length; j++) {
              browserslist.versionAliases[name][interval[j]] = full;
            }
          }
        }
      }
      browserslist.nodeVersions = jsReleases.map(function(release) {
        return release.version;
      });
    })();
    module2.exports = browserslist;
  }
});

// node_modules/autoprefixer/lib/utils.js
var require_utils = __commonJS({
  "node_modules/autoprefixer/lib/utils.js"(exports2, module2) {
    var { list } = require_postcss();
    module2.exports.error = function(text) {
      let err = new Error(text);
      err.autoprefixer = true;
      throw err;
    };
    module2.exports.uniq = function(array) {
      return [...new Set(array)];
    };
    module2.exports.removeNote = function(string) {
      if (!string.includes(" ")) {
        return string;
      }
      return string.split(" ")[0];
    };
    module2.exports.escapeRegexp = function(string) {
      return string.replace(/[$()*+-.?[\\\]^{|}]/g, "\\$&");
    };
    module2.exports.regexp = function(word, escape = true) {
      if (escape) {
        word = this.escapeRegexp(word);
      }
      return new RegExp(`(^|[\\s,(])(${word}($|[\\s(,]))`, "gi");
    };
    module2.exports.editList = function(value, callback) {
      let origin = list.comma(value);
      let changed = callback(origin, []);
      if (origin === changed) {
        return value;
      }
      let join = value.match(/,\s*/);
      join = join ? join[0] : ", ";
      return changed.join(join);
    };
    module2.exports.splitSelector = function(selector) {
      return list.comma(selector).map((i) => {
        return list.space(i).map((k) => {
          return k.split(/(?=\.|#)/g);
        });
      });
    };
    module2.exports.isPureNumber = function(value) {
      if (typeof value === "number") {
        return true;
      }
      if (typeof value === "string") {
        return /^[0-9]+$/.test(value);
      }
      return false;
    };
  }
});

// node_modules/autoprefixer/lib/browsers.js
var require_browsers3 = __commonJS({
  "node_modules/autoprefixer/lib/browsers.js"(exports2, module2) {
    var browserslist = require_browserslist();
    var { agents } = require_agents2();
    var utils = require_utils();
    var Browsers = class {
      /**
       * Return all prefixes for default browser data
       */
      static prefixes() {
        if (this.prefixesCache) {
          return this.prefixesCache;
        }
        this.prefixesCache = [];
        for (let name in agents) {
          this.prefixesCache.push(`-${agents[name].prefix}-`);
        }
        this.prefixesCache = utils.uniq(this.prefixesCache).sort((a, b) => b.length - a.length);
        return this.prefixesCache;
      }
      /**
       * Check is value contain any possible prefix
       */
      static withPrefix(value) {
        if (!this.prefixesRegexp) {
          this.prefixesRegexp = new RegExp(this.prefixes().join("|"));
        }
        return this.prefixesRegexp.test(value);
      }
      constructor(data, requirements, options, browserslistOpts) {
        this.data = data;
        this.options = options || {};
        this.browserslistOpts = browserslistOpts || {};
        this.selected = this.parse(requirements);
      }
      /**
       * Return browsers selected by requirements
       */
      parse(requirements) {
        let opts = {};
        for (let i in this.browserslistOpts) {
          opts[i] = this.browserslistOpts[i];
        }
        opts.path = this.options.from;
        return browserslist(requirements, opts);
      }
      /**
       * Return prefix for selected browser
       */
      prefix(browser) {
        let [name, version] = browser.split(" ");
        let data = this.data[name];
        let prefix = data.prefix_exceptions && data.prefix_exceptions[version];
        if (!prefix) {
          prefix = data.prefix;
        }
        return `-${prefix}-`;
      }
      /**
       * Is browser is selected by requirements
       */
      isSelected(browser) {
        return this.selected.includes(browser);
      }
    };
    module2.exports = Browsers;
  }
});

// node_modules/autoprefixer/lib/vendor.js
var require_vendor = __commonJS({
  "node_modules/autoprefixer/lib/vendor.js"(exports2, module2) {
    module2.exports = {
      prefix(prop) {
        let match = prop.match(/^(-\w+-)/);
        if (match) {
          return match[0];
        }
        return "";
      },
      unprefixed(prop) {
        return prop.replace(/^-\w+-/, "");
      }
    };
  }
});

// node_modules/autoprefixer/lib/prefixer.js
var require_prefixer = __commonJS({
  "node_modules/autoprefixer/lib/prefixer.js"(exports2, module2) {
    var Browsers = require_browsers3();
    var vendor = require_vendor();
    var utils = require_utils();
    function clone(obj, parent) {
      let cloned = new obj.constructor();
      for (let i of Object.keys(obj || {})) {
        let value = obj[i];
        if (i === "parent" && typeof value === "object") {
          if (parent) {
            cloned[i] = parent;
          }
        } else if (i === "source" || i === null) {
          cloned[i] = value;
        } else if (Array.isArray(value)) {
          cloned[i] = value.map((x) => clone(x, cloned));
        } else if (i !== "_autoprefixerPrefix" && i !== "_autoprefixerValues" && i !== "proxyCache") {
          if (typeof value === "object" && value !== null) {
            value = clone(value, cloned);
          }
          cloned[i] = value;
        }
      }
      return cloned;
    }
    var Prefixer = class _Prefixer {
      /**
       * Add hack to selected names
       */
      static hack(klass) {
        if (!this.hacks) {
          this.hacks = {};
        }
        return klass.names.map((name) => {
          this.hacks[name] = klass;
          return this.hacks[name];
        });
      }
      /**
       * Load hacks for some names
       */
      static load(name, prefixes, all) {
        let Klass = this.hacks && this.hacks[name];
        if (Klass) {
          return new Klass(name, prefixes, all);
        } else {
          return new this(name, prefixes, all);
        }
      }
      /**
       * Clone node and clean autprefixer custom caches
       */
      static clone(node, overrides) {
        let cloned = clone(node);
        for (let name in overrides) {
          cloned[name] = overrides[name];
        }
        return cloned;
      }
      constructor(name, prefixes, all) {
        this.prefixes = prefixes;
        this.name = name;
        this.all = all;
      }
      /**
       * Find prefix in node parents
       */
      parentPrefix(node) {
        let prefix;
        if (typeof node._autoprefixerPrefix !== "undefined") {
          prefix = node._autoprefixerPrefix;
        } else if (node.type === "decl" && node.prop[0] === "-") {
          prefix = vendor.prefix(node.prop);
        } else if (node.type === "root") {
          prefix = false;
        } else if (node.type === "rule" && node.selector.includes(":-") && /:(-\w+-)/.test(node.selector)) {
          prefix = node.selector.match(/:(-\w+-)/)[1];
        } else if (node.type === "atrule" && node.name[0] === "-") {
          prefix = vendor.prefix(node.name);
        } else {
          prefix = this.parentPrefix(node.parent);
        }
        if (!Browsers.prefixes().includes(prefix)) {
          prefix = false;
        }
        node._autoprefixerPrefix = prefix;
        return node._autoprefixerPrefix;
      }
      /**
       * Clone node with prefixes
       */
      process(node, result) {
        if (!this.check(node)) {
          return void 0;
        }
        let parent = this.parentPrefix(node);
        let prefixes = this.prefixes.filter(
          (prefix) => !parent || parent === utils.removeNote(prefix)
        );
        let added = [];
        for (let prefix of prefixes) {
          if (this.add(node, prefix, added.concat([prefix]), result)) {
            added.push(prefix);
          }
        }
        return added;
      }
      /**
       * Shortcut for Prefixer.clone
       */
      clone(node, overrides) {
        return _Prefixer.clone(node, overrides);
      }
    };
    module2.exports = Prefixer;
  }
});

// node_modules/autoprefixer/lib/declaration.js
var require_declaration2 = __commonJS({
  "node_modules/autoprefixer/lib/declaration.js"(exports2, module2) {
    var Prefixer = require_prefixer();
    var Browsers = require_browsers3();
    var utils = require_utils();
    var Declaration = class extends Prefixer {
      /**
       * Always true, because we already get prefixer by property name
       */
      check() {
        return true;
      }
      /**
       * Return prefixed version of property
       */
      prefixed(prop, prefix) {
        return prefix + prop;
      }
      /**
       * Return unprefixed version of property
       */
      normalize(prop) {
        return prop;
      }
      /**
       * Check `value`, that it contain other prefixes, rather than `prefix`
       */
      otherPrefixes(value, prefix) {
        for (let other of Browsers.prefixes()) {
          if (other === prefix) {
            continue;
          }
          if (value.includes(other)) {
            return value.replace(/var\([^)]+\)/, "").includes(other);
          }
        }
        return false;
      }
      /**
       * Set prefix to declaration
       */
      set(decl, prefix) {
        decl.prop = this.prefixed(decl.prop, prefix);
        return decl;
      }
      /**
       * Should we use visual cascade for prefixes
       */
      needCascade(decl) {
        if (!decl._autoprefixerCascade) {
          decl._autoprefixerCascade = this.all.options.cascade !== false && decl.raw("before").includes("\n");
        }
        return decl._autoprefixerCascade;
      }
      /**
       * Return maximum length of possible prefixed property
       */
      maxPrefixed(prefixes, decl) {
        if (decl._autoprefixerMax) {
          return decl._autoprefixerMax;
        }
        let max = 0;
        for (let prefix of prefixes) {
          prefix = utils.removeNote(prefix);
          if (prefix.length > max) {
            max = prefix.length;
          }
        }
        decl._autoprefixerMax = max;
        return decl._autoprefixerMax;
      }
      /**
       * Calculate indentation to create visual cascade
       */
      calcBefore(prefixes, decl, prefix = "") {
        let max = this.maxPrefixed(prefixes, decl);
        let diff = max - utils.removeNote(prefix).length;
        let before = decl.raw("before");
        if (diff > 0) {
          before += Array(diff).fill(" ").join("");
        }
        return before;
      }
      /**
       * Remove visual cascade
       */
      restoreBefore(decl) {
        let lines = decl.raw("before").split("\n");
        let min = lines[lines.length - 1];
        this.all.group(decl).up((prefixed) => {
          let array = prefixed.raw("before").split("\n");
          let last = array[array.length - 1];
          if (last.length < min.length) {
            min = last;
          }
        });
        lines[lines.length - 1] = min;
        decl.raws.before = lines.join("\n");
      }
      /**
       * Clone and insert new declaration
       */
      insert(decl, prefix, prefixes) {
        let cloned = this.set(this.clone(decl), prefix);
        if (!cloned)
          return void 0;
        let already = decl.parent.some(
          (i) => i.prop === cloned.prop && i.value === cloned.value
        );
        if (already) {
          return void 0;
        }
        if (this.needCascade(decl)) {
          cloned.raws.before = this.calcBefore(prefixes, decl, prefix);
        }
        return decl.parent.insertBefore(decl, cloned);
      }
      /**
       * Did this declaration has this prefix above
       */
      isAlready(decl, prefixed) {
        let already = this.all.group(decl).up((i) => i.prop === prefixed);
        if (!already) {
          already = this.all.group(decl).down((i) => i.prop === prefixed);
        }
        return already;
      }
      /**
       * Clone and add prefixes for declaration
       */
      add(decl, prefix, prefixes, result) {
        let prefixed = this.prefixed(decl.prop, prefix);
        if (this.isAlready(decl, prefixed) || this.otherPrefixes(decl.value, prefix)) {
          return void 0;
        }
        return this.insert(decl, prefix, prefixes, result);
      }
      /**
       * Add spaces for visual cascade
       */
      process(decl, result) {
        if (!this.needCascade(decl)) {
          super.process(decl, result);
          return;
        }
        let prefixes = super.process(decl, result);
        if (!prefixes || !prefixes.length) {
          return;
        }
        this.restoreBefore(decl);
        decl.raws.before = this.calcBefore(prefixes, decl);
      }
      /**
       * Return list of prefixed properties to clean old prefixes
       */
      old(prop, prefix) {
        return [this.prefixed(prop, prefix)];
      }
    };
    module2.exports = Declaration;
  }
});

// node_modules/fraction.js/fraction.js
var require_fraction = __commonJS({
  "node_modules/fraction.js/fraction.js"(exports2, module2) {
    (function(root) {
      "use strict";
      var MAX_CYCLE_LEN = 2e3;
      var P = {
        "s": 1,
        "n": 0,
        "d": 1
      };
      function assign(n, s) {
        if (isNaN(n = parseInt(n, 10))) {
          throw Fraction["InvalidParameter"];
        }
        return n * s;
      }
      function newFraction(n, d) {
        if (d === 0) {
          throw Fraction["DivisionByZero"];
        }
        var f = Object.create(Fraction.prototype);
        f["s"] = n < 0 ? -1 : 1;
        n = n < 0 ? -n : n;
        var a = gcd(n, d);
        f["n"] = n / a;
        f["d"] = d / a;
        return f;
      }
      function factorize(num) {
        var factors = {};
        var n = num;
        var i = 2;
        var s = 4;
        while (s <= n) {
          while (n % i === 0) {
            n /= i;
            factors[i] = (factors[i] || 0) + 1;
          }
          s += 1 + 2 * i++;
        }
        if (n !== num) {
          if (n > 1)
            factors[n] = (factors[n] || 0) + 1;
        } else {
          factors[num] = (factors[num] || 0) + 1;
        }
        return factors;
      }
      var parse = function(p1, p2) {
        var n = 0, d = 1, s = 1;
        var v = 0, w = 0, x = 0, y = 1, z = 1;
        var A = 0, B = 1;
        var C = 1, D = 1;
        var N = 1e7;
        var M;
        if (p1 === void 0 || p1 === null) {
        } else if (p2 !== void 0) {
          n = p1;
          d = p2;
          s = n * d;
          if (n % 1 !== 0 || d % 1 !== 0) {
            throw Fraction["NonIntegerParameter"];
          }
        } else
          switch (typeof p1) {
            case "object": {
              if ("d" in p1 && "n" in p1) {
                n = p1["n"];
                d = p1["d"];
                if ("s" in p1)
                  n *= p1["s"];
              } else if (0 in p1) {
                n = p1[0];
                if (1 in p1)
                  d = p1[1];
              } else {
                throw Fraction["InvalidParameter"];
              }
              s = n * d;
              break;
            }
            case "number": {
              if (p1 < 0) {
                s = p1;
                p1 = -p1;
              }
              if (p1 % 1 === 0) {
                n = p1;
              } else if (p1 > 0) {
                if (p1 >= 1) {
                  z = Math.pow(10, Math.floor(1 + Math.log(p1) / Math.LN10));
                  p1 /= z;
                }
                while (B <= N && D <= N) {
                  M = (A + C) / (B + D);
                  if (p1 === M) {
                    if (B + D <= N) {
                      n = A + C;
                      d = B + D;
                    } else if (D > B) {
                      n = C;
                      d = D;
                    } else {
                      n = A;
                      d = B;
                    }
                    break;
                  } else {
                    if (p1 > M) {
                      A += C;
                      B += D;
                    } else {
                      C += A;
                      D += B;
                    }
                    if (B > N) {
                      n = C;
                      d = D;
                    } else {
                      n = A;
                      d = B;
                    }
                  }
                }
                n *= z;
              } else if (isNaN(p1) || isNaN(p2)) {
                d = n = NaN;
              }
              break;
            }
            case "string": {
              B = p1.match(/\d+|./g);
              if (B === null)
                throw Fraction["InvalidParameter"];
              if (B[A] === "-") {
                s = -1;
                A++;
              } else if (B[A] === "+") {
                A++;
              }
              if (B.length === A + 1) {
                w = assign(B[A++], s);
              } else if (B[A + 1] === "." || B[A] === ".") {
                if (B[A] !== ".") {
                  v = assign(B[A++], s);
                }
                A++;
                if (A + 1 === B.length || B[A + 1] === "(" && B[A + 3] === ")" || B[A + 1] === "'" && B[A + 3] === "'") {
                  w = assign(B[A], s);
                  y = Math.pow(10, B[A].length);
                  A++;
                }
                if (B[A] === "(" && B[A + 2] === ")" || B[A] === "'" && B[A + 2] === "'") {
                  x = assign(B[A + 1], s);
                  z = Math.pow(10, B[A + 1].length) - 1;
                  A += 3;
                }
              } else if (B[A + 1] === "/" || B[A + 1] === ":") {
                w = assign(B[A], s);
                y = assign(B[A + 2], 1);
                A += 3;
              } else if (B[A + 3] === "/" && B[A + 1] === " ") {
                v = assign(B[A], s);
                w = assign(B[A + 2], s);
                y = assign(B[A + 4], 1);
                A += 5;
              }
              if (B.length <= A) {
                d = y * z;
                s = /* void */
                n = x + d * v + z * w;
                break;
              }
            }
            default:
              throw Fraction["InvalidParameter"];
          }
        if (d === 0) {
          throw Fraction["DivisionByZero"];
        }
        P["s"] = s < 0 ? -1 : 1;
        P["n"] = Math.abs(n);
        P["d"] = Math.abs(d);
      };
      function modpow(b, e, m) {
        var r = 1;
        for (; e > 0; b = b * b % m, e >>= 1) {
          if (e & 1) {
            r = r * b % m;
          }
        }
        return r;
      }
      function cycleLen(n, d) {
        for (; d % 2 === 0; d /= 2) {
        }
        for (; d % 5 === 0; d /= 5) {
        }
        if (d === 1)
          return 0;
        var rem = 10 % d;
        var t = 1;
        for (; rem !== 1; t++) {
          rem = rem * 10 % d;
          if (t > MAX_CYCLE_LEN)
            return 0;
        }
        return t;
      }
      function cycleStart(n, d, len) {
        var rem1 = 1;
        var rem2 = modpow(10, len, d);
        for (var t = 0; t < 300; t++) {
          if (rem1 === rem2)
            return t;
          rem1 = rem1 * 10 % d;
          rem2 = rem2 * 10 % d;
        }
        return 0;
      }
      function gcd(a, b) {
        if (!a)
          return b;
        if (!b)
          return a;
        while (1) {
          a %= b;
          if (!a)
            return b;
          b %= a;
          if (!b)
            return a;
        }
      }
      ;
      function Fraction(a, b) {
        parse(a, b);
        if (this instanceof Fraction) {
          a = gcd(P["d"], P["n"]);
          this["s"] = P["s"];
          this["n"] = P["n"] / a;
          this["d"] = P["d"] / a;
        } else {
          return newFraction(P["s"] * P["n"], P["d"]);
        }
      }
      Fraction["DivisionByZero"] = new Error("Division by Zero");
      Fraction["InvalidParameter"] = new Error("Invalid argument");
      Fraction["NonIntegerParameter"] = new Error("Parameters must be integer");
      Fraction.prototype = {
        "s": 1,
        "n": 0,
        "d": 1,
        /**
         * Calculates the absolute value
         *
         * Ex: new Fraction(-4).abs() => 4
         **/
        "abs": function() {
          return newFraction(this["n"], this["d"]);
        },
        /**
         * Inverts the sign of the current fraction
         *
         * Ex: new Fraction(-4).neg() => 4
         **/
        "neg": function() {
          return newFraction(-this["s"] * this["n"], this["d"]);
        },
        /**
         * Adds two rational numbers
         *
         * Ex: new Fraction({n: 2, d: 3}).add("14.9") => 467 / 30
         **/
        "add": function(a, b) {
          parse(a, b);
          return newFraction(
            this["s"] * this["n"] * P["d"] + P["s"] * this["d"] * P["n"],
            this["d"] * P["d"]
          );
        },
        /**
         * Subtracts two rational numbers
         *
         * Ex: new Fraction({n: 2, d: 3}).add("14.9") => -427 / 30
         **/
        "sub": function(a, b) {
          parse(a, b);
          return newFraction(
            this["s"] * this["n"] * P["d"] - P["s"] * this["d"] * P["n"],
            this["d"] * P["d"]
          );
        },
        /**
         * Multiplies two rational numbers
         *
         * Ex: new Fraction("-17.(345)").mul(3) => 5776 / 111
         **/
        "mul": function(a, b) {
          parse(a, b);
          return newFraction(
            this["s"] * P["s"] * this["n"] * P["n"],
            this["d"] * P["d"]
          );
        },
        /**
         * Divides two rational numbers
         *
         * Ex: new Fraction("-17.(345)").inverse().div(3)
         **/
        "div": function(a, b) {
          parse(a, b);
          return newFraction(
            this["s"] * P["s"] * this["n"] * P["d"],
            this["d"] * P["n"]
          );
        },
        /**
         * Clones the actual object
         *
         * Ex: new Fraction("-17.(345)").clone()
         **/
        "clone": function() {
          return newFraction(this["s"] * this["n"], this["d"]);
        },
        /**
         * Calculates the modulo of two rational numbers - a more precise fmod
         *
         * Ex: new Fraction('4.(3)').mod([7, 8]) => (13/3) % (7/8) = (5/6)
         **/
        "mod": function(a, b) {
          if (isNaN(this["n"]) || isNaN(this["d"])) {
            return new Fraction(NaN);
          }
          if (a === void 0) {
            return newFraction(this["s"] * this["n"] % this["d"], 1);
          }
          parse(a, b);
          if (0 === P["n"] && 0 === this["d"]) {
            throw Fraction["DivisionByZero"];
          }
          return newFraction(
            this["s"] * (P["d"] * this["n"]) % (P["n"] * this["d"]),
            P["d"] * this["d"]
          );
        },
        /**
         * Calculates the fractional gcd of two rational numbers
         *
         * Ex: new Fraction(5,8).gcd(3,7) => 1/56
         */
        "gcd": function(a, b) {
          parse(a, b);
          return newFraction(gcd(P["n"], this["n"]) * gcd(P["d"], this["d"]), P["d"] * this["d"]);
        },
        /**
         * Calculates the fractional lcm of two rational numbers
         *
         * Ex: new Fraction(5,8).lcm(3,7) => 15
         */
        "lcm": function(a, b) {
          parse(a, b);
          if (P["n"] === 0 && this["n"] === 0) {
            return newFraction(0, 1);
          }
          return newFraction(P["n"] * this["n"], gcd(P["n"], this["n"]) * gcd(P["d"], this["d"]));
        },
        /**
         * Calculates the ceil of a rational number
         *
         * Ex: new Fraction('4.(3)').ceil() => (5 / 1)
         **/
        "ceil": function(places) {
          places = Math.pow(10, places || 0);
          if (isNaN(this["n"]) || isNaN(this["d"])) {
            return new Fraction(NaN);
          }
          return newFraction(Math.ceil(places * this["s"] * this["n"] / this["d"]), places);
        },
        /**
         * Calculates the floor of a rational number
         *
         * Ex: new Fraction('4.(3)').floor() => (4 / 1)
         **/
        "floor": function(places) {
          places = Math.pow(10, places || 0);
          if (isNaN(this["n"]) || isNaN(this["d"])) {
            return new Fraction(NaN);
          }
          return newFraction(Math.floor(places * this["s"] * this["n"] / this["d"]), places);
        },
        /**
         * Rounds a rational numbers
         *
         * Ex: new Fraction('4.(3)').round() => (4 / 1)
         **/
        "round": function(places) {
          places = Math.pow(10, places || 0);
          if (isNaN(this["n"]) || isNaN(this["d"])) {
            return new Fraction(NaN);
          }
          return newFraction(Math.round(places * this["s"] * this["n"] / this["d"]), places);
        },
        /**
         * Gets the inverse of the fraction, means numerator and denominator are exchanged
         *
         * Ex: new Fraction([-3, 4]).inverse() => -4 / 3
         **/
        "inverse": function() {
          return newFraction(this["s"] * this["d"], this["n"]);
        },
        /**
         * Calculates the fraction to some rational exponent, if possible
         *
         * Ex: new Fraction(-1,2).pow(-3) => -8
         */
        "pow": function(a, b) {
          parse(a, b);
          if (P["d"] === 1) {
            if (P["s"] < 0) {
              return newFraction(Math.pow(this["s"] * this["d"], P["n"]), Math.pow(this["n"], P["n"]));
            } else {
              return newFraction(Math.pow(this["s"] * this["n"], P["n"]), Math.pow(this["d"], P["n"]));
            }
          }
          if (this["s"] < 0)
            return null;
          var N = factorize(this["n"]);
          var D = factorize(this["d"]);
          var n = 1;
          var d = 1;
          for (var k in N) {
            if (k === "1")
              continue;
            if (k === "0") {
              n = 0;
              break;
            }
            N[k] *= P["n"];
            if (N[k] % P["d"] === 0) {
              N[k] /= P["d"];
            } else
              return null;
            n *= Math.pow(k, N[k]);
          }
          for (var k in D) {
            if (k === "1")
              continue;
            D[k] *= P["n"];
            if (D[k] % P["d"] === 0) {
              D[k] /= P["d"];
            } else
              return null;
            d *= Math.pow(k, D[k]);
          }
          if (P["s"] < 0) {
            return newFraction(d, n);
          }
          return newFraction(n, d);
        },
        /**
         * Check if two rational numbers are the same
         *
         * Ex: new Fraction(19.6).equals([98, 5]);
         **/
        "equals": function(a, b) {
          parse(a, b);
          return this["s"] * this["n"] * P["d"] === P["s"] * P["n"] * this["d"];
        },
        /**
         * Check if two rational numbers are the same
         *
         * Ex: new Fraction(19.6).equals([98, 5]);
         **/
        "compare": function(a, b) {
          parse(a, b);
          var t = this["s"] * this["n"] * P["d"] - P["s"] * P["n"] * this["d"];
          return (0 < t) - (t < 0);
        },
        "simplify": function(eps) {
          if (isNaN(this["n"]) || isNaN(this["d"])) {
            return this;
          }
          eps = eps || 1e-3;
          var thisABS = this["abs"]();
          var cont = thisABS["toContinued"]();
          for (var i = 1; i < cont.length; i++) {
            var s = newFraction(cont[i - 1], 1);
            for (var k = i - 2; k >= 0; k--) {
              s = s["inverse"]()["add"](cont[k]);
            }
            if (s["sub"](thisABS)["abs"]().valueOf() < eps) {
              return s["mul"](this["s"]);
            }
          }
          return this;
        },
        /**
         * Check if two rational numbers are divisible
         *
         * Ex: new Fraction(19.6).divisible(1.5);
         */
        "divisible": function(a, b) {
          parse(a, b);
          return !(!(P["n"] * this["d"]) || this["n"] * P["d"] % (P["n"] * this["d"]));
        },
        /**
         * Returns a decimal representation of the fraction
         *
         * Ex: new Fraction("100.'91823'").valueOf() => 100.91823918239183
         **/
        "valueOf": function() {
          return this["s"] * this["n"] / this["d"];
        },
        /**
         * Returns a string-fraction representation of a Fraction object
         *
         * Ex: new Fraction("1.'3'").toFraction(true) => "4 1/3"
         **/
        "toFraction": function(excludeWhole) {
          var whole, str = "";
          var n = this["n"];
          var d = this["d"];
          if (this["s"] < 0) {
            str += "-";
          }
          if (d === 1) {
            str += n;
          } else {
            if (excludeWhole && (whole = Math.floor(n / d)) > 0) {
              str += whole;
              str += " ";
              n %= d;
            }
            str += n;
            str += "/";
            str += d;
          }
          return str;
        },
        /**
         * Returns a latex representation of a Fraction object
         *
         * Ex: new Fraction("1.'3'").toLatex() => "\frac{4}{3}"
         **/
        "toLatex": function(excludeWhole) {
          var whole, str = "";
          var n = this["n"];
          var d = this["d"];
          if (this["s"] < 0) {
            str += "-";
          }
          if (d === 1) {
            str += n;
          } else {
            if (excludeWhole && (whole = Math.floor(n / d)) > 0) {
              str += whole;
              n %= d;
            }
            str += "\\frac{";
            str += n;
            str += "}{";
            str += d;
            str += "}";
          }
          return str;
        },
        /**
         * Returns an array of continued fraction elements
         *
         * Ex: new Fraction("7/8").toContinued() => [0,1,7]
         */
        "toContinued": function() {
          var t;
          var a = this["n"];
          var b = this["d"];
          var res = [];
          if (isNaN(a) || isNaN(b)) {
            return res;
          }
          do {
            res.push(Math.floor(a / b));
            t = a % b;
            a = b;
            b = t;
          } while (a !== 1);
          return res;
        },
        /**
         * Creates a string representation of a fraction with all digits
         *
         * Ex: new Fraction("100.'91823'").toString() => "100.(91823)"
         **/
        "toString": function(dec) {
          var N = this["n"];
          var D = this["d"];
          if (isNaN(N) || isNaN(D)) {
            return "NaN";
          }
          dec = dec || 15;
          var cycLen = cycleLen(N, D);
          var cycOff = cycleStart(N, D, cycLen);
          var str = this["s"] < 0 ? "-" : "";
          str += N / D | 0;
          N %= D;
          N *= 10;
          if (N)
            str += ".";
          if (cycLen) {
            for (var i = cycOff; i--; ) {
              str += N / D | 0;
              N %= D;
              N *= 10;
            }
            str += "(";
            for (var i = cycLen; i--; ) {
              str += N / D | 0;
              N %= D;
              N *= 10;
            }
            str += ")";
          } else {
            for (var i = dec; N && i--; ) {
              str += N / D | 0;
              N %= D;
              N *= 10;
            }
          }
          return str;
        }
      };
      if (typeof define === "function" && define["amd"]) {
        define([], function() {
          return Fraction;
        });
      } else if (typeof exports2 === "object") {
        Object.defineProperty(Fraction, "__esModule", { "value": true });
        Fraction["default"] = Fraction;
        Fraction["Fraction"] = Fraction;
        module2["exports"] = Fraction;
      } else {
        root["Fraction"] = Fraction;
      }
    })(exports2);
  }
});

// node_modules/autoprefixer/lib/resolution.js
var require_resolution = __commonJS({
  "node_modules/autoprefixer/lib/resolution.js"(exports2, module2) {
    var FractionJs = require_fraction();
    var Prefixer = require_prefixer();
    var utils = require_utils();
    var REGEXP = /(min|max)-resolution\s*:\s*\d*\.?\d+(dppx|dpcm|dpi|x)/gi;
    var SPLIT = /(min|max)-resolution(\s*:\s*)(\d*\.?\d+)(dppx|dpcm|dpi|x)/i;
    var Resolution = class extends Prefixer {
      /**
       * Return prefixed query name
       */
      prefixName(prefix, name) {
        if (prefix === "-moz-") {
          return name + "--moz-device-pixel-ratio";
        } else {
          return prefix + name + "-device-pixel-ratio";
        }
      }
      /**
       * Return prefixed query
       */
      prefixQuery(prefix, name, colon, value, units) {
        value = new FractionJs(value);
        if (units === "dpi") {
          value = value.div(96);
        } else if (units === "dpcm") {
          value = value.mul(2.54).div(96);
        }
        value = value.simplify();
        if (prefix === "-o-") {
          value = value.n + "/" + value.d;
        }
        return this.prefixName(prefix, name) + colon + value;
      }
      /**
       * Remove prefixed queries
       */
      clean(rule) {
        if (!this.bad) {
          this.bad = [];
          for (let prefix of this.prefixes) {
            this.bad.push(this.prefixName(prefix, "min"));
            this.bad.push(this.prefixName(prefix, "max"));
          }
        }
        rule.params = utils.editList(rule.params, (queries) => {
          return queries.filter((query) => this.bad.every((i) => !query.includes(i)));
        });
      }
      /**
       * Add prefixed queries
       */
      process(rule) {
        let parent = this.parentPrefix(rule);
        let prefixes = parent ? [parent] : this.prefixes;
        rule.params = utils.editList(rule.params, (origin, prefixed) => {
          for (let query of origin) {
            if (!query.includes("min-resolution") && !query.includes("max-resolution")) {
              prefixed.push(query);
              continue;
            }
            for (let prefix of prefixes) {
              let processed = query.replace(REGEXP, (str) => {
                let parts = str.match(SPLIT);
                return this.prefixQuery(
                  prefix,
                  parts[1],
                  parts[2],
                  parts[3],
                  parts[4]
                );
              });
              prefixed.push(processed);
            }
            prefixed.push(query);
          }
          return utils.uniq(prefixed);
        });
      }
    };
    module2.exports = Resolution;
  }
});

// node_modules/autoprefixer/lib/transition.js
var require_transition = __commonJS({
  "node_modules/autoprefixer/lib/transition.js"(exports2, module2) {
    var { list } = require_postcss();
    var parser = require_lib();
    var Browsers = require_browsers3();
    var vendor = require_vendor();
    var Transition = class {
      constructor(prefixes) {
        this.props = ["transition", "transition-property"];
        this.prefixes = prefixes;
      }
      /**
       * Process transition and add prefixes for all necessary properties
       */
      add(decl, result) {
        let prefix, prop;
        let add = this.prefixes.add[decl.prop];
        let vendorPrefixes = this.ruleVendorPrefixes(decl);
        let declPrefixes = vendorPrefixes || add && add.prefixes || [];
        let params = this.parse(decl.value);
        let names = params.map((i) => this.findProp(i));
        let added = [];
        if (names.some((i) => i[0] === "-")) {
          return;
        }
        for (let param of params) {
          prop = this.findProp(param);
          if (prop[0] === "-")
            continue;
          let prefixer = this.prefixes.add[prop];
          if (!prefixer || !prefixer.prefixes)
            continue;
          for (prefix of prefixer.prefixes) {
            if (vendorPrefixes && !vendorPrefixes.some((p) => prefix.includes(p))) {
              continue;
            }
            let prefixed = this.prefixes.prefixed(prop, prefix);
            if (prefixed !== "-ms-transform" && !names.includes(prefixed)) {
              if (!this.disabled(prop, prefix)) {
                added.push(this.clone(prop, prefixed, param));
              }
            }
          }
        }
        params = params.concat(added);
        let value = this.stringify(params);
        let webkitClean = this.stringify(
          this.cleanFromUnprefixed(params, "-webkit-")
        );
        if (declPrefixes.includes("-webkit-")) {
          this.cloneBefore(decl, `-webkit-${decl.prop}`, webkitClean);
        }
        this.cloneBefore(decl, decl.prop, webkitClean);
        if (declPrefixes.includes("-o-")) {
          let operaClean = this.stringify(this.cleanFromUnprefixed(params, "-o-"));
          this.cloneBefore(decl, `-o-${decl.prop}`, operaClean);
        }
        for (prefix of declPrefixes) {
          if (prefix !== "-webkit-" && prefix !== "-o-") {
            let prefixValue = this.stringify(
              this.cleanOtherPrefixes(params, prefix)
            );
            this.cloneBefore(decl, prefix + decl.prop, prefixValue);
          }
        }
        if (value !== decl.value && !this.already(decl, decl.prop, value)) {
          this.checkForWarning(result, decl);
          decl.cloneBefore();
          decl.value = value;
        }
      }
      /**
       * Find property name
       */
      findProp(param) {
        let prop = param[0].value;
        if (/^\d/.test(prop)) {
          for (let [i, token] of param.entries()) {
            if (i !== 0 && token.type === "word") {
              return token.value;
            }
          }
        }
        return prop;
      }
      /**
       * Does we already have this declaration
       */
      already(decl, prop, value) {
        return decl.parent.some((i) => i.prop === prop && i.value === value);
      }
      /**
       * Add declaration if it is not exist
       */
      cloneBefore(decl, prop, value) {
        if (!this.already(decl, prop, value)) {
          decl.cloneBefore({ prop, value });
        }
      }
      /**
       * Show transition-property warning
       */
      checkForWarning(result, decl) {
        if (decl.prop !== "transition-property") {
          return;
        }
        let isPrefixed = false;
        let hasAssociatedProp = false;
        decl.parent.each((i) => {
          if (i.type !== "decl") {
            return void 0;
          }
          if (i.prop.indexOf("transition-") !== 0) {
            return void 0;
          }
          let values = list.comma(i.value);
          if (i.prop === "transition-property") {
            values.forEach((value) => {
              let lookup = this.prefixes.add[value];
              if (lookup && lookup.prefixes && lookup.prefixes.length > 0) {
                isPrefixed = true;
              }
            });
            return void 0;
          }
          hasAssociatedProp = hasAssociatedProp || values.length > 1;
          return false;
        });
        if (isPrefixed && hasAssociatedProp) {
          decl.warn(
            result,
            "Replace transition-property to transition, because Autoprefixer could not support any cases of transition-property and other transition-*"
          );
        }
      }
      /**
       * Process transition and remove all unnecessary properties
       */
      remove(decl) {
        let params = this.parse(decl.value);
        params = params.filter((i) => {
          let prop = this.prefixes.remove[this.findProp(i)];
          return !prop || !prop.remove;
        });
        let value = this.stringify(params);
        if (decl.value === value) {
          return;
        }
        if (params.length === 0) {
          decl.remove();
          return;
        }
        let double = decl.parent.some((i) => {
          return i.prop === decl.prop && i.value === value;
        });
        let smaller = decl.parent.some((i) => {
          return i !== decl && i.prop === decl.prop && i.value.length > value.length;
        });
        if (double || smaller) {
          decl.remove();
          return;
        }
        decl.value = value;
      }
      /**
       * Parse properties list to array
       */
      parse(value) {
        let ast = parser(value);
        let result = [];
        let param = [];
        for (let node of ast.nodes) {
          param.push(node);
          if (node.type === "div" && node.value === ",") {
            result.push(param);
            param = [];
          }
        }
        result.push(param);
        return result.filter((i) => i.length > 0);
      }
      /**
       * Return properties string from array
       */
      stringify(params) {
        if (params.length === 0) {
          return "";
        }
        let nodes = [];
        for (let param of params) {
          if (param[param.length - 1].type !== "div") {
            param.push(this.div(params));
          }
          nodes = nodes.concat(param);
        }
        if (nodes[0].type === "div") {
          nodes = nodes.slice(1);
        }
        if (nodes[nodes.length - 1].type === "div") {
          nodes = nodes.slice(0, -2 + 1 || void 0);
        }
        return parser.stringify({ nodes });
      }
      /**
       * Return new param array with different name
       */
      clone(origin, name, param) {
        let result = [];
        let changed = false;
        for (let i of param) {
          if (!changed && i.type === "word" && i.value === origin) {
            result.push({ type: "word", value: name });
            changed = true;
          } else {
            result.push(i);
          }
        }
        return result;
      }
      /**
       * Find or create separator
       */
      div(params) {
        for (let param of params) {
          for (let node of param) {
            if (node.type === "div" && node.value === ",") {
              return node;
            }
          }
        }
        return { type: "div", value: ",", after: " " };
      }
      cleanOtherPrefixes(params, prefix) {
        return params.filter((param) => {
          let current = vendor.prefix(this.findProp(param));
          return current === "" || current === prefix;
        });
      }
      /**
       * Remove all non-webkit prefixes and unprefixed params if we have prefixed
       */
      cleanFromUnprefixed(params, prefix) {
        let remove = params.map((i) => this.findProp(i)).filter((i) => i.slice(0, prefix.length) === prefix).map((i) => this.prefixes.unprefixed(i));
        let result = [];
        for (let param of params) {
          let prop = this.findProp(param);
          let p = vendor.prefix(prop);
          if (!remove.includes(prop) && (p === prefix || p === "")) {
            result.push(param);
          }
        }
        return result;
      }
      /**
       * Check property for disabled by option
       */
      disabled(prop, prefix) {
        let other = ["order", "justify-content", "align-self", "align-content"];
        if (prop.includes("flex") || other.includes(prop)) {
          if (this.prefixes.options.flexbox === false) {
            return true;
          }
          if (this.prefixes.options.flexbox === "no-2009") {
            return prefix.includes("2009");
          }
        }
        return void 0;
      }
      /**
       * Check if transition prop is inside vendor specific rule
       */
      ruleVendorPrefixes(decl) {
        let { parent } = decl;
        if (parent.type !== "rule") {
          return false;
        } else if (!parent.selector.includes(":-")) {
          return false;
        }
        let selectors = Browsers.prefixes().filter(
          (s) => parent.selector.includes(":" + s)
        );
        return selectors.length > 0 ? selectors : false;
      }
    };
    module2.exports = Transition;
  }
});

// node_modules/autoprefixer/lib/old-value.js
var require_old_value = __commonJS({
  "node_modules/autoprefixer/lib/old-value.js"(exports2, module2) {
    var utils = require_utils();
    var OldValue = class {
      constructor(unprefixed, prefixed, string, regexp) {
        this.unprefixed = unprefixed;
        this.prefixed = prefixed;
        this.string = string || prefixed;
        this.regexp = regexp || utils.regexp(prefixed);
      }
      /**
       * Check, that value contain old value
       */
      check(value) {
        if (value.includes(this.string)) {
          return !!value.match(this.regexp);
        }
        return false;
      }
    };
    module2.exports = OldValue;
  }
});

// node_modules/autoprefixer/lib/value.js
var require_value = __commonJS({
  "node_modules/autoprefixer/lib/value.js"(exports2, module2) {
    var Prefixer = require_prefixer();
    var OldValue = require_old_value();
    var vendor = require_vendor();
    var utils = require_utils();
    var Value = class extends Prefixer {
      /**
       * Clone decl for each prefixed values
       */
      static save(prefixes, decl) {
        let prop = decl.prop;
        let result = [];
        for (let prefix in decl._autoprefixerValues) {
          let value = decl._autoprefixerValues[prefix];
          if (value === decl.value) {
            continue;
          }
          let item;
          let propPrefix = vendor.prefix(prop);
          if (propPrefix === "-pie-") {
            continue;
          }
          if (propPrefix === prefix) {
            item = decl.value = value;
            result.push(item);
            continue;
          }
          let prefixed = prefixes.prefixed(prop, prefix);
          let rule = decl.parent;
          if (!rule.every((i) => i.prop !== prefixed)) {
            result.push(item);
            continue;
          }
          let trimmed = value.replace(/\s+/, " ");
          let already = rule.some(
            (i) => i.prop === decl.prop && i.value.replace(/\s+/, " ") === trimmed
          );
          if (already) {
            result.push(item);
            continue;
          }
          let cloned = this.clone(decl, { value });
          item = decl.parent.insertBefore(decl, cloned);
          result.push(item);
        }
        return result;
      }
      /**
       * Is declaration need to be prefixed
       */
      check(decl) {
        let value = decl.value;
        if (!value.includes(this.name)) {
          return false;
        }
        return !!value.match(this.regexp());
      }
      /**
       * Lazy regexp loading
       */
      regexp() {
        return this.regexpCache || (this.regexpCache = utils.regexp(this.name));
      }
      /**
       * Add prefix to values in string
       */
      replace(string, prefix) {
        return string.replace(this.regexp(), `$1${prefix}$2`);
      }
      /**
       * Get value with comments if it was not changed
       */
      value(decl) {
        if (decl.raws.value && decl.raws.value.value === decl.value) {
          return decl.raws.value.raw;
        } else {
          return decl.value;
        }
      }
      /**
       * Save values with next prefixed token
       */
      add(decl, prefix) {
        if (!decl._autoprefixerValues) {
          decl._autoprefixerValues = {};
        }
        let value = decl._autoprefixerValues[prefix] || this.value(decl);
        let before;
        do {
          before = value;
          value = this.replace(value, prefix);
          if (value === false)
            return;
        } while (value !== before);
        decl._autoprefixerValues[prefix] = value;
      }
      /**
       * Return function to fast find prefixed value
       */
      old(prefix) {
        return new OldValue(this.name, prefix + this.name);
      }
    };
    module2.exports = Value;
  }
});

// node_modules/autoprefixer/lib/hacks/grid-utils.js
var require_grid_utils = __commonJS({
  "node_modules/autoprefixer/lib/hacks/grid-utils.js"(exports2) {
    var parser = require_lib();
    var list = require_postcss().list;
    var uniq = require_utils().uniq;
    var escapeRegexp = require_utils().escapeRegexp;
    var splitSelector = require_utils().splitSelector;
    function convert(value) {
      if (value && value.length === 2 && value[0] === "span" && parseInt(value[1], 10) > 0) {
        return [false, parseInt(value[1], 10)];
      }
      if (value && value.length === 1 && parseInt(value[0], 10) > 0) {
        return [parseInt(value[0], 10), false];
      }
      return [false, false];
    }
    exports2.translate = translate;
    function translate(values, startIndex, endIndex) {
      let startValue = values[startIndex];
      let endValue = values[endIndex];
      if (!startValue) {
        return [false, false];
      }
      let [start, spanStart] = convert(startValue);
      let [end, spanEnd] = convert(endValue);
      if (start && !endValue) {
        return [start, false];
      }
      if (spanStart && end) {
        return [end - spanStart, spanStart];
      }
      if (start && spanEnd) {
        return [start, spanEnd];
      }
      if (start && end) {
        return [start, end - start];
      }
      return [false, false];
    }
    exports2.parse = parse;
    function parse(decl) {
      let node = parser(decl.value);
      let values = [];
      let current = 0;
      values[current] = [];
      for (let i of node.nodes) {
        if (i.type === "div") {
          current += 1;
          values[current] = [];
        } else if (i.type === "word") {
          values[current].push(i.value);
        }
      }
      return values;
    }
    exports2.insertDecl = insertDecl;
    function insertDecl(decl, prop, value) {
      if (value && !decl.parent.some((i) => i.prop === `-ms-${prop}`)) {
        decl.cloneBefore({
          prop: `-ms-${prop}`,
          value: value.toString()
        });
      }
    }
    exports2.prefixTrackProp = prefixTrackProp;
    function prefixTrackProp({ prop, prefix }) {
      return prefix + prop.replace("template-", "");
    }
    function transformRepeat({ nodes }, { gap }) {
      let { count, size } = nodes.reduce(
        (result, node) => {
          if (node.type === "div" && node.value === ",") {
            result.key = "size";
          } else {
            result[result.key].push(parser.stringify(node));
          }
          return result;
        },
        {
          key: "count",
          size: [],
          count: []
        }
      );
      if (gap) {
        size = size.filter((i) => i.trim());
        let val = [];
        for (let i = 1; i <= count; i++) {
          size.forEach((item, index) => {
            if (index > 0 || i > 1) {
              val.push(gap);
            }
            val.push(item);
          });
        }
        return val.join(" ");
      }
      return `(${size.join("")})[${count.join("")}]`;
    }
    exports2.prefixTrackValue = prefixTrackValue;
    function prefixTrackValue({ value, gap }) {
      let result = parser(value).nodes.reduce((nodes, node) => {
        if (node.type === "function" && node.value === "repeat") {
          return nodes.concat({
            type: "word",
            value: transformRepeat(node, { gap })
          });
        }
        if (gap && node.type === "space") {
          return nodes.concat(
            {
              type: "space",
              value: " "
            },
            {
              type: "word",
              value: gap
            },
            node
          );
        }
        return nodes.concat(node);
      }, []);
      return parser.stringify(result);
    }
    var DOTS = /^\.+$/;
    function track(start, end) {
      return { start, end, span: end - start };
    }
    function getColumns(line) {
      return line.trim().split(/\s+/g);
    }
    exports2.parseGridAreas = parseGridAreas;
    function parseGridAreas({ rows, gap }) {
      return rows.reduce((areas, line, rowIndex) => {
        if (gap.row)
          rowIndex *= 2;
        if (line.trim() === "")
          return areas;
        getColumns(line).forEach((area, columnIndex) => {
          if (DOTS.test(area))
            return;
          if (gap.column)
            columnIndex *= 2;
          if (typeof areas[area] === "undefined") {
            areas[area] = {
              column: track(columnIndex + 1, columnIndex + 2),
              row: track(rowIndex + 1, rowIndex + 2)
            };
          } else {
            let { column, row } = areas[area];
            column.start = Math.min(column.start, columnIndex + 1);
            column.end = Math.max(column.end, columnIndex + 2);
            column.span = column.end - column.start;
            row.start = Math.min(row.start, rowIndex + 1);
            row.end = Math.max(row.end, rowIndex + 2);
            row.span = row.end - row.start;
          }
        });
        return areas;
      }, {});
    }
    function testTrack(node) {
      return node.type === "word" && /^\[.+]$/.test(node.value);
    }
    function verifyRowSize(result) {
      if (result.areas.length > result.rows.length) {
        result.rows.push("auto");
      }
      return result;
    }
    exports2.parseTemplate = parseTemplate;
    function parseTemplate({ decl, gap }) {
      let gridTemplate = parser(decl.value).nodes.reduce(
        (result, node) => {
          let { type, value } = node;
          if (testTrack(node) || type === "space")
            return result;
          if (type === "string") {
            result = verifyRowSize(result);
            result.areas.push(value);
          }
          if (type === "word" || type === "function") {
            result[result.key].push(parser.stringify(node));
          }
          if (type === "div" && value === "/") {
            result.key = "columns";
            result = verifyRowSize(result);
          }
          return result;
        },
        {
          key: "rows",
          columns: [],
          rows: [],
          areas: []
        }
      );
      return {
        areas: parseGridAreas({
          rows: gridTemplate.areas,
          gap
        }),
        columns: prefixTrackValue({
          value: gridTemplate.columns.join(" "),
          gap: gap.column
        }),
        rows: prefixTrackValue({
          value: gridTemplate.rows.join(" "),
          gap: gap.row
        })
      };
    }
    function getMSDecls(area, addRowSpan = false, addColumnSpan = false) {
      let result = [
        {
          prop: "-ms-grid-row",
          value: String(area.row.start)
        }
      ];
      if (area.row.span > 1 || addRowSpan) {
        result.push({
          prop: "-ms-grid-row-span",
          value: String(area.row.span)
        });
      }
      result.push({
        prop: "-ms-grid-column",
        value: String(area.column.start)
      });
      if (area.column.span > 1 || addColumnSpan) {
        result.push({
          prop: "-ms-grid-column-span",
          value: String(area.column.span)
        });
      }
      return result;
    }
    function getParentMedia(parent) {
      if (parent.type === "atrule" && parent.name === "media") {
        return parent;
      }
      if (!parent.parent) {
        return false;
      }
      return getParentMedia(parent.parent);
    }
    function changeDuplicateAreaSelectors(ruleSelectors, templateSelectors) {
      ruleSelectors = ruleSelectors.map((selector) => {
        let selectorBySpace = list.space(selector);
        let selectorByComma = list.comma(selector);
        if (selectorBySpace.length > selectorByComma.length) {
          selector = selectorBySpace.slice(-1).join("");
        }
        return selector;
      });
      return ruleSelectors.map((ruleSelector) => {
        let newSelector = templateSelectors.map((tplSelector, index) => {
          let space = index === 0 ? "" : " ";
          return `${space}${tplSelector} > ${ruleSelector}`;
        });
        return newSelector;
      });
    }
    function selectorsEqual(ruleA, ruleB) {
      return ruleA.selectors.some((sel) => {
        return ruleB.selectors.includes(sel);
      });
    }
    function parseGridTemplatesData(css) {
      let parsed = [];
      css.walkDecls(/grid-template(-areas)?$/, (d) => {
        let rule = d.parent;
        let media = getParentMedia(rule);
        let gap = getGridGap(d);
        let inheritedGap = inheritGridGap(d, gap);
        let { areas } = parseTemplate({ decl: d, gap: inheritedGap || gap });
        let areaNames = Object.keys(areas);
        if (areaNames.length === 0) {
          return true;
        }
        let index = parsed.reduce((acc, { allAreas }, idx) => {
          let hasAreas = allAreas && areaNames.some((area) => allAreas.includes(area));
          return hasAreas ? idx : acc;
        }, null);
        if (index !== null) {
          let { allAreas, rules } = parsed[index];
          let hasNoDuplicates = rules.some((r) => {
            return r.hasDuplicates === false && selectorsEqual(r, rule);
          });
          let duplicatesFound = false;
          let duplicateAreaNames = rules.reduce((acc, r) => {
            if (!r.params && selectorsEqual(r, rule)) {
              duplicatesFound = true;
              return r.duplicateAreaNames;
            }
            if (!duplicatesFound) {
              areaNames.forEach((name) => {
                if (r.areas[name]) {
                  acc.push(name);
                }
              });
            }
            return uniq(acc);
          }, []);
          rules.forEach((r) => {
            areaNames.forEach((name) => {
              let area = r.areas[name];
              if (area && area.row.span !== areas[name].row.span) {
                areas[name].row.updateSpan = true;
              }
              if (area && area.column.span !== areas[name].column.span) {
                areas[name].column.updateSpan = true;
              }
            });
          });
          parsed[index].allAreas = uniq([...allAreas, ...areaNames]);
          parsed[index].rules.push({
            hasDuplicates: !hasNoDuplicates,
            params: media.params,
            selectors: rule.selectors,
            node: rule,
            duplicateAreaNames,
            areas
          });
        } else {
          parsed.push({
            allAreas: areaNames,
            areasCount: 0,
            rules: [
              {
                hasDuplicates: false,
                duplicateRules: [],
                params: media.params,
                selectors: rule.selectors,
                node: rule,
                duplicateAreaNames: [],
                areas
              }
            ]
          });
        }
        return void 0;
      });
      return parsed;
    }
    exports2.insertAreas = insertAreas;
    function insertAreas(css, isDisabled) {
      let gridTemplatesData = parseGridTemplatesData(css);
      if (gridTemplatesData.length === 0) {
        return void 0;
      }
      let rulesToInsert = {};
      css.walkDecls("grid-area", (gridArea) => {
        let gridAreaRule = gridArea.parent;
        let hasPrefixedRow = gridAreaRule.first.prop === "-ms-grid-row";
        let gridAreaMedia = getParentMedia(gridAreaRule);
        if (isDisabled(gridArea)) {
          return void 0;
        }
        let gridAreaRuleIndex = css.index(gridAreaMedia || gridAreaRule);
        let value = gridArea.value;
        let data = gridTemplatesData.filter((d) => d.allAreas.includes(value))[0];
        if (!data) {
          return true;
        }
        let lastArea = data.allAreas[data.allAreas.length - 1];
        let selectorBySpace = list.space(gridAreaRule.selector);
        let selectorByComma = list.comma(gridAreaRule.selector);
        let selectorIsComplex = selectorBySpace.length > 1 && selectorBySpace.length > selectorByComma.length;
        if (hasPrefixedRow) {
          return false;
        }
        if (!rulesToInsert[lastArea]) {
          rulesToInsert[lastArea] = {};
        }
        let lastRuleIsSet = false;
        for (let rule of data.rules) {
          let area = rule.areas[value];
          let hasDuplicateName = rule.duplicateAreaNames.includes(value);
          if (!area) {
            let lastRule = rulesToInsert[lastArea].lastRule;
            let lastRuleIndex;
            if (lastRule) {
              lastRuleIndex = css.index(lastRule);
            } else {
              lastRuleIndex = -1;
            }
            if (gridAreaRuleIndex > lastRuleIndex) {
              rulesToInsert[lastArea].lastRule = gridAreaMedia || gridAreaRule;
            }
            continue;
          }
          if (rule.params && !rulesToInsert[lastArea][rule.params]) {
            rulesToInsert[lastArea][rule.params] = [];
          }
          if ((!rule.hasDuplicates || !hasDuplicateName) && !rule.params) {
            getMSDecls(area, false, false).reverse().forEach(
              (i) => gridAreaRule.prepend(
                Object.assign(i, {
                  raws: {
                    between: gridArea.raws.between
                  }
                })
              )
            );
            rulesToInsert[lastArea].lastRule = gridAreaRule;
            lastRuleIsSet = true;
          } else if (rule.hasDuplicates && !rule.params && !selectorIsComplex) {
            let cloned = gridAreaRule.clone();
            cloned.removeAll();
            getMSDecls(area, area.row.updateSpan, area.column.updateSpan).reverse().forEach(
              (i) => cloned.prepend(
                Object.assign(i, {
                  raws: {
                    between: gridArea.raws.between
                  }
                })
              )
            );
            cloned.selectors = changeDuplicateAreaSelectors(
              cloned.selectors,
              rule.selectors
            );
            if (rulesToInsert[lastArea].lastRule) {
              rulesToInsert[lastArea].lastRule.after(cloned);
            }
            rulesToInsert[lastArea].lastRule = cloned;
            lastRuleIsSet = true;
          } else if (rule.hasDuplicates && !rule.params && selectorIsComplex && gridAreaRule.selector.includes(rule.selectors[0])) {
            gridAreaRule.walkDecls(/-ms-grid-(row|column)/, (d) => d.remove());
            getMSDecls(area, area.row.updateSpan, area.column.updateSpan).reverse().forEach(
              (i) => gridAreaRule.prepend(
                Object.assign(i, {
                  raws: {
                    between: gridArea.raws.between
                  }
                })
              )
            );
          } else if (rule.params) {
            let cloned = gridAreaRule.clone();
            cloned.removeAll();
            getMSDecls(area, area.row.updateSpan, area.column.updateSpan).reverse().forEach(
              (i) => cloned.prepend(
                Object.assign(i, {
                  raws: {
                    between: gridArea.raws.between
                  }
                })
              )
            );
            if (rule.hasDuplicates && hasDuplicateName) {
              cloned.selectors = changeDuplicateAreaSelectors(
                cloned.selectors,
                rule.selectors
              );
            }
            cloned.raws = rule.node.raws;
            if (css.index(rule.node.parent) > gridAreaRuleIndex) {
              rule.node.parent.append(cloned);
            } else {
              rulesToInsert[lastArea][rule.params].push(cloned);
            }
            if (!lastRuleIsSet) {
              rulesToInsert[lastArea].lastRule = gridAreaMedia || gridAreaRule;
            }
          }
        }
        return void 0;
      });
      Object.keys(rulesToInsert).forEach((area) => {
        let data = rulesToInsert[area];
        let lastRule = data.lastRule;
        Object.keys(data).reverse().filter((p) => p !== "lastRule").forEach((params) => {
          if (data[params].length > 0 && lastRule) {
            lastRule.after({ name: "media", params });
            lastRule.next().append(data[params]);
          }
        });
      });
      return void 0;
    }
    exports2.warnMissedAreas = warnMissedAreas;
    function warnMissedAreas(areas, decl, result) {
      let missed = Object.keys(areas);
      decl.root().walkDecls("grid-area", (gridArea) => {
        missed = missed.filter((e) => e !== gridArea.value);
      });
      if (missed.length > 0) {
        decl.warn(result, "Can not find grid areas: " + missed.join(", "));
      }
      return void 0;
    }
    exports2.warnTemplateSelectorNotFound = warnTemplateSelectorNotFound;
    function warnTemplateSelectorNotFound(decl, result) {
      let rule = decl.parent;
      let root = decl.root();
      let duplicatesFound = false;
      let slicedSelectorArr = list.space(rule.selector).filter((str) => str !== ">").slice(0, -1);
      if (slicedSelectorArr.length > 0) {
        let gridTemplateFound = false;
        let foundAreaSelector = null;
        root.walkDecls(/grid-template(-areas)?$/, (d) => {
          let parent = d.parent;
          let templateSelectors = parent.selectors;
          let { areas } = parseTemplate({ decl: d, gap: getGridGap(d) });
          let hasArea = areas[decl.value];
          for (let tplSelector of templateSelectors) {
            if (gridTemplateFound) {
              break;
            }
            let tplSelectorArr = list.space(tplSelector).filter((str) => str !== ">");
            gridTemplateFound = tplSelectorArr.every(
              (item, idx) => item === slicedSelectorArr[idx]
            );
          }
          if (gridTemplateFound || !hasArea) {
            return true;
          }
          if (!foundAreaSelector) {
            foundAreaSelector = parent.selector;
          }
          if (foundAreaSelector && foundAreaSelector !== parent.selector) {
            duplicatesFound = true;
          }
          return void 0;
        });
        if (!gridTemplateFound && duplicatesFound) {
          decl.warn(
            result,
            `Autoprefixer cannot find a grid-template containing the duplicate grid-area "${decl.value}" with full selector matching: ${slicedSelectorArr.join(" ")}`
          );
        }
      }
    }
    exports2.warnIfGridRowColumnExists = warnIfGridRowColumnExists;
    function warnIfGridRowColumnExists(decl, result) {
      let rule = decl.parent;
      let decls = [];
      rule.walkDecls(/^grid-(row|column)/, (d) => {
        if (!d.prop.endsWith("-end") && !d.value.startsWith("span") && !d.prop.endsWith("-gap")) {
          decls.push(d);
        }
      });
      if (decls.length > 0) {
        decls.forEach((d) => {
          d.warn(
            result,
            `You already have a grid-area declaration present in the rule. You should use either grid-area or ${d.prop}, not both`
          );
        });
      }
      return void 0;
    }
    exports2.getGridGap = getGridGap;
    function getGridGap(decl) {
      let gap = {};
      let testGap = /^(grid-)?((row|column)-)?gap$/;
      decl.parent.walkDecls(testGap, ({ prop, value }) => {
        if (/^(grid-)?gap$/.test(prop)) {
          let [row, , column] = parser(value).nodes;
          gap.row = row && parser.stringify(row);
          gap.column = column ? parser.stringify(column) : gap.row;
        }
        if (/^(grid-)?row-gap$/.test(prop))
          gap.row = value;
        if (/^(grid-)?column-gap$/.test(prop))
          gap.column = value;
      });
      return gap;
    }
    function parseMediaParams(params) {
      if (!params) {
        return [];
      }
      let parsed = parser(params);
      let prop;
      let value;
      parsed.walk((node) => {
        if (node.type === "word" && /min|max/g.test(node.value)) {
          prop = node.value;
        } else if (node.value.includes("px")) {
          value = parseInt(node.value.replace(/\D/g, ""));
        }
      });
      return [prop, value];
    }
    function shouldInheritGap(selA, selB) {
      let result;
      let splitSelectorArrA = splitSelector(selA);
      let splitSelectorArrB = splitSelector(selB);
      if (splitSelectorArrA[0].length < splitSelectorArrB[0].length) {
        return false;
      } else if (splitSelectorArrA[0].length > splitSelectorArrB[0].length) {
        let idx = splitSelectorArrA[0].reduce((res, [item], index) => {
          let firstSelectorPart = splitSelectorArrB[0][0][0];
          if (item === firstSelectorPart) {
            return index;
          }
          return false;
        }, false);
        if (idx) {
          result = splitSelectorArrB[0].every((arr, index) => {
            return arr.every(
              (part, innerIndex) => (
                // because selectorA has more space elements, we need to slice
                // selectorA array by 'idx' number to compare them
                splitSelectorArrA[0].slice(idx)[index][innerIndex] === part
              )
            );
          });
        }
      } else {
        result = splitSelectorArrB.some((byCommaArr) => {
          return byCommaArr.every((bySpaceArr, index) => {
            return bySpaceArr.every(
              (part, innerIndex) => splitSelectorArrA[0][index][innerIndex] === part
            );
          });
        });
      }
      return result;
    }
    exports2.inheritGridGap = inheritGridGap;
    function inheritGridGap(decl, gap) {
      let rule = decl.parent;
      let mediaRule = getParentMedia(rule);
      let root = rule.root();
      let splitSelectorArr = splitSelector(rule.selector);
      if (Object.keys(gap).length > 0) {
        return false;
      }
      let [prop] = parseMediaParams(mediaRule.params);
      let lastBySpace = splitSelectorArr[0];
      let escaped = escapeRegexp(lastBySpace[lastBySpace.length - 1][0]);
      let regexp = new RegExp(`(${escaped}$)|(${escaped}[,.])`);
      let closestRuleGap;
      root.walkRules(regexp, (r) => {
        let gridGap;
        if (rule.toString() === r.toString()) {
          return false;
        }
        r.walkDecls("grid-gap", (d) => gridGap = getGridGap(d));
        if (!gridGap || Object.keys(gridGap).length === 0) {
          return true;
        }
        if (!shouldInheritGap(rule.selector, r.selector)) {
          return true;
        }
        let media = getParentMedia(r);
        if (media) {
          let propToCompare = parseMediaParams(media.params)[0];
          if (propToCompare === prop) {
            closestRuleGap = gridGap;
            return true;
          }
        } else {
          closestRuleGap = gridGap;
          return true;
        }
        return void 0;
      });
      if (closestRuleGap && Object.keys(closestRuleGap).length > 0) {
        return closestRuleGap;
      }
      return false;
    }
    exports2.warnGridGap = warnGridGap;
    function warnGridGap({ gap, hasColumns, decl, result }) {
      let hasBothGaps = gap.row && gap.column;
      if (!hasColumns && (hasBothGaps || gap.column && !gap.row)) {
        delete gap.column;
        decl.warn(
          result,
          "Can not implement grid-gap without grid-template-columns"
        );
      }
    }
    function normalizeRowColumn(str) {
      let normalized = parser(str).nodes.reduce((result, node) => {
        if (node.type === "function" && node.value === "repeat") {
          let key = "count";
          let [count, value] = node.nodes.reduce(
            (acc, n) => {
              if (n.type === "word" && key === "count") {
                acc[0] = Math.abs(parseInt(n.value));
                return acc;
              }
              if (n.type === "div" && n.value === ",") {
                key = "value";
                return acc;
              }
              if (key === "value") {
                acc[1] += parser.stringify(n);
              }
              return acc;
            },
            [0, ""]
          );
          if (count) {
            for (let i = 0; i < count; i++) {
              result.push(value);
            }
          }
          return result;
        }
        if (node.type === "space") {
          return result;
        }
        return result.concat(parser.stringify(node));
      }, []);
      return normalized;
    }
    exports2.autoplaceGridItems = autoplaceGridItems;
    function autoplaceGridItems(decl, result, gap, autoflowValue = "row") {
      let { parent } = decl;
      let rowDecl = parent.nodes.find((i) => i.prop === "grid-template-rows");
      let rows = normalizeRowColumn(rowDecl.value);
      let columns = normalizeRowColumn(decl.value);
      let filledRows = rows.map((_, rowIndex) => {
        return Array.from(
          { length: columns.length },
          (v, k) => k + rowIndex * columns.length + 1
        ).join(" ");
      });
      let areas = parseGridAreas({ rows: filledRows, gap });
      let keys = Object.keys(areas);
      let items = keys.map((i) => areas[i]);
      if (autoflowValue.includes("column")) {
        items = items.sort((a, b) => a.column.start - b.column.start);
      }
      items.reverse().forEach((item, index) => {
        let { column, row } = item;
        let nodeSelector = parent.selectors.map((sel) => sel + ` > *:nth-child(${keys.length - index})`).join(", ");
        let node = parent.clone().removeAll();
        node.selector = nodeSelector;
        node.append({ prop: "-ms-grid-row", value: row.start });
        node.append({ prop: "-ms-grid-column", value: column.start });
        parent.after(node);
      });
      return void 0;
    }
  }
});

// node_modules/autoprefixer/lib/processor.js
var require_processor2 = __commonJS({
  "node_modules/autoprefixer/lib/processor.js"(exports2, module2) {
    var parser = require_lib();
    var Value = require_value();
    var insertAreas = require_grid_utils().insertAreas;
    var OLD_LINEAR = /(^|[^-])linear-gradient\(\s*(top|left|right|bottom)/i;
    var OLD_RADIAL = /(^|[^-])radial-gradient\(\s*\d+(\w*|%)\s+\d+(\w*|%)\s*,/i;
    var IGNORE_NEXT = /(!\s*)?autoprefixer:\s*ignore\s+next/i;
    var GRID_REGEX = /(!\s*)?autoprefixer\s*grid:\s*(on|off|(no-)?autoplace)/i;
    var SIZES = [
      "width",
      "height",
      "min-width",
      "max-width",
      "min-height",
      "max-height",
      "inline-size",
      "min-inline-size",
      "max-inline-size",
      "block-size",
      "min-block-size",
      "max-block-size"
    ];
    function hasGridTemplate(decl) {
      return decl.parent.some(
        (i) => i.prop === "grid-template" || i.prop === "grid-template-areas"
      );
    }
    function hasRowsAndColumns(decl) {
      let hasRows = decl.parent.some((i) => i.prop === "grid-template-rows");
      let hasColumns = decl.parent.some((i) => i.prop === "grid-template-columns");
      return hasRows && hasColumns;
    }
    var Processor = class {
      constructor(prefixes) {
        this.prefixes = prefixes;
      }
      /**
       * Add necessary prefixes
       */
      add(css, result) {
        let resolution = this.prefixes.add["@resolution"];
        let keyframes = this.prefixes.add["@keyframes"];
        let viewport = this.prefixes.add["@viewport"];
        let supports = this.prefixes.add["@supports"];
        css.walkAtRules((rule) => {
          if (rule.name === "keyframes") {
            if (!this.disabled(rule, result)) {
              return keyframes && keyframes.process(rule);
            }
          } else if (rule.name === "viewport") {
            if (!this.disabled(rule, result)) {
              return viewport && viewport.process(rule);
            }
          } else if (rule.name === "supports") {
            if (this.prefixes.options.supports !== false && !this.disabled(rule, result)) {
              return supports.process(rule);
            }
          } else if (rule.name === "media" && rule.params.includes("-resolution")) {
            if (!this.disabled(rule, result)) {
              return resolution && resolution.process(rule);
            }
          }
          return void 0;
        });
        css.walkRules((rule) => {
          if (this.disabled(rule, result))
            return void 0;
          return this.prefixes.add.selectors.map((selector) => {
            return selector.process(rule, result);
          });
        });
        function insideGrid(decl) {
          return decl.parent.nodes.some((node) => {
            if (node.type !== "decl")
              return false;
            let displayGrid = node.prop === "display" && /(inline-)?grid/.test(node.value);
            let gridTemplate = node.prop.startsWith("grid-template");
            let gridGap = /^grid-([A-z]+-)?gap/.test(node.prop);
            return displayGrid || gridTemplate || gridGap;
          });
        }
        function insideFlex(decl) {
          return decl.parent.some((node) => {
            return node.prop === "display" && /(inline-)?flex/.test(node.value);
          });
        }
        let gridPrefixes = this.gridStatus(css, result) && this.prefixes.add["grid-area"] && this.prefixes.add["grid-area"].prefixes;
        css.walkDecls((decl) => {
          if (this.disabledDecl(decl, result))
            return void 0;
          let parent = decl.parent;
          let prop = decl.prop;
          let value = decl.value;
          if (prop === "color-adjust") {
            if (parent.every((i) => i.prop !== "print-color-adjust")) {
              result.warn(
                "Replace color-adjust to print-color-adjust. The color-adjust shorthand is currently deprecated.",
                { node: decl }
              );
            }
          } else if (prop === "grid-row-span") {
            result.warn(
              "grid-row-span is not part of final Grid Layout. Use grid-row.",
              { node: decl }
            );
            return void 0;
          } else if (prop === "grid-column-span") {
            result.warn(
              "grid-column-span is not part of final Grid Layout. Use grid-column.",
              { node: decl }
            );
            return void 0;
          } else if (prop === "display" && value === "box") {
            result.warn(
              "You should write display: flex by final spec instead of display: box",
              { node: decl }
            );
            return void 0;
          } else if (prop === "text-emphasis-position") {
            if (value === "under" || value === "over") {
              result.warn(
                "You should use 2 values for text-emphasis-position For example, `under left` instead of just `under`.",
                { node: decl }
              );
            }
          } else if (/^(align|justify|place)-(items|content)$/.test(prop) && insideFlex(decl)) {
            if (value === "start" || value === "end") {
              result.warn(
                `${value} value has mixed support, consider using flex-${value} instead`,
                { node: decl }
              );
            }
          } else if (prop === "text-decoration-skip" && value === "ink") {
            result.warn(
              "Replace text-decoration-skip: ink to text-decoration-skip-ink: auto, because spec had been changed",
              { node: decl }
            );
          } else {
            if (gridPrefixes && this.gridStatus(decl, result)) {
              if (decl.value === "subgrid") {
                result.warn("IE does not support subgrid", { node: decl });
              }
              if (/^(align|justify|place)-items$/.test(prop) && insideGrid(decl)) {
                let fixed = prop.replace("-items", "-self");
                result.warn(
                  `IE does not support ${prop} on grid containers. Try using ${fixed} on child elements instead: ${decl.parent.selector} > * { ${fixed}: ${decl.value} }`,
                  { node: decl }
                );
              } else if (/^(align|justify|place)-content$/.test(prop) && insideGrid(decl)) {
                result.warn(`IE does not support ${decl.prop} on grid containers`, {
                  node: decl
                });
              } else if (prop === "display" && decl.value === "contents") {
                result.warn(
                  "Please do not use display: contents; if you have grid setting enabled",
                  { node: decl }
                );
                return void 0;
              } else if (decl.prop === "grid-gap") {
                let status = this.gridStatus(decl, result);
                if (status === "autoplace" && !hasRowsAndColumns(decl) && !hasGridTemplate(decl)) {
                  result.warn(
                    "grid-gap only works if grid-template(-areas) is being used or both rows and columns have been declared and cells have not been manually placed inside the explicit grid",
                    { node: decl }
                  );
                } else if ((status === true || status === "no-autoplace") && !hasGridTemplate(decl)) {
                  result.warn(
                    "grid-gap only works if grid-template(-areas) is being used",
                    { node: decl }
                  );
                }
              } else if (prop === "grid-auto-columns") {
                result.warn("grid-auto-columns is not supported by IE", {
                  node: decl
                });
                return void 0;
              } else if (prop === "grid-auto-rows") {
                result.warn("grid-auto-rows is not supported by IE", { node: decl });
                return void 0;
              } else if (prop === "grid-auto-flow") {
                let hasRows = parent.some((i) => i.prop === "grid-template-rows");
                let hasCols = parent.some((i) => i.prop === "grid-template-columns");
                if (hasGridTemplate(decl)) {
                  result.warn("grid-auto-flow is not supported by IE", {
                    node: decl
                  });
                } else if (value.includes("dense")) {
                  result.warn("grid-auto-flow: dense is not supported by IE", {
                    node: decl
                  });
                } else if (!hasRows && !hasCols) {
                  result.warn(
                    "grid-auto-flow works only if grid-template-rows and grid-template-columns are present in the same rule",
                    { node: decl }
                  );
                }
                return void 0;
              } else if (value.includes("auto-fit")) {
                result.warn("auto-fit value is not supported by IE", {
                  node: decl,
                  word: "auto-fit"
                });
                return void 0;
              } else if (value.includes("auto-fill")) {
                result.warn("auto-fill value is not supported by IE", {
                  node: decl,
                  word: "auto-fill"
                });
                return void 0;
              } else if (prop.startsWith("grid-template") && value.includes("[")) {
                result.warn(
                  "Autoprefixer currently does not support line names. Try using grid-template-areas instead.",
                  { node: decl, word: "[" }
                );
              }
            }
            if (value.includes("radial-gradient")) {
              if (OLD_RADIAL.test(decl.value)) {
                result.warn(
                  "Gradient has outdated direction syntax. New syntax is like `closest-side at 0 0` instead of `0 0, closest-side`.",
                  { node: decl }
                );
              } else {
                let ast = parser(value);
                for (let i of ast.nodes) {
                  if (i.type === "function" && i.value === "radial-gradient") {
                    for (let word of i.nodes) {
                      if (word.type === "word") {
                        if (word.value === "cover") {
                          result.warn(
                            "Gradient has outdated direction syntax. Replace `cover` to `farthest-corner`.",
                            { node: decl }
                          );
                        } else if (word.value === "contain") {
                          result.warn(
                            "Gradient has outdated direction syntax. Replace `contain` to `closest-side`.",
                            { node: decl }
                          );
                        }
                      }
                    }
                  }
                }
              }
            }
            if (value.includes("linear-gradient")) {
              if (OLD_LINEAR.test(value)) {
                result.warn(
                  "Gradient has outdated direction syntax. New syntax is like `to left` instead of `right`.",
                  { node: decl }
                );
              }
            }
          }
          if (SIZES.includes(decl.prop)) {
            if (!decl.value.includes("-fill-available")) {
              if (decl.value.includes("fill-available")) {
                result.warn(
                  "Replace fill-available to stretch, because spec had been changed",
                  { node: decl }
                );
              } else if (decl.value.includes("fill")) {
                let ast = parser(value);
                if (ast.nodes.some((i) => i.type === "word" && i.value === "fill")) {
                  result.warn(
                    "Replace fill to stretch, because spec had been changed",
                    { node: decl }
                  );
                }
              }
            }
          }
          let prefixer;
          if (decl.prop === "transition" || decl.prop === "transition-property") {
            return this.prefixes.transition.add(decl, result);
          } else if (decl.prop === "align-self") {
            let display = this.displayType(decl);
            if (display !== "grid" && this.prefixes.options.flexbox !== false) {
              prefixer = this.prefixes.add["align-self"];
              if (prefixer && prefixer.prefixes) {
                prefixer.process(decl);
              }
            }
            if (this.gridStatus(decl, result) !== false) {
              prefixer = this.prefixes.add["grid-row-align"];
              if (prefixer && prefixer.prefixes) {
                return prefixer.process(decl, result);
              }
            }
          } else if (decl.prop === "justify-self") {
            if (this.gridStatus(decl, result) !== false) {
              prefixer = this.prefixes.add["grid-column-align"];
              if (prefixer && prefixer.prefixes) {
                return prefixer.process(decl, result);
              }
            }
          } else if (decl.prop === "place-self") {
            prefixer = this.prefixes.add["place-self"];
            if (prefixer && prefixer.prefixes && this.gridStatus(decl, result) !== false) {
              return prefixer.process(decl, result);
            }
          } else {
            prefixer = this.prefixes.add[decl.prop];
            if (prefixer && prefixer.prefixes) {
              return prefixer.process(decl, result);
            }
          }
          return void 0;
        });
        if (this.gridStatus(css, result)) {
          insertAreas(css, this.disabled);
        }
        return css.walkDecls((decl) => {
          if (this.disabledValue(decl, result))
            return;
          let unprefixed = this.prefixes.unprefixed(decl.prop);
          let list = this.prefixes.values("add", unprefixed);
          if (Array.isArray(list)) {
            for (let value of list) {
              if (value.process)
                value.process(decl, result);
            }
          }
          Value.save(this.prefixes, decl);
        });
      }
      /**
       * Remove unnecessary pefixes
       */
      remove(css, result) {
        let resolution = this.prefixes.remove["@resolution"];
        css.walkAtRules((rule, i) => {
          if (this.prefixes.remove[`@${rule.name}`]) {
            if (!this.disabled(rule, result)) {
              rule.parent.removeChild(i);
            }
          } else if (rule.name === "media" && rule.params.includes("-resolution") && resolution) {
            resolution.clean(rule);
          }
        });
        for (let checker of this.prefixes.remove.selectors) {
          css.walkRules((rule, i) => {
            if (checker.check(rule)) {
              if (!this.disabled(rule, result)) {
                rule.parent.removeChild(i);
              }
            }
          });
        }
        return css.walkDecls((decl, i) => {
          if (this.disabled(decl, result))
            return;
          let rule = decl.parent;
          let unprefixed = this.prefixes.unprefixed(decl.prop);
          if (decl.prop === "transition" || decl.prop === "transition-property") {
            this.prefixes.transition.remove(decl);
          }
          if (this.prefixes.remove[decl.prop] && this.prefixes.remove[decl.prop].remove) {
            let notHack = this.prefixes.group(decl).down((other) => {
              return this.prefixes.normalize(other.prop) === unprefixed;
            });
            if (unprefixed === "flex-flow") {
              notHack = true;
            }
            if (decl.prop === "-webkit-box-orient") {
              let hacks = { "flex-direction": true, "flex-flow": true };
              if (!decl.parent.some((j) => hacks[j.prop]))
                return;
            }
            if (notHack && !this.withHackValue(decl)) {
              if (decl.raw("before").includes("\n")) {
                this.reduceSpaces(decl);
              }
              rule.removeChild(i);
              return;
            }
          }
          for (let checker of this.prefixes.values("remove", unprefixed)) {
            if (!checker.check)
              continue;
            if (!checker.check(decl.value))
              continue;
            unprefixed = checker.unprefixed;
            let notHack = this.prefixes.group(decl).down((other) => {
              return other.value.includes(unprefixed);
            });
            if (notHack) {
              rule.removeChild(i);
              return;
            }
          }
        });
      }
      /**
       * Some rare old values, which is not in standard
       */
      withHackValue(decl) {
        return decl.prop === "-webkit-background-clip" && decl.value === "text";
      }
      /**
       * Check for grid/flexbox options.
       */
      disabledValue(node, result) {
        if (this.gridStatus(node, result) === false && node.type === "decl") {
          if (node.prop === "display" && node.value.includes("grid")) {
            return true;
          }
        }
        if (this.prefixes.options.flexbox === false && node.type === "decl") {
          if (node.prop === "display" && node.value.includes("flex")) {
            return true;
          }
        }
        if (node.type === "decl" && node.prop === "content") {
          return true;
        }
        return this.disabled(node, result);
      }
      /**
       * Check for grid/flexbox options.
       */
      disabledDecl(node, result) {
        if (this.gridStatus(node, result) === false && node.type === "decl") {
          if (node.prop.includes("grid") || node.prop === "justify-items") {
            return true;
          }
        }
        if (this.prefixes.options.flexbox === false && node.type === "decl") {
          let other = ["order", "justify-content", "align-items", "align-content"];
          if (node.prop.includes("flex") || other.includes(node.prop)) {
            return true;
          }
        }
        return this.disabled(node, result);
      }
      /**
       * Check for control comment and global options
       */
      disabled(node, result) {
        if (!node)
          return false;
        if (node._autoprefixerDisabled !== void 0) {
          return node._autoprefixerDisabled;
        }
        if (node.parent) {
          let p = node.prev();
          if (p && p.type === "comment" && IGNORE_NEXT.test(p.text)) {
            node._autoprefixerDisabled = true;
            node._autoprefixerSelfDisabled = true;
            return true;
          }
        }
        let value = null;
        if (node.nodes) {
          let status;
          node.each((i) => {
            if (i.type !== "comment")
              return;
            if (/(!\s*)?autoprefixer:\s*(off|on)/i.test(i.text)) {
              if (typeof status !== "undefined") {
                result.warn(
                  "Second Autoprefixer control comment was ignored. Autoprefixer applies control comment to whole block, not to next rules.",
                  { node: i }
                );
              } else {
                status = /on/i.test(i.text);
              }
            }
          });
          if (status !== void 0) {
            value = !status;
          }
        }
        if (!node.nodes || value === null) {
          if (node.parent) {
            let isParentDisabled = this.disabled(node.parent, result);
            if (node.parent._autoprefixerSelfDisabled === true) {
              value = false;
            } else {
              value = isParentDisabled;
            }
          } else {
            value = false;
          }
        }
        node._autoprefixerDisabled = value;
        return value;
      }
      /**
       * Normalize spaces in cascade declaration group
       */
      reduceSpaces(decl) {
        let stop = false;
        this.prefixes.group(decl).up(() => {
          stop = true;
          return true;
        });
        if (stop) {
          return;
        }
        let parts = decl.raw("before").split("\n");
        let prevMin = parts[parts.length - 1].length;
        let diff = false;
        this.prefixes.group(decl).down((other) => {
          parts = other.raw("before").split("\n");
          let last = parts.length - 1;
          if (parts[last].length > prevMin) {
            if (diff === false) {
              diff = parts[last].length - prevMin;
            }
            parts[last] = parts[last].slice(0, -diff);
            other.raws.before = parts.join("\n");
          }
        });
      }
      /**
       * Is it flebox or grid rule
       */
      displayType(decl) {
        for (let i of decl.parent.nodes) {
          if (i.prop !== "display") {
            continue;
          }
          if (i.value.includes("flex")) {
            return "flex";
          }
          if (i.value.includes("grid")) {
            return "grid";
          }
        }
        return false;
      }
      /**
       * Set grid option via control comment
       */
      gridStatus(node, result) {
        if (!node)
          return false;
        if (node._autoprefixerGridStatus !== void 0) {
          return node._autoprefixerGridStatus;
        }
        let value = null;
        if (node.nodes) {
          let status;
          node.each((i) => {
            if (i.type !== "comment")
              return;
            if (GRID_REGEX.test(i.text)) {
              let hasAutoplace = /:\s*autoplace/i.test(i.text);
              let noAutoplace = /no-autoplace/i.test(i.text);
              if (typeof status !== "undefined") {
                result.warn(
                  "Second Autoprefixer grid control comment was ignored. Autoprefixer applies control comments to the whole block, not to the next rules.",
                  { node: i }
                );
              } else if (hasAutoplace) {
                status = "autoplace";
              } else if (noAutoplace) {
                status = true;
              } else {
                status = /on/i.test(i.text);
              }
            }
          });
          if (status !== void 0) {
            value = status;
          }
        }
        if (node.type === "atrule" && node.name === "supports") {
          let params = node.params;
          if (params.includes("grid") && params.includes("auto")) {
            value = false;
          }
        }
        if (!node.nodes || value === null) {
          if (node.parent) {
            let isParentGrid = this.gridStatus(node.parent, result);
            if (node.parent._autoprefixerSelfDisabled === true) {
              value = false;
            } else {
              value = isParentGrid;
            }
          } else if (typeof this.prefixes.options.grid !== "undefined") {
            value = this.prefixes.options.grid;
          } else if (typeof process.env.AUTOPREFIXER_GRID !== "undefined") {
            if (process.env.AUTOPREFIXER_GRID === "autoplace") {
              value = "autoplace";
            } else {
              value = true;
            }
          } else {
            value = false;
          }
        }
        node._autoprefixerGridStatus = value;
        return value;
      }
    };
    module2.exports = Processor;
  }
});

// node_modules/caniuse-lite/data/features/css-featurequeries.js
var require_css_featurequeries = __commonJS({
  "node_modules/caniuse-lite/data/features/css-featurequeries.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB" }, E: { "1": "F A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E dC HC eC fC gC" }, F: { "1": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t 7B", "2": "F B C oC pC qC rC 6B WC sC" }, G: { "1": "yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC" }, H: { "1": "FD" }, I: { "1": "I KD LD", "2": "BC J GD HD ID JD XC" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "CSS Feature Queries", D: true };
  }
});

// node_modules/autoprefixer/lib/brackets.js
var require_brackets = __commonJS({
  "node_modules/autoprefixer/lib/brackets.js"(exports2, module2) {
    function last(array) {
      return array[array.length - 1];
    }
    var brackets = {
      /**
       * Parse string to nodes tree
       */
      parse(str) {
        let current = [""];
        let stack = [current];
        for (let sym of str) {
          if (sym === "(") {
            current = [""];
            last(stack).push(current);
            stack.push(current);
            continue;
          }
          if (sym === ")") {
            stack.pop();
            current = last(stack);
            current.push("");
            continue;
          }
          current[current.length - 1] += sym;
        }
        return stack[0];
      },
      /**
       * Generate output string by nodes tree
       */
      stringify(ast) {
        let result = "";
        for (let i of ast) {
          if (typeof i === "object") {
            result += `(${brackets.stringify(i)})`;
            continue;
          }
          result += i;
        }
        return result;
      }
    };
    module2.exports = brackets;
  }
});

// node_modules/autoprefixer/lib/supports.js
var require_supports = __commonJS({
  "node_modules/autoprefixer/lib/supports.js"(exports2, module2) {
    var featureQueries = require_css_featurequeries();
    var feature = require_feature();
    var { parse } = require_postcss();
    var Browsers = require_browsers3();
    var brackets = require_brackets();
    var Value = require_value();
    var utils = require_utils();
    var data = feature(featureQueries);
    var supported = [];
    for (let browser in data.stats) {
      let versions = data.stats[browser];
      for (let version in versions) {
        let support = versions[version];
        if (/y/.test(support)) {
          supported.push(browser + " " + version);
        }
      }
    }
    var Supports = class {
      constructor(Prefixes, all) {
        this.Prefixes = Prefixes;
        this.all = all;
      }
      /**
       * Return prefixer only with @supports supported browsers
       */
      prefixer() {
        if (this.prefixerCache) {
          return this.prefixerCache;
        }
        let filtered = this.all.browsers.selected.filter((i) => {
          return supported.includes(i);
        });
        let browsers = new Browsers(
          this.all.browsers.data,
          filtered,
          this.all.options
        );
        this.prefixerCache = new this.Prefixes(
          this.all.data,
          browsers,
          this.all.options
        );
        return this.prefixerCache;
      }
      /**
       * Parse string into declaration property and value
       */
      parse(str) {
        let parts = str.split(":");
        let prop = parts[0];
        let value = parts[1];
        if (!value)
          value = "";
        return [prop.trim(), value.trim()];
      }
      /**
       * Create virtual rule to process it by prefixer
       */
      virtual(str) {
        let [prop, value] = this.parse(str);
        let rule = parse("a{}").first;
        rule.append({ prop, value, raws: { before: "" } });
        return rule;
      }
      /**
       * Return array of Declaration with all necessary prefixes
       */
      prefixed(str) {
        let rule = this.virtual(str);
        if (this.disabled(rule.first)) {
          return rule.nodes;
        }
        let result = { warn: () => null };
        let prefixer = this.prefixer().add[rule.first.prop];
        prefixer && prefixer.process && prefixer.process(rule.first, result);
        for (let decl of rule.nodes) {
          for (let value of this.prefixer().values("add", rule.first.prop)) {
            value.process(decl);
          }
          Value.save(this.all, decl);
        }
        return rule.nodes;
      }
      /**
       * Return true if brackets node is "not" word
       */
      isNot(node) {
        return typeof node === "string" && /not\s*/i.test(node);
      }
      /**
       * Return true if brackets node is "or" word
       */
      isOr(node) {
        return typeof node === "string" && /\s*or\s*/i.test(node);
      }
      /**
       * Return true if brackets node is (prop: value)
       */
      isProp(node) {
        return typeof node === "object" && node.length === 1 && typeof node[0] === "string";
      }
      /**
       * Return true if prefixed property has no unprefixed
       */
      isHack(all, unprefixed) {
        let check = new RegExp(`(\\(|\\s)${utils.escapeRegexp(unprefixed)}:`);
        return !check.test(all);
      }
      /**
       * Return true if we need to remove node
       */
      toRemove(str, all) {
        let [prop, value] = this.parse(str);
        let unprefixed = this.all.unprefixed(prop);
        let cleaner = this.all.cleaner();
        if (cleaner.remove[prop] && cleaner.remove[prop].remove && !this.isHack(all, unprefixed)) {
          return true;
        }
        for (let checker of cleaner.values("remove", unprefixed)) {
          if (checker.check(value)) {
            return true;
          }
        }
        return false;
      }
      /**
       * Remove all unnecessary prefixes
       */
      remove(nodes, all) {
        let i = 0;
        while (i < nodes.length) {
          if (!this.isNot(nodes[i - 1]) && this.isProp(nodes[i]) && this.isOr(nodes[i + 1])) {
            if (this.toRemove(nodes[i][0], all)) {
              nodes.splice(i, 2);
              continue;
            }
            i += 2;
            continue;
          }
          if (typeof nodes[i] === "object") {
            nodes[i] = this.remove(nodes[i], all);
          }
          i += 1;
        }
        return nodes;
      }
      /**
       * Clean brackets with one child
       */
      cleanBrackets(nodes) {
        return nodes.map((i) => {
          if (typeof i !== "object") {
            return i;
          }
          if (i.length === 1 && typeof i[0] === "object") {
            return this.cleanBrackets(i[0]);
          }
          return this.cleanBrackets(i);
        });
      }
      /**
       * Add " or " between properties and convert it to brackets format
       */
      convert(progress) {
        let result = [""];
        for (let i of progress) {
          result.push([`${i.prop}: ${i.value}`]);
          result.push(" or ");
        }
        result[result.length - 1] = "";
        return result;
      }
      /**
       * Compress value functions into a string nodes
       */
      normalize(nodes) {
        if (typeof nodes !== "object") {
          return nodes;
        }
        nodes = nodes.filter((i) => i !== "");
        if (typeof nodes[0] === "string") {
          let firstNode = nodes[0].trim();
          if (firstNode.includes(":") || firstNode === "selector" || firstNode === "not selector") {
            return [brackets.stringify(nodes)];
          }
        }
        return nodes.map((i) => this.normalize(i));
      }
      /**
       * Add prefixes
       */
      add(nodes, all) {
        return nodes.map((i) => {
          if (this.isProp(i)) {
            let prefixed = this.prefixed(i[0]);
            if (prefixed.length > 1) {
              return this.convert(prefixed);
            }
            return i;
          }
          if (typeof i === "object") {
            return this.add(i, all);
          }
          return i;
        });
      }
      /**
       * Add prefixed declaration
       */
      process(rule) {
        let ast = brackets.parse(rule.params);
        ast = this.normalize(ast);
        ast = this.remove(ast, rule.params);
        ast = this.add(ast, rule.params);
        ast = this.cleanBrackets(ast);
        rule.params = brackets.stringify(ast);
      }
      /**
       * Check global options
       */
      disabled(node) {
        if (!this.all.options.grid) {
          if (node.prop === "display" && node.value.includes("grid")) {
            return true;
          }
          if (node.prop.includes("grid") || node.prop === "justify-items") {
            return true;
          }
        }
        if (this.all.options.flexbox === false) {
          if (node.prop === "display" && node.value.includes("flex")) {
            return true;
          }
          let other = ["order", "justify-content", "align-items", "align-content"];
          if (node.prop.includes("flex") || other.includes(node.prop)) {
            return true;
          }
        }
        return false;
      }
    };
    module2.exports = Supports;
  }
});

// node_modules/autoprefixer/lib/old-selector.js
var require_old_selector = __commonJS({
  "node_modules/autoprefixer/lib/old-selector.js"(exports2, module2) {
    var OldSelector = class {
      constructor(selector, prefix) {
        this.prefix = prefix;
        this.prefixed = selector.prefixed(this.prefix);
        this.regexp = selector.regexp(this.prefix);
        this.prefixeds = selector.possible().map((x) => [selector.prefixed(x), selector.regexp(x)]);
        this.unprefixed = selector.name;
        this.nameRegexp = selector.regexp();
      }
      /**
       * Is rule a hack without unprefixed version bottom
       */
      isHack(rule) {
        let index = rule.parent.index(rule) + 1;
        let rules = rule.parent.nodes;
        while (index < rules.length) {
          let before = rules[index].selector;
          if (!before) {
            return true;
          }
          if (before.includes(this.unprefixed) && before.match(this.nameRegexp)) {
            return false;
          }
          let some = false;
          for (let [string, regexp] of this.prefixeds) {
            if (before.includes(string) && before.match(regexp)) {
              some = true;
              break;
            }
          }
          if (!some) {
            return true;
          }
          index += 1;
        }
        return true;
      }
      /**
       * Does rule contain an unnecessary prefixed selector
       */
      check(rule) {
        if (!rule.selector.includes(this.prefixed)) {
          return false;
        }
        if (!rule.selector.match(this.regexp)) {
          return false;
        }
        if (this.isHack(rule)) {
          return false;
        }
        return true;
      }
    };
    module2.exports = OldSelector;
  }
});

// node_modules/autoprefixer/lib/selector.js
var require_selector = __commonJS({
  "node_modules/autoprefixer/lib/selector.js"(exports2, module2) {
    var { list } = require_postcss();
    var OldSelector = require_old_selector();
    var Prefixer = require_prefixer();
    var Browsers = require_browsers3();
    var utils = require_utils();
    var Selector = class extends Prefixer {
      constructor(name, prefixes, all) {
        super(name, prefixes, all);
        this.regexpCache = /* @__PURE__ */ new Map();
      }
      /**
       * Is rule selectors need to be prefixed
       */
      check(rule) {
        if (rule.selector.includes(this.name)) {
          return !!rule.selector.match(this.regexp());
        }
        return false;
      }
      /**
       * Return prefixed version of selector
       */
      prefixed(prefix) {
        return this.name.replace(/^(\W*)/, `$1${prefix}`);
      }
      /**
       * Lazy loadRegExp for name
       */
      regexp(prefix) {
        if (!this.regexpCache.has(prefix)) {
          let name = prefix ? this.prefixed(prefix) : this.name;
          this.regexpCache.set(
            prefix,
            new RegExp(`(^|[^:"'=])${utils.escapeRegexp(name)}`, "gi")
          );
        }
        return this.regexpCache.get(prefix);
      }
      /**
       * All possible prefixes
       */
      possible() {
        return Browsers.prefixes();
      }
      /**
       * Return all possible selector prefixes
       */
      prefixeds(rule) {
        if (rule._autoprefixerPrefixeds) {
          if (rule._autoprefixerPrefixeds[this.name]) {
            return rule._autoprefixerPrefixeds;
          }
        } else {
          rule._autoprefixerPrefixeds = {};
        }
        let prefixeds = {};
        if (rule.selector.includes(",")) {
          let ruleParts = list.comma(rule.selector);
          let toProcess = ruleParts.filter((el) => el.includes(this.name));
          for (let prefix of this.possible()) {
            prefixeds[prefix] = toProcess.map((el) => this.replace(el, prefix)).join(", ");
          }
        } else {
          for (let prefix of this.possible()) {
            prefixeds[prefix] = this.replace(rule.selector, prefix);
          }
        }
        rule._autoprefixerPrefixeds[this.name] = prefixeds;
        return rule._autoprefixerPrefixeds;
      }
      /**
       * Is rule already prefixed before
       */
      already(rule, prefixeds, prefix) {
        let index = rule.parent.index(rule) - 1;
        while (index >= 0) {
          let before = rule.parent.nodes[index];
          if (before.type !== "rule") {
            return false;
          }
          let some = false;
          for (let key in prefixeds[this.name]) {
            let prefixed = prefixeds[this.name][key];
            if (before.selector === prefixed) {
              if (prefix === key) {
                return true;
              } else {
                some = true;
                break;
              }
            }
          }
          if (!some) {
            return false;
          }
          index -= 1;
        }
        return false;
      }
      /**
       * Replace selectors by prefixed one
       */
      replace(selector, prefix) {
        return selector.replace(this.regexp(), `$1${this.prefixed(prefix)}`);
      }
      /**
       * Clone and add prefixes for at-rule
       */
      add(rule, prefix) {
        let prefixeds = this.prefixeds(rule);
        if (this.already(rule, prefixeds, prefix)) {
          return;
        }
        let cloned = this.clone(rule, { selector: prefixeds[this.name][prefix] });
        rule.parent.insertBefore(rule, cloned);
      }
      /**
       * Return function to fast find prefixed selector
       */
      old(prefix) {
        return new OldSelector(this, prefix);
      }
    };
    module2.exports = Selector;
  }
});

// node_modules/autoprefixer/lib/at-rule.js
var require_at_rule2 = __commonJS({
  "node_modules/autoprefixer/lib/at-rule.js"(exports2, module2) {
    var Prefixer = require_prefixer();
    var AtRule = class extends Prefixer {
      /**
       * Clone and add prefixes for at-rule
       */
      add(rule, prefix) {
        let prefixed = prefix + rule.name;
        let already = rule.parent.some(
          (i) => i.name === prefixed && i.params === rule.params
        );
        if (already) {
          return void 0;
        }
        let cloned = this.clone(rule, { name: prefixed });
        return rule.parent.insertBefore(rule, cloned);
      }
      /**
       * Clone node with prefixes
       */
      process(node) {
        let parent = this.parentPrefix(node);
        for (let prefix of this.prefixes) {
          if (!parent || parent === prefix) {
            this.add(node, prefix);
          }
        }
      }
    };
    module2.exports = AtRule;
  }
});

// node_modules/autoprefixer/lib/hacks/fullscreen.js
var require_fullscreen = __commonJS({
  "node_modules/autoprefixer/lib/hacks/fullscreen.js"(exports2, module2) {
    var Selector = require_selector();
    var Fullscreen = class extends Selector {
      /**
       * Return different selectors depend on prefix
       */
      prefixed(prefix) {
        if (prefix === "-webkit-") {
          return ":-webkit-full-screen";
        }
        if (prefix === "-moz-") {
          return ":-moz-full-screen";
        }
        return `:${prefix}fullscreen`;
      }
    };
    Fullscreen.names = [":fullscreen"];
    module2.exports = Fullscreen;
  }
});

// node_modules/autoprefixer/lib/hacks/placeholder.js
var require_placeholder = __commonJS({
  "node_modules/autoprefixer/lib/hacks/placeholder.js"(exports2, module2) {
    var Selector = require_selector();
    var Placeholder = class extends Selector {
      /**
       * Add old mozilla to possible prefixes
       */
      possible() {
        return super.possible().concat(["-moz- old", "-ms- old"]);
      }
      /**
       * Return different selectors depend on prefix
       */
      prefixed(prefix) {
        if (prefix === "-webkit-") {
          return "::-webkit-input-placeholder";
        }
        if (prefix === "-ms-") {
          return "::-ms-input-placeholder";
        }
        if (prefix === "-ms- old") {
          return ":-ms-input-placeholder";
        }
        if (prefix === "-moz- old") {
          return ":-moz-placeholder";
        }
        return `::${prefix}placeholder`;
      }
    };
    Placeholder.names = ["::placeholder"];
    module2.exports = Placeholder;
  }
});

// node_modules/autoprefixer/lib/hacks/placeholder-shown.js
var require_placeholder_shown = __commonJS({
  "node_modules/autoprefixer/lib/hacks/placeholder-shown.js"(exports2, module2) {
    var Selector = require_selector();
    var PlaceholderShown = class extends Selector {
      /**
       * Return different selectors depend on prefix
       */
      prefixed(prefix) {
        if (prefix === "-ms-") {
          return ":-ms-input-placeholder";
        }
        return `:${prefix}placeholder-shown`;
      }
    };
    PlaceholderShown.names = [":placeholder-shown"];
    module2.exports = PlaceholderShown;
  }
});

// node_modules/autoprefixer/lib/hacks/file-selector-button.js
var require_file_selector_button = __commonJS({
  "node_modules/autoprefixer/lib/hacks/file-selector-button.js"(exports2, module2) {
    var Selector = require_selector();
    var utils = require_utils();
    var FileSelectorButton = class extends Selector {
      constructor(name, prefixes, all) {
        super(name, prefixes, all);
        if (this.prefixes) {
          this.prefixes = utils.uniq(this.prefixes.map(() => "-webkit-"));
        }
      }
      /**
       * Return different selectors depend on prefix
       */
      prefixed(prefix) {
        if (prefix === "-webkit-") {
          return "::-webkit-file-upload-button";
        }
        return `::${prefix}file-selector-button`;
      }
    };
    FileSelectorButton.names = ["::file-selector-button"];
    module2.exports = FileSelectorButton;
  }
});

// node_modules/autoprefixer/lib/hacks/flex-spec.js
var require_flex_spec = __commonJS({
  "node_modules/autoprefixer/lib/hacks/flex-spec.js"(exports2, module2) {
    module2.exports = function(prefix) {
      let spec;
      if (prefix === "-webkit- 2009" || prefix === "-moz-") {
        spec = 2009;
      } else if (prefix === "-ms-") {
        spec = 2012;
      } else if (prefix === "-webkit-") {
        spec = "final";
      }
      if (prefix === "-webkit- 2009") {
        prefix = "-webkit-";
      }
      return [spec, prefix];
    };
  }
});

// node_modules/autoprefixer/lib/hacks/flex.js
var require_flex = __commonJS({
  "node_modules/autoprefixer/lib/hacks/flex.js"(exports2, module2) {
    var list = require_postcss().list;
    var flexSpec = require_flex_spec();
    var Declaration = require_declaration2();
    var Flex = class _Flex extends Declaration {
      /**
       * Change property name for 2009 spec
       */
      prefixed(prop, prefix) {
        let spec;
        [spec, prefix] = flexSpec(prefix);
        if (spec === 2009) {
          return prefix + "box-flex";
        }
        return super.prefixed(prop, prefix);
      }
      /**
       * Return property name by final spec
       */
      normalize() {
        return "flex";
      }
      /**
       * Spec 2009 supports only first argument
       * Spec 2012 disallows unitless basis
       */
      set(decl, prefix) {
        let spec = flexSpec(prefix)[0];
        if (spec === 2009) {
          decl.value = list.space(decl.value)[0];
          decl.value = _Flex.oldValues[decl.value] || decl.value;
          return super.set(decl, prefix);
        }
        if (spec === 2012) {
          let components = list.space(decl.value);
          if (components.length === 3 && components[2] === "0") {
            decl.value = components.slice(0, 2).concat("0px").join(" ");
          }
        }
        return super.set(decl, prefix);
      }
    };
    Flex.names = ["flex", "box-flex"];
    Flex.oldValues = {
      auto: "1",
      none: "0"
    };
    module2.exports = Flex;
  }
});

// node_modules/autoprefixer/lib/hacks/order.js
var require_order = __commonJS({
  "node_modules/autoprefixer/lib/hacks/order.js"(exports2, module2) {
    var flexSpec = require_flex_spec();
    var Declaration = require_declaration2();
    var Order = class extends Declaration {
      /**
       * Change property name for 2009 and 2012 specs
       */
      prefixed(prop, prefix) {
        let spec;
        [spec, prefix] = flexSpec(prefix);
        if (spec === 2009) {
          return prefix + "box-ordinal-group";
        }
        if (spec === 2012) {
          return prefix + "flex-order";
        }
        return super.prefixed(prop, prefix);
      }
      /**
       * Return property name by final spec
       */
      normalize() {
        return "order";
      }
      /**
       * Fix value for 2009 spec
       */
      set(decl, prefix) {
        let spec = flexSpec(prefix)[0];
        if (spec === 2009 && /\d/.test(decl.value)) {
          decl.value = (parseInt(decl.value) + 1).toString();
          return super.set(decl, prefix);
        }
        return super.set(decl, prefix);
      }
    };
    Order.names = ["order", "flex-order", "box-ordinal-group"];
    module2.exports = Order;
  }
});

// node_modules/autoprefixer/lib/hacks/filter.js
var require_filter = __commonJS({
  "node_modules/autoprefixer/lib/hacks/filter.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var Filter = class extends Declaration {
      /**
       * Check is it Internet Explorer filter
       */
      check(decl) {
        let v = decl.value;
        return !v.toLowerCase().includes("alpha(") && !v.includes("DXImageTransform.Microsoft") && !v.includes("data:image/svg+xml");
      }
    };
    Filter.names = ["filter"];
    module2.exports = Filter;
  }
});

// node_modules/autoprefixer/lib/hacks/grid-end.js
var require_grid_end = __commonJS({
  "node_modules/autoprefixer/lib/hacks/grid-end.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var { isPureNumber } = require_utils();
    var GridEnd = class extends Declaration {
      /**
       * Change repeating syntax for IE
       */
      insert(decl, prefix, prefixes, result) {
        if (prefix !== "-ms-")
          return super.insert(decl, prefix, prefixes);
        let clonedDecl = this.clone(decl);
        let startProp = decl.prop.replace(/end$/, "start");
        let spanProp = prefix + decl.prop.replace(/end$/, "span");
        if (decl.parent.some((i) => i.prop === spanProp)) {
          return void 0;
        }
        clonedDecl.prop = spanProp;
        if (decl.value.includes("span")) {
          clonedDecl.value = decl.value.replace(/span\s/i, "");
        } else {
          let startDecl;
          decl.parent.walkDecls(startProp, (d) => {
            startDecl = d;
          });
          if (startDecl) {
            if (isPureNumber(startDecl.value)) {
              let value = Number(decl.value) - Number(startDecl.value) + "";
              clonedDecl.value = value;
            } else {
              return void 0;
            }
          } else {
            decl.warn(
              result,
              `Can not prefix ${decl.prop} (${startProp} is not found)`
            );
          }
        }
        decl.cloneBefore(clonedDecl);
        return void 0;
      }
    };
    GridEnd.names = ["grid-row-end", "grid-column-end"];
    module2.exports = GridEnd;
  }
});

// node_modules/autoprefixer/lib/hacks/animation.js
var require_animation = __commonJS({
  "node_modules/autoprefixer/lib/hacks/animation.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var Animation = class extends Declaration {
      /**
       * Don’t add prefixes for modern values.
       */
      check(decl) {
        return !decl.value.split(/\s+/).some((i) => {
          let lower = i.toLowerCase();
          return lower === "reverse" || lower === "alternate-reverse";
        });
      }
    };
    Animation.names = ["animation", "animation-direction"];
    module2.exports = Animation;
  }
});

// node_modules/autoprefixer/lib/hacks/flex-flow.js
var require_flex_flow = __commonJS({
  "node_modules/autoprefixer/lib/hacks/flex-flow.js"(exports2, module2) {
    var flexSpec = require_flex_spec();
    var Declaration = require_declaration2();
    var FlexFlow = class extends Declaration {
      /**
       * Use two properties for 2009 spec
       */
      insert(decl, prefix, prefixes) {
        let spec;
        [spec, prefix] = flexSpec(prefix);
        if (spec !== 2009) {
          return super.insert(decl, prefix, prefixes);
        }
        let values = decl.value.split(/\s+/).filter((i) => i !== "wrap" && i !== "nowrap" && "wrap-reverse");
        if (values.length === 0) {
          return void 0;
        }
        let already = decl.parent.some(
          (i) => i.prop === prefix + "box-orient" || i.prop === prefix + "box-direction"
        );
        if (already) {
          return void 0;
        }
        let value = values[0];
        let orient = value.includes("row") ? "horizontal" : "vertical";
        let dir = value.includes("reverse") ? "reverse" : "normal";
        let cloned = this.clone(decl);
        cloned.prop = prefix + "box-orient";
        cloned.value = orient;
        if (this.needCascade(decl)) {
          cloned.raws.before = this.calcBefore(prefixes, decl, prefix);
        }
        decl.parent.insertBefore(decl, cloned);
        cloned = this.clone(decl);
        cloned.prop = prefix + "box-direction";
        cloned.value = dir;
        if (this.needCascade(decl)) {
          cloned.raws.before = this.calcBefore(prefixes, decl, prefix);
        }
        return decl.parent.insertBefore(decl, cloned);
      }
    };
    FlexFlow.names = ["flex-flow", "box-direction", "box-orient"];
    module2.exports = FlexFlow;
  }
});

// node_modules/autoprefixer/lib/hacks/flex-grow.js
var require_flex_grow = __commonJS({
  "node_modules/autoprefixer/lib/hacks/flex-grow.js"(exports2, module2) {
    var flexSpec = require_flex_spec();
    var Declaration = require_declaration2();
    var Flex = class extends Declaration {
      /**
       * Return property name by final spec
       */
      normalize() {
        return "flex";
      }
      /**
       * Return flex property for 2009 and 2012 specs
       */
      prefixed(prop, prefix) {
        let spec;
        [spec, prefix] = flexSpec(prefix);
        if (spec === 2009) {
          return prefix + "box-flex";
        }
        if (spec === 2012) {
          return prefix + "flex-positive";
        }
        return super.prefixed(prop, prefix);
      }
    };
    Flex.names = ["flex-grow", "flex-positive"];
    module2.exports = Flex;
  }
});

// node_modules/autoprefixer/lib/hacks/flex-wrap.js
var require_flex_wrap = __commonJS({
  "node_modules/autoprefixer/lib/hacks/flex-wrap.js"(exports2, module2) {
    var flexSpec = require_flex_spec();
    var Declaration = require_declaration2();
    var FlexWrap = class extends Declaration {
      /**
       * Don't add prefix for 2009 spec
       */
      set(decl, prefix) {
        let spec = flexSpec(prefix)[0];
        if (spec !== 2009) {
          return super.set(decl, prefix);
        }
        return void 0;
      }
    };
    FlexWrap.names = ["flex-wrap"];
    module2.exports = FlexWrap;
  }
});

// node_modules/autoprefixer/lib/hacks/grid-area.js
var require_grid_area = __commonJS({
  "node_modules/autoprefixer/lib/hacks/grid-area.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var utils = require_grid_utils();
    var GridArea = class extends Declaration {
      /**
       * Translate grid-area to separate -ms- prefixed properties
       */
      insert(decl, prefix, prefixes, result) {
        if (prefix !== "-ms-")
          return super.insert(decl, prefix, prefixes);
        let values = utils.parse(decl);
        let [rowStart, rowSpan] = utils.translate(values, 0, 2);
        let [columnStart, columnSpan] = utils.translate(values, 1, 3);
        [
          ["grid-row", rowStart],
          ["grid-row-span", rowSpan],
          ["grid-column", columnStart],
          ["grid-column-span", columnSpan]
        ].forEach(([prop, value]) => {
          utils.insertDecl(decl, prop, value);
        });
        utils.warnTemplateSelectorNotFound(decl, result);
        utils.warnIfGridRowColumnExists(decl, result);
        return void 0;
      }
    };
    GridArea.names = ["grid-area"];
    module2.exports = GridArea;
  }
});

// node_modules/autoprefixer/lib/hacks/place-self.js
var require_place_self = __commonJS({
  "node_modules/autoprefixer/lib/hacks/place-self.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var utils = require_grid_utils();
    var PlaceSelf = class extends Declaration {
      /**
       * Translate place-self to separate -ms- prefixed properties
       */
      insert(decl, prefix, prefixes) {
        if (prefix !== "-ms-")
          return super.insert(decl, prefix, prefixes);
        if (decl.parent.some((i) => i.prop === "-ms-grid-row-align")) {
          return void 0;
        }
        let [[first, second]] = utils.parse(decl);
        if (second) {
          utils.insertDecl(decl, "grid-row-align", first);
          utils.insertDecl(decl, "grid-column-align", second);
        } else {
          utils.insertDecl(decl, "grid-row-align", first);
          utils.insertDecl(decl, "grid-column-align", first);
        }
        return void 0;
      }
    };
    PlaceSelf.names = ["place-self"];
    module2.exports = PlaceSelf;
  }
});

// node_modules/autoprefixer/lib/hacks/grid-start.js
var require_grid_start = __commonJS({
  "node_modules/autoprefixer/lib/hacks/grid-start.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var GridStart = class extends Declaration {
      /**
       * Do not add prefix for unsupported value in IE
       */
      check(decl) {
        let value = decl.value;
        return !value.includes("/") && !value.includes("span");
      }
      /**
       * Return a final spec property
       */
      normalize(prop) {
        return prop.replace("-start", "");
      }
      /**
       * Change property name for IE
       */
      prefixed(prop, prefix) {
        let result = super.prefixed(prop, prefix);
        if (prefix === "-ms-") {
          result = result.replace("-start", "");
        }
        return result;
      }
    };
    GridStart.names = ["grid-row-start", "grid-column-start"];
    module2.exports = GridStart;
  }
});

// node_modules/autoprefixer/lib/hacks/align-self.js
var require_align_self = __commonJS({
  "node_modules/autoprefixer/lib/hacks/align-self.js"(exports2, module2) {
    var flexSpec = require_flex_spec();
    var Declaration = require_declaration2();
    var AlignSelf = class _AlignSelf extends Declaration {
      check(decl) {
        return decl.parent && !decl.parent.some((i) => {
          return i.prop && i.prop.startsWith("grid-");
        });
      }
      /**
       * Change property name for 2012 specs
       */
      prefixed(prop, prefix) {
        let spec;
        [spec, prefix] = flexSpec(prefix);
        if (spec === 2012) {
          return prefix + "flex-item-align";
        }
        return super.prefixed(prop, prefix);
      }
      /**
       * Return property name by final spec
       */
      normalize() {
        return "align-self";
      }
      /**
       * Change value for 2012 spec and ignore prefix for 2009
       */
      set(decl, prefix) {
        let spec = flexSpec(prefix)[0];
        if (spec === 2012) {
          decl.value = _AlignSelf.oldValues[decl.value] || decl.value;
          return super.set(decl, prefix);
        }
        if (spec === "final") {
          return super.set(decl, prefix);
        }
        return void 0;
      }
    };
    AlignSelf.names = ["align-self", "flex-item-align"];
    AlignSelf.oldValues = {
      "flex-end": "end",
      "flex-start": "start"
    };
    module2.exports = AlignSelf;
  }
});

// node_modules/autoprefixer/lib/hacks/appearance.js
var require_appearance = __commonJS({
  "node_modules/autoprefixer/lib/hacks/appearance.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var utils = require_utils();
    var Appearance = class extends Declaration {
      constructor(name, prefixes, all) {
        super(name, prefixes, all);
        if (this.prefixes) {
          this.prefixes = utils.uniq(
            this.prefixes.map((i) => {
              if (i === "-ms-") {
                return "-webkit-";
              }
              return i;
            })
          );
        }
      }
    };
    Appearance.names = ["appearance"];
    module2.exports = Appearance;
  }
});

// node_modules/autoprefixer/lib/hacks/flex-basis.js
var require_flex_basis = __commonJS({
  "node_modules/autoprefixer/lib/hacks/flex-basis.js"(exports2, module2) {
    var flexSpec = require_flex_spec();
    var Declaration = require_declaration2();
    var FlexBasis = class extends Declaration {
      /**
       * Return property name by final spec
       */
      normalize() {
        return "flex-basis";
      }
      /**
       * Return flex property for 2012 spec
       */
      prefixed(prop, prefix) {
        let spec;
        [spec, prefix] = flexSpec(prefix);
        if (spec === 2012) {
          return prefix + "flex-preferred-size";
        }
        return super.prefixed(prop, prefix);
      }
      /**
       * Ignore 2009 spec and use flex property for 2012
       */
      set(decl, prefix) {
        let spec;
        [spec, prefix] = flexSpec(prefix);
        if (spec === 2012 || spec === "final") {
          return super.set(decl, prefix);
        }
        return void 0;
      }
    };
    FlexBasis.names = ["flex-basis", "flex-preferred-size"];
    module2.exports = FlexBasis;
  }
});

// node_modules/autoprefixer/lib/hacks/mask-border.js
var require_mask_border = __commonJS({
  "node_modules/autoprefixer/lib/hacks/mask-border.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var MaskBorder = class extends Declaration {
      /**
       * Return property name by final spec
       */
      normalize() {
        return this.name.replace("box-image", "border");
      }
      /**
       * Return flex property for 2012 spec
       */
      prefixed(prop, prefix) {
        let result = super.prefixed(prop, prefix);
        if (prefix === "-webkit-") {
          result = result.replace("border", "box-image");
        }
        return result;
      }
    };
    MaskBorder.names = [
      "mask-border",
      "mask-border-source",
      "mask-border-slice",
      "mask-border-width",
      "mask-border-outset",
      "mask-border-repeat",
      "mask-box-image",
      "mask-box-image-source",
      "mask-box-image-slice",
      "mask-box-image-width",
      "mask-box-image-outset",
      "mask-box-image-repeat"
    ];
    module2.exports = MaskBorder;
  }
});

// node_modules/autoprefixer/lib/hacks/mask-composite.js
var require_mask_composite = __commonJS({
  "node_modules/autoprefixer/lib/hacks/mask-composite.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var MaskComposite = class _MaskComposite extends Declaration {
      /**
       * Prefix mask-composite for webkit
       */
      insert(decl, prefix, prefixes) {
        let isCompositeProp = decl.prop === "mask-composite";
        let compositeValues;
        if (isCompositeProp) {
          compositeValues = decl.value.split(",");
        } else {
          compositeValues = decl.value.match(_MaskComposite.regexp) || [];
        }
        compositeValues = compositeValues.map((el) => el.trim()).filter((el) => el);
        let hasCompositeValues = compositeValues.length;
        let compositeDecl;
        if (hasCompositeValues) {
          compositeDecl = this.clone(decl);
          compositeDecl.value = compositeValues.map((value) => _MaskComposite.oldValues[value] || value).join(", ");
          if (compositeValues.includes("intersect")) {
            compositeDecl.value += ", xor";
          }
          compositeDecl.prop = prefix + "mask-composite";
        }
        if (isCompositeProp) {
          if (!hasCompositeValues) {
            return void 0;
          }
          if (this.needCascade(decl)) {
            compositeDecl.raws.before = this.calcBefore(prefixes, decl, prefix);
          }
          return decl.parent.insertBefore(decl, compositeDecl);
        }
        let cloned = this.clone(decl);
        cloned.prop = prefix + cloned.prop;
        if (hasCompositeValues) {
          cloned.value = cloned.value.replace(_MaskComposite.regexp, "");
        }
        if (this.needCascade(decl)) {
          cloned.raws.before = this.calcBefore(prefixes, decl, prefix);
        }
        decl.parent.insertBefore(decl, cloned);
        if (!hasCompositeValues) {
          return decl;
        }
        if (this.needCascade(decl)) {
          compositeDecl.raws.before = this.calcBefore(prefixes, decl, prefix);
        }
        return decl.parent.insertBefore(decl, compositeDecl);
      }
    };
    MaskComposite.names = ["mask", "mask-composite"];
    MaskComposite.oldValues = {
      add: "source-over",
      subtract: "source-out",
      intersect: "source-in",
      exclude: "xor"
    };
    MaskComposite.regexp = new RegExp(
      `\\s+(${Object.keys(MaskComposite.oldValues).join(
        "|"
      )})\\b(?!\\))\\s*(?=[,])`,
      "ig"
    );
    module2.exports = MaskComposite;
  }
});

// node_modules/autoprefixer/lib/hacks/align-items.js
var require_align_items = __commonJS({
  "node_modules/autoprefixer/lib/hacks/align-items.js"(exports2, module2) {
    var flexSpec = require_flex_spec();
    var Declaration = require_declaration2();
    var AlignItems = class _AlignItems extends Declaration {
      /**
       * Change property name for 2009 and 2012 specs
       */
      prefixed(prop, prefix) {
        let spec;
        [spec, prefix] = flexSpec(prefix);
        if (spec === 2009) {
          return prefix + "box-align";
        }
        if (spec === 2012) {
          return prefix + "flex-align";
        }
        return super.prefixed(prop, prefix);
      }
      /**
       * Return property name by final spec
       */
      normalize() {
        return "align-items";
      }
      /**
       * Change value for 2009 and 2012 specs
       */
      set(decl, prefix) {
        let spec = flexSpec(prefix)[0];
        if (spec === 2009 || spec === 2012) {
          decl.value = _AlignItems.oldValues[decl.value] || decl.value;
        }
        return super.set(decl, prefix);
      }
    };
    AlignItems.names = ["align-items", "flex-align", "box-align"];
    AlignItems.oldValues = {
      "flex-end": "end",
      "flex-start": "start"
    };
    module2.exports = AlignItems;
  }
});

// node_modules/autoprefixer/lib/hacks/user-select.js
var require_user_select = __commonJS({
  "node_modules/autoprefixer/lib/hacks/user-select.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var UserSelect = class extends Declaration {
      /**
       * Change prefixed value for IE
       */
      set(decl, prefix) {
        if (prefix === "-ms-" && decl.value === "contain") {
          decl.value = "element";
        }
        return super.set(decl, prefix);
      }
      /**
       * Avoid prefixing all in IE
       */
      insert(decl, prefix, prefixes) {
        if (decl.value === "all" && prefix === "-ms-") {
          return void 0;
        } else {
          return super.insert(decl, prefix, prefixes);
        }
      }
    };
    UserSelect.names = ["user-select"];
    module2.exports = UserSelect;
  }
});

// node_modules/autoprefixer/lib/hacks/flex-shrink.js
var require_flex_shrink = __commonJS({
  "node_modules/autoprefixer/lib/hacks/flex-shrink.js"(exports2, module2) {
    var flexSpec = require_flex_spec();
    var Declaration = require_declaration2();
    var FlexShrink = class extends Declaration {
      /**
       * Return property name by final spec
       */
      normalize() {
        return "flex-shrink";
      }
      /**
       * Return flex property for 2012 spec
       */
      prefixed(prop, prefix) {
        let spec;
        [spec, prefix] = flexSpec(prefix);
        if (spec === 2012) {
          return prefix + "flex-negative";
        }
        return super.prefixed(prop, prefix);
      }
      /**
       * Ignore 2009 spec and use flex property for 2012
       */
      set(decl, prefix) {
        let spec;
        [spec, prefix] = flexSpec(prefix);
        if (spec === 2012 || spec === "final") {
          return super.set(decl, prefix);
        }
        return void 0;
      }
    };
    FlexShrink.names = ["flex-shrink", "flex-negative"];
    module2.exports = FlexShrink;
  }
});

// node_modules/autoprefixer/lib/hacks/break-props.js
var require_break_props = __commonJS({
  "node_modules/autoprefixer/lib/hacks/break-props.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var BreakProps = class extends Declaration {
      /**
       * Change name for -webkit- and -moz- prefix
       */
      prefixed(prop, prefix) {
        return `${prefix}column-${prop}`;
      }
      /**
       * Return property name by final spec
       */
      normalize(prop) {
        if (prop.includes("inside")) {
          return "break-inside";
        }
        if (prop.includes("before")) {
          return "break-before";
        }
        return "break-after";
      }
      /**
       * Change prefixed value for avoid-column and avoid-page
       */
      set(decl, prefix) {
        if (decl.prop === "break-inside" && decl.value === "avoid-column" || decl.value === "avoid-page") {
          decl.value = "avoid";
        }
        return super.set(decl, prefix);
      }
      /**
       * Don’t prefix some values
       */
      insert(decl, prefix, prefixes) {
        if (decl.prop !== "break-inside") {
          return super.insert(decl, prefix, prefixes);
        }
        if (/region/i.test(decl.value) || /page/i.test(decl.value)) {
          return void 0;
        }
        return super.insert(decl, prefix, prefixes);
      }
    };
    BreakProps.names = [
      "break-inside",
      "page-break-inside",
      "column-break-inside",
      "break-before",
      "page-break-before",
      "column-break-before",
      "break-after",
      "page-break-after",
      "column-break-after"
    ];
    module2.exports = BreakProps;
  }
});

// node_modules/autoprefixer/lib/hacks/writing-mode.js
var require_writing_mode = __commonJS({
  "node_modules/autoprefixer/lib/hacks/writing-mode.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var WritingMode = class _WritingMode extends Declaration {
      insert(decl, prefix, prefixes) {
        if (prefix === "-ms-") {
          let cloned = this.set(this.clone(decl), prefix);
          if (this.needCascade(decl)) {
            cloned.raws.before = this.calcBefore(prefixes, decl, prefix);
          }
          let direction = "ltr";
          decl.parent.nodes.forEach((i) => {
            if (i.prop === "direction") {
              if (i.value === "rtl" || i.value === "ltr")
                direction = i.value;
            }
          });
          cloned.value = _WritingMode.msValues[direction][decl.value] || decl.value;
          return decl.parent.insertBefore(decl, cloned);
        }
        return super.insert(decl, prefix, prefixes);
      }
    };
    WritingMode.names = ["writing-mode"];
    WritingMode.msValues = {
      ltr: {
        "horizontal-tb": "lr-tb",
        "vertical-rl": "tb-rl",
        "vertical-lr": "tb-lr"
      },
      rtl: {
        "horizontal-tb": "rl-tb",
        "vertical-rl": "bt-rl",
        "vertical-lr": "bt-lr"
      }
    };
    module2.exports = WritingMode;
  }
});

// node_modules/autoprefixer/lib/hacks/border-image.js
var require_border_image = __commonJS({
  "node_modules/autoprefixer/lib/hacks/border-image.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var BorderImage = class extends Declaration {
      /**
       * Remove fill parameter for prefixed declarations
       */
      set(decl, prefix) {
        decl.value = decl.value.replace(/\s+fill(\s)/, "$1");
        return super.set(decl, prefix);
      }
    };
    BorderImage.names = ["border-image"];
    module2.exports = BorderImage;
  }
});

// node_modules/autoprefixer/lib/hacks/align-content.js
var require_align_content = __commonJS({
  "node_modules/autoprefixer/lib/hacks/align-content.js"(exports2, module2) {
    var flexSpec = require_flex_spec();
    var Declaration = require_declaration2();
    var AlignContent = class _AlignContent extends Declaration {
      /**
       * Change property name for 2012 spec
       */
      prefixed(prop, prefix) {
        let spec;
        [spec, prefix] = flexSpec(prefix);
        if (spec === 2012) {
          return prefix + "flex-line-pack";
        }
        return super.prefixed(prop, prefix);
      }
      /**
       * Return property name by final spec
       */
      normalize() {
        return "align-content";
      }
      /**
       * Change value for 2012 spec and ignore prefix for 2009
       */
      set(decl, prefix) {
        let spec = flexSpec(prefix)[0];
        if (spec === 2012) {
          decl.value = _AlignContent.oldValues[decl.value] || decl.value;
          return super.set(decl, prefix);
        }
        if (spec === "final") {
          return super.set(decl, prefix);
        }
        return void 0;
      }
    };
    AlignContent.names = ["align-content", "flex-line-pack"];
    AlignContent.oldValues = {
      "flex-end": "end",
      "flex-start": "start",
      "space-between": "justify",
      "space-around": "distribute"
    };
    module2.exports = AlignContent;
  }
});

// node_modules/autoprefixer/lib/hacks/border-radius.js
var require_border_radius = __commonJS({
  "node_modules/autoprefixer/lib/hacks/border-radius.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var BorderRadius = class _BorderRadius extends Declaration {
      /**
       * Change syntax, when add Mozilla prefix
       */
      prefixed(prop, prefix) {
        if (prefix === "-moz-") {
          return prefix + (_BorderRadius.toMozilla[prop] || prop);
        }
        return super.prefixed(prop, prefix);
      }
      /**
       * Return unprefixed version of property
       */
      normalize(prop) {
        return _BorderRadius.toNormal[prop] || prop;
      }
    };
    BorderRadius.names = ["border-radius"];
    BorderRadius.toMozilla = {};
    BorderRadius.toNormal = {};
    for (let ver of ["top", "bottom"]) {
      for (let hor of ["left", "right"]) {
        let normal = `border-${ver}-${hor}-radius`;
        let mozilla = `border-radius-${ver}${hor}`;
        BorderRadius.names.push(normal);
        BorderRadius.names.push(mozilla);
        BorderRadius.toMozilla[normal] = mozilla;
        BorderRadius.toNormal[mozilla] = normal;
      }
    }
    module2.exports = BorderRadius;
  }
});

// node_modules/autoprefixer/lib/hacks/block-logical.js
var require_block_logical = __commonJS({
  "node_modules/autoprefixer/lib/hacks/block-logical.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var BlockLogical = class extends Declaration {
      /**
       * Use old syntax for -moz- and -webkit-
       */
      prefixed(prop, prefix) {
        if (prop.includes("-start")) {
          return prefix + prop.replace("-block-start", "-before");
        }
        return prefix + prop.replace("-block-end", "-after");
      }
      /**
       * Return property name by spec
       */
      normalize(prop) {
        if (prop.includes("-before")) {
          return prop.replace("-before", "-block-start");
        }
        return prop.replace("-after", "-block-end");
      }
    };
    BlockLogical.names = [
      "border-block-start",
      "border-block-end",
      "margin-block-start",
      "margin-block-end",
      "padding-block-start",
      "padding-block-end",
      "border-before",
      "border-after",
      "margin-before",
      "margin-after",
      "padding-before",
      "padding-after"
    ];
    module2.exports = BlockLogical;
  }
});

// node_modules/autoprefixer/lib/hacks/grid-template.js
var require_grid_template = __commonJS({
  "node_modules/autoprefixer/lib/hacks/grid-template.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var {
      parseTemplate,
      warnMissedAreas,
      getGridGap,
      warnGridGap,
      inheritGridGap
    } = require_grid_utils();
    var GridTemplate = class extends Declaration {
      /**
       * Translate grid-template to separate -ms- prefixed properties
       */
      insert(decl, prefix, prefixes, result) {
        if (prefix !== "-ms-")
          return super.insert(decl, prefix, prefixes);
        if (decl.parent.some((i) => i.prop === "-ms-grid-rows")) {
          return void 0;
        }
        let gap = getGridGap(decl);
        let inheritedGap = inheritGridGap(decl, gap);
        let { rows, columns, areas } = parseTemplate({
          decl,
          gap: inheritedGap || gap
        });
        let hasAreas = Object.keys(areas).length > 0;
        let hasRows = Boolean(rows);
        let hasColumns = Boolean(columns);
        warnGridGap({
          gap,
          hasColumns,
          decl,
          result
        });
        warnMissedAreas(areas, decl, result);
        if (hasRows && hasColumns || hasAreas) {
          decl.cloneBefore({
            prop: "-ms-grid-rows",
            value: rows,
            raws: {}
          });
        }
        if (hasColumns) {
          decl.cloneBefore({
            prop: "-ms-grid-columns",
            value: columns,
            raws: {}
          });
        }
        return decl;
      }
    };
    GridTemplate.names = ["grid-template"];
    module2.exports = GridTemplate;
  }
});

// node_modules/autoprefixer/lib/hacks/inline-logical.js
var require_inline_logical = __commonJS({
  "node_modules/autoprefixer/lib/hacks/inline-logical.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var InlineLogical = class extends Declaration {
      /**
       * Use old syntax for -moz- and -webkit-
       */
      prefixed(prop, prefix) {
        return prefix + prop.replace("-inline", "");
      }
      /**
       * Return property name by spec
       */
      normalize(prop) {
        return prop.replace(/(margin|padding|border)-(start|end)/, "$1-inline-$2");
      }
    };
    InlineLogical.names = [
      "border-inline-start",
      "border-inline-end",
      "margin-inline-start",
      "margin-inline-end",
      "padding-inline-start",
      "padding-inline-end",
      "border-start",
      "border-end",
      "margin-start",
      "margin-end",
      "padding-start",
      "padding-end"
    ];
    module2.exports = InlineLogical;
  }
});

// node_modules/autoprefixer/lib/hacks/grid-row-align.js
var require_grid_row_align = __commonJS({
  "node_modules/autoprefixer/lib/hacks/grid-row-align.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var GridRowAlign = class extends Declaration {
      /**
       * Do not prefix flexbox values
       */
      check(decl) {
        return !decl.value.includes("flex-") && decl.value !== "baseline";
      }
      /**
       * Change property name for IE
       */
      prefixed(prop, prefix) {
        return prefix + "grid-row-align";
      }
      /**
       * Change IE property back
       */
      normalize() {
        return "align-self";
      }
    };
    GridRowAlign.names = ["grid-row-align"];
    module2.exports = GridRowAlign;
  }
});

// node_modules/autoprefixer/lib/hacks/transform-decl.js
var require_transform_decl = __commonJS({
  "node_modules/autoprefixer/lib/hacks/transform-decl.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var TransformDecl = class _TransformDecl extends Declaration {
      /**
       * Recursively check all parents for @keyframes
       */
      keyframeParents(decl) {
        let { parent } = decl;
        while (parent) {
          if (parent.type === "atrule" && parent.name === "keyframes") {
            return true;
          }
          ;
          ({ parent } = parent);
        }
        return false;
      }
      /**
       * Is transform contain 3D commands
       */
      contain3d(decl) {
        if (decl.prop === "transform-origin") {
          return false;
        }
        for (let func of _TransformDecl.functions3d) {
          if (decl.value.includes(`${func}(`)) {
            return true;
          }
        }
        return false;
      }
      /**
       * Replace rotateZ to rotate for IE 9
       */
      set(decl, prefix) {
        decl = super.set(decl, prefix);
        if (prefix === "-ms-") {
          decl.value = decl.value.replace(/rotatez/gi, "rotate");
        }
        return decl;
      }
      /**
       * Don't add prefix for IE in keyframes
       */
      insert(decl, prefix, prefixes) {
        if (prefix === "-ms-") {
          if (!this.contain3d(decl) && !this.keyframeParents(decl)) {
            return super.insert(decl, prefix, prefixes);
          }
        } else if (prefix === "-o-") {
          if (!this.contain3d(decl)) {
            return super.insert(decl, prefix, prefixes);
          }
        } else {
          return super.insert(decl, prefix, prefixes);
        }
        return void 0;
      }
    };
    TransformDecl.names = ["transform", "transform-origin"];
    TransformDecl.functions3d = [
      "matrix3d",
      "translate3d",
      "translateZ",
      "scale3d",
      "scaleZ",
      "rotate3d",
      "rotateX",
      "rotateY",
      "perspective"
    ];
    module2.exports = TransformDecl;
  }
});

// node_modules/autoprefixer/lib/hacks/flex-direction.js
var require_flex_direction = __commonJS({
  "node_modules/autoprefixer/lib/hacks/flex-direction.js"(exports2, module2) {
    var flexSpec = require_flex_spec();
    var Declaration = require_declaration2();
    var FlexDirection = class extends Declaration {
      /**
       * Return property name by final spec
       */
      normalize() {
        return "flex-direction";
      }
      /**
       * Use two properties for 2009 spec
       */
      insert(decl, prefix, prefixes) {
        let spec;
        [spec, prefix] = flexSpec(prefix);
        if (spec !== 2009) {
          return super.insert(decl, prefix, prefixes);
        }
        let already = decl.parent.some(
          (i) => i.prop === prefix + "box-orient" || i.prop === prefix + "box-direction"
        );
        if (already) {
          return void 0;
        }
        let v = decl.value;
        let orient, dir;
        if (v === "inherit" || v === "initial" || v === "unset") {
          orient = v;
          dir = v;
        } else {
          orient = v.includes("row") ? "horizontal" : "vertical";
          dir = v.includes("reverse") ? "reverse" : "normal";
        }
        let cloned = this.clone(decl);
        cloned.prop = prefix + "box-orient";
        cloned.value = orient;
        if (this.needCascade(decl)) {
          cloned.raws.before = this.calcBefore(prefixes, decl, prefix);
        }
        decl.parent.insertBefore(decl, cloned);
        cloned = this.clone(decl);
        cloned.prop = prefix + "box-direction";
        cloned.value = dir;
        if (this.needCascade(decl)) {
          cloned.raws.before = this.calcBefore(prefixes, decl, prefix);
        }
        return decl.parent.insertBefore(decl, cloned);
      }
      /**
       * Clean two properties for 2009 spec
       */
      old(prop, prefix) {
        let spec;
        [spec, prefix] = flexSpec(prefix);
        if (spec === 2009) {
          return [prefix + "box-orient", prefix + "box-direction"];
        } else {
          return super.old(prop, prefix);
        }
      }
    };
    FlexDirection.names = ["flex-direction", "box-direction", "box-orient"];
    module2.exports = FlexDirection;
  }
});

// node_modules/autoprefixer/lib/hacks/image-rendering.js
var require_image_rendering = __commonJS({
  "node_modules/autoprefixer/lib/hacks/image-rendering.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var ImageRendering = class extends Declaration {
      /**
       * Add hack only for crisp-edges
       */
      check(decl) {
        return decl.value === "pixelated";
      }
      /**
       * Change property name for IE
       */
      prefixed(prop, prefix) {
        if (prefix === "-ms-") {
          return "-ms-interpolation-mode";
        }
        return super.prefixed(prop, prefix);
      }
      /**
       * Change property and value for IE
       */
      set(decl, prefix) {
        if (prefix !== "-ms-")
          return super.set(decl, prefix);
        decl.prop = "-ms-interpolation-mode";
        decl.value = "nearest-neighbor";
        return decl;
      }
      /**
       * Return property name by spec
       */
      normalize() {
        return "image-rendering";
      }
      /**
       * Warn on old value
       */
      process(node, result) {
        return super.process(node, result);
      }
    };
    ImageRendering.names = ["image-rendering", "interpolation-mode"];
    module2.exports = ImageRendering;
  }
});

// node_modules/autoprefixer/lib/hacks/backdrop-filter.js
var require_backdrop_filter = __commonJS({
  "node_modules/autoprefixer/lib/hacks/backdrop-filter.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var utils = require_utils();
    var BackdropFilter = class extends Declaration {
      constructor(name, prefixes, all) {
        super(name, prefixes, all);
        if (this.prefixes) {
          this.prefixes = utils.uniq(
            this.prefixes.map((i) => {
              return i === "-ms-" ? "-webkit-" : i;
            })
          );
        }
      }
    };
    BackdropFilter.names = ["backdrop-filter"];
    module2.exports = BackdropFilter;
  }
});

// node_modules/autoprefixer/lib/hacks/background-clip.js
var require_background_clip = __commonJS({
  "node_modules/autoprefixer/lib/hacks/background-clip.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var utils = require_utils();
    var BackgroundClip = class extends Declaration {
      constructor(name, prefixes, all) {
        super(name, prefixes, all);
        if (this.prefixes) {
          this.prefixes = utils.uniq(
            this.prefixes.map((i) => {
              return i === "-ms-" ? "-webkit-" : i;
            })
          );
        }
      }
      check(decl) {
        return decl.value.toLowerCase() === "text";
      }
    };
    BackgroundClip.names = ["background-clip"];
    module2.exports = BackgroundClip;
  }
});

// node_modules/autoprefixer/lib/hacks/text-decoration.js
var require_text_decoration = __commonJS({
  "node_modules/autoprefixer/lib/hacks/text-decoration.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var BASIC = [
      "none",
      "underline",
      "overline",
      "line-through",
      "blink",
      "inherit",
      "initial",
      "unset"
    ];
    var TextDecoration = class extends Declaration {
      /**
       * Do not add prefixes for basic values.
       */
      check(decl) {
        return decl.value.split(/\s+/).some((i) => !BASIC.includes(i));
      }
    };
    TextDecoration.names = ["text-decoration"];
    module2.exports = TextDecoration;
  }
});

// node_modules/autoprefixer/lib/hacks/justify-content.js
var require_justify_content = __commonJS({
  "node_modules/autoprefixer/lib/hacks/justify-content.js"(exports2, module2) {
    var flexSpec = require_flex_spec();
    var Declaration = require_declaration2();
    var JustifyContent = class _JustifyContent extends Declaration {
      /**
       * Change property name for 2009 and 2012 specs
       */
      prefixed(prop, prefix) {
        let spec;
        [spec, prefix] = flexSpec(prefix);
        if (spec === 2009) {
          return prefix + "box-pack";
        }
        if (spec === 2012) {
          return prefix + "flex-pack";
        }
        return super.prefixed(prop, prefix);
      }
      /**
       * Return property name by final spec
       */
      normalize() {
        return "justify-content";
      }
      /**
       * Change value for 2009 and 2012 specs
       */
      set(decl, prefix) {
        let spec = flexSpec(prefix)[0];
        if (spec === 2009 || spec === 2012) {
          let value = _JustifyContent.oldValues[decl.value] || decl.value;
          decl.value = value;
          if (spec !== 2009 || value !== "distribute") {
            return super.set(decl, prefix);
          }
        } else if (spec === "final") {
          return super.set(decl, prefix);
        }
        return void 0;
      }
    };
    JustifyContent.names = ["justify-content", "flex-pack", "box-pack"];
    JustifyContent.oldValues = {
      "flex-end": "end",
      "flex-start": "start",
      "space-between": "justify",
      "space-around": "distribute"
    };
    module2.exports = JustifyContent;
  }
});

// node_modules/autoprefixer/lib/hacks/background-size.js
var require_background_size = __commonJS({
  "node_modules/autoprefixer/lib/hacks/background-size.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var BackgroundSize = class extends Declaration {
      /**
       * Duplication parameter for -webkit- browsers
       */
      set(decl, prefix) {
        let value = decl.value.toLowerCase();
        if (prefix === "-webkit-" && !value.includes(" ") && value !== "contain" && value !== "cover") {
          decl.value = decl.value + " " + decl.value;
        }
        return super.set(decl, prefix);
      }
    };
    BackgroundSize.names = ["background-size"];
    module2.exports = BackgroundSize;
  }
});

// node_modules/autoprefixer/lib/hacks/grid-row-column.js
var require_grid_row_column = __commonJS({
  "node_modules/autoprefixer/lib/hacks/grid-row-column.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var utils = require_grid_utils();
    var GridRowColumn = class extends Declaration {
      /**
       * Translate grid-row / grid-column to separate -ms- prefixed properties
       */
      insert(decl, prefix, prefixes) {
        if (prefix !== "-ms-")
          return super.insert(decl, prefix, prefixes);
        let values = utils.parse(decl);
        let [start, span] = utils.translate(values, 0, 1);
        let hasStartValueSpan = values[0] && values[0].includes("span");
        if (hasStartValueSpan) {
          span = values[0].join("").replace(/\D/g, "");
        }
        ;
        [
          [decl.prop, start],
          [`${decl.prop}-span`, span]
        ].forEach(([prop, value]) => {
          utils.insertDecl(decl, prop, value);
        });
        return void 0;
      }
    };
    GridRowColumn.names = ["grid-row", "grid-column"];
    module2.exports = GridRowColumn;
  }
});

// node_modules/autoprefixer/lib/hacks/grid-rows-columns.js
var require_grid_rows_columns = __commonJS({
  "node_modules/autoprefixer/lib/hacks/grid-rows-columns.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var {
      prefixTrackProp,
      prefixTrackValue,
      autoplaceGridItems,
      getGridGap,
      inheritGridGap
    } = require_grid_utils();
    var Processor = require_processor2();
    var GridRowsColumns = class extends Declaration {
      /**
       * Change property name for IE
       */
      prefixed(prop, prefix) {
        if (prefix === "-ms-") {
          return prefixTrackProp({ prop, prefix });
        }
        return super.prefixed(prop, prefix);
      }
      /**
       * Change IE property back
       */
      normalize(prop) {
        return prop.replace(/^grid-(rows|columns)/, "grid-template-$1");
      }
      insert(decl, prefix, prefixes, result) {
        if (prefix !== "-ms-")
          return super.insert(decl, prefix, prefixes);
        let { parent, prop, value } = decl;
        let isRowProp = prop.includes("rows");
        let isColumnProp = prop.includes("columns");
        let hasGridTemplate = parent.some(
          (i) => i.prop === "grid-template" || i.prop === "grid-template-areas"
        );
        if (hasGridTemplate && isRowProp) {
          return false;
        }
        let processor = new Processor({ options: {} });
        let status = processor.gridStatus(parent, result);
        let gap = getGridGap(decl);
        gap = inheritGridGap(decl, gap) || gap;
        let gapValue = isRowProp ? gap.row : gap.column;
        if ((status === "no-autoplace" || status === true) && !hasGridTemplate) {
          gapValue = null;
        }
        let prefixValue = prefixTrackValue({
          value,
          gap: gapValue
        });
        decl.cloneBefore({
          prop: prefixTrackProp({ prop, prefix }),
          value: prefixValue
        });
        let autoflow = parent.nodes.find((i) => i.prop === "grid-auto-flow");
        let autoflowValue = "row";
        if (autoflow && !processor.disabled(autoflow, result)) {
          autoflowValue = autoflow.value.trim();
        }
        if (status === "autoplace") {
          let rowDecl = parent.nodes.find((i) => i.prop === "grid-template-rows");
          if (!rowDecl && hasGridTemplate) {
            return void 0;
          } else if (!rowDecl && !hasGridTemplate) {
            decl.warn(
              result,
              "Autoplacement does not work without grid-template-rows property"
            );
            return void 0;
          }
          let columnDecl = parent.nodes.find((i) => {
            return i.prop === "grid-template-columns";
          });
          if (!columnDecl && !hasGridTemplate) {
            decl.warn(
              result,
              "Autoplacement does not work without grid-template-columns property"
            );
          }
          if (isColumnProp && !hasGridTemplate) {
            autoplaceGridItems(decl, result, gap, autoflowValue);
          }
        }
        return void 0;
      }
    };
    GridRowsColumns.names = [
      "grid-template-rows",
      "grid-template-columns",
      "grid-rows",
      "grid-columns"
    ];
    module2.exports = GridRowsColumns;
  }
});

// node_modules/autoprefixer/lib/hacks/grid-column-align.js
var require_grid_column_align = __commonJS({
  "node_modules/autoprefixer/lib/hacks/grid-column-align.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var GridColumnAlign = class extends Declaration {
      /**
       * Do not prefix flexbox values
       */
      check(decl) {
        return !decl.value.includes("flex-") && decl.value !== "baseline";
      }
      /**
       * Change property name for IE
       */
      prefixed(prop, prefix) {
        return prefix + "grid-column-align";
      }
      /**
       * Change IE property back
       */
      normalize() {
        return "justify-self";
      }
    };
    GridColumnAlign.names = ["grid-column-align"];
    module2.exports = GridColumnAlign;
  }
});

// node_modules/autoprefixer/lib/hacks/print-color-adjust.js
var require_print_color_adjust = __commonJS({
  "node_modules/autoprefixer/lib/hacks/print-color-adjust.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var PrintColorAdjust = class extends Declaration {
      /**
       * Change property name for WebKit-based browsers
       */
      prefixed(prop, prefix) {
        if (prefix === "-moz-") {
          return "color-adjust";
        } else {
          return prefix + "print-color-adjust";
        }
      }
      /**
       * Return property name by spec
       */
      normalize() {
        return "print-color-adjust";
      }
    };
    PrintColorAdjust.names = ["print-color-adjust", "color-adjust"];
    module2.exports = PrintColorAdjust;
  }
});

// node_modules/autoprefixer/lib/hacks/overscroll-behavior.js
var require_overscroll_behavior = __commonJS({
  "node_modules/autoprefixer/lib/hacks/overscroll-behavior.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var OverscrollBehavior = class extends Declaration {
      /**
       * Change property name for IE
       */
      prefixed(prop, prefix) {
        return prefix + "scroll-chaining";
      }
      /**
       * Return property name by spec
       */
      normalize() {
        return "overscroll-behavior";
      }
      /**
       * Change value for IE
       */
      set(decl, prefix) {
        if (decl.value === "auto") {
          decl.value = "chained";
        } else if (decl.value === "none" || decl.value === "contain") {
          decl.value = "none";
        }
        return super.set(decl, prefix);
      }
    };
    OverscrollBehavior.names = ["overscroll-behavior", "scroll-chaining"];
    module2.exports = OverscrollBehavior;
  }
});

// node_modules/autoprefixer/lib/hacks/grid-template-areas.js
var require_grid_template_areas = __commonJS({
  "node_modules/autoprefixer/lib/hacks/grid-template-areas.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var {
      parseGridAreas,
      warnMissedAreas,
      prefixTrackProp,
      prefixTrackValue,
      getGridGap,
      warnGridGap,
      inheritGridGap
    } = require_grid_utils();
    function getGridRows(tpl) {
      return tpl.trim().slice(1, -1).split(/["']\s*["']?/g);
    }
    var GridTemplateAreas = class extends Declaration {
      /**
       * Translate grid-template-areas to separate -ms- prefixed properties
       */
      insert(decl, prefix, prefixes, result) {
        if (prefix !== "-ms-")
          return super.insert(decl, prefix, prefixes);
        let hasColumns = false;
        let hasRows = false;
        let parent = decl.parent;
        let gap = getGridGap(decl);
        gap = inheritGridGap(decl, gap) || gap;
        parent.walkDecls(/-ms-grid-rows/, (i) => i.remove());
        parent.walkDecls(/grid-template-(rows|columns)/, (trackDecl) => {
          if (trackDecl.prop === "grid-template-rows") {
            hasRows = true;
            let { prop, value } = trackDecl;
            trackDecl.cloneBefore({
              prop: prefixTrackProp({ prop, prefix }),
              value: prefixTrackValue({ value, gap: gap.row })
            });
          } else {
            hasColumns = true;
          }
        });
        let gridRows = getGridRows(decl.value);
        if (hasColumns && !hasRows && gap.row && gridRows.length > 1) {
          decl.cloneBefore({
            prop: "-ms-grid-rows",
            value: prefixTrackValue({
              value: `repeat(${gridRows.length}, auto)`,
              gap: gap.row
            }),
            raws: {}
          });
        }
        warnGridGap({
          gap,
          hasColumns,
          decl,
          result
        });
        let areas = parseGridAreas({
          rows: gridRows,
          gap
        });
        warnMissedAreas(areas, decl, result);
        return decl;
      }
    };
    GridTemplateAreas.names = ["grid-template-areas"];
    module2.exports = GridTemplateAreas;
  }
});

// node_modules/autoprefixer/lib/hacks/text-emphasis-position.js
var require_text_emphasis_position = __commonJS({
  "node_modules/autoprefixer/lib/hacks/text-emphasis-position.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var TextEmphasisPosition = class extends Declaration {
      set(decl, prefix) {
        if (prefix === "-webkit-") {
          decl.value = decl.value.replace(/\s*(right|left)\s*/i, "");
        }
        return super.set(decl, prefix);
      }
    };
    TextEmphasisPosition.names = ["text-emphasis-position"];
    module2.exports = TextEmphasisPosition;
  }
});

// node_modules/autoprefixer/lib/hacks/text-decoration-skip-ink.js
var require_text_decoration_skip_ink = __commonJS({
  "node_modules/autoprefixer/lib/hacks/text-decoration-skip-ink.js"(exports2, module2) {
    var Declaration = require_declaration2();
    var TextDecorationSkipInk = class extends Declaration {
      /**
       * Change prefix for ink value
       */
      set(decl, prefix) {
        if (decl.prop === "text-decoration-skip-ink" && decl.value === "auto") {
          decl.prop = prefix + "text-decoration-skip";
          decl.value = "ink";
          return decl;
        } else {
          return super.set(decl, prefix);
        }
      }
    };
    TextDecorationSkipInk.names = [
      "text-decoration-skip-ink",
      "text-decoration-skip"
    ];
    module2.exports = TextDecorationSkipInk;
  }
});

// node_modules/normalize-range/index.js
var require_normalize_range = __commonJS({
  "node_modules/normalize-range/index.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      wrap: wrapRange,
      limit: limitRange,
      validate: validateRange,
      test: testRange,
      curry,
      name
    };
    function wrapRange(min, max, value) {
      var maxLessMin = max - min;
      return ((value - min) % maxLessMin + maxLessMin) % maxLessMin + min;
    }
    function limitRange(min, max, value) {
      return Math.max(min, Math.min(max, value));
    }
    function validateRange(min, max, value, minExclusive, maxExclusive) {
      if (!testRange(min, max, value, minExclusive, maxExclusive)) {
        throw new Error(value + " is outside of range [" + min + "," + max + ")");
      }
      return value;
    }
    function testRange(min, max, value, minExclusive, maxExclusive) {
      return !(value < min || value > max || maxExclusive && value === max || minExclusive && value === min);
    }
    function name(min, max, minExcl, maxExcl) {
      return (minExcl ? "(" : "[") + min + "," + max + (maxExcl ? ")" : "]");
    }
    function curry(min, max, minExclusive, maxExclusive) {
      var boundNameFn = name.bind(null, min, max, minExclusive, maxExclusive);
      return {
        wrap: wrapRange.bind(null, min, max),
        limit: limitRange.bind(null, min, max),
        validate: function(value) {
          return validateRange(min, max, value, minExclusive, maxExclusive);
        },
        test: function(value) {
          return testRange(min, max, value, minExclusive, maxExclusive);
        },
        toString: boundNameFn,
        name: boundNameFn
      };
    }
  }
});

// node_modules/autoprefixer/lib/hacks/gradient.js
var require_gradient = __commonJS({
  "node_modules/autoprefixer/lib/hacks/gradient.js"(exports2, module2) {
    var parser = require_lib();
    var range = require_normalize_range();
    var OldValue = require_old_value();
    var Value = require_value();
    var utils = require_utils();
    var IS_DIRECTION = /top|left|right|bottom/gi;
    var Gradient = class _Gradient extends Value {
      /**
       * Change degrees for webkit prefix
       */
      replace(string, prefix) {
        let ast = parser(string);
        for (let node of ast.nodes) {
          let gradientName = this.name;
          if (node.type === "function" && node.value === gradientName) {
            node.nodes = this.newDirection(node.nodes);
            node.nodes = this.normalize(node.nodes, gradientName);
            if (prefix === "-webkit- old") {
              let changes = this.oldWebkit(node);
              if (!changes) {
                return false;
              }
            } else {
              node.nodes = this.convertDirection(node.nodes);
              node.value = prefix + node.value;
            }
          }
        }
        return ast.toString();
      }
      /**
       * Replace first token
       */
      replaceFirst(params, ...words) {
        let prefix = words.map((i) => {
          if (i === " ") {
            return { type: "space", value: i };
          }
          return { type: "word", value: i };
        });
        return prefix.concat(params.slice(1));
      }
      /**
       * Convert angle unit to deg
       */
      normalizeUnit(str, full) {
        let num = parseFloat(str);
        let deg = num / full * 360;
        return `${deg}deg`;
      }
      /**
       * Normalize angle
       */
      normalize(nodes, gradientName) {
        if (!nodes[0])
          return nodes;
        if (/-?\d+(.\d+)?grad/.test(nodes[0].value)) {
          nodes[0].value = this.normalizeUnit(nodes[0].value, 400);
        } else if (/-?\d+(.\d+)?rad/.test(nodes[0].value)) {
          nodes[0].value = this.normalizeUnit(nodes[0].value, 2 * Math.PI);
        } else if (/-?\d+(.\d+)?turn/.test(nodes[0].value)) {
          nodes[0].value = this.normalizeUnit(nodes[0].value, 1);
        } else if (nodes[0].value.includes("deg")) {
          let num = parseFloat(nodes[0].value);
          num = range.wrap(0, 360, num);
          nodes[0].value = `${num}deg`;
        }
        if (gradientName === "linear-gradient" || gradientName === "repeating-linear-gradient") {
          let direction = nodes[0].value;
          if (direction === "0deg" || direction === "0") {
            nodes = this.replaceFirst(nodes, "to", " ", "top");
          } else if (direction === "90deg") {
            nodes = this.replaceFirst(nodes, "to", " ", "right");
          } else if (direction === "180deg") {
            nodes = this.replaceFirst(nodes, "to", " ", "bottom");
          } else if (direction === "270deg") {
            nodes = this.replaceFirst(nodes, "to", " ", "left");
          }
        }
        return nodes;
      }
      /**
       * Replace old direction to new
       */
      newDirection(params) {
        if (params[0].value === "to") {
          return params;
        }
        IS_DIRECTION.lastIndex = 0;
        if (!IS_DIRECTION.test(params[0].value)) {
          return params;
        }
        params.unshift(
          {
            type: "word",
            value: "to"
          },
          {
            type: "space",
            value: " "
          }
        );
        for (let i = 2; i < params.length; i++) {
          if (params[i].type === "div") {
            break;
          }
          if (params[i].type === "word") {
            params[i].value = this.revertDirection(params[i].value);
          }
        }
        return params;
      }
      /**
       * Look for at word
       */
      isRadial(params) {
        let state = "before";
        for (let param of params) {
          if (state === "before" && param.type === "space") {
            state = "at";
          } else if (state === "at" && param.value === "at") {
            state = "after";
          } else if (state === "after" && param.type === "space") {
            return true;
          } else if (param.type === "div") {
            break;
          } else {
            state = "before";
          }
        }
        return false;
      }
      /**
       * Change new direction to old
       */
      convertDirection(params) {
        if (params.length > 0) {
          if (params[0].value === "to") {
            this.fixDirection(params);
          } else if (params[0].value.includes("deg")) {
            this.fixAngle(params);
          } else if (this.isRadial(params)) {
            this.fixRadial(params);
          }
        }
        return params;
      }
      /**
       * Replace `to top left` to `bottom right`
       */
      fixDirection(params) {
        params.splice(0, 2);
        for (let param of params) {
          if (param.type === "div") {
            break;
          }
          if (param.type === "word") {
            param.value = this.revertDirection(param.value);
          }
        }
      }
      /**
       * Add 90 degrees
       */
      fixAngle(params) {
        let first = params[0].value;
        first = parseFloat(first);
        first = Math.abs(450 - first) % 360;
        first = this.roundFloat(first, 3);
        params[0].value = `${first}deg`;
      }
      /**
       * Fix radial direction syntax
       */
      fixRadial(params) {
        let first = [];
        let second = [];
        let a, b, c, i, next;
        for (i = 0; i < params.length - 2; i++) {
          a = params[i];
          b = params[i + 1];
          c = params[i + 2];
          if (a.type === "space" && b.value === "at" && c.type === "space") {
            next = i + 3;
            break;
          } else {
            first.push(a);
          }
        }
        let div;
        for (i = next; i < params.length; i++) {
          if (params[i].type === "div") {
            div = params[i];
            break;
          } else {
            second.push(params[i]);
          }
        }
        params.splice(0, i, ...second, div, ...first);
      }
      revertDirection(word) {
        return _Gradient.directions[word.toLowerCase()] || word;
      }
      /**
       * Round float and save digits under dot
       */
      roundFloat(float, digits) {
        return parseFloat(float.toFixed(digits));
      }
      /**
       * Convert to old webkit syntax
       */
      oldWebkit(node) {
        let { nodes } = node;
        let string = parser.stringify(node.nodes);
        if (this.name !== "linear-gradient") {
          return false;
        }
        if (nodes[0] && nodes[0].value.includes("deg")) {
          return false;
        }
        if (string.includes("px") || string.includes("-corner") || string.includes("-side")) {
          return false;
        }
        let params = [[]];
        for (let i of nodes) {
          params[params.length - 1].push(i);
          if (i.type === "div" && i.value === ",") {
            params.push([]);
          }
        }
        this.oldDirection(params);
        this.colorStops(params);
        node.nodes = [];
        for (let param of params) {
          node.nodes = node.nodes.concat(param);
        }
        node.nodes.unshift(
          { type: "word", value: "linear" },
          this.cloneDiv(node.nodes)
        );
        node.value = "-webkit-gradient";
        return true;
      }
      /**
       * Change direction syntax to old webkit
       */
      oldDirection(params) {
        let div = this.cloneDiv(params[0]);
        if (params[0][0].value !== "to") {
          return params.unshift([
            { type: "word", value: _Gradient.oldDirections.bottom },
            div
          ]);
        } else {
          let words = [];
          for (let node of params[0].slice(2)) {
            if (node.type === "word") {
              words.push(node.value.toLowerCase());
            }
          }
          words = words.join(" ");
          let old = _Gradient.oldDirections[words] || words;
          params[0] = [{ type: "word", value: old }, div];
          return params[0];
        }
      }
      /**
       * Get div token from exists parameters
       */
      cloneDiv(params) {
        for (let i of params) {
          if (i.type === "div" && i.value === ",") {
            return i;
          }
        }
        return { type: "div", value: ",", after: " " };
      }
      /**
       * Change colors syntax to old webkit
       */
      colorStops(params) {
        let result = [];
        for (let i = 0; i < params.length; i++) {
          let pos;
          let param = params[i];
          let item;
          if (i === 0) {
            continue;
          }
          let color = parser.stringify(param[0]);
          if (param[1] && param[1].type === "word") {
            pos = param[1].value;
          } else if (param[2] && param[2].type === "word") {
            pos = param[2].value;
          }
          let stop;
          if (i === 1 && (!pos || pos === "0%")) {
            stop = `from(${color})`;
          } else if (i === params.length - 1 && (!pos || pos === "100%")) {
            stop = `to(${color})`;
          } else if (pos) {
            stop = `color-stop(${pos}, ${color})`;
          } else {
            stop = `color-stop(${color})`;
          }
          let div = param[param.length - 1];
          params[i] = [{ type: "word", value: stop }];
          if (div.type === "div" && div.value === ",") {
            item = params[i].push(div);
          }
          result.push(item);
        }
        return result;
      }
      /**
       * Remove old WebKit gradient too
       */
      old(prefix) {
        if (prefix === "-webkit-") {
          let type;
          if (this.name === "linear-gradient") {
            type = "linear";
          } else if (this.name === "repeating-linear-gradient") {
            type = "repeating-linear";
          } else if (this.name === "repeating-radial-gradient") {
            type = "repeating-radial";
          } else {
            type = "radial";
          }
          let string = "-gradient";
          let regexp = utils.regexp(
            `-webkit-(${type}-gradient|gradient\\(\\s*${type})`,
            false
          );
          return new OldValue(this.name, prefix + this.name, string, regexp);
        } else {
          return super.old(prefix);
        }
      }
      /**
       * Do not add non-webkit prefixes for list-style and object
       */
      add(decl, prefix) {
        let p = decl.prop;
        if (p.includes("mask")) {
          if (prefix === "-webkit-" || prefix === "-webkit- old") {
            return super.add(decl, prefix);
          }
        } else if (p === "list-style" || p === "list-style-image" || p === "content") {
          if (prefix === "-webkit-" || prefix === "-webkit- old") {
            return super.add(decl, prefix);
          }
        } else {
          return super.add(decl, prefix);
        }
        return void 0;
      }
    };
    Gradient.names = [
      "linear-gradient",
      "repeating-linear-gradient",
      "radial-gradient",
      "repeating-radial-gradient"
    ];
    Gradient.directions = {
      top: "bottom",
      // default value
      left: "right",
      bottom: "top",
      right: "left"
    };
    Gradient.oldDirections = {
      "top": "left bottom, left top",
      "left": "right top, left top",
      "bottom": "left top, left bottom",
      "right": "left top, right top",
      "top right": "left bottom, right top",
      "top left": "right bottom, left top",
      "right top": "left bottom, right top",
      "right bottom": "left top, right bottom",
      "bottom right": "left top, right bottom",
      "bottom left": "right top, left bottom",
      "left top": "right bottom, left top",
      "left bottom": "right top, left bottom"
    };
    module2.exports = Gradient;
  }
});

// node_modules/autoprefixer/lib/hacks/intrinsic.js
var require_intrinsic = __commonJS({
  "node_modules/autoprefixer/lib/hacks/intrinsic.js"(exports2, module2) {
    var OldValue = require_old_value();
    var Value = require_value();
    function regexp(name) {
      return new RegExp(`(^|[\\s,(])(${name}($|[\\s),]))`, "gi");
    }
    var Intrinsic = class extends Value {
      regexp() {
        if (!this.regexpCache)
          this.regexpCache = regexp(this.name);
        return this.regexpCache;
      }
      isStretch() {
        return this.name === "stretch" || this.name === "fill" || this.name === "fill-available";
      }
      replace(string, prefix) {
        if (prefix === "-moz-" && this.isStretch()) {
          return string.replace(this.regexp(), "$1-moz-available$3");
        }
        if (prefix === "-webkit-" && this.isStretch()) {
          return string.replace(this.regexp(), "$1-webkit-fill-available$3");
        }
        return super.replace(string, prefix);
      }
      old(prefix) {
        let prefixed = prefix + this.name;
        if (this.isStretch()) {
          if (prefix === "-moz-") {
            prefixed = "-moz-available";
          } else if (prefix === "-webkit-") {
            prefixed = "-webkit-fill-available";
          }
        }
        return new OldValue(this.name, prefixed, prefixed, regexp(prefixed));
      }
      add(decl, prefix) {
        if (decl.prop.includes("grid") && prefix !== "-webkit-") {
          return void 0;
        }
        return super.add(decl, prefix);
      }
    };
    Intrinsic.names = [
      "max-content",
      "min-content",
      "fit-content",
      "fill",
      "fill-available",
      "stretch"
    ];
    module2.exports = Intrinsic;
  }
});

// node_modules/autoprefixer/lib/hacks/pixelated.js
var require_pixelated = __commonJS({
  "node_modules/autoprefixer/lib/hacks/pixelated.js"(exports2, module2) {
    var OldValue = require_old_value();
    var Value = require_value();
    var Pixelated = class extends Value {
      /**
       * Use non-standard name for WebKit and Firefox
       */
      replace(string, prefix) {
        if (prefix === "-webkit-") {
          return string.replace(this.regexp(), "$1-webkit-optimize-contrast");
        }
        if (prefix === "-moz-") {
          return string.replace(this.regexp(), "$1-moz-crisp-edges");
        }
        return super.replace(string, prefix);
      }
      /**
       * Different name for WebKit and Firefox
       */
      old(prefix) {
        if (prefix === "-webkit-") {
          return new OldValue(this.name, "-webkit-optimize-contrast");
        }
        if (prefix === "-moz-") {
          return new OldValue(this.name, "-moz-crisp-edges");
        }
        return super.old(prefix);
      }
    };
    Pixelated.names = ["pixelated"];
    module2.exports = Pixelated;
  }
});

// node_modules/autoprefixer/lib/hacks/image-set.js
var require_image_set = __commonJS({
  "node_modules/autoprefixer/lib/hacks/image-set.js"(exports2, module2) {
    var Value = require_value();
    var ImageSet = class extends Value {
      /**
       * Use non-standard name for WebKit and Firefox
       */
      replace(string, prefix) {
        let fixed = super.replace(string, prefix);
        if (prefix === "-webkit-") {
          fixed = fixed.replace(/("[^"]+"|'[^']+')(\s+\d+\w)/gi, "url($1)$2");
        }
        return fixed;
      }
    };
    ImageSet.names = ["image-set"];
    module2.exports = ImageSet;
  }
});

// node_modules/autoprefixer/lib/hacks/cross-fade.js
var require_cross_fade = __commonJS({
  "node_modules/autoprefixer/lib/hacks/cross-fade.js"(exports2, module2) {
    var list = require_postcss().list;
    var Value = require_value();
    var CrossFade = class extends Value {
      replace(string, prefix) {
        return list.space(string).map((value) => {
          if (value.slice(0, +this.name.length + 1) !== this.name + "(") {
            return value;
          }
          let close = value.lastIndexOf(")");
          let after = value.slice(close + 1);
          let args = value.slice(this.name.length + 1, close);
          if (prefix === "-webkit-") {
            let match = args.match(/\d*.?\d+%?/);
            if (match) {
              args = args.slice(match[0].length).trim();
              args += `, ${match[0]}`;
            } else {
              args += ", 0.5";
            }
          }
          return prefix + this.name + "(" + args + ")" + after;
        }).join(" ");
      }
    };
    CrossFade.names = ["cross-fade"];
    module2.exports = CrossFade;
  }
});

// node_modules/autoprefixer/lib/hacks/display-flex.js
var require_display_flex = __commonJS({
  "node_modules/autoprefixer/lib/hacks/display-flex.js"(exports2, module2) {
    var flexSpec = require_flex_spec();
    var OldValue = require_old_value();
    var Value = require_value();
    var DisplayFlex = class extends Value {
      constructor(name, prefixes) {
        super(name, prefixes);
        if (name === "display-flex") {
          this.name = "flex";
        }
      }
      /**
       * Faster check for flex value
       */
      check(decl) {
        return decl.prop === "display" && decl.value === this.name;
      }
      /**
       * Return value by spec
       */
      prefixed(prefix) {
        let spec, value;
        [spec, prefix] = flexSpec(prefix);
        if (spec === 2009) {
          if (this.name === "flex") {
            value = "box";
          } else {
            value = "inline-box";
          }
        } else if (spec === 2012) {
          if (this.name === "flex") {
            value = "flexbox";
          } else {
            value = "inline-flexbox";
          }
        } else if (spec === "final") {
          value = this.name;
        }
        return prefix + value;
      }
      /**
       * Add prefix to value depend on flebox spec version
       */
      replace(string, prefix) {
        return this.prefixed(prefix);
      }
      /**
       * Change value for old specs
       */
      old(prefix) {
        let prefixed = this.prefixed(prefix);
        if (!prefixed)
          return void 0;
        return new OldValue(this.name, prefixed);
      }
    };
    DisplayFlex.names = ["display-flex", "inline-flex"];
    module2.exports = DisplayFlex;
  }
});

// node_modules/autoprefixer/lib/hacks/display-grid.js
var require_display_grid = __commonJS({
  "node_modules/autoprefixer/lib/hacks/display-grid.js"(exports2, module2) {
    var Value = require_value();
    var DisplayGrid = class extends Value {
      constructor(name, prefixes) {
        super(name, prefixes);
        if (name === "display-grid") {
          this.name = "grid";
        }
      }
      /**
       * Faster check for flex value
       */
      check(decl) {
        return decl.prop === "display" && decl.value === this.name;
      }
    };
    DisplayGrid.names = ["display-grid", "inline-grid"];
    module2.exports = DisplayGrid;
  }
});

// node_modules/autoprefixer/lib/hacks/filter-value.js
var require_filter_value = __commonJS({
  "node_modules/autoprefixer/lib/hacks/filter-value.js"(exports2, module2) {
    var Value = require_value();
    var FilterValue = class extends Value {
      constructor(name, prefixes) {
        super(name, prefixes);
        if (name === "filter-function") {
          this.name = "filter";
        }
      }
    };
    FilterValue.names = ["filter", "filter-function"];
    module2.exports = FilterValue;
  }
});

// node_modules/autoprefixer/lib/hacks/autofill.js
var require_autofill = __commonJS({
  "node_modules/autoprefixer/lib/hacks/autofill.js"(exports2, module2) {
    var Selector = require_selector();
    var utils = require_utils();
    var Autofill = class extends Selector {
      constructor(name, prefixes, all) {
        super(name, prefixes, all);
        if (this.prefixes) {
          this.prefixes = utils.uniq(this.prefixes.map(() => "-webkit-"));
        }
      }
      /**
       * Return different selectors depend on prefix
       */
      prefixed(prefix) {
        if (prefix === "-webkit-") {
          return ":-webkit-autofill";
        }
        return `:${prefix}autofill`;
      }
    };
    Autofill.names = [":autofill"];
    module2.exports = Autofill;
  }
});

// node_modules/autoprefixer/lib/prefixes.js
var require_prefixes = __commonJS({
  "node_modules/autoprefixer/lib/prefixes.js"(exports2, module2) {
    var vendor = require_vendor();
    var Declaration = require_declaration2();
    var Resolution = require_resolution();
    var Transition = require_transition();
    var Processor = require_processor2();
    var Supports = require_supports();
    var Browsers = require_browsers3();
    var Selector = require_selector();
    var AtRule = require_at_rule2();
    var Value = require_value();
    var utils = require_utils();
    var hackFullscreen = require_fullscreen();
    var hackPlaceholder = require_placeholder();
    var hackPlaceholderShown = require_placeholder_shown();
    var hackFileSelectorButton = require_file_selector_button();
    var hackFlex = require_flex();
    var hackOrder = require_order();
    var hackFilter = require_filter();
    var hackGridEnd = require_grid_end();
    var hackAnimation = require_animation();
    var hackFlexFlow = require_flex_flow();
    var hackFlexGrow = require_flex_grow();
    var hackFlexWrap = require_flex_wrap();
    var hackGridArea = require_grid_area();
    var hackPlaceSelf = require_place_self();
    var hackGridStart = require_grid_start();
    var hackAlignSelf = require_align_self();
    var hackAppearance = require_appearance();
    var hackFlexBasis = require_flex_basis();
    var hackMaskBorder = require_mask_border();
    var hackMaskComposite = require_mask_composite();
    var hackAlignItems = require_align_items();
    var hackUserSelect = require_user_select();
    var hackFlexShrink = require_flex_shrink();
    var hackBreakProps = require_break_props();
    var hackWritingMode = require_writing_mode();
    var hackBorderImage = require_border_image();
    var hackAlignContent = require_align_content();
    var hackBorderRadius = require_border_radius();
    var hackBlockLogical = require_block_logical();
    var hackGridTemplate = require_grid_template();
    var hackInlineLogical = require_inline_logical();
    var hackGridRowAlign = require_grid_row_align();
    var hackTransformDecl = require_transform_decl();
    var hackFlexDirection = require_flex_direction();
    var hackImageRendering = require_image_rendering();
    var hackBackdropFilter = require_backdrop_filter();
    var hackBackgroundClip = require_background_clip();
    var hackTextDecoration = require_text_decoration();
    var hackJustifyContent = require_justify_content();
    var hackBackgroundSize = require_background_size();
    var hackGridRowColumn = require_grid_row_column();
    var hackGridRowsColumns = require_grid_rows_columns();
    var hackGridColumnAlign = require_grid_column_align();
    var hackPrintColorAdjust = require_print_color_adjust();
    var hackOverscrollBehavior = require_overscroll_behavior();
    var hackGridTemplateAreas = require_grid_template_areas();
    var hackTextEmphasisPosition = require_text_emphasis_position();
    var hackTextDecorationSkipInk = require_text_decoration_skip_ink();
    var hackGradient = require_gradient();
    var hackIntrinsic = require_intrinsic();
    var hackPixelated = require_pixelated();
    var hackImageSet = require_image_set();
    var hackCrossFade = require_cross_fade();
    var hackDisplayFlex = require_display_flex();
    var hackDisplayGrid = require_display_grid();
    var hackFilterValue = require_filter_value();
    var hackAutofill = require_autofill();
    Selector.hack(hackAutofill);
    Selector.hack(hackFullscreen);
    Selector.hack(hackPlaceholder);
    Selector.hack(hackPlaceholderShown);
    Selector.hack(hackFileSelectorButton);
    Declaration.hack(hackFlex);
    Declaration.hack(hackOrder);
    Declaration.hack(hackFilter);
    Declaration.hack(hackGridEnd);
    Declaration.hack(hackAnimation);
    Declaration.hack(hackFlexFlow);
    Declaration.hack(hackFlexGrow);
    Declaration.hack(hackFlexWrap);
    Declaration.hack(hackGridArea);
    Declaration.hack(hackPlaceSelf);
    Declaration.hack(hackGridStart);
    Declaration.hack(hackAlignSelf);
    Declaration.hack(hackAppearance);
    Declaration.hack(hackFlexBasis);
    Declaration.hack(hackMaskBorder);
    Declaration.hack(hackMaskComposite);
    Declaration.hack(hackAlignItems);
    Declaration.hack(hackUserSelect);
    Declaration.hack(hackFlexShrink);
    Declaration.hack(hackBreakProps);
    Declaration.hack(hackWritingMode);
    Declaration.hack(hackBorderImage);
    Declaration.hack(hackAlignContent);
    Declaration.hack(hackBorderRadius);
    Declaration.hack(hackBlockLogical);
    Declaration.hack(hackGridTemplate);
    Declaration.hack(hackInlineLogical);
    Declaration.hack(hackGridRowAlign);
    Declaration.hack(hackTransformDecl);
    Declaration.hack(hackFlexDirection);
    Declaration.hack(hackImageRendering);
    Declaration.hack(hackBackdropFilter);
    Declaration.hack(hackBackgroundClip);
    Declaration.hack(hackTextDecoration);
    Declaration.hack(hackJustifyContent);
    Declaration.hack(hackBackgroundSize);
    Declaration.hack(hackGridRowColumn);
    Declaration.hack(hackGridRowsColumns);
    Declaration.hack(hackGridColumnAlign);
    Declaration.hack(hackOverscrollBehavior);
    Declaration.hack(hackGridTemplateAreas);
    Declaration.hack(hackPrintColorAdjust);
    Declaration.hack(hackTextEmphasisPosition);
    Declaration.hack(hackTextDecorationSkipInk);
    Value.hack(hackGradient);
    Value.hack(hackIntrinsic);
    Value.hack(hackPixelated);
    Value.hack(hackImageSet);
    Value.hack(hackCrossFade);
    Value.hack(hackDisplayFlex);
    Value.hack(hackDisplayGrid);
    Value.hack(hackFilterValue);
    var declsCache = /* @__PURE__ */ new Map();
    var Prefixes = class _Prefixes {
      constructor(data, browsers, options = {}) {
        this.data = data;
        this.browsers = browsers;
        this.options = options;
        [this.add, this.remove] = this.preprocess(this.select(this.data));
        this.transition = new Transition(this);
        this.processor = new Processor(this);
      }
      /**
       * Return clone instance to remove all prefixes
       */
      cleaner() {
        if (this.cleanerCache) {
          return this.cleanerCache;
        }
        if (this.browsers.selected.length) {
          let empty = new Browsers(this.browsers.data, []);
          this.cleanerCache = new _Prefixes(this.data, empty, this.options);
        } else {
          return this;
        }
        return this.cleanerCache;
      }
      /**
       * Select prefixes from data, which is necessary for selected browsers
       */
      select(list) {
        let selected = { add: {}, remove: {} };
        for (let name in list) {
          let data = list[name];
          let add = data.browsers.map((i) => {
            let params = i.split(" ");
            return {
              browser: `${params[0]} ${params[1]}`,
              note: params[2]
            };
          });
          let notes = add.filter((i) => i.note).map((i) => `${this.browsers.prefix(i.browser)} ${i.note}`);
          notes = utils.uniq(notes);
          add = add.filter((i) => this.browsers.isSelected(i.browser)).map((i) => {
            let prefix = this.browsers.prefix(i.browser);
            if (i.note) {
              return `${prefix} ${i.note}`;
            } else {
              return prefix;
            }
          });
          add = this.sort(utils.uniq(add));
          if (this.options.flexbox === "no-2009") {
            add = add.filter((i) => !i.includes("2009"));
          }
          let all = data.browsers.map((i) => this.browsers.prefix(i));
          if (data.mistakes) {
            all = all.concat(data.mistakes);
          }
          all = all.concat(notes);
          all = utils.uniq(all);
          if (add.length) {
            selected.add[name] = add;
            if (add.length < all.length) {
              selected.remove[name] = all.filter((i) => !add.includes(i));
            }
          } else {
            selected.remove[name] = all;
          }
        }
        return selected;
      }
      /**
       * Sort vendor prefixes
       */
      sort(prefixes) {
        return prefixes.sort((a, b) => {
          let aLength = utils.removeNote(a).length;
          let bLength = utils.removeNote(b).length;
          if (aLength === bLength) {
            return b.length - a.length;
          } else {
            return bLength - aLength;
          }
        });
      }
      /**
       * Cache prefixes data to fast CSS processing
       */
      preprocess(selected) {
        let add = {
          "selectors": [],
          "@supports": new Supports(_Prefixes, this)
        };
        for (let name in selected.add) {
          let prefixes = selected.add[name];
          if (name === "@keyframes" || name === "@viewport") {
            add[name] = new AtRule(name, prefixes, this);
          } else if (name === "@resolution") {
            add[name] = new Resolution(name, prefixes, this);
          } else if (this.data[name].selector) {
            add.selectors.push(Selector.load(name, prefixes, this));
          } else {
            let props = this.data[name].props;
            if (props) {
              let value = Value.load(name, prefixes, this);
              for (let prop of props) {
                if (!add[prop]) {
                  add[prop] = { values: [] };
                }
                add[prop].values.push(value);
              }
            } else {
              let values = add[name] && add[name].values || [];
              add[name] = Declaration.load(name, prefixes, this);
              add[name].values = values;
            }
          }
        }
        let remove = { selectors: [] };
        for (let name in selected.remove) {
          let prefixes = selected.remove[name];
          if (this.data[name].selector) {
            let selector = Selector.load(name, prefixes);
            for (let prefix of prefixes) {
              remove.selectors.push(selector.old(prefix));
            }
          } else if (name === "@keyframes" || name === "@viewport") {
            for (let prefix of prefixes) {
              let prefixed = `@${prefix}${name.slice(1)}`;
              remove[prefixed] = { remove: true };
            }
          } else if (name === "@resolution") {
            remove[name] = new Resolution(name, prefixes, this);
          } else {
            let props = this.data[name].props;
            if (props) {
              let value = Value.load(name, [], this);
              for (let prefix of prefixes) {
                let old = value.old(prefix);
                if (old) {
                  for (let prop of props) {
                    if (!remove[prop]) {
                      remove[prop] = {};
                    }
                    if (!remove[prop].values) {
                      remove[prop].values = [];
                    }
                    remove[prop].values.push(old);
                  }
                }
              }
            } else {
              for (let p of prefixes) {
                let olds = this.decl(name).old(name, p);
                if (name === "align-self") {
                  let a = add[name] && add[name].prefixes;
                  if (a) {
                    if (p === "-webkit- 2009" && a.includes("-webkit-")) {
                      continue;
                    } else if (p === "-webkit-" && a.includes("-webkit- 2009")) {
                      continue;
                    }
                  }
                }
                for (let prefixed of olds) {
                  if (!remove[prefixed]) {
                    remove[prefixed] = {};
                  }
                  remove[prefixed].remove = true;
                }
              }
            }
          }
        }
        return [add, remove];
      }
      /**
       * Declaration loader with caching
       */
      decl(prop) {
        if (!declsCache.has(prop)) {
          declsCache.set(prop, Declaration.load(prop));
        }
        return declsCache.get(prop);
      }
      /**
       * Return unprefixed version of property
       */
      unprefixed(prop) {
        let value = this.normalize(vendor.unprefixed(prop));
        if (value === "flex-direction") {
          value = "flex-flow";
        }
        return value;
      }
      /**
       * Normalize prefix for remover
       */
      normalize(prop) {
        return this.decl(prop).normalize(prop);
      }
      /**
       * Return prefixed version of property
       */
      prefixed(prop, prefix) {
        prop = vendor.unprefixed(prop);
        return this.decl(prop).prefixed(prop, prefix);
      }
      /**
       * Return values, which must be prefixed in selected property
       */
      values(type, prop) {
        let data = this[type];
        let global2 = data["*"] && data["*"].values;
        let values = data[prop] && data[prop].values;
        if (global2 && values) {
          return utils.uniq(global2.concat(values));
        } else {
          return global2 || values || [];
        }
      }
      /**
       * Group declaration by unprefixed property to check them
       */
      group(decl) {
        let rule = decl.parent;
        let index = rule.index(decl);
        let { length } = rule.nodes;
        let unprefixed = this.unprefixed(decl.prop);
        let checker = (step, callback) => {
          index += step;
          while (index >= 0 && index < length) {
            let other = rule.nodes[index];
            if (other.type === "decl") {
              if (step === -1 && other.prop === unprefixed) {
                if (!Browsers.withPrefix(other.value)) {
                  break;
                }
              }
              if (this.unprefixed(other.prop) !== unprefixed) {
                break;
              } else if (callback(other) === true) {
                return true;
              }
              if (step === 1 && other.prop === unprefixed) {
                if (!Browsers.withPrefix(other.value)) {
                  break;
                }
              }
            }
            index += step;
          }
          return false;
        };
        return {
          up(callback) {
            return checker(-1, callback);
          },
          down(callback) {
            return checker(1, callback);
          }
        };
      }
    };
    module2.exports = Prefixes;
  }
});

// node_modules/caniuse-lite/data/features/border-radius.js
var require_border_radius2 = __commonJS({
  "node_modules/caniuse-lite/data/features/border-radius.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "F A B", "2": "K D E YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "257": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB", "289": "BC bC cC", "292": "ZC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "33": "J" }, E: { "1": "DB D E F A B C L M G gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "33": "J dC HC", "129": "K eC fC" }, F: { "1": "B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t qC rC 6B WC sC 7B", "2": "F oC pC" }, G: { "1": "E tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "33": "HC" }, H: { "2": "FD" }, I: { "1": "BC J I HD ID JD XC KD LD", "33": "GD" }, J: { "1": "D A" }, K: { "1": "B C H 6B WC 7B", "2": "A" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "257": "aD" } }, B: 4, C: "CSS3 Border-radius (rounded corners)", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-boxshadow.js
var require_css_boxshadow = __commonJS({
  "node_modules/caniuse-lite/data/features/css-boxshadow.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "F A B", "2": "K D E YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC", "33": "bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "33": "J DB K D E F" }, E: { "1": "K D E F A B C L M G eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "33": "DB", "164": "J dC HC" }, F: { "1": "B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t qC rC 6B WC sC 7B", "2": "F oC pC" }, G: { "1": "E uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "33": "tC XC", "164": "HC" }, H: { "2": "FD" }, I: { "1": "J I JD XC KD LD", "164": "BC GD HD ID" }, J: { "1": "A", "33": "D" }, K: { "1": "B C H 6B WC 7B", "2": "A" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "CSS3 Box-shadow", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-animation.js
var require_css_animation = __commonJS({
  "node_modules/caniuse-lite/data/features/css-animation.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "A B", "2": "K D E F YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J bC cC", "33": "DB K D E F A B C L M G" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "33": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB" }, E: { "1": "F A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "dC HC", "33": "K D E eC fC gC", "292": "J DB" }, F: { "1": "KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t 7B", "2": "F B oC pC qC rC 6B WC sC", "33": "C G N O P EB u v w x y FB GB HB IB JB" }, G: { "1": "yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "33": "E vC wC xC", "164": "HC tC XC uC" }, H: { "2": "FD" }, I: { "1": "I", "33": "J JD XC KD LD", "164": "BC GD HD ID" }, J: { "33": "D A" }, K: { "1": "H 7B", "2": "A B C 6B WC" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 5, C: "CSS Animation", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-transitions.js
var require_css_transitions = __commonJS({
  "node_modules/caniuse-lite/data/features/css-transitions.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "A B", "2": "K D E F YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC bC cC", "33": "DB K D E F A B C L M G", "164": "J" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "33": "J DB K D E F A B C L M G N O P EB u v w x y FB" }, E: { "1": "D E F A B C L M G fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "33": "K eC", "164": "J DB dC HC" }, F: { "1": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t 7B", "2": "F oC pC", "33": "C", "164": "B qC rC 6B WC sC" }, G: { "1": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "33": "vC", "164": "HC tC XC uC" }, H: { "2": "FD" }, I: { "1": "I KD LD", "33": "BC J GD HD ID JD XC" }, J: { "1": "A", "33": "D" }, K: { "1": "H 7B", "33": "C", "164": "A B 6B WC" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 5, C: "CSS3 Transitions", D: true };
  }
});

// node_modules/caniuse-lite/data/features/transforms2d.js
var require_transforms2d = __commonJS({
  "node_modules/caniuse-lite/data/features/transforms2d.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "YC", "8": "K D E", "129": "A B", "161": "F" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "129": "C L M G N" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC", "33": "J DB K D E F A B C L M G bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "33": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB" }, E: { "1": "F A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "33": "J DB K D E dC HC eC fC gC" }, F: { "1": "x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t 7B", "2": "F oC pC", "33": "B C G N O P EB u v w qC rC 6B WC sC" }, G: { "1": "yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "33": "E HC tC XC uC vC wC xC" }, H: { "2": "FD" }, I: { "1": "I", "33": "BC J GD HD ID JD XC KD LD" }, J: { "33": "D A" }, K: { "1": "B C H 6B WC 7B", "2": "A" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "CSS3 2D Transforms", D: true };
  }
});

// node_modules/caniuse-lite/data/features/transforms3d.js
var require_transforms3d = __commonJS({
  "node_modules/caniuse-lite/data/features/transforms3d.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F YC", "132": "A B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F bC cC", "33": "A B C L M G" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B", "33": "C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB" }, E: { "1": "KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "dC HC", "33": "J DB K D E eC fC gC", "257": "F A B C L M G hC IC 6B 7B iC jC kC JC" }, F: { "1": "x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "33": "G N O P EB u v w" }, G: { "1": "KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "33": "E HC tC XC uC vC wC xC", "257": "yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC" }, H: { "2": "FD" }, I: { "1": "I", "2": "GD HD ID", "33": "BC J JD XC KD LD" }, J: { "33": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "132": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 5, C: "CSS3 3D Transforms", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-gradients.js
var require_css_gradients = __commonJS({
  "node_modules/caniuse-lite/data/features/css-gradients.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "A B", "2": "K D E F YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC bC", "260": "N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB", "292": "J DB K D E F A B C L M G cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "33": "A B C L M G N O P EB u v w x y FB", "548": "J DB K D E F" }, E: { "1": "KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "dC HC", "260": "D E F A B C L M G fC gC hC IC 6B 7B iC jC kC JC", "292": "K eC", "804": "J DB" }, F: { "1": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t 7B", "2": "F B oC pC qC rC", "33": "C sC", "164": "6B WC" }, G: { "1": "KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "260": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC", "292": "uC vC", "804": "HC tC XC" }, H: { "2": "FD" }, I: { "1": "I KD LD", "33": "J JD XC", "548": "BC GD HD ID" }, J: { "1": "A", "548": "D" }, K: { "1": "H 7B", "2": "A B", "33": "C", "164": "6B WC" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "CSS Gradients", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css3-boxsizing.js
var require_css3_boxsizing = __commonJS({
  "node_modules/caniuse-lite/data/features/css3-boxsizing.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "E F A B", "8": "K D YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "33": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "33": "J DB K D E F" }, E: { "1": "K D E F A B C L M G eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "33": "J DB dC HC" }, F: { "1": "B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t oC pC qC rC 6B WC sC 7B", "2": "F" }, G: { "1": "E uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "33": "HC tC XC" }, H: { "1": "FD" }, I: { "1": "J I JD XC KD LD", "33": "BC GD HD ID" }, J: { "1": "A", "33": "D" }, K: { "1": "A B C H 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 5, C: "CSS3 Box-sizing", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-filters.js
var require_css_filters = __commonJS({
  "node_modules/caniuse-lite/data/features/css-filters.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "1028": "L M G N O P", "1346": "C" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC bC", "196": "OB", "516": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O", "33": "P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB" }, E: { "1": "A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB dC HC eC", "33": "K D E F fC gC" }, F: { "1": "UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "33": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB" }, G: { "1": "zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC", "33": "E vC wC xC yC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC", "33": "KD LD" }, J: { "2": "D", "33": "A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y OD PD QD IC RD SD TD UD VD 9B AC WD XD", "33": "J MD ND" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 5, C: "CSS Filter Effects", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-filter-function.js
var require_css_filter_function = __commonJS({
  "node_modules/caniuse-lite/data/features/css-filter-function.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "2": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "2": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "2": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E dC HC eC fC gC", "33": "F" }, F: { "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t oC pC qC rC 6B WC sC 7B" }, G: { "1": "0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC", "33": "yC zC" }, H: { "2": "FD" }, I: { "2": "BC J I GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "2": "A B C H 6B WC 7B" }, L: { "2": "I" }, M: { "2": "5B" }, N: { "2": "A B" }, O: { "2": "8B" }, P: { "2": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "2": "YD" }, R: { "2": "ZD" }, S: { "2": "aD bD" } }, B: 5, C: "CSS filter() function", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-backdrop-filter.js
var require_css_backdrop_filter = __commonJS({
  "node_modules/caniuse-lite/data/features/css-backdrop-filter.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N", "257": "O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB bC cC", "578": "wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB", "194": "bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B" }, E: { "2": "J DB K D E dC HC eC fC gC", "33": "F A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB oC pC qC rC 6B WC sC 7B", "194": "OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB" }, G: { "2": "E HC tC XC uC vC wC xC", "33": "yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y SD TD UD VD 9B AC WD XD", "2": "J", "194": "MD ND OD PD QD IC RD" }, Q: { "2": "YD" }, R: { "1": "ZD" }, S: { "2": "aD bD" } }, B: 7, C: "CSS Backdrop Filter", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-element-function.js
var require_css_element_function = __commonJS({
  "node_modules/caniuse-lite/data/features/css-element-function.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "2": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "33": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "164": "ZC BC bC cC" }, D: { "2": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t oC pC qC rC 6B WC sC 7B" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "2": "BC J I GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "2": "A B C H 6B WC 7B" }, L: { "2": "I" }, M: { "33": "5B" }, N: { "2": "A B" }, O: { "2": "8B" }, P: { "2": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "2": "YD" }, R: { "2": "ZD" }, S: { "33": "aD bD" } }, B: 5, C: "CSS element() function", D: true };
  }
});

// node_modules/caniuse-lite/data/features/multicolumn.js
var require_multicolumn = __commonJS({
  "node_modules/caniuse-lite/data/features/multicolumn.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "A B", "2": "K D E F YC" }, B: { "1": "C L M G N O P", "516": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "132": "gB hB iB jB kB lB mB CC nB DC oB pB qB", "164": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB bC cC", "516": "rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a", "1028": "0 1 2 3 4 5 6 7 8 9 b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC" }, D: { "420": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB", "516": "0 1 2 3 4 5 6 7 8 9 eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "A B C L M G IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "132": "F hC", "164": "D E gC", "420": "J DB K dC HC eC fC" }, F: { "1": "C 6B WC sC 7B", "2": "F B oC pC qC rC", "420": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB", "516": "RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t" }, G: { "1": "0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "132": "yC zC", "164": "E wC xC", "420": "HC tC XC uC vC" }, H: { "1": "FD" }, I: { "420": "BC J GD HD ID JD XC KD LD", "516": "I" }, J: { "420": "D A" }, K: { "1": "C 6B WC 7B", "2": "A B", "516": "H" }, L: { "516": "I" }, M: { "1028": "5B" }, N: { "1": "A B" }, O: { "516": "8B" }, P: { "420": "J", "516": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "516": "YD" }, R: { "516": "ZD" }, S: { "164": "aD bD" } }, B: 4, C: "CSS3 Multiple column layout", D: true };
  }
});

// node_modules/caniuse-lite/data/features/user-select-none.js
var require_user_select_none = __commonJS({
  "node_modules/caniuse-lite/data/features/user-select-none.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F YC", "33": "A B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "33": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "33": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "33": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB" }, E: { "1": "nC", "33": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC" }, F: { "1": "VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "33": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB" }, G: { "33": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I", "33": "BC J GD HD ID JD XC KD LD" }, J: { "33": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "33": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "33": "J MD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "33": "aD" } }, B: 5, C: "CSS user-select: none", D: true };
  }
});

// node_modules/caniuse-lite/data/features/flexbox.js
var require_flexbox = __commonJS({
  "node_modules/caniuse-lite/data/features/flexbox.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F YC", "1028": "B", "1316": "A" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "164": "ZC BC J DB K D E F A B C L M G N O P EB u v bC cC", "516": "w x y FB GB HB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "33": "v w x y FB GB HB IB", "164": "J DB K D E F A B C L M G N O P EB u" }, E: { "1": "F A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "33": "D E fC gC", "164": "J DB K dC HC eC" }, F: { "1": "O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t 7B", "2": "F B C oC pC qC rC 6B WC sC", "33": "G N" }, G: { "1": "yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "33": "E wC xC", "164": "HC tC XC uC vC" }, H: { "1": "FD" }, I: { "1": "I KD LD", "164": "BC J GD HD ID JD XC" }, J: { "1": "A", "164": "D" }, K: { "1": "H 7B", "2": "A B C 6B WC" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "B", "292": "A" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "CSS Flexible Box Layout Module", D: true };
  }
});

// node_modules/caniuse-lite/data/features/calc.js
var require_calc = __commonJS({
  "node_modules/caniuse-lite/data/features/calc.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E YC", "260": "F", "516": "A B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC bC cC", "33": "J DB K D E F A B C L M G" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P", "33": "EB u v w x y FB" }, E: { "1": "D E F A B C L M G fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB dC HC eC", "33": "K" }, F: { "1": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B" }, G: { "1": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC", "33": "vC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC", "132": "KD LD" }, J: { "1": "A", "2": "D" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "calc() as CSS unit value", D: true };
  }
});

// node_modules/caniuse-lite/data/features/background-img-opts.js
var require_background_img_opts = __commonJS({
  "node_modules/caniuse-lite/data/features/background-img-opts.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "F A B", "2": "K D E YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC bC", "36": "cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "516": "J DB K D E F A B C L M" }, E: { "1": "D E F A B C L M G gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "772": "J DB K dC HC eC fC" }, F: { "1": "B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t qC rC 6B WC sC 7B", "2": "F oC", "36": "pC" }, G: { "1": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "4": "HC tC XC vC", "516": "uC" }, H: { "132": "FD" }, I: { "1": "I KD LD", "36": "GD", "516": "BC J JD XC", "548": "HD ID" }, J: { "1": "D A" }, K: { "1": "A B C H 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "CSS3 Background-image options", D: true };
  }
});

// node_modules/caniuse-lite/data/features/background-clip-text.js
var require_background_clip_text = __commonJS({
  "node_modules/caniuse-lite/data/features/background-clip-text.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "G N O P", "33": "C L M", "132": "8 9 AB BB CB I", "164": "0 1 2 3 4 5 6 7 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB bC cC" }, D: { "132": "8 9 AB BB CB I 5B FC GC", "164": "0 1 2 3 4 5 6 7 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z" }, E: { "16": "dC HC", "132": "8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "388": "M G jC kC JC KC", "420": "J DB K D E F A B C L eC fC gC hC IC 6B 7B iC" }, F: { "2": "F B C oC pC qC rC 6B WC sC 7B", "132": "p q r s t", "164": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o" }, G: { "16": "HC tC XC uC", "132": "8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "388": "AD BD CD JC KC", "420": "E vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C" }, H: { "2": "FD" }, I: { "16": "BC GD HD ID", "132": "I", "164": "J JD XC KD LD" }, J: { "164": "D A" }, K: { "16": "A B C 6B WC 7B", "132": "H" }, L: { "132": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "164": "8B" }, P: { "164": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "164": "YD" }, R: { "164": "ZD" }, S: { "1": "aD bD" } }, B: 7, C: "Background-clip: text", D: true };
  }
});

// node_modules/caniuse-lite/data/features/font-feature.js
var require_font_feature = __commonJS({
  "node_modules/caniuse-lite/data/features/font-feature.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "A B", "2": "K D E F YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC bC cC", "33": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB", "164": "J DB K D E F A B C L M" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G", "33": "v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB", "292": "N O P EB u" }, E: { "1": "A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "D E F dC HC fC gC", "4": "J DB K eC" }, F: { "1": "PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "33": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB" }, G: { "1": "zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E wC xC yC", "4": "HC tC XC uC vC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC", "33": "KD LD" }, J: { "2": "D", "33": "A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "33": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 2, C: "CSS font-feature-settings", D: true };
  }
});

// node_modules/caniuse-lite/data/features/font-kerning.js
var require_font_kerning = __commonJS({
  "node_modules/caniuse-lite/data/features/font-kerning.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x bC cC", "194": "y FB GB HB IB JB KB LB MB NB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB", "33": "JB KB LB MB" }, E: { "1": "A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K dC HC eC fC", "33": "D E F gC" }, F: { "1": "u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G oC pC qC rC 6B WC sC 7B", "33": "N O P EB" }, G: { "1": "4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC wC", "33": "E xC yC zC 0C 1C 2C 3C" }, H: { "2": "FD" }, I: { "1": "I LD", "2": "BC J GD HD ID JD XC", "33": "KD" }, J: { "2": "D", "33": "A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "CSS3 font-kerning", D: true };
  }
});

// node_modules/caniuse-lite/data/features/border-image.js
var require_border_image2 = __commonJS({
  "node_modules/caniuse-lite/data/features/border-image.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "B", "2": "K D E F A YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "129": "C L" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC", "260": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB", "804": "J DB K D E F A B C L M bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "260": "fB gB hB iB jB", "388": "KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB", "1412": "G N O P EB u v w x y FB GB HB IB JB", "1956": "J DB K D E F A B C L M" }, E: { "1": "KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "129": "A B C L M G hC IC 6B 7B iC jC kC JC", "1412": "K D E F fC gC", "1956": "J DB dC HC eC" }, F: { "1": "XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F oC pC", "260": "SB TB UB VB WB", "388": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB", "1796": "qC rC", "1828": "B C 6B WC sC 7B" }, G: { "1": "KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "129": "zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC", "1412": "E vC wC xC yC", "1956": "HC tC XC uC" }, H: { "1828": "FD" }, I: { "1": "I", "388": "KD LD", "1956": "BC J GD HD ID JD XC" }, J: { "1412": "A", "1924": "D" }, K: { "1": "H", "2": "A", "1828": "B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "B", "2": "A" }, O: { "1": "8B" }, P: { "1": "u v w x y OD PD QD IC RD SD TD UD VD 9B AC WD XD", "260": "MD ND", "388": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "260": "aD" } }, B: 4, C: "CSS3 Border images", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-selection.js
var require_css_selection = __commonJS({
  "node_modules/caniuse-lite/data/features/css-selection.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "F A B", "2": "K D E YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "33": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t oC pC qC rC 6B WC sC 7B", "2": "F" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I KD LD", "2": "BC J GD HD ID JD XC" }, J: { "1": "A", "2": "D" }, K: { "1": "C H WC 7B", "16": "A B 6B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "33": "aD" } }, B: 5, C: "::selection CSS pseudo-element", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-placeholder.js
var require_css_placeholder = __commonJS({
  "node_modules/caniuse-lite/data/features/css-placeholder.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "36": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "33": "EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB", "130": "ZC BC J DB K D E F A B C L M G N O P bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "36": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB" }, E: { "1": "B C L M G IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J dC HC", "36": "DB K D E F A eC fC gC hC" }, F: { "1": "YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "36": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB" }, G: { "1": "1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC", "36": "E XC uC vC wC xC yC zC 0C" }, H: { "2": "FD" }, I: { "1": "I", "36": "BC J GD HD ID JD XC KD LD" }, J: { "36": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "36": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y OD PD QD IC RD SD TD UD VD 9B AC WD XD", "36": "J MD ND" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "33": "aD" } }, B: 5, C: "::placeholder CSS pseudo-element", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-placeholder-shown.js
var require_css_placeholder_shown = __commonJS({
  "node_modules/caniuse-lite/data/features/css-placeholder-shown.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F YC", "292": "A B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC bC cC", "164": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB" }, E: { "1": "F A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E dC HC eC fC gC" }, F: { "1": "OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB oC pC qC rC 6B WC sC 7B" }, G: { "1": "yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "164": "aD" } }, B: 5, C: ":placeholder-shown CSS pseudo-class", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-hyphens.js
var require_css_hyphens = __commonJS({
  "node_modules/caniuse-lite/data/features/css-hyphens.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F YC", "33": "A B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 o p q r s t z AB BB CB I", "33": "C L M G N O P", "132": "Q H R S T U V W", "260": "X Y Z a b c d e f g h i j k l m n" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB bC cC", "33": "K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB", "132": "jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W" }, E: { "1": "AC QC RC SC TC UC VC nC", "2": "J DB dC HC", "33": "K D E F A B C L M G eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC" }, F: { "1": "a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB oC pC qC rC 6B WC sC 7B", "132": "WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z" }, G: { "1": "AC QC RC SC TC UC VC", "2": "HC tC", "33": "E XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J", "132": "MD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "CSS Hyphenation", D: true };
  }
});

// node_modules/caniuse-lite/data/features/fullscreen.js
var require_fullscreen2 = __commonJS({
  "node_modules/caniuse-lite/data/features/fullscreen.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A YC", "548": "B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "516": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F bC cC", "676": "A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB", "1700": "bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M", "676": "G N O P EB", "804": "u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB" }, E: { "1": "OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB dC HC", "548": "KC 8B lC 9B LC MC NC", "676": "eC", "804": "K D E F A B C L M G fC gC hC IC 6B 7B iC jC kC JC" }, F: { "1": "qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t 7B", "2": "F B C oC pC qC rC 6B WC sC", "804": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C", "2052": "4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "2": "BC J I GD HD ID JD XC KD LD" }, J: { "2": "D", "292": "A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A", "548": "B" }, O: { "1": "8B" }, P: { "1": "u v w x y IC RD SD TD UD VD 9B AC WD XD", "804": "J MD ND OD PD QD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "Fullscreen API", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-file-selector-button.js
var require_css_file_selector_button = __commonJS({
  "node_modules/caniuse-lite/data/features/css-file-selector-button.js"(exports2, module2) {
    module2.exports = { A: { D: { "1": "0 1 2 3 4 5 6 7 8 9 Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "33": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X" }, L: { "1": "I" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "33": "C L M G N O P Q H R S T U V W X" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R bC cC" }, M: { "1": "5B" }, A: { "2": "K D E F YC", "33": "A B" }, F: { "1": "1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "33": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, E: { "1": "G jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC", "2": "nC", "33": "J DB K D E F A B C L M dC HC eC fC gC hC IC 6B 7B iC" }, G: { "1": "BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "33": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD" }, P: { "1": "u v w x y VD 9B AC WD XD", "33": "J MD ND OD PD QD IC RD SD TD UD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC", "33": "KD LD" } }, B: 6, C: "::file-selector-button CSS pseudo-element", D: void 0 };
  }
});

// node_modules/caniuse-lite/data/features/css-autofill.js
var require_css_autofill = __commonJS({
  "node_modules/caniuse-lite/data/features/css-autofill.js"(exports2, module2) {
    module2.exports = { A: { D: { "1": "0 1 2 3 4 5 6 7 8 9 t z AB BB CB I 5B FC GC", "33": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s" }, L: { "1": "I" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 t z AB BB CB I", "2": "C L M G N O P", "33": "Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U bC cC" }, M: { "1": "5B" }, A: { "2": "K D E F A B YC" }, F: { "1": "f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "33": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, E: { "1": "G kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC", "2": "nC", "33": "J DB K D E F A B C L M dC HC eC fC gC hC IC 6B 7B iC jC" }, G: { "1": "CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "33": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD" }, P: { "1": "v w x y", "33": "J u MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC", "33": "KD LD" } }, B: 6, C: ":autofill CSS pseudo-class", D: void 0 };
  }
});

// node_modules/caniuse-lite/data/features/css3-tabsize.js
var require_css3_tabsize = __commonJS({
  "node_modules/caniuse-lite/data/features/css3-tabsize.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC bC cC", "33": "hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z", "164": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u", "132": "v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB" }, E: { "1": "M G iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K dC HC eC", "132": "D E F A B C L fC gC hC IC 6B 7B" }, F: { "1": "JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F oC pC qC", "132": "G N O P EB u v w x y FB GB HB IB", "164": "B C rC 6B WC sC 7B" }, G: { "1": "9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC", "132": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C" }, H: { "164": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC", "132": "KD LD" }, J: { "132": "D A" }, K: { "1": "H", "2": "A", "164": "B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "164": "aD bD" } }, B: 4, C: "CSS3 tab-size", D: true };
  }
});

// node_modules/caniuse-lite/data/features/intrinsic-width.js
var require_intrinsic_width = __commonJS({
  "node_modules/caniuse-lite/data/features/intrinsic-width.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "2": "C L M G N O P", "1025": "0 1 2 3 4 5 6 7 8 9 d e f g h i j k l m n o p q r s t z AB BB CB I", "1537": "Q H R S T U V W X Y Z a b c" }, C: { "2": "ZC", "932": "BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB bC cC", "2308": "0 1 2 3 4 5 6 7 8 9 sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC" }, D: { "2": "J DB K D E F A B C L M G N O P EB u v", "545": "w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB", "1025": "0 1 2 3 4 5 6 7 8 9 d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "1537": "aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c" }, E: { "1": "9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K dC HC eC", "516": "B C L M G 6B 7B iC jC kC JC KC 8B lC", "548": "F A hC IC", "676": "D E fC gC" }, F: { "2": "F B C oC pC qC rC 6B WC sC 7B", "513": "OB", "545": "G N O P EB u v w x y FB GB HB IB JB KB LB MB", "1025": "e f g h i j k l m n o p q r s t", "1537": "NB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d" }, G: { "1": "9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC", "516": "AD BD CD JC KC 8B DD", "548": "yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C", "676": "E wC xC" }, H: { "2": "FD" }, I: { "2": "BC J GD HD ID JD XC", "545": "KD LD", "1025": "I" }, J: { "2": "D", "545": "A" }, K: { "2": "A B C 6B WC 7B", "1025": "H" }, L: { "1025": "I" }, M: { "2308": "5B" }, N: { "2": "A B" }, O: { "1537": "8B" }, P: { "545": "J", "1025": "u v w x y AC WD XD", "1537": "MD ND OD PD QD IC RD SD TD UD VD 9B" }, Q: { "1537": "YD" }, R: { "1537": "ZD" }, S: { "932": "aD", "2308": "bD" } }, B: 5, C: "Intrinsic & Extrinsic Sizing", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-width-stretch.js
var require_css_width_stretch = __commonJS({
  "node_modules/caniuse-lite/data/features/css-width-stretch.js"(exports2, module2) {
    module2.exports = { A: { D: { "2": "J DB K D E F A B C L M G N O P EB u v", "33": "0 1 2 3 4 5 6 7 8 9 w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, L: { "33": "I" }, B: { "2": "C L M G N O P", "33": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "2": "ZC", "33": "0 1 2 3 4 5 6 7 8 9 BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, M: { "33": "5B" }, A: { "2": "K D E F A B YC" }, F: { "2": "F B C oC pC qC rC 6B WC sC 7B", "33": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t" }, K: { "2": "A B C 6B WC 7B", "33": "H" }, E: { "2": "J DB K dC HC eC fC nC", "33": "D E F A B C L M G gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC" }, G: { "2": "HC tC XC uC vC", "33": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, P: { "2": "J", "33": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, I: { "2": "BC J GD HD ID JD XC", "33": "I KD LD" } }, B: 6, C: "width: stretch property", D: void 0 };
  }
});

// node_modules/caniuse-lite/data/features/css3-cursors-newer.js
var require_css3_cursors_newer = __commonJS({
  "node_modules/caniuse-lite/data/features/css3-cursors-newer.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "33": "ZC BC J DB K D E F A B C L M G N O P EB u v w x bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "33": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB" }, E: { "1": "F A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "33": "J DB K D E dC HC eC fC gC" }, F: { "1": "C y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t sC 7B", "2": "F B oC pC qC rC 6B WC", "33": "G N O P EB u v w x" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "33": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "2": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "2": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "2": "aD bD" } }, B: 2, C: "CSS3 Cursors: zoom-in & zoom-out", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css3-cursors-grab.js
var require_css3_cursors_grab = __commonJS({
  "node_modules/caniuse-lite/data/features/css3-cursors-grab.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "33": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "33": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB" }, E: { "1": "B C L M G 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "33": "J DB K D E F A dC HC eC fC gC hC IC" }, F: { "1": "C jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t sC 7B", "2": "F B oC pC qC rC 6B WC", "33": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "33": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "2": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "2": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "2": "aD bD" } }, B: 2, C: "CSS grab & grabbing cursors", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-sticky.js
var require_css_sticky = __commonJS({
  "node_modules/caniuse-lite/data/features/css-sticky.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G", "1028": "Q H R S T U V W X Y Z", "4100": "N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB bC cC", "194": "GB HB IB JB KB LB", "516": "MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB", "322": "x y FB GB HB IB JB KB LB MB NB OB PB QB gB hB iB jB", "1028": "kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z" }, E: { "1": "L M G iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K dC HC eC", "33": "E F A B C gC hC IC 6B 7B", "2084": "D fC" }, F: { "1": "4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB oC pC qC rC 6B WC sC 7B", "322": "TB UB VB", "1028": "WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B" }, G: { "1": "6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC", "33": "E xC yC zC 0C 1C 2C 3C 4C 5C", "2084": "vC wC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J MD" }, Q: { "1028": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "516": "aD" } }, B: 5, C: "CSS position:sticky", D: true };
  }
});

// node_modules/caniuse-lite/data/features/pointer.js
var require_pointer = __commonJS({
  "node_modules/caniuse-lite/data/features/pointer.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "B", "2": "K D E F YC", "164": "A" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB bC cC", "8": "K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB", "328": "VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v", "8": "w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB", "584": "gB hB iB" }, E: { "1": "L M G iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K dC HC eC", "8": "D E F A B C fC gC hC IC 6B", "1096": "7B" }, F: { "1": "WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "8": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB", "584": "TB UB VB" }, G: { "1": "7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "8": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C", "6148": "6C" }, H: { "2": "FD" }, I: { "1": "I", "8": "BC J GD HD ID JD XC KD LD" }, J: { "8": "D A" }, K: { "1": "H", "2": "A", "8": "B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "B", "36": "A" }, O: { "1": "8B" }, P: { "1": "u v w x y ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "MD", "8": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "328": "aD" } }, B: 2, C: "Pointer events", D: true };
  }
});

// node_modules/caniuse-lite/data/features/text-decoration.js
var require_text_decoration2 = __commonJS({
  "node_modules/caniuse-lite/data/features/text-decoration.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "2": "C L M G N O P", "2052": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "2": "ZC BC J DB bC cC", "1028": "0 1 2 3 4 5 6 7 8 9 QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "1060": "K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB" }, D: { "2": "J DB K D E F A B C L M G N O P EB u v w x y FB", "226": "GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB", "2052": "0 1 2 3 4 5 6 7 8 9 lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "2": "J DB K D dC HC eC fC", "772": "L M G 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "804": "E F A B C hC IC 6B", "1316": "gC" }, F: { "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB oC pC qC rC 6B WC sC 7B", "226": "PB QB RB SB TB UB VB WB XB", "2052": "YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t" }, G: { "2": "HC tC XC uC vC wC", "292": "E xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "2": "A B C 6B WC 7B", "2052": "H" }, L: { "2052": "I" }, M: { "1028": "5B" }, N: { "2": "A B" }, O: { "2052": "8B" }, P: { "2": "J MD ND", "2052": "u v w x y OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "2052": "YD" }, R: { "2052": "ZD" }, S: { "1028": "aD bD" } }, B: 4, C: "text-decoration styling", D: true };
  }
});

// node_modules/caniuse-lite/data/features/mdn-text-decoration-shorthand.js
var require_mdn_text_decoration_shorthand = __commonJS({
  "node_modules/caniuse-lite/data/features/mdn-text-decoration-shorthand.js"(exports2, module2) {
    module2.exports = { A: { D: { "1": "0 1 2 3 4 5 6 7 8 9 lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB" }, L: { "1": "I" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB bC cC" }, M: { "1": "5B" }, A: { "2": "K D E F A B YC" }, F: { "1": "YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB oC pC qC rC 6B WC sC 7B" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, E: { "2": "J DB K D dC HC eC fC gC nC", "33": "E F A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC" }, G: { "2": "HC tC XC uC vC wC", "33": "E xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, P: { "1": "u v w x y OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J MD ND" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" } }, B: 6, C: "text-decoration shorthand property", D: void 0 };
  }
});

// node_modules/caniuse-lite/data/features/mdn-text-decoration-color.js
var require_mdn_text_decoration_color = __commonJS({
  "node_modules/caniuse-lite/data/features/mdn-text-decoration-color.js"(exports2, module2) {
    module2.exports = { A: { D: { "1": "0 1 2 3 4 5 6 7 8 9 lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB" }, L: { "1": "I" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB bC cC", "33": "K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB" }, M: { "1": "5B" }, A: { "2": "K D E F A B YC" }, F: { "1": "YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB oC pC qC rC 6B WC sC 7B" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, E: { "1": "L M G 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC", "2": "J DB K D dC HC eC fC gC nC", "33": "E F A B C hC IC 6B" }, G: { "1": "5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC wC", "33": "E xC yC zC 0C 1C 2C 3C 4C" }, P: { "1": "u v w x y OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J MD ND" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" } }, B: 6, C: "text-decoration-color property", D: void 0 };
  }
});

// node_modules/caniuse-lite/data/features/mdn-text-decoration-line.js
var require_mdn_text_decoration_line = __commonJS({
  "node_modules/caniuse-lite/data/features/mdn-text-decoration-line.js"(exports2, module2) {
    module2.exports = { A: { D: { "1": "0 1 2 3 4 5 6 7 8 9 lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB" }, L: { "1": "I" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB bC cC", "33": "K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB" }, M: { "1": "5B" }, A: { "2": "K D E F A B YC" }, F: { "1": "YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB oC pC qC rC 6B WC sC 7B" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, E: { "1": "L M G 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC", "2": "J DB K D dC HC eC fC gC nC", "33": "E F A B C hC IC 6B" }, G: { "1": "5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC wC", "33": "E xC yC zC 0C 1C 2C 3C 4C" }, P: { "1": "u v w x y OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J MD ND" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" } }, B: 6, C: "text-decoration-line property", D: void 0 };
  }
});

// node_modules/caniuse-lite/data/features/mdn-text-decoration-style.js
var require_mdn_text_decoration_style = __commonJS({
  "node_modules/caniuse-lite/data/features/mdn-text-decoration-style.js"(exports2, module2) {
    module2.exports = { A: { D: { "1": "0 1 2 3 4 5 6 7 8 9 lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB" }, L: { "1": "I" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB bC cC", "33": "K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB" }, M: { "1": "5B" }, A: { "2": "K D E F A B YC" }, F: { "1": "YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB oC pC qC rC 6B WC sC 7B" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, E: { "1": "L M G 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC", "2": "J DB K D dC HC eC fC gC nC", "33": "E F A B C hC IC 6B" }, G: { "1": "5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC wC", "33": "E xC yC zC 0C 1C 2C 3C 4C" }, P: { "1": "u v w x y OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J MD ND" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" } }, B: 6, C: "text-decoration-style property", D: void 0 };
  }
});

// node_modules/caniuse-lite/data/features/text-size-adjust.js
var require_text_size_adjust = __commonJS({
  "node_modules/caniuse-lite/data/features/text-size-adjust.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "33": "C L M G N O P" }, C: { "2": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB", "258": "GB" }, E: { "2": "J DB K D E F A B C L M G dC HC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "258": "eC" }, F: { "1": "XB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB YB oC pC qC rC 6B WC sC 7B" }, G: { "2": "HC tC XC", "33": "E uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "33": "5B" }, N: { "161": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "2": "aD bD" } }, B: 7, C: "CSS text-size-adjust", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-masks.js
var require_css_masks = __commonJS({
  "node_modules/caniuse-lite/data/features/css-masks.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "8 9 AB BB CB I", "2": "C L M G N", "164": "0 1 2 3 4 5 6 7 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z", "3138": "O", "12292": "P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC", "260": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB bC cC" }, D: { "1": "8 9 AB BB CB I 5B FC GC", "164": "0 1 2 3 4 5 6 7 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z" }, E: { "1": "KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "dC HC", "164": "J DB K D E F A B C L M G eC fC gC hC IC 6B 7B iC jC kC JC" }, F: { "1": "p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "164": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o" }, G: { "1": "KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "164": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC" }, H: { "2": "FD" }, I: { "1": "I", "164": "KD LD", "676": "BC J GD HD ID JD XC" }, J: { "164": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "164": "8B" }, P: { "164": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "164": "YD" }, R: { "164": "ZD" }, S: { "1": "bD", "260": "aD" } }, B: 4, C: "CSS Masks", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-clip-path.js
var require_css_clip_path = __commonJS({
  "node_modules/caniuse-lite/data/features/css-clip-path.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "2": "C L M G N O", "260": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "3138": "P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC", "132": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bC cC", "644": "bB cB dB eB fB gB hB" }, D: { "2": "J DB K D E F A B C L M G N O P EB u v w x", "260": "0 1 2 3 4 5 6 7 8 9 jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "292": "y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB" }, E: { "2": "J DB K dC HC eC fC", "260": "M G iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "292": "D E F A B C L gC hC IC 6B 7B" }, F: { "2": "F B C oC pC qC rC 6B WC sC 7B", "260": "WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "292": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB" }, G: { "2": "HC tC XC uC vC", "260": "6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "292": "E wC xC yC zC 0C 1C 2C 3C 4C 5C" }, H: { "2": "FD" }, I: { "2": "BC J GD HD ID JD XC", "260": "I", "292": "KD LD" }, J: { "2": "D A" }, K: { "2": "A B C 6B WC 7B", "260": "H" }, L: { "260": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "260": "8B" }, P: { "260": "u v w x y ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "292": "J MD" }, Q: { "260": "YD" }, R: { "260": "ZD" }, S: { "1": "bD", "644": "aD" } }, B: 4, C: "CSS clip-path property (for HTML)", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-boxdecorationbreak.js
var require_css_boxdecorationbreak = __commonJS({
  "node_modules/caniuse-lite/data/features/css-boxdecorationbreak.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "2": "C L M G N O P", "164": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB bC cC" }, D: { "2": "J DB K D E F A B C L M G N O P EB u v", "164": "0 1 2 3 4 5 6 7 8 9 w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "2": "J DB K dC HC eC", "164": "D E F A B C L M G fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "2": "F oC pC qC rC", "129": "B C 6B WC sC 7B", "164": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t" }, G: { "2": "HC tC XC uC vC", "164": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "132": "FD" }, I: { "2": "BC J GD HD ID JD XC", "164": "I KD LD" }, J: { "2": "D", "164": "A" }, K: { "2": "A", "129": "B C 6B WC 7B", "164": "H" }, L: { "164": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "164": "8B" }, P: { "164": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "164": "YD" }, R: { "164": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "CSS box-decoration-break", D: true };
  }
});

// node_modules/caniuse-lite/data/features/object-fit.js
var require_object_fit = __commonJS({
  "node_modules/caniuse-lite/data/features/object-fit.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G", "260": "N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB" }, E: { "1": "A B C L M G IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D dC HC eC fC", "132": "E F gC hC" }, F: { "1": "EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F G N O P oC pC qC", "33": "B C rC 6B WC sC 7B" }, G: { "1": "0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC wC", "132": "E xC yC zC" }, H: { "33": "FD" }, I: { "1": "I LD", "2": "BC J GD HD ID JD XC KD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A", "33": "B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "CSS3 object-fit/object-position", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-shapes.js
var require_css_shapes = __commonJS({
  "node_modules/caniuse-lite/data/features/css-shapes.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB bC cC", "322": "fB gB hB iB jB kB lB mB CC nB DC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB", "194": "OB PB QB" }, E: { "1": "B C L M G IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D dC HC eC fC", "33": "E F A gC hC" }, F: { "1": "y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x oC pC qC rC 6B WC sC 7B" }, G: { "1": "1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC wC", "33": "E xC yC zC 0C" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "2": "aD" } }, B: 4, C: "CSS Shapes Level 1", D: true };
  }
});

// node_modules/caniuse-lite/data/features/text-overflow.js
var require_text_overflow = __commonJS({
  "node_modules/caniuse-lite/data/features/text-overflow.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "K D E F A B", "2": "YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "8": "ZC BC J DB K bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t 6B WC sC 7B", "33": "F oC pC qC rC" }, G: { "1": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "1": "FD" }, I: { "1": "BC J I GD HD ID JD XC KD LD" }, J: { "1": "D A" }, K: { "1": "H 7B", "33": "A B C 6B WC" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 2, C: "CSS3 Text-overflow", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-deviceadaptation.js
var require_css_deviceadaptation = __commonJS({
  "node_modules/caniuse-lite/data/features/css-deviceadaptation.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F YC", "164": "A B" }, B: { "66": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "164": "C L M G N O P" }, C: { "2": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB", "66": "0 1 2 3 4 5 6 7 8 9 JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB oC pC qC rC 6B WC sC 7B", "66": "UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "292": "FD" }, I: { "2": "BC J I GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "2": "A H", "292": "B C 6B WC 7B" }, L: { "2": "I" }, M: { "2": "5B" }, N: { "164": "A B" }, O: { "2": "8B" }, P: { "2": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "66": "YD" }, R: { "2": "ZD" }, S: { "2": "aD bD" } }, B: 5, C: "CSS Device Adaptation", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-media-resolution.js
var require_css_media_resolution = __commonJS({
  "node_modules/caniuse-lite/data/features/css-media-resolution.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E YC", "132": "F A B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "1028": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC", "260": "J DB K D E F A B C L M G bC cC", "1028": "N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "548": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB", "1028": "JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB" }, E: { "1": "9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "dC HC", "548": "J DB K D E F A B C L M G eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC" }, F: { "1": "jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t 7B", "2": "F", "548": "B C oC pC qC rC 6B WC sC", "1028": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB" }, G: { "1": "9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "16": "HC", "548": "E tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD" }, H: { "132": "FD" }, I: { "1": "I", "16": "GD HD", "548": "BC J ID JD XC", "1028": "KD LD" }, J: { "548": "D A" }, K: { "1": "H 7B", "548": "A B C 6B WC" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "132": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y IC RD SD TD UD VD 9B AC WD XD", "1028": "J MD ND OD PD QD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "Media Queries: resolution feature", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-text-align-last.js
var require_css_text_align_last = __commonJS({
  "node_modules/caniuse-lite/data/features/css-text-align-last.js"(exports2, module2) {
    module2.exports = { A: { A: { "132": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "4": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B bC cC", "33": "C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB", "322": "PB QB RB SB TB UB VB WB XB YB ZB aB" }, E: { "1": "9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC" }, F: { "1": "OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v oC pC qC rC 6B WC sC 7B", "578": "w x y FB GB HB IB JB KB LB MB NB" }, G: { "1": "9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "132": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "33": "aD" } }, B: 4, C: "CSS3 text-align-last", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-crisp-edges.js
var require_css_crisp_edges = __commonJS({
  "node_modules/caniuse-lite/data/features/css-crisp-edges.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K YC", "2340": "D E F A B" }, B: { "2": "C L M G N O P", "1025": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC bC", "513": "rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b", "545": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB cC" }, D: { "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB", "1025": "0 1 2 3 4 5 6 7 8 9 VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "A B C L M G IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB dC HC eC", "164": "K", "4644": "D E F fC gC hC" }, F: { "2": "F B G N O P EB u v w x y FB GB HB oC pC qC rC 6B WC", "545": "C sC 7B", "1025": "IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t" }, G: { "1": "0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC", "4260": "uC vC", "4644": "E wC xC yC zC" }, H: { "2": "FD" }, I: { "2": "BC J GD HD ID JD XC KD LD", "1025": "I" }, J: { "2": "D", "4260": "A" }, K: { "2": "A B 6B WC", "545": "C 7B", "1025": "H" }, L: { "1025": "I" }, M: { "1": "5B" }, N: { "2340": "A B" }, O: { "1025": "8B" }, P: { "1025": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1025": "YD" }, R: { "1025": "ZD" }, S: { "1": "bD", "4097": "aD" } }, B: 4, C: "Crisp edges/pixelated images", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-logical-props.js
var require_css_logical_props = __commonJS({
  "node_modules/caniuse-lite/data/features/css-logical-props.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P", "1028": "W X", "1540": "Q H R S T U V" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC", "164": "BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB bC cC", "1540": "VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "292": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB", "1028": "W X", "1540": "vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V" }, E: { "1": "G kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "292": "J DB K D E F A B C dC HC eC fC gC hC IC 6B", "1540": "L M 7B iC", "3076": "jC" }, F: { "1": "2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "292": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB", "1028": "0B 1B", "1540": "kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB" }, G: { "1": "CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "292": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C", "1540": "5C 6C 7C 8C 9C AD", "3076": "BD" }, H: { "2": "FD" }, I: { "1": "I", "292": "BC J GD HD ID JD XC KD LD" }, J: { "292": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y VD 9B AC WD XD", "292": "J MD ND OD PD QD", "1540": "IC RD SD TD UD" }, Q: { "1540": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "1540": "aD" } }, B: 5, C: "CSS Logical Properties", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-appearance.js
var require_css_appearance = __commonJS({
  "node_modules/caniuse-lite/data/features/css-appearance.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "33": "S", "164": "Q H R", "388": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "164": "PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q", "676": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "33": "S", "164": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R" }, E: { "1": "KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "164": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC" }, F: { "1": "zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "33": "wB xB yB", "164": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB" }, G: { "1": "KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "164": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC" }, H: { "2": "FD" }, I: { "1": "I", "164": "BC J GD HD ID JD XC KD LD" }, J: { "164": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A", "388": "B" }, O: { "1": "8B" }, P: { "1": "u v w x y UD VD 9B AC WD XD", "164": "J MD ND OD PD QD IC RD SD TD" }, Q: { "164": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "164": "aD" } }, B: 5, C: "CSS Appearance", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-snappoints.js
var require_css_snappoints = __commonJS({
  "node_modules/caniuse-lite/data/features/css-snappoints.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F YC", "6308": "A", "6436": "B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "6436": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB bC cC", "2052": "TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB", "8258": "sB tB uB" }, E: { "1": "B C L M G 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E dC HC eC fC gC", "3108": "F A hC IC" }, F: { "1": "qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB oC pC qC rC 6B WC sC 7B", "8258": "iB jB kB lB mB nB oB pB" }, G: { "1": "2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC", "3108": "yC zC 0C 1C" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y IC RD SD TD UD VD 9B AC WD XD", "2": "J MD ND OD PD QD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "2052": "aD" } }, B: 4, C: "CSS Scroll Snap", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-regions.js
var require_css_regions = __commonJS({
  "node_modules/caniuse-lite/data/features/css-regions.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F YC", "420": "A B" }, B: { "2": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "420": "C L M G N O P" }, C: { "2": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "2": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "36": "G N O P", "66": "EB u v w x y FB GB HB IB JB KB LB MB NB OB" }, E: { "2": "J DB K C L M G dC HC eC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "33": "D E F A B fC gC hC IC" }, F: { "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t oC pC qC rC 6B WC sC 7B" }, G: { "2": "HC tC XC uC vC 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "33": "E wC xC yC zC 0C 1C 2C" }, H: { "2": "FD" }, I: { "2": "BC J I GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "2": "A B C H 6B WC 7B" }, L: { "2": "I" }, M: { "2": "5B" }, N: { "420": "A B" }, O: { "2": "8B" }, P: { "2": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "2": "YD" }, R: { "2": "ZD" }, S: { "2": "aD bD" } }, B: 5, C: "CSS Regions", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-image-set.js
var require_css_image_set = __commonJS({
  "node_modules/caniuse-lite/data/features/css-image-set.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "2 3 4 5 6 7 8 9 AB BB CB I", "2": "C L M G N O P", "164": "0 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z", "2049": "1" }, C: { "1": "1 2 3 4 5 6 7 8 9 AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U bC cC", "66": "V W", "2305": "0 Y Z a b c d e f g h i j k l m n o p q r s t z", "2820": "X" }, D: { "1": "2 3 4 5 6 7 8 9 AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u", "164": "0 v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z", "2049": "1" }, E: { "1": "AC QC RC SC TC UC VC nC", "2": "J DB dC HC eC", "132": "A B C L IC 6B 7B iC", "164": "K D E F fC gC hC", "1540": "M G jC kC JC KC 8B lC 9B LC MC NC OC PC mC" }, F: { "1": "j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "164": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h", "2049": "i" }, G: { "1": "AC QC RC SC TC UC VC", "2": "HC tC XC uC", "132": "0C 1C 2C 3C 4C 5C 6C 7C 8C 9C", "164": "E vC wC xC yC zC", "1540": "AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC", "164": "KD LD" }, J: { "2": "D", "164": "A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "164": "8B" }, P: { "1": "x y", "164": "J u v w MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "164": "YD" }, R: { "164": "ZD" }, S: { "2": "aD bD" } }, B: 5, C: "CSS image-set", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-writing-mode.js
var require_css_writing_mode = __commonJS({
  "node_modules/caniuse-lite/data/features/css-writing-mode.js"(exports2, module2) {
    module2.exports = { A: { A: { "132": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB bC cC", "322": "QB RB SB TB UB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K", "16": "D", "33": "E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB" }, E: { "1": "B C L M G 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J dC HC", "16": "DB", "33": "K D E F A eC fC gC hC IC" }, F: { "1": "PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "33": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB" }, G: { "1": "2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "16": "HC tC XC", "33": "E uC vC wC xC yC zC 0C 1C" }, H: { "2": "FD" }, I: { "1": "I", "2": "GD HD ID", "33": "BC J JD XC KD LD" }, J: { "33": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "36": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "33": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 2, C: "CSS writing-mode property", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-cross-fade.js
var require_css_cross_fade = __commonJS({
  "node_modules/caniuse-lite/data/features/css-cross-fade.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "2": "C L M G N O P", "33": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "2": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "2": "J DB K D E F A B C L M G N", "33": "0 1 2 3 4 5 6 7 8 9 O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "A B C L M G IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB dC HC", "33": "K D E F eC fC gC hC" }, F: { "2": "F B C oC pC qC rC 6B WC sC 7B", "33": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t" }, G: { "1": "0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC", "33": "E uC vC wC xC yC zC" }, H: { "2": "FD" }, I: { "2": "BC J GD HD ID JD XC", "33": "I KD LD" }, J: { "2": "D A" }, K: { "2": "A B C 6B WC 7B", "33": "H" }, L: { "33": "I" }, M: { "2": "5B" }, N: { "2": "A B" }, O: { "33": "8B" }, P: { "33": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "33": "YD" }, R: { "33": "ZD" }, S: { "2": "aD bD" } }, B: 4, C: "CSS Cross-Fade Function", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-read-only-write.js
var require_css_read_only_write = __commonJS({
  "node_modules/caniuse-lite/data/features/css-read-only-write.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "16": "ZC", "33": "BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "16": "J DB K D E F A B C L M", "132": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB" }, E: { "1": "F A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "16": "dC HC", "132": "J DB K D E eC fC gC" }, F: { "1": "x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "16": "F B oC pC qC rC 6B", "132": "C G N O P EB u v w WC sC 7B" }, G: { "1": "yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "16": "HC tC", "132": "E XC uC vC wC xC" }, H: { "2": "FD" }, I: { "1": "I", "16": "GD HD", "132": "BC J ID JD XC KD LD" }, J: { "1": "A", "132": "D" }, K: { "1": "H", "2": "A B 6B", "132": "C WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "33": "aD" } }, B: 1, C: "CSS :read-only and :read-write selectors", D: true };
  }
});

// node_modules/caniuse-lite/data/features/text-emphasis.js
var require_text_emphasis = __commonJS({
  "node_modules/caniuse-lite/data/features/text-emphasis.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P", "164": "Q H R S T U V W X Y Z a b c d e f g h" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB bC cC", "322": "ZB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y", "164": "FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h" }, E: { "1": "E F A B C L M G gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K dC HC eC", "164": "D fC" }, F: { "1": "V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "164": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U" }, G: { "1": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC", "164": "KD LD" }, J: { "2": "D", "164": "A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y WD XD", "164": "J MD ND OD PD QD IC RD SD TD UD VD 9B AC" }, Q: { "164": "YD" }, R: { "164": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "text-emphasis styling", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-grid.js
var require_css_grid = __commonJS({
  "node_modules/caniuse-lite/data/features/css-grid.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E YC", "8": "F", "292": "A B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "292": "C L M G" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P bC cC", "8": "EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB", "584": "UB VB WB XB YB ZB aB bB cB dB eB fB", "1025": "gB hB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y", "8": "FB GB HB IB", "200": "JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB", "1025": "lB" }, E: { "1": "B C L M G IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB dC HC eC", "8": "K D E F A fC gC hC" }, F: { "1": "YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB oC pC qC rC 6B WC sC 7B", "200": "IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB" }, G: { "1": "1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC", "8": "E vC wC xC yC zC 0C" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD", "8": "XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "292": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "MD", "8": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "CSS Grid Layout (level 1)", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-text-spacing.js
var require_css_text_spacing = __commonJS({
  "node_modules/caniuse-lite/data/features/css-text-spacing.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D YC", "161": "E F A B" }, B: { "2": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "161": "C L M G N O P" }, C: { "2": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "2": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t oC pC qC rC 6B WC sC 7B" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "2": "BC J I GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "2": "A B C H 6B WC 7B" }, L: { "2": "I" }, M: { "2": "5B" }, N: { "16": "A B" }, O: { "2": "8B" }, P: { "2": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "2": "YD" }, R: { "2": "ZD" }, S: { "2": "aD bD" } }, B: 5, C: "CSS Text 4 text-spacing", D: false };
  }
});

// node_modules/caniuse-lite/data/features/css-any-link.js
var require_css_any_link = __commonJS({
  "node_modules/caniuse-lite/data/features/css-any-link.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "16": "ZC", "33": "BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "16": "J DB K D E F A B C L M", "33": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB" }, E: { "1": "F A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "16": "J DB K dC HC eC", "33": "D E fC gC" }, F: { "1": "gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "33": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB" }, G: { "1": "yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "16": "HC tC XC uC", "33": "E vC wC xC" }, H: { "2": "FD" }, I: { "1": "I", "16": "BC J GD HD ID JD XC", "33": "KD LD" }, J: { "16": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y QD IC RD SD TD UD VD 9B AC WD XD", "16": "J", "33": "MD ND OD PD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "33": "aD" } }, B: 5, C: "CSS :any-link selector", D: true };
  }
});

// node_modules/caniuse-lite/data/features/mdn-css-unicode-bidi-isolate.js
var require_mdn_css_unicode_bidi_isolate = __commonJS({
  "node_modules/caniuse-lite/data/features/mdn-css-unicode-bidi-isolate.js"(exports2, module2) {
    module2.exports = { A: { D: { "1": "0 1 2 3 4 5 6 7 8 9 cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G", "33": "N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB" }, L: { "1": "I" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F bC cC", "33": "A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB" }, M: { "1": "5B" }, A: { "2": "K D E F A B YC" }, F: { "1": "PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "33": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, E: { "1": "B C L M G 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC", "2": "J DB dC HC eC nC", "33": "K D E F A fC gC hC IC" }, G: { "1": "2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC", "33": "E vC wC xC yC zC 0C 1C" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" } }, B: 6, C: "isolate from unicode-bidi", D: void 0 };
  }
});

// node_modules/caniuse-lite/data/features/mdn-css-unicode-bidi-plaintext.js
var require_mdn_css_unicode_bidi_plaintext = __commonJS({
  "node_modules/caniuse-lite/data/features/mdn-css-unicode-bidi-plaintext.js"(exports2, module2) {
    module2.exports = { A: { D: { "1": "0 1 2 3 4 5 6 7 8 9 cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB" }, L: { "1": "I" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F bC cC", "33": "A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB" }, M: { "1": "5B" }, A: { "2": "K D E F A B YC" }, F: { "1": "PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB oC pC qC rC 6B WC sC 7B" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, E: { "1": "B C L M G 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC", "2": "J DB dC HC eC nC", "33": "K D E F A fC gC hC IC" }, G: { "1": "2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC", "33": "E vC wC xC yC zC 0C 1C" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" } }, B: 6, C: "plaintext from unicode-bidi", D: void 0 };
  }
});

// node_modules/caniuse-lite/data/features/mdn-css-unicode-bidi-isolate-override.js
var require_mdn_css_unicode_bidi_isolate_override = __commonJS({
  "node_modules/caniuse-lite/data/features/mdn-css-unicode-bidi-isolate-override.js"(exports2, module2) {
    module2.exports = { A: { D: { "1": "0 1 2 3 4 5 6 7 8 9 cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB" }, L: { "1": "I" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N bC cC", "33": "O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB" }, M: { "1": "5B" }, A: { "2": "K D E F A B YC" }, F: { "1": "PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB oC pC qC rC 6B WC sC 7B" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, E: { "1": "B C L M G 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC", "2": "J DB K dC HC eC fC nC", "33": "D E F A gC hC IC" }, G: { "1": "2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC", "33": "E wC xC yC zC 0C 1C" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" } }, B: 6, C: "isolate-override from unicode-bidi", D: void 0 };
  }
});

// node_modules/caniuse-lite/data/features/css-overscroll-behavior.js
var require_css_overscroll_behavior = __commonJS({
  "node_modules/caniuse-lite/data/features/css-overscroll-behavior.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F YC", "132": "A B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "132": "C L M G N O", "516": "P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB", "260": "pB qB" }, E: { "1": "9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F A B C L M dC HC eC fC gC hC IC 6B 7B iC", "1090": "G jC kC JC KC 8B lC" }, F: { "1": "gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB oC pC qC rC 6B WC sC 7B", "260": "eB fB" }, G: { "1": "9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD", "1090": "BD CD JC KC 8B DD" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "132": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J MD ND OD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "2": "aD" } }, B: 5, C: "CSS overscroll-behavior", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-text-orientation.js
var require_css_text_orientation = __commonJS({
  "node_modules/caniuse-lite/data/features/css-text-orientation.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB bC cC", "194": "SB TB UB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB" }, E: { "1": "M G jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F dC HC eC fC gC hC", "16": "A", "33": "B C L IC 6B 7B iC" }, F: { "1": "PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB oC pC qC rC 6B WC sC 7B" }, G: { "1": "0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 2, C: "CSS text-orientation", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-print-color-adjust.js
var require_css_print_color_adjust = __commonJS({
  "node_modules/caniuse-lite/data/features/css-print-color-adjust.js"(exports2, module2) {
    module2.exports = { A: { D: { "2": "J DB K D E F A B C L M G N", "33": "0 1 2 3 4 5 6 7 8 9 O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, L: { "33": "I" }, B: { "2": "C L M G N O P", "33": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB bC cC", "33": "cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f" }, M: { "1": "5B" }, A: { "2": "K D E F A B YC" }, F: { "2": "F B C oC pC qC rC 6B WC sC 7B", "33": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t" }, K: { "2": "A B C 6B WC 7B", "33": "H" }, E: { "1": "KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC", "2": "J DB dC HC eC nC", "33": "K D E F A B C L M G fC gC hC IC 6B 7B iC jC kC JC" }, G: { "1": "KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC", "33": "E vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC" }, P: { "33": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, I: { "2": "BC J GD HD ID JD XC", "33": "I KD LD" } }, B: 6, C: "print-color-adjust property", D: void 0 };
  }
});

// node_modules/autoprefixer/data/prefixes.js
var require_prefixes2 = __commonJS({
  "node_modules/autoprefixer/data/prefixes.js"(exports2, module2) {
    var unpack = require_feature();
    function browsersSort(a, b) {
      a = a.split(" ");
      b = b.split(" ");
      if (a[0] > b[0]) {
        return 1;
      } else if (a[0] < b[0]) {
        return -1;
      } else {
        return Math.sign(parseFloat(a[1]) - parseFloat(b[1]));
      }
    }
    function f(data, opts, callback) {
      data = unpack(data);
      if (!callback) {
        ;
        [callback, opts] = [opts, {}];
      }
      let match = opts.match || /\sx($|\s)/;
      let need = [];
      for (let browser in data.stats) {
        let versions = data.stats[browser];
        for (let version in versions) {
          let support = versions[version];
          if (support.match(match)) {
            need.push(browser + " " + version);
          }
        }
      }
      callback(need.sort(browsersSort));
    }
    var result = {};
    function prefix(names, data) {
      for (let name of names) {
        result[name] = Object.assign({}, data);
      }
    }
    function add(names, data) {
      for (let name of names) {
        result[name].browsers = result[name].browsers.concat(data.browsers).sort(browsersSort);
      }
    }
    module2.exports = result;
    var prefixBorderRadius = require_border_radius2();
    f(
      prefixBorderRadius,
      (browsers) => prefix(
        [
          "border-radius",
          "border-top-left-radius",
          "border-top-right-radius",
          "border-bottom-right-radius",
          "border-bottom-left-radius"
        ],
        {
          mistakes: ["-khtml-", "-ms-", "-o-"],
          feature: "border-radius",
          browsers
        }
      )
    );
    var prefixBoxshadow = require_css_boxshadow();
    f(
      prefixBoxshadow,
      (browsers) => prefix(["box-shadow"], {
        mistakes: ["-khtml-"],
        feature: "css-boxshadow",
        browsers
      })
    );
    var prefixAnimation = require_css_animation();
    f(
      prefixAnimation,
      (browsers) => prefix(
        [
          "animation",
          "animation-name",
          "animation-duration",
          "animation-delay",
          "animation-direction",
          "animation-fill-mode",
          "animation-iteration-count",
          "animation-play-state",
          "animation-timing-function",
          "@keyframes"
        ],
        {
          mistakes: ["-khtml-", "-ms-"],
          feature: "css-animation",
          browsers
        }
      )
    );
    var prefixTransition = require_css_transitions();
    f(
      prefixTransition,
      (browsers) => prefix(
        [
          "transition",
          "transition-property",
          "transition-duration",
          "transition-delay",
          "transition-timing-function"
        ],
        {
          mistakes: ["-khtml-", "-ms-"],
          browsers,
          feature: "css-transitions"
        }
      )
    );
    var prefixTransform2d = require_transforms2d();
    f(
      prefixTransform2d,
      (browsers) => prefix(["transform", "transform-origin"], {
        feature: "transforms2d",
        browsers
      })
    );
    var prefixTransforms3d = require_transforms3d();
    f(prefixTransforms3d, (browsers) => {
      prefix(["perspective", "perspective-origin"], {
        feature: "transforms3d",
        browsers
      });
      return prefix(["transform-style"], {
        mistakes: ["-ms-", "-o-"],
        browsers,
        feature: "transforms3d"
      });
    });
    f(
      prefixTransforms3d,
      { match: /y\sx|y\s#2/ },
      (browsers) => prefix(["backface-visibility"], {
        mistakes: ["-ms-", "-o-"],
        feature: "transforms3d",
        browsers
      })
    );
    var prefixGradients = require_css_gradients();
    f(
      prefixGradients,
      { match: /y\sx/ },
      (browsers) => prefix(
        [
          "linear-gradient",
          "repeating-linear-gradient",
          "radial-gradient",
          "repeating-radial-gradient"
        ],
        {
          props: [
            "background",
            "background-image",
            "border-image",
            "mask",
            "list-style",
            "list-style-image",
            "content",
            "mask-image"
          ],
          mistakes: ["-ms-"],
          feature: "css-gradients",
          browsers
        }
      )
    );
    f(prefixGradients, { match: /a\sx/ }, (browsers) => {
      browsers = browsers.map((i) => {
        if (/firefox|op/.test(i)) {
          return i;
        } else {
          return `${i} old`;
        }
      });
      return add(
        [
          "linear-gradient",
          "repeating-linear-gradient",
          "radial-gradient",
          "repeating-radial-gradient"
        ],
        {
          feature: "css-gradients",
          browsers
        }
      );
    });
    var prefixBoxsizing = require_css3_boxsizing();
    f(
      prefixBoxsizing,
      (browsers) => prefix(["box-sizing"], {
        feature: "css3-boxsizing",
        browsers
      })
    );
    var prefixFilters = require_css_filters();
    f(
      prefixFilters,
      (browsers) => prefix(["filter"], {
        feature: "css-filters",
        browsers
      })
    );
    var prefixFilterFunction = require_css_filter_function();
    f(
      prefixFilterFunction,
      (browsers) => prefix(["filter-function"], {
        props: [
          "background",
          "background-image",
          "border-image",
          "mask",
          "list-style",
          "list-style-image",
          "content",
          "mask-image"
        ],
        feature: "css-filter-function",
        browsers
      })
    );
    var prefixBackdrop = require_css_backdrop_filter();
    f(
      prefixBackdrop,
      { match: /y\sx|y\s#2/ },
      (browsers) => prefix(["backdrop-filter"], {
        feature: "css-backdrop-filter",
        browsers
      })
    );
    var prefixElementFunction = require_css_element_function();
    f(
      prefixElementFunction,
      (browsers) => prefix(["element"], {
        props: [
          "background",
          "background-image",
          "border-image",
          "mask",
          "list-style",
          "list-style-image",
          "content",
          "mask-image"
        ],
        feature: "css-element-function",
        browsers
      })
    );
    var prefixMulticolumns = require_multicolumn();
    f(prefixMulticolumns, (browsers) => {
      prefix(
        [
          "columns",
          "column-width",
          "column-gap",
          "column-rule",
          "column-rule-color",
          "column-rule-width",
          "column-count",
          "column-rule-style",
          "column-span",
          "column-fill"
        ],
        {
          feature: "multicolumn",
          browsers
        }
      );
      let noff = browsers.filter((i) => !/firefox/.test(i));
      prefix(["break-before", "break-after", "break-inside"], {
        feature: "multicolumn",
        browsers: noff
      });
    });
    var prefixUserSelect = require_user_select_none();
    f(
      prefixUserSelect,
      (browsers) => prefix(["user-select"], {
        mistakes: ["-khtml-"],
        feature: "user-select-none",
        browsers
      })
    );
    var prefixFlexbox = require_flexbox();
    f(prefixFlexbox, { match: /a\sx/ }, (browsers) => {
      browsers = browsers.map((i) => {
        if (/ie|firefox/.test(i)) {
          return i;
        } else {
          return `${i} 2009`;
        }
      });
      prefix(["display-flex", "inline-flex"], {
        props: ["display"],
        feature: "flexbox",
        browsers
      });
      prefix(["flex", "flex-grow", "flex-shrink", "flex-basis"], {
        feature: "flexbox",
        browsers
      });
      prefix(
        [
          "flex-direction",
          "flex-wrap",
          "flex-flow",
          "justify-content",
          "order",
          "align-items",
          "align-self",
          "align-content"
        ],
        {
          feature: "flexbox",
          browsers
        }
      );
    });
    f(prefixFlexbox, { match: /y\sx/ }, (browsers) => {
      add(["display-flex", "inline-flex"], {
        feature: "flexbox",
        browsers
      });
      add(["flex", "flex-grow", "flex-shrink", "flex-basis"], {
        feature: "flexbox",
        browsers
      });
      add(
        [
          "flex-direction",
          "flex-wrap",
          "flex-flow",
          "justify-content",
          "order",
          "align-items",
          "align-self",
          "align-content"
        ],
        {
          feature: "flexbox",
          browsers
        }
      );
    });
    var prefixCalc = require_calc();
    f(
      prefixCalc,
      (browsers) => prefix(["calc"], {
        props: ["*"],
        feature: "calc",
        browsers
      })
    );
    var prefixBackgroundOptions = require_background_img_opts();
    f(
      prefixBackgroundOptions,
      (browsers) => prefix(["background-origin", "background-size"], {
        feature: "background-img-opts",
        browsers
      })
    );
    var prefixBackgroundClipText = require_background_clip_text();
    f(
      prefixBackgroundClipText,
      (browsers) => prefix(["background-clip"], {
        feature: "background-clip-text",
        browsers
      })
    );
    var prefixFontFeature = require_font_feature();
    f(
      prefixFontFeature,
      (browsers) => prefix(
        [
          "font-feature-settings",
          "font-variant-ligatures",
          "font-language-override"
        ],
        {
          feature: "font-feature",
          browsers
        }
      )
    );
    var prefixFontKerning = require_font_kerning();
    f(
      prefixFontKerning,
      (browsers) => prefix(["font-kerning"], {
        feature: "font-kerning",
        browsers
      })
    );
    var prefixBorderImage = require_border_image2();
    f(
      prefixBorderImage,
      (browsers) => prefix(["border-image"], {
        feature: "border-image",
        browsers
      })
    );
    var prefixSelection = require_css_selection();
    f(
      prefixSelection,
      (browsers) => prefix(["::selection"], {
        selector: true,
        feature: "css-selection",
        browsers
      })
    );
    var prefixPlaceholder = require_css_placeholder();
    f(prefixPlaceholder, (browsers) => {
      prefix(["::placeholder"], {
        selector: true,
        feature: "css-placeholder",
        browsers: browsers.concat(["ie 10 old", "ie 11 old", "firefox 18 old"])
      });
    });
    var prefixPlaceholderShown = require_css_placeholder_shown();
    f(prefixPlaceholderShown, (browsers) => {
      prefix([":placeholder-shown"], {
        selector: true,
        feature: "css-placeholder-shown",
        browsers
      });
    });
    var prefixHyphens = require_css_hyphens();
    f(
      prefixHyphens,
      (browsers) => prefix(["hyphens"], {
        feature: "css-hyphens",
        browsers
      })
    );
    var prefixFullscreen = require_fullscreen2();
    f(
      prefixFullscreen,
      (browsers) => prefix([":fullscreen"], {
        selector: true,
        feature: "fullscreen",
        browsers
      })
    );
    f(
      prefixFullscreen,
      { match: /x(\s#2|$)/ },
      (browsers) => prefix(["::backdrop"], {
        selector: true,
        feature: "fullscreen",
        browsers
      })
    );
    var prefixFileSelectorButton = require_css_file_selector_button();
    f(
      prefixFileSelectorButton,
      (browsers) => prefix(["::file-selector-button"], {
        selector: true,
        feature: "file-selector-button",
        browsers
      })
    );
    var prefixAutofill = require_css_autofill();
    f(
      prefixAutofill,
      (browsers) => prefix([":autofill"], {
        selector: true,
        feature: "css-autofill",
        browsers
      })
    );
    var prefixTabsize = require_css3_tabsize();
    f(
      prefixTabsize,
      (browsers) => prefix(["tab-size"], {
        feature: "css3-tabsize",
        browsers
      })
    );
    var prefixIntrinsic = require_intrinsic_width();
    var sizeProps = [
      "width",
      "min-width",
      "max-width",
      "height",
      "min-height",
      "max-height",
      "inline-size",
      "min-inline-size",
      "max-inline-size",
      "block-size",
      "min-block-size",
      "max-block-size",
      "grid",
      "grid-template",
      "grid-template-rows",
      "grid-template-columns",
      "grid-auto-columns",
      "grid-auto-rows"
    ];
    f(
      prefixIntrinsic,
      (browsers) => prefix(["max-content", "min-content"], {
        props: sizeProps,
        feature: "intrinsic-width",
        browsers
      })
    );
    f(
      prefixIntrinsic,
      { match: /x|\s#4/ },
      (browsers) => prefix(["fill", "fill-available"], {
        props: sizeProps,
        feature: "intrinsic-width",
        browsers
      })
    );
    f(
      prefixIntrinsic,
      { match: /x|\s#5/ },
      (browsers) => prefix(["fit-content"], {
        props: sizeProps,
        feature: "intrinsic-width",
        browsers
      })
    );
    var prefixStretch = require_css_width_stretch();
    f(
      prefixStretch,
      (browsers) => prefix(["stretch"], {
        props: sizeProps,
        feature: "css-width-stretch",
        browsers
      })
    );
    var prefixCursorsNewer = require_css3_cursors_newer();
    f(
      prefixCursorsNewer,
      (browsers) => prefix(["zoom-in", "zoom-out"], {
        props: ["cursor"],
        feature: "css3-cursors-newer",
        browsers
      })
    );
    var prefixCursorsGrab = require_css3_cursors_grab();
    f(
      prefixCursorsGrab,
      (browsers) => prefix(["grab", "grabbing"], {
        props: ["cursor"],
        feature: "css3-cursors-grab",
        browsers
      })
    );
    var prefixSticky = require_css_sticky();
    f(
      prefixSticky,
      (browsers) => prefix(["sticky"], {
        props: ["position"],
        feature: "css-sticky",
        browsers
      })
    );
    var prefixPointer = require_pointer();
    f(
      prefixPointer,
      (browsers) => prefix(["touch-action"], {
        feature: "pointer",
        browsers
      })
    );
    var prefixDecoration = require_text_decoration2();
    f(
      prefixDecoration,
      { match: /x.*#[235]/ },
      (browsers) => prefix(["text-decoration-skip", "text-decoration-skip-ink"], {
        feature: "text-decoration",
        browsers
      })
    );
    var prefixDecorationShorthand = require_mdn_text_decoration_shorthand();
    f(
      prefixDecorationShorthand,
      (browsers) => prefix(["text-decoration"], {
        feature: "text-decoration",
        browsers
      })
    );
    var prefixDecorationColor = require_mdn_text_decoration_color();
    f(
      prefixDecorationColor,
      (browsers) => prefix(["text-decoration-color"], {
        feature: "text-decoration",
        browsers
      })
    );
    var prefixDecorationLine = require_mdn_text_decoration_line();
    f(
      prefixDecorationLine,
      (browsers) => prefix(["text-decoration-line"], {
        feature: "text-decoration",
        browsers
      })
    );
    var prefixDecorationStyle = require_mdn_text_decoration_style();
    f(
      prefixDecorationStyle,
      (browsers) => prefix(["text-decoration-style"], {
        feature: "text-decoration",
        browsers
      })
    );
    var prefixTextSizeAdjust = require_text_size_adjust();
    f(
      prefixTextSizeAdjust,
      (browsers) => prefix(["text-size-adjust"], {
        feature: "text-size-adjust",
        browsers
      })
    );
    var prefixCssMasks = require_css_masks();
    f(prefixCssMasks, (browsers) => {
      prefix(
        [
          "mask-clip",
          "mask-composite",
          "mask-image",
          "mask-origin",
          "mask-repeat",
          "mask-border-repeat",
          "mask-border-source"
        ],
        {
          feature: "css-masks",
          browsers
        }
      );
      prefix(
        [
          "mask",
          "mask-position",
          "mask-size",
          "mask-border",
          "mask-border-outset",
          "mask-border-width",
          "mask-border-slice"
        ],
        {
          feature: "css-masks",
          browsers
        }
      );
    });
    var prefixClipPath = require_css_clip_path();
    f(
      prefixClipPath,
      (browsers) => prefix(["clip-path"], {
        feature: "css-clip-path",
        browsers
      })
    );
    var prefixBoxdecoration = require_css_boxdecorationbreak();
    f(
      prefixBoxdecoration,
      (browsers) => prefix(["box-decoration-break"], {
        feature: "css-boxdecorationbreak",
        browsers
      })
    );
    var prefixObjectFit = require_object_fit();
    f(
      prefixObjectFit,
      (browsers) => prefix(["object-fit", "object-position"], {
        feature: "object-fit",
        browsers
      })
    );
    var prefixShapes = require_css_shapes();
    f(
      prefixShapes,
      (browsers) => prefix(["shape-margin", "shape-outside", "shape-image-threshold"], {
        feature: "css-shapes",
        browsers
      })
    );
    var prefixTextOverflow = require_text_overflow();
    f(
      prefixTextOverflow,
      (browsers) => prefix(["text-overflow"], {
        feature: "text-overflow",
        browsers
      })
    );
    var prefixDeviceadaptation = require_css_deviceadaptation();
    f(
      prefixDeviceadaptation,
      (browsers) => prefix(["@viewport"], {
        feature: "css-deviceadaptation",
        browsers
      })
    );
    var prefixResolut = require_css_media_resolution();
    f(
      prefixResolut,
      { match: /( x($| )|a #2)/ },
      (browsers) => prefix(["@resolution"], {
        feature: "css-media-resolution",
        browsers
      })
    );
    var prefixTextAlignLast = require_css_text_align_last();
    f(
      prefixTextAlignLast,
      (browsers) => prefix(["text-align-last"], {
        feature: "css-text-align-last",
        browsers
      })
    );
    var prefixCrispedges = require_css_crisp_edges();
    f(
      prefixCrispedges,
      { match: /y x|a x #1/ },
      (browsers) => prefix(["pixelated"], {
        props: ["image-rendering"],
        feature: "css-crisp-edges",
        browsers
      })
    );
    f(
      prefixCrispedges,
      { match: /a x #2/ },
      (browsers) => prefix(["image-rendering"], {
        feature: "css-crisp-edges",
        browsers
      })
    );
    var prefixLogicalProps = require_css_logical_props();
    f(
      prefixLogicalProps,
      (browsers) => prefix(
        [
          "border-inline-start",
          "border-inline-end",
          "margin-inline-start",
          "margin-inline-end",
          "padding-inline-start",
          "padding-inline-end"
        ],
        {
          feature: "css-logical-props",
          browsers
        }
      )
    );
    f(
      prefixLogicalProps,
      { match: /x\s#2/ },
      (browsers) => prefix(
        [
          "border-block-start",
          "border-block-end",
          "margin-block-start",
          "margin-block-end",
          "padding-block-start",
          "padding-block-end"
        ],
        {
          feature: "css-logical-props",
          browsers
        }
      )
    );
    var prefixAppearance = require_css_appearance();
    f(
      prefixAppearance,
      { match: /#2|x/ },
      (browsers) => prefix(["appearance"], {
        feature: "css-appearance",
        browsers
      })
    );
    var prefixSnappoints = require_css_snappoints();
    f(
      prefixSnappoints,
      (browsers) => prefix(
        [
          "scroll-snap-type",
          "scroll-snap-coordinate",
          "scroll-snap-destination",
          "scroll-snap-points-x",
          "scroll-snap-points-y"
        ],
        {
          feature: "css-snappoints",
          browsers
        }
      )
    );
    var prefixRegions = require_css_regions();
    f(
      prefixRegions,
      (browsers) => prefix(["flow-into", "flow-from", "region-fragment"], {
        feature: "css-regions",
        browsers
      })
    );
    var prefixImageSet = require_css_image_set();
    f(
      prefixImageSet,
      (browsers) => prefix(["image-set"], {
        props: [
          "background",
          "background-image",
          "border-image",
          "cursor",
          "mask",
          "mask-image",
          "list-style",
          "list-style-image",
          "content"
        ],
        feature: "css-image-set",
        browsers
      })
    );
    var prefixWritingMode = require_css_writing_mode();
    f(
      prefixWritingMode,
      { match: /a|x/ },
      (browsers) => prefix(["writing-mode"], {
        feature: "css-writing-mode",
        browsers
      })
    );
    var prefixCrossFade = require_css_cross_fade();
    f(
      prefixCrossFade,
      (browsers) => prefix(["cross-fade"], {
        props: [
          "background",
          "background-image",
          "border-image",
          "mask",
          "list-style",
          "list-style-image",
          "content",
          "mask-image"
        ],
        feature: "css-cross-fade",
        browsers
      })
    );
    var prefixReadOnly = require_css_read_only_write();
    f(
      prefixReadOnly,
      (browsers) => prefix([":read-only", ":read-write"], {
        selector: true,
        feature: "css-read-only-write",
        browsers
      })
    );
    var prefixTextEmphasis = require_text_emphasis();
    f(
      prefixTextEmphasis,
      (browsers) => prefix(
        [
          "text-emphasis",
          "text-emphasis-position",
          "text-emphasis-style",
          "text-emphasis-color"
        ],
        {
          feature: "text-emphasis",
          browsers
        }
      )
    );
    var prefixGrid = require_css_grid();
    f(prefixGrid, (browsers) => {
      prefix(["display-grid", "inline-grid"], {
        props: ["display"],
        feature: "css-grid",
        browsers
      });
      prefix(
        [
          "grid-template-columns",
          "grid-template-rows",
          "grid-row-start",
          "grid-column-start",
          "grid-row-end",
          "grid-column-end",
          "grid-row",
          "grid-column",
          "grid-area",
          "grid-template",
          "grid-template-areas",
          "place-self"
        ],
        {
          feature: "css-grid",
          browsers
        }
      );
    });
    f(
      prefixGrid,
      { match: /a x/ },
      (browsers) => prefix(["grid-column-align", "grid-row-align"], {
        feature: "css-grid",
        browsers
      })
    );
    var prefixTextSpacing = require_css_text_spacing();
    f(
      prefixTextSpacing,
      (browsers) => prefix(["text-spacing"], {
        feature: "css-text-spacing",
        browsers
      })
    );
    var prefixAnyLink = require_css_any_link();
    f(
      prefixAnyLink,
      (browsers) => prefix([":any-link"], {
        selector: true,
        feature: "css-any-link",
        browsers
      })
    );
    var bidiIsolate = require_mdn_css_unicode_bidi_isolate();
    f(
      bidiIsolate,
      (browsers) => prefix(["isolate"], {
        props: ["unicode-bidi"],
        feature: "css-unicode-bidi",
        browsers
      })
    );
    var bidiPlaintext = require_mdn_css_unicode_bidi_plaintext();
    f(
      bidiPlaintext,
      (browsers) => prefix(["plaintext"], {
        props: ["unicode-bidi"],
        feature: "css-unicode-bidi",
        browsers
      })
    );
    var bidiOverride = require_mdn_css_unicode_bidi_isolate_override();
    f(
      bidiOverride,
      { match: /y x/ },
      (browsers) => prefix(["isolate-override"], {
        props: ["unicode-bidi"],
        feature: "css-unicode-bidi",
        browsers
      })
    );
    var prefixOverscroll = require_css_overscroll_behavior();
    f(
      prefixOverscroll,
      { match: /a #1/ },
      (browsers) => prefix(["overscroll-behavior"], {
        feature: "css-overscroll-behavior",
        browsers
      })
    );
    var prefixTextOrientation = require_css_text_orientation();
    f(
      prefixTextOrientation,
      (browsers) => prefix(["text-orientation"], {
        feature: "css-text-orientation",
        browsers
      })
    );
    var prefixPrintAdjust = require_css_print_color_adjust();
    f(
      prefixPrintAdjust,
      (browsers) => prefix(["print-color-adjust", "color-adjust"], {
        feature: "css-print-color-adjust",
        browsers
      })
    );
  }
});

// node_modules/autoprefixer/lib/info.js
var require_info = __commonJS({
  "node_modules/autoprefixer/lib/info.js"(exports2, module2) {
    var browserslist = require_browserslist();
    function capitalize(str) {
      return str.slice(0, 1).toUpperCase() + str.slice(1);
    }
    var NAMES = {
      ie: "IE",
      ie_mob: "IE Mobile",
      ios_saf: "iOS Safari",
      op_mini: "Opera Mini",
      op_mob: "Opera Mobile",
      and_chr: "Chrome for Android",
      and_ff: "Firefox for Android",
      and_uc: "UC for Android",
      and_qq: "QQ Browser",
      kaios: "KaiOS Browser",
      baidu: "Baidu Browser",
      samsung: "Samsung Internet"
    };
    function prefix(name, prefixes, note) {
      let out = `  ${name}`;
      if (note)
        out += " *";
      out += ": ";
      out += prefixes.map((i) => i.replace(/^-(.*)-$/g, "$1")).join(", ");
      out += "\n";
      return out;
    }
    module2.exports = function(prefixes) {
      if (prefixes.browsers.selected.length === 0) {
        return "No browsers selected";
      }
      let versions = {};
      for (let browser of prefixes.browsers.selected) {
        let parts = browser.split(" ");
        let name = parts[0];
        let version = parts[1];
        name = NAMES[name] || capitalize(name);
        if (versions[name]) {
          versions[name].push(version);
        } else {
          versions[name] = [version];
        }
      }
      let out = "Browsers:\n";
      for (let browser in versions) {
        let list = versions[browser];
        list = list.sort((a, b) => parseFloat(b) - parseFloat(a));
        out += `  ${browser}: ${list.join(", ")}
`;
      }
      let coverage = browserslist.coverage(prefixes.browsers.selected);
      let round = Math.round(coverage * 100) / 100;
      out += `
These browsers account for ${round}% of all users globally
`;
      let atrules = [];
      for (let name in prefixes.add) {
        let data = prefixes.add[name];
        if (name[0] === "@" && data.prefixes) {
          atrules.push(prefix(name, data.prefixes));
        }
      }
      if (atrules.length > 0) {
        out += `
At-Rules:
${atrules.sort().join("")}`;
      }
      let selectors = [];
      for (let selector of prefixes.add.selectors) {
        if (selector.prefixes) {
          selectors.push(prefix(selector.name, selector.prefixes));
        }
      }
      if (selectors.length > 0) {
        out += `
Selectors:
${selectors.sort().join("")}`;
      }
      let values = [];
      let props = [];
      let hadGrid = false;
      for (let name in prefixes.add) {
        let data = prefixes.add[name];
        if (name[0] !== "@" && data.prefixes) {
          let grid = name.indexOf("grid-") === 0;
          if (grid)
            hadGrid = true;
          props.push(prefix(name, data.prefixes, grid));
        }
        if (!Array.isArray(data.values)) {
          continue;
        }
        for (let value of data.values) {
          let grid = value.name.includes("grid");
          if (grid)
            hadGrid = true;
          let string = prefix(value.name, value.prefixes, grid);
          if (!values.includes(string)) {
            values.push(string);
          }
        }
      }
      if (props.length > 0) {
        out += `
Properties:
${props.sort().join("")}`;
      }
      if (values.length > 0) {
        out += `
Values:
${values.sort().join("")}`;
      }
      if (hadGrid) {
        out += "\n* - Prefixes will be added only on grid: true option.\n";
      }
      if (!atrules.length && !selectors.length && !props.length && !values.length) {
        out += "\nAwesome! Your browsers don't require any vendor prefixes.\nNow you can remove Autoprefixer from build steps.";
      }
      return out;
    };
  }
});

// node_modules/autoprefixer/lib/autoprefixer.js
var require_autoprefixer = __commonJS({
  "node_modules/autoprefixer/lib/autoprefixer.js"(exports2, module2) {
    var browserslist = require_browserslist();
    var { agents } = require_agents2();
    var pico = require_picocolors();
    var Browsers = require_browsers3();
    var Prefixes = require_prefixes();
    var dataPrefixes = require_prefixes2();
    var getInfo = require_info();
    var autoprefixerData = { browsers: agents, prefixes: dataPrefixes };
    var WARNING = "\n  Replace Autoprefixer `browsers` option to Browserslist config.\n  Use `browserslist` key in `package.json` or `.browserslistrc` file.\n\n  Using `browsers` option can cause errors. Browserslist config can\n  be used for Babel, Autoprefixer, postcss-normalize and other tools.\n\n  If you really need to use option, rename it to `overrideBrowserslist`.\n\n  Learn more at:\n  https://github.com/browserslist/browserslist#readme\n  https://twitter.com/browserslist\n\n";
    function isPlainObject(obj) {
      return Object.prototype.toString.apply(obj) === "[object Object]";
    }
    var cache = /* @__PURE__ */ new Map();
    function timeCapsule(result, prefixes) {
      if (prefixes.browsers.selected.length === 0) {
        return;
      }
      if (prefixes.add.selectors.length > 0) {
        return;
      }
      if (Object.keys(prefixes.add).length > 2) {
        return;
      }
      result.warn(
        "Autoprefixer target browsers do not need any prefixes.You do not need Autoprefixer anymore.\nCheck your Browserslist config to be sure that your targets are set up correctly.\n\n  Learn more at:\n  https://github.com/postcss/autoprefixer#readme\n  https://github.com/browserslist/browserslist#readme\n\n"
      );
    }
    module2.exports = plugin;
    function plugin(...reqs) {
      let options;
      if (reqs.length === 1 && isPlainObject(reqs[0])) {
        options = reqs[0];
        reqs = void 0;
      } else if (reqs.length === 0 || reqs.length === 1 && !reqs[0]) {
        reqs = void 0;
      } else if (reqs.length <= 2 && (Array.isArray(reqs[0]) || !reqs[0])) {
        options = reqs[1];
        reqs = reqs[0];
      } else if (typeof reqs[reqs.length - 1] === "object") {
        options = reqs.pop();
      }
      if (!options) {
        options = {};
      }
      if (options.browser) {
        throw new Error(
          "Change `browser` option to `overrideBrowserslist` in Autoprefixer"
        );
      } else if (options.browserslist) {
        throw new Error(
          "Change `browserslist` option to `overrideBrowserslist` in Autoprefixer"
        );
      }
      if (options.overrideBrowserslist) {
        reqs = options.overrideBrowserslist;
      } else if (options.browsers) {
        if (typeof console !== "undefined" && console.warn) {
          console.warn(
            pico.red(WARNING.replace(/`[^`]+`/g, (i) => pico.yellow(i.slice(1, -1))))
          );
        }
        reqs = options.browsers;
      }
      let brwlstOpts = {
        ignoreUnknownVersions: options.ignoreUnknownVersions,
        stats: options.stats,
        env: options.env
      };
      function loadPrefixes(opts) {
        let d = autoprefixerData;
        let browsers = new Browsers(d.browsers, reqs, opts, brwlstOpts);
        let key = browsers.selected.join(", ") + JSON.stringify(options);
        if (!cache.has(key)) {
          cache.set(key, new Prefixes(d.prefixes, browsers, options));
        }
        return cache.get(key);
      }
      return {
        postcssPlugin: "autoprefixer",
        prepare(result) {
          let prefixes = loadPrefixes({
            from: result.opts.from,
            env: options.env
          });
          return {
            OnceExit(root) {
              timeCapsule(result, prefixes);
              if (options.remove !== false) {
                prefixes.processor.remove(root, result);
              }
              if (options.add !== false) {
                prefixes.processor.add(root, result);
              }
            }
          };
        },
        info(opts) {
          opts = opts || {};
          opts.from = opts.from || process.cwd();
          return getInfo(loadPrefixes(opts));
        },
        options,
        browsers: reqs
      };
    }
    plugin.postcss = true;
    plugin.data = autoprefixerData;
    plugin.defaults = browserslist.defaults;
    plugin.info = () => plugin().info();
  }
});

// node_modules/lilconfig/dist/index.js
var require_dist = __commonJS({
  "node_modules/lilconfig/dist/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.lilconfigSync = exports2.lilconfig = exports2.defaultLoaders = void 0;
    var path = require("path");
    var fs = require("fs");
    var os = require("os");
    var fsReadFileAsync = fs.promises.readFile;
    function getDefaultSearchPlaces(name) {
      return [
        "package.json",
        `.${name}rc.json`,
        `.${name}rc.js`,
        `.${name}rc.cjs`,
        `.config/${name}rc`,
        `.config/${name}rc.json`,
        `.config/${name}rc.js`,
        `.config/${name}rc.cjs`,
        `${name}.config.js`,
        `${name}.config.cjs`
      ];
    }
    function getSearchPaths(startDir, stopDir) {
      return startDir.split(path.sep).reduceRight((acc, _, ind, arr) => {
        const currentPath = arr.slice(0, ind + 1).join(path.sep);
        if (!acc.passedStopDir)
          acc.searchPlaces.push(currentPath || path.sep);
        if (currentPath === stopDir)
          acc.passedStopDir = true;
        return acc;
      }, { searchPlaces: [], passedStopDir: false }).searchPlaces;
    }
    exports2.defaultLoaders = Object.freeze({
      ".js": require,
      ".json": require,
      ".cjs": require,
      noExt(_, content) {
        return JSON.parse(content);
      }
    });
    function getExtDesc(ext) {
      return ext === "noExt" ? "files without extensions" : `extension "${ext}"`;
    }
    function getOptions(name, options = {}) {
      const conf = {
        stopDir: os.homedir(),
        searchPlaces: getDefaultSearchPlaces(name),
        ignoreEmptySearchPlaces: true,
        transform: (x) => x,
        packageProp: [name],
        ...options,
        loaders: { ...exports2.defaultLoaders, ...options.loaders }
      };
      conf.searchPlaces.forEach((place) => {
        const key = path.extname(place) || "noExt";
        const loader = conf.loaders[key];
        if (!loader) {
          throw new Error(`No loader specified for ${getExtDesc(key)}, so searchPlaces item "${place}" is invalid`);
        }
        if (typeof loader !== "function") {
          throw new Error(`loader for ${getExtDesc(key)} is not a function (type provided: "${typeof loader}"), so searchPlaces item "${place}" is invalid`);
        }
      });
      return conf;
    }
    function getPackageProp(props, obj) {
      if (typeof props === "string" && props in obj)
        return obj[props];
      return (Array.isArray(props) ? props : props.split(".")).reduce((acc, prop) => acc === void 0 ? acc : acc[prop], obj) || null;
    }
    function getSearchItems(searchPlaces, searchPaths) {
      return searchPaths.reduce((acc, searchPath) => {
        searchPlaces.forEach((sp) => acc.push({
          searchPlace: sp,
          filepath: path.join(searchPath, sp),
          loaderKey: path.extname(sp) || "noExt"
        }));
        return acc;
      }, []);
    }
    function validateFilePath(filepath) {
      if (!filepath)
        throw new Error("load must pass a non-empty string");
    }
    function validateLoader(loader, ext) {
      if (!loader)
        throw new Error(`No loader specified for extension "${ext}"`);
      if (typeof loader !== "function")
        throw new Error("loader is not a function");
    }
    function lilconfig(name, options) {
      const { ignoreEmptySearchPlaces, loaders, packageProp, searchPlaces, stopDir, transform } = getOptions(name, options);
      return {
        async search(searchFrom = process.cwd()) {
          const searchPaths = getSearchPaths(searchFrom, stopDir);
          const result = {
            config: null,
            filepath: ""
          };
          const searchItems = getSearchItems(searchPlaces, searchPaths);
          for (const { searchPlace, filepath, loaderKey } of searchItems) {
            try {
              await fs.promises.access(filepath);
            } catch (_a) {
              continue;
            }
            const content = String(await fsReadFileAsync(filepath));
            const loader = loaders[loaderKey];
            if (searchPlace === "package.json") {
              const pkg = await loader(filepath, content);
              const maybeConfig = getPackageProp(packageProp, pkg);
              if (maybeConfig != null) {
                result.config = maybeConfig;
                result.filepath = filepath;
                break;
              }
              continue;
            }
            const isEmpty = content.trim() === "";
            if (isEmpty && ignoreEmptySearchPlaces)
              continue;
            if (isEmpty) {
              result.isEmpty = true;
              result.config = void 0;
            } else {
              validateLoader(loader, loaderKey);
              result.config = await loader(filepath, content);
            }
            result.filepath = filepath;
            break;
          }
          if (result.filepath === "" && result.config === null)
            return transform(null);
          return transform(result);
        },
        async load(filepath) {
          validateFilePath(filepath);
          const absPath = path.resolve(process.cwd(), filepath);
          const { base, ext } = path.parse(absPath);
          const loaderKey = ext || "noExt";
          const loader = loaders[loaderKey];
          validateLoader(loader, loaderKey);
          const content = String(await fsReadFileAsync(absPath));
          if (base === "package.json") {
            const pkg = await loader(absPath, content);
            return transform({
              config: getPackageProp(packageProp, pkg),
              filepath: absPath
            });
          }
          const result = {
            config: null,
            filepath: absPath
          };
          const isEmpty = content.trim() === "";
          if (isEmpty && ignoreEmptySearchPlaces)
            return transform({
              config: void 0,
              filepath: absPath,
              isEmpty: true
            });
          result.config = isEmpty ? void 0 : await loader(absPath, content);
          return transform(isEmpty ? { ...result, isEmpty, config: void 0 } : result);
        }
      };
    }
    exports2.lilconfig = lilconfig;
    function lilconfigSync(name, options) {
      const { ignoreEmptySearchPlaces, loaders, packageProp, searchPlaces, stopDir, transform } = getOptions(name, options);
      return {
        search(searchFrom = process.cwd()) {
          const searchPaths = getSearchPaths(searchFrom, stopDir);
          const result = {
            config: null,
            filepath: ""
          };
          const searchItems = getSearchItems(searchPlaces, searchPaths);
          for (const { searchPlace, filepath, loaderKey } of searchItems) {
            try {
              fs.accessSync(filepath);
            } catch (_a) {
              continue;
            }
            const loader = loaders[loaderKey];
            const content = String(fs.readFileSync(filepath));
            if (searchPlace === "package.json") {
              const pkg = loader(filepath, content);
              const maybeConfig = getPackageProp(packageProp, pkg);
              if (maybeConfig != null) {
                result.config = maybeConfig;
                result.filepath = filepath;
                break;
              }
              continue;
            }
            const isEmpty = content.trim() === "";
            if (isEmpty && ignoreEmptySearchPlaces)
              continue;
            if (isEmpty) {
              result.isEmpty = true;
              result.config = void 0;
            } else {
              validateLoader(loader, loaderKey);
              result.config = loader(filepath, content);
            }
            result.filepath = filepath;
            break;
          }
          if (result.filepath === "" && result.config === null)
            return transform(null);
          return transform(result);
        },
        load(filepath) {
          validateFilePath(filepath);
          const absPath = path.resolve(process.cwd(), filepath);
          const { base, ext } = path.parse(absPath);
          const loaderKey = ext || "noExt";
          const loader = loaders[loaderKey];
          validateLoader(loader, loaderKey);
          const content = String(fs.readFileSync(absPath));
          if (base === "package.json") {
            const pkg = loader(absPath, content);
            return transform({
              config: getPackageProp(packageProp, pkg),
              filepath: absPath
            });
          }
          const result = {
            config: null,
            filepath: absPath
          };
          const isEmpty = content.trim() === "";
          if (isEmpty && ignoreEmptySearchPlaces)
            return transform({
              filepath: absPath,
              config: void 0,
              isEmpty: true
            });
          result.config = isEmpty ? void 0 : loader(absPath, content);
          return transform(isEmpty ? { ...result, isEmpty, config: void 0 } : result);
        }
      };
    }
    exports2.lilconfigSync = lilconfigSync;
  }
});

// node_modules/css-declaration-sorter/dist/main.cjs
var require_main = __commonJS({
  "node_modules/css-declaration-sorter/dist/main.cjs"(exports2, module2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var shorthandData = {
      "animation": [
        "animation-name",
        "animation-duration",
        "animation-timing-function",
        "animation-delay",
        "animation-iteration-count",
        "animation-direction",
        "animation-fill-mode",
        "animation-play-state"
      ],
      "background": [
        "background-image",
        "background-size",
        "background-position",
        "background-repeat",
        "background-origin",
        "background-clip",
        "background-attachment",
        "background-color"
      ],
      "columns": [
        "column-width",
        "column-count"
      ],
      "column-rule": [
        "column-rule-width",
        "column-rule-style",
        "column-rule-color"
      ],
      "flex": [
        "flex-grow",
        "flex-shrink",
        "flex-basis"
      ],
      "flex-flow": [
        "flex-direction",
        "flex-wrap"
      ],
      "font": [
        "font-style",
        "font-variant",
        "font-weight",
        "font-stretch",
        "font-size",
        "font-family",
        "line-height"
      ],
      "grid": [
        "grid-template-rows",
        "grid-template-columns",
        "grid-template-areas",
        "grid-auto-rows",
        "grid-auto-columns",
        "grid-auto-flow",
        "column-gap",
        "row-gap"
      ],
      "grid-area": [
        "grid-row-start",
        "grid-column-start",
        "grid-row-end",
        "grid-column-end"
      ],
      "grid-column": [
        "grid-column-start",
        "grid-column-end"
      ],
      "grid-row": [
        "grid-row-start",
        "grid-row-end"
      ],
      "grid-template": [
        "grid-template-columns",
        "grid-template-rows",
        "grid-template-areas"
      ],
      "list-style": [
        "list-style-type",
        "list-style-position",
        "list-style-image"
      ],
      "padding": [
        "padding-block",
        "padding-block-start",
        "padding-block-end",
        "padding-inline",
        "padding-inline-start",
        "padding-inline-end",
        "padding-top",
        "padding-right",
        "padding-bottom",
        "padding-left"
      ],
      "padding-block": [
        "padding-block-start",
        "padding-block-end",
        "padding-top",
        "padding-right",
        "padding-bottom",
        "padding-left"
      ],
      "padding-block-start": [
        "padding-top",
        "padding-right",
        "padding-left"
      ],
      "padding-block-end": [
        "padding-right",
        "padding-bottom",
        "padding-left"
      ],
      "padding-inline": [
        "padding-inline-start",
        "padding-inline-end",
        "padding-top",
        "padding-right",
        "padding-bottom",
        "padding-left"
      ],
      "padding-inline-start": [
        "padding-top",
        "padding-right",
        "padding-left"
      ],
      "padding-inline-end": [
        "padding-right",
        "padding-bottom",
        "padding-left"
      ],
      "margin": [
        "margin-block",
        "margin-block-start",
        "margin-block-end",
        "margin-inline",
        "margin-inline-start",
        "margin-inline-end",
        "margin-top",
        "margin-right",
        "margin-bottom",
        "margin-left"
      ],
      "margin-block": [
        "margin-block-start",
        "margin-block-end",
        "margin-top",
        "margin-right",
        "margin-bottom",
        "margin-left"
      ],
      "margin-inline": [
        "margin-inline-start",
        "margin-inline-end",
        "margin-top",
        "margin-right",
        "margin-bottom",
        "margin-left"
      ],
      "margin-inline-start": [
        "margin-top",
        "margin-right",
        "margin-bottom",
        "margin-left"
      ],
      "margin-inline-end": [
        "margin-top",
        "margin-right",
        "margin-bottom",
        "margin-left"
      ],
      "border": [
        "border-top",
        "border-right",
        "border-bottom",
        "border-left",
        "border-width",
        "border-style",
        "border-color",
        "border-top-width",
        "border-right-width",
        "border-bottom-width",
        "border-left-width",
        "border-inline-start-width",
        "border-inline-end-width",
        "border-block-start-width",
        "border-block-end-width",
        "border-top-style",
        "border-right-style",
        "border-bottom-style",
        "border-left-style",
        "border-inline-start-style",
        "border-inline-end-style",
        "border-block-start-style",
        "border-block-end-style",
        "border-top-color",
        "border-right-color",
        "border-bottom-color",
        "border-left-color",
        "border-inline-start-color",
        "border-inline-end-color",
        "border-block-start-color",
        "border-block-end-color",
        "border-block",
        "border-block-start",
        "border-block-end",
        "border-block-width",
        "border-block-style",
        "border-block-color",
        "border-inline",
        "border-inline-start",
        "border-inline-end",
        "border-inline-width",
        "border-inline-style",
        "border-inline-color"
      ],
      "border-top": [
        "border-width",
        "border-style",
        "border-color",
        "border-top-width",
        "border-top-style",
        "border-top-color"
      ],
      "border-right": [
        "border-width",
        "border-style",
        "border-color",
        "border-right-width",
        "border-right-style",
        "border-right-color"
      ],
      "border-bottom": [
        "border-width",
        "border-style",
        "border-color",
        "border-bottom-width",
        "border-bottom-style",
        "border-bottom-color"
      ],
      "border-left": [
        "border-width",
        "border-style",
        "border-color",
        "border-left-width",
        "border-left-style",
        "border-left-color"
      ],
      "border-color": [
        "border-top-color",
        "border-bottom-color",
        "border-left-color",
        "border-right-color",
        "border-inline-start-color",
        "border-inline-end-color",
        "border-block-start-color",
        "border-block-end-color"
      ],
      "border-width": [
        "border-top-width",
        "border-bottom-width",
        "border-left-width",
        "border-right-width",
        "border-inline-start-width",
        "border-inline-end-width",
        "border-block-start-width",
        "border-block-end-width"
      ],
      "border-style": [
        "border-top-style",
        "border-bottom-style",
        "border-left-style",
        "border-right-style",
        "border-inline-start-style",
        "border-inline-end-style",
        "border-block-start-style",
        "border-block-end-style"
      ],
      "border-radius": [
        "border-top-right-radius",
        "border-top-left-radius",
        "border-bottom-right-radius",
        "border-bottom-left-radius"
      ],
      "border-block": [
        "border-block-start",
        "border-block-end",
        "border-block-width",
        "border-width",
        "border-block-style",
        "border-style",
        "border-block-color",
        "border-color"
      ],
      "border-block-start": [
        "border-block-start-width",
        "border-width",
        "border-block-start-style",
        "border-style",
        "border-block-start-color",
        "border-color"
      ],
      "border-block-end": [
        "border-block-end-width",
        "border-width",
        "border-block-end-style",
        "border-style",
        "border-block-end-color",
        "border-color"
      ],
      "border-inline": [
        "border-inline-start",
        "border-inline-end",
        "border-inline-width",
        "border-width",
        "border-inline-style",
        "border-style",
        "border-inline-color",
        "border-color"
      ],
      "border-inline-start": [
        "border-inline-start-width",
        "border-width",
        "border-inline-start-style",
        "border-style",
        "border-inline-start-color",
        "border-color"
      ],
      "border-inline-end": [
        "border-inline-end-width",
        "border-width",
        "border-inline-end-style",
        "border-style",
        "border-inline-end-color",
        "border-color"
      ],
      "border-image": [
        "border-image-source",
        "border-image-slice",
        "border-image-width",
        "border-image-outset",
        "border-image-repeat"
      ],
      "mask": [
        "mask-image",
        "mask-mode",
        "mask-position",
        "mask-size",
        "mask-repeat",
        "mask-origin",
        "mask-clip",
        "mask-composite"
      ],
      "inline-size": [
        "width",
        "height"
      ],
      "block-size": [
        "width",
        "height"
      ],
      "max-inline-size": [
        "max-width",
        "max-height"
      ],
      "max-block-size": [
        "max-width",
        "max-height"
      ],
      "inset": [
        "inset-block",
        "inset-block-start",
        "inset-block-end",
        "inset-inline",
        "inset-inline-start",
        "inset-inline-end",
        "top",
        "right",
        "bottom",
        "left"
      ],
      "inset-block": [
        "inset-block-start",
        "inset-block-end",
        "top",
        "right",
        "bottom",
        "left"
      ],
      "inset-inline": [
        "inset-inline-start",
        "inset-inline-end",
        "top",
        "right",
        "bottom",
        "left"
      ],
      "outline": [
        "outline-color",
        "outline-style",
        "outline-width"
      ],
      "overflow": [
        "overflow-x",
        "overflow-y"
      ],
      "place-content": [
        "align-content",
        "justify-content"
      ],
      "place-items": [
        "align-items",
        "justify-items"
      ],
      "place-self": [
        "align-self",
        "justify-self"
      ],
      "text-decoration": [
        "text-decoration-color",
        "text-decoration-style",
        "text-decoration-line"
      ],
      "transition": [
        "transition-delay",
        "transition-duration",
        "transition-property",
        "transition-timing-function"
      ],
      "text-emphasis": [
        "text-emphasis-style",
        "text-emphasis-color"
      ]
    };
    function bubbleSort(list, comparator) {
      let upperIndex = list.length - 1;
      while (upperIndex > 0) {
        let swapIndex = 0;
        for (let i = 0; i < upperIndex; i += 1) {
          if (comparator(list[i], list[i + 1]) > 0) {
            const temp = list[i + 1];
            list[i + 1] = list[i];
            list[i] = temp;
            swapIndex = i;
          }
        }
        upperIndex = swapIndex;
      }
      return list;
    }
    function __variableDynamicImportRuntime0__(path) {
      switch (path) {
        case "../orders/alphabetical.mjs":
          return Promise.resolve().then(function() {
            return alphabetical;
          });
        case "../orders/concentric-css.mjs":
          return Promise.resolve().then(function() {
            return concentricCss;
          });
        case "../orders/smacss.mjs":
          return Promise.resolve().then(function() {
            return smacss;
          });
        default:
          return new Promise(function(resolve, reject) {
            (typeof queueMicrotask === "function" ? queueMicrotask : setTimeout)(
              reject.bind(null, new Error("Unknown variable dynamic import: " + path))
            );
          });
      }
    }
    var builtInOrders = [
      "alphabetical",
      "concentric-css",
      "smacss"
    ];
    var cssDeclarationSorter = ({ order = "alphabetical", keepOverrides = false } = {}) => ({
      postcssPlugin: "css-declaration-sorter",
      OnceExit(css) {
        let withKeepOverrides = (comparator) => comparator;
        if (keepOverrides) {
          withKeepOverrides = withOverridesComparator(shorthandData);
        }
        if (typeof order === "function") {
          return processCss({ css, comparator: withKeepOverrides(order) });
        }
        if (!builtInOrders.includes(order))
          return Promise.reject(
            Error([
              `Invalid built-in order '${order}' provided.`,
              `Available built-in orders are: ${builtInOrders}`
            ].join("\n"))
          );
        return __variableDynamicImportRuntime0__(`../orders/${order}.mjs`).then(({ properties: properties2 }) => processCss({
          css,
          comparator: withKeepOverrides(orderComparator(properties2))
        }));
      }
    });
    cssDeclarationSorter.postcss = true;
    function processCss({ css, comparator }) {
      const comments = [];
      const rulesCache = [];
      css.walk((node) => {
        const nodes = node.nodes;
        const type = node.type;
        if (type === "comment") {
          const isNewlineNode = node.raws.before && node.raws.before.includes("\n");
          const lastNewlineNode = isNewlineNode && !node.next();
          const onlyNode = !node.prev() && !node.next() || !node.parent;
          if (lastNewlineNode || onlyNode || node.parent.type === "root") {
            return;
          }
          if (isNewlineNode) {
            const pairedNode = node.next() || node.prev();
            if (pairedNode) {
              comments.unshift({
                "comment": node,
                "pairedNode": pairedNode,
                "insertPosition": node.next() ? "Before" : "After"
              });
              node.remove();
            }
          } else {
            const pairedNode = node.prev() || node.next();
            if (pairedNode) {
              comments.push({
                "comment": node,
                "pairedNode": pairedNode,
                "insertPosition": "After"
              });
              node.remove();
            }
          }
          return;
        }
        const isRule = type === "rule" || type === "atrule";
        if (isRule && nodes && nodes.length > 1) {
          rulesCache.push(nodes);
        }
      });
      rulesCache.forEach((nodes) => {
        sortCssDeclarations({ nodes, comparator });
      });
      comments.forEach((node) => {
        const pairedNode = node.pairedNode;
        node.comment.remove();
        pairedNode.parent && pairedNode.parent["insert" + node.insertPosition](pairedNode, node.comment);
      });
    }
    function sortCssDeclarations({ nodes, comparator }) {
      bubbleSort(nodes, (a, b) => {
        if (a.type === "decl" && b.type === "decl") {
          return comparator(a.prop, b.prop);
        } else {
          return compareDifferentType(a, b);
        }
      });
    }
    function withOverridesComparator(shorthandData2) {
      return function(comparator) {
        return function(a, b) {
          a = removeVendorPrefix(a);
          b = removeVendorPrefix(b);
          if (shorthandData2[a] && shorthandData2[a].includes(b))
            return 0;
          if (shorthandData2[b] && shorthandData2[b].includes(a))
            return 0;
          return comparator(a, b);
        };
      };
    }
    function orderComparator(order) {
      return function(a, b) {
        return order.indexOf(a) - order.indexOf(b);
      };
    }
    function compareDifferentType(a, b) {
      if (b.type === "atrule" || a.type === "atrule") {
        return 0;
      }
      return a.type === "decl" ? -1 : b.type === "decl" ? 1 : 0;
    }
    function removeVendorPrefix(property) {
      return property.replace(/^-\w+-/, "");
    }
    var properties$2 = [
      "all",
      "-webkit-line-clamp",
      "-webkit-text-fill-color",
      "-webkit-text-stroke",
      "-webkit-text-stroke-color",
      "-webkit-text-stroke-width",
      "accent-color",
      "align-content",
      "align-items",
      "align-self",
      "animation",
      "animation-delay",
      "animation-direction",
      "animation-duration",
      "animation-fill-mode",
      "animation-iteration-count",
      "animation-name",
      "animation-play-state",
      "animation-timing-function",
      "appearance",
      "ascent-override",
      "aspect-ratio",
      "backdrop-filter",
      "backface-visibility",
      "background",
      "background-attachment",
      "background-blend-mode",
      "background-clip",
      "background-color",
      "background-image",
      "background-origin",
      "background-position",
      "background-position-x",
      "background-position-y",
      "background-repeat",
      "background-size",
      "block-size",
      "border",
      "border-block",
      "border-block-color",
      "border-block-end",
      "border-block-end-color",
      "border-block-end-style",
      "border-block-end-width",
      "border-block-start",
      "border-block-start-color",
      "border-block-start-style",
      "border-block-start-width",
      "border-block-style",
      "border-block-width",
      "border-bottom",
      "border-bottom-color",
      "border-bottom-left-radius",
      "border-bottom-right-radius",
      "border-bottom-style",
      "border-bottom-width",
      "border-collapse",
      "border-color",
      "border-end-end-radius",
      "border-end-start-radius",
      "border-image",
      "border-image-outset",
      "border-image-repeat",
      "border-image-slice",
      "border-image-source",
      "border-image-width",
      "border-inline",
      "border-inline-color",
      "border-inline-end",
      "border-inline-end-color",
      "border-inline-end-style",
      "border-inline-end-width",
      "border-inline-start",
      "border-inline-start-color",
      "border-inline-start-style",
      "border-inline-start-width",
      "border-inline-style",
      "border-inline-width",
      "border-left",
      "border-left-color",
      "border-left-style",
      "border-left-width",
      "border-radius",
      "border-right",
      "border-right-color",
      "border-right-style",
      "border-right-width",
      "border-spacing",
      "border-start-end-radius",
      "border-start-start-radius",
      "border-style",
      "border-top",
      "border-top-color",
      "border-top-left-radius",
      "border-top-right-radius",
      "border-top-style",
      "border-top-width",
      "border-width",
      "bottom",
      "box-decoration-break",
      "box-shadow",
      "box-sizing",
      "break-after",
      "break-before",
      "break-inside",
      "caption-side",
      "caret-color",
      "clear",
      "clip-path",
      "color",
      "color-scheme",
      "column-count",
      "column-fill",
      "column-gap",
      "column-rule",
      "column-rule-color",
      "column-rule-style",
      "column-rule-width",
      "column-span",
      "column-width",
      "columns",
      "contain",
      "contain-intrinsic-height",
      "contain-intrinsic-size",
      "contain-intrinsic-width",
      "container",
      "container-name",
      "container-type",
      "content",
      "content-visibility",
      "counter-increment",
      "counter-reset",
      "counter-set",
      "cursor",
      "descent-override",
      "direction",
      "display",
      "empty-cells",
      "filter",
      "flex",
      "flex-basis",
      "flex-direction",
      "flex-flow",
      "flex-grow",
      "flex-shrink",
      "flex-wrap",
      "float",
      "font",
      "font-display",
      "font-family",
      "font-kerning",
      "font-language-override",
      "font-optical-sizing",
      "font-palette",
      "font-size",
      "font-size-adjust",
      "font-stretch",
      "font-style",
      "font-synthesis",
      "font-variant",
      "font-variant-alternates",
      "font-variant-caps",
      "font-variant-east-asian",
      "font-variant-emoji",
      "font-variant-ligatures",
      "font-variant-numeric",
      "font-variant-position",
      "font-variation-settings",
      "font-weight",
      "forced-color-adjust",
      "gap",
      "grid",
      "grid-area",
      "grid-auto-columns",
      "grid-auto-flow",
      "grid-auto-rows",
      "grid-column",
      "grid-column-end",
      "grid-column-start",
      "grid-row",
      "grid-row-end",
      "grid-row-start",
      "grid-template",
      "grid-template-areas",
      "grid-template-columns",
      "grid-template-rows",
      "hanging-punctuation",
      "height",
      "hyphenate-character",
      "hyphens",
      "image-orientation",
      "image-rendering",
      "inline-size",
      "inset",
      "inset-block",
      "inset-block-end",
      "inset-block-start",
      "inset-inline",
      "inset-inline-end",
      "inset-inline-start",
      "isolation",
      "justify-content",
      "justify-items",
      "justify-self",
      "left",
      "letter-spacing",
      "line-break",
      "line-gap-override",
      "line-height",
      "list-style",
      "list-style-image",
      "list-style-position",
      "list-style-type",
      "margin",
      "margin-block",
      "margin-block-end",
      "margin-block-start",
      "margin-bottom",
      "margin-inline",
      "margin-inline-end",
      "margin-inline-start",
      "margin-left",
      "margin-right",
      "margin-top",
      "mask",
      "mask-border",
      "mask-border-outset",
      "mask-border-repeat",
      "mask-border-slice",
      "mask-border-source",
      "mask-border-width",
      "mask-clip",
      "mask-composite",
      "mask-image",
      "mask-mode",
      "mask-origin",
      "mask-position",
      "mask-repeat",
      "mask-size",
      "mask-type",
      "max-block-size",
      "max-height",
      "max-inline-size",
      "max-width",
      "min-block-size",
      "min-height",
      "min-inline-size",
      "min-width",
      "mix-blend-mode",
      "object-fit",
      "object-position",
      "offset",
      "offset-anchor",
      "offset-distance",
      "offset-path",
      "offset-rotate",
      "opacity",
      "order",
      "orphans",
      "outline",
      "outline-color",
      "outline-offset",
      "outline-style",
      "outline-width",
      "overflow",
      "overflow-anchor",
      "overflow-block",
      "overflow-clip-margin",
      "overflow-inline",
      "overflow-wrap",
      "overflow-x",
      "overflow-y",
      "overscroll-behavior",
      "overscroll-behavior-block",
      "overscroll-behavior-inline",
      "overscroll-behavior-x",
      "overscroll-behavior-y",
      "padding",
      "padding-block",
      "padding-block-end",
      "padding-block-start",
      "padding-bottom",
      "padding-inline",
      "padding-inline-end",
      "padding-inline-start",
      "padding-left",
      "padding-right",
      "padding-top",
      "page",
      "page-break-after",
      "page-break-before",
      "page-break-inside",
      "paint-order",
      "perspective",
      "perspective-origin",
      "place-content",
      "place-items",
      "place-self",
      "pointer-events",
      "position",
      "print-color-adjust",
      "quotes",
      "resize",
      "right",
      "rotate",
      "row-gap",
      "ruby-position",
      "scale",
      "scroll-behavior",
      "scroll-margin",
      "scroll-margin-block",
      "scroll-margin-block-end",
      "scroll-margin-block-start",
      "scroll-margin-bottom",
      "scroll-margin-inline",
      "scroll-margin-inline-end",
      "scroll-margin-inline-start",
      "scroll-margin-left",
      "scroll-margin-right",
      "scroll-margin-top",
      "scroll-padding",
      "scroll-padding-block",
      "scroll-padding-block-end",
      "scroll-padding-block-start",
      "scroll-padding-bottom",
      "scroll-padding-inline",
      "scroll-padding-inline-end",
      "scroll-padding-inline-start",
      "scroll-padding-left",
      "scroll-padding-right",
      "scroll-padding-top",
      "scroll-snap-align",
      "scroll-snap-stop",
      "scroll-snap-type",
      "scrollbar-color",
      "scrollbar-gutter",
      "scrollbar-width",
      "shape-image-threshold",
      "shape-margin",
      "shape-outside",
      "size-adjust",
      "src",
      "tab-size",
      "table-layout",
      "text-align",
      "text-align-last",
      "text-combine-upright",
      "text-decoration",
      "text-decoration-color",
      "text-decoration-line",
      "text-decoration-skip-ink",
      "text-decoration-style",
      "text-decoration-thickness",
      "text-emphasis",
      "text-emphasis-color",
      "text-emphasis-position",
      "text-emphasis-style",
      "text-indent",
      "text-justify",
      "text-orientation",
      "text-overflow",
      "text-rendering",
      "text-shadow",
      "text-transform",
      "text-underline-offset",
      "text-underline-position",
      "top",
      "touch-action",
      "transform",
      "transform-box",
      "transform-origin",
      "transform-style",
      "transition",
      "transition-delay",
      "transition-duration",
      "transition-property",
      "transition-timing-function",
      "translate",
      "unicode-bidi",
      "unicode-range",
      "user-select",
      "vertical-align",
      "visibility",
      "white-space",
      "widows",
      "width",
      "will-change",
      "word-break",
      "word-spacing",
      "writing-mode",
      "z-index"
    ];
    var alphabetical = /* @__PURE__ */ Object.freeze({
      __proto__: null,
      properties: properties$2
    });
    var properties$1 = [
      "all",
      "display",
      "position",
      "top",
      "right",
      "bottom",
      "left",
      "offset",
      "offset-anchor",
      "offset-distance",
      "offset-path",
      "offset-rotate",
      "grid",
      "grid-template-rows",
      "grid-template-columns",
      "grid-template-areas",
      "grid-auto-rows",
      "grid-auto-columns",
      "grid-auto-flow",
      "column-gap",
      "row-gap",
      "grid-area",
      "grid-row",
      "grid-row-start",
      "grid-row-end",
      "grid-column",
      "grid-column-start",
      "grid-column-end",
      "grid-template",
      "flex",
      "flex-grow",
      "flex-shrink",
      "flex-basis",
      "flex-direction",
      "flex-flow",
      "flex-wrap",
      "box-decoration-break",
      "place-content",
      "align-content",
      "justify-content",
      "place-items",
      "align-items",
      "justify-items",
      "place-self",
      "align-self",
      "justify-self",
      "vertical-align",
      "order",
      "float",
      "clear",
      "shape-margin",
      "shape-outside",
      "shape-image-threshold",
      "orphans",
      "gap",
      "columns",
      "column-fill",
      "column-rule",
      "column-rule-width",
      "column-rule-style",
      "column-rule-color",
      "column-width",
      "column-span",
      "column-count",
      "break-before",
      "break-after",
      "break-inside",
      "page",
      "page-break-before",
      "page-break-after",
      "page-break-inside",
      "transform",
      "transform-box",
      "transform-origin",
      "transform-style",
      "translate",
      "rotate",
      "scale",
      "perspective",
      "perspective-origin",
      "appearance",
      "visibility",
      "content-visibility",
      "opacity",
      "z-index",
      "paint-order",
      "mix-blend-mode",
      "backface-visibility",
      "backdrop-filter",
      "clip-path",
      "mask",
      "mask-border",
      "mask-border-outset",
      "mask-border-repeat",
      "mask-border-slice",
      "mask-border-source",
      "mask-border-width",
      "mask-image",
      "mask-mode",
      "mask-position",
      "mask-size",
      "mask-repeat",
      "mask-origin",
      "mask-clip",
      "mask-composite",
      "mask-type",
      "filter",
      "animation",
      "animation-duration",
      "animation-timing-function",
      "animation-delay",
      "animation-iteration-count",
      "animation-direction",
      "animation-fill-mode",
      "animation-play-state",
      "animation-name",
      "transition",
      "transition-delay",
      "transition-duration",
      "transition-property",
      "transition-timing-function",
      "will-change",
      "counter-increment",
      "counter-reset",
      "counter-set",
      "cursor",
      "box-sizing",
      "contain",
      "contain-intrinsic-height",
      "contain-intrinsic-size",
      "contain-intrinsic-width",
      "container",
      "container-name",
      "container-type",
      "margin",
      "margin-top",
      "margin-right",
      "margin-bottom",
      "margin-left",
      "margin-inline",
      "margin-inline-start",
      "margin-inline-end",
      "margin-block",
      "margin-block-start",
      "margin-block-end",
      "inset",
      "inset-block",
      "inset-block-end",
      "inset-block-start",
      "inset-inline",
      "inset-inline-end",
      "inset-inline-start",
      "outline",
      "outline-color",
      "outline-style",
      "outline-width",
      "outline-offset",
      "box-shadow",
      "border",
      "border-top",
      "border-right",
      "border-bottom",
      "border-left",
      "border-width",
      "border-top-width",
      "border-right-width",
      "border-bottom-width",
      "border-left-width",
      "border-style",
      "border-top-style",
      "border-right-style",
      "border-bottom-style",
      "border-left-style",
      "border-color",
      "border-top-color",
      "border-right-color",
      "border-bottom-color",
      "border-left-color",
      "border-radius",
      "border-top-right-radius",
      "border-top-left-radius",
      "border-bottom-right-radius",
      "border-bottom-left-radius",
      "border-inline",
      "border-inline-width",
      "border-inline-style",
      "border-inline-color",
      "border-inline-start",
      "border-inline-start-width",
      "border-inline-start-style",
      "border-inline-start-color",
      "border-inline-end",
      "border-inline-end-width",
      "border-inline-end-style",
      "border-inline-end-color",
      "border-block",
      "border-block-width",
      "border-block-style",
      "border-block-color",
      "border-block-start",
      "border-block-start-width",
      "border-block-start-style",
      "border-block-start-color",
      "border-block-end",
      "border-block-end-width",
      "border-block-end-style",
      "border-block-end-color",
      "border-image",
      "border-image-source",
      "border-image-slice",
      "border-image-width",
      "border-image-outset",
      "border-image-repeat",
      "border-collapse",
      "border-spacing",
      "border-start-start-radius",
      "border-start-end-radius",
      "border-end-start-radius",
      "border-end-end-radius",
      "background",
      "background-image",
      "background-position",
      "background-size",
      "background-repeat",
      "background-origin",
      "background-clip",
      "background-attachment",
      "background-color",
      "background-blend-mode",
      "background-position-x",
      "background-position-y",
      "isolation",
      "padding",
      "padding-top",
      "padding-right",
      "padding-bottom",
      "padding-left",
      "padding-inline",
      "padding-inline-start",
      "padding-inline-end",
      "padding-block",
      "padding-block-start",
      "padding-block-end",
      "image-orientation",
      "image-rendering",
      "aspect-ratio",
      "width",
      "min-width",
      "max-width",
      "height",
      "min-height",
      "max-height",
      "-webkit-line-clamp",
      "-webkit-text-fill-color",
      "-webkit-text-stroke",
      "-webkit-text-stroke-color",
      "-webkit-text-stroke-width",
      "inline-size",
      "min-inline-size",
      "max-inline-size",
      "block-size",
      "min-block-size",
      "max-block-size",
      "table-layout",
      "caption-side",
      "empty-cells",
      "overflow",
      "overflow-anchor",
      "overflow-block",
      "overflow-clip-margin",
      "overflow-inline",
      "overflow-x",
      "overflow-y",
      "overscroll-behavior",
      "overscroll-behavior-block",
      "overscroll-behavior-inline",
      "overscroll-behavior-x",
      "overscroll-behavior-y",
      "resize",
      "object-fit",
      "object-position",
      "scroll-behavior",
      "scroll-margin",
      "scroll-margin-block",
      "scroll-margin-block-end",
      "scroll-margin-block-start",
      "scroll-margin-bottom",
      "scroll-margin-inline",
      "scroll-margin-inline-end",
      "scroll-margin-inline-start",
      "scroll-margin-left",
      "scroll-margin-right",
      "scroll-margin-top",
      "scroll-padding",
      "scroll-padding-block",
      "scroll-padding-block-end",
      "scroll-padding-block-start",
      "scroll-padding-bottom",
      "scroll-padding-inline",
      "scroll-padding-inline-end",
      "scroll-padding-inline-start",
      "scroll-padding-left",
      "scroll-padding-right",
      "scroll-padding-top",
      "scroll-snap-align",
      "scroll-snap-stop",
      "scroll-snap-type",
      "scrollbar-color",
      "scrollbar-gutter",
      "scrollbar-width",
      "touch-action",
      "pointer-events",
      "content",
      "quotes",
      "hanging-punctuation",
      "color",
      "accent-color",
      "print-color-adjust",
      "forced-color-adjust",
      "color-scheme",
      "caret-color",
      "font",
      "font-style",
      "font-variant",
      "font-weight",
      "font-stretch",
      "font-size",
      "size-adjust",
      "line-height",
      "src",
      "font-family",
      "font-display",
      "font-kerning",
      "font-language-override",
      "font-optical-sizing",
      "font-palette",
      "font-size-adjust",
      "font-synthesis",
      "font-variant-alternates",
      "font-variant-caps",
      "font-variant-east-asian",
      "font-variant-emoji",
      "font-variant-ligatures",
      "font-variant-numeric",
      "font-variant-position",
      "font-variation-settings",
      "ascent-override",
      "descent-override",
      "line-gap-override",
      "hyphens",
      "hyphenate-character",
      "letter-spacing",
      "line-break",
      "list-style",
      "list-style-type",
      "list-style-image",
      "list-style-position",
      "writing-mode",
      "direction",
      "unicode-bidi",
      "unicode-range",
      "user-select",
      "ruby-position",
      "text-combine-upright",
      "text-align",
      "text-align-last",
      "text-decoration",
      "text-decoration-line",
      "text-decoration-style",
      "text-decoration-color",
      "text-decoration-thickness",
      "text-decoration-skip-ink",
      "text-emphasis",
      "text-emphasis-style",
      "text-emphasis-color",
      "text-emphasis-position",
      "text-indent",
      "text-justify",
      "text-underline-position",
      "text-underline-offset",
      "text-orientation",
      "text-overflow",
      "text-rendering",
      "text-shadow",
      "text-transform",
      "white-space",
      "word-break",
      "word-spacing",
      "overflow-wrap",
      "tab-size",
      "widows"
    ];
    var concentricCss = /* @__PURE__ */ Object.freeze({
      __proto__: null,
      properties: properties$1
    });
    var properties = [
      "all",
      "box-sizing",
      "contain",
      "contain-intrinsic-height",
      "contain-intrinsic-size",
      "contain-intrinsic-width",
      "container",
      "container-name",
      "container-type",
      "display",
      "appearance",
      "visibility",
      "content-visibility",
      "z-index",
      "paint-order",
      "position",
      "top",
      "right",
      "bottom",
      "left",
      "offset",
      "offset-anchor",
      "offset-distance",
      "offset-path",
      "offset-rotate",
      "grid",
      "grid-template-rows",
      "grid-template-columns",
      "grid-template-areas",
      "grid-auto-rows",
      "grid-auto-columns",
      "grid-auto-flow",
      "column-gap",
      "row-gap",
      "grid-area",
      "grid-row",
      "grid-row-start",
      "grid-row-end",
      "grid-column",
      "grid-column-start",
      "grid-column-end",
      "grid-template",
      "flex",
      "flex-grow",
      "flex-shrink",
      "flex-basis",
      "flex-direction",
      "flex-flow",
      "flex-wrap",
      "box-decoration-break",
      "place-content",
      "place-items",
      "place-self",
      "align-content",
      "align-items",
      "align-self",
      "justify-content",
      "justify-items",
      "justify-self",
      "order",
      "aspect-ratio",
      "width",
      "min-width",
      "max-width",
      "height",
      "min-height",
      "max-height",
      "-webkit-line-clamp",
      "-webkit-text-fill-color",
      "-webkit-text-stroke",
      "-webkit-text-stroke-color",
      "-webkit-text-stroke-width",
      "inline-size",
      "min-inline-size",
      "max-inline-size",
      "block-size",
      "min-block-size",
      "max-block-size",
      "margin",
      "margin-top",
      "margin-right",
      "margin-bottom",
      "margin-left",
      "margin-inline",
      "margin-inline-start",
      "margin-inline-end",
      "margin-block",
      "margin-block-start",
      "margin-block-end",
      "inset",
      "inset-block",
      "inset-block-end",
      "inset-block-start",
      "inset-inline",
      "inset-inline-end",
      "inset-inline-start",
      "padding",
      "padding-top",
      "padding-right",
      "padding-bottom",
      "padding-left",
      "padding-inline",
      "padding-inline-start",
      "padding-inline-end",
      "padding-block",
      "padding-block-start",
      "padding-block-end",
      "float",
      "clear",
      "overflow",
      "overflow-anchor",
      "overflow-block",
      "overflow-clip-margin",
      "overflow-inline",
      "overflow-x",
      "overflow-y",
      "overscroll-behavior",
      "overscroll-behavior-block",
      "overscroll-behavior-inline",
      "overscroll-behavior-x",
      "overscroll-behavior-y",
      "orphans",
      "gap",
      "columns",
      "column-fill",
      "column-rule",
      "column-rule-color",
      "column-rule-style",
      "column-rule-width",
      "column-span",
      "column-count",
      "column-width",
      "object-fit",
      "object-position",
      "transform",
      "transform-box",
      "transform-origin",
      "transform-style",
      "translate",
      "rotate",
      "scale",
      "border",
      "border-top",
      "border-right",
      "border-bottom",
      "border-left",
      "border-width",
      "border-top-width",
      "border-right-width",
      "border-bottom-width",
      "border-left-width",
      "border-style",
      "border-top-style",
      "border-right-style",
      "border-bottom-style",
      "border-left-style",
      "border-radius",
      "border-top-right-radius",
      "border-top-left-radius",
      "border-bottom-right-radius",
      "border-bottom-left-radius",
      "border-inline",
      "border-inline-color",
      "border-inline-style",
      "border-inline-width",
      "border-inline-start",
      "border-inline-start-color",
      "border-inline-start-style",
      "border-inline-start-width",
      "border-inline-end",
      "border-inline-end-color",
      "border-inline-end-style",
      "border-inline-end-width",
      "border-block",
      "border-block-color",
      "border-block-style",
      "border-block-width",
      "border-block-start",
      "border-block-start-color",
      "border-block-start-style",
      "border-block-start-width",
      "border-block-end",
      "border-block-end-color",
      "border-block-end-style",
      "border-block-end-width",
      "border-color",
      "border-image",
      "border-image-outset",
      "border-image-repeat",
      "border-image-slice",
      "border-image-source",
      "border-image-width",
      "border-top-color",
      "border-right-color",
      "border-bottom-color",
      "border-left-color",
      "border-collapse",
      "border-spacing",
      "border-start-start-radius",
      "border-start-end-radius",
      "border-end-start-radius",
      "border-end-end-radius",
      "outline",
      "outline-color",
      "outline-style",
      "outline-width",
      "outline-offset",
      "backdrop-filter",
      "backface-visibility",
      "background",
      "background-image",
      "background-position",
      "background-size",
      "background-repeat",
      "background-origin",
      "background-clip",
      "background-attachment",
      "background-color",
      "background-blend-mode",
      "background-position-x",
      "background-position-y",
      "box-shadow",
      "isolation",
      "content",
      "quotes",
      "hanging-punctuation",
      "color",
      "accent-color",
      "print-color-adjust",
      "forced-color-adjust",
      "color-scheme",
      "caret-color",
      "font",
      "font-style",
      "font-variant",
      "font-weight",
      "src",
      "font-stretch",
      "font-size",
      "size-adjust",
      "line-height",
      "font-family",
      "font-display",
      "font-kerning",
      "font-language-override",
      "font-optical-sizing",
      "font-palette",
      "font-size-adjust",
      "font-synthesis",
      "font-variant-alternates",
      "font-variant-caps",
      "font-variant-east-asian",
      "font-variant-emoji",
      "font-variant-ligatures",
      "font-variant-numeric",
      "font-variant-position",
      "font-variation-settings",
      "ascent-override",
      "descent-override",
      "line-gap-override",
      "hyphens",
      "hyphenate-character",
      "letter-spacing",
      "line-break",
      "list-style",
      "list-style-image",
      "list-style-position",
      "list-style-type",
      "direction",
      "text-align",
      "text-align-last",
      "text-decoration",
      "text-decoration-line",
      "text-decoration-style",
      "text-decoration-color",
      "text-decoration-thickness",
      "text-decoration-skip-ink",
      "text-emphasis",
      "text-emphasis-style",
      "text-emphasis-color",
      "text-emphasis-position",
      "text-indent",
      "text-justify",
      "text-underline-position",
      "text-underline-offset",
      "text-orientation",
      "text-overflow",
      "text-rendering",
      "text-shadow",
      "text-transform",
      "vertical-align",
      "white-space",
      "word-break",
      "word-spacing",
      "overflow-wrap",
      "animation",
      "animation-duration",
      "animation-timing-function",
      "animation-delay",
      "animation-iteration-count",
      "animation-direction",
      "animation-fill-mode",
      "animation-play-state",
      "animation-name",
      "mix-blend-mode",
      "break-before",
      "break-after",
      "break-inside",
      "page",
      "page-break-before",
      "page-break-after",
      "page-break-inside",
      "caption-side",
      "clip-path",
      "counter-increment",
      "counter-reset",
      "counter-set",
      "cursor",
      "empty-cells",
      "filter",
      "image-orientation",
      "image-rendering",
      "mask",
      "mask-border",
      "mask-border-outset",
      "mask-border-repeat",
      "mask-border-slice",
      "mask-border-source",
      "mask-border-width",
      "mask-clip",
      "mask-composite",
      "mask-image",
      "mask-mode",
      "mask-origin",
      "mask-position",
      "mask-repeat",
      "mask-size",
      "mask-type",
      "opacity",
      "perspective",
      "perspective-origin",
      "pointer-events",
      "resize",
      "scroll-behavior",
      "scroll-margin",
      "scroll-margin-block",
      "scroll-margin-block-end",
      "scroll-margin-block-start",
      "scroll-margin-bottom",
      "scroll-margin-inline",
      "scroll-margin-inline-end",
      "scroll-margin-inline-start",
      "scroll-margin-left",
      "scroll-margin-right",
      "scroll-margin-top",
      "scroll-padding",
      "scroll-padding-block",
      "scroll-padding-block-end",
      "scroll-padding-block-start",
      "scroll-padding-bottom",
      "scroll-padding-inline",
      "scroll-padding-inline-end",
      "scroll-padding-inline-start",
      "scroll-padding-left",
      "scroll-padding-right",
      "scroll-padding-top",
      "scroll-snap-align",
      "scroll-snap-stop",
      "scroll-snap-type",
      "scrollbar-color",
      "scrollbar-gutter",
      "scrollbar-width",
      "shape-image-threshold",
      "shape-margin",
      "shape-outside",
      "tab-size",
      "table-layout",
      "ruby-position",
      "text-combine-upright",
      "touch-action",
      "transition",
      "transition-delay",
      "transition-duration",
      "transition-property",
      "transition-timing-function",
      "will-change",
      "unicode-bidi",
      "unicode-range",
      "user-select",
      "widows",
      "writing-mode"
    ];
    var smacss = /* @__PURE__ */ Object.freeze({
      __proto__: null,
      properties
    });
    exports2.cssDeclarationSorter = cssDeclarationSorter;
    exports2.default = cssDeclarationSorter;
    module2.exports = cssDeclarationSorter;
  }
});

// node_modules/postcss-discard-comments/src/lib/commentRemover.js
var require_commentRemover = __commonJS({
  "node_modules/postcss-discard-comments/src/lib/commentRemover.js"(exports2, module2) {
    "use strict";
    function CommentRemover(options) {
      this.options = options;
    }
    CommentRemover.prototype.canRemove = function(comment) {
      const remove = this.options.remove;
      if (remove) {
        return remove(comment);
      } else {
        const isImportant = comment.indexOf("!") === 0;
        if (!isImportant) {
          return true;
        }
        if (this.options.removeAll || this._hasFirst) {
          return true;
        } else if (this.options.removeAllButFirst && !this._hasFirst) {
          this._hasFirst = true;
          return false;
        }
      }
    };
    module2.exports = CommentRemover;
  }
});

// node_modules/postcss-discard-comments/src/lib/commentParser.js
var require_commentParser = __commonJS({
  "node_modules/postcss-discard-comments/src/lib/commentParser.js"(exports2, module2) {
    "use strict";
    module2.exports = function commentParser(input) {
      const tokens = [];
      const length = input.length;
      let pos = 0;
      let next;
      while (pos < length) {
        next = input.indexOf("/*", pos);
        if (~next) {
          tokens.push([0, pos, next]);
          pos = next;
          next = input.indexOf("*/", pos + 2);
          tokens.push([1, pos + 2, next]);
          pos = next + 2;
        } else {
          tokens.push([0, pos, length]);
          pos = length;
        }
      }
      return tokens;
    };
  }
});

// node_modules/postcss-discard-comments/src/index.js
var require_src2 = __commonJS({
  "node_modules/postcss-discard-comments/src/index.js"(exports2, module2) {
    "use strict";
    var CommentRemover = require_commentRemover();
    var commentParser = require_commentParser();
    function pluginCreator(opts = {}) {
      const remover = new CommentRemover(opts);
      const matcherCache = /* @__PURE__ */ new Map();
      const replacerCache = /* @__PURE__ */ new Map();
      function matchesComments(source) {
        if (matcherCache.has(source)) {
          return matcherCache.get(source);
        }
        const result = commentParser(source).filter(([type]) => type);
        matcherCache.set(source, result);
        return result;
      }
      function replaceComments(source, space, separator = " ") {
        const key = source + "@|@" + separator;
        if (replacerCache.has(key)) {
          return replacerCache.get(key);
        }
        const parsed = commentParser(source).reduce((value, [type, start, end]) => {
          const contents = source.slice(start, end);
          if (!type) {
            return value + contents;
          }
          if (remover.canRemove(contents)) {
            return value + separator;
          }
          return `${value}/*${contents}*/`;
        }, "");
        const result = space(parsed).join(" ");
        replacerCache.set(key, result);
        return result;
      }
      return {
        postcssPlugin: "postcss-discard-comments",
        OnceExit(css, { list }) {
          css.walk((node) => {
            if (node.type === "comment" && remover.canRemove(node.text)) {
              node.remove();
              return;
            }
            if (typeof node.raws.between === "string") {
              node.raws.between = replaceComments(node.raws.between, list.space);
            }
            if (node.type === "decl") {
              if (node.raws.value && node.raws.value.raw) {
                if (node.raws.value.value === node.value) {
                  node.value = replaceComments(node.raws.value.raw, list.space);
                } else {
                  node.value = replaceComments(node.value, list.space);
                }
                node.raws.value = null;
              }
              if (node.raws.important) {
                node.raws.important = replaceComments(
                  node.raws.important,
                  list.space
                );
                const b = matchesComments(node.raws.important);
                node.raws.important = b.length ? node.raws.important : "!important";
              } else {
                node.value = replaceComments(node.value, list.space);
              }
              return;
            }
            if (node.type === "rule" && node.raws.selector && node.raws.selector.raw) {
              node.raws.selector.raw = replaceComments(
                node.raws.selector.raw,
                list.space,
                ""
              );
              return;
            }
            if (node.type === "atrule") {
              if (node.raws.afterName) {
                const commentsReplaced = replaceComments(
                  node.raws.afterName,
                  list.space
                );
                if (!commentsReplaced.length) {
                  node.raws.afterName = commentsReplaced + " ";
                } else {
                  node.raws.afterName = " " + commentsReplaced + " ";
                }
              }
              if (node.raws.params && node.raws.params.raw) {
                node.raws.params.raw = replaceComments(
                  node.raws.params.raw,
                  list.space
                );
              }
            }
          });
        }
      };
    }
    pluginCreator.postcss = true;
    module2.exports = pluginCreator;
  }
});

// node_modules/lodash.memoize/index.js
var require_lodash = __commonJS({
  "node_modules/lodash.memoize/index.js"(exports2, module2) {
    var FUNC_ERROR_TEXT = "Expected a function";
    var HASH_UNDEFINED = "__lodash_hash_undefined__";
    var funcTag = "[object Function]";
    var genTag = "[object GeneratorFunction]";
    var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
    var reIsHostCtor = /^\[object .+?Constructor\]$/;
    var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
    var freeSelf = typeof self == "object" && self && self.Object === Object && self;
    var root = freeGlobal || freeSelf || Function("return this")();
    function getValue(object, key) {
      return object == null ? void 0 : object[key];
    }
    function isHostObject(value) {
      var result = false;
      if (value != null && typeof value.toString != "function") {
        try {
          result = !!(value + "");
        } catch (e) {
        }
      }
      return result;
    }
    var arrayProto = Array.prototype;
    var funcProto = Function.prototype;
    var objectProto = Object.prototype;
    var coreJsData = root["__core-js_shared__"];
    var maskSrcKey = function() {
      var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || "");
      return uid ? "Symbol(src)_1." + uid : "";
    }();
    var funcToString = funcProto.toString;
    var hasOwnProperty2 = objectProto.hasOwnProperty;
    var objectToString = objectProto.toString;
    var reIsNative = RegExp(
      "^" + funcToString.call(hasOwnProperty2).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
    );
    var splice = arrayProto.splice;
    var Map2 = getNative(root, "Map");
    var nativeCreate = getNative(Object, "create");
    function Hash(entries) {
      var index = -1, length = entries ? entries.length : 0;
      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    function hashClear() {
      this.__data__ = nativeCreate ? nativeCreate(null) : {};
    }
    function hashDelete(key) {
      return this.has(key) && delete this.__data__[key];
    }
    function hashGet(key) {
      var data = this.__data__;
      if (nativeCreate) {
        var result = data[key];
        return result === HASH_UNDEFINED ? void 0 : result;
      }
      return hasOwnProperty2.call(data, key) ? data[key] : void 0;
    }
    function hashHas(key) {
      var data = this.__data__;
      return nativeCreate ? data[key] !== void 0 : hasOwnProperty2.call(data, key);
    }
    function hashSet(key, value) {
      var data = this.__data__;
      data[key] = nativeCreate && value === void 0 ? HASH_UNDEFINED : value;
      return this;
    }
    Hash.prototype.clear = hashClear;
    Hash.prototype["delete"] = hashDelete;
    Hash.prototype.get = hashGet;
    Hash.prototype.has = hashHas;
    Hash.prototype.set = hashSet;
    function ListCache(entries) {
      var index = -1, length = entries ? entries.length : 0;
      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    function listCacheClear() {
      this.__data__ = [];
    }
    function listCacheDelete(key) {
      var data = this.__data__, index = assocIndexOf(data, key);
      if (index < 0) {
        return false;
      }
      var lastIndex = data.length - 1;
      if (index == lastIndex) {
        data.pop();
      } else {
        splice.call(data, index, 1);
      }
      return true;
    }
    function listCacheGet(key) {
      var data = this.__data__, index = assocIndexOf(data, key);
      return index < 0 ? void 0 : data[index][1];
    }
    function listCacheHas(key) {
      return assocIndexOf(this.__data__, key) > -1;
    }
    function listCacheSet(key, value) {
      var data = this.__data__, index = assocIndexOf(data, key);
      if (index < 0) {
        data.push([key, value]);
      } else {
        data[index][1] = value;
      }
      return this;
    }
    ListCache.prototype.clear = listCacheClear;
    ListCache.prototype["delete"] = listCacheDelete;
    ListCache.prototype.get = listCacheGet;
    ListCache.prototype.has = listCacheHas;
    ListCache.prototype.set = listCacheSet;
    function MapCache(entries) {
      var index = -1, length = entries ? entries.length : 0;
      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    function mapCacheClear() {
      this.__data__ = {
        "hash": new Hash(),
        "map": new (Map2 || ListCache)(),
        "string": new Hash()
      };
    }
    function mapCacheDelete(key) {
      return getMapData(this, key)["delete"](key);
    }
    function mapCacheGet(key) {
      return getMapData(this, key).get(key);
    }
    function mapCacheHas(key) {
      return getMapData(this, key).has(key);
    }
    function mapCacheSet(key, value) {
      getMapData(this, key).set(key, value);
      return this;
    }
    MapCache.prototype.clear = mapCacheClear;
    MapCache.prototype["delete"] = mapCacheDelete;
    MapCache.prototype.get = mapCacheGet;
    MapCache.prototype.has = mapCacheHas;
    MapCache.prototype.set = mapCacheSet;
    function assocIndexOf(array, key) {
      var length = array.length;
      while (length--) {
        if (eq(array[length][0], key)) {
          return length;
        }
      }
      return -1;
    }
    function baseIsNative(value) {
      if (!isObject(value) || isMasked(value)) {
        return false;
      }
      var pattern = isFunction(value) || isHostObject(value) ? reIsNative : reIsHostCtor;
      return pattern.test(toSource(value));
    }
    function getMapData(map, key) {
      var data = map.__data__;
      return isKeyable(key) ? data[typeof key == "string" ? "string" : "hash"] : data.map;
    }
    function getNative(object, key) {
      var value = getValue(object, key);
      return baseIsNative(value) ? value : void 0;
    }
    function isKeyable(value) {
      var type = typeof value;
      return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value !== "__proto__" : value === null;
    }
    function isMasked(func) {
      return !!maskSrcKey && maskSrcKey in func;
    }
    function toSource(func) {
      if (func != null) {
        try {
          return funcToString.call(func);
        } catch (e) {
        }
        try {
          return func + "";
        } catch (e) {
        }
      }
      return "";
    }
    function memoize(func, resolver) {
      if (typeof func != "function" || resolver && typeof resolver != "function") {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      var memoized = function() {
        var args = arguments, key = resolver ? resolver.apply(this, args) : args[0], cache = memoized.cache;
        if (cache.has(key)) {
          return cache.get(key);
        }
        var result = func.apply(this, args);
        memoized.cache = cache.set(key, result);
        return result;
      };
      memoized.cache = new (memoize.Cache || MapCache)();
      return memoized;
    }
    memoize.Cache = MapCache;
    function eq(value, other) {
      return value === other || value !== value && other !== other;
    }
    function isFunction(value) {
      var tag = isObject(value) ? objectToString.call(value) : "";
      return tag == funcTag || tag == genTag;
    }
    function isObject(value) {
      var type = typeof value;
      return !!value && (type == "object" || type == "function");
    }
    module2.exports = memoize;
  }
});

// node_modules/caniuse-lite/data/features/aac.js
var require_aac = __commonJS({
  "node_modules/caniuse-lite/data/features/aac.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "F A B", "2": "K D E YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "2": "ZC BC J DB K D E F A B C L M G N O P EB u v bC cC", "132": "0 1 2 3 4 5 6 7 8 9 w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F", "16": "A B" }, E: { "1": "J DB K D E F A B C L M G eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "dC HC" }, F: { "1": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B" }, G: { "1": "E tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "16": "HC" }, H: { "2": "FD" }, I: { "1": "BC J I JD XC KD LD", "2": "GD HD ID" }, J: { "1": "A", "2": "D" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "132": "5B" }, N: { "1": "A", "2": "B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "132": "aD bD" } }, B: 6, C: "AAC audio file format", D: true };
  }
});

// node_modules/caniuse-lite/data/features/abortcontroller.js
var require_abortcontroller = __commonJS({
  "node_modules/caniuse-lite/data/features/abortcontroller.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB" }, E: { "1": "L M G 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F A B dC HC eC fC gC hC IC", "130": "C 6B" }, F: { "1": "hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB oC pC qC rC 6B WC sC 7B" }, G: { "1": "3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y QD IC RD SD TD UD VD 9B AC WD XD", "2": "J MD ND OD PD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "2": "aD" } }, B: 1, C: "AbortController & AbortSignal", D: true };
  }
});

// node_modules/caniuse-lite/data/features/ac3-ec3.js
var require_ac3_ec3 = __commonJS({
  "node_modules/caniuse-lite/data/features/ac3-ec3.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "C L M G N O P", "2": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "2": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "2": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t oC pC qC rC 6B WC sC 7B" }, G: { "2": "E HC tC XC uC vC wC xC", "132": "yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "2": "BC J I GD HD ID JD XC KD LD" }, J: { "2": "D", "132": "A" }, K: { "2": "A B C H 6B WC", "132": "7B" }, L: { "2": "I" }, M: { "2": "5B" }, N: { "2": "A B" }, O: { "2": "8B" }, P: { "2": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "2": "YD" }, R: { "2": "ZD" }, S: { "2": "aD bD" } }, B: 6, C: "AC-3 (Dolby Digital) and EC-3 (Dolby Digital Plus) codecs", D: false };
  }
});

// node_modules/caniuse-lite/data/features/accelerometer.js
var require_accelerometer = __commonJS({
  "node_modules/caniuse-lite/data/features/accelerometer.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "2": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB", "194": "mB CC nB DC oB pB qB rB sB" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB oC pC qC rC 6B WC sC 7B" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "2": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "2": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "2": "aD bD" } }, B: 4, C: "Accelerometer", D: true };
  }
});

// node_modules/caniuse-lite/data/features/addeventlistener.js
var require_addeventlistener = __commonJS({
  "node_modules/caniuse-lite/data/features/addeventlistener.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "F A B", "130": "K D E YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "257": "ZC BC J DB K bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t oC pC qC rC 6B WC sC 7B" }, G: { "1": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "1": "FD" }, I: { "1": "BC J I GD HD ID JD XC KD LD" }, J: { "1": "D A" }, K: { "1": "A B C H 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "EventTarget.addEventListener()", D: true };
  }
});

// node_modules/caniuse-lite/data/features/alternate-stylesheet.js
var require_alternate_stylesheet = __commonJS({
  "node_modules/caniuse-lite/data/features/alternate-stylesheet.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "E F A B", "2": "K D YC" }, B: { "2": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "2": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "F B C oC pC qC rC 6B WC sC 7B", "16": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "16": "FD" }, I: { "2": "BC J I GD HD ID JD XC KD LD" }, J: { "16": "D A" }, K: { "2": "H", "16": "A B C 6B WC 7B" }, L: { "16": "I" }, M: { "16": "5B" }, N: { "16": "A B" }, O: { "16": "8B" }, P: { "16": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "2": "YD" }, R: { "16": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "Alternate stylesheet", D: false };
  }
});

// node_modules/caniuse-lite/data/features/ambient-light.js
var require_ambient_light = __commonJS({
  "node_modules/caniuse-lite/data/features/ambient-light.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "2": "C L", "132": "M G N O P", "322": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "2": "ZC BC J DB K D E F A B C L M G N O P EB u v bC cC", "132": "w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC", "194": "0 1 2 3 4 5 6 7 8 9 nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC" }, D: { "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB", "322": "0 1 2 3 4 5 6 7 8 9 mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB oC pC qC rC 6B WC sC 7B", "322": "zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "2": "BC J I GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "2": "A B C H 6B WC 7B" }, L: { "2": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "2": "8B" }, P: { "2": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "2": "YD" }, R: { "2": "ZD" }, S: { "132": "aD bD" } }, B: 4, C: "Ambient Light Sensor", D: true };
  }
});

// node_modules/caniuse-lite/data/features/apng.js
var require_apng = __commonJS({
  "node_modules/caniuse-lite/data/features/apng.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC", "2": "ZC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB" }, E: { "1": "E F A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D dC HC eC fC gC" }, F: { "1": "B C aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t oC pC qC rC 6B WC sC 7B", "2": "F G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB" }, G: { "1": "E xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC wC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "A B C H 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J MD ND" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "Animated PNG (APNG)", D: true };
  }
});

// node_modules/caniuse-lite/data/features/array-find-index.js
var require_array_find_index = __commonJS({
  "node_modules/caniuse-lite/data/features/array-find-index.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB" }, E: { "1": "E F A B C L M G gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D dC HC eC fC" }, F: { "1": "MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB oC pC qC rC 6B WC sC 7B" }, G: { "1": "E xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC wC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D", "16": "A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 6, C: "Array.prototype.findIndex", D: true };
  }
});

// node_modules/caniuse-lite/data/features/array-find.js
var require_array_find = __commonJS({
  "node_modules/caniuse-lite/data/features/array-find.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "16": "C L M" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB" }, E: { "1": "E F A B C L M G gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D dC HC eC fC" }, F: { "1": "MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB oC pC qC rC 6B WC sC 7B" }, G: { "1": "E xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC wC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D", "16": "A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 6, C: "Array.prototype.find", D: true };
  }
});

// node_modules/caniuse-lite/data/features/array-flat.js
var require_array_flat = __commonJS({
  "node_modules/caniuse-lite/data/features/array-flat.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB" }, E: { "1": "C L M G 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F A B dC HC eC fC gC hC IC 6B" }, F: { "1": "kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB oC pC qC rC 6B WC sC 7B" }, G: { "1": "4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y IC RD SD TD UD VD 9B AC WD XD", "2": "J MD ND OD PD QD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "2": "aD" } }, B: 6, C: "flat & flatMap array methods", D: true };
  }
});

// node_modules/caniuse-lite/data/features/array-includes.js
var require_array_includes = __commonJS({
  "node_modules/caniuse-lite/data/features/array-includes.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB" }, E: { "1": "F A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E dC HC eC fC gC" }, F: { "1": "OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB oC pC qC rC 6B WC sC 7B" }, G: { "1": "yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 6, C: "Array.prototype.includes", D: true };
  }
});

// node_modules/caniuse-lite/data/features/arrow-functions.js
var require_arrow_functions = __commonJS({
  "node_modules/caniuse-lite/data/features/arrow-functions.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB" }, E: { "1": "A B C L M G IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F dC HC eC fC gC hC" }, F: { "1": "MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB oC pC qC rC 6B WC sC 7B" }, G: { "1": "0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 6, C: "Arrow functions", D: true };
  }
});

// node_modules/caniuse-lite/data/features/asmjs.js
var require_asmjs = __commonJS({
  "node_modules/caniuse-lite/data/features/asmjs.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "L M G N O P", "132": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "322": "C" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v bC cC" }, D: { "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB", "132": "0 1 2 3 4 5 6 7 8 9 IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "2": "F B C oC pC qC rC 6B WC sC 7B", "132": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "2": "BC J GD HD ID JD XC KD LD", "132": "I" }, J: { "2": "D A" }, K: { "2": "A B C 6B WC 7B", "132": "H" }, L: { "132": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "132": "8B" }, P: { "2": "J", "132": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "132": "YD" }, R: { "132": "ZD" }, S: { "1": "aD bD" } }, B: 6, C: "asm.js", D: true };
  }
});

// node_modules/caniuse-lite/data/features/async-clipboard.js
var require_async_clipboard = __commonJS({
  "node_modules/caniuse-lite/data/features/async-clipboard.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB bC cC", "132": "0 1 2 3 4 5 6 7 8 9 pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB", "66": "mB CC nB DC" }, E: { "1": "M G iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F A B C L dC HC eC fC gC hC IC 6B 7B" }, F: { "1": "dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB oC pC qC rC 6B WC sC 7B" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C", "260": "AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "2": "BC J GD HD ID JD XC KD LD", "260": "I" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "132": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "2": "J MD ND OD PD", "260": "u v w x y QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "2": "aD", "132": "bD" } }, B: 5, C: "Asynchronous Clipboard API", D: true };
  }
});

// node_modules/caniuse-lite/data/features/async-functions.js
var require_async_functions = __commonJS({
  "node_modules/caniuse-lite/data/features/async-functions.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L", "194": "M" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB" }, E: { "1": "B C L M G 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F A dC HC eC fC gC hC", "258": "IC" }, F: { "1": "WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB oC pC qC rC 6B WC sC 7B" }, G: { "1": "2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC 0C", "258": "1C" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J MD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "2": "aD" } }, B: 6, C: "Async functions", D: true };
  }
});

// node_modules/caniuse-lite/data/features/atob-btoa.js
var require_atob_btoa = __commonJS({
  "node_modules/caniuse-lite/data/features/atob-btoa.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "A B", "2": "K D E F YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t rC 6B WC sC 7B", "2": "F oC pC", "16": "qC" }, G: { "1": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "1": "FD" }, I: { "1": "BC J I GD HD ID JD XC KD LD" }, J: { "1": "D A" }, K: { "1": "B C H 6B WC 7B", "16": "A" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "Base64 encoding and decoding", D: true };
  }
});

// node_modules/caniuse-lite/data/features/audio-api.js
var require_audio_api = __commonJS({
  "node_modules/caniuse-lite/data/features/audio-api.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L", "33": "M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB" }, E: { "1": "G jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB dC HC eC", "33": "K D E F A B C L M fC gC hC IC 6B 7B iC" }, F: { "1": "w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B", "33": "G N O P EB u v" }, G: { "1": "BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC", "33": "E vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 2, C: "Web Audio API", D: true };
  }
});

// node_modules/caniuse-lite/data/features/audio.js
var require_audio = __commonJS({
  "node_modules/caniuse-lite/data/features/audio.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "F A B", "2": "K D E YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC", "132": "J DB K D E F A B C L M G N O P EB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t qC rC 6B WC sC 7B", "2": "F", "4": "oC pC" }, G: { "260": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "BC J I ID JD XC KD LD", "2": "GD HD" }, J: { "1": "D A" }, K: { "1": "B C H 6B WC 7B", "2": "A" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "Audio element", D: true };
  }
});

// node_modules/caniuse-lite/data/features/audiotracks.js
var require_audiotracks = __commonJS({
  "node_modules/caniuse-lite/data/features/audiotracks.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "A B", "2": "K D E F YC" }, B: { "1": "C L M G N O P", "322": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB bC cC", "194": "0 1 2 3 4 5 6 7 8 9 NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC" }, D: { "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB", "322": "0 1 2 3 4 5 6 7 8 9 ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "D E F A B C L M G fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K dC HC eC" }, F: { "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB oC pC qC rC 6B WC sC 7B", "322": "MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t" }, G: { "1": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC" }, H: { "2": "FD" }, I: { "2": "BC J I GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "2": "A B C 6B WC 7B", "322": "H" }, L: { "322": "I" }, M: { "2": "5B" }, N: { "1": "A B" }, O: { "322": "8B" }, P: { "2": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "322": "YD" }, R: { "322": "ZD" }, S: { "194": "aD bD" } }, B: 1, C: "Audio Tracks", D: true };
  }
});

// node_modules/caniuse-lite/data/features/autofocus.js
var require_autofocus = __commonJS({
  "node_modules/caniuse-lite/data/features/autofocus.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "A B", "2": "K D E F YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J" }, E: { "1": "DB K D E F A B C L M G eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J dC HC" }, F: { "1": "B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t oC pC qC rC 6B WC sC 7B", "2": "F" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "BC J I JD XC KD LD", "2": "GD HD ID" }, J: { "1": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "2": "aD" } }, B: 1, C: "Autofocus attribute", D: true };
  }
});

// node_modules/caniuse-lite/data/features/auxclick.js
var require_auxclick = __commonJS({
  "node_modules/caniuse-lite/data/features/auxclick.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB bC cC", "129": "0 1 2 3 4 5 6 7 8 9 hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB oC pC qC rC 6B WC sC 7B" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "2": "aD bD" } }, B: 5, C: "Auxclick", D: true };
  }
});

// node_modules/caniuse-lite/data/features/av1.js
var require_av1 = __commonJS({
  "node_modules/caniuse-lite/data/features/av1.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "9 AB BB CB I", "2": "4 5 6 7 8 C L M G N O", "194": "0 1 2 3 P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB bC cC", "66": "jB kB lB mB CC nB DC oB pB qB", "260": "rB", "516": "sB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB", "66": "tB uB vB" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC", "1028": "AC QC RC SC TC UC VC nC" }, F: { "1": "lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB oC pC qC rC 6B WC sC 7B" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED", "1028": "AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y SD TD UD VD 9B AC WD XD", "2": "J MD ND OD PD QD IC RD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "2": "aD bD" } }, B: 6, C: "AV1 video format", D: true };
  }
});

// node_modules/caniuse-lite/data/features/avif.js
var require_avif = __commonJS({
  "node_modules/caniuse-lite/data/features/avif.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "9 AB BB CB I", "2": "0 1 6 7 8 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z", "4162": "2 3 4 5" }, C: { "1": "1 2 3 4 5 6 7 8 9 AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B bC cC", "194": "3B 4B Q H R EC S T U V W X Y Z a b", "257": "c d e f g h i j k l m n o p q r s t", "2049": "0 z" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T" }, E: { "1": "OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B", "1796": "LC MC NC" }, F: { "1": "xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB oC pC qC rC 6B WC sC 7B" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD", "257": "OC PC ED AC QC RC SC TC UC VC", "1281": "9B LC MC NC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y UD VD 9B AC WD XD", "2": "J MD ND OD PD QD IC RD SD TD" }, Q: { "2": "YD" }, R: { "1": "ZD" }, S: { "2": "aD bD" } }, B: 6, C: "AVIF image format", D: true };
  }
});

// node_modules/caniuse-lite/data/features/background-attachment.js
var require_background_attachment = __commonJS({
  "node_modules/caniuse-lite/data/features/background-attachment.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "F A B", "132": "K D E YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "132": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "DB K D E F A B C eC fC gC hC IC 6B 7B KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "132": "J L dC HC iC", "2050": "M G jC kC JC" }, F: { "1": "B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t qC rC 6B WC sC 7B", "132": "F oC pC" }, G: { "2": "HC tC XC", "772": "E uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C", "2050": "6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "2": "BC J I GD HD ID KD LD", "132": "JD XC" }, J: { "260": "D A" }, K: { "1": "B C H 6B WC 7B", "132": "A" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "2": "J", "1028": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "CSS background-attachment", D: true };
  }
});

// node_modules/caniuse-lite/data/features/background-position-x-y.js
var require_background_position_x_y = __commonJS({
  "node_modules/caniuse-lite/data/features/background-position-x-y.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B" }, G: { "1": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "BC J I GD HD ID JD XC KD LD" }, J: { "1": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "2": "aD" } }, B: 7, C: "background-position-x & background-position-y", D: true };
  }
});

// node_modules/caniuse-lite/data/features/background-repeat-round-space.js
var require_background_repeat_round_space = __commonJS({
  "node_modules/caniuse-lite/data/features/background-repeat-round-space.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "A B", "2": "K D E YC", "132": "F" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB" }, E: { "1": "D E F A B C L M G gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K dC HC eC fC" }, F: { "1": "B C EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t qC rC 6B WC sC 7B", "2": "F G N O P oC pC" }, G: { "1": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC" }, H: { "1": "FD" }, I: { "1": "I KD LD", "2": "BC J GD HD ID JD XC" }, J: { "1": "A", "2": "D" }, K: { "1": "B C H 6B WC 7B", "2": "A" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "2": "aD" } }, B: 4, C: "CSS background-repeat round and space", D: true };
  }
});

// node_modules/caniuse-lite/data/features/background-sync.js
var require_background_sync = __commonJS({
  "node_modules/caniuse-lite/data/features/background-sync.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "2": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B bC cC", "16": "FC GC aC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB oC pC qC rC 6B WC sC 7B" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "2": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "2": "aD bD" } }, B: 7, C: "Background Sync API", D: true };
  }
});

// node_modules/caniuse-lite/data/features/battery-status.js
var require_battery_status = __commonJS({
  "node_modules/caniuse-lite/data/features/battery-status.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "XB YB ZB aB bB cB dB eB fB", "2": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC", "132": "N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB", "164": "A B C L M G" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB", "66": "RB" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y oC pC qC rC 6B WC sC 7B" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "2": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD", "2": "bD" } }, B: 4, C: "Battery Status API", D: true };
  }
});

// node_modules/caniuse-lite/data/features/beacon.js
var require_beacon = __commonJS({
  "node_modules/caniuse-lite/data/features/beacon.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB" }, E: { "1": "C L M G 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F A B dC HC eC fC gC hC IC" }, F: { "1": "GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB oC pC qC rC 6B WC sC 7B" }, G: { "1": "3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "Beacon API", D: true };
  }
});

// node_modules/caniuse-lite/data/features/beforeafterprint.js
var require_beforeafterprint = __commonJS({
  "node_modules/caniuse-lite/data/features/beforeafterprint.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "K D E F A B", "16": "YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB" }, E: { "1": "L M G iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F A B C dC HC eC fC gC hC IC 6B 7B" }, F: { "1": "eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB oC pC qC rC 6B WC sC 7B" }, G: { "1": "6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C" }, H: { "2": "FD" }, I: { "2": "BC J I GD HD ID JD XC KD LD" }, J: { "16": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "16": "A B" }, O: { "1": "8B" }, P: { "2": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "16": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "Printing Events", D: true };
  }
});

// node_modules/caniuse-lite/data/features/bigint.js
var require_bigint = __commonJS({
  "node_modules/caniuse-lite/data/features/bigint.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB bC cC", "194": "rB sB tB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB" }, E: { "1": "M G jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F A B C L dC HC eC fC gC hC IC 6B 7B iC" }, F: { "1": "iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB oC pC qC rC 6B WC sC 7B" }, G: { "1": "AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y QD IC RD SD TD UD VD 9B AC WD XD", "2": "J MD ND OD PD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "2": "aD" } }, B: 6, C: "BigInt", D: true };
  }
});

// node_modules/caniuse-lite/data/features/blobbuilder.js
var require_blobbuilder = __commonJS({
  "node_modules/caniuse-lite/data/features/blobbuilder.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "A B", "2": "K D E F YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB bC cC", "36": "K D E F A B C" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D", "36": "E F A B C L M G N O P EB" }, E: { "1": "K D E F A B C L M G fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB dC HC eC" }, F: { "1": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t 7B", "2": "F B C oC pC qC rC 6B WC sC" }, G: { "1": "E vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC" }, H: { "2": "FD" }, I: { "1": "I", "2": "GD HD ID", "36": "BC J JD XC KD LD" }, J: { "1": "A", "2": "D" }, K: { "1": "H 7B", "2": "A B C 6B WC" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 5, C: "Blob constructing", D: true };
  }
});

// node_modules/caniuse-lite/data/features/bloburls.js
var require_bloburls = __commonJS({
  "node_modules/caniuse-lite/data/features/bloburls.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F YC", "129": "A B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "129": "C L M" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D", "33": "E F A B C L M G N O P EB u v w" }, E: { "1": "D E F A B C L M G fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB dC HC eC", "33": "K" }, F: { "1": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B" }, G: { "1": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC", "33": "vC" }, H: { "2": "FD" }, I: { "1": "I KD LD", "2": "BC GD HD ID", "33": "J JD XC" }, J: { "1": "A", "2": "D" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "B", "2": "A" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 5, C: "Blob URLs", D: true };
  }
});

// node_modules/caniuse-lite/data/features/broadcastchannel.js
var require_broadcastchannel = __commonJS({
  "node_modules/caniuse-lite/data/features/broadcastchannel.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB" }, E: { "1": "KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC" }, F: { "1": "VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB oC pC qC rC 6B WC sC 7B" }, G: { "1": "KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J MD ND" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "BroadcastChannel", D: true };
  }
});

// node_modules/caniuse-lite/data/features/brotli.js
var require_brotli = __commonJS({
  "node_modules/caniuse-lite/data/features/brotli.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB", "194": "dB", "257": "eB" }, E: { "1": "L M G iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F A dC HC eC fC gC hC IC", "513": "B C 6B 7B" }, F: { "1": "SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB oC pC qC rC 6B WC sC 7B", "194": "QB RB" }, G: { "1": "2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC 0C 1C" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 6, C: "Brotli Accept-Encoding/Content-Encoding", D: true };
  }
});

// node_modules/caniuse-lite/data/features/canvas-blending.js
var require_canvas_blending = __commonJS({
  "node_modules/caniuse-lite/data/features/canvas-blending.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB" }, E: { "1": "D E F A B C L M G fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K dC HC eC" }, F: { "1": "O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N oC pC qC rC 6B WC sC 7B" }, G: { "1": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC" }, H: { "2": "FD" }, I: { "1": "I KD LD", "2": "BC J GD HD ID JD XC" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "Canvas blend modes", D: true };
  }
});

// node_modules/caniuse-lite/data/features/canvas-text.js
var require_canvas_text = __commonJS({
  "node_modules/caniuse-lite/data/features/canvas-text.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "F A B", "2": "YC", "8": "K D E" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC", "8": "ZC BC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "J DB K D E F A B C L M G eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "8": "dC HC" }, F: { "1": "B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t qC rC 6B WC sC 7B", "8": "F oC pC" }, G: { "1": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "BC J I GD HD ID JD XC KD LD" }, J: { "1": "D A" }, K: { "1": "B C H 6B WC 7B", "8": "A" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "Text API for Canvas", D: true };
  }
});

// node_modules/caniuse-lite/data/features/canvas.js
var require_canvas = __commonJS({
  "node_modules/caniuse-lite/data/features/canvas.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "F A B", "2": "YC", "8": "K D E" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC cC", "132": "ZC BC bC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "J DB K D E F A B C L M G eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "132": "dC HC" }, F: { "1": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t oC pC qC rC 6B WC sC 7B" }, G: { "1": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "260": "FD" }, I: { "1": "BC J I JD XC KD LD", "132": "GD HD ID" }, J: { "1": "D A" }, K: { "1": "A B C H 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "Canvas (basic support)", D: true };
  }
});

// node_modules/caniuse-lite/data/features/ch-unit.js
var require_ch_unit = __commonJS({
  "node_modules/caniuse-lite/data/features/ch-unit.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E YC", "132": "F A B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB" }, E: { "1": "D E F A B C L M G gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K dC HC eC fC" }, F: { "1": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B" }, G: { "1": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC" }, H: { "2": "FD" }, I: { "1": "I KD LD", "2": "BC J GD HD ID JD XC" }, J: { "1": "A", "2": "D" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "ch (character) unit", D: true };
  }
});

// node_modules/caniuse-lite/data/features/chacha20-poly1305.js
var require_chacha20_poly1305 = __commonJS({
  "node_modules/caniuse-lite/data/features/chacha20-poly1305.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB", "129": "NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB" }, E: { "1": "C L M G 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F A B dC HC eC fC gC hC IC" }, F: { "1": "QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB oC pC qC rC 6B WC sC 7B" }, G: { "1": "2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC 0C 1C" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD", "16": "LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 6, C: "ChaCha20-Poly1305 cipher suites for TLS", D: true };
  }
});

// node_modules/caniuse-lite/data/features/channel-messaging.js
var require_channel_messaging = __commonJS({
  "node_modules/caniuse-lite/data/features/channel-messaging.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "A B", "2": "K D E F YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB bC cC", "194": "GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "DB K D E F A B C L M G eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J dC HC" }, F: { "1": "B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t rC 6B WC sC 7B", "2": "F oC pC", "16": "qC" }, G: { "1": "E uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC" }, H: { "2": "FD" }, I: { "1": "I KD LD", "2": "BC J GD HD ID JD XC" }, J: { "1": "D A" }, K: { "1": "B C H 6B WC 7B", "2": "A" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "Channel messaging", D: true };
  }
});

// node_modules/caniuse-lite/data/features/childnode-remove.js
var require_childnode_remove = __commonJS({
  "node_modules/caniuse-lite/data/features/childnode-remove.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "16": "C" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x" }, E: { "1": "D E F A B C L M G fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB dC HC eC", "16": "K" }, F: { "1": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B" }, G: { "1": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC" }, H: { "2": "FD" }, I: { "1": "I KD LD", "2": "BC J GD HD ID JD XC" }, J: { "1": "A", "2": "D" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "ChildNode.remove()", D: true };
  }
});

// node_modules/caniuse-lite/data/features/classlist.js
var require_classlist = __commonJS({
  "node_modules/caniuse-lite/data/features/classlist.js"(exports2, module2) {
    module2.exports = { A: { A: { "8": "K D E F YC", "1924": "A B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "8": "ZC BC bC", "516": "y FB", "772": "J DB K D E F A B C L M G N O P EB u v w x cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "8": "J DB K D", "516": "y FB GB HB", "772": "x", "900": "E F A B C L M G N O P EB u v w" }, E: { "1": "D E F A B C L M G gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "8": "J DB dC HC", "900": "K eC fC" }, F: { "1": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "8": "F B oC pC qC rC 6B", "900": "C WC sC 7B" }, G: { "1": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "8": "HC tC XC", "900": "uC vC" }, H: { "900": "FD" }, I: { "1": "I KD LD", "8": "GD HD ID", "900": "BC J JD XC" }, J: { "1": "A", "900": "D" }, K: { "1": "H", "8": "A B", "900": "C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "900": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "classList (DOMTokenList)", D: true };
  }
});

// node_modules/caniuse-lite/data/features/client-hints-dpr-width-viewport.js
var require_client_hints_dpr_width_viewport = __commonJS({
  "node_modules/caniuse-lite/data/features/client-hints-dpr-width-viewport.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "2": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB oC pC qC rC 6B WC sC 7B" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "2": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "2": "aD bD" } }, B: 6, C: "Client Hints: DPR, Width, Viewport-Width", D: true };
  }
});

// node_modules/caniuse-lite/data/features/clipboard.js
var require_clipboard = __commonJS({
  "node_modules/caniuse-lite/data/features/clipboard.js"(exports2, module2) {
    module2.exports = { A: { A: { "2436": "K D E F A B YC" }, B: { "260": "O P", "2436": "C L M G N", "8196": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "2": "ZC BC J DB K D E F A B C L M G N O P EB u v bC cC", "772": "w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB", "4100": "0 1 2 3 4 5 6 7 8 9 VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC" }, D: { "2": "J DB K D E F A B C", "2564": "L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB", "8196": "0 1 2 3 4 5 6 7 8 9 mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "10244": "XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB" }, E: { "1": "C L M G 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "16": "dC HC", "2308": "A B IC 6B", "2820": "J DB K D E F eC fC gC hC" }, F: { "2": "F B oC pC qC rC 6B WC sC", "16": "C", "516": "7B", "2564": "G N O P EB u v w x y FB GB HB IB JB", "8196": "ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "10244": "KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB" }, G: { "1": "4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC", "2820": "E uC vC wC xC yC zC 0C 1C 2C 3C" }, H: { "2": "FD" }, I: { "2": "BC J GD HD ID JD XC", "260": "I", "2308": "KD LD" }, J: { "2": "D", "2308": "A" }, K: { "2": "A B C 6B WC", "16": "7B", "8196": "H" }, L: { "8196": "I" }, M: { "1028": "5B" }, N: { "2": "A B" }, O: { "8196": "8B" }, P: { "2052": "MD ND", "2308": "J", "8196": "u v w x y OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "8196": "YD" }, R: { "8196": "ZD" }, S: { "4100": "aD bD" } }, B: 5, C: "Synchronous Clipboard API", D: true };
  }
});

// node_modules/caniuse-lite/data/features/colr-v1.js
var require_colr_v1 = __commonJS({
  "node_modules/caniuse-lite/data/features/colr-v1.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P Q H R S T U V W X Y Z a b c d e f g" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g bC cC", "258": "h i j k l m n", "578": "o p" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y", "194": "Z a b c d e f g" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U oC pC qC rC 6B WC sC 7B" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "16": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "16": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y WD XD", "2": "J MD ND OD PD QD IC RD SD TD UD VD 9B AC" }, Q: { "2": "YD" }, R: { "2": "ZD" }, S: { "2": "aD bD" } }, B: 6, C: "COLR/CPAL(v1) Font Formats", D: true };
  }
});

// node_modules/caniuse-lite/data/features/colr.js
var require_colr = __commonJS({
  "node_modules/caniuse-lite/data/features/colr.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E YC", "257": "F A B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P t z AB BB CB I", "513": "Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB", "513": "xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s" }, E: { "1": "M G jC kC JC KC 8B lC 9B LC MC NC OC PC mC RC SC TC UC VC nC", "2": "J DB K D E F A dC HC eC fC gC hC IC", "129": "B C L 6B 7B iC", "1026": "AC QC" }, F: { "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB oC pC qC rC 6B WC sC 7B", "513": "mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t" }, G: { "1": "2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC 0C 1C", "1026": "AC QC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "16": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "16": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y IC RD SD TD UD VD 9B AC WD XD", "2": "J MD ND OD PD QD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 6, C: "COLR/CPAL(v0) Font Formats", D: true };
  }
});

// node_modules/caniuse-lite/data/features/comparedocumentposition.js
var require_comparedocumentposition = __commonJS({
  "node_modules/caniuse-lite/data/features/comparedocumentposition.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "F A B", "2": "K D E YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "16": "ZC BC bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "16": "J DB K D E F A B C L M", "132": "G N O P EB u v w x y FB GB HB IB JB" }, E: { "1": "A B C L M G IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "16": "J DB K dC HC", "132": "D E F fC gC hC", "260": "eC" }, F: { "1": "C O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t sC 7B", "16": "F B oC pC qC rC 6B WC", "132": "G N" }, G: { "1": "0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "16": "HC", "132": "E tC XC uC vC wC xC yC zC" }, H: { "1": "FD" }, I: { "1": "I KD LD", "16": "GD HD", "132": "BC J ID JD XC" }, J: { "132": "D A" }, K: { "1": "C H 7B", "16": "A B 6B WC" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "Node.compareDocumentPosition()", D: true };
  }
});

// node_modules/caniuse-lite/data/features/console-basic.js
var require_console_basic = __commonJS({
  "node_modules/caniuse-lite/data/features/console-basic.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "A B", "2": "K D YC", "132": "E F" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t 6B WC sC 7B", "2": "F oC pC qC rC" }, G: { "1": "HC tC XC uC", "513": "E vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "4097": "FD" }, I: { "1025": "BC J I GD HD ID JD XC KD LD" }, J: { "258": "D A" }, K: { "2": "A", "258": "B C 6B WC 7B", "1025": "H" }, L: { "1025": "I" }, M: { "2049": "5B" }, N: { "258": "A B" }, O: { "258": "8B" }, P: { "1025": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1025": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "Basic console logging functions", D: true };
  }
});

// node_modules/caniuse-lite/data/features/console-time.js
var require_console_time = __commonJS({
  "node_modules/caniuse-lite/data/features/console-time.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "B", "2": "K D E F A YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "J DB K D E F A B C L M G eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "dC HC" }, F: { "1": "C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t 6B WC sC 7B", "2": "F oC pC qC rC", "16": "B" }, G: { "1": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "1": "FD" }, I: { "1": "BC J I GD HD ID JD XC KD LD" }, J: { "1": "D A" }, K: { "1": "H", "16": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "B", "2": "A" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "console.time and console.timeEnd", D: true };
  }
});

// node_modules/caniuse-lite/data/features/const.js
var require_const = __commonJS({
  "node_modules/caniuse-lite/data/features/const.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A YC", "2052": "B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "132": "ZC BC J DB K D E F A B C bC cC", "260": "L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "260": "J DB K D E F A B C L M G N O P EB u", "772": "v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB", "1028": "VB WB XB YB ZB aB bB cB" }, E: { "1": "B C L M G 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "260": "J DB A dC HC IC", "772": "K D E F eC fC gC hC" }, F: { "1": "QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F oC", "132": "B pC qC rC 6B WC", "644": "C sC 7B", "772": "G N O P EB u v w x y FB GB HB", "1028": "IB JB KB LB MB NB OB PB" }, G: { "1": "2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "260": "HC tC XC 0C 1C", "772": "E uC vC wC xC yC zC" }, H: { "644": "FD" }, I: { "1": "I", "16": "GD HD", "260": "ID", "772": "BC J JD XC KD LD" }, J: { "772": "D A" }, K: { "1": "H", "132": "A B 6B WC", "644": "C 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "B", "2": "A" }, O: { "1": "8B" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "1028": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 6, C: "const", D: true };
  }
});

// node_modules/caniuse-lite/data/features/constraint-validation.js
var require_constraint_validation = __commonJS({
  "node_modules/caniuse-lite/data/features/constraint-validation.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F YC", "900": "A B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "388": "M G N", "900": "C L" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC bC cC", "260": "dB eB", "388": "JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB", "900": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "16": "J DB K D E F A B C L M", "388": "FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB", "900": "G N O P EB u v w x y" }, E: { "1": "A B C L M G IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "16": "J DB dC HC", "388": "E F gC hC", "900": "K D eC fC" }, F: { "1": "HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "16": "F B oC pC qC rC 6B WC", "388": "G N O P EB u v w x y FB GB", "900": "C sC 7B" }, G: { "1": "0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "16": "HC tC XC", "388": "E wC xC yC zC", "900": "uC vC" }, H: { "2": "FD" }, I: { "1": "I", "16": "BC GD HD ID", "388": "KD LD", "900": "J JD XC" }, J: { "16": "D", "388": "A" }, K: { "1": "H", "16": "A B 6B WC", "900": "C 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "900": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "388": "aD" } }, B: 1, C: "Constraint Validation API", D: true };
  }
});

// node_modules/caniuse-lite/data/features/contenteditable.js
var require_contenteditable = __commonJS({
  "node_modules/caniuse-lite/data/features/contenteditable.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC", "2": "ZC", "4": "BC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "1": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t oC pC qC rC 6B WC sC 7B" }, G: { "1": "E uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC" }, H: { "2": "FD" }, I: { "1": "BC J I JD XC KD LD", "2": "GD HD ID" }, J: { "1": "D A" }, K: { "1": "H 7B", "2": "A B C 6B WC" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "contenteditable attribute (basic support)", D: true };
  }
});

// node_modules/caniuse-lite/data/features/contentsecuritypolicy.js
var require_contentsecuritypolicy = __commonJS({
  "node_modules/caniuse-lite/data/features/contentsecuritypolicy.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F YC", "132": "A B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC bC cC", "129": "J DB K D E F A B C L M G N O P EB u v w" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L", "257": "M G N O P EB u v w x y" }, E: { "1": "D E F A B C L M G gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB dC HC", "257": "K fC", "260": "eC" }, F: { "1": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C oC pC qC rC 6B WC sC 7B" }, G: { "1": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC", "257": "vC", "260": "uC" }, H: { "2": "FD" }, I: { "1": "I KD LD", "2": "BC J GD HD ID JD XC" }, J: { "2": "D", "257": "A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "132": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "Content Security Policy 1.0", D: true };
  }
});

// node_modules/caniuse-lite/data/features/contentsecuritypolicy2.js
var require_contentsecuritypolicy2 = __commonJS({
  "node_modules/caniuse-lite/data/features/contentsecuritypolicy2.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M", "4100": "G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB bC cC", "132": "LB MB NB OB", "260": "PB", "516": "QB RB SB TB UB VB WB XB YB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB", "1028": "QB RB SB", "2052": "TB" }, E: { "1": "A B C L M G IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F dC HC eC fC gC hC" }, F: { "1": "HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w oC pC qC rC 6B WC sC 7B", "1028": "x y FB", "2052": "GB" }, G: { "1": "0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 2, C: "Content Security Policy Level 2", D: true };
  }
});

// node_modules/caniuse-lite/data/features/cookie-store-api.js
var require_cookie_store_api = __commonJS({
  "node_modules/caniuse-lite/data/features/cookie-store-api.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P", "194": "Q H R S T U V" }, C: { "2": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB", "194": "qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB oC pC qC rC 6B WC sC 7B", "194": "fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "2": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y UD VD 9B AC WD XD", "2": "J MD ND OD PD QD IC RD SD TD" }, Q: { "2": "YD" }, R: { "1": "ZD" }, S: { "2": "aD bD" } }, B: 7, C: "Cookie Store API", D: true };
  }
});

// node_modules/caniuse-lite/data/features/cors.js
var require_cors = __commonJS({
  "node_modules/caniuse-lite/data/features/cors.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "B", "2": "K D YC", "132": "A", "260": "E F" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC", "2": "ZC BC", "1025": "DC oB pB qB rB sB tB uB vB wB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "132": "J DB K D E F A B C" }, E: { "2": "dC HC", "513": "K D E F A B C L M G fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "644": "J DB eC" }, F: { "1": "C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t 7B", "2": "F B oC pC qC rC 6B WC sC" }, G: { "513": "E vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "644": "HC tC XC uC" }, H: { "2": "FD" }, I: { "1": "I KD LD", "132": "BC J GD HD ID JD XC" }, J: { "1": "A", "132": "D" }, K: { "1": "C H 7B", "2": "A B 6B WC" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "B", "132": "A" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 1, C: "Cross-Origin Resource Sharing", D: true };
  }
});

// node_modules/caniuse-lite/data/features/createimagebitmap.js
var require_createimagebitmap = __commonJS({
  "node_modules/caniuse-lite/data/features/createimagebitmap.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB bC cC", "1028": "c d e f g", "3076": "WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b", "8196": "0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB", "132": "eB fB", "260": "gB hB", "516": "iB jB kB lB mB" }, E: { "2": "J DB K D E F A B C L M dC HC eC fC gC hC IC 6B 7B iC jC", "4100": "G kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB oC pC qC rC 6B WC sC 7B", "132": "RB SB", "260": "TB UB", "516": "VB WB XB YB ZB" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD", "4100": "CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "8196": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "16": "J MD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "3076": "aD bD" } }, B: 1, C: "createImageBitmap", D: true };
  }
});

// node_modules/caniuse-lite/data/features/credential-management.js
var require_credential_management = __commonJS({
  "node_modules/caniuse-lite/data/features/credential-management.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "2": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB", "66": "cB dB eB", "129": "fB gB hB iB jB kB" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "1": "ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB oC pC qC rC 6B WC sC 7B" }, G: { "1": "AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "2": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J MD ND" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "2": "aD bD" } }, B: 5, C: "Credential Management API", D: true };
  }
});

// node_modules/caniuse-lite/data/features/cryptography.js
var require_cryptography = __commonJS({
  "node_modules/caniuse-lite/data/features/cryptography.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "YC", "8": "K D E F A", "164": "B" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "513": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "8": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB bC cC", "66": "MB NB" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "8": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB" }, E: { "1": "B C L M G 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "8": "J DB K D dC HC eC fC", "289": "E F A gC hC IC" }, F: { "1": "y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "8": "F B C G N O P EB u v w x oC pC qC rC 6B WC sC 7B" }, G: { "1": "2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "8": "HC tC XC uC vC wC", "289": "E xC yC zC 0C 1C" }, H: { "2": "FD" }, I: { "1": "I", "8": "BC J GD HD ID JD XC KD LD" }, J: { "8": "D A" }, K: { "1": "H", "8": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "8": "A", "164": "B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 2, C: "Web Cryptography", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-all.js
var require_css_all = __commonJS({
  "node_modules/caniuse-lite/data/features/css-all.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB" }, E: { "1": "A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F dC HC eC fC gC" }, F: { "1": "y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x oC pC qC rC 6B WC sC 7B" }, G: { "1": "zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC" }, H: { "2": "FD" }, I: { "1": "I LD", "2": "BC J GD HD ID JD XC KD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 2, C: "CSS all property", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-anchor-positioning.js
var require_css_anchor_positioning = __commonJS({
  "node_modules/caniuse-lite/data/features/css-anchor-positioning.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "I", "2": "0 1 2 3 4 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z", "194": "5 6 7 8 9 AB BB CB" }, C: { "2": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "1": "I 5B FC GC", "2": "0 1 2 3 4 J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z", "194": "5 6 7 8 9 AB BB CB" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l oC pC qC rC 6B WC sC 7B", "194": "m n o p q r s t" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "2": "A B C H 6B WC 7B" }, L: { "1": "I" }, M: { "2": "5B" }, N: { "2": "A B" }, O: { "2": "8B" }, P: { "2": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "2": "YD" }, R: { "2": "ZD" }, S: { "2": "aD bD" } }, B: 5, C: "CSS Anchor Positioning", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-at-counter-style.js
var require_css_at_counter_style = __commonJS({
  "node_modules/caniuse-lite/data/features/css-at-counter-style.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "2": "C L M G N O P Q H R S T U V W X Y Z", "132": "0 1 2 3 4 5 6 7 8 9 a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB bC cC", "132": "0 1 2 3 4 5 6 7 8 9 NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC" }, D: { "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z", "132": "0 1 2 3 4 5 6 7 8 9 a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC" }, E: { "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC", "4": "AC QC RC SC TC UC VC nC" }, F: { "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B oC pC qC rC 6B WC sC 7B", "132": "3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t" }, G: { "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED", "4": "AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "2": "BC J GD HD ID JD XC KD LD", "132": "I" }, J: { "2": "D A" }, K: { "2": "A B C 6B WC 7B", "132": "H" }, L: { "132": "I" }, M: { "132": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "2": "J MD ND OD PD QD IC RD SD TD UD VD", "132": "u v w x y 9B AC WD XD" }, Q: { "2": "YD" }, R: { "132": "ZD" }, S: { "132": "aD bD" } }, B: 4, C: "CSS Counter Styles", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-background-offsets.js
var require_css_background_offsets = __commonJS({
  "node_modules/caniuse-lite/data/features/css-background-offsets.js"(exports2, module2) {
    module2.exports = { A: { A: { "1": "F A B", "2": "K D E YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y" }, E: { "1": "D E F A B C L M G gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K dC HC eC fC" }, F: { "1": "B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t qC rC 6B WC sC 7B", "2": "F oC pC" }, G: { "1": "E wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC" }, H: { "1": "FD" }, I: { "1": "I KD LD", "2": "BC J GD HD ID JD XC" }, J: { "1": "A", "2": "D" }, K: { "1": "B C H 6B WC 7B", "2": "A" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "1": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "CSS background-position edge offsets", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-backgroundblendmode.js
var require_css_backgroundblendmode = __commonJS({
  "node_modules/caniuse-lite/data/features/css-backgroundblendmode.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 PB QB RB SB TB UB VB WB XB YB ZB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB", "260": "aB" }, E: { "1": "B C L M G IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D dC HC eC fC", "132": "E F A gC hC" }, F: { "1": "w x y FB GB HB IB JB KB LB MB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v oC pC qC rC 6B WC sC 7B", "260": "NB" }, G: { "1": "1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "HC tC XC uC vC wC", "132": "E xC yC zC 0C" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 4, C: "CSS background-blend-mode", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-canvas.js
var require_css_canvas = __commonJS({
  "node_modules/caniuse-lite/data/features/css-canvas.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "2": "0 1 2 3 4 5 6 7 8 9 C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "2": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "2": "0 1 2 3 4 5 6 7 8 9 cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "33": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB" }, E: { "2": "dC HC", "33": "J DB K D E F A B C L M G eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC" }, F: { "2": "F B C PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t oC pC qC rC 6B WC sC 7B", "33": "G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB" }, G: { "33": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC" }, H: { "2": "FD" }, I: { "2": "I", "33": "BC J GD HD ID JD XC KD LD" }, J: { "33": "D A" }, K: { "2": "A B C H 6B WC 7B" }, L: { "2": "I" }, M: { "2": "5B" }, N: { "2": "A B" }, O: { "2": "8B" }, P: { "2": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "33": "J" }, Q: { "2": "YD" }, R: { "2": "ZD" }, S: { "2": "aD bD" } }, B: 7, C: "CSS Canvas Drawings", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-caret-color.js
var require_css_caret_color = __commonJS({
  "node_modules/caniuse-lite/data/features/css-caret-color.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB" }, E: { "1": "C L M G 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F A B dC HC eC fC gC hC IC" }, F: { "1": "YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB oC pC qC rC 6B WC sC 7B" }, G: { "1": "3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J MD ND" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "bD", "2": "aD" } }, B: 2, C: "CSS caret-color", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-cascade-layers.js
var require_css_cascade_layers = __commonJS({
  "node_modules/caniuse-lite/data/features/css-cascade-layers.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P Q H R S T U V W X Y Z a b c d e", "322": "f g h" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c bC cC", "194": "d e f" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e", "322": "f g h" }, E: { "1": "KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC" }, F: { "1": "V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U oC pC qC rC 6B WC sC 7B" }, G: { "1": "KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y WD XD", "2": "J MD ND OD PD QD IC RD SD TD UD VD 9B AC" }, Q: { "2": "YD" }, R: { "2": "ZD" }, S: { "2": "aD bD" } }, B: 4, C: "CSS Cascade Layers", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-cascade-scope.js
var require_css_cascade_scope = __commonJS({
  "node_modules/caniuse-lite/data/features/css-cascade-scope.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "6 7 8 9 AB BB CB I", "2": "C L M G N O P Q H R S T U V W X Y Z a b c d e f g h i j k l m", "194": "0 1 2 3 4 5 n o p q r s t z" }, C: { "2": "0 1 2 3 4 5 6 7 8 9 ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC bC cC" }, D: { "1": "6 7 8 9 AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m", "194": "0 1 2 3 4 5 n o p q r s t z" }, E: { "1": "TC UC VC nC", "2": "J DB K D E F A B C L M G dC HC eC fC gC hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC" }, F: { "1": "p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y oC pC qC rC 6B WC sC 7B", "194": "Z a b c d e f g h i j k l m n o" }, G: { "1": "TC UC VC", "2": "E HC tC XC uC vC wC xC yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "2": "5B" }, N: { "2": "A B" }, O: { "2": "8B" }, P: { "2": "J u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD" }, Q: { "2": "YD" }, R: { "2": "ZD" }, S: { "2": "aD bD" } }, B: 5, C: "Scoped Styles: the @scope rule", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-case-insensitive.js
var require_css_case_insensitive = __commonJS({
  "node_modules/caniuse-lite/data/features/css-case-insensitive.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "1": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I", "2": "C L M G N O P" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 bB cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bC cC" }, D: { "1": "0 1 2 3 4 5 6 7 8 9 dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC", "2": "J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB cB" }, E: { "1": "F A B C L M G hC IC 6B 7B iC jC kC JC KC 8B lC 9B LC MC NC OC PC mC AC QC RC SC TC UC VC nC", "2": "J DB K D E dC HC eC fC gC" }, F: { "1": "QB RB SB TB UB VB WB XB YB ZB aB bB cB dB eB fB gB hB iB jB kB lB mB nB oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t", "2": "F B C G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB oC pC qC rC 6B WC sC 7B" }, G: { "1": "yC zC 0C 1C 2C 3C 4C 5C 6C 7C 8C 9C AD BD CD JC KC 8B DD 9B LC MC NC OC PC ED AC QC RC SC TC UC VC", "2": "E HC tC XC uC vC wC xC" }, H: { "2": "FD" }, I: { "1": "I", "2": "BC J GD HD ID JD XC KD LD" }, J: { "2": "D A" }, K: { "1": "H", "2": "A B C 6B WC 7B" }, L: { "1": "I" }, M: { "1": "5B" }, N: { "2": "A B" }, O: { "1": "8B" }, P: { "1": "u v w x y MD ND OD PD QD IC RD SD TD UD VD 9B AC WD XD", "2": "J" }, Q: { "1": "YD" }, R: { "1": "ZD" }, S: { "1": "aD bD" } }, B: 5, C: "Case-insensitive CSS attribute selectors", D: true };
  }
});

// node_modules/caniuse-lite/data/features/css-color-adjust.js
var require_css_color_adjust = __commonJS({
  "node_modules/caniuse-lite/data/features/css-color-adjust.js"(exports2, module2) {
    module2.exports = { A: { A: { "2": "K D E F A B YC" }, B: { "2": "C L M G N O P", "33": "0 1 2 3 4 5 6 7 8 9 Q H R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I" }, C: { "1": "0 1 2 3 4 5 6 7 8 9 cB dB eB fB gB hB iB jB kB lB mB CC nB DC oB pB qB rB sB tB uB vB wB xB yB zB 0B 1B 2B 3B 4B Q H R EC S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t z AB BB CB I 5B FC GC aC", "2": "ZC BC J DB K D E F A B C L M G N O P EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB WB XB YB ZB aB bB bC cC" }, D: { "16": "J DB K D E F A B C L M G N O P", "33": "0 1 2 3 4 5 6 7 8 9 EB u v w x y FB GB HB IB JB KB LB MB NB OB PB QB RB SB TB UB VB W