<?php
namespace App\Jobs;

use App\Models\BookingManagement;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendRideTimeoutJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $bookingId;

    /**
     * Create a new job instance.
     */
    public function __construct($bookingId)
    {
        $this->bookingId = $bookingId;
    }

    /**
     * Execute the job.
     */
    public function handle()
    {
        $booking = BookingManagement::find($this->bookingId);

        if ($booking && $booking->trip_status == 0) {
                                       // Update trip status to timeout
            $booking->trip_status = 4; // 4 = Timeout or No Driver Accepted
            $booking->save();

            // Optionally: notify user that no driver accepted
            // event(new RideTimeoutEvent($booking));
        }
    }
}
