<?php

// app/Http/Controllers/OtpController.php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class OtpController extends Controller
{

    public function verifyOtp(Request $request)
    {
        $request->validate([
            'booking_id' => 'required|exists:otp_codes,booking_id',
            'otp'        => 'required|digits:6',
        ]);

        $otpRecord = DB::table('otp_codes')
            ->where('booking_id', $request->booking_id)
            ->where('otp', $request->otp)
            ->first();

        if (! $otpRecord) {
            return response()->json(['message' => 'Invalid OTP.'], 400);
        }

        if (Carbon::now()->gt(Carbon::parse($otpRecord->expires_at))) {
            return response()->json(['message' => 'OTP has expired.'], 400);
        }

        // Optionally: mark OTP as used (if you track that)
        DB::table('otp_codes')
            ->where('booking_id', $request->booking_id)
            ->update([
                // 'otp_verified_at' => now(), // optional
                'updated_at' => now(),
            ]);

        return response()->json(['message' => 'OTP verified successfully.']);
    }

}
