<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class DriverTripDetailsController extends Controller
{
    public function driverTripDetails($driverId, $date)
    {

        $baseQuery = DB::table('fare_summaries')
            ->where('driver_id', $driverId)
            ->whereDate('end_date', $date);

        $totalPrice   = (clone $baseQuery)->sum('total_price');
        $num_of_trips = (clone $baseQuery)->count();

        $commissionPercentage = DB::table('settings')->value('commission_percentage') ?? 0;
        $commissionAmount     = round(($totalPrice * $commissionPercentage) / 100, 2);

        $trip = DB::table('trips')
            ->where('driver_id', $driverId)
            ->whereDate('trip_date', $date)
            ->first();

        if (! $trip) {
            // Insert new trip
            DB::table('trips')->insert([
                'driver_id'             => $driverId,
                'trip_date'             => $date,
                'amount'                => $totalPrice,
                'commission_percentage' => $commissionPercentage,
                'commission_amount'     => $commissionAmount,
                'trips_count'           => $num_of_trips,
                'payment_status'        => 0,
                'created_at'            => now(),
                'updated_at'            => now(),
            ]);
            $tripInserted = true;
        } else {
            // Step 4: Update existing trip
            $newPaymentStatus = 0;

            if ($trip->paid_amount == $commissionAmount) {
                $newPaymentStatus = 2;
            } elseif ($trip->paid_amount > 0 && $trip->paid_amount < $commissionAmount) {
                $newPaymentStatus = 1;
            }
            $newTripCount = $trip->trips_count + 1;

            DB::table('trips')
                ->where('id', $trip->id)
                ->update([
                    'amount'                => $totalPrice,
                    'commission_percentage' => $commissionPercentage,
                    'commission_amount'     => $commissionAmount,
                    'trips_count'           => $num_of_trips,
                    'payment_status'        => $newPaymentStatus,
                    'updated_at'            => now(),
                ]);

            $tripInserted = false;
        }

        return response()->json([
            'driver_id'             => $driverId,
            'date'                  => $date,
            'total_price'           => round($totalPrice, 2),
            'commission_percentage' => $commissionPercentage,
            'commission_amount'     => $commissionAmount,
            'trip_inserted'         => $tripInserted,
            'trips_count'           => $newTripCount,
        ]);
    }
}
