<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\ACommonController;
use App\Models\BookingManagement;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class BookingManagementController extends ACommonController
{

    public function dataindex(Request $request)
    {
        $recordsTotal    = 0;
        $recordsFiltered = 0;
        $draw            = $request->input('draw', '1');
        $start           = $request->input('start', '0');
        $length          = $request->input('length', '0');
        $columnsall      = $request->input('columns', []);
        $orderall        = $request->input('order', []);
        $dataResult      = [];
        $recordQry       = DB::table('booking_management')
            ->leftJoin('driver_management', 'booking_management.driver_id', '=', 'driver_management.id')
            ->leftJoin('otp_codes', 'booking_management.id', '=', 'otp_codes.booking_id')
            ->select(
                'booking_management.*',
                DB::raw("COALESCE(driver_management.driver_name, 'Not Accept') as DriverName"),
                'otp_codes.otp'
            );

        foreach ($columnsall as $key => $column_row) {
            $isSearchable = $column_row['searchable'];
            $dbcolname    = $column_row['data'];
            $dbcolval     = trim($column_row['search']['value']);

            if ($dbcolval !== "" && $isSearchable && ! is_numeric($key)) {

                switch ($dbcolname) {
                    case 'car_model':
                        $carbrandIds = DB::table('carbrand_management')
                            ->where('brand_name', 'like', '%' . $dbcolval . '%')
                            ->pluck('id');

                        $recordQry->where(function ($query) use ($dbcolval, $carbrandIds) {
                            $query->orWhere('vehicle_management.car_model', 'like', '%' . $dbcolval . '%')
                                ->orWhereIn('vehicle_management.carbrand_id', $carbrandIds)
                                ->orWhere('vehicle_management.fuel_type', 'like', '%' . $dbcolval . '%')
                                ->orWhere('vehicle_management.seat_capacity', 'like', '%' . $dbcolval . '%');
                        });
                        break;

                    default:
                        $recordQry->where($dbcolname, 'like', '%' . $dbcolval . '%');
                        break;
                }
            }
        }

        if ($orderall) {
            $ordtyp = $orderall[0]['dir'];
            if ($orderall[0]['column'] > 0) {
                $colsynt   = $orderall[0]['column'];
                $dbcolname = $columnsall[$colsynt]['data'];
                $recordQry->orderBy($dbcolname, $ordtyp);
            } else {
                $recordQry->orderBy('id', $ordtyp);
            }
        }
        $recordAllQry = $recordQry;
        $recordsTotal = $recordAllQry->count();
        $recordList   = $recordQry->orderBy('id', 'desc')
            ->offset($start)->limit($length)->get();
        $recordsFiltered = $recordList->count();
        $dataResult      = $recordList;

        return response()->json(["draw" => $draw, "recordsTotal" => $recordsTotal, "recordsFiltered" => $recordsTotal, "data" => $dataResult]);
    }

    public function index()
    {
        return view('admin.booking_management.list');
    }

    public function test()
    {

        $estimation = $this->getEstimatedAmountAndPackage([
            'cartype_id'     => 2,
            'ac_type'        => 'AC',
            'traveltype_id'  => 1,
            'estimated_km'   => 35,
            'estimated_time' => 4,
        ]);
        dd($estimation);

    }public function create()
    {

        $googleMapsApiKey = env('NEW_GOOGLE_MAPS_API_KEY');
        $drivers          = DB::table('driver_management')->select('id', 'latitude', 'longitude')
            ->where('online_status', '=', 'online')
            ->where('trip_status', 0)
            ->get();
        // dd($drivers);
        $traveltype = DB::table('travel_types')->get();
        $cartype    = DB::table('cartype_management')->get();

        return view('admin.booking_management.map
        ', compact('googleMapsApiKey', 'drivers', 'traveltype', 'cartype'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'notify_driver'  => 'required|in:single,all',
            'cartype'        => 'required',
            'customer_name'  => 'required|string|max:255',
            'phone'          => 'required|string|max:20',
            'from_address'   => 'required|string',
            'to_address'     => 'required|string',
            'from_latitude'  => 'required|numeric',
            'from_longitude' => 'required|numeric',
            'to_latitude'    => 'required|numeric',
            'to_longitude'   => 'required|numeric',
            'driver_id'      => 'required_if:notify_driver,single|nullable|exists:driver_management,id',
        ]);

        $booktime = date("H:i:s", strtotime($request->booking_time));

        // ✅ Get estimated amount & package before create
        $estimation = $this->getEstimatedAmountAndPackage([
            'cartype_id'     => $request->cartype,
            'ac_type'        => $request->vehicle_ac_type,
            'traveltype_id'  => $request->traveltype,
            'estimated_km'   => $request->distance_km,
            'estimated_time' => $request->estimated_hours,
        ]);
        if (count($estimation) > 0) {
            $booking = BookingManagement::create([
                'driver_id'           => $request->notify_driver === 'single' ? $request->driver_id : 0,
                'radius_km'           => $request->radiuskm,
                'ac_type'             => $request->vehicle_ac_type,
                'cartype_id'          => $request->cartype,
                'notify_driver'       => $request->notify_driver,
                'customer_name'       => $request->customer_name,
                'traveltype_id'       => $request->traveltype,
                'phone'               => $request->phone,
                'from_address'        => $request->from_address,
                'to_address'          => $request->to_address,
                'start_latitude'      => $request->from_latitude,
                'start_longitude'     => $request->from_longitude,
                'end_latitude'        => $request->to_latitude,
                'end_longitude'       => $request->to_longitude,
                'estimated_km'        => $request->distance_km,
                'estimated_time'      => $request->estimated_hours,
                'estimated_amount'    => $estimation['amount'],
                'estimated_packageid' => $estimation['package_id'],
                'booking_date'        => $request->booking_date,
                'booking_time'        => $booktime,
                'booking_dateTime'    => $request->booking_date . " " . $booktime,
            ]);

            // try {
            //     $this->getEstimatedAmountAndPackage($booking->id);
            // } catch (\Exception $e) {
            //     Log::error("Estimated Amount Error: " . $e->getMessage());
            // }

            // dd($booking);
            // Log::info('Booking Data:', $request->all());

            // if ($request->notify_driver === 'single') {
            //     $driverTokens = DB::table('driver_management')
            //         ->where('id', $request->driver_id)
            //         ->whereNotNull('device_id')
            //         ->pluck('device_id')
            //         ->toArray();
            // } else {
            //     // Send to all drivers within your logic (e.g., nearby or active drivers)
            //     $driverTokens = DB::table('driver_management')
            //         ->whereNotNull('device_id')
            //         ->where('online_status', '==', 'online')
            //         ->pluck('device_id')
            //         ->toArray();
            // }
            // if ($request->notify_driver === 'single') {
            //     // ✅ 1. Assign the booking directly to the selected driver
            //     DB::table('booking_management')
            //         ->where('id', $booking->id)
            //         ->update([
            //             'driver_id'      => $request->driver_id,
            //             'booking_status' => 2, // Example: Assigned
            //             'updated_at'     => now(),
            //         ]);

            //     //✅ 2. Send notification ONLY to that driver
            //     $driverTokens = DB::table('driver_management')
            //         ->where('id', $request->driver_id)
            //         ->whereNotNull('device_id')
            //         ->pluck('device_id')
            //         ->toArray();

            // } else {
            //     // Notify all available drivers (e.g., online status)
            //     $driverTokens = DB::table('driver_management')
            //         ->whereNotNull('device_id')
            //         ->where('online_status', 'online') // Fix the comparison
            //         ->pluck('device_id')
            //         ->toArray();
            // }
            if ($request->notify_driver === 'single') {
                // ✅ 1. Check if the driver is available
                $driver = DB::table('driver_management')
                    ->where('id', $request->driver_id)
                    ->where('trip_status', '!=', 1)    // Not on a trip
                    ->where('online_status', 'online') // Must be online
                    ->whereNotNull('device_id')        // Has device ID
                    ->first();

                if ($driver) {
                    // ✅ 2. Assign the booking directly to that driver
                    DB::table('booking_management')
                        ->where('id', $booking->id)
                        ->update([
                            'driver_id'      => $request->driver_id,
                            'booking_status' => 2, // Assigned
                            'updated_at'     => now(),
                        ]);

                                                          // ✅ 3. Send notification to that specific driver
                    $driverTokens = [$driver->device_id]; // Wrap in array for chunking below
                } else {
                    return redirect()->route('admin.BookingManagement-index')
                        ->with('error', 'Selected driver is not available (offline or on a trip).');
                }
            } else {
                // ✅ Notify all available online drivers
                $driverTokens = DB::table('driver_management')
                    ->where('online_status', 'online')
                    ->where('trip_status', '!=', 1)
                    ->whereNotNull('device_id')
                    ->pluck('device_id')
                    ->toArray();
            }

            // 🔁 Chunk to 100 tokens per Expo request
            $chunks = array_chunk($driverTokens, 100);

            foreach ($chunks as $tokensChunk) {
                $messages = [];

                foreach ($tokensChunk as $token) {
                    if (str_starts_with($token, 'ExponentPushToken')) {
                        $messages[] = [
                            'to'    => $token,
                            'sound' => 'default',
                            'title' => $request->notify_driver === 'single' ? 'Ride Assigned' : 'New Ride Request',
                            'body'  => $request->notify_driver === 'single'
                            ? 'A ride has been assigned to you directly.'
                            : 'Tap to accept the new ride request.',
                            'data'  => [
                                'booking_id'   => $booking->id,
                                'from_address' => $booking->from_address,
                                'to_address'   => $booking->to_address,
                                'screen'       => '/app/index',
                            ],
                        ];
                    }
                }

                // Send push to Expo
                $response = Http::withHeaders([
                    'Accept'       => 'application/json',
                    'Content-Type' => 'application/json',
                ])->post('https://exp.host/--/api/v2/push/send', $messages);

                // Optional: Log or handle errors
                if (! $response->successful()) {
                    Log::error('Expo Push failed', ['response' => $response->body()]);
                }
            }

            event(new \App\Events\SendRideRequestEvent($booking));
            // SendExpoNotificationJob::dispatch($booking, $driverTokens);

            // SendRideTimeoutJob::dispatch($booking->id)->delay(now()->addSeconds(30));

            return redirect()->route('admin.BookingManagement-index')->with('success', 'Ride created successfully!');

        } else {
            return redirect()->route('admin.BookingManagement-index')->with('error', 'Error occurred');

        }

    }

    public function store1(Request $request)
    {
        $request->validate([
            'notify_driver'  => 'required|in:single,all',
            'customer_name'  => 'required|string|max:255',
            'phone'          => 'required|string|max:20',
            'from_address'   => 'required|string',
            'to_address'     => 'required|string',
            'from_latitude'  => 'required|numeric',
            'from_longitude' => 'required|numeric',
            'to_latitude'    => 'required|numeric',
            'to_longitude'   => 'required|numeric',
            'driver_id'      => 'required_if:notify_driver,single|nullable|exists:driver_management,id',
        ]);
        $booktime = date("H:i:s", strtotime($request->booking_time));
        $booking  = BookingManagement::create([
            'driver_id'        => $request->notify_driver === 'single' ? $request->driver_id : 0,
            'radius_km'        => $request->radiuskm,
            'ac_type'          => $request->vehicle_ac_type,
            'cartype_id'       => $request->cartype,
            'notify_driver'    => $request->notify_driver,
            'customer_name'    => $request->customer_name,
            'traveltype_id'    => $request->traveltype,
            'phone'            => $request->phone,
            'from_address'     => $request->from_address,
            'to_address'       => $request->to_address,
            'start_latitude'   => $request->from_latitude,
            'start_longitude'  => $request->from_longitude,
            'end_latitude'     => $request->to_latitude,
            'end_longitute'    => $request->to_longitude,
            'booking_date'     => $request->booking_date,
            'booking_time'     => $booktime,
            'booking_dateTime' => $request->booking_date . " " . $booktime,
        ]);

        // Get tokens
        if ($request->notify_driver === 'single') {
            $driverTokens = DB::table('driver_management')
                ->where('id', $request->driver_id)
                ->whereNotNull('device_id')
                ->pluck('device_id')
                ->toArray();
        } else {
            $driverTokens = DB::table('driver_management')
                ->whereNotNull('device_id')
                ->where('online_status', 'online') // single =, not ==
                ->pluck('device_id')
                ->toArray();
        }

        // Send push notification via Firebase
        foreach ($driverTokens as $token) {
            $payload = [
                'to'           => $token,
                'notification' => [
                    'title' => 'New Ride Request',
                    'body'  => 'Tap to accept the new ride request',
                    'sound' => 'default',
                ],
                'data'         => [
                    'booking_id'   => $booking->id,
                    'from_address' => $booking->from_address,
                    'to_address'   => $booking->to_address,
                    'screen'       => '/app/index', // Adjust to your frontend route
                ],
            ];

            $response = Http::withHeaders([
                'Authorization' => 'key=' . config('services.firebase.server_key'),
                'Content-Type'  => 'application/json',
            ])->post('https://fcm.googleapis.com/fcm/send', $payload);

            if (! $response->successful()) {
                Log::error('FCM Push Failed', [
                    'token'    => $token,
                    'response' => $response->body(),
                ]);
            }
        }

        // Trigger backend events if needed
        event(new \App\Events\SendRideRequestEvent($booking));
        // SendRideTimeoutJob::dispatch($booking->id)->delay(now()->addSeconds(30));

        return redirect()->route('admin.BookingManagement-index')->with('success', 'Ride created and notification sent!');
    }

    public function edit(Request $request, $id)
    {
        $getRow     = DB::table('booking_management')->where('id', $id)->first();
        $get_driver = DB::table('driver_management')->where('id', $getRow->driver_id)->first();

        $googleMapsApiKey = env('NEW_GOOGLE_MAPS_API_KEY');
        $drivers          = DB::table('driver_management')->select('id', 'latitude', 'longitude')
            ->where('online_status', '=', 'online')
            ->where('trip_status', 0)
            ->get();

        return view('admin.booking_management.edit', compact('getRow', 'get_driver', 'googleMapsApiKey', 'drivers'));
    }

    public function update(Request $request, $id)
    {
        try {

            DB::beginTransaction();

            $driver = DB::table('vehicle_management')->where('id', $id)->first();

            $updateData = [
                'carbrand_id'   => $request->car_brand,
                'car_model'     => $request->car_model,
                'cartype_id'    => $request->car_type,
                'fuel_type'     => $request->fuel_type,
                'seat_capacity' => $request->seat_capacity,
                'status'        => $request->status,
                'updated_at'    => now(),
            ];

            DB::table('vehicle_management')->where('id', $id)->update($updateData);

            DB::commit();

            return redirect()->route('admin.VehicleManagement-index')
                ->with('success', 'Vehicle updated successfully');
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()
                ->with('error', 'Error updating driver: ' . $e->getMessage())
                ->withInput();
        }
    }

    public function show($id)
    {
        $getRow     = DB::table('booking_management')->where('id', $id)->first();
        $get_driver = DB::table('driver_management')->where('id', $getRow->driver_id)->first();

        return view('admin.booking_management.view', compact('getRow', 'get_driver'));

    }

    public function destroy($id)
    {
        try {
            DB::beginTransaction();

            $driver = DB::table('vehicle_management')->where('id', $id)->first();
            if (! $driver) {
                return response()->json(['status' => 404, 'message' => 'Driver not found']);
            }

            DB::table('vehicle_management')->where('id', $id)->delete();

            DB::commit();
            return response()->json(['status' => 200, 'message' => 'Deleted successfully']);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['status' => 500, 'message' => 'Error: ' . $e->getMessage()]);
        }
    }

    public function updateStatus(Request $request)
    {
        $request->validate([
            'id'     => 'required|integer|exists:vehicle_management,id',
            'status' => 'required|boolean',
        ]);

        DB::table('vehicle_management')
            ->where('id', $request->id)
            ->update(['status' => $request->status, 'updated_at' => now()]);

        return response()->json(['message' => 'Status updated successfully']);
    }

    public function getNearbyDrivers(Request $request)
    {
        $request->validate([
            'latitude'  => 'required|numeric',
            'longitude' => 'required|numeric',
            'radius_km' => 'nullable|numeric',
        ]);

        $latitude  = $request->latitude;
        $longitude = $request->longitude;
        $radius    = $request->radius_km ?? 3; // Default to 3 km if not provided

        $drivers = DB::table('driver_management')
            ->where('online_status', '=', 'online')
            ->where('trip_status', 0)
            ->select('id', 'driver_name', 'latitude', 'longitude')
            ->selectRaw('(6371 * acos(cos(radians(?)) * cos(radians(latitude)) * cos(radians(longitude) - radians(?)) + sin(radians(?)) * sin(radians(latitude)))) AS distance', [$latitude, $longitude, $latitude])
            ->having('distance', '<=', $radius)
            ->get();

        return response()->json($drivers);
    }

    public function getEstimatedAmountAndPackage(array $data): array
    {
        $setting = DB::table('settings')->where('id', 1)->first();
        $package = DB::table('packages as p')
            ->join('outstation_package as op', function ($join) use ($data) {
                $join->on('p.id', '=', 'op.package_id')
                    ->where('op.cartype_id', $data['cartype_id'])
                    ->where('op.inout_type', $data['traveltype_id']);
            })
            ->where('p.traveltype_id', $data['traveltype_id'])
            ->where('p.km', '<=', $data['estimated_km'])
            ->orderBy('p.km', 'desc')
            ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type', 'op.per_hours_ac_price', 'op.per_hours_price', 'op.below50kmhrcharge', 'op.below100kmhrcharge', 'op.above100kmhrcharge')
            ->first();

        if (! $package) {

            $package = DB::table('packages as p')
                ->join('outstation_package as op', function ($join) use ($data) {
                    $join->on('p.id', '=', 'op.package_id')
                        ->where('op.cartype_id', $data['cartype_id'])
                        ->where('op.inout_type', $data['traveltype_id']);
                })
                ->where('p.traveltype_id', $data['traveltype_id'])
                ->orderBy('p.km', 'asc')
                ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type', 'op.per_hours_ac_price', 'op.per_hours_price', 'op.below50kmhrcharge', 'op.below100kmhrcharge', 'op.above100kmhrcharge')
                ->first();

        }

        if (! $package) {
            return [];
        }

        $isMinutes = false;

        $rate             = $data['ac_type'] === 'AC' ? $package->ac_price : $package->nonac_price;
        $additionalKMrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
        $additionalhrrate = $data['ac_type'] === 'AC' ? $package->per_hours_ac_price : $package->per_hours_price;
        $includedKm       = $package->included_km;
        $includedHr       = $package->free_hours;
        $extraKm          = max(0, $data['estimated_km'] - $includedKm);
        $extrahrs         = 0;

        $baseFare      = $rate;
        $extraFare     = $additionalKMrate * $extraKm;
        $hrcharge      = 0;
        $extrahrcharge = 0;
        $perhrcharge   = 0;
        if ($data['estimated_time'] > $includedHr) {
            $extrahrs = max(0, $data['estimated_time'] - $includedHr);
            if ($data['traveltype_id'] == 2) {
                if ($data['estimated_km'] > 100) {
                    $perhrcharge = $package->above100kmhrcharge;
                } elseif ($data['estimated_km'] >= 51) {
                    $perhrcharge = $package->below100kmhrcharge;
                } else {
                    $perhrcharge = $package->below50kmhrcharge;
                }
            } else {
                $perhrcharge = $package->per_hours_price;
            }
            $extrahrcharge = $extrahrs * $perhrcharge;
        }
        $waitingcharge = 0;
        if ($package->local_type == 2) {
            $extrahrcharge        = 0;
            $isMinutes            = true;
            $allowedwaitingmin    = $data['estimated_km'] * $setting->waitingminperkm;
            $estimatedtime_to_min = $data['estimated_time'] * 60;
            if ($estimatedtime_to_min > $allowedwaitingmin) {
                $waitingcharge = max(0, $estimatedtime_to_min - $allowedwaitingmin) * $setting->waitingchargepermin;
            }
        }

        $totalCost = $baseFare + $extraFare + $hrcharge + $waitingcharge;

        return [
            'package_id'          => $package->package_id,
            'amount'              => $totalCost,
            'additional_kmrate'   => $additionalKMrate,
            'additionalperhrrate' => $perhrcharge,
            'totalKm'             => $data['estimated_km'],
            'baseKm'              => $includedKm,
            'extraKm'             => $extraKm,
            'totalTime'           => $data['estimated_time'],
            'freehours'           => $includedHr,
            'baseFare'            => $baseFare,
            'extraKmFare'         => $extraFare,
            'extraHourFare'       => $extrahrcharge,
            'waitingcharge'       => $waitingcharge,
            'is_minutes'          => $isMinutes ? 1 : 0,
        ];
    }
    // For sending WhatsApp API

    public function sendOtp(Request $request)
    {
        $booking = DB::table('booking_management as bm')
            ->join('driver_management as dm', 'bm.driver_id', '=', 'dm.id')
            ->join('otp_codes as oc', 'bm.id', '=', 'oc.booking_id')
            ->where('bm.id', $request->booking_id)
            ->select('bm.phone', 'oc.otp')
            ->first();

        if (! $booking) {
            return response()->json(['status' => false, 'message' => 'Booking or OTP not found']);
        }

        $message = "Your ride OTP is: {$booking->otp}";

        // ✅ Send the message
        $x = $this->sendWelcomeSms($booking->phone, 'text', $message);

        // ✅ Optional: log or inspect $x if needed

        return response()->json(['status' => true, 'message' => 'OTP sent successfully']);
    }
    public function cancelRide(Request $request)
    {
        $request->validate([
            'booking_id'    => 'required|exists:booking_management,id',
            'cancel_reason' => 'required|string|max:255',
        ]);

        DB::table('booking_management')
            ->where('id', $request->booking_id)
            ->update([
                'booking_status' => 5,
                'cancel_reason'  => $request->cancel_reason,
                'updated_at'     => now(),
            ]);

        return response()->json([
            'status'  => true,
            'message' => 'Ride has been cancelled successfully.',
        ]);
    }

    // public function getEstimatedAmountAndPackage1(array $data): array
    // {
    //     $setting = DB::table('settings')->where('id', 1)->first();

    //     $package = DB::table('packages as p')
    //         ->join('outstation_package as op', function ($join) use ($data) {
    //             $join->on('p.id', '=', 'op.package_id')
    //                 ->where('op.cartype_id', $data['cartype_id'])
    //                 ->where('op.inout_type', $data['traveltype_id']);
    //         })
    //         ->where('p.traveltype_id', $data['traveltype_id'])
    //         ->where('p.km', '<=', $data['estimated_km'])
    //         ->orderBy('p.km', 'desc')
    //         ->select(
    //             'p.id as package_id',
    //             'p.km as included_km',
    //             'p.free_hours as free_hours',
    //             'op.ac_price',
    //             'op.additionalperkm_ac_price',
    //             'op.additionalperkm_nonac_price',
    //             'op.nonac_price',
    //             'op.local_type'
    //         )
    //         ->first();

    //     if (! $package) {
    //         $package = DB::table('packages as p')
    //             ->join('outstation_package as op', function ($join) use ($data) {
    //                 $join->on('p.id', '=', 'op.package_id')
    //                     ->where('op.cartype_id', $data['cartype_id'])
    //                     ->where('op.inout_type', $data['traveltype_id']);
    //             })
    //             ->where('p.traveltype_id', $data['traveltype_id'])
    //             ->orderBy('p.km', 'asc')
    //             ->select(
    //                 'p.id as package_id',
    //                 'p.km as included_km',
    //                 'p.free_hours as free_hours',
    //                 'op.ac_price',
    //                 'op.additionalperkm_ac_price',
    //                 'op.additionalperkm_nonac_price',
    //                 'op.nonac_price',
    //                 'op.local_type'
    //             )
    //             ->first();
    //     }

    //     // ✅ Custom rule for short local ride < 10 km
    //     if ($package->local_type == 2 && $data['estimated_km'] < 10) {
    //         $baseFare     = 100; // ₹100 up to 3km
    //         $additionalKm = max(0, $data['estimated_km'] - 3);

    //         $additionalRate = $data['ac_type'] === 'AC' ? 22 : 20;
    //         $extraFare      = $additionalKm * $additionalRate;

    //                                                       // estimated_time is considered in minutes directly
    //         $waitingcharge = $data['estimated_time'] * 2; // ₹2 per minute

    //         $totalCost = $baseFare + $extraFare + $waitingcharge;

    //         return [
    //             'package_id'          => $package->package_id,
    //             'amount'              => $totalCost,
    //             'additional_kmrate'   => $additionalRate,
    //             'additionalperhrrate' => 0,
    //             'extraKm'             => $additionalKm,
    //             'waitingcharge'       => $waitingcharge,
    //             'baseFare'           => $baseFare,
    //             'extraFare'           => $extraFare,
    //             'hrcharge'            => 0,
    //         ];
    //     }

    //     // ✅ Normal estimation logic (as in your original code)
    //     $rate             = $data['ac_type'] === 'AC' ? $package->ac_price : $package->nonac_price;
    //     $additionalKMrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
    //     $additionalhrrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
    //     $includedKm       = $package->included_km;
    //     $extraKm          = max(0, $data['estimated_km'] - $includedKm);

    //     $baseFare  = $rate;
    //     $extraFare = $additionalKMrate * $extraKm;
    //     $hrcharge  = 0;

    //     if ($data['estimated_time'] > $package->free_hours) {
    //         $extrahrs = max(0, $data['estimated_time'] - $package->free_hours);
    //         if ($data['traveltype_id'] == 2) {
    //             if ($data['estimated_km'] > 100) {
    //                 $hrcharge = $package->above100kmhrcharge ?? 0;
    //             } elseif ($data['estimated_km'] >= 51) {
    //                 $hrcharge = $package->below100kmhrcharge ?? 0;
    //             } else {
    //                 $hrcharge = $package->below50kmhrcharge ?? 0;
    //             }
    //         } else {
    //             $hrcharge = $package->per_hours_price ?? 0;
    //         }
    //     }

    //     $waitingcharge = 0;
    //     if ($package->local_type == 2) {
    //         $allowedwaitingmin    = $includedKm * $setting->waitingminperkm;
    //         $estimatedtime_to_min = $data['estimated_time'] * 60;
    //         if ($estimatedtime_to_min > $allowedwaitingmin) {
    //             $waitingcharge = max(0, $estimatedtime_to_min - $allowedwaitingmin) * $setting->waitingchargepermin;
    //         }
    //     }

    //     $totalCost = $baseFare + $extraFare + $hrcharge + $waitingcharge;

    //     return [
    //         'package_id'          => $package->package_id,
    //         'amount'              => $totalCost,
    //         'additional_kmrate'   => $additionalKMrate,
    //         'additionalperhrrate' => $additionalhrrate,
    //         'extraKm'             => $extraKm,
    //         'waitingcharge'       => $waitingcharge,
    //         'baseFare'           => $baseFare,
    //         'extraFare'           => $extraFare,
    //         'hrcharge'            => $hrcharge,
    //         'is_minutes'          => 0,
    //     ];
    // }

}
