<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AcceptRideController extends Controller
{

    // public function acceptRide1(Request $request)
    // {
    //     $request->validate([
    //         'booking_id' => 'required|exists:booking_management,id',
    //     ]);

    //     $driver = auth('api_driver')->user();

    //     try {
    //         DB::beginTransaction();

    //         // Lock the booking row for update
    //         $booking = DB::table('booking_management')
    //             ->where('id', $request->booking_id)
    //             ->lockForUpdate()
    //             ->first();

    //         // If booking is already accepted
    //         if ($booking->trip_status == 1) {
    //             DB::rollBack();
    //             return response()->json(['message' => 'Ride already accepted.'], 400);
    //         }

    //         // Update the booking
    //         DB::table('booking_management')
    //             ->where('id', $request->booking_id)
    //             ->update([
    //                 'driver_id'   => $driver->id,
    //                 'trip_status' => 1,
    //             ]);

    //         // Update driver trip status
    //         DB::table('driver_management')
    //             ->where('id', $driver->id)
    //             ->update([
    //                 'trip_status' => 1,
    //             ]);

    //         DB::commit();

    //         return response()->json(['message' => 'Ride accepted successfully.']);

    //     } catch (\Exception $e) {
    //         DB::rollBack();
    //         return response()->json(['message' => 'Something went wrong.', 'error' => $e->getMessage()], 500);
    //     }
    // }

    public function acceptRide(Request $request)
    {
        $request->validate([
            'booking_id' => 'required|exists:booking_management,id',
        ]);

        $driver = auth('api_driver')->user();

        try {
            DB::beginTransaction();

            // Lock the booking row for update
            $booking = DB::table('booking_management')
                ->where('id', $request->booking_id)
                ->lockForUpdate()
                ->first();

            if ($booking->trip_status == 1) {
                DB::rollBack();
                return response()->json(['message' => 'Ride already accepted.'], 400);
            }

            // Update booking
            DB::table('booking_management')
                ->where('id', $request->booking_id)
                ->update([
                    'driver_id'   => $driver->id,
                    'trip_status' => 1,
                ]);

            // Update driver status
            DB::table('driver_management')
                ->where('id', $driver->id)
                ->update(['trip_status' => 1]);

            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['message' => 'Transaction failed.', 'error' => $e->getMessage()], 500);
        }

        // OTP Generation and Handling
        try {
            $booking = DB::table('booking_management')
                ->find($request->booking_id);

            $phone     = $booking->phone; // Verify column name
            $otp       = rand(100000, 999999);
            $expiresAt = Carbon::now()->addMinutes(30);

            // Save OTP with booking ID
            DB::table('otp_codes')->insert([
                'booking_id' => $request->booking_id,
                'driver_id'  => $driver->id,
                'phone'      => $phone,
                'otp'        => $otp,
                'expires_at' => $expiresAt,
                'updated_at' => now(),
                'created_at' => now(), // Optional: Add if your table uses timestamps
            ]);

            $message = "Your ride OTP is: $otp";
            $x       = $this->sendWelcomeSms($phone, 'text', $message);

            // Send SMS
            // $twilio = new Client(env('TWILIO_SID'), env('TWILIO_AUTH_TOKEN'));
            // $twilio->messages->create(
            //     '+91' . $phone,
            //     [
            //         'from' => env('TWILIO_SMS_FROM'),
            //         'body' => "Your ride OTP is: $otp",
            //     ]
            // );

            return response()->json([
                'message' => 'Ride accepted and OTP sent successfully.',
                'otp'     => $otp, // Remove in production
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Ride accepted but OTP failed to send.',
                'error'   => $e->getMessage(),
            ], 200);
        }
    }

}
