<?php $__env->startSection('style1'); ?>
<style>
    #map {
        height: 500px;
        width: 100%;
        margin-top: 20px;
        border: 1px solid #ddd;
        border-radius: 4px;
    }
    .pac-container {
        z-index: 1051 !important;
    }


</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contentarea'); ?>
<div class="container mt-4">
    <h4>Route Picker</h4>
    <form action="<?php echo e(route('admin.BookingManagement-store')); ?>" method="POST" enctype="multipart/form-data" name="booking_form" id="booking_form" onsubmit="return validateForm();">
        <?php echo csrf_field(); ?>

        <div class="row g-2">
            <div class="mb-3 col-md-3">
                <label for="notify_driver" class="form-label">Notify Driver(s)</label>
                <select id="notify_driver" class="form-select" name="notify_driver" onchange="toggleDriverRequirement()">
                    <option value="" disabled selected>---Select Notify Driver(s)--</option>
                    <option value="single">Single</option>
                    <option value="all">All</option>
                </select>        
<?php $__errorArgs = ['notify_driver'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
    <small class="text-danger"><?php echo e($message); ?></small>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-3 col-md-3">
                <label for="cartype" class="form-label">Cartype Type</label>
                <select id="cartype" class="form-select" name="cartype">
                    <option value="" disabled selected>---Select cartype(s)--</option>
                    <?php $__currentLoopData = $cartype; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cartypes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($cartypes->id); ?>"><?php echo e($cartypes->car_type); ?></option>
                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>  
                <?php $__errorArgs = ['cartype'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
    <small class="text-danger"><?php echo e($message); ?></small>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>      
            </div>
            
            <div class="mb-3 col-md-3">
    <label for="traveltype" class="form-label">Trip Type</label>
    <select id="trip_type" class="form-select" name="trip_type">
        <option value="" disabled selected>---Select Trip Type--</option>
        <option value="1">Round</option>
        <option value="2">Drop</option>
    </select>
    <?php $__errorArgs = ['trip_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
<small class="text-danger"><?php echo e($message); ?></small>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
</div>


            <div class="mb-3 col-md-3">
                <label for="traveltype" class="form-label">Package Type</label>
                <select id="traveltype" class="form-select" name="traveltype">
                    <option value="" disabled selected>---Select traveltype(s)--</option>
                    <?php $__currentLoopData = $traveltype; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $traveltypes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($traveltypes->id); ?>"><?php echo e($traveltypes->package_name); ?></option>
                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>    
                <?php $__errorArgs = ['traveltype'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
    <small class="text-danger"><?php echo e($message); ?></small>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>    
            </div>


            <div class="mb-3 col-md-3" >
                <label class="form-label">Vehicle A/C Type</label>
                <div class="mt-2 d-flex align-items-center gap-4">
                    <div class="form-check form-check-inline">
                        <input type="radio" class="form-check-input" id="vehicleAc" name="vehicle_ac_type" value="AC" checked>
                        <label class="form-check-label" for="vehicleAc">A/C</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input type="radio" class="form-check-input" id="vehicleNonAc" name="vehicle_ac_type" value="Non-AC">
                        <label class="form-check-label" for="vehicleNonAc">Non A/C</label>
                    </div>
                </div>
                               <?php $__errorArgs = ['vehicle_ac_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
    <small class="text-danger"><?php echo e($message); ?></small>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>     
            </div>



        

        <input type="hidden" name="driver_id" id="driver_id">
      

         <!-- Date Picker -->
   <div class="mb-3 col-md-3">
     <label class="form-label">Booking Date</label>
        <div class="input-group" id="flatpickr-datepicker-preview">
           
            <input type="text" id="basic-datepicker" class="form-control" placeholder="Basic datepicker" name="booking_date" id="booking_date">
            <span class="input-group-text"><i class="ri-calendar-line"></i></span>

        </div>
        <?php $__errorArgs = ['booking_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
    <small class="text-danger"><?php echo e($message); ?></small>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

    <!-- Time Picker -->

<div class="mb-3 col-md-3 position-relative">
    <label class="form-label">Booking Time</label>
       <div class="input-group" id="timepicker-input-group3">
        <input id="timepicker3" type="text" class="form-control" data-provide='timepicker' data-minute-step="5" name="booking_time" id="booking_time">
        <span class="input-group-text"><i class="ri-time-line"></i></span>
    </div>
    <?php $__errorArgs = ['booking_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
    <small class="text-danger"><?php echo e($message); ?></small>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
</div>



        <div class="mb-3 col-md-3">
                <label  class="form-label">Radius KM</label>
                <select id="radiuskm" class="form-select" name="radiuskm">
                    <option value="" disabled>---Select radiuskm(s)--</option>
                    <option value="3" selected> 3 KM</option>
                    <option value="5"> 5 KM</option>
                    <option value="7"> 7 KM</option>
                    <option value="10"> 10 KM</option>
                 
                </select>  
                
                <?php $__errorArgs = ['radiuskm'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
    <small class="text-danger"><?php echo e($message); ?></small>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>


    

</div>


    
        <div class="row g-2">
            <div class="mb-3 col-md-6">
                <label for="customer_name" class="form-label">Customer Name</label>
                <input type="text" id="customer_name" name="customer_name" class="form-control">
                <?php $__errorArgs = ['customer_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
    <small class="text-danger"><?php echo e($message); ?></small>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="mb-3 col-md-6">
                <label for="phone" class="form-label">Phone Number</label>
                <input class="form-control" type="text" id="phone"  name="phone" autocomplete="new-phone">
                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
    <small class="text-danger"><?php echo e($message); ?></small>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
        </div>

        <div class="row g-2">

                <div class="col-md-6">
                    <label class="form-label">From Location</label>
                    <input type="text" id="fromAddress" name="from_address" class="form-control" placeholder="Enter starting location">
                    <input type="hidden" id="fromLatitude" name="from_latitude">
                    <input type="hidden" id="fromLongitude" name="from_longitude">
                    <?php $__errorArgs = ['from_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
    <small class="text-danger"><?php echo e($message); ?></small>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="col-md-6">
                    <label class="form-label">To Location</label>
                    <input type="text" id="toAddress" name="to_address" class="form-control" placeholder="Enter destination location">
                    <input type="hidden" id="toLatitude" name="to_latitude">
                    <input type="hidden" id="toLongitude" name="to_longitude">
                    <input type="hidden" id="distance_km" name="distance_km">
                    <input type="hidden" id="duration_text" name="duration_text">
                    <?php $__errorArgs = ['to_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
    <small class="text-danger"><?php echo e($message); ?></small>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="col-md-6">
                    <label><strong> Estimated Distance:</strong> <span id="distanceDisplay">--</span> km</label>
                </div>
                <div class="col-md-6">
                    <input type="hidden" id="estimated_hours" name="estimated_hours" value="">

                <label><strong> Estimated Time:</strong> <span id="durationDisplay">--</span></label>
                </div>
<div class="col-md-12">Online Free Driver Count  - <span id="onlinefreeavilabledrivercount"></span></div>

                <div class="col-md-12"><div id="map"></div>
                </div>
<div class="col-md-12">
                <div class="mt-4 mb-3" style="float: right">
            <button type="submit" class="btn btn-primary">Save Route</button>
        </div></div>

            </div>
        

        

        
    </form>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script1'); ?>
<script>

    let drivers = <?php echo json_encode($drivers, 15, 512) ?>;
    let map;
    let fromMarker;
    let toMarker;
    let directionsService;
    let directionsRenderer;
    let fromAutocomplete;
    let toAutocomplete;
    let fromLocation = null;
    let toLocation = null;
    let geocoder;
    let selectedDriverMarker = null;


  // {lat: 9.93900, lng: 78.09420}, // Othakadai Bus Stop
        // {lat: 9.93500, lng: 78.11000}, // Kadhakaman
        // {lat: 9.93000, lng: 78.12500}, // Oomachikulam
        // {lat: 9.92500, lng: 78.13500}, // Panakadi
        // {lat: 9.92000, lng: 78.14500}, // Chikartharachavadi
        // {lat: 9.91500, lng: 78.14000}, // Vilakudi
        // {lat: 9.91000, lng: 78.13000}, // Queenmina School
        // {lat: 9.90500, lng: 78.12000}, // Nagamalai Puthukottai
        // {lat: 9.90000, lng: 78.11000}, // Mullai Nagar
        // {lat: 9.89500, lng: 78.10000}, // Airport - Perungudi
        // {lat: 9.89000, lng: 78.09500}, // Chinthamani Signal
        // {lat: 9.88500, lng: 78.09000}, // Viraganoor Ring Road
        // {lat: 9.93900, lng: 78.09420}  // Close polygon
     
        const maduraiBoundary = [  
    {lat: 9.93900, lng: 78.09420}, // Othakadai Bus Stop
    {lat: 9.93000, lng: 78.12500}, // Oomachikulam
    {lat: 9.92500, lng: 78.13500}, // Panakadi
    {lat: 9.92000, lng: 78.14500}, // Chikartharachavadi
    {lat: 9.91500, lng: 78.14000},//vilankudi
    {lat: 9.91000, lng: 78.13000}, // Queenmina School
    {lat: 9.89500, lng: 78.14800}, // ✅ Kadhakinaru
    {lat: 9.88050, lng: 78.15520}, // ✅ Virapanjan
    {lat: 9.88570, lng: 78.12050}, // ✅ Thanakkankulam
    {lat: 9.90000, lng: 78.11000}, // Mullai Nagar
    {lat: 9.89500, lng: 78.10000}, // Airport - Perungudi
    {lat: 9.89000, lng: 78.09500}, // Chinthamani Signal
    {lat: 9.88500, lng: 78.09000}, // Viraganoor Ring Road
    {lat: 9.93900, lng: 78.09420}  // Close polygon
];
//  const maduraiBoundary = [    
// {lat: 9.7619706, lng: 78.1368692},
// {lat: 9.7756317, lng: 78.138628},
// {lat: 9.7803261, lng: 78.1397867},
// {lat: 9.7820178, lng: 78.1415891},
// {lat: 9.7836249, lng: 78.1435203},
// {lat: 9.7847244, lng: 78.144207},
// {lat: 9.7873887, lng: 78.1455802},
// {lat: 9.788446, lng: 78.1456232},
// {lat: 9.7936477, lng: 78.1459236},
// {lat: 9.7948318, lng: 78.1439495},
// {lat: 9.7949164, lng: 78.1422329},
// {lat: 9.7960582, lng: 78.1403875},
// {lat: 9.7990608, lng: 78.1397867},
// {lat: 9.801429, lng: 78.1397008},
// {lat: 9.8031628, lng: 78.1399154},
// {lat: 9.8078145, lng: 78.1406021},
// {lat: 9.8087872, lng: 78.1420183},
// {lat: 9.8081106, lng: 78.1466102},
// {lat: 9.8074339, lng: 78.1501722},
// {lat: 9.8066305, lng: 78.153691199999983},
// {lat: 9.8051927, lng: 78.1562662},
// {lat: 9.8040086, lng: 78.1591415},
// {lat: 9.8027399, lng: 78.161416},
// {lat: 9.8005832, lng: 78.1630897},
// {lat: 9.7986802, lng: 78.1656217},
// {lat: 9.7984687, lng: 78.1671667},
// {lat: 9.7977921, lng: 78.169870299999985},
// {lat: 9.7969886, lng: 78.1709861},
// {lat: 9.7946627, lng: 78.1715869},
// {lat: 9.7927596, lng: 78.1718015},
// {lat: 9.7904337, lng: 78.1717586},
// {lat: 9.7835403, lng: 78.170042},
// {lat: 9.7821869, lng: 78.1686258},
// {lat: 9.7817217, lng: 78.1666517},
// {lat: 9.7817217, lng: 78.1643772},
// {lat: 9.7806645, lng: 78.162961},
// {lat: 9.7785076, lng: 78.1620597},
// {lat: 9.7767313, lng: 78.1615018},
// {lat: 9.7747859, lng: 78.1611156},
// {lat: 9.7745744, lng: 78.162832199999983},
// {lat: 9.7752934, lng: 78.165106699999981},
// {lat: 9.7754203, lng: 78.1681966},
// {lat: 9.7752934, lng: 78.172144799999984},
// {lat: 9.7740669, lng: 78.1737756},
// {lat: 9.7728404, lng: 78.1750202},
// {lat: 9.7725867, lng: 78.1775522},
// {lat: 9.7744052, lng: 78.1787538},
// {lat: 9.7807067, lng: 78.1795263},
// {lat: 9.7831596, lng: 78.180084199999982},
// {lat: 9.7866698, lng: 78.1808137},
// {lat: 9.7889535, lng: 78.1816721},
// {lat: 9.7918292, lng: 78.1836032},
// {lat: 9.7945358, lng: 78.1870794},
// {lat: 9.7974538, lng: 78.1900835},
// {lat: 9.8005832, lng: 78.1911134},
// {lat: 9.8043892, lng: 78.1925296},
// {lat: 9.8064613, lng: 78.1936025},
// {lat: 9.8084489, lng: 78.1924438},
// {lat: 9.810521, lng: 78.1900405},
// {lat: 9.8123393, lng: 78.1878089},
// {lat: 9.8147074, lng: 78.1868219},
// {lat: 9.8183864, lng: 78.183388699999981},
// {lat: 9.8201624, lng: 78.1817579},
// {lat: 9.8225305, lng: 78.1802988},
// {lat: 9.8232493, lng: 78.1775522},
// {lat: 9.8240951, lng: 78.1743764},
// {lat: 9.8250254, lng: 78.1723594},
// {lat: 9.8274356, lng: 78.1711578},
// {lat: 9.8292539, lng: 78.170042},
// {lat: 9.8302265, lng: 78.16854},
// {lat: 9.8290425, lng: 78.1645488},
// {lat: 9.8287888, lng: 78.162446},
// {lat: 9.8288734, lng: 78.1586694},
// {lat: 9.8290002, lng: 78.155579499999988},
// {lat: 9.8283236, lng: 78.1536054},
// {lat: 9.8272665, lng: 78.1527471},
// {lat: 9.8253636, lng: 78.1526613},
// {lat: 9.8232916, lng: 78.153090399999982},
// {lat: 9.8218962, lng: 78.153519599999981},
// {lat: 9.8200779, lng: 78.1524896},
// {lat: 9.8194859, lng: 78.150773},
// {lat: 9.8190207, lng: 78.1495285},
// {lat: 9.8179635, lng: 78.147726},
// {lat: 9.814496, lng: 78.144679},
// {lat: 9.8128468, lng: 78.142704899999984},
// {lat: 9.8120433, lng: 78.1405592},
// {lat: 9.811705, lng: 78.1386709},
// {lat: 9.8111976, lng: 78.1363964},
// {lat: 9.8117473, lng: 78.1341219},
// {lat: 9.8125931, lng: 78.1320619},
// {lat: 9.8133119, lng: 78.1298303},
// {lat: 9.8141154, lng: 78.1284999},
// {lat: 9.8152572, lng: 78.1283283},
// {lat: 9.8168641, lng: 78.1295299},
// {lat: 9.819063, lng: 78.1314182},
// {lat: 9.820839, lng: 78.1319332},
// {lat: 9.8248139, lng: 78.1322765},
// {lat: 9.8294231, lng: 78.1321477},
// {lat: 9.8321716, lng: 78.1319761},
// {lat: 9.8347087, lng: 78.131289399999986},
// {lat: 9.8366538, lng: 78.130517},
// {lat: 9.8402057, lng: 78.1276416},
// {lat: 9.8436729, lng: 78.1252813},
// {lat: 9.8463368, lng: 78.1240367},
// {lat: 9.8490006, lng: 78.1236076},
// {lat: 9.8512416, lng: 78.1244659},
// {lat: 9.8542436, lng: 78.1251525},
// {lat: 9.8523409, lng: 78.1267833},
// {lat: 9.8516644, lng: 78.1280708},
// {lat: 9.8525523, lng: 78.1296157},
// {lat: 9.8540745, lng: 78.1309032},
// {lat: 9.8562309, lng: 78.1318044},
// {lat: 9.8557235, lng: 78.1332206},
// {lat: 9.8521295, lng: 78.1399583},
// {lat: 9.8526792, lng: 78.1414604},
// {lat: 9.8535671, lng: 78.1433057},
// {lat: 9.8530597, lng: 78.1450223},
// {lat: 9.8521295, lng: 78.1475544},
// {lat: 9.852045, lng: 78.149571399999985},
// {lat: 9.8527638, lng: 78.1509876},
// {lat: 9.8547933, lng: 78.1521034},
// {lat: 9.8591061, lng: 78.1533908},
// {lat: 9.8647717, lng: 78.1531763},
// {lat: 9.86752, lng: 78.1522321},
// {lat: 9.8702259, lng: 78.1517171},
// {lat: 9.8726782, lng: 78.1520176},
// {lat: 9.8742002, lng: 78.1527042},
// {lat: 9.8728896, lng: 78.1547641},
// {lat: 9.8734815, lng: 78.1567812},
// {lat: 9.8750881, lng: 78.1585407},
// {lat: 9.8753841, lng: 78.1616306},
// {lat: 9.874919, lng: 78.1659221},
// {lat: 9.8741579, lng: 78.1691837},
// {lat: 9.8731855, lng: 78.171544},
// {lat: 9.871452, lng: 78.174033099999988},
// {lat: 9.8692112, lng: 78.1780242},
// {lat: 9.8683656, lng: 78.1800413},
// {lat: 9.8679428, lng: 78.18235869999998},
// {lat: 9.8695072, lng: 78.183774899999989},
// {lat: 9.8687038, lng: 78.1861352},
// {lat: 9.8698454, lng: 78.1873369},
// {lat: 9.8724245, lng: 78.188323899999986},
// {lat: 9.8709024, lng: 78.1904697},
// {lat: 9.8702259, lng: 78.192358},
// {lat: 9.8695494, lng: 78.1948041},
// {lat: 9.8694649, lng: 78.1963062},
// {lat: 9.8697608, lng: 78.1984949},
// {lat: 9.8709024, lng: 78.2002544},
// {lat: 9.8723399, lng: 78.2011985},
// {lat: 9.8743693, lng: 78.2021856},
// {lat: 9.8752572, lng: 78.2033872},
// {lat: 9.87568, lng: 78.2057476},
// {lat: 9.8753841, lng: 78.208451199999985},
// {lat: 9.8744962, lng: 78.210124899999983},
// {lat: 9.8727627, lng: 78.2126569},
// {lat: 9.8717903, lng: 78.2142019},
// {lat: 9.8702259, lng: 78.217592199999984},
// {lat: 9.8663784, lng: 78.2208967},
// {lat: 9.8640952, lng: 78.2221412},
// {lat: 9.8626154, lng: 78.2235145},
// {lat: 9.862404, lng: 78.2255745},
// {lat: 9.8637993, lng: 78.2274627},
// {lat: 9.8648563, lng: 78.2299518},
// {lat: 9.8647717, lng: 78.2322263},
// {lat: 9.8636302, lng: 78.2345008},
// {lat: 9.8623194, lng: 78.2362604},
// {lat: 9.8608819, lng: 78.2386207},
// {lat: 9.8604168, lng: 78.2413244},
// {lat: 9.8606705, lng: 78.2478046},
// {lat: 9.859698, lng: 78.2498216},
// {lat: 9.8570765, lng: 78.2467746},
// {lat: 9.8555121, lng: 78.2450151},
// {lat: 9.8523832, lng: 78.2425689},
// {lat: 9.8500577, lng: 78.2405948},
// {lat: 9.8485355, lng: 78.2399082},
// {lat: 9.8462522, lng: 78.2403373},
// {lat: 9.8438843, lng: 78.2412386},
// {lat: 9.842785, lng: 78.2428264},
// {lat: 9.8380069, lng: 78.2463884},
// {lat: 9.8362309, lng: 78.2488775},
// {lat: 9.8351738, lng: 78.2499933},
// {lat: 9.834751, lng: 78.2536411},
// {lat: 9.8348355, lng: 78.2566022},
// {lat: 9.8365269, lng: 78.2587051},
// {lat: 9.8398251, lng: 78.259692099999981},
// {lat: 9.8433347, lng: 78.260507499999989},
// {lat: 9.8465059, lng: 78.2612371},
// {lat: 9.8474361, lng: 78.263211199999986},
// {lat: 9.8479013, lng: 78.2647991},
// {lat: 9.8482395, lng: 78.2661295},
// {lat: 9.8498885, lng: 78.2669019},
// {lat: 9.8552584, lng: 78.2667303},
// {lat: 9.856992, lng: 78.2649278},
// {lat: 9.8590638, lng: 78.2630825},
// {lat: 9.8606282, lng: 78.2617092},
// {lat: 9.8609664, lng: 78.2599926},
// {lat: 9.8630382, lng: 78.2573747},
// {lat: 9.8641375, lng: 78.255743899999985},
// {lat: 9.8667166, lng: 78.253898599999985},
// {lat: 9.8691266, lng: 78.252654},
// {lat: 9.8715366, lng: 78.251194899999987},
// {lat: 9.8740311, lng: 78.2501649},
// {lat: 9.8736083, lng: 78.2532119},
// {lat: 9.8727204, lng: 78.2572031},
// {lat: 9.8715789, lng: 78.260507499999989},
// {lat: 9.8700991, lng: 78.263812},
// {lat: 9.8700991, lng: 78.2666874},
// {lat: 9.8705219, lng: 78.2701635},
// {lat: 9.8712829, lng: 78.2742405},
// {lat: 9.8712522, lng: 78.2760217},
// {lat: 9.8711984, lng: 78.2778883},
// {lat: 9.8704373, lng: 78.279390299999989},
// {lat: 9.8705642, lng: 78.2829523},
// {lat: 9.8701414, lng: 78.2866001},
// {lat: 9.8691689, lng: 78.2884025},
// {lat: 9.8666321, lng: 78.28969},
// {lat: 9.8641375, lng: 78.2914495},
// {lat: 9.8630382, lng: 78.2925653},
// {lat: 9.8623194, lng: 78.2953119},
// {lat: 9.8614738, lng: 78.2982301},
// {lat: 9.8620235, lng: 78.3015346},
// {lat: 9.8629959, lng: 78.3040237},
// {lat: 9.8641798, lng: 78.3068561},
// {lat: 9.8657865, lng: 78.3086156},
// {lat: 9.8668012, lng: 78.3090877},
// {lat: 9.8700145, lng: 78.309431},
// {lat: 9.8750035, lng: 78.3123064},
// {lat: 9.876664, lng: 78.3128608},
// {lat: 9.8782168, lng: 78.313379199999986},
// {lat: 9.880373, lng: 78.3126926},
// {lat: 9.8824447, lng: 78.3125639},
// {lat: 9.8829943, lng: 78.3136797},
// {lat: 9.8834171, lng: 78.3147096},
// {lat: 9.8857001, lng: 78.3156538},
// {lat: 9.8904352, lng: 78.3143234},
// {lat: 9.8925913, lng: 78.3124351},
// {lat: 9.8946207, lng: 78.3113837},
// {lat: 9.8986158, lng: 78.3111262},
// {lat: 9.9012158, lng: 78.3109545},
// {lat: 9.9042808, lng: 78.3120703},
// {lat: 9.9074303, lng: 78.3120703},
// {lat: 9.6638976, lng: 78.0597718},
// {lat: 9.6626919, lng: 78.0598791},
// {lat: 9.6617823, lng: 78.0598791},
// {lat: 9.6608727, lng: 78.0606945},
// {lat: 9.6609393, lng: 78.0652382},
// {lat: 9.6610208, lng: 78.070801},
// {lat: 9.6608304, lng: 78.0739553},
// {lat: 9.6606823, lng: 78.0767877},
// {lat: 9.6610419, lng: 78.0792554},
// {lat: 9.6619303, lng: 78.080457},
// {lat: 9.6627553, lng: 78.0815084},
// {lat: 9.6640034, lng: 78.0820019},
// {lat: 9.6680647, lng: 78.0821307},
// {lat: 9.6703704, lng: 78.0814011},
// {lat: 9.6716184, lng: 78.0807574},
// {lat: 9.672528, lng: 78.0801351},
// {lat: 9.6732472, lng: 78.0795343},
// {lat: 9.6739452, lng: 78.0794056},
// {lat: 9.6758066, lng: 78.0796201},
// {lat: 9.6756586, lng: 78.0815513},
// {lat: 9.6759758, lng: 78.0845339},
// {lat: 9.6768642, lng: 78.086057399999987},
// {lat: 9.6784084, lng: 78.0867012},
// {lat: 9.6791487, lng: 78.0868085},
// {lat: 9.6817716, lng: 78.0873878},
// {lat: 9.6838868, lng: 78.0862291},
// {lat: 9.6854097, lng: 78.0851991},
// {lat: 9.6860654, lng: 78.0845125},
// {lat: 9.6874191, lng: 78.083182099999988},
// {lat: 9.6883286, lng: 78.082860199999985},
// {lat: 9.690338, lng: 78.083611299999987},
// {lat: 9.6921571, lng: 78.0839546},
// {lat: 9.6940395, lng: 78.0826028},
// {lat: 9.6946741, lng: 78.080972},
// {lat: 9.6954355, lng: 78.0796201},
// {lat: 9.6961546, lng: 78.0777748},
// {lat: 9.6964719, lng: 78.076895},
// {lat: 9.6972968, lng: 78.076465899999988},
// {lat: 9.7004271, lng: 78.076573199999984},
// {lat: 9.7026268, lng: 78.0777533},
// {lat: 9.7045938, lng: 78.078847699999983},
// {lat: 9.7056725, lng: 78.0792768},
// {lat: 9.7076395, lng: 78.0794914},
// {lat: 9.7082317, lng: 78.0789335},
// {lat: 9.7086124, lng: 78.0765302},
// {lat: 9.7092046, lng: 78.075393},
// {lat: 9.7112985, lng: 78.0745132},
// {lat: 9.7137519, lng: 78.0742128},
// {lat: 9.71574, lng: 78.0742128},
// {lat: 9.7172205, lng: 78.0739982},
// {lat: 9.7181088, lng: 78.0731614},
// {lat: 9.719272, lng: 78.0722816},
// {lat: 9.7223176, lng: 78.0714019},
// {lat: 9.7230578, lng: 78.0703075},
// {lat: 9.7233962, lng: 78.0690201},
// {lat: 9.724496, lng: 78.0683978},
// {lat: 9.7283874, lng: 78.0688698},
// {lat: 9.7291065, lng: 78.0698569},
// {lat: 9.7306715, lng: 78.0722172},
// {lat: 9.7318982, lng: 78.0721314},
// {lat: 9.7343091, lng: 78.0708869},
// {lat: 9.7373122, lng: 78.0690201},
// {lat: 9.7383697, lng: 78.0674966},
// {lat: 9.7393848, lng: 78.0659301},
// {lat: 9.7401673, lng: 78.0641062},
// {lat: 9.740696, lng: 78.0629046},
// {lat: 9.741267, lng: 78.0621536},
// {lat: 9.7416477, lng: 78.062132099999985},
// {lat: 9.7425993, lng: 78.0625184},
// {lat: 9.7449468, lng: 78.0635913},
// {lat: 9.7484362, lng: 78.0647714},
// {lat: 9.7507413, lng: 78.0656297},
// {lat: 9.7516295, lng: 78.0661876},
// {lat: 9.7520313, lng: 78.067925699999989},
// {lat: 9.7520736, lng: 78.0705865},
// {lat: 9.7515872, lng: 78.0739124},
// {lat: 9.7505933, lng: 78.0753715},
// {lat: 9.7493244, lng: 78.0773027},
// {lat: 9.7497896, lng: 78.0785902},
// {lat: 9.751418, lng: 78.0798991},
// {lat: 9.7531098, lng: 78.0811436},
// {lat: 9.757868, lng: 78.0850275},
// {lat: 9.75643, lng: 78.0867441},
// {lat: 9.7554149, lng: 78.0888469},
// {lat: 9.7550766, lng: 78.0909498},
// {lat: 9.7551189, lng: 78.0931814},
// {lat: 9.7550343, lng: 78.0954988},
// {lat: 9.7546536, lng: 78.0980308},
// {lat: 9.7544421, lng: 78.1001337},
// {lat: 9.7554572, lng: 78.1013353},
// {lat: 9.7572759, lng: 78.1023653},
// {lat: 9.7593906, lng: 78.1034811},
// {lat: 9.7628587, lng: 78.1041248},
// {lat: 9.7641275, lng: 78.1043823},
// {lat: 9.7673418, lng: 78.1043394},
// {lat: 9.7694565, lng: 78.1029661},
// {lat: 9.7703447, lng: 78.1009061},
// {lat: 9.7710213, lng: 78.09846},
// {lat: 9.7715289, lng: 78.095885},
// {lat: 9.7721632, lng: 78.094168399999987},
// {lat: 9.773432, lng: 78.0919797},
// {lat: 9.775166, lng: 78.0898769},
// {lat: 9.7758215, lng: 78.0892546},
// {lat: 9.7777458, lng: 78.0891688},
// {lat: 9.7792895, lng: 78.0892976},
// {lat: 9.7791414, lng: 78.0904563},
// {lat: 9.77893, lng: 78.0923445},
// {lat: 9.7787608, lng: 78.095928},
// {lat: 9.7787608, lng: 78.0973871},
// {lat: 9.7792472, lng: 78.098223899999979},
// {lat: 9.780389, lng: 78.0986102},
// {lat: 9.781975, lng: 78.0990179},
// {lat: 9.7827785, lng: 78.1001551},
// {lat: 9.7844067, lng: 78.1028588},
// {lat: 9.7850834, lng: 78.104275},
// {lat: 9.7852525, lng: 78.1064851},
// {lat: 9.784301, lng: 78.1087597},
// {lat: 9.7831803, lng: 78.11009},
// {lat: 9.7823133, lng: 78.111399},
// {lat: 9.7810446, lng: 78.112386},
// {lat: 9.7796066, lng: 78.1129224},
// {lat: 9.7791626, lng: 78.1132229},
// {lat: 9.7777247, lng: 78.1165488},
// {lat: 9.7769, lng: 78.117600199999984},
// {lat: 9.7755255, lng: 78.1178148},
// {lat: 9.7745105, lng: 78.1185444},
// {lat: 9.77358, lng: 78.1204326},
// {lat: 9.7709579, lng: 78.125046},
// {lat: 9.7702178, lng: 78.1255825},
// {lat: 9.7688221, lng: 78.1256254},
// {lat: 9.767363, lng: 78.125325},
// {lat: 9.7662633, lng: 78.125539599999982},
// {lat: 9.7653117, lng: 78.1265266},
// {lat: 9.7647831, lng: 78.1281359},
// {lat: 9.7641064, lng: 78.1305177},
// {lat: 9.7635988, lng: 78.1319339},
// {lat: 9.7619706, lng: 78.136869},
//     ];


    function initMap() {
        const initialLocation = { lat: 9.9252, lng: 78.1198 };

    map = new google.maps.Map(document.getElementById("map"), {
        center: initialLocation,
        zoom: 13,
        streetViewControl: false,
        mapTypeControlOptions: {
            style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
            position: google.maps.ControlPosition.TOP_RIGHT
        }
    });

            // fetchOnlineDrivers();

            
    // Add Madurai boundary polygon
    const cityBoundary = new google.maps.Polygon({
        paths: maduraiBoundary,
        strokeColor: "#FF0000",
        strokeOpacity: 0.4,
        strokeWeight: 2,
        fillColor: "#FF0000",
        fillOpacity: 0.1,
        map: map
    });

    geocoder = new google.maps.Geocoder();
    directionsService = new google.maps.DirectionsService();
    directionsRenderer = new google.maps.DirectionsRenderer({
        map: map,
        suppressMarkers: true,
        polylineOptions: {
            strokeColor: "#3a86ff",
            strokeOpacity: 0.8,
            strokeWeight: 5
        }
    });

        fromAutocomplete = new google.maps.places.Autocomplete(
            document.getElementById("fromAddress"),
            { fields: ["formatted_address", "geometry", "address_components"], componentRestrictions: { country: "in" } }
        );

        toAutocomplete = new google.maps.places.Autocomplete(
            document.getElementById("toAddress"),
            { fields: ["formatted_address", "geometry", "address_components"], componentRestrictions: { country: "in" } }
        );

        fromAutocomplete.addListener("place_changed", function () {
            const place = fromAutocomplete.getPlace();

            if (!place.geometry) {
                alert("No details available for input: '" + place.name + "'");
                return;
            }

            // if (place.geometry) {
            //     document.getElementById('from_Latitude').value = place.geometry.location.lat();
            //     document.getElementById('from_Longitude').value = place.geometry.location.lng();
            //     checkAndCalculateDistance();
            // }

            fromLocation = place.geometry.location;
            updateFromLocation(place.geometry.location, place.formatted_address);
            updateFormFields();
            updateRoute();
            checkAndCalculateDistance();

            if (window.fromLocationCircle) {
                window.fromLocationCircle.setMap(null);
            }

          // Initial radius fallback if nothing is selected yet (default: 3 km)
            let initialRadius = 3000;

            window.fromLocationCircle = new google.maps.Circle({
                strokeColor: "#007bff",
                strokeOpacity: 0.8,
                strokeWeight: 2,
                fillColor: "#007bff",
                fillOpacity: 0.2,
                map: map,
                center: fromLocation, // Make sure this is defined and valid
                radius: initialRadius
            });


          // Trigger fetching drivers when the radius changes
document.getElementById('radiuskm').addEventListener('change', function () {
    let selectedKm = parseFloat(this.value);
    if (!isNaN(selectedKm) && window.fromLocationCircle) {
        let radiusInMeters = selectedKm * 1000;
        window.fromLocationCircle.setRadius(radiusInMeters);
        window.fromLocationCircle.setVisible(true);

        if (fromLocation) {
            fetchNearbyDrivers(fromLocation.lat(), fromLocation.lng(), selectedKm);

            // Update map position and bounds
            map.panTo(fromLocation);
            map.fitBounds(window.fromLocationCircle.getBounds());

            google.maps.event.addListenerOnce(map, 'bounds_changed', function () {
                const desiredZoom = 18;
                if (map.getZoom() > desiredZoom) {
                    // map.setZoom(desiredZoom);
                }
            });
        }
    }
});
document.getElementById('cartype').addEventListener('change', function () {
    let selectedKm = parseFloat(document.getElementById('radiuskm').value) || 3;
    let cartypeId = this.value;

    if (fromLocation) {
        fetchNearbyDrivers(fromLocation.lat(), fromLocation.lng(), selectedKm, cartypeId);
    }else{
        showAllOnlineDriver(cartypeId);
    }
});

// Manually trigger nearby driver fetch on load or as needed
if (fromLocation) {
    let selectedKm = parseFloat(document.getElementById('radiuskm').value) || 3;
    fetchNearbyDrivers(fromLocation.lat(), fromLocation.lng(), selectedKm);
}

// The fetch function to get nearby drivers and place markers
function fetchNearbyDrivers(lat, lng, radiusKm,cartypeId = null) {

    cartypeId = document.getElementById('cartype').value;

    fetch("<?php echo e(route('admin.getNearbyDrivers')); ?>", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
            "X-CSRF-TOKEN": '<?php echo e(csrf_token()); ?>',
        },
        body: JSON.stringify({
            latitude: lat,
            longitude: lng,
            radius_km: radiusKm,
            cartype_id: cartypeId
        })
    })
        .then(res => res.json())
        .then(drivers => {
            // Clear existing driver markers
            if (window.dynamicDriverMarkers) {
                window.dynamicDriverMarkers.forEach(marker => marker.setMap(null));
            }
            window.dynamicDriverMarkers = [];
            document.getElementById('onlinefreeavilabledrivercount').innerText = drivers.length;

            drivers.forEach(driver => {
                const marker = new google.maps.Marker({
                    position: {
                        lat: parseFloat(driver.latitude),
                        lng: parseFloat(driver.longitude)
                    },
                    map: map,
                    icon: {
                        url: "https://img.icons8.com/emoji/48/oncoming-taxi.png",
                        scaledSize: new google.maps.Size(32, 32)
                    },
                    title: `${driver.driver_name} - ${driver.user_name}` 
                });

                marker.addListener('click', () => {
                    selectDriverFromMap(driver.id, marker);
                });

                const infoWindow = new google.maps.InfoWindow({
                        content: `
                            <div>
                                <strong>${driver.driver_code} - ${driver.driver_name}</strong><br>
                                Phone: ${driver.user_name}<br>
                                Vehicle: ${driver.car_model}
                            </div>
                        `
                    });

                marker.addListener("mouseover", () => infoWindow.open(map, marker));
                marker.addListener("mouseout", () => infoWindow.close());

                window.dynamicDriverMarkers.push(marker);
            });
        })
        .catch(error => {
            console.error("Error fetching nearby drivers:", error);
        });
}





                          
            // ✅ Safe parsing of address_components
           if (place.address_components) {
    let country = '', state = '', city = '', district = '';

    place.address_components.forEach(component => {
        const types = component.types;

        if (types.includes('country')) {
            country = component.long_name;
        }
        if (types.includes('administrative_area_level_1')) {
            state = component.long_name;
        }
        if (types.includes('administrative_area_level_3')) {
            district = component.long_name;
        }
        if (types.includes('locality')) {
            city = component.long_name;
        }
    });

    console.log('From Location Details:', { country, state, district, city });
}

        });

        toAutocomplete.addListener("place_changed", function () {
            const place = toAutocomplete.getPlace();

            if (!place.geometry) {
                alert("No details available for input: '" + place.name + "'");
                return;
            }

            // if (place.geometry) {
            // document.getElementById('to_Latitude').value = place.geometry.location.lat();
            // document.getElementById('to_Longitude').value = place.geometry.location.lng();
            // checkAndCalculateDistance();
            // }

            toLocation = place.geometry.location;
            updateToLocation(place.geometry.location, place.formatted_address);
            updateFormFields();
            updateRoute();
            checkAndCalculateDistance();


            // ✅ Safe parsing of address_components
           if (place.address_components) {
    let country = '', state = '', city = '', district = '';

    place.address_components.forEach(component => {
        const types = component.types;

        if (types.includes('country')) {
            country = component.long_name;
        }
        if (types.includes('administrative_area_level_1')) {
            state = component.long_name;
        }
        if (types.includes('administrative_area_level_3')) {
            district = component.long_name;
        }
        if (types.includes('locality')) {
            city = component.long_name;
        }
    });

    console.log('From Location Details:', { country, state, district, city });
}

        });

        map.addListener("click", function (e) {
            geocoder.geocode({ location: e.latLng }, (results, status) => {
                if (status === "OK" && results[0]) {
                    const address = results[0].formatted_address;

                    if (!fromLocation) {
                        fromLocation = e.latLng;
                        updateFromLocation(e.latLng, address);
                        document.getElementById("fromAddress").value = address;
                    } else if (!toLocation) {
                        toLocation = e.latLng;
                        updateToLocation(e.latLng, address);
                        document.getElementById("toAddress").value = address;
                    } else {
                        fromLocation = e.latLng;
                        toLocation = null;
                        updateFromLocation(e.latLng, address);
                        document.getElementById("fromAddress").value = address;
                        document.getElementById("toAddress").value = "";
                        if (toMarker) {
                            toMarker.setMap(null);
                            toMarker = null;
                        }
                    }

                    updateFormFields();
                    updateRoute();
                    checkAndCalculateDistance();
                }
            });
        });

        // If prefilled
        const fromLat = document.getElementById("fromLatitude").value;
        const fromLng = document.getElementById("fromLongitude").value;
        if (fromLat && fromLng) {
            fromLocation = new google.maps.LatLng(parseFloat(fromLat), parseFloat(fromLng));
            updateFromLocation(fromLocation, document.getElementById("fromAddress").value);
        }

        const toLat = document.getElementById("toLatitude").value;
        const toLng = document.getElementById("toLongitude").value;
        if (toLat && toLng) {
            toLocation = new google.maps.LatLng(parseFloat(toLat), parseFloat(toLng));
            updateToLocation(toLocation, document.getElementById("toAddress").value);
        }

        if (fromLocation && toLocation) {
            updateRoute();
            checkAndCalculateDistance();
        }

        // Static driver markers
        drivers.forEach(driver => {
            const marker = new google.maps.Marker({
                position: {
                    lat: parseFloat(driver.current_latitude),
                    lng: parseFloat(driver.current_longitude)
                },
                map: map,
                icon: {
                    url: "https://img.icons8.com/emoji/48/oncoming-taxi.png",
                    scaledSize: new google.maps.Size(32, 32)
                },
                title: 'Driver ID: ' + driver.id
            });

            marker.addListener('click', () => {
                selectDriverFromMap(driver.id, marker);
            });
        });
    }

    function selectDriverFromMap(driverId, marker) {
        document.getElementById('driver_id').value = driverId;

        if (selectedDriverMarker) {
            selectedDriverMarker.setIcon({
                url: "https://img.icons8.com/emoji/48/oncoming-taxi.png",
                scaledSize: new google.maps.Size(32, 32)
            });
        }

        marker.setIcon({
            url: "https://maps.google.com/mapfiles/ms/icons/blue-dot.png",
            scaledSize: new google.maps.Size(40, 40)
        });

        selectedDriverMarker = marker;
    }

    function validateForm() {
        const notifyType = document.getElementById('notify_driver').value;
        const driverId = document.getElementById('driver_id').value;

        if (notifyType === 'single' && !driverId) {
            alert('You selected single driver notification. Please select a driver on the map.');
            return false;
        }

        return true;
    }

    function toggleDriverRequirement() {
        const type = document.getElementById('notify_driver').value;
        const driverIdField = document.getElementById('driver_id');

        if (type === 'all') {
            driverIdField.value = '';
            // let selectedKm = parseFloat(document.getElementById('radiuskm').value) || 3;
            // const fromLat = document.getElementById("fromLatitude").value;
            // const fromLng = document.getElementById("fromLongitude").value;
            // fetchNearbyDrivers(fromLat, fromLng, selectedKm);
        } else {
            if (window.driverMarkers) {
                window.driverMarkers.forEach(marker => marker.setMap(null));
                window.driverMarkers = [];
            }
        }
    }

 

    function updateFromLocation(location, address = null) {
        if (fromMarker) fromMarker.setMap(null);

        fromMarker = new google.maps.Marker({
            position: location,
            map: map,
            title: "From Location",
            draggable: true,
            icon: {
                url: "http://maps.google.com/mapfiles/ms/icons/green-dot.png",
                scaledSize: new google.maps.Size(32, 32)
            }
        });

        fromMarker.addListener("dragend", function () {
            geocoder.geocode({ location: fromMarker.getPosition() }, (results, status) => {
                if (status === "OK" && results[0]) {
                    document.getElementById("fromAddress").value = results[0].formatted_address;
                    updateFormFields();
                    updateRoute();
                    checkAndCalculateDistance();
                }
            });
        });

        if (!toLocation) {
            map.setCenter(location);
            map.setZoom(15);
        }
    }

    function updateToLocation(location, address = null) {
        if (toMarker) toMarker.setMap(null);

        toMarker = new google.maps.Marker({
            position: location,
            map: map,
            title: "To Location",
            draggable: true,
            icon: {
                url: "http://maps.google.com/mapfiles/ms/icons/red-dot.png",
                scaledSize: new google.maps.Size(32, 32)
            }
        });

        toMarker.addListener("dragend", function () {
            geocoder.geocode({ location: toMarker.getPosition() }, (results, status) => {
                if (status === "OK" && results[0]) {
                    document.getElementById("toAddress").value = results[0].formatted_address;
                    updateFormFields();
                    updateRoute();
                    checkAndCalculateDistance();
                }
            });
        });

        if (fromLocation) {
            const bounds = new google.maps.LatLngBounds();
            bounds.extend(fromLocation);
            bounds.extend(location);
            map.fitBounds(bounds);
        }
    }

    function updateRoute() {
        if (!fromLocation || !toLocation) return;

        directionsService.route(
            {
                origin: fromLocation,
                destination: toLocation,
                travelMode: google.maps.TravelMode.DRIVING,
                provideRouteAlternatives: true
            },
            (response, status) => {
                if (status === "OK") {
                    directionsRenderer.setDirections(response);
                } else {
                    alert("Directions request failed due to " + status);
                }
            }
        );
    }

    function updateFormFields() {
        if (fromLocation) {
            document.getElementById("fromLatitude").value = fromLocation.lat();
            document.getElementById("fromLongitude").value = fromLocation.lng();
        }

        if (toLocation) {
            document.getElementById("toLatitude").value = toLocation.lat();
            document.getElementById("toLongitude").value = toLocation.lng();
        }
    }

    document.getElementById("fromAddress").addEventListener("keypress", function (e) {
        if (e.key === "Enter") e.preventDefault();
    });

    document.getElementById("toAddress").addEventListener("keypress", function (e) {
        if (e.key === "Enter") e.preventDefault();
    });

// let deviceId = localStorage.getItem("device_id");
// if (!deviceId) {
//   deviceId = crypto.randomUUID();
//   localStorage.setItem("device_id", deviceId);
// }
// console.log("Device ID:", deviceId);




    // let fromAutocomplete, toAutocomplete;

    function initAutocomplete() {
        // fromAutocomplete = new google.maps.places.Autocomplete(document.getElementById('from_Address'));
        // toAutocomplete = new google.maps.places.Autocomplete(document.getElementById('to_Address'));

        // fromAutocomplete.addListener('place_changed', fillFromLatLng);
        // toAutocomplete.addListener('place_changed', fillToLatLng);
    }

    // function fillFromLatLng() {
    //     const place = fromAutocomplete.getPlace();
    //     if (place.geometry) {
    //         document.getElementById('from_Latitude').value = place.geometry.location.lat();
    //         document.getElementById('from_Longitude').value = place.geometry.location.lng();
    //         checkAndCalculateDistance();
    //     }
    // }

    // function fillToLatLng() {
    //     const place = toAutocomplete.getPlace();
    //     if (place.geometry) {
    //         document.getElementById('to_Latitude').value = place.geometry.location.lat();
    //         document.getElementById('to_Longitude').value = place.geometry.location.lng();
    //         checkAndCalculateDistance();
    //     }
    // }

   function checkAndCalculateDistance() {
    const fromLat = document.getElementById('fromLatitude').value;
    const fromLng = document.getElementById('fromLongitude').value;
    const toLat = document.getElementById('toLatitude').value;
    const toLng = document.getElementById('toLongitude').value;

    if (fromLat && fromLng && toLat && toLng) {
        calculateDistance(fromLat, fromLng, toLat, toLng);
    }
}

function calculateDistance(fromLat, fromLng, toLat, toLng) {
    const service = new google.maps.DistanceMatrixService();

    service.getDistanceMatrix({
        origins: [{ lat: parseFloat(fromLat), lng: parseFloat(fromLng) }],
        destinations: [{ lat: parseFloat(toLat), lng: parseFloat(toLng) }],
        travelMode: 'DRIVING',
        unitSystem: google.maps.UnitSystem.METRIC,
    }, (response, status) => {
        if (status === 'OK') {
            const result = response.rows[0].elements[0];
            if (result.status === "OK") {
                const distanceText = result.distance?.text || "0 km";    // e.g. "12.3 km"
                const durationText = result.duration?.text || "0 mins";  // e.g. "1 hour 30 mins"
                const distanceValue = parseFloat(distanceText.replace(/[^\d.]/g, '')); // numeric distance

                // Convert duration text to hours
                const estimatedHours = convertDurationToHours(durationText);
 


                // Update HTML
                document.getElementById('distanceDisplay').innerText = distanceValue;
                document.getElementById('distance_km').value = distanceValue;

                document.getElementById('durationDisplay').innerText = durationText;
                document.getElementById('duration_text').value = durationText;

                document.getElementById('estimated_hours').value = estimatedHours.toFixed(2); // 2 decimal places
            } else {
                setDistanceError();
            }
        } else {
            console.error('Distance Matrix error:', status, response);
            setDistanceError();
        }
    });
}

function convertDurationToHours(duration) {
    let hours = 0, minutes = 0;

    const hourMatch = duration.match(/(\d+)\s*hour[s]?/i);   // matches "hour" or "hours"
    const minuteMatch = duration.match(/(\d+)\s*min[s]?/i);  // matches "min" or "mins"

    if (hourMatch) hours = parseInt(hourMatch[1]);
    if (minuteMatch) minutes = parseInt(minuteMatch[1]);

    let totalHours = hours + (minutes / 60);

    // Round up only if time > 1.83 hrs (1 hr 50 mins)
    if (totalHours > 1) {
        totalHours = Math.ceil(totalHours);  // round up to next full hour
    }

    return totalHours;
}


function setDistanceError() {
    document.getElementById('distanceDisplay').innerText = 'Unavailable';
    document.getElementById('distance_km').value = '';
    document.getElementById('durationDisplay').innerText = 'Unavailable';
    document.getElementById('duration_text').value = '';
}

/*
function initMap() {
        map = new google.maps.Map(document.getElementById("map"), {
            center: { lat: 9.9252, lng: 78.1198 },  
            zoom: 12,
        });

        fetchOnlineDrivers();
    }
*/
    // function fetchOnlineDrivers() {
    //     fetch("<?php echo e(route('admin.onlineDrivers')); ?>")
    //         .then(response => response.json())
    //         .then(data => {
    //             data.forEach(driver => {
    //                 if (driver.latitude && driver.longitude) {
    //                     new google.maps.Marker({
    //                         position: { lat: parseFloat(driver.latitude), lng: parseFloat(driver.longitude) },
    //                         map: map,
    //                         title: driver.driver_name,
    //                         icon: "http://maps.google.com/mapfiles/ms/icons/green-dot.png"
    //                     });
    //                 }
    //             });
    //         });
    // }


    
// Add clustering
window.markerCluster = new markerClusterer.MarkerClusterer({
    map: map,
    markers: window.dynamicDriverMarkers,
    renderer: {
        render: ({ count, position }) => {
            return new google.maps.Marker({
                position,
                label: {
                    text: String(count),
                    color: 'white',
                    fontSize: '14px',
                    fontWeight: 'bold',
                },
                icon: {
                    url: 'https://img.icons8.com/emoji/48/oncoming-taxi.png',
                    scaledSize: new google.maps.Size(40, 40),
                    labelOrigin: new google.maps.Point(20, 10)
                }
            });
        }
    }
});
    // Initialize autocomplete on ooke load
    window.onload = initAutocomplete;
     

</script>

<script src="https://developers.google.com/maps/documentation/javascript/examples/markerclusterer/markerclusterer.js"></script>
<script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e($googleMapsApiKey); ?>&libraries=places&callback=initMap" async defer></script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script2'); ?>
<script>
$(document).ready(function () {

    // Fetch and show all online drivers on map
    function showAllOnlineDriver(cartypeId = null) {
        console.log('Fetching drivers...');
        fetch("<?php echo e(route('admin.getAllOnlineDrivers')); ?>", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "X-CSRF-TOKEN": '<?php echo e(csrf_token()); ?>',
            },
            body: JSON.stringify({
                cartype_id: cartypeId
            })
        })
        .then(res => res.json())
        .then(drivers => {
            console.log('Drivers:', drivers);

            // Clear cluster if exists
            if (window.markerCluster) {
                window.markerCluster.clearMarkers();
            }

            // Clear old markers
            if (window.dynamicDriverMarkers) {
                window.dynamicDriverMarkers.forEach(marker => marker.setMap(null));
            }
            window.dynamicDriverMarkers = [];

            // Display total online drivers
            $('#onlinefreeavilabledrivercount').html(drivers.length);

            // Detect if device is mobile (touch screen)
            const isMobile = ('ontouchstart' in window) || (navigator.maxTouchPoints > 0);

            drivers.forEach(driver => {
                const marker = new google.maps.Marker({
                    position: {
                        lat: parseFloat(driver.latitude),
                        lng: parseFloat(driver.longitude)
                    },
                    map: map,
                    icon: {
                        url: "https://img.icons8.com/emoji/48/oncoming-taxi.png",
                        scaledSize: new google.maps.Size(32, 32)
                    },
                    title: `${driver.driver_name} - ${driver.user_name}`
                });

                marker.addListener('click', () => {
                    selectDriverFromMap(driver.id, marker);
                });

                // Styled InfoWindow for both mobile & desktop
                const infoWindow = new google.maps.InfoWindow({
                    content: `
                        <div> <strong>${driver.driver_code} - ${driver.driver_name}</strong><br> 
										Phone: ${driver.user_name}<br> 
									Vehicle: ${driver.car_model} 
</div>
                    `
                });

                // ? Mobile: tap ? open info
                // ? Laptop/Desktop: hover ? show info
                if (isMobile) {
                    marker.addListener("click", () => {
                        if (window.activeInfoWindow) {
                            window.activeInfoWindow.close();
                        }
                        infoWindow.open(map, marker);
                        window.activeInfoWindow = infoWindow;
                    });
                } else {
                    marker.addListener("mouseover", () => infoWindow.open(map, marker));
                    marker.addListener("mouseout", () => infoWindow.close());
                }

                window.dynamicDriverMarkers.push(marker);
            });
        })
        .catch(error => {
            console.error("Error fetching nearby drivers:", error);
        });
    }

    // When car type dropdown changes
    $('#cartype').on('change', function () {
        const fromLoc = $('#fromAddress').val();
        const cartypeId = $('#cartype').val();

        if (fromLoc === "") {
            showAllOnlineDriver(cartypeId);
        }
    });

    // Initial load
    showAllOnlineDriver(null);
});
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/vaigainammataxi.com/resources/views/admin/booking_management/map.blade.php ENDPATH**/ ?>