<?php $__env->startSection('style1'); ?>
<style>
    .detail-table {
       
        border-radius: 0.5rem;
        overflow: hidden;
        box-shadow: 0 0 15px rgba(0,0,0,0.05);
    }
    .info-label {
        font-weight: 600;
        color: #6c757d;
        font-size: 0.875rem;
    }
    .info-value {
        color: #707d8b;
        font-size: 1rem;
    }
    .sub-header {
        background: #f8f9fa!important;
    }
    .img-thumbnail {
        border: 1px solid #dee2e6;
        max-width: 200px;
        margin-top: 0.5rem;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contentarea'); ?>
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <h4 class="mb-3">Driver Details</h4>
            
            <table class="table table-bordered detail-table">
                <!-- Main Header -->
                <thead>
                    <tr>
                        <th colspan="4" class="bg-light">Driver Information</th>
                    </tr>
                </thead>

                <!-- Basic Information -->
                <tbody>
                    <tr>
                        <td rowspan="4" style="width: 30%; vertical-align: top;">
                            <div class="info-label">Driver ID</div>
                            <div class="info-value mb-3"><?php echo e($getRow->driver_code); ?></div>
                            <div class="info-label">Driver Name</div>
                            <div class="info-value mb-3"><?php echo e($getRow->driver_name); ?></div>
                            
                            <?php if($getRow->photo): ?>
                            <div class="info-label">Photo</div>
                            <img src="<?php echo e(asset('public/storage/drivers/photos/' . $getRow->photo)); ?>" 
                                alt="Driver Photo" 
                                class="img-thumbnail">
                            <?php endif; ?>
                        </td>
                        <td class="sub-header">Vehicle Information</td>
                        <td class="sub-header">Account Information</td>
                    </tr>
                    <tr>
                        <td>
                            <div class="info-label">Vehicle Name</div>
                            <div class="info-value"><?php echo e($get_vehiclename->car_model ?? 'N/A'); ?></div>
                        </td>
                        <td>
                            <div class="info-label">Username</div>
                            <div class="info-value"><?php echo e($getRow->user_name); ?></div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="info-label">Vehicle Number</div>
                            <div class="info-value"><?php echo e($getRow->vehicle_number); ?></div>
                        </td>
                        <td>
                            <div class="info-label">Status</div>
                            <div class="info-value">
                                <?php if($getRow->status): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Inactive</span>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                </tbody>

                <!-- Documents Section -->
                <thead>
                    <tr>
                        <th colspan="4" class="sub-header">Documents</th>
                    </tr>
                    <tr>
                        <th>Document Title</th>
                        <th>Document Number</th>
                        <th colspan="2">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($document->document_title); ?></td>
                        <td><?php echo e($document->document); ?></td>
                        <td colspan="2">
                            <a href="<?php echo e(asset('public/storage/drivers/documents/' . $document->document)); ?>" 
                               target="_blank" 
                               class="btn btn-sm btn-primary">
                                View Document
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4" class="text-center text-muted py-4">
                            No documents available
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>

            <div class="mt-4">
                <a href="<?php echo e(route('admin.DriverManagement-index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-2"></i> Back to List
                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script1'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('a[target="_blank"]').forEach(link => {
            link.addEventListener('click', function(e) {
                if(!confirm('You are about to open an external document. Continue?')) {
                    e.preventDefault();
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/vaigainammataxi.com/resources/views/admin/driver_management/view.blade.php ENDPATH**/ ?>