<?php $__env->startSection('style1'); ?>

        

        <style>
            .containerbutton {
                display: flex;
                justify-content: flex-end;
                /* Aligns button to the right */
                margin-bottom: 10px;
                /* Optional: Space between button and table */
            }
            .header-container {
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                    }


            

            .tblsearch {
                width: 100%;
                margin: 4px auto 0px auto;
                height: 30px;
                padding-left: 6px;
            }

            a {
                color: #5b5959;
            }
        </style>

<?php $__env->stopSection(); ?>











<?php $__env->startSection('contentarea'); ?>

<h4>Driver Management</h4>

<div class="row">
    <div class="header-container">

<div class="col-xl-8">
    <div class="typeahead__container mb-1">

        <div class="typeahead__field">
            <div class="typeahead__query input-group">
                <input class="form-control customsearch" id="customsearch" placeholder="search here.."
                    autocomplete="off">
            </div>
        </div>
    </div>
</div>

<div class="containerbutton">
    <a href="<?php echo e(route('admin.DriverManagement-create')); ?>" class="btn btn-warning">New Driver</a>
</div>
</div>
</div>



        <table id="listAjaxDataTable" class="table text-nowrap w-100  mb-3">
            <thead>
                <tr>
                    <th data-ftcol="sno" > S.No </th>
                    <th data-ftcol="driver_code">Driver ID</th>
                    <th data-ftcol="driver_name">Name</th>
                    <th data-ftcol="photo">Photo</th>
                    <th data-ftcol="status">Status</th>
                    <th data-ftcol="actions"> Action </th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>




   
   

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script1'); ?>


<script src="<?php echo e(asset('public/admin_assets/js/jquery.min.js')); ?>"></script>


<script>
    $(document).ready(function() {

            var reorderStart = -1; 
        $('th').on("click", function(event) {
            if ($(event.target).is("input") || $(event.target).is("select")) {
                event.stopImmediatePropagation();
            }
        });
        var sno = 1;
        var dataTablecol = [
            {
                "name": "serial_no",
                "searchable": false,
                "sortable": true,
                render: function(data, type, row, meta) {
                    return meta.row + meta.settings._iDisplayStart + 1;
                }
            },

            {
                    "searchable": true,
                    "sortable": false,
                    data: 'driver_code',
                    name: 'driver_code',
               },
           {
                    "searchable": true,
                    "sortable": false,
                    data: 'driver_name',
                    name: 'driver_name',
                 render: function (data, type, row) {
                        let statusDot = '';

                        if (row.trip_status == 1 && row.online_status === 'online') {
                            statusDot = '<span title="In Trip" style="display:inline-block; width:10px; height:10px; border-radius:50%; background-color:yellow; margin-right:6px;"></span>';
                        } else if (row.trip_status == 0 && row.online_status === 'online') {
                            statusDot = '<span title="Online" style="display:inline-block; width:10px; height:10px; border-radius:50%; background-color:green; margin-right:6px;"></span>';
                        } else  if(row.trip_status == 0 && row.online_status === 'offline') {
                            statusDot = '<span title="Offline" style="display:inline-block; width:10px; height:10px; border-radius:50%; background-color:red; margin-right:6px;"></span>';
                        }

                        return `${statusDot}${data}`;
                    }
            },

               {
                searchable: false,
                sortable: false,
                data: 'photo',
                name: 'photo',
                render: function (data, type, row) {
                    if (data) {
                        return `<img src="<?php echo e(asset('public/storage/drivers/photos')); ?>/${data}" alt="Driver Photo" width="60" height="60" class="rounded-circle">`;
                    } else {
                        return `<span class="text-muted">No Photo</span>`;
                    }
                }
           },

            {
                data: 'status',
                name: 'status',
                searchable: true,
                orderable: false,
                render: function(data, type, row) {
                let checked = row.status == 1 ? 'checked' : '';
                return `
                    <div class="form-check form-switch">
                        <input type="checkbox" class="form-check-input status-toggle"
                               id="statusSwitch${row.id}" data-id="${row.id}" ${checked}>
                        <label class="form-check-label" for="statusSwitch${row.id}">
                            ${row.status == 1 ? 'Active' : 'Inactive'}
                        </label>
                    </div>`;
            }
            },


            {
                "searchable": false,
                "sortable": false,
                data: 'id',
                render: function(data, type, row, meta) {
                    var url = "<?php echo e(route('admin.DriverManagement')); ?>";
                  

                    var editLink = '<a class="" href="' + url + '/' + data + '/edit" title="Edit">' +
                        '<i class="mdi mdi-pencil" style="color: rgb(0, 157, 255); font-size: 20px"></i>' +
                        '</a>';

                    var viewLink = '<a class="" href="' + url + '/' + data + '/view" title="View">' +
                        '<i class="mdi mdi-eye" style="color: #009378; font-size: 20px"></i>' +
                        '</a>';

                    var deleteLink = '<a data-id="' + data + '" class="deleteRow" href="#" title="Delete">' +
                        '<i class="mdi mdi-delete" style="color: red; font-size: 20px;"></i>' +
                        '</a>';

                    var result = editLink + '&nbsp;' + viewLink + '&nbsp;' + deleteLink;
                    return result;
                }
            },
            
        ];
        var listAjaxDataTable = $('#listAjaxDataTable').DataTable({
            // "order": [
            //     [0, "desc"]
            // ],
            "processing": true,
            "serverSide": true,
            "colReorder": true,
            "columns": dataTablecol,
            "ordering": false,
            "bAutoWidth": false,
            // "dom": 'ltpr',
            "dom": " <'row'<'col-sm-12 mt-3'tr>><'row'<'col-sm-2'l><'col-sm-6'i><'col-sm-4'p>>",
            "drawCallback": function(settings) {
                var response = settings.json;
                if (response.recordsTotal > 0) {
                    $('#exportreport').show();
                } else {
                    $('#exportreport').hide();
                }
            },
            "ajax": DataTable.pipeline({
                url: "<?php echo e(route('admin.DriverManagement-dataindex')); ?>",
                method: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                pages: 5 // number of pages to cache
            }),
        });

       
          $('#customsearch').on('keyup change', function () {
                let value = $(this).val();
                listAjaxDataTable.search(value).draw();
            });
            

        $('table').on('click', '.deleteRow', function(e) {
            e.preventDefault();
            $chId = $(this).data('id');
            var k = confirm("Are you sure to Delete this record.");
            if (k == true) {
                $.ajax({
                    url: "<?php echo e(route('admin.DriverManagement')); ?>/" + $chId,
                    method: "DELETE",
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    error: function(data) {
                        toastr.error("Error Occured. Please Try Again Later.");
                    },
                    success: function(result) {
                        result = JSON.stringify(result)
                        result = JSON.parse(result);
                        if (result.status == 200) {
                            toastr.success("Deleted Successfully");
                            listAjaxDataTable.clearPipeline().draw();
                        } else {
                            toastr.error("Error Occured. Please Try Again Later.");
                        }
                    }
                });
            }
        });


        $(document).on('change', '.status-toggle', function () {
    let checkbox = $(this);
    let id = checkbox.data('id');
    let status = checkbox.is(':checked') ? 1 : 0;

    let message = status === 1 
        ? "Are you sure you want to activate this driver?" 
        : "Are you sure you want to deactivate this driver?";

    if (confirm(message)) {
        $.ajax({
            url: "<?php echo e(route('admin.driverupdate-status')); ?>",
            type: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                id: id,
                status: status
            },
            success: function (response) {
                let label = checkbox.closest('.form-check').find('label');
                label.text(status === 1 ? 'Active' : 'Inactive');
                toastr.success(response.message || 'Status updated');

            },
            error: function () {
                toastr.error('Failed to update status');
                checkbox.prop('checked', !status); // rollback toggle on error
            }
        });
    } else {
        checkbox.prop('checked', !status); // rollback toggle if cancelled
    }
});

       
        
        });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/vaigainammataxi.com/resources/views/admin/driver_management/list.blade.php ENDPATH**/ ?>