<?php $__env->startSection('contentarea'); ?>
<div class="container mt-4">

    <h2 class="mb-4">Customer Report</h2>

<div class="table-responsive">
      <table class="table table-bordered table-striped align-middle">
    <thead class="table-dark">
        <tr>
            <th> ID</th>
            <th>Customer Name</th>
            <th>Phone</th>
            <th>From Location</th>
            <th>To Location</th>
            <th>Total KM</th>
            <th>Total Price (Rs)</th>
            <th>Date</th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $query; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($report->booking_id); ?></td>
                <td><?php echo e($report->customer_name); ?></td>
                <td><?php echo e($report->phone); ?></td>
                <td><?php echo e($report->from_address); ?></td>
                <td><?php echo e($report->to_address); ?></td>
                <td><?php echo e($report->total_km_travelled ?? 'N/A'); ?></td>
                <td>₹ <?php echo e(number_format($report->total_price ?? 0, 2)); ?></td>
                <td><?php echo e(\Carbon\Carbon::parse($report->booking_date)->format('d-m-Y')); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="8" class="text-center text-muted">No data found for selected filters.</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>
 


    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/vaigainammataxi.com/resources/views/admin/report_management/customer_report.blade.php ENDPATH**/ ?>