
@extends('admin.layout.adminmaster')

@section('style1')


<style>

    .error {
            color:red;
            font-size: larger;
            font-weight: 400;
    
        }
    
        .header-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
    
        .select2-container--default .select2-selection--single{
                background-color: #1d2835 !important;
                }
                
                .select2-search--dropdown{
                background-color: #1d2835 !important;
                }
                .select2-search__field{
                background-color: #1d2835 !important;
                }
                
                .select2-container--default .select2-selection--single .select2-selection__rendered {
                color: #fff;
                line-height: 35px;
               
                }
                .select2-results__option {
                background: #1c2632 !important;
                }
    
     
             .select2-container--default .select2-selection--single {
        background-color: #fff;
        border: 1px solid #4e525b;
        border-radius: 4px;
          }   
    
    .select2-results__option[aria-selected=true] {
        color: #919191 !important;
    }
    
    </style>

@endsection

@section('contentarea')



<div id="selectPicker" class="mb-5">
    <h4>New User</h4>
    <div class="card">
    <div class="card-body pb-2">
    <form action="{{ route('admin.UserManagement-store') }}"method="POST" enctype="multipart/form-data" name="user" id="user">
    @csrf
    <div class="row">

        <div class="col-xl-6">
            <div class="form-group mb-3">
                <label class="form-label"
                    for="name">Name</label>
                <input type="text" class="form-control" name="name"
                    id="name"
                    placeholder="Name" value="{{ old('name') }}">

                    @if ($errors->has('name'))
                    <span class="invalid-feedback d-block">
                        <strong>{{ $errors->first('name') }}</strong>
                    </span>
                @endif
            </div>
        </div>

        <div class="col-xl-6">
            <div class="form-group mb-3">
                <label class="form-label"
                    for="email">Email</label>
                <input type="email" class="form-control" name="email"
                    id="email"
                    placeholder="Email" value="{{ old('email') }}">
                    @if ($errors->has('email'))
                    <span class="invalid-feedback d-block">
                        <strong>{{ $errors->first('email') }}</strong>
                    </span>
                @endif
            </div>
        </div>

        <div class="col-xl-4">
            <div class="form-group mb-3">
                <label class="form-label"
                    for="phone">Phone / Username</label>
                <input type="text" class="form-control" name="phone"
                    id="phone"
                    placeholder="Phone" value="{{ old('phone') }}" maxlength="10">

                    @if ($errors->has('phone'))
                    <span class="invalid-feedback d-block">
                        <strong>{{ $errors->first('phone') }}</strong>
                    </span>
                @endif
            </div>
        </div>

       

        <div class="col-xl-4">
            <div class="form-group mb-3">
                <label class="form-label" for="password">Password</label>
                <input type="password" class="form-control" name="password" id="password" placeholder="Password">
                @if ($errors->has('password'))
                <span class="invalid-feedback d-block">
                    <strong>{{ $errors->first('password') }}</strong>
                </span>
            @endif
            </div>
        </div>
        
        <div class="col-xl-4">
            <div class="form-group mb-3">
                <label class="form-label" for="password_confirmation">Confirm Password</label>
                <input type="password" class="form-control" name="password_confirmation" id="password_confirmation" placeholder="Confirm Password ">
                @if ($errors->has('confrim_password'))
                <span class="invalid-tooltip d-block">
                    <strong>{{ $errors->first('confrim_password') }}</strong>
                </span>
            @endif
            </div>
        </div>



            <div class="col-xl-6 mb-3">
                <label for="example-select" class="form-label">User Roles</label>
                <select class="form-select" id="example-select" name="user_roles[]">
                    {{-- <option value=""></option> --}}
                @foreach($assoc_roleList as $for_id=>$for_row)
                <option value="{{$for_id}}">{{$for_row}}</option>
                @endforeach
            </select>

            @if ($errors->has('user_roles'))
            <span class="invalid-feedback d-block">
                <strong>{{ $errors->first('user_roles') }}</strong>
            </span>
        @endif
                </select>
            </div>




            <div class="col-xl-6 mb-3">
                <label for="example-select" class="form-label">Status</label>
                <select class="form-select" id="example-select" name="status">
                    <option value="1" selected>Enable</option>
                    <option value="0">Disable</option>
                </select>
            </div>


         



       
    </div>

    <a href="{{ route('admin.UserManagement-index') }}" class="btn btn-dark mb-1">BACK</a>
    {{-- <button type="submit" style="float:right"class="btn btn-outline-theme">SAVE</button> --}}

    <input type="submit" style="float:right"class="btn btn-warning" value="SAVE">
        
    </div>
                
    </form>


    <div class="card-arrow">
        <div class="card-arrow-top-left"></div>
        <div class="card-arrow-top-right"></div>
        <div class="card-arrow-bottom-left"></div>
        <div class="card-arrow-bottom-right"></div>
        </div>
    </div>
    
   
    </div>
    </div>

@endsection

@section('script1')


<script src="{{ asset('public/admin_assets/our_plugin/validate/jquery.validate.js') }}"></script>

<script src="{{ asset('public/admin_assets/our_plugin/validate/additional-methods.js') }}"></script>

<script src="{{ asset('public/admin_assets/our_plugin/validate/my_validator.js') }}"></script>

<script>
    $(document).ready(function() {

        $('#user_roles').select2({
                  placeholder: "Select User Roles",

                  allowClear: true,

              });

              $('#status').select2({
               

                  allowClear: true,

              });



$('.perm_all_check').on('click', function(e){
$menuid = $(this).data('menu');
if ($(this).is(':checked')) {
$('input:checkbox[id=perm_list_'+$menuid+']').prop('checked',true);
$('input:checkbox[id=perm_add_'+$menuid+']').prop('checked',true);
$('input:checkbox[id=perm_delete_'+$menuid+']').prop('checked',true);
}else
{
$('input:checkbox[id=perm_list_'+$menuid+']').prop('checked',false);
$('input:checkbox[id=perm_add_'+$menuid+']').prop('checked',false);
$('input:checkbox[id=perm_delete_'+$menuid+']').prop('checked',false);
}
});

$('.perm_add_check, .perm_delete_check').on('click', function(e){
$menuid = $(this).data('menu');
if ($(this).is(':checked')) {
$('input:checkbox[id=perm_list_'+$menuid+']').prop('checked',true);
if($('#perm_list_'+$menuid).is(':checked') && $('#perm_add_'+$menuid).is(':checked') && $('#perm_delete_'+$menuid).is(':checked'))
{
$('input:checkbox[id=perm_all_'+$menuid+']').prop('checked',true);
}
}else
{
$('input:checkbox[id=perm_all_'+$menuid+']').prop('checked',false);
}
});


$('.perm_list_check').on('click', function(e){
$menuid = $(this).data('menu');
if ($(this).is(':checked')) {
if($('#perm_list_'+$menuid).is(':checked') && $('#perm_add_'+$menuid).is(':checked') && $('#perm_delete_'+$menuid).is(':checked'))
{
$('input:checkbox[id=perm_all_'+$menuid+']').prop('checked',true);
}
}else
{
$('input:checkbox[id=perm_all_'+$menuid+']').prop('checked',false);
$('input:checkbox[id=perm_add_'+$menuid+']').prop('checked',false);
$('input:checkbox[id=perm_delete_'+$menuid+']').prop('checked',false);
}
});




        
        $('#user').validate({
            rules: {
                name:{
                    required: true, 
                },
                'user_roles[]':{
                    required: true, 
                },

                password:{
                    required: true, 
                },




                phone: {
                    required: true,
                    nohtml: true,
                    minlength: 10,
                    maxlength: 10,
                    number:true,
                    remote: {
								url: "{{ route('admin.check-phone') }}",
								type: "post",
								data: {
										 _token: '{{ csrf_token() }}',										
										 phone: function() {
											return $("#user #phone").val();
											},
									 },
							}
					},

            },
            messages: {
                
                phone : {
					  remote:'This Mobile number is already registered',
					},
                    'user_roles[]':{
                    required: 'select the user type. ', 
                },
            },

            errorPlacement: function(error, element) {
                error.insertAfter(element);
            }
        })

      
   

        function padLeadingZeros(num, size) {
            var s = num + "";
            while (s.length < size) s = "0" + s;
            return s;
        }



   
      






    });
</script>


@endsection



@section('script2')
              

@endsection