@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="container mt-4">

    <h2 class="mb-4">Approval Reports</h2>

 
       

    
    <div class="table-responsive">
    <table class="table table-bordered">
    <thead>
        <tr>
            <th>Driver Details</th>
            <th>Payment Receipt</th> {{-- now shows image --}}
            {{-- <th>Commission Amount (₹)</th> --}}
            <th>Paid Amount (₹)</th>
            <th>Balance Amount (₹)</th>
            <th>Status</th>
        </tr>
    </thead>
    <tbody>
        @forelse ($datas as $data)
            <tr>
                <td>{{ $data->driver_code . ' - ' . $data->driver_name }}</td>

                {{-- Show payment receipt image if exists --}}
                <td>
                    @if (!empty($data->payment_receipt_image))
                        <img src="{{ asset('payment_receipts/' . $data->payment_receipt_image) }}" 
                             alt="Receipt" width="80" height="80" class="img-thumbnail">
                    @else
                        <span class="text-muted">No receipt</span>
                    @endif
                </td>

                {{-- <td>₹ {{ number_format($data->req_amount, 2) }}</td> --}}
                
                <td>₹ @if ($data->pay_status == 2)
                    {{ number_format($data->paid_amount, 2) }}@else
                    {{ number_format($data->req_amount, 2) }}
                @endif</td>
                <td>₹ {{ number_format($data->pending_amount, 2) }}</td>
                 <td>
                                <div id="status-{{ $data->id }}">
                                
                        @if ($data->pay_status == 0)
                        <button onclick="setStatus({{ $data->id }}, 'approved')" class="btn btn-sm btn-success">Approve</button>
                        <button onclick="setStatus({{ $data->id }}, 'rejected')" class="btn btn-sm btn-danger">Reject</button>
                    @elseif ($data->pay_status == 2)
                        <span class="badge bg-success">Approved</span>
                    @elseif ($data->pay_status == 1)
                        <span class="badge bg-danger">Rejected</span>
                    
                    @endif
                </div>
            </td>

                </td>

                 
            </tr>
        @empty
            <tr>
                <td colspan="6" class="text-center text-muted">No data available for the selected filters.</td>
            </tr>
        @endforelse
    </tbody>
</table>

    </div>
@endsection
<script>
     function setStatus(id, status) {
        const statusDiv = document.getElementById('status-' + id);

        fetch("{{ route('admin.Payupdate-status') }}", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({
                id: id,
                status: status === 'approved' ? 2 : 1
            })
        })
        .then(res => {
            if (!res.ok) throw new Error("HTTP error " + res.status);
            return res.json();
        })
        .then(response => {
            if (response.success) {
                const badgeClass = status === 'approved' ? 'bg-success' : 'bg-danger';
                const label = status === 'approved' ? 'Approved' : 'Rejected';
                statusDiv.innerHTML = `<span class="badge ${badgeClass}">${label}</span>`;
            } else {
                alert(response.message || "Update failed");
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert("An error occurred");
        });
    }
</script>

