@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="container mt-4">

    <h2 class="mb-4">Customer Report</h2>

<div class="table-responsive">
      <table class="table table-bordered table-striped align-middle">
    <thead class="table-dark">
        <tr>
            <th> ID</th>
            <th>Customer Name</th>
            <th>Phone</th>
            <th>From Location</th>
            <th>To Location</th>
            <th>Total KM</th>
            <th>Total Price (Rs)</th>
            <th>Date</th>
        </tr>
    </thead>
    <tbody>
        @forelse ($query as $report)
            <tr>
                <td>{{ $report->booking_id }}</td>
                <td>{{ $report->customer_name }}</td>
                <td>{{ $report->phone }}</td>
                <td>{{ $report->from_address }}</td>
                <td>{{ $report->to_address }}</td>
                <td>{{ $report->total_km_travelled ?? 'N/A' }}</td>
                <td>₹ {{ number_format($report->total_price ?? 0, 2) }}</td>
                <td>{{ \Carbon\Carbon::parse($report->booking_date)->format('d-m-Y') }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="8" class="text-center text-muted">No data found for selected filters.</td>
            </tr>
        @endforelse
    </tbody>
</table>
 


    </div>

</div>
@endsection
