
@extends('admin.layout.adminmaster')

@section('style1')



<style>

    .error {
            color:red;
            font-size: larger;
            font-weight: 400;
    
        }
    
        .header-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }  
    </style>


@endsection




    @section('contentarea')

    <div id="selectPicker" class="mb-5">
        <h4>Update Driver</h4>
        <div class="card">
        <div class="card-body pb-2">
            <form action="{{ route('admin.DriverManagement-update',[$getRow->id]) }}" method="POST" enctype="multipart/form-data" name="driver_form" id="driver_form">
                @csrf
                @method('PUT')
    
        <div class="row g-2">
            <div class="mb-3 col-md-6">
             <label for="driver_name" class="form-label">Driver Name</label>
            <input type="text" id="driver_name" name="driver_name" class="form-control" value="{{$getRow->driver_name }}">
          </div>
          <div class="col-sm-6">
            <label class="form-label">Photo</label>
            <input class="form-control" type="file" name="photo" id="inputGroupFile04">
            @if($getRow->photo)
        <img src="{{ asset('public/storage/drivers/photos/' . $getRow->photo) }}" alt="Driver Photo" width="80" class="mt-2 rounded-circle">
            @endif

        </div>
        </div>
    
    
        <div class="row g-2">
            <div class="mb-3 col-md-6">
        <label for="vehicle_name" class="form-label">Vehicle Name</label>
        <select class="form-select" id="vehicle_name" name="vehicle_name">
            <option value="">--- Select Vehicle ---</option>
            @foreach($get_vehiclename as $vehiclename)
             <option value="{{ $vehiclename->id }}" 
                 @if($vehiclename->id == $getRow->vehicle_id) selected @endif>
                {{ $vehiclename->car_model }}
             </option>
         @endforeach
        </select>
        
       </div>
       <div class="mb-3 col-md-6">
        <label for="vehicle_number" class="form-label">Vehicle Number</label>
        <input type="text" id="vehicle_number" name="vehicle_number" class="form-control" value="{{ $getRow->vehicle_number }}">
    </div>
    </div>
    
        <div class="row g-2">
            <div class="mb-3 col-md-3">
                <label for="user_name" class="form-label">Mobile Number</label>
                <input type="text" id="user_name" name="user_name" class="form-control" value="{{ $getRow->user_name }}" autocomplete="new-user_name">
            </div>
            <div class="mb-3 col-md-3">
                <label for="password" class="form-label">Password</label>
                  <div class="input-group input-group-merge">
                    <input type="password" id="password" name="password" class="form-control" placeholder="Enter new password" autocomplete="new-password">
              <div class="input-group-text" data-password="false">
                <span class="password-eye"></span>
            </div>
        </div>
            </div>

            <div class="mb-3 col-md-3">
                <label for="password_confirmation" class="form-label"> Confirm Password</label>
                  <div class="input-group input-group-merge">
            <input type="password" id="password_confirmation" name="password_confirmation" class="form-control" placeholder="Enter your password" autocomplete="new-password">
              <div class="input-group-text" data-password="false">
                <span class="password-eye"></span>
            </div>
        </div>
            </div>
            <div class="mb-3 col-md-3">
                <label for="inputState" class="form-label">Status</label>
                <select id="inputState" class="form-select" name="status">
                    <option value="1" @if($getRow->status == 1) selected @endif >Enable</option>
                    <option value="0" @if($getRow->status != 1) selected @endif >Disable</option>
                </select>        
               </div>
            
        </div>
                    
       
        <div class="row">
            <div class="mb-3">
                <div class="col-sm-6">
                    <label class="form-label">Documents</label>
                    <div id="fileInputsContainer">
                        <!-- Existing Documents -->
                        @foreach($documents as $index => $document)
                        <div class="file-wrapper mb-3">
                            <div class="file-group d-flex gap-2 mb-1">
                                <input type="hidden" name="existing_documents[{{ $index }}][id]" value="{{ $document->id }}">
                                <input type="text" class="form-control" 
                                       name="existing_documents[{{ $index }}][title]" 
                                       value="{{ $document->document_title }}">
                                <input class="form-control" type="file" 
                                       name="existing_documents[{{ $index }}][file]">
                                       <button type="button" class="btn btn-danger deleteDocumentBtn" data-id="{{ $document->id }}">
                                        Delete
                                    </button>
                                <a href="{{ asset('public/storage/drivers/documents/' . $document->document) }}" 
                                   target="_blank" class="btn btn-info">
                                    View
                                </a>
                            </div>
                            <div class="file-names">
                                Current: {{ $document->document }}
                            </div>
                        </div>
                        @endforeach
        
                        <!-- New Documents Section -->
                        <div class="file-wrapper mb-3">
                            <div class="file-group d-flex gap-2 mb-1">
                                <input type="text" class="form-control" 
                                       name="document_titles[]" 
                                       placeholder="Enter Document Name">
                                <input class="form-control" type="file" name="documents[]">
                                <input type="button" class="btn btn-warning" 
                                       value="Add More" onclick="addFileInput()">
                            </div>
                            <div class="file-names"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Hidden input to track removed existing documents -->
        <input type="hidden" name="removed_documents" id="removedDocuments" value="">          
                    
        <a href="{{ route('admin.DriverManagement-index') }}" class="btn btn-dark mb-1">BACK</a>
        {{-- <button type="submit" style="float:right"class="btn btn-outline-theme">SAVE</button> --}}
    
        <input type="submit" style="float:right"class="btn btn-warning" value="SAVE">
            
        </div>
                    
        </form>
    
        
        </div>
        
       
        </div>
        </div>
    
    @endsection
    
    @section('script1')
    <script src="{{ asset('public/admin_assets/js/jquery.min.js') }}"></script>
    
    
    <script>
        // Remove an existing document with confirmation
        
        function removeDocument(button, docId) {
            if (!confirm("Are you sure you want to delete this document?")) {
                return;
            }
    
            const wrapper = button.closest('.file-wrapper');
            wrapper.remove();
    
            const removedInput = document.getElementById('removedDocuments');
            const currentRemoved = removedInput.value ? removedInput.value.split(',') : [];
            currentRemoved.push(docId);
            removedInput.value = currentRemoved.join(',');
        }
    
        // Add a new file input dynamically
        function addFileInput() {
            const container = document.getElementById('fileInputsContainer');
            const wrapper = document.createElement('div');
            wrapper.className = 'file-wrapper mb-3';
    
            wrapper.innerHTML = `
                <div class="file-group d-flex gap-2 mb-1">
                    <input type="text" class="form-control" name="document_titles[]" placeholder="Enter Document Name">
                    <input class="form-control" type="file" name="documents[]">
                    <button type="button" class="btn btn-danger" onclick="removeFileInput(this)">Remove</button>
                </div>
                <div class="file-names"></div>
            `;
    
            container.appendChild(wrapper);
        }
    
        // Remove a newly added file input
        function removeFileInput(button) {
            const wrapper = button.closest('.file-wrapper');
            wrapper.remove();
        }


        // Handle Delete Document
        $('#fileInputsContainer').on('click', '.deleteDocumentBtn', function (e) {
            e.preventDefault();
            let button = $(this);
            let docId = button.data('id');

            if (confirm("Are you sure you want to delete this document?")) {
                $.ajax({
                    url: "{{ url('admin/driver-documents') }}/" + docId,
                    method: "DELETE",
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                   
                    error: function(data) {
                        toastr.error("Error Occured. Please Try Again Later.");
                    },
                    success: function (response) {
                        toastr.success("Document deleted successfully");
                        button.closest('.file-wrapper').remove();
                    },
                    error: function (xhr) {
                        let msg = "Error occurred. Please try again.";
                        if (xhr.responseJSON && xhr.responseJSON.error) {
                            msg = xhr.responseJSON.error;
                        }
                        toastr.error(msg);
                    }
                });
            }
        });

        // Add More File Input Dynamically
        window.addFileInput = function () {
            let wrapper = $('<div class="file-wrapper mb-3">');
            let group = `
                <div class="file-group d-flex gap-2 mb-1">
                    <input type="text" class="form-control" name="document_titles[]" placeholder="Enter Document Name">
                    <input class="form-control" type="file" name="documents[]">
                    <button type="button" class="btn btn-danger removeNewFileBtn">Remove</button>
                </div>
                <div class="file-names"></div>
            `;
            wrapper.html(group);
            $('#fileInputsContainer').append(wrapper);
        };

        // Remove new file input
        $('#fileInputsContainer').on('click', '.removeNewFileBtn', function () {
            $(this).closest('.file-wrapper').remove();
        });
    </script>
    
    
    <script>
        $(document).ready(function() {
            // Determine if it's an edit form
            var isEdit = {{ isset($getRow) ? 'true' : 'false' }};
    
            // Custom rule for vehicle number
            $.validator.addMethod("vehiclenumber", function (value, element) {
                return this.optional(element) || /^[A-Z]{2}[0-9]{2}[A-Z]{2}[0-9]{4}$/i.test(value);
            }, "Please enter a valid vehicle number (e.g., TN12AB1234)");
    
            $("#driver_form").validate({
                rules: {
                    driver_name: {
                        required: true,
                        maxlength: 255
                    },
                    photo: {
                        required: isEdit ? false : true, // Not required in edit mode
                        extension: "jpg|jpeg|png|gif"
                    },
                    vehicle_name: {
                        required: true
                    },
                    // vehicle_number: {
                    //     required: true,
                    //     vehiclenumber: true
                    // },
                    vehicle_number: {
                        required: true,
                        vehiclenumber: true,
                        remote: {
                            url: "{{ route('admin.edit_check_vehiclenumber') }}",
                            type: "post",
                            data: {
                                _token: '{{ csrf_token() }}',
                                vehicle_number: function() {
                                    return $("#vehicle_number").val();
                                },
                                ref_id: '{{ $getRow->id ?? '' }}', // Handle new entries
                            },
                        },
                    },
                    user_name: {
                        required: true,
                        digits: true,
                        minlength: 10,
                        maxlength: 10,
                        remote: {
                            url: "{{ route('admin.edit_check_username') }}",
                            type: "post",
                            data: {
                                _token: '{{ csrf_token() }}',
                                user_name: function() {
                                    return $("#user_name").val();
                                },
                                ref_id: '{{ $getRow->id ?? '' }}', // Handle new entries
                            },
                        },
                    },
                    password: {
                            minlength: 6
                        },
                        password_confirmation: {
                            equalTo: "#password"
                    }
                    "document_titles[]": {
                        required: isEdit ? false : true,
                        maxlength: 255
                    },
                    "documents[]": {
                        required: isEdit ? false : true, // Not required in edit mode
                        extension: "pdf|jpg|jpeg|png|doc|docx|xls|xlsx"
                    }
                },
                messages: {
            driver_name: {
                required: "Driver name is required"
            },
            vehicle_name: {
                required: "Please select a vehicle"
            },
            vehicle_number: {
                required: "Vehicle number is required",
                vehiclenumber:'Please enter a valid vehicle number (e.g., TN12AB1234)',
                remote:'This Vehicle number is already registered',
            },
            
               
          user_name : {
                      required: "Phone number is required",
                      digits: "Only digits are allowed",
                      minlength: "Phone number must be 10 digits",
                      maxlength: "Phone number must be 10 digits",
					  remote:'This Mobile number is already registered',
					},
                   
            password: {
            required: "Please enter a password",
            minlength: "Password must be at least 6 characters"
        },
        password_confirmation: {
            required: "Please confirm your password",
            minlength: "Password must be at least 6 characters",
            equalTo: "Passwords do not match"
        },
            photo: {
                extension: "Only image files are allowed"
            },
            "documents[]": {
                extension: "Only PDF and image files are allowed"
            }
        },
                errorElement: 'div',
                errorClass: 'invalid-feedback',
                highlight: function(element) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function(element) {
                    $(element).removeClass('is-invalid');
                },
                errorPlacement: function(error, element) {
                    if (element.parent('.input-group').length) {
                        error.insertAfter(element.parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });
    </script>
    
    
    @endsection
    
    
    
    @section('script2')
                  
    
    @endsection