<?php
namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class FrontendController extends Controller
{
    public function home()
    {
        return view('front.index');
    }
    public function contactsave(Request $request)
    {
        // Validate the request
        $request->validate([
            'name'        => 'required|string|max:255',
            'mobile'      => 'required|digits_between:10,15',
            'from_place'  => 'required|string|max:255',
            'to_place'    => 'required|string|max:255',
            'car_type'    => 'required|string|max:255',
            'pickup_date' => 'required|date',
            'pickup_time' => 'required',
            'message'     => 'nullable|string',
        ]);

        $dateTime = now();

        $insertId = DB::table('contactus')->insertGetId([
            'name'        => $request->name,
            'mobile'      => $request->mobile,
            'from_place'  => $request->from_place,
            'to_place'    => $request->to_place,
            'car_type'    => $request->car_type,
            'pickup_date' => $request->pickup_date,
            'pickup_time' => $request->pickup_time,
            'message'     => $request->message,
            'created_at'  => $dateTime,
        ]);

      
            return redirect()->route('home')->with('success', 'We have received your booking request. We will contact you soon.');
       
           
    }

}
