<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\DB;

class AutomateController extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    public function createmenutopermission()
    {
        $dateTime = date('Y-m-d H:i:s');
        $guard_name = "web";
        $menus = DB::table('backend_menu_managament')->get();
        /* 1-list, 2-add, 3-edit, 4-delete, 5-view, 6-others */
        $permissionarray = array();
        $permissionarray[] = array("slug" => "dashboard", "name" => "Dashboard", "type" => 0, "menu_id" => 0, "created_at" => $dateTime, "updated_at" => $dateTime, "guard_name" => $guard_name);
        foreach ($menus as $menu_row) {
            $menuid = $menu_row->id;
            $man_name = $menu_row->title;
            $slug_list = $menu_row->slug;
            if ($slug_list && $slug_list != "") {
                $list_name = $man_name;
                $type = 1;
                $permissionarray[] = array("slug" => $slug_list, "name" => $list_name, "type" => $type, "menu_id" => $menuid, "created_at" => $dateTime, "updated_at" => $dateTime, "guard_name" => $guard_name);
            }

            $slug_add = $menu_row->add_slug;

            if ($slug_add && $slug_add != "") {
                $add_name = $man_name . " - Add";
                $type = 2;
                $permissionarray[] = array("slug" => $slug_add, "name" => $add_name, "type" => $type, "menu_id" => $menuid, "created_at" => $dateTime, "updated_at" => $dateTime, "guard_name" => $guard_name);
            }

            $slug_edit = $menu_row->edit_slug;
            if ($slug_edit && $slug_edit != "") {
                $edit_name = $man_name . " - Edit";
                $type = 3;
                $permissionarray[] = array("slug" => $slug_edit, "name" => $edit_name, "type" => $type, "menu_id" => $menuid, "created_at" => $dateTime, "updated_at" => $dateTime, "guard_name" => $guard_name);
            }

            $slug_delete = $menu_row->delete_slug;
            if ($slug_delete && $slug_delete != "") {
                $delete_name = $man_name . " - Delete";
                $type = 4;
                $permissionarray[] = array("slug" => $slug_delete, "name" => $delete_name, "type" => $type, "menu_id" => $menuid, "created_at" => $dateTime, "updated_at" => $dateTime, "guard_name" => $guard_name);
            }

            $slug_view = $menu_row->view_slug;
            if ($slug_delete && $slug_delete != "") {
                $view_name = $man_name . " - View";
                $type = 5;
                $permissionarray[] = array("slug" => $slug_view, "name" => $view_name, "type" => $type, "menu_id" => $menuid, "created_at" => $dateTime, "updated_at" => $dateTime, "guard_name" => $guard_name);
            }

            $slug_extra = $menu_row->extra_slug;
            if ($slug_extra && $slug_extra != "") {
                $extra_arr = explode(",", $slug_extra);
                if (count($extra_arr) > 0) {
                    foreach ($extra_arr as $extra_slug) {
                        $view_name = $man_name . " - Extra";
                        $type = 6;
                        $permissionarray[] = array("slug" => trim($extra_slug), "name" => $view_name, "type" => $type, "menu_id" => $menuid, "created_at" => $dateTime, "updated_at" => $dateTime, "guard_name" => $guard_name);
                    }
                }
            }

        }

        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('permissions')->truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        DB::table('permissions')->insert($permissionarray);
        echo "<pre>";
        print_r($permissionarray);
        exit();
    }
}
