<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class DriverStatusController extends Controller
{
    public function getDriverStatus($driver_id)
    {
        $driverInfo = DB::table('driver_management as dm')
            ->leftJoin('booking_management as bm', 'dm.id', '=', 'bm.driver_id')
            ->leftJoin('driver_arrived as da', 'dm.id', '=', 'da.driver_id')
            ->where('dm.id', $driver_id)
            ->select(
                'dm.id as driver_id',
                'dm.driver_code',
                'dm.driver_name',
                'da.driver_status',
                'bm.id as booking_id',
                'bm.from_address',
                'bm.to_address',
                'bm.booking_status'
            )
            ->orderByDesc('bm.id') // latest booking
            ->first();

        if (! $driverInfo) {
            return response()->json([
                'status'  => false,
                'message' => 'Driver or booking not found.',
            ], 404);
        }

        // Separate driver and booking data
        $driverData = [
            'driver_id'     => $driverInfo->driver_id,
            'driver_code'   => $driverInfo->driver_code,
            'driver_name'   => $driverInfo->driver_name,
            'driver_status' => $driverInfo->driver_status,
        ];

        $bookingData = [
            'booking_id'     => $driverInfo->booking_id,
            'from_address'   => $driverInfo->from_address,
            'to_address'     => $driverInfo->to_address,
            'booking_status' => $driverInfo->booking_status,
        ];

        return response()->json([
            'status' => true,
            'data'   => [
                'driver'  => $driverData,
                'booking' => $bookingData,
            ],
        ]);
    }
}
