<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AcceptRideController extends Controller
{

    // public function acceptRide1(Request $request)
    // {
    //     $request->validate([
    //         'booking_id' => 'required|exists:booking_management,id',
    //     ]);

    //     $driver = auth('api_driver')->user();

    //     try {
    //         DB::beginTransaction();

    //         // Lock the booking row for update
    //         $booking = DB::table('booking_management')
    //             ->where('id', $request->booking_id)
    //             ->lockForUpdate()
    //             ->first();

    //         // If booking is already accepted
    //         if ($booking->trip_status == 1) {
    //             DB::rollBack();
    //             return response()->json(['message' => 'Ride already accepted.'], 400);
    //         }

    //         // Update the booking
    //         DB::table('booking_management')
    //             ->where('id', $request->booking_id)
    //             ->update([
    //                 'driver_id'   => $driver->id,
    //                 'trip_status' => 1,
    //             ]);

    //         // Update driver trip status
    //         DB::table('driver_management')
    //             ->where('id', $driver->id)
    //             ->update([
    //                 'trip_status' => 1,
    //             ]);

    //         DB::commit();

    //         return response()->json(['message' => 'Ride accepted successfully.']);

    //     } catch (\Exception $e) {
    //         DB::rollBack();
    //         return response()->json(['message' => 'Something went wrong.', 'error' => $e->getMessage()], 500);
    //     }
    // }

//   public function acceptRide(Request $request)
// {
//     $request->validate([
//         'booking_id' => 'required|exists:booking_management,id',
//     ]);

//     $driver = auth('api_driver')->user();

//     try {
//         DB::beginTransaction();

//         // Lock the booking row to avoid race conditions
//         $booking = DB::table('booking_management')
//             ->where('id', $request->booking_id)
//             ->lockForUpdate()
//             ->first();

//         if (! $booking) {
//             DB::rollBack();
//             return response()->json(['message' => 'Booking ID not found.'], 404);
//         }

//         if ($booking->booking_status == 5) {
//             DB::rollBack();
//             return response()->json(['message' => 'Ride is already cancelled.'], 400);
//         }

//         if ($booking->trip_status == 1) {
//             DB::rollBack();
//             return response()->json(['message' => 'Ride already accepted.'], 400);
//         }

//         // Update booking with accepted driver
//         DB::table('booking_management')
//             ->where('id', $request->booking_id)
//             ->update([
//                 'driver_id'   => $driver->id,
//                 'trip_status' => 1,
//             ]);

//         DB::commit();
//     } catch (\Exception $e) {
//         DB::rollBack();
//         return response()->json(['message' => 'Transaction failed.', 'error' => $e->getMessage()], 500);
//     }

//     // ✅ OTP Generation and SMS Sending
//     try {
//         $booking = DB::table('booking_management')->find($request->booking_id);
//         $driver = DB::table('driver_management')->where('id', $booking->driver_id)->first();

//         $phone     = $booking->phone;
//         $otp       = rand(1000, 9999);
//         $expiresAt = Carbon::now()->addMinutes(30);

//         // Save OTP to database
//         DB::table('otp_codes')->insert([
//             'booking_id' => $request->booking_id,
//             'driver_id'  => $driver->id,
//             'phone'      => $phone,
//             'otp'        => $otp,
//             'expires_at' => $expiresAt,
//             'created_at' => now(),
//             'updated_at' => now(),
//         ]);

//         $message = "Your ride OTP is: $otp\n"
//             . "Driver Name: {$driver->driver_name}\n"
//             . "Driver Phone: {$driver->user_name}\n"
//             . "Vehicle Number: {$driver->vehicle_number}";

//         $this->sendWelcomeSms($phone, 'text', $message);

//     } catch (\Exception $e) {
//         // Log error if needed
//     }

//     // ✅ Notify all other drivers to cancel notification
//     try {
//         $otherDrivers = DB::table('driver_management')
//             ->where('id', '!=', $driver->id)
//             ->where('online_status', 'online')
//             ->where('trip_status', '!=', 1)
//             ->whereNotNull('device_id')
//             ->pluck('device_id')
//             ->toArray();

//         if (!empty($otherDrivers)) {
//             $chunks = array_chunk($otherDrivers, 100); // Expo limit is 100 per request

//             foreach ($chunks as $tokensChunk) {
//                 $messages = [];

//                 foreach ($tokensChunk as $token) {
//                     if (str_starts_with($token, 'ExponentPushToken')) {
//                         $messages[] = [
//                             'to' => $token,
//                             'sound' => 'default',
//                             'title' => 'Ride No Longer Available',
//                             'body' => 'This ride has already been accepted by another driver.',
//                             'data' => [
//                                 'booking_id' => $booking->id,
//                                 'type'       => 'ride_already_accepted',
//                             ],
//                         ];
//                     }
//                 }

//                 // Send to Expo Push Notification API
//                 $response = Http::withHeaders([
//                     'Accept' => 'application/json',
//                     'Content-Type' => 'application/json',
//                 ])->post('https://exp.host/--/api/v2/push/send', $messages);

//                 if (! $response->successful()) {
//                     Log::error('Expo cancel notification failed', [
//                         'response' => $response->body()
//                     ]);
//                 }
//             }
//         }
//     } catch (\Exception $e) {
//         Log::error('Failed to notify other drivers', [
//             'error' => $e->getMessage()
//         ]);
//     }

//     // ✅ Final response
//     return response()->json([
//         'message' => 'Ride accepted and OTP sent successfully.',
//         'otp'     => $otp,
//         'data'    => $driver, // optional for debug
//     ]);
// }

    public function acceptRide(Request $request)
    {
        $request->validate([
            'booking_id' => 'required|exists:booking_management,id',
        ]);

        $driver = auth('api_driver')->user();

        try {
            DB::beginTransaction();

            // Lock the booking row to avoid race conditions
            $booking = DB::table('booking_management')
                ->where('id', $request->booking_id)
                ->lockForUpdate()
                ->first();

            if (! $booking) {
                DB::rollBack();
                return response()->json(['message' => 'Booking ID not found.'], 404);
            }

            if ($booking->booking_status == 5) {
                DB::rollBack();
                return response()->json(['message' => 'Ride is already cancelled.'], 400);
            }

            if ($booking->trip_status == 1) {
                DB::rollBack();
                return response()->json(['message' => 'Ride already accepted.'], 400);
            }

            // Update booking with accepted driver
            DB::table('booking_management')
                ->where('id', $request->booking_id)
                ->update([
                    'driver_id' => $driver->id,
                ]);

            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['message' => 'Transaction failed.', 'error' => $e->getMessage()], 500);
        }

        // ✅ OTP Generation and SMS Sending
        try {
            $booking = DB::table('booking_management')->find($request->booking_id);
            $driver  = DB::table('driver_management')->where('id', $booking->driver_id)->first();

            $phone     = $booking->phone;
            $otp       = rand(1000, 9999);
            $expiresAt = Carbon::now()->addMinutes(30)->format('Y-m-d H:i:s');

            // Save OTP to database
            DB::table('otp_codes')->insert([
                'booking_id' => $request->booking_id,
                'driver_id'  => $driver->id,
                'phone'      => $phone,
                'otp'        => $otp,
                'expires_at' => $expiresAt,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            $message = "Your ride OTP is: $otp\n"
                . "Driver Name: {$driver->driver_name}\n"
                . "Driver Phone: {$driver->user_name}\n"
                . "Vehicle Number: {$driver->vehicle_number}";

            $this->sendWelcomeSms($phone, 'text', $message);

        } catch (\Exception $e) {
            // Log error if needed
        }

        // ✅ Notify all other drivers to cancel notification
        //     try {
        //         $otherDrivers = DB::table('driver_management')
        //             ->where('id', '!=', $driver->id)
        //             ->where('online_status', 'online')
        //             ->where('trip_status', '!=', 1)
        //             ->whereNotNull('device_id')
        //             // ->where('device_id', 'not like', '%expo%')
        //             ->pluck('device_id')
        //             ->toArray();

        //         if (! empty($otherDrivers)) {
        //             $chunks = array_chunk($otherDrivers, 100); // Expo limit is 100 per request

        //             foreach ($chunks as $tokensChunk) {
        //                 $messages = [];

        //                 foreach ($tokensChunk as $token) {
        //                     if (str_starts_with($token, 'ExponentPushToken')) {
        //                         $messages[] = [
        //                             'to'    => $token,
        //                             'sound' => 'default',
        //                             'title' => 'Ride No Longer Available',
        //                             'body'  => 'This ride has already been accepted by another driver.',
        //                             'data'  => [
        //                                 'booking_id' => $booking->id,
        //                                 'type'       => 'ride_already_accepted',
        //                             ],
        //                         ];
        //                     }
        //                 }

        //                 // Send to Expo Push Notification API
        //                 $response = Http::withHeaders([
        //                     'Accept'       => 'application/json',
        //                     'Content-Type' => 'application/json',
        //                 ])->post('https://exp.host/--/api/v2/push/send', $messages);

        //                 if (! $response->successful()) {
        //                     Log::error('Expo cancel notification failed', [
        //                         'response' => $response->body(),
        //                     ]);
        //                 }
        //             }
        //         }
        //     } catch (\Exception $e) {
        //         Log::error('Failed to notify other drivers', [
        //             'error' => $e->getMessage(),
        //         ]);
        //     }

        //     // ✅ Final response
        //     return response()->json([
        //         'message' => 'Ride accepted and OTP sent successfully.',
        //         'otp'     => $otp,
        //         'data'    => $driver, // optional for debug
        //     ]);
        // }

    }
}
