<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\BookingManagement;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class UpcomingRideController extends Controller
{
    public function upcomingRides(Request $request)
    {
        // echo 1;
        // exit(0);
        $driver = auth('api_driver')->user();

        $perPage = request()->get('perpage', 10);

        $page         = request()->get('page', 1);
        $upcomingRide = BookingManagement::where('driver_id', $driver->id)
            ->where('trip_status', 0)
            ->where('booking_status', 0)
            ->where('booking_date', '>=', date('Y-m-d'))
            ->orderBy('booking_dateTime', 'asc')
            ->paginate($perPage, ['*'], 'page', $page);

        return response()->json(['ride' => $upcomingRide]);
    }

    public function pastRides(Request $request)
    {
        // echo 1;
        // exit(0);
        $driver = auth('api_driver')->user();

        $perPage = request()->get('perpage', 10);

        $page     = request()->get('page', 1);
        $pastRide = BookingManagement::where('driver_id', $driver->id)
            ->where('booking_status', 4)
            ->where('booking_dateTime', '<=', now())
            ->orderBy('booking_dateTime', 'asc')
            ->paginate($perPage, ['*'], 'page', $page);

        return response()->json(['ride' => $pastRide]);
    }
    public function DriverRideDetails(Request $request)
    {
        $driver = auth('api_driver')->user();
        $today  = Carbon::today()->toDateString();

        // ✅ Total completed rides today
        $RideDetails = BookingManagement::where('driver_id', $driver->id)
            ->where('booking_status', 4)
            ->whereDate('booking_dateTime', $today)
            ->count();

        // ✅ Total distance traveled today
        $TotalDistance = DB::table('booking_management as bm')
            ->join('fare_summaries as fs', 'bm.id', '=', 'fs.booking_id')
            ->where('bm.driver_id', $driver->id)
            ->where('bm.booking_status', 4)
            ->whereDate('bm.booking_dateTime', $today)
            ->sum('fs.total_km_travelled');

        // ✅ Total amount earned today
        $TotalAmount = DB::table('booking_management as bm')
            ->join('fare_summaries as fs', 'bm.id', '=', 'fs.booking_id')
            ->where('bm.driver_id', $driver->id)
            ->where('bm.booking_status', 4)
            ->whereDate('bm.booking_dateTime', $today)
            ->sum('fs.total_price');

        // ✅ Online logs (optional: limit to today)
        $firstTotalHour = DB::table('driver_logdetails')
            ->where('driver_id', $driver->id)
            ->whereDate('driver_logintime', $today)
            ->pluck('total_hours')
            ->first(); // returns the first item from the array

        return response()->json([
            'ride'           => $RideDetails,
            'total_distance' => $TotalDistance,
            'total_amount'   => $TotalAmount,
            'online_hours'   => $firstTotalHour,
        ]);
    }
    public function Activeno(Request $request)
    {
        $driver = auth('api_driver')->user();
        $today  = Carbon::today()->toDateString();

    }
}
