<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\BookingManagement;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PendingRideController extends Controller
{

    public function pendingRides(Request $request)
    {
        $driver    = auth('api_driver')->user();
        $pickupLat = $driver->latitude;
        $pickupLng = $driver->longitude;

        // $radiusKm   = $pendingRide->radius_km;
        // $pickupLat  = $pendingRide->start_latitude;
        // $pickupLng  = $pendingRide->start_longitude;
        // $radiusKm   = $pendingRide->radius_km;

        $isOnline = DB::table('driver_management')
            ->where('id', $driver->id)
            ->where('online_status', 'online')
            ->exists();

        if (! $isOnline) {
            return response()->json([
            ]);
        }

        $driverRow = DB::table('driver_management')
            ->join('vehicle_management', 'driver_management.vehicle_id', '=', 'vehicle_management.id')
            ->where('driver_management.id', $driver->id)
            ->select('driver_name', 'cartype_id', 'driver_management.id as id')
            ->first();

        if (! $driverRow) {
            return response()->json([
            ]);
        }

        $pendingRide = BookingManagement::where(function ($query) use ($driver, $driverRow) {
            $query->where(function ($q) use ($driver) {
                $q->where('notify_driver', 'single')
                    ->where('driver_id', $driver->id);
            })->orWhere(function ($q) use ($driverRow) {
                $q->where('notify_driver', 'all');
                $q->where('cartype_id', $driverRow->cartype_id);
                // $q->whereRaw("FIND_IN_SET(?, notification_drivers)", [$driverRow->id]);
            });
        })
            ->where('deleted_status', 0)
            ->where('trip_status', 0)
            ->where('driver_id', 0)
            ->whereRaw("
                        (
                            6371 * acos(
                                cos(radians(?)) *
                                cos(radians(start_latitude)) *
                                cos(radians(start_longitude) - radians(?)) +
                                sin(radians(?)) *
                                sin(radians(start_latitude))
                            )
                        ) <= radius_km
                    ", [$pickupLat, $pickupLng, $pickupLat])
        // ->whereNull('driver_id') // 👈 ADD THIS LINE
            ->latest()
            ->first();

        return response()->json(['ride' => $pendingRide]);
    }

    public function pendingRides1(Request $request)
    {
        $driver = auth('api_driver')->user();

        $pendingRide = BookingManagement::where(function ($query) use ($driver) {
            $query->where(function ($q) use ($driver) {
                $q->where('notify_driver', 'single')
                    ->where('driver_id', $driver->id);
            })->orWhere(function ($q) {
                $q->where('notify_driver', 'all');
            });
        })
            ->where('trip_status', 0)
            ->latest()
            ->first();

        return response()->json(['ride' => $pendingRide]);
    }

/*

    public function pendingRides2(Request $request)
    {
        $driver = auth('api_driver')->user();

        $pendingRide = BookingManagement::where(function ($query) use ($driver) {
            $query->where(function ($q) use ($driver) {
                $q->where('notify_driver', 'single')
                    ->where('driver_id', $driver->id);
            })->orWhere(function ($q) {
                $q->where('notify_driver', 'all');
            });
        })
            ->where('trip_status', 0)
            ->latest()
            ->first();

        if (! $pendingRide) {
            return response()->json(['ride' => null, 'message' => 'No pending rides']);
        }

        // Determine the drivers to notify
        // For example, if 'notify_driver' = 'all', notify all active drivers
        if ($pendingRide->notify_driver === 'all') {
            // Get all active driver IDs who have device tokens
            $driverIds = DB::table('driver_management')
                ->whereNotNull('device_id')
            ->where('device_id', 'not like', '%expo%')
                ->pluck('id')
                ->toArray();
        } else {
            // Notify single driver (the driver assigned)
            $driverIds = [$pendingRide->driver_id];
        }

        // Get device tokens for those driver IDs
        $tokens = DB::table('driver_management')
            ->whereIn('id', $driverIds)
            ->whereNotNull('device_id')
            ->where('device_id', 'not like', '%expo%')
            ->pluck('device_id')
            ->toArray();

        // Prepare Expo push messages (assuming you use Expo push service)
        $messages = [];

        foreach ($tokens as $token) {
            $messages[] = [
                'to'    => $token,
                'sound' => 'default',
                'title' => 'Pending Ride Alert',
                'body'  => 'You have a pending ride to attend.',
                'data'  => ['ride_id' => $pendingRide->id],
            ];
        }

        if (! empty($messages)) {
            $response = Http::withHeaders([
                'Accept'       => 'application/json',
                'Content-Type' => 'application/json',
            ])->post('https://exp.host/--/api/v2/push/send', $messages);

            // Optional: Log or handle the response
            // Log::info('Push notification response:', $response->json());
        }

        return response()->json(['ride' => $pendingRide, 'notification_response' => $response->json() ?? null]);
    }
*/

// public function pendingRides(Request $request)
// {
//     $driver = auth('api_driver')->user();

//     // Get car type of the driver from vehicle_management
//     $vehicle = DB::table('vehicle_management')
//         ->where('driver_id', $driver->id)
//         ->first();

//     if (! $vehicle) {
//         return response()->json(['ride' => null, 'message' => 'Driver has no vehicle registered']);
//     }

//     $carTypeId = $vehicle->cartype_id;
//     $pickupLat = $driver->latitude;
//     $pickupLng = $driver->longitude;

//     $pendingRide = BookingManagement::where(function ($query) use ($driver) {
//             $query->where(function ($q) use ($driver) {
//                 $q->where('notify_driver', 'single')
//                     ->where('driver_id', $driver->id);
//             })->orWhere(function ($q) {
//                 $q->where('notify_driver', 'all');
//             });
//         })
//         ->where('trip_status', 0)
//         ->where(function ($q) use ($carTypeId) {
//             $q->where('car_type', $carTypeId); // Match driver car type
//         })
//         ->where(function ($q) use ($pickupLat, $pickupLng) {
//             $q->whereRaw("
//                 (
//                     6371 * acos(
//                         cos(radians(?)) *
//                         cos(radians(start_latitude)) *
//                         cos(radians(start_longitude) - radians(?)) +
//                         sin(radians(?)) *
//                         sin(radians(start_latitude))
//                     )
//                 ) <= radius_km
//             ", [$pickupLat, $pickupLng, $pickupLat]);
//         })
//         ->where(function ($q) {
//             $q->whereNull('driver_id')->orWhere('driver_id', 0);
//         })
//         ->latest()
//         ->first();

//     return response()->json(['ride' => $pendingRide]);
// }

}
