<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DriverReachController extends Controller
{

    public function driverdeparture(Request $request)
    {
        $request->validate([
            'booking_id'      => 'required|integer',
            'start_latitude'  => 'required|numeric',
            'start_longitude' => 'required|numeric',
            'start_image'     => 'nullable|image|mimes:jpg,jpeg,png|max:2048',
            'start_km'        => 'required|numeric',
        ]);
        $driver    = auth('api_driver')->user();
        $imagePath = "";
        if ($request->hasFile('start_image')) {
            $imagePath = $request->file('start_image')->store('driverdeparture_start_images', 'public');
        }

        DB::table('driver_management')
            ->where('id', $driver->id)
            ->update(['trip_status' => 1]);

        $id = DB::table('driver_arrived')->insertGetId([
            'booking_id'         => $request->booking_id,
            'driver_id'          => $driver->id,
            'driver_departed_at' => Carbon::now(),
            'start_latitude'     => $request->start_latitude,
            'start_longitude'    => $request->start_longitude,
            'start_image'        => $imagePath,
            'start_km'           => $request->start_km,
            'created_at'         => now(),
            'updated_at'         => now(),
        ]);

        if ($id > 0) {
            DB::table('booking_management')->where('id', $request->booking_id)->where('deleted_status', 0)->update(['arrived_id' => $id]);
        }

        return response()->json(['message' => 'Driver departure recorded', 'id' => $id], 201);
    }

    public function driverreached(Request $request, $id)
    {
        $request->validate([
            'end_latitude'  => 'required|numeric',
            'end_longitude' => 'required|numeric',
            'end_image'     => 'nullable|image|mimes:jpg,jpeg,png|max:2048',
            'end_km'        => 'required|numeric',
        ]);

        $trip = DB::table('driver_arrived')->where('id', $id)->first();

        if (! $trip) {
            return response()->json(['message' => 'Trip not found'], 404);
        }

        // 1. total_km as start_km + end_km
        $total_km = $request->end_km - $trip->start_km;

        // 2. Calculate lat-lon distance using Haversine formula
        $lat1 = $trip->start_latitude;
        $lon1 = $trip->start_longitude;
        $lat2 = $request->end_latitude;
        $lon2 = $request->end_longitude;

        $earthRadius = 6371; // in kilometers

        $dLat = deg2rad($lat2 - $lat1);
        $dLon = deg2rad($lon2 - $lon1);

        $a = sin($dLat / 2) * sin($dLat / 2) +
        cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
        sin($dLon / 2) * sin($dLon / 2);

        $c               = 2 * atan2(sqrt($a), sqrt(1 - $a));
        $lat_lon_totalkm = $earthRadius * $c;

        // 3. Calculate amount
        $amount_per_km       = 10;
        $lat_lon_totalamount = $lat_lon_totalkm * $amount_per_km;
        $total_amount        = $total_km * $amount_per_km;

        // Store image

        $imagePath = "";
        if ($request->hasFile('end_image')) {
            $imagePath = $request->file('end_image')->store('driverreached_end_images', 'public');
        }

        $expiresAt = Carbon::now()->addMinutes(30)->format('Y-m-d H:i:s');

        DB::table('otp_codes')
            ->where('booking_id', $trip->booking_id)
            ->where('driver_id', $trip->driver_id)
            ->update([
                'expires_at' => $expiresAt,
                'updated_at' => now(),
            ]);

        // Update record
        DB::table('driver_arrived')
            ->where('id', $id)
            ->update([
                'driver_arrived_at'   => now(),
                'end_latitude'        => $lat2,
                'end_longitude'       => $lon2,
                'end_image'           => $imagePath,
                'end_km'              => $request->end_km,
                'total_km'            => $total_km,
                'amount_per_km'       => 0,
                'total_amount'        => 0,
                'lat_lon_totalkm'     => $lat_lon_totalkm,
                'lat_lon_totalamount' => $lat_lon_totalamount,
                'updated_at'          => now(),
            ]);

        return response()->json(['message' => 'Driver arrival updated successfully',
            'expires_at'                       => $expiresAt,
        ]);
    }

}
