<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class DriverLocationController extends Controller
{
    public function updateLocation(Request $request)
    {
        $request->validate([
            'latitude'  => 'required|numeric',
            'longitude' => 'required|numeric',
        ]);

        $driver = Auth::guard('api_driver')->user();

        DB::table('driver_management')->updateOrInsert(
            ['id' => $driver->id],
            [
                'latitude'   => $request->latitude,
                'longitude'  => $request->longitude,
                'updated_at' => now(),
            ]
        );

        return response()->json([
            'status'  => true,
            'message' => 'Driver location updated successfully.',
        ]);
    }

}
