<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Tymon\JWTAuth\Facades\JWTAuth;

class DriverAuthController extends Controller
{
    public function login1(Request $request)
    {
        $request->validate([
            'user_name' => 'required|string',
            'password'  => 'required|string',
        ]);

        if (! $token = auth('api_driver')->attempt($request->only('user_name', 'password'))) {
            return response()->json([
                'error'   => true,
                'message' => 'Invalid credentials',
            ], 401);
        }

        $driver = auth('api_driver')->user();

        return response()->json([
            'access_token' => $token,
            'token_type'   => 'bearer',
            'driver'       => [
                'driver_id'      => $driver->id,
                'driver_code'    => $driver->driver_code,
                'driver_name'    => $driver->driver_name,
                'photo'          => $driver->photo,
                'vehicle_number' => $driver->vehicle_number,
                'user_name'      => $driver->user_name,
            ],
        ]);
    }

    public function login(Request $request)
    {
        $request->validate([
            'user_name' => 'required|string',
            'password'  => 'required|string',
            'deviceId'  => 'nullable|string',
            'latitude'  => 'nullable|numeric',
            'longitude' => 'nullable|numeric',
        ]);

        if (! $token = auth('api_driver')->attempt($request->only('user_name', 'password'))) {
            return response()->json([
                'error'   => true,
                'message' => 'Invalid credentials',
            ], 401);
        }

        $driver         = auth('api_driver')->user();
        $current_driver = DB::table('driver_management')
            ->where('id', $driver->id)
            ->first();
        DB::table('driver_management')
            ->where('id', $driver->id)
            ->update([
                'device_id'  => $request->deviceId ?? $current_driver->device_id,
                // 'online_status' => 'online',
                'latitude'   => $request->latitude ?? $current_driver->latitude,
                'longitude'  => $request->longitude ?? $current_driver->longitude,
                'updated_at' => now(),
            ]);

        $refreshToken = $token;

        $driver = DB::table('driver_management')
            ->where('id', $driver->id)
            ->first();

        return response()->json([
            'access_token'  => $token,
            'refresh_token' => $refreshToken,
            'expires_in'    => auth('api_driver')->factory()->getTTL() * 60,
            'token_type'    => 'bearer',
            'driver'        => [
                'driver_id'      => $driver->id,
                'driver_code'    => $driver->driver_code,
                'driver_name'    => $driver->driver_name,
                'photo'          => $driver->photo,
                'vehicle_number' => $driver->vehicle_number,
                'user_name'      => $driver->user_name,
                'latitude'       => $driver->latitude,
                'longitude'      => $driver->longitude,
                'device_id'      => $driver->device_id,
                'online_status'  => $driver->online_status,

            ],
        ]);
    }

    public function refreshToken(Request $request)
    {
        try {
            // Refresh token using the expired token sent in Authorization header
            $refreshedToken = JWTAuth::parseToken()->refresh();

            return response()->json([
                'access_token' => $refreshedToken,
                'token_type'   => 'bearer',
                // 'expires_in'   => auth('api_driver')->factory()->make()()->getTTL() * 60, // in seconds
                'expires_in'   => auth('api_driver')->factory()->getTTL() * 60,
            ]);

        } catch (\Tymon\JWTAuth\Exceptions\TokenInvalidException $e) {
            return response()->json(['message' => 'Invalid token'], 401);
        } catch (\Tymon\JWTAuth\Exceptions\JWTException $e) {
            return response()->json(['message' => 'Token not provided'], 401);
        }
    }

}
