<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ContactusController extends Controller
{

    public function dataindex(Request $request)
    {
        $recordsTotal    = 0;
        $recordsFiltered = 0;
        $draw            = $request->input('draw', '1');
        $start           = $request->input('start', '0');
        $length          = $request->input('length', '0');
        $columnsall      = $request->input('columns', []);
        $orderall        = $request->input('order', []);
        $dataResult      = [];
        $recordQry       = DB::table('contactus');

        foreach ($columnsall as $key => $column_row) {
            $isSearchable = $column_row['searchable'];
            $dbcolname    = $column_row['data'];
            $dbcolval     = $column_row['search']['value'];
            $dbcolval     = trim($dbcolval);

            if ($dbcolval != "" && $isSearchable && ! is_numeric($dbcolname)) {

                switch ($dbcolname) {
                    case 'name':
                        if ($dbcolval > 0) {

                            $recordQry->where(function ($query) use ($dbcolval) {

                                $query->orWhere('name', 'like', '%' . $dbcolval . '%');

                            });
                        }
                        break;

                    default:
                        $recordQry->where($dbcolname, 'like', '%' . $dbcolval . '%');
                        break;
                }

            }
        }

        if ($orderall) {
            $ordtyp = $orderall[0]['dir'];
            if ($orderall[0]['column'] > 0) {
                $colsynt   = $orderall[0]['column'];
                $dbcolname = $columnsall[$colsynt]['data'];
                $recordQry->orderBy($dbcolname, $ordtyp);
            } else {
                $recordQry->orderBy('id', $ordtyp);
            }
        }

        $recordAllQry = $recordQry;
        $recordsTotal = $recordAllQry->count();

        $recordList = $recordQry->orderBy('id', 'desc')
            ->offset($start)->limit($length)->get();
        $recordsFiltered = $recordList->count();
        $dataResult      = $recordList;

        return response()->json(["draw" => $draw, "recordsTotal" => $recordsTotal, "recordsFiltered" => $recordsTotal, "data" => $dataResult]);
    }

    public function index()
    {
        $messages = DB::table('contactus')->orderBy('created_at', 'desc');
        return view('admin.contactus_management.list', compact('messages'));
    }
    public function show($id)
    {
        $getRow = DB::table('contactus')->where('id', $id)->first();
        return view('admin.contactus_management.view', compact('getRow'));
    }
    public function destroy($id)
    {

        $contact = DB::table('contactus')->where('id', $id)->first();

        if (! $contact) {
            return response()->json(['status' => 404, 'message' => 'content not found']);
        }

        DB::beginTransaction();
        try {
            DB::table('contactus')->where('id', $id)->delete();
            DB::commit();

            return response()->json(['status' => 200, 'message' => 'Deleted successfully']);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['status' => 500, 'message' => 'Delete failed']);
        }

    }
}
