<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\ACommonController;
use App\Models\BookingManagement;
use Google\Auth\Credentials\ServiceAccountCredentials;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class BookingManagementController extends ACommonController
{

    public function dataindex(Request $request)
    {
        $recordsTotal    = 0;
        $recordsFiltered = 0;
        $draw            = $request->input('draw', '1');
        $start           = $request->input('start', '0');
        $length          = $request->input('length', '0');
        $columnsall      = $request->input('columns', []);
        $orderall        = $request->input('order', []);
        $dataResult      = [];
        $recordQry       = DB::table('booking_management')
            ->leftJoin('driver_management', 'booking_management.driver_id', '=', 'driver_management.id')
            ->leftJoin('otp_codes', 'booking_management.id', '=', 'otp_codes.booking_id')
            ->select(
                'booking_management.*',
                'driver_management.driver_name as DriverName',
                'otp_codes.otp'
            );

        foreach ($columnsall as $key => $column_row) {
            $isSearchable = $column_row['searchable'];
            $dbcolname    = $column_row['data'];
            $dbcolval     = trim($column_row['search']['value']);

            if ($dbcolval !== "" && $isSearchable && ! is_numeric($key)) {

                switch ($dbcolname) {
                    case 'car_model':
                        $carbrandIds = DB::table('carbrand_management')
                            ->where('brand_name', 'like', '%' . $dbcolval . '%')
                            ->pluck('id');

                        $recordQry->where(function ($query) use ($dbcolval, $carbrandIds) {
                            $query->orWhere('vehicle_management.car_model', 'like', '%' . $dbcolval . '%')
                                ->orWhereIn('vehicle_management.carbrand_id', $carbrandIds)
                                ->orWhere('vehicle_management.fuel_type', 'like', '%' . $dbcolval . '%')
                                ->orWhere('vehicle_management.seat_capacity', 'like', '%' . $dbcolval . '%');
                        });
                        break;

                    default:
                        $recordQry->where($dbcolname, 'like', '%' . $dbcolval . '%');
                        break;
                }
            }
        }

        if ($orderall) {
            $ordtyp = $orderall[0]['dir'];
            if ($orderall[0]['column'] > 0) {
                $colsynt   = $orderall[0]['column'];
                $dbcolname = $columnsall[$colsynt]['data'];
                $recordQry->orderBy($dbcolname, $ordtyp);
            } else {
                $recordQry->orderBy('id', $ordtyp);
            }
        }
        $recordAllQry = $recordQry;
        $recordsTotal = $recordAllQry->count();
        $recordList   = $recordQry->orderBy('id', 'desc')
            ->offset($start)->limit($length)->get();
        $recordsFiltered = $recordList->count();
        $dataResult      = $recordList;

        return response()->json(["draw" => $draw, "recordsTotal" => $recordsTotal, "recordsFiltered" => $recordsTotal, "data" => $dataResult]);
    }

    public function index()
    {
        return view('admin.booking_management.list');
    }

    public function test()
    {

        $estimation = $this->getEstimatedAmountAndPackage([
            'cartype_id'     => 2,
            'ac_type'        => 'AC',
            'traveltype_id'  => 1,
            'estimated_km'   => 35,
            'estimated_time' => 4,
        ]);
        dd($estimation);

    }public function create()
    {

        $googleMapsApiKey = env('NEW_GOOGLE_MAPS_API_KEY');
        $drivers          = DB::table('driver_management')->select('id', 'latitude', 'longitude')
            ->where('online_status', '=', 'online')
            ->where('trip_status', 0)
            ->get();
        // dd($drivers);
        $traveltype = DB::table('travel_types')->get();
        $cartype    = DB::table('cartype_management')->get();

        return view('admin.booking_management.map
        ', compact('googleMapsApiKey', 'drivers', 'traveltype', 'cartype'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'notify_driver'  => 'required|in:single,all',
            'cartype'        => 'required',
            'customer_name'  => 'required|string|max:255',
            'phone'          => 'required|string|max:20',
            'from_address'   => 'required|string',
            'to_address'     => 'required|string',
            'from_latitude'  => 'required|numeric',
            'from_longitude' => 'required|numeric',
            'to_latitude'    => 'required|numeric',
            'to_longitude'   => 'required|numeric',
            'driver_id'      => 'required_if:notify_driver,single|nullable|exists:driver_management,id',
        ]);

        $booktime = date("H:i:s", strtotime($request->booking_time));

        // ✅ Get estimated amount & package before create
        $estimation = $this->getEstimatedAmountAndPackage([
            'cartype_id'     => $request->cartype,
            'ac_type'        => $request->vehicle_ac_type,
            'traveltype_id'  => $request->traveltype,
            'estimated_km'   => $request->distance_km,
            'estimated_time' => $request->estimated_hours,
        ]);
        if (count($estimation) > 0) {
            $booking = BookingManagement::create([
                'driver_id'           => $request->notify_driver === 'single' ? $request->driver_id : 0,
                'radius_km'           => $request->radiuskm,
                'ac_type'             => $request->vehicle_ac_type,
                'cartype_id'          => $request->cartype,
                'notify_driver'       => $request->notify_driver,
                'customer_name'       => $request->customer_name,
                'traveltype_id'       => $request->traveltype,
                'phone'               => $request->phone,
                'from_address'        => $request->from_address,
                'to_address'          => $request->to_address,
                'start_latitude'      => $request->from_latitude,
                'start_longitude'     => $request->from_longitude,
                'end_latitude'        => $request->to_latitude,
                'end_longitude'       => $request->to_longitude,
                'estimated_km'        => $request->distance_km,
                'estimated_time'      => $request->estimated_hours,
                'estimated_amount'    => $estimation['amount'],
                'estimated_packageid' => $estimation['package_id'],
                'booking_date'        => $request->booking_date,
                'booking_time'        => $booktime,
                'booking_dateTime'    => $request->booking_date . " " . $booktime,
            ]);
            $pickupLat = $request->from_latitude;
            $pickupLng = $request->from_longitude;
            $radiusKm  = $request->radiuskm;
            if ($request->notify_driver === 'single') {

                // ✅ 1. Assign the booking directly to the selected driver
                DB::table('booking_management')
                    ->where('id', $booking->id)
                    ->update([
                        'driver_id'      => $request->driver_id,
                        'booking_status' => 2, // Example: Assigned
                        'updated_at'     => now(),
                    ]);

                //✅ 2. Send notification ONLY to that driver
                $driverTokens = DB::table('driver_management')
                    ->where('id', $request->driver_id)
                    ->whereNotNull('device_id')
                    ->where('device_id', 'not like', '%expo%')
                    ->pluck('device_id')
                    ->toArray();

                $otp       = rand(1000, 9999);
                $expiresAt = now()->addMinutes(30);

                // Insert OTP record
                DB::table('otp_codes')->insert([
                    'booking_id' => $booking->id,
                    'driver_id'  => $booking->driver_id,
                    'phone'      => $booking->phone,
                    'otp'        => $otp,
                    'expires_at' => $expiresAt,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);

                // Send OTP message
                $message = "Your ride OTP is: " . $otp;
                $this->sendWelcomeSms($booking->phone, 'text', $message); // Custom SMS handler

            } else {
                // Notify all available drivers (e.g., online status)
                $driverTokens = DB::table('driver_management')
                    ->whereNotNull('device_id')
                    ->where('device_id', '!=', '')
                    ->where('device_id', 'not like', '%expo%')
                    ->where('online_status', 'online')
                    ->whereRaw("
        (
            6371 * acos(
                cos(radians(?)) *
                cos(radians(latitude)) *
                cos(radians(longitude) - radians(?)) +
                sin(radians(?)) *
                sin(radians(latitude))
            )
        ) <= ?
    ", [$pickupLat, $pickupLng, $pickupLat, $radiusKm])
                    ->pluck('device_id')
                    ->toArray();

            }

            try {
                $jsonPath = storage_path('app/public/firebase/vaigainammataxi-firebase-adminsdk-fbsvc-0298640d7a.json');

                $scopes      = ['https://www.googleapis.com/auth/firebase.messaging'];
                $credentials = new ServiceAccountCredentials($scopes, $jsonPath);
                $token       = $credentials->fetchAuthToken()['access_token'];
                $projectId   = json_decode(file_get_contents($jsonPath))->project_id;
                $fcmUrl      = "https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send";

                foreach ($driverTokens as $deviceToken) {
                    $title = $request->notify_driver === 'single' ? 'Ride Assigned' : 'New Ride Request';
                    $body  = $request->notify_driver === 'single'
                    ? 'A ride has been assigned to you directly.'
                    : 'Tap to accept the new ride request.';

                    $message = [
                        'message' => [
                            'token'        => $deviceToken,
                            'notification' => [
                                'title' => $title,
                                'body'  => $body,
                            ],
                            'data'         => [
                                'screen'       => '/app/index',
                                'customSound'  => 'alert33762.mp3',
                                'booking_id'   => "" . $booking->id . "",
                                'from_address' => "" . $booking->from_address . "",
                                'to_address'   => "" . $booking->to_address . "",
                            ],
                            'android'      => [
                                'notification' => [
                                    'sound'      => 'alert33762',
                                    'channel_id' => 'high-priority',
                                ],
                            ],
                            'apns'         => [
                                'payload' => [
                                    'aps' => [
                                        'sound' => 'alert33762.caf',
                                    ],
                                ],
                            ],
                        ],
                    ];

                    $response = Http::withToken($token)
                        ->withHeaders(['Content-Type' => 'application/json'])
                        ->post($fcmUrl, $message);

                    if (! $response->successful()) {
                        Log::error('FCM Push Failed', [
                            'token'    => $deviceToken,
                            'response' => $response->body(),

                        ]);
                    } else {
                        // Log::success('FCM Push Success', [
                        //     'token'    => $deviceToken,
                        //     'response' => $response->json(),
                        // ]);
                        // dd($message);
                    }

                }
            } catch (\Exception $e) {
                Log::error('FCM Notification Exception', [
                    'error' => $e->getMessage(),
                ]);
            }

            event(new \App\Events\SendRideRequestEvent($booking));
            // SendExpoNotificationJob::dispatch($booking, $driverTokens);

            // SendRideTimeoutJob::dispatch($booking->id)->delay(now()->addSeconds(30));

            return redirect()->route('admin.BookingManagement-index')->with('success', 'Ride created successfully!');

        } else {
            return redirect()->route('admin.BookingManagement-index')->with('error', 'Error occurred');

        }

    }

    public function store1(Request $request)
    {
        $request->validate([
            'notify_driver'  => 'required|in:single,all',
            'customer_name'  => 'required|string|max:255',
            'phone'          => 'required|string|max:20',
            'from_address'   => 'required|string',
            'to_address'     => 'required|string',
            'from_latitude'  => 'required|numeric',
            'from_longitude' => 'required|numeric',
            'to_latitude'    => 'required|numeric',
            'to_longitude'   => 'required|numeric',
            'driver_id'      => 'required_if:notify_driver,single|nullable|exists:driver_management,id',
        ]);
        $booktime = date("H:i:s", strtotime($request->booking_time));
        $booking  = BookingManagement::create([
            'driver_id'        => $request->notify_driver === 'single' ? $request->driver_id : 0,
            'radius_km'        => $request->radiuskm,
            'ac_type'          => $request->vehicle_ac_type,
            'cartype_id'       => $request->cartype,
            'notify_driver'    => $request->notify_driver,
            'customer_name'    => $request->customer_name,
            'traveltype_id'    => $request->traveltype,
            'phone'            => $request->phone,
            'from_address'     => $request->from_address,
            'to_address'       => $request->to_address,
            'start_latitude'   => $request->from_latitude,
            'start_longitude'  => $request->from_longitude,
            'end_latitude'     => $request->to_latitude,
            'end_longitute'    => $request->to_longitude,
            'booking_date'     => $request->booking_date,
            'booking_time'     => $booktime,
            'booking_dateTime' => $request->booking_date . " " . $booktime,
        ]);

        // Get tokens
        if ($request->notify_driver === 'single') {
            $driverTokens = DB::table('driver_management')
                ->where('id', $request->driver_id)
                ->whereNotNull('device_id')
                ->pluck('device_id')
                ->toArray();
        } else {
            $driverTokens = DB::table('driver_management')
                ->whereNotNull('device_id')
                ->where('device_id', 'not like', '%expo%')
                ->where('online_status', 'online') // single =, not ==
                ->pluck('device_id')
                ->toArray();
        }

        // Send push notification via Firebase
        foreach ($driverTokens as $token) {
            $payload = [
                'to'           => $token,
                'notification' => [
                    'title' => 'New Ride Request',
                    'body'  => 'Tap to accept the new ride request',
                    'sound' => 'default',
                ],
                'data'         => [
                    'booking_id'   => $booking->id,
                    'from_address' => $booking->from_address,
                    'to_address'   => $booking->to_address,
                    'screen'       => '/app/index', // Adjust to your frontend route
                ],
            ];

            $response = Http::withHeaders([
                'Authorization' => 'key=' . config('services.firebase.server_key'),
                'Content-Type'  => 'application/json',
            ])->post('https://fcm.googleapis.com/fcm/send', $payload);

            if (! $response->successful()) {
                Log::error('FCM Push Failed', [
                    'token'    => $token,
                    'response' => $response->body(),
                ]);
            }
        }

        // Trigger backend events if needed
        event(new \App\Events\SendRideRequestEvent($booking));
        // SendRideTimeoutJob::dispatch($booking->id)->delay(now()->addSeconds(30));

        return redirect()->route('admin.BookingManagement-index')->with('success', 'Ride created and notification sent!');
    }

    public function edit(Request $request, $id)
    {
        $getRow     = DB::table('booking_management')->where('id', $id)->first();
        $get_driver = DB::table('driver_management')->where('id', $getRow->driver_id)->first();

        $googleMapsApiKey = env('NEW_GOOGLE_MAPS_API_KEY');
        $drivers          = DB::table('driver_management')->select('id', 'latitude', 'longitude')
            ->where('online_status', '=', 'online')
            ->where('trip_status', 0)
            ->get();

        return view('admin.booking_management.edit', compact('getRow', 'get_driver', 'googleMapsApiKey', 'drivers'));
    }
    public function edit1(Request $request, $id)
    {
        $getRow = DB::table('booking_management as bm')
            ->leftJoin('driver_management as dm', 'bm.driver_id', '=', 'dm.id')
            ->leftJoin('otp_codes as otp', 'otp.booking_id', '=', 'bm.id')
            ->leftJoin('outstation_package as op', 'op.cartype_id', '=', 'bm.cartype_id')
            ->leftJoin('driver_arrived as da', 'da.booking_id', '=', 'bm.id')
            ->leftJoin('fare_summaries as fs', 'fs.booking_id', '=', 'bm.id')
            ->where('bm.id', $id)
            ->select(
                'bm.*',
                'dm.driver_name',
                'otp.start_km as otp_start_km',
                'otp.end_km as otp_end_km',
                'op.hillsac_price',
                'op.hillsnonac_price',
                'da.total_km',
                'da.start_km',
                'da.end_km',
                'da.driver_arrived_at',
                'da.driver_departed_at',
                'fs.start_time',
                'fs.end_time',
                'fs.total_km_travelled',
                'fs.total_price',
                'fs.extra_discountamount',
                'fs.extra_fair',
                'fs.hills_fare',
                'fs.hills_km',
            )
            ->first();

        $statusOptions = [
            1 => 'Driver started to reach Destination',
            2 => 'Driver Reached customer location',
            3 => 'Driver pick up customer from location',
            4 => 'Driver completed Ride',
            5 => 'cancel ride',

        ];

        return view('admin.booking_management.editpayment', compact('getRow'));
    }
    // public function update1(Request $request, $id)
    // {
    //     DB::beginTransaction();

    //     try {

    //         $bookingRow = DB::table('booking_management')->where('id', $id)->first();
    //         // 1. Update booking_management
    //         DB::table('booking_management')->where('id', $id)->update([
    //             'customer_name'  => $request->input('customer_name'),
    //             'phone'          => $request->input('phone'),
    //             'booking_status' => $request->input('booking_status'),

    //         ]);

    //         DB::table('driver_arrived')->updateOrInsert(
    //             ['booking_id' => $id, 'driver_id' => $bookingRow->driver_id],
    //             [
    //                 'total_km'          => $request->input('total_km'),
    //                 'start_km'          => $request->input('start_km'),
    //                 'end_km'            => $request->input('end_km'),
    //                 'driver_arrived_at' => $request->input('driver_arrived_at'),
    //             ]
    //         );

    //         // 2. Update or insert into otp_codes
    //         DB::table('otp_codes')->updateOrInsert(
    //             ['booking_id' => $id],
    //             [
    //                 'start_km' => $request->input('otp_start_km'),
    //                 'end_km'   => $request->input('otp_end_km'),
    //             ]
    //         );

    //         // 3. Update or insert into driver_arrived

    //         // 4. Update or insert into fare_summaries
    //         // Get values from request
    //         $startTime        = $request->input('start_time');
    //         $endTime          = $request->input('end_time');
    //         $totalKmTravelled = $request->input('total_km_travelled');
    //         $extraDiscount    = $request->input('extra_discountamount') ?? 0;
    //         $extraFare        = $request->input('extra_fair') ?? 0;
    //         $totalprice       = $request->input('total_price') ?? 0;
    //         $hillsFare        = $request->input('hills_fare') ?? 0;
    //         $hillsKm          = $request->input('hills_km') ?? 0;

    //         $totalPrice = $totalprice + $extraFare + $hillsFare - $extraDiscount;

    //         $totalPrice1 = max($totalPrice, 0);

    //         DB::table('fare_summaries')->updateOrInsert(
    //             ['booking_id' => $id],
    //             [
    //                 'start_time'           => $startTime,
    //                 'end_time'             => $endTime,
    //                 'total_km_travelled'   => $totalKmTravelled,
    //                 'extra_discountamount' => $extraDiscount,
    //                 'extra_fair'           => $extraFare,
    //                 'total_price'          => $totalPrice1,
    //                 'hills_fare'           => $hillsFare,
    //                 'hills_km'             => $hillsKm,
    //             ]
    //         );

    //         DB::commit();

    //         return redirect()->route('admin.BookingManagement-index')
    //             ->with('success', 'Booking updated successfully.');

    //     } catch (\Exception $e) {
    //         DB::rollback();
    //         return back()->with('error', 'Update failed: ' . $e->getMessage());
    //     }
    // }

    public function update1(Request $request, $id)
    {
        DB::beginTransaction();

        try {
            $bookingRow = DB::table('booking_management')->where('id', $id)->first();

            // 1. Update booking_management
            if ($request->hasAny(['customer_name', 'phone', 'booking_status'])) {
                $updateData = [];
                if ($request->filled('customer_name')) {
                    $updateData['customer_name'] = $request->input('customer_name');
                }
                if ($request->filled('phone')) {
                    $updateData['phone'] = $request->input('phone');
                }
                if ($request->filled('booking_status')) {
                    $updateData['booking_status'] = $request->input('booking_status');
                }

                if (! empty($updateData)) {
                    DB::table('booking_management')->where('id', $id)->update($updateData);
                }
            }

            // 2. Update or insert into driver_arrived
            if ($request->hasAny(['total_km', 'start_km', 'end_km', 'driver_departed_at', 'driver_arrived_at', 'otp_start_km']) && $bookingRow) {
                $arrivedData = [];

                // start_km with fallback to otp_start_km
                if ($request->filled('start_km')) {
                    $startKm                 = $request->input('start_km');
                    $arrivedData['start_km'] = $startKm;
                } elseif ($request->filled('otp_start_km')) {
                    $startKm                 = $request->input('otp_start_km');
                    $arrivedData['start_km'] = $startKm;
                } else {
                    $startKm = null;
                }

                // end_km with fallback to otp_start_km
                if ($request->filled('end_km')) {
                    $endKm                 = $request->input('end_km');
                    $arrivedData['end_km'] = $endKm;
                } elseif ($request->filled('otp_start_km')) {
                    $endKm                 = $request->input('otp_start_km');
                    $arrivedData['end_km'] = $endKm;
                } else {
                    $endKm = null;
                }

                // calculate total_km only if both start and end are numeric
                if (is_numeric($startKm) && is_numeric($endKm)) {
                    $arrivedData['total_km'] = $endKm - $startKm;
                }

                if ($request->filled('driver_departed_at')) {
                    $arrivedData['driver_departed_at'] = $request->input('driver_departed_at');
                } else {
                    $arrivedData['driver_departed_at'] = now();
                }

                if ($request->filled('start_time')) {
                    $arrivedData['driver_arrived_at'] = $request->input('start_time');
                } elseif ($request->filled('start_time')) {
                    // fallback: use driver_arrived_at if start_time not provided
                    $arrivedData['driver_arrived_at'] = $request->input('start_time');
                } else {
                    $arrivedData['driver_arrived_at'] = now();
                }

                if (! empty($arrivedData)) {
                    DB::table('driver_arrived')->updateOrInsert(
                        ['booking_id' => $id, 'driver_id' => $bookingRow->driver_id],
                        $arrivedData
                    );
                }
            }

            // 3. Update or insert into otp_codes
            if ($request->hasAny(['otp_start_km', 'otp_end_km'])) {
                $otpData = [];
                if ($request->filled('otp_start_km')) {
                    $otpData['start_km'] = $request->input('otp_start_km');
                }
                if ($request->filled('otp_end_km')) {
                    $otpData['end_km'] = $request->input('otp_end_km');
                }

                if (! empty($otpData)) {
                    DB::table('otp_codes')->updateOrInsert(
                        ['booking_id' => $id, 'driver_id' => $bookingRow->driver_id],
                        $otpData
                    );
                }
            }

            // 4. Update or insert into fare_summaries
            if (
                $request->hasAny([
                    'start_time', 'end_time', 'total_km_travelled',
                    'extra_discountamount', 'extra_fair', 'total_price',
                    'hills_fare', 'hills_km',
                ])
            ) {
                $startTime        = $request->filled('start_time') ? $request->input('start_time') : now();
                $endTime          = $request->filled('end_time') ? $request->input('end_time') : now();
                $totalKmTravelled = $request->filled('total_km_travelled') ? $request->input('total_km_travelled') : 0;
                $extraDiscount    = $request->filled('extra_discountamount') ? $request->input('extra_discountamount') : 0;
                $extraFare        = $request->filled('extra_fair') ? $request->input('extra_fair') : 0;
                $totalprice       = $request->filled('total_price') ? $request->input('total_price') : 0;
                $hillsFare        = $request->filled('hills_fare') ? $request->input('hills_fare') : 0;
                $hillsKm          = $request->filled('hills_km') ? $request->input('hills_km') : 0;

                $totalPrice  = $totalprice + $extraFare + $hillsFare - $extraDiscount;
                $totalPrice1 = max($totalPrice, 0);

                DB::table('fare_summaries')->updateOrInsert(
                    ['booking_id' => $id, 'driver_id' => $bookingRow->driver_id],
                    [
                        'start_time'           => $startTime,
                        'end_time'             => $endTime,
                        'total_km_travelled'   => $totalKmTravelled,
                        'extra_discountamount' => $extraDiscount,
                        'extra_fair'           => $extraFare,
                        'total_price'          => $totalPrice1,
                        'hills_fare'           => $hillsFare,
                        'hills_km'             => $hillsKm,
                        'driver_id'            => $bookingRow->driver_id,
                        'customer_name'        => $bookingRow->customer_name,
                        'phone'                => $bookingRow->phone,
                        // 'cartype_id'           => $bookingRow->cartype_id,
                        'pickup_location'      => $bookingRow->from_address,
                        'drop_location'        => $bookingRow->to_address,
                        'hills_km'             => $hillsKm,

                    ]
                );
            }
            DB::commit();

            if ($request->filled('summary_details') && $request->input('summary_details') == '1') {
                $booking     = DB::table('booking_management')->where('id', $id)->first();
                $fareSummary = DB::table('fare_summaries')->where('booking_id', $id)->first();
                $otpData     = DB::table('otp_codes')->where('booking_id', $id)->first();

                if ($booking && $fareSummary) {
                    $customerPhone = $booking->phone;
                    $driver        = DB::table('drivers')->where('id', $booking->driver_id)->first();
                    $driverPhone   = $driver->phone ?? null;

                    $message = "*Vaigai Namma Taxi Ride Summary*\n"
                        . "Customer: {$booking->customer_name}\n"
                        . "From: {$booking->from_address}\n"
                        . "To: {$booking->to_address}\n"
                        . "Trip Start KM: " . ($otpData->start_km ?? '-') . "\n"
                        . "Trip End KM: " . ($otpData->end_km ?? '-') . "\n"
                        . "Total KM Travelled: {$fareSummary->total_km_travelled} KM\n"
                        . "Extra Fare: ₹{$fareSummary->extra_fair}\n"
                        . "Discount: ₹{$fareSummary->extra_discountamount}\n"
                        . "Hills Fare: ₹{$fareSummary->hills_fare}\n"
                        . "Final Total: ₹{$fareSummary->total_price}\n\n"
                        . "Thank you for choosing VaigaiNamma Taxi!";

                    // Send to customer
                    if (! empty($customerPhone)) {
                        $this->sendWelcomeSms($customerPhone, 'text', $message);

                    }

                    // Send to driver
                    if (! empty($driverPhone)) {
                        $this->sendWelcomeSms($driverPhone, 'text', $message);

                    }
                }
            }

            return redirect()->route('admin.BookingManagement-index')
                ->with('success', 'Booking updated successfully.');

        } catch (\Exception $e) {
            DB::rollback();
            return back()->with('error', 'Update failed: ' . $e->getMessage());
        }
    }

    public function update(Request $request, $id)
    {
        try {

            DB::beginTransaction();

            $driver = DB::table('vehicle_management')->where('id', $id)->first();

            $updateData = [
                'carbrand_id'   => $request->car_brand,
                'car_model'     => $request->car_model,
                'cartype_id'    => $request->car_type,
                'fuel_type'     => $request->fuel_type,
                'seat_capacity' => $request->seat_capacity,
                'status'        => $request->status,
                'updated_at'    => now(),
            ];

            DB::table('vehicle_management')->where('id', $id)->update($updateData);

            DB::commit();

            return redirect()->route('admin.VehicleManagement-index')
                ->with('success', 'Vehicle updated successfully');
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()
                ->with('error', 'Error updating driver: ' . $e->getMessage())
                ->withInput();
        }
    }

    public function show($id)
    {
        $getRow     = DB::table('booking_management')->where('id', $id)->first();
        $get_driver = DB::table('driver_management')->where('id', $getRow->driver_id)->first();

        return view('admin.booking_management.view', compact('getRow', 'get_driver'));

    }

    public function destroy($id)
    {
        try {
            DB::beginTransaction();

            $driver = DB::table('vehicle_management')->where('id', $id)->first();
            if (! $driver) {
                return response()->json(['status' => 404, 'message' => 'Driver not found']);
            }

            DB::table('vehicle_management')->where('id', $id)->delete();

            DB::commit();
            return response()->json(['status' => 200, 'message' => 'Deleted successfully']);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['status' => 500, 'message' => 'Error: ' . $e->getMessage()]);
        }
    }

    public function updateStatus(Request $request)
    {
        $request->validate([
            'id'     => 'required|integer|exists:vehicle_management,id',
            'status' => 'required|boolean',
        ]);

        DB::table('vehicle_management')
            ->where('id', $request->id)
            ->update(['status' => $request->status, 'updated_at' => now()]);

        return response()->json(['message' => 'Status updated successfully']);
    }

    // public function getNearbyDrivers(Request $request)
    // {
    //     $request->validate([
    //         'latitude'  => 'required|numeric',
    //         'longitude' => 'required|numeric',
    //         'radius_km' => 'nullable|numeric',
    //     ]);

    //     $latitude  = $request->latitude;
    //     $longitude = $request->longitude;
    //     $radius    = $request->radius_km ?? 3; // Default to 3 km if not provided

    //     $drivers = DB::table('driver_management')
    //         ->where('online_status', '=', 'online')
    //         ->where('trip_status', 0)
    //         ->select('id', 'driver_name', 'latitude', 'longitude')
    //         ->selectRaw('(6371 * acos(cos(radians(?)) * cos(radians(latitude)) * cos(radians(longitude) - radians(?)) + sin(radians(?)) * sin(radians(latitude)))) AS distance', [$latitude, $longitude, $latitude])
    //         ->having('distance', '<=', $radius)
    //         ->get();

    //     return response()->json($drivers);
    // }

    public function getNearbyDrivers(Request $request)
    {
        // Step 1: Validate incoming request
        $request->validate([
            'latitude'  => 'required|numeric',
            'longitude' => 'required|numeric',
            'radius_km' => 'nullable|numeric',
        ]);

        $latitude  = $request->latitude;
        $longitude = $request->longitude;
        $radius    = $request->radius_km ?? 3; // default to 3km

        // Step 2: Get all online & free drivers within the radius
        $drivers = DB::table('driver_management')
            ->where('online_status', 'online')
            ->where('trip_status', 0)
            ->whereNotNull('latitude')
            ->whereNotNull('longitude')
            ->select('id', 'driver_name', 'latitude', 'longitude')
            ->selectRaw('
            (6371 * acos(
                cos(radians(?)) * cos(radians(latitude)) *
                cos(radians(longitude) - radians(?)) +
                sin(radians(?)) * sin(radians(latitude))
            )) AS distance', [$latitude, $longitude, $latitude])
            ->having('distance', '<=', $radius)
            ->orderBy('distance')
            ->get();

        return response()->json($drivers);
    }

    public function getEstimatedAmountAndPackage(array $data): array
    {
        $setting = DB::table('settings')->where('id', 1)->first();
        $package = DB::table('packages as p')
            ->join('outstation_package as op', function ($join) use ($data) {
                $join->on('p.id', '=', 'op.package_id')
                    ->where('op.cartype_id', $data['cartype_id'])
                    ->where('op.inout_type', $data['traveltype_id']);
            })
            ->where('p.traveltype_id', $data['traveltype_id'])
            ->where('p.km', '<=', $data['estimated_km'])
            ->orderBy('p.km', 'desc')
            ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type', 'op.per_hours_ac_price', 'op.per_hours_price', 'op.below50kmhrcharge', 'op.below100kmhrcharge', 'op.above100kmhrcharge')
            ->first();

        if (! $package) {

            $package = DB::table('packages as p')
                ->join('outstation_package as op', function ($join) use ($data) {
                    $join->on('p.id', '=', 'op.package_id')
                        ->where('op.cartype_id', $data['cartype_id'])
                        ->where('op.inout_type', $data['traveltype_id']);
                })
                ->where('p.traveltype_id', $data['traveltype_id'])
                ->orderBy('p.km', 'asc')
                ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type', 'op.per_hours_ac_price', 'op.per_hours_price', 'op.below50kmhrcharge', 'op.below100kmhrcharge', 'op.above100kmhrcharge')
                ->first();

        }

        if (! $package) {
            return [];
        }

        $isMinutes = false;

        $rate             = $data['ac_type'] === 'AC' ? $package->ac_price : $package->nonac_price;
        $additionalKMrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
        $additionalhrrate = $data['ac_type'] === 'AC' ? $package->per_hours_ac_price : $package->per_hours_price;
        $includedKm       = $package->included_km;
        $includedHr       = $package->free_hours;
        $extraKm          = max(0, $data['estimated_km'] - $includedKm);
        $extrahrs         = 0;

        $baseFare      = $rate;
        $extraFare     = $additionalKMrate * $extraKm;
        $hrcharge      = 0;
        $extrahrcharge = 0;
        $perhrcharge   = 0;
        if ($data['estimated_time'] > $includedHr) {
            $extrahrs = max(0, $data['estimated_time'] - $includedHr);
            if ($data['traveltype_id'] == 2) {
                if ($data['estimated_km'] > 100) {
                    $perhrcharge = $package->above100kmhrcharge;
                } elseif ($data['estimated_km'] >= 51) {
                    $perhrcharge = $package->below100kmhrcharge;
                } else {
                    $perhrcharge = $package->below50kmhrcharge;
                }
            } else {
                $perhrcharge = $package->per_hours_price;
            }
            $extrahrcharge = $extrahrs * $perhrcharge;
        }
        $waitingcharge = 0;
        if ($package->local_type == 2) {
            $extrahrcharge        = 0;
            $isMinutes            = true;
            $allowedwaitingmin    = $data['estimated_km'] * $setting->waitingminperkm;
            $estimatedtime_to_min = $data['estimated_time'] * 60;
            if ($estimatedtime_to_min > $allowedwaitingmin) {
                $waitingcharge = max(0, $estimatedtime_to_min - $allowedwaitingmin) * $setting->waitingchargepermin;
            }
        }

        $totalCost = $baseFare + $extraFare + $hrcharge + $waitingcharge;

        return [
            'package_id'          => $package->package_id,
            'amount'              => $totalCost,
            'additional_kmrate'   => $additionalKMrate,
            'additionalperhrrate' => $perhrcharge,
            'totalKm'             => $data['estimated_km'],
            'baseKm'              => $includedKm,
            'extraKm'             => $extraKm,
            'totalTime'           => $data['estimated_time'],
            'freehours'           => $includedHr,
            'baseFare'            => $baseFare,
            'extraKmFare'         => $extraFare,
            'extraHourFare'       => $extrahrcharge,
            'waitingcharge'       => $waitingcharge,
            'is_minutes'          => $isMinutes ? 1 : 0,
        ];
    }
    // For sending WhatsApp API

    public function sendOtp(Request $request)
    {
        $booking = DB::table('booking_management as bm')
            ->join('driver_management as dm', 'bm.driver_id', '=', 'dm.id')
            ->join('otp_codes as oc', 'bm.id', '=', 'oc.booking_id')
            ->where('bm.id', $request->booking_id)
            ->select('bm.phone', 'oc.otp')
            ->first();

        if (! $booking) {
            return response()->json(['status' => false, 'message' => 'Booking or OTP not found']);
        }

        $message = "Your ride OTP is: {$booking->otp}";

        // ✅ Send the message
        $x = $this->sendWelcomeSms($booking->phone, 'text', $message);

        // ✅ Optional: log or inspect $x if needed

        return response()->json(['status' => true, 'message' => 'OTP sent successfully']);
    }
    public function cancelRide1(Request $request)
    {
        $request->validate([
            'booking_id'    => 'required|exists:booking_management,id',
            'cancel_reason' => 'required|string|max:255',
        ]);

        DB::table('booking_management')
            ->where('id', $request->booking_id)
            ->update([
                'booking_status' => 5,
                'cancel_reason'  => $request->cancel_reason,
                'updated_at'     => now(),
            ]);

        return response()->json([
            'status'  => true,
            'message' => 'Ride has been cancelled successfully.',
        ]);
    }
    public function cancelRide(Request $request)
    {
        $request->validate([
            'booking_id'    => 'required|exists:booking_management,id',
            'cancel_reason' => 'required|string|max:255',
        ]);

        $booking = DB::table('booking_management')->where('id', $request->booking_id)->first();

        if (! $booking) {
            return response()->json([
                'status'  => false,
                'message' => 'Booking not found.',
            ], 404);
        }

        // Prevent double cancellation
        if ($booking->booking_status == 5) {
            return response()->json([
                'status'  => false,
                'message' => 'This ride is already cancelled.',
            ], 400);
        }

        // Update booking as cancelled
        DB::table('booking_management')
            ->where('id', $request->booking_id)
            ->update([
                'booking_status' => 5, // assuming 5 = Cancelled
                'cancel_reason'  => $request->cancel_reason,
                'updated_at'     => now(),
            ]);

        // ✅ Send Firebase notification to driver (optional)
        $driver = DB::table('driver_management')->where('id', $booking->driver_id)->first();

        if ($driver && $driver->firebase_token) {
            try {
                $this->sendPushNotification($driver->firebase_token, [
                    'title' => 'Ride Cancelled',
                    'body'  => 'Your assigned ride has been cancelled by the admin.',
                    'data'  => [
                        'booking_id' => $request->booking_id,
                        'type'       => 'ride_cancelled',
                    ],
                ]);
            } catch (\Exception $e) {
                Log::error("FCM Error during cancelRide: " . $e->getMessage());
            }
        }

        return response()->json([
            'status'  => true,
            'message' => 'Ride has been cancelled successfully.',
        ]);
    }

    public function getSingleRow(Request $request)
    {
        $bookingId = $request->booking_id;

        $row = DB::table('booking_management')
            ->leftJoin('driver_management', 'booking_management.driver_id', '=', 'driver_management.id')
            ->leftJoin('otp_codes', 'booking_management.id', '=', 'otp_codes.booking_id')
            ->select(
                'booking_management.id',
                'driver_management.driver_name as DriverName',
                'driver_management.online_status',
                'otp_codes.otp'
            )
            ->where('booking_management.id', $bookingId)
            ->first();

        if ($row) {
            return response()->json(['status' => true, 'data' => $row]);
        } else {
            return response()->json(['status' => false, 'message' => 'Booking not found.']);
        }
    }

    public function getOnlineDrivers()
    {
        $drivers = DB::table('driver_management')
            ->where('online_status', true)
            ->where('trip_status', 0)
            ->select('id', 'driver_name', 'latitude', 'longitude')
            ->get();

        return response()->json($drivers);
    }

    // public function getEstimatedAmountAndPackage1(array $data): array
    // {
    //     $setting = DB::table('settings')->where('id', 1)->first();

    //     $package = DB::table('packages as p')
    //         ->join('outstation_package as op', function ($join) use ($data) {
    //             $join->on('p.id', '=', 'op.package_id')
    //                 ->where('op.cartype_id', $data['cartype_id'])
    //                 ->where('op.inout_type', $data['traveltype_id']);
    //         })
    //         ->where('p.traveltype_id', $data['traveltype_id'])
    //         ->where('p.km', '<=', $data['estimated_km'])
    //         ->orderBy('p.km', 'desc')
    //         ->select(
    //             'p.id as package_id',
    //             'p.km as included_km',
    //             'p.free_hours as free_hours',
    //             'op.ac_price',
    //             'op.additionalperkm_ac_price',
    //             'op.additionalperkm_nonac_price',
    //             'op.nonac_price',
    //             'op.local_type'
    //         )
    //         ->first();

    //     if (! $package) {
    //         $package = DB::table('packages as p')
    //             ->join('outstation_package as op', function ($join) use ($data) {
    //                 $join->on('p.id', '=', 'op.package_id')
    //                     ->where('op.cartype_id', $data['cartype_id'])
    //                     ->where('op.inout_type', $data['traveltype_id']);
    //             })
    //             ->where('p.traveltype_id', $data['traveltype_id'])
    //             ->orderBy('p.km', 'asc')
    //             ->select(
    //                 'p.id as package_id',
    //                 'p.km as included_km',
    //                 'p.free_hours as free_hours',
    //                 'op.ac_price',
    //                 'op.additionalperkm_ac_price',
    //                 'op.additionalperkm_nonac_price',
    //                 'op.nonac_price',
    //                 'op.local_type'
    //             )
    //             ->first();
    //     }

    //     // ✅ Custom rule for short local ride < 10 km
    //     if ($package->local_type == 2 && $data['estimated_km'] < 10) {
    //         $baseFare     = 100; // ₹100 up to 3km
    //         $additionalKm = max(0, $data['estimated_km'] - 3);

    //         $additionalRate = $data['ac_type'] === 'AC' ? 22 : 20;
    //         $extraFare      = $additionalKm * $additionalRate;

    //                                                       // estimated_time is considered in minutes directly
    //         $waitingcharge = $data['estimated_time'] * 2; // ₹2 per minute

    //         $totalCost = $baseFare + $extraFare + $waitingcharge;

    //         return [
    //             'package_id'          => $package->package_id,
    //             'amount'              => $totalCost,
    //             'additional_kmrate'   => $additionalRate,
    //             'additionalperhrrate' => 0,
    //             'extraKm'             => $additionalKm,
    //             'waitingcharge'       => $waitingcharge,
    //             'baseFare'           => $baseFare,
    //             'extraFare'           => $extraFare,
    //             'hrcharge'            => 0,
    //         ];
    //     }

    //     // ✅ Normal estimation logic (as in your original code)
    //     $rate             = $data['ac_type'] === 'AC' ? $package->ac_price : $package->nonac_price;
    //     $additionalKMrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
    //     $additionalhrrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
    //     $includedKm       = $package->included_km;
    //     $extraKm          = max(0, $data['estimated_km'] - $includedKm);

    //     $baseFare  = $rate;
    //     $extraFare = $additionalKMrate * $extraKm;
    //     $hrcharge  = 0;

    //     if ($data['estimated_time'] > $package->free_hours) {
    //         $extrahrs = max(0, $data['estimated_time'] - $package->free_hours);
    //         if ($data['traveltype_id'] == 2) {
    //             if ($data['estimated_km'] > 100) {
    //                 $hrcharge = $package->above100kmhrcharge ?? 0;
    //             } elseif ($data['estimated_km'] >= 51) {
    //                 $hrcharge = $package->below100kmhrcharge ?? 0;
    //             } else {
    //                 $hrcharge = $package->below50kmhrcharge ?? 0;
    //             }
    //         } else {
    //             $hrcharge = $package->per_hours_price ?? 0;
    //         }
    //     }

    //     $waitingcharge = 0;
    //     if ($package->local_type == 2) {
    //         $allowedwaitingmin    = $includedKm * $setting->waitingminperkm;
    //         $estimatedtime_to_min = $data['estimated_time'] * 60;
    //         if ($estimatedtime_to_min > $allowedwaitingmin) {
    //             $waitingcharge = max(0, $estimatedtime_to_min - $allowedwaitingmin) * $setting->waitingchargepermin;
    //         }
    //     }

    //     $totalCost = $baseFare + $extraFare + $hrcharge + $waitingcharge;

    //     return [
    //         'package_id'          => $package->package_id,
    //         'amount'              => $totalCost,
    //         'additional_kmrate'   => $additionalKMrate,
    //         'additionalperhrrate' => $additionalhrrate,
    //         'extraKm'             => $extraKm,
    //         'waitingcharge'       => $waitingcharge,
    //         'baseFare'           => $baseFare,
    //         'extraFare'           => $extraFare,
    //         'hrcharge'            => $hrcharge,
    //         'is_minutes'          => 0,
    //     ];
    // }

}
