<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\ACommonController;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class DriverTripsManagementController extends ACommonController
{
    public function dataindex(Request $request)
    {
        $recordsTotal    = 0;
        $recordsFiltered = 0;
        $draw            = $request->input('draw', '1');
        $start           = $request->input('start', '0');
        $length          = $request->input('length', '0');
        $columnsall      = $request->input('columns', []);
        $orderall        = $request->input('order', []);
        $dataResult      = [];
        $recordQry       = DB::table('booking_management')
            ->leftJoin('driver_management', 'booking_management.driver_id', '=', 'driver_management.id')
            ->leftJoin('otp_codes', 'booking_management.id', '=', 'otp_codes.booking_id')
            ->select(
                'booking_management.*',
                'driver_management.driver_name as DriverName',
                'driver_management.driver_code as DriverCode',
            )
            ->where('booking_management.deleted_status', 0)
            ->whereNotIn('booking_management.booking_status', [4, 5]);
        $searchValue = $request->input('search.value');
        if (! empty($searchValue)) {
            $recordQry->where('driver_management.driver_name', 'like', '%' . $searchValue . '%');
        }
        if ($orderall) {
            $ordtyp = $orderall[0]['dir'];
            if ($orderall[0]['column'] > 0) {
                $colsynt   = $orderall[0]['column'];
                $dbcolname = $columnsall[$colsynt]['data'];
                $recordQry->orderBy($dbcolname, $ordtyp);
            } else {
                $recordQry->orderBy('id', $ordtyp);
            }
        }
        $recordAllQry    = $recordQry;
        $recordsTotal    = $recordAllQry->count();
        $recordList      = $recordQry->orderBy('id', 'desc')->offset($start)->limit($length)->get();
        $recordsFiltered = $recordList->count();
        $dataResult      = $recordList;
        return response()->json(["draw" => $draw, "recordsTotal" => $recordsTotal, "recordsFiltered" => $recordsTotal, "data" => $dataResult]);
    }
    public function index()
    {
        return view('admin.driver_trips.list');
    }
    public function edit1(Request $request, $id)
    {
        $getRow = DB::table('booking_management as bm')
            ->leftJoin('driver_management as dm', 'bm.driver_id', '=', 'dm.id')
            ->leftJoin('otp_codes as otp', 'otp.booking_id', '=', 'bm.id')
            ->leftJoin('outstation_package as op', 'op.cartype_id', '=', 'bm.cartype_id')
            ->leftJoin('driver_arrived as da', 'da.booking_id', '=', 'bm.id')
            ->leftJoin('fare_summaries as fs', 'fs.booking_id', '=', 'bm.id')
            ->where('bm.id', $id)
            ->select(
                'bm.*',
                'dm.driver_name',
                'otp.start_km as otp_start_km',
                'otp.end_km as otp_end_km',
                'otp.start_date as start_date',
                'otp.end_date as end_date',
                'otp.total_km as total_km',
                'op.hillsac_price',
                'op.hillsnonac_price',
                // 'da.total_km',
                'da.start_km',
                'da.end_km',
                'da.driver_arrived_at',
                'da.driver_departed_at',
                'fs.start_time',
                'fs.end_time',
                'fs.total_km_travelled',
                'fs.total_price',
                'fs.extra_discountamount',
                'fs.extra_fair',
                'fs.hills_fare',
                'fs.hills_km',
            )
            ->first();
        $statusOptions = [
            1 => 'Driver started to reach Destination',
            2 => 'Driver Reached customer location',
            3 => 'Driver pick up customer from location',
            4 => 'Driver completed Ride',
            5 => 'cancel ride',
        ];
        return view('admin.driver_trips.editpayment', compact('getRow'));
    }
    public function update1(Request $request, $id)
    {
        DB::beginTransaction();
        try {
            $bookingRow = DB::table('booking_management')->where('id', $id)->where('deleted_status', 0)->first();
            if (! $bookingRow) {
                throw new \Exception("Booking not found.");
            }
            // 1. Update basic booking fields
            if ($request->hasAny(['customer_name', 'phone', 'booking_status', 'extra_discountamount', 'extra_fair'])) {
                $updateData = $request->only(['customer_name', 'phone', 'booking_status', 'extra_discountamount', 'extra_fair']);
                DB::table('booking_management')->where('id', $id)->where('deleted_status', 0)->update(array_filter($updateData));
            }
            // 2. Update driver arrival (departure/start_km and arrival time)
            $arrivedUpdated = false;
            if ($request->hasAny(['total_km', 'start_km', 'driver_departed_at', 'driver_arrived_at', 'otp_start_km'])) {
                $dep_startKm = $request->filled('start_km') ? $request->start_km : ($request->otp_start_km ?? null);
                $dep_endKm   = $request->otp_start_km ?? null;
                $arrivedData = [
                    'start_km' => $dep_startKm,
                    'end_km'   => $dep_endKm,
                    'total_km' => is_numeric($dep_startKm) && is_numeric($dep_endKm) ? $dep_endKm - $dep_startKm : null,
                ];
                if ($request->filled('driver_departed_at')) {
                    $arrivedData['driver_departed_at'] = \Carbon\Carbon::parse($request->driver_departed_at)->format('Y-m-d H:i:s');
                }
                if ($request->filled('start_time')) {
                    $arrivedData['driver_arrived_at'] = \Carbon\Carbon::parse($request->start_time)->format('Y-m-d H:i:s');
                }
                if (! empty(array_filter($arrivedData))) {
                    DB::table('driver_arrived')->updateOrInsert(
                        ['booking_id' => $id, 'driver_id' => $bookingRow->driver_id],
                        array_filter($arrivedData)
                    );
                    DB::table('driver_management')
                        ->where('id', $bookingRow->driver_id)
                        ->update(['trip_status' => 1]);
                    $arrivedUpdated = true;
                }
            }
            // 3. Update OTP km and times
            $otpUpdated   = false;
            $trip_startKm = $trip_endKm = null;
            if ($request->hasAny(['otp_start_km', 'otp_end_km'])) {
                $trip_startKm = $request->otp_start_km ?? null;
                $trip_endKm   = $request->otp_end_km ?? null;
                $trip_totalKm = $trip_endKm - $trip_startKm;
                $otpData      = [
                    'start_km'   => $trip_startKm,
                    'end_km'     => $trip_endKm,
                    'start_date' => $request->start_date ?? null,
                    'end_date'   => $request->end_date ?? null,
                    'total_km'   => $trip_totalKm ?? 0,
                ];
                DB::table('otp_codes')->updateOrInsert(
                    ['booking_id' => $id, 'driver_id' => $bookingRow->driver_id],
                    array_filter($otpData)
                );
                $otpUpdated = true;
            }
            // 4. Update booking status again if needed
            if ($request->filled('booking_status')) {
                DB::table('booking_management')->where('id', $id)->where('deleted_status', 0)->update([
                    'booking_status' => $request->input('booking_status'),
                ]);
            }
            // 5. Only call fare calculation if ALL required data was updated
            if ($arrivedUpdated && $otpUpdated && $request->filled('start_date') && $request->filled('end_date')) {
                $bookingRow  = DB::table('booking_management')->where('id', $id)->where('deleted_status', 0)->first();
                $fareDetails = $this->getEndrideAmountAndNewPackage($id);
                if ($fareDetails && is_array($fareDetails)) {
                    $startTime = \Carbon\Carbon::parse($request->start_date);
                    $endTime   = \Carbon\Carbon::parse($request->end_date);
                    // $durationMinutes = $endTime->diffInMinutes($startTime);
                    $durationSeconds   = $endTime->diffInSeconds($startTime);
                    $durationMinutes   = number_format($durationSeconds / 60, 2);
                    $durationHr        = $durationMinutes / 60;
                    $durationFormatted = $endTime->diff($startTime)->format('%H:%I:%S');
                    $result            = DB::table('fare_summaries')->updateOrInsert(
                        ['booking_id' => $id],
                        [
                            'driver_id'            => $bookingRow->driver_id,
                            'customer_name'        => $bookingRow->customer_name,
                            'phone'                => $bookingRow->phone,
                            'pickup_location'      => $bookingRow->from_address,
                            'drop_location'        => $bookingRow->to_address,
                            'total_km_travelled'   => $trip_totalKm,
                            'package_km'           => $fareDetails['package_km'] ?? 0,
                            'extra_km_charged'     => $fareDetails['extraKm'] ?? 0,
                            'base_fare'            => $fareDetails['baseFare'] ?? 0,
                            'per_km_charge'        => $fareDetails['additional_kmrate'] ?? 0,
                            'distance_fare'        => $fareDetails['extraFare'] ?? 0,
                            'hr_fare'              => $fareDetails['additionalperhrrate'] ?? 0,
                            'extraHourFare'        => $fareDetails['extraHourFare'] ?? 0,
                            'waiting_charge'       => $fareDetails['waitingcharge'] ?? 0,
                            'extra_fair'           => $request->input('extra_fair') ?? 0,
                            'extra_discountamount' => $request->input('extra_discountamount') ?? 0,
                            'hills_fare'           => $request->input('hills_fare') ?? 0,
                            'hills_km'             => $request->input('hills_km') ?? 0,
                            'total_price'          => $fareDetails['amount'] ?? 0,
                            'start_time'           => $startTime->format('H:i:s'),
                            'end_time'             => $endTime->format('H:i:s'),
                            'travel_minutes'       => $this->formatMinutesToHours($durationMinutes),
                            'end_date'             => now()->format('Y-m-d'),
                        ]
                    );
                    // Reset trip status after ride ends
                    DB::table('driver_management')->where('id', $bookingRow->driver_id)->update(['trip_status' => 0]);
                    // Update driver trip summary
                    $this->updateDriverTripSummary($bookingRow->driver_id, now()->format('Y-m-d'));
                }
            }
            DB::commit();
            if ($request->filled('summary_details') && $request->input('summary_details') == '1') {
                $bookingId   = $id;
                $booking     = DB::table('booking_management')->where('id', $bookingId)->where('deleted_status', 0)->first();
                $fareSummary = DB::table('fare_summaries')->where('booking_id', $bookingId)->first();
                $otp         = DB::table('otp_codes')->where('booking_id', $bookingId)->first();
                if ($booking && $fareSummary) {
                    $customerPhone = $booking->phone;
                    $driver        = DB::table('driver_management')->where('id', $booking->driver_id)->first();
                    $driverPhone   = $driver->user_name ?? null;
                    $message       = "*Vaigai Namma Taxi Ride Summary*\n"
                        . "Customer: {$booking->customer_name}\n"
                        . "From: {$booking->from_address}\n"
                        . "To: {$booking->to_address}\n"
                        . "Trip Start KM: " . ($otp->start_km ?? '-') . "\n"
                        . "Trip End KM: " . ($otp->end_km ?? '-') . "\n"
                        . "Total KM Travelled: {$fareSummary->total_km_travelled} KM\n"
                        . "Travel Time: {$fareSummary->travel_minutes}\n"
                        . "Extra Fare: ₹{$fareSummary->extra_fair}\n"
                        . "Discount: ₹{$fareSummary->extra_discountamount}\n"
                        . "Hills Fare: ₹{$fareSummary->hills_fare}\n"
                        . "Final Total: ₹{$fareSummary->total_price}\n\n"
                        . "Thank you for choosing VaigaiNamma Taxi!";
                    if (! empty($customerPhone)) {
                        $this->sendWelcomeSms($customerPhone, 'text', $message);
                    }
                    if (! empty($driverPhone)) {
                        $this->sendWelcomeSms($driverPhone, 'text', $message);
                    }
                }

            }
            return redirect()->route('admin.DriverTripsManagement-index')->with('success', 'Booking updated and fare calculated.');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Update1 Error: ' . $e->getMessage());
            return back()->with('error', 'Update failed: ' . $e->getMessage());
        }
    }
    public function calculateFare($bookingId, $driverId)
    {
        $otp     = DB::table('otp_codes')->where('booking_id', $bookingId)->first();
        $booking = DB::table('booking_management')
            ->select('id', 'cartype_id', 'ac_type', 'traveltype_id', 'driver_id', 'package_id', 'phone', 'customer_name')
            ->where('id', $bookingId)
            ->where('deleted_status', 0)
            ->first();
        if (! $otp || ! $booking) {
            throw new \Exception('Booking or OTP not found.');
        }
        $traveledKm    = round($otp->end_km - $otp->start_km, 2);
        $cartype_id    = $booking->cartype_id;
        $traveltype_id = $booking->traveltype_id;
        $setting       = DB::table('settings')->where('id', 1)->first();
        $package       = DB::table('packages as p')
            ->join('outstation_package as op', function ($join) use ($cartype_id, $traveltype_id) {
                $join->on('p.id', '=', 'op.package_id')
                    ->where('op.cartype_id', $cartype_id)
                    ->where('op.inout_type', $traveltype_id);
            })
            ->where('p.traveltype_id', $traveltype_id)
            ->orderBy('p.km', 'desc')
            ->first();
        if (! $package) {
            throw new \Exception('No package found.');
        }
        DB::table('booking_management')->where('id', $bookingId)->where('deleted_status', 0)->update(['package_id' => $package->package_id]);
        $startTime             = Carbon::parse($otp->created_at);
        $endTime               = Carbon::parse($otp->updated_at);
        $durationSeconds       = $endTime->diffInSeconds($startTime);
        $travelled_time_in_min = number_format($durationSeconds / 60, 2);
        $travelled_time_in_hr  = $travelled_time_in_min / 60;
        $rate                  = $booking->ac_type === 'AC' ? $package->ac_price : $package->nonac_price;
        $additionalKMrate      = $booking->ac_type === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
        $includedKm            = $package->km;
        $includedHr            = $package->free_hours;
        $extraKm               = max(0, $traveledKm - $includedKm);
        $extraFare             = $additionalKMrate * $extraKm;
        $extrahrs              = max(0, $travelled_time_in_hr - $includedHr);
        $perhrcharge           = $package->per_hours_price;
        $extrahrcharge         = $extrahrs * $perhrcharge;
        $totalCost             = $rate + $extraFare + $extrahrcharge;
        return [
            'totalKm'        => $traveledKm,
            'baseKm'         => $includedKm,
            'extraKm'        => $extraKm,
            'baseFare'       => $rate,
            'extraKmFare'    => $extraFare,
            'extraHourFare'  => $extrahrcharge,
            'total_price'    => $totalCost,
            'start_time'     => $startTime->format('H:i:s'),
            'end_time'       => $endTime->format('H:i:s'),
            'travel_minutes' => $this->formatMinutesToHours($travelled_time_in_min),
        ];
    }
}
