<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\ACommonController;
use App\Traits\ApiResponseTrait;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class DriverManagementController extends ACommonController
{
    use ApiResponseTrait;

    public function dataindex(Request $request)
    {
        $recordsTotal    = 0;
        $recordsFiltered = 0;
        $draw            = $request->input('draw', '1');
        $start           = $request->input('start', '0');
        $length          = $request->input('length', '0');
        $columnsall      = $request->input('columns', []);
        $orderall        = $request->input('order', []);
        $dataResult      = [];
        $recordQry       = DB::table('driver_management as d')
            ->where('d.deleted_status', 0)
            ->select(
                'd.*',
                DB::raw('IF(d.trip_status = 1, 1, 0) as trip_status'),
                DB::raw('IF(d.online_status = "online", "online", "offline") as online_status')
            )
            ->groupBy('d.id');

        $searchValue = $request->input('search.value');

        if (! empty($searchValue)) {

            $vehicleIds = DB::table('vehicle_management')
                ->where('car_model', 'like', '%' . $searchValue . '%')
                ->pluck('id');

            $recordQry->where(function ($query) use ($searchValue, $vehicleIds) {
                $query->orWhere('driver_management.driver_code', 'like', '%' . $searchValue . '%')
                    ->orWhere('driver_management.driver_name', 'like', '%' . $searchValue . '%')
                    ->orWhere('driver_management.online_status', 'like', '%' . $searchValue . '%')
                    ->orWhere('driver_management.vehicle_number', 'like', '%' . $searchValue . '%')
                    ->orWhere('driver_management.user_name', $searchValue)
                    ->orWhereIn('vehicle_management.car_model', $vehicleIds);
            });
        }

        if ($orderall) {
            $ordtyp = $orderall[0]['dir'];
            if ($orderall[0]['column'] > 0) {
                $colsynt   = $orderall[0]['column'];
                $dbcolname = $columnsall[$colsynt]['data'];
                $recordQry->orderBy($dbcolname, $ordtyp);

            } else {
                $recordQry->orderBy('online_status', 'asc');
                $recordQry->orderBy('id', $ordtyp);
            }
        }

        $recordAllQry = $recordQry;
        $recordsTotal = $recordAllQry->count();
        $recordQry->orderBy('online_status', 'desc');
        $recordList = $recordQry->orderBy('id', 'desc')
            ->offset($start)->limit($length)->get();
        $recordsFiltered = $recordList->count();
        $dataResult      = $recordList;

        return response()->json(["draw" => $draw, "recordsTotal" => $recordsTotal, "recordsFiltered" => $recordsTotal, "data" => $dataResult]);
    }

    public function index()
    {
        return view('admin.driver_management.list');
    }

    public function create()
    {
        $get_vehiclename = DB::table('vehicle_management')->get();
        return view('admin.driver_management.add', compact('get_vehiclename'));
    }

    public function store(Request $request)
    {

        // Verify document titles and files count match
        if (count($request->document_titles) !== count($request->documents)) {
            return redirect()->back()
                ->withErrors(['documents' => 'Each document must have a title'])
                ->withInput();
        }

        try {
            DB::beginTransaction();

            // Fetch the latest driver code
            $latestDriver = DB::table('driver_management')
                ->where('deleted_status', 0)
                ->orderByDesc('id')
                ->first();

            if ($latestDriver && $latestDriver->driver_code) {
                $number    = (int) str_replace('D', '', $latestDriver->driver_code);
                $newNumber = $number + 1;
            } else {
                $newNumber = 1;
            }

            // Format the new driver code like D0001
            $driverCode = 'D' . str_pad($newNumber, 4, '0', STR_PAD_LEFT);

            // Handle photo upload
            $photoPath = $request->file('photo')->store('public/drivers/photos');
            $photoName = basename($photoPath);

            // Insert driver data
            $driverId = DB::table('driver_management')->insertGetId([
                'driver_code'    => $driverCode,
                'driver_name'    => $request->driver_name,
                'photo'          => $photoName,
                'vehicle_id'     => $request->vehicle_name,
                'vehicle_number' => $request->vehicle_number,
                'ac_type'        => implode(',', $request->vehicle_ac_types),
                'user_name'      => $request->user_name,
                'password'       => Hash::make($request->password),
                'created_at'     => now(),
                'updated_at'     => now(),
                'deleted_status' => 0,
                'status'         => $request->status,
            ]);

            // Handle documents
            foreach ($request->document_titles as $index => $title) {
                $document = $request->documents[$index];
                $docPath  = $document->store('public/drivers/documents');
                $docName  = basename($docPath);

                DB::table('driver_documents')->insert([
                    'driver_id'      => $driverId,
                    'document_title' => $title,
                    'document'       => $docName,
                    'created_at'     => now(),
                    'updated_at'     => now(),
                ]);
            }

            DB::commit();

            return redirect()->route('admin.DriverManagement-index')
                ->with('success', 'Driver created successfully');

        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()
                ->with('error', 'Error creating driver: ' . $e->getMessage())
                ->withInput();
        }
    }

    public function edit(Request $request, $id)
    {
        $getRow          = DB::table('driver_management')->where('deleted_status', '0')->where('id', $id)->first();
        $documents       = DB::table('driver_documents')->where('driver_id', $getRow->id)->get();
        $get_vehiclename = DB::table('vehicle_management')->get();

        return view('admin.driver_management.edit', compact('getRow', 'documents', 'get_vehiclename'));
    }

    public function destroyDocument($documentId)
    {
        try {
            $document = DB::table('driver_documents')->find($documentId);

            if (! $document) {
                return response()->json(['error' => 'Document not found'], 404);
            }

            // Delete file from storage
            Storage::delete('public/drivers/documents/' . $document->document);

            // Delete record from database
            DB::table('driver_documents')->where('id', $documentId)->delete();

            return response()->json(['message' => 'Document deleted successfully']);

        } catch (\Exception $e) {
            return response()->json(['error' => 'Error deleting document: ' . $e->getMessage()], 500);
        }
    }

    public function update(Request $request, $id)
    {

        try {

            DB::beginTransaction();

            // === Update driver details ===
            $driver = DB::table('driver_management')->where('id', $id)->first();

            $updateData = [
                'driver_name'    => $request->driver_name,
                'vehicle_id'     => $request->vehicle_name,
                'vehicle_number' => $request->vehicle_number,
                'user_name'      => $request->user_name,
                'status'         => $request->status,
                'updated_at'     => now(),
            ];

            if ($request->has('password') && $request->password != "") {
                $updateData['password'] = Hash::make($request->password);
            }
            // dd($updateData);

            if ($request->hasFile('photo')) {
                // Delete old photo if exists
                if (! empty($driver->photo)) {
                    Storage::delete('public/drivers/photos/' . $driver->photo);
                }

                // Store new photo
                $photoPath           = $request->file('photo')->store('public/drivers/photos');
                $updateData['photo'] = basename($photoPath);
            } else {
                // Keep the existing photo if no new one is uploaded
                $updateData['photo'] = $driver->photo;
            }

            DB::table('driver_management')->where('id', $id)->update($updateData);

            // === Update existing documents ===
            if (! empty($request['existing_documents'])) {
                foreach ($request['existing_documents'] as $docData) {
                    $updateDoc = [
                        'document_title' => $docData['title'],
                        'updated_at'     => now(),
                    ];

                    if ($request->hasFile("existing_documents.{$docData['id']}.file")) {
                        $uploadedFile = $request->file("existing_documents")[$docData['id']]['file'];

                        $oldDoc = DB::table('driver_documents')->where('id', $docData['id'])->first();
                        if ($oldDoc && $oldDoc->document) {
                            Storage::delete('public/drivers/documents/' . $oldDoc->document);
                        }

                        $docPath               = $uploadedFile->store('public/drivers/documents');
                        $updateDoc['document'] = basename($docPath);
                    }

                    DB::table('driver_documents')
                        ->where('id', $docData['id'])
                        ->update($updateDoc);
                }
            }

            // === Add new documents ===
            if (! empty($request['document_titles']) && ! empty($request['documents'])) {
                foreach ($request['document_titles'] as $index => $title) {
                    if (! isset($request['documents'][$index])) {
                        continue;
                    }

                    $document = $request['documents'][$index];
                    $docPath  = $document->store('public/drivers/documents');

                    DB::table('driver_documents')->insert([
                        'driver_id'      => $id,
                        'document_title' => $title,
                        'document'       => basename($docPath),
                        'created_at'     => now(),
                        'updated_at'     => now(),
                    ]);
                }
            }

            DB::commit();

            return redirect()->route('admin.DriverManagement-index')
                ->with('success', 'Driver updated successfully');
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()
                ->with('error', 'Error updating driver: ' . $e->getMessage())
                ->withInput();
        }
    }

    public function show($id)
    {

        $getRow          = DB::table('driver_management')->where('deleted_status', '0')->where('id', $id)->first();
        $documents       = DB::table('driver_documents')->where('driver_id', $getRow->id)->get();
        $get_vehiclename = DB::table('vehicle_management')->where('id', $getRow->vehicle_id)->first();

        // dd($get_vehiclename);

        return view('admin.driver_management.view', compact('getRow', 'documents', 'get_vehiclename'));

    }

    public function destroy($id)
    {
        try {
            DB::beginTransaction();

            // Fetch driver to access file names
            $driver = DB::table('driver_management')->where('id', $id)->first();
            if (! $driver) {
                return response()->json(['status' => 404, 'message' => 'Driver not found']);
            }

            // Delete driver photo from storage
            if ($driver->photo) {
                Storage::delete('public/drivers/photos/' . $driver->photo);
            }

            // Get and delete driver documents from storage
            $documents = DB::table('driver_documents')->where('driver_id', $id)->get();
            foreach ($documents as $doc) {
                if ($doc->document) {
                    Storage::delete('public/drivers/documents/' . $doc->document);
                }
            }

            // Delete documents from DB
            DB::table('driver_documents')->where('driver_id', $id)->delete();

            // Delete driver
            DB::table('driver_management')->where('id', $id)->delete();

            DB::commit();
            return response()->json(['status' => 200, 'message' => 'Deleted successfully']);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['status' => 500, 'message' => 'Error: ' . $e->getMessage()]);
        }
    }

    public function updateStatus(Request $request)
    {
        $request->validate([
            'id'     => 'required|integer|exists:driver_management,id',
            'status' => 'required|boolean',
        ]);

        DB::table('driver_management')
            ->where('id', $request->id)
            ->update(['status' => $request->status, 'updated_at' => now()]);

        return response()->json(['message' => 'Status updated successfully']);
    }

    public function check_username(Request $request)
    {
        $input        = $request->only(['user_name']);
        $return       = false;
        $request_data = [
            'user_name' => 'required',
        ];
        $validator = Validator::make($input, $request_data);

        if ($validator->fails()) {
            $errors = json_decode(json_encode($validator->errors()), 1);
        } else {
            $user_name             = trim($request->user_name);
            $checkwebinarregisterd = DB::table('driver_management')
                ->where('user_name', $user_name)
                ->count();
            if ($checkwebinarregisterd == 0) {
                $return = true;
            }
        }
        echo json_encode($return);
        exit;
    }
    public function edit_check_username(Request $request)
    {
        $input        = $request->only(['user_name', 'ref_id']);
        $return       = false;
        $request_data = [
            'user_name' => 'required',
            'ref_id'    => 'required|integer',
        ];
        $validator = Validator::make($input, $request_data);

        if ($validator->fails()) {
            $errors = json_decode(json_encode($validator->errors()), 1);
        } else {
            $user_name             = trim($request->user_name);
            $ref_id                = (int) trim($request->ref_id);
            $checkwebinarregisterd = DB::table('driver_management')
                ->where('user_name', $user_name)
                ->where('id', '!=', $ref_id)
                ->count();
            if ($checkwebinarregisterd == 0) {
                $return = true;
            }
        }
        echo json_encode($return);
        exit;
    }
    public function check_vehiclenumber(Request $request)
    {
        $input        = $request->only(['vehicle_number']);
        $return       = false;
        $request_data = [
            'vehicle_number' => 'required',
        ];
        $validator = Validator::make($input, $request_data);

        if ($validator->fails()) {
            $errors = json_decode(json_encode($validator->errors()), 1);
        } else {
            $vehicle_number        = trim($request->vehicle_number);
            $checkwebinarregisterd = DB::table('driver_management')
                ->where('vehicle_number', $vehicle_number)
                ->count();
            if ($checkwebinarregisterd == 0) {
                $return = true;
            }
        }
        echo json_encode($return);
        exit;
    }
    public function edit_vehiclenumber(Request $request)
    {
        $input        = $request->only(['vehicle_number', 'ref_id']);
        $return       = false;
        $request_data = [
            'vehicle_number' => 'required',
            'ref_id'         => 'required|integer',
        ];
        $validator = Validator::make($input, $request_data);

        if ($validator->fails()) {
            $errors = json_decode(json_encode($validator->errors()), 1);
        } else {
            $vehicle_number        = trim($request->vehicle_number);
            $ref_id                = (int) trim($request->ref_id);
            $checkwebinarregisterd = DB::table('driver_management')
                ->where('vehicle_number', $vehicle_number)
                ->where('id', '!=', $ref_id)
                ->count();
            if ($checkwebinarregisterd == 0) {
                $return = true;
            }
        }
        echo json_encode($return);
        exit;
    }

    // public function updateLocation(Request $request)
// {

    //     try {
    //         $token = JWTAuth::getToken();
    //         if (! $token) {
    //             Log::error('No token provided');
    //             return $this->unauthorized('Token missing');
    //         }

    //         $driver = JWTAuth::authenticate($token);
    //         if (! $driver) {
    //             Log::error('Token invalid or driver not found');
    //             return $this->notFound('Driver not found');
    //         }

    //         Log::info('Authenticated driver: ' . $driver->id);
    //         $validated = $request->validate([
    //             'latitude'  => 'required|numeric|between:-90,90',
    //             'longitude' => 'required|numeric|between:-180,180',
    //             'status'    => 'required|string|in:online,offline,busy',
    //         ]);

    //         // Insert into driver_locations table
    //         $driver_locations = DB::table('driver_locations')->insert([
    //             'driver_id'  => $driver->id,
    //             'latitude'   => $validated['latitude'],
    //             'longitude'  => $validated['longitude'],
    //             'status'     => $validated['status'],
    //             'created_at' => now(),
    //             'updated_at' => now(),
    //         ]);

    //         // Update current location and status in driver_management table
    //         $driver_management = DB::table('driver_management')->where('id', $driver->id)->update([
    //             'latitude'      => $validated['latitude'],
    //             'longitude'     => $validated['longitude'],
    //             'online_status' => $validated['status'],
    //             'updated_at'    => now(),
    //         ]);

    //         return $this->success($driver_locations, $driver_management, 'Location and status updated successfully');
    //     } catch (\Illuminate\Validation\ValidationException $e) {
    //         return $this->validationError($e->errors(), 'Validation failed');
    //     } catch (\Exception $e) {
    //         return $this->internalError('An error occurred while updating location');
    //     }
//}

    // public function updateLocation(Request $request)
    // {
    //     try {
    //         $driver = auth('api_driver')->user();

    //         if (! $driver) {
    //             Log::error('Driver not authenticated');
    //             return $this->unauthorized('Authentication failed');
    //         }

    //         Log::info('Authenticated driver: ' . $driver->id);

    //         $validated = $request->validate([
    //             'latitude'  => 'required|numeric|between:-90,90',
    //             'longitude' => 'required|numeric|between:-180,180',
    //             'status'    => 'required|string|in:online,offline,busy',
    //         ]);

    //         //Insert into driver_locations table

    //         $driver_locations = DB::table('driver_locations')->insert([
    //             'driver_id'  => $driver->id,
    //             'latitude'   => $validated['latitude'],
    //             'longitude'  => $validated['longitude'],
    //             'status'     => $validated['status'],
    //             'created_at' => now(),
    //             'updated_at' => now(),
    //         ]);

    //         // Update current location and status in driver_management table
    //         $driver_management = DB::table('driver_management')->where('id', $driver->id)->update([
    //             'latitude'      => $validated['latitude'],
    //             'longitude'     => $validated['longitude'],
    //             'online_status' => $validated['status'],
    //             'updated_at'    => now(),
    //         ]);

    //         return response()->json([
    //             'success' => true,
    //             'message' => 'Location and status updated successfully',
    //         ]);
    //     } catch (\Illuminate\Validation\ValidationException $e) {
    //         return response()->json([
    //             'success' => false,
    //             'errors'  => $e->errors(),
    //             'message' => 'Validation failed',
    //         ], 422);
    //     } catch (\Exception $e) {
    //         Log::error('Error updating driver location: ' . $e->getMessage());
    //         return response()->json([
    //             'success' => false,
    //             'message' => 'An error occurred while updating location',
    //         ], 500);
    //     }
    // }

    // public function updateLocation(Request $request)
    // {
    //     try {
    //         $driver = auth('api_driver')->user();

    //         if (! $driver) {
    //             return response()->json(['success' => false, 'message' => 'Authentication failed'], 401);
    //         }

    //         $validated = $request->validate([
    //             'latitude'  => 'required|numeric|between:-90,90',
    //             'longitude' => 'required|numeric|between:-180,180',
    //             'status'    => 'required|string|in:online,offline,busy',
    //         ]);

    //         $now = now();

    //         // 1. Store driver location
    //         DB::table('driver_locations')->insert([
    //             'driver_id'  => $driver->id,
    //             'latitude'   => $validated['latitude'],
    //             'longitude'  => $validated['longitude'],
    //             'status'     => $validated['status'],
    //             'created_at' => $now,
    //             'updated_at' => $now,
    //         ]);

    //         // 2. Update current status in driver_management
    //         DB::table('driver_management')->where('id', $driver->id)->update([
    //             'latitude'      => $validated['latitude'],
    //             'longitude'     => $validated['longitude'],
    //             'online_status' => $validated['status'],
    //             'updated_at'    => $now,
    //         ]);

    //         // 3. If driver goes ONLINE
    //         if ($validated['status'] === 'online') {
    //             // Close any previous unclosed session
    //             DB::table('driver_logdetails')
    //                 ->where('driver_id', $driver->id)
    //                 ->whereNull('driver_logouttime')
    //                 ->update([
    //                     'driver_logouttime' => $now,
    //                     'updated_at'        => $now,
    //                 ]);

    //             // Insert new login session
    //             DB::table('driver_logdetails')->insert([
    //                 'driver_id'        => $driver->id,
    //                 'driver_logintime' => $now,
    //                 'created_at'       => $now,
    //                 'updated_at'       => $now,
    //             ]);
    //         }

    //         // 4. If driver goes OFFLINE
    //         if ($validated['status'] === 'offline') {
    //             $lastLog = DB::table('driver_logdetails')
    //                 ->where('driver_id', $driver->id)
    //                 ->whereNull('driver_logouttime')
    //                 ->orderByDesc('id')
    //                 ->first();

    //             if ($lastLog) {
    //                 $loginTime  = Carbon::parse($lastLog->driver_logintime);
    //                 $logoutTime = $now;
    //                 $diffInSec  = $logoutTime->diffInSeconds($loginTime);
    //                 $formatted  = gmdate('H:i:s', $diffInSec);

    //                 DB::table('driver_logdetails')
    //                     ->where('id', $lastLog->id)
    //                     ->update([
    //                         'driver_logouttime'  => $logoutTime,
    //                         'difference_of_logs' => $formatted,
    //                         'updated_at'         => $now,
    //                     ]);
    //             }
    //         }

    //         // 5. Sum all difference_of_logs for this driver
    //         $today    = Carbon::today();
    //         $logTimes = DB::table('driver_logdetails')
    //             ->where('driver_id', $driver->id)
    //             ->whereDate('driver_logintime', $today)
    //             ->whereNotNull('difference_of_logs')
    //             ->pluck('difference_of_logs');

    //         $totalSeconds = 0;

    //         foreach ($logTimes as $logTime) {
    //             [$h, $m, $s] = array_pad(explode(':', $logTime), 3, 0);
    //             $totalSeconds += ($h * 3600) + ($m * 60) + $s;
    //         }

    //         $formattedTotalHours = gmdate('H:i:s', $totalSeconds);

    //         // 6. Update total_hours in all rows for this driver
    //         $today = Carbon::today();
    //         DB::table('driver_logdetails')
    //             ->where('driver_id', $driver->id)
    //             ->whereDate('driver_logintime', $today)
    //             ->update([
    //                 'total_hours' => $formattedTotalHours,
    //                 'updated_at'  => $now,
    //             ]);

    //         // 7. Optional: return today’s online time (if you want only for today)
    //         $today       = Carbon::today();
    //         $logSessions = DB::table('driver_logdetails')
    //             ->where('driver_id', $driver->id)
    //             ->whereDate('driver_logintime', $today)
    //             ->get();

    //         $todaySeconds = 0;
    //         foreach ($logSessions as $session) {
    //             $login  = Carbon::parse($session->driver_logintime);
    //             $logout = $session->driver_logouttime ? Carbon::parse($session->driver_logouttime) : $now;
    //             $todaySeconds += $logout->diffInSeconds($login);
    //         }

    //         $todayFormatted = gmdate('H:i:s', $todaySeconds);

    //         return response()->json([
    //             'success'            => true,
    //             'message'            => 'Location and status updated successfully',
    //             'difference_of_logs' => $todayFormatted,
    //             'total_hours'        => $formattedTotalHours,
    //         ]);

    //     } catch (\Illuminate\Validation\ValidationException $e) {
    //         return response()->json([
    //             'success' => false,
    //             'errors'  => $e->errors(),
    //             'message' => 'Validation failed',
    //         ], 422);
    //     } catch (\Exception $e) {
    //         Log::error('Error updating location: ' . $e->getMessage());
    //         return response()->json([
    //             'success' => false,
    //             'message' => 'Server error: ' . $e->getMessage(),
    //         ], 500);
    //     }
    // }

    public function updateLocation(Request $request)
    {
        try {
            $driver = auth('api_driver')->user();

            if (! $driver) {
                return response()->json(['success' => false, 'message' => 'Authentication failed'], 401);
            }

            $validated = $request->validate([
                'latitude'  => 'required|numeric|between:-90,90',
                'longitude' => 'required|numeric|between:-180,180',
                'status'    => 'required|string|in:online,offline,busy',
            ]);

            $now   = now();
            $today = Carbon::today();

            // 1. Store driver location
            DB::table('driver_locations')->insert([
                'driver_id'  => $driver->id,
                'latitude'   => $validated['latitude'],
                'longitude'  => $validated['longitude'],
                'status'     => $validated['status'],
                'created_at' => $now,
                'updated_at' => $now,
            ]);

            // 2. Update current status in driver_management
            DB::table('driver_management')->where('id', $driver->id)->update([
                'latitude'      => $validated['latitude'],
                'longitude'     => $validated['longitude'],
                'online_status' => $validated['status'],
                'updated_at'    => $now,
            ]);

            // 3. If driver goes ONLINE
            if ($validated['status'] === 'online') {
                // Close any previous unclosed session
                DB::table('driver_logdetails')
                    ->where('driver_id', $driver->id)
                    ->whereNull('driver_logouttime')
                    ->update([
                        'driver_logouttime' => $now,
                        'updated_at'        => $now,
                    ]);

                // Insert new login session
                DB::table('driver_logdetails')->insert([
                    'driver_id'        => $driver->id,
                    'driver_logintime' => $now,
                    'created_at'       => $now,
                    'updated_at'       => $now,
                ]);
            }

            // 4. If driver goes OFFLINE
            if ($validated['status'] === 'offline') {
                $lastLog = DB::table('driver_logdetails')
                    ->where('driver_id', $driver->id)
                    ->whereNull('driver_logouttime')
                    ->orderByDesc('id')
                    ->first();

                if ($lastLog) {
                    $loginTime  = Carbon::parse($lastLog->driver_logintime);
                    $logoutTime = $now;
                    $diffInSec  = $logoutTime->diffInSeconds($loginTime);
                    $formatted  = gmdate('H:i:s', $diffInSec);

                    DB::table('driver_logdetails')
                        ->where('id', $lastLog->id)
                        ->update([
                            'driver_logouttime'  => $logoutTime,
                            'difference_of_logs' => $formatted,
                            'updated_at'         => $now,
                        ]);
                }
            }

            // 5. Sum all difference_of_logs for today only
            $logTimes = DB::table('driver_logdetails')
                ->where('driver_id', $driver->id)
                ->whereDate('driver_logintime', $today)
                ->whereNotNull('difference_of_logs')
                ->pluck('difference_of_logs');

            $totalSeconds = 0;
            foreach ($logTimes as $logTime) {
                [$h, $m, $s] = array_pad(explode(':', $logTime), 3, 0);
                $totalSeconds += ($h * 3600) + ($m * 60) + $s;
            }

            $formattedTotalHours = gmdate('H:i:s', $totalSeconds);

            // 6. Update today’s rows only with today’s total
            DB::table('driver_logdetails')
                ->where('driver_id', $driver->id)
                ->whereDate('driver_logintime', $today)
                ->update([
                    'total_hours' => $formattedTotalHours,
                    'updated_at'  => $now,
                ]);

            return response()->json([
                'success'            => true,
                'message'            => 'Location and status updated successfully',
                'difference_of_logs' => $formattedTotalHours,
                'total_hours'        => $formattedTotalHours,
            ]);

        } catch (\Illuminate\Validation\ValidationException $e) {
            return response()->json([
                'success' => false,
                'errors'  => $e->errors(),
                'message' => 'Validation failed',
            ], 422);
        } catch (\Exception $e) {
            Log::error('Error updating location: ' . $e->getMessage());
            return response()->json([
                'success' => false,
                'message' => 'Server error: ' . $e->getMessage(),
            ], 500);
        }
    }

}
