<?php
namespace App\Helpers;

use Illuminate\Support\Facades\Http;

class FCMHelper
{
    public static function sendNotification($deviceToken, $title, $body, $data = [])
    {
        $serverKey = config('services.fcm.server_key');

        $response = Http::withHeaders([
            'Authorization' => 'key=' . $serverKey,
            'Content-Type'  => 'application/json',
        ])->post('https://fcm.googleapis.com/fcm/send', [
            'to'           => $deviceToken,
            'notification' => [
                'title' => $title,
                'body'  => $body,
                'sound' => 'default',
            ],
            'data'         => $data,
        ]);

        return $response->json();
    }
}
