<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTopicsTable extends Migration
{
    public function up()
    {
        Schema::create('topics', function (Blueprint $table) {

		$table->bigIncrements('topic_id');
		$table->integer('topic_meeting_id');
		$table->integer('topic_created_by');
		$table->string('topic_name',255);
		$table->date('topic_created_date');
		$table->integer('topic_status');
		$table->integer('topic_time');
		$table->integer('topic_rem_time');
		$table->integer('topic_order');
		$table->longtext('topic_prevnames')->nullable();
		$table->integer('topic_prevcount');
		$table->string('topic_color',50)->default('#FFFFFF');
		$table->integer('topic_swot_status')->default('0');
		$table->integer('topic_discussed_counts')->default('0');
		$table->integer('topic_emap_status')->default('0');
		$table->integer('topic_pv_status')->default('0');
		$table->integer('topic_sb_status')->default('0');
		$table->integer('topic_lc_status')->default('0');
		$table->integer('topic_pc_status')->default('0');
		$table->integer('topic_lp_status')->default('0');
		$table->integer('topic_sm_status')->default('0');
		$table->integer('topic_os_status')->default('0');
		$table->integer('topic_fb_status')->default('0');
		$table->integer('topic_cop_status')->default('0');

	
        });
    }

    public function down()
    {
        Schema::dropIfExists('topics');
    }
}