<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Exports\PostsExport;
use DB;
use Mail;
use PDF;

class SailboatController extends Controller
{
	public function guestuser(Request $request)
	{		
		if(session('lcbuser_id') == '')
		{
		$data['metting_random_number'] = $request->id;
		$valid_meeting_rno = DB::table('boards')->where('meeting_rand',$data['metting_random_number'])->count();
		if($valid_meeting_rno == 0)
		{
			return redirect('/signin/')->with("error","Sorry, wrong guest user link");
		}
		else
		{
			$me_infos = DB::table('boards')->where('meeting_rand',$data['metting_random_number'])->first();
			// to check guest allowed or not
			if($me_infos->meeting_no_guests == 0)
			{
				if($me_infos->meeting_end_status == 1)
				{
					return redirect('/signin')->with("error","Meeting is already Over!!!");
				}	
				else
				{			
					return view('user/guestlogin',$data);
				}
			}
			else
			{
				return redirect('/signin/')->with("error","Sorry guests are not allowed");
			}
			// to check guest allowed or not
			
			
		}
		}
		else
		{

			$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
			if($userinfo->user_type == 1)
			{
				if($userinfo->user_ftype == 0)
				{
					return redirect('/home');
				}
				else
				{
					return redirect('/customerhome');
				}
			}
			else
			{
				return redirect('/attendeehome');
			}			
					
		}
	}
	
	
	public function getmonths(Request $request)
	{
		$data['subscription_info'] = $this->subscriptiondetails();
		$currentprice = $data['subscription_info']->stotalprice;
		$cuserinfo = $this->userdetails();
		
		if($data['subscription_info']->advance_done == 1)
		{
		// if any advance payment done
		$ad_pay_done = DB::table('paymenthistory')->where('pay_user_id',$cuserinfo->user_id)->where('pay_status','1')->where('pay_description','Advance subscription')->count();
		if($ad_pay_done >= 2)
		{
			// get final amount paid
			$ad_pay_done_info = DB::table('paymenthistory')->where('pay_user_id',$cuserinfo->user_id)->where('pay_status','1')->where('pay_description','Advance subscription')->count();
			$ad_pay_done_info_val = $ad_pay_done_info - 1;
			$currentpricefinal = 2 * $currentprice;
			// get final amount paid
		}
		else
		{
			$currentpricefinal = $currentprice;
		}
		// if any advance payment done
		}
		else
		{
			$currentpricefinal = $currentprice;
		}
		
		$currentsubscription = $data['subscription_info']->snofacilitators;
		
			
			$data['pinfo'] = DB::table('prices')->where('pcount','=',$request->monthid)->first();
			
			
			$cprice = $data['pinfo']->pprice;
			$allmonths = DB::table('months')->orderBy("mid","asc")->get();
			$a=array();
			foreach($allmonths as $am)
			{
				$tot_price = $am->mcount * $cprice;
				if($tot_price > $currentpricefinal)
				{					
					array_push($a,$am->mid);
				}
			}
			$data['selmonths'] = $a;
			$selectedmonths = DB::table('months')->whereIn('mid',$data['selmonths'])->pluck("minfo","mcount","mmain","mid");
			$selectedmonths_first = DB::table('months')->whereIn('mid',$data['selmonths'])->first();
			
		$results=array("selectedmonths"=>$selectedmonths,"selectedmonths_first"=>$selectedmonths_first->mmain,"cprice"=>$cprice);//,"alertmessageinfo"=>$almessage
		return response()->json($results);	


			
			
		
		
		/*if($request->monthid > 1)
		{
		$states = DB::table('months')->where("mcount",">=",$request->monthid)->orderBy("mid","asc")->pluck("minfo","mcount","mmain","mid");
		}
		else
		{
		$states = DB::table('months')->where("mcount",">",$request->monthid)->orderBy("mid","asc")->pluck("minfo","mcount","mmain","mid");	
		}
		return response()->json($states);		*/
	}
		
	
	public function getmonths_prevone(Request $request)
	{
		$data['subscription_info'] = $this->subscriptiondetails();
		$currentprice = $data['subscription_info']->stotalprice;
		
		$currentsubscription = $data['subscription_info']->snofacilitators;
		
			
			$data['pinfo'] = DB::table('prices')->where('pcount','=',$request->monthid)->first();
			
			
			$cprice = $data['pinfo']->pprice;
			$allmonths = DB::table('months')->orderBy("mid","asc")->get();
			$a=array();
			foreach($allmonths as $am)
			{
				$tot_price = $am->mcount * $cprice;
				if($tot_price > $currentprice)
				{					
					array_push($a,$am->mid);
				}
			}
			$data['selmonths'] = $a;
			$selectedmonths = DB::table('months')->whereIn('mid',$data['selmonths'])->pluck("minfo","mcount","mmain","mid");
			$selectedmonths_first = DB::table('months')->whereIn('mid',$data['selmonths'])->first();
			
		$results=array("selectedmonths"=>$selectedmonths,"selectedmonths_first"=>$selectedmonths_first->mmain,"cprice"=>$cprice);//,"alertmessageinfo"=>$almessage
		return response()->json($results);	


			
			
		
		
		/*if($request->monthid > 1)
		{
		$states = DB::table('months')->where("mcount",">=",$request->monthid)->orderBy("mid","asc")->pluck("minfo","mcount","mmain","mid");
		}
		else
		{
		$states = DB::table('months')->where("mcount",">",$request->monthid)->orderBy("mid","asc")->pluck("minfo","mcount","mmain","mid");	
		}
		return response()->json($states);		*/
	}
	
	
	public function mergetopics(Request $request)
	{
		$this->updateusertime();
		//return $request->sel_topics;
		if(isset($request->sel_topics))  
		{ 
			if(count($request->sel_topics) == 1)
			{
				$results=array("message"=>1);
			}
			else
			{
				$prev_topics='';
				foreach($request->sel_topics as $st)
				{
					$topicname = DB::table('topics')->where('topic_id',$st)->first();
					if($prev_topics == '')
					{
						$prev_topics = $topicname->topic_name;
					}
					else
					{
						$prev_topics = $prev_topics.",".$topicname->topic_name;
					}
					// delete topic
					DB::table('topics')->where('topic_id',$st)->delete();
					// delete topic
					
					// remove all votes
					DB::table('topics_votes')->where('vtopicid',$st)->delete();	
					// remove all votes
					
					// remove all comments
					DB::table('topic_discussion')->where('d_topic_id',$st)->delete();
					// remove all comments	
									
					// remove all actions
					DB::table('actions')->where('a_topicid',$st)->delete();
					// remove all actions						
					
				}
		// to find order by
		$ifanyitems =  DB::table('topics')->where('topic_meeting_id',$request->current_mid)->count();
		if($ifanyitems == 0)
		{
			$orderbyinfo = 1;
		}
		else
		{
			$fac_det =  DB::table('topics')->where('topic_meeting_id',$request->current_mid)->orderBy('topic_order','DESC')->first();
			$orderbyinfo = $fac_det->topic_order+1;
		}
		// to find order by	
		
		$todaydate = date("Y-m-d");	
		$data['prevtopics'] = $prev_topics;	
		DB::table('topics')->insert(['topic_order' => $orderbyinfo,'topic_created_by' => session('lcbuser_id'),'topic_meeting_id' => $request->current_mid,'topic_name' =>$request->new_topic_name,'topic_created_date' => $todaydate,'topic_prevnames' => $prev_topics,'topic_prevcount' => count($request->sel_topics)]);
						
				$results=array("message"=>2);
			}
			
		} 
		else
		{
			$results=array("message"=>1);
		} 
		return response()->json($results);		
	}
	
	
	public function boardsnewway(Request $request)
	{
	
		$user_info = $this->userdetails();
		
		if($user_info->user_type == '2')
		{
			return redirect('/yourboards/');
		}
		
		
		$tochecktrailornot = DB::table('paymenthistory')->where([ ["pay_user_id","=",session('lcbuser_id')] ])->where([ ["pay_status","1"] ])->count();	
		if($tochecktrailornot == 0)
		{
			$data['tinfo'] = "trial";
		}	
		else
		{
			$data['tinfo'] = "subscription";
		}
		$data['userdetails'] = $this->userdetails();
				
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();		
		
		$data['allboards'] = DB::table('boards')->join('siteusers as A' ,'boards.meeting_by','=','A.user_id')->where('A.user_id',session('lcbuser_id'))->select('boards.*','A.user_name')->orderBy('boards.meeting_date_created','DESC')->get();				

		$data['joinedboards'] = DB::table('attendees_request')->join('boards as A' ,'attendees_request.rboardid','=','A.meeting_id')->where('attendees_request.remailid',"=",$user_info->user_emailid)->join('siteusers as B' ,'A.meeting_by','=','B.user_id')->orderBy('A.meeting_date_created','DESC')->get();	
		
		
		$data['result'] = $data['allboards']->merge($data['joinedboards'])->sortByDesc('meeting_date_created');
		/*dd($data['result']);
		exit();*/
		
$data['mymeetingids'] = DB::table('attendees_request')->select('A.meeting_id')->join('boards as A' ,'attendees_request.rboardid','=','A.meeting_id')->where('attendees_request.remailid',"=",$user_info->user_emailid)->join('siteusers as B' ,'A.meeting_by','=','B.user_id')->get();

		$data['all_meetingids'] = json_decode(json_encode($data['mymeetingids']), true);
		
		$data['yourtopics'] = DB::table('topics')->whereIn('topic_meeting_id',$data['all_meetingids'])->where('topic_status','2')->where('topic_rem_time','!=','0')->get();
		
		$data['totalvoteslist'] = DB::table('votecounts')->orderBy('vid','ASC')->get();		
		
									
		return view('user/boardsnewway',$data);		
	
	}
	
		
	public function boards(Request $request)
	{
		$user_info = $this->userdetails();
		
		if($user_info->user_type == '2')
		{
			return redirect('/yourboards/');
		}
		
		
		$tochecktrailornot = DB::table('paymenthistory')->where([ ["pay_user_id","=",session('lcbuser_id')] ])->where([ ["pay_status","1"] ])->count();	
		if($tochecktrailornot == 0)
		{
			$data['tinfo'] = "trial";
		}	
		else
		{
			$data['tinfo'] = "subscription";
		}
		$data['userdetails'] = $this->userdetails();
				
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();		
		
		$data['allboards'] = DB::table('boards')->join('siteusers as A' ,'boards.meeting_by','=','A.user_id')->where('A.user_id',session('lcbuser_id'))->select('boards.*','A.user_name')->orderBy('boards.meeting_date_created','DESC')->get();				

		$data['joinedboards'] = DB::table('attendees_request')->join('boards as A' ,'attendees_request.rboardid','=','A.meeting_id')->where('attendees_request.remailid',"=",$user_info->user_emailid)->join('siteusers as B' ,'A.meeting_by','=','B.user_id')->orderBy('A.meeting_date_created','DESC')->get();	
		
		
		/*$data['result'] = $data['allboards']->merge($data['joinedboards']);
		dd($data['result']);
		exit();*/
$data['mymeetingids'] = DB::table('attendees_request')->select('A.meeting_id')->join('boards as A' ,'attendees_request.rboardid','=','A.meeting_id')->where('attendees_request.remailid',"=",$user_info->user_emailid)->join('siteusers as B' ,'A.meeting_by','=','B.user_id')->get();

		$data['all_meetingids'] = json_decode(json_encode($data['mymeetingids']), true);
		
		$data['yourtopics'] = DB::table('topics')->whereIn('topic_meeting_id',$data['all_meetingids'])->where('topic_status','2')->where('topic_rem_time','!=','0')->get();
		
		$data['totalvoteslist'] = DB::table('votecounts')->orderBy('vid','ASC')->get();		
		
									
		return view('user/boards',$data);		
	}
	
	public function yourboards(Request $request)
	{
		$user_info = $this->userdetails();
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		$data['yourmeetings'] = DB::table('attendees_request')->join('boards as A' ,'attendees_request.rboardid','=','A.meeting_id')->where('attendees_request.remailid',"=",$user_info->user_emailid)->join('siteusers as B' ,'A.meeting_by','=','B.user_id')->orderBy('A.meeting_date_created','DESC')->get();	

		$data['mymeetingids'] = DB::table('attendees_request')->select('A.meeting_id')->join('boards as A' ,'attendees_request.rboardid','=','A.meeting_id')->where('attendees_request.remailid',"=",$user_info->user_emailid)->join('siteusers as B' ,'A.meeting_by','=','B.user_id')->get();

		$data['all_meetingids'] = json_decode(json_encode($data['mymeetingids']), true);
		
		$data['yourtopics'] = DB::table('topics')->whereIn('topic_meeting_id',$data['all_meetingids'])->where('topic_status','2')->where('topic_rem_time','!=','0')->get();
		/*foreach($data['yourtopics'] as $ut)
		{
			echo $ut->topic_id;
		}*/
		
		return view('user/yourboards',$data);
	}
	
	public function topics_sorting(Request $request)
	{	
		$this->updateusertime();
		$id_ary = $request->topic_id;	
		$itemcounts = count($id_ary);
		for($i=0;$i<$itemcounts;$i++) 
		{
		$k=$i+1;
		$values = array('topic_order' => $k);
		DB::table('topics')->where([["topic_id","=",$id_ary[$i]]])->update($values);
		}		
		return 1;
	}
	
	public function topics_load(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();

		
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['yourtopics2'] = DB::table('topics')->where('topic_meeting_id',$request->id)->orderBy('topic_order','ASC')->get();
		
		
$duprecnameload = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');

$tablename = 'topics';

$data['yourtopics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)
       ->leftJoinSub($duprecnameload,'duprecnameload', function ($leftJoin) {
           $leftJoin->on('duprecnameload.vtopicid', '=', 'topics.topic_id');
       })->orderBy('TV','DESC')->get();
	   
	   		
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = 3 - $topic_votes_count;

		// all votes
		
				
		return view('user/topics_load',$data);
	}
	
	public function topics_load_vote_only(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();

		
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['yourtopics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->orderBy('topic_order','ASC')->get();
		
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = 3 - $topic_votes_count;

		// all votes
		
				
		return view('user/topics_load_vote_only',$data);
	}	
	
	public function topics(Request $request)
	{
	
		
		
		
		$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;		
		
		
		$ifexist = DB::table('boards')->where('meeting_id',$request->id)->count();
		
		if($ifexist == 0)
		{
			if($user_info->user_type == 2)
			{
				return redirect('/attendeehome');
			}
			if($user_info->user_type == 1)
			{
			
				return redirect('/boards');
			}
			
			if($user_info->user_type == 3)
			{
				$ifanyboards = DB::table('boards')->where('meeting_id',$request->id)->where('meeting_no_guests','0')->count();	
				if($ifanyboards == 0)
				{
					session()->put('lcbuser_id','');			
					session()->put('lcbuser_name','');
					session()->put('lcbuser_ftype','');		
					return redirect('/index');
				}
			}
			
			
		}
				
		
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		

		if($user_info->user_type == 2)
		{
			$ifanyboards = DB::table('attendees_request')->where('rboardid',$request->id)->where('remailid',$user_info->user_emailid)->count();	//where('rstatus','1')->
			if($ifanyboards == 0)
			{
				return redirect('/attendeehome');
			}
		}
		
		if($user_info->user_type == 1 and $data['meeting_by']->meeting_by != $user_info->user_id)
		{	
			$ifanyboards = DB::table('attendees_request')->where('rboardid',$request->id)->where('remailid',$user_info->user_emailid)->count();	//where('rstatus','1')->
			if($ifanyboards == 0)
			{
				return redirect('/boards');
			}			
		}
				
		if($user_info->user_type == 3)
		{
			$ifanyboards = DB::table('boards')->where('meeting_id',$request->id)->where('meeting_no_guests','0')->count();	
			if($ifanyboards == 0)
			{
				session()->put('lcbuser_id','');			
				session()->put('lcbuser_name','');
				session()->put('lcbuser_ftype','');		
				return redirect('/index');
			}
			else
			{
				$em = explode("@",$user_info->user_emailid);
				$mid = DB::table('boards')->where('meeting_rand',$em[0])->first();
				$meeting_id = $mid->meeting_id;	
				return redirect('discussion/'.$meeting_id);				
				
			}
		}
		
				
				
		

		
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['yourtopics1'] = DB::table('topics')->where('topic_meeting_id',$request->id)->orderBy('topic_order','ASC')->get();
		
		
		$data['countassoc'] = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid')->pluck('TV','vtopicid')->toArray();
		//dd($data['countassoc']);
		
		//$data['yourtopicsnew'] = DB::table('topics')->where('topic_meeting_id',$request->id)->orderBy('topic_order','ASC')->get();
		
		$data['yourtopicsnew'] = DB::table('topics')->get();
		
/*SELECT a.*, count(b.vid) as TotalCount
FROM lcb_topics a
LEFT JOIN lcb_topics_votes b on a.topic_id=b.vtopicid
GROUP BY a.topic_id
ORDER BY TotalCount desc*/



$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');

$tablename = 'topics';

$data['yourtopics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)
       ->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
           $leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
       })->orderBy('TV','DESC')->get();
	   


	   
$data['ftest'] = DB::table('topics')->leftJoin('topics_votes', 'topics.topic_id', '=', 'topics_votes.vtopicid')->groupBy('topics.topic_id')->get();
		
		
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = 3 - $topic_votes_count;

		// all votes
						
		return view('user/topics',$data);
		
	}
	
	public function viewalltopics(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();

		
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['yourtopics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->orderBy('topic_order','ASC')->get();
		
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = 3 - $topic_votes_count;

		// all votes
		
				
		return view('user/viewalltopics',$data);
	}	
	
	public function discussingtopics(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['yourtopics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','0')->orderBy('topic_id','DESC')->get();
		$data['discussion_topics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','1')->orderBy('topic_id','DESC')->get();
		$data['discussing_topics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->get();
		
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = 3 - $topic_votes_count;

		// all votes
			
		return view('user/discussingpage',$data);
			
	}
	
	public function showmovedtopics(Request $request)
	{
		$this->updateusertime();
				$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['yourtopics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','0')->orderBy('topic_id','DESC')->get();
		$data['discussion_topics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','1')->orderBy('topic_id','DESC')->get();
		$data['discussing_topics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->get();		
		
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = 3 - $topic_votes_count;

		// all votes
			
		return view('user/mydiscussion',$data);
	}
	
	public function testdiscussion(Request $request)
	{}
	
	public function currentdiscussingtopics(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['yourtopics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','0')->orderBy('topic_id','DESC')->get();
		$data['discussion_topics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','1')->orderBy('topic_id','DESC')->get();
		$data['discussing_topics_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->count();
		$data['discussed_topics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->orderBy('topic_id','DESC')->get();		
		$data['discussing_topics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->first();
		if($data['discussing_topics_count'] != 0)
		{
		$data['act_time'] = $data['discussing_topics']->topic_time * 60; 
		}
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();
		
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 
		
				

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = 3 - $topic_votes_count;

		// all votes

		$data['all_action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['discussed_topics_tot_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->count();
		
				
		return view('user/currentdiscussingtopics',$data);		
	}
	
	public function columnone_topics(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['yourtopics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','0')->orderBy('topic_id','DESC')->get();
		$data['discussion_topics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','1')->orderBy('topic_id','DESC')->get();
		$data['discussing_topics_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->count();
		$data['discussed_topics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->orderBy('topic_id','DESC')->get();		
		$data['discussing_topics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->first();
		if($data['discussing_topics_count'] != 0)
		{
		$data['act_time'] = $data['discussing_topics']->topic_time * 60; 
		}
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();
		
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 
		
				

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = 3 - $topic_votes_count;

		// all votes

		$data['all_action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['discussed_topics_tot_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->count();
		
				
		return view('user/columnone_topics',$data);
		
	}	
	
	
	
	public function columntwo_topics(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['yourtopics2'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','0')->orderBy('topic_id','DESC')->get();
		$data['discussion_topics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','1')->orderBy('topic_id','DESC')->get();
		$data['discussing_topics_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->count();
		$data['discussed_topics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->orderBy('topic_id','DESC')->get();		
		$data['discussing_topics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->first();
		if($data['discussing_topics_count'] != 0)
		{
		$data['act_time'] = $data['discussing_topics']->topic_time * 60; 
		}
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();
		
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 
		
				

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = 3 - $topic_votes_count;

		// all votes

		$data['all_action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['discussed_topics_tot_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->count();
		
				
		return view('user/columntwo_topics',$data);
		
	}	
	
	public function takehostback(Request $request)
	{
		$values = array('meeting_host_by' => $request->userid);
		$tt = DB::table('boards')->where([["meeting_id","=",$request->mid]])->update($values);
		
		return redirect('/boards')->with("success","You are host now!!!");
				
	}
	
	
	public function getfirsttwocolumnsdatas_sb(Request $request)
	{
	
		$this->updateusertime();
		$userdetails = $this->userdetails();
		$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		$topicid_array = explode(',', $data['meeting_by']->meeting_opened_topics);
		
		$yourtopics_old = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','0')->orderBy('topics.topic_order','ASC')->get();
		
// join query
/*$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$yourtopics = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"0")->where('topic_sb_status',"0")->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();*/

$data['vision_topics'] =  DB::select('CALL  getSBtopics(?,?,?)',array($request->id,1,0));



// join query

		
// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();
		
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 
		
				

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = $data['meeting_by']->meeting_votes_fixed - $topic_votes_count;

		// all votes

		$data['all_action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['discussed_topics_tot_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->count();
		
// first column details					
		$htmlmsg='';
		if(count($data['vision_topics']) != 0)
		{
			foreach($data['vision_topics'] as $ytt)
			{

 if(in_array($ytt->topic_id,$topicid_array))
  {
  	$v = 'collapsed';
	$w = 'true';
  }
  else
  {
  	$v = 'collapse';$w = 'false';
  }
  
  
$uid_second = "topic_id_".$ytt->topic_id;
$did=$ytt->topic_id;

$htmlmsg.='<li id='.$uid_second.'><div class="card" style="width: 100%;height:auto;">';

$htmlmsg.='<header class="card-header" style="background-color:'.$ytt->topic_color.'"><a href="#" data-toggle="collapse" data-target="#collapse__'.$ytt->topic_id.'" data-id="'.$ytt->topic_id.'"  id="col_'.$ytt->topic_id.'"  aria-expanded="'.$w.'" class="mycheck" >';

$htmlmsg.='<span title="'.ucfirst($ytt->topic_name).'">&nbsp;'.str_limit(ucfirst($ytt->topic_name),10).'</span>';	

$htmlmsg.='<i class="fa fa-chevron-down" style="float:right; padding-top:5px;"></i> </a></header>';
$htmlmsg.='<div class="'.$v.'" id="collapse__'.$ytt->topic_id.'" style=""><div class="stackedExistingTopic">';
if($ytt->topic_prevcount != '0')
{
$htmlmsg.='<a href="javascript:void(0)" style="padding:3px" class="re_btn"  title="Merged Topics: '.$ytt->topic_prevnames.'">'.$ytt->topic_prevcount.'</a>';
}
$htmlmsg.='</div>';

$htmlmsg.='<div class="card-body">
<table width="100%" border="0">
<tr><td valign="top" colspan="2" style="font-size:14px;">';




$htmlmsg.='<p align="left">';
if($ytt->topic_discussed_counts != 0)
{
for($i=0;$i<$ytt->topic_discussed_counts;$i++)
{ 
	$htmlmsg.='<i class="fa fa-check" style="color:#006600; font-size:14px;"></i>';
}
}
else
{
$htmlmsg.='</br>'; 	
}
$htmlmsg.='</p>';             
               
$htmlmsg.='<p align="left">';

$i=1; $j=0; $m=0;


if($data['meeting_by']->meeting_name_dsiplay == '1')
{
	$htmlmsg.="&nbsp;".$ytt->user_name;
}
else
{
	$htmlmsg.='</br>';
}

$htmlmsg.='</p></td></tr>';		

if($data['meeting_by']->meeting_host_by == $userdetails->user_id)
{
$htmlmsg.='<span data-id="'.$ytt->topic_id.'" data-info="'.$ytt->topic_id.'"></span>';
}	
else
{
	if($ytt->topic_created_by == $userdetails->user_id)
	{
		$htmlmsg.='<span data-id="'.$ytt->topic_id.'" data-info="'.$ytt->topic_id.'"></span>';
	}
	else
	{
		$htmlmsg.='<span data-id="'.$ytt->topic_id.'" ></span>';
	}	
}






$htmlmsg.='<tr style="background-color:#ecf0f1">';
if($data['meeting_by']->meeting_host_by == $userdetails->user_id)
{
$htmlmsg.='<td align="left"><a data-id="'.$ytt->topic_id.'" class="addaction_function" id="addaction_function" style="cursor:pointer" alt="Add Actions" title="Add Actions"><i class="fa fa-plus"></i></a>&nbsp;<a id="actioninfos" data-toggle="modal" class="showaction_function"   alt="View Actions" title="View Actions" data-id="'.$ytt->topic_id.'" style="cursor:pointer"><i class="fa fa-eye"></i></a></td><td align="right"><a id="commentinfos" data-toggle="modal" class="showcomment_function"   alt="Add/View Comments" title="Add/View Comments" data-id="'.$ytt->topic_id.'" ><i class="fa fa-comment"></i></a>&nbsp;<a class="startagain"  name="startagain" id="startagain" alt="Start Discussion" title="Start Discussion"  data-id="'.$ytt->topic_id.'"><i class="fa fa-clock-o"></i></a>&nbsp;<a class="editing-yt" data-id="'.$ytt->topic_id.'" href="javascript:void(0)" alt="Edit" title="Edit"><i class="fa fa-pencil"></i></a>&nbsp;<a class="delete-yt"  data-id="'.$ytt->topic_id.'" href="javascript:void(0)" alt="Delete" title="Delete"><i class="fa fa-trash"></i></a></td>';
}
else
{
if($ytt->topic_created_by == $userdetails->user_id)
{
$htmlmsg.='<td align="left"><a href="#" data-toggle="modal" class="showaction_function"  data-id="'.$ytt->topic_id.'"><i class="fa fa-eye"></i></a></td><td align="right"><a id="commentinfos" data-toggle="modal" class="showcomment_function"  alt="Add/View Comments" title="Add/View Comments" data-id="'.$ytt->topic_id.'" ><i class="fa fa-comment"></i></a>&nbsp;<a class="editing-yt" data-id="'.$ytt->topic_id.'" href="javascript:void(0)" alt="Edit" title="Edit"><i class="fa fa-pencil"></i></a>&nbsp;<a class="delete-yt"  data-id="'.$ytt->topic_id.'" href="javascript:void(0)" alt="Delete" title="Delete"><i class="fa fa-trash"></i></a></td>
';
}
else
{
$htmlmsg.='<td align="left"><a href="#" data-toggle="modal" class="showaction_function"  data-id="'.$ytt->topic_id.'"><i class="fa fa-eye"></i></a></td><td align="right"><a id="commentinfos" data-toggle="modal" class="showcomment_function"  alt="Add/View Comments" title="Add/View Comments" data-id="'.$ytt->topic_id.'" ><i class="fa fa-comment"></i></a>&nbsp;</td>';
}
}
$htmlmsg.='</tr>';


			
$htmlmsg.='</table></div></div>';

$htmlmsg.='</div></li>';
				
								
}
		}
// first column details		
		$htmlmsg .="__________";
		
// second column details	



// join query
/*$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['s_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"1")->where('topic_sb_status',"0")->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();*/
$data['s_topics'] =  DB::select('CALL  getSBtopics(?,?,?)',array($request->id,2,0));
// join query



if(count($data['s_topics']) != 0)
{
foreach($data['s_topics'] as $ytt)
{

 if(in_array($ytt->topic_id,$topicid_array))
  {
  	$v = 'collapsed';
	$w = 'true';
  }
  else
  {
  	$v = 'collapse';$w = 'false';
  }
  
  
$uid_second = "topic_id_".$ytt->topic_id;
$did=$ytt->topic_id;

$htmlmsg.='<li id='.$uid_second.'><div class="card" style="width: 100%;height:auto;">';

$htmlmsg.='<header class="card-header" style="background-color:'.$ytt->topic_color.'"><a href="#" data-toggle="collapse" data-target="#collapse__'.$ytt->topic_id.'" data-id="'.$ytt->topic_id.'"  id="col_'.$ytt->topic_id.'"  aria-expanded="'.$w.'" class="mycheck" >';
$htmlmsg.='<span title="'.ucfirst($ytt->topic_name).'">&nbsp;'.str_limit(ucfirst($ytt->topic_name),10).'</span>';
$htmlmsg.='<i class="fa fa-chevron-down" style="float:right; padding-top:5px;"></i> </a></header>';
$htmlmsg.='<div class="'.$v.'" id="collapse__'.$ytt->topic_id.'" style=""><div class="stackedExistingTopic">';
if($ytt->topic_prevcount != '0')
{
$htmlmsg.='<a href="javascript:void(0)" style="padding:3px" class="re_btn"  title="Merged Topics: '.$ytt->topic_prevnames.'">'.$ytt->topic_prevcount.'</a>';
}
$htmlmsg.='</div>';

$htmlmsg.='<div class="card-body">
<table width="100%" border="0">
<tr><td valign="top" colspan="2" style="font-size:14px;">';




$htmlmsg.='<p align="left">';
if($ytt->topic_discussed_counts != 0)
{
for($i=0;$i<$ytt->topic_discussed_counts;$i++)
{ 
	$htmlmsg.='<i class="fa fa-check" style="color:#006600; font-size:14px;"></i>';
}
}
else
{
$htmlmsg.='</br>'; 	
}
$htmlmsg.='</p>';             
               
$htmlmsg.='<p align="left">';

$i=1; $j=0; $m=0;


if($data['meeting_by']->meeting_name_dsiplay == '1')
{
	$htmlmsg.="&nbsp;".$ytt->user_name;
}
else
{
	$htmlmsg.='</br>';
}

$htmlmsg.='</p></td></tr>';		

if($data['meeting_by']->meeting_host_by == $userdetails->user_id)
{
$htmlmsg.='<span data-id="'.$ytt->topic_id.'" data-info="'.$ytt->topic_id.'"></span>';
}	
else
{
	if($ytt->topic_created_by == $userdetails->user_id)
	{
		$htmlmsg.='<span data-id="'.$ytt->topic_id.'" data-info="'.$ytt->topic_id.'"></span>';
	}
	else
	{
		$htmlmsg.='<span data-id="'.$ytt->topic_id.'" ></span>';
	}	
}






$htmlmsg.='<tr style="background-color:#ecf0f1">';
if($data['meeting_by']->meeting_host_by == $userdetails->user_id)
{
$htmlmsg.='<td align="left"><a data-id="'.$ytt->topic_id.'" class="addaction_function" id="addaction_function" style="cursor:pointer" alt="Add Actions" title="Add Actions"><i class="fa fa-plus"></i></a>&nbsp;<a id="actioninfos" data-toggle="modal" class="showaction_function"   alt="View Actions" title="View Actions" data-id="'.$ytt->topic_id.'" style="cursor:pointer"><i class="fa fa-eye"></i></a></td><td align="right"><a id="commentinfos" data-toggle="modal" class="showcomment_function"   alt="Add/View Comments" title="Add/View Comments" data-id="'.$ytt->topic_id.'" ><i class="fa fa-comment"></i></a>&nbsp;<a class="startagain"  name="startagain" id="startagain" alt="Start Discussion" title="Start Discussion"  data-id="'.$ytt->topic_id.'"><i class="fa fa-clock-o"></i></a>&nbsp;<a class="editing-yt" data-id="'.$ytt->topic_id.'" href="javascript:void(0)" alt="Edit" title="Edit"><i class="fa fa-pencil"></i></a>&nbsp;<a class="delete-yt"  data-id="'.$ytt->topic_id.'" href="javascript:void(0)" alt="Delete" title="Delete"><i class="fa fa-trash"></i></a></td>';
}
else
{
if($ytt->topic_created_by == $userdetails->user_id)
{
$htmlmsg.='<td align="left"><a href="#" data-toggle="modal" class="showaction_function"  data-id="'.$ytt->topic_id.'"><i class="fa fa-eye"></i></a></td><td align="right"><a id="commentinfos" data-toggle="modal" class="showcomment_function"  alt="Add/View Comments" title="Add/View Comments" data-id="'.$ytt->topic_id.'" ><i class="fa fa-comment"></i></a>&nbsp;<a class="editing-yt" data-id="'.$ytt->topic_id.'" href="javascript:void(0)" alt="Edit" title="Edit"><i class="fa fa-pencil"></i></a>&nbsp;<a class="delete-yt"  data-id="'.$ytt->topic_id.'" href="javascript:void(0)" alt="Delete" title="Delete"><i class="fa fa-trash"></i></a></td>
';
}
else
{
$htmlmsg.='<td align="left"><a href="#" data-toggle="modal" class="showaction_function"  data-id="'.$ytt->topic_id.'"><i class="fa fa-eye"></i></a></td><td align="right"><a id="commentinfos" data-toggle="modal" class="showcomment_function"  alt="Add/View Comments" title="Add/View Comments" data-id="'.$ytt->topic_id.'" ><i class="fa fa-comment"></i></a>&nbsp;</td>';
}
}
$htmlmsg.='</tr>';


			
$htmlmsg.='</table></div></div>';

$htmlmsg.='</div></li>';
				
								
}
}


// second column details	
$htmlmsg .="__________";


// third column details	



// join query
/*$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['w_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"2")->where('topic_sb_status',"0")->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();*/
$data['w_topics'] =  DB::select('CALL  getSBtopics(?,?,?)',array($request->id,3,0));
// join query



if(count($data['w_topics']) != 0)
{
foreach($data['w_topics'] as $ytt)
{

 if(in_array($ytt->topic_id,$topicid_array))
  {
  	$v2 = 'collapsed';
	$w2 = 'true';
  }
  else
  {
  	$v2 = 'collapse';$w2 = 'false';
  }
  
  
$uid_second = "topic_id_".$ytt->topic_id;
$did=$ytt->topic_id;

$htmlmsg.='<li id='.$uid_second.'><div class="card" style="width: 100%;height:auto;">';

$htmlmsg.='<header class="card-header" style="background-color:'.$ytt->topic_color.'"><a href="#" data-toggle="collapse" data-target="#collapse__'.$ytt->topic_id.'" data-id="'.$ytt->topic_id.'"  id="col_'.$ytt->topic_id.'"  aria-expanded="'.$w2.'" class="mycheck" >';
$htmlmsg.='<span title="'.ucfirst($ytt->topic_name).'">&nbsp;'.str_limit(ucfirst($ytt->topic_name),10).'</span>';
$htmlmsg.='<i class="fa fa-chevron-down" style="float:right; padding-top:5px;"></i> </a></header>';
$htmlmsg.='<div class="'.$v2.'" id="collapse__'.$ytt->topic_id.'" style=""><div class="stackedExistingTopic">';
if($ytt->topic_prevcount != '0')
{
$htmlmsg.='<a href="javascript:void(0)" style="padding:3px" class="re_btn"  title="Merged Topics: '.$ytt->topic_prevnames.'">'.$ytt->topic_prevcount.'</a>';
}
$htmlmsg.='</div>';

$htmlmsg.='<div class="card-body">
<table width="100%" border="0">
<tr><td valign="top" colspan="2" style="font-size:14px;">';




$htmlmsg.='<p align="left">';
if($ytt->topic_discussed_counts != 0)
{
for($i=0;$i<$ytt->topic_discussed_counts;$i++)
{ 
	$htmlmsg.='<i class="fa fa-check" style="color:#006600; font-size:14px;"></i>';
}
}
else
{
$htmlmsg.='</br>'; 	
}
$htmlmsg.='</p>';             
               
$htmlmsg.='<p align="left">';

$i=1; $j=0; $m=0;


if($data['meeting_by']->meeting_name_dsiplay == '1')
{
	$htmlmsg.="&nbsp;".$ytt->user_name;
}
else
{
	$htmlmsg.='</br>';
}

$htmlmsg.='</p></td></tr>';		

if($data['meeting_by']->meeting_host_by == $userdetails->user_id)
{
$htmlmsg.='<span data-id="'.$ytt->topic_id.'" data-info="'.$ytt->topic_id.'"></span>';
}	
else
{
	if($ytt->topic_created_by == $userdetails->user_id)
	{
		$htmlmsg.='<span data-id="'.$ytt->topic_id.'" data-info="'.$ytt->topic_id.'"></span>';
	}
	else
	{
		$htmlmsg.='<span data-id="'.$ytt->topic_id.'" ></span>';
	}	
}






$htmlmsg.='<tr style="background-color:#ecf0f1">';
if($data['meeting_by']->meeting_host_by == $userdetails->user_id)
{
$htmlmsg.='<td align="left"><a data-id="'.$ytt->topic_id.'" class="addaction_function" id="addaction_function" style="cursor:pointer" alt="Add Actions" title="Add Actions"><i class="fa fa-plus"></i></a>&nbsp;<a id="actioninfos" data-toggle="modal" class="showaction_function"   alt="View Actions" title="View Actions" data-id="'.$ytt->topic_id.'" style="cursor:pointer"><i class="fa fa-eye"></i></a></td><td align="right"><a id="commentinfos" data-toggle="modal" class="showcomment_function"   alt="Add/View Comments" title="Add/View Comments" data-id="'.$ytt->topic_id.'" ><i class="fa fa-comment"></i></a>&nbsp;<a class="startagain"  name="startagain" id="startagain" alt="Start Discussion" title="Start Discussion"  data-id="'.$ytt->topic_id.'"><i class="fa fa-clock-o"></i></a>&nbsp;<a class="editing-yt" data-id="'.$ytt->topic_id.'" href="javascript:void(0)" alt="Edit" title="Edit"><i class="fa fa-pencil"></i></a>&nbsp;<a class="delete-yt"  data-id="'.$ytt->topic_id.'" href="javascript:void(0)" alt="Delete" title="Delete"><i class="fa fa-trash"></i></a></td>';
}
else
{
if($ytt->topic_created_by == $userdetails->user_id)
{
$htmlmsg.='<td align="left"><a href="#" data-toggle="modal" class="showaction_function"  data-id="'.$ytt->topic_id.'"><i class="fa fa-eye"></i></a></td><td align="right"><a id="commentinfos" data-toggle="modal" class="showcomment_function"  alt="Add/View Comments" title="Add/View Comments" data-id="'.$ytt->topic_id.'" ><i class="fa fa-comment"></i></a>&nbsp;<a class="editing-yt" data-id="'.$ytt->topic_id.'" href="javascript:void(0)" alt="Edit" title="Edit"><i class="fa fa-pencil"></i></a>&nbsp;<a class="delete-yt"  data-id="'.$ytt->topic_id.'" href="javascript:void(0)" alt="Delete" title="Delete"><i class="fa fa-trash"></i></a></td>
';
}
else
{
$htmlmsg.='<td align="left"><a href="#" data-toggle="modal" class="showaction_function"  data-id="'.$ytt->topic_id.'"><i class="fa fa-eye"></i></a></td><td align="right"><a id="commentinfos" data-toggle="modal" class="showcomment_function"  alt="Add/View Comments" title="Add/View Comments" data-id="'.$ytt->topic_id.'" ><i class="fa fa-comment"></i></a>&nbsp;</td>';
}
}
$htmlmsg.='</tr>';


			
$htmlmsg.='</table></div></div>';

$htmlmsg.='</div></li>';
				
								
}
}


// third column details	


$htmlmsg .="__________";


// fourth column details	



// join query
/*$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['o_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"3")->where('topic_sb_status',"0")->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();*/
$data['o_topics'] =  DB::select('CALL  getSBtopics(?,?,?)',array($request->id,4,0));
// join query



if(count($data['o_topics']) != 0)
{
foreach($data['o_topics'] as $ytt)
{

 if(in_array($ytt->topic_id,$topicid_array))
  {
  	$v3 = 'collapsed';
	$w3 = 'true';
  }
  else
  {
  	$v3 = 'collapse';$w3 = 'false';
  }
  
  
$uid_second = "topic_id_".$ytt->topic_id;
$did=$ytt->topic_id;

$htmlmsg.='<li id='.$uid_second.'><div class="card" style="width: 100%;height:auto;">';

$htmlmsg.='<header class="card-header" style="background-color:'.$ytt->topic_color.'"><a href="#" data-toggle="collapse" data-target="#collapse__'.$ytt->topic_id.'" data-id="'.$ytt->topic_id.'"  id="col_'.$ytt->topic_id.'"  aria-expanded="'.$w3.'" class="mycheck" >';
$htmlmsg.='<span title="'.ucfirst($ytt->topic_name).'">&nbsp;'.str_limit(ucfirst($ytt->topic_name),10).'</span>';
$htmlmsg.='<i class="fa fa-chevron-down" style="float:right; padding-top:5px;"></i> </a></header>';
$htmlmsg.='<div class="'.$v3.'" id="collapse__'.$ytt->topic_id.'" style=""><div class="stackedExistingTopic">';
if($ytt->topic_prevcount != '0')
{
$htmlmsg.='<a href="javascript:void(0)" style="padding:3px" class="re_btn"  title="Merged Topics: '.$ytt->topic_prevnames.'">'.$ytt->topic_prevcount.'</a>';
}
$htmlmsg.='</div>';

$htmlmsg.='<div class="card-body">
<table width="100%" border="0">
<tr><td valign="top" colspan="2" style="font-size:14px;">';




$htmlmsg.='<p align="left">';
if($ytt->topic_discussed_counts != 0)
{
for($i=0;$i<$ytt->topic_discussed_counts;$i++)
{ 
	$htmlmsg.='<i class="fa fa-check" style="color:#006600; font-size:14px;"></i>';
}
}
else
{
$htmlmsg.='</br>'; 	
}
$htmlmsg.='</p>';             
               
$htmlmsg.='<p align="left">';

$i=1; $j=0; $m=0;


if($data['meeting_by']->meeting_name_dsiplay == '1')
{
	$htmlmsg.="&nbsp;".$ytt->user_name;
}
else
{
	$htmlmsg.='</br>';
}

$htmlmsg.='</p></td></tr>';		

if($data['meeting_by']->meeting_host_by == $userdetails->user_id)
{
$htmlmsg.='<span data-id="'.$ytt->topic_id.'" data-info="'.$ytt->topic_id.'"></span>';
}	
else
{
	if($ytt->topic_created_by == $userdetails->user_id)
	{
		$htmlmsg.='<span data-id="'.$ytt->topic_id.'" data-info="'.$ytt->topic_id.'"></span>';
	}
	else
	{
		$htmlmsg.='<span data-id="'.$ytt->topic_id.'" ></span>';
	}	
}






$htmlmsg.='<tr style="background-color:#ecf0f1">';
if($data['meeting_by']->meeting_host_by == $userdetails->user_id)
{
$htmlmsg.='<td align="left"><a data-id="'.$ytt->topic_id.'" class="addaction_function" id="addaction_function" style="cursor:pointer" alt="Add Actions" title="Add Actions"><i class="fa fa-plus"></i></a>&nbsp;<a id="actioninfos" data-toggle="modal" class="showaction_function"   alt="View Actions" title="View Actions" data-id="'.$ytt->topic_id.'" style="cursor:pointer"><i class="fa fa-eye"></i></a></td><td align="right"><a id="commentinfos" data-toggle="modal" class="showcomment_function"   alt="Add/View Comments" title="Add/View Comments" data-id="'.$ytt->topic_id.'" ><i class="fa fa-comment"></i></a>&nbsp;<a class="startagain"  name="startagain" id="startagain" alt="Start Discussion" title="Start Discussion"  data-id="'.$ytt->topic_id.'"><i class="fa fa-clock-o"></i></a>&nbsp;<a class="editing-yt" data-id="'.$ytt->topic_id.'" href="javascript:void(0)" alt="Edit" title="Edit"><i class="fa fa-pencil"></i></a>&nbsp;<a class="delete-yt"  data-id="'.$ytt->topic_id.'" href="javascript:void(0)" alt="Delete" title="Delete"><i class="fa fa-trash"></i></a></td>';
}
else
{
if($ytt->topic_created_by == $userdetails->user_id)
{
$htmlmsg.='<td align="left"><a href="#" data-toggle="modal" class="showaction_function"  data-id="'.$ytt->topic_id.'"><i class="fa fa-eye"></i></a></td><td align="right"><a id="commentinfos" data-toggle="modal" class="showcomment_function"  alt="Add/View Comments" title="Add/View Comments" data-id="'.$ytt->topic_id.'" ><i class="fa fa-comment"></i></a>&nbsp;<a class="editing-yt" data-id="'.$ytt->topic_id.'" href="javascript:void(0)" alt="Edit" title="Edit"><i class="fa fa-pencil"></i></a>&nbsp;<a class="delete-yt"  data-id="'.$ytt->topic_id.'" href="javascript:void(0)" alt="Delete" title="Delete"><i class="fa fa-trash"></i></a></td>
';
}
else
{
$htmlmsg.='<td align="left"><a href="#" data-toggle="modal" class="showaction_function"  data-id="'.$ytt->topic_id.'"><i class="fa fa-eye"></i></a></td><td align="right"><a id="commentinfos" data-toggle="modal" class="showcomment_function"  alt="Add/View Comments" title="Add/View Comments" data-id="'.$ytt->topic_id.'" ><i class="fa fa-comment"></i></a>&nbsp;</td>';
}
}
$htmlmsg.='</tr>';


			
$htmlmsg.='</table></div></div>';

$htmlmsg.='</div></li>';
				
								
}
}


// fourth column details	


$htmlmsg .="__________";


// fifth column details	





$data['discussing_topics_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->count();
if($data['discussing_topics_count'] != 0)
{
$data['discussing_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','2')->orderBy('topics.topic_order','ASC')->first();
$htmlmsg .="__________".$data['discussing_topics_count']."__________".$data['discussing_topics']->topic_time."__________".$data['meeting_by']->meeting_end_status;
}
else
{
$htmlmsg .="__________"."0"."__________"."0"."__________".$data['meeting_by']->meeting_end_status;
}
		
		/*echo $htmlmsg;
		exit();
		*/
		$discuss_status = 0;
		$discuss_status_cnt = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','1')->where('topic_sb_status','2')->where('topic_rem_time','>','1')->count();
		
		$discuss_status_cnt_w = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->where('topic_sb_status','2')->where('topic_rem_time','>','1')->count();
		
		$discuss_status_cnt_o = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->where('topic_sb_status','2')->where('topic_rem_time','>','1')->count();
		
		$discuss_status_cnt_t = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','4')->where('topic_sb_status','2')->where('topic_rem_time','>','1')->count();
		
		
$discuss_status_cnt_pain = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','5')->where('topic_sb_status','2')->where('topic_rem_time','>','1')->count();


		
		
		if($discuss_status_cnt > 0 || $discuss_status_cnt_w > 0 || $discuss_status_cnt_o > 0 || $discuss_status_cnt_t > 0 || $discuss_status_cnt_pain > 0)
		{
			$discuss_status = 1;
		}
		
$currenthost = 0;
		if($user_info->user_id == $data['meeting_by']->meeting_host_by && $data['meeting_by']->meeting_by != $data['meeting_by']->meeting_host_by)
		{
			$currenthost = 1;
		}
		
		// to check removed status
		$currentremvoedstatus = 0;
		$re_status_check = DB::table('attendees_request')->where('remailid',$userdetails->user_emailid)->where('rboardid',$request->id)->where('removedstatus','1')->count();
		if($re_status_check != 0)
		{
			$currentremvoedstatus = 1;
		}	
		// to check removed status
		
		
		// to check removed status
		$currentremvoedstatusguest = 0;
		$reg_status_check = DB::table('guest_request')->where('guserid',$userdetails->user_id)->where('gboardid',$request->id)->where('gremovedstatus','1')->count();
		if($reg_status_check != 0)
		{
			$currentremvoedstatusguest = 1;
		}	
		// to check removed status
				
		
		// show notification when participant enter and exist
		
		// when participant joined and left
		
		$almessage='';		
		$arcount = DB::table('attendees_request')->where('rboardid',$request->id)->where('ronlinestatus','1')->where('astatus','0')->orderBy('rid','DESC')->count(); 
		if($arcount != 0)
		{
			$ar = DB::table('attendees_request')->where('rboardid',$request->id)->where('ronlinestatus','1')->where('astatus','0')->orderBy('rid','DESC')->first(); 
			$aid = $ar->rid;
			$almessage.="<p style='color:#fff; font-size:12px;'>".$ar->remailid." joined the meeting</p>";		
		}
		else
		{
			$aid=0;
		}
		
		
		$aleftmessage='';	
		$arcount_left = DB::table('attendees_request')->where('rboardid',$request->id)->where('leavestatus','1')->where('bstatus','0')->orderBy('rid','DESC')->count(); 
		if($arcount_left != 0)
		{
		$ar_left = DB::table('attendees_request')->where('rboardid',$request->id)->where('leavestatus','1')->where('bstatus','0')->orderBy('rid','DESC')->first(); 
		$aid_left = $ar_left->rid;
		$aleftmessage.="<p style='color:#fff; font-size:12px;'>".$ar_left->remailid." left the meeting</p>";
		}
		else
		{
		$aid_left=0;
		}
		
		
		// when participant joined and left
		
		
		// when guest joined and left
		$guestmessage='';
		$arcount_guest = DB::table('guest_request')->where('gboardid',$request->id)->where('gonlinestatus','1')->where('astatus','0')->orderBy('gid','DESC')->count(); 
		if($arcount_guest != 0)
		{
			$ar_guest = DB::table('guest_request')->where('gboardid',$request->id)->where('gonlinestatus','1')->where('astatus','0')->orderBy('gid','DESC')->first(); 
			// find guest name
			$gname = DB::table('siteusers')->where('user_id',$ar_guest->guserid)->first(); 
			// find guest name
			$aid_guest = $ar_guest->gid;
			$guestmessage.="<p style='color:#fff; font-size:12px;'>".ucfirst($gname->user_name)." joined the meeting</p>";
		}
		else
		{
			$aid_guest=0;
		}		
		
		
		$guestmessage_left='';
		$arcount3 = DB::table('guest_request')->where('gboardid',$request->id)->where('gleavestatus','1')->where('bstatus','0')->orderBy('gid','DESC')->count(); 
		if($arcount3 != 0)
		{
			$ar3 = DB::table('guest_request')->where('gboardid',$request->id)->where('gleavestatus','1')->where('bstatus','0')->orderBy('gid','DESC')->first(); 
			
			// find guest name
			$gname3 = DB::table('siteusers')->where('user_id',$ar3->guserid)->first(); 
			// find guest name

			$aid3 = $ar3->gid;
			$guestmessage_left.="<p style='color:#fff; font-size:12px;'>".ucfirst($gname3->user_name)." left the meeting</p>";
		
		}
		else
		{
			$aid3=0;
		}
				
		
		
		// when guest joined and left
		
		
		
		// show notification when partcipant enter and exist
		
				

				
				
		
		$results=array("count"=>1,"first_second_columns"=>$htmlmsg,"discuss"=>$discuss_status,"meetend"=>$data['meeting_by']->meeting_end_status,"currenthost"=>$currenthost,"currentremvoedstatus"=>$currentremvoedstatus,"currentremvoedstatusguest"=>$currentremvoedstatusguest,"remvotes"=>$data['rem_votes'],"totalvotesfixed"=>$data['meeting_by']->meeting_votes_fixed,"alertmessageinfo"=>$almessage,"alertid"=>$aid,"alert_leftmessageinfo"=>$aleftmessage,"alert_pleftid"=>$aid_left,"alertguestmessageinfo"=>$guestmessage,"alertguestid"=>$aid_guest,"alert_leftguestmessageinfo"=>$guestmessage_left,"alert_gleftid"=>$aid3);//,"alertmessageinfo"=>$almessage,"guestmessageinfo"=>$guestmessage
		return response()->json($results);	

	
	
	
	
}
	
	
	
	
	
	




	public function participantjoinedmessages(Request $request)
	{
		$almessage='';		
		$arcount = DB::table('attendees_request')->where('rboardid',$request->id)->where('ronlinestatus','1')->where('astatus','0')->orderBy('rid','DESC')->count(); 
		if($arcount != 0)
		{
		$ar = DB::table('attendees_request')->where('rboardid',$request->id)->where('ronlinestatus','1')->where('astatus','0')->orderBy('rid','DESC')->first(); 
		$aid = $ar->rid;
		$almessage.="<p style='color:#fff; font-size:12px;'>".$ar->remailid." joined the meeting</p>";		
		}
		else
		{
		$aid=0;
		}
		$results=array("alertmessageinfo"=>$almessage,"alertid"=>$aid);
		return response()->json($results);	
				
	}	
	
	public function changejoinstatusparticipants(Request $request)
	{
		$values = array('astatus' => '1');	DB::table('attendees_request')->where('rid',$request->id)->update($values);	
		return 1;	
	}

	
	public function participantleftmessages(Request $request)
	{
		$almessage='';
		
		$arcount = DB::table('attendees_request')->where('rboardid',$request->id)->where('leavestatus','1')->where('bstatus','0')->orderBy('rid','DESC')->count(); 
		if($arcount != 0)
		{
		$ar = DB::table('attendees_request')->where('rboardid',$request->id)->where('leavestatus','1')->where('bstatus','0')->orderBy('rid','DESC')->first(); 
		$aid = $ar->rid;
		$almessage.="<p style='color:#fff; font-size:12px;'>".$ar->remailid." left the meeting</p>";
		}
		else
		{
		$aid=0;
		}
		$results=array("alertmessageinfo"=>$almessage,"alertid"=>$aid);//,"alertmessageinfo"=>$almessage
		return response()->json($results);		
	}	
	
	public function changeleftstatusparticipants(Request $request)
	{
		$values = array('bstatus' => '1');	DB::table('attendees_request')->where('rid',$request->id)->update($values);	
		return 1;	
	}	
	
	
	public function guestjoinedmessages(Request $request)
	{
		$guestmessage='';
		$arcount = DB::table('guest_request')->where('gboardid',$request->id)->where('gonlinestatus','1')->where('astatus','0')->orderBy('gid','DESC')->count(); 
		if($arcount != 0)
		{
			$ar = DB::table('guest_request')->where('gboardid',$request->id)->where('gonlinestatus','1')->where('astatus','0')->orderBy('gid','DESC')->first(); 
			
			// find guest name
			$gname = DB::table('siteusers')->where('user_id',$ar->guserid)->first(); 
			// find guest name

			$aid = $ar->gid;
			$guestmessage.="<p style='color:#fff; font-size:12px;'>".ucfirst($gname->user_name)." joined the meeting</p>";
		
		}
		else
		{
			$aid=0;
		}
		$results=array("guestmessageinfo"=>$guestmessage,"alertid"=>$aid);//,"alertmessageinfo"=>$almessage
		return response()->json($results);	
					
				
	}
	
	public function changejoinstatusguest(Request $request)
	{
		$values = array('astatus' => '1');	DB::table('guest_request')->where('gid',$request->id)->update($values);	
		return 1;	
	}
		
	
	public function guestleftmessages(Request $request)
	{
		$guestmessage='';
		$arcount = DB::table('guest_request')->where('gboardid',$request->id)->where('gleavestatus','1')->where('bstatus','0')->orderBy('gid','DESC')->count(); 
		if($arcount != 0)
		{
			$ar = DB::table('guest_request')->where('gboardid',$request->id)->where('gleavestatus','1')->where('bstatus','0')->orderBy('gid','DESC')->first(); 
			
			// find guest name
			$gname = DB::table('siteusers')->where('user_id',$ar->guserid)->first(); 
			// find guest name

			$aid = $ar->gid;
			$guestmessage.="<p style='color:#fff; font-size:12px;'>".ucfirst($gname->user_name)." left the meeting</p>";
		
		}
		else
		{
			$aid=0;
		}
		$results=array("guestmessageinfo"=>$guestmessage,"alertid"=>$aid);//,"alertmessageinfo"=>$almessage
		return response()->json($results);
				
	}	
	
	public function changeleftstatusguest(Request $request)
	{
		$values = array('bstatus' => '1');	DB::table('guest_request')->where('gid',$request->id)->update($values);	
		return 1;
	}	
		
	
	public function resettimetozero(Request $request)
	{
	
		$values = array('topic_time' => '0','topic_rem_time' => '0');
		DB::table('topics')->where('topic_id',$request->cur_topicid)->update($values);	
		return 1;		
	}
	

	
		
	public function fifthcolumn_topics_sb(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['yourtopics_oneeee'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','0')->orderBy('topics.topic_order','ASC')->get();
		
		
		
// join query
$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['paininfo_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"5")->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();
// join query

		
		
		$data['discussion_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','1')->orderBy('topics.topic_order','ASC')->get();
		
		$data['discussing_topics_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->count();
		$data['discussed_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','3')->orderBy('topics.topic_order','ASC')->get();				
		$data['discussing_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','2')->orderBy('topics.topic_order','ASC')->first();
		
		if($data['discussing_topics_count'] != 0)
		{
		$data['act_time'] = $data['discussing_topics']->topic_time * 60; 
		}
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();
		
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 
		
				

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = $data['meeting_by']->meeting_votes_fixed - $topic_votes_count;

		// all votes

		$data['all_action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['discussed_topics_tot_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->count();
		
				
		return view('user/fifthcolumn_topics_sb',$data);
		
			
	

	}
	
	
	
	public function sixthcolumn_topics_sb(Request $request)
	{
	

	$this->updateusertime();
		$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['yourtopics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','0')->orderBy('topics.topic_order','ASC')->get();
		
		$data['discussion_topics22222'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','1')->orderBy('topics.topic_order','ASC')->get();
		
		
// join query

$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['gaininfo_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"6")->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();
// join query

		
		$data['discussing_topics_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->count();
		$data['discussed_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','3')->orderBy('topics.topic_order','ASC')->get();				
		$data['discussing_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','2')->orderBy('topics.topic_order','ASC')->first();
		if($data['discussing_topics_count'] != 0)
		{
		$data['act_time'] = $data['discussing_topics']->topic_time * 60; 
		}
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();
		
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 
		
				

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = $data['meeting_by']->meeting_votes_fixed - $topic_votes_count;

		// all votes

		$data['all_action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['discussed_topics_tot_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->count();
		
				
		return view('user/sixthcolumn_topics_sb',$data);
		
			
	
	}	
	
	// old style
	
// old style
	public function firstrow_sailboat_topics(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['yourtopics_oneeee'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','0')->orderBy('topics.topic_order','ASC')->get();
		
		
		
// join query
$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['thinkfeel_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"1")->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();
// join query

		
		
		$data['discussion_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','1')->orderBy('topics.topic_order','ASC')->get();
		
		$data['discussing_topics_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->count();
		$data['discussed_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','3')->orderBy('topics.topic_order','ASC')->get();				
		$data['discussing_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','2')->orderBy('topics.topic_order','ASC')->first();
		
		if($data['discussing_topics_count'] != 0)
		{
		$data['act_time'] = $data['discussing_topics']->topic_time * 60; 
		}
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();
		
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 
		
				

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = $data['meeting_by']->meeting_votes_fixed - $topic_votes_count;

		// all votes

		$data['all_action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['discussed_topics_tot_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->count();
		
				
		return view('user/firstrow_sailboat_topics',$data);
		
			
	

	}
	
	
	
	public function secondrow_sailboat_topics(Request $request)
	{
	

	$this->updateusertime();
		$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['yourtopics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','0')->orderBy('topics.topic_order','ASC')->get();
		
		$data['discussion_topics22222'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','1')->orderBy('topics.topic_order','ASC')->get();
		

		
// join query
$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['see_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"2")->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();
// join query

		
		$data['discussing_topics_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->count();
		$data['discussed_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','3')->orderBy('topics.topic_order','ASC')->get();				
		$data['discussing_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','2')->orderBy('topics.topic_order','ASC')->first();
		if($data['discussing_topics_count'] != 0)
		{
		$data['act_time'] = $data['discussing_topics']->topic_time * 60; 
		}
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();
		
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 
		
				

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = $data['meeting_by']->meeting_votes_fixed - $topic_votes_count;

		// all votes

		$data['all_action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['discussed_topics_tot_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->count();
		
				
		return view('user/secondrow_sailboat_topics',$data);
		
			
	
	}
	
	
	
	
	public function thirdrow_sailboat_topics(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['yourtopics_oneeee'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','0')->orderBy('topics.topic_order','ASC')->get();
		
		
		
// join query
$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['hear_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"3")->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();
// join query

		
		
		$data['discussion_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','1')->orderBy('topics.topic_order','ASC')->get();
		
		$data['discussing_topics_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->count();
		$data['discussed_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','3')->orderBy('topics.topic_order','ASC')->get();				
		$data['discussing_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','2')->orderBy('topics.topic_order','ASC')->first();
		
		if($data['discussing_topics_count'] != 0)
		{
		$data['act_time'] = $data['discussing_topics']->topic_time * 60; 
		}
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();
		
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 
		
				

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = $data['meeting_by']->meeting_votes_fixed - $topic_votes_count;

		// all votes

		$data['all_action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['discussed_topics_tot_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->count();
		
				
		return view('user/thirdrow_sailboat_topics',$data);
		
			
	

	}
	
	
	
	public function fourthrow_sailboat_topics(Request $request)
	{
	

	$this->updateusertime();
		$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['yourtopics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','0')->orderBy('topics.topic_order','ASC')->get();
		
		$data['discussion_topics22222'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','1')->orderBy('topics.topic_order','ASC')->get();
		
		
// join query
$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['saydo_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"4")->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();
// join query

		
		$data['discussing_topics_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->count();
		$data['discussed_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','3')->orderBy('topics.topic_order','ASC')->get();				
		$data['discussing_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','2')->orderBy('topics.topic_order','ASC')->first();
		if($data['discussing_topics_count'] != 0)
		{
		$data['act_time'] = $data['discussing_topics']->topic_time * 60; 
		}
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();
		
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 
		
				

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = $data['meeting_by']->meeting_votes_fixed - $topic_votes_count;

		// all votes

		$data['all_action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['discussed_topics_tot_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->count();
		
				
		return view('user/fourthrow_sailboat_topics',$data);
		
			
	
	}
	

	
	

	
	
		
	
	public function gettopicsdetails(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		$data['meeting_id'] = $request->id;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['yourtopics2'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','0')->orderBy('topic_id','DESC')->get();
		$data['discussion_topics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','1')->orderBy('topic_id','DESC')->get();
		$data['discussing_topics_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->count();
		$data['discussed_topics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->orderBy('topic_id','DESC')->get();		
		$data['discussing_topics'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->first();
		if($data['discussing_topics_count'] != 0)
		{
		$data['act_time'] = $data['discussing_topics']->topic_time * 60; 
		}
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();
		
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 
		
				

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = 3 - $topic_votes_count;

		// all votes

		$data['all_action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['discussed_topics_tot_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->count();
		
				
		return view('user/gettopicsdetails',$data);
		
	}
	
	public function gettopicsonly(Request $request)
	{
		$this->updateusertime();
		$twoleveltopics = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->whereIn('topics.topic_status',[0,1])->orderBy('topics.topic_order','ASC')->pluck("topics.topic_name","topics.topic_id");
		return response()->json($twoleveltopics);
	}
	
	
	// remove guest and show participants and guest list
	public function removepsgetlcbguest_ps_sb(Request $request)
	{
	
	
		$this->updateusertime();
		$user_info = $this->userdetails();
		
		// split userid and meeting id
		$sp = explode("_____",$request->id);
		$me_id = $sp[0];
		$me_uid = $sp[1];
		$at_rid = $sp[2];
		// split userid and meeting id
		
		// remove from meeting
		
		$values = array('gremovedstatus' => '1');
		DB::table('guest_request')->where('gid',$at_rid)->update($values);
		
		
		// remove from meeting
		
		// facilitator details
		$data['bar_info'] = DB::table('boards')->join('siteusers as A' ,'boards.meeting_by','=','A.user_id')->where('boards.meeting_id',$me_id)->first();	
		
		// list of attendees
		//$participants_info_lcb = DB::table('attendees_request')->where('rboardid',$me_id)->get();	
		$participants_info_lcb = DB::table('attendees_request')->join('siteusers as A' ,'attendees_request.remailid','=','A.user_emailid')->where('rboardid',$me_id)->where('attendees_request.ronlinestatus','1')->where('attendees_request.removedstatus','0')->get();	
		// list of attendees
		
		
		
		// if any guest joined
		$rr_no = $data['bar_info']->meeting_rand;
		$checkanyguestcount = DB::table('siteusers')->where('user_emailid','like','%'.$rr_no.'%')->where('user_online','1')->count();
		if($checkanyguestcount != 0)
		{
			$data['showguests'] = 1; 
			//$guestinfos = DB::table('siteusers')->where('user_emailid','like','%'.$rr_no.'%')->where('user_online','1')->get();
			$guestinfos = DB::table('guest_request')->join('siteusers as A' ,'guest_request.guserid','=','A.user_id')->where('gboardid',$me_id)->where('guest_request.gonlinestatus','1')->where('guest_request.gremovedstatus','0')->get();
		}
		else
		{
			$data['showguests'] = 0; 
		}
		// if any guest joined
		
				
				
		$lcbpartcipants = "<table class='table table-bordered'><tr><td colspan=3>".$data['bar_info']->user_name." (Barista)"."</td></tr>";
				
		foreach($participants_info_lcb as $fs)
		{
			$did = $fs->user_id;
			$forid = $me_id."_____".$did;
			$forid2 = $me_id."_____".$did."_____".$fs->rid;
			// total no.votes
			
$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$me_id)->get();

$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$did)->count();	

			
			// total no.votes
			
			
			//$lcbpartcipants.="<tr><td>".$fs->user_name."</td><td><a class='re_btn btn-danger btn-sm make-host'  data-id='$did' href='javascript:void(0)' alt='Make as Host' //title='Make as Host'>Make as Host</a></td></tr>";
			
			if($did == $user_info->user_id)
			{
			//$lcbpartcipants.="<tr><td>".$fs->user_name."</td><td>voted:".$topic_votes_count."</td><td>Host</td></tr>";
			}
			else
			{
			if($topic_votes_count != 0)
			{
			$lcbpartcipants.="<tr><td>".$fs->user_name."</td><td><a class='re_btn btn-danger btn-sm make-host'  data-id='$did' href='javascript:void(0)' alt='Make as Host' title='Make as Host'>Make as Host</a></td><td><a class='re_btn btn-danger btn-sm delete-attendee-ps' data-id='$forid2' href='javascript:void(0)' alt='Remove from meeting' title='Remove from meeting'>X</a></td></tr>";
			}
			else
			{
			$lcbpartcipants.="<tr><td>".$fs->user_name."</td><td><a class='re_btn btn-danger btn-sm make-host'  data-id='$did' href='javascript:void(0)' alt='Make as Host' title='Make as Host'>Make as Host</a></td><td><a class='re_btn btn-danger btn-sm delete-attendee-ps' data-id='$forid2' href='javascript:void(0)' alt='Remove from meeting' title='Remove from meeting'>X</a></td></tr>";
			}	
			}
			//$lcbpartcipants.="";
			
		
		}
		
		if($data['showguests'] == 1)
		{
			
			foreach($guestinfos as $fs)
			{
		
				$did = $fs->user_id;
				$forid = $me_id."_____".$did;
				$forid2 = $me_id."_____".$did."_____".$fs->gid;
			// total no.votes
			
$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$me_id)->get();

$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

$topic_votes_count2 = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$did)->count();	

if($topic_votes_count2 != 0)
{
$lcbpartcipants.="<tr id=user_id_".$did."><td colspan=2>".$fs->user_name." (Guest)"."</td><td>&nbsp;</td>";
}
else
{
$lcbpartcipants.="<tr id=user_id_".$did."><td colspan=2>".$fs->user_name." (Guest)"."</td><td>&nbsp;</td><td><a class='re_btn btn-danger btn-sm delete-guest-ps' data-id='$forid2' href='javascript:void(0)' alt='Remove from meeting' title='Remove from meeting'>X</a></td></tr>";
}
//$lcbpartcipants.="";
		
			}
			
		}
				
		$lcbpartcipants.="</table>";	
				
		return $lcbpartcipants;	
		// facilitator details		
		
	
	
	
	}
	// remove guest and show participants and guest list
	
	// remove participant and show participants and guest list
	public function removepsgetlcbparticipants_ps_sb(Request $request)
	{
	
		$this->updateusertime();
		$user_info = $this->userdetails();
		
		// split userid and meeting id
		$sp = explode("_____",$request->id);
		$me_id = $sp[0];
		$me_uid = $sp[1];
		$at_rid = $sp[2];
		// split userid and meeting id
		
		// remove from meeting
		
		$values = array('removedstatus' => '1');
		DB::table('attendees_request')->where('rid',$at_rid)->update($values);
		
		
		// remove from meeting
		
		// facilitator details
		$data['bar_info'] = DB::table('boards')->join('siteusers as A' ,'boards.meeting_by','=','A.user_id')->where('boards.meeting_id',$me_id)->first();	
		
		// list of attendees
		//$participants_info_lcb = DB::table('attendees_request')->where('rboardid',$me_id)->get();	
		$participants_info_lcb = DB::table('attendees_request')->join('siteusers as A' ,'attendees_request.remailid','=','A.user_emailid')->where('rboardid',$me_id)->where('attendees_request.ronlinestatus','1')->where('attendees_request.removedstatus','0')->get();	
		// list of attendees
		
		
		
		// if any guest joined
		$rr_no = $data['bar_info']->meeting_rand;
		$checkanyguestcount = DB::table('siteusers')->where('user_emailid','like','%'.$rr_no.'%')->where('user_online','1')->count();
		if($checkanyguestcount != 0)
		{
			$data['showguests'] = 1; 
			//$guestinfos = DB::table('siteusers')->where('user_emailid','like','%'.$rr_no.'%')->where('user_online','1')->get();
			$guestinfos = DB::table('guest_request')->join('siteusers as A' ,'guest_request.guserid','=','A.user_id')->where('gboardid',$me_id)->where('guest_request.gonlinestatus','1')->where('guest_request.gremovedstatus','0')->get();
		}
		else
		{
			$data['showguests'] = 0; 
		}
		// if any guest joined
		
				
				
		$lcbpartcipants = "<table class='table table-bordered'><tr><td colspan=3>".$data['bar_info']->user_name." (Barista)"."</td></tr>";
				
		foreach($participants_info_lcb as $fs)
		{
			$did = $fs->user_id;
			$forid = $me_id."_____".$did;
			$forid2 = $me_id."_____".$did."_____".$fs->rid;
			// total no.votes
			
$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$me_id)->get();

$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$did)->count();	

			
			// total no.votes
			
			
			//$lcbpartcipants.="<tr><td>".$fs->user_name."</td><td><a class='re_btn btn-danger btn-sm make-host'  data-id='$did' href='javascript:void(0)' alt='Make as Host' //title='Make as Host'>Make as Host</a></td></tr>";
			
			if($did == $user_info->user_id)
			{
			//$lcbpartcipants.="<tr><td>".$fs->user_name."</td><td>voted:".$topic_votes_count."</td><td>Host</td></tr>";
			}
			else
			{
			if($topic_votes_count != 0)
			{
			$lcbpartcipants.="<tr><td>".$fs->user_name."</td><td><a class='re_btn btn-danger btn-sm make-host'  data-id='$did' href='javascript:void(0)' alt='Make as Host' title='Make as Host'>Make as Host</a></td><td><a class='re_btn btn-danger btn-sm delete-attendee-ps' data-id='$forid2' href='javascript:void(0)' alt='Remove from meeting' title='Remove from meeting'>X</a></td></tr>";
			}
			else
			{
			$lcbpartcipants.="<tr><td>".$fs->user_name."</td><td><a class='re_btn btn-danger btn-sm make-host'  data-id='$did' href='javascript:void(0)' alt='Make as Host' title='Make as Host'>Make as Host</a></td><td><a class='re_btn btn-danger btn-sm delete-attendee-ps' data-id='$forid2' href='javascript:void(0)' alt='Remove from meeting' title='Remove from meeting'>X</a></td></tr>";
			}	
			}
			//$lcbpartcipants.="";
			
		
		}
		
		if($data['showguests'] == 1)
		{
			
			foreach($guestinfos as $fs)
			{
		
				$did = $fs->user_id;
				$forid = $me_id."_____".$did;
				$forid2 = $me_id."_____".$did."_____".$fs->gid;
			// total no.votes
			
$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$me_id)->get();

$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

$topic_votes_count2 = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$did)->count();	

if($topic_votes_count2 != 0)
{
$lcbpartcipants.="<tr id=user_id_".$did."><td colspan=2>".$fs->user_name." (Guest)"."</td><td>&nbsp;</td><td><a class='re_btn btn-danger btn-sm delete-guest-ps' data-id='$forid2' href='javascript:void(0)' alt='Remove from meeting' title='Remove from meeting'>X</a></td></tr>";
}
else
{
$lcbpartcipants.="<tr id=user_id_".$did."><td colspan=2>".$fs->user_name." (Guest)"."</td><td>&nbsp;</td><td><a class='re_btn btn-danger btn-sm delete-guest-ps' data-id='$forid2' href='javascript:void(0)' alt='Remove from meeting' title='Remove from meeting'>X</a></td></tr>";
}
//$lcbpartcipants.="";
		
			}
			
		}
				
		$lcbpartcipants.="</table>";	
				
		return $lcbpartcipants;	
		// facilitator details		
		
	
	}	
	// remove participant and show participants and guest list
	
	
	// reset votes and show participants and guest list
	public function getlcbparticipants_ps_sb(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		
		// split userid and meeting id
		$sp = explode("_____",$request->id);
		$me_id = $sp[0];
		$me_uid = $sp[1];
		// split userid and meeting id
		
		// delete all votes
		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$me_id)->where('topic_status','!=',3)->get();
		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);
		DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$me_uid)->delete();
		
		// delete all votes
		
		// facilitator details
		$data['bar_info'] = DB::table('boards')->join('siteusers as A' ,'boards.meeting_by','=','A.user_id')->where('boards.meeting_id',$me_id)->first();	
		
		// list of attendees
		//$participants_info_lcb = DB::table('attendees_request')->where('rboardid',$me_id)->get();	
		$participants_info_lcb = DB::table('attendees_request')->join('siteusers as A' ,'attendees_request.remailid','=','A.user_emailid')->where('rboardid',$me_id)->where('attendees_request.ronlinestatus','1')->where('attendees_request.removedstatus','0')->get();	
		// list of attendees
		
		
		
		// if any guest joined
		$rr_no = $data['bar_info']->meeting_rand;
		$checkanyguestcount = DB::table('siteusers')->where('user_emailid','like','%'.$rr_no.'%')->where('user_online','1')->count();
		if($checkanyguestcount != 0)
		{
			$data['showguests'] = 1; 
			//$guestinfos = DB::table('siteusers')->where('user_emailid','like','%'.$rr_no.'%')->where('user_online','1')->get();
			$guestinfos = DB::table('guest_request')->join('siteusers as A' ,'guest_request.guserid','=','A.user_id')->where('gboardid',$me_id)->where('guest_request.gonlinestatus','1')->where('guest_request.gremovedstatus','0')->get();
		}
		else
		{
			$data['showguests'] = 0; 
		}
		// if any guest joined
		
				
				
		$lcbpartcipants = "<table class='table table-bordered'><tr><td colspan=3>".$data['bar_info']->user_name." (Barista)"."</td></tr>";
				
		foreach($participants_info_lcb as $fs)
		{
			$did = $fs->user_id;
			$forid = $me_id."_____".$did;
			$forid2 = $me_id."_____".$did."_____".$fs->rid;
			// total no.votes
			
$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$me_id)->get();

$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$did)->count();	

			
			// total no.votes
			
			
			//$lcbpartcipants.="<tr><td>".$fs->user_name."</td><td><a class='re_btn btn-danger btn-sm make-host'  data-id='$did' href='javascript:void(0)' alt='Make as Host' //title='Make as Host'>Make as Host</a></td></tr>";
			
			if($did == $user_info->user_id)
			{
			//$lcbpartcipants.="<tr><td>".$fs->user_name."</td><td>voted:".$topic_votes_count."</td><td>Host</td></tr>";
			}
			else
			{
			if($topic_votes_count != 0)
			{
			$lcbpartcipants.="<tr><td>".$fs->user_name."</td><td><a class='re_btn btn-danger btn-sm make-host'  data-id='$did' href='javascript:void(0)' alt='Make as Host' title='Make as Host'>Make as Host</a></td><td><a class='re_btn btn-danger btn-sm delete-attendee-ps' data-id='$forid2' href='javascript:void(0)' alt='Remove from meeting' title='Remove from meeting'>X</a></td></tr>";
			}
			else
			{
			$lcbpartcipants.="<tr><td>".$fs->user_name."</td><td><a class='re_btn btn-danger btn-sm make-host'  data-id='$did' href='javascript:void(0)' alt='Make as Host' title='Make as Host'>Make as Host</a></td><td><a class='re_btn btn-danger btn-sm delete-attendee-ps' data-id='$forid2' href='javascript:void(0)' alt='Remove from meeting' title='Remove from meeting'>X</a></td></tr>";
			}	
			}
			//$lcbpartcipants.="";
			
		
		}
		
		if($data['showguests'] == 1)
		{
			
			foreach($guestinfos as $fs)
			{
		
					$did = $fs->user_id;
					$forid = $me_id."_____".$did;
					$forid2 = $me_id."_____".$did."_____".$fs->gid;
			// total no.votes
			
$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$me_id)->get();

$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

$topic_votes_count2 = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$did)->count();	

if($topic_votes_count2 != 0)
{
$lcbpartcipants.="<tr id=user_id_".$did."><td colspan=2>".$fs->user_name." (Guest)"."</td><td><a class='re_btn btn-danger btn-sm delete-guest-ps' data-id='$forid2' href='javascript:void(0)' alt='Remove from meeting' title='Remove from meeting'>X</a></td></tr>";
}
else
{
$lcbpartcipants.="<tr id=user_id_".$did."><td colspan=2>".$fs->user_name." (Guest)"."</td><td><a class='re_btn btn-danger btn-sm delete-guest-ps' data-id='$forid2' href='javascript:void(0)' alt='Remove from meeting' title='Remove from meeting'>X</a></td></tr>";
}
//$lcbpartcipants.="";
		
			}
			
		}
				
		$lcbpartcipants.="</table>";	
				
		return $lcbpartcipants;	
		// facilitator details		
		
	}
	// reset votes and show participants and guest list
		

	// get all participants and guest list	
	public function getlcbparticipants_sb(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		// facilitator details
		$data['bar_info'] = DB::table('boards')->join('siteusers as A' ,'boards.meeting_by','=','A.user_id')->where('boards.meeting_id',$request->id)->first();	
		
		// list of attendees
		//$participants_info_lcb = DB::table('attendees_request')->where('rboardid',$request->id)->get();	
		$participants_info_lcb = DB::table('attendees_request')->join('siteusers as A' ,'attendees_request.remailid','=','A.user_emailid')->where('rboardid',$request->id)->where('attendees_request.ronlinestatus','1')->where('A.user_online','1')->where('attendees_request.removedstatus','0')->get();

		// list of attendees
		
		
		
		// if any guest joined
		$rr_no = $data['bar_info']->meeting_rand;
		$checkanyguestcount = DB::table('siteusers')->where('user_emailid','like','%'.$rr_no.'%')->where('user_online','1')->count();
		if($checkanyguestcount != 0)
		{
			$data['showguests'] = 1; 
			//$guestinfos = DB::table('siteusers')->where('user_emailid','like','%'.$rr_no.'%')->where('user_online','1')->get();
			$guestinfos = DB::table('guest_request')->join('siteusers as A' ,'guest_request.guserid','=','A.user_id')->where('gboardid',$request->id)->where('guest_request.gonlinestatus','1')->where('guest_request.gremovedstatus','0')->where('A.user_online','1')->get();
		}
		else
		{
			$data['showguests'] = 0; 
		}
		// if any guest joined
		
				
				
		$lcbpartcipants = "<table class='table table-bordered'><tr><td colspan=3>".$data['bar_info']->user_name." (Barista)"."</td></tr>";
				
		foreach($participants_info_lcb as $fs)
		{
		
			$did = $fs->user_id;
			$forid = $request->id."_____".$did;
			$forid2 = $request->id."_____".$did."_____".$fs->rid;
			// total no.votes
	

		
$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();

$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$did)->count();	

			
			// total no.votes
			
			

			
			if($did == $user_info->user_id)
			{
			//$lcbpartcipants.="<tr><td>".$fs->user_name."</td><td>voted:".$topic_votes_count."</td><td>Host</td></tr>";
			}
			else
			{
			if($topic_votes_count != 0)
			{
			$lcbpartcipants.="<tr id=user_id_".$did."><td>".$fs->user_name."</td><td><a class='re_btn btn-danger btn-sm make-host'  data-id='$did' href='javascript:void(0)' alt='Make as Host' title='Make as Host'>Make as Host</a></td><td><a class='re_btn btn-danger btn-sm delete-attendee-ps' data-id='$forid2' href='javascript:void(0)' alt='Remove from meeting' title='Remove from meeting'>X</a></td></tr>";
			}
			else
			{
			$lcbpartcipants.="<tr><td>".$fs->user_name."</td><td><a class='re_btn btn-danger btn-sm make-host'  data-id='$did' href='javascript:void(0)' alt='Make as Host' title='Make as Host'>Make as Host</a></td><td><a class='re_btn btn-danger btn-sm delete-attendee-ps' data-id='$forid2' href='javascript:void(0)' alt='Remove from meeting' title='Remove from meeting'>X</a></td></tr>";
			}	
			}
			
			
		
		}
		
		
		if($data['showguests'] == 1)
		{
			
			foreach($guestinfos as $fs)
			{
		
			$did = $fs->user_id;
			$forid = $request->id."_____".$did;
			$forid2 = $request->id."_____".$did."_____".$fs->gid;
			// total no.votes
			
$data['mytopics2'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();

$data['all_topic_ids2'] = json_decode(json_encode($data['mytopics2']), true);

$topic_votes_count2 = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids2'])->where('vuserid',$did)->count();	

		
		if($topic_votes_count2 != 0)
{
$lcbpartcipants.="<tr id=user_id_".$did."><td colspan=2>".$fs->user_name." (Guest)"."</td><td><a class='re_btn btn-danger btn-sm delete-guest-ps' data-id='$forid2' href='javascript:void(0)' alt='Remove from meeting' title='Remove from meeting'>X</a></td></tr>";
}
else
{
$lcbpartcipants.="<tr id=user_id_".$did."><td colspan=2>".$fs->user_name." (Guest)"."</td><td><a class='re_btn btn-danger btn-sm delete-guest-ps' data-id='$forid2' href='javascript:void(0)' alt='Remove from meeting' title='Remove from meeting'>X</a></td></tr>";
}
//$lcbpartcipants.="";
		
			}
			
		}
				
		$lcbpartcipants.="</table>";	
				
		return $lcbpartcipants;	
		// facilitator details		
		
	}
	// get all participants and guest list	
	
	
	public function makehost(Request $request)
	{

		$values = array('meeting_host_by' => $request->id);
		$tt = DB::table('boards')->where([["meeting_id","=",$request->mid]])->update($values);
		
		return 1;
	}
	
	public function takehost(Request $request)
	{

		$values = array('meeting_host_by' => $request->id);
		$tt = DB::table('boards')->where([["meeting_id","=",$request->mid]])->update($values);
		
		return 1;
	}
	
	
	public function leavemeetingnow(Request $request)
	{
		$nuserid = $request->id;
		$userinfonow = DB::table('siteusers')->where('user_id',$nuserid)->first();
		$emid = $userinfonow->user_emailid;
		if($userinfonow->user_type == '3')
		{
			$values = array('gleavestatus' => '1','astatus' => '0','gonlinestatus' => '0');
			$tt = DB::table('guest_request')->where([["guserid",$nuserid]])->where([["gboardid",$request->mid]])->update($values);			
		}
		else
		{
			$values = array('leavestatus' => '1','astatus' => '0','ronlinestatus' => '0');
			$tt = DB::table('attendees_request')->where([["remailid","=",$emid]])->where([["rboardid",$request->mid]])->update($values);				
		}
		return 1;
		
	}
		
		
	
	public function sailboatdiscussion(Request $request)
	{
	
	
	
		$this->updateusertime();
		
		
		
		
		
		$user_info = $this->userdetails();
		$data['userinfo'] = $this->userdetails();
			
		$data['meeting_id'] = $request->id;		
		
		// list of attendees
		$data['participants_info_lcb'] = DB::table('attendees_request')->where('rboardid',$request->id)->get();	
		// list of attendees
				
		$ifexist = DB::table('boards')->where('meeting_id',$request->id)->count();
		
		if($ifexist == 0)
		{
			if($user_info->user_type == 2)
			{
				return redirect('/attendeehome');
			}
			if($user_info->user_type == 1)
			{
			
				return redirect('/boards');
			}
			
			if($user_info->user_type == 3)
			{
				$ifanyboards = DB::table('boards')->where('meeting_id',$request->id)->where('meeting_no_guests','0')->count();	
				if($ifanyboards == 0)
				{
					session()->put('lcbuser_id','');			
					session()->put('lcbuser_name','');
					session()->put('lcbuser_ftype','');		
					return redirect('/index');
				}
			}
			
			
		}
		
				
		//$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		$meetingby =  DB::select('CALL  getMeetingBy(?)',array($request->id));
		$data['meeting_by'] = $meetingby[0];
				
		
		$checkalreadyonlinestatus = DB::table('attendees_request')->where([["rboardid","=",$request->id]])->where([["remailid","=",$user_info->user_emailid]])->first();
		
		if($user_info->user_type != 3)
		{
		if($data['meeting_by']->meeting_by != $user_info->user_id)
		{		
			if($checkalreadyonlinestatus->ronlinestatus == 0)
			{				
			//$this->updateattendeestatus($request->id,$user_info->user_id);
				$values = array('ronlinestatus' => '1','leavestatus' => '0','astatus' => '0','bstatus' => '0');
				DB::table('attendees_request')->where([["rboardid","=",$request->id]])->where([["remailid","=",$user_info->user_emailid]])->update($values);				
			}
		}
		}

		if($user_info->user_type == 2)
		{
			$ifanyboards = DB::table('attendees_request')->where('rboardid',$request->id)->where('remailid',$user_info->user_emailid)->count();	//->where('rstatus','1')
			if($ifanyboards == 0)
			{
				return redirect('/attendeehome');
			}
		}
		
		
		if($user_info->user_type == 1 and $data['meeting_by']->meeting_by != $user_info->user_id)
		{
			$ifanyboards = DB::table('attendees_request')->where('rboardid',$request->id)->where('remailid',$user_info->user_emailid)->where('rstatus','1')->count();	
			if($ifanyboards == 0)
			{
				return redirect('/boards');
			}			
		}		
		
		
		if($user_info->user_type == 3)
		{
			$ifanyboards = DB::table('boards')->where('meeting_id',$request->id)->where('meeting_no_guests','0')->count();	
			if($ifanyboards == 0)
			{
				session()->put('lcbuser_id','');			
				session()->put('lcbuser_name','');
				session()->put('lcbuser_ftype','');		
				return redirect('/index');
			}
		}	
		
		if($user_info->user_type == 1 and $data['meeting_by']->meeting_by == $user_info->user_id)
		{
			$subscription_info = $this->subscriptiondetails();
			if($subscription_info->sstatus == 0)
			{
				return redirect('/boards')->with("error","Your current subscription was cancelled. So you can't start discussion.");;
			}
		}	

		// to check removed status
		$re_status_check = DB::table('attendees_request')->where('remailid',$user_info->user_emailid)->where('rboardid',$request->id)->where('removedstatus','1')->count();
		if($re_status_check != 0)
		{
		
			if($user_info->user_type == 2)
			{				
				return redirect('/yourboards')->with("error","Sorry you are removed from this meeting!!!");
			}
			if($user_info->user_type == 1)
			{
			
				return redirect('/boards')->with("error","Sorry you are removed from this meeting!!!");
			}
			
			
		}	
		// to check removed status
		

		
		// all votes		
		//$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();

		$data['mytopics'] =  DB::select('CALL getTopicsbymeetingid(?)',array($request->id));
		
		
		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		
		$data['rem_votes'] = $data['meeting_by']->meeting_votes_fixed - $topic_votes_count;

		// all votes
		
				
					
		$data['soundlists'] = DB::select('CALL getSounds()');
		
		

		
		if($data['meeting_by']->meeting_conf_link != '')
		{
			$conf_link = explode("j/",$data['meeting_by']->meeting_conf_link);
			$data['agenda_conf_linkinfo'] = $conf_link[1];		
		}	
		else
		{
			$data['agenda_conf_linkinfo'] = '';	
		}	
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['selsound'] = DB::table('sounds')->where('mid',$data['meeting_by']->meeting_sound)->first();
		
		$data['selsound_count'] = DB::table('sounds')->where('mid',$data['meeting_by']->meeting_sound)->count();
		
		$data['yourtopicsnew'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','0')->orderBy('topic_id','DESC')->get();
		
		// only two levels
		$data['twoleveltopics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->whereIn('topics.topic_status',[0,1])->orderBy('topics.topic_order','ASC')->get();
		$data['twoleveltopics_count'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->whereIn('topics.topic_status',[0,1])->orderBy('topics.topic_order','ASC')->count();
		// only two levels
		
		$data['yourtopics_old'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','0')->orderBy('topics.topic_order','ASC')->get();
	

$data['yourtopics'] =  DB::select('CALL  getSBtopics(?,?,?)',array($request->id,0,0));
$data['v_topics'] =  DB::select('CALL  getSBtopics(?,?,?)',array($request->id,1,0));
$data['tg_topics'] =  DB::select('CALL  getSBtopics(?,?,?)',array($request->id,2,0));
$data['n_topics'] =  DB::select('CALL  getSBtopics(?,?,?)',array($request->id,3,0));
$data['p_topics'] =  DB::select('CALL  getSBtopics(?,?,?)',array($request->id,4,0));


		
/*$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['yourtopics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"0")->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();

		
$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['s_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"1")->where('topics.topic_sb_status','0')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();


$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['w_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"2")->where('topics.topic_sb_status','0')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();


$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['o_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"3")->where('topics.topic_sb_status','0')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();

$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['t_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"4")->where('topics.topic_sb_status','0')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();


$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['pain_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"5")->where('topics.topic_sb_status','0')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();


$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['gain_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"6")->where('topics.topic_sb_status','0')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();*/






$count_s_topics =  DB::select('CALL getRunningsbtopics(?,?,?)',array($request->id,1,2));
$data['discussing_topics_count_fc']	= count($count_s_topics);
if(count($count_s_topics) != 0)
{
$s_topics_running =  DB::select('CALL getSBtopics(?,?,?)',array($request->id,1,2));
$data['discussing_topics_fc'] = $s_topics_running[0];
}

$count_w_topics =  DB::select('CALL getRunningsbtopics(?,?,?)',array($request->id,2,2));
$data['discussing_topics_count_fc_w']	= count($count_w_topics);
if(count($count_w_topics) != 0)
{
$w_topics_running =  DB::select('CALL getSBtopics(?,?,?)',array($request->id,2,2));
$data['discussing_topics_fc_w'] = $w_topics_running[0];
}
	
$count_o_topics =  DB::select('CALL getRunningsbtopics(?,?,?)',array($request->id,3,2));
$data['discussing_topics_count_fc_o']	= count($count_o_topics);
if(count($count_o_topics) != 0)
{
$o_topics_running =  DB::select('CALL getSBtopics(?,?,?)',array($request->id,3,2));
$data['discussing_topics_fc_o'] = $o_topics_running[0];
}

$count_t_topics =  DB::select('CALL getRunningsbtopics(?,?,?)',array($request->id,4,2));
$data['discussing_topics_count_fc_t']	= count($count_t_topics);
if(count($count_t_topics) != 0)
{
$t_topics_running =  DB::select('CALL getSBtopics(?,?,?)',array($request->id,4,2));
$data['discussing_topics_fc_t'] = $t_topics_running[0];
}



		if($data['discussing_topics_count_fc'] != 0)
		{
			$data['act_time'] = $data['discussing_topics_fc']->topic_time * 60; 
		}
		if($data['discussing_topics_count_fc_w'] != 0)
		{
			$data['act_time'] = $data['discussing_topics_fc_w']->topic_time * 60; 
		}	
		if($data['discussing_topics_count_fc_o'] != 0)
		{
			$data['act_time'] = $data['discussing_topics_fc_o']->topic_time * 60; 
		}
		if($data['discussing_topics_count_fc_t'] != 0)
		{
			$data['act_time'] = $data['discussing_topics_fc_t']->topic_time * 60; 
		}	

		
						
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();
		
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 
		
				

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = $data['meeting_by']->meeting_votes_fixed - $topic_votes_count;

		// all votes


		
		$data['all_action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['discussed_topics_tot_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->count();
		
		$discuss_status = 0;
		$discuss_status_cnt = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_sb_status','2')->where('topic_rem_time','>','1')->count();
		if($discuss_status_cnt > 0)
		{
			$discuss_status = 1;
		}
		
		$data['discuss'] = $discuss_status;
		$data['meetend'] = $data['meeting_by']->meeting_end_status;
		$data['currenthost'] = 0;
		if($user_info->user_id == $data['meeting_by']->meeting_host_by && $data['meeting_by']->meeting_by != $data['meeting_by']->meeting_host_by)
		{
			$data['currenthost'] = 1;
		}
		

				
		return view('user/sailboatdiscussion',$data);
		
	
	
	}
	
	
	public function emapdiscussion(Request $request)
	{
	
	
		$this->updateusertime();
		
		
		
		
		
		$user_info = $this->userdetails();
		$data['userinfo'] = $this->userdetails();
			
		$data['meeting_id'] = $request->id;		
		
		// list of attendees
		$data['participants_info_lcb'] = DB::table('attendees_request')->where('rboardid',$request->id)->get();	
		// list of attendees
				
		$ifexist = DB::table('boards')->where('meeting_id',$request->id)->count();
		
		if($ifexist == 0)
		{
			if($user_info->user_type == 2)
			{
				return redirect('/attendeehome');
			}
			if($user_info->user_type == 1)
			{
			
				return redirect('/boards');
			}
			
			if($user_info->user_type == 3)
			{
				$ifanyboards = DB::table('boards')->where('meeting_id',$request->id)->where('meeting_no_guests','0')->count();	
				if($ifanyboards == 0)
				{
					session()->put('lcbuser_id','');			
					session()->put('lcbuser_name','');
					session()->put('lcbuser_ftype','');		
					return redirect('/index');
				}
			}
			
			
		}
		
				
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		
		$checkalreadyonlinestatus = DB::table('attendees_request')->where([["rboardid","=",$request->id]])->where([["remailid","=",$user_info->user_emailid]])->first();
		
		if($user_info->user_type != 3)
		{
		if($data['meeting_by']->meeting_by != $user_info->user_id)
		{		
			if($checkalreadyonlinestatus->ronlinestatus == 0)
			{				
			//$this->updateattendeestatus($request->id,$user_info->user_id);
				$values = array('ronlinestatus' => '1','leavestatus' => '0','astatus' => '0','bstatus' => '0');
				DB::table('attendees_request')->where([["rboardid","=",$request->id]])->where([["remailid","=",$user_info->user_emailid]])->update($values);				
			}
		}
		}

		if($user_info->user_type == 2)
		{
			$ifanyboards = DB::table('attendees_request')->where('rboardid',$request->id)->where('remailid',$user_info->user_emailid)->count();	//->where('rstatus','1')
			if($ifanyboards == 0)
			{
				return redirect('/attendeehome');
			}
		}
		
		
		if($user_info->user_type == 1 and $data['meeting_by']->meeting_by != $user_info->user_id)
		{
			$ifanyboards = DB::table('attendees_request')->where('rboardid',$request->id)->where('remailid',$user_info->user_emailid)->where('rstatus','1')->count();	
			if($ifanyboards == 0)
			{
				return redirect('/boards');
			}			
		}		
		
		
		if($user_info->user_type == 3)
		{
			$ifanyboards = DB::table('boards')->where('meeting_id',$request->id)->where('meeting_no_guests','0')->count();	
			if($ifanyboards == 0)
			{
				session()->put('lcbuser_id','');			
				session()->put('lcbuser_name','');
				session()->put('lcbuser_ftype','');		
				return redirect('/index');
			}
		}	
		
		if($user_info->user_type == 1 and $data['meeting_by']->meeting_by == $user_info->user_id)
		{
			$subscription_info = $this->subscriptiondetails();
			if($subscription_info->sstatus == 0)
			{
				return redirect('/boards')->with("error","Your current subscription was cancelled. So you can't start discussion.");;
			}
		}	

		// to check removed status
		$re_status_check = DB::table('attendees_request')->where('remailid',$user_info->user_emailid)->where('rboardid',$request->id)->where('removedstatus','1')->count();
		if($re_status_check != 0)
		{
		
			if($user_info->user_type == 2)
			{				
				return redirect('/yourboards')->with("error","Sorry you are removed from this meeting!!!");
			}
			if($user_info->user_type == 1)
			{
			
				return redirect('/boards')->with("error","Sorry you are removed from this meeting!!!");
			}
			
			
		}	
		// to check removed status
		

		
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		
		$data['rem_votes'] = $data['meeting_by']->meeting_votes_fixed - $topic_votes_count;

		// all votes
		
				
					
		$data['soundlists'] = DB::table('sounds')->get();
		
		

		
		if($data['meeting_by']->meeting_conf_link != '')
		{
			$conf_link = explode("j/",$data['meeting_by']->meeting_conf_link);
			$data['agenda_conf_linkinfo'] = $conf_link[1];		
		}	
		else
		{
			$data['agenda_conf_linkinfo'] = '';	
		}	
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['selsound'] = DB::table('sounds')->where('mid',$data['meeting_by']->meeting_sound)->first();
		
		$data['selsound_count'] = DB::table('sounds')->where('mid',$data['meeting_by']->meeting_sound)->count();
		
		$data['yourtopicsnew'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','0')->orderBy('topic_id','DESC')->get();
		
		// only two levels
		$data['twoleveltopics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->whereIn('topics.topic_status',[0,1])->orderBy('topics.topic_order','ASC')->get();
		$data['twoleveltopics_count'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->whereIn('topics.topic_status',[0,1])->orderBy('topics.topic_order','ASC')->count();
		// only two levels
		
		$data['yourtopics_old'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','0')->orderBy('topics.topic_order','ASC')->get();
		
$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['yourtopics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"0")->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();

		$data['discussion_topics_oldone'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','1')->orderBy('topics.topic_order','ASC')->get();
		
		
$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['s_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"1")->where('topics.topic_sb_status','0')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();


$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['w_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"2")->where('topics.topic_sb_status','0')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();


$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['o_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"3")->where('topics.topic_sb_status','0')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();

$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['t_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"4")->where('topics.topic_sb_status','0')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();


$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['pain_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"5")->where('topics.topic_sb_status','0')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();


$duprecname = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['gain_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"6")->where('topics.topic_sb_status','0')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname,'duprecname', function ($leftJoin) {
$leftJoin->on('duprecname.vtopicid', '=', 'topics.topic_id');
})->orderBy('topics..topic_order','ASC')->get();

		
		
$data['discussing_topics_count_fc'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','1')->where('topic_sb_status','2')->orderBy('topic_id','DESC')->count();
$data['discussing_topics_count_fc_w'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->where('topic_sb_status','2')->orderBy('topic_id','DESC')->count();
$data['discussing_topics_count_fc_o'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->where('topic_sb_status','2')->orderBy('topic_id','DESC')->count();
$data['discussing_topics_count_fc_t'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','4')->where('topic_sb_status','2')->orderBy('topic_id','DESC')->count();
$data['discussing_topics_count_fc_pain'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','5')->where('topic_sb_status','2')->orderBy('topic_id','DESC')->count();
$data['discussing_topics_count_fc_gain'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','6')->where('topic_sb_status','2')->orderBy('topic_id','DESC')->count();

		$data['discussed_topics_oldone'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','3')->orderBy('topics.topic_order','ASC')->get();
		
		
$duprecname3 = DB::table('topics_votes')->selectRaw('count(*) as TV,vtopicid')->groupBy('vtopicid');
$tablename = 'topics';
$data['discussed_topics'] = DB::table($tablename)->where('topic_meeting_id',$request->id)->where('topic_status',"3")->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')
->leftJoinSub($duprecname3,'duprecname3', function ($leftJoin) {
$leftJoin->on('duprecname3.vtopicid', '=', 'topics.topic_id');
})->orderBy('TV','DESC')->get();

		
				
$data['discussing_topics_fc'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','1')->where('topics.topic_sb_status','2')->orderBy('topics.topic_order','ASC')->first();

$data['discussing_topics_fc_w'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','2')->where('topics.topic_sb_status','2')->orderBy('topics.topic_order','ASC')->first();

$data['discussing_topics_fc_o'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','3')->where('topics.topic_sb_status','2')->orderBy('topics.topic_order','ASC')->first();

$data['discussing_topics_fc_t'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','4')->where('topics.topic_sb_status','2')->orderBy('topics.topic_order','ASC')->first();

$data['discussing_topics_fc_pain'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','5')->where('topics.topic_sb_status','2')->orderBy('topics.topic_order','ASC')->first();

$data['discussing_topics_fc_gain'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','6')->where('topics.topic_sb_status','2')->orderBy('topics.topic_order','ASC')->first();

		
		if($data['discussing_topics_count_fc'] != 0)
		{
			$data['act_time'] = $data['discussing_topics_fc']->topic_time * 60; 
		}
		if($data['discussing_topics_count_fc_w'] != 0)
		{
			$data['act_time'] = $data['discussing_topics_fc_w']->topic_time * 60; 
		}	
		if($data['discussing_topics_count_fc_o'] != 0)
		{
			$data['act_time'] = $data['discussing_topics_fc_o']->topic_time * 60; 
		}
		if($data['discussing_topics_count_fc_t'] != 0)
		{
			$data['act_time'] = $data['discussing_topics_fc_t']->topic_time * 60; 
		}	
		if($data['discussing_topics_count_fc_pain'] != 0)
		{
			$data['act_time'] = $data['discussing_topics_fc_pain']->topic_time * 60; 
		}
		if($data['discussing_topics_count_fc_gain'] != 0)
		{
			$data['act_time'] = $data['discussing_topics_fc_gain']->topic_time * 60; 
		}
						
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();
		
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 
		
				

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = $data['meeting_by']->meeting_votes_fixed - $topic_votes_count;

		// all votes


		
		$data['all_action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['discussed_topics_tot_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->count();
		
		$discuss_status = 0;
		$discuss_status_cnt = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_sb_status','2')->where('topic_rem_time','>','1')->count();
		if($discuss_status_cnt > 0)
		{
			$discuss_status = 1;
		}
		
		$data['discuss'] = $discuss_status;
		$data['meetend'] = $data['meeting_by']->meeting_end_status;
		$data['currenthost'] = 0;
		if($user_info->user_id == $data['meeting_by']->meeting_host_by && $data['meeting_by']->meeting_by != $data['meeting_by']->meeting_host_by)
		{
			$data['currenthost'] = 1;
		}
		

				
		return view('user/empathymap',$data);
		
	
	}
	
	
	
public function discussion11(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		$data['userinfo'] = $this->userdetails();
			
		$data['meeting_id'] = $request->id;		
		
		// list of attendees
		$data['participants_info_lcb'] = DB::table('attendees_request')->where('rboardid',$request->id)->get();	
		// list of attendees
				
		$ifexist = DB::table('boards')->where('meeting_id',$request->id)->count();
		
		if($ifexist == 0)
		{
			if($user_info->user_type == 2)
			{
				return redirect('/attendeehome');
			}
			if($user_info->user_type == 1)
			{
			
				return redirect('/boards');
			}
			
			if($user_info->user_type == 3)
			{
				$ifanyboards = DB::table('boards')->where('meeting_id',$request->id)->where('meeting_no_guests','0')->count();	
				if($ifanyboards == 0)
				{
					session()->put('lcbuser_id','');			
					session()->put('lcbuser_name','');
					session()->put('lcbuser_ftype','');		
					return redirect('/index');
				}
			}
			
			
		}
		
				
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		
		
		
		if($user_info->user_type == 2)
		{
			$ifanyboards = DB::table('attendees_request')->where('rboardid',$request->id)->where('remailid',$user_info->user_emailid)->count();	//->where('rstatus','1')
			if($ifanyboards == 0)
			{
				return redirect('/attendeehome');
			}
		}
		
		
		if($user_info->user_type == 1 and $data['meeting_by']->meeting_by != $user_info->user_id)
		{
			$ifanyboards = DB::table('attendees_request')->where('rboardid',$request->id)->where('remailid',$user_info->user_emailid)->where('rstatus','1')->count();	
			if($ifanyboards == 0)
			{
				return redirect('/boards');
			}			
		}		
		
		
		if($user_info->user_type == 3)
		{
			$ifanyboards = DB::table('boards')->where('meeting_id',$request->id)->where('meeting_no_guests','0')->count();	
			if($ifanyboards == 0)
			{
				session()->put('lcbuser_id','');			
				session()->put('lcbuser_name','');
				session()->put('lcbuser_ftype','');		
				return redirect('/index');
			}
		}	
		
		if($user_info->user_type == 1 and $data['meeting_by']->meeting_by == $user_info->user_id)
		{
			$subscription_info = $this->subscriptiondetails();
			if($subscription_info->sstatus == 0)
			{
				return redirect('/boards')->with("error","Your current subscription was cancelled. So you can't start discussion.");;
			}
		}	
		
			
		
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = 3 - $topic_votes_count;

		// all votes
		
				
					
		$data['soundlists'] = DB::table('sounds')->get();
		
		

		
		if($data['meeting_by']->meeting_conf_link != '')
		{
			$conf_link = explode("j/",$data['meeting_by']->meeting_conf_link);
			$data['agenda_conf_linkinfo'] = $conf_link[1];		
		}	
		else
		{
			$data['agenda_conf_linkinfo'] = '';	
		}	
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','2')->first();
		
		$data['selsound'] = DB::table('sounds')->where('mid',$data['meeting_by']->meeting_sound)->first();
		
		$data['selsound_count'] = DB::table('sounds')->where('mid',$data['meeting_by']->meeting_sound)->count();
		
		$data['yourtopicsnew'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','0')->orderBy('topic_id','DESC')->get();
		
		// only two levels
		$data['twoleveltopics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->whereIn('topics.topic_status',[0,1])->orderBy('topics.topic_order','ASC')->get();
		$data['twoleveltopics_count'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->whereIn('topics.topic_status',[0,1])->orderBy('topics.topic_order','ASC')->count();
		// only two levels
		
		$data['yourtopics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','0')->orderBy('topics.topic_order','ASC')->get();
		
		$data['discussion_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','1')->orderBy('topics.topic_order','ASC')->get();
		
		$data['discussing_topics_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','2')->orderBy('topic_id','DESC')->count();
		$data['discussed_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','3')->orderBy('topics.topic_order','ASC')->get();
				
		$data['discussing_topics'] = DB::table('topics')->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_meeting_id',$request->id)->where('topics.topic_status','2')->orderBy('topics.topic_order','ASC')->first();
		
		if($data['discussing_topics_count'] != 0)
		{
			$data['act_time'] = $data['discussing_topics']->topic_time * 60; 
		}
		// all votes		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();
		
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 
		
				

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);

		$data['alltopicvotes'] = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->get();
		
		$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		$data['rem_votes'] = 3 - $topic_votes_count;

		// all votes

		$data['all_action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['discussed_topics_tot_count'] = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','3')->count();
		
				
		return view('user/11discussion',$data);
		
	}	
	
		
		
	public function addtopicname_sb(Request $request)
	{
	

		$this->updateusertime();
		// to find order by
		$ifanyitems =  DB::table('topics')->where('topic_meeting_id',$request->mid)->count();
		if($ifanyitems == 0)
		{
			$orderbyinfo = 1;
		}
		else
		{
			$fac_det =  DB::table('topics')->where('topic_meeting_id',$request->mid)->orderBy('topic_order','DESC')->first();
			$orderbyinfo = $fac_det->topic_order+1;
		}
		// to find order by	
		
		$todaydate = date("Y-m-d");		
		DB::table('topics')->insert(['topic_order' => $orderbyinfo,'topic_status' => $request->cur_topic_status,'topic_color' => $request->eselcolor,'topic_created_by' => session('lcbuser_id'),'topic_meeting_id' => $request->mid,'topic_name' =>$request->newtopicname,'topic_created_date' => $todaydate]);
		
     	return $request->cur_topic_status;
	
	
		
	}
		
	public function mycreatetopic(Request $request)
	{
		$this->updateusertime();
		// to find order by
		$ifanyitems =  DB::table('topics')->where('topic_meeting_id',$request->mid)->count();
		if($ifanyitems == 0)
		{
			$orderbyinfo = 1;
		}
		else
		{
			$fac_det =  DB::table('topics')->where('topic_meeting_id',$request->mid)->orderBy('topic_order','DESC')->first();
			$orderbyinfo = $fac_det->topic_order+1;
		}
		// to find order by	
		
		$todaydate = date("Y-m-d");		
		DB::table('topics')->insert(['topic_order' => $orderbyinfo,'topic_color' => $request->selcolor,'topic_created_by' => session('lcbuser_id'),'topic_meeting_id' => $request->mid,'topic_name' =>$request->topics,'topic_created_date' => $todaydate]);
		$results=array("a"=>$request->mid,"b"=>$request->topics);
     	return response()->json($results);
	}

	public function oldaddattendeerequest_oldone(Request $request)
	{		
		$this->updateusertime();
		$vcode = $this->VerificationCode(10);
		
		$barista_user_exist =  DB::table('siteusers')->where('user_emailid',$request->reqemail)->count();
		if($barista_user_exist == 0)
		{
			$r_status = 1;
		}
		else
		{
			$r_status = 1;
		}
		
		
		$alreadyexistcount2 = DB::table('attendees_request')->where('rboardid',$request->mid)->where([["remailid","=",$request->reqemail]])->count();
		if($alreadyexistcount2 == 0)
		{

		DB::table('attendees_request')->insert(['ruserid' => session('lcbuser_id'),'rboardid' => $request->mid,'remailid' =>$request->reqemail,'rstatus' =>$r_status,'rtoken' =>$vcode]);
		$values = array('meeting_name' => $request->mcname,'meeting_votes_fixed' => $request->mcvote);
		DB::table('boards')->where([["meeting_id","=",$request->mid]])->update($values);	
		$boards_rand = DB::table('boards')->where('meeting_id',$request->mid)->first();
		$fac_info =  DB::table('attendees_request')->where('rboardid',$request->mid)->orderBy('rid','DESC')->get();
		// create table
		$htmlmsg = "<table class='table table-bordered'>";		
		foreach($fac_info as $fs)
		{
			$fcountss = DB::table('siteusers')->where('user_emailid',$fs->remailid)->count();
			if($fcountss == 0)
			{
				$fuserid_info = 0;	
			}
			else
			{
				$fuserid = DB::table('siteusers')->where('user_emailid',$fs->remailid)->first();
				$fuserid_info = $fuserid->user_id;
			}
		$uid = "user_id_".$fs->rid;
		$did=$fs->rid;
		$didboth=$fs->rid."__________".$request->mid."__________".$fuserid_info;
		$htmlmsg.="<tr id=".$uid."><td>".$fs->remailid."</td>";
		$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-attendee' data-id='$didboth' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";
		}
				
		$htmlmsg.="</table>";	
		// create table	
		$results=array("count"=>1,"attendee_list"=>$htmlmsg);
		
			// send mail
			$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();				
			$sdata2['m_name'] = $userinfo->user_name;
			$sdata2['m_emailid'] = $request->reqemail;	
			$sdata2['m_rand'] = $vcode;	
			Mail::send('mail.mail_attendee_request', $sdata2, function($message) use ($sdata2) {
			$subject = $sdata2['m_name']." has invited you to a Lean Coffee Brew session!";
			$message->to($sdata2['m_emailid'])->subject($subject);
			});					
			// send mail
			
					
		return response()->json($results);	
			
		}
		else
		{
			$results='';
			return response()->json($results);			
		}		
	}
	
	

	

// for csv import when add
public function addimportattendeerequest(Request $request)
	{
	 	$this->updateusertime();
	 	$filename = $request->file('impmailfl_new')->getRealPath();
		$delimiter = ',';
		$data = array();
		if (!file_exists($filename) || !is_readable($filename))
		{
		  
		}else
		{
			$header = null;
			if (($handle = fopen($filename, 'r')) !== false)
			{
				while (($row = fgetcsv($handle, 1000, $delimiter)) !== false)
				{
						$data[] = $row[0];
				}
				fclose($handle);
			}
		}	
		
		$succarr = array();
		$errarr = array();
		
		foreach($data as $ind_email2)
		{
		$ind_email = trim($ind_email2);
		if($ind_email != '')
		{
			/*$barista_user_exist =  DB::table('siteusers')->where('user_emailid',$request->reqemail)->count();
			if($barista_user_exist == 0)
			{
				$r_status = 1;
			}
			else
			{
				$r_status = 1;
			}*/
			
							// before email check it
							
				$user_info = $this->userdetails();
				if($ind_email == $user_info->user_emailid)
				{
					$status = 4;
				}
				else
				{
					$alreadyexistcount = DB::table('attendees_request')->where('rboardid',$request->mid)->where('removedstatus','0')->where([["remailid","=",$ind_email]])->count();
					if($alreadyexistcount == 1)
					{
						$status = 2;
					}
					else

					{
						$status = 0;
					}
		
				}						
				// before email check it
				if($status == 0)
				{
				
				
			$r_status = 1;
		
        	$alreadyexistcount = DB::table('attendees_request')->where('rboardid',$request->mid)->where([["remailid","=",$ind_email]])->count();
		   
		    if($alreadyexistcount == 0)
            {
                $vcode = $this->VerificationCode(10);
                DB::table('attendees_request')->insert(['ruserid' => session('lcbuser_id'),'rboardid' => $request->mid,'remailid' =>$ind_email,'rstatus' =>$r_status,'rtoken' =>$vcode]);

                    // send mail
                    /*$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();				
                    $sdata2['m_name'] = $userinfo->user_name;
                    $sdata2['m_emailid'] = $ind_email;	
                    $sdata2['m_rand'] = $vcode;	
                    Mail::send('mail.mail_attendee_request', $sdata2, function($message) use ($sdata2) {
                    $subject = $sdata2['m_name']." has invited you to a Lean Coffee Brew session!";
                    $message->to($sdata2['m_emailid'])->subject($subject);
                    });				*/	
                    // send mail
                    $succarr[] = $ind_email; 
                            
            }
            else
            {
				 $vcode = $this->VerificationCode(10);
               $alreadyexistrow = DB::table('attendees_request')->where('rboardid',$request->mid)->where([["remailid","=",$ind_email]])->first();
                if($alreadyexistrow->removedstatus==1)
                {
                    $updatearr = array();
						$values = array('removedstatus' => '0','mailstatus' => '0');
						DB::table('attendees_request')->where([["rboardid","=",$request->mid]])->where('remailid',$ind_email)->update($values);
					$boards_rand = DB::table('attendees_request')->where('rboardid',$request->mid)->first();
					
					
                    /*$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();				
                    $sdata2['m_name'] = $userinfo->user_name;
                    $sdata2['m_emailid'] = $ind_email;	
                    $sdata2['m_rand'] = $boards_rand->rtoken;	
                    Mail::send('mail.mail_attendee_request', $sdata2, function($message) use ($sdata2) {
                    $subject = $sdata2['m_name']." has invited you to a Lean Coffee Brew session!";
                    $message->to($sdata2['m_emailid'])->subject($subject);
                     });*/	
                    $succarr[] = $ind_email;
                }else
                {}
            }
        
		}
		}
		}
		
		$values = array('meeting_name' => $request->mcname);
		DB::table('boards')->where([["meeting_id","=",$request->mid]])->update($values);	
		$boards_rand = DB::table('boards')->where('meeting_id',$request->mid)->first();
		$fac_info =  DB::table('attendees_request')->where('rboardid',$request->mid)->orderBy('rid','DESC')->get();
		// create table
		$htmlmsg = "<table class='table table-bordered'>";		
		foreach($fac_info as $fs)
		{
			$fcountss = DB::table('siteusers')->where('user_emailid',$fs->remailid)->count();
			if($fcountss == 0)
			{
				$fuserid_info = 0;	
			}
			else
			{
				$fuserid = DB::table('siteusers')->where('user_emailid',$fs->remailid)->first();
				$fuserid_info = $fuserid->user_id;
			}
		$uid = "user_id_".$fs->rid;
		$did=$fs->rid;
		$didboth=$fs->rid."__________".$request->mid."__________".$fuserid_info;
		$htmlmsg.="<tr id=".$uid."><td>".$fs->remailid."</td>";
		$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-attendee' data-id='$didboth' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";
		}
				
		$htmlmsg.="</table>";	
		// create table	
		$results=array("count"=>1,"attendee_list"=>$htmlmsg,"succ"=>$succarr,"err"=>$errarr);
		return response()->json($results);	
	}
	
	public function addattendeerequest(Request $request)
	{
		$this->updateusertime();

		$succarr = array();
		$errarr = array();
		$data_1 = $request->reqemail;
		if($data_1!="")
		 {
		 	$data = explode(",",$data_1);
			foreach($data as $ind_email)
			{
			
				// before email check it
				$user_info = $this->userdetails();
				if($ind_email == $user_info->user_emailid)
				{
					$status = 4;
				}
				else
				{
					$alreadyexistcount = DB::table('attendees_request')->where('rboardid',$request->mid)->where('removedstatus','0')->where([["remailid","=",$ind_email]])->count();
					if($alreadyexistcount == 1)
					{
						$status = 2;
					}
					else
					{
						$status = 0;
					}
		
				}						
				// before email check it
				if($status == 0)
				{
				
				$barista_user_exist =  DB::table('siteusers')->where('user_emailid',$ind_email)->count();
				if($barista_user_exist == 0)
				{
					$r_status = 1;
				}
				else
				{
					$r_status = 1;
				}
		
				$alreadyexistcount2 = DB::table('attendees_request')->where('rboardid',$request->mid)->where([["remailid","=",$ind_email]])->count();
				 if($alreadyexistcount2 == 0)
           		 {
				 	$vcode = $this->VerificationCode(10);
						DB::table('attendees_request')->insert(['ruserid' => session('lcbuser_id'),'rboardid' => $request->mid,'remailid' =>$ind_email,'rstatus' =>$r_status,'rtoken' =>$vcode]);
						// send mail
						/*$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();				
						$sdata2['m_name'] = $userinfo->user_name;
						$sdata2['m_emailid'] = $ind_email;	
						$sdata2['m_rand'] = $vcode;	
						Mail::send('mail.mail_attendee_request', $sdata2, function($message) use ($sdata2) {
						$subject = $sdata2['m_name']." has invited you to a Lean Coffee Brew session!";
						$message->to($sdata2['m_emailid'])->subject($subject);
						});	*/				
						// send mail
		
				 }
				 else
				 {
				 	$alreadyexistrow = DB::table('attendees_request')->where('rboardid',$request->mid)->where([["remailid","=",$ind_email]])->first();
                	if($alreadyexistrow->removedstatus==1)
                	{
					
						$values = array('removedstatus' => '0','mailstatus' => '0');
						DB::table('attendees_request')->where([["rboardid","=",$request->mid]])->where('remailid',$ind_email)->update($values);	
						$boards_rand = DB::table('attendees_request')->where('rboardid',$request->mid)->first();
						// send mail
						/*$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();				
						$sdata2['m_name'] = $userinfo->user_name;
						$sdata2['m_emailid'] = $ind_email;	
						$sdata2['m_rand'] = $boards_rand->rtoken;	
						Mail::send('mail.mail_attendee_request', $sdata2, function($message) use ($sdata2) {
						$subject = $sdata2['m_name']." has invited again you to a Lean Coffee Brew session!";
						$message->to($sdata2['m_emailid'])->subject($subject);
						});	*/				
						// send mail
												
		
					}
				 }
				 
				 }
			}
		 }
		 
		$values = array('meeting_name' => $request->mcname);
		DB::table('boards')->where([["meeting_id","=",$request->mid]])->update($values);	
		$boards_rand = DB::table('boards')->where('meeting_id',$request->mid)->first();
		
		$fac_info =  DB::table('attendees_request')->where('rboardid',$request->mid)->orderBy('rid','DESC')->get();
		// create table
		$htmlmsg = "<table class='table table-bordered'>";		
		foreach($fac_info as $fs)
		{
			$fcountss = DB::table('siteusers')->where('user_emailid',$fs->remailid)->count();
			if($fcountss == 0)
			{
				$fuserid_info = 0;	
			}
			else
			{
				$fuserid = DB::table('siteusers')->where('user_emailid',$fs->remailid)->first();
				$fuserid_info = $fuserid->user_id;
			}
		$uid = "user_id_".$fs->rid;
		$did=$fs->rid;
		$didboth=$fs->rid."__________".$request->mid."__________".$fuserid_info;
		$htmlmsg.="<tr id=".$uid."><td>".$fs->remailid."</td>";

		$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-attendee' data-id='$didboth' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";
		}
		$htmlmsg.="</table>";	
		// create table	
		$results=array("count"=>1,"attendee_list"=>$htmlmsg,"succ"=>$succarr,"err"=>$errarr);
		return response()->json($results);	
	
	}
// for csv import when add



// for csv import when edit


public function editattendeerequest(Request $request)
	{
	
	 $this->updateusertime();
	 $succarr = array();
	 $errarr = array();
	 $data_1 = $request->reqemail2;
	 $rr = $request->emid;
	 

	 if($data_1!="")
	 {
	 	$data = explode(",",$data_1);
	 	foreach($data as $ind_email)
		{
				 $vcode = $this->VerificationCode(10);
				// before email check it
				$user_info = $this->userdetails();
				if($ind_email == $user_info->user_emailid)
				{
					$status = 4;
				}
				else
				{
					$alreadyexistcount = DB::table('attendees_request')->where('rboardid',$rr)->where('removedstatus','0')->where([["remailid","=",$ind_email]])->count();
					if($alreadyexistcount == 1)
					{
						$status = 2;
					}
					else
					{
						$status = 0;
					}
		
				}						
				// before email check it
			
			if($status == 0)
			{	
        	$alreadyexistcount = DB::table('attendees_request')->where('rboardid',$rr)->where([["remailid","=",$ind_email]])->count();
			
            if($alreadyexistcount == 0)
            {
               
                DB::table('attendees_request')->insert(['ruserid' => session('lcbuser_id'),'rboardid' => $rr,'remailid' =>$ind_email,'rstatus' =>'1','rtoken' =>$vcode]);
                    // send mail
				
                    /*$sdata2['m_name'] = $user_info->user_name;
                    $sdata2['m_emailid'] = $ind_email;	
                    $sdata2['m_rand'] = $vcode;	
                    Mail::send('mail.mail_attendee_request', $sdata2, function($message) use ($sdata2) {
                    $subject = $sdata2['m_name']." has invited you to a Lean Coffee Brew session!";
                    $message->to($sdata2['m_emailid'])->subject($subject);
                    });		*/			
                    // send mail
                    $succarr[] = $ind_email; 
                            
            }
            else
            {
               $alreadyexistrow = DB::table('attendees_request')->where('rboardid',$rr)->where([["remailid","=",$ind_email]])->first();
                if($alreadyexistrow->removedstatus==1)
                {
                    $updatearr = array();
						$values = array('removedstatus' => '0','mailstatus' => '0');
						DB::table('attendees_request')->where([["rboardid","=",$rr]])->where('remailid',$ind_email)->update($values);	
						$boards_rand = DB::table('attendees_request')->where('rboardid',$rr)->first();
                    /*$sdata2['m_name'] = $user_info->user_name;
                    $sdata2['m_emailid'] = $ind_email;	
                    $sdata2['m_rand'] = $boards_rand->rtoken;	
                    Mail::send('mail.mail_attendee_request', $sdata2, function($message) use ($sdata2) {
                    $subject = $sdata2['m_name']." has invited again you to a Lean Coffee Brew session!";
                    $message->to($sdata2['m_emailid'])->subject($subject);
                     });	*/
                    $succarr[] = $ind_email;
                }else
                {
                    //$errarr[] = $ind_email;
                }
            }
			}
        }
	 }
		
		$fac_info =  DB::table('attendees_request')->where('rboardid',$rr)->where('removedstatus','0')->orderBy('rid','DESC')->get();
		// create table
		$htmlmsg = "<table class='table table-bordered'>";		
		foreach($fac_info as $fs)
		{
			$fcountss = DB::table('siteusers')->where('user_emailid',$fs->remailid)->count();
			if($fcountss == 0)
			{
				$fuserid_info = 0;	
			}
			else
			{
				$fuserid = DB::table('siteusers')->where('user_emailid',$fs->remailid)->first();
				$fuserid_info = $fuserid->user_id;
			}
			$uid = "user_id_".$fs->rid;
			$did=$fs->rid;
			$didboth=$fs->rid."__________".$rr."__________".$fuserid_info;
			$htmlmsg.="<tr id=".$uid."><td>".$fs->remailid."</td>";
	
			$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-attendee' data-id='$didboth' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";
		}
		$htmlmsg.="</table>";	
		
		
		$values = array('meeting_name' => $request->emcname);
		DB::table('boards')->where([["meeting_id","=",$rr]])->update($values);	
		$boards_rand = DB::table('boards')->where('meeting_id',$rr)->first();
			
		
		// create table	
		$results=array("count"=>1,"attendee_list"=>$htmlmsg);
		return response()->json($results);
	}
	
	
public function editimportattendeerequest(Request $request)
	{
	        $this->updateusertime();
		
		$filename = $request->file('impmailfl')->getRealPath();
		$delimiter = ',';
		$data = array();
		if (!file_exists($filename) || !is_readable($filename))
		{
		  
		}else
		{
			$header = null;
			if (($handle = fopen($filename, 'r')) !== false)
			{
				while (($row = fgetcsv($handle, 1000, $delimiter)) !== false)
				{
						$data[] = $row[0];
				}
				fclose($handle);
			}
		}	
		
		$succarr = array();
		$errarr = array();
    
		foreach($data as $ind_email2)
		{
		$ind_email = trim($ind_email2);
		if($ind_email != '')
		{
		// before email check it
				$user_info = $this->userdetails();
				if($ind_email == $user_info->user_emailid)
				{
					$status = 4;
				}
				else
				{
					$alreadyexistcount = DB::table('attendees_request')->where('rboardid',$request->emid)->where('removedstatus','0')->where([["remailid","=",$ind_email]])->count();
					if($alreadyexistcount == 1)
					{
						$status = 2;
					}
					else
					{
						$status = 0;
					}
		
				}						
				// before email check it
				
			if($status == 0)
			{	
        	$alreadyexistcount = DB::table('attendees_request')->where('rboardid',$request->emid)->where([["remailid","=",$ind_email]])->count();
            if($alreadyexistcount == 0)
            {
                $vcode = $this->VerificationCode(10);
                DB::table('attendees_request')->insert(['ruserid' => session('lcbuser_id'),'rboardid' => $request->emid,'remailid' =>$ind_email,'rstatus' =>'1','rtoken' =>$vcode]);
                    // send mail
                    /*$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();				
                    $sdata2['m_name'] = $userinfo->user_name;
                    $sdata2['m_emailid'] = $ind_email;	
                    $sdata2['m_rand'] = $vcode;	
                    Mail::send('mail.mail_attendee_request', $sdata2, function($message) use ($sdata2) {
                    $subject = $sdata2['m_name']." has invited you to a Lean Coffee Brew session!";
                    $message->to($sdata2['m_emailid'])->subject($subject);
                    });	*/				
                    // send mail
                    $succarr[] = $ind_email; 
                            
            }
            else
            {
               $alreadyexistrow = DB::table('attendees_request')->where('rboardid',$request->emid)->where([["remailid","=",$ind_email]])->first();
                if($alreadyexistrow->removedstatus==1)
                {
				
				
				
				                   
						$values = array('removedstatus' => '0','mailstatus' => '0');
						DB::table('attendees_request')->where([["rboardid","=",$request->emid]])->where('remailid',$ind_email)->update($values);	
						$boards_rand = DB::table('attendees_request')->where('rboardid',$request->emid)->first();
						
						
					/*$vcode = $this->VerificationCode(10);
                    $updatearr = array();
                    $updatearr['removedstatus'] = 0;
                    DB::table('attendees_request')->where('rboardid',$request->emid)->where([["remailid","=",$ind_email]])->update($updatearr);
                    $userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();	
					$boards_rand = DB::table('attendees_request')->where('rboardid',$request->emid)->first();
								
                    $sdata2['m_name'] = $userinfo->user_name;
                    $sdata2['m_emailid'] = $ind_email;	
                    $sdata2['m_rand'] = $boards_rand->rtoken;		
                    Mail::send('mail.mail_attendee_request', $sdata2, function($message) use ($sdata2) {
                    $subject = $sdata2['m_name']." has invited you to a Lean Coffee Brew session!";
                    $message->to($sdata2['m_emailid'])->subject($subject);
                     });	*/
                    $succarr[] = $ind_email;
                }else
                {
                    //$errarr[] = $ind_email;
                }
            }
			
			}
			}
        }
		
		$fac_info =  DB::table('attendees_request')->where('rboardid',$request->emid)->where('removedstatus','0')->orderBy('rid','DESC')->get();
		// create table
		$htmlmsg = "<table class='table table-bordered'>";		
		foreach($fac_info as $fs)
		{
			$fcountss = DB::table('siteusers')->where('user_emailid',$fs->remailid)->count();
			if($fcountss == 0)
			{
				$fuserid_info = 0;	
			}
			else
			{
				$fuserid = DB::table('siteusers')->where('user_emailid',$fs->remailid)->first();
				$fuserid_info = $fuserid->user_id;
			}
		$uid = "user_id_".$fs->rid;
		$did=$fs->rid;
		$didboth=$fs->rid."__________".$request->emid."__________".$fuserid_info;
		$htmlmsg.="<tr id=".$uid."><td>".$fs->remailid."</td>";

		$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-attendee' data-id='$didboth' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";
		}
				
		$htmlmsg.="</table>";	
		// create table	
		$results=array("count"=>1,"attendee_list"=>$htmlmsg,"succ"=>$succarr,"err"=>$errarr);
		return response()->json($results);	
	}
	
	
// for csv import when edit	

		
	public function editattendeerequest_my(Request $request)
	{		
		$this->updateusertime();
		$alreadyexistcount = DB::table('attendees_request')->where('rboardid',$request->emid)->where([["remailid","=",$request->reqemail2]])->count();
		if($alreadyexistcount == 0)
		{
		$vcode = $this->VerificationCode(10);
		DB::table('attendees_request')->insert(['ruserid' => session('lcbuser_id'),'rboardid' => $request->emid,'remailid' =>$request->reqemail2,'rstatus' =>'1','rtoken' =>$vcode]);
		$values = array('meeting_name' => $request->emcname);
		DB::table('boards')->where([["meeting_id","=",$request->emid]])->update($values);	
		$boards_rand = DB::table('boards')->where('meeting_id',$request->emid)->first();
		$fac_info =  DB::table('attendees_request')->where('rboardid',$request->emid)->where('removedstatus','0')->orderBy('rid','DESC')->get();
		// create table
		$htmlmsg = "<table class='table table-bordered'>";		
		foreach($fac_info as $fs)
		{
		$uid = "user_id_".$fs->rid;
		$did=$fs->rid;
		$htmlmsg.="<tr id=".$uid."><td>".$fs->remailid."</td>";

		$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-attendee' data-id='$did' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";
		}
				
		$htmlmsg.="</table>";	
		// create table	
		$results=array("count"=>1,"attendee_list"=>$htmlmsg);
		
			// send mail
			$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();				
			$sdata2['m_name'] = $userinfo->user_name;
			$sdata2['m_emailid'] = $request->reqemail2;	
			$sdata2['m_rand'] = $vcode;	
			Mail::send('mail.mail_attendee_request', $sdata2, function($message) use ($sdata2) {
			$subject = $sdata2['m_name']." has invited you to a Lean Coffee Brew session!";
			$message->to($sdata2['m_emailid'])->subject($subject);
			});					
			// send mail
			
					
		return response()->json($results);	
		}
		else
		{
			$results='';
			return response()->json($results);
		}	
				
	}
	
	public function justchangeremovedstatus(Request $request)
	{		
		$this->updateusertime();
		$alreadyexistcount = DB::table('attendees_request')->where('rboardid',$request->emid)->where([["remailid","=",$request->reqemail2]])->count();
		if($alreadyexistcount == 1)
		{
		$vcode = $this->VerificationCode(10);
		
		
		$values2 = array('removedstatus' => '0');
		DB::table('attendees_request')->where('rboardid',$request->emid)->where([["remailid","=",$request->reqemail2]])->update($values2);	
		
				
		$values = array('meeting_name' => $request->emcname);
		DB::table('boards')->where([["meeting_id","=",$request->emid]])->update($values);	
		$boards_rand = DB::table('boards')->where('meeting_id',$request->emid)->first();
		$fac_info =  DB::table('attendees_request')->where('rboardid',$request->emid)->where('removedstatus','0')->orderBy('rid','DESC')->get();
		// create table
		$htmlmsg = "<table class='table table-bordered'>";		
		foreach($fac_info as $fs)
		{
		$uid = "user_id_".$fs->rid;
		$did=$fs->rid;
		$htmlmsg.="<tr id=".$uid."><td>".$fs->remailid."</td>";

		$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-attendee' data-id='$did' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";
		}
				
		$htmlmsg.="</table>";	
		// create table	
		$results=array("count"=>1,"attendee_list"=>$htmlmsg);
		
			// send mail
			$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();				
			$sdata2['m_name'] = $userinfo->user_name;
			$sdata2['m_emailid'] = $request->reqemail2;	
			$sdata2['m_rand'] = $vcode;	
			Mail::send('mail.mail_attendee_request', $sdata2, function($message) use ($sdata2) {
			$subject = $sdata2['m_name']." has again invited you to a Lean Coffee Brew session!";
			$message->to($sdata2['m_emailid'])->subject($subject);
			});					
			// send mail
			
					
		return response()->json($results);	
		}
		else
		{
			$results='';
			return response()->json($results);
		}	
				
	}


	
	
	
	public function shownamestatus(Request $request)
	{
		$this->updateusertime();
		$values = array('meeting_name_dsiplay' => $request->choice_info);
		DB::table('boards')->where('meeting_id',$request->cur_mid)->update($values);
		return 1;		
	}
	
	public function changetimersound(Request $request)
	{
		$this->updateusertime();
		$values = array('meeting_sound' => $request->selvalue);
		DB::table('boards')->where('meeting_id',$request->cur_mid)->update($values);
		
		//$data['soundlists'] = DB::table('sounds')->get();
		$selsound = DB::table('sounds')->where('mid',$request->selvalue)->first();
		
		$selurl = url('/')."/user/sounds/".$selsound->msound;
		
		
		$soundlists = DB::table('sounds')->pluck("mname","mid");
		
		$results=array("soundlists"=>$soundlists,"selectedsound"=>$request->selvalue,"soundurl"=>$selurl);
		
		return response()->json($results);
				
				
	}	
	
	
	public function deletealltopics(Request $request)
	{
		$this->updateusertime();
		//DB::table('attendees_request')->where('rboardid',$request->id)->delete();	
		//DB::table('boards')->where('meeting_id',$request->id)->delete();
		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);
				
		DB::table('topics')->where('topic_meeting_id',$request->id)->delete();	
		DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->delete();
		
		DB::table('topic_discussion')->whereIn('d_topic_id',$data['all_topic_ids'])->delete();
		
		DB::table('actions')->whereIn('a_topicid',$data['all_topic_ids'])->delete();
								
		return 1;
	}	
	public function deletemeeting(Request $request)
	{
		$this->updateusertime();
		DB::table('attendees_request')->where('rboardid',$request->id)->delete();	
		DB::table('boards')->where('meeting_id',$request->id)->delete();
		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->id)->get();

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);
				
		DB::table('topics')->where('topic_meeting_id',$request->id)->delete();	
		DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->delete();
		
		DB::table('topic_discussion')->whereIn('d_topic_id',$data['all_topic_ids'])->delete();
		
		DB::table('actions')->whereIn('a_topicid',$data['all_topic_ids'])->delete();
								
		return 1;
	}
	
	public function gettopicnamedetails_sb(Request $request)
	{
		$this->updateusertime();
		$data['topic_infos'] = DB::table('topics')->where('topic_id',$request->id)->first();
		$results=array("tid"=>$request->id,"tname"=>$data['topic_infos']->topic_name,"tcolor"=>$data['topic_infos']->topic_color,"tstatus"=>$data['topic_infos']->topic_status);
		return response()->json($results);		
	}
	
	public function setconferencestatus(Request $request)
	{
		$this->updateusertime();
		$values = array('meeting_conf_status' => $request->sid);
		DB::table('boards')->where('meeting_id',$request->id)->update($values);	
		return 1;
	}
	
	public function updatemeetingname(Request $request)
	{
		$this->updateusertime();
		$values = array('meeting_name' => $request->cur_mname);
		DB::table('boards')->where('meeting_id',$request->cur_mid)->update($values);	
	}
	public function updatemeetingvotes(Request $request)
	{
		$this->updateusertime();
		
/*		if($request->cur_mvote < $request->pre_vote)
		{			
			$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->cur_mid)->get();
			$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);
			DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->delete();

			$values = array('meeting_votes_fixed' => $request->cur_mvote);
			DB::table('boards')->where('meeting_id',$request->cur_mid)->update($values);			
		}
		else
		{		


		}*/
		
			$values = array('meeting_votes_fixed' => $request->cur_mvote);
			DB::table('boards')->where('meeting_id',$request->cur_mid)->update($values);
			
					
		return 	$request->cur_mvote;
	}	
	
	
	public function updatemeetingvotes_edit(Request $request)
	{
	
		$values = array('meeting_votes_fixed' => $request->cur_mvote);
		DB::table('boards')->where('meeting_id',$request->cur_mid)->update($values);
			
				
		$data['allboards'] = DB::table('boards')->where('meeting_id',$request->cur_mid)->first();
		$vlist='';
		$votelistedit = DB::table('votecounts')->orderBy('vid','ASC')->get();		
		foreach($votelistedit as $ev)
		{
		if($ev->vcount == $data['allboards']->meeting_votes_fixed)
		{
		$cinfo = 'checked="checked"';	
		}
		else
		{
		$cinfo = '';
		}
		
		if($ev->vcount <= $data['allboards']->meeting_votes_fixed)
		{		
		$vlist.='<input type="radio" name="emcvote" id="emcvote" value="'.$ev->vcount.'" disabled class="editvoteclass" '.$cinfo.' />&nbsp;'.$ev->vcount.'&nbsp;';	
		}
		else
		{
		$vlist.='<input type="radio" name="emcvote" id="emcvote" value="'.$ev->vcount.'"  class="editvoteclass" '.$cinfo.' />&nbsp;'.$ev->vcount.'&nbsp;';	
		}
		}
		
		$results=array("mvotelist"=>$vlist);
		return response()->json($results);		
	}	
	
	public function updatemeetingnameandvotes(Request $request)
	{
		$this->updateusertime();
		$values = array('meeting_name' => $request->cur_mname,'meeting_votes_fixed' => $request->cur_mvote);
		DB::table('boards')->where('meeting_id',$request->cur_mid)->update($values);	
	}
		


	
	
	public function updatemeetinglink(Request $request)
	{
		$this->updateusertime();
		$values = array('meeting_conf_link' => $request->cur_mname,'meeting_password' => $request->cur_mpwd);
		DB::table('boards')->where('meeting_id',$request->cur_mid)->update($values);	
	}	
	
	public function updatetopicstatus(Request $request)
	{
		$this->updateusertime();
		if($request->choice_info != '2')
		{
		$values = array('topic_status' => $request->choice_info,'topic_time' => '0','topic_rem_time' => '0');
		DB::table('topics')->where('topic_id',$request->cur_topicid)->update($values);			
		}
		$retvalue = $request->choice_info;
		return $retvalue;
	}
	
	
	
	public function updatetopicstatus_sb(Request $request)
	{
		$this->updateusertime();
		
		$values = array('topic_status' => $request->choice_info,'topic_time' => '0','topic_rem_time' => '0');
		DB::table('topics')->where('topic_id',$request->cur_topicid)->update($values);			
		
		$retvalue = $request->choice_info;
		return $retvalue;
	}	
	
	public function updatetopicstatusanother_sb(Request $request)
	{
		$this->updateusertime();
		
		$cur_counts = DB::table('topics')->where('topic_id',$request->cur_topicid)->first();	
		$nc = $cur_counts->topic_discussed_counts + 1;
		
		$values = array('topic_time' => '0','topic_rem_time' => '0','topic_sb_status' => '0','topic_discussed_counts' => $nc);
		DB::table('topics')->where('topic_id',$request->cur_topicid)->update($values);			
		
		$retvalue = $request->choice_info;
		return $retvalue;
	}	
	
	public function tocheckanyactivedicussion_sb(Request $request)
	{
		$this->updateusertime();
		$discussing_topics_count = DB::table('topics')->where('topic_meeting_id',$request->cur_meetingid)->where('topic_sb_status','2')->count();
		$finalvalue = $discussing_topics_count."___".$request->cur_topicid;
		return $finalvalue;
	}
	
	public function updatetimefortopic_sb(Request $request)
	{
		
		$v2 = $request->timing_info * 60;
		$values = array('topic_sb_status' => '2','topic_time' => $request->timing_info,'topic_rem_time' => $v2);
		DB::table('topics')->where('topic_id',$request->cur_topicid)->update($values);
		$this->updateusertime();
		return $request->timing_info;			
	}
	
	public function updateremainingtimes_sb(Request $request)
	{
		$this->updateusertime();
		$values = array('topic_rem_time' => $request->tleft);
		DB::table('topics')->where('topic_id',$request->topicid)->where('topic_time','!=','0')->update($values);
		return $request->tleft;			
	}
	
	
	public function messageentry(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		$tinfo = date('Y-m-d-H:i:s');
		DB::table('topic_discussion')->insert(['d_topic_id' => $request->ctopic_id,'d_user_id' => $user_info->user_id,'d_message' => $request->topic_message,'d_time' => $tinfo]);
		return 1;
	}
	
	
	
	
		
	public function topicdiscussionmessage(Request $request)
	{
		$this->updateusertime();
		$data['userdetails'] = $this->userdetails();
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->mid)->first();		
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->where('d_topic_id',$request->id)->orderBy('topic_discussion.d_id','DESC')->get(); 
		//dd($data['topic_messages']);
		return view('user/topicdiscussionmessage',$data);
	}
	
	public function deletecomments(Request $request)
	{
		DB::table('topic_discussion')->where('d_id',$request->id)->delete();
		return $request->id;		
	}
	
	public function deleteallcomments_sb(Request $request)
	{
		DB::table('topic_discussion')->where('d_topic_id',$request->id)->delete();
		return $request->id;		
	}	

	
	
	public function changetopicstatus(Request $request)
	{
		$this->updateusertime();
		return 1;			
	}
	
	public function updatetopicname_sb(Request $request)
	{
		$this->updateusertime();
		$values = array('topic_name' => $request->edittopicname,'topic_color' => $request->editselcolor);
		DB::table('topics')->where('topic_id',$request->edittid)->update($values);
		
		return $request->editstatus;	
	}	
	
	public function removevote(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		$loopvalues = DB::table('topics_votes')->where('vtopicid',$request->id)->where('vuserid',$user_info->user_id)->get();
		foreach($loopvalues as $lp)
		{
			DB::table('topics_votes')->where('vid',$lp->vid)->delete();
			break;		
		}
		
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->mid)->first();
		
		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->mid)->get();

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);
		
		// to find all topics under this meeting
		
		// to find maximum vote limit reached
		$totvotes = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		// to find maximum vote limit reached
		
		$tt = $data['meeting_by']->meeting_votes_fixed - $totvotes; 
						
		return $tt;
	}
	
	public function removeallvotes(Request $request)
	{
		$this->updateusertime();
		//$loopvaluesall = DB::table('topics')->where('topic_meeting_id',$request->id)->get();
		$loopvaluesall = DB::table('topics')->where('topic_meeting_id',$request->id)->where('topic_status','!=',3)->get();
		foreach($loopvaluesall as $lp)
		{
			DB::table('topics_votes')->where('vtopicid',$lp->topic_id)->delete();	
		}				
		return 1;
	}	
	
	public function deletetopics_sb(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		DB::table('topics')->where('topic_id',$request->id)->delete();	
		DB::table('topics_votes')->where('vtopicid',$request->id)->delete();	
		// remove all comments
		DB::table('topic_discussion')->where('d_topic_id',$request->id)->delete();
		// remove all comments
		
		// remove all actions
		DB::table('actions')->where('a_topicid',$request->id)->delete();
		// remove all actions	
		
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->mid)->get();
		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);
		$totvotes = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->mid)->first();
		
		
		$rem_votes = $data['meeting_by']->meeting_votes_fixed - $totvotes;		
					
		
			return $rem_votes;		
	}
	
	public function votetopics(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();
		
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->mid)->first();
		
		
		// to find all topics under this meeting
		$data['mytopics'] = DB::table('topics')->select('topic_id')->where('topic_meeting_id',$request->mid)->get();

		$data['all_topic_ids'] = json_decode(json_encode($data['mytopics']), true);
		
		// to find all topics under this meeting
		
		// to find maximum vote limit reached
		$totvotes = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
		// to find maximum vote limit reached

				
		if($totvotes < $data['meeting_by']->meeting_votes_fixed)
		{
			DB::table('topics_votes')->insert(['vtopicid' => $request->id,'vuserid' => $user_info->user_id,'vvote' =>'1']);
			$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
			$rem_votes = $data['meeting_by']->meeting_votes_fixed - $topic_votes_count;
			$reinfo = "1"."___".$rem_votes;			
			return $reinfo;	
		}
		else
		{
			$topic_votes_count = DB::table('topics_votes')->whereIn('vtopicid',$data['all_topic_ids'])->where('vuserid',$user_info->user_id)->count();
			$rem_votes = $data['meeting_by']->meeting_votes_fixed - $topic_votes_count;		
			$reinfo = "0"."___".$rem_votes;		
			return $reinfo;		
		}


		
	}
	
	public function removethisattendee(Request $request)
	{
		$this->updateusertime();
		//DB::table('attendees_request')->where('rid',$request->id)->delete();	 // previous functionality
		

		
		// to test user acting as host
		$hostcount = DB::table('boards')->where('meeting_id',$request->mid)->where('meeting_host_by',$request->emid)->count();
		// to test user acting as host
		if($hostcount == 0)
		{
		$values = array('removedstatus' => '1');
		DB::table('attendees_request')->where('rid',$request->id)->update($values);
		$st=1;
		}
		else
		{
		$st=0;	
		}			
							
	 	$results=array("status"=>$st);
     	return response()->json($results);	
	}	
	
	public function checkattendeeornot(Request $request)
	{
		$this->updateusertime();
		// check same user id
		$user_info = $this->userdetails();
		if($request->emid == $user_info->user_emailid)
		{
			$status = 4;
		}
		else
		{
		// check same user id
		
		$alreadyexistcount_removed = DB::table('attendees_request')->where('rboardid',$request->cur_mid)->where('removedstatus','1')->where([["remailid","=",$request->emid]])->count();
		if($alreadyexistcount_removed == 1)
		{
				$status = 201;
				$results=array("statusinfo"=>$status);
     			return response()->json($results);
		}
		
		
		$alreadyexistcount = DB::table('attendees_request')->where('rboardid',$request->cur_mid)->where('removedstatus','0')->where([["remailid","=",$request->emid]])->count();
		if($alreadyexistcount == 1)
		{
			$status = 2;
		}
		else
		{
		$ucount = DB::table('siteusers')->where([["user_emailid","=",$request->emid]])->count();		
		if($ucount == 0)
		{
			$status = 0;
		}
		else
		{
			$iffacilitator = DB::table('siteusers')->where([["user_emailid","=",$request->emid]])->where([["user_type","=",'1']])->count();
			if($iffacilitator == 0)
			{
				$status = 0;
			}
			else
			{
				$status = 0;
			}
		}
		}
		}
		$results=array("statusinfo"=>$status);
     	return response()->json($results);
	}
	
	
	public function createmeeting(Request $request)
	{
		$this->updateusertime();
		$todaydate = date("Y-m-d");
		$vcode = $this->VerificationCode(10);
		$mid = DB::table('boards')->insertGetId(['meeting_by' => session('lcbuser_id'),'meeting_host_by' => session('lcbuser_id'),'meeting_rand' => $vcode,'meeting_name' =>$request->mname,'meeting_type' =>$request->mtype,'meeting_status' =>'1','meeting_date_created' => $todaydate,'meeting_votes_fixed' => '1']);
		$results=array("count"=>$request->mtype,"name"=>$request->mname,"id"=>$mid,"rno"=>$vcode);
     	return response()->json($results);
	}
	
	
	public function getvotelistbarista(Request $request)
	{

		$this->updateusertime();
		$data['allboards'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		

$vlist='';
$votelistedit = DB::table('votecounts')->orderBy('vid','ASC')->get();		
foreach($votelistedit as $ev)
{
	if($ev->vcount == $data['allboards']->meeting_votes_fixed)
	{
		$cinfo = 'checked="checked"';	
	}
	else
	{
		$cinfo = '';
	}
	
	if($ev->vcount <= $data['allboards']->meeting_votes_fixed)
	{		
		$vlist.='<input type="radio" name="emcvote" id="emcvote" value="'.$ev->vcount.'" disabled class="editvoteclass" '.$cinfo.' />&nbsp;'.$ev->vcount.'&nbsp;';	
	}
	else
	{
		$vlist.='<input type="radio" name="emcvote" id="emcvote" value="'.$ev->vcount.'"  class="editvoteclass" '.$cinfo.' />&nbsp;'.$ev->vcount.'&nbsp;';	
	}
}
		
		$results=array("mvotelist"=>$vlist);
		return response()->json($results);		
		
	}
	
	
		
	public function editmeeting(Request $request)
	{
		$this->updateusertime();
		$data['allboards'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		$me_name = $data['allboards']->meeting_name;$me_link = $data['allboards']->meeting_conf_link;$me_pass = $data['allboards']->meeting_password;
		$me_id = $data['allboards']->meeting_id;$me_rand_id = $data['allboards']->meeting_rand;
		$fac_info =  DB::table('attendees_request')->where('rboardid',$request->id)->where('removedstatus','0')->orderBy('rid','DESC')->get();
		// create table
		$htmlmsg = "<table class='table table-bordered'>";		
		foreach($fac_info as $fs)
		{
			$fcountss = DB::table('siteusers')->where('user_emailid',$fs->remailid)->count();
			if($fcountss == 0)
			{
				$fuserid_info = 0;	
			}
			else
			{
				$fuserid = DB::table('siteusers')->where('user_emailid',$fs->remailid)->first();
				$fuserid_info = $fuserid->user_id;
			}
			
			$uid = "user_id_".$fs->rid;
			$did=$fs->rid;
			$didboth=$fs->rid."__________".$request->id."__________".$fuserid_info;
			$htmlmsg.="<tr id=".$uid."><td>".$fs->remailid."</td>";
			$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-attendee' data-id='$didboth' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";
		}
				
		$htmlmsg.="</table>";	
		
		
		// create table	

$vlist='';
$votelistedit = DB::table('votecounts')->orderBy('vid','ASC')->get();		
foreach($votelistedit as $ev)
{
	if($ev->vcount == $data['allboards']->meeting_votes_fixed)
	{
		$cinfo = 'checked="checked"';	
	}
	else
	{
		$cinfo = '';
	}
	
	if($ev->vcount <= $data['allboards']->meeting_votes_fixed)
	{		
		$vlist.='<input type="radio" name="emcvote" id="emcvote" value="'.$ev->vcount.'" disabled class="editvoteclass" '.$cinfo.' />&nbsp;'.$ev->vcount.'&nbsp;';	
	}
	else
	{
		$vlist.='<input type="radio" name="emcvote" id="emcvote" value="'.$ev->vcount.'"  class="editvoteclass" '.$cinfo.' />&nbsp;'.$ev->vcount.'&nbsp;';	
	}
}
		
		$results=array("count"=>1,"attendee_list"=>$htmlmsg,"mpwd"=>$me_pass,"mlink"=>$me_link,"mname"=>$me_name,"mid"=>$me_id,"rno"=>$me_rand_id,"gchoice"=>$data['allboards']->meeting_no_guests,"mvotes"=>$data['allboards']->meeting_votes_fixed,"mvotelist"=>$vlist);
		return response()->json($results);		
	}
	
	
	public function meetingboard(Request $request)
	{
		$this->updateusertime();
		// to check id is valid or not
		$fac_info =  DB::table('attendees_request')->where('rtoken',$request->id)->where('remailid',$request->email)->count();
		if($fac_info == 0)
		{
			return redirect('/index')->with("error","Sorry not a valid invitation");
		}
		else
		{
			// to check fresh user or not
			$siteusers_count =  DB::table('siteusers')->where('user_emailid',$request->email)->count();
			if($siteusers_count == 0)
			{
				session()->put('dummy_token',$request->id);			
				session()->put('dummy_emailid',$request->email);
				return redirect('/signin/')->with("error","Please sign in or register to join the meeting");
			}
			else
			{
				// to check attendee or not
				$users_count2 =  DB::table('siteusers')->where('user_emailid',$request->email)->where('user_type','2')->count();				
/*				if($users_count2 == 1)
				{
					$values = array('rstatus' => '1');
					DB::table('attendees_request')->where('rtoken',$request->id)->where('remailid',$request->email)->update($values);
					return redirect('/signin/')->with("error","Please sign in to join the meeting");				
				}
				else
				{					
					return redirect('/index')->with("error","Sorry not a valid invitation");
				}*/
				// to check attendee or not
				
					$values = array('rstatus' => '1');
					DB::table('attendees_request')->where('rtoken',$request->id)->where('remailid',$request->email)->update($values);
					return redirect('/signin/')->with("error","Please sign in to join the meeting");	
									
			}
			// to check fresh user or not
		}
		// to check id is valid or not
	}
	
	public function addactiondetails_sb(Request $request)
	{
		$this->updateusertime();
		$tinfo = date('Y-m-d-H:i:s');
		DB::table('actions')->insert(['a_userid' => session('lcbuser_id'),'a_topicid' => $request->action_topicid,'a_title' => $request->action_title,'a_description' => $request->action_info,'a_datetime' => $tinfo]);

		return 1;
	}	
	
	
	
	public function messageentry_comment_sb(Request $request)
	{
	
		$this->updateusertime();
		$user_info = $this->userdetails();
		$tinfo = date('Y-m-d-H:i:s');
		DB::table('topic_discussion')->insert(['d_topic_id' => $request->ctopic_id_popup,'d_user_id' => $user_info->user_id,'d_message' => $request->topic_message_popup,'d_time' => $tinfo]);
		
		
		$this->updateusertime();
		$userdetails = $this->userdetails();
		$meeting_by = DB::table('boards')->where('meeting_id',$request->mid)->first();		
		$topic_messages = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->where('d_topic_id',$request->ctopic_id_popup)->orderBy('topic_discussion.d_id','DESC')->get(); 
		
		$comment_det = '<span id="rmallid___'.$request->ctopic_id_popup.'"><p align="right">';
		if($meeting_by->meeting_host_by == $userdetails->user_id)
		{
		if(count($topic_messages) != 0)
		{
		$comment_det .= '<a class="changetimer_btn_sd delete-all-comments-popup"  data-id="'.$request->ctopic_id_popup.'" href="javascript:void(0)" alt="Delete all comments" title="Delete all comments" style="font-size:10px; padding:6px; color:#FFFFFF">DELETE ALL COMMENTS</a>
		</p>';
		}
		else
		{
			$comment_det .= '</p>';
		}
		}
		else
		{
			$comment_det .= '</p>';
		}
		foreach($topic_messages as $tpm)
		{

			$remid = "rmid___".$tpm->d_id;
			$delid = $tpm->d_id;
			$comment_det.='<p align="left" style="padding-left:5px;"  id="'.$remid.'"><span style="color:#F60">'.ucfirst($tpm->user_name).'</span><br>
			'.$tpm->d_message.'<br>'.$tpm->d_time;
			
			if($meeting_by->meeting_host_by == $userdetails->user_id)
			{
				$comment_det.='&nbsp;&nbsp;<a class="delete-comments-popup"  data-id="'.$delid.'" href="javascript:void(0)" alt="Delete" title="Delete"><i class="fa fa-trash"></i></a>';
			}
			else
			{
				if($tpm->d_user_id == $userdetails->user_id)
				{
					$comment_det.='&nbsp;&nbsp;<a class="delete-comments-popup"  data-id="'.$delid.'" href="javascript:void(0)" alt="Delete" title="Delete"><i class="fa fa-trash"></i></a>';
				}
			}
			
			$comment_det.="</p>";
		
		}
		$comment_det.="</span>";
		
		$results=array("comments"=>$comment_det,"topicid"=>$request->ctopic_id_popup);
		return response()->json($results);	
		
		
	
	}
		
	public function getcommentdetails_sb(Request $request)
	{
	
	
		$this->updateusertime();
		$userdetails = $this->userdetails();
		$meeting_by = DB::table('boards')->where('meeting_id',$request->mid)->first();		
		$topic_messages = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->where('d_topic_id',$request->id)->orderBy('topic_discussion.d_id','DESC')->get(); 
		
		$comment_det = '<span id="rmallid___'.$request->id.'"><p align="right">';
		
		if($meeting_by->meeting_host_by == $userdetails->user_id)
		{
		if(count($topic_messages) != 0)
		{
		$comment_det .= '<a class="changetimer_btn_sd delete-all-comments-popup"  data-id="'.$request->id.'" href="javascript:void(0)" alt="Delete all comments" title="Delete all comments" style="font-size:10px; padding:6px; color:#FFFFFF">DELETE ALL COMMENTS</a>
		</p>';
		}
		else
		{
			$comment_det .= '</p>';
		}
		}
		else
		{
		$comment_det .='</p>';
		}
		
		foreach($topic_messages as $tpm)
		{
			$remid = "rmid___".$tpm->d_id;
			$delid = $tpm->d_id;
			$comment_det.='<p align="left" style="padding-left:5px;"  id="'.$remid.'"><span style="color:#F60">'.ucfirst($tpm->user_name).'</span><br>
			'.$tpm->d_message.'<br>'.$tpm->d_time;
			
			if($meeting_by->meeting_host_by == $userdetails->user_id)
			{
				$comment_det.='&nbsp;&nbsp;<a class="delete-comments-popup"  data-id="'.$delid.'" href="javascript:void(0)" alt="Delete" title="Delete"><i class="fa fa-trash"></i></a>';
			}
			else
			{
				if($tpm->d_user_id == $userdetails->user_id)
				{
					$comment_det.='&nbsp;&nbsp;<a class="delete-comments-popup"  data-id="'.$delid.'" href="javascript:void(0)" alt="Delete" title="Delete"><i class="fa fa-trash"></i></a>';
				}
			}
			
			$comment_det.="</p>";
		}
		$comment_det.="</span>";
		
		$results=array("comments"=>$comment_det,"topicid"=>$request->id);
		return response()->json($results);	
		
				
		
		
		/*@foreach($topic_messages as $tpm)
<p align="left" style="padding-left:5px;" class="myinfo" id="rmid___{{$tpm->d_id}}"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>{{$tpm->d_message}}<br>{{ Carbon\Carbon::parse($tpm->d_time)->diffForHumans()}}&nbsp;&nbsp;@if($meeting_by->meeting_host_by == $userdetails->user_id) <a class="delete-comments"  data-id="{{ $tpm->d_id }}" href="javascript:void(0)" alt="Delete" title="Delete"><i class="fa fa-trash"></i></a> @else 
@if($tpm->d_user_id == $userdetails->user_id)
<a class="delete-comments"  data-id="{{ $tpm->d_id }}" href="javascript:void(0)" alt="Delete" title="Delete"><i class="fa fa-trash"></i></a>
@endif
@endif</p>
@endforeach*/


		//dd($data['topic_messages']);
		//return view('user/topicdiscussionmessage',$data);
		
			
	}
	
	public function getactiondetails_sb(Request $request)
	{
		$this->updateusertime();
		$tid = $request->id;
		$user_info = $this->userdetails();
		$topicsinfo = DB::table('topics')->where('topic_id',$request->id)->first();
		$topicsinfo2 = DB::table('boards')->where('meeting_id',$topicsinfo->topic_meeting_id)->first();
		
		
		$action_infos = DB::table('actions')->where('a_topicid',$tid)->orderBy('a_id','DESC')->get();
		if(count($action_infos) != 0)
		{
		$act_det = '<table width=100%>';
		foreach($action_infos as $ai)
		{
$timestamp = strtotime($ai->a_datetime);
$dt = date("h.i A", $timestamp);

			$did = $ai->a_id;$uid = "actionid_".$ai->a_id;
			$dt1 = explode(" ",$ai->a_datetime);
			$act_det.="<tr id=".$uid."><td><table width=100%>";
			$act_det.="<tr><td>".ucfirst($ai->a_title)."</td></tr>";
			$act_det.="<tr><td>".$ai->a_description."</td></tr>";
			
			if($topicsinfo2->meeting_host_by == $user_info->user_id) 
			{
			$act_det.="<tr><td align=right>".$dt."&nbsp;<a class='delete-addactions' data-id='$did' href='javascript:void(0)' alt='Delete' title='Delete'><i class='fa fa-trash'></i></a>"."</td></tr>";
			}
			$act_det.="<tr><td><hr></td></tr></table></td></tr>";
		}
		$act_det.= '</table>';
		}
		else
		{
			$act_det='Sorry no action details available.';
		}
		return $act_det;
		
	}
	
	
	public function getactioncomments(Request $request)
	{
		$this->updateusertime();
		$data['topic_comments'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->
		where('topic_discussion.d_topic_id','=',$request->id)->orderBy('topic_discussion.d_id','DESC')->get(); 
		
		
		$act_det = '<table width=100% border=0>';
		foreach($data['topic_comments'] as $ai)
		{
			$timestamp = strtotime($ai->d_time); 
$dt = date("h.i A", $timestamp);
			$act_det.='<tr><td><p align="left" style="padding-left:5px; width:100%; color:#000000" class="myinfo"><span style="color:#F60">'.ucfirst($ai->user_name).'</span><br>'.$ai->d_message.'<br>'.$dt.'</p></td></tr>';
		}
		$act_det.= '</table>';
		
		if(count($data['topic_comments']) == 0)
		{
			$act_det = 'Sorry no comments available.';
		}
		return $act_det;
	}
	
		
	public function getactiondetailsd(Request $request)
	{
		$this->updateusertime();
		$tid = $request->id;
		$action_infos = DB::table('actions')->where('a_topicid',$tid)->orderBy('a_id','DESC')->get();
		if(count($action_infos) != 0)
		{
		$act_det = '<table width=100%>';
		foreach($action_infos as $ai)
		{
$timestamp = strtotime($ai->a_datetime);
$dt = date("h.i A", $timestamp);

			$did = $ai->a_id;$uid = "actionid_".$ai->a_id;
			$dt1 = explode(" ",$ai->a_datetime);
			$act_det.="<tr id=".$uid."><td><table width=100%>";
			$act_det.="<tr><td>".$ai->a_title."</td></tr>";
			$act_det.="<tr><td>".$ai->a_description."</td></tr>";
			$act_det.="<tr><td align=right>".$dt."</td></tr>";
			$act_det.="<tr><td><hr></td></tr></table></td></tr>";
		}
		$act_det.= '</table>';
		}
		else
		{
		$act_det='Sorry no action details available.';	
		}
		return $act_det;
		
	}	
	
	
	
	public function removeactions(Request $request)
	{
		$this->updateusertime();
		// remove from request table
		DB::table('actions')->where('a_id',$request->id)->delete();
		return 1;
		// remove from request table		
	}	
	
	


	public function getstatusofthemeeting(Request $request)
	{
		$this->updateusertime();
		// remove from request table
		
		$mm = DB::table('boards')->where("meeting_id","=",$request->id)->first();
		
		return $mm->meeting_end_status;
		// remove from request table		
	}
		
	
	public function changestatusofthemeeting(Request $request)
	{
		//$this->updateusertime();
		
		$mm = DB::table('boards')->where("meeting_id","=",$request->id)->first();
		
		
		// remove from request table
		$values = array('meeting_end_status' => '1','meeting_host_by' => $mm->meeting_by);
		DB::table('boards')->where([["meeting_id","=",$request->id]])->update($values);
		return 1;
		// remove from request table		
	}	
	
	public function addtoopenclose_sb(Request $request)
	{
		// check if null
		$ifnull = DB::table('boards')->where("meeting_id","=",$request->mid)->first();
		if($request->option == 'false')
		{
			if($ifnull->meeting_opened_topics == '')
			{
				$n = $request->tid;
			}
			else
			{
				$n = $ifnull->meeting_opened_topics.",".$request->tid;			
			}
			
			$values = array('meeting_opened_topics' => $n);
			DB::table('boards')->where([["meeting_id","=",$request->mid]])->update($values);
			
			
		}
		else
		{
			$m = DB::table('boards')->where("meeting_id","=",$request->mid)->first();
			$topicid_array = explode(',', $m->meeting_opened_topics);
			$key = array_search($request->tid, $topicid_array);
			unset($topicid_array[$key]);
			$m1 = implode(",",$topicid_array);

			$values2 = array('meeting_opened_topics' => $m1);
			DB::table('boards')->where([["meeting_id","=",$request->mid]])->update($values2);

		}
		return 1;
		
						
		// check if null
	}
	
	public function addcollapsed(Request $request)
	{
		$infot = array();
		if($request->toption == 1)
		{
			// push to array
			array_push($infot,$request->tid);
			// push to array
		}	
		else
		{
			// remove from array
			
			// remove from array
		}
		return $infot;
	}
	
		
	
	
	public function changestatusofthemeetingboard(Request $request)
	{	
		$this->updateusertime();
		// remove from request table
		$values = array('meeting_end_status' => '0');
		DB::table('boards')->where([["meeting_id","=",$request->id]])->update($values);
		return 1;
		// remove from request table		
	}
		
	
	
	public function exporttocsv_sb(Request $request)
	{
		$this->updateusertime();

		$csvtopicids=array();
		$data['csvtopics_allinfo'] = DB::table('topics')->where('topic_meeting_id',$request->id)->get();
		
		foreach($data['csvtopics_allinfo'] as $d)
		{
			array_push($csvtopicids,$d->topic_id);
		}
		$data['csvtopicids'] = $csvtopicids;
		

		
		
     $customer_data = DB::table('actions')->whereIn('a_topicid',$data['csvtopicids'])->get();
	 $customer_array = array();
     $customer_array[] = array('ID', 'TopicID', 'TopicName', 'Title', 'Description','OwnerEmail','Status','Created');
     foreach($customer_data as $customer)
     {
	 $tname = DB::table('topics')->where('topic_id',$customer->a_topicid)->first();
	 $temail = DB::table('siteusers')->where('user_id',$tname->topic_created_by)->first();
      $customer_array[] = array(
       'ID'  => $customer->a_id,
       'TopicID'   => $customer->a_topicid,
       'TopicName'    => $tname->topic_name,
       'Title'  => $customer->a_title,
       'Description'   => $customer->a_description,
       'OwnerEmail'  => $temail->user_emailid,
       'Status'  => '',
       'Created'   => $customer->a_datetime	   
      );
     }
	 
	$serialize_user_arr = serialize($customer_array);
	// to make csv
	$tinfo = time();
	$filename = 'public/csv/'.$tinfo."SB".'.csv';
	$export_data = unserialize($serialize_user_arr);
	// to make csv
	
// file creation
$file = fopen($filename,"w");

foreach ($export_data as $line){
 fputcsv($file,$line);
}

fclose($file);

// download
header("Content-Description: File Transfer");
header("Content-Disposition: attachment; filename=".$filename);
header("Content-Type: application/csv; "); 

readfile($filename);

// deleting file
unlink($filename);
exit();	
	
	}
	
	public function printPDF()
    {
		$this->updateusertime();
       // This  $data array will be passed to our PDF blade       
	    $data = ['title' => 'First PDF for Medium','heading' => 'Hello from 99Points.info','content' => "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged."];
        
        $pdf = PDF::loadView('user/pdf_view', $data);  
        return $pdf->download('medium.pdf');
    }
	
	public function newtestPDF()
    {
		//$this->updateusertime();
       // This  $data array will be passed to our PDF blade       
	    $data = ['title' => 'First PDF for Medium','heading' => 'Hello from 99Points.info','content' => "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged."];
        
		$data['meeting_by'] = DB::table('boards')->where('meeting_id','5')->first();
		
		
		$data['ainfo'] = 'sai god';

		$data['datedetails'] = 0;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',5)->first();
		$data['barista_info'] = DB::table('siteusers')->where('user_id',$data['meeting_by']->meeting_by)->first();
		
		$data['par_info'] = DB::table('attendees_request')->join('siteusers as A' ,'attendees_request.ruserid','=','A.user_id')->where('attendees_request.rboardid',$data['meeting_by']->meeting_id)->where('attendees_request.ronlinestatus','1')->get();
		
		$data['par_info_removed'] = DB::table('attendees_request')->join('siteusers as A' ,'attendees_request.ruserid','=','A.user_id')->where('attendees_request.rboardid',$data['meeting_by']->meeting_id)->where('attendees_request.removedstatus','1')->get();
				
		$data['par_info_not'] = DB::table('attendees_request')->join('siteusers as A' ,'attendees_request.ruserid','=','A.user_id')->where('attendees_request.rboardid',$data['meeting_by']->meeting_id)->where('attendees_request.ronlinestatus','0')->where('attendees_request.removedstatus','0')->where('attendees_request.leavestatus','0')->get();
				
		$randno = $data['meeting_by']->meeting_rand;
		$data['guest_count'] = DB::table('guest_request')->join('siteusers as A' ,'guest_request.guserid','=','A.user_id')->where('guest_request.gboardid',$data['meeting_by']->meeting_id)->count();
		
		if($data['guest_count'] != 0)
		{
			//$data['guest_info'] = DB::table('siteusers')->where('user_emailid','LIKE',$randno.'%')->get();
			
			
			$data['guest_info'] = DB::table('guest_request')->join('siteusers as A' ,'guest_request.guserid','=','A.user_id')->where('guest_request.gboardid',$data['meeting_by']->meeting_id)->where('guest_request.gremovedstatus','0')->get();
			
			$data['guest_info_removed'] = DB::table('guest_request')->join('siteusers as A' ,'guest_request.guserid','=','A.user_id')->where('guest_request.gboardid',$data['meeting_by']->meeting_id)->where('guest_request.gremovedstatus','1')->get();
					
			
		}
		
		
		
		
		
		
		
		$data['s_topics'] = DB::table('topics')->where('topic_meeting_id',5)->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_status','1')->orderBy('topics.topic_id','DESC')->get();
		
		
		
		$data['w_topics'] = DB::table('topics')->where('topic_meeting_id',5)->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_status','2')->orderBy('topics.topic_id','DESC')->get();
		
		$data['o_topics'] = DB::table('topics')->where('topic_meeting_id',5)->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_status','3')->orderBy('topics.topic_id','DESC')->get();
		
		$data['t_topics'] = DB::table('topics')->where('topic_meeting_id',5)->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_status','4')->orderBy('topics.topic_id','DESC')->get();
		
								
		

		
		
		$data['action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 

		
		

		
		

		
		
				
			$data['datedetails'] = 0;
		
		
        $pdf = PDF::loadView('user/testpdf', $data);
		//$path = public_path('pdf/');  
		//$fileName =  'swot-session-summary-'.$tinfo.'.' . 'pdf' ;
		//$pdf->save($path . '/' . $fileName);
		 return $pdf->download('medium.pdf');
        
    }	
	
	public function previewsailboatdiscussion(Request $request)
	{
	
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		
		$data['v_topics'] =  DB::select('CALL  getSBtopics(?,?,?)',array($request->id,1,0));
		$data['tg_topics'] =  DB::select('CALL  getSBtopics(?,?,?)',array($request->id,2,0));
		$data['n_topics'] =  DB::select('CALL  getSBtopics(?,?,?)',array($request->id,3,0));
		$data['p_topics'] =  DB::select('CALL  getSBtopics(?,?,?)',array($request->id,4,0));
		
		return view('user/previewsailboatdiscussion',$data);
		exit();	
	
	}
	
	public function createpdf_sb(Request $request)
	{
		$this->updateusertime();
       // This  $data array will be passed to our PDF blade       
	  	$tinfo = time();

		$data['ainfo'] = $request->action_info;
		$data['dfinfo'] = $request->dateformat_info;		
		
		
		if($request->from != '' and $request->to != '')
		{

		
		$data['datedetails'] = 1;
		$fromdate = $request->from;
		$startDate = date("Y-m-d", strtotime($fromdate));
		$data['s_date'] = date("d M Y", strtotime($fromdate));
		$todate = $request->to;
		$endDate = date("Y-m-d", strtotime($todate));		
		$data['e_date'] = date("d M Y", strtotime($todate));

		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->current_mid)->first();
		$data['barista_info'] = DB::table('siteusers')->where('user_id',$data['meeting_by']->meeting_by)->first();
		//$data['par_info'] = DB::table('attendees_request')->join('siteusers as A' ,'attendees_request.ruserid','=','A.user_id')->where('attendees_request.rboardid',$data['meeting_by']->meeting_id)->get();
		
		
$data['par_info'] = DB::table('attendees_request')->join('siteusers as A' ,'attendees_request.ruserid','=','A.user_id')->where('attendees_request.rboardid',$data['meeting_by']->meeting_id)->where('attendees_request.ronlinestatus','1')->get();
		//where('attendees_request.removedstatus','0')->where('attendees_request.ronlinestatus','1')->orWhere('attendees_request.leavestatus','1')
		$data['par_info_removed'] = DB::table('attendees_request')->join('siteusers as A' ,'attendees_request.ruserid','=','A.user_id')->where('attendees_request.rboardid',$data['meeting_by']->meeting_id)->where('attendees_request.removedstatus','1')->get();
				
		$data['par_info_not'] = DB::table('attendees_request')->join('siteusers as A' ,'attendees_request.ruserid','=','A.user_id')->where('attendees_request.rboardid',$data['meeting_by']->meeting_id)->where('attendees_request.ronlinestatus','0')->where('attendees_request.removedstatus','0')->where('attendees_request.leavestatus','0')->get();
		
				
		$randno = $data['meeting_by']->meeting_rand;
		$data['guest_count'] =  DB::table('guest_request')->join('siteusers as A' ,'guest_request.guserid','=','A.user_id')->where('guest_request.gboardid',$data['meeting_by']->meeting_id)->count();
		
		if($data['guest_count'] != 0)
		{
			//$data['guest_info'] = DB::table('guest_request')->join('siteusers as A' ,'guest_request.guserid','=','A.user_id')->where('guest_request.gboardid',$data['meeting_by']->meeting_id)->get();
			
			$data['guest_info'] = DB::table('guest_request')->join('siteusers as A' ,'guest_request.guserid','=','A.user_id')->where('guest_request.gboardid',$data['meeting_by']->meeting_id)->where('guest_request.gremovedstatus','0')->get();
			
			$data['guest_info_removed'] = DB::table('guest_request')->join('siteusers as A' ,'guest_request.guserid','=','A.user_id')->where('guest_request.gboardid',$data['meeting_by']->meeting_id)->where('guest_request.gremovedstatus','1')->get();
			
			
		}		
		
	
		
			
		$data['v_topics'] = DB::table('topics')->where('topic_meeting_id',$request->current_mid)->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_status','1')->whereBetween('topics.topic_created_date', [$startDate, $endDate])->orderBy('topics.topic_id','DESC')->get();
				
		$data['tg_topics'] = DB::table('topics')->where('topic_meeting_id',$request->current_mid)->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_status','2')->whereBetween('topics.topic_created_date', [$startDate, $endDate])->orderBy('topics.topic_id','DESC')->get();
		
		$data['n_topics'] = DB::table('topics')->where('topic_meeting_id',$request->current_mid)->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_status','3')->whereBetween('topics.topic_created_date', [$startDate, $endDate])->orderBy('topics.topic_id','DESC')->get();
		
		$data['p_topics'] = DB::table('topics')->where('topic_meeting_id',$request->current_mid)->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_status','4')->whereBetween('topics.topic_created_date', [$startDate, $endDate])->orderBy('topics.topic_id','DESC')->get();
		
		
		
		
		
		
	
		$data['action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 


		


	

		
        $pdf = PDF::loadView('user/sb_pdf_view', $data);
		$path = public_path('pdf/');  
		$fileName =  'sail-boat-summary-'.$tinfo.'.' . 'pdf' ;
		$pdf->save($path . '/' . $fileName);
        return $fileName;
			
		}
		else
		{
		$data['datedetails'] = 0;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->current_mid)->first();
		$data['barista_info'] = DB::table('siteusers')->where('user_id',$data['meeting_by']->meeting_by)->first();
		
		$data['par_info'] = DB::table('attendees_request')->join('siteusers as A' ,'attendees_request.ruserid','=','A.user_id')->where('attendees_request.rboardid',$data['meeting_by']->meeting_id)->where('attendees_request.ronlinestatus','1')->get();
		
		$data['par_info_removed'] = DB::table('attendees_request')->join('siteusers as A' ,'attendees_request.ruserid','=','A.user_id')->where('attendees_request.rboardid',$data['meeting_by']->meeting_id)->where('attendees_request.removedstatus','1')->get();
				
		$data['par_info_not'] = DB::table('attendees_request')->join('siteusers as A' ,'attendees_request.ruserid','=','A.user_id')->where('attendees_request.rboardid',$data['meeting_by']->meeting_id)->where('attendees_request.ronlinestatus','0')->where('attendees_request.removedstatus','0')->where('attendees_request.leavestatus','0')->get();
				
		$randno = $data['meeting_by']->meeting_rand;
		$data['guest_count'] = DB::table('guest_request')->join('siteusers as A' ,'guest_request.guserid','=','A.user_id')->where('guest_request.gboardid',$data['meeting_by']->meeting_id)->count();
		
		if($data['guest_count'] != 0)
		{
			//$data['guest_info'] = DB::table('siteusers')->where('user_emailid','LIKE',$randno.'%')->get();
			
			
			$data['guest_info'] = DB::table('guest_request')->join('siteusers as A' ,'guest_request.guserid','=','A.user_id')->where('guest_request.gboardid',$data['meeting_by']->meeting_id)->where('guest_request.gremovedstatus','0')->get();
			
			$data['guest_info_removed'] = DB::table('guest_request')->join('siteusers as A' ,'guest_request.guserid','=','A.user_id')->where('guest_request.gboardid',$data['meeting_by']->meeting_id)->where('guest_request.gremovedstatus','1')->get();
					
			
		}
		
		
		
		
		
		
		
		$data['v_topics'] = DB::table('topics')->where('topic_meeting_id',$request->current_mid)->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_status','1')->orderBy('topics.topic_id','DESC')->get();
						
		$data['tg_topics'] = DB::table('topics')->where('topic_meeting_id',$request->current_mid)->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_status','2')->orderBy('topics.topic_id','DESC')->get();
		
		$data['n_topics'] = DB::table('topics')->where('topic_meeting_id',$request->current_mid)->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_status','3')->orderBy('topics.topic_id','DESC')->get();
		
		$data['p_topics'] = DB::table('topics')->where('topic_meeting_id',$request->current_mid)->join('siteusers as A' ,'A.user_id','=','topics.topic_created_by')->where('topics.topic_status','4')->orderBy('topics.topic_id','DESC')->get();
		
		
		
										
		

		
		
		$data['action_infos'] = DB::table('actions')->orderBy('a_id','DESC')->get();
		$data['topic_messages'] = DB::table('topic_discussion')->join('siteusers as A' ,'A.user_id','=','topic_discussion.d_user_id')->orderBy('topic_discussion.d_id','DESC')->get(); 

		
		

		
		
		// suggested topics with no votes
		

		
		

		
		
				
		/*$data['suggested_topics_with_no_votes'] = DB::table('topics')->join('topics_votes as A' ,'topics.topic_id','!=','A.vtopicid')->where('topics.topic_meeting_id',$request->current_mid)->groupBy('topics.topic_id')->get();*/	
		// suggested topics with no votes	
		
		// list of topics
		
		// list of topics
						
		/*return view('user/pdf_view',$data);
		exit();*/
		
        $pdf = PDF::loadView('user/sb_pdf_view', $data);
		$path = public_path('pdf/');  
		$fileName =  'sail-boat-summary-'.$tinfo.'.' . 'pdf' ;
		$pdf->save($path . '/' . $fileName);
        return $fileName;
		}
	}
			
}
