<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Mail;
use Carbon\Carbon;
class FrontLandingPageController extends Controller
{

    public function newcyberbahnlandingdetails(Request $request)
	{
		$course_id = $request->cid;
		
		$check_exist = DB::table('landing_training_details')->where('id',$course_id)->count();
		if($check_exist == 0)
		{
			return redirect('home');
		}
		else
		{
			$data['common'] = DB::table('settings')->where('id','1')->first();
			$data['section6'] = DB::table('client')->where('status','2')->get();		
			$data['each_course_details'] = DB::table('landing_training_details')->where('id',$course_id)->first();
			$data['course_details'] = DB::table('landing_courses')->where('id',$data['each_course_details']->course_id)->first();
			$data['venues'] = DB::table('venue')->where('status','2')->get();
			$data['trainer_name'] = DB::table('trainer')->where('id',$data['each_course_details']->crs_class_instr_id)->get();
			
			$data['other_course_details'] = DB::table('landing_training_details')->where('course_id',$data['each_course_details']->course_id)->where('status',"=",'2')->where('id','!=',$course_id)->get();
			
		}	
	
		return view('landingpage/newcyberbahnlandingdetails',$data);
	}
	
	
	
	public function testcyberbahnlandingdetails(Request $request)
	{
	
		$course_id = $request->cid;
		
		$check_exist = DB::table('landing_training_details')->where('id',$course_id)->count();
		if($check_exist == 0)
		{
			return redirect('home');
		}
		else
		{
			$data['common'] = DB::table('settings')->where('id','1')->first();
			$data['section6'] = DB::table('client')->where('status','2')->get();		
			$data['each_course_details'] = DB::table('landing_training_details')->where('id',$course_id)->first();
			
			$data['offline_venues'] = DB::table('venue')->where('status','2')->where('id',$data['each_course_details']->crs_class_venue_id)->first();
		
			
			$data['course_details'] = DB::table('landing_courses')->where('id',$data['each_course_details']->course_id)->first();
			$data['venues'] = DB::table('venue')->where('status','2')->get();
			
        $data['venue_assoc'] = DB::table('venue')
                ->selectRaw("CONCAT(venue,'-',city) as full,id")
                ->orderBy('venue','asc')->pluck('full','id')->toArray();
				
							
			$data['trainer_name'] = DB::table('trainer')->where('id',$data['each_course_details']->crs_class_instr_id)->get();
			
			$data['other_course_details'] = DB::table('landing_training_details')->where('course_id',$data['each_course_details']->course_id)->where('status',"=",'2')->where('id','!=',$course_id)->where('crs_date_start', '>', Carbon::now())->orderBy('crs_date_start','asc')->get();
			
		}	
	
		return view('landingpage/testcyberbahnlandingdetails',$data);
	
	}
	
	
    public function cyberbahnlandingdetails(Request $request)
	{
		$course_id = $request->cid;
		
		$check_exist = DB::table('landing_training_details')->where('id',$course_id)->count();
		if($check_exist == 0)
		{
			return redirect('home');
		}
		else
		{
			$data['common'] = DB::table('settings')->where('id','1')->first();
			$data['section6'] = DB::table('client')->where('status','2')->get();		
			$data['each_course_details'] = DB::table('landing_training_details')->where('id',$course_id)->first();
			
			
$ee = explode("tickets-",$data['each_course_details']->register_link);
$data["elinkid"]=$ee[1];
$data["elinkdet"] = 'eventbrite-widget-modal-trigger-'.$ee[1];


			
			$data['offline_venues'] = DB::table('venue')->where('status','2')->where('id',$data['each_course_details']->crs_class_venue_id)->first();
		
			
			$data['course_details'] = DB::table('landing_courses')->where('id',$data['each_course_details']->course_id)->first();
			$data['venues'] = DB::table('venue')->where('status','2')->get();
			
        $data['venue_assoc'] = DB::table('venue')
                ->selectRaw("CONCAT(venue,'-',city) as full,id")
                ->orderBy('venue','asc')->pluck('full','id')->toArray();
				
							
			$data['trainer_name'] = DB::table('trainer')->where('id',$data['each_course_details']->crs_class_instr_id)->get();
			
			if($data['each_course_details']->crs_class_instr_co_id != '')
			{
				$data['co_trainer_name'] = DB::table('trainer')->where('id',$data['each_course_details']->crs_class_instr_co_id)->get();
			}
			else
			{
				$data['co_trainer_name'] = '';
			}
			
			
			$data['other_course_details'] = DB::table('landing_training_details')->where('course_id',$data['each_course_details']->course_id)->where('status',"=",'2')->where('id','!=',$course_id)->where('crs_date_start', '>', Carbon::now())->orderBy('crs_date_start','asc')->get();
			
		}	
		
		$scrum_data = array('85','65','64','23');
		
		$req_id = $request->cid;
		
		if(in_array($req_id,$scrum_data))
		{
		     $scrum="1";
		}
		else{
		     $scrum="0";
		}
	
		return view('landingpage/cyberbahnlandingdetails',$data)->with('scrum',$scrum);
	}
	
	public function cyberbahnlandingpage(Request $request)
	{
		$course_title = $request->cname;
		
		$check_exist = DB::table('landing_courses')->where('slug',$course_title)->count();
		if($check_exist == 0)
		{
			return redirect('home');
		}	
		else
		{
			$data['course_details'] = DB::table('landing_courses')->where('slug',$course_title)->first();
			$data['each_course_details_count'] = DB::table('landing_training_details')->where('course_id',$data['course_details']->id)->count();
			if($data['each_course_details_count'] != 0)
			{
				$data['each_course_details'] = DB::table('landing_training_details')->where('course_id',$data['course_details']->id)->orderby('crs_date_start','ASC')->get();
			}
		}
		$data['common'] = DB::table('settings')->where('id','1')->first();
		$data['section6'] = DB::table('client')->where('status','2')->get();
		$data['venues'] = DB::table('venue')->where('status','2')->get();
		
		
		return view('landingpage/cyberbahnlandingpage',$data);
	}
	
	public function adddetails_downloadbroucher_test(Request $request)
	{
	
		// to add details into the database
		$todaydate = date("Y-m-d");
		$mid = DB::table('user_who_downloaded_broucher')->insert(['ufname' => $request->firstname,'ulname' => $request->lastname,'umobilenumber' =>$request->mobilenumber,'umessage' =>$request->message,'uemailid' =>$request->email,'udate' => $todaydate,'ucourseid' => $request->courseid]);		
		// to add details into the database
		
			$data['each_course_details'] = DB::table('landing_training_details')->where('id',$request->courseid)->first();
			$data['course_details'] = DB::table('landing_courses')->where('id',$data['each_course_details']->course_id)->first();
			
			$details= array(
			'email' => $request->email
			);	

				$sdata2['course_name'] = $data['course_details']->title;
				$sdata2['m_name'] = $request->firstname;
				$sdata2['m_emailid'] = $request->email;
				$sdata2['m_broucher'] = $data['course_details']->brouchare;
					
			$fullname=$request->firstname." ".$request->lastname;
			$sub = $sdata2['course_name']." Brochure downloaded by the user";
			$mdetails= array(
				'name' => trim($fullname),
				'email' =>  trim($request->email),
				'mobilenumber' =>  trim($request->mobilenumber),
				'message' =>  trim($request->message),
				'subject' =>  $sub,
				'evtitle' =>  trim($request->evtitle),
				'evfullurl' =>  trim($request->evfullurl),
				'evfulltime' =>  trim($request->evfulltime),
				'evvenue' =>  trim($request->evvenue),		
			);	
						
 			Mail::send('testbrouchermail', ['mdetails'=>$mdetails], function($message) use ($mdetails) {
			/*$bcc = array('prasanna@qf4tech.com' => 'Prasanna', 'ranjitm@qf4tech.com' => 'Ranjit', 'md.safeek@cyberbahnit.com' => 'MD Safeek');*/
			$bcc = array('kannanog@qf4tech.com' => 'Kannan','prasanna@cyberbahntas.com' => 'Prasanna');
            $message->to('kannanog@gmail.com', 'kannan')->bcc($bcc)->subject('Download Brochure Form - '.$mdetails['subject']);
            $message->from($mdetails["email"],$mdetails["name"]);
          });
		  
		  				
			
			Mail::send('downloadbroucher', $sdata2, function($message) use ($sdata2) {
			$subject_msg = "Thank you for showing interest in ".$sdata2['course_name'];
			$message->to($sdata2['m_emailid'])->subject($subject_msg);
			$message->from('info@cyberbahntas.com', 'CyberBahn - TAS');
			});	
							
										
		
		$results=array("msg"=>'success');
     	return response()->json($results);		
	
	}
	
	
	public function adddetails_downloadbroucher(Request $request)
	{
		// to add details into the database
		$todaydate = date("Y-m-d");
		$mid = DB::table('user_who_downloaded_broucher')->insert(['ufname' => $request->firstname,'ulname' => $request->lastname,'umobilenumber' =>$request->mobilenumber,'umessage' =>$request->message,'uemailid' =>$request->email,'udate' => $todaydate,'ucourseid' => $request->courseid]);		
		// to add details into the database
		
			$data['each_course_details'] = DB::table('landing_training_details')->where('id',$request->courseid)->first();
			$data['course_details'] = DB::table('landing_courses')->where('id',$data['each_course_details']->course_id)->first();
			
			$details= array(
			'email' => $request->email
			);	

				$sdata2['course_name'] = $data['course_details']->title;
				$sdata2['m_name'] = $request->firstname;
				$sdata2['m_emailid'] = $request->email;
				$sdata2['m_broucher'] = $data['course_details']->brouchare;
				
				
				
		$fullname=$request->firstname." ".$request->lastname;
		$sub = $sdata2['course_name']." Brochure downloaded by the user";
$mdetails= array(
	'name' => trim($fullname),
	'email' =>  trim($request->email),
	'mobilenumber' =>  trim($request->mobilenumber),
	'message' =>  trim($request->message),
	'subject' =>  $sub,
	'evtitle' =>  trim($request->evtitle),
	'evfullurl' =>  trim($request->evfullurl),
	'evfulltime' =>  trim($request->evfulltime),
	'evvenue' =>  trim($request->evvenue),			
);				
 			Mail::send('brouchermail', ['mdetails'=>$mdetails], function($message) use ($mdetails) {
			/*$bcc = array('prasanna@qf4tech.com' => 'Prasanna', 'ranjitm@qf4tech.com' => 'Ranjit', 'md.safeek@cyberbahnit.com' => 'MD Safeek');*/
			$bcc = array('kannanog@qf4tech.com' => 'Kannan','prasanna@cyberbahntas.com' => 'Prasanna','p.diana@cyberbahnit.com' => 'Preethi','saidappa@cyberbahntas.com' => 'Sai');
            $message->to('info@cyberbahnit.com', 'CyberBahn - TAS')->bcc($bcc)->subject('Download Brochure Form - '.$mdetails['subject']);
            $message->from($mdetails["email"],$mdetails["name"]);
          });
		  
		  				
			
			Mail::send('downloadbroucher', $sdata2, function($message) use ($sdata2) {
			$subject_msg = "Thank you for showing interest in ".$sdata2['course_name'];
			$message->to($sdata2['m_emailid'])->subject($subject_msg);
			$message->from('info@cyberbahntas.com', 'CyberBahn - TAS');
			});	
							
										
		
		$results=array("msg"=>'success');
     	return response()->json($results);		
	}
	
	
	public function adddetails_leadform_test(Request $request)
	{

		
		$fullname=$request->firstname." ".$request->lastname;
$details= array(
	'name' => trim($fullname),
	'email' =>  trim($request->email),
	'phonenumber' =>  trim($request->phonenumber),
	'message' =>  trim($request->message),
	'subject' =>  'lead form',
	'evtitle' =>  trim($request->evtitle),
	'evfullurl' =>  trim($request->evfullurl),
	'evfulltime' =>  trim($request->evfulltime),
	'evvenue' =>  trim($request->evvenue),		
);		

 			Mail::send('testleadformmail', ['details'=>$details], function($message) use ($details) {
			
			$bcc = array('kannanog@qf4tech.com' => 'Kannan','prasanna@cyberbahntas.com' => 'Prasanna');
            $message->to('kannanog@gmail.com', 'kannan')->bcc($bcc)->subject('Contact Form - '.$details['subject']);
            $message->from($details["email"],$details["name"]);
          });
		  
		  
		   Mail::send([], $details, function($message) use($details) {
                 $message->to($details["email"] , $details["name"])->subject
                    ('Thanks for reaching us - CyberBahn');
                $message->setBody('Dear '.$details["name"].',<br><br> <b style="text-align-center">
We have received your message and we will revert you back as soon as possible.<br><br>Thanks,<br><img class="mt-5 mb-20" alt="CyberBahn" src="'.url("public/front/images/small-logo.png").'">', 'text/html'); 

                 $message->from("info@cyberbahnit.com","CyberBahn");
              });
			  
			if(Mail::failures() && count(Mail::failures()) > 0 ) {
		$results=array("msg"=>'error');
     	
			}else
			{
			$results=array("msg"=>'success');
     	
			}			  
			  
			 return response()->json($results); 		
		
	}
	
	public function adddetails_leadform(Request $request)
	{
		$req_id = $request->eventid;
		
		$scrum_data = array('85','65','64','23');
		
		$fullname=$request->firstname." ".$request->lastname;
$details= array(
	'name' => trim($fullname),
	'email' =>  trim($request->email),
	'phonenumber' =>  trim($request->phonenumber),
	'message' =>  trim($request->message),
	'subject' =>  'lead form',
	'evtitle' =>  trim($request->evtitle),
	'evfullurl' =>  trim($request->evfullurl),
	'evfulltime' =>  trim($request->evfulltime),
	'evvenue' =>  trim($request->evvenue),		
);		

         if(in_array($req_id,$scrum_data))
		 {
 			Mail::send('leadformmail', ['details'=>$details], function($message) use ($details) {
			
			$bcc = array('kannanog@qf4tech.com' => 'Kannan','prasanna@cyberbahntas.com' => 'Prasanna','p.diana@cyberbahnit.com' => 'Preethi','saidappa@cyberbahntas.com' => 'Sai','sarthak@cyberbahnit.com' => 'Sarthak');
            $message->to('info@cyberbahnit.com', 'CyberBahn - TAS')->bcc($bcc)->subject('Contact Form - '.$details['subject']);
            $message->from($details["email"],$details["name"]);
			});
		}
		else{	
			
			Mail::send('leadformmail', ['details'=>$details], function($message) use ($details) {
			
			$bcc = array('kannanog@qf4tech.com' => 'Kannan','prasanna@cyberbahntas.com' => 'Prasanna','p.diana@cyberbahnit.com' => 'Preethi','saidappa@cyberbahntas.com' => 'Sai');
            $message->to('info@cyberbahnit.com', 'CyberBahn - TAS')->bcc($bcc)->subject('Contact Form - '.$details['subject']);
            $message->from($details["email"],$details["name"]);
			});
		}	
			
          
		  
		  
		   Mail::send([], $details, function($message) use($details) {
                 $message->to($details["email"] , $details["name"])->subject
                    ('Thanks for reaching us - CyberBahn');
                $message->setBody('Dear '.$details["name"].',<br><br> <b style="text-align-center">
We have received your message and we will revert you back as soon as possible.<br><br>Thanks,<br><img class="mt-5 mb-20" alt="CyberBahn" src="'.url("public/front/images/small-logo.png").'">', 'text/html'); 

                 $message->from("info@cyberbahnit.com","CyberBahn");
              });
			  
			if(Mail::failures() && count(Mail::failures()) > 0 ) {
		$results=array("msg"=>'error');
     	
			}else
			{
			$results=array("msg"=>'success');
     	
			}			  
			  
			 return response()->json($results); 		
	}
}
