@extends('layouts.default')
@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">
<?php
$sociallinks = App\Http\Controllers\Controller::sociallinks();
$subscriptiondetails = App\Http\Controllers\Controller::subscriptiondetails();

$fdate = date("Y-m-d");
$tdate = $subscriptiondetails->send_date;
$datetime1 = new DateTime($fdate);
$datetime2 = new DateTime($tdate);
$interval = $datetime1->diff($datetime2);
$days = $interval->format('%a');



?>
<style type="text/css">
.panel-body p{ color:#FFFFFF;}
#editmeeting_info .modal-dialog,
#editmeeting_info .modal-content {
   
    height: 600px;
}

#editmeeting_info .modal-body {
   
    max-height: calc(100% - 120px);
    overflow-y: scroll;
}



#newmeeting_new .modal-dialog,
#newmeeting_new .modal-content {
   
   height: 600px;
}

#newmeeting_new .modal-body {
   
    max-height: calc(100% - 120px);
    overflow-y: scroll;
}
</style>



<div id="page-banner-area" class="page-banner-area" style="background-image:url({{url('admin/dist/img/bannerimages/'.$totpbanner->b_image)}})">
  <!-- Subpage title start -->
  <div class="page-banner-title">
    <div class="text-center">
      <h2>Boards</h2>
      <ol class="breadcrumb">
        <li> <a href="{{url('/')}}">Home /</a> </li>
        <li>Boards</li>
      </ol>
    </div>
  </div>
  <!-- Subpage title end -->
</div>
<section class="ts-intro-content">
  <div class="container">
    <div class="row">
      <div class="col-lg-12">
        <h2 class="column-title"> Lean Coffee Brew </h2>
        <div class="intro-content-text">
          <div class="row" style="padding-bottom:20px">
            <div class="col-lg-12 col-md-12 wow fadeInUp" data-wow-duration="1.5s" data-wow-delay="400ms">
              <div class="alert alert-primary" role="alert">              
              @if($subscriptiondetails->sstatus == '1')
              You have <span data-bind="text:dayLeftInTrial">{{$days}}</span> days left on your Lean Coffee Brew {{$tinfo}}.
              @else
              <span class="myerror">Your current subscription was cancelled. </span>
              @endif              
              </div>
            </div>
          </div>
          @if($subscriptiondetails->sstatus == '1')
          <div class="d-flex ts-submit-btn"> <a href="#" class="ticket-btn btn view-speaker ts-image-popup"  data-toggle="modal" data-target="#newmeeting"  >New Meeting</a> </div>@endif
          @if(count($result) != 0)
         <div class="table-responsive"> <table class="table table-striped">
            <thead>
              <tr>               	             
                <th scope="col">Meeting Name</th>
                <th scope="col">Meeting Type</th>  
                <th scope="col">Barista</th>
                <th scope="col">Status</th>                
                <th scope="col">Date Created</th>
                <th scope="col">Action</th>
              </tr>
            </thead>
            <tbody>
            @foreach($result as $ab)
           
               <tr id="meeting_id_{{ $ab->meeting_id }}" class="disabled">               
                
                <td>
                
                @if($ab->meeting_type == '1')
                 @if($ab->meeting_end_status == '0')<a href='{{url('discussion')}}/{{$ab->meeting_id}}'>{{ucfirst($ab->meeting_name)}}</a><br />
                 
                 @if($ab->meeting_by == $userdetails->user_id)
                 @if($ab->meeting_by != $ab->meeting_host_by)
                 <a href='{{url('takehostback')}}/{{$userdetails->user_id}}/{{$ab->meeting_id}}'   class="ere_btn" style="padding:5px;">Take Host </a>
                 @endif
                  @endif
                 @else  {{ucfirst($ab->meeting_name)}} @endif
                @else
                 @if($ab->meeting_end_status == '0')<a href='{{url('agendameeting')}}/{{$ab->meeting_id}}'>{{ucfirst($ab->meeting_name)}}</a> @else  {{ucfirst($ab->meeting_name)}} @endif
                @endif
                     
                </td>
                <td>
                 @if($ab->meeting_type == '1') Lean Coffee Brew (Retrospective) @else Agenda-driven meeting @endif
                </td>
                
                <td>{{$ab->user_name}}</td>
                <td>
                 @if($ab->meeting_by == $userdetails->user_id)
                 @if($ab->meeting_end_status == '1') Meeting ended <br />
                 <a data-id="{{$ab->meeting_id}}"  class="ere_btn" id="changemeetingstatus" name="changemeetingstatus" style="padding:5px; color:#FFFFFF">Click here</a> to start meeting again.
                 @else  --- @endif
                 @else
                 @if($ab->meeting_end_status == '1') Meeting ended @else  --- @endif
        		 @endif
                </td>
                <td>{{ \Carbon\Carbon::parse($ab->meeting_date_created)->format('F d, Y')}}</td>
                <td>
                @if($ab->meeting_by == $userdetails->user_id)
                @if($ab->meeting_type == '1')
                <a class="edit-ab"  data-id="{{ $ab->meeting_id }}" href="javascript:void(0)" alt="Edit" title="Edit"><i class="fa fa-pencil"></i></a>&nbsp;&nbsp;
                <a class="delete-ab"  data-id="{{ $ab->meeting_id }}" href="javascript:void(0)" alt="Delete" title="Delete"><i class="fa fa-trash"></i></a>
                @else
                <a href="{{url('agendameeting')}}/{{$ab->meeting_id}}" alt="Edit" title="Edit"><i class="fa fa-pencil"></i></a>&nbsp;&nbsp;
                <a id="deleteagendameeting"  data-id="{{$ab->meeting_id}}"  href="javascript:void(0)" alt="Delete" title="Delete"><i class="fa fa-trash"></i></a>                
                @endif
                @endif
                </td>
              </tr>
            @endforeach  
                   
            </tbody>
          </table></div>
          @else
          <div align="center" style="color:#F60"><strong>Sorry no meetings available.</strong></div>
          @endif </div>
          
          
        <!-- single intro text end-->
      </div>
      <!-- col end-->
      <!-- col end-->
      <!-- col end-->
    </div>
    <!-- row end-->
  </div>
  <!-- container end-->
</section>


<div id="newmeeting" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Lean Coffee Brew Meeting</h4><button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
      <div class="modal-body">
        <div id="listfac">
          <form class="form-signin" name="create_meeting_form" id="create_meeting_form" action="" method="post">{{ csrf_field() }}
        <table class="table table-bordered">
              <tbody>
                <tr>
                  <td>Meeting Type</td>
                  <td>
                  <select class="form-control select2" name="mtype" id="mtype" required>
                  <option value="">Select</option>
                  <option value="1">Lean Coffee Brew (Retrospective)</option>
                  <option value="2">Agenda-driven meeting</option>
                  <option value="">Open Space</option>
                  <option value="">Communities of Practice</option>
                  <option value="">Lean Planning</option>
                  <option value="">Fishbone - 5 Whys</option>
                  <option value="">Agenda Driven</option>
                  <option value="">Story Mapping</option>
                  <option value="">SailBoat</option>
                  <option value="">Swot Analysis</option>
                  <option value="">Lean Canvas</option>
                  <option value="">Empathy Map</option>
                  <option value="">Value Stream</option>
                  <option value="">Mind Map</option>
                  <option value="">Portfolio Canvas</option>   
                  <option value="">Product Vision</option>                                                                                                                        
                  </select>
                  </td>
                </tr>
				 <tr>
                  <td>Meeting Name</td>
                  <td><input type="text" name="mname" id="mname" maxlength="50" AUTOCOMPLETE="OFF" class="form-control" required /></td>
                </tr>
                
                 <tr>
                  <td></td>
                  <td><button class="loginbtn btn-primary btn-small" type="submit" name="createmeeting" id="createmeeting">Create</button></td>
                </tr>
              </tbody>
            </table>
        </form>
        </div>
      </div>
      <!--<div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>-->
    </div>
  </div>
</div>



<div id="newmeeting_new" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Lean Coffee Brew Meeting</h4><button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
      <div class="modal-body">
        <div id="listfac">
          <form method="post" action="" name="attendeerequest_form" id="attendeerequest_form">
            {{ csrf_field() }}
           
             
             
             <div class="form-row">
                      <div class="form-group col-md-6">
                        <label for="inputEmail4">Meeting Name</label>
                        <input type="text" class="form-control" required name="mcname" id="mcname" maxlength="50" AUTOCOMPLETE="OFF">
                        <input type="text" class="form-control meetingidinfo" required name="mid" id="mid" style="display:none">
                      </div>
                       <div class="form-group col-md-6">
                        <label for="inputEmail4">Meeting Highest Vote</label><br />
                         <!--<input type="number"  class="form-control" required name="mcvote" id="mcvote" maxlength="5" AUTOCOMPLETE="OFF" min="1">-->
                         <!--<input type="radio" name="mcvote" id="mcvote" class="voteclass" value="1" checked="checked"/>&nbsp;1
                          <input type="radio" name="mcvote" id="mcvote" value="3" class="voteclass" />&nbsp;3
                           <input type="radio" name="mcvote" id="mcvote" value="5" class="voteclass" />&nbsp;5-->
                           @foreach($totalvoteslist as $tv)
                           <input type="radio" name="mcvote" id="mcvote" value="{{$tv->vcount}}" class="voteclass"  @if($tv->vcount == 1) checked="checked" @endif/>&nbsp;{{$tv->vcount}}
                           @endforeach
                      </div>
                      <div class="form-group col-md-6">
                        <label for="inputPassword4">Set Conference Link (Zoom)</label>
                        <input type="text" class="form-control" id="mconf_link" name="mconf_link" placeholder="e.g. https://zoom.us/j/1212121" >
                      </div>
                      <div class="form-group col-md-6">
                        <label for="inputPassword4">Zoom meeting password</label>
                        <input type="text" class="form-control" id="mconf_pwd" name="mconf_pwd"  >
                      </div>
                    </div>
                    
                           
            <label for="basic-url"><strong><br />Send Invite</strong><br />
            Enter the email address(es) of the people you want to invite to this board. </label>
            <div class="input-group">
              <!--<input type="email" class="form-control" required name="reqemail" id="reqemail" maxlength="50" AUTOCOMPLETE="OFF">-->
              <textarea class="form-control emailverifycheck" required name="reqemail" id="reqemail" AUTOCOMPLETE="OFF"></textarea>
              <span class="input-group-btn">
              <button class="btn btn-default" type="submit" name="aareqbutton" id="aareqbutton">+</button>
              </span> 
            </div>
            
                        	<p class="text-center" style="margin-bottom:0px;">(or)</p>
            <div class="input-group" >
            <input type="file" class="form-control"  name="impmailfl_new" id="impmailfl_new" onchange="return csvfileValidation_new()" accept=".csv">
             
              <span class="input-group-btn">
              <button class="btn btn-default" type="button" name="impmailbtn_new" id="impmailbtn_new"><i class="fa fa-upload"></i></button>
              </span> 
            </div>
            (File format : .csv)
            <div id="impmailload_new">&nbsp;</div>
            
            
            <div id="hideguestlink">
            <p><br />Allow any guest with a board link URL to join</p>
            <p id="texttocopy2" style="display:none"> </p>
            <div class="input-group">
              <input type="text" class="form-control"  name="guesturl2" id="guesturl2" readonly="readonly">
              <span class="input-group-btn">
              <button class="btn btn-default" type="button" name="aareqbutton" id="aareqbutton" onclick="copyToClipboard('#texttocopy2')">Copy URL</button>
              </span> 
            </div>
            </div>
             <input type="checkbox" name="dontallowguests" id="dontallowguests" value="1" />&nbsp;Allow Only Participants<br />
            <p id="loadingimage" style="display:none"><img src="{{url('user/images/emailsending.gif')}}" /></p>
            <label for="basic-url"><strong><br />Participants</strong></label>
            <div id="listattendees"></div>
          </form>
          
        </div>
      </div>
      
    </div>
  </div>
</div>

<div id="editmeeting_info" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content" id="editmeet_info">
      <div class="modal-header">
        <h4 class="modal-title">Lean Coffee Brew Meeting</h4> <!--<button type="button" class="btn btn-default" data-dismiss="modal">Back</button>--><button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
      <div class="modal-body">
        <div id="listfac">
          <form method="post" action="" name="attendeerequest_editform" id="attendeerequest_editform">
            {{ csrf_field() }}
           
             
             <div class="form-row">
                      <div class="form-group col-md-6">
                        <label for="inputEmail4">Meeting Name</label>
                        <input type="text" class="form-control" required name="emcname" id="emcname" maxlength="50" AUTOCOMPLETE="OFF">
                       <input type="text" class="form-control meetingidinfo" required name="emid" id="emid" style="display:none">
                        <input type="text" class="form-control" required name="cvotecount" id="cvotecount" style="display:none">
                      </div>
                      <div class="form-group col-md-6">
                        <label for="inputEmail4">Meeting Highest Vote</label><br />
                        <span id="votelistedit"></span>                      
                      </div>
                      <div class="form-group col-md-6">
                        <label for="inputPassword4">Set Conference Link (Zoom)</label>
                        <input type="text" class="form-control" id="emconf_link" name="emconf_link" placeholder="e.g. https://zoom.us/j/1212121" >
                      </div>
                     
                      <div class="form-group col-md-6">
                        <label for="inputPassword4">Zoom meeting password</label>
                        <input type="text" class="form-control" id="emconf_pwd" name="emconf_pwd"  >
                      </div>
                    </div>
                    
                                 
            <label for="basic-url"><strong><br />Send Invite</strong><br />
            Enter the email address(es) of the people you want to invite to this board. </label>
            <div class="input-group">
              <!--<input type="text" class="form-control" required name="reqemail2" id="reqemail2" maxlength="500" AUTOCOMPLETE="OFF">-->
              <textarea class="form-control emailverifycheck" required name="reqemail2" id="reqemail2" AUTOCOMPLETE="OFF"></textarea>
              <span class="input-group-btn">
              <button class="btn btn-default" type="submit" name="aareqbutton" id="aareqbutton">+</button>
              </span> 
            </div>
            
            	<p class="text-center" style="margin-bottom:0px;">(or)</p>
            <div class="input-group" >
            <input type="file" class="form-control"  name="impmailfl" id="impmailfl" onchange="return csvfileValidation()" accept=".csv">
             
              <span class="input-group-btn">
              <button class="btn btn-default" type="button" name="impmailbtn" id="impmailbtn"><i class="fa fa-upload"></i></button>
              </span> 
            </div>
            (File format : .csv)
            <div id="impmailload">&nbsp;</div>
            
            
            <div id="hideguestlink_edit" >
            <p><br />Allow any guest with a board link URL to join</p>
            <p id="texttocopy" style="display:none"> </p>
            <div class="input-group">
              <input type="text" class="form-control"  name="guesturl" id="guesturl" readonly="readonly">
              <span class="input-group-btn">
              <button class="btn btn-default" type="button" name="aareqbutton" id="aareqbutton" onclick="copyToClipboard('#texttocopy')">Copy URL</button>
              </span> 
            </div>
            </div>
<input type="checkbox" name="dontallowguests_edit" id="dontallowguests_edit" value="1" />&nbsp;Allow Only Participants<br />
           <p id="loadingimage2" style="display:none"><img src="{{url('user/images/emailsending.gif')}}" /></p>
            <label for="basic-url"><strong><br />Participants</strong></label>
            <div id="elistattendees"></div>
          </form>
          
        </div>
      </div>
      
    </div>
  </div>
</div>


@stop