<meta name="csrf-token" content="{{ csrf_token() }}">
@include('common.adminheader')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Upload Image</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{url('admin/home')}}">Home</a></li>
              <li class="breadcrumb-item active">Upload Image</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <form method="post"  name="image_upload_form" id="image_upload_form" enctype="multipart/form-data">
       {{ csrf_field() }}
      <div class="row">
        <div class="col-md-12">
          <div class="card card-primary">
            <div class="card-header"></div>
            <div class="card-body">
            <div class="form-group">
                    <label for="exampleInputFile">Profile Image</label>
                    <div class="input-group">
                      <div class="custom-file">
                        <input type="file" name="exampleInputFile" class="custom-file-input" id="exampleInputFile" onChange="showPreview(this);" >
                        <label class="custom-file-label" for="exampleInputFile">Choose image</label>
                      </div>
                     
                    </div>
                  </div>
              
             <br />
   <span id="uploaded_image"></span>
              
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        
      </div>
      <div class="row">
        <div class="col-12">
          <a href="{{url('admin/home')}}" class="btn btn-secondary">CANCEL</a>
          <input type="submit" value="Upload Image" class="btn btn-success float-right">
        </div>
      </div>
      <div>&nbsp;</div>
      </form>
    </section>
    <!-- /.content -->
  </div>
@include('common.adminfooter')
<!-- Form validation starts here -->
<script type="text/javascript" src="{{url('admin/dist/js/jquery.validate.min.js')}}"></script>

<script type="text/javascript">
function showPreview(objFileInput) {
    if (objFileInput.files[0]) {
        var fileReader = new FileReader();
        fileReader.onload = function (e) {
            //$('#blah').attr('src', e.target.result);
			$("#uploaded_image").html('<img src="'+e.target.result+'" width="200px" height="200px" class="upload-preview" />');
			$("#uploaded_image").css('opacity','0.7');
			//$(".icon-choose-image").css('opacity','0.5');
        }
		fileReader.readAsDataURL(objFileInput.files[0]);
    }
}


$(document).ready(function(){

 $('#image_upload_form').on('submit', function(e){
  e.preventDefault();
  $.ajax({
   url:"uploadimage",
   method:"POST",
   data:  new FormData(this),
   dataType:'JSON',
   contentType: false,
   cache: false,
   processData: false,
   success:function(data)
   {
   	if(data.status == 0)
	{
		toastr.error(data.message);
	}
	else
	{
		toastr.success(data.message);
	}
   }
  })
 });

});
</script>


<!-- Form validation ends here -->