<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="csrf-token" content="{{ csrf_token() }}">
<title>Lean Coffee Brew | Forgot Password</title>
<!-- Tell the browser to be responsive to screen width -->
<meta name="viewport" content="width=device-width, initial-scale=1">
<!-- Font Awesome -->
<link rel="stylesheet" href="{{url('admin/plugins/fontawesome-free/css/all.min.css')}}">
<!-- Ionicons -->
<link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
<!-- icheck bootstrap -->
<link rel="stylesheet" href="{{url('admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css')}}">
<!-- Theme style -->
<link rel="stylesheet" href="{{url('admin/dist/css/adminlte.min.css')}}">
<!-- Google Font: Source Sans Pro -->
<link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
<link rel="stylesheet" href="{{url('admin/dist/css/toastr.min.css')}}">
</head>
<body class="hold-transition login-page">
@foreach ($errors->all() as $error)
<input type="text" name="errorinfo" id="errorinfo" value="{{ $error }}" style="display:none">
@endforeach
<div class="login-box">
  <div class="login-logo"> <a href="#"><b>QF4</b>Technologies</a> </div>
  <!-- /.login-logo -->
  <div class="card">
    <div class="card-body login-card-body">
      <p class="login-box-msg">You forgot your password? Here you can easily retrieve a new password.</p>
      <form action="" method="post" name="forget_form" id="forget_form">
        <div class="input-group mb-3">
          <input type="text" class="form-control" placeholder="Email" name="emailid" id="emailid">
          <div class="input-group-append">
            <div class="input-group-text"> <span class="fas fa-envelope"></span> </div>
          </div>
        </div>
        <div id="emailid_error" style="color:#FF0000"></div>
        <div id='error-container' class="myerror">{{ $errors->login->first('emailid') }}</div>
        <div class="row">
          <div class="col-12">
            <button type="submit" class="btn btn-primary btn-block">Request new password</button>
          </div>
          <!-- /.col -->
        </div>
      </form>
      <p class="mt-3 mb-1"> <a href="{{url('admin/index')}}">Login</a> </p>
    </div>
    <!-- /.login-card-body -->
  </div>
</div>
<!-- /.login-box -->
<!-- jQuery -->
<script src="{{url('admin/plugins/jquery/jquery.min.js')}}"></script>
<!-- Bootstrap 4 -->
<script src="{{url('admin/plugins/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
<!-- AdminLTE App -->
<script src="{{url('admin/dist/js/adminlte.min.js')}}"></script>
<script>
$("#error_notification").fadeTo(2000, 500).slideUp(500, function(){
    $("#error_notification").slideUp(500);
});
</script>
<script type="text/javascript" src="{{url('admin/dist/js/jquery.validate.min.js')}}"></script>
<script src="{{url('admin/dist/js/toastr.min.js')}}"></script>
<script type="text/javascript">

$(document).ready(function(){
$("#forget_form").validate({
errorPlacement: function(error, element) {
if (element.attr("name") == "emailid") {
error.insertAfter('#emailid_error');
}		
else {
error.insertAfter(element);
}
},
rules: {
emailid: {
required: true,
email:true	
}			
},	
messages: {
emailid: {
required: '<font color="#bd1a00"  style="font-family:Arial, Helvetica, sans-serif; font-size:11px; font-weight:bold">Please enter your emailid</font>',
email: '<font color="#bd1a00"  style="font-family:Arial, Helvetica, sans-serif; font-size:11px; font-weight:bold">Please enter valid emailid</font>'
}
},
submitHandler: function(form) {
$.ajaxSetup({
headers: {
'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
}
});
$.ajax({

data: $('#forget_form').serialize(),
url: "forgetpassword",
type: "POST",
dataType: 'json',

success: function (data) {
	if(data.status == 0)
	{
		toastr.error(data.message);
	}
	else
	{
		toastr.success(data.message);
	}
},
error: function (data) {
	toastr.error(data);
}

});

}
});
});
</script>
</body>
</html>
@foreach ($errors->all() as $error)
<script type="text/javascript">
var v = $('#errorinfo').val();
toastr.error(v);</script>
@endforeach