/******/ (function(modules) { // webpackBootstrap

/******/ 	// The module cache

/******/ 	var installedModules = {};

/******/

/******/ 	// The require function

/******/ 	function __webpack_require__(moduleId) {

/******/

/******/ 		// Check if module is in cache

/******/ 		if(installedModules[moduleId]) {

/******/ 			return installedModules[moduleId].exports;

/******/ 		}

/******/ 		// Create a new module (and put it into the cache)

/******/ 		var module = installedModules[moduleId] = {

/******/ 			i: moduleId,

/******/ 			l: false,

/******/ 			exports: {}

/******/ 		};

/******/

/******/ 		// Execute the module function

/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/

/******/ 		// Flag the module as loaded

/******/ 		module.l = true;

/******/

/******/ 		// Return the exports of the module

/******/ 		return module.exports;

/******/ 	}

/******/

/******/

/******/ 	// expose the modules object (__webpack_modules__)

/******/ 	__webpack_require__.m = modules;

/******/

/******/ 	// expose the module cache

/******/ 	__webpack_require__.c = installedModules;

/******/

/******/ 	// define getter function for harmony exports

/******/ 	__webpack_require__.d = function(exports, name, getter) {

/******/ 		if(!__webpack_require__.o(exports, name)) {

/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });

/******/ 		}

/******/ 	};

/******/

/******/ 	// define __esModule on exports

/******/ 	__webpack_require__.r = function(exports) {

/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {

/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

/******/ 		}

/******/ 		Object.defineProperty(exports, '__esModule', { value: true });

/******/ 	};

/******/

/******/ 	// create a fake namespace object

/******/ 	// mode & 1: value is a module id, require it

/******/ 	// mode & 2: merge all properties of value into the ns

/******/ 	// mode & 4: return value when already ns object

/******/ 	// mode & 8|1: behave like require

/******/ 	__webpack_require__.t = function(value, mode) {

/******/ 		if(mode & 1) value = __webpack_require__(value);

/******/ 		if(mode & 8) return value;

/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;

/******/ 		var ns = Object.create(null);

/******/ 		__webpack_require__.r(ns);

/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });

/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));

/******/ 		return ns;

/******/ 	};

/******/

/******/ 	// getDefaultExport function for compatibility with non-harmony modules

/******/ 	__webpack_require__.n = function(module) {

/******/ 		var getter = module && module.__esModule ?

/******/ 			function getDefault() { return module['default']; } :

/******/ 			function getModuleExports() { return module; };

/******/ 		__webpack_require__.d(getter, 'a', getter);

/******/ 		return getter;

/******/ 	};

/******/

/******/ 	// Object.prototype.hasOwnProperty.call

/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };

/******/

/******/ 	// __webpack_public_path__

/******/ 	__webpack_require__.p = "/";

/******/

/******/

/******/ 	// Load entry module and return exports

/******/ 	return __webpack_require__(__webpack_require__.s = 0);

/******/ })

/************************************************************************/

/******/ ({



/***/ "./node_modules/autolinker/dist/Autolinker.js":

/*!****************************************************!*\

  !*** ./node_modules/autolinker/dist/Autolinker.js ***!

  \****************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!

 * Autolinker.js

 * 1.8.3

 *

 * Copyright(c) 2018 Gregory Jacobs <greg@greg-jacobs.com>

 * MIT License

 *

 * https://github.com/gregjacobs/Autolinker.js

 */

;(function(root, factory) {

  if (true) {

    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),

				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?

				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),

				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

  } else {}

}(this, function() {

/**

 * @class Autolinker

 * @extends Object

 *

 * Utility class used to process a given string of text, and wrap the matches in

 * the appropriate anchor (&lt;a&gt;) tags to turn them into links.

 *

 * Any of the configuration options may be provided in an Object (map) provided

 * to the Autolinker constructor, which will configure how the {@link #link link()}

 * method will process the links.

 *

 * For example:

 *

 *     var autolinker = new Autolinker( {

 *         newWindow : false,

 *         truncate  : 30

 *     } );

 *

 *     var html = autolinker.link( "Joe went to www.yahoo.com" );

 *     // produces: 'Joe went to <a href="http://www.yahoo.com">yahoo.com</a>'

 *

 *

 * The {@link #static-link static link()} method may also be used to inline

 * options into a single call, which may be more convenient for one-off uses.

 * For example:

 *

 *     var html = Autolinker.link( "Joe went to www.yahoo.com", {

 *         newWindow : false,

 *         truncate  : 30

 *     } );

 *     // produces: 'Joe went to <a href="http://www.yahoo.com">yahoo.com</a>'

 *

 *

 * ## Custom Replacements of Links

 *

 * If the configuration options do not provide enough flexibility, a {@link #replaceFn}

 * may be provided to fully customize the output of Autolinker. This function is

 * called once for each URL/Email/Phone#/Hashtag/Mention (Twitter, Instagram, Soundcloud)

 * match that is encountered.

 *

 * For example:

 *

 *     var input = "...";  // string with URLs, Email Addresses, Phone #s, Hashtags, and Mentions (Twitter, Instagram, Soundcloud)

 *

 *     var linkedText = Autolinker.link( input, {

 *         replaceFn : function( match ) {

 *             console.log( "href = ", match.getAnchorHref() );

 *             console.log( "text = ", match.getAnchorText() );

 *

 *             switch( match.getType() ) {

 *                 case 'url' :

 *                     console.log( "url: ", match.getUrl() );

 *

 *                     if( match.getUrl().indexOf( 'mysite.com' ) === -1 ) {

 *                         var tag = match.buildTag();  // returns an `Autolinker.HtmlTag` instance, which provides mutator methods for easy changes

 *                         tag.setAttr( 'rel', 'nofollow' );

 *                         tag.addClass( 'external-link' );

 *

 *                         return tag;

 *

 *                     } else {

 *                         return true;  // let Autolinker perform its normal anchor tag replacement

 *                     }

 *

 *                 case 'email' :

 *                     var email = match.getEmail();

 *                     console.log( "email: ", email );

 *

 *                     if( email === "my@own.address" ) {

 *                         return false;  // don't auto-link this particular email address; leave as-is

 *                     } else {

 *                         return;  // no return value will have Autolinker perform its normal anchor tag replacement (same as returning `true`)

 *                     }

 *

 *                 case 'phone' :

 *                     var phoneNumber = match.getPhoneNumber();

 *                     console.log( phoneNumber );

 *

 *                     return '<a href="http://newplace.to.link.phone.numbers.to/">' + phoneNumber + '</a>';

 *

 *                 case 'hashtag' :

 *                     var hashtag = match.getHashtag();

 *                     console.log( hashtag );

 *

 *                     return '<a href="http://newplace.to.link.hashtag.handles.to/">' + hashtag + '</a>';

 *

 *                 case 'mention' :

 *                     var mention = match.getMention();

 *                     console.log( mention );

 *

 *                     return '<a href="http://newplace.to.link.mention.to/">' + mention + '</a>';

 *             }

 *         }

 *     } );

 *

 *

 * The function may return the following values:

 *

 * - `true` (Boolean): Allow Autolinker to replace the match as it normally

 *   would.

 * - `false` (Boolean): Do not replace the current match at all - leave as-is.

 * - Any String: If a string is returned from the function, the string will be

 *   used directly as the replacement HTML for the match.

 * - An {@link Autolinker.HtmlTag} instance, which can be used to build/modify

 *   an HTML tag before writing out its HTML text.

 *

 * @constructor

 * @param {Object} [cfg] The configuration options for the Autolinker instance,

 *   specified in an Object (map).

 */

var Autolinker = function( cfg ) {

	cfg = cfg || {};



	this.version = Autolinker.version;



	this.urls = this.normalizeUrlsCfg( cfg.urls );

	this.email = typeof cfg.email === 'boolean' ? cfg.email : true;

	this.phone = typeof cfg.phone === 'boolean' ? cfg.phone : true;

	this.hashtag = cfg.hashtag || false;

	this.mention = cfg.mention || false;

	this.newWindow = typeof cfg.newWindow === 'boolean' ? cfg.newWindow : true;

	this.stripPrefix = this.normalizeStripPrefixCfg( cfg.stripPrefix );

	this.stripTrailingSlash = typeof cfg.stripTrailingSlash === 'boolean' ? cfg.stripTrailingSlash : true;

	this.decodePercentEncoding = typeof cfg.decodePercentEncoding === 'boolean' ? cfg.decodePercentEncoding : true;



	// Validate the value of the `mention` cfg

	var mention = this.mention;

	if( mention !== false && mention !== 'twitter' && mention !== 'instagram'  && mention !== 'soundcloud' ) {

		throw new Error( "invalid `mention` cfg - see docs" );

	}



	// Validate the value of the `hashtag` cfg

	var hashtag = this.hashtag;

	if( hashtag !== false && hashtag !== 'twitter' && hashtag !== 'facebook' && hashtag !== 'instagram' ) {

		throw new Error( "invalid `hashtag` cfg - see docs" );

	}



	this.truncate = this.normalizeTruncateCfg( cfg.truncate );

	this.className = cfg.className || '';

	this.replaceFn = cfg.replaceFn || null;

	this.context = cfg.context || this;



	this.htmlParser = null;

	this.matchers = null;

	this.tagBuilder = null;

};







/**

 * Automatically links URLs, Email addresses, Phone Numbers, Twitter handles,

 * Hashtags, and Mentions found in the given chunk of HTML. Does not link URLs

 * found within HTML tags.

 *

 * For instance, if given the text: `You should go to http://www.yahoo.com`,

 * then the result will be `You should go to &lt;a href="http://www.yahoo.com"&gt;http://www.yahoo.com&lt;/a&gt;`

 *

 * Example:

 *

 *     var linkedText = Autolinker.link( "Go to google.com", { newWindow: false } );

 *     // Produces: "Go to <a href="http://google.com">google.com</a>"

 *

 * @static

 * @param {String} textOrHtml The HTML or text to find matches within (depending

 *   on if the {@link #urls}, {@link #email}, {@link #phone}, {@link #mention},

 *   {@link #hashtag}, and {@link #mention} options are enabled).

 * @param {Object} [options] Any of the configuration options for the Autolinker

 *   class, specified in an Object (map). See the class description for an

 *   example call.

 * @return {String} The HTML text, with matches automatically linked.

 */

Autolinker.link = function( textOrHtml, options ) {

	var autolinker = new Autolinker( options );

	return autolinker.link( textOrHtml );

};







/**

 * Parses the input `textOrHtml` looking for URLs, email addresses, phone

 * numbers, username handles, and hashtags (depending on the configuration

 * of the Autolinker instance), and returns an array of {@link Autolinker.match.Match}

 * objects describing those matches (without making any replacements).

 *

 * Note that if parsing multiple pieces of text, it is slightly more efficient

 * to create an Autolinker instance, and use the instance-level {@link #parse}

 * method.

 *

 * Example:

 *

 *     var matches = Autolinker.parse( "Hello google.com, I am asdf@asdf.com", {

 *         urls: true,

 *         email: true

 *     } );

 *

 *     console.log( matches.length );           // 2

 *     console.log( matches[ 0 ].getType() );   // 'url'

 *     console.log( matches[ 0 ].getUrl() );    // 'google.com'

 *     console.log( matches[ 1 ].getType() );   // 'email'

 *     console.log( matches[ 1 ].getEmail() );  // 'asdf@asdf.com'

 *

 * @static

 * @param {String} textOrHtml The HTML or text to find matches within

 *   (depending on if the {@link #urls}, {@link #email}, {@link #phone},

 *   {@link #hashtag}, and {@link #mention} options are enabled).

 * @param {Object} [options] Any of the configuration options for the Autolinker

 *   class, specified in an Object (map). See the class description for an

 *   example call.

 * @return {Autolinker.match.Match[]} The array of Matches found in the

 *   given input `textOrHtml`.

 */

Autolinker.parse = function( textOrHtml, options ) {

	var autolinker = new Autolinker( options );

	return autolinker.parse( textOrHtml );

};





/**

 * @static

 * @property {String} version (readonly)

 *

 * The Autolinker version number in the form major.minor.patch

 *

 * Ex: 0.25.1

 */

Autolinker.version = '1.8.3';





Autolinker.prototype = {

	constructor : Autolinker,  // fix constructor property



	/**

	 * @cfg {Boolean/Object} [urls]

	 *

	 * `true` if URLs should be automatically linked, `false` if they should not

	 * be. Defaults to `true`.

	 *

	 * Examples:

	 *

	 *     urls: true

	 *

	 *     // or

	 *

	 *     urls: {

	 *         schemeMatches : true,

	 *         wwwMatches    : true,

	 *         tldMatches    : true

	 *     }

	 *

	 * As shown above, this option also accepts an Object form with 3 properties

	 * to allow for more customization of what exactly gets linked. All default

	 * to `true`:

	 *

	 * @cfg {Boolean} [urls.schemeMatches] `true` to match URLs found prefixed

	 *   with a scheme, i.e. `http://google.com`, or `other+scheme://google.com`,

	 *   `false` to prevent these types of matches.

	 * @cfg {Boolean} [urls.wwwMatches] `true` to match urls found prefixed with

	 *   `'www.'`, i.e. `www.google.com`. `false` to prevent these types of

	 *   matches. Note that if the URL had a prefixed scheme, and

	 *   `schemeMatches` is true, it will still be linked.

	 * @cfg {Boolean} [urls.tldMatches] `true` to match URLs with known top

	 *   level domains (.com, .net, etc.) that are not prefixed with a scheme or

	 *   `'www.'`. This option attempts to match anything that looks like a URL

	 *   in the given text. Ex: `google.com`, `asdf.org/?page=1`, etc. `false`

	 *   to prevent these types of matches.

	 */



	/**

	 * @cfg {Boolean} [email=true]

	 *

	 * `true` if email addresses should be automatically linked, `false` if they

	 * should not be.

	 */



	/**

	 * @cfg {Boolean} [phone=true]

	 *

	 * `true` if Phone numbers ("(555)555-5555") should be automatically linked,

	 * `false` if they should not be.

	 */



	/**

	 * @cfg {Boolean/String} [hashtag=false]

	 *

	 * A string for the service name to have hashtags (ex: "#myHashtag")

	 * auto-linked to. The currently-supported values are:

	 *

	 * - 'twitter'

	 * - 'facebook'

	 * - 'instagram'

	 *

	 * Pass `false` to skip auto-linking of hashtags.

	 */



	/**

	 * @cfg {String/Boolean} [mention=false]

	 *

	 * A string for the service name to have mentions (ex: "@myuser")

	 * auto-linked to. The currently supported values are:

	 *

	 * - 'twitter'

	 * - 'instagram'

	 * - 'soundcloud'

	 *

	 * Defaults to `false` to skip auto-linking of mentions.

	 */



	/**

	 * @cfg {Boolean} [newWindow=true]

	 *

	 * `true` if the links should open in a new window, `false` otherwise.

	 */



	/**

	 * @cfg {Boolean/Object} [stripPrefix]

	 *

	 * `true` if 'http://' (or 'https://') and/or the 'www.' should be stripped

	 * from the beginning of URL links' text, `false` otherwise. Defaults to

	 * `true`.

	 *

	 * Examples:

	 *

	 *     stripPrefix: true

	 *

	 *     // or

	 *

	 *     stripPrefix: {

	 *         scheme : true,

	 *         www    : true

	 *     }

	 *

	 * As shown above, this option also accepts an Object form with 2 properties

	 * to allow for more customization of what exactly is prevented from being

	 * displayed. Both default to `true`:

	 *

	 * @cfg {Boolean} [stripPrefix.scheme] `true` to prevent the scheme part of

	 *   a URL match from being displayed to the user. Example:

	 *   `'http://google.com'` will be displayed as `'google.com'`. `false` to

	 *   not strip the scheme. NOTE: Only an `'http://'` or `'https://'` scheme

	 *   will be removed, so as not to remove a potentially dangerous scheme

	 *   (such as `'file://'` or `'javascript:'`)

	 * @cfg {Boolean} [stripPrefix.www] www (Boolean): `true` to prevent the

	 *   `'www.'` part of a URL match from being displayed to the user. Ex:

	 *   `'www.google.com'` will be displayed as `'google.com'`. `false` to not

	 *   strip the `'www'`.

	 */



	/**

	 * @cfg {Boolean} [stripTrailingSlash=true]

	 *

	 * `true` to remove the trailing slash from URL matches, `false` to keep

	 *  the trailing slash.

	 *

	 *  Example when `true`: `http://google.com/` will be displayed as

	 *  `http://google.com`.

	 */



	/**

	 * @cfg {Boolean} [decodePercentEncoding=true]

	 *

	 * `true` to decode percent-encoded characters in URL matches, `false` to keep

	 *  the percent-encoded characters.

	 *

	 *  Example when `true`: `https://en.wikipedia.org/wiki/San_Jos%C3%A9` will

	 *  be displayed as `https://en.wikipedia.org/wiki/San_José`.

	 */



	/**

	 * @cfg {Number/Object} [truncate=0]

	 *

	 * ## Number Form

	 *

	 * A number for how many characters matched text should be truncated to

	 * inside the text of a link. If the matched text is over this number of

	 * characters, it will be truncated to this length by adding a two period

	 * ellipsis ('..') to the end of the string.

	 *

	 * For example: A url like 'http://www.yahoo.com/some/long/path/to/a/file'

	 * truncated to 25 characters might look something like this:

	 * 'yahoo.com/some/long/pat..'

	 *

	 * Example Usage:

	 *

	 *     truncate: 25

	 *

	 *

	 *  Defaults to `0` for "no truncation."

	 *

	 *

	 * ## Object Form

	 *

	 * An Object may also be provided with two properties: `length` (Number) and

	 * `location` (String). `location` may be one of the following: 'end'

	 * (default), 'middle', or 'smart'.

	 *

	 * Example Usage:

	 *

	 *     truncate: { length: 25, location: 'middle' }

	 *

	 * @cfg {Number} [truncate.length=0] How many characters to allow before

	 *   truncation will occur. Defaults to `0` for "no truncation."

	 * @cfg {"end"/"middle"/"smart"} [truncate.location="end"]

	 *

	 * - 'end' (default): will truncate up to the number of characters, and then

	 *   add an ellipsis at the end. Ex: 'yahoo.com/some/long/pat..'

	 * - 'middle': will truncate and add the ellipsis in the middle. Ex:

	 *   'yahoo.com/s..th/to/a/file'

	 * - 'smart': for URLs where the algorithm attempts to strip out unnecessary

	 *   parts first (such as the 'www.', then URL scheme, hash, etc.),

	 *   attempting to make the URL human-readable before looking for a good

	 *   point to insert the ellipsis if it is still too long. Ex:

	 *   'yahoo.com/some..to/a/file'. For more details, see

	 *   {@link Autolinker.truncate.TruncateSmart}.

	 */



	/**

	 * @cfg {String} className

	 *

	 * A CSS class name to add to the generated links. This class will be added

	 * to all links, as well as this class plus match suffixes for styling

	 * url/email/phone/hashtag/mention links differently.

	 *

	 * For example, if this config is provided as "myLink", then:

	 *

	 * - URL links will have the CSS classes: "myLink myLink-url"

	 * - Email links will have the CSS classes: "myLink myLink-email", and

	 * - Phone links will have the CSS classes: "myLink myLink-phone"

	 * - Hashtag links will have the CSS classes: "myLink myLink-hashtag"

	 * - Mention links will have the CSS classes: "myLink myLink-mention myLink-[type]"

	 *   where [type] is either "instagram", "twitter" or "soundcloud"

	 */



	/**

	 * @cfg {Function} replaceFn

	 *

	 * A function to individually process each match found in the input string.

	 *

	 * See the class's description for usage.

	 *

	 * The `replaceFn` can be called with a different context object (`this`

	 * reference) using the {@link #context} cfg.

	 *

	 * This function is called with the following parameter:

	 *

	 * @cfg {Autolinker.match.Match} replaceFn.match The Match instance which

	 *   can be used to retrieve information about the match that the `replaceFn`

	 *   is currently processing. See {@link Autolinker.match.Match} subclasses

	 *   for details.

	 */



	/**

	 * @cfg {Object} context

	 *

	 * The context object (`this` reference) to call the `replaceFn` with.

	 *

	 * Defaults to this Autolinker instance.

	 */





	/**

	 * @property {String} version (readonly)

	 *

	 * The Autolinker version number in the form major.minor.patch

	 *

	 * Ex: 0.25.1

	 */



	/**

	 * @private

	 * @property {Autolinker.htmlParser.HtmlParser} htmlParser

	 *

	 * The HtmlParser instance used to skip over HTML tags, while finding text

	 * nodes to process. This is lazily instantiated in the {@link #getHtmlParser}

	 * method.

	 */



	/**

	 * @private

	 * @property {Autolinker.matcher.Matcher[]} matchers

	 *

	 * The {@link Autolinker.matcher.Matcher} instances for this Autolinker

	 * instance.

	 *

	 * This is lazily created in {@link #getMatchers}.

	 */



	/**

	 * @private

	 * @property {Autolinker.AnchorTagBuilder} tagBuilder

	 *

	 * The AnchorTagBuilder instance used to build match replacement anchor tags.

	 * Note: this is lazily instantiated in the {@link #getTagBuilder} method.

	 */





	/**

	 * Normalizes the {@link #urls} config into an Object with 3 properties:

	 * `schemeMatches`, `wwwMatches`, and `tldMatches`, all Booleans.

	 *

	 * See {@link #urls} config for details.

	 *

	 * @private

	 * @param {Boolean/Object} urls

	 * @return {Object}

	 */

	normalizeUrlsCfg : function( urls ) {

		if( urls == null ) urls = true;  // default to `true`



		if( typeof urls === 'boolean' ) {

			return { schemeMatches: urls, wwwMatches: urls, tldMatches: urls };



		} else {  // object form

			return {

				schemeMatches : typeof urls.schemeMatches === 'boolean' ? urls.schemeMatches : true,

				wwwMatches    : typeof urls.wwwMatches === 'boolean'    ? urls.wwwMatches    : true,

				tldMatches    : typeof urls.tldMatches === 'boolean'    ? urls.tldMatches    : true

			};

		}

	},





	/**

	 * Normalizes the {@link #stripPrefix} config into an Object with 2

	 * properties: `scheme`, and `www` - both Booleans.

	 *

	 * See {@link #stripPrefix} config for details.

	 *

	 * @private

	 * @param {Boolean/Object} stripPrefix

	 * @return {Object}

	 */

	normalizeStripPrefixCfg : function( stripPrefix ) {

		if( stripPrefix == null ) stripPrefix = true;  // default to `true`



		if( typeof stripPrefix === 'boolean' ) {

			return { scheme: stripPrefix, www: stripPrefix };



		} else {  // object form

			return {

				scheme : typeof stripPrefix.scheme === 'boolean' ? stripPrefix.scheme : true,

				www    : typeof stripPrefix.www === 'boolean'    ? stripPrefix.www    : true

			};

		}

	},





	/**

	 * Normalizes the {@link #truncate} config into an Object with 2 properties:

	 * `length` (Number), and `location` (String).

	 *

	 * See {@link #truncate} config for details.

	 *

	 * @private

	 * @param {Number/Object} truncate

	 * @return {Object}

	 */

	normalizeTruncateCfg : function( truncate ) {

		if( typeof truncate === 'number' ) {

			return { length: truncate, location: 'end' };



		} else {  // object, or undefined/null

			return Autolinker.Util.defaults( truncate || {}, {

				length   : Number.POSITIVE_INFINITY,

				location : 'end'

			} );

		}

	},





	/**

	 * Parses the input `textOrHtml` looking for URLs, email addresses, phone

	 * numbers, username handles, and hashtags (depending on the configuration

	 * of the Autolinker instance), and returns an array of {@link Autolinker.match.Match}

	 * objects describing those matches (without making any replacements).

	 *

	 * This method is used by the {@link #link} method, but can also be used to

	 * simply do parsing of the input in order to discover what kinds of links

	 * there are and how many.

	 *

	 * Example usage:

	 *

	 *     var autolinker = new Autolinker( {

	 *         urls: true,

	 *         email: true

	 *     } );

	 *

	 *     var matches = autolinker.parse( "Hello google.com, I am asdf@asdf.com" );

	 *

	 *     console.log( matches.length );           // 2

	 *     console.log( matches[ 0 ].getType() );   // 'url'

	 *     console.log( matches[ 0 ].getUrl() );    // 'google.com'

	 *     console.log( matches[ 1 ].getType() );   // 'email'

	 *     console.log( matches[ 1 ].getEmail() );  // 'asdf@asdf.com'

	 *

	 * @param {String} textOrHtml The HTML or text to find matches within

	 *   (depending on if the {@link #urls}, {@link #email}, {@link #phone},

	 *   {@link #hashtag}, and {@link #mention} options are enabled).

	 * @return {Autolinker.match.Match[]} The array of Matches found in the

	 *   given input `textOrHtml`.

	 */

	parse : function( textOrHtml ) {

		var htmlParser = this.getHtmlParser(),

		    htmlNodes = htmlParser.parse( textOrHtml ),

		    anchorTagStackCount = 0,  // used to only process text around anchor tags, and any inner text/html they may have;

		    matches = [];



		// Find all matches within the `textOrHtml` (but not matches that are

		// already nested within <a>, <style> and <script> tags)

		for( var i = 0, len = htmlNodes.length; i < len; i++ ) {

			var node = htmlNodes[ i ],

			    nodeType = node.getType();



			if( nodeType === 'element' && ['a', 'style', 'script'].indexOf(node.getTagName()) !== -1 ) {  // Process HTML anchor, style and script element nodes in the input `textOrHtml` to find out when we're within an <a>, <style> or <script> tag

				if( !node.isClosing() ) {  // it's the start <a>, <style> or <script> tag

					anchorTagStackCount++;

				} else {  // it's the end </a>, </style> or </script> tag

					anchorTagStackCount = Math.max( anchorTagStackCount - 1, 0 );  // attempt to handle extraneous </a> tags by making sure the stack count never goes below 0

				}



			} else if( nodeType === 'text' && anchorTagStackCount === 0 ) {  // Process text nodes that are not within an <a>, <style> and <script> tag

				var textNodeMatches = this.parseText( node.getText(), node.getOffset() );



				matches.push.apply( matches, textNodeMatches );

			}

		}





		// After we have found all matches, remove subsequent matches that

		// overlap with a previous match. This can happen for instance with URLs,

		// where the url 'google.com/#link' would match '#link' as a hashtag.

		matches = this.compactMatches( matches );



		// And finally, remove matches for match types that have been turned

		// off. We needed to have all match types turned on initially so that

		// things like hashtags could be filtered out if they were really just

		// part of a URL match (for instance, as a named anchor).

		matches = this.removeUnwantedMatches( matches );



		return matches;

	},





	/**

	 * After we have found all matches, we need to remove subsequent matches

	 * that overlap with a previous match. This can happen for instance with

	 * URLs, where the url 'google.com/#link' would match '#link' as a hashtag.

	 *

	 * @private

	 * @param {Autolinker.match.Match[]} matches

	 * @return {Autolinker.match.Match[]}

	 */

	compactMatches : function( matches ) {

		// First, the matches need to be sorted in order of offset

		matches.sort( function( a, b ) { return a.getOffset() - b.getOffset(); } );



		for( var i = 0; i < matches.length - 1; i++ ) {

			var match = matches[ i ],

					offset = match.getOffset(),

					matchedTextLength = match.getMatchedText().length,

			    endIdx = offset + matchedTextLength;



			if( i + 1 < matches.length ) {

				// Remove subsequent matches that equal offset with current match

				if( matches[ i + 1 ].getOffset() === offset ) {

					var removeIdx = matches[ i + 1 ].getMatchedText().length > matchedTextLength ? i : i + 1;

					matches.splice( removeIdx, 1 );

					continue;

				}



				// Remove subsequent matches that overlap with the current match

				if( matches[ i + 1 ].getOffset() < endIdx ) {

					matches.splice( i + 1, 1 );

				}

			}

		}



		return matches;

	},





	/**

	 * Removes matches for matchers that were turned off in the options. For

	 * example, if {@link #hashtag hashtags} were not to be matched, we'll

	 * remove them from the `matches` array here.

	 *

	 * @private

	 * @param {Autolinker.match.Match[]} matches The array of matches to remove

	 *   the unwanted matches from. Note: this array is mutated for the

	 *   removals.

	 * @return {Autolinker.match.Match[]} The mutated input `matches` array.

	 */

	removeUnwantedMatches : function( matches ) {

		var remove = Autolinker.Util.remove;



		if( !this.hashtag ) remove( matches, function( match ) { return match.getType() === 'hashtag'; } );

		if( !this.email )   remove( matches, function( match ) { return match.getType() === 'email'; } );

		if( !this.phone )   remove( matches, function( match ) { return match.getType() === 'phone'; } );

		if( !this.mention ) remove( matches, function( match ) { return match.getType() === 'mention'; } );

		if( !this.urls.schemeMatches ) {

			remove( matches, function( m ) { return m.getType() === 'url' && m.getUrlMatchType() === 'scheme'; } );

		}

		if( !this.urls.wwwMatches ) {

			remove( matches, function( m ) { return m.getType() === 'url' && m.getUrlMatchType() === 'www'; } );

		}

		if( !this.urls.tldMatches ) {

			remove( matches, function( m ) { return m.getType() === 'url' && m.getUrlMatchType() === 'tld'; } );

		}



		return matches;

	},





	/**

	 * Parses the input `text` looking for URLs, email addresses, phone

	 * numbers, username handles, and hashtags (depending on the configuration

	 * of the Autolinker instance), and returns an array of {@link Autolinker.match.Match}

	 * objects describing those matches.

	 *

	 * This method processes a **non-HTML string**, and is used to parse and

	 * match within the text nodes of an HTML string. This method is used

	 * internally by {@link #parse}.

	 *

	 * @private

	 * @param {String} text The text to find matches within (depending on if the

	 *   {@link #urls}, {@link #email}, {@link #phone},

	 *   {@link #hashtag}, and {@link #mention} options are enabled). This must be a non-HTML string.

	 * @param {Number} [offset=0] The offset of the text node within the

	 *   original string. This is used when parsing with the {@link #parse}

	 *   method to generate correct offsets within the {@link Autolinker.match.Match}

	 *   instances, but may be omitted if calling this method publicly.

	 * @return {Autolinker.match.Match[]} The array of Matches found in the

	 *   given input `text`.

	 */

	parseText : function( text, offset ) {

		offset = offset || 0;

		var matchers = this.getMatchers(),

		    matches = [];



		for( var i = 0, numMatchers = matchers.length; i < numMatchers; i++ ) {

			var textMatches = matchers[ i ].parseMatches( text );



			// Correct the offset of each of the matches. They are originally

			// the offset of the match within the provided text node, but we

			// need to correct them to be relative to the original HTML input

			// string (i.e. the one provided to #parse).

			for( var j = 0, numTextMatches = textMatches.length; j < numTextMatches; j++ ) {

				textMatches[ j ].setOffset( offset + textMatches[ j ].getOffset() );

			}



			matches.push.apply( matches, textMatches );

		}

		return matches;

	},





	/**

	 * Automatically links URLs, Email addresses, Phone numbers, Hashtags,

	 * and Mentions (Twitter, Instagram, Soundcloud) found in the given chunk of HTML. Does not link

	 * URLs found within HTML tags.

	 *

	 * For instance, if given the text: `You should go to http://www.yahoo.com`,

	 * then the result will be `You should go to

	 * &lt;a href="http://www.yahoo.com"&gt;http://www.yahoo.com&lt;/a&gt;`

	 *

	 * This method finds the text around any HTML elements in the input

	 * `textOrHtml`, which will be the text that is processed. Any original HTML

	 * elements will be left as-is, as well as the text that is already wrapped

	 * in anchor (&lt;a&gt;) tags.

	 *

	 * @param {String} textOrHtml The HTML or text to autolink matches within

	 *   (depending on if the {@link #urls}, {@link #email}, {@link #phone}, {@link #hashtag}, and {@link #mention} options are enabled).

	 * @return {String} The HTML, with matches automatically linked.

	 */

	link : function( textOrHtml ) {

		if( !textOrHtml ) { return ""; }  // handle `null` and `undefined`



		var matches = this.parse( textOrHtml ),

			newHtml = [],

			lastIndex = 0;



		for( var i = 0, len = matches.length; i < len; i++ ) {

			var match = matches[ i ];



			newHtml.push( textOrHtml.substring( lastIndex, match.getOffset() ) );

			newHtml.push( this.createMatchReturnVal( match ) );



			lastIndex = match.getOffset() + match.getMatchedText().length;

		}

		newHtml.push( textOrHtml.substring( lastIndex ) );  // handle the text after the last match



		return newHtml.join( '' );

	},





	/**

	 * Creates the return string value for a given match in the input string.

	 *

	 * This method handles the {@link #replaceFn}, if one was provided.

	 *

	 * @private

	 * @param {Autolinker.match.Match} match The Match object that represents

	 *   the match.

	 * @return {String} The string that the `match` should be replaced with.

	 *   This is usually the anchor tag string, but may be the `matchStr` itself

	 *   if the match is not to be replaced.

	 */

	createMatchReturnVal : function( match ) {

		// Handle a custom `replaceFn` being provided

		var replaceFnResult;

		if( this.replaceFn ) {

			replaceFnResult = this.replaceFn.call( this.context, match );  // Autolinker instance is the context

		}



		if( typeof replaceFnResult === 'string' ) {

			return replaceFnResult;  // `replaceFn` returned a string, use that



		} else if( replaceFnResult === false ) {

			return match.getMatchedText();  // no replacement for the match



		} else if( replaceFnResult instanceof Autolinker.HtmlTag ) {

			return replaceFnResult.toAnchorString();



		} else {  // replaceFnResult === true, or no/unknown return value from function

			// Perform Autolinker's default anchor tag generation

			var anchorTag = match.buildTag();  // returns an Autolinker.HtmlTag instance



			return anchorTag.toAnchorString();

		}

	},





	/**

	 * Lazily instantiates and returns the {@link #htmlParser} instance for this

	 * Autolinker instance.

	 *

	 * @protected

	 * @return {Autolinker.htmlParser.HtmlParser}

	 */

	getHtmlParser : function() {

		var htmlParser = this.htmlParser;



		if( !htmlParser ) {

			htmlParser = this.htmlParser = new Autolinker.htmlParser.HtmlParser();

		}



		return htmlParser;

	},





	/**

	 * Lazily instantiates and returns the {@link Autolinker.matcher.Matcher}

	 * instances for this Autolinker instance.

	 *

	 * @protected

	 * @return {Autolinker.matcher.Matcher[]}

	 */

	getMatchers : function() {

		if( !this.matchers ) {

			var matchersNs = Autolinker.matcher,

			    tagBuilder = this.getTagBuilder();



			var matchers = [

				new matchersNs.Hashtag( { tagBuilder: tagBuilder, serviceName: this.hashtag } ),

				new matchersNs.Email( { tagBuilder: tagBuilder } ),

				new matchersNs.Phone( { tagBuilder: tagBuilder } ),

				new matchersNs.Mention( { tagBuilder: tagBuilder, serviceName: this.mention } ),

				new matchersNs.Url( { tagBuilder: tagBuilder, stripPrefix: this.stripPrefix, stripTrailingSlash: this.stripTrailingSlash, decodePercentEncoding: this.decodePercentEncoding } )

			];



			return ( this.matchers = matchers );



		} else {

			return this.matchers;

		}

	},





	/**

	 * Returns the {@link #tagBuilder} instance for this Autolinker instance, lazily instantiating it

	 * if it does not yet exist.

	 *

	 * This method may be used in a {@link #replaceFn} to generate the {@link Autolinker.HtmlTag HtmlTag} instance that

	 * Autolinker would normally generate, and then allow for modifications before returning it. For example:

	 *

	 *     var html = Autolinker.link( "Test google.com", {

	 *         replaceFn : function( match ) {

	 *             var tag = match.buildTag();  // returns an {@link Autolinker.HtmlTag} instance

	 *             tag.setAttr( 'rel', 'nofollow' );

	 *

	 *             return tag;

	 *         }

	 *     } );

	 *

	 *     // generated html:

	 *     //   Test <a href="http://google.com" target="_blank" rel="nofollow">google.com</a>

	 *

	 * @return {Autolinker.AnchorTagBuilder}

	 */

	getTagBuilder : function() {

		var tagBuilder = this.tagBuilder;



		if( !tagBuilder ) {

			tagBuilder = this.tagBuilder = new Autolinker.AnchorTagBuilder( {

				newWindow   : this.newWindow,

				truncate    : this.truncate,

				className   : this.className

			} );

		}



		return tagBuilder;

	}



};





// Autolinker Namespaces



Autolinker.match = {};

Autolinker.matcher = {};

Autolinker.htmlParser = {};

Autolinker.truncate = {};



/*global Autolinker */

/*jshint eqnull:true, boss:true */

/**

 * @class Autolinker.Util

 * @singleton

 *

 * A few utility methods for Autolinker.

 */

Autolinker.Util = {



	/**

	 * @property {Function} abstractMethod

	 *

	 * A function object which represents an abstract method.

	 */

	abstractMethod : function() { throw "abstract"; },





	/**

	 * @private

	 * @property {RegExp} trimRegex

	 *

	 * The regular expression used to trim the leading and trailing whitespace

	 * from a string.

	 */

	trimRegex : /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,





	/**

	 * Assigns (shallow copies) the properties of `src` onto `dest`.

	 *

	 * @param {Object} dest The destination object.

	 * @param {Object} src The source object.

	 * @return {Object} The destination object (`dest`)

	 */

	assign : function( dest, src ) {

		for( var prop in src ) {

			if( src.hasOwnProperty( prop ) ) {

				dest[ prop ] = src[ prop ];

			}

		}



		return dest;

	},





	/**

	 * Assigns (shallow copies) the properties of `src` onto `dest`, if the

	 * corresponding property on `dest` === `undefined`.

	 *

	 * @param {Object} dest The destination object.

	 * @param {Object} src The source object.

	 * @return {Object} The destination object (`dest`)

	 */

	defaults : function( dest, src ) {

		for( var prop in src ) {

			if( src.hasOwnProperty( prop ) && dest[ prop ] === undefined ) {

				dest[ prop ] = src[ prop ];

			}

		}



		return dest;

	},





	/**

	 * Extends `superclass` to create a new subclass, adding the `protoProps` to the new subclass's prototype.

	 *

	 * @param {Function} superclass The constructor function for the superclass.

	 * @param {Object} protoProps The methods/properties to add to the subclass's prototype. This may contain the

	 *   special property `constructor`, which will be used as the new subclass's constructor function.

	 * @return {Function} The new subclass function.

	 */

	extend : function( superclass, protoProps ) {

		var superclassProto = superclass.prototype;



		var F = function() {};

		F.prototype = superclassProto;



		var subclass;

		if( protoProps.hasOwnProperty( 'constructor' ) ) {

			subclass = protoProps.constructor;

		} else {

			subclass = function() { superclassProto.constructor.apply( this, arguments ); };

		}



		var subclassProto = subclass.prototype = new F();  // set up prototype chain

		subclassProto.constructor = subclass;  // fix constructor property

		subclassProto.superclass = superclassProto;



		delete protoProps.constructor;  // don't re-assign constructor property to the prototype, since a new function may have been created (`subclass`), which is now already there

		Autolinker.Util.assign( subclassProto, protoProps );



		return subclass;

	},





	/**

	 * Truncates the `str` at `len - ellipsisChars.length`, and adds the `ellipsisChars` to the

	 * end of the string (by default, two periods: '..'). If the `str` length does not exceed

	 * `len`, the string will be returned unchanged.

	 *

	 * @param {String} str The string to truncate and add an ellipsis to.

	 * @param {Number} truncateLen The length to truncate the string at.

	 * @param {String} [ellipsisChars=...] The ellipsis character(s) to add to the end of `str`

	 *   when truncated. Defaults to '...'

	 */

	ellipsis : function( str, truncateLen, ellipsisChars ) {

		var ellipsisLength;



		if( str.length > truncateLen ) {

			if(ellipsisChars == null) {

			  ellipsisChars = '&hellip;';

			  ellipsisLength = 3;

			} else {

			  ellipsisLength = ellipsisChars.length;

			}



			str = str.substring( 0, truncateLen - ellipsisLength ) + ellipsisChars;

		}

		return str;

	},





	/**

	 * Supports `Array.prototype.indexOf()` functionality for old IE (IE8 and below).

	 *

	 * @param {Array} arr The array to find an element of.

	 * @param {*} element The element to find in the array, and return the index of.

	 * @return {Number} The index of the `element`, or -1 if it was not found.

	 */

	indexOf : function( arr, element ) {

		if( Array.prototype.indexOf ) {

			return arr.indexOf( element );



		} else {

			for( var i = 0, len = arr.length; i < len; i++ ) {

				if( arr[ i ] === element ) return i;

			}

			return -1;

		}

	},





	/**

	 * Removes array elements based on a filtering function. Mutates the input

	 * array.

	 *

	 * Using this instead of the ES5 Array.prototype.filter() function, to allow

	 * Autolinker compatibility with IE8, and also to prevent creating many new

	 * arrays in memory for filtering.

	 *

	 * @param {Array} arr The array to remove elements from. This array is

	 *   mutated.

	 * @param {Function} fn A function which should return `true` to

	 *   remove an element.

	 * @return {Array} The mutated input `arr`.

	 */

	remove : function( arr, fn ) {

		for( var i = arr.length - 1; i >= 0; i-- ) {

			if( fn( arr[ i ] ) === true ) {

				arr.splice( i, 1 );

			}

		}

	},





	/**

	 * Performs the functionality of what modern browsers do when `String.prototype.split()` is called

	 * with a regular expression that contains capturing parenthesis.

	 *

	 * For example:

	 *

	 *     // Modern browsers:

	 *     "a,b,c".split( /(,)/ );  // --> [ 'a', ',', 'b', ',', 'c' ]

	 *

	 *     // Old IE (including IE8):

	 *     "a,b,c".split( /(,)/ );  // --> [ 'a', 'b', 'c' ]

	 *

	 * This method emulates the functionality of modern browsers for the old IE case.

	 *

	 * @param {String} str The string to split.

	 * @param {RegExp} splitRegex The regular expression to split the input `str` on. The splitting

	 *   character(s) will be spliced into the array, as in the "modern browsers" example in the

	 *   description of this method.

	 *   Note #1: the supplied regular expression **must** have the 'g' flag specified.

	 *   Note #2: for simplicity's sake, the regular expression does not need

	 *   to contain capturing parenthesis - it will be assumed that any match has them.

	 * @return {String[]} The split array of strings, with the splitting character(s) included.

	 */

	splitAndCapture : function( str, splitRegex ) {

		if( !splitRegex.global ) throw new Error( "`splitRegex` must have the 'g' flag set" );



		var result = [],

		    lastIdx = 0,

		    match;



		while( match = splitRegex.exec( str ) ) {

			result.push( str.substring( lastIdx, match.index ) );

			result.push( match[ 0 ] );  // push the splitting char(s)



			lastIdx = match.index + match[ 0 ].length;

		}

		result.push( str.substring( lastIdx ) );



		return result;

	},





	/**

	 * Trims the leading and trailing whitespace from a string.

	 *

	 * @param {String} str The string to trim.

	 * @return {String}

	 */

	trim : function( str ) {

		return str.replace( this.trimRegex, '' );

	}



};



/*global Autolinker */

/*jshint boss:true */

/**

 * @class Autolinker.HtmlTag

 * @extends Object

 *

 * Represents an HTML tag, which can be used to easily build/modify HTML tags programmatically.

 *

 * Autolinker uses this abstraction to create HTML tags, and then write them out as strings. You may also use

 * this class in your code, especially within a {@link Autolinker#replaceFn replaceFn}.

 *

 * ## Examples

 *

 * Example instantiation:

 *

 *     var tag = new Autolinker.HtmlTag( {

 *         tagName : 'a',

 *         attrs   : { 'href': 'http://google.com', 'class': 'external-link' },

 *         innerHtml : 'Google'

 *     } );

 *

 *     tag.toAnchorString();  // <a href="http://google.com" class="external-link">Google</a>

 *

 *     // Individual accessor methods

 *     tag.getTagName();                 // 'a'

 *     tag.getAttr( 'href' );            // 'http://google.com'

 *     tag.hasClass( 'external-link' );  // true

 *

 *

 * Using mutator methods (which may be used in combination with instantiation config properties):

 *

 *     var tag = new Autolinker.HtmlTag();

 *     tag.setTagName( 'a' );

 *     tag.setAttr( 'href', 'http://google.com' );

 *     tag.addClass( 'external-link' );

 *     tag.setInnerHtml( 'Google' );

 *

 *     tag.getTagName();                 // 'a'

 *     tag.getAttr( 'href' );            // 'http://google.com'

 *     tag.hasClass( 'external-link' );  // true

 *

 *     tag.toAnchorString();  // <a href="http://google.com" class="external-link">Google</a>

 *

 *

 * ## Example use within a {@link Autolinker#replaceFn replaceFn}

 *

 *     var html = Autolinker.link( "Test google.com", {

 *         replaceFn : function( match ) {

 *             var tag = match.buildTag();  // returns an {@link Autolinker.HtmlTag} instance, configured with the Match's href and anchor text

 *             tag.setAttr( 'rel', 'nofollow' );

 *

 *             return tag;

 *         }

 *     } );

 *

 *     // generated html:

 *     //   Test <a href="http://google.com" target="_blank" rel="nofollow">google.com</a>

 *

 *

 * ## Example use with a new tag for the replacement

 *

 *     var html = Autolinker.link( "Test google.com", {

 *         replaceFn : function( match ) {

 *             var tag = new Autolinker.HtmlTag( {

 *                 tagName : 'button',

 *                 attrs   : { 'title': 'Load URL: ' + match.getAnchorHref() },

 *                 innerHtml : 'Load URL: ' + match.getAnchorText()

 *             } );

 *

 *             return tag;

 *         }

 *     } );

 *

 *     // generated html:

 *     //   Test <button title="Load URL: http://google.com">Load URL: google.com</button>

 */

Autolinker.HtmlTag = Autolinker.Util.extend( Object, {



	/**

	 * @cfg {String} tagName

	 *

	 * The tag name. Ex: 'a', 'button', etc.

	 *

	 * Not required at instantiation time, but should be set using {@link #setTagName} before {@link #toAnchorString}

	 * is executed.

	 */



	/**

	 * @cfg {Object.<String, String>} attrs

	 *

	 * An key/value Object (map) of attributes to create the tag with. The keys are the attribute names, and the

	 * values are the attribute values.

	 */



	/**

	 * @cfg {String} innerHtml

	 *

	 * The inner HTML for the tag.

	 *

	 * Note the camel case name on `innerHtml`. Acronyms are camelCased in this utility (such as not to run into the acronym

	 * naming inconsistency that the DOM developers created with `XMLHttpRequest`). You may alternatively use {@link #innerHTML}

	 * if you prefer, but this one is recommended.

	 */



	/**

	 * @cfg {String} innerHTML

	 *

	 * Alias of {@link #innerHtml}, accepted for consistency with the browser DOM api, but prefer the camelCased version

	 * for acronym names.

	 */





	/**

	 * @protected

	 * @property {RegExp} whitespaceRegex

	 *

	 * Regular expression used to match whitespace in a string of CSS classes.

	 */

	whitespaceRegex : /\s+/,





	/**

	 * @constructor

	 * @param {Object} [cfg] The configuration properties for this class, in an Object (map)

	 */

	constructor : function( cfg ) {

		Autolinker.Util.assign( this, cfg );



		this.innerHtml = this.innerHtml || this.innerHTML;  // accept either the camelCased form or the fully capitalized acronym

	},





	/**

	 * Sets the tag name that will be used to generate the tag with.

	 *

	 * @param {String} tagName

	 * @return {Autolinker.HtmlTag} This HtmlTag instance, so that method calls may be chained.

	 */

	setTagName : function( tagName ) {

		this.tagName = tagName;

		return this;

	},





	/**

	 * Retrieves the tag name.

	 *

	 * @return {String}

	 */

	getTagName : function() {

		return this.tagName || "";

	},





	/**

	 * Sets an attribute on the HtmlTag.

	 *

	 * @param {String} attrName The attribute name to set.

	 * @param {String} attrValue The attribute value to set.

	 * @return {Autolinker.HtmlTag} This HtmlTag instance, so that method calls may be chained.

	 */

	setAttr : function( attrName, attrValue ) {

		var tagAttrs = this.getAttrs();

		tagAttrs[ attrName ] = attrValue;



		return this;

	},





	/**

	 * Retrieves an attribute from the HtmlTag. If the attribute does not exist, returns `undefined`.

	 *

	 * @param {String} attrName The attribute name to retrieve.

	 * @return {String} The attribute's value, or `undefined` if it does not exist on the HtmlTag.

	 */

	getAttr : function( attrName ) {

		return this.getAttrs()[ attrName ];

	},





	/**

	 * Sets one or more attributes on the HtmlTag.

	 *

	 * @param {Object.<String, String>} attrs A key/value Object (map) of the attributes to set.

	 * @return {Autolinker.HtmlTag} This HtmlTag instance, so that method calls may be chained.

	 */

	setAttrs : function( attrs ) {

		var tagAttrs = this.getAttrs();

		Autolinker.Util.assign( tagAttrs, attrs );



		return this;

	},





	/**

	 * Retrieves the attributes Object (map) for the HtmlTag.

	 *

	 * @return {Object.<String, String>} A key/value object of the attributes for the HtmlTag.

	 */

	getAttrs : function() {

		return this.attrs || ( this.attrs = {} );

	},





	/**

	 * Sets the provided `cssClass`, overwriting any current CSS classes on the HtmlTag.

	 *

	 * @param {String} cssClass One or more space-separated CSS classes to set (overwrite).

	 * @return {Autolinker.HtmlTag} This HtmlTag instance, so that method calls may be chained.

	 */

	setClass : function( cssClass ) {

		return this.setAttr( 'class', cssClass );

	},





	/**

	 * Convenience method to add one or more CSS classes to the HtmlTag. Will not add duplicate CSS classes.

	 *

	 * @param {String} cssClass One or more space-separated CSS classes to add.

	 * @return {Autolinker.HtmlTag} This HtmlTag instance, so that method calls may be chained.

	 */

	addClass : function( cssClass ) {

		var classAttr = this.getClass(),

		    whitespaceRegex = this.whitespaceRegex,

		    indexOf = Autolinker.Util.indexOf,  // to support IE8 and below

		    classes = ( !classAttr ) ? [] : classAttr.split( whitespaceRegex ),

		    newClasses = cssClass.split( whitespaceRegex ),

		    newClass;



		while( newClass = newClasses.shift() ) {

			if( indexOf( classes, newClass ) === -1 ) {

				classes.push( newClass );

			}

		}



		this.getAttrs()[ 'class' ] = classes.join( " " );

		return this;

	},





	/**

	 * Convenience method to remove one or more CSS classes from the HtmlTag.

	 *

	 * @param {String} cssClass One or more space-separated CSS classes to remove.

	 * @return {Autolinker.HtmlTag} This HtmlTag instance, so that method calls may be chained.

	 */

	removeClass : function( cssClass ) {

		var classAttr = this.getClass(),

		    whitespaceRegex = this.whitespaceRegex,

		    indexOf = Autolinker.Util.indexOf,  // to support IE8 and below

		    classes = ( !classAttr ) ? [] : classAttr.split( whitespaceRegex ),

		    removeClasses = cssClass.split( whitespaceRegex ),

		    removeClass;



		while( classes.length && ( removeClass = removeClasses.shift() ) ) {

			var idx = indexOf( classes, removeClass );

			if( idx !== -1 ) {

				classes.splice( idx, 1 );

			}

		}



		this.getAttrs()[ 'class' ] = classes.join( " " );

		return this;

	},





	/**

	 * Convenience method to retrieve the CSS class(es) for the HtmlTag, which will each be separated by spaces when

	 * there are multiple.

	 *

	 * @return {String}

	 */

	getClass : function() {

		return this.getAttrs()[ 'class' ] || "";

	},





	/**

	 * Convenience method to check if the tag has a CSS class or not.

	 *

	 * @param {String} cssClass The CSS class to check for.

	 * @return {Boolean} `true` if the HtmlTag has the CSS class, `false` otherwise.

	 */

	hasClass : function( cssClass ) {

		return ( ' ' + this.getClass() + ' ' ).indexOf( ' ' + cssClass + ' ' ) !== -1;

	},





	/**

	 * Sets the inner HTML for the tag.

	 *

	 * @param {String} html The inner HTML to set.

	 * @return {Autolinker.HtmlTag} This HtmlTag instance, so that method calls may be chained.

	 */

	setInnerHtml : function( html ) {

		this.innerHtml = html;



		return this;

	},





	/**

	 * Retrieves the inner HTML for the tag.

	 *

	 * @return {String}

	 */

	getInnerHtml : function() {

		return this.innerHtml || "";

	},





	/**

	 * Override of superclass method used to generate the HTML string for the tag.

	 *

	 * @return {String}

	 */

	toAnchorString : function() {

		var tagName = this.getTagName(),

		    attrsStr = this.buildAttrsStr();



		attrsStr = ( attrsStr ) ? ' ' + attrsStr : '';  // prepend a space if there are actually attributes



		return [ '<', tagName, attrsStr, '>', this.getInnerHtml(), '</', tagName, '>' ].join( "" );

	},





	/**

	 * Support method for {@link #toAnchorString}, returns the string space-separated key="value" pairs, used to populate

	 * the stringified HtmlTag.

	 *

	 * @protected

	 * @return {String} Example return: `attr1="value1" attr2="value2"`

	 */

	buildAttrsStr : function() {

		if( !this.attrs ) return "";  // no `attrs` Object (map) has been set, return empty string



		var attrs = this.getAttrs(),

		    attrsArr = [];



		for( var prop in attrs ) {

			if( attrs.hasOwnProperty( prop ) ) {

				attrsArr.push( prop + '="' + attrs[ prop ] + '"' );

			}

		}

		return attrsArr.join( " " );

	}



} );



/*global Autolinker */

/**

 * @class Autolinker.RegexLib

 * @singleton

 *

 * Builds and stores a library of the common regular expressions used by the

 * Autolinker utility.

 *

 * Other regular expressions may exist ad-hoc, but these are generally the

 * regular expressions that are shared between source files.

 */

Autolinker.RegexLib = (function() {



	/**

	 * The string form of a regular expression that would match all of the

	 * alphabetic ("letter") chars in the unicode character set when placed in a

	 * RegExp character class (`[]`). This includes all international alphabetic

	 * characters.

	 *

	 * These would be the characters matched by unicode regex engines `\p{L}`

	 * escape ("all letters").

	 *

	 * Taken from the XRegExp library: http://xregexp.com/

	 * Specifically: http://xregexp.com/v/3.0.0/unicode-categories.js

	 *

	 * @private

	 * @type {String}

	 */

	var alphaCharsStr = 'A-Za-z\\xAA\\xB5\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0-\u08B4\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16F1-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FD5\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AD\uA7B0-\uA7B7\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC';



	/**

	 * The string form of a regular expression that would match all of the

	 * decimal number chars in the unicode character set when placed in a RegExp

	 * character class (`[]`).

	 *

	 * These would be the characters matched by unicode regex engines `\p{Nd}`

	 * escape ("all decimal numbers")

	 *

	 * Taken from the XRegExp library: http://xregexp.com/

	 * Specifically: http://xregexp.com/v/3.0.0/unicode-categories.js

	 *

	 * @private

	 * @type {String}

	 */

	var decimalNumbersStr = '0-9\u0660-\u0669\u06F0-\u06F9\u07C0-\u07C9\u0966-\u096F\u09E6-\u09EF\u0A66-\u0A6F\u0AE6-\u0AEF\u0B66-\u0B6F\u0BE6-\u0BEF\u0C66-\u0C6F\u0CE6-\u0CEF\u0D66-\u0D6F\u0DE6-\u0DEF\u0E50-\u0E59\u0ED0-\u0ED9\u0F20-\u0F29\u1040-\u1049\u1090-\u1099\u17E0-\u17E9\u1810-\u1819\u1946-\u194F\u19D0-\u19D9\u1A80-\u1A89\u1A90-\u1A99\u1B50-\u1B59\u1BB0-\u1BB9\u1C40-\u1C49\u1C50-\u1C59\uA620-\uA629\uA8D0-\uA8D9\uA900-\uA909\uA9D0-\uA9D9\uA9F0-\uA9F9\uAA50-\uAA59\uABF0-\uABF9\uFF10-\uFF19';





	// See documentation below

	var alphaNumericCharsStr = alphaCharsStr + decimalNumbersStr;



	// Simplified IP regular expression

	var ipStr = '(?:[' + decimalNumbersStr + ']{1,3}\\.){3}[' + decimalNumbersStr + ']{1,3}';



	// Protected domain label which do not allow "-" character on the beginning and the end of a single label

	var domainLabelStr = '[' + alphaNumericCharsStr + '](?:[' + alphaNumericCharsStr + '\\-]{0,61}[' + alphaNumericCharsStr + '])?';



	var getDomainLabelStr = function(group) {

		return '(?=(' + domainLabelStr + '))\\' + group;

	};



	// See documentation below

	var getDomainNameStr = function(group) {

		return '(?:' + getDomainLabelStr(group) + '(?:\\.' + getDomainLabelStr(group + 1) + '){0,126}|' + ipStr + ')';

	};



	return {



		/**

		 * The string form of a regular expression that would match all of the

		 * letters and decimal number chars in the unicode character set when placed

		 * in a RegExp character class (`[]`).

		 *

		 * These would be the characters matched by unicode regex engines `[\p{L}\p{Nd}]`

		 * escape ("all letters and decimal numbers")

		 *

		 * @property {String} alphaNumericCharsStr

		 */

		alphaNumericCharsStr : alphaNumericCharsStr,



		/**

		 * The string form of a regular expression that would match all of the

		 * letters and in the unicode character set when placed

		 * in a RegExp character class (`[]`).

		 *

		 * These would be the characters matched by unicode regex engines `[\p{L}]`

		 * escape ("all letters")

		 *

		 * @property {String} alphaCharsStr

		 */

		alphaCharsStr : alphaCharsStr,



		/**

		 * A regular expression to match domain names of a URL or email address.

		 * Ex: 'google', 'yahoo', 'some-other-company', etc.

		 *

		 * @property {RegExp} domainNameRegex

		 */

		getDomainNameStr : getDomainNameStr,



	};





}() );



/*global Autolinker */

/*jshint sub:true */

/**

 * @protected

 * @class Autolinker.AnchorTagBuilder

 * @extends Object

 *

 * Builds anchor (&lt;a&gt;) tags for the Autolinker utility when a match is

 * found.

 *

 * Normally this class is instantiated, configured, and used internally by an

 * {@link Autolinker} instance, but may actually be used indirectly in a

 * {@link Autolinker#replaceFn replaceFn} to create {@link Autolinker.HtmlTag HtmlTag}

 * instances which may be modified before returning from the

 * {@link Autolinker#replaceFn replaceFn}. For example:

 *

 *     var html = Autolinker.link( "Test google.com", {

 *         replaceFn : function( match ) {

 *             var tag = match.buildTag();  // returns an {@link Autolinker.HtmlTag} instance

 *             tag.setAttr( 'rel', 'nofollow' );

 *

 *             return tag;

 *         }

 *     } );

 *

 *     // generated html:

 *     //   Test <a href="http://google.com" target="_blank" rel="nofollow">google.com</a>

 */

Autolinker.AnchorTagBuilder = Autolinker.Util.extend( Object, {



	/**

	 * @cfg {Boolean} newWindow

	 * @inheritdoc Autolinker#newWindow

	 */



	/**

	 * @cfg {Object} truncate

	 * @inheritdoc Autolinker#truncate

	 */



	/**

	 * @cfg {String} className

	 * @inheritdoc Autolinker#className

	 */





	/**

	 * @constructor

	 * @param {Object} [cfg] The configuration options for the AnchorTagBuilder instance, specified in an Object (map).

	 */

	constructor : function( cfg ) {

		cfg = cfg || {};



		this.newWindow = cfg.newWindow;

		this.truncate = cfg.truncate;

		this.className = cfg.className;

	},





	/**

	 * Generates the actual anchor (&lt;a&gt;) tag to use in place of the

	 * matched text, via its `match` object.

	 *

	 * @param {Autolinker.match.Match} match The Match instance to generate an

	 *   anchor tag from.

	 * @return {Autolinker.HtmlTag} The HtmlTag instance for the anchor tag.

	 */

	build : function( match ) {

		return new Autolinker.HtmlTag( {

			tagName   : 'a',

			attrs     : this.createAttrs( match ),

			innerHtml : this.processAnchorText( match.getAnchorText() )

		} );

	},





	/**

	 * Creates the Object (map) of the HTML attributes for the anchor (&lt;a&gt;)

	 *   tag being generated.

	 *

	 * @protected

	 * @param {Autolinker.match.Match} match The Match instance to generate an

	 *   anchor tag from.

	 * @return {Object} A key/value Object (map) of the anchor tag's attributes.

	 */

	createAttrs : function( match ) {

		var attrs = {

			'href' : match.getAnchorHref()  // we'll always have the `href` attribute

		};



		var cssClass = this.createCssClass( match );

		if( cssClass ) {

			attrs[ 'class' ] = cssClass;

		}

		if( this.newWindow ) {

			attrs[ 'target' ] = "_blank";

			attrs[ 'rel' ] = "noopener noreferrer";

		}



		if( this.truncate ) {

			if( this.truncate.length && this.truncate.length < match.getAnchorText().length ) {

				attrs[ 'title' ] = match.getAnchorHref();

			}

		}



		return attrs;

	},





	/**

	 * Creates the CSS class that will be used for a given anchor tag, based on

	 * the `matchType` and the {@link #className} config.

	 *

	 * Example returns:

	 *

	 * - ""                                      // no {@link #className}

	 * - "myLink myLink-url"                     // url match

	 * - "myLink myLink-email"                   // email match

	 * - "myLink myLink-phone"                   // phone match

	 * - "myLink myLink-hashtag"                 // hashtag match

	 * - "myLink myLink-mention myLink-twitter"  // mention match with Twitter service

	 *

	 * @private

	 * @param {Autolinker.match.Match} match The Match instance to generate an

	 *   anchor tag from.

	 * @return {String} The CSS class string for the link. Example return:

	 *   "myLink myLink-url". If no {@link #className} was configured, returns

	 *   an empty string.

	 */

	createCssClass : function( match ) {

		var className = this.className;



		if( !className ) {

			return "";



		} else {

			var returnClasses = [ className ],

				cssClassSuffixes = match.getCssClassSuffixes();



			for( var i = 0, len = cssClassSuffixes.length; i < len; i++ ) {

				returnClasses.push( className + '-' + cssClassSuffixes[ i ] );

			}

			return returnClasses.join( ' ' );

		}

	},





	/**

	 * Processes the `anchorText` by truncating the text according to the

	 * {@link #truncate} config.

	 *

	 * @private

	 * @param {String} anchorText The anchor tag's text (i.e. what will be

	 *   displayed).

	 * @return {String} The processed `anchorText`.

	 */

	processAnchorText : function( anchorText ) {

		anchorText = this.doTruncate( anchorText );



		return anchorText;

	},





	/**

	 * Performs the truncation of the `anchorText` based on the {@link #truncate}

	 * option. If the `anchorText` is longer than the length specified by the

	 * {@link #truncate} option, the truncation is performed based on the

	 * `location` property. See {@link #truncate} for details.

	 *

	 * @private

	 * @param {String} anchorText The anchor tag's text (i.e. what will be

	 *   displayed).

	 * @return {String} The truncated anchor text.

	 */

	doTruncate : function( anchorText ) {

		var truncate = this.truncate;

		if( !truncate || !truncate.length ) return anchorText;



		var truncateLength = truncate.length,

			truncateLocation = truncate.location;



		if( truncateLocation === 'smart' ) {

			return Autolinker.truncate.TruncateSmart( anchorText, truncateLength );



		} else if( truncateLocation === 'middle' ) {

			return Autolinker.truncate.TruncateMiddle( anchorText, truncateLength );



		} else {

			return Autolinker.truncate.TruncateEnd( anchorText, truncateLength );

		}

	}



} );



/*global Autolinker */

/**

 * @class Autolinker.htmlParser.HtmlParser

 * @extends Object

 *

 * An HTML parser implementation which simply walks an HTML string and returns an array of

 * {@link Autolinker.htmlParser.HtmlNode HtmlNodes} that represent the basic HTML structure of the input string.

 *

 * Autolinker uses this to only link URLs/emails/mentions within text nodes, effectively ignoring / "walking

 * around" HTML tags.

 */

Autolinker.htmlParser.HtmlParser = Autolinker.Util.extend( Object, {



	/**

	 * @private

	 * @property {RegExp} htmlRegex

	 *

	 * The regular expression used to pull out HTML tags from a string. Handles namespaced HTML tags and

	 * attribute names, as specified by http://www.w3.org/TR/html-markup/syntax.html.

	 *

	 * Capturing groups:

	 *

	 * 1. The "!DOCTYPE" tag name, if a tag is a &lt;!DOCTYPE&gt; tag.

	 * 2. If it is an end tag, this group will have the '/'.

	 * 3. If it is a comment tag, this group will hold the comment text (i.e.

	 *    the text inside the `&lt;!--` and `--&gt;`.

	 * 4. The tag name for a tag without attributes (other than the &lt;!DOCTYPE&gt; tag)

	 * 5. The tag name for a tag with attributes (other than the &lt;!DOCTYPE&gt; tag)

	 */

	htmlRegex : (function() {

		var commentTagRegex = /!--([\s\S]+?)--/,

		    tagNameRegex = /[0-9a-zA-Z][0-9a-zA-Z:]*/,

		    attrNameRegex = /[^\s"'>\/=\x00-\x1F\x7F]+/,   // the unicode range accounts for excluding control chars, and the delete char

		    attrValueRegex = /(?:"[^"]*?"|'[^']*?'|[^'"=<>`\s]+)/, // double quoted, single quoted, or unquoted attribute values

		    optionalAttrValueRegex = '(?:\\s*?=\\s*?' + attrValueRegex.source + ')?'; // optional '=[value]'



		var getNameEqualsValueRegex = function(group) {

			return '(?=(' + attrNameRegex.source + '))\\' + group + optionalAttrValueRegex;

		};



		return new RegExp( [

			// for <!DOCTYPE> tag. Ex: <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">)

			'(?:',

				'<(!DOCTYPE)',  // *** Capturing Group 1 - If it's a doctype tag



					// Zero or more attributes following the tag name

					'(?:',

						'\\s+',  // one or more whitespace chars before an attribute



						// Either:

						// A. attr="value", or

						// B. "value" alone (To cover example doctype tag: <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">)

						// *** Capturing Group 2 - Pseudo-atomic group for attrNameRegex

						'(?:', getNameEqualsValueRegex(2), '|', attrValueRegex.source + ')',

					')*',

				'>',

			')',



			'|',



			// All other HTML tags (i.e. tags that are not <!DOCTYPE>)

			'(?:',

				'<(/)?',  // Beginning of a tag or comment. Either '<' for a start tag, or '</' for an end tag.

				          // *** Capturing Group 3: The slash or an empty string. Slash ('/') for end tag, empty string for start or self-closing tag.



					'(?:',

						commentTagRegex.source,  // *** Capturing Group 4 - A Comment Tag's Text



						'|',



						// Handle tag without attributes.

						// Doing this separately from a tag that has attributes

						// to fix a regex time complexity issue seen with the

						// example in https://github.com/gregjacobs/Autolinker.js/issues/172

						'(?:',

							// *** Capturing Group 5 - The tag name for a tag without attributes

							'(' + tagNameRegex.source + ')',



							'\\s*/?',  // any trailing spaces and optional '/' before the closing '>'

						')',



						'|',



						// Handle tag with attributes

						// Doing this separately from a tag with no attributes

						// to fix a regex time complexity issue seen with the

						// example in https://github.com/gregjacobs/Autolinker.js/issues/172

						'(?:',

							// *** Capturing Group 6 - The tag name for a tag with attributes

							'(' + tagNameRegex.source + ')',



							'\\s+',  // must have at least one space after the tag name to prevent ReDoS issue (issue #172)



							// Zero or more attributes following the tag name

							'(?:',

								'(?:\\s+|\\b)',        // any number of whitespace chars before an attribute. NOTE: Using \s* here throws Chrome into an infinite loop for some reason, so using \s+|\b instead

								// *** Capturing Group 7 - Pseudo-atomic group for attrNameRegex

								getNameEqualsValueRegex(7),  // attr="value" (with optional ="value" part)

							')*',



							'\\s*/?',  // any trailing spaces and optional '/' before the closing '>'

						')',

					')',

				'>',

			')'

		].join( "" ), 'gi' );

	} )(),



	/**

	 * @private

	 * @property {RegExp} htmlCharacterEntitiesRegex

	 *

	 * The regular expression that matches common HTML character entities.

	 *

	 * Ignoring &amp; as it could be part of a query string -- handling it separately.

	 */

	htmlCharacterEntitiesRegex: /(&nbsp;|&#160;|&lt;|&#60;|&gt;|&#62;|&quot;|&#34;|&#39;)/gi,





	/**

	 * Parses an HTML string and returns a simple array of {@link Autolinker.htmlParser.HtmlNode HtmlNodes}

	 * to represent the HTML structure of the input string.

	 *

	 * @param {String} html The HTML to parse.

	 * @return {Autolinker.htmlParser.HtmlNode[]}

	 */

	parse : function( html ) {

		var htmlRegex = this.htmlRegex,

		    currentResult,

		    lastIndex = 0,

		    textAndEntityNodes,

		    nodes = [];  // will be the result of the method



		while( ( currentResult = htmlRegex.exec( html ) ) !== null ) {

			var tagText = currentResult[ 0 ],

			    commentText = currentResult[ 4 ], // if we've matched a comment

			    tagName = currentResult[ 1 ] || currentResult[ 5 ] || currentResult[ 6 ],  // The <!DOCTYPE> tag (ex: "!DOCTYPE"), or another tag (ex: "a" or "img")

			    isClosingTag = !!currentResult[ 3 ],

			    offset = currentResult.index,

			    inBetweenTagsText = html.substring( lastIndex, offset );



			// Push TextNodes and EntityNodes for any text found between tags

			if( inBetweenTagsText ) {

				textAndEntityNodes = this.parseTextAndEntityNodes( lastIndex, inBetweenTagsText );

				nodes.push.apply( nodes, textAndEntityNodes );

			}



			// Push the CommentNode or ElementNode

			if( commentText ) {

				nodes.push( this.createCommentNode( offset, tagText, commentText ) );

			} else {

				nodes.push( this.createElementNode( offset, tagText, tagName, isClosingTag ) );

			}



			lastIndex = offset + tagText.length;

		}



		// Process any remaining text after the last HTML element. Will process all of the text if there were no HTML elements.

		if( lastIndex < html.length ) {

			var text = html.substring( lastIndex );



			// Push TextNodes and EntityNodes for any text found between tags

			if( text ) {

				textAndEntityNodes = this.parseTextAndEntityNodes( lastIndex, text );



				// Note: the following 3 lines were previously:

				//   nodes.push.apply( nodes, textAndEntityNodes );

				// but this was causing a "Maximum Call Stack Size Exceeded"

				// error on inputs with a large number of html entities.

				textAndEntityNodes.forEach( function( node ) {

					nodes.push( node );

				} );

			}

		}



		return nodes;

	},





	/**

	 * Parses text and HTML entity nodes from a given string. The input string

	 * should not have any HTML tags (elements) within it.

	 *

	 * @private

	 * @param {Number} offset The offset of the text node match within the

	 *   original HTML string.

	 * @param {String} text The string of text to parse. This is from an HTML

	 *   text node.

	 * @return {Autolinker.htmlParser.HtmlNode[]} An array of HtmlNodes to

	 *   represent the {@link Autolinker.htmlParser.TextNode TextNodes} and

	 *   {@link Autolinker.htmlParser.EntityNode EntityNodes} found.

	 */

	parseTextAndEntityNodes : function( offset, text ) {

		var nodes = [],

		    textAndEntityTokens = Autolinker.Util.splitAndCapture( text, this.htmlCharacterEntitiesRegex );  // split at HTML entities, but include the HTML entities in the results array



		// Every even numbered token is a TextNode, and every odd numbered token is an EntityNode

		// For example: an input `text` of "Test &quot;this&quot; today" would turn into the

		//   `textAndEntityTokens`: [ 'Test ', '&quot;', 'this', '&quot;', ' today' ]

		for( var i = 0, len = textAndEntityTokens.length; i < len; i += 2 ) {

			var textToken = textAndEntityTokens[ i ],

			    entityToken = textAndEntityTokens[ i + 1 ];



			if( textToken ) {

				nodes.push( this.createTextNode( offset, textToken ) );

				offset += textToken.length;

			}

			if( entityToken ) {

				nodes.push( this.createEntityNode( offset, entityToken ) );

				offset += entityToken.length;

			}

		}

		return nodes;

	},





	/**

	 * Factory method to create an {@link Autolinker.htmlParser.CommentNode CommentNode}.

	 *

	 * @private

	 * @param {Number} offset The offset of the match within the original HTML

	 *   string.

	 * @param {String} tagText The full text of the tag (comment) that was

	 *   matched, including its &lt;!-- and --&gt;.

	 * @param {String} commentText The full text of the comment that was matched.

	 */

	createCommentNode : function( offset, tagText, commentText ) {

		return new Autolinker.htmlParser.CommentNode( {

			offset : offset,

			text   : tagText,

			comment: Autolinker.Util.trim( commentText )

		} );

	},





	/**

	 * Factory method to create an {@link Autolinker.htmlParser.ElementNode ElementNode}.

	 *

	 * @private

	 * @param {Number} offset The offset of the match within the original HTML

	 *   string.

	 * @param {String} tagText The full text of the tag (element) that was

	 *   matched, including its attributes.

	 * @param {String} tagName The name of the tag. Ex: An &lt;img&gt; tag would

	 *   be passed to this method as "img".

	 * @param {Boolean} isClosingTag `true` if it's a closing tag, false

	 *   otherwise.

	 * @return {Autolinker.htmlParser.ElementNode}

	 */

	createElementNode : function( offset, tagText, tagName, isClosingTag ) {

		return new Autolinker.htmlParser.ElementNode( {

			offset  : offset,

			text    : tagText,

			tagName : tagName.toLowerCase(),

			closing : isClosingTag

		} );

	},





	/**

	 * Factory method to create a {@link Autolinker.htmlParser.EntityNode EntityNode}.

	 *

	 * @private

	 * @param {Number} offset The offset of the match within the original HTML

	 *   string.

	 * @param {String} text The text that was matched for the HTML entity (such

	 *   as '&amp;nbsp;').

	 * @return {Autolinker.htmlParser.EntityNode}

	 */

	createEntityNode : function( offset, text ) {

		return new Autolinker.htmlParser.EntityNode( { offset: offset, text: text } );

	},





	/**

	 * Factory method to create a {@link Autolinker.htmlParser.TextNode TextNode}.

	 *

	 * @private

	 * @param {Number} offset The offset of the match within the original HTML

	 *   string.

	 * @param {String} text The text that was matched.

	 * @return {Autolinker.htmlParser.TextNode}

	 */

	createTextNode : function( offset, text ) {

		return new Autolinker.htmlParser.TextNode( { offset: offset, text: text } );

	}



} );



/*global Autolinker */

/**

 * @abstract

 * @class Autolinker.htmlParser.HtmlNode

 *

 * Represents an HTML node found in an input string. An HTML node is one of the

 * following:

 *

 * 1. An {@link Autolinker.htmlParser.ElementNode ElementNode}, which represents

 *    HTML tags.

 * 2. A {@link Autolinker.htmlParser.CommentNode CommentNode}, which represents

 *    HTML comments.

 * 3. A {@link Autolinker.htmlParser.TextNode TextNode}, which represents text

 *    outside or within HTML tags.

 * 4. A {@link Autolinker.htmlParser.EntityNode EntityNode}, which represents

 *    one of the known HTML entities that Autolinker looks for. This includes

 *    common ones such as &amp;quot; and &amp;nbsp;

 */

Autolinker.htmlParser.HtmlNode = Autolinker.Util.extend( Object, {



	/**

	 * @cfg {Number} offset (required)

	 *

	 * The offset of the HTML node in the original text that was parsed.

	 */

	offset : undefined,



	/**

	 * @cfg {String} text (required)

	 *

	 * The text that was matched for the HtmlNode.

	 *

	 * - In the case of an {@link Autolinker.htmlParser.ElementNode ElementNode},

	 *   this will be the tag's text.

	 * - In the case of an {@link Autolinker.htmlParser.CommentNode CommentNode},

	 *   this will be the comment's text.

	 * - In the case of a {@link Autolinker.htmlParser.TextNode TextNode}, this

	 *   will be the text itself.

	 * - In the case of a {@link Autolinker.htmlParser.EntityNode EntityNode},

	 *   this will be the text of the HTML entity.

	 */

	text : undefined,





	/**

	 * @constructor

	 * @param {Object} cfg The configuration properties for the Match instance,

	 * specified in an Object (map).

	 */

	constructor : function( cfg ) {

		Autolinker.Util.assign( this, cfg );



		if( this.offset == null ) throw new Error( '`offset` cfg required' );

		if( this.text == null ) throw new Error( '`text` cfg required' );

	},





	/**

	 * Returns a string name for the type of node that this class represents.

	 *

	 * @abstract

	 * @return {String}

	 */

	getType : Autolinker.Util.abstractMethod,





	/**

	 * Retrieves the {@link #offset} of the HtmlNode. This is the offset of the

	 * HTML node in the original string that was parsed.

	 *

	 * @return {Number}

	 */

	getOffset : function() {

		return this.offset;

	},





	/**

	 * Retrieves the {@link #text} for the HtmlNode.

	 *

	 * @return {String}

	 */

	getText : function() {

		return this.text;

	}



} );

/*global Autolinker */

/**

 * @class Autolinker.htmlParser.CommentNode

 * @extends Autolinker.htmlParser.HtmlNode

 *

 * Represents an HTML comment node that has been parsed by the

 * {@link Autolinker.htmlParser.HtmlParser}.

 *

 * See this class's superclass ({@link Autolinker.htmlParser.HtmlNode}) for more

 * details.

 */

Autolinker.htmlParser.CommentNode = Autolinker.Util.extend( Autolinker.htmlParser.HtmlNode, {



	/**

	 * @cfg {String} comment (required)

	 *

	 * The text inside the comment tag. This text is stripped of any leading or

	 * trailing whitespace.

	 */

	comment : '',





	/**

	 * Returns a string name for the type of node that this class represents.

	 *

	 * @return {String}

	 */

	getType : function() {

		return 'comment';

	},





	/**

	 * Returns the comment inside the comment tag.

	 *

	 * @return {String}

	 */

	getComment : function() {

		return this.comment;

	}



} );

/*global Autolinker */

/**

 * @class Autolinker.htmlParser.ElementNode

 * @extends Autolinker.htmlParser.HtmlNode

 *

 * Represents an HTML element node that has been parsed by the {@link Autolinker.htmlParser.HtmlParser}.

 *

 * See this class's superclass ({@link Autolinker.htmlParser.HtmlNode}) for more

 * details.

 */

Autolinker.htmlParser.ElementNode = Autolinker.Util.extend( Autolinker.htmlParser.HtmlNode, {



	/**

	 * @cfg {String} tagName (required)

	 *

	 * The name of the tag that was matched.

	 */

	tagName : '',



	/**

	 * @cfg {Boolean} closing (required)

	 *

	 * `true` if the element (tag) is a closing tag, `false` if its an opening

	 * tag.

	 */

	closing : false,





	/**

	 * Returns a string name for the type of node that this class represents.

	 *

	 * @return {String}

	 */

	getType : function() {

		return 'element';

	},





	/**

	 * Returns the HTML element's (tag's) name. Ex: for an &lt;img&gt; tag,

	 * returns "img".

	 *

	 * @return {String}

	 */

	getTagName : function() {

		return this.tagName;

	},





	/**

	 * Determines if the HTML element (tag) is a closing tag. Ex: &lt;div&gt;

	 * returns `false`, while &lt;/div&gt; returns `true`.

	 *

	 * @return {Boolean}

	 */

	isClosing : function() {

		return this.closing;

	}



} );

/*global Autolinker */

/**

 * @class Autolinker.htmlParser.EntityNode

 * @extends Autolinker.htmlParser.HtmlNode

 *

 * Represents a known HTML entity node that has been parsed by the {@link Autolinker.htmlParser.HtmlParser}.

 * Ex: '&amp;nbsp;', or '&amp#160;' (which will be retrievable from the {@link #getText}

 * method.

 *

 * Note that this class will only be returned from the HtmlParser for the set of

 * checked HTML entity nodes  defined by the {@link Autolinker.htmlParser.HtmlParser#htmlCharacterEntitiesRegex}.

 *

 * See this class's superclass ({@link Autolinker.htmlParser.HtmlNode}) for more

 * details.

 */

Autolinker.htmlParser.EntityNode = Autolinker.Util.extend( Autolinker.htmlParser.HtmlNode, {



	/**

	 * Returns a string name for the type of node that this class represents.

	 *

	 * @return {String}

	 */

	getType : function() {

		return 'entity';

	}



} );

/*global Autolinker */

/**

 * @class Autolinker.htmlParser.TextNode

 * @extends Autolinker.htmlParser.HtmlNode

 *

 * Represents a text node that has been parsed by the {@link Autolinker.htmlParser.HtmlParser}.

 *

 * See this class's superclass ({@link Autolinker.htmlParser.HtmlNode}) for more

 * details.

 */

Autolinker.htmlParser.TextNode = Autolinker.Util.extend( Autolinker.htmlParser.HtmlNode, {



	/**

	 * Returns a string name for the type of node that this class represents.

	 *

	 * @return {String}

	 */

	getType : function() {

		return 'text';

	}



} );

/*global Autolinker */

/**

 * @abstract

 * @class Autolinker.match.Match

 *

 * Represents a match found in an input string which should be Autolinked. A Match object is what is provided in a

 * {@link Autolinker#replaceFn replaceFn}, and may be used to query for details about the match.

 *

 * For example:

 *

 *     var input = "...";  // string with URLs, Email Addresses, and Mentions (Twitter, Instagram, Soundcloud)

 *

 *     var linkedText = Autolinker.link( input, {

 *         replaceFn : function( match ) {

 *             console.log( "href = ", match.getAnchorHref() );

 *             console.log( "text = ", match.getAnchorText() );

 *

 *             switch( match.getType() ) {

 *                 case 'url' :

 *                     console.log( "url: ", match.getUrl() );

 *

 *                 case 'email' :

 *                     console.log( "email: ", match.getEmail() );

 *

 *                 case 'mention' :

 *                     console.log( "mention: ", match.getMention() );

 *             }

 *         }

 *     } );

 *

 * See the {@link Autolinker} class for more details on using the {@link Autolinker#replaceFn replaceFn}.

 */

Autolinker.match.Match = Autolinker.Util.extend( Object, {



	/**

	 * @cfg {Autolinker.AnchorTagBuilder} tagBuilder (required)

	 *

	 * Reference to the AnchorTagBuilder instance to use to generate an anchor

	 * tag for the Match.

	 */



	/**

	 * @cfg {String} matchedText (required)

	 *

	 * The original text that was matched by the {@link Autolinker.matcher.Matcher}.

	 */



	/**

	 * @cfg {Number} offset (required)

	 *

	 * The offset of where the match was made in the input string.

	 */





	/**

	 * @constructor

	 * @param {Object} cfg The configuration properties for the Match

	 *   instance, specified in an Object (map).

	 */

	constructor : function( cfg ) {

		if( cfg.tagBuilder == null ) throw new Error( '`tagBuilder` cfg required' );

		if( cfg.matchedText == null ) throw new Error( '`matchedText` cfg required' );

		if( cfg.offset == null ) throw new Error( '`offset` cfg required' );



		this.tagBuilder = cfg.tagBuilder;

		this.matchedText = cfg.matchedText;

		this.offset = cfg.offset;

	},





	/**

	 * Returns a string name for the type of match that this class represents.

	 *

	 * @abstract

	 * @return {String}

	 */

	getType : Autolinker.Util.abstractMethod,





	/**

	 * Returns the original text that was matched.

	 *

	 * @return {String}

	 */

	getMatchedText : function() {

		return this.matchedText;

	},





	/**

	 * Sets the {@link #offset} of where the match was made in the input string.

	 *

	 * A {@link Autolinker.matcher.Matcher} will be fed only HTML text nodes,

	 * and will therefore set an original offset that is relative to the HTML

	 * text node itself. However, we want this offset to be relative to the full

	 * HTML input string, and thus if using {@link Autolinker#parse} (rather

	 * than calling a {@link Autolinker.matcher.Matcher} directly), then this

	 * offset is corrected after the Matcher itself has done its job.

	 *

	 * @param {Number} offset

	 */

	setOffset : function( offset ) {

		this.offset = offset;

	},





	/**

	 * Returns the offset of where the match was made in the input string. This

	 * is the 0-based index of the match.

	 *

	 * @return {Number}

	 */

	getOffset : function() {

		return this.offset;

	},





	/**

	 * Returns the anchor href that should be generated for the match.

	 *

	 * @abstract

	 * @return {String}

	 */

	getAnchorHref : Autolinker.Util.abstractMethod,





	/**

	 * Returns the anchor text that should be generated for the match.

	 *

	 * @abstract

	 * @return {String}

	 */

	getAnchorText : Autolinker.Util.abstractMethod,





	/**

	 * Returns the CSS class suffix(es) for this match.

	 *

	 * A CSS class suffix is appended to the {@link Autolinker#className} in

	 * the {@link Autolinker.AnchorTagBuilder} when a match is translated into

	 * an anchor tag.

	 *

	 * For example, if {@link Autolinker#className} was configured as 'myLink',

	 * and this method returns `[ 'url' ]`, the final class name of the element

	 * will become: 'myLink myLink-url'.

	 *

	 * The match may provide multiple CSS class suffixes to be appended to the

	 * {@link Autolinker#className} in order to facilitate better styling

	 * options for different match criteria. See {@link Autolinker.match.Mention}

	 * for an example.

	 *

	 * By default, this method returns a single array with the match's

	 * {@link #getType type} name, but may be overridden by subclasses.

	 *

	 * @return {String[]}

	 */

	getCssClassSuffixes : function() {

		return [ this.getType() ];

	},





	/**

	 * Builds and returns an {@link Autolinker.HtmlTag} instance based on the

	 * Match.

	 *

	 * This can be used to easily generate anchor tags from matches, and either

	 * return their HTML string, or modify them before doing so.

	 *

	 * Example Usage:

	 *

	 *     var tag = match.buildTag();

	 *     tag.addClass( 'cordova-link' );

	 *     tag.setAttr( 'target', '_system' );

	 *

	 *     tag.toAnchorString();  // <a href="http://google.com" class="cordova-link" target="_system">Google</a>

	 */

	buildTag : function() {

		return this.tagBuilder.build( this );

	}



} );



/*global Autolinker */

/**

 * @class Autolinker.match.Email

 * @extends Autolinker.match.Match

 *

 * Represents a Email match found in an input string which should be Autolinked.

 *

 * See this class's superclass ({@link Autolinker.match.Match}) for more details.

 */

Autolinker.match.Email = Autolinker.Util.extend( Autolinker.match.Match, {



	/**

	 * @cfg {String} email (required)

	 *

	 * The email address that was matched.

	 */





	/**

	 * @constructor

	 * @param {Object} cfg The configuration properties for the Match

	 *   instance, specified in an Object (map).

	 */

	constructor : function( cfg ) {

		Autolinker.match.Match.prototype.constructor.call( this, cfg );



		if( !cfg.email ) throw new Error( '`email` cfg required' );



		this.email = cfg.email;

	},





	/**

	 * Returns a string name for the type of match that this class represents.

	 *

	 * @return {String}

	 */

	getType : function() {

		return 'email';

	},





	/**

	 * Returns the email address that was matched.

	 *

	 * @return {String}

	 */

	getEmail : function() {

		return this.email;

	},





	/**

	 * Returns the anchor href that should be generated for the match.

	 *

	 * @return {String}

	 */

	getAnchorHref : function() {

		return 'mailto:' + this.email;

	},





	/**

	 * Returns the anchor text that should be generated for the match.

	 *

	 * @return {String}

	 */

	getAnchorText : function() {

		return this.email;

	}



} );

/*global Autolinker */

/**

 * @class Autolinker.match.Hashtag

 * @extends Autolinker.match.Match

 *

 * Represents a Hashtag match found in an input string which should be

 * Autolinked.

 *

 * See this class's superclass ({@link Autolinker.match.Match}) for more

 * details.

 */

Autolinker.match.Hashtag = Autolinker.Util.extend( Autolinker.match.Match, {



	/**

	 * @cfg {String} serviceName

	 *

	 * The service to point hashtag matches to. See {@link Autolinker#hashtag}

	 * for available values.

	 */



	/**

	 * @cfg {String} hashtag (required)

	 *

	 * The Hashtag that was matched, without the '#'.

	 */





	/**

	 * @constructor

	 * @param {Object} cfg The configuration properties for the Match

	 *   instance, specified in an Object (map).

	 */

	constructor : function( cfg ) {

		Autolinker.match.Match.prototype.constructor.call( this, cfg );



		// TODO: if( !serviceName ) throw new Error( '`serviceName` cfg required' );

		if( !cfg.hashtag ) throw new Error( '`hashtag` cfg required' );



		this.serviceName = cfg.serviceName;

		this.hashtag = cfg.hashtag;

	},





	/**

	 * Returns the type of match that this class represents.

	 *

	 * @return {String}

	 */

	getType : function() {

		return 'hashtag';

	},





	/**

	 * Returns the configured {@link #serviceName} to point the Hashtag to.

	 * Ex: 'facebook', 'twitter'.

	 *

	 * @return {String}

	 */

	getServiceName : function() {

		return this.serviceName;

	},





	/**

	 * Returns the matched hashtag, without the '#' character.

	 *

	 * @return {String}

	 */

	getHashtag : function() {

		return this.hashtag;

	},





	/**

	 * Returns the anchor href that should be generated for the match.

	 *

	 * @return {String}

	 */

	getAnchorHref : function() {

		var serviceName = this.serviceName,

		    hashtag = this.hashtag;



		switch( serviceName ) {

			case 'twitter' :

				return 'https://twitter.com/hashtag/' + hashtag;

			case 'facebook' :

				return 'https://www.facebook.com/hashtag/' + hashtag;

			case 'instagram' :

				return 'https://instagram.com/explore/tags/' + hashtag;



			default :  // Shouldn't happen because Autolinker's constructor should block any invalid values, but just in case.

				throw new Error( 'Unknown service name to point hashtag to: ', serviceName );

		}

	},





	/**

	 * Returns the anchor text that should be generated for the match.

	 *

	 * @return {String}

	 */

	getAnchorText : function() {

		return '#' + this.hashtag;

	}



} );



/*global Autolinker */

/**

 * @class Autolinker.match.Phone

 * @extends Autolinker.match.Match

 *

 * Represents a Phone number match found in an input string which should be

 * Autolinked.

 *

 * See this class's superclass ({@link Autolinker.match.Match}) for more

 * details.

 */

Autolinker.match.Phone = Autolinker.Util.extend( Autolinker.match.Match, {



	/**

	 * @protected

	 * @property {String} number (required)

	 *

	 * The phone number that was matched, without any delimiter characters.

	 *

	 * Note: This is a string to allow for prefixed 0's.

	 */



	/**

	 * @protected

	 * @property  {Boolean} plusSign (required)

	 *

	 * `true` if the matched phone number started with a '+' sign. We'll include

	 * it in the `tel:` URL if so, as this is needed for international numbers.

	 *

	 * Ex: '+1 (123) 456 7879'

	 */





	/**

	 * @constructor

	 * @param {Object} cfg The configuration properties for the Match

	 *   instance, specified in an Object (map).

	 */

	constructor : function( cfg ) {

		Autolinker.match.Match.prototype.constructor.call( this, cfg );



		if( !cfg.number ) throw new Error( '`number` cfg required' );

		if( cfg.plusSign == null ) throw new Error( '`plusSign` cfg required' );



		this.number = cfg.number;

		this.plusSign = cfg.plusSign;

	},





	/**

	 * Returns a string name for the type of match that this class represents.

	 *

	 * @return {String}

	 */

	getType : function() {

		return 'phone';

	},





	/**

	 * Returns the phone number that was matched as a string, without any

	 * delimiter characters.

	 *

	 * Note: This is a string to allow for prefixed 0's.

	 *

	 * @return {String}

	 */

	getNumber: function() {

		return this.number;

	},





	/**

	 * Returns the anchor href that should be generated for the match.

	 *

	 * @return {String}

	 */

	getAnchorHref : function() {

		return 'tel:' + ( this.plusSign ? '+' : '' ) + this.number;

	},





	/**

	 * Returns the anchor text that should be generated for the match.

	 *

	 * @return {String}

	 */

	getAnchorText : function() {

		return this.matchedText;

	}



} );



/*global Autolinker */

/**

 * @class Autolinker.match.Mention

 * @extends Autolinker.match.Match

 *

 * Represents a Mention match found in an input string which should be Autolinked.

 *

 * See this class's superclass ({@link Autolinker.match.Match}) for more details.

 */

Autolinker.match.Mention = Autolinker.Util.extend( Autolinker.match.Match, {



	/**

	 * @cfg {String} serviceName

	 *

	 * The service to point mention matches to. See {@link Autolinker#mention}

	 * for available values.

	 */



	/**

	 * @cfg {String} mention (required)

	 *

	 * The Mention that was matched, without the '@' character.

	 */





	/**

	 * @constructor

	 * @param {Object} cfg The configuration properties for the Match

	 *   instance, specified in an Object (map).

	 */

	constructor : function( cfg ) {

		Autolinker.match.Match.prototype.constructor.call( this, cfg );



		if( !cfg.serviceName ) throw new Error( '`serviceName` cfg required' );

		if( !cfg.mention ) throw new Error( '`mention` cfg required' );



		this.mention = cfg.mention;

		this.serviceName = cfg.serviceName;

	},





	/**

	 * Returns the type of match that this class represents.

	 *

	 * @return {String}

	 */

	getType : function() {

		return 'mention';

	},





	/**

	 * Returns the mention, without the '@' character.

	 *

	 * @return {String}

	 */

	getMention : function() {

		return this.mention;

	},





	/**

	 * Returns the configured {@link #serviceName} to point the mention to.

	 * Ex: 'instagram', 'twitter', 'soundcloud'.

	 *

	 * @return {String}

	 */

	getServiceName : function() {

		return this.serviceName;

	},





	/**

	 * Returns the anchor href that should be generated for the match.

	 *

	 * @return {String}

	 */

	getAnchorHref : function() {

		switch( this.serviceName ) {

			case 'twitter' :

				return 'https://twitter.com/' + this.mention;

			case 'instagram' :

				return 'https://instagram.com/' + this.mention;

			case 'soundcloud' :

				return 'https://soundcloud.com/' + this.mention;



			default :  // Shouldn't happen because Autolinker's constructor should block any invalid values, but just in case.

				throw new Error( 'Unknown service name to point mention to: ', this.serviceName );

		}

	},





	/**

	 * Returns the anchor text that should be generated for the match.

	 *

	 * @return {String}

	 */

	getAnchorText : function() {

		return '@' + this.mention;

	},





	/**

	 * Returns the CSS class suffixes that should be used on a tag built with

	 * the match. See {@link Autolinker.match.Match#getCssClassSuffixes} for

	 * details.

	 *

	 * @return {String[]}

	 */

	getCssClassSuffixes : function() {

		var cssClassSuffixes = Autolinker.match.Match.prototype.getCssClassSuffixes.call( this ),

		    serviceName = this.getServiceName();



		if( serviceName ) {

			cssClassSuffixes.push( serviceName );

		}

		return cssClassSuffixes;

	}



} );



/*global Autolinker */

/**

 * @class Autolinker.match.Url

 * @extends Autolinker.match.Match

 *

 * Represents a Url match found in an input string which should be Autolinked.

 *

 * See this class's superclass ({@link Autolinker.match.Match}) for more details.

 */

Autolinker.match.Url = Autolinker.Util.extend( Autolinker.match.Match, {



	/**

	 * @cfg {String} url (required)

	 *

	 * The url that was matched.

	 */



	/**

	 * @cfg {"scheme"/"www"/"tld"} urlMatchType (required)

	 *

	 * The type of URL match that this class represents. This helps to determine

	 * if the match was made in the original text with a prefixed scheme (ex:

	 * 'http://www.google.com'), a prefixed 'www' (ex: 'www.google.com'), or

	 * was matched by a known top-level domain (ex: 'google.com').

	 */



	/**

	 * @cfg {Boolean} protocolUrlMatch (required)

	 *

	 * `true` if the URL is a match which already has a protocol (i.e.

	 * 'http://'), `false` if the match was from a 'www' or known TLD match.

	 */



	/**

	 * @cfg {Boolean} protocolRelativeMatch (required)

	 *

	 * `true` if the URL is a protocol-relative match. A protocol-relative match

	 * is a URL that starts with '//', and will be either http:// or https://

	 * based on the protocol that the site is loaded under.

	 */



	/**

	 * @cfg {Object} stripPrefix (required)

	 *

	 * The Object form of {@link Autolinker#cfg-stripPrefix}.

	 */



	/**

	 * @cfg {Boolean} stripTrailingSlash (required)

	 * @inheritdoc Autolinker#cfg-stripTrailingSlash

	 */



	/**

	 * @cfg {Boolean} decodePercentEncoding (required)

	 * @inheritdoc Autolinker#cfg-decodePercentEncoding

	 */



	/**

	 * @constructor

	 * @param {Object} cfg The configuration properties for the Match

	 *   instance, specified in an Object (map).

	 */

	constructor : function( cfg ) {

		Autolinker.match.Match.prototype.constructor.call( this, cfg );



		if( cfg.urlMatchType !== 'scheme' && cfg.urlMatchType !== 'www' && cfg.urlMatchType !== 'tld' ) throw new Error( '`urlMatchType` cfg must be one of: "scheme", "www", or "tld"' );

		if( !cfg.url ) throw new Error( '`url` cfg required' );

		if( cfg.protocolUrlMatch == null ) throw new Error( '`protocolUrlMatch` cfg required' );

		if( cfg.protocolRelativeMatch == null ) throw new Error( '`protocolRelativeMatch` cfg required' );

		if( cfg.stripPrefix == null ) throw new Error( '`stripPrefix` cfg required' );

		if( cfg.stripTrailingSlash == null ) throw new Error( '`stripTrailingSlash` cfg required' );

		if( cfg.decodePercentEncoding == null ) throw new Error( '`decodePercentEncoding` cfg required' );



		this.urlMatchType = cfg.urlMatchType;

		this.url = cfg.url;

		this.protocolUrlMatch = cfg.protocolUrlMatch;

		this.protocolRelativeMatch = cfg.protocolRelativeMatch;

		this.stripPrefix = cfg.stripPrefix;

		this.stripTrailingSlash = cfg.stripTrailingSlash;

		this.decodePercentEncoding = cfg.decodePercentEncoding;

	},





	/**

	 * @private

	 * @property {RegExp} schemePrefixRegex

	 *

	 * A regular expression used to remove the 'http://' or 'https://' from

	 * URLs.

	 */

	schemePrefixRegex: /^(https?:\/\/)?/i,



	/**

	 * @private

	 * @property {RegExp} wwwPrefixRegex

	 *

	 * A regular expression used to remove the 'www.' from URLs.

	 */

	wwwPrefixRegex: /^(https?:\/\/)?(www\.)?/i,



	/**

	 * @private

	 * @property {RegExp} protocolRelativeRegex

	 *

	 * The regular expression used to remove the protocol-relative '//' from the {@link #url} string, for purposes

	 * of {@link #getAnchorText}. A protocol-relative URL is, for example, "//yahoo.com"

	 */

	protocolRelativeRegex : /^\/\//,



	/**

	 * @private

	 * @property {Boolean} protocolPrepended

	 *

	 * Will be set to `true` if the 'http://' protocol has been prepended to the {@link #url} (because the

	 * {@link #url} did not have a protocol)

	 */

	protocolPrepended : false,





	/**

	 * Returns a string name for the type of match that this class represents.

	 *

	 * @return {String}

	 */

	getType : function() {

		return 'url';

	},





	/**

	 * Returns a string name for the type of URL match that this class

	 * represents.

	 *

	 * This helps to determine if the match was made in the original text with a

	 * prefixed scheme (ex: 'http://www.google.com'), a prefixed 'www' (ex:

	 * 'www.google.com'), or was matched by a known top-level domain (ex:

	 * 'google.com').

	 *

	 * @return {"scheme"/"www"/"tld"}

	 */

	getUrlMatchType : function() {

		return this.urlMatchType;

	},





	/**

	 * Returns the url that was matched, assuming the protocol to be 'http://' if the original

	 * match was missing a protocol.

	 *

	 * @return {String}

	 */

	getUrl : function() {

		var url = this.url;



		// if the url string doesn't begin with a protocol, assume 'http://'

		if( !this.protocolRelativeMatch && !this.protocolUrlMatch && !this.protocolPrepended ) {

			url = this.url = 'http://' + url;



			this.protocolPrepended = true;

		}



		return url;

	},





	/**

	 * Returns the anchor href that should be generated for the match.

	 *

	 * @return {String}

	 */

	getAnchorHref : function() {

		var url = this.getUrl();



		return url.replace( /&amp;/g, '&' );  // any &amp;'s in the URL should be converted back to '&' if they were displayed as &amp; in the source html

	},





	/**

	 * Returns the anchor text that should be generated for the match.

	 *

	 * @return {String}

	 */

	getAnchorText : function() {

		var anchorText = this.getMatchedText();



		if( this.protocolRelativeMatch ) {

			// Strip off any protocol-relative '//' from the anchor text

			anchorText = this.stripProtocolRelativePrefix( anchorText );

		}

		if( this.stripPrefix.scheme ) {

			anchorText = this.stripSchemePrefix( anchorText );

		}

		if( this.stripPrefix.www ) {

			anchorText = this.stripWwwPrefix( anchorText );

		}

		if( this.stripTrailingSlash ) {

			anchorText = this.removeTrailingSlash( anchorText );  // remove trailing slash, if there is one

		}

		if( this.decodePercentEncoding ) {

			anchorText = this.removePercentEncoding( anchorText);

		}



		return anchorText;

	},





	// ---------------------------------------



	// Utility Functionality



	/**

	 * Strips the scheme prefix (such as "http://" or "https://") from the given

	 * `url`.

	 *

	 * @private

	 * @param {String} url The text of the anchor that is being generated, for

	 *   which to strip off the url scheme.

	 * @return {String} The `url`, with the scheme stripped.

	 */

	stripSchemePrefix : function( url ) {

		return url.replace( this.schemePrefixRegex, '' );

	},





	/**

	 * Strips the 'www' prefix from the given `url`.

	 *

	 * @private

	 * @param {String} url The text of the anchor that is being generated, for

	 *   which to strip off the 'www' if it exists.

	 * @return {String} The `url`, with the 'www' stripped.

	 */

	stripWwwPrefix : function( url ) {

		return url.replace( this.wwwPrefixRegex, '$1' );  // leave any scheme ($1), it one exists

	},





	/**

	 * Strips any protocol-relative '//' from the anchor text.

	 *

	 * @private

	 * @param {String} text The text of the anchor that is being generated, for which to strip off the

	 *   protocol-relative prefix (such as stripping off "//")

	 * @return {String} The `anchorText`, with the protocol-relative prefix stripped.

	 */

	stripProtocolRelativePrefix : function( text ) {

		return text.replace( this.protocolRelativeRegex, '' );

	},





	/**

	 * Removes any trailing slash from the given `anchorText`, in preparation for the text to be displayed.

	 *

	 * @private

	 * @param {String} anchorText The text of the anchor that is being generated, for which to remove any trailing

	 *   slash ('/') that may exist.

	 * @return {String} The `anchorText`, with the trailing slash removed.

	 */

	removeTrailingSlash : function( anchorText ) {

		if( anchorText.charAt( anchorText.length - 1 ) === '/' ) {

			anchorText = anchorText.slice( 0, -1 );

		}

		return anchorText;

	},



	/**

	 * Decodes percent-encoded characters from the given `anchorText`, in preparation for the text to be displayed.

	 *

	 * @private

	 * @param {String} anchorText The text of the anchor that is being generated, for which to decode any percent-encoded characters.

	 * @return {String} The `anchorText`, with the percent-encoded characters decoded.

	 */

	removePercentEncoding : function( anchorText ) {

		try {

			return decodeURIComponent( anchorText

				.replace( /%22/gi, '&quot;' )

				.replace( /%26/gi, '&amp;' )

				.replace( /%27/gi, '&#39;')

				.replace( /%3C/gi, '&lt;' )

				.replace( /%3E/gi, '&gt;' )

			 );

		} catch (e) {

			// Invalid escape sequence.

			return anchorText;

		}

	}



} );

// NOTE: THIS IS A GENERATED FILE

// To update with the latest TLD list, run `gulp update-tld-list`



/*global Autolinker */

Autolinker.tldRegex = /(?:xn--vermgensberatung-pwb|xn--vermgensberater-ctb|xn--clchc0ea0b2g2a9gcd|xn--w4r85el8fhu5dnra|northwesternmutual|travelersinsurance|vermögensberatung|xn--3oq18vl8pn36a|xn--5su34j936bgsg|xn--bck1b9a5dre4c|xn--mgbai9azgqp6j|xn--mgberp4a5d4ar|xn--xkc2dl3a5ee0h|vermögensberater|xn--fzys8d69uvgm|xn--mgba7c0bbn0a|xn--xkc2al3hye2a|americanexpress|kerryproperties|sandvikcoromant|xn--i1b6b1a6a2e|xn--kcrx77d1x4a|xn--lgbbat1ad8j|xn--mgba3a4f16a|xn--mgbc0a9azcg|xn--nqv7fs00ema|afamilycompany|americanfamily|bananarepublic|cancerresearch|cookingchannel|kerrylogistics|weatherchannel|xn--54b7fta0cc|xn--6qq986b3xl|xn--80aqecdr1a|xn--b4w605ferd|xn--fiq228c5hs|xn--jlq61u9w7b|xn--mgba3a3ejt|xn--mgbaam7a8h|xn--mgbayh7gpa|xn--mgbb9fbpob|xn--mgbbh1a71e|xn--mgbca7dzdo|xn--mgbi4ecexp|xn--mgbx4cd0ab|international|lifeinsurance|orientexpress|spreadbetting|travelchannel|wolterskluwer|xn--eckvdtc9d|xn--fpcrj9c3d|xn--fzc2c9e2c|xn--tiq49xqyj|xn--yfro4i67o|xn--ygbi2ammx|construction|lplfinancial|pamperedchef|scholarships|versicherung|xn--3e0b707e|xn--80adxhks|xn--80asehdb|xn--8y0a063a|xn--gckr3f0f|xn--mgb9awbf|xn--mgbab2bd|xn--mgbpl2fh|xn--mgbt3dhd|xn--mk1bu44c|xn--ngbc5azd|xn--ngbe9e0a|xn--ogbpf8fl|xn--qcka1pmc|accountants|barclaycard|blackfriday|blockbuster|bridgestone|calvinklein|contractors|creditunion|engineering|enterprises|foodnetwork|investments|kerryhotels|lamborghini|motorcycles|olayangroup|photography|playstation|productions|progressive|redumbrella|rightathome|williamhill|xn--11b4c3d|xn--1ck2e1b|xn--1qqw23a|xn--3bst00m|xn--3ds443g|xn--42c2d9a|xn--45brj9c|xn--55qw42g|xn--6frz82g|xn--80ao21a|xn--9krt00a|xn--cck2b3b|xn--czr694b|xn--d1acj3b|xn--efvy88h|xn--estv75g|xn--fct429k|xn--fjq720a|xn--flw351e|xn--g2xx48c|xn--gecrj9c|xn--gk3at1e|xn--h2brj9c|xn--hxt814e|xn--imr513n|xn--j6w193g|xn--jvr189m|xn--kprw13d|xn--kpry57d|xn--kpu716f|xn--mgbtx2b|xn--mix891f|xn--nyqy26a|xn--pbt977c|xn--pgbs0dh|xn--q9jyb4c|xn--rhqv96g|xn--rovu88b|xn--s9brj9c|xn--ses554g|xn--t60b56a|xn--vuq861b|xn--w4rs40l|xn--xhq521b|xn--zfr164b|சிங்கப்பூர்|accountant|apartments|associates|basketball|bnpparibas|boehringer|capitalone|consulting|creditcard|cuisinella|eurovision|extraspace|foundation|healthcare|immobilien|industries|management|mitsubishi|nationwide|newholland|nextdirect|onyourside|properties|protection|prudential|realestate|republican|restaurant|schaeffler|swiftcover|tatamotors|technology|telefonica|university|vistaprint|vlaanderen|volkswagen|xn--30rr7y|xn--3pxu8k|xn--45q11c|xn--4gbrim|xn--55qx5d|xn--5tzm5g|xn--80aswg|xn--90a3ac|xn--9dbq2a|xn--9et52u|xn--c2br7g|xn--cg4bki|xn--czrs0t|xn--czru2d|xn--fiq64b|xn--fiqs8s|xn--fiqz9s|xn--io0a7i|xn--kput3i|xn--mxtq1m|xn--o3cw4h|xn--pssy2u|xn--unup4y|xn--wgbh1c|xn--wgbl6a|xn--y9a3aq|accenture|alfaromeo|allfinanz|amsterdam|analytics|aquarelle|barcelona|bloomberg|christmas|community|directory|education|equipment|fairwinds|financial|firestone|fresenius|frontdoor|fujixerox|furniture|goldpoint|goodhands|hisamitsu|homedepot|homegoods|homesense|honeywell|institute|insurance|kuokgroup|ladbrokes|lancaster|landrover|lifestyle|marketing|marshalls|mcdonalds|melbourne|microsoft|montblanc|panasonic|passagens|pramerica|richardli|scjohnson|shangrila|solutions|statebank|statefarm|stockholm|travelers|vacations|xn--90ais|xn--c1avg|xn--d1alf|xn--e1a4c|xn--fhbei|xn--j1aef|xn--j1amh|xn--l1acc|xn--nqv7f|xn--p1acf|xn--tckwe|xn--vhquv|yodobashi|abudhabi|airforce|allstate|attorney|barclays|barefoot|bargains|baseball|boutique|bradesco|broadway|brussels|budapest|builders|business|capetown|catering|catholic|chrysler|cipriani|cityeats|cleaning|clinique|clothing|commbank|computer|delivery|deloitte|democrat|diamonds|discount|discover|download|engineer|ericsson|esurance|everbank|exchange|feedback|fidelity|firmdale|football|frontier|goodyear|grainger|graphics|guardian|hdfcbank|helsinki|holdings|hospital|infiniti|ipiranga|istanbul|jpmorgan|lighting|lundbeck|marriott|maserati|mckinsey|memorial|mortgage|movistar|observer|partners|pharmacy|pictures|plumbing|property|redstone|reliance|saarland|samsclub|security|services|shopping|showtime|softbank|software|stcgroup|supplies|symantec|telecity|training|uconnect|vanguard|ventures|verisign|woodside|xn--90ae|xn--node|xn--p1ai|xn--qxam|yokohama|السعودية|abogado|academy|agakhan|alibaba|android|athleta|auction|audible|auspost|avianca|banamex|bauhaus|bentley|bestbuy|booking|brother|bugatti|capital|caravan|careers|cartier|channel|chintai|citadel|clubmed|college|cologne|comcast|company|compare|contact|cooking|corsica|country|coupons|courses|cricket|cruises|dentist|digital|domains|exposed|express|farmers|fashion|ferrari|ferrero|finance|fishing|fitness|flights|florist|flowers|forsale|frogans|fujitsu|gallery|genting|godaddy|guitars|hamburg|hangout|hitachi|holiday|hosting|hoteles|hotmail|hyundai|iselect|ismaili|jewelry|juniper|kitchen|komatsu|lacaixa|lancome|lanxess|lasalle|latrobe|leclerc|liaison|limited|lincoln|markets|metlife|monster|netbank|netflix|network|neustar|okinawa|oldnavy|organic|origins|panerai|philips|pioneer|politie|realtor|recipes|rentals|reviews|rexroth|samsung|sandvik|schmidt|schwarz|science|shiksha|shriram|singles|spiegel|staples|starhub|statoil|storage|support|surgery|systems|temasek|theater|theatre|tickets|tiffany|toshiba|trading|walmart|wanggou|watches|weather|website|wedding|whoswho|windows|winners|xfinity|yamaxun|youtube|zuerich|католик|الجزائر|العليان|پاکستان|كاثوليك|موبايلي|இந்தியா|abarth|abbott|abbvie|active|africa|agency|airbus|airtel|alipay|alsace|alstom|anquan|aramco|author|bayern|beauty|berlin|bharti|blanco|bostik|boston|broker|camera|career|caseih|casino|center|chanel|chrome|church|circle|claims|clinic|coffee|comsec|condos|coupon|credit|cruise|dating|datsun|dealer|degree|dental|design|direct|doctor|dunlop|dupont|durban|emerck|energy|estate|events|expert|family|flickr|futbol|gallup|garden|george|giving|global|google|gratis|health|hermes|hiphop|hockey|hughes|imamat|insure|intuit|jaguar|joburg|juegos|kaufen|kinder|kindle|kosher|lancia|latino|lawyer|lefrak|living|locker|london|luxury|madrid|maison|makeup|market|mattel|mobile|mobily|monash|mormon|moscow|museum|mutual|nagoya|natura|nissan|nissay|norton|nowruz|office|olayan|online|oracle|orange|otsuka|pfizer|photos|physio|piaget|pictet|quebec|racing|realty|reisen|repair|report|review|rocher|rogers|ryukyu|safety|sakura|sanofi|school|schule|secure|select|shouji|soccer|social|stream|studio|supply|suzuki|swatch|sydney|taipei|taobao|target|tattoo|tennis|tienda|tjmaxx|tkmaxx|toyota|travel|unicom|viajes|viking|villas|virgin|vision|voting|voyage|vuelos|walter|warman|webcam|xihuan|xperia|yachts|yandex|zappos|москва|онлайн|ابوظبي|ارامكو|الاردن|المغرب|امارات|فلسطين|مليسيا|இலங்கை|ファッション|actor|adult|aetna|amfam|amica|apple|archi|audio|autos|azure|baidu|beats|bible|bingo|black|boats|boots|bosch|build|canon|cards|chase|cheap|chloe|cisco|citic|click|cloud|coach|codes|crown|cymru|dabur|dance|deals|delta|dodge|drive|dubai|earth|edeka|email|epost|epson|faith|fedex|final|forex|forum|gallo|games|gifts|gives|glade|glass|globo|gmail|green|gripe|group|gucci|guide|homes|honda|horse|house|hyatt|ikano|intel|irish|iveco|jetzt|koeln|kyoto|lamer|lease|legal|lexus|lilly|linde|lipsy|lixil|loans|locus|lotte|lotto|lupin|macys|mango|media|miami|money|mopar|movie|nadex|nexus|nikon|ninja|nokia|nowtv|omega|osaka|paris|parts|party|phone|photo|pizza|place|poker|praxi|press|prime|promo|quest|radio|rehab|reise|ricoh|rocks|rodeo|salon|sener|seven|sharp|shell|shoes|skype|sling|smart|smile|solar|space|stada|store|study|style|sucks|swiss|tatar|tires|tirol|tmall|today|tokyo|tools|toray|total|tours|trade|trust|tunes|tushu|ubank|vegas|video|vista|vodka|volvo|wales|watch|weber|weibo|works|world|xerox|yahoo|zippo|ایران|بازار|بھارت|سودان|سورية|همراه|संगठन|বাংলা|భారత్|嘉里大酒店|aarp|able|adac|aero|aigo|akdn|ally|amex|army|arpa|arte|asda|asia|audi|auto|baby|band|bank|bbva|beer|best|bike|bing|blog|blue|bofa|bond|book|buzz|cafe|call|camp|care|cars|casa|case|cash|cbre|cern|chat|citi|city|club|cool|coop|cyou|data|date|dclk|deal|dell|desi|diet|dish|docs|doha|duck|duns|dvag|erni|fage|fail|fans|farm|fast|fiat|fido|film|fire|fish|flir|food|ford|free|fund|game|gbiz|gent|ggee|gift|gmbh|gold|golf|goog|guge|guru|hair|haus|hdfc|help|here|hgtv|host|hsbc|icbc|ieee|imdb|immo|info|itau|java|jeep|jobs|jprs|kddi|kiwi|kpmg|kred|land|lego|lgbt|lidl|life|like|limo|link|live|loan|loft|love|ltda|luxe|maif|meet|meme|menu|mini|mint|mobi|moda|moto|mtpc|name|navy|news|next|nico|nike|ollo|open|page|pars|pccw|pics|ping|pink|play|plus|pohl|porn|post|prod|prof|qpon|raid|read|reit|rent|rest|rich|rmit|room|rsvp|ruhr|safe|sale|sapo|sarl|save|saxo|scor|scot|seat|seek|sexy|shaw|shia|shop|show|silk|sina|site|skin|sncf|sohu|song|sony|spot|star|surf|talk|taxi|team|tech|teva|tiaa|tips|town|toys|tube|vana|visa|viva|vivo|vote|voto|wang|weir|wien|wiki|wine|work|xbox|yoga|zara|zero|zone|дети|сайт|بيتك|تونس|شبكة|عراق|عمان|موقع|भारत|ভারত|ਭਾਰਤ|ભારત|ලංකා|グーグル|クラウド|ポイント|大众汽车|组织机构|電訊盈科|香格里拉|aaa|abb|abc|aco|ads|aeg|afl|aig|anz|aol|app|art|aws|axa|bar|bbc|bbt|bcg|bcn|bet|bid|bio|biz|bms|bmw|bnl|bom|boo|bot|box|buy|bzh|cab|cal|cam|car|cat|cba|cbn|cbs|ceb|ceo|cfa|cfd|com|crs|csc|dad|day|dds|dev|dhl|diy|dnp|dog|dot|dtv|dvr|eat|eco|edu|esq|eus|fan|fit|fly|foo|fox|frl|ftr|fun|fyi|gal|gap|gdn|gea|gle|gmo|gmx|goo|gop|got|gov|hbo|hiv|hkt|hot|how|htc|ibm|ice|icu|ifm|ing|ink|int|ist|itv|iwc|jcb|jcp|jio|jlc|jll|jmp|jnj|jot|joy|kfh|kia|kim|kpn|krd|lat|law|lds|lol|lpl|ltd|man|mba|mcd|med|men|meo|mil|mit|mlb|mls|mma|moe|moi|mom|mov|msd|mtn|mtr|nab|nba|nec|net|new|nfl|ngo|nhk|now|nra|nrw|ntt|nyc|obi|off|one|ong|onl|ooo|org|ott|ovh|pay|pet|pid|pin|pnc|pro|pru|pub|pwc|qvc|red|ren|ril|rio|rip|run|rwe|sap|sas|sbi|sbs|sca|scb|ses|sew|sex|sfr|ski|sky|soy|srl|srt|stc|tab|tax|tci|tdk|tel|thd|tjx|top|trv|tui|tvs|ubs|uno|uol|ups|vet|vig|vin|vip|wed|win|wme|wow|wtc|wtf|xin|xxx|xyz|you|yun|zip|бел|ком|қаз|мкд|мон|орг|рус|срб|укр|հայ|קום|قطر|كوم|مصر|कॉम|नेट|คอม|ไทย|ストア|セール|みんな|中文网|天主教|我爱你|新加坡|淡马锡|诺基亚|飞利浦|ac|ad|ae|af|ag|ai|al|am|ao|aq|ar|as|at|au|aw|ax|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|cr|cu|cv|cw|cx|cy|cz|de|dj|dk|dm|do|dz|ec|ee|eg|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|in|io|iq|ir|is|it|je|jm|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|me|mg|mh|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|re|ro|rs|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|sk|sl|sm|sn|so|sr|st|su|sv|sx|sy|sz|tc|td|tf|tg|th|tj|tk|tl|tm|tn|to|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|za|zm|zw|ελ|бг|ею|рф|გე|닷넷|닷컴|삼성|한국|コム|世界|中信|中国|中國|企业|佛山|信息|健康|八卦|公司|公益|台湾|台灣|商城|商店|商标|嘉里|在线|大拿|娱乐|家電|工行|广东|微博|慈善|手机|手表|政务|政府|新闻|时尚|書籍|机构|游戏|澳門|点看|珠宝|移动|网址|网店|网站|网络|联通|谷歌|购物|通販|集团|食品|餐厅|香港)/;



/*global Autolinker */

/**

 * @abstract

 * @class Autolinker.matcher.Matcher

 *

 * An abstract class and interface for individual matchers to find matches in

 * an input string with linkified versions of them.

 *

 * Note that Matchers do not take HTML into account - they must be fed the text

 * nodes of any HTML string, which is handled by {@link Autolinker#parse}.

 */

Autolinker.matcher.Matcher = Autolinker.Util.extend( Object, {



	/**

	 * @cfg {Autolinker.AnchorTagBuilder} tagBuilder (required)

	 *

	 * Reference to the AnchorTagBuilder instance to use to generate HTML tags

	 * for {@link Autolinker.match.Match Matches}.

	 */





	/**

	 * @constructor

	 * @param {Object} cfg The configuration properties for the Matcher

	 *   instance, specified in an Object (map).

	 */

	constructor : function( cfg ) {

		if( !cfg.tagBuilder ) throw new Error( '`tagBuilder` cfg required' );



		this.tagBuilder = cfg.tagBuilder;

	},





	/**

	 * Parses the input `text` and returns the array of {@link Autolinker.match.Match Matches}

	 * for the matcher.

	 *

	 * @abstract

	 * @param {String} text The text to scan and replace matches in.

	 * @return {Autolinker.match.Match[]}

	 */

	parseMatches : Autolinker.Util.abstractMethod



} );

/*global Autolinker */

/**

 * @class Autolinker.matcher.Email

 * @extends Autolinker.matcher.Matcher

 *

 * Matcher to find email matches in an input string.

 *

 * See this class's superclass ({@link Autolinker.matcher.Matcher}) for more details.

 */

Autolinker.matcher.Email = Autolinker.Util.extend( Autolinker.matcher.Matcher, {



	/**

	 * The regular expression to match email addresses. Example match:

	 *

	 *     person@place.com

	 *

	 * @private

	 * @property {RegExp} matcherRegex

	 */

	matcherRegex : (function() {

		var alphaNumericChars = Autolinker.RegexLib.alphaNumericCharsStr,

			specialCharacters = '!#$%&\'*+\\-\\/=?^_`{|}~',

			restrictedSpecialCharacters = '\\s"(),:;<>@\\[\\]',

			validCharacters = alphaNumericChars + specialCharacters,

			validRestrictedCharacters = validCharacters + restrictedSpecialCharacters,

		    emailRegex = new RegExp( '(?:[' + validCharacters + '](?:[' + validCharacters + ']|\\.(?!\\.|@))*|\\"[' + validRestrictedCharacters + '.]+\\")@'),

			getDomainNameStr = Autolinker.RegexLib.getDomainNameStr,

			tldRegex = Autolinker.tldRegex;  // match our known top level domains (TLDs)



		return new RegExp( [

			emailRegex.source,

			getDomainNameStr(1),

			'\\.', tldRegex.source   // '.com', '.net', etc

		].join( "" ), 'gi' );

	} )(),





	/**

	 * @inheritdoc

	 */

	parseMatches : function( text ) {

		var matcherRegex = this.matcherRegex,

		    tagBuilder = this.tagBuilder,

		    matches = [],

		    match;



		while( ( match = matcherRegex.exec( text ) ) !== null ) {

			var matchedText = match[ 0 ];



			matches.push( new Autolinker.match.Email( {

				tagBuilder  : tagBuilder,

				matchedText : matchedText,

				offset      : match.index,

				email       : matchedText

			} ) );

		}



		return matches;

	}



} );



/*global Autolinker */

/**

 * @class Autolinker.matcher.Hashtag

 * @extends Autolinker.matcher.Matcher

 *

 * Matcher to find Hashtag matches in an input string.

 */

Autolinker.matcher.Hashtag = Autolinker.Util.extend( Autolinker.matcher.Matcher, {



	/**

	 * @cfg {String} serviceName

	 *

	 * The service to point hashtag matches to. See {@link Autolinker#hashtag}

	 * for available values.

	 */





	/**

	 * The regular expression to match Hashtags. Example match:

	 *

	 *     #asdf

	 *

	 * @private

	 * @property {RegExp} matcherRegex

	 */

	matcherRegex : new RegExp( '#[_' + Autolinker.RegexLib.alphaNumericCharsStr + ']{1,139}', 'g' ),



	/**

	 * The regular expression to use to check the character before a username match to

	 * make sure we didn't accidentally match an email address.

	 *

	 * For example, the string "asdf@asdf.com" should not match "@asdf" as a username.

	 *

	 * @private

	 * @property {RegExp} nonWordCharRegex

	 */

	nonWordCharRegex : new RegExp( '[^' + Autolinker.RegexLib.alphaNumericCharsStr + ']' ),





	/**

	 * @constructor

	 * @param {Object} cfg The configuration properties for the Match instance,

	 *   specified in an Object (map).

	 */

	constructor : function( cfg ) {

		Autolinker.matcher.Matcher.prototype.constructor.call( this, cfg );



		this.serviceName = cfg.serviceName;

	},





	/**

	 * @inheritdoc

	 */

	parseMatches : function( text ) {

		var matcherRegex = this.matcherRegex,

		    nonWordCharRegex = this.nonWordCharRegex,

		    serviceName = this.serviceName,

		    tagBuilder = this.tagBuilder,

		    matches = [],

		    match;



		while( ( match = matcherRegex.exec( text ) ) !== null ) {

			var offset = match.index,

			    prevChar = text.charAt( offset - 1 );



			// If we found the match at the beginning of the string, or we found the match

			// and there is a whitespace char in front of it (meaning it is not a '#' char

			// in the middle of a word), then it is a hashtag match.

			if( offset === 0 || nonWordCharRegex.test( prevChar ) ) {

				var matchedText = match[ 0 ],

				    hashtag = match[ 0 ].slice( 1 );  // strip off the '#' character at the beginning



				matches.push( new Autolinker.match.Hashtag( {

					tagBuilder  : tagBuilder,

					matchedText : matchedText,

					offset      : offset,

					serviceName : serviceName,

					hashtag     : hashtag

				} ) );

			}

		}



		return matches;

	}



} );

/*global Autolinker */

/**

 * @class Autolinker.matcher.Phone

 * @extends Autolinker.matcher.Matcher

 *

 * Matcher to find Phone number matches in an input string.

 *

 * See this class's superclass ({@link Autolinker.matcher.Matcher}) for more

 * details.

 */

Autolinker.matcher.Phone = Autolinker.Util.extend( Autolinker.matcher.Matcher, {



	/**

	 * The regular expression to match Phone numbers. Example match:

	 *

	 *     (123) 456-7890

	 *

	 * This regular expression has the following capturing groups:

	 *

	 * 1 or 2. The prefixed '+' sign, if there is one.

	 *

	 * @private

	 * @property {RegExp} matcherRegex

	 */

	matcherRegex : /(?:(?:(?:(\+)?\d{1,3}[-\040.]?)?\(?\d{3}\)?[-\040.]?\d{3}[-\040.]?\d{4})|(?:(\+)(?:9[976]\d|8[987530]\d|6[987]\d|5[90]\d|42\d|3[875]\d|2[98654321]\d|9[8543210]|8[6421]|6[6543210]|5[87654321]|4[987654310]|3[9643210]|2[70]|7|1)[-\040.]?(?:\d[-\040.]?){6,12}\d+))([,;]+[0-9]+#?)*/g,



	// ex: (123) 456-7890, 123 456 7890, 123-456-7890, +18004441234,,;,10226420346#,

	// +1 (800) 444 1234, 10226420346#, 1-800-444-1234,1022,64,20346#



	/**

	 * @inheritdoc

	 */

	parseMatches: function(text) {

		var matcherRegex = this.matcherRegex,

			tagBuilder = this.tagBuilder,

			matches = [],

			match;



		while ((match = matcherRegex.exec(text)) !== null) {

			// Remove non-numeric values from phone number string

			var matchedText = match[0],

				cleanNumber = matchedText.replace(/[^0-9,;#]/g, ''), // strip out non-digit characters exclude comma semicolon and #

				plusSign = !!(match[1] || match[2]), // match[ 1 ] or match[ 2 ] is the prefixed plus sign, if there is one

				before = match.index == 0 ? '' : text.substr(match.index - 1, 1),

				after = text.substr(match.index + matchedText.length, 1),

				contextClear = !before.match(/\d/) && !after.match(/\d/);



			if (this.testMatch(match[3]) && this.testMatch(matchedText) && contextClear) {

				matches.push(new Autolinker.match.Phone({

					tagBuilder: tagBuilder,

					matchedText: matchedText,

					offset: match.index,

					number: cleanNumber,

					plusSign: plusSign

				}));

			}

		}



		return matches;

	},



	testMatch: function(text) {

		return /\D/.test(text);

	}



} );



/*global Autolinker */

/**

 * @class Autolinker.matcher.Mention

 * @extends Autolinker.matcher.Matcher

 *

 * Matcher to find/replace username matches in an input string.

 */

Autolinker.matcher.Mention = Autolinker.Util.extend( Autolinker.matcher.Matcher, {



	/**

	 * Hash of regular expression to match username handles. Example match:

	 *

	 *     @asdf

	 *

	 * @private

	 * @property {Object} matcherRegexes

	 */

	matcherRegexes : {

		"twitter": new RegExp( '@[_' + Autolinker.RegexLib.alphaNumericCharsStr + ']{1,20}', 'g' ),

		"instagram": new RegExp( '@[_.' + Autolinker.RegexLib.alphaNumericCharsStr + ']{1,50}', 'g' ),

		"soundcloud": new RegExp( '@[_.' + Autolinker.RegexLib.alphaNumericCharsStr + "\-" + ']{1,50}', 'g' )

	},



	/**

	 * The regular expression to use to check the character before a username match to

	 * make sure we didn't accidentally match an email address.

	 *

	 * For example, the string "asdf@asdf.com" should not match "@asdf" as a username.

	 *

	 * @private

	 * @property {RegExp} nonWordCharRegex

	 */

	nonWordCharRegex : new RegExp( '[^' + Autolinker.RegexLib.alphaNumericCharsStr + ']' ),





	/**

	 * @constructor

	 * @param {Object} cfg The configuration properties for the Match instance,

	 *   specified in an Object (map).

	 */

	constructor : function( cfg ) {

		Autolinker.matcher.Matcher.prototype.constructor.call( this, cfg );



		this.serviceName = cfg.serviceName;

	},





	/**

	 * @inheritdoc

	 */

	parseMatches : function( text ) {

		var matcherRegex = this.matcherRegexes[this.serviceName],

		    nonWordCharRegex = this.nonWordCharRegex,

		    serviceName = this.serviceName,

		    tagBuilder = this.tagBuilder,

		    matches = [],

		    match;



		if (!matcherRegex) {

			return matches;

		}



		while( ( match = matcherRegex.exec( text ) ) !== null ) {

			var offset = match.index,

			    prevChar = text.charAt( offset - 1 );



			// If we found the match at the beginning of the string, or we found the match

			// and there is a whitespace char in front of it (meaning it is not an email

			// address), then it is a username match.

			if( offset === 0 || nonWordCharRegex.test( prevChar ) ) {

				var matchedText = match[ 0 ].replace(/\.+$/g, ''), // strip off trailing .

				    mention = matchedText.slice( 1 );  // strip off the '@' character at the beginning



				matches.push( new Autolinker.match.Mention( {

					tagBuilder    : tagBuilder,

					matchedText   : matchedText,

					offset        : offset,

					serviceName   : serviceName,

					mention       : mention

				} ) );

			}

		}



		return matches;

	}



} );



/*global Autolinker */

/**

 * @class Autolinker.matcher.Url

 * @extends Autolinker.matcher.Matcher

 *

 * Matcher to find URL matches in an input string.

 *

 * See this class's superclass ({@link Autolinker.matcher.Matcher}) for more details.

 */

Autolinker.matcher.Url = Autolinker.Util.extend( Autolinker.matcher.Matcher, {



	/**

	 * @cfg {Object} stripPrefix (required)

	 *

	 * The Object form of {@link Autolinker#cfg-stripPrefix}.

	 */



	/**

	 * @cfg {Boolean} stripTrailingSlash (required)

	 * @inheritdoc Autolinker#stripTrailingSlash

	 */



	/**

	 * @cfg {Boolean} decodePercentEncoding (required)

	 * @inheritdoc Autolinker#decodePercentEncoding

	 */





	/**

	 * @private

	 * @property {RegExp} matcherRegex

	 *

	 * The regular expression to match URLs with an optional scheme, port

	 * number, path, query string, and hash anchor.

	 *

	 * Example matches:

	 *

	 *     http://google.com

	 *     www.google.com

	 *     google.com/path/to/file?q1=1&q2=2#myAnchor

	 *

	 *

	 * This regular expression will have the following capturing groups:

	 *

	 * 1.  Group that matches a scheme-prefixed URL (i.e. 'http://google.com').

	 *     This is used to match scheme URLs with just a single word, such as

	 *     'http://localhost', where we won't double check that the domain name

	 *     has at least one dot ('.') in it.

	 * 2.  Group that matches a 'www.' prefixed URL. This is only matched if the

	 *     'www.' text was not prefixed by a scheme (i.e.: not prefixed by

	 *     'http://', 'ftp:', etc.)

	 * 3.  A protocol-relative ('//') match for the case of a 'www.' prefixed

	 *     URL. Will be an empty string if it is not a protocol-relative match.

	 *     We need to know the character before the '//' in order to determine

	 *     if it is a valid match or the // was in a string we don't want to

	 *     auto-link.

	 * 4.  Group that matches a known TLD (top level domain), when a scheme

	 *     or 'www.'-prefixed domain is not matched.

	 * 5.  A protocol-relative ('//') match for the case of a known TLD prefixed

	 *     URL. Will be an empty string if it is not a protocol-relative match.

	 *     See #3 for more info.

	 */

	matcherRegex : (function() {

		var schemeRegex = /(?:[A-Za-z][-.+A-Za-z0-9]{0,63}:(?![A-Za-z][-.+A-Za-z0-9]{0,63}:\/\/)(?!\d+\/?)(?:\/\/)?)/,  // match protocol, allow in format "http://" or "mailto:". However, do not match the first part of something like 'link:http://www.google.com' (i.e. don't match "link:"). Also, make sure we don't interpret 'google.com:8000' as if 'google.com' was a protocol here (i.e. ignore a trailing port number in this regex)

		    wwwRegex = /(?:www\.)/,                  // starting with 'www.'

		    getDomainNameStr = Autolinker.RegexLib.getDomainNameStr,

		    tldRegex = Autolinker.tldRegex,  // match our known top level domains (TLDs)

		    alphaNumericCharsStr = Autolinker.RegexLib.alphaNumericCharsStr,



		    // Allow optional path, query string, and hash anchor, not ending in the following characters: "?!:,.;"

		    // http://blog.codinghorror.com/the-problem-with-urls/

		    urlSuffixRegex = new RegExp( '[/?#](?:[' + alphaNumericCharsStr + '\\-+&@#/%=~_()|\'$*\\[\\]?!:,.;\u2713]*[' + alphaNumericCharsStr + '\\-+&@#/%=~_()|\'$*\\[\\]\u2713])?' );



		return new RegExp( [

			'(?:', // parens to cover match for scheme (optional), and domain

				'(',  // *** Capturing group $1, for a scheme-prefixed url (ex: http://google.com)

					schemeRegex.source,

					getDomainNameStr(2),

				')',



				'|',



				'(',  // *** Capturing group $4 for a 'www.' prefixed url (ex: www.google.com)

					'(//)?',  // *** Capturing group $5 for an optional protocol-relative URL. Must be at the beginning of the string or start with a non-word character (handled later)

					wwwRegex.source,

					getDomainNameStr(6),

				')',



				'|',



				'(',  // *** Capturing group $8, for known a TLD url (ex: google.com)

					'(//)?',  // *** Capturing group $9 for an optional protocol-relative URL. Must be at the beginning of the string or start with a non-word character (handled later)

					getDomainNameStr(10) + '\\.',

					tldRegex.source,

					'(?![-' + alphaNumericCharsStr + '])', // TLD not followed by a letter, behaves like unicode-aware \b

				')',

			')',



			'(?::[0-9]+)?', // port



			'(?:' + urlSuffixRegex.source + ')?'  // match for path, query string, and/or hash anchor - optional

		].join( "" ), 'gi' );

	} )(),





	/**

	 * A regular expression to use to check the character before a protocol-relative

	 * URL match. We don't want to match a protocol-relative URL if it is part

	 * of another word.

	 *

	 * For example, we want to match something like "Go to: //google.com",

	 * but we don't want to match something like "abc//google.com"

	 *

	 * This regular expression is used to test the character before the '//'.

	 *

	 * @private

	 * @type {RegExp} wordCharRegExp

	 */

	wordCharRegExp : new RegExp( '[' + Autolinker.RegexLib.alphaNumericCharsStr + ']' ),





	/**

	 * The regular expression to match opening parenthesis in a URL match.

	 *

	 * This is to determine if we have unbalanced parenthesis in the URL, and to

	 * drop the final parenthesis that was matched if so.

	 *

	 * Ex: The text "(check out: wikipedia.com/something_(disambiguation))"

	 * should only autolink the inner "wikipedia.com/something_(disambiguation)"

	 * part, so if we find that we have unbalanced parenthesis, we will drop the

	 * last one for the match.

	 *

	 * @private

	 * @property {RegExp}

	 */

	openParensRe : /\(/g,



	/**

	 * The regular expression to match closing parenthesis in a URL match. See

	 * {@link #openParensRe} for more information.

	 *

	 * @private

	 * @property {RegExp}

	 */

	closeParensRe : /\)/g,





	/**

	 * @constructor

	 * @param {Object} cfg The configuration properties for the Match instance,

	 *   specified in an Object (map).

	 */

	constructor : function( cfg ) {

		Autolinker.matcher.Matcher.prototype.constructor.call( this, cfg );



		if( cfg.stripPrefix == null ) throw new Error( '`stripPrefix` cfg required' );

		if( cfg.stripTrailingSlash == null ) throw new Error( '`stripTrailingSlash` cfg required' );



		this.stripPrefix = cfg.stripPrefix;

		this.stripTrailingSlash = cfg.stripTrailingSlash;

		this.decodePercentEncoding = cfg.decodePercentEncoding;

	},





	/**

	 * @inheritdoc

	 */

	parseMatches : function( text ) {

		var matcherRegex = this.matcherRegex,

		    stripPrefix = this.stripPrefix,

		    stripTrailingSlash = this.stripTrailingSlash,

		    decodePercentEncoding = this.decodePercentEncoding,

		    tagBuilder = this.tagBuilder,

		    matches = [],

		    match;



		while( ( match = matcherRegex.exec( text ) ) !== null ) {

			var matchStr = match[ 0 ],

			    schemeUrlMatch = match[ 1 ],

			    wwwUrlMatch = match[ 4 ],

			    wwwProtocolRelativeMatch = match[ 5 ],

			    //tldUrlMatch = match[ 8 ],  -- not needed at the moment

			    tldProtocolRelativeMatch = match[ 9 ],

			    offset = match.index,

			    protocolRelativeMatch = wwwProtocolRelativeMatch || tldProtocolRelativeMatch,

				prevChar = text.charAt( offset - 1 );



			if( !Autolinker.matcher.UrlMatchValidator.isValid( matchStr, schemeUrlMatch ) ) {

				continue;

			}



			// If the match is preceded by an '@' character, then it is either

			// an email address or a username. Skip these types of matches.

			if( offset > 0 && prevChar === '@' ) {

				continue;

			}



			// If it's a protocol-relative '//' match, but the character before the '//'

			// was a word character (i.e. a letter/number), then we found the '//' in the

			// middle of another word (such as "asdf//asdf.com"). In this case, skip the

			// match.

			if( offset > 0 && protocolRelativeMatch && this.wordCharRegExp.test( prevChar ) ) {

				continue;

			}



			if( /\?$/.test(matchStr) ) {

				matchStr = matchStr.substr(0, matchStr.length-1);

			}



			// Handle a closing parenthesis at the end of the match, and exclude

			// it if there is not a matching open parenthesis in the match

			// itself.

			if( this.matchHasUnbalancedClosingParen( matchStr ) ) {

				matchStr = matchStr.substr( 0, matchStr.length - 1 );  // remove the trailing ")"

			} else {

				// Handle an invalid character after the TLD

				var pos = this.matchHasInvalidCharAfterTld( matchStr, schemeUrlMatch );

				if( pos > -1 ) {

					matchStr = matchStr.substr( 0, pos ); // remove the trailing invalid chars

				}

			}



			var urlMatchType = schemeUrlMatch ? 'scheme' : ( wwwUrlMatch ? 'www' : 'tld' ),

			    protocolUrlMatch = !!schemeUrlMatch;



			matches.push( new Autolinker.match.Url( {

				tagBuilder            : tagBuilder,

				matchedText           : matchStr,

				offset                : offset,

				urlMatchType          : urlMatchType,

				url                   : matchStr,

				protocolUrlMatch      : protocolUrlMatch,

				protocolRelativeMatch : !!protocolRelativeMatch,

				stripPrefix           : stripPrefix,

				stripTrailingSlash    : stripTrailingSlash,

				decodePercentEncoding : decodePercentEncoding,

			} ) );

		}



		return matches;

	},





	/**

	 * Determines if a match found has an unmatched closing parenthesis. If so,

	 * this parenthesis will be removed from the match itself, and appended

	 * after the generated anchor tag.

	 *

	 * A match may have an extra closing parenthesis at the end of the match

	 * because the regular expression must include parenthesis for URLs such as

	 * "wikipedia.com/something_(disambiguation)", which should be auto-linked.

	 *

	 * However, an extra parenthesis *will* be included when the URL itself is

	 * wrapped in parenthesis, such as in the case of "(wikipedia.com/something_(disambiguation))".

	 * In this case, the last closing parenthesis should *not* be part of the

	 * URL itself, and this method will return `true`.

	 *

	 * @private

	 * @param {String} matchStr The full match string from the {@link #matcherRegex}.

	 * @return {Boolean} `true` if there is an unbalanced closing parenthesis at

	 *   the end of the `matchStr`, `false` otherwise.

	 */

	matchHasUnbalancedClosingParen : function( matchStr ) {

		var lastChar = matchStr.charAt( matchStr.length - 1 );



		if( lastChar === ')' ) {

			var openParensMatch = matchStr.match( this.openParensRe ),

			    closeParensMatch = matchStr.match( this.closeParensRe ),

			    numOpenParens = ( openParensMatch && openParensMatch.length ) || 0,

			    numCloseParens = ( closeParensMatch && closeParensMatch.length ) || 0;



			if( numOpenParens < numCloseParens ) {

				return true;

			}

		}



		return false;

	},





	/**

	 * Determine if there's an invalid character after the TLD in a URL. Valid

	 * characters after TLD are ':/?#'. Exclude scheme matched URLs from this

	 * check.

	 *

	 * @private

	 * @param {String} urlMatch The matched URL, if there was one. Will be an

	 *   empty string if the match is not a URL match.

	 * @param {String} schemeUrlMatch The match URL string for a scheme

	 *   match. Ex: 'http://yahoo.com'. This is used to match something like

	 *   'http://localhost', where we won't double check that the domain name

	 *   has at least one '.' in it.

	 * @return {Number} the position where the invalid character was found. If

	 *   no such character was found, returns -1

	 */

	matchHasInvalidCharAfterTld : function( urlMatch, schemeUrlMatch ) {

		if( !urlMatch ) {

			return -1;

		}



		var offset = 0;

		if ( schemeUrlMatch ) {

			offset = urlMatch.indexOf(':');

			urlMatch = urlMatch.slice(offset);

		}



		var alphaNumeric = Autolinker.RegexLib.alphaNumericCharsStr;



		var re = new RegExp("^((.?\/\/)?[-." + alphaNumeric + "]*[-" + alphaNumeric + "]\\.[-" + alphaNumeric + "]+)");

		var res = re.exec( urlMatch );

		if ( res === null ) {

			return -1;

		}



		offset += res[1].length;

		urlMatch = urlMatch.slice(res[1].length);

		if (/^[^-.A-Za-z0-9:\/?#]/.test(urlMatch)) {

			return offset;

		}



		return -1;

	}



} );



/*global Autolinker */

/*jshint scripturl:true */

/**

 * @private

 * @class Autolinker.matcher.UrlMatchValidator

 * @singleton

 *

 * Used by Autolinker to filter out false URL positives from the

 * {@link Autolinker.matcher.Url UrlMatcher}.

 *

 * Due to the limitations of regular expressions (including the missing feature

 * of look-behinds in JS regular expressions), we cannot always determine the

 * validity of a given match. This class applies a bit of additional logic to

 * filter out any false positives that have been matched by the

 * {@link Autolinker.matcher.Url UrlMatcher}.

 */

Autolinker.matcher.UrlMatchValidator = {



	/**

	 * Regex to test for a full protocol, with the two trailing slashes. Ex: 'http://'

	 *

	 * @private

	 * @property {RegExp} hasFullProtocolRegex

	 */

	hasFullProtocolRegex : /^[A-Za-z][-.+A-Za-z0-9]*:\/\//,



	/**

	 * Regex to find the URI scheme, such as 'mailto:'.

	 *

	 * This is used to filter out 'javascript:' and 'vbscript:' schemes.

	 *

	 * @private

	 * @property {RegExp} uriSchemeRegex

	 */

	uriSchemeRegex : /^[A-Za-z][-.+A-Za-z0-9]*:/,



	/**

	 * Regex to determine if at least one word char exists after the protocol (i.e. after the ':')

	 *

	 * @private

	 * @property {RegExp} hasWordCharAfterProtocolRegex

	 */

	hasWordCharAfterProtocolRegex : new RegExp(":[^\\s]*?[" + Autolinker.RegexLib.alphaCharsStr + "]"),



	/**

	 * Regex to determine if the string is a valid IP address

	 *

	 * @private

	 * @property {RegExp} ipRegex

	 */

	ipRegex: /[0-9][0-9]?[0-9]?\.[0-9][0-9]?[0-9]?\.[0-9][0-9]?[0-9]?\.[0-9][0-9]?[0-9]?(:[0-9]*)?\/?$/,



	/**

	 * Determines if a given URL match found by the {@link Autolinker.matcher.Url UrlMatcher}

	 * is valid. Will return `false` for:

	 *

	 * 1) URL matches which do not have at least have one period ('.') in the

	 *    domain name (effectively skipping over matches like "abc:def").

	 *    However, URL matches with a protocol will be allowed (ex: 'http://localhost')

	 * 2) URL matches which do not have at least one word character in the

	 *    domain name (effectively skipping over matches like "git:1.0").

	 * 3) A protocol-relative url match (a URL beginning with '//') whose

	 *    previous character is a word character (effectively skipping over

	 *    strings like "abc//google.com")

	 *

	 * Otherwise, returns `true`.

	 *

	 * @param {String} urlMatch The matched URL, if there was one. Will be an

	 *   empty string if the match is not a URL match.

	 * @param {String} protocolUrlMatch The match URL string for a protocol

	 *   match. Ex: 'http://yahoo.com'. This is used to match something like

	 *   'http://localhost', where we won't double check that the domain name

	 *   has at least one '.' in it.

	 * @return {Boolean} `true` if the match given is valid and should be

	 *   processed, or `false` if the match is invalid and/or should just not be

	 *   processed.

	 */

	isValid : function( urlMatch, protocolUrlMatch ) {

		if(

			( protocolUrlMatch && !this.isValidUriScheme( protocolUrlMatch ) ) ||

			this.urlMatchDoesNotHaveProtocolOrDot( urlMatch, protocolUrlMatch ) ||    // At least one period ('.') must exist in the URL match for us to consider it an actual URL, *unless* it was a full protocol match (like 'http://localhost')

			(this.urlMatchDoesNotHaveAtLeastOneWordChar( urlMatch, protocolUrlMatch ) && // At least one letter character must exist in the domain name after a protocol match. Ex: skip over something like "git:1.0"

			   !this.isValidIpAddress( urlMatch )) || // Except if it's an IP address

			this.containsMultipleDots( urlMatch )

		) {

			return false;

		}



		return true;

	},





	isValidIpAddress : function ( uriSchemeMatch ) {

		var newRegex = new RegExp(this.hasFullProtocolRegex.source + this.ipRegex.source);

		var uriScheme = uriSchemeMatch.match( newRegex );



		return uriScheme !== null;

	},



	containsMultipleDots : function ( urlMatch ) {

		var stringBeforeSlash = urlMatch;

		if (this.hasFullProtocolRegex.test(urlMatch)) {

			stringBeforeSlash = urlMatch.split('://')[1];

		}

		return stringBeforeSlash.split('/')[0].indexOf("..") > -1;

	},



	/**

	 * Determines if the URI scheme is a valid scheme to be autolinked. Returns

	 * `false` if the scheme is 'javascript:' or 'vbscript:'

	 *

	 * @private

	 * @param {String} uriSchemeMatch The match URL string for a full URI scheme

	 *   match. Ex: 'http://yahoo.com' or 'mailto:a@a.com'.

	 * @return {Boolean} `true` if the scheme is a valid one, `false` otherwise.

	 */

	isValidUriScheme : function( uriSchemeMatch ) {

		var uriScheme = uriSchemeMatch.match( this.uriSchemeRegex )[ 0 ].toLowerCase();



		return ( uriScheme !== 'javascript:' && uriScheme !== 'vbscript:' );

	},





	/**

	 * Determines if a URL match does not have either:

	 *

	 * a) a full protocol (i.e. 'http://'), or

	 * b) at least one dot ('.') in the domain name (for a non-full-protocol

	 *    match).

	 *

	 * Either situation is considered an invalid URL (ex: 'git:d' does not have

	 * either the '://' part, or at least one dot in the domain name. If the

	 * match was 'git:abc.com', we would consider this valid.)

	 *

	 * @private

	 * @param {String} urlMatch The matched URL, if there was one. Will be an

	 *   empty string if the match is not a URL match.

	 * @param {String} protocolUrlMatch The match URL string for a protocol

	 *   match. Ex: 'http://yahoo.com'. This is used to match something like

	 *   'http://localhost', where we won't double check that the domain name

	 *   has at least one '.' in it.

	 * @return {Boolean} `true` if the URL match does not have a full protocol,

	 *   or at least one dot ('.') in a non-full-protocol match.

	 */

	urlMatchDoesNotHaveProtocolOrDot : function( urlMatch, protocolUrlMatch ) {

		return ( !!urlMatch && ( !protocolUrlMatch || !this.hasFullProtocolRegex.test( protocolUrlMatch ) ) && urlMatch.indexOf( '.' ) === -1 );

	},





	/**

	 * Determines if a URL match does not have at least one word character after

	 * the protocol (i.e. in the domain name).

	 *

	 * At least one letter character must exist in the domain name after a

	 * protocol match. Ex: skip over something like "git:1.0"

	 *

	 * @private

	 * @param {String} urlMatch The matched URL, if there was one. Will be an

	 *   empty string if the match is not a URL match.

	 * @param {String} protocolUrlMatch The match URL string for a protocol

	 *   match. Ex: 'http://yahoo.com'. This is used to know whether or not we

	 *   have a protocol in the URL string, in order to check for a word

	 *   character after the protocol separator (':').

	 * @return {Boolean} `true` if the URL match does not have at least one word

	 *   character in it after the protocol, `false` otherwise.

	 */

	urlMatchDoesNotHaveAtLeastOneWordChar : function( urlMatch, protocolUrlMatch ) {

		if( urlMatch && protocolUrlMatch ) {

			return !this.hasWordCharAfterProtocolRegex.test( urlMatch );

		} else {

			return false;

		}

	}



};



/*global Autolinker */

/**

 * A truncation feature where the ellipsis will be placed at the end of the URL.

 *

 * @param {String} anchorText

 * @param {Number} truncateLen The maximum length of the truncated output URL string.

 * @param {String} ellipsisChars The characters to place within the url, e.g. "..".

 * @return {String} The truncated URL.

 */

Autolinker.truncate.TruncateEnd = function(anchorText, truncateLen, ellipsisChars){

	return Autolinker.Util.ellipsis( anchorText, truncateLen, ellipsisChars );

};



/*global Autolinker */

/**

 * Date: 2015-10-05

 * Author: Kasper Søfren <soefritz@gmail.com> (https://github.com/kafoso)

 *

 * A truncation feature, where the ellipsis will be placed in the dead-center of the URL.

 *

 * @param {String} url             A URL.

 * @param {Number} truncateLen     The maximum length of the truncated output URL string.

 * @param {String} ellipsisChars   The characters to place within the url, e.g. "..".

 * @return {String} The truncated URL.

 */

Autolinker.truncate.TruncateMiddle = function(url, truncateLen, ellipsisChars){

  if (url.length <= truncateLen) {

    return url;

  }



  var ellipsisLengthBeforeParsing;

  var ellipsisLength;



  if(ellipsisChars == null) {

    ellipsisChars = '&hellip;';

    ellipsisLengthBeforeParsing = 8;

    ellipsisLength = 3;

  } else {

    ellipsisLengthBeforeParsing = ellipsisChars.length;

    ellipsisLength = ellipsisChars.length;

  }



  var availableLength = truncateLen - ellipsisLength;

  var end = "";

  if (availableLength > 0) {

    end = url.substr((-1)*Math.floor(availableLength/2));

  }

  return (url.substr(0, Math.ceil(availableLength/2)) + ellipsisChars + end).substr(0, availableLength + ellipsisLengthBeforeParsing);

};



/*global Autolinker */

/**

 * Date: 2015-10-05

 * Author: Kasper Søfren <soefritz@gmail.com> (https://github.com/kafoso)

 *

 * A truncation feature, where the ellipsis will be placed at a section within

 * the URL making it still somewhat human readable.

 *

 * @param {String} url						 A URL.

 * @param {Number} truncateLen		 The maximum length of the truncated output URL string.

 * @param {String} ellipsisChars	 The characters to place within the url, e.g. "...".

 * @return {String} The truncated URL.

 */

Autolinker.truncate.TruncateSmart = function(url, truncateLen, ellipsisChars){



	var ellipsisLengthBeforeParsing;

	var ellipsisLength;



	if(ellipsisChars == null) {

		ellipsisChars = '&hellip;';

		ellipsisLength = 3;

		ellipsisLengthBeforeParsing = 8;

	} else {

		ellipsisLength = ellipsisChars.length;

		ellipsisLengthBeforeParsing = ellipsisChars.length;

	}



	var parse_url = function(url){ // Functionality inspired by PHP function of same name

		var urlObj = {};

		var urlSub = url;

		var match = urlSub.match(/^([a-z]+):\/\//i);

		if (match) {

			urlObj.scheme = match[1];

			urlSub = urlSub.substr(match[0].length);

		}

		match = urlSub.match(/^(.*?)(?=(\?|#|\/|$))/i);

		if (match) {

			urlObj.host = match[1];

			urlSub = urlSub.substr(match[0].length);

		}

		match = urlSub.match(/^\/(.*?)(?=(\?|#|$))/i);

		if (match) {

			urlObj.path = match[1];

			urlSub = urlSub.substr(match[0].length);

		}

		match = urlSub.match(/^\?(.*?)(?=(#|$))/i);

		if (match) {

			urlObj.query = match[1];

			urlSub = urlSub.substr(match[0].length);

		}

		match = urlSub.match(/^#(.*?)$/i);

		if (match) {

			urlObj.fragment = match[1];

			//urlSub = urlSub.substr(match[0].length);  -- not used. Uncomment if adding another block.

		}

		return urlObj;

	};



	var buildUrl = function(urlObj){

		var url = "";

		if (urlObj.scheme && urlObj.host) {

			url += urlObj.scheme + "://";

		}

		if (urlObj.host) {

			url += urlObj.host;

		}

		if (urlObj.path) {

			url += "/" + urlObj.path;

		}

		if (urlObj.query) {

			url += "?" + urlObj.query;

		}

		if (urlObj.fragment) {

			url += "#" + urlObj.fragment;

		}

		return url;

	};



	var buildSegment = function(segment, remainingAvailableLength){

		var remainingAvailableLengthHalf = remainingAvailableLength/ 2,

				startOffset = Math.ceil(remainingAvailableLengthHalf),

				endOffset = (-1)*Math.floor(remainingAvailableLengthHalf),

				end = "";

		if (endOffset < 0) {

			end = segment.substr(endOffset);

		}

		return segment.substr(0, startOffset) + ellipsisChars + end;

	};

	if (url.length <= truncateLen) {

		return url;

	}

	var availableLength = truncateLen - ellipsisLength;

	var urlObj = parse_url(url);

	// Clean up the URL

	if (urlObj.query) {

		var matchQuery = urlObj.query.match(/^(.*?)(?=(\?|\#))(.*?)$/i);

		if (matchQuery) {

			// Malformed URL; two or more "?". Removed any content behind the 2nd.

			urlObj.query = urlObj.query.substr(0, matchQuery[1].length);

			url = buildUrl(urlObj);

		}

	}

	if (url.length <= truncateLen) {

		return url;

	}

	if (urlObj.host) {

		urlObj.host = urlObj.host.replace(/^www\./, "");

		url = buildUrl(urlObj);

	}

	if (url.length <= truncateLen) {

		return url;

	}

	// Process and build the URL

	var str = "";

	if (urlObj.host) {

		str += urlObj.host;

	}

	if (str.length >= availableLength) {

		if (urlObj.host.length == truncateLen) {

			return (urlObj.host.substr(0, (truncateLen - ellipsisLength)) + ellipsisChars).substr(0, availableLength + ellipsisLengthBeforeParsing);

		}

		return buildSegment(str, availableLength).substr(0, availableLength + ellipsisLengthBeforeParsing);

	}

	var pathAndQuery = "";

	if (urlObj.path) {

		pathAndQuery += "/" + urlObj.path;

	}

	if (urlObj.query) {

		pathAndQuery += "?" + urlObj.query;

	}

	if (pathAndQuery) {

		if ((str+pathAndQuery).length >= availableLength) {

			if ((str+pathAndQuery).length == truncateLen) {

				return (str + pathAndQuery).substr(0, truncateLen);

			}

			var remainingAvailableLength = availableLength - str.length;

			return (str + buildSegment(pathAndQuery, remainingAvailableLength)).substr(0, availableLength + ellipsisLengthBeforeParsing);

		} else {

			str += pathAndQuery;

		}

	}

	if (urlObj.fragment) {

		var fragment = "#"+urlObj.fragment;

		if ((str+fragment).length >= availableLength) {

			if ((str+fragment).length == truncateLen) {

				return (str + fragment).substr(0, truncateLen);

			}

			var remainingAvailableLength2 = availableLength - str.length;

			return (str + buildSegment(fragment, remainingAvailableLength2)).substr(0, availableLength + ellipsisLengthBeforeParsing);

		} else {

			str += fragment;

		}

	}

	if (urlObj.scheme && urlObj.host) {

		var scheme = urlObj.scheme + "://";

		if ((str+scheme).length < availableLength) {

			return (scheme + str).substr(0, truncateLen);

		}

	}

	if (str.length <= truncateLen) {

		return str;

	}

	var end = "";

	if (availableLength > 0) {

		end = str.substr((-1)*Math.floor(availableLength/2));

	}

	return (str.substr(0, Math.ceil(availableLength/2)) + ellipsisChars + end).substr(0, availableLength + ellipsisLengthBeforeParsing);

};



return Autolinker;

}));





/***/ }),



/***/ "./node_modules/axios/index.js":

/*!*************************************!*\

  !*** ./node_modules/axios/index.js ***!

  \*************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



module.exports = __webpack_require__(/*! ./lib/axios */ "./node_modules/axios/lib/axios.js");



/***/ }),



/***/ "./node_modules/axios/lib/adapters/xhr.js":

/*!************************************************!*\

  !*** ./node_modules/axios/lib/adapters/xhr.js ***!

  \************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

var settle = __webpack_require__(/*! ./../core/settle */ "./node_modules/axios/lib/core/settle.js");

var buildURL = __webpack_require__(/*! ./../helpers/buildURL */ "./node_modules/axios/lib/helpers/buildURL.js");

var buildFullPath = __webpack_require__(/*! ../core/buildFullPath */ "./node_modules/axios/lib/core/buildFullPath.js");

var parseHeaders = __webpack_require__(/*! ./../helpers/parseHeaders */ "./node_modules/axios/lib/helpers/parseHeaders.js");

var isURLSameOrigin = __webpack_require__(/*! ./../helpers/isURLSameOrigin */ "./node_modules/axios/lib/helpers/isURLSameOrigin.js");

var createError = __webpack_require__(/*! ../core/createError */ "./node_modules/axios/lib/core/createError.js");



module.exports = function xhrAdapter(config) {

  return new Promise(function dispatchXhrRequest(resolve, reject) {

    var requestData = config.data;

    var requestHeaders = config.headers;



    if (utils.isFormData(requestData)) {

      delete requestHeaders['Content-Type']; // Let the browser set it

    }



    var request = new XMLHttpRequest();



    // HTTP basic authentication

    if (config.auth) {

      var username = config.auth.username || '';

      var password = config.auth.password || '';

      requestHeaders.Authorization = 'Basic ' + btoa(username + ':' + password);

    }



    var fullPath = buildFullPath(config.baseURL, config.url);

    request.open(config.method.toUpperCase(), buildURL(fullPath, config.params, config.paramsSerializer), true);



    // Set the request timeout in MS

    request.timeout = config.timeout;



    // Listen for ready state

    request.onreadystatechange = function handleLoad() {

      if (!request || request.readyState !== 4) {

        return;

      }



      // The request errored out and we didn't get a response, this will be

      // handled by onerror instead

      // With one exception: request that using file: protocol, most browsers

      // will return status as 0 even though it's a successful request

      if (request.status === 0 && !(request.responseURL && request.responseURL.indexOf('file:') === 0)) {

        return;

      }



      // Prepare the response

      var responseHeaders = 'getAllResponseHeaders' in request ? parseHeaders(request.getAllResponseHeaders()) : null;

      var responseData = !config.responseType || config.responseType === 'text' ? request.responseText : request.response;

      var response = {

        data: responseData,

        status: request.status,

        statusText: request.statusText,

        headers: responseHeaders,

        config: config,

        request: request

      };



      settle(resolve, reject, response);



      // Clean up request

      request = null;

    };



    // Handle browser request cancellation (as opposed to a manual cancellation)

    request.onabort = function handleAbort() {

      if (!request) {

        return;

      }



      reject(createError('Request aborted', config, 'ECONNABORTED', request));



      // Clean up request

      request = null;

    };



    // Handle low level network errors

    request.onerror = function handleError() {

      // Real errors are hidden from us by the browser

      // onerror should only fire if it's a network error

      reject(createError('Network Error', config, null, request));



      // Clean up request

      request = null;

    };



    // Handle timeout

    request.ontimeout = function handleTimeout() {

      var timeoutErrorMessage = 'timeout of ' + config.timeout + 'ms exceeded';

      if (config.timeoutErrorMessage) {

        timeoutErrorMessage = config.timeoutErrorMessage;

      }

      reject(createError(timeoutErrorMessage, config, 'ECONNABORTED',

        request));



      // Clean up request

      request = null;

    };



    // Add xsrf header

    // This is only done if running in a standard browser environment.

    // Specifically not if we're in a web worker, or react-native.

    if (utils.isStandardBrowserEnv()) {

      var cookies = __webpack_require__(/*! ./../helpers/cookies */ "./node_modules/axios/lib/helpers/cookies.js");



      // Add xsrf header

      var xsrfValue = (config.withCredentials || isURLSameOrigin(fullPath)) && config.xsrfCookieName ?

        cookies.read(config.xsrfCookieName) :

        undefined;



      if (xsrfValue) {

        requestHeaders[config.xsrfHeaderName] = xsrfValue;

      }

    }



    // Add headers to the request

    if ('setRequestHeader' in request) {

      utils.forEach(requestHeaders, function setRequestHeader(val, key) {

        if (typeof requestData === 'undefined' && key.toLowerCase() === 'content-type') {

          // Remove Content-Type if data is undefined

          delete requestHeaders[key];

        } else {

          // Otherwise add header to the request

          request.setRequestHeader(key, val);

        }

      });

    }



    // Add withCredentials to request if needed

    if (!utils.isUndefined(config.withCredentials)) {

      request.withCredentials = !!config.withCredentials;

    }



    // Add responseType to request if needed

    if (config.responseType) {

      try {

        request.responseType = config.responseType;

      } catch (e) {

        // Expected DOMException thrown by browsers not compatible XMLHttpRequest Level 2.

        // But, this can be suppressed for 'json' type as it can be parsed by default 'transformResponse' function.

        if (config.responseType !== 'json') {

          throw e;

        }

      }

    }



    // Handle progress if needed

    if (typeof config.onDownloadProgress === 'function') {

      request.addEventListener('progress', config.onDownloadProgress);

    }



    // Not all browsers support upload events

    if (typeof config.onUploadProgress === 'function' && request.upload) {

      request.upload.addEventListener('progress', config.onUploadProgress);

    }



    if (config.cancelToken) {

      // Handle cancellation

      config.cancelToken.promise.then(function onCanceled(cancel) {

        if (!request) {

          return;

        }



        request.abort();

        reject(cancel);

        // Clean up request

        request = null;

      });

    }



    if (requestData === undefined) {

      requestData = null;

    }



    // Send the request

    request.send(requestData);

  });

};





/***/ }),



/***/ "./node_modules/axios/lib/axios.js":

/*!*****************************************!*\

  !*** ./node_modules/axios/lib/axios.js ***!

  \*****************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var utils = __webpack_require__(/*! ./utils */ "./node_modules/axios/lib/utils.js");

var bind = __webpack_require__(/*! ./helpers/bind */ "./node_modules/axios/lib/helpers/bind.js");

var Axios = __webpack_require__(/*! ./core/Axios */ "./node_modules/axios/lib/core/Axios.js");

var mergeConfig = __webpack_require__(/*! ./core/mergeConfig */ "./node_modules/axios/lib/core/mergeConfig.js");

var defaults = __webpack_require__(/*! ./defaults */ "./node_modules/axios/lib/defaults.js");



/**

 * Create an instance of Axios

 *

 * @param {Object} defaultConfig The default config for the instance

 * @return {Axios} A new instance of Axios

 */

function createInstance(defaultConfig) {

  var context = new Axios(defaultConfig);

  var instance = bind(Axios.prototype.request, context);



  // Copy axios.prototype to instance

  utils.extend(instance, Axios.prototype, context);



  // Copy context to instance

  utils.extend(instance, context);



  return instance;

}



// Create the default instance to be exported

var axios = createInstance(defaults);



// Expose Axios class to allow class inheritance

axios.Axios = Axios;



// Factory for creating new instances

axios.create = function create(instanceConfig) {

  return createInstance(mergeConfig(axios.defaults, instanceConfig));

};



// Expose Cancel & CancelToken

axios.Cancel = __webpack_require__(/*! ./cancel/Cancel */ "./node_modules/axios/lib/cancel/Cancel.js");

axios.CancelToken = __webpack_require__(/*! ./cancel/CancelToken */ "./node_modules/axios/lib/cancel/CancelToken.js");

axios.isCancel = __webpack_require__(/*! ./cancel/isCancel */ "./node_modules/axios/lib/cancel/isCancel.js");



// Expose all/spread

axios.all = function all(promises) {

  return Promise.all(promises);

};

axios.spread = __webpack_require__(/*! ./helpers/spread */ "./node_modules/axios/lib/helpers/spread.js");



module.exports = axios;



// Allow use of default import syntax in TypeScript

module.exports.default = axios;





/***/ }),



/***/ "./node_modules/axios/lib/cancel/Cancel.js":

/*!*************************************************!*\

  !*** ./node_modules/axios/lib/cancel/Cancel.js ***!

  \*************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





/**

 * A `Cancel` is an object that is thrown when an operation is canceled.

 *

 * @class

 * @param {string=} message The message.

 */

function Cancel(message) {

  this.message = message;

}



Cancel.prototype.toString = function toString() {

  return 'Cancel' + (this.message ? ': ' + this.message : '');

};



Cancel.prototype.__CANCEL__ = true;



module.exports = Cancel;





/***/ }),



/***/ "./node_modules/axios/lib/cancel/CancelToken.js":

/*!******************************************************!*\

  !*** ./node_modules/axios/lib/cancel/CancelToken.js ***!

  \******************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var Cancel = __webpack_require__(/*! ./Cancel */ "./node_modules/axios/lib/cancel/Cancel.js");



/**

 * A `CancelToken` is an object that can be used to request cancellation of an operation.

 *

 * @class

 * @param {Function} executor The executor function.

 */

function CancelToken(executor) {

  if (typeof executor !== 'function') {

    throw new TypeError('executor must be a function.');

  }



  var resolvePromise;

  this.promise = new Promise(function promiseExecutor(resolve) {

    resolvePromise = resolve;

  });



  var token = this;

  executor(function cancel(message) {

    if (token.reason) {

      // Cancellation has already been requested

      return;

    }



    token.reason = new Cancel(message);

    resolvePromise(token.reason);

  });

}



/**

 * Throws a `Cancel` if cancellation has been requested.

 */

CancelToken.prototype.throwIfRequested = function throwIfRequested() {

  if (this.reason) {

    throw this.reason;

  }

};



/**

 * Returns an object that contains a new `CancelToken` and a function that, when called,

 * cancels the `CancelToken`.

 */

CancelToken.source = function source() {

  var cancel;

  var token = new CancelToken(function executor(c) {

    cancel = c;

  });

  return {

    token: token,

    cancel: cancel

  };

};



module.exports = CancelToken;





/***/ }),



/***/ "./node_modules/axios/lib/cancel/isCancel.js":

/*!***************************************************!*\

  !*** ./node_modules/axios/lib/cancel/isCancel.js ***!

  \***************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





module.exports = function isCancel(value) {

  return !!(value && value.__CANCEL__);

};





/***/ }),



/***/ "./node_modules/axios/lib/core/Axios.js":

/*!**********************************************!*\

  !*** ./node_modules/axios/lib/core/Axios.js ***!

  \**********************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

var buildURL = __webpack_require__(/*! ../helpers/buildURL */ "./node_modules/axios/lib/helpers/buildURL.js");

var InterceptorManager = __webpack_require__(/*! ./InterceptorManager */ "./node_modules/axios/lib/core/InterceptorManager.js");

var dispatchRequest = __webpack_require__(/*! ./dispatchRequest */ "./node_modules/axios/lib/core/dispatchRequest.js");

var mergeConfig = __webpack_require__(/*! ./mergeConfig */ "./node_modules/axios/lib/core/mergeConfig.js");



/**

 * Create a new instance of Axios

 *

 * @param {Object} instanceConfig The default config for the instance

 */

function Axios(instanceConfig) {

  this.defaults = instanceConfig;

  this.interceptors = {

    request: new InterceptorManager(),

    response: new InterceptorManager()

  };

}



/**

 * Dispatch a request

 *

 * @param {Object} config The config specific for this request (merged with this.defaults)

 */

Axios.prototype.request = function request(config) {

  /*eslint no-param-reassign:0*/

  // Allow for axios('example/url'[, config]) a la fetch API

  if (typeof config === 'string') {

    config = arguments[1] || {};

    config.url = arguments[0];

  } else {

    config = config || {};

  }



  config = mergeConfig(this.defaults, config);



  // Set config.method

  if (config.method) {

    config.method = config.method.toLowerCase();

  } else if (this.defaults.method) {

    config.method = this.defaults.method.toLowerCase();

  } else {

    config.method = 'get';

  }



  // Hook up interceptors middleware

  var chain = [dispatchRequest, undefined];

  var promise = Promise.resolve(config);



  this.interceptors.request.forEach(function unshiftRequestInterceptors(interceptor) {

    chain.unshift(interceptor.fulfilled, interceptor.rejected);

  });



  this.interceptors.response.forEach(function pushResponseInterceptors(interceptor) {

    chain.push(interceptor.fulfilled, interceptor.rejected);

  });



  while (chain.length) {

    promise = promise.then(chain.shift(), chain.shift());

  }



  return promise;

};



Axios.prototype.getUri = function getUri(config) {

  config = mergeConfig(this.defaults, config);

  return buildURL(config.url, config.params, config.paramsSerializer).replace(/^\?/, '');

};



// Provide aliases for supported request methods

utils.forEach(['delete', 'get', 'head', 'options'], function forEachMethodNoData(method) {

  /*eslint func-names:0*/

  Axios.prototype[method] = function(url, config) {

    return this.request(utils.merge(config || {}, {

      method: method,

      url: url

    }));

  };

});



utils.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {

  /*eslint func-names:0*/

  Axios.prototype[method] = function(url, data, config) {

    return this.request(utils.merge(config || {}, {

      method: method,

      url: url,

      data: data

    }));

  };

});



module.exports = Axios;





/***/ }),



/***/ "./node_modules/axios/lib/core/InterceptorManager.js":

/*!***********************************************************!*\

  !*** ./node_modules/axios/lib/core/InterceptorManager.js ***!

  \***********************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");



function InterceptorManager() {

  this.handlers = [];

}



/**

 * Add a new interceptor to the stack

 *

 * @param {Function} fulfilled The function to handle `then` for a `Promise`

 * @param {Function} rejected The function to handle `reject` for a `Promise`

 *

 * @return {Number} An ID used to remove interceptor later

 */

InterceptorManager.prototype.use = function use(fulfilled, rejected) {

  this.handlers.push({

    fulfilled: fulfilled,

    rejected: rejected

  });

  return this.handlers.length - 1;

};



/**

 * Remove an interceptor from the stack

 *

 * @param {Number} id The ID that was returned by `use`

 */

InterceptorManager.prototype.eject = function eject(id) {

  if (this.handlers[id]) {

    this.handlers[id] = null;

  }

};



/**

 * Iterate over all the registered interceptors

 *

 * This method is particularly useful for skipping over any

 * interceptors that may have become `null` calling `eject`.

 *

 * @param {Function} fn The function to call for each interceptor

 */

InterceptorManager.prototype.forEach = function forEach(fn) {

  utils.forEach(this.handlers, function forEachHandler(h) {

    if (h !== null) {

      fn(h);

    }

  });

};



module.exports = InterceptorManager;





/***/ }),



/***/ "./node_modules/axios/lib/core/buildFullPath.js":

/*!******************************************************!*\

  !*** ./node_modules/axios/lib/core/buildFullPath.js ***!

  \******************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var isAbsoluteURL = __webpack_require__(/*! ../helpers/isAbsoluteURL */ "./node_modules/axios/lib/helpers/isAbsoluteURL.js");

var combineURLs = __webpack_require__(/*! ../helpers/combineURLs */ "./node_modules/axios/lib/helpers/combineURLs.js");



/**

 * Creates a new URL by combining the baseURL with the requestedURL,

 * only when the requestedURL is not already an absolute URL.

 * If the requestURL is absolute, this function returns the requestedURL untouched.

 *

 * @param {string} baseURL The base URL

 * @param {string} requestedURL Absolute or relative URL to combine

 * @returns {string} The combined full path

 */

module.exports = function buildFullPath(baseURL, requestedURL) {

  if (baseURL && !isAbsoluteURL(requestedURL)) {

    return combineURLs(baseURL, requestedURL);

  }

  return requestedURL;

};





/***/ }),



/***/ "./node_modules/axios/lib/core/createError.js":

/*!****************************************************!*\

  !*** ./node_modules/axios/lib/core/createError.js ***!

  \****************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var enhanceError = __webpack_require__(/*! ./enhanceError */ "./node_modules/axios/lib/core/enhanceError.js");



/**

 * Create an Error with the specified message, config, error code, request and response.

 *

 * @param {string} message The error message.

 * @param {Object} config The config.

 * @param {string} [code] The error code (for example, 'ECONNABORTED').

 * @param {Object} [request] The request.

 * @param {Object} [response] The response.

 * @returns {Error} The created error.

 */

module.exports = function createError(message, config, code, request, response) {

  var error = new Error(message);

  return enhanceError(error, config, code, request, response);

};





/***/ }),



/***/ "./node_modules/axios/lib/core/dispatchRequest.js":

/*!********************************************************!*\

  !*** ./node_modules/axios/lib/core/dispatchRequest.js ***!

  \********************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

var transformData = __webpack_require__(/*! ./transformData */ "./node_modules/axios/lib/core/transformData.js");

var isCancel = __webpack_require__(/*! ../cancel/isCancel */ "./node_modules/axios/lib/cancel/isCancel.js");

var defaults = __webpack_require__(/*! ../defaults */ "./node_modules/axios/lib/defaults.js");



/**

 * Throws a `Cancel` if cancellation has been requested.

 */

function throwIfCancellationRequested(config) {

  if (config.cancelToken) {

    config.cancelToken.throwIfRequested();

  }

}



/**

 * Dispatch a request to the server using the configured adapter.

 *

 * @param {object} config The config that is to be used for the request

 * @returns {Promise} The Promise to be fulfilled

 */

module.exports = function dispatchRequest(config) {

  throwIfCancellationRequested(config);



  // Ensure headers exist

  config.headers = config.headers || {};



  // Transform request data

  config.data = transformData(

    config.data,

    config.headers,

    config.transformRequest

  );



  // Flatten headers

  config.headers = utils.merge(

    config.headers.common || {},

    config.headers[config.method] || {},

    config.headers

  );



  utils.forEach(

    ['delete', 'get', 'head', 'post', 'put', 'patch', 'common'],

    function cleanHeaderConfig(method) {

      delete config.headers[method];

    }

  );



  var adapter = config.adapter || defaults.adapter;



  return adapter(config).then(function onAdapterResolution(response) {

    throwIfCancellationRequested(config);



    // Transform response data

    response.data = transformData(

      response.data,

      response.headers,

      config.transformResponse

    );



    return response;

  }, function onAdapterRejection(reason) {

    if (!isCancel(reason)) {

      throwIfCancellationRequested(config);



      // Transform response data

      if (reason && reason.response) {

        reason.response.data = transformData(

          reason.response.data,

          reason.response.headers,

          config.transformResponse

        );

      }

    }



    return Promise.reject(reason);

  });

};





/***/ }),



/***/ "./node_modules/axios/lib/core/enhanceError.js":

/*!*****************************************************!*\

  !*** ./node_modules/axios/lib/core/enhanceError.js ***!

  \*****************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





/**

 * Update an Error with the specified config, error code, and response.

 *

 * @param {Error} error The error to update.

 * @param {Object} config The config.

 * @param {string} [code] The error code (for example, 'ECONNABORTED').

 * @param {Object} [request] The request.

 * @param {Object} [response] The response.

 * @returns {Error} The error.

 */

module.exports = function enhanceError(error, config, code, request, response) {

  error.config = config;

  if (code) {

    error.code = code;

  }



  error.request = request;

  error.response = response;

  error.isAxiosError = true;



  error.toJSON = function() {

    return {

      // Standard

      message: this.message,

      name: this.name,

      // Microsoft

      description: this.description,

      number: this.number,

      // Mozilla

      fileName: this.fileName,

      lineNumber: this.lineNumber,

      columnNumber: this.columnNumber,

      stack: this.stack,

      // Axios

      config: this.config,

      code: this.code

    };

  };

  return error;

};





/***/ }),



/***/ "./node_modules/axios/lib/core/mergeConfig.js":

/*!****************************************************!*\

  !*** ./node_modules/axios/lib/core/mergeConfig.js ***!

  \****************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var utils = __webpack_require__(/*! ../utils */ "./node_modules/axios/lib/utils.js");



/**

 * Config-specific merge-function which creates a new config-object

 * by merging two configuration objects together.

 *

 * @param {Object} config1

 * @param {Object} config2

 * @returns {Object} New object resulting from merging config2 to config1

 */

module.exports = function mergeConfig(config1, config2) {

  // eslint-disable-next-line no-param-reassign

  config2 = config2 || {};

  var config = {};



  var valueFromConfig2Keys = ['url', 'method', 'params', 'data'];

  var mergeDeepPropertiesKeys = ['headers', 'auth', 'proxy'];

  var defaultToConfig2Keys = [

    'baseURL', 'url', 'transformRequest', 'transformResponse', 'paramsSerializer',

    'timeout', 'withCredentials', 'adapter', 'responseType', 'xsrfCookieName',

    'xsrfHeaderName', 'onUploadProgress', 'onDownloadProgress',

    'maxContentLength', 'validateStatus', 'maxRedirects', 'httpAgent',

    'httpsAgent', 'cancelToken', 'socketPath'

  ];



  utils.forEach(valueFromConfig2Keys, function valueFromConfig2(prop) {

    if (typeof config2[prop] !== 'undefined') {

      config[prop] = config2[prop];

    }

  });



  utils.forEach(mergeDeepPropertiesKeys, function mergeDeepProperties(prop) {

    if (utils.isObject(config2[prop])) {

      config[prop] = utils.deepMerge(config1[prop], config2[prop]);

    } else if (typeof config2[prop] !== 'undefined') {

      config[prop] = config2[prop];

    } else if (utils.isObject(config1[prop])) {

      config[prop] = utils.deepMerge(config1[prop]);

    } else if (typeof config1[prop] !== 'undefined') {

      config[prop] = config1[prop];

    }

  });



  utils.forEach(defaultToConfig2Keys, function defaultToConfig2(prop) {

    if (typeof config2[prop] !== 'undefined') {

      config[prop] = config2[prop];

    } else if (typeof config1[prop] !== 'undefined') {

      config[prop] = config1[prop];

    }

  });



  var axiosKeys = valueFromConfig2Keys

    .concat(mergeDeepPropertiesKeys)

    .concat(defaultToConfig2Keys);



  var otherKeys = Object

    .keys(config2)

    .filter(function filterAxiosKeys(key) {

      return axiosKeys.indexOf(key) === -1;

    });



  utils.forEach(otherKeys, function otherKeysDefaultToConfig2(prop) {

    if (typeof config2[prop] !== 'undefined') {

      config[prop] = config2[prop];

    } else if (typeof config1[prop] !== 'undefined') {

      config[prop] = config1[prop];

    }

  });



  return config;

};





/***/ }),



/***/ "./node_modules/axios/lib/core/settle.js":

/*!***********************************************!*\

  !*** ./node_modules/axios/lib/core/settle.js ***!

  \***********************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var createError = __webpack_require__(/*! ./createError */ "./node_modules/axios/lib/core/createError.js");



/**

 * Resolve or reject a Promise based on response status.

 *

 * @param {Function} resolve A function that resolves the promise.

 * @param {Function} reject A function that rejects the promise.

 * @param {object} response The response.

 */

module.exports = function settle(resolve, reject, response) {

  var validateStatus = response.config.validateStatus;

  if (!validateStatus || validateStatus(response.status)) {

    resolve(response);

  } else {

    reject(createError(

      'Request failed with status code ' + response.status,

      response.config,

      null,

      response.request,

      response

    ));

  }

};





/***/ }),



/***/ "./node_modules/axios/lib/core/transformData.js":

/*!******************************************************!*\

  !*** ./node_modules/axios/lib/core/transformData.js ***!

  \******************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");



/**

 * Transform the data for a request or a response

 *

 * @param {Object|String} data The data to be transformed

 * @param {Array} headers The headers for the request or response

 * @param {Array|Function} fns A single function or Array of functions

 * @returns {*} The resulting transformed data

 */

module.exports = function transformData(data, headers, fns) {

  /*eslint no-param-reassign:0*/

  utils.forEach(fns, function transform(fn) {

    data = fn(data, headers);

  });



  return data;

};





/***/ }),



/***/ "./node_modules/axios/lib/defaults.js":

/*!********************************************!*\

  !*** ./node_modules/axios/lib/defaults.js ***!

  \********************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";

/* WEBPACK VAR INJECTION */(function(process) {



var utils = __webpack_require__(/*! ./utils */ "./node_modules/axios/lib/utils.js");

var normalizeHeaderName = __webpack_require__(/*! ./helpers/normalizeHeaderName */ "./node_modules/axios/lib/helpers/normalizeHeaderName.js");



var DEFAULT_CONTENT_TYPE = {

  'Content-Type': 'application/x-www-form-urlencoded'

};



function setContentTypeIfUnset(headers, value) {

  if (!utils.isUndefined(headers) && utils.isUndefined(headers['Content-Type'])) {

    headers['Content-Type'] = value;

  }

}



function getDefaultAdapter() {

  var adapter;

  if (typeof XMLHttpRequest !== 'undefined') {

    // For browsers use XHR adapter

    adapter = __webpack_require__(/*! ./adapters/xhr */ "./node_modules/axios/lib/adapters/xhr.js");

  } else if (typeof process !== 'undefined' && Object.prototype.toString.call(process) === '[object process]') {

    // For node use HTTP adapter

    adapter = __webpack_require__(/*! ./adapters/http */ "./node_modules/axios/lib/adapters/xhr.js");

  }

  return adapter;

}



var defaults = {

  adapter: getDefaultAdapter(),



  transformRequest: [function transformRequest(data, headers) {

    normalizeHeaderName(headers, 'Accept');

    normalizeHeaderName(headers, 'Content-Type');

    if (utils.isFormData(data) ||

      utils.isArrayBuffer(data) ||

      utils.isBuffer(data) ||

      utils.isStream(data) ||

      utils.isFile(data) ||

      utils.isBlob(data)

    ) {

      return data;

    }

    if (utils.isArrayBufferView(data)) {

      return data.buffer;

    }

    if (utils.isURLSearchParams(data)) {

      setContentTypeIfUnset(headers, 'application/x-www-form-urlencoded;charset=utf-8');

      return data.toString();

    }

    if (utils.isObject(data)) {

      setContentTypeIfUnset(headers, 'application/json;charset=utf-8');

      return JSON.stringify(data);

    }

    return data;

  }],



  transformResponse: [function transformResponse(data) {

    /*eslint no-param-reassign:0*/

    if (typeof data === 'string') {

      try {

        data = JSON.parse(data);

      } catch (e) { /* Ignore */ }

    }

    return data;

  }],



  /**

   * A timeout in milliseconds to abort a request. If set to 0 (default) a

   * timeout is not created.

   */

  timeout: 0,



  xsrfCookieName: 'XSRF-TOKEN',

  xsrfHeaderName: 'X-XSRF-TOKEN',



  maxContentLength: -1,



  validateStatus: function validateStatus(status) {

    return status >= 200 && status < 300;

  }

};



defaults.headers = {

  common: {

    'Accept': 'application/json, text/plain, */*'

  }

};



utils.forEach(['delete', 'get', 'head'], function forEachMethodNoData(method) {

  defaults.headers[method] = {};

});



utils.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {

  defaults.headers[method] = utils.merge(DEFAULT_CONTENT_TYPE);

});



module.exports = defaults;



/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../process/browser.js */ "./node_modules/process/browser.js")))



/***/ }),



/***/ "./node_modules/axios/lib/helpers/bind.js":

/*!************************************************!*\

  !*** ./node_modules/axios/lib/helpers/bind.js ***!

  \************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





module.exports = function bind(fn, thisArg) {

  return function wrap() {

    var args = new Array(arguments.length);

    for (var i = 0; i < args.length; i++) {

      args[i] = arguments[i];

    }

    return fn.apply(thisArg, args);

  };

};





/***/ }),



/***/ "./node_modules/axios/lib/helpers/buildURL.js":

/*!****************************************************!*\

  !*** ./node_modules/axios/lib/helpers/buildURL.js ***!

  \****************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");



function encode(val) {

  return encodeURIComponent(val).

    replace(/%40/gi, '@').

    replace(/%3A/gi, ':').

    replace(/%24/g, '$').

    replace(/%2C/gi, ',').

    replace(/%20/g, '+').

    replace(/%5B/gi, '[').

    replace(/%5D/gi, ']');

}



/**

 * Build a URL by appending params to the end

 *

 * @param {string} url The base of the url (e.g., http://www.google.com)

 * @param {object} [params] The params to be appended

 * @returns {string} The formatted url

 */

module.exports = function buildURL(url, params, paramsSerializer) {

  /*eslint no-param-reassign:0*/

  if (!params) {

    return url;

  }



  var serializedParams;

  if (paramsSerializer) {

    serializedParams = paramsSerializer(params);

  } else if (utils.isURLSearchParams(params)) {

    serializedParams = params.toString();

  } else {

    var parts = [];



    utils.forEach(params, function serialize(val, key) {

      if (val === null || typeof val === 'undefined') {

        return;

      }



      if (utils.isArray(val)) {

        key = key + '[]';

      } else {

        val = [val];

      }



      utils.forEach(val, function parseValue(v) {

        if (utils.isDate(v)) {

          v = v.toISOString();

        } else if (utils.isObject(v)) {

          v = JSON.stringify(v);

        }

        parts.push(encode(key) + '=' + encode(v));

      });

    });



    serializedParams = parts.join('&');

  }



  if (serializedParams) {

    var hashmarkIndex = url.indexOf('#');

    if (hashmarkIndex !== -1) {

      url = url.slice(0, hashmarkIndex);

    }



    url += (url.indexOf('?') === -1 ? '?' : '&') + serializedParams;

  }



  return url;

};





/***/ }),



/***/ "./node_modules/axios/lib/helpers/combineURLs.js":

/*!*******************************************************!*\

  !*** ./node_modules/axios/lib/helpers/combineURLs.js ***!

  \*******************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





/**

 * Creates a new URL by combining the specified URLs

 *

 * @param {string} baseURL The base URL

 * @param {string} relativeURL The relative URL

 * @returns {string} The combined URL

 */

module.exports = function combineURLs(baseURL, relativeURL) {

  return relativeURL

    ? baseURL.replace(/\/+$/, '') + '/' + relativeURL.replace(/^\/+/, '')

    : baseURL;

};





/***/ }),



/***/ "./node_modules/axios/lib/helpers/cookies.js":

/*!***************************************************!*\

  !*** ./node_modules/axios/lib/helpers/cookies.js ***!

  \***************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");



module.exports = (

  utils.isStandardBrowserEnv() ?



  // Standard browser envs support document.cookie

    (function standardBrowserEnv() {

      return {

        write: function write(name, value, expires, path, domain, secure) {

          var cookie = [];

          cookie.push(name + '=' + encodeURIComponent(value));



          if (utils.isNumber(expires)) {

            cookie.push('expires=' + new Date(expires).toGMTString());

          }



          if (utils.isString(path)) {

            cookie.push('path=' + path);

          }



          if (utils.isString(domain)) {

            cookie.push('domain=' + domain);

          }



          if (secure === true) {

            cookie.push('secure');

          }



          document.cookie = cookie.join('; ');

        },



        read: function read(name) {

          var match = document.cookie.match(new RegExp('(^|;\\s*)(' + name + ')=([^;]*)'));

          return (match ? decodeURIComponent(match[3]) : null);

        },



        remove: function remove(name) {

          this.write(name, '', Date.now() - 86400000);

        }

      };

    })() :



  // Non standard browser env (web workers, react-native) lack needed support.

    (function nonStandardBrowserEnv() {

      return {

        write: function write() {},

        read: function read() { return null; },

        remove: function remove() {}

      };

    })()

);





/***/ }),



/***/ "./node_modules/axios/lib/helpers/isAbsoluteURL.js":

/*!*********************************************************!*\

  !*** ./node_modules/axios/lib/helpers/isAbsoluteURL.js ***!

  \*********************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





/**

 * Determines whether the specified URL is absolute

 *

 * @param {string} url The URL to test

 * @returns {boolean} True if the specified URL is absolute, otherwise false

 */

module.exports = function isAbsoluteURL(url) {

  // A URL is considered absolute if it begins with "<scheme>://" or "//" (protocol-relative URL).

  // RFC 3986 defines scheme name as a sequence of characters beginning with a letter and followed

  // by any combination of letters, digits, plus, period, or hyphen.

  return /^([a-z][a-z\d\+\-\.]*:)?\/\//i.test(url);

};





/***/ }),



/***/ "./node_modules/axios/lib/helpers/isURLSameOrigin.js":

/*!***********************************************************!*\

  !*** ./node_modules/axios/lib/helpers/isURLSameOrigin.js ***!

  \***********************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");



module.exports = (

  utils.isStandardBrowserEnv() ?



  // Standard browser envs have full support of the APIs needed to test

  // whether the request URL is of the same origin as current location.

    (function standardBrowserEnv() {

      var msie = /(msie|trident)/i.test(navigator.userAgent);

      var urlParsingNode = document.createElement('a');

      var originURL;



      /**

    * Parse a URL to discover it's components

    *

    * @param {String} url The URL to be parsed

    * @returns {Object}

    */

      function resolveURL(url) {

        var href = url;



        if (msie) {

        // IE needs attribute set twice to normalize properties

          urlParsingNode.setAttribute('href', href);

          href = urlParsingNode.href;

        }



        urlParsingNode.setAttribute('href', href);



        // urlParsingNode provides the UrlUtils interface - http://url.spec.whatwg.org/#urlutils

        return {

          href: urlParsingNode.href,

          protocol: urlParsingNode.protocol ? urlParsingNode.protocol.replace(/:$/, '') : '',

          host: urlParsingNode.host,

          search: urlParsingNode.search ? urlParsingNode.search.replace(/^\?/, '') : '',

          hash: urlParsingNode.hash ? urlParsingNode.hash.replace(/^#/, '') : '',

          hostname: urlParsingNode.hostname,

          port: urlParsingNode.port,

          pathname: (urlParsingNode.pathname.charAt(0) === '/') ?

            urlParsingNode.pathname :

            '/' + urlParsingNode.pathname

        };

      }



      originURL = resolveURL(window.location.href);



      /**

    * Determine if a URL shares the same origin as the current location

    *

    * @param {String} requestURL The URL to test

    * @returns {boolean} True if URL shares the same origin, otherwise false

    */

      return function isURLSameOrigin(requestURL) {

        var parsed = (utils.isString(requestURL)) ? resolveURL(requestURL) : requestURL;

        return (parsed.protocol === originURL.protocol &&

            parsed.host === originURL.host);

      };

    })() :



  // Non standard browser envs (web workers, react-native) lack needed support.

    (function nonStandardBrowserEnv() {

      return function isURLSameOrigin() {

        return true;

      };

    })()

);





/***/ }),



/***/ "./node_modules/axios/lib/helpers/normalizeHeaderName.js":

/*!***************************************************************!*\

  !*** ./node_modules/axios/lib/helpers/normalizeHeaderName.js ***!

  \***************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var utils = __webpack_require__(/*! ../utils */ "./node_modules/axios/lib/utils.js");



module.exports = function normalizeHeaderName(headers, normalizedName) {

  utils.forEach(headers, function processHeader(value, name) {

    if (name !== normalizedName && name.toUpperCase() === normalizedName.toUpperCase()) {

      headers[normalizedName] = value;

      delete headers[name];

    }

  });

};





/***/ }),



/***/ "./node_modules/axios/lib/helpers/parseHeaders.js":

/*!********************************************************!*\

  !*** ./node_modules/axios/lib/helpers/parseHeaders.js ***!

  \********************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");



// Headers whose duplicates are ignored by node

// c.f. https://nodejs.org/api/http.html#http_message_headers

var ignoreDuplicateOf = [

  'age', 'authorization', 'content-length', 'content-type', 'etag',

  'expires', 'from', 'host', 'if-modified-since', 'if-unmodified-since',

  'last-modified', 'location', 'max-forwards', 'proxy-authorization',

  'referer', 'retry-after', 'user-agent'

];



/**

 * Parse headers into an object

 *

 * ```

 * Date: Wed, 27 Aug 2014 08:58:49 GMT

 * Content-Type: application/json

 * Connection: keep-alive

 * Transfer-Encoding: chunked

 * ```

 *

 * @param {String} headers Headers needing to be parsed

 * @returns {Object} Headers parsed into an object

 */

module.exports = function parseHeaders(headers) {

  var parsed = {};

  var key;

  var val;

  var i;



  if (!headers) { return parsed; }



  utils.forEach(headers.split('\n'), function parser(line) {

    i = line.indexOf(':');

    key = utils.trim(line.substr(0, i)).toLowerCase();

    val = utils.trim(line.substr(i + 1));



    if (key) {

      if (parsed[key] && ignoreDuplicateOf.indexOf(key) >= 0) {

        return;

      }

      if (key === 'set-cookie') {

        parsed[key] = (parsed[key] ? parsed[key] : []).concat([val]);

      } else {

        parsed[key] = parsed[key] ? parsed[key] + ', ' + val : val;

      }

    }

  });



  return parsed;

};





/***/ }),



/***/ "./node_modules/axios/lib/helpers/spread.js":

/*!**************************************************!*\

  !*** ./node_modules/axios/lib/helpers/spread.js ***!

  \**************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





/**

 * Syntactic sugar for invoking a function and expanding an array for arguments.

 *

 * Common use case would be to use `Function.prototype.apply`.

 *

 *  ```js

 *  function f(x, y, z) {}

 *  var args = [1, 2, 3];

 *  f.apply(null, args);

 *  ```

 *

 * With `spread` this example can be re-written.

 *

 *  ```js

 *  spread(function(x, y, z) {})([1, 2, 3]);

 *  ```

 *

 * @param {Function} callback

 * @returns {Function}

 */

module.exports = function spread(callback) {

  return function wrap(arr) {

    return callback.apply(null, arr);

  };

};





/***/ }),



/***/ "./node_modules/axios/lib/utils.js":

/*!*****************************************!*\

  !*** ./node_modules/axios/lib/utils.js ***!

  \*****************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





var bind = __webpack_require__(/*! ./helpers/bind */ "./node_modules/axios/lib/helpers/bind.js");



/*global toString:true*/



// utils is a library of generic helper functions non-specific to axios



var toString = Object.prototype.toString;



/**

 * Determine if a value is an Array

 *

 * @param {Object} val The value to test

 * @returns {boolean} True if value is an Array, otherwise false

 */

function isArray(val) {

  return toString.call(val) === '[object Array]';

}



/**

 * Determine if a value is undefined

 *

 * @param {Object} val The value to test

 * @returns {boolean} True if the value is undefined, otherwise false

 */

function isUndefined(val) {

  return typeof val === 'undefined';

}



/**

 * Determine if a value is a Buffer

 *

 * @param {Object} val The value to test

 * @returns {boolean} True if value is a Buffer, otherwise false

 */

function isBuffer(val) {

  return val !== null && !isUndefined(val) && val.constructor !== null && !isUndefined(val.constructor)

    && typeof val.constructor.isBuffer === 'function' && val.constructor.isBuffer(val);

}



/**

 * Determine if a value is an ArrayBuffer

 *

 * @param {Object} val The value to test

 * @returns {boolean} True if value is an ArrayBuffer, otherwise false

 */

function isArrayBuffer(val) {

  return toString.call(val) === '[object ArrayBuffer]';

}



/**

 * Determine if a value is a FormData

 *

 * @param {Object} val The value to test

 * @returns {boolean} True if value is an FormData, otherwise false

 */

function isFormData(val) {

  return (typeof FormData !== 'undefined') && (val instanceof FormData);

}



/**

 * Determine if a value is a view on an ArrayBuffer

 *

 * @param {Object} val The value to test

 * @returns {boolean} True if value is a view on an ArrayBuffer, otherwise false

 */

function isArrayBufferView(val) {

  var result;

  if ((typeof ArrayBuffer !== 'undefined') && (ArrayBuffer.isView)) {

    result = ArrayBuffer.isView(val);

  } else {

    result = (val) && (val.buffer) && (val.buffer instanceof ArrayBuffer);

  }

  return result;

}



/**

 * Determine if a value is a String

 *

 * @param {Object} val The value to test

 * @returns {boolean} True if value is a String, otherwise false

 */

function isString(val) {

  return typeof val === 'string';

}



/**

 * Determine if a value is a Number

 *

 * @param {Object} val The value to test

 * @returns {boolean} True if value is a Number, otherwise false

 */

function isNumber(val) {

  return typeof val === 'number';

}



/**

 * Determine if a value is an Object

 *

 * @param {Object} val The value to test

 * @returns {boolean} True if value is an Object, otherwise false

 */

function isObject(val) {

  return val !== null && typeof val === 'object';

}



/**

 * Determine if a value is a Date

 *

 * @param {Object} val The value to test

 * @returns {boolean} True if value is a Date, otherwise false

 */

function isDate(val) {

  return toString.call(val) === '[object Date]';

}



/**

 * Determine if a value is a File

 *

 * @param {Object} val The value to test

 * @returns {boolean} True if value is a File, otherwise false

 */

function isFile(val) {

  return toString.call(val) === '[object File]';

}



/**

 * Determine if a value is a Blob

 *

 * @param {Object} val The value to test

 * @returns {boolean} True if value is a Blob, otherwise false

 */

function isBlob(val) {

  return toString.call(val) === '[object Blob]';

}



/**

 * Determine if a value is a Function

 *

 * @param {Object} val The value to test

 * @returns {boolean} True if value is a Function, otherwise false

 */

function isFunction(val) {

  return toString.call(val) === '[object Function]';

}



/**

 * Determine if a value is a Stream

 *

 * @param {Object} val The value to test

 * @returns {boolean} True if value is a Stream, otherwise false

 */

function isStream(val) {

  return isObject(val) && isFunction(val.pipe);

}



/**

 * Determine if a value is a URLSearchParams object

 *

 * @param {Object} val The value to test

 * @returns {boolean} True if value is a URLSearchParams object, otherwise false

 */

function isURLSearchParams(val) {

  return typeof URLSearchParams !== 'undefined' && val instanceof URLSearchParams;

}



/**

 * Trim excess whitespace off the beginning and end of a string

 *

 * @param {String} str The String to trim

 * @returns {String} The String freed of excess whitespace

 */

function trim(str) {

  return str.replace(/^\s*/, '').replace(/\s*$/, '');

}



/**

 * Determine if we're running in a standard browser environment

 *

 * This allows axios to run in a web worker, and react-native.

 * Both environments support XMLHttpRequest, but not fully standard globals.

 *

 * web workers:

 *  typeof window -> undefined

 *  typeof document -> undefined

 *

 * react-native:

 *  navigator.product -> 'ReactNative'

 * nativescript

 *  navigator.product -> 'NativeScript' or 'NS'

 */

function isStandardBrowserEnv() {

  if (typeof navigator !== 'undefined' && (navigator.product === 'ReactNative' ||

                                           navigator.product === 'NativeScript' ||

                                           navigator.product === 'NS')) {

    return false;

  }

  return (

    typeof window !== 'undefined' &&

    typeof document !== 'undefined'

  );

}



/**

 * Iterate over an Array or an Object invoking a function for each item.

 *

 * If `obj` is an Array callback will be called passing

 * the value, index, and complete array for each item.

 *

 * If 'obj' is an Object callback will be called passing

 * the value, key, and complete object for each property.

 *

 * @param {Object|Array} obj The object to iterate

 * @param {Function} fn The callback to invoke for each item

 */

function forEach(obj, fn) {

  // Don't bother if no value provided

  if (obj === null || typeof obj === 'undefined') {

    return;

  }



  // Force an array if not already something iterable

  if (typeof obj !== 'object') {

    /*eslint no-param-reassign:0*/

    obj = [obj];

  }



  if (isArray(obj)) {

    // Iterate over array values

    for (var i = 0, l = obj.length; i < l; i++) {

      fn.call(null, obj[i], i, obj);

    }

  } else {

    // Iterate over object keys

    for (var key in obj) {

      if (Object.prototype.hasOwnProperty.call(obj, key)) {

        fn.call(null, obj[key], key, obj);

      }

    }

  }

}



/**

 * Accepts varargs expecting each argument to be an object, then

 * immutably merges the properties of each object and returns result.

 *

 * When multiple objects contain the same key the later object in

 * the arguments list will take precedence.

 *

 * Example:

 *

 * ```js

 * var result = merge({foo: 123}, {foo: 456});

 * console.log(result.foo); // outputs 456

 * ```

 *

 * @param {Object} obj1 Object to merge

 * @returns {Object} Result of all merge properties

 */

function merge(/* obj1, obj2, obj3, ... */) {

  var result = {};

  function assignValue(val, key) {

    if (typeof result[key] === 'object' && typeof val === 'object') {

      result[key] = merge(result[key], val);

    } else {

      result[key] = val;

    }

  }



  for (var i = 0, l = arguments.length; i < l; i++) {

    forEach(arguments[i], assignValue);

  }

  return result;

}



/**

 * Function equal to merge with the difference being that no reference

 * to original objects is kept.

 *

 * @see merge

 * @param {Object} obj1 Object to merge

 * @returns {Object} Result of all merge properties

 */

function deepMerge(/* obj1, obj2, obj3, ... */) {

  var result = {};

  function assignValue(val, key) {

    if (typeof result[key] === 'object' && typeof val === 'object') {

      result[key] = deepMerge(result[key], val);

    } else if (typeof val === 'object') {

      result[key] = deepMerge({}, val);

    } else {

      result[key] = val;

    }

  }



  for (var i = 0, l = arguments.length; i < l; i++) {

    forEach(arguments[i], assignValue);

  }

  return result;

}



/**

 * Extends object a by mutably adding to it the properties of object b.

 *

 * @param {Object} a The object to be extended

 * @param {Object} b The object to copy properties from

 * @param {Object} thisArg The object to bind function to

 * @return {Object} The resulting value of object a

 */

function extend(a, b, thisArg) {

  forEach(b, function assignValue(val, key) {

    if (thisArg && typeof val === 'function') {

      a[key] = bind(val, thisArg);

    } else {

      a[key] = val;

    }

  });

  return a;

}



module.exports = {

  isArray: isArray,

  isArrayBuffer: isArrayBuffer,

  isBuffer: isBuffer,

  isFormData: isFormData,

  isArrayBufferView: isArrayBufferView,

  isString: isString,

  isNumber: isNumber,

  isObject: isObject,

  isUndefined: isUndefined,

  isDate: isDate,

  isFile: isFile,

  isBlob: isBlob,

  isFunction: isFunction,

  isStream: isStream,

  isURLSearchParams: isURLSearchParams,

  isStandardBrowserEnv: isStandardBrowserEnv,

  forEach: forEach,

  merge: merge,

  deepMerge: deepMerge,

  extend: extend,

  trim: trim

};





/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/BeautyChatarea.vue?vue&type=script&lang=js&":

/*!*************************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/BeautyChatarea.vue?vue&type=script&lang=js& ***!

  \*************************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

/* harmony import */ var _Chatarea__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Chatarea */ "./resources/js/components/Chatarea.vue");

/* harmony import */ var _colors__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./colors */ "./resources/js/components/colors.js");

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }



function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }



function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }



function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }



function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }



function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }



function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }



//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//







var moment = __webpack_require__(/*! moment */ "./node_modules/moment/moment.js");



/* harmony default export */ __webpack_exports__["default"] = ({

  props: {

    title: {

      type: String,

      "default": function _default() {

        return '';

      }

    },

    discuss: {

      type: String,

      "default": function _default() {

        return '';

      }

    },

    chatfrom: {

      type: String,

      "default": function _default() {

        return '';

      }

    }

  },

  name: 'app',

  components: {

    Chatarea: _Chatarea__WEBPACK_IMPORTED_MODULE_0__["default"]

  },

  data: function data() {

    return {

      timestamp: "",

      chatusrwindow: 0,

      participants: [],

      titleImageUrl: '../public/images/chat/chat_logo.png',

      messageList: [],

      newMessagesCount: 0,

      isChatOpen: false,

      showTypingIndicator: '',

      colors: null,

      availableColors: _colors__WEBPACK_IMPORTED_MODULE_1__["default"],

      chosenColor: null,

      alwaysScrollToBottom: true,

      messageStyling: true,

      userIsTyping: false

    };

  },

  created: function created() {

    this.setColor('orange');

  },

  methods: {

    getchattuuserchanged: function getchattuuserchanged(chattuchangeid) {

      this.chatusrwindow = chattuchangeid;

      this.getInitialData(this.chatusrwindow);

    },

    getNow: function getNow() {

      var today = new Date();

      var date = today.getFullYear() + '-' + (today.getMonth() + 1) + '-' + today.getDate();

      var time = today.getHours() + ":" + today.getMinutes() + ":" + today.getSeconds();

      var dateTime = date + ' ' + time;

      this.timestamp = dateTime;

    },

    sendMessage: function sendMessage(text) {

      if (text.length > 0) {

        this.newMessagesCount = this.isChatOpen ? this.newMessagesCount : this.newMessagesCount + 1;

        this.onMessageWasSent({

          id: Math.random(),

          type: 'text',

          author: 'me',

          data: {

            text: text

          },

          time: moment("YYYY/M/D h:mm"),

          fromusr: this.chatfrom,

          tousr: 0,

          togroup: 1

        });

      }

    },

    handleTyping: function handleTyping(text) {

      this.showTypingIndicator = text.length > 0 ? this.participants[this.participants.length - 1].id : '';

    },

    buildFormData: function buildFormData(formData, data, parentKey) {

      var _this = this;



      if (data && _typeof(data) === 'object' && !(data instanceof Date) && !(data instanceof File)) {

        Object.keys(data).forEach(function (key) {

          _this.buildFormData(formData, data[key], parentKey ? "".concat(parentKey, "[").concat(key, "]") : key);

        });

      } else {

        var value = data == null ? '' : data;

        formData.append(parentKey, value);

      }

    },

    onMessageWasSent: function onMessageWasSent(message) {

      var _this2 = this;



      this.getNow();

      message.id = Math.random();

      message.time = this.timestamp;

      message.meet_id = this.discuss;

      message.fromusr = this.chatfrom;

      var prevmessagelist = this.messageList;

      this.messageList = [].concat(_toConsumableArray(this.messageList), [message]);

      var formData = new FormData();



      if (message.data.file && message.data.file.name) {

        formData.append('fileup', message.data.file, message.data.file.name);

      }



      this.buildFormData(formData, message);

      axios.post('../sendvchat', formData).then(function (response) {

        if (response.data.code == 1) {

          _this2.messageList = [].concat(_toConsumableArray(prevmessagelist), [response.data.message]);

        } else {

          console.log('err');

          _this2.messageList = prevmessagelist;

        }

      })["catch"](function (error) {

        console.log(error);

      });

    },

    openChat: function openChat() {

      this.isChatOpen = true;

      this.newMessagesCount = 0;

    },

    closeChat: function closeChat() {

      this.isChatOpen = false;

    },

    setColor: function setColor(color) {

      this.colors = this.availableColors[color];

      this.chosenColor = color;

    },

    showStylingInfo: function showStylingInfo() {

      this.$modal.show('dialog', {

        title: 'Info',

        text: 'You can use *word* to <strong>boldify</strong>, /word/ to <em>emphasize</em>, _word_ to <u>underline</u>, `code` to <code>write = code;</code>, ~this~ to <del>delete</del> and ^sup^ or ¡sub¡ to write <sup>sup</sup> and <sub>sub</sub>'

      });

    },

    messageStylingToggled: function messageStylingToggled(e) {

      this.messageStyling = e.target.checked;

    },

    handleOnType: function handleOnType() {

      this.$root.$emit('onType');

      this.userIsTyping = true;

    },

    editMessage: function editMessage(message) {

      var m = this.messageList.find(function (m) {

        return m.id === message.id;

      });

      m.isEdited = true;

      m.data.text = message.data.text;

    },

    removeMessage: function removeMessage(message) {

      if (confirm('Delete?')) {

        var m = this.messageList.find(function (m) {

          return m.id === message.id;

        });

        m.type = 'system';

        m.data.text = 'This message has been removed';

      }

    },

    like: function like(id) {

      var m = this.messageList.findIndex(function (m) {

        return m.id === id;

      });

      var msg = this.messageList[m];

      msg.liked = !msg.liked;

      this.$set(this.messageList, m, msg);

    },

    getInitialData: function getInitialData(reqchatid) {

      var _this3 = this;



      var reqdata = {

        req: reqchatid

      };

      axios.post("../getchatdetail/".concat(this.discuss), reqdata).then(function (res) {

        if (res.status == 200) {

          //this.participants = res.data.users;

          _this3.messageList = res.data.messages;

        }

      })["catch"](function (err) {

        console.log('usetgeterror:' + err);

      });

    }

  },

  computed: {

    chatTitle: function chatTitle() {

      if (this.title !== '') {

        return this.title;

      }

    },

    linkColor: function linkColor() {

      return this.chosenColor === 'dark' ? this.colors.sentMessage.text : this.colors.launcher.bg;

    },

    backgroundColor: function backgroundColor() {

      return this.chosenColor === 'dark' ? this.colors.messageList.bg : '#fff';

    }

  },

  mounted: function mounted() {

    var _this4 = this;



    this.getInitialData(0);

    Echo.channel("discusmeetchat.".concat(this.discuss)).listen('DiscussChatEvent', function (e) {

      if (_this4.chatfrom == e.alldata.tousr || e.alldata.tousr == 0) {

        _this4.messageList.push(e.alldata);



        _this4.newMessagesCount = 0;

      } else {//this.newMessagesCount = this.newMessagesCount + 1

      }



      _this4.isChatOpen = true;

    });

    Echo.join("discusmeetchat.".concat(this.discuss)).here(function (users) {
		console.log('A');
			console.log(users);	
      _this4.participants = users;

    }).joining(function (user) {
console.log('B');
			console.log(user);	
      _this4.participants.push(user);

    }).leaving(function (user) {
console.log('C');
			console.log(user);	
      //this.participants = _.reject(this.participants, participant => participant.id == user.id);

      if (user.id == _this4.chatusrwindow) {

        _this4.chatusrwindow = 0;



        _this4.getInitialData(_this4.chatusrwindow);

      }



      var i = _this4.participants.map(function (item) {

        return item.id;

      }).indexOf(user.id); // find index of your object





      _this4.participants.splice(i, 1);

    });

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/ChatWindow.vue?vue&type=script&lang=js&":

/*!*********************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/ChatWindow.vue?vue&type=script&lang=js& ***!

  \*********************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

/* harmony import */ var _Header_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Header.vue */ "./resources/js/components/Header.vue");

/* harmony import */ var _MessageList_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MessageList.vue */ "./resources/js/components/MessageList.vue");

/* harmony import */ var _UserInput_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./UserInput.vue */ "./resources/js/components/UserInput.vue");

/* harmony import */ var _UserList_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./UserList.vue */ "./resources/js/components/UserList.vue");

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//









/* harmony default export */ __webpack_exports__["default"] = ({

  components: {

    Header: _Header_vue__WEBPACK_IMPORTED_MODULE_0__["default"],

    MessageList: _MessageList_vue__WEBPACK_IMPORTED_MODULE_1__["default"],

    UserInput: _UserInput_vue__WEBPACK_IMPORTED_MODULE_2__["default"],

    UserList: _UserList_vue__WEBPACK_IMPORTED_MODULE_3__["default"]

  },

  props: {

    chatusrwindow: {

      type: Number,

      required: true

    },

    chatuser: {

      type: String,

      required: true

    },

    showEmoji: {

      type: Boolean,

      "default": false

    },

    showCloseButton: {

      type: Boolean,

      "default": true

    },

    showFile: {

      type: Boolean,

      "default": false

    },

    showHeader: {

      type: Boolean,

      "default": true

    },

    participants: {

      type: Array,

      required: true

    },

    title: {

      type: String,

      required: true

    },

    titleImageUrl: {

      type: String,

      "default": ''

    },

    onUserInputSubmit: {

      type: Function,

      required: true

    },

    onClose: {

      type: Function,

      required: true

    },

    messageList: {

      type: Array,

      "default": function _default() {

        return [];

      }

    },

    isOpen: {

      type: Boolean,

      "default": function _default() {

        return false;

      }

    },

    placeholder: {

      type: String,

      "default": 'Write a message...'

    },

    showTypingIndicator: {

      type: String,

      required: true

    },

    colors: {

      type: Object,

      required: true

    },

    alwaysScrollToBottom: {

      type: Boolean,

      required: true

    },

    messageStyling: {

      type: Boolean,

      required: true

    },

    disableUserListToggle: {

      type: Boolean,

      "default": false

    },

    showEdition: {

      type: Boolean,

      required: true

    },

    showDeletion: {

      type: Boolean,

      required: true

    }

  },

  data: function data() {

    return {

      showUserList: false,

      inUserListval: false

    };

  },

  computed: {

    messages: function messages() {

      var messages = this.messageList;

      return messages;

    }

  },

  methods: {

    handleUserListToggle: function handleUserListToggle(showUserList) {

      this.showUserList = showUserList;

      this.inUserListval = showUserList;

    },

    getSuggestions: function getSuggestions() {

      return this.messages.length > 0 ? this.messages[this.messages.length - 1].suggestions : [];

    },

    chatuserchangedfromuser: function chatuserchangedfromuser($event) {

      this.handleUserListToggle(false);

      this.$emit('chattouserchanged', $event);

    }

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/Chatarea.vue?vue&type=script&lang=js&":

/*!*******************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/Chatarea.vue?vue&type=script&lang=js& ***!

  \*******************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

/* harmony import */ var _ChatWindow_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ChatWindow.vue */ "./resources/js/components/ChatWindow.vue");

/* harmony import */ var _assets_close_icon_png__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./assets/close-icon.png */ "./resources/js/components/assets/close-icon.png");

/* harmony import */ var _assets_close_icon_png__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_assets_close_icon_png__WEBPACK_IMPORTED_MODULE_1__);

/* harmony import */ var _assets_logo_no_bg_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./assets/logo-no-bg.svg */ "./resources/js/components/assets/logo-no-bg.svg");

/* harmony import */ var _assets_logo_no_bg_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_assets_logo_no_bg_svg__WEBPACK_IMPORTED_MODULE_2__);

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//







/* harmony default export */ __webpack_exports__["default"] = ({

  components: {

    ChatWindow: _ChatWindow_vue__WEBPACK_IMPORTED_MODULE_0__["default"]

  },

  props: {

    icons: {

      type: Object,

      "default": function _default() {

        return {

          open: {

            img: '../public/images/chat/logo-no-bg.svg',

            name: 'default'

          },

          close: {

            img: '../public/images/chat/close-icon.png',

            name: 'default'

          }

        };

      }

    },

    showEmoji: {

      type: Boolean,

      "default": false

    },

    showEdition: {

      type: Boolean,

      "default": false

    },

    showDeletion: {

      type: Boolean,

      "default": false

    },

    isOpen: {

      type: Boolean,

      required: true

    },

    chatuser: {

      type: String,

      required: true

    },

    chatusrwindow: {

      type: Number,

      required: true

    },

    open: {

      type: Function,

      required: true

    },

    close: {

      type: Function,

      required: true

    },

    showFile: {

      type: Boolean,

      "default": false

    },

    showLauncher: {

      type: Boolean,

      "default": true

    },

    showCloseButton: {

      type: Boolean,

      "default": true

    },

    showHeader: {

      type: Boolean,

      "default": true

    },

    participants: {

      type: Array,

      required: true

    },

    title: {

      type: String,

      "default": function _default() {

        return '';

      }

    },

    titleImageUrl: {

      type: String,

      "default": function _default() {

        return '';

      }

    },

    onMessageWasSent: {

      type: Function,

      required: true

    },

    messageList: {

      type: Array,

      "default": function _default() {

        return [];

      }

    },

    newMessagesCount: {

      type: Number,

      "default": function _default() {

        return 0;

      }

    },

    placeholder: {

      type: String,

      "default": 'Write a message...'

    },

    showTypingIndicator: {

      type: String,

      "default": function _default() {

        return '';

      }

    },

    colors: {

      type: Object,

      validator: function validator(c) {

        return 'header' in c && 'bg' in c.header && 'text' in c.header && 'launcher' in c && 'bg' in c.launcher && 'messageList' in c && 'bg' in c.messageList && 'sentMessage' in c && 'bg' in c.sentMessage && 'text' in c.sentMessage && 'receivedMessage' in c && 'bg' in c.receivedMessage && 'text' in c.receivedMessage && 'userInput' in c && 'bg' in c.userInput && 'text' in c.userInput;

      },

      "default": function _default() {

        return {

          header: {

            bg: '#4e8cff',

            text: '#ffffff'

          },

          launcher: {

            bg: '#4e8cff'

          },

          messageList: {

            bg: '#ffffff'

          },

          sentMessage: {

            bg: '#4e8cff',

            text: '#ffffff'

          },

          receivedMessage: {

            bg: '#f4f7f9',

            text: '#ffffff'

          },

          userInput: {

            bg: '#f4f7f9',

            text: '#565867'

          }

        };

      }

    },

    alwaysScrollToBottom: {

      type: Boolean,

      "default": function _default() {

        return false;

      }

    },

    messageStyling: {

      type: Boolean,

      "default": function _default() {

        return false;

      }

    },

    disableUserListToggle: {

      type: Boolean,

      "default": false

    }

  },

  computed: {

    chatWindowTitle: function chatWindowTitle() {

      if (this.title !== '') {

        return this.title;

      }



      if (this.participants.length === 0) {

        return 'You';

      } else if (this.participants.length > 1) {

        return 'You, ' + this.participants[0].name + ' & others';

      } else {

        return 'You & ' + this.participants[0].name;

      }

    }

  },

  methods: {

    openAndFocus: function openAndFocus() {

      this.open();

      this.$root.$emit('focusUserInput');

    }

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/EmojiPicker.vue?vue&type=script&lang=js&":

/*!**********************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/EmojiPicker.vue?vue&type=script&lang=js& ***!

  \**********************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

/* harmony import */ var emoji_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! emoji-js */ "./node_modules/emoji-js/lib/emoji.js");

/* harmony import */ var emoji_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(emoji_js__WEBPACK_IMPORTED_MODULE_0__);

/* harmony import */ var _emojiData__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./emojiData */ "./resources/js/components/emojiData.js");

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//





/* harmony default export */ __webpack_exports__["default"] = ({

  props: {

    onBlur: {

      type: Function,

      required: true

    },

    onEmojiPicked: {

      type: Function,

      required: true

    }

  },

  data: function data() {

    return {

      emojiData: _emojiData__WEBPACK_IMPORTED_MODULE_1__["default"],

      emojiConvertor: new emoji_js__WEBPACK_IMPORTED_MODULE_0___default.a()

    };

  },

  mounted: function mounted() {

    var elem = this.$refs.domNode;

    elem.style.opacity = 0;

    window.requestAnimationFrame(function () {

      elem.style.transition = 'opacity 350ms';

      elem.style.opacity = 1;

    });

    this.$refs.domNode.focus();

    this.emojiConvertor.init_env();

  },

  methods: {

    emojiClicked: function emojiClicked(emoji) {

      this.onEmojiPicked(emoji);

      this.$refs.domNode.blur();

    }

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/ExampleComponent.vue?vue&type=script&lang=js&":

/*!***************************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/ExampleComponent.vue?vue&type=script&lang=js& ***!

  \***************************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

/* harmony default export */ __webpack_exports__["default"] = ({

  mounted: function mounted() {

    console.log('Component mounted.');

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/Header.vue?vue&type=script&lang=js&":

/*!*****************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/Header.vue?vue&type=script&lang=js& ***!

  \*****************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

/* harmony import */ var _assets_close_icon_big_png__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./assets/close-icon-big.png */ "./resources/js/components/assets/close-icon-big.png");

/* harmony import */ var _assets_close_icon_big_png__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_assets_close_icon_big_png__WEBPACK_IMPORTED_MODULE_0__);

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//



/* harmony default export */ __webpack_exports__["default"] = ({

  props: {

    icons: {

      type: Object,

      "default": function _default() {

        return {

          close: {

            img: '../public/images/chat/close-icon-big.png',

            name: 'default'

          }

        };

      }

    },

    imageUrl: {

      type: String,

      required: true

    },

    title: {

      type: String,

      required: true

    },

    onClose: {

      type: Function,

      required: true

    },

    colors: {

      type: Object,

      required: true

    },

    disableUserListToggle: {

      type: Boolean,

      "default": false

    },

    showCloseButton: {

      type: Boolean,

      "default": false

    },

    inUserList: {

      type: Boolean,

      "default": false

    }

  },

  data: function data() {

    return {

      inUserListVal: this.inUserList

    };

  },

  methods: {

    toggleUserList: function toggleUserList() {

      this.inUserListVal = !this.inUserListVal;

      this.$emit('userList', this.inUserListVal);

    }

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/IconBase.vue?vue&type=script&lang=js&":

/*!*******************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/IconBase.vue?vue&type=script&lang=js& ***!

  \*******************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

/* harmony default export */ __webpack_exports__["default"] = ({

  props: {

    iconName: {

      type: String,

      "default": 'box'

    },

    width: {

      type: [Number, String],

      "default": 18

    },

    height: {

      type: [Number, String],

      "default": 18

    },

    iconColor: {

      type: String,

      "default": 'currentColor'

    }

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/Message.vue?vue&type=script&lang=js&":

/*!******************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/Message.vue?vue&type=script&lang=js& ***!

  \******************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

/* harmony import */ var _messages_TextMessage_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../messages/TextMessage.vue */ "./resources/js/messages/TextMessage.vue");

/* harmony import */ var _messages_FileMessage_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../messages/FileMessage.vue */ "./resources/js/messages/FileMessage.vue");

/* harmony import */ var _messages_EmojiMessage_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./../messages/EmojiMessage.vue */ "./resources/js/messages/EmojiMessage.vue");

/* harmony import */ var _messages_TypingMessage_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./../messages/TypingMessage.vue */ "./resources/js/messages/TypingMessage.vue");

/* harmony import */ var _messages_SystemMessage_vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./../messages/SystemMessage.vue */ "./resources/js/messages/SystemMessage.vue");

/* harmony import */ var _assets_chat_icon_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./assets/chat-icon.svg */ "./resources/js/components/assets/chat-icon.svg");

/* harmony import */ var _assets_chat_icon_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_assets_chat_icon_svg__WEBPACK_IMPORTED_MODULE_5__);

/* harmony import */ var _store___WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./../store/ */ "./resources/js/store/index.js");

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//















/* harmony default export */ __webpack_exports__["default"] = ({

  components: {

    TextMessage: _messages_TextMessage_vue__WEBPACK_IMPORTED_MODULE_0__["default"],

    FileMessage: _messages_FileMessage_vue__WEBPACK_IMPORTED_MODULE_1__["default"],

    EmojiMessage: _messages_EmojiMessage_vue__WEBPACK_IMPORTED_MODULE_2__["default"],

    TypingMessage: _messages_TypingMessage_vue__WEBPACK_IMPORTED_MODULE_3__["default"],

    SystemMessage: _messages_SystemMessage_vue__WEBPACK_IMPORTED_MODULE_4__["default"]

  },

  props: {

    chatusrwindow: {

      type: Number,

      required: true

    },

    chatuser: {

      type: String,

      required: true

    },

    message: {

      type: Object,

      required: true

    },

    colors: {

      type: Object,

      required: true

    },

    messageStyling: {

      type: Boolean,

      required: true

    },

    user: {

      type: Object,

      required: true

    },

    showEdition: {

      type: Boolean,

      required: true

    },

    showDeletion: {

      type: Boolean,

      required: true

    }

  },

  methods: {

    chattouserchanged: function chattouserchanged(event) {

      event.preventDefault();

      var selusr = event.target.getAttribute('data-usr');

      this.$emit('chattouserchanged', selusr);

    }

  },

  computed: {

    authorName: function authorName() {

      return this.user && this.user.name;

    },

    chatImageUrl: function chatImageUrl() {

      return this.user && this.user.imageUrl || _assets_chat_icon_svg__WEBPACK_IMPORTED_MODULE_5___default.a;

    },

    messageColors: function messageColors() {

      return this.message.fromusr == this.chatuser ? this.sentColorsStyle : this.receivedColorsStyle;

    },

    receivedColorsStyle: function receivedColorsStyle() {

      return {

        color: this.colors.receivedMessage.text,

        backgroundColor: this.colors.receivedMessage.bg

      };

    },

    sentColorsStyle: function sentColorsStyle() {

      return {

        color: this.colors.sentMessage.text,

        backgroundColor: this.colors.sentMessage.bg

      };

    }

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/MessageList.vue?vue&type=script&lang=js&":

/*!**********************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/MessageList.vue?vue&type=script&lang=js& ***!

  \**********************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

/* harmony import */ var _Message_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Message.vue */ "./resources/js/components/Message.vue");

/* harmony import */ var _assets_chat_icon_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./assets/chat-icon.svg */ "./resources/js/components/assets/chat-icon.svg");

/* harmony import */ var _assets_chat_icon_svg__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_assets_chat_icon_svg__WEBPACK_IMPORTED_MODULE_1__);

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//





/* harmony default export */ __webpack_exports__["default"] = ({

  components: {

    Message: _Message_vue__WEBPACK_IMPORTED_MODULE_0__["default"]

  },

  props: {

    chatusrwindow: {

      type: Number,

      required: true

    },

    chatuser: {

      type: String,

      required: true

    },

    participants: {

      type: Array,

      required: true

    },

    messages: {

      type: Array,

      required: true

    },

    showTypingIndicator: {

      type: String,

      required: true

    },

    colors: {

      type: Object,

      required: true

    },

    alwaysScrollToBottom: {

      type: Boolean,

      required: true

    },

    messageStyling: {

      type: Boolean,

      required: true

    },

    showEdition: {

      type: Boolean,

      required: true

    },

    showDeletion: {

      type: Boolean,

      required: true

    }

  },

  computed: {

    defaultChatIcon: function defaultChatIcon() {

      return '../public/images/chat/chat-icon.svg';

    }

  },

  mounted: function mounted() {

    this.$nextTick(this._scrollDown());

  },

  updated: function updated() {

    if (this.shouldScrollToBottom()) this.$nextTick(this._scrollDown());

  },

  methods: {

    _scrollDown: function _scrollDown() {

      this.$refs.scrollList.scrollTop = this.$refs.scrollList.scrollHeight;

    },

    handleScroll: function handleScroll(e) {

      if (e.target.scrollTop === 0) {

        this.$emit('scrollToTop');

      }

    },

    shouldScrollToBottom: function shouldScrollToBottom() {

      var scrollTop = this.$refs.scrollList.scrollTop;

      var scrollable = scrollTop > this.$refs.scrollList.scrollHeight - 600;

      return this.alwaysScrollToBottom || scrollable;

    },

    profile: function profile(author) {

      var profile = this.participants.find(function (profile) {

        return profile.id === author;

      }); // A profile may not be found for system messages or messages by 'me'



      return profile || {

        imageUrl: '',

        name: ''

      };

    }

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/Suggestions.vue?vue&type=script&lang=js&":

/*!**********************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/Suggestions.vue?vue&type=script&lang=js& ***!

  \**********************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

/* harmony default export */ __webpack_exports__["default"] = ({

  props: {

    suggestions: {

      type: Array,

      "default": function _default() {

        return [];

      }

    },

    colors: {

      type: Object,

      required: true

    }

  },

  data: function data() {

    return {};

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/UserInput.vue?vue&type=script&lang=js&":

/*!********************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/UserInput.vue?vue&type=script&lang=js& ***!

  \********************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

/* harmony import */ var _icons_EmojiIcon_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../icons/EmojiIcon.vue */ "./resources/js/icons/EmojiIcon.vue");

/* harmony import */ var _icons_FileIcons_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../icons/FileIcons.vue */ "./resources/js/icons/FileIcons.vue");

/* harmony import */ var _UserInputButton_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./UserInputButton.vue */ "./resources/js/components/UserInputButton.vue");

/* harmony import */ var _Suggestions_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Suggestions.vue */ "./resources/js/components/Suggestions.vue");

/* harmony import */ var _assets_file_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./assets/file.svg */ "./resources/js/components/assets/file.svg");

/* harmony import */ var _assets_file_svg__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_assets_file_svg__WEBPACK_IMPORTED_MODULE_4__);

/* harmony import */ var _assets_close_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./assets/close.svg */ "./resources/js/components/assets/close.svg");

/* harmony import */ var _assets_close_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_assets_close_svg__WEBPACK_IMPORTED_MODULE_5__);

/* harmony import */ var _store___WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./../store/ */ "./resources/js/store/index.js");

/* harmony import */ var _icons_IconCross_vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./icons/IconCross.vue */ "./resources/js/components/icons/IconCross.vue");

/* harmony import */ var _icons_IconOk_vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./icons/IconOk.vue */ "./resources/js/components/icons/IconOk.vue");

/* harmony import */ var _icons_IconSend_vue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./icons/IconSend.vue */ "./resources/js/components/icons/IconSend.vue");

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//





















/* harmony default export */ __webpack_exports__["default"] = ({

  components: {

    EmojiIcon: _icons_EmojiIcon_vue__WEBPACK_IMPORTED_MODULE_0__["default"],

    FileIcons: _icons_FileIcons_vue__WEBPACK_IMPORTED_MODULE_1__["default"],

    UserInputButton: _UserInputButton_vue__WEBPACK_IMPORTED_MODULE_2__["default"],

    Suggestions: _Suggestions_vue__WEBPACK_IMPORTED_MODULE_3__["default"],

    IconCross: _icons_IconCross_vue__WEBPACK_IMPORTED_MODULE_7__["default"],

    IconOk: _icons_IconOk_vue__WEBPACK_IMPORTED_MODULE_8__["default"],

    IconSend: _icons_IconSend_vue__WEBPACK_IMPORTED_MODULE_9__["default"]

  },

  props: {

    chatusrwindow: {

      type: Number,

      required: true,

      "default": 0

    },

    chatuser: {

      type: String,

      required: true

    },

    participants: {

      type: Array,

      required: true

    },

    icons: {

      type: Object,

      "default": function _default() {

        return {

          file: {

            img: '../public/images/chat/file.svg',

            name: 'default'

          },

          closeSvg: {

            img: '../public/images/chat/close.svg',

            name: 'default'

          }

        };

      }

    },

    showEmoji: {

      type: Boolean,

      "default": function _default() {

        return false;

      }

    },

    suggestions: {

      type: Array,

      "default": function _default() {

        return [];

      }

    },

    showFile: {

      type: Boolean,

      "default": function _default() {

        return false;

      }

    },

    onSubmit: {

      type: Function,

      required: true

    },

    placeholder: {

      type: String,

      "default": 'Write something...'

    },

    colors: {

      type: Object,

      required: true

    }

  },

  data: function data() {

    return {

      file: null,

      inputActive: false,

      chatusrwindowval: this.chatusrwindow,

      store: _store___WEBPACK_IMPORTED_MODULE_6__["default"]

    };

  },

  computed: {

    editMessageId: function editMessageId() {

      return this.isEditing && _store___WEBPACK_IMPORTED_MODULE_6__["default"].editMessage.id;

    },

    isEditing: function isEditing() {

      return _store___WEBPACK_IMPORTED_MODULE_6__["default"].editMessage && _store___WEBPACK_IMPORTED_MODULE_6__["default"].editMessage.id;

    }

  },

  watch: {

    editMessageId: function editMessageId(m) {

      if (_store___WEBPACK_IMPORTED_MODULE_6__["default"].editMessage != null && _store___WEBPACK_IMPORTED_MODULE_6__["default"].editMessage != undefined) {

        this.$refs.userInput.focus();

        this.$refs.userInput.textContent = _store___WEBPACK_IMPORTED_MODULE_6__["default"].editMessage.data.text;

      } else {

        this.$refs.userInput.textContent = '';

      }

    }

  },

  mounted: function mounted() {

    var _this = this;



    this.$root.$on('focusUserInput', function () {

      if (_this.$refs.userInput) {

        _this.focusUserInput();

      }

    });

  },

  methods: {

    cancelFile: function cancelFile() {

      this.file = null;

    },

    setInputActive: function setInputActive(onoff) {

      this.inputActive = onoff;

    },

    handleKey: function handleKey(event) {

      if (event.keyCode === 13 && !event.shiftKey) {

        if (!this.isEditing) {

          this._submitText(event);

        } else {

          this._editText(event);

        }



        this._editFinish();



        event.preventDefault();

      } else if (event.keyCode === 27) {

        this._editFinish();



        event.preventDefault();

      }



      this.$emit('onType');

    },

    chattouserchanged: function chattouserchanged() {

      this.$emit('chattouserchanged', this.chatusrwindowval);

    },

    focusUserInput: function focusUserInput() {

      var _this2 = this;



      this.$nextTick(function () {

        _this2.$refs.userInput.focus();

      });

    },

    _submitSuggestion: function _submitSuggestion(suggestion) {

      this.onSubmit({

        fromusr: this.chatuser,

        author: 'me',

        type: 'text',

        data: {

          text: suggestion

        }

      });

    },

    _checkSubmitSuccess: function _checkSubmitSuccess(success) {

      console.log(Promise);



      if (Promise !== undefined) {

        Promise.resolve(success).then(function (wasSuccessful) {

          if (wasSuccessful === undefined || wasSuccessful) {

            this.file = null;

            this.$refs.userInput.innerHTML = '';

          }

        }.bind(this));

      } else {

        this.file = null;

        this.$refs.userInput.innerHTML = '';

      }

    },

    _submitText: function _submitText(event) {

      var text = this.$refs.userInput.textContent;

      var file = this.file;

      var togroup = 0;



      if (this.chatusrwindowval == 0) {

        var togroup = 1;

      }



      console.log(this.chatuser);



      if (file) {

        this._submitTextWhenFile(event, text, file);

      } else {

        if (text && text.length > 0) {

          this._checkSubmitSuccess(this.onSubmit({

            fromusr: this.chatuser,

            author: 'me',

            tousr: this.chatusrwindowval,

            togroup: togroup,

            type: 'text',

            c_typ: 1,

            data: {

              text: text

            }

          }));

        }

      }

    },

    _submitTextWhenFile: function _submitTextWhenFile(event, text, file) {

      if (text && text.length > 0) {

        this._checkSubmitSuccess(this.onSubmit({

          author: 'me',

          c_typ: 2,

          fromusr: this.chatuser,

          data: {

            text: text,

            file: file

          },

          type: 'file'

        }));

      } else {

        this._checkSubmitSuccess(this.onSubmit({

          author: 'me',

          c_typ: 2,

          fromusr: this.chatuser,

          type: 'file',

          data: {

            file: file

          }

        }));

      }

    },

    _editText: function _editText(event) {

      var text = this.$refs.userInput.textContent;



      if (text && text.length) {

        this.$emit('edit', {

          fromusr: this.chatuser,

          author: 'me',

          c_typ: 1,

          type: 'text',

          id: _store___WEBPACK_IMPORTED_MODULE_6__["default"].editMessage.id,

          data: {

            text: text

          }

        });



        this._editFinish();

      }

    },

    _handleEmojiPicked: function _handleEmojiPicked(emoji) {

      this._checkSubmitSuccess(this.onSubmit({

        fromusr: this.chatuser,

        author: 'me',

        c_typ: 3,

        type: 'emoji',

        data: {

          emoji: emoji

        }

      }));

    },

    _handleFileSubmit: function _handleFileSubmit(file) {

      this.file = file;

    },

    _editFinish: function _editFinish() {

      this.store.editMessage = null;

    }

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/UserInputButton.vue?vue&type=script&lang=js&":

/*!**************************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/UserInputButton.vue?vue&type=script&lang=js& ***!

  \**************************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

/* harmony import */ var _IconBase_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./IconBase.vue */ "./resources/js/components/IconBase.vue");

//

//

//

//

//

//

//

//



/* harmony default export */ __webpack_exports__["default"] = ({

  components: {

    IconBase: _IconBase_vue__WEBPACK_IMPORTED_MODULE_0__["default"]

  },

  props: {

    color: {

      type: String,

      required: true

    },

    tooltip: {

      type: String,

      "default": ''

    }

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/UserList.vue?vue&type=script&lang=js&":

/*!*******************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/UserList.vue?vue&type=script&lang=js& ***!

  \*******************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

/* harmony default export */ __webpack_exports__["default"] = ({

  props: {

    chatusrwindow: {

      type: Number,

      required: true

    },

    chatuser: {

      type: String,

      required: true

    },

    participants: {

      type: Array,

      required: true

    },

    colors: {

      type: Object,

      "default": function _default() {

        return {};

      }

    }

  },

  data: function data() {

    return {

      emptyprofile: '../public/images/chat/emptyprofile.jpg'

    };

  },

  methods: {

    chattouserchanged: function chattouserchanged(event) {

      event.preventDefault();

      var selusr = event.target.getAttribute('data-usr');

      selusr = parseInt(selusr, 10);

      this.$emit('chattouserchanged', selusr);

    }

  },

  computed: {

    userListColor: function userListColor() {

      var defaultColors = {

        userList: {

          bg: '#FFFFFF',

          text: '#000000'

        }

      };

      return Object.assign(defaultColors, this.colors);

    }

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/icons/EmojiIcon.vue?vue&type=script&lang=js&":

/*!***************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/icons/EmojiIcon.vue?vue&type=script&lang=js& ***!

  \***************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

/* harmony import */ var _components_EmojiPicker_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../components/EmojiPicker.vue */ "./resources/js/components/EmojiPicker.vue");

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//



/* harmony default export */ __webpack_exports__["default"] = ({

  components: {

    EmojiPicker: _components_EmojiPicker_vue__WEBPACK_IMPORTED_MODULE_0__["default"]

  },

  props: {

    onEmojiPicked: {

      type: Function,

      required: true

    },

    color: {

      type: String,

      required: true

    }

  },

  data: function data() {

    return {

      isActive: false

    };

  },

  methods: {

    _openPicker: function _openPicker(e) {

      this.isActive = !this.isActive;

    },

    _handlePickerBlur: function _handlePickerBlur() {

      this.isActive = false;

    }

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/icons/FileIcons.vue?vue&type=script&lang=js&":

/*!***************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/icons/FileIcons.vue?vue&type=script&lang=js& ***!

  \***************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

/* harmony default export */ __webpack_exports__["default"] = ({

  props: {

    onChange: {

      type: Function,

      required: true

    },

    color: {

      type: String,

      required: true

    }

  },

  methods: {

    _handleClick: function _handleClick(e) {

      e.target.value = null;

    },

    _handleChange: function _handleChange(e) {

      this.onChange(e.target.files[0]);

    }

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/messages/EmojiMessage.vue?vue&type=script&lang=js&":

/*!*********************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/messages/EmojiMessage.vue?vue&type=script&lang=js& ***!

  \*********************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

//

//

//

//

/* harmony default export */ __webpack_exports__["default"] = ({

  props: {

    data: {

      type: Object,

      required: true

    }

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/messages/FileMessage.vue?vue&type=script&lang=js&":

/*!********************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/messages/FileMessage.vue?vue&type=script&lang=js& ***!

  \********************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

//

//

//

//

//

//

//

//

//

//

//

//

//

//

/* harmony default export */ __webpack_exports__["default"] = ({

  props: {

    data: {

      type: Object,

      required: true

    },

    messageColors: {

      type: Object,

      required: true

    }

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/messages/SystemMessage.vue?vue&type=script&lang=js&":

/*!**********************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/messages/SystemMessage.vue?vue&type=script&lang=js& ***!

  \**********************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

//

//

//

//

//

//

//

//

//

//

//

/* harmony default export */ __webpack_exports__["default"] = ({

  props: {

    data: {

      type: Object,

      required: true

    },

    messageColors: {

      type: Object,

      required: true

    }

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/messages/TextMessage.vue?vue&type=script&lang=js&":

/*!********************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/messages/TextMessage.vue?vue&type=script&lang=js& ***!

  \********************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

/* harmony import */ var _components_IconBase_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../components/IconBase.vue */ "./resources/js/components/IconBase.vue");

/* harmony import */ var _components_icons_IconEdit_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../components/icons/IconEdit.vue */ "./resources/js/components/icons/IconEdit.vue");

/* harmony import */ var _components_icons_IconCross_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./../components/icons/IconCross.vue */ "./resources/js/components/icons/IconCross.vue");

/* harmony import */ var escape_goat__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! escape-goat */ "./node_modules/escape-goat/index.js");

/* harmony import */ var escape_goat__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(escape_goat__WEBPACK_IMPORTED_MODULE_3__);

/* harmony import */ var autolinker_dist_Autolinker_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! autolinker/dist/Autolinker.js */ "./node_modules/autolinker/dist/Autolinker.js");

/* harmony import */ var autolinker_dist_Autolinker_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(autolinker_dist_Autolinker_js__WEBPACK_IMPORTED_MODULE_4__);

/* harmony import */ var _store___WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./../store/ */ "./resources/js/store/index.js");

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//

//















var fmt = __webpack_require__(/*! msgdown */ "./node_modules/msgdown/src/msgdown.js");



/* harmony default export */ __webpack_exports__["default"] = ({

  components: {

    IconBase: _components_IconBase_vue__WEBPACK_IMPORTED_MODULE_0__["default"],

    IconCross: _components_icons_IconCross_vue__WEBPACK_IMPORTED_MODULE_2__["default"],

    IconEdit: _components_icons_IconEdit_vue__WEBPACK_IMPORTED_MODULE_1__["default"]

  },

  props: {

    message: {

      type: Object,

      required: true

    },

    messageColors: {

      type: Object,

      required: true

    },

    messageStyling: {

      type: Boolean,

      required: true

    },

    showEdition: {

      type: Boolean,

      required: true

    },

    showDeletion: {

      type: Boolean,

      required: true

    }

  },

  data: function data() {

    return {

      store: _store___WEBPACK_IMPORTED_MODULE_5__["default"]

    };

  },

  computed: {

    messageText: function messageText() {

      var escaped = escape_goat__WEBPACK_IMPORTED_MODULE_3___default.a.escape(this.message.data.text);

      return autolinker_dist_Autolinker_js__WEBPACK_IMPORTED_MODULE_4___default.a.link(this.messageStyling ? fmt(escaped) : escaped, {

        className: 'chatLink',

        truncate: {

          length: 50,

          location: 'smart'

        }

      });

    },

    me: function me() {

      return this.message.author === 'me';

    },

    isEditing: function isEditing() {

      return (_store___WEBPACK_IMPORTED_MODULE_5__["default"].editMessage && _store___WEBPACK_IMPORTED_MODULE_5__["default"].editMessage.id) == this.message.id;

    }

  },

  methods: {

    edit: function edit() {

      this.store.editMessage = this.message;

    }

  }

});



/***/ }),



/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/messages/TypingMessage.vue?vue&type=script&lang=js&":

/*!**********************************************************************************************************************************************************************!*\

  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/messages/TypingMessage.vue?vue&type=script&lang=js& ***!

  \**********************************************************************************************************************************************************************/

/*! exports provided: default */

/***/ (function(module, __webpack_exports__, __webpack_require__) {



"use strict";

__webpack_require__.r(__webpack_exports__);

//

//

//

//

//

//

//

//

/* harmony default export */ __webpack_exports__["default"] = ({

  props: {

    messageColors: {

      type: Object,

      required: true

    }

  }

});



/***/ }),



/***/ "./node_modules/bootstrap/dist/js/bootstrap.js":

/*!*****************************************************!*\

  !*** ./node_modules/bootstrap/dist/js/bootstrap.js ***!

  \*****************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



/*!

  * Bootstrap v4.5.2 (https://getbootstrap.com/)

  * Copyright 2011-2020 The Bootstrap Authors (https://github.com/twbs/bootstrap/graphs/contributors)

  * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)

  */

(function (global, factory) {

   true ? factory(exports, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js"), __webpack_require__(/*! popper.js */ "./node_modules/popper.js/dist/esm/popper.js")) :

  undefined;

}(this, (function (exports, $, Popper) { 'use strict';



  $ = $ && Object.prototype.hasOwnProperty.call($, 'default') ? $['default'] : $;

  Popper = Popper && Object.prototype.hasOwnProperty.call(Popper, 'default') ? Popper['default'] : Popper;



  function _defineProperties(target, props) {

    for (var i = 0; i < props.length; i++) {

      var descriptor = props[i];

      descriptor.enumerable = descriptor.enumerable || false;

      descriptor.configurable = true;

      if ("value" in descriptor) descriptor.writable = true;

      Object.defineProperty(target, descriptor.key, descriptor);

    }

  }



  function _createClass(Constructor, protoProps, staticProps) {

    if (protoProps) _defineProperties(Constructor.prototype, protoProps);

    if (staticProps) _defineProperties(Constructor, staticProps);

    return Constructor;

  }



  function _extends() {

    _extends = Object.assign || function (target) {

      for (var i = 1; i < arguments.length; i++) {

        var source = arguments[i];



        for (var key in source) {

          if (Object.prototype.hasOwnProperty.call(source, key)) {

            target[key] = source[key];

          }

        }

      }



      return target;

    };



    return _extends.apply(this, arguments);

  }



  function _inheritsLoose(subClass, superClass) {

    subClass.prototype = Object.create(superClass.prototype);

    subClass.prototype.constructor = subClass;

    subClass.__proto__ = superClass;

  }



  /**

   * --------------------------------------------------------------------------

   * Bootstrap (v4.5.2): util.js

   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)

   * --------------------------------------------------------------------------

   */

  /**

   * ------------------------------------------------------------------------

   * Private TransitionEnd Helpers

   * ------------------------------------------------------------------------

   */



  var TRANSITION_END = 'transitionend';

  var MAX_UID = 1000000;

  var MILLISECONDS_MULTIPLIER = 1000; // Shoutout AngusCroll (https://goo.gl/pxwQGp)



  function toType(obj) {

    if (obj === null || typeof obj === 'undefined') {

      return "" + obj;

    }



    return {}.toString.call(obj).match(/\s([a-z]+)/i)[1].toLowerCase();

  }



  function getSpecialTransitionEndEvent() {

    return {

      bindType: TRANSITION_END,

      delegateType: TRANSITION_END,

      handle: function handle(event) {

        if ($(event.target).is(this)) {

          return event.handleObj.handler.apply(this, arguments); // eslint-disable-line prefer-rest-params

        }



        return undefined;

      }

    };

  }



  function transitionEndEmulator(duration) {

    var _this = this;



    var called = false;

    $(this).one(Util.TRANSITION_END, function () {

      called = true;

    });

    setTimeout(function () {

      if (!called) {

        Util.triggerTransitionEnd(_this);

      }

    }, duration);

    return this;

  }



  function setTransitionEndSupport() {

    $.fn.emulateTransitionEnd = transitionEndEmulator;

    $.event.special[Util.TRANSITION_END] = getSpecialTransitionEndEvent();

  }

  /**

   * --------------------------------------------------------------------------

   * Public Util Api

   * --------------------------------------------------------------------------

   */





  var Util = {

    TRANSITION_END: 'bsTransitionEnd',

    getUID: function getUID(prefix) {

      do {

        // eslint-disable-next-line no-bitwise

        prefix += ~~(Math.random() * MAX_UID); // "~~" acts like a faster Math.floor() here

      } while (document.getElementById(prefix));



      return prefix;

    },

    getSelectorFromElement: function getSelectorFromElement(element) {

      var selector = element.getAttribute('data-target');



      if (!selector || selector === '#') {

        var hrefAttr = element.getAttribute('href');

        selector = hrefAttr && hrefAttr !== '#' ? hrefAttr.trim() : '';

      }



      try {

        return document.querySelector(selector) ? selector : null;

      } catch (err) {

        return null;

      }

    },

    getTransitionDurationFromElement: function getTransitionDurationFromElement(element) {

      if (!element) {

        return 0;

      } // Get transition-duration of the element





      var transitionDuration = $(element).css('transition-duration');

      var transitionDelay = $(element).css('transition-delay');

      var floatTransitionDuration = parseFloat(transitionDuration);

      var floatTransitionDelay = parseFloat(transitionDelay); // Return 0 if element or transition duration is not found



      if (!floatTransitionDuration && !floatTransitionDelay) {

        return 0;

      } // If multiple durations are defined, take the first





      transitionDuration = transitionDuration.split(',')[0];

      transitionDelay = transitionDelay.split(',')[0];

      return (parseFloat(transitionDuration) + parseFloat(transitionDelay)) * MILLISECONDS_MULTIPLIER;

    },

    reflow: function reflow(element) {

      return element.offsetHeight;

    },

    triggerTransitionEnd: function triggerTransitionEnd(element) {

      $(element).trigger(TRANSITION_END);

    },

    // TODO: Remove in v5

    supportsTransitionEnd: function supportsTransitionEnd() {

      return Boolean(TRANSITION_END);

    },

    isElement: function isElement(obj) {

      return (obj[0] || obj).nodeType;

    },

    typeCheckConfig: function typeCheckConfig(componentName, config, configTypes) {

      for (var property in configTypes) {

        if (Object.prototype.hasOwnProperty.call(configTypes, property)) {

          var expectedTypes = configTypes[property];

          var value = config[property];

          var valueType = value && Util.isElement(value) ? 'element' : toType(value);



          if (!new RegExp(expectedTypes).test(valueType)) {

            throw new Error(componentName.toUpperCase() + ": " + ("Option \"" + property + "\" provided type \"" + valueType + "\" ") + ("but expected type \"" + expectedTypes + "\"."));

          }

        }

      }

    },

    findShadowRoot: function findShadowRoot(element) {

      if (!document.documentElement.attachShadow) {

        return null;

      } // Can find the shadow root otherwise it'll return the document





      if (typeof element.getRootNode === 'function') {

        var root = element.getRootNode();

        return root instanceof ShadowRoot ? root : null;

      }



      if (element instanceof ShadowRoot) {

        return element;

      } // when we don't find a shadow root





      if (!element.parentNode) {

        return null;

      }



      return Util.findShadowRoot(element.parentNode);

    },

    jQueryDetection: function jQueryDetection() {

      if (typeof $ === 'undefined') {

        throw new TypeError('Bootstrap\'s JavaScript requires jQuery. jQuery must be included before Bootstrap\'s JavaScript.');

      }



      var version = $.fn.jquery.split(' ')[0].split('.');

      var minMajor = 1;

      var ltMajor = 2;

      var minMinor = 9;

      var minPatch = 1;

      var maxMajor = 4;



      if (version[0] < ltMajor && version[1] < minMinor || version[0] === minMajor && version[1] === minMinor && version[2] < minPatch || version[0] >= maxMajor) {

        throw new Error('Bootstrap\'s JavaScript requires at least jQuery v1.9.1 but less than v4.0.0');

      }

    }

  };

  Util.jQueryDetection();

  setTransitionEndSupport();



  /**

   * ------------------------------------------------------------------------

   * Constants

   * ------------------------------------------------------------------------

   */



  var NAME = 'alert';

  var VERSION = '4.5.2';

  var DATA_KEY = 'bs.alert';

  var EVENT_KEY = "." + DATA_KEY;

  var DATA_API_KEY = '.data-api';

  var JQUERY_NO_CONFLICT = $.fn[NAME];

  var SELECTOR_DISMISS = '[data-dismiss="alert"]';

  var EVENT_CLOSE = "close" + EVENT_KEY;

  var EVENT_CLOSED = "closed" + EVENT_KEY;

  var EVENT_CLICK_DATA_API = "click" + EVENT_KEY + DATA_API_KEY;

  var CLASS_NAME_ALERT = 'alert';

  var CLASS_NAME_FADE = 'fade';

  var CLASS_NAME_SHOW = 'show';

  /**

   * ------------------------------------------------------------------------

   * Class Definition

   * ------------------------------------------------------------------------

   */



  var Alert = /*#__PURE__*/function () {

    function Alert(element) {

      this._element = element;

    } // Getters





    var _proto = Alert.prototype;



    // Public

    _proto.close = function close(element) {

      var rootElement = this._element;



      if (element) {

        rootElement = this._getRootElement(element);

      }



      var customEvent = this._triggerCloseEvent(rootElement);



      if (customEvent.isDefaultPrevented()) {

        return;

      }



      this._removeElement(rootElement);

    };



    _proto.dispose = function dispose() {

      $.removeData(this._element, DATA_KEY);

      this._element = null;

    } // Private

    ;



    _proto._getRootElement = function _getRootElement(element) {

      var selector = Util.getSelectorFromElement(element);

      var parent = false;



      if (selector) {

        parent = document.querySelector(selector);

      }



      if (!parent) {

        parent = $(element).closest("." + CLASS_NAME_ALERT)[0];

      }



      return parent;

    };



    _proto._triggerCloseEvent = function _triggerCloseEvent(element) {

      var closeEvent = $.Event(EVENT_CLOSE);

      $(element).trigger(closeEvent);

      return closeEvent;

    };



    _proto._removeElement = function _removeElement(element) {

      var _this = this;



      $(element).removeClass(CLASS_NAME_SHOW);



      if (!$(element).hasClass(CLASS_NAME_FADE)) {

        this._destroyElement(element);



        return;

      }



      var transitionDuration = Util.getTransitionDurationFromElement(element);

      $(element).one(Util.TRANSITION_END, function (event) {

        return _this._destroyElement(element, event);

      }).emulateTransitionEnd(transitionDuration);

    };



    _proto._destroyElement = function _destroyElement(element) {

      $(element).detach().trigger(EVENT_CLOSED).remove();

    } // Static

    ;



    Alert._jQueryInterface = function _jQueryInterface(config) {

      return this.each(function () {

        var $element = $(this);

        var data = $element.data(DATA_KEY);



        if (!data) {

          data = new Alert(this);

          $element.data(DATA_KEY, data);

        }



        if (config === 'close') {

          data[config](this);

        }

      });

    };



    Alert._handleDismiss = function _handleDismiss(alertInstance) {

      return function (event) {

        if (event) {

          event.preventDefault();

        }



        alertInstance.close(this);

      };

    };



    _createClass(Alert, null, [{

      key: "VERSION",

      get: function get() {

        return VERSION;

      }

    }]);



    return Alert;

  }();

  /**

   * ------------------------------------------------------------------------

   * Data Api implementation

   * ------------------------------------------------------------------------

   */





  $(document).on(EVENT_CLICK_DATA_API, SELECTOR_DISMISS, Alert._handleDismiss(new Alert()));

  /**

   * ------------------------------------------------------------------------

   * jQuery

   * ------------------------------------------------------------------------

   */



  $.fn[NAME] = Alert._jQueryInterface;

  $.fn[NAME].Constructor = Alert;



  $.fn[NAME].noConflict = function () {

    $.fn[NAME] = JQUERY_NO_CONFLICT;

    return Alert._jQueryInterface;

  };



  /**

   * ------------------------------------------------------------------------

   * Constants

   * ------------------------------------------------------------------------

   */



  var NAME$1 = 'button';

  var VERSION$1 = '4.5.2';

  var DATA_KEY$1 = 'bs.button';

  var EVENT_KEY$1 = "." + DATA_KEY$1;

  var DATA_API_KEY$1 = '.data-api';

  var JQUERY_NO_CONFLICT$1 = $.fn[NAME$1];

  var CLASS_NAME_ACTIVE = 'active';

  var CLASS_NAME_BUTTON = 'btn';

  var CLASS_NAME_FOCUS = 'focus';

  var SELECTOR_DATA_TOGGLE_CARROT = '[data-toggle^="button"]';

  var SELECTOR_DATA_TOGGLES = '[data-toggle="buttons"]';

  var SELECTOR_DATA_TOGGLE = '[data-toggle="button"]';

  var SELECTOR_DATA_TOGGLES_BUTTONS = '[data-toggle="buttons"] .btn';

  var SELECTOR_INPUT = 'input:not([type="hidden"])';

  var SELECTOR_ACTIVE = '.active';

  var SELECTOR_BUTTON = '.btn';

  var EVENT_CLICK_DATA_API$1 = "click" + EVENT_KEY$1 + DATA_API_KEY$1;

  var EVENT_FOCUS_BLUR_DATA_API = "focus" + EVENT_KEY$1 + DATA_API_KEY$1 + " " + ("blur" + EVENT_KEY$1 + DATA_API_KEY$1);

  var EVENT_LOAD_DATA_API = "load" + EVENT_KEY$1 + DATA_API_KEY$1;

  /**

   * ------------------------------------------------------------------------

   * Class Definition

   * ------------------------------------------------------------------------

   */



  var Button = /*#__PURE__*/function () {

    function Button(element) {

      this._element = element;

    } // Getters





    var _proto = Button.prototype;



    // Public

    _proto.toggle = function toggle() {

      var triggerChangeEvent = true;

      var addAriaPressed = true;

      var rootElement = $(this._element).closest(SELECTOR_DATA_TOGGLES)[0];



      if (rootElement) {

        var input = this._element.querySelector(SELECTOR_INPUT);



        if (input) {

          if (input.type === 'radio') {

            if (input.checked && this._element.classList.contains(CLASS_NAME_ACTIVE)) {

              triggerChangeEvent = false;

            } else {

              var activeElement = rootElement.querySelector(SELECTOR_ACTIVE);



              if (activeElement) {

                $(activeElement).removeClass(CLASS_NAME_ACTIVE);

              }

            }

          }



          if (triggerChangeEvent) {

            // if it's not a radio button or checkbox don't add a pointless/invalid checked property to the input

            if (input.type === 'checkbox' || input.type === 'radio') {

              input.checked = !this._element.classList.contains(CLASS_NAME_ACTIVE);

            }



            $(input).trigger('change');

          }



          input.focus();

          addAriaPressed = false;

        }

      }



      if (!(this._element.hasAttribute('disabled') || this._element.classList.contains('disabled'))) {

        if (addAriaPressed) {

          this._element.setAttribute('aria-pressed', !this._element.classList.contains(CLASS_NAME_ACTIVE));

        }



        if (triggerChangeEvent) {

          $(this._element).toggleClass(CLASS_NAME_ACTIVE);

        }

      }

    };



    _proto.dispose = function dispose() {

      $.removeData(this._element, DATA_KEY$1);

      this._element = null;

    } // Static

    ;



    Button._jQueryInterface = function _jQueryInterface(config) {

      return this.each(function () {

        var data = $(this).data(DATA_KEY$1);



        if (!data) {

          data = new Button(this);

          $(this).data(DATA_KEY$1, data);

        }



        if (config === 'toggle') {

          data[config]();

        }

      });

    };



    _createClass(Button, null, [{

      key: "VERSION",

      get: function get() {

        return VERSION$1;

      }

    }]);



    return Button;

  }();

  /**

   * ------------------------------------------------------------------------

   * Data Api implementation

   * ------------------------------------------------------------------------

   */





  $(document).on(EVENT_CLICK_DATA_API$1, SELECTOR_DATA_TOGGLE_CARROT, function (event) {

    var button = event.target;

    var initialButton = button;



    if (!$(button).hasClass(CLASS_NAME_BUTTON)) {

      button = $(button).closest(SELECTOR_BUTTON)[0];

    }



    if (!button || button.hasAttribute('disabled') || button.classList.contains('disabled')) {

      event.preventDefault(); // work around Firefox bug #1540995

    } else {

      var inputBtn = button.querySelector(SELECTOR_INPUT);



      if (inputBtn && (inputBtn.hasAttribute('disabled') || inputBtn.classList.contains('disabled'))) {

        event.preventDefault(); // work around Firefox bug #1540995



        return;

      }



      if (initialButton.tagName !== 'LABEL' || inputBtn && inputBtn.type !== 'checkbox') {

        Button._jQueryInterface.call($(button), 'toggle');

      }

    }

  }).on(EVENT_FOCUS_BLUR_DATA_API, SELECTOR_DATA_TOGGLE_CARROT, function (event) {

    var button = $(event.target).closest(SELECTOR_BUTTON)[0];

    $(button).toggleClass(CLASS_NAME_FOCUS, /^focus(in)?$/.test(event.type));

  });

  $(window).on(EVENT_LOAD_DATA_API, function () {

    // ensure correct active class is set to match the controls' actual values/states

    // find all checkboxes/readio buttons inside data-toggle groups

    var buttons = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLES_BUTTONS));



    for (var i = 0, len = buttons.length; i < len; i++) {

      var button = buttons[i];

      var input = button.querySelector(SELECTOR_INPUT);



      if (input.checked || input.hasAttribute('checked')) {

        button.classList.add(CLASS_NAME_ACTIVE);

      } else {

        button.classList.remove(CLASS_NAME_ACTIVE);

      }

    } // find all button toggles





    buttons = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLE));



    for (var _i = 0, _len = buttons.length; _i < _len; _i++) {

      var _button = buttons[_i];



      if (_button.getAttribute('aria-pressed') === 'true') {

        _button.classList.add(CLASS_NAME_ACTIVE);

      } else {

        _button.classList.remove(CLASS_NAME_ACTIVE);

      }

    }

  });

  /**

   * ------------------------------------------------------------------------

   * jQuery

   * ------------------------------------------------------------------------

   */



  $.fn[NAME$1] = Button._jQueryInterface;

  $.fn[NAME$1].Constructor = Button;



  $.fn[NAME$1].noConflict = function () {

    $.fn[NAME$1] = JQUERY_NO_CONFLICT$1;

    return Button._jQueryInterface;

  };



  /**

   * ------------------------------------------------------------------------

   * Constants

   * ------------------------------------------------------------------------

   */



  var NAME$2 = 'carousel';

  var VERSION$2 = '4.5.2';

  var DATA_KEY$2 = 'bs.carousel';

  var EVENT_KEY$2 = "." + DATA_KEY$2;

  var DATA_API_KEY$2 = '.data-api';

  var JQUERY_NO_CONFLICT$2 = $.fn[NAME$2];

  var ARROW_LEFT_KEYCODE = 37; // KeyboardEvent.which value for left arrow key



  var ARROW_RIGHT_KEYCODE = 39; // KeyboardEvent.which value for right arrow key



  var TOUCHEVENT_COMPAT_WAIT = 500; // Time for mouse compat events to fire after touch



  var SWIPE_THRESHOLD = 40;

  var Default = {

    interval: 5000,

    keyboard: true,

    slide: false,

    pause: 'hover',

    wrap: true,

    touch: true

  };

  var DefaultType = {

    interval: '(number|boolean)',

    keyboard: 'boolean',

    slide: '(boolean|string)',

    pause: '(string|boolean)',

    wrap: 'boolean',

    touch: 'boolean'

  };

  var DIRECTION_NEXT = 'next';

  var DIRECTION_PREV = 'prev';

  var DIRECTION_LEFT = 'left';

  var DIRECTION_RIGHT = 'right';

  var EVENT_SLIDE = "slide" + EVENT_KEY$2;

  var EVENT_SLID = "slid" + EVENT_KEY$2;

  var EVENT_KEYDOWN = "keydown" + EVENT_KEY$2;

  var EVENT_MOUSEENTER = "mouseenter" + EVENT_KEY$2;

  var EVENT_MOUSELEAVE = "mouseleave" + EVENT_KEY$2;

  var EVENT_TOUCHSTART = "touchstart" + EVENT_KEY$2;

  var EVENT_TOUCHMOVE = "touchmove" + EVENT_KEY$2;

  var EVENT_TOUCHEND = "touchend" + EVENT_KEY$2;

  var EVENT_POINTERDOWN = "pointerdown" + EVENT_KEY$2;

  var EVENT_POINTERUP = "pointerup" + EVENT_KEY$2;

  var EVENT_DRAG_START = "dragstart" + EVENT_KEY$2;

  var EVENT_LOAD_DATA_API$1 = "load" + EVENT_KEY$2 + DATA_API_KEY$2;

  var EVENT_CLICK_DATA_API$2 = "click" + EVENT_KEY$2 + DATA_API_KEY$2;

  var CLASS_NAME_CAROUSEL = 'carousel';

  var CLASS_NAME_ACTIVE$1 = 'active';

  var CLASS_NAME_SLIDE = 'slide';

  var CLASS_NAME_RIGHT = 'carousel-item-right';

  var CLASS_NAME_LEFT = 'carousel-item-left';

  var CLASS_NAME_NEXT = 'carousel-item-next';

  var CLASS_NAME_PREV = 'carousel-item-prev';

  var CLASS_NAME_POINTER_EVENT = 'pointer-event';

  var SELECTOR_ACTIVE$1 = '.active';

  var SELECTOR_ACTIVE_ITEM = '.active.carousel-item';

  var SELECTOR_ITEM = '.carousel-item';

  var SELECTOR_ITEM_IMG = '.carousel-item img';

  var SELECTOR_NEXT_PREV = '.carousel-item-next, .carousel-item-prev';

  var SELECTOR_INDICATORS = '.carousel-indicators';

  var SELECTOR_DATA_SLIDE = '[data-slide], [data-slide-to]';

  var SELECTOR_DATA_RIDE = '[data-ride="carousel"]';

  var PointerType = {

    TOUCH: 'touch',

    PEN: 'pen'

  };

  /**

   * ------------------------------------------------------------------------

   * Class Definition

   * ------------------------------------------------------------------------

   */



  var Carousel = /*#__PURE__*/function () {

    function Carousel(element, config) {

      this._items = null;

      this._interval = null;

      this._activeElement = null;

      this._isPaused = false;

      this._isSliding = false;

      this.touchTimeout = null;

      this.touchStartX = 0;

      this.touchDeltaX = 0;

      this._config = this._getConfig(config);

      this._element = element;

      this._indicatorsElement = this._element.querySelector(SELECTOR_INDICATORS);

      this._touchSupported = 'ontouchstart' in document.documentElement || navigator.maxTouchPoints > 0;

      this._pointerEvent = Boolean(window.PointerEvent || window.MSPointerEvent);



      this._addEventListeners();

    } // Getters





    var _proto = Carousel.prototype;



    // Public

    _proto.next = function next() {

      if (!this._isSliding) {

        this._slide(DIRECTION_NEXT);

      }

    };



    _proto.nextWhenVisible = function nextWhenVisible() {

      // Don't call next when the page isn't visible

      // or the carousel or its parent isn't visible

      if (!document.hidden && $(this._element).is(':visible') && $(this._element).css('visibility') !== 'hidden') {

        this.next();

      }

    };



    _proto.prev = function prev() {

      if (!this._isSliding) {

        this._slide(DIRECTION_PREV);

      }

    };



    _proto.pause = function pause(event) {

      if (!event) {

        this._isPaused = true;

      }



      if (this._element.querySelector(SELECTOR_NEXT_PREV)) {

        Util.triggerTransitionEnd(this._element);

        this.cycle(true);

      }



      clearInterval(this._interval);

      this._interval = null;

    };



    _proto.cycle = function cycle(event) {

      if (!event) {

        this._isPaused = false;

      }



      if (this._interval) {

        clearInterval(this._interval);

        this._interval = null;

      }



      if (this._config.interval && !this._isPaused) {

        this._interval = setInterval((document.visibilityState ? this.nextWhenVisible : this.next).bind(this), this._config.interval);

      }

    };



    _proto.to = function to(index) {

      var _this = this;



      this._activeElement = this._element.querySelector(SELECTOR_ACTIVE_ITEM);



      var activeIndex = this._getItemIndex(this._activeElement);



      if (index > this._items.length - 1 || index < 0) {

        return;

      }



      if (this._isSliding) {

        $(this._element).one(EVENT_SLID, function () {

          return _this.to(index);

        });

        return;

      }



      if (activeIndex === index) {

        this.pause();

        this.cycle();

        return;

      }



      var direction = index > activeIndex ? DIRECTION_NEXT : DIRECTION_PREV;



      this._slide(direction, this._items[index]);

    };



    _proto.dispose = function dispose() {

      $(this._element).off(EVENT_KEY$2);

      $.removeData(this._element, DATA_KEY$2);

      this._items = null;

      this._config = null;

      this._element = null;

      this._interval = null;

      this._isPaused = null;

      this._isSliding = null;

      this._activeElement = null;

      this._indicatorsElement = null;

    } // Private

    ;



    _proto._getConfig = function _getConfig(config) {

      config = _extends({}, Default, config);

      Util.typeCheckConfig(NAME$2, config, DefaultType);

      return config;

    };



    _proto._handleSwipe = function _handleSwipe() {

      var absDeltax = Math.abs(this.touchDeltaX);



      if (absDeltax <= SWIPE_THRESHOLD) {

        return;

      }



      var direction = absDeltax / this.touchDeltaX;

      this.touchDeltaX = 0; // swipe left



      if (direction > 0) {

        this.prev();

      } // swipe right





      if (direction < 0) {

        this.next();

      }

    };



    _proto._addEventListeners = function _addEventListeners() {

      var _this2 = this;



      if (this._config.keyboard) {

        $(this._element).on(EVENT_KEYDOWN, function (event) {

          return _this2._keydown(event);

        });

      }



      if (this._config.pause === 'hover') {

        $(this._element).on(EVENT_MOUSEENTER, function (event) {

          return _this2.pause(event);

        }).on(EVENT_MOUSELEAVE, function (event) {

          return _this2.cycle(event);

        });

      }



      if (this._config.touch) {

        this._addTouchEventListeners();

      }

    };



    _proto._addTouchEventListeners = function _addTouchEventListeners() {

      var _this3 = this;



      if (!this._touchSupported) {

        return;

      }



      var start = function start(event) {

        if (_this3._pointerEvent && PointerType[event.originalEvent.pointerType.toUpperCase()]) {

          _this3.touchStartX = event.originalEvent.clientX;

        } else if (!_this3._pointerEvent) {

          _this3.touchStartX = event.originalEvent.touches[0].clientX;

        }

      };



      var move = function move(event) {

        // ensure swiping with one touch and not pinching

        if (event.originalEvent.touches && event.originalEvent.touches.length > 1) {

          _this3.touchDeltaX = 0;

        } else {

          _this3.touchDeltaX = event.originalEvent.touches[0].clientX - _this3.touchStartX;

        }

      };



      var end = function end(event) {

        if (_this3._pointerEvent && PointerType[event.originalEvent.pointerType.toUpperCase()]) {

          _this3.touchDeltaX = event.originalEvent.clientX - _this3.touchStartX;

        }



        _this3._handleSwipe();



        if (_this3._config.pause === 'hover') {

          // If it's a touch-enabled device, mouseenter/leave are fired as

          // part of the mouse compatibility events on first tap - the carousel

          // would stop cycling until user tapped out of it;

          // here, we listen for touchend, explicitly pause the carousel

          // (as if it's the second time we tap on it, mouseenter compat event

          // is NOT fired) and after a timeout (to allow for mouse compatibility

          // events to fire) we explicitly restart cycling

          _this3.pause();



          if (_this3.touchTimeout) {

            clearTimeout(_this3.touchTimeout);

          }



          _this3.touchTimeout = setTimeout(function (event) {

            return _this3.cycle(event);

          }, TOUCHEVENT_COMPAT_WAIT + _this3._config.interval);

        }

      };



      $(this._element.querySelectorAll(SELECTOR_ITEM_IMG)).on(EVENT_DRAG_START, function (e) {

        return e.preventDefault();

      });



      if (this._pointerEvent) {

        $(this._element).on(EVENT_POINTERDOWN, function (event) {

          return start(event);

        });

        $(this._element).on(EVENT_POINTERUP, function (event) {

          return end(event);

        });



        this._element.classList.add(CLASS_NAME_POINTER_EVENT);

      } else {

        $(this._element).on(EVENT_TOUCHSTART, function (event) {

          return start(event);

        });

        $(this._element).on(EVENT_TOUCHMOVE, function (event) {

          return move(event);

        });

        $(this._element).on(EVENT_TOUCHEND, function (event) {

          return end(event);

        });

      }

    };



    _proto._keydown = function _keydown(event) {

      if (/input|textarea/i.test(event.target.tagName)) {

        return;

      }



      switch (event.which) {

        case ARROW_LEFT_KEYCODE:

          event.preventDefault();

          this.prev();

          break;



        case ARROW_RIGHT_KEYCODE:

          event.preventDefault();

          this.next();

          break;

      }

    };



    _proto._getItemIndex = function _getItemIndex(element) {

      this._items = element && element.parentNode ? [].slice.call(element.parentNode.querySelectorAll(SELECTOR_ITEM)) : [];

      return this._items.indexOf(element);

    };



    _proto._getItemByDirection = function _getItemByDirection(direction, activeElement) {

      var isNextDirection = direction === DIRECTION_NEXT;

      var isPrevDirection = direction === DIRECTION_PREV;



      var activeIndex = this._getItemIndex(activeElement);



      var lastItemIndex = this._items.length - 1;

      var isGoingToWrap = isPrevDirection && activeIndex === 0 || isNextDirection && activeIndex === lastItemIndex;



      if (isGoingToWrap && !this._config.wrap) {

        return activeElement;

      }



      var delta = direction === DIRECTION_PREV ? -1 : 1;

      var itemIndex = (activeIndex + delta) % this._items.length;

      return itemIndex === -1 ? this._items[this._items.length - 1] : this._items[itemIndex];

    };



    _proto._triggerSlideEvent = function _triggerSlideEvent(relatedTarget, eventDirectionName) {

      var targetIndex = this._getItemIndex(relatedTarget);



      var fromIndex = this._getItemIndex(this._element.querySelector(SELECTOR_ACTIVE_ITEM));



      var slideEvent = $.Event(EVENT_SLIDE, {

        relatedTarget: relatedTarget,

        direction: eventDirectionName,

        from: fromIndex,

        to: targetIndex

      });

      $(this._element).trigger(slideEvent);

      return slideEvent;

    };



    _proto._setActiveIndicatorElement = function _setActiveIndicatorElement(element) {

      if (this._indicatorsElement) {

        var indicators = [].slice.call(this._indicatorsElement.querySelectorAll(SELECTOR_ACTIVE$1));

        $(indicators).removeClass(CLASS_NAME_ACTIVE$1);



        var nextIndicator = this._indicatorsElement.children[this._getItemIndex(element)];



        if (nextIndicator) {

          $(nextIndicator).addClass(CLASS_NAME_ACTIVE$1);

        }

      }

    };



    _proto._slide = function _slide(direction, element) {

      var _this4 = this;



      var activeElement = this._element.querySelector(SELECTOR_ACTIVE_ITEM);



      var activeElementIndex = this._getItemIndex(activeElement);



      var nextElement = element || activeElement && this._getItemByDirection(direction, activeElement);



      var nextElementIndex = this._getItemIndex(nextElement);



      var isCycling = Boolean(this._interval);

      var directionalClassName;

      var orderClassName;

      var eventDirectionName;



      if (direction === DIRECTION_NEXT) {

        directionalClassName = CLASS_NAME_LEFT;

        orderClassName = CLASS_NAME_NEXT;

        eventDirectionName = DIRECTION_LEFT;

      } else {

        directionalClassName = CLASS_NAME_RIGHT;

        orderClassName = CLASS_NAME_PREV;

        eventDirectionName = DIRECTION_RIGHT;

      }



      if (nextElement && $(nextElement).hasClass(CLASS_NAME_ACTIVE$1)) {

        this._isSliding = false;

        return;

      }



      var slideEvent = this._triggerSlideEvent(nextElement, eventDirectionName);



      if (slideEvent.isDefaultPrevented()) {

        return;

      }



      if (!activeElement || !nextElement) {

        // Some weirdness is happening, so we bail

        return;

      }



      this._isSliding = true;



      if (isCycling) {

        this.pause();

      }



      this._setActiveIndicatorElement(nextElement);



      var slidEvent = $.Event(EVENT_SLID, {

        relatedTarget: nextElement,

        direction: eventDirectionName,

        from: activeElementIndex,

        to: nextElementIndex

      });



      if ($(this._element).hasClass(CLASS_NAME_SLIDE)) {

        $(nextElement).addClass(orderClassName);

        Util.reflow(nextElement);

        $(activeElement).addClass(directionalClassName);

        $(nextElement).addClass(directionalClassName);

        var nextElementInterval = parseInt(nextElement.getAttribute('data-interval'), 10);



        if (nextElementInterval) {

          this._config.defaultInterval = this._config.defaultInterval || this._config.interval;

          this._config.interval = nextElementInterval;

        } else {

          this._config.interval = this._config.defaultInterval || this._config.interval;

        }



        var transitionDuration = Util.getTransitionDurationFromElement(activeElement);

        $(activeElement).one(Util.TRANSITION_END, function () {

          $(nextElement).removeClass(directionalClassName + " " + orderClassName).addClass(CLASS_NAME_ACTIVE$1);

          $(activeElement).removeClass(CLASS_NAME_ACTIVE$1 + " " + orderClassName + " " + directionalClassName);

          _this4._isSliding = false;

          setTimeout(function () {

            return $(_this4._element).trigger(slidEvent);

          }, 0);

        }).emulateTransitionEnd(transitionDuration);

      } else {

        $(activeElement).removeClass(CLASS_NAME_ACTIVE$1);

        $(nextElement).addClass(CLASS_NAME_ACTIVE$1);

        this._isSliding = false;

        $(this._element).trigger(slidEvent);

      }



      if (isCycling) {

        this.cycle();

      }

    } // Static

    ;



    Carousel._jQueryInterface = function _jQueryInterface(config) {

      return this.each(function () {

        var data = $(this).data(DATA_KEY$2);



        var _config = _extends({}, Default, $(this).data());



        if (typeof config === 'object') {

          _config = _extends({}, _config, config);

        }



        var action = typeof config === 'string' ? config : _config.slide;



        if (!data) {

          data = new Carousel(this, _config);

          $(this).data(DATA_KEY$2, data);

        }



        if (typeof config === 'number') {

          data.to(config);

        } else if (typeof action === 'string') {

          if (typeof data[action] === 'undefined') {

            throw new TypeError("No method named \"" + action + "\"");

          }



          data[action]();

        } else if (_config.interval && _config.ride) {

          data.pause();

          data.cycle();

        }

      });

    };



    Carousel._dataApiClickHandler = function _dataApiClickHandler(event) {

      var selector = Util.getSelectorFromElement(this);



      if (!selector) {

        return;

      }



      var target = $(selector)[0];



      if (!target || !$(target).hasClass(CLASS_NAME_CAROUSEL)) {

        return;

      }



      var config = _extends({}, $(target).data(), $(this).data());



      var slideIndex = this.getAttribute('data-slide-to');



      if (slideIndex) {

        config.interval = false;

      }



      Carousel._jQueryInterface.call($(target), config);



      if (slideIndex) {

        $(target).data(DATA_KEY$2).to(slideIndex);

      }



      event.preventDefault();

    };



    _createClass(Carousel, null, [{

      key: "VERSION",

      get: function get() {

        return VERSION$2;

      }

    }, {

      key: "Default",

      get: function get() {

        return Default;

      }

    }]);



    return Carousel;

  }();

  /**

   * ------------------------------------------------------------------------

   * Data Api implementation

   * ------------------------------------------------------------------------

   */





  $(document).on(EVENT_CLICK_DATA_API$2, SELECTOR_DATA_SLIDE, Carousel._dataApiClickHandler);

  $(window).on(EVENT_LOAD_DATA_API$1, function () {

    var carousels = [].slice.call(document.querySelectorAll(SELECTOR_DATA_RIDE));



    for (var i = 0, len = carousels.length; i < len; i++) {

      var $carousel = $(carousels[i]);



      Carousel._jQueryInterface.call($carousel, $carousel.data());

    }

  });

  /**

   * ------------------------------------------------------------------------

   * jQuery

   * ------------------------------------------------------------------------

   */



  $.fn[NAME$2] = Carousel._jQueryInterface;

  $.fn[NAME$2].Constructor = Carousel;



  $.fn[NAME$2].noConflict = function () {

    $.fn[NAME$2] = JQUERY_NO_CONFLICT$2;

    return Carousel._jQueryInterface;

  };



  /**

   * ------------------------------------------------------------------------

   * Constants

   * ------------------------------------------------------------------------

   */



  var NAME$3 = 'collapse';

  var VERSION$3 = '4.5.2';

  var DATA_KEY$3 = 'bs.collapse';

  var EVENT_KEY$3 = "." + DATA_KEY$3;

  var DATA_API_KEY$3 = '.data-api';

  var JQUERY_NO_CONFLICT$3 = $.fn[NAME$3];

  var Default$1 = {

    toggle: true,

    parent: ''

  };

  var DefaultType$1 = {

    toggle: 'boolean',

    parent: '(string|element)'

  };

  var EVENT_SHOW = "show" + EVENT_KEY$3;

  var EVENT_SHOWN = "shown" + EVENT_KEY$3;

  var EVENT_HIDE = "hide" + EVENT_KEY$3;

  var EVENT_HIDDEN = "hidden" + EVENT_KEY$3;

  var EVENT_CLICK_DATA_API$3 = "click" + EVENT_KEY$3 + DATA_API_KEY$3;

  var CLASS_NAME_SHOW$1 = 'show';

  var CLASS_NAME_COLLAPSE = 'collapse';

  var CLASS_NAME_COLLAPSING = 'collapsing';

  var CLASS_NAME_COLLAPSED = 'collapsed';

  var DIMENSION_WIDTH = 'width';

  var DIMENSION_HEIGHT = 'height';

  var SELECTOR_ACTIVES = '.show, .collapsing';

  var SELECTOR_DATA_TOGGLE$1 = '[data-toggle="collapse"]';

  /**

   * ------------------------------------------------------------------------

   * Class Definition

   * ------------------------------------------------------------------------

   */



  var Collapse = /*#__PURE__*/function () {

    function Collapse(element, config) {

      this._isTransitioning = false;

      this._element = element;

      this._config = this._getConfig(config);

      this._triggerArray = [].slice.call(document.querySelectorAll("[data-toggle=\"collapse\"][href=\"#" + element.id + "\"]," + ("[data-toggle=\"collapse\"][data-target=\"#" + element.id + "\"]")));

      var toggleList = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLE$1));



      for (var i = 0, len = toggleList.length; i < len; i++) {

        var elem = toggleList[i];

        var selector = Util.getSelectorFromElement(elem);

        var filterElement = [].slice.call(document.querySelectorAll(selector)).filter(function (foundElem) {

          return foundElem === element;

        });



        if (selector !== null && filterElement.length > 0) {

          this._selector = selector;



          this._triggerArray.push(elem);

        }

      }



      this._parent = this._config.parent ? this._getParent() : null;



      if (!this._config.parent) {

        this._addAriaAndCollapsedClass(this._element, this._triggerArray);

      }



      if (this._config.toggle) {

        this.toggle();

      }

    } // Getters





    var _proto = Collapse.prototype;



    // Public

    _proto.toggle = function toggle() {

      if ($(this._element).hasClass(CLASS_NAME_SHOW$1)) {

        this.hide();

      } else {

        this.show();

      }

    };



    _proto.show = function show() {

      var _this = this;



      if (this._isTransitioning || $(this._element).hasClass(CLASS_NAME_SHOW$1)) {

        return;

      }



      var actives;

      var activesData;



      if (this._parent) {

        actives = [].slice.call(this._parent.querySelectorAll(SELECTOR_ACTIVES)).filter(function (elem) {

          if (typeof _this._config.parent === 'string') {

            return elem.getAttribute('data-parent') === _this._config.parent;

          }



          return elem.classList.contains(CLASS_NAME_COLLAPSE);

        });



        if (actives.length === 0) {

          actives = null;

        }

      }



      if (actives) {

        activesData = $(actives).not(this._selector).data(DATA_KEY$3);



        if (activesData && activesData._isTransitioning) {

          return;

        }

      }



      var startEvent = $.Event(EVENT_SHOW);

      $(this._element).trigger(startEvent);



      if (startEvent.isDefaultPrevented()) {

        return;

      }



      if (actives) {

        Collapse._jQueryInterface.call($(actives).not(this._selector), 'hide');



        if (!activesData) {

          $(actives).data(DATA_KEY$3, null);

        }

      }



      var dimension = this._getDimension();



      $(this._element).removeClass(CLASS_NAME_COLLAPSE).addClass(CLASS_NAME_COLLAPSING);

      this._element.style[dimension] = 0;



      if (this._triggerArray.length) {

        $(this._triggerArray).removeClass(CLASS_NAME_COLLAPSED).attr('aria-expanded', true);

      }



      this.setTransitioning(true);



      var complete = function complete() {

        $(_this._element).removeClass(CLASS_NAME_COLLAPSING).addClass(CLASS_NAME_COLLAPSE + " " + CLASS_NAME_SHOW$1);

        _this._element.style[dimension] = '';



        _this.setTransitioning(false);



        $(_this._element).trigger(EVENT_SHOWN);

      };



      var capitalizedDimension = dimension[0].toUpperCase() + dimension.slice(1);

      var scrollSize = "scroll" + capitalizedDimension;

      var transitionDuration = Util.getTransitionDurationFromElement(this._element);

      $(this._element).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);

      this._element.style[dimension] = this._element[scrollSize] + "px";

    };



    _proto.hide = function hide() {

      var _this2 = this;



      if (this._isTransitioning || !$(this._element).hasClass(CLASS_NAME_SHOW$1)) {

        return;

      }



      var startEvent = $.Event(EVENT_HIDE);

      $(this._element).trigger(startEvent);



      if (startEvent.isDefaultPrevented()) {

        return;

      }



      var dimension = this._getDimension();



      this._element.style[dimension] = this._element.getBoundingClientRect()[dimension] + "px";

      Util.reflow(this._element);

      $(this._element).addClass(CLASS_NAME_COLLAPSING).removeClass(CLASS_NAME_COLLAPSE + " " + CLASS_NAME_SHOW$1);

      var triggerArrayLength = this._triggerArray.length;



      if (triggerArrayLength > 0) {

        for (var i = 0; i < triggerArrayLength; i++) {

          var trigger = this._triggerArray[i];

          var selector = Util.getSelectorFromElement(trigger);



          if (selector !== null) {

            var $elem = $([].slice.call(document.querySelectorAll(selector)));



            if (!$elem.hasClass(CLASS_NAME_SHOW$1)) {

              $(trigger).addClass(CLASS_NAME_COLLAPSED).attr('aria-expanded', false);

            }

          }

        }

      }



      this.setTransitioning(true);



      var complete = function complete() {

        _this2.setTransitioning(false);



        $(_this2._element).removeClass(CLASS_NAME_COLLAPSING).addClass(CLASS_NAME_COLLAPSE).trigger(EVENT_HIDDEN);

      };



      this._element.style[dimension] = '';

      var transitionDuration = Util.getTransitionDurationFromElement(this._element);

      $(this._element).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);

    };



    _proto.setTransitioning = function setTransitioning(isTransitioning) {

      this._isTransitioning = isTransitioning;

    };



    _proto.dispose = function dispose() {

      $.removeData(this._element, DATA_KEY$3);

      this._config = null;

      this._parent = null;

      this._element = null;

      this._triggerArray = null;

      this._isTransitioning = null;

    } // Private

    ;



    _proto._getConfig = function _getConfig(config) {

      config = _extends({}, Default$1, config);

      config.toggle = Boolean(config.toggle); // Coerce string values



      Util.typeCheckConfig(NAME$3, config, DefaultType$1);

      return config;

    };



    _proto._getDimension = function _getDimension() {

      var hasWidth = $(this._element).hasClass(DIMENSION_WIDTH);

      return hasWidth ? DIMENSION_WIDTH : DIMENSION_HEIGHT;

    };



    _proto._getParent = function _getParent() {

      var _this3 = this;



      var parent;



      if (Util.isElement(this._config.parent)) {

        parent = this._config.parent; // It's a jQuery object



        if (typeof this._config.parent.jquery !== 'undefined') {

          parent = this._config.parent[0];

        }

      } else {

        parent = document.querySelector(this._config.parent);

      }



      var selector = "[data-toggle=\"collapse\"][data-parent=\"" + this._config.parent + "\"]";

      var children = [].slice.call(parent.querySelectorAll(selector));

      $(children).each(function (i, element) {

        _this3._addAriaAndCollapsedClass(Collapse._getTargetFromElement(element), [element]);

      });

      return parent;

    };



    _proto._addAriaAndCollapsedClass = function _addAriaAndCollapsedClass(element, triggerArray) {

      var isOpen = $(element).hasClass(CLASS_NAME_SHOW$1);



      if (triggerArray.length) {

        $(triggerArray).toggleClass(CLASS_NAME_COLLAPSED, !isOpen).attr('aria-expanded', isOpen);

      }

    } // Static

    ;



    Collapse._getTargetFromElement = function _getTargetFromElement(element) {

      var selector = Util.getSelectorFromElement(element);

      return selector ? document.querySelector(selector) : null;

    };



    Collapse._jQueryInterface = function _jQueryInterface(config) {

      return this.each(function () {

        var $this = $(this);

        var data = $this.data(DATA_KEY$3);



        var _config = _extends({}, Default$1, $this.data(), typeof config === 'object' && config ? config : {});



        if (!data && _config.toggle && typeof config === 'string' && /show|hide/.test(config)) {

          _config.toggle = false;

        }



        if (!data) {

          data = new Collapse(this, _config);

          $this.data(DATA_KEY$3, data);

        }



        if (typeof config === 'string') {

          if (typeof data[config] === 'undefined') {

            throw new TypeError("No method named \"" + config + "\"");

          }



          data[config]();

        }

      });

    };



    _createClass(Collapse, null, [{

      key: "VERSION",

      get: function get() {

        return VERSION$3;

      }

    }, {

      key: "Default",

      get: function get() {

        return Default$1;

      }

    }]);



    return Collapse;

  }();

  /**

   * ------------------------------------------------------------------------

   * Data Api implementation

   * ------------------------------------------------------------------------

   */





  $(document).on(EVENT_CLICK_DATA_API$3, SELECTOR_DATA_TOGGLE$1, function (event) {

    // preventDefault only for <a> elements (which change the URL) not inside the collapsible element

    if (event.currentTarget.tagName === 'A') {

      event.preventDefault();

    }



    var $trigger = $(this);

    var selector = Util.getSelectorFromElement(this);

    var selectors = [].slice.call(document.querySelectorAll(selector));

    $(selectors).each(function () {

      var $target = $(this);

      var data = $target.data(DATA_KEY$3);

      var config = data ? 'toggle' : $trigger.data();



      Collapse._jQueryInterface.call($target, config);

    });

  });

  /**

   * ------------------------------------------------------------------------

   * jQuery

   * ------------------------------------------------------------------------

   */



  $.fn[NAME$3] = Collapse._jQueryInterface;

  $.fn[NAME$3].Constructor = Collapse;



  $.fn[NAME$3].noConflict = function () {

    $.fn[NAME$3] = JQUERY_NO_CONFLICT$3;

    return Collapse._jQueryInterface;

  };



  /**

   * ------------------------------------------------------------------------

   * Constants

   * ------------------------------------------------------------------------

   */



  var NAME$4 = 'dropdown';

  var VERSION$4 = '4.5.2';

  var DATA_KEY$4 = 'bs.dropdown';

  var EVENT_KEY$4 = "." + DATA_KEY$4;

  var DATA_API_KEY$4 = '.data-api';

  var JQUERY_NO_CONFLICT$4 = $.fn[NAME$4];

  var ESCAPE_KEYCODE = 27; // KeyboardEvent.which value for Escape (Esc) key



  var SPACE_KEYCODE = 32; // KeyboardEvent.which value for space key



  var TAB_KEYCODE = 9; // KeyboardEvent.which value for tab key



  var ARROW_UP_KEYCODE = 38; // KeyboardEvent.which value for up arrow key



  var ARROW_DOWN_KEYCODE = 40; // KeyboardEvent.which value for down arrow key



  var RIGHT_MOUSE_BUTTON_WHICH = 3; // MouseEvent.which value for the right button (assuming a right-handed mouse)



  var REGEXP_KEYDOWN = new RegExp(ARROW_UP_KEYCODE + "|" + ARROW_DOWN_KEYCODE + "|" + ESCAPE_KEYCODE);

  var EVENT_HIDE$1 = "hide" + EVENT_KEY$4;

  var EVENT_HIDDEN$1 = "hidden" + EVENT_KEY$4;

  var EVENT_SHOW$1 = "show" + EVENT_KEY$4;

  var EVENT_SHOWN$1 = "shown" + EVENT_KEY$4;

  var EVENT_CLICK = "click" + EVENT_KEY$4;

  var EVENT_CLICK_DATA_API$4 = "click" + EVENT_KEY$4 + DATA_API_KEY$4;

  var EVENT_KEYDOWN_DATA_API = "keydown" + EVENT_KEY$4 + DATA_API_KEY$4;

  var EVENT_KEYUP_DATA_API = "keyup" + EVENT_KEY$4 + DATA_API_KEY$4;

  var CLASS_NAME_DISABLED = 'disabled';

  var CLASS_NAME_SHOW$2 = 'show';

  var CLASS_NAME_DROPUP = 'dropup';

  var CLASS_NAME_DROPRIGHT = 'dropright';

  var CLASS_NAME_DROPLEFT = 'dropleft';

  var CLASS_NAME_MENURIGHT = 'dropdown-menu-right';

  var CLASS_NAME_POSITION_STATIC = 'position-static';

  var SELECTOR_DATA_TOGGLE$2 = '[data-toggle="dropdown"]';

  var SELECTOR_FORM_CHILD = '.dropdown form';

  var SELECTOR_MENU = '.dropdown-menu';

  var SELECTOR_NAVBAR_NAV = '.navbar-nav';

  var SELECTOR_VISIBLE_ITEMS = '.dropdown-menu .dropdown-item:not(.disabled):not(:disabled)';

  var PLACEMENT_TOP = 'top-start';

  var PLACEMENT_TOPEND = 'top-end';

  var PLACEMENT_BOTTOM = 'bottom-start';

  var PLACEMENT_BOTTOMEND = 'bottom-end';

  var PLACEMENT_RIGHT = 'right-start';

  var PLACEMENT_LEFT = 'left-start';

  var Default$2 = {

    offset: 0,

    flip: true,

    boundary: 'scrollParent',

    reference: 'toggle',

    display: 'dynamic',

    popperConfig: null

  };

  var DefaultType$2 = {

    offset: '(number|string|function)',

    flip: 'boolean',

    boundary: '(string|element)',

    reference: '(string|element)',

    display: 'string',

    popperConfig: '(null|object)'

  };

  /**

   * ------------------------------------------------------------------------

   * Class Definition

   * ------------------------------------------------------------------------

   */



  var Dropdown = /*#__PURE__*/function () {

    function Dropdown(element, config) {

      this._element = element;

      this._popper = null;

      this._config = this._getConfig(config);

      this._menu = this._getMenuElement();

      this._inNavbar = this._detectNavbar();



      this._addEventListeners();

    } // Getters





    var _proto = Dropdown.prototype;



    // Public

    _proto.toggle = function toggle() {

      if (this._element.disabled || $(this._element).hasClass(CLASS_NAME_DISABLED)) {

        return;

      }



      var isActive = $(this._menu).hasClass(CLASS_NAME_SHOW$2);



      Dropdown._clearMenus();



      if (isActive) {

        return;

      }



      this.show(true);

    };



    _proto.show = function show(usePopper) {

      if (usePopper === void 0) {

        usePopper = false;

      }



      if (this._element.disabled || $(this._element).hasClass(CLASS_NAME_DISABLED) || $(this._menu).hasClass(CLASS_NAME_SHOW$2)) {

        return;

      }



      var relatedTarget = {

        relatedTarget: this._element

      };

      var showEvent = $.Event(EVENT_SHOW$1, relatedTarget);



      var parent = Dropdown._getParentFromElement(this._element);



      $(parent).trigger(showEvent);



      if (showEvent.isDefaultPrevented()) {

        return;

      } // Disable totally Popper.js for Dropdown in Navbar





      if (!this._inNavbar && usePopper) {

        /**

         * Check for Popper dependency

         * Popper - https://popper.js.org

         */

        if (typeof Popper === 'undefined') {

          throw new TypeError('Bootstrap\'s dropdowns require Popper.js (https://popper.js.org/)');

        }



        var referenceElement = this._element;



        if (this._config.reference === 'parent') {

          referenceElement = parent;

        } else if (Util.isElement(this._config.reference)) {

          referenceElement = this._config.reference; // Check if it's jQuery element



          if (typeof this._config.reference.jquery !== 'undefined') {

            referenceElement = this._config.reference[0];

          }

        } // If boundary is not `scrollParent`, then set position to `static`

        // to allow the menu to "escape" the scroll parent's boundaries

        // https://github.com/twbs/bootstrap/issues/24251





        if (this._config.boundary !== 'scrollParent') {

          $(parent).addClass(CLASS_NAME_POSITION_STATIC);

        }



        this._popper = new Popper(referenceElement, this._menu, this._getPopperConfig());

      } // If this is a touch-enabled device we add extra

      // empty mouseover listeners to the body's immediate children;

      // only needed because of broken event delegation on iOS

      // https://www.quirksmode.org/blog/archives/2014/02/mouse_event_bub.html





      if ('ontouchstart' in document.documentElement && $(parent).closest(SELECTOR_NAVBAR_NAV).length === 0) {

        $(document.body).children().on('mouseover', null, $.noop);

      }



      this._element.focus();



      this._element.setAttribute('aria-expanded', true);



      $(this._menu).toggleClass(CLASS_NAME_SHOW$2);

      $(parent).toggleClass(CLASS_NAME_SHOW$2).trigger($.Event(EVENT_SHOWN$1, relatedTarget));

    };



    _proto.hide = function hide() {

      if (this._element.disabled || $(this._element).hasClass(CLASS_NAME_DISABLED) || !$(this._menu).hasClass(CLASS_NAME_SHOW$2)) {

        return;

      }



      var relatedTarget = {

        relatedTarget: this._element

      };

      var hideEvent = $.Event(EVENT_HIDE$1, relatedTarget);



      var parent = Dropdown._getParentFromElement(this._element);



      $(parent).trigger(hideEvent);



      if (hideEvent.isDefaultPrevented()) {

        return;

      }



      if (this._popper) {

        this._popper.destroy();

      }



      $(this._menu).toggleClass(CLASS_NAME_SHOW$2);

      $(parent).toggleClass(CLASS_NAME_SHOW$2).trigger($.Event(EVENT_HIDDEN$1, relatedTarget));

    };



    _proto.dispose = function dispose() {

      $.removeData(this._element, DATA_KEY$4);

      $(this._element).off(EVENT_KEY$4);

      this._element = null;

      this._menu = null;



      if (this._popper !== null) {

        this._popper.destroy();



        this._popper = null;

      }

    };



    _proto.update = function update() {

      this._inNavbar = this._detectNavbar();



      if (this._popper !== null) {

        this._popper.scheduleUpdate();

      }

    } // Private

    ;



    _proto._addEventListeners = function _addEventListeners() {

      var _this = this;



      $(this._element).on(EVENT_CLICK, function (event) {

        event.preventDefault();

        event.stopPropagation();



        _this.toggle();

      });

    };



    _proto._getConfig = function _getConfig(config) {

      config = _extends({}, this.constructor.Default, $(this._element).data(), config);

      Util.typeCheckConfig(NAME$4, config, this.constructor.DefaultType);

      return config;

    };



    _proto._getMenuElement = function _getMenuElement() {

      if (!this._menu) {

        var parent = Dropdown._getParentFromElement(this._element);



        if (parent) {

          this._menu = parent.querySelector(SELECTOR_MENU);

        }

      }



      return this._menu;

    };



    _proto._getPlacement = function _getPlacement() {

      var $parentDropdown = $(this._element.parentNode);

      var placement = PLACEMENT_BOTTOM; // Handle dropup



      if ($parentDropdown.hasClass(CLASS_NAME_DROPUP)) {

        placement = $(this._menu).hasClass(CLASS_NAME_MENURIGHT) ? PLACEMENT_TOPEND : PLACEMENT_TOP;

      } else if ($parentDropdown.hasClass(CLASS_NAME_DROPRIGHT)) {

        placement = PLACEMENT_RIGHT;

      } else if ($parentDropdown.hasClass(CLASS_NAME_DROPLEFT)) {

        placement = PLACEMENT_LEFT;

      } else if ($(this._menu).hasClass(CLASS_NAME_MENURIGHT)) {

        placement = PLACEMENT_BOTTOMEND;

      }



      return placement;

    };



    _proto._detectNavbar = function _detectNavbar() {

      return $(this._element).closest('.navbar').length > 0;

    };



    _proto._getOffset = function _getOffset() {

      var _this2 = this;



      var offset = {};



      if (typeof this._config.offset === 'function') {

        offset.fn = function (data) {

          data.offsets = _extends({}, data.offsets, _this2._config.offset(data.offsets, _this2._element) || {});

          return data;

        };

      } else {

        offset.offset = this._config.offset;

      }



      return offset;

    };



    _proto._getPopperConfig = function _getPopperConfig() {

      var popperConfig = {

        placement: this._getPlacement(),

        modifiers: {

          offset: this._getOffset(),

          flip: {

            enabled: this._config.flip

          },

          preventOverflow: {

            boundariesElement: this._config.boundary

          }

        }

      }; // Disable Popper.js if we have a static display



      if (this._config.display === 'static') {

        popperConfig.modifiers.applyStyle = {

          enabled: false

        };

      }



      return _extends({}, popperConfig, this._config.popperConfig);

    } // Static

    ;



    Dropdown._jQueryInterface = function _jQueryInterface(config) {

      return this.each(function () {

        var data = $(this).data(DATA_KEY$4);



        var _config = typeof config === 'object' ? config : null;



        if (!data) {

          data = new Dropdown(this, _config);

          $(this).data(DATA_KEY$4, data);

        }



        if (typeof config === 'string') {

          if (typeof data[config] === 'undefined') {

            throw new TypeError("No method named \"" + config + "\"");

          }



          data[config]();

        }

      });

    };



    Dropdown._clearMenus = function _clearMenus(event) {

      if (event && (event.which === RIGHT_MOUSE_BUTTON_WHICH || event.type === 'keyup' && event.which !== TAB_KEYCODE)) {

        return;

      }



      var toggles = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLE$2));



      for (var i = 0, len = toggles.length; i < len; i++) {

        var parent = Dropdown._getParentFromElement(toggles[i]);



        var context = $(toggles[i]).data(DATA_KEY$4);

        var relatedTarget = {

          relatedTarget: toggles[i]

        };



        if (event && event.type === 'click') {

          relatedTarget.clickEvent = event;

        }



        if (!context) {

          continue;

        }



        var dropdownMenu = context._menu;



        if (!$(parent).hasClass(CLASS_NAME_SHOW$2)) {

          continue;

        }



        if (event && (event.type === 'click' && /input|textarea/i.test(event.target.tagName) || event.type === 'keyup' && event.which === TAB_KEYCODE) && $.contains(parent, event.target)) {

          continue;

        }



        var hideEvent = $.Event(EVENT_HIDE$1, relatedTarget);

        $(parent).trigger(hideEvent);



        if (hideEvent.isDefaultPrevented()) {

          continue;

        } // If this is a touch-enabled device we remove the extra

        // empty mouseover listeners we added for iOS support





        if ('ontouchstart' in document.documentElement) {

          $(document.body).children().off('mouseover', null, $.noop);

        }



        toggles[i].setAttribute('aria-expanded', 'false');



        if (context._popper) {

          context._popper.destroy();

        }



        $(dropdownMenu).removeClass(CLASS_NAME_SHOW$2);

        $(parent).removeClass(CLASS_NAME_SHOW$2).trigger($.Event(EVENT_HIDDEN$1, relatedTarget));

      }

    };



    Dropdown._getParentFromElement = function _getParentFromElement(element) {

      var parent;

      var selector = Util.getSelectorFromElement(element);



      if (selector) {

        parent = document.querySelector(selector);

      }



      return parent || element.parentNode;

    } // eslint-disable-next-line complexity

    ;



    Dropdown._dataApiKeydownHandler = function _dataApiKeydownHandler(event) {

      // If not input/textarea:

      //  - And not a key in REGEXP_KEYDOWN => not a dropdown command

      // If input/textarea:

      //  - If space key => not a dropdown command

      //  - If key is other than escape

      //    - If key is not up or down => not a dropdown command

      //    - If trigger inside the menu => not a dropdown command

      if (/input|textarea/i.test(event.target.tagName) ? event.which === SPACE_KEYCODE || event.which !== ESCAPE_KEYCODE && (event.which !== ARROW_DOWN_KEYCODE && event.which !== ARROW_UP_KEYCODE || $(event.target).closest(SELECTOR_MENU).length) : !REGEXP_KEYDOWN.test(event.which)) {

        return;

      }



      if (this.disabled || $(this).hasClass(CLASS_NAME_DISABLED)) {

        return;

      }



      var parent = Dropdown._getParentFromElement(this);



      var isActive = $(parent).hasClass(CLASS_NAME_SHOW$2);



      if (!isActive && event.which === ESCAPE_KEYCODE) {

        return;

      }



      event.preventDefault();

      event.stopPropagation();



      if (!isActive || isActive && (event.which === ESCAPE_KEYCODE || event.which === SPACE_KEYCODE)) {

        if (event.which === ESCAPE_KEYCODE) {

          $(parent.querySelector(SELECTOR_DATA_TOGGLE$2)).trigger('focus');

        }



        $(this).trigger('click');

        return;

      }



      var items = [].slice.call(parent.querySelectorAll(SELECTOR_VISIBLE_ITEMS)).filter(function (item) {

        return $(item).is(':visible');

      });



      if (items.length === 0) {

        return;

      }



      var index = items.indexOf(event.target);



      if (event.which === ARROW_UP_KEYCODE && index > 0) {

        // Up

        index--;

      }



      if (event.which === ARROW_DOWN_KEYCODE && index < items.length - 1) {

        // Down

        index++;

      }



      if (index < 0) {

        index = 0;

      }



      items[index].focus();

    };



    _createClass(Dropdown, null, [{

      key: "VERSION",

      get: function get() {

        return VERSION$4;

      }

    }, {

      key: "Default",

      get: function get() {

        return Default$2;

      }

    }, {

      key: "DefaultType",

      get: function get() {

        return DefaultType$2;

      }

    }]);



    return Dropdown;

  }();

  /**

   * ------------------------------------------------------------------------

   * Data Api implementation

   * ------------------------------------------------------------------------

   */





  $(document).on(EVENT_KEYDOWN_DATA_API, SELECTOR_DATA_TOGGLE$2, Dropdown._dataApiKeydownHandler).on(EVENT_KEYDOWN_DATA_API, SELECTOR_MENU, Dropdown._dataApiKeydownHandler).on(EVENT_CLICK_DATA_API$4 + " " + EVENT_KEYUP_DATA_API, Dropdown._clearMenus).on(EVENT_CLICK_DATA_API$4, SELECTOR_DATA_TOGGLE$2, function (event) {

    event.preventDefault();

    event.stopPropagation();



    Dropdown._jQueryInterface.call($(this), 'toggle');

  }).on(EVENT_CLICK_DATA_API$4, SELECTOR_FORM_CHILD, function (e) {

    e.stopPropagation();

  });

  /**

   * ------------------------------------------------------------------------

   * jQuery

   * ------------------------------------------------------------------------

   */



  $.fn[NAME$4] = Dropdown._jQueryInterface;

  $.fn[NAME$4].Constructor = Dropdown;



  $.fn[NAME$4].noConflict = function () {

    $.fn[NAME$4] = JQUERY_NO_CONFLICT$4;

    return Dropdown._jQueryInterface;

  };



  /**

   * ------------------------------------------------------------------------

   * Constants

   * ------------------------------------------------------------------------

   */



  var NAME$5 = 'modal';

  var VERSION$5 = '4.5.2';

  var DATA_KEY$5 = 'bs.modal';

  var EVENT_KEY$5 = "." + DATA_KEY$5;

  var DATA_API_KEY$5 = '.data-api';

  var JQUERY_NO_CONFLICT$5 = $.fn[NAME$5];

  var ESCAPE_KEYCODE$1 = 27; // KeyboardEvent.which value for Escape (Esc) key



  var Default$3 = {

    backdrop: true,

    keyboard: true,

    focus: true,

    show: true

  };

  var DefaultType$3 = {

    backdrop: '(boolean|string)',

    keyboard: 'boolean',

    focus: 'boolean',

    show: 'boolean'

  };

  var EVENT_HIDE$2 = "hide" + EVENT_KEY$5;

  var EVENT_HIDE_PREVENTED = "hidePrevented" + EVENT_KEY$5;

  var EVENT_HIDDEN$2 = "hidden" + EVENT_KEY$5;

  var EVENT_SHOW$2 = "show" + EVENT_KEY$5;

  var EVENT_SHOWN$2 = "shown" + EVENT_KEY$5;

  var EVENT_FOCUSIN = "focusin" + EVENT_KEY$5;

  var EVENT_RESIZE = "resize" + EVENT_KEY$5;

  var EVENT_CLICK_DISMISS = "click.dismiss" + EVENT_KEY$5;

  var EVENT_KEYDOWN_DISMISS = "keydown.dismiss" + EVENT_KEY$5;

  var EVENT_MOUSEUP_DISMISS = "mouseup.dismiss" + EVENT_KEY$5;

  var EVENT_MOUSEDOWN_DISMISS = "mousedown.dismiss" + EVENT_KEY$5;

  var EVENT_CLICK_DATA_API$5 = "click" + EVENT_KEY$5 + DATA_API_KEY$5;

  var CLASS_NAME_SCROLLABLE = 'modal-dialog-scrollable';

  var CLASS_NAME_SCROLLBAR_MEASURER = 'modal-scrollbar-measure';

  var CLASS_NAME_BACKDROP = 'modal-backdrop';

  var CLASS_NAME_OPEN = 'modal-open';

  var CLASS_NAME_FADE$1 = 'fade';

  var CLASS_NAME_SHOW$3 = 'show';

  var CLASS_NAME_STATIC = 'modal-static';

  var SELECTOR_DIALOG = '.modal-dialog';

  var SELECTOR_MODAL_BODY = '.modal-body';

  var SELECTOR_DATA_TOGGLE$3 = '[data-toggle="modal"]';

  var SELECTOR_DATA_DISMISS = '[data-dismiss="modal"]';

  var SELECTOR_FIXED_CONTENT = '.fixed-top, .fixed-bottom, .is-fixed, .sticky-top';

  var SELECTOR_STICKY_CONTENT = '.sticky-top';

  /**

   * ------------------------------------------------------------------------

   * Class Definition

   * ------------------------------------------------------------------------

   */



  var Modal = /*#__PURE__*/function () {

    function Modal(element, config) {

      this._config = this._getConfig(config);

      this._element = element;

      this._dialog = element.querySelector(SELECTOR_DIALOG);

      this._backdrop = null;

      this._isShown = false;

      this._isBodyOverflowing = false;

      this._ignoreBackdropClick = false;

      this._isTransitioning = false;

      this._scrollbarWidth = 0;

    } // Getters





    var _proto = Modal.prototype;



    // Public

    _proto.toggle = function toggle(relatedTarget) {

      return this._isShown ? this.hide() : this.show(relatedTarget);

    };



    _proto.show = function show(relatedTarget) {

      var _this = this;



      if (this._isShown || this._isTransitioning) {

        return;

      }



      if ($(this._element).hasClass(CLASS_NAME_FADE$1)) {

        this._isTransitioning = true;

      }



      var showEvent = $.Event(EVENT_SHOW$2, {

        relatedTarget: relatedTarget

      });

      $(this._element).trigger(showEvent);



      if (this._isShown || showEvent.isDefaultPrevented()) {

        return;

      }



      this._isShown = true;



      this._checkScrollbar();



      this._setScrollbar();



      this._adjustDialog();



      this._setEscapeEvent();



      this._setResizeEvent();



      $(this._element).on(EVENT_CLICK_DISMISS, SELECTOR_DATA_DISMISS, function (event) {

        return _this.hide(event);

      });

      $(this._dialog).on(EVENT_MOUSEDOWN_DISMISS, function () {

        $(_this._element).one(EVENT_MOUSEUP_DISMISS, function (event) {

          if ($(event.target).is(_this._element)) {

            _this._ignoreBackdropClick = true;

          }

        });

      });



      this._showBackdrop(function () {

        return _this._showElement(relatedTarget);

      });

    };



    _proto.hide = function hide(event) {

      var _this2 = this;



      if (event) {

        event.preventDefault();

      }



      if (!this._isShown || this._isTransitioning) {

        return;

      }



      var hideEvent = $.Event(EVENT_HIDE$2);

      $(this._element).trigger(hideEvent);



      if (!this._isShown || hideEvent.isDefaultPrevented()) {

        return;

      }



      this._isShown = false;

      var transition = $(this._element).hasClass(CLASS_NAME_FADE$1);



      if (transition) {

        this._isTransitioning = true;

      }



      this._setEscapeEvent();



      this._setResizeEvent();



      $(document).off(EVENT_FOCUSIN);

      $(this._element).removeClass(CLASS_NAME_SHOW$3);

      $(this._element).off(EVENT_CLICK_DISMISS);

      $(this._dialog).off(EVENT_MOUSEDOWN_DISMISS);



      if (transition) {

        var transitionDuration = Util.getTransitionDurationFromElement(this._element);

        $(this._element).one(Util.TRANSITION_END, function (event) {

          return _this2._hideModal(event);

        }).emulateTransitionEnd(transitionDuration);

      } else {

        this._hideModal();

      }

    };



    _proto.dispose = function dispose() {

      [window, this._element, this._dialog].forEach(function (htmlElement) {

        return $(htmlElement).off(EVENT_KEY$5);

      });

      /**

       * `document` has 2 events `EVENT_FOCUSIN` and `EVENT_CLICK_DATA_API`

       * Do not move `document` in `htmlElements` array

       * It will remove `EVENT_CLICK_DATA_API` event that should remain

       */



      $(document).off(EVENT_FOCUSIN);

      $.removeData(this._element, DATA_KEY$5);

      this._config = null;

      this._element = null;

      this._dialog = null;

      this._backdrop = null;

      this._isShown = null;

      this._isBodyOverflowing = null;

      this._ignoreBackdropClick = null;

      this._isTransitioning = null;

      this._scrollbarWidth = null;

    };



    _proto.handleUpdate = function handleUpdate() {

      this._adjustDialog();

    } // Private

    ;



    _proto._getConfig = function _getConfig(config) {

      config = _extends({}, Default$3, config);

      Util.typeCheckConfig(NAME$5, config, DefaultType$3);

      return config;

    };



    _proto._triggerBackdropTransition = function _triggerBackdropTransition() {

      var _this3 = this;



      if (this._config.backdrop === 'static') {

        var hideEventPrevented = $.Event(EVENT_HIDE_PREVENTED);

        $(this._element).trigger(hideEventPrevented);



        if (hideEventPrevented.defaultPrevented) {

          return;

        }



        var isModalOverflowing = this._element.scrollHeight > document.documentElement.clientHeight;



        if (!isModalOverflowing) {

          this._element.style.overflowY = 'hidden';

        }



        this._element.classList.add(CLASS_NAME_STATIC);



        var modalTransitionDuration = Util.getTransitionDurationFromElement(this._dialog);

        $(this._element).off(Util.TRANSITION_END);

        $(this._element).one(Util.TRANSITION_END, function () {

          _this3._element.classList.remove(CLASS_NAME_STATIC);



          if (!isModalOverflowing) {

            $(_this3._element).one(Util.TRANSITION_END, function () {

              _this3._element.style.overflowY = '';

            }).emulateTransitionEnd(_this3._element, modalTransitionDuration);

          }

        }).emulateTransitionEnd(modalTransitionDuration);



        this._element.focus();

      } else {

        this.hide();

      }

    };



    _proto._showElement = function _showElement(relatedTarget) {

      var _this4 = this;



      var transition = $(this._element).hasClass(CLASS_NAME_FADE$1);

      var modalBody = this._dialog ? this._dialog.querySelector(SELECTOR_MODAL_BODY) : null;



      if (!this._element.parentNode || this._element.parentNode.nodeType !== Node.ELEMENT_NODE) {

        // Don't move modal's DOM position

        document.body.appendChild(this._element);

      }



      this._element.style.display = 'block';



      this._element.removeAttribute('aria-hidden');



      this._element.setAttribute('aria-modal', true);



      this._element.setAttribute('role', 'dialog');



      if ($(this._dialog).hasClass(CLASS_NAME_SCROLLABLE) && modalBody) {

        modalBody.scrollTop = 0;

      } else {

        this._element.scrollTop = 0;

      }



      if (transition) {

        Util.reflow(this._element);

      }



      $(this._element).addClass(CLASS_NAME_SHOW$3);



      if (this._config.focus) {

        this._enforceFocus();

      }



      var shownEvent = $.Event(EVENT_SHOWN$2, {

        relatedTarget: relatedTarget

      });



      var transitionComplete = function transitionComplete() {

        if (_this4._config.focus) {

          _this4._element.focus();

        }



        _this4._isTransitioning = false;

        $(_this4._element).trigger(shownEvent);

      };



      if (transition) {

        var transitionDuration = Util.getTransitionDurationFromElement(this._dialog);

        $(this._dialog).one(Util.TRANSITION_END, transitionComplete).emulateTransitionEnd(transitionDuration);

      } else {

        transitionComplete();

      }

    };



    _proto._enforceFocus = function _enforceFocus() {

      var _this5 = this;



      $(document).off(EVENT_FOCUSIN) // Guard against infinite focus loop

      .on(EVENT_FOCUSIN, function (event) {

        if (document !== event.target && _this5._element !== event.target && $(_this5._element).has(event.target).length === 0) {

          _this5._element.focus();

        }

      });

    };



    _proto._setEscapeEvent = function _setEscapeEvent() {

      var _this6 = this;



      if (this._isShown) {

        $(this._element).on(EVENT_KEYDOWN_DISMISS, function (event) {

          if (_this6._config.keyboard && event.which === ESCAPE_KEYCODE$1) {

            event.preventDefault();



            _this6.hide();

          } else if (!_this6._config.keyboard && event.which === ESCAPE_KEYCODE$1) {

            _this6._triggerBackdropTransition();

          }

        });

      } else if (!this._isShown) {

        $(this._element).off(EVENT_KEYDOWN_DISMISS);

      }

    };



    _proto._setResizeEvent = function _setResizeEvent() {

      var _this7 = this;



      if (this._isShown) {

        $(window).on(EVENT_RESIZE, function (event) {

          return _this7.handleUpdate(event);

        });

      } else {

        $(window).off(EVENT_RESIZE);

      }

    };



    _proto._hideModal = function _hideModal() {

      var _this8 = this;



      this._element.style.display = 'none';



      this._element.setAttribute('aria-hidden', true);



      this._element.removeAttribute('aria-modal');



      this._element.removeAttribute('role');



      this._isTransitioning = false;



      this._showBackdrop(function () {

        $(document.body).removeClass(CLASS_NAME_OPEN);



        _this8._resetAdjustments();



        _this8._resetScrollbar();



        $(_this8._element).trigger(EVENT_HIDDEN$2);

      });

    };



    _proto._removeBackdrop = function _removeBackdrop() {

      if (this._backdrop) {

        $(this._backdrop).remove();

        this._backdrop = null;

      }

    };



    _proto._showBackdrop = function _showBackdrop(callback) {

      var _this9 = this;



      var animate = $(this._element).hasClass(CLASS_NAME_FADE$1) ? CLASS_NAME_FADE$1 : '';



      if (this._isShown && this._config.backdrop) {

        this._backdrop = document.createElement('div');

        this._backdrop.className = CLASS_NAME_BACKDROP;



        if (animate) {

          this._backdrop.classList.add(animate);

        }



        $(this._backdrop).appendTo(document.body);

        $(this._element).on(EVENT_CLICK_DISMISS, function (event) {

          if (_this9._ignoreBackdropClick) {

            _this9._ignoreBackdropClick = false;

            return;

          }



          if (event.target !== event.currentTarget) {

            return;

          }



          _this9._triggerBackdropTransition();

        });



        if (animate) {

          Util.reflow(this._backdrop);

        }



        $(this._backdrop).addClass(CLASS_NAME_SHOW$3);



        if (!callback) {

          return;

        }



        if (!animate) {

          callback();

          return;

        }



        var backdropTransitionDuration = Util.getTransitionDurationFromElement(this._backdrop);

        $(this._backdrop).one(Util.TRANSITION_END, callback).emulateTransitionEnd(backdropTransitionDuration);

      } else if (!this._isShown && this._backdrop) {

        $(this._backdrop).removeClass(CLASS_NAME_SHOW$3);



        var callbackRemove = function callbackRemove() {

          _this9._removeBackdrop();



          if (callback) {

            callback();

          }

        };



        if ($(this._element).hasClass(CLASS_NAME_FADE$1)) {

          var _backdropTransitionDuration = Util.getTransitionDurationFromElement(this._backdrop);



          $(this._backdrop).one(Util.TRANSITION_END, callbackRemove).emulateTransitionEnd(_backdropTransitionDuration);

        } else {

          callbackRemove();

        }

      } else if (callback) {

        callback();

      }

    } // ----------------------------------------------------------------------

    // the following methods are used to handle overflowing modals

    // todo (fat): these should probably be refactored out of modal.js

    // ----------------------------------------------------------------------

    ;



    _proto._adjustDialog = function _adjustDialog() {

      var isModalOverflowing = this._element.scrollHeight > document.documentElement.clientHeight;



      if (!this._isBodyOverflowing && isModalOverflowing) {

        this._element.style.paddingLeft = this._scrollbarWidth + "px";

      }



      if (this._isBodyOverflowing && !isModalOverflowing) {

        this._element.style.paddingRight = this._scrollbarWidth + "px";

      }

    };



    _proto._resetAdjustments = function _resetAdjustments() {

      this._element.style.paddingLeft = '';

      this._element.style.paddingRight = '';

    };



    _proto._checkScrollbar = function _checkScrollbar() {

      var rect = document.body.getBoundingClientRect();

      this._isBodyOverflowing = Math.round(rect.left + rect.right) < window.innerWidth;

      this._scrollbarWidth = this._getScrollbarWidth();

    };



    _proto._setScrollbar = function _setScrollbar() {

      var _this10 = this;



      if (this._isBodyOverflowing) {

        // Note: DOMNode.style.paddingRight returns the actual value or '' if not set

        //   while $(DOMNode).css('padding-right') returns the calculated value or 0 if not set

        var fixedContent = [].slice.call(document.querySelectorAll(SELECTOR_FIXED_CONTENT));

        var stickyContent = [].slice.call(document.querySelectorAll(SELECTOR_STICKY_CONTENT)); // Adjust fixed content padding



        $(fixedContent).each(function (index, element) {

          var actualPadding = element.style.paddingRight;

          var calculatedPadding = $(element).css('padding-right');

          $(element).data('padding-right', actualPadding).css('padding-right', parseFloat(calculatedPadding) + _this10._scrollbarWidth + "px");

        }); // Adjust sticky content margin



        $(stickyContent).each(function (index, element) {

          var actualMargin = element.style.marginRight;

          var calculatedMargin = $(element).css('margin-right');

          $(element).data('margin-right', actualMargin).css('margin-right', parseFloat(calculatedMargin) - _this10._scrollbarWidth + "px");

        }); // Adjust body padding



        var actualPadding = document.body.style.paddingRight;

        var calculatedPadding = $(document.body).css('padding-right');

        $(document.body).data('padding-right', actualPadding).css('padding-right', parseFloat(calculatedPadding) + this._scrollbarWidth + "px");

      }



      $(document.body).addClass(CLASS_NAME_OPEN);

    };



    _proto._resetScrollbar = function _resetScrollbar() {

      // Restore fixed content padding

      var fixedContent = [].slice.call(document.querySelectorAll(SELECTOR_FIXED_CONTENT));

      $(fixedContent).each(function (index, element) {

        var padding = $(element).data('padding-right');

        $(element).removeData('padding-right');

        element.style.paddingRight = padding ? padding : '';

      }); // Restore sticky content



      var elements = [].slice.call(document.querySelectorAll("" + SELECTOR_STICKY_CONTENT));

      $(elements).each(function (index, element) {

        var margin = $(element).data('margin-right');



        if (typeof margin !== 'undefined') {

          $(element).css('margin-right', margin).removeData('margin-right');

        }

      }); // Restore body padding



      var padding = $(document.body).data('padding-right');

      $(document.body).removeData('padding-right');

      document.body.style.paddingRight = padding ? padding : '';

    };



    _proto._getScrollbarWidth = function _getScrollbarWidth() {

      // thx d.walsh

      var scrollDiv = document.createElement('div');

      scrollDiv.className = CLASS_NAME_SCROLLBAR_MEASURER;

      document.body.appendChild(scrollDiv);

      var scrollbarWidth = scrollDiv.getBoundingClientRect().width - scrollDiv.clientWidth;

      document.body.removeChild(scrollDiv);

      return scrollbarWidth;

    } // Static

    ;



    Modal._jQueryInterface = function _jQueryInterface(config, relatedTarget) {

      return this.each(function () {

        var data = $(this).data(DATA_KEY$5);



        var _config = _extends({}, Default$3, $(this).data(), typeof config === 'object' && config ? config : {});



        if (!data) {

          data = new Modal(this, _config);

          $(this).data(DATA_KEY$5, data);

        }



        if (typeof config === 'string') {

          if (typeof data[config] === 'undefined') {

            throw new TypeError("No method named \"" + config + "\"");

          }



          data[config](relatedTarget);

        } else if (_config.show) {

          data.show(relatedTarget);

        }

      });

    };



    _createClass(Modal, null, [{

      key: "VERSION",

      get: function get() {

        return VERSION$5;

      }

    }, {

      key: "Default",

      get: function get() {

        return Default$3;

      }

    }]);



    return Modal;

  }();

  /**

   * ------------------------------------------------------------------------

   * Data Api implementation

   * ------------------------------------------------------------------------

   */





  $(document).on(EVENT_CLICK_DATA_API$5, SELECTOR_DATA_TOGGLE$3, function (event) {

    var _this11 = this;



    var target;

    var selector = Util.getSelectorFromElement(this);



    if (selector) {

      target = document.querySelector(selector);

    }



    var config = $(target).data(DATA_KEY$5) ? 'toggle' : _extends({}, $(target).data(), $(this).data());



    if (this.tagName === 'A' || this.tagName === 'AREA') {

      event.preventDefault();

    }



    var $target = $(target).one(EVENT_SHOW$2, function (showEvent) {

      if (showEvent.isDefaultPrevented()) {

        // Only register focus restorer if modal will actually get shown

        return;

      }



      $target.one(EVENT_HIDDEN$2, function () {

        if ($(_this11).is(':visible')) {

          _this11.focus();

        }

      });

    });



    Modal._jQueryInterface.call($(target), config, this);

  });

  /**

   * ------------------------------------------------------------------------

   * jQuery

   * ------------------------------------------------------------------------

   */



  $.fn[NAME$5] = Modal._jQueryInterface;

  $.fn[NAME$5].Constructor = Modal;



  $.fn[NAME$5].noConflict = function () {

    $.fn[NAME$5] = JQUERY_NO_CONFLICT$5;

    return Modal._jQueryInterface;

  };



  /**

   * --------------------------------------------------------------------------

   * Bootstrap (v4.5.2): tools/sanitizer.js

   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)

   * --------------------------------------------------------------------------

   */

  var uriAttrs = ['background', 'cite', 'href', 'itemtype', 'longdesc', 'poster', 'src', 'xlink:href'];

  var ARIA_ATTRIBUTE_PATTERN = /^aria-[\w-]*$/i;

  var DefaultWhitelist = {

    // Global attributes allowed on any supplied element below.

    '*': ['class', 'dir', 'id', 'lang', 'role', ARIA_ATTRIBUTE_PATTERN],

    a: ['target', 'href', 'title', 'rel'],

    area: [],

    b: [],

    br: [],

    col: [],

    code: [],

    div: [],

    em: [],

    hr: [],

    h1: [],

    h2: [],

    h3: [],

    h4: [],

    h5: [],

    h6: [],

    i: [],

    img: ['src', 'srcset', 'alt', 'title', 'width', 'height'],

    li: [],

    ol: [],

    p: [],

    pre: [],

    s: [],

    small: [],

    span: [],

    sub: [],

    sup: [],

    strong: [],

    u: [],

    ul: []

  };

  /**

   * A pattern that recognizes a commonly useful subset of URLs that are safe.

   *

   * Shoutout to Angular 7 https://github.com/angular/angular/blob/7.2.4/packages/core/src/sanitization/url_sanitizer.ts

   */



  var SAFE_URL_PATTERN = /^(?:(?:https?|mailto|ftp|tel|file):|[^#&/:?]*(?:[#/?]|$))/gi;

  /**

   * A pattern that matches safe data URLs. Only matches image, video and audio types.

   *

   * Shoutout to Angular 7 https://github.com/angular/angular/blob/7.2.4/packages/core/src/sanitization/url_sanitizer.ts

   */



  var DATA_URL_PATTERN = /^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[\d+/a-z]+=*$/i;



  function allowedAttribute(attr, allowedAttributeList) {

    var attrName = attr.nodeName.toLowerCase();



    if (allowedAttributeList.indexOf(attrName) !== -1) {

      if (uriAttrs.indexOf(attrName) !== -1) {

        return Boolean(attr.nodeValue.match(SAFE_URL_PATTERN) || attr.nodeValue.match(DATA_URL_PATTERN));

      }



      return true;

    }



    var regExp = allowedAttributeList.filter(function (attrRegex) {

      return attrRegex instanceof RegExp;

    }); // Check if a regular expression validates the attribute.



    for (var i = 0, len = regExp.length; i < len; i++) {

      if (attrName.match(regExp[i])) {

        return true;

      }

    }



    return false;

  }



  function sanitizeHtml(unsafeHtml, whiteList, sanitizeFn) {

    if (unsafeHtml.length === 0) {

      return unsafeHtml;

    }



    if (sanitizeFn && typeof sanitizeFn === 'function') {

      return sanitizeFn(unsafeHtml);

    }



    var domParser = new window.DOMParser();

    var createdDocument = domParser.parseFromString(unsafeHtml, 'text/html');

    var whitelistKeys = Object.keys(whiteList);

    var elements = [].slice.call(createdDocument.body.querySelectorAll('*'));



    var _loop = function _loop(i, len) {

      var el = elements[i];

      var elName = el.nodeName.toLowerCase();



      if (whitelistKeys.indexOf(el.nodeName.toLowerCase()) === -1) {

        el.parentNode.removeChild(el);

        return "continue";

      }



      var attributeList = [].slice.call(el.attributes);

      var whitelistedAttributes = [].concat(whiteList['*'] || [], whiteList[elName] || []);

      attributeList.forEach(function (attr) {

        if (!allowedAttribute(attr, whitelistedAttributes)) {

          el.removeAttribute(attr.nodeName);

        }

      });

    };



    for (var i = 0, len = elements.length; i < len; i++) {

      var _ret = _loop(i);



      if (_ret === "continue") continue;

    }



    return createdDocument.body.innerHTML;

  }



  /**

   * ------------------------------------------------------------------------

   * Constants

   * ------------------------------------------------------------------------

   */



  var NAME$6 = 'tooltip';

  var VERSION$6 = '4.5.2';

  var DATA_KEY$6 = 'bs.tooltip';

  var EVENT_KEY$6 = "." + DATA_KEY$6;

  var JQUERY_NO_CONFLICT$6 = $.fn[NAME$6];

  var CLASS_PREFIX = 'bs-tooltip';

  var BSCLS_PREFIX_REGEX = new RegExp("(^|\\s)" + CLASS_PREFIX + "\\S+", 'g');

  var DISALLOWED_ATTRIBUTES = ['sanitize', 'whiteList', 'sanitizeFn'];

  var DefaultType$4 = {

    animation: 'boolean',

    template: 'string',

    title: '(string|element|function)',

    trigger: 'string',

    delay: '(number|object)',

    html: 'boolean',

    selector: '(string|boolean)',

    placement: '(string|function)',

    offset: '(number|string|function)',

    container: '(string|element|boolean)',

    fallbackPlacement: '(string|array)',

    boundary: '(string|element)',

    sanitize: 'boolean',

    sanitizeFn: '(null|function)',

    whiteList: 'object',

    popperConfig: '(null|object)'

  };

  var AttachmentMap = {

    AUTO: 'auto',

    TOP: 'top',

    RIGHT: 'right',

    BOTTOM: 'bottom',

    LEFT: 'left'

  };

  var Default$4 = {

    animation: true,

    template: '<div class="tooltip" role="tooltip">' + '<div class="arrow"></div>' + '<div class="tooltip-inner"></div></div>',

    trigger: 'hover focus',

    title: '',

    delay: 0,

    html: false,

    selector: false,

    placement: 'top',

    offset: 0,

    container: false,

    fallbackPlacement: 'flip',

    boundary: 'scrollParent',

    sanitize: true,

    sanitizeFn: null,

    whiteList: DefaultWhitelist,

    popperConfig: null

  };

  var HOVER_STATE_SHOW = 'show';

  var HOVER_STATE_OUT = 'out';

  var Event = {

    HIDE: "hide" + EVENT_KEY$6,

    HIDDEN: "hidden" + EVENT_KEY$6,

    SHOW: "show" + EVENT_KEY$6,

    SHOWN: "shown" + EVENT_KEY$6,

    INSERTED: "inserted" + EVENT_KEY$6,

    CLICK: "click" + EVENT_KEY$6,

    FOCUSIN: "focusin" + EVENT_KEY$6,

    FOCUSOUT: "focusout" + EVENT_KEY$6,

    MOUSEENTER: "mouseenter" + EVENT_KEY$6,

    MOUSELEAVE: "mouseleave" + EVENT_KEY$6

  };

  var CLASS_NAME_FADE$2 = 'fade';

  var CLASS_NAME_SHOW$4 = 'show';

  var SELECTOR_TOOLTIP_INNER = '.tooltip-inner';

  var SELECTOR_ARROW = '.arrow';

  var TRIGGER_HOVER = 'hover';

  var TRIGGER_FOCUS = 'focus';

  var TRIGGER_CLICK = 'click';

  var TRIGGER_MANUAL = 'manual';

  /**

   * ------------------------------------------------------------------------

   * Class Definition

   * ------------------------------------------------------------------------

   */



  var Tooltip = /*#__PURE__*/function () {

    function Tooltip(element, config) {

      if (typeof Popper === 'undefined') {

        throw new TypeError('Bootstrap\'s tooltips require Popper.js (https://popper.js.org/)');

      } // private





      this._isEnabled = true;

      this._timeout = 0;

      this._hoverState = '';

      this._activeTrigger = {};

      this._popper = null; // Protected



      this.element = element;

      this.config = this._getConfig(config);

      this.tip = null;



      this._setListeners();

    } // Getters





    var _proto = Tooltip.prototype;



    // Public

    _proto.enable = function enable() {

      this._isEnabled = true;

    };



    _proto.disable = function disable() {

      this._isEnabled = false;

    };



    _proto.toggleEnabled = function toggleEnabled() {

      this._isEnabled = !this._isEnabled;

    };



    _proto.toggle = function toggle(event) {

      if (!this._isEnabled) {

        return;

      }



      if (event) {

        var dataKey = this.constructor.DATA_KEY;

        var context = $(event.currentTarget).data(dataKey);



        if (!context) {

          context = new this.constructor(event.currentTarget, this._getDelegateConfig());

          $(event.currentTarget).data(dataKey, context);

        }



        context._activeTrigger.click = !context._activeTrigger.click;



        if (context._isWithActiveTrigger()) {

          context._enter(null, context);

        } else {

          context._leave(null, context);

        }

      } else {

        if ($(this.getTipElement()).hasClass(CLASS_NAME_SHOW$4)) {

          this._leave(null, this);



          return;

        }



        this._enter(null, this);

      }

    };



    _proto.dispose = function dispose() {

      clearTimeout(this._timeout);

      $.removeData(this.element, this.constructor.DATA_KEY);

      $(this.element).off(this.constructor.EVENT_KEY);

      $(this.element).closest('.modal').off('hide.bs.modal', this._hideModalHandler);



      if (this.tip) {

        $(this.tip).remove();

      }



      this._isEnabled = null;

      this._timeout = null;

      this._hoverState = null;

      this._activeTrigger = null;



      if (this._popper) {

        this._popper.destroy();

      }



      this._popper = null;

      this.element = null;

      this.config = null;

      this.tip = null;

    };



    _proto.show = function show() {

      var _this = this;



      if ($(this.element).css('display') === 'none') {

        throw new Error('Please use show on visible elements');

      }



      var showEvent = $.Event(this.constructor.Event.SHOW);



      if (this.isWithContent() && this._isEnabled) {

        $(this.element).trigger(showEvent);

        var shadowRoot = Util.findShadowRoot(this.element);

        var isInTheDom = $.contains(shadowRoot !== null ? shadowRoot : this.element.ownerDocument.documentElement, this.element);



        if (showEvent.isDefaultPrevented() || !isInTheDom) {

          return;

        }



        var tip = this.getTipElement();

        var tipId = Util.getUID(this.constructor.NAME);

        tip.setAttribute('id', tipId);

        this.element.setAttribute('aria-describedby', tipId);

        this.setContent();



        if (this.config.animation) {

          $(tip).addClass(CLASS_NAME_FADE$2);

        }



        var placement = typeof this.config.placement === 'function' ? this.config.placement.call(this, tip, this.element) : this.config.placement;



        var attachment = this._getAttachment(placement);



        this.addAttachmentClass(attachment);



        var container = this._getContainer();



        $(tip).data(this.constructor.DATA_KEY, this);



        if (!$.contains(this.element.ownerDocument.documentElement, this.tip)) {

          $(tip).appendTo(container);

        }



        $(this.element).trigger(this.constructor.Event.INSERTED);

        this._popper = new Popper(this.element, tip, this._getPopperConfig(attachment));

        $(tip).addClass(CLASS_NAME_SHOW$4); // If this is a touch-enabled device we add extra

        // empty mouseover listeners to the body's immediate children;

        // only needed because of broken event delegation on iOS

        // https://www.quirksmode.org/blog/archives/2014/02/mouse_event_bub.html



        if ('ontouchstart' in document.documentElement) {

          $(document.body).children().on('mouseover', null, $.noop);

        }



        var complete = function complete() {

          if (_this.config.animation) {

            _this._fixTransition();

          }



          var prevHoverState = _this._hoverState;

          _this._hoverState = null;

          $(_this.element).trigger(_this.constructor.Event.SHOWN);



          if (prevHoverState === HOVER_STATE_OUT) {

            _this._leave(null, _this);

          }

        };



        if ($(this.tip).hasClass(CLASS_NAME_FADE$2)) {

          var transitionDuration = Util.getTransitionDurationFromElement(this.tip);

          $(this.tip).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);

        } else {

          complete();

        }

      }

    };



    _proto.hide = function hide(callback) {

      var _this2 = this;



      var tip = this.getTipElement();

      var hideEvent = $.Event(this.constructor.Event.HIDE);



      var complete = function complete() {

        if (_this2._hoverState !== HOVER_STATE_SHOW && tip.parentNode) {

          tip.parentNode.removeChild(tip);

        }



        _this2._cleanTipClass();



        _this2.element.removeAttribute('aria-describedby');



        $(_this2.element).trigger(_this2.constructor.Event.HIDDEN);



        if (_this2._popper !== null) {

          _this2._popper.destroy();

        }



        if (callback) {

          callback();

        }

      };



      $(this.element).trigger(hideEvent);



      if (hideEvent.isDefaultPrevented()) {

        return;

      }



      $(tip).removeClass(CLASS_NAME_SHOW$4); // If this is a touch-enabled device we remove the extra

      // empty mouseover listeners we added for iOS support



      if ('ontouchstart' in document.documentElement) {

        $(document.body).children().off('mouseover', null, $.noop);

      }



      this._activeTrigger[TRIGGER_CLICK] = false;

      this._activeTrigger[TRIGGER_FOCUS] = false;

      this._activeTrigger[TRIGGER_HOVER] = false;



      if ($(this.tip).hasClass(CLASS_NAME_FADE$2)) {

        var transitionDuration = Util.getTransitionDurationFromElement(tip);

        $(tip).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);

      } else {

        complete();

      }



      this._hoverState = '';

    };



    _proto.update = function update() {

      if (this._popper !== null) {

        this._popper.scheduleUpdate();

      }

    } // Protected

    ;



    _proto.isWithContent = function isWithContent() {

      return Boolean(this.getTitle());

    };



    _proto.addAttachmentClass = function addAttachmentClass(attachment) {

      $(this.getTipElement()).addClass(CLASS_PREFIX + "-" + attachment);

    };



    _proto.getTipElement = function getTipElement() {

      this.tip = this.tip || $(this.config.template)[0];

      return this.tip;

    };



    _proto.setContent = function setContent() {

      var tip = this.getTipElement();

      this.setElementContent($(tip.querySelectorAll(SELECTOR_TOOLTIP_INNER)), this.getTitle());

      $(tip).removeClass(CLASS_NAME_FADE$2 + " " + CLASS_NAME_SHOW$4);

    };



    _proto.setElementContent = function setElementContent($element, content) {

      if (typeof content === 'object' && (content.nodeType || content.jquery)) {

        // Content is a DOM node or a jQuery

        if (this.config.html) {

          if (!$(content).parent().is($element)) {

            $element.empty().append(content);

          }

        } else {

          $element.text($(content).text());

        }



        return;

      }



      if (this.config.html) {

        if (this.config.sanitize) {

          content = sanitizeHtml(content, this.config.whiteList, this.config.sanitizeFn);

        }



        $element.html(content);

      } else {

        $element.text(content);

      }

    };



    _proto.getTitle = function getTitle() {

      var title = this.element.getAttribute('data-original-title');



      if (!title) {

        title = typeof this.config.title === 'function' ? this.config.title.call(this.element) : this.config.title;

      }



      return title;

    } // Private

    ;



    _proto._getPopperConfig = function _getPopperConfig(attachment) {

      var _this3 = this;



      var defaultBsConfig = {

        placement: attachment,

        modifiers: {

          offset: this._getOffset(),

          flip: {

            behavior: this.config.fallbackPlacement

          },

          arrow: {

            element: SELECTOR_ARROW

          },

          preventOverflow: {

            boundariesElement: this.config.boundary

          }

        },

        onCreate: function onCreate(data) {

          if (data.originalPlacement !== data.placement) {

            _this3._handlePopperPlacementChange(data);

          }

        },

        onUpdate: function onUpdate(data) {

          return _this3._handlePopperPlacementChange(data);

        }

      };

      return _extends({}, defaultBsConfig, this.config.popperConfig);

    };



    _proto._getOffset = function _getOffset() {

      var _this4 = this;



      var offset = {};



      if (typeof this.config.offset === 'function') {

        offset.fn = function (data) {

          data.offsets = _extends({}, data.offsets, _this4.config.offset(data.offsets, _this4.element) || {});

          return data;

        };

      } else {

        offset.offset = this.config.offset;

      }



      return offset;

    };



    _proto._getContainer = function _getContainer() {

      if (this.config.container === false) {

        return document.body;

      }



      if (Util.isElement(this.config.container)) {

        return $(this.config.container);

      }



      return $(document).find(this.config.container);

    };



    _proto._getAttachment = function _getAttachment(placement) {

      return AttachmentMap[placement.toUpperCase()];

    };



    _proto._setListeners = function _setListeners() {

      var _this5 = this;



      var triggers = this.config.trigger.split(' ');

      triggers.forEach(function (trigger) {

        if (trigger === 'click') {

          $(_this5.element).on(_this5.constructor.Event.CLICK, _this5.config.selector, function (event) {

            return _this5.toggle(event);

          });

        } else if (trigger !== TRIGGER_MANUAL) {

          var eventIn = trigger === TRIGGER_HOVER ? _this5.constructor.Event.MOUSEENTER : _this5.constructor.Event.FOCUSIN;

          var eventOut = trigger === TRIGGER_HOVER ? _this5.constructor.Event.MOUSELEAVE : _this5.constructor.Event.FOCUSOUT;

          $(_this5.element).on(eventIn, _this5.config.selector, function (event) {

            return _this5._enter(event);

          }).on(eventOut, _this5.config.selector, function (event) {

            return _this5._leave(event);

          });

        }

      });



      this._hideModalHandler = function () {

        if (_this5.element) {

          _this5.hide();

        }

      };



      $(this.element).closest('.modal').on('hide.bs.modal', this._hideModalHandler);



      if (this.config.selector) {

        this.config = _extends({}, this.config, {

          trigger: 'manual',

          selector: ''

        });

      } else {

        this._fixTitle();

      }

    };



    _proto._fixTitle = function _fixTitle() {

      var titleType = typeof this.element.getAttribute('data-original-title');



      if (this.element.getAttribute('title') || titleType !== 'string') {

        this.element.setAttribute('data-original-title', this.element.getAttribute('title') || '');

        this.element.setAttribute('title', '');

      }

    };



    _proto._enter = function _enter(event, context) {

      var dataKey = this.constructor.DATA_KEY;

      context = context || $(event.currentTarget).data(dataKey);



      if (!context) {

        context = new this.constructor(event.currentTarget, this._getDelegateConfig());

        $(event.currentTarget).data(dataKey, context);

      }



      if (event) {

        context._activeTrigger[event.type === 'focusin' ? TRIGGER_FOCUS : TRIGGER_HOVER] = true;

      }



      if ($(context.getTipElement()).hasClass(CLASS_NAME_SHOW$4) || context._hoverState === HOVER_STATE_SHOW) {

        context._hoverState = HOVER_STATE_SHOW;

        return;

      }



      clearTimeout(context._timeout);

      context._hoverState = HOVER_STATE_SHOW;



      if (!context.config.delay || !context.config.delay.show) {

        context.show();

        return;

      }



      context._timeout = setTimeout(function () {

        if (context._hoverState === HOVER_STATE_SHOW) {

          context.show();

        }

      }, context.config.delay.show);

    };



    _proto._leave = function _leave(event, context) {

      var dataKey = this.constructor.DATA_KEY;

      context = context || $(event.currentTarget).data(dataKey);



      if (!context) {

        context = new this.constructor(event.currentTarget, this._getDelegateConfig());

        $(event.currentTarget).data(dataKey, context);

      }



      if (event) {

        context._activeTrigger[event.type === 'focusout' ? TRIGGER_FOCUS : TRIGGER_HOVER] = false;

      }



      if (context._isWithActiveTrigger()) {

        return;

      }



      clearTimeout(context._timeout);

      context._hoverState = HOVER_STATE_OUT;



      if (!context.config.delay || !context.config.delay.hide) {

        context.hide();

        return;

      }



      context._timeout = setTimeout(function () {

        if (context._hoverState === HOVER_STATE_OUT) {

          context.hide();

        }

      }, context.config.delay.hide);

    };



    _proto._isWithActiveTrigger = function _isWithActiveTrigger() {

      for (var trigger in this._activeTrigger) {

        if (this._activeTrigger[trigger]) {

          return true;

        }

      }



      return false;

    };



    _proto._getConfig = function _getConfig(config) {

      var dataAttributes = $(this.element).data();

      Object.keys(dataAttributes).forEach(function (dataAttr) {

        if (DISALLOWED_ATTRIBUTES.indexOf(dataAttr) !== -1) {

          delete dataAttributes[dataAttr];

        }

      });

      config = _extends({}, this.constructor.Default, dataAttributes, typeof config === 'object' && config ? config : {});



      if (typeof config.delay === 'number') {

        config.delay = {

          show: config.delay,

          hide: config.delay

        };

      }



      if (typeof config.title === 'number') {

        config.title = config.title.toString();

      }



      if (typeof config.content === 'number') {

        config.content = config.content.toString();

      }



      Util.typeCheckConfig(NAME$6, config, this.constructor.DefaultType);



      if (config.sanitize) {

        config.template = sanitizeHtml(config.template, config.whiteList, config.sanitizeFn);

      }



      return config;

    };



    _proto._getDelegateConfig = function _getDelegateConfig() {

      var config = {};



      if (this.config) {

        for (var key in this.config) {

          if (this.constructor.Default[key] !== this.config[key]) {

            config[key] = this.config[key];

          }

        }

      }



      return config;

    };



    _proto._cleanTipClass = function _cleanTipClass() {

      var $tip = $(this.getTipElement());

      var tabClass = $tip.attr('class').match(BSCLS_PREFIX_REGEX);



      if (tabClass !== null && tabClass.length) {

        $tip.removeClass(tabClass.join(''));

      }

    };



    _proto._handlePopperPlacementChange = function _handlePopperPlacementChange(popperData) {

      this.tip = popperData.instance.popper;



      this._cleanTipClass();



      this.addAttachmentClass(this._getAttachment(popperData.placement));

    };



    _proto._fixTransition = function _fixTransition() {

      var tip = this.getTipElement();

      var initConfigAnimation = this.config.animation;



      if (tip.getAttribute('x-placement') !== null) {

        return;

      }



      $(tip).removeClass(CLASS_NAME_FADE$2);

      this.config.animation = false;

      this.hide();

      this.show();

      this.config.animation = initConfigAnimation;

    } // Static

    ;



    Tooltip._jQueryInterface = function _jQueryInterface(config) {

      return this.each(function () {

        var data = $(this).data(DATA_KEY$6);



        var _config = typeof config === 'object' && config;



        if (!data && /dispose|hide/.test(config)) {

          return;

        }



        if (!data) {

          data = new Tooltip(this, _config);

          $(this).data(DATA_KEY$6, data);

        }



        if (typeof config === 'string') {

          if (typeof data[config] === 'undefined') {

            throw new TypeError("No method named \"" + config + "\"");

          }



          data[config]();

        }

      });

    };



    _createClass(Tooltip, null, [{

      key: "VERSION",

      get: function get() {

        return VERSION$6;

      }

    }, {

      key: "Default",

      get: function get() {

        return Default$4;

      }

    }, {

      key: "NAME",

      get: function get() {

        return NAME$6;

      }

    }, {

      key: "DATA_KEY",

      get: function get() {

        return DATA_KEY$6;

      }

    }, {

      key: "Event",

      get: function get() {

        return Event;

      }

    }, {

      key: "EVENT_KEY",

      get: function get() {

        return EVENT_KEY$6;

      }

    }, {

      key: "DefaultType",

      get: function get() {

        return DefaultType$4;

      }

    }]);



    return Tooltip;

  }();

  /**

   * ------------------------------------------------------------------------

   * jQuery

   * ------------------------------------------------------------------------

   */





  $.fn[NAME$6] = Tooltip._jQueryInterface;

  $.fn[NAME$6].Constructor = Tooltip;



  $.fn[NAME$6].noConflict = function () {

    $.fn[NAME$6] = JQUERY_NO_CONFLICT$6;

    return Tooltip._jQueryInterface;

  };



  /**

   * ------------------------------------------------------------------------

   * Constants

   * ------------------------------------------------------------------------

   */



  var NAME$7 = 'popover';

  var VERSION$7 = '4.5.2';

  var DATA_KEY$7 = 'bs.popover';

  var EVENT_KEY$7 = "." + DATA_KEY$7;

  var JQUERY_NO_CONFLICT$7 = $.fn[NAME$7];

  var CLASS_PREFIX$1 = 'bs-popover';

  var BSCLS_PREFIX_REGEX$1 = new RegExp("(^|\\s)" + CLASS_PREFIX$1 + "\\S+", 'g');



  var Default$5 = _extends({}, Tooltip.Default, {

    placement: 'right',

    trigger: 'click',

    content: '',

    template: '<div class="popover" role="tooltip">' + '<div class="arrow"></div>' + '<h3 class="popover-header"></h3>' + '<div class="popover-body"></div></div>'

  });



  var DefaultType$5 = _extends({}, Tooltip.DefaultType, {

    content: '(string|element|function)'

  });



  var CLASS_NAME_FADE$3 = 'fade';

  var CLASS_NAME_SHOW$5 = 'show';

  var SELECTOR_TITLE = '.popover-header';

  var SELECTOR_CONTENT = '.popover-body';

  var Event$1 = {

    HIDE: "hide" + EVENT_KEY$7,

    HIDDEN: "hidden" + EVENT_KEY$7,

    SHOW: "show" + EVENT_KEY$7,

    SHOWN: "shown" + EVENT_KEY$7,

    INSERTED: "inserted" + EVENT_KEY$7,

    CLICK: "click" + EVENT_KEY$7,

    FOCUSIN: "focusin" + EVENT_KEY$7,

    FOCUSOUT: "focusout" + EVENT_KEY$7,

    MOUSEENTER: "mouseenter" + EVENT_KEY$7,

    MOUSELEAVE: "mouseleave" + EVENT_KEY$7

  };

  /**

   * ------------------------------------------------------------------------

   * Class Definition

   * ------------------------------------------------------------------------

   */



  var Popover = /*#__PURE__*/function (_Tooltip) {

    _inheritsLoose(Popover, _Tooltip);



    function Popover() {

      return _Tooltip.apply(this, arguments) || this;

    }



    var _proto = Popover.prototype;



    // Overrides

    _proto.isWithContent = function isWithContent() {

      return this.getTitle() || this._getContent();

    };



    _proto.addAttachmentClass = function addAttachmentClass(attachment) {

      $(this.getTipElement()).addClass(CLASS_PREFIX$1 + "-" + attachment);

    };



    _proto.getTipElement = function getTipElement() {

      this.tip = this.tip || $(this.config.template)[0];

      return this.tip;

    };



    _proto.setContent = function setContent() {

      var $tip = $(this.getTipElement()); // We use append for html objects to maintain js events



      this.setElementContent($tip.find(SELECTOR_TITLE), this.getTitle());



      var content = this._getContent();



      if (typeof content === 'function') {

        content = content.call(this.element);

      }



      this.setElementContent($tip.find(SELECTOR_CONTENT), content);

      $tip.removeClass(CLASS_NAME_FADE$3 + " " + CLASS_NAME_SHOW$5);

    } // Private

    ;



    _proto._getContent = function _getContent() {

      return this.element.getAttribute('data-content') || this.config.content;

    };



    _proto._cleanTipClass = function _cleanTipClass() {

      var $tip = $(this.getTipElement());

      var tabClass = $tip.attr('class').match(BSCLS_PREFIX_REGEX$1);



      if (tabClass !== null && tabClass.length > 0) {

        $tip.removeClass(tabClass.join(''));

      }

    } // Static

    ;



    Popover._jQueryInterface = function _jQueryInterface(config) {

      return this.each(function () {

        var data = $(this).data(DATA_KEY$7);



        var _config = typeof config === 'object' ? config : null;



        if (!data && /dispose|hide/.test(config)) {

          return;

        }



        if (!data) {

          data = new Popover(this, _config);

          $(this).data(DATA_KEY$7, data);

        }



        if (typeof config === 'string') {

          if (typeof data[config] === 'undefined') {

            throw new TypeError("No method named \"" + config + "\"");

          }



          data[config]();

        }

      });

    };



    _createClass(Popover, null, [{

      key: "VERSION",

      // Getters

      get: function get() {

        return VERSION$7;

      }

    }, {

      key: "Default",

      get: function get() {

        return Default$5;

      }

    }, {

      key: "NAME",

      get: function get() {

        return NAME$7;

      }

    }, {

      key: "DATA_KEY",

      get: function get() {

        return DATA_KEY$7;

      }

    }, {

      key: "Event",

      get: function get() {

        return Event$1;

      }

    }, {

      key: "EVENT_KEY",

      get: function get() {

        return EVENT_KEY$7;

      }

    }, {

      key: "DefaultType",

      get: function get() {

        return DefaultType$5;

      }

    }]);



    return Popover;

  }(Tooltip);

  /**

   * ------------------------------------------------------------------------

   * jQuery

   * ------------------------------------------------------------------------

   */





  $.fn[NAME$7] = Popover._jQueryInterface;

  $.fn[NAME$7].Constructor = Popover;



  $.fn[NAME$7].noConflict = function () {

    $.fn[NAME$7] = JQUERY_NO_CONFLICT$7;

    return Popover._jQueryInterface;

  };



  /**

   * ------------------------------------------------------------------------

   * Constants

   * ------------------------------------------------------------------------

   */



  var NAME$8 = 'scrollspy';

  var VERSION$8 = '4.5.2';

  var DATA_KEY$8 = 'bs.scrollspy';

  var EVENT_KEY$8 = "." + DATA_KEY$8;

  var DATA_API_KEY$6 = '.data-api';

  var JQUERY_NO_CONFLICT$8 = $.fn[NAME$8];

  var Default$6 = {

    offset: 10,

    method: 'auto',

    target: ''

  };

  var DefaultType$6 = {

    offset: 'number',

    method: 'string',

    target: '(string|element)'

  };

  var EVENT_ACTIVATE = "activate" + EVENT_KEY$8;

  var EVENT_SCROLL = "scroll" + EVENT_KEY$8;

  var EVENT_LOAD_DATA_API$2 = "load" + EVENT_KEY$8 + DATA_API_KEY$6;

  var CLASS_NAME_DROPDOWN_ITEM = 'dropdown-item';

  var CLASS_NAME_ACTIVE$2 = 'active';

  var SELECTOR_DATA_SPY = '[data-spy="scroll"]';

  var SELECTOR_NAV_LIST_GROUP = '.nav, .list-group';

  var SELECTOR_NAV_LINKS = '.nav-link';

  var SELECTOR_NAV_ITEMS = '.nav-item';

  var SELECTOR_LIST_ITEMS = '.list-group-item';

  var SELECTOR_DROPDOWN = '.dropdown';

  var SELECTOR_DROPDOWN_ITEMS = '.dropdown-item';

  var SELECTOR_DROPDOWN_TOGGLE = '.dropdown-toggle';

  var METHOD_OFFSET = 'offset';

  var METHOD_POSITION = 'position';

  /**

   * ------------------------------------------------------------------------

   * Class Definition

   * ------------------------------------------------------------------------

   */



  var ScrollSpy = /*#__PURE__*/function () {

    function ScrollSpy(element, config) {

      var _this = this;



      this._element = element;

      this._scrollElement = element.tagName === 'BODY' ? window : element;

      this._config = this._getConfig(config);

      this._selector = this._config.target + " " + SELECTOR_NAV_LINKS + "," + (this._config.target + " " + SELECTOR_LIST_ITEMS + ",") + (this._config.target + " " + SELECTOR_DROPDOWN_ITEMS);

      this._offsets = [];

      this._targets = [];

      this._activeTarget = null;

      this._scrollHeight = 0;

      $(this._scrollElement).on(EVENT_SCROLL, function (event) {

        return _this._process(event);

      });

      this.refresh();



      this._process();

    } // Getters





    var _proto = ScrollSpy.prototype;



    // Public

    _proto.refresh = function refresh() {

      var _this2 = this;



      var autoMethod = this._scrollElement === this._scrollElement.window ? METHOD_OFFSET : METHOD_POSITION;

      var offsetMethod = this._config.method === 'auto' ? autoMethod : this._config.method;

      var offsetBase = offsetMethod === METHOD_POSITION ? this._getScrollTop() : 0;

      this._offsets = [];

      this._targets = [];

      this._scrollHeight = this._getScrollHeight();

      var targets = [].slice.call(document.querySelectorAll(this._selector));

      targets.map(function (element) {

        var target;

        var targetSelector = Util.getSelectorFromElement(element);



        if (targetSelector) {

          target = document.querySelector(targetSelector);

        }



        if (target) {

          var targetBCR = target.getBoundingClientRect();



          if (targetBCR.width || targetBCR.height) {

            // TODO (fat): remove sketch reliance on jQuery position/offset

            return [$(target)[offsetMethod]().top + offsetBase, targetSelector];

          }

        }



        return null;

      }).filter(function (item) {

        return item;

      }).sort(function (a, b) {

        return a[0] - b[0];

      }).forEach(function (item) {

        _this2._offsets.push(item[0]);



        _this2._targets.push(item[1]);

      });

    };



    _proto.dispose = function dispose() {

      $.removeData(this._element, DATA_KEY$8);

      $(this._scrollElement).off(EVENT_KEY$8);

      this._element = null;

      this._scrollElement = null;

      this._config = null;

      this._selector = null;

      this._offsets = null;

      this._targets = null;

      this._activeTarget = null;

      this._scrollHeight = null;

    } // Private

    ;



    _proto._getConfig = function _getConfig(config) {

      config = _extends({}, Default$6, typeof config === 'object' && config ? config : {});



      if (typeof config.target !== 'string' && Util.isElement(config.target)) {

        var id = $(config.target).attr('id');



        if (!id) {

          id = Util.getUID(NAME$8);

          $(config.target).attr('id', id);

        }



        config.target = "#" + id;

      }



      Util.typeCheckConfig(NAME$8, config, DefaultType$6);

      return config;

    };



    _proto._getScrollTop = function _getScrollTop() {

      return this._scrollElement === window ? this._scrollElement.pageYOffset : this._scrollElement.scrollTop;

    };



    _proto._getScrollHeight = function _getScrollHeight() {

      return this._scrollElement.scrollHeight || Math.max(document.body.scrollHeight, document.documentElement.scrollHeight);

    };



    _proto._getOffsetHeight = function _getOffsetHeight() {

      return this._scrollElement === window ? window.innerHeight : this._scrollElement.getBoundingClientRect().height;

    };



    _proto._process = function _process() {

      var scrollTop = this._getScrollTop() + this._config.offset;



      var scrollHeight = this._getScrollHeight();



      var maxScroll = this._config.offset + scrollHeight - this._getOffsetHeight();



      if (this._scrollHeight !== scrollHeight) {

        this.refresh();

      }



      if (scrollTop >= maxScroll) {

        var target = this._targets[this._targets.length - 1];



        if (this._activeTarget !== target) {

          this._activate(target);

        }



        return;

      }



      if (this._activeTarget && scrollTop < this._offsets[0] && this._offsets[0] > 0) {

        this._activeTarget = null;



        this._clear();



        return;

      }



      for (var i = this._offsets.length; i--;) {

        var isActiveTarget = this._activeTarget !== this._targets[i] && scrollTop >= this._offsets[i] && (typeof this._offsets[i + 1] === 'undefined' || scrollTop < this._offsets[i + 1]);



        if (isActiveTarget) {

          this._activate(this._targets[i]);

        }

      }

    };



    _proto._activate = function _activate(target) {

      this._activeTarget = target;



      this._clear();



      var queries = this._selector.split(',').map(function (selector) {

        return selector + "[data-target=\"" + target + "\"]," + selector + "[href=\"" + target + "\"]";

      });



      var $link = $([].slice.call(document.querySelectorAll(queries.join(','))));



      if ($link.hasClass(CLASS_NAME_DROPDOWN_ITEM)) {

        $link.closest(SELECTOR_DROPDOWN).find(SELECTOR_DROPDOWN_TOGGLE).addClass(CLASS_NAME_ACTIVE$2);

        $link.addClass(CLASS_NAME_ACTIVE$2);

      } else {

        // Set triggered link as active

        $link.addClass(CLASS_NAME_ACTIVE$2); // Set triggered links parents as active

        // With both <ul> and <nav> markup a parent is the previous sibling of any nav ancestor



        $link.parents(SELECTOR_NAV_LIST_GROUP).prev(SELECTOR_NAV_LINKS + ", " + SELECTOR_LIST_ITEMS).addClass(CLASS_NAME_ACTIVE$2); // Handle special case when .nav-link is inside .nav-item



        $link.parents(SELECTOR_NAV_LIST_GROUP).prev(SELECTOR_NAV_ITEMS).children(SELECTOR_NAV_LINKS).addClass(CLASS_NAME_ACTIVE$2);

      }



      $(this._scrollElement).trigger(EVENT_ACTIVATE, {

        relatedTarget: target

      });

    };



    _proto._clear = function _clear() {

      [].slice.call(document.querySelectorAll(this._selector)).filter(function (node) {

        return node.classList.contains(CLASS_NAME_ACTIVE$2);

      }).forEach(function (node) {

        return node.classList.remove(CLASS_NAME_ACTIVE$2);

      });

    } // Static

    ;



    ScrollSpy._jQueryInterface = function _jQueryInterface(config) {

      return this.each(function () {

        var data = $(this).data(DATA_KEY$8);



        var _config = typeof config === 'object' && config;



        if (!data) {

          data = new ScrollSpy(this, _config);

          $(this).data(DATA_KEY$8, data);

        }



        if (typeof config === 'string') {

          if (typeof data[config] === 'undefined') {

            throw new TypeError("No method named \"" + config + "\"");

          }



          data[config]();

        }

      });

    };



    _createClass(ScrollSpy, null, [{

      key: "VERSION",

      get: function get() {

        return VERSION$8;

      }

    }, {

      key: "Default",

      get: function get() {

        return Default$6;

      }

    }]);



    return ScrollSpy;

  }();

  /**

   * ------------------------------------------------------------------------

   * Data Api implementation

   * ------------------------------------------------------------------------

   */





  $(window).on(EVENT_LOAD_DATA_API$2, function () {

    var scrollSpys = [].slice.call(document.querySelectorAll(SELECTOR_DATA_SPY));

    var scrollSpysLength = scrollSpys.length;



    for (var i = scrollSpysLength; i--;) {

      var $spy = $(scrollSpys[i]);



      ScrollSpy._jQueryInterface.call($spy, $spy.data());

    }

  });

  /**

   * ------------------------------------------------------------------------

   * jQuery

   * ------------------------------------------------------------------------

   */



  $.fn[NAME$8] = ScrollSpy._jQueryInterface;

  $.fn[NAME$8].Constructor = ScrollSpy;



  $.fn[NAME$8].noConflict = function () {

    $.fn[NAME$8] = JQUERY_NO_CONFLICT$8;

    return ScrollSpy._jQueryInterface;

  };



  /**

   * ------------------------------------------------------------------------

   * Constants

   * ------------------------------------------------------------------------

   */



  var NAME$9 = 'tab';

  var VERSION$9 = '4.5.2';

  var DATA_KEY$9 = 'bs.tab';

  var EVENT_KEY$9 = "." + DATA_KEY$9;

  var DATA_API_KEY$7 = '.data-api';

  var JQUERY_NO_CONFLICT$9 = $.fn[NAME$9];

  var EVENT_HIDE$3 = "hide" + EVENT_KEY$9;

  var EVENT_HIDDEN$3 = "hidden" + EVENT_KEY$9;

  var EVENT_SHOW$3 = "show" + EVENT_KEY$9;

  var EVENT_SHOWN$3 = "shown" + EVENT_KEY$9;

  var EVENT_CLICK_DATA_API$6 = "click" + EVENT_KEY$9 + DATA_API_KEY$7;

  var CLASS_NAME_DROPDOWN_MENU = 'dropdown-menu';

  var CLASS_NAME_ACTIVE$3 = 'active';

  var CLASS_NAME_DISABLED$1 = 'disabled';

  var CLASS_NAME_FADE$4 = 'fade';

  var CLASS_NAME_SHOW$6 = 'show';

  var SELECTOR_DROPDOWN$1 = '.dropdown';

  var SELECTOR_NAV_LIST_GROUP$1 = '.nav, .list-group';

  var SELECTOR_ACTIVE$2 = '.active';

  var SELECTOR_ACTIVE_UL = '> li > .active';

  var SELECTOR_DATA_TOGGLE$4 = '[data-toggle="tab"], [data-toggle="pill"], [data-toggle="list"]';

  var SELECTOR_DROPDOWN_TOGGLE$1 = '.dropdown-toggle';

  var SELECTOR_DROPDOWN_ACTIVE_CHILD = '> .dropdown-menu .active';

  /**

   * ------------------------------------------------------------------------

   * Class Definition

   * ------------------------------------------------------------------------

   */



  var Tab = /*#__PURE__*/function () {

    function Tab(element) {

      this._element = element;

    } // Getters





    var _proto = Tab.prototype;



    // Public

    _proto.show = function show() {

      var _this = this;



      if (this._element.parentNode && this._element.parentNode.nodeType === Node.ELEMENT_NODE && $(this._element).hasClass(CLASS_NAME_ACTIVE$3) || $(this._element).hasClass(CLASS_NAME_DISABLED$1)) {

        return;

      }



      var target;

      var previous;

      var listElement = $(this._element).closest(SELECTOR_NAV_LIST_GROUP$1)[0];

      var selector = Util.getSelectorFromElement(this._element);



      if (listElement) {

        var itemSelector = listElement.nodeName === 'UL' || listElement.nodeName === 'OL' ? SELECTOR_ACTIVE_UL : SELECTOR_ACTIVE$2;

        previous = $.makeArray($(listElement).find(itemSelector));

        previous = previous[previous.length - 1];

      }



      var hideEvent = $.Event(EVENT_HIDE$3, {

        relatedTarget: this._element

      });

      var showEvent = $.Event(EVENT_SHOW$3, {

        relatedTarget: previous

      });



      if (previous) {

        $(previous).trigger(hideEvent);

      }



      $(this._element).trigger(showEvent);



      if (showEvent.isDefaultPrevented() || hideEvent.isDefaultPrevented()) {

        return;

      }



      if (selector) {

        target = document.querySelector(selector);

      }



      this._activate(this._element, listElement);



      var complete = function complete() {

        var hiddenEvent = $.Event(EVENT_HIDDEN$3, {

          relatedTarget: _this._element

        });

        var shownEvent = $.Event(EVENT_SHOWN$3, {

          relatedTarget: previous

        });

        $(previous).trigger(hiddenEvent);

        $(_this._element).trigger(shownEvent);

      };



      if (target) {

        this._activate(target, target.parentNode, complete);

      } else {

        complete();

      }

    };



    _proto.dispose = function dispose() {

      $.removeData(this._element, DATA_KEY$9);

      this._element = null;

    } // Private

    ;



    _proto._activate = function _activate(element, container, callback) {

      var _this2 = this;



      var activeElements = container && (container.nodeName === 'UL' || container.nodeName === 'OL') ? $(container).find(SELECTOR_ACTIVE_UL) : $(container).children(SELECTOR_ACTIVE$2);

      var active = activeElements[0];

      var isTransitioning = callback && active && $(active).hasClass(CLASS_NAME_FADE$4);



      var complete = function complete() {

        return _this2._transitionComplete(element, active, callback);

      };



      if (active && isTransitioning) {

        var transitionDuration = Util.getTransitionDurationFromElement(active);

        $(active).removeClass(CLASS_NAME_SHOW$6).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);

      } else {

        complete();

      }

    };



    _proto._transitionComplete = function _transitionComplete(element, active, callback) {

      if (active) {

        $(active).removeClass(CLASS_NAME_ACTIVE$3);

        var dropdownChild = $(active.parentNode).find(SELECTOR_DROPDOWN_ACTIVE_CHILD)[0];



        if (dropdownChild) {

          $(dropdownChild).removeClass(CLASS_NAME_ACTIVE$3);

        }



        if (active.getAttribute('role') === 'tab') {

          active.setAttribute('aria-selected', false);

        }

      }



      $(element).addClass(CLASS_NAME_ACTIVE$3);



      if (element.getAttribute('role') === 'tab') {

        element.setAttribute('aria-selected', true);

      }



      Util.reflow(element);



      if (element.classList.contains(CLASS_NAME_FADE$4)) {

        element.classList.add(CLASS_NAME_SHOW$6);

      }



      if (element.parentNode && $(element.parentNode).hasClass(CLASS_NAME_DROPDOWN_MENU)) {

        var dropdownElement = $(element).closest(SELECTOR_DROPDOWN$1)[0];



        if (dropdownElement) {

          var dropdownToggleList = [].slice.call(dropdownElement.querySelectorAll(SELECTOR_DROPDOWN_TOGGLE$1));

          $(dropdownToggleList).addClass(CLASS_NAME_ACTIVE$3);

        }



        element.setAttribute('aria-expanded', true);

      }



      if (callback) {

        callback();

      }

    } // Static

    ;



    Tab._jQueryInterface = function _jQueryInterface(config) {

      return this.each(function () {

        var $this = $(this);

        var data = $this.data(DATA_KEY$9);



        if (!data) {

          data = new Tab(this);

          $this.data(DATA_KEY$9, data);

        }



        if (typeof config === 'string') {

          if (typeof data[config] === 'undefined') {

            throw new TypeError("No method named \"" + config + "\"");

          }



          data[config]();

        }

      });

    };



    _createClass(Tab, null, [{

      key: "VERSION",

      get: function get() {

        return VERSION$9;

      }

    }]);



    return Tab;

  }();

  /**

   * ------------------------------------------------------------------------

   * Data Api implementation

   * ------------------------------------------------------------------------

   */





  $(document).on(EVENT_CLICK_DATA_API$6, SELECTOR_DATA_TOGGLE$4, function (event) {

    event.preventDefault();



    Tab._jQueryInterface.call($(this), 'show');

  });

  /**

   * ------------------------------------------------------------------------

   * jQuery

   * ------------------------------------------------------------------------

   */



  $.fn[NAME$9] = Tab._jQueryInterface;

  $.fn[NAME$9].Constructor = Tab;



  $.fn[NAME$9].noConflict = function () {

    $.fn[NAME$9] = JQUERY_NO_CONFLICT$9;

    return Tab._jQueryInterface;

  };



  /**

   * ------------------------------------------------------------------------

   * Constants

   * ------------------------------------------------------------------------

   */



  var NAME$a = 'toast';

  var VERSION$a = '4.5.2';

  var DATA_KEY$a = 'bs.toast';

  var EVENT_KEY$a = "." + DATA_KEY$a;

  var JQUERY_NO_CONFLICT$a = $.fn[NAME$a];

  var EVENT_CLICK_DISMISS$1 = "click.dismiss" + EVENT_KEY$a;

  var EVENT_HIDE$4 = "hide" + EVENT_KEY$a;

  var EVENT_HIDDEN$4 = "hidden" + EVENT_KEY$a;

  var EVENT_SHOW$4 = "show" + EVENT_KEY$a;

  var EVENT_SHOWN$4 = "shown" + EVENT_KEY$a;

  var CLASS_NAME_FADE$5 = 'fade';

  var CLASS_NAME_HIDE = 'hide';

  var CLASS_NAME_SHOW$7 = 'show';

  var CLASS_NAME_SHOWING = 'showing';

  var DefaultType$7 = {

    animation: 'boolean',

    autohide: 'boolean',

    delay: 'number'

  };

  var Default$7 = {

    animation: true,

    autohide: true,

    delay: 500

  };

  var SELECTOR_DATA_DISMISS$1 = '[data-dismiss="toast"]';

  /**

   * ------------------------------------------------------------------------

   * Class Definition

   * ------------------------------------------------------------------------

   */



  var Toast = /*#__PURE__*/function () {

    function Toast(element, config) {

      this._element = element;

      this._config = this._getConfig(config);

      this._timeout = null;



      this._setListeners();

    } // Getters





    var _proto = Toast.prototype;



    // Public

    _proto.show = function show() {

      var _this = this;



      var showEvent = $.Event(EVENT_SHOW$4);

      $(this._element).trigger(showEvent);



      if (showEvent.isDefaultPrevented()) {

        return;

      }



      this._clearTimeout();



      if (this._config.animation) {

        this._element.classList.add(CLASS_NAME_FADE$5);

      }



      var complete = function complete() {

        _this._element.classList.remove(CLASS_NAME_SHOWING);



        _this._element.classList.add(CLASS_NAME_SHOW$7);



        $(_this._element).trigger(EVENT_SHOWN$4);



        if (_this._config.autohide) {

          _this._timeout = setTimeout(function () {

            _this.hide();

          }, _this._config.delay);

        }

      };



      this._element.classList.remove(CLASS_NAME_HIDE);



      Util.reflow(this._element);



      this._element.classList.add(CLASS_NAME_SHOWING);



      if (this._config.animation) {

        var transitionDuration = Util.getTransitionDurationFromElement(this._element);

        $(this._element).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);

      } else {

        complete();

      }

    };



    _proto.hide = function hide() {

      if (!this._element.classList.contains(CLASS_NAME_SHOW$7)) {

        return;

      }



      var hideEvent = $.Event(EVENT_HIDE$4);

      $(this._element).trigger(hideEvent);



      if (hideEvent.isDefaultPrevented()) {

        return;

      }



      this._close();

    };



    _proto.dispose = function dispose() {

      this._clearTimeout();



      if (this._element.classList.contains(CLASS_NAME_SHOW$7)) {

        this._element.classList.remove(CLASS_NAME_SHOW$7);

      }



      $(this._element).off(EVENT_CLICK_DISMISS$1);

      $.removeData(this._element, DATA_KEY$a);

      this._element = null;

      this._config = null;

    } // Private

    ;



    _proto._getConfig = function _getConfig(config) {

      config = _extends({}, Default$7, $(this._element).data(), typeof config === 'object' && config ? config : {});

      Util.typeCheckConfig(NAME$a, config, this.constructor.DefaultType);

      return config;

    };



    _proto._setListeners = function _setListeners() {

      var _this2 = this;



      $(this._element).on(EVENT_CLICK_DISMISS$1, SELECTOR_DATA_DISMISS$1, function () {

        return _this2.hide();

      });

    };



    _proto._close = function _close() {

      var _this3 = this;



      var complete = function complete() {

        _this3._element.classList.add(CLASS_NAME_HIDE);



        $(_this3._element).trigger(EVENT_HIDDEN$4);

      };



      this._element.classList.remove(CLASS_NAME_SHOW$7);



      if (this._config.animation) {

        var transitionDuration = Util.getTransitionDurationFromElement(this._element);

        $(this._element).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);

      } else {

        complete();

      }

    };



    _proto._clearTimeout = function _clearTimeout() {

      clearTimeout(this._timeout);

      this._timeout = null;

    } // Static

    ;



    Toast._jQueryInterface = function _jQueryInterface(config) {

      return this.each(function () {

        var $element = $(this);

        var data = $element.data(DATA_KEY$a);



        var _config = typeof config === 'object' && config;



        if (!data) {

          data = new Toast(this, _config);

          $element.data(DATA_KEY$a, data);

        }



        if (typeof config === 'string') {

          if (typeof data[config] === 'undefined') {

            throw new TypeError("No method named \"" + config + "\"");

          }



          data[config](this);

        }

      });

    };



    _createClass(Toast, null, [{

      key: "VERSION",

      get: function get() {

        return VERSION$a;

      }

    }, {

      key: "DefaultType",

      get: function get() {

        return DefaultType$7;

      }

    }, {

      key: "Default",

      get: function get() {

        return Default$7;

      }

    }]);



    return Toast;

  }();

  /**

   * ------------------------------------------------------------------------

   * jQuery

   * ------------------------------------------------------------------------

   */





  $.fn[NAME$a] = Toast._jQueryInterface;

  $.fn[NAME$a].Constructor = Toast;



  $.fn[NAME$a].noConflict = function () {

    $.fn[NAME$a] = JQUERY_NO_CONFLICT$a;

    return Toast._jQueryInterface;

  };



  exports.Alert = Alert;

  exports.Button = Button;

  exports.Carousel = Carousel;

  exports.Collapse = Collapse;

  exports.Dropdown = Dropdown;

  exports.Modal = Modal;

  exports.Popover = Popover;

  exports.Scrollspy = ScrollSpy;

  exports.Tab = Tab;

  exports.Toast = Toast;

  exports.Tooltip = Tooltip;

  exports.Util = Util;



  Object.defineProperty(exports, '__esModule', { value: true });



})));

//# sourceMappingURL=bootstrap.js.map





/***/ }),



/***/ "./node_modules/css-loader/index.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/sass-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/Message.vue?vue&type=style&index=0&lang=scss&":

/*!*****************************************************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--7-2!./node_modules/sass-loader/dist/cjs.js??ref--7-3!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/Message.vue?vue&type=style&index=0&lang=scss& ***!

  \*****************************************************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, ".cht--prvt {\n  color: #ff0000;\n  font-size: 12px;\n  font-style: italic;\n}\n.chattime {\n  color: #949494;\n  font-size: 12px;\n  font-style: italic;\n}\n.sc-message--user {\n  display: block;\n  color: #fe6600;\n}\n.sc-message {\n  width: 300px;\n  margin: auto;\n  padding-bottom: 10px;\n  display: flex;\n}\n.sc-message .sc-message--edited {\n  opacity: 0.7;\n  word-wrap: normal;\n  font-size: xx-small;\n  text-align: center;\n}\n.sc-message .chattime {\n  float: right;\n}\n.sc-message--content {\n  width: 100%;\n  /*display: flex;*/\n  display: block;\n}\n.sc-message--content.sent {\n  justify-content: flex-end;\n}\n.sc-message--content.sent {\n  /*justify-content: flex-end;*/\n  float: right;\n}\n.sc-message--content.sent .chattime {\n  float: left;\n}\n.sc-message--content.system {\n  justify-content: center;\n}\n.sc-message--content.sent .sc-message--avatar {\n  display: none;\n}\n.sc-message--avatar {\n  background-repeat: no-repeat;\n  background-size: 100%;\n  background-position: center;\n  min-width: 30px;\n  min-height: 30px;\n  border-radius: 50%;\n  align-self: center;\n  margin-right: 15px;\n}\n.sc-message--meta {\n  font-size: xx-small;\n  margin-bottom: 0px;\n  color: white;\n  text-align: center;\n}\n@media (max-width: 450px) {\n.sc-message {\n    width: 80%;\n}\n}\n.sc-message--text {\n  padding: 5px 10px;\n  max-width: calc(100% - 50px);\n  border-radius: 6px;\n  font-weight: 300;\n  font-size: 14px;\n  line-height: 1.4;\n  position: relative;\n  -webkit-font-smoothing: subpixel-antialiased;\n}\n.sc-message--text .sc-message--text-body .sc-message--text-content {\n  white-space: pre-wrap;\n}\n.sc-message--text p {\n  margin-bottom: 0rem;\n  font-size: 15px;\n  line-height: 21px;\n}\n.sc-message--text:hover .sc-message--toolbox {\n  left: -20px;\n  opacity: 1;\n}\n.sc-message--text .sc-message--toolbox {\n  transition: left 0.2s ease-out 0s;\n  white-space: normal;\n  opacity: 0;\n  position: absolute;\n  left: 0px;\n  width: 25px;\n  top: 0;\n}\n.sc-message--text .sc-message--toolbox button {\n  background: none;\n  border: none;\n  padding: 0px;\n  margin: 0px;\n  outline: none;\n  width: 100%;\n  text-align: center;\n  cursor: pointer;\n}\n.sc-message--text .sc-message--toolbox button:focus {\n  outline: none;\n}\n.sc-message--content.sent .sc-message--text {\n  color: white;\n  background-color: #4e8cff;\n  max-width: calc(100% - 50px);\n  word-wrap: break-word;\n}\n.sc-message--content.sent .sc-message--user {\n  display: block;\n  width: 100%;\n  text-align: right;\n  /*float:right;*/\n}\n.sc-message--content.sent .sc-message--user .chattime {\n  float: left;\n}\n.sc-message--text code {\n  font-family: \"Courier New\", Courier, monospace !important;\n}\n.sc-message--content.received .sc-message--text {\n  color: #263238;\n  background-color: #f4f7f9;\n  margin-right: 40px;\n}\n.tooltip {\n  display: block !important;\n  z-index: 10000;\n}\n.tooltip .tooltip-inner {\n  background: black;\n  color: white;\n  border-radius: 16px;\n  padding: 5px 10px 4px;\n}\n.tooltip .tooltip-arrow {\n  width: 0;\n  height: 0;\n  border-style: solid;\n  position: absolute;\n  margin: 5px;\n  border-color: black;\n  z-index: 1;\n}\n.tooltip[x-placement^=top] {\n  margin-bottom: 5px;\n}\n.tooltip[x-placement^=top] .tooltip-arrow {\n  border-width: 5px 5px 0 5px;\n  border-left-color: transparent !important;\n  border-right-color: transparent !important;\n  border-bottom-color: transparent !important;\n  bottom: -5px;\n  left: calc(50% - 5px);\n  margin-top: 0;\n  margin-bottom: 0;\n}\n.tooltip[x-placement^=bottom] {\n  margin-top: 5px;\n}\n.tooltip[x-placement^=bottom] .tooltip-arrow {\n  border-width: 0 5px 5px 5px;\n  border-left-color: transparent !important;\n  border-right-color: transparent !important;\n  border-top-color: transparent !important;\n  top: -5px;\n  left: calc(50% - 5px);\n  margin-top: 0;\n  margin-bottom: 0;\n}\n.tooltip[x-placement^=right] {\n  margin-left: 5px;\n}\n.tooltip[x-placement^=right] .tooltip-arrow {\n  border-width: 5px 5px 5px 0;\n  border-left-color: transparent !important;\n  border-top-color: transparent !important;\n  border-bottom-color: transparent !important;\n  left: -5px;\n  top: calc(50% - 5px);\n  margin-left: 0;\n  margin-right: 0;\n}\n.tooltip[x-placement^=left] {\n  margin-right: 5px;\n}\n.tooltip[x-placement^=left] .tooltip-arrow {\n  border-width: 5px 0 5px 5px;\n  border-top-color: transparent !important;\n  border-right-color: transparent !important;\n  border-bottom-color: transparent !important;\n  right: -5px;\n  top: calc(50% - 5px);\n  margin-left: 0;\n  margin-right: 0;\n}\n.tooltip[aria-hidden=true] {\n  visibility: hidden;\n  opacity: 0;\n  transition: opacity 0.15s, visibility 0.15s;\n}\n.tooltip[aria-hidden=false] {\n  visibility: visible;\n  opacity: 1;\n  transition: opacity 0.15s;\n}\n.tooltip.info .tooltip-inner {\n  background: rgba(0, 68, 153, 0.9);\n  color: white;\n  padding: 24px;\n  border-radius: 5px;\n  box-shadow: 0 5px 30px rgba(0, 0, 0, 0.1);\n}\n.tooltip.info .tooltip-arrow {\n  border-color: rgba(0, 68, 153, 0.9);\n}\n.tooltip.popover .popover-inner {\n  background: #f9f9f9;\n  color: black;\n  padding: 24px;\n  border-radius: 5px;\n  box-shadow: 0 5px 30px rgba(0, 0, 0, 0.1);\n}\n.tooltip.popover .popover-arrow {\n  border-color: #f9f9f9;\n}", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/BeautyChatarea.vue?vue&type=style&index=0&lang=css&":

/*!********************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/BeautyChatarea.vue?vue&type=style&index=0&lang=css& ***!

  \********************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\nbody {\r\n  padding: 0px;\r\n  margin: 0px;\n}\n* {\r\n  font-family: Avenir Next, Helvetica Neue, Helvetica, sans-serif;\n}\n.demo-description {\r\n  max-width: 500px;\n}\n.demo-description img {\r\n  max-width: 500px;\n}\n.demo-test-area {\r\n  width: 300px;\r\n  box-sizing: border-box;\n}\n.demo-test-area--text {\r\n  box-sizing: border-box;\r\n  width: 100%;\r\n  margin: 0px;\r\n  padding: 0px;\r\n  resize: none;\r\n  font-family: Avenir Next, Helvetica Neue, Helvetica, sans-serif;\r\n  background: #fafbfc;\r\n  color: #8da2b5;\r\n  border: 1px solid #dde5ed;\r\n  font-size: 16px;\r\n  padding: 16px 15px 14px;\r\n  margin: 0;\r\n  border-radius: 6px;\r\n  outline: none;\r\n  height: 150px;\r\n  margin-bottom: 10px;\n}\n.demo-monster-img {\r\n  width: 400px;\r\n  display: block;\r\n  margin: 60px auto;\n}\n.text-center {\r\n  text-align: center;\n}\n.colors a {\r\n  color: #fff;\r\n  text-decoration: none;\r\n  padding: 4px 10px;\r\n  border-radius: 10px;\n}\n.toggle a {\r\n  text-decoration: none;\n}\n.messageStyling {\r\n  font-size: small;\n}\r\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/ChatWindow.vue?vue&type=style&index=0&id=11683213&scoped=true&lang=css&":

/*!****************************************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/ChatWindow.vue?vue&type=style&index=0&id=11683213&scoped=true&lang=css& ***!

  \****************************************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\n.sc-chat-window[data-v-11683213] {\r\n  width: 370px;\r\n  height: calc(100% - 200px);\r\n  max-height: 590px;\r\n  position: fixed;\r\n  right: 25px;\r\n  bottom: 100px;\r\n  box-sizing: border-box;\r\n  box-shadow: 0px 7px 40px 2px rgba(148, 149, 150, 0.1);\r\n  background: white;\r\n  display: flex;\r\n  flex-direction: column;\r\n  justify-content: space-between;\r\n  border-radius: 10px;\r\n  font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;\r\n  -webkit-animation: fadeIn-data-v-11683213;\r\n          animation: fadeIn-data-v-11683213;\r\n  -webkit-animation-duration: 0.3s;\r\n          animation-duration: 0.3s;\r\n  -webkit-animation-timing-function: ease-in-out;\r\n          animation-timing-function: ease-in-out;\r\n  z-index:100;\n}\n.sc-chat-window.closed[data-v-11683213] {\r\n  opacity: 0;\r\n  display: none;\r\n  bottom: 90px;\n}\n@-webkit-keyframes fadeIn-data-v-11683213 {\n0% {\r\n    display: none;\r\n    opacity: 0;\n}\n100% {\r\n    display: flex;\r\n    opacity: 1;\n}\n}\n@keyframes fadeIn-data-v-11683213 {\n0% {\r\n    display: none;\r\n    opacity: 0;\n}\n100% {\r\n    display: flex;\r\n    opacity: 1;\n}\n}\n.sc-message--me[data-v-11683213] {\r\n  text-align: right;\n}\n.sc-message--them[data-v-11683213] {\r\n  text-align: left;\n}\n@media (max-width: 450px) {\n.sc-chat-window[data-v-11683213] {\r\n    width: 100%;\r\n    height: 100%;\r\n    max-height: 100%;\r\n    right: 0px;\r\n    bottom: 0px;\r\n    border-radius: 0px;\n}\n.sc-chat-window[data-v-11683213] {\r\n    transition: 0.1s ease-in-out;\n}\n.sc-chat-window.closed[data-v-11683213] {\r\n    bottom: 0px;\n}\n}\r\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/Chatarea.vue?vue&type=style&index=0&id=275cda60&scoped=true&lang=css&":

/*!**************************************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/Chatarea.vue?vue&type=style&index=0&id=275cda60&scoped=true&lang=css& ***!

  \**************************************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\n.sc-launcher[data-v-275cda60] {\r\n  width: 44px;\r\n  height: 44px;\r\n  background-position: center;\r\n  background-repeat: no-repeat;\r\n  position: fixed;\r\n  right: 70px;\r\n  bottom: 35px;\r\n  border-radius: 50%;\r\n  box-shadow: none;\r\n  transition: box-shadow 0.2s ease-in-out;\r\n  cursor: pointer;\r\n  z-index: 1;\n}\n.sc-launcher[data-v-275cda60]:before {\r\n  content: '';\r\n  position: relative;\r\n  display: block;\r\n  width: 44px;\r\n  height: 44px;\r\n  border-radius: 50%;\r\n  transition: box-shadow 0.2s ease-in-out;\n}\n.sc-launcher .sc-closed-icon[data-v-275cda60] {\r\n  width: 57px;\r\n  height: 57px;\r\n  position: fixed;\r\n  right: 69px;\r\n  bottom: 35px;\r\n  transition: opacity 100ms ease-in-out, transform 100ms ease-in-out;\n}\n.sc-launcher .sc-open-icon[data-v-275cda60] {\r\n  width: 60px;\r\n  height: 60px;\r\n  position: fixed;\r\n  right: 61px;\r\n  bottom: 27px;\r\n  transition: opacity 100ms ease-in-out, transform 100ms ease-in-out;\n}\n.sc-launcher .sc-closed-icon[data-v-275cda60] {\r\n  transition: opacity 100ms ease-in-out, transform 100ms ease-in-out;\r\n  width: 44px;\r\n  height: 44px;\n}\n.sc-launcher .sc-open-icon[data-v-275cda60] {\r\n  padding: 20px;\r\n  box-sizing: border-box;\r\n  opacity: 1;\n}\n.sc-launcher.opened .sc-open-icon[data-v-275cda60] {\r\n  transform: rotate(-90deg);\r\n  opacity: 1;\n}\n.sc-launcher.opened .sc-closed-icon[data-v-275cda60] {\r\n  transform: rotate(-90deg);\r\n  opacity: 1;\n}\n.sc-launcher.opened[data-v-275cda60]:before {\r\n  box-shadow: 0px 0px 400px 250px rgba(148, 149, 150, 0.2);\n}\n.sc-launcher[data-v-275cda60]:hover {\r\n  box-shadow: 0 0px 27px 1.5px rgba(0, 0, 0, 0.2);\n}\n.sc-new-messsages-count[data-v-275cda60] {\r\n  position: absolute;\r\n  top: -3px;\r\n  left: 41px;\r\n  display: flex;\r\n  justify-content: center;\r\n  flex-direction: column;\r\n  border-radius: 50%;\r\n  width: 22px;\r\n  height: 22px;\r\n  background: #ff4646;\r\n  color: white;\r\n  text-align: center;\r\n  margin: auto;\r\n  font-size: 12px;\r\n  font-weight: 500;\n}\r\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/EmojiPicker.vue?vue&type=style&index=0&id=57e24959&scoped=true&lang=css&":

/*!*****************************************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/EmojiPicker.vue?vue&type=style&index=0&id=57e24959&scoped=true&lang=css& ***!

  \*****************************************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\n.sc-emoji-picker[data-v-57e24959] {\n  position: absolute;\n  bottom: 50px;\n  right: 0px;\n  width: 330px;\n  max-height: 215px;\n  box-shadow: 0px 7px 40px 2px rgba(148, 149, 150, 0.3);\n  background: white;\n  border-radius: 10px;\n  outline: none;\n}\n.sc-emoji-picker[data-v-57e24959]:after {\n  content: '';\n  width: 14px;\n  height: 14px;\n  background: white;\n  position: absolute;\n  bottom: -6px;\n  right: 55px;\n  transform: rotate(45deg);\n  border-radius: 2px;\n}\n.sc-emoji-picker--content[data-v-57e24959] {\n  padding: 10px;\n  overflow: auto;\n  width: 100%;\n  max-height: 195px;\n  margin-top: 7px;\n  box-sizing: border-box;\n}\n.sc-emoji-picker--category[data-v-57e24959] {\n  display: flex;\n  flex-direction: row;\n  flex-wrap: wrap;\n}\n.sc-emoji-picker--category-title[data-v-57e24959] {\n  min-width: 100%;\n  color: #b8c3ca;\n  font-weight: 200;\n  font-size: 13px;\n  margin: 5px;\n  letter-spacing: 1px;\n}\n.sc-emoji-picker--emoji[data-v-57e24959] {\n  margin: 5px;\n  width: 30px;\n  line-height: 30px;\n  text-align: center;\n  cursor: pointer;\n  vertical-align: middle;\n  font-size: 28px;\n  transition: transform 60ms ease-out;\n}\n.sc-emoji-picker--emoji[data-v-57e24959]:hover {\n  transform: scale(1.4);\n}\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/Header.vue?vue&type=style&index=0&id=1f42fb90&scoped=true&lang=css&":

/*!************************************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/Header.vue?vue&type=style&index=0&id=1f42fb90&scoped=true&lang=css& ***!

  \************************************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\n.sc-header[data-v-1f42fb90] {\r\n  min-height: 55px;\r\n  border-top-left-radius: 9px;\r\n  border-top-right-radius: 9px;\r\n  padding: 2px 10px;\r\n  box-shadow: 0 1px 4px rgba(0, 0, 0, 0.2);\r\n  position: relative;\r\n  box-sizing: border-box;\r\n  display: flex;\n}\n.sc-header--img[data-v-1f42fb90] {\r\n  border-radius: 50%;\r\n  align-self: center;\r\n  padding: 10px;\n}\n.sc-header--title[data-v-1f42fb90] {\r\n  align-self: center;\r\n  padding: 10px;\r\n  flex: 1;\r\n  -webkit-user-select: none;\r\n     -moz-user-select: none;\r\n      -ms-user-select: none;\r\n          user-select: none;\r\n  font-size: 18px;\n}\n.sc-header--title.enabled[data-v-1f42fb90] {\r\n  cursor: pointer;\r\n  border-radius: 5px;\n}\n.sc-header--title.enabled[data-v-1f42fb90]:hover {\r\n  box-shadow: 0px 2px 5px rgba(0.2, 0.2, 0.5, 0.1);\n}\n.sc-header--close-button[data-v-1f42fb90] {\r\n  width: 40px;\r\n  align-self: center;\r\n  height: 40px;\r\n  margin-right: 10px;\r\n  box-sizing: border-box;\r\n  cursor: pointer;\r\n  border-radius: 5px;\r\n  margin-left: auto;\n}\n.sc-header--close-button[data-v-1f42fb90]:hover {\r\n  box-shadow: 0px 2px 5px rgba(0.2, 0.2, 0.5, 0.1);\n}\n.sc-header--close-button img[data-v-1f42fb90] {\r\n  width: 100%;\r\n  height: 100%;\r\n  padding: 13px;\r\n  box-sizing: border-box;\n}\n@media (max-width: 450px) {\n.sc-header[data-v-1f42fb90] {\r\n    border-radius: 0px;\n}\n}\r\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/IconBase.vue?vue&type=style&index=0&id=14fb6355&scoped=true&lang=css&":

/*!**************************************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/IconBase.vue?vue&type=style&index=0&id=14fb6355&scoped=true&lang=css& ***!

  \**************************************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\nsvg[data-v-14fb6355] {\n  display: inline-block;\n  vertical-align: baseline;\n  margin-bottom: -2px; /* yes, I'm that particular about formatting */\n}\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/MessageList.vue?vue&type=style&index=0&id=6a7499aa&scoped=true&lang=css&":

/*!*****************************************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/MessageList.vue?vue&type=style&index=0&id=6a7499aa&scoped=true&lang=css& ***!

  \*****************************************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\n.sc-message-list[data-v-6a7499aa] {\r\n  height: 80%;\r\n  overflow-y: auto;\r\n  background-size: 100%;\r\n  padding: 40px 0px;\n}\r\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/Suggestions.vue?vue&type=style&index=0&lang=css&":

/*!*****************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/Suggestions.vue?vue&type=style&index=0&lang=css& ***!

  \*****************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\n.sc-suggestions-row {\n  text-align: center;\n  background: inherit;\n}\n.sc-suggestions-element {\n  margin: 3px;\n  padding: 5px 10px 5px 10px;\n  border: 1px solid;\n  border-radius: 15px;\n  font-size: 14px;\n  background: inherit;\n  cursor: pointer;\n}\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/UserInput.vue?vue&type=style&index=0&lang=css&":

/*!***************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/UserInput.vue?vue&type=style&index=0&lang=css& ***!

  \***************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\n.userselectarea{\n}\n.choosechatto {\r\n    width: 100%;\r\n    padding: 6px 10px;\r\n\tborder-color:#ffded4;\r\n\tcolor:#fe6600;\n}\n.sc-user-input {\r\n  min-height: 55px;\r\n  margin: 0px;\r\n  position: relative;\r\n  bottom: 0;\r\n  display: flex;\r\n  background-color: #f4f7f9;\r\n  border-bottom-left-radius: 10px;\r\n  border-bottom-right-radius: 10px;\r\n  transition: background-color 0.2s ease, box-shadow 0.2s ease;\n}\n.sc-user-input--text {\r\n  width: 300px;\r\n  resize: none;\r\n  border: none;\r\n  outline: none;\r\n  border-bottom-left-radius: 10px;\r\n  box-sizing: border-box;\r\n  padding: 18px;\r\n  font-size: 15px;\r\n  font-weight: 400;\r\n  line-height: 1.33;\r\n  white-space: pre-wrap;\r\n  word-wrap: break-word;\r\n  color: #565867;\r\n  -webkit-font-smoothing: antialiased;\r\n  max-height: 200px;\r\n  overflow: scroll;\r\n  bottom: 0;\r\n  overflow-x: hidden;\r\n  overflow-y: auto;\n}\n.sc-user-input--text:empty:before {\r\n  content: attr(placeholder);\r\n  display: block; /* For Firefox */\r\n  /* color: rgba(86, 88, 103, 0.3); */\r\n  filter: contrast(15%);\r\n  outline: none;\r\n  cursor: text;\n}\n.sc-user-input--buttons {\r\n  width: 100px;\r\n  position: absolute;\r\n  right: 30px;\r\n  height: 100%;\r\n  display: flex;\r\n  justify-content: flex-end;\n}\n.sc-user-input--button:first-of-type {\r\n  width: 40px;\n}\n.sc-user-input--button {\r\n  width: 30px;\r\n  height: 55px;\r\n  margin-left: 2px;\r\n  margin-right: 2px;\r\n  display: flex;\r\n  flex-direction: column;\r\n  justify-content: center;\n}\n.sc-user-input.active {\r\n  box-shadow: none;\r\n  background-color: white;\r\n  box-shadow: 0px -5px 20px 0px rgba(150, 165, 190, 0.2);\n}\n.sc-user-input--button label {\r\n  position: relative;\r\n  height: 24px;\r\n  padding-left: 3px;\r\n  cursor: pointer;\n}\n.sc-user-input--button label:hover path {\r\n  fill: rgba(86, 88, 103, 1);\n}\n.sc-user-input--button input {\r\n  position: absolute;\r\n  left: 0;\r\n  top: 0;\r\n  width: 100%;\r\n  z-index: 99999;\r\n  height: 100%;\r\n  opacity: 0;\r\n  cursor: pointer;\r\n  overflow: hidden;\n}\n.file-container {\r\n  background-color: #f4f7f9;\r\n  border-top-left-radius: 10px;\r\n  padding: 5px 20px;\r\n  color: #565867;\n}\n.delete-file-message {\r\n  font-style: normal;\r\n  float: right;\r\n  cursor: pointer;\r\n  color: #c8cad0;\n}\n.delete-file-message:hover {\r\n  color: #5d5e6d;\n}\n.icon-file-message {\r\n  margin-right: 5px;\n}\r\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/UserInputButton.vue?vue&type=style&index=0&id=5fefb294&scoped=true&lang=css&":

/*!*********************************************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/UserInputButton.vue?vue&type=style&index=0&id=5fefb294&scoped=true&lang=css& ***!

  \*********************************************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\n.sc-user-input--button-icon-wrapper[data-v-5fefb294] {\r\n  background: none;\r\n  border: none;\r\n  padding: 0px;\r\n  margin: 0px;\r\n  outline: none;\r\n  cursor: pointer;\n}\r\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/components/UserList.vue?vue&type=style&index=0&id=3c9e9bf4&scoped=true&lang=css&":

/*!**************************************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/components/UserList.vue?vue&type=style&index=0&id=3c9e9bf4&scoped=true&lang=css& ***!

  \**************************************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\n.user-list[data-v-3c9e9bf4] {\r\n  height: 100%;\r\n  overflow: auto;\r\n  padding-left: 5px;\r\n  padding-top: 5px;\n}\n.img-msg[data-v-3c9e9bf4] {\r\n  border-radius: 50%;\r\n  width: 36px;;\r\n  margin-right: 5px;\n}\n.user-element[data-v-3c9e9bf4] {\r\n  font-size: 17px;\r\n  vertical-align: middle;\r\n  padding-left:2px;\n}\r\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/icons/EmojiIcon.vue?vue&type=style&index=0&id=0336c3fc&scoped=true&lang=css&":

/*!**********************************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/icons/EmojiIcon.vue?vue&type=style&index=0&id=0336c3fc&scoped=true&lang=css& ***!

  \**********************************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\n.sc-user-input--emoji-icon-wrapper[data-v-0336c3fc] {\r\n  background: none;\r\n  border: none;\r\n  padding: 0px;\r\n  margin: 0px;\r\n  outline: none;\n}\n.sc-user-input--emoji-icon-wrapper[data-v-0336c3fc]:focus {\r\n  outline: none;\n}\n.sc-user-input--emoji-icon[data-v-0336c3fc] {\r\n  height: 18px;\r\n  cursor: pointer;\r\n  align-self: center;\n}\n.sc-user-input--emoji-icon-wrapper:focus .sc-user-input--emoji-icon path[data-v-0336c3fc],\r\n.sc-user-input--emoji-icon-wrapper:focus .sc-user-input--emoji-icon circle[data-v-0336c3fc],\r\n.sc-user-input--emoji-icon.active path[data-v-0336c3fc],\r\n.sc-user-input--emoji-icon.active circle[data-v-0336c3fc],\r\n.sc-user-input--emoji-icon:hover path[data-v-0336c3fc],\r\n.sc-user-input--emoji-icon:hover circle[data-v-0336c3fc] {\r\n  filter: contrast(15%);\n}\r\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/icons/FileIcons.vue?vue&type=style&index=0&id=66fa0cca&scoped=true&lang=css&":

/*!**********************************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/icons/FileIcons.vue?vue&type=style&index=0&id=66fa0cca&scoped=true&lang=css& ***!

  \**********************************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\n#file-input[data-v-66fa0cca] {\r\n  cursor: pointer;\n}\n.sc-user-input--file-icon-wrapper[data-v-66fa0cca] {\r\n  background: none;\r\n  border: none;\r\n  padding: 0px;\r\n  margin: 0px;\r\n  outline: none;\r\n  cursor: pointer;\n}\n.sc-user-input--file-icon[data-v-66fa0cca] {\r\n  height: 20px;\r\n  width: 20px;\r\n  align-self: center;\r\n  outline: none;\n}\n.sc-user-input--file-icon:hover path[data-v-66fa0cca] {\r\n  filter: contrast(15%);\n}\r\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/messages/EmojiMessage.vue?vue&type=style&index=0&id=7e770954&scoped=true&lang=css&":

/*!****************************************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/messages/EmojiMessage.vue?vue&type=style&index=0&id=7e770954&scoped=true&lang=css& ***!

  \****************************************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\n.sc-message--emoji[data-v-7e770954] {\n  font-size: 40px;\n}\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/messages/FileMessage.vue?vue&type=style&index=0&id=1bde7ff4&scoped=true&lang=css&":

/*!***************************************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/messages/FileMessage.vue?vue&type=style&index=0&id=1bde7ff4&scoped=true&lang=css& ***!

  \***************************************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\n.sc-message--file[data-v-1bde7ff4] {\r\n  border-radius: 6px !important;\r\n  font-weight: 300;\r\n  font-size: 14px;\r\n  line-height: 1.4;\r\n  -webkit-font-smoothing: subpixel-antialiased;\n}\n.sc-message--content.sent .sc-message--file[data-v-1bde7ff4] {\r\n  word-wrap: break-word;\n}\n.sc-message--file-icon[data-v-1bde7ff4] {\r\n  text-align: center;\r\n  margin-left: auto;\r\n  margin-right: auto;\r\n  margin-top: 15px;\r\n  margin-bottom: 0px;\n}\n.sc-image[data-v-1bde7ff4] {\r\n  max-width: 100%;\r\n  min-width: 100%;\n}\n.sc-message--file-text[data-v-1bde7ff4] {\r\n  padding: 17px 20px;\r\n  border-radius: 6px;\r\n  font-weight: 300;\r\n  font-size: 14px;\r\n  line-height: 1.4;\r\n /* white-space: pre-wrap;\r\n  -webkit-font-smoothing: subpixel-antialiased;*/\n}\n.sc-message--file-name[data-v-1bde7ff4] {\r\n  color: white;\r\n  padding-left: 15px;\r\n  padding-right: 15px;\r\n  padding-top: 0;\r\n  font-size: x-small;\r\n  text-align: center;\n}\n.sc-message--file-name a[data-v-1bde7ff4] {\r\n  text-decoration: none;\r\n  color: #ece7e7;\n}\n.sc-message--file-name a[data-v-1bde7ff4]:hover {\r\n  color: white;\n}\n.sc-message--content.sent .sc-message--file-text[data-v-1bde7ff4] {\r\n  color: white;\r\n  background-color: #4e8cff;\r\n  word-wrap: break-word;\n}\n.sc-message--content.received .sc-message--file[data-v-1bde7ff4] {\r\n  color: #263238;\r\n  background-color: #f4f7f9;\r\n  margin-right: 40px;\r\n  word-wrap: break-word;\n}\n.sc-message--content.received .sc-message--file-name[data-v-1bde7ff4] {\r\n  color: #000;\n}\n.sc-message--content.received .sc-message--file a[data-v-1bde7ff4] {\r\n  color: rgba(43, 40, 40, 0.7);\n}\n.sc-message--content.received .sc-message--file a[data-v-1bde7ff4]:hover {\r\n  color: #0c0c0c;\n}\n.sc-message--file-att-name[data-v-1bde7ff4]{font-size: 13px;line-height: 16px; padding:10px 2px; border-radius:6px;}\n.sc-message--file-name-link[data-v-1bde7ff4]{ color: #888888 !important;}\n.sc-message--file-name-link[data-v-1bde7ff4]:hover{ color: #0c0c0c !important;}\r\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/messages/SystemMessage.vue?vue&type=style&index=0&id=e1131e9a&scoped=true&lang=css&":

/*!*****************************************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/messages/SystemMessage.vue?vue&type=style&index=0&id=e1131e9a&scoped=true&lang=css& ***!

  \*****************************************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\n.sc-message--system[data-v-e1131e9a] {\n  padding: 8px 20px;\n  border-radius: 6px;\n  font-weight: 300;\n  font-size: 12px;\n  line-height: 1.2;\n  white-space: pre-wrap;\n  -webkit-font-smoothing: subpixel-antialiased;\n  font-style: italic;\n  opacity: 0.55;\n}\n.sc-message--meta[data-v-e1131e9a] {\n  font-size: xx-small;\n  margin-bottom: 0px;\n  margin-top: 5px;\n  opacity: 0.5;\n  text-align: center;\n}\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/messages/TextMessage.vue?vue&type=style&index=0&id=13b33096&scoped=true&lang=css&":

/*!***************************************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/messages/TextMessage.vue?vue&type=style&index=0&id=13b33096&scoped=true&lang=css& ***!

  \***************************************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\na.chatLink[data-v-13b33096] {\r\n  color: inherit !important;\n}\r\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/index.js?!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/messages/TypingMessage.vue?vue&type=style&index=0&id=5277c06b&scoped=true&lang=css&":

/*!*****************************************************************************************************************************************************************************************************************************************************************************************************!*\

  !*** ./node_modules/css-loader??ref--6-1!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/src??ref--6-2!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/messages/TypingMessage.vue?vue&type=style&index=0&id=5277c06b&scoped=true&lang=css& ***!

  \*****************************************************************************************************************************************************************************************************************************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



exports = module.exports = __webpack_require__(/*! ../../../node_modules/css-loader/lib/css-base.js */ "./node_modules/css-loader/lib/css-base.js")(false);

// imports





// module

exports.push([module.i, "\n.sc-typing-indicator[data-v-5277c06b] {\n  text-align: center;\n  padding: 17px 20px;\n  border-radius: 6px;\n}\n.sc-typing-indicator span[data-v-5277c06b] {\n  display: inline-block;\n  background-color: #b6b5ba;\n  width: 10px;\n  height: 10px;\n  border-radius: 100%;\n  margin-right: 3px;\n  -webkit-animation: bob-data-v-5277c06b 2s infinite;\n          animation: bob-data-v-5277c06b 2s infinite;\n}\n\n/* SAFARI GLITCH */\n.sc-typing-indicator span[data-v-5277c06b]:nth-child(1) {\n  -webkit-animation-delay: -1s;\n          animation-delay: -1s;\n}\n.sc-typing-indicator span[data-v-5277c06b]:nth-child(2) {\n  -webkit-animation-delay: -0.85s;\n          animation-delay: -0.85s;\n}\n.sc-typing-indicator span[data-v-5277c06b]:nth-child(3) {\n  -webkit-animation-delay: -0.7s;\n          animation-delay: -0.7s;\n}\n@-webkit-keyframes bob-data-v-5277c06b {\n10% {\n    transform: translateY(-10px);\n    background-color: #9e9da2;\n}\n50% {\n    transform: translateY(0);\n    background-color: #b6b5ba;\n}\n}\n@keyframes bob-data-v-5277c06b {\n10% {\n    transform: translateY(-10px);\n    background-color: #9e9da2;\n}\n50% {\n    transform: translateY(0);\n    background-color: #b6b5ba;\n}\n}\n", ""]);



// exports





/***/ }),



/***/ "./node_modules/css-loader/lib/css-base.js":

/*!*************************************************!*\

  !*** ./node_modules/css-loader/lib/css-base.js ***!

  \*************************************************/

/*! no static exports found */

/***/ (function(module, exports) {



/*

	MIT License http://www.opensource.org/licenses/mit-license.php

	Author Tobias Koppers @sokra

*/

// css base code, injected by the css-loader

module.exports = function(useSourceMap) {

	var list = [];



	// return the list of modules as css string

	list.toString = function toString() {

		return this.map(function (item) {

			var content = cssWithMappingToString(item, useSourceMap);

			if(item[2]) {

				return "@media " + item[2] + "{" + content + "}";

			} else {

				return content;

			}

		}).join("");

	};



	// import a list of modules into the list

	list.i = function(modules, mediaQuery) {

		if(typeof modules === "string")

			modules = [[null, modules, ""]];

		var alreadyImportedModules = {};

		for(var i = 0; i < this.length; i++) {

			var id = this[i][0];

			if(typeof id === "number")

				alreadyImportedModules[id] = true;

		}

		for(i = 0; i < modules.length; i++) {

			var item = modules[i];

			// skip already imported module

			// this implementation is not 100% perfect for weird media query combinations

			//  when a module is imported multiple times with different media queries.

			//  I hope this will never occur (Hey this way we have smaller bundles)

			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {

				if(mediaQuery && !item[2]) {

					item[2] = mediaQuery;

				} else if(mediaQuery) {

					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";

				}

				list.push(item);

			}

		}

	};

	return list;

};



function cssWithMappingToString(item, useSourceMap) {

	var content = item[1] || '';

	var cssMapping = item[3];

	if (!cssMapping) {

		return content;

	}



	if (useSourceMap && typeof btoa === 'function') {

		var sourceMapping = toComment(cssMapping);

		var sourceURLs = cssMapping.sources.map(function (source) {

			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'

		});



		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');

	}



	return [content].join('\n');

}



// Adapted from convert-source-map (MIT)

function toComment(sourceMap) {

	// eslint-disable-next-line no-undef

	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));

	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;



	return '/*# ' + data + ' */';

}





/***/ }),



/***/ "./node_modules/date-fns/_lib/getTimezoneOffsetInMilliseconds/index.js":

/*!*****************************************************************************!*\

  !*** ./node_modules/date-fns/_lib/getTimezoneOffsetInMilliseconds/index.js ***!

  \*****************************************************************************/

/*! no static exports found */

/***/ (function(module, exports) {



var MILLISECONDS_IN_MINUTE = 60000



/**

 * Google Chrome as of 67.0.3396.87 introduced timezones with offset that includes seconds.

 * They usually appear for dates that denote time before the timezones were introduced

 * (e.g. for 'Europe/Prague' timezone the offset is GMT+00:57:44 before 1 October 1891

 * and GMT+01:00:00 after that date)

 *

 * Date#getTimezoneOffset returns the offset in minutes and would return 57 for the example above,

 * which would lead to incorrect calculations.

 *

 * This function returns the timezone offset in milliseconds that takes seconds in account.

 */

module.exports = function getTimezoneOffsetInMilliseconds (dirtyDate) {

  var date = new Date(dirtyDate.getTime())

  var baseTimezoneOffset = date.getTimezoneOffset()

  date.setSeconds(0, 0)

  var millisecondsPartOfTimezoneOffset = date.getTime() % MILLISECONDS_IN_MINUTE



  return baseTimezoneOffset * MILLISECONDS_IN_MINUTE + millisecondsPartOfTimezoneOffset

}





/***/ }),



/***/ "./node_modules/date-fns/compare_asc/index.js":

/*!****************************************************!*\

  !*** ./node_modules/date-fns/compare_asc/index.js ***!

  \****************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



var parse = __webpack_require__(/*! ../parse/index.js */ "./node_modules/date-fns/parse/index.js")



/**

 * @category Common Helpers

 * @summary Compare the two dates and return -1, 0 or 1.

 *

 * @description

 * Compare the two dates and return 1 if the first date is after the second,

 * -1 if the first date is before the second or 0 if dates are equal.

 *

 * @param {Date|String|Number} dateLeft - the first date to compare

 * @param {Date|String|Number} dateRight - the second date to compare

 * @returns {Number} the result of the comparison

 *

 * @example

 * // Compare 11 February 1987 and 10 July 1989:

 * var result = compareAsc(

 *   new Date(1987, 1, 11),

 *   new Date(1989, 6, 10)

 * )

 * //=> -1

 *

 * @example

 * // Sort the array of dates:

 * var result = [

 *   new Date(1995, 6, 2),

 *   new Date(1987, 1, 11),

 *   new Date(1989, 6, 10)

 * ].sort(compareAsc)

 * //=> [

 * //   Wed Feb 11 1987 00:00:00,

 * //   Mon Jul 10 1989 00:00:00,

 * //   Sun Jul 02 1995 00:00:00

 * // ]

 */

function compareAsc (dirtyDateLeft, dirtyDateRight) {

  var dateLeft = parse(dirtyDateLeft)

  var timeLeft = dateLeft.getTime()

  var dateRight = parse(dirtyDateRight)

  var timeRight = dateRight.getTime()



  if (timeLeft < timeRight) {

    return -1

  } else if (timeLeft > timeRight) {

    return 1

  } else {

    return 0

  }

}



module.exports = compareAsc





/***/ }),



/***/ "./node_modules/date-fns/compare_desc/index.js":

/*!*****************************************************!*\

  !*** ./node_modules/date-fns/compare_desc/index.js ***!

  \*****************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



var parse = __webpack_require__(/*! ../parse/index.js */ "./node_modules/date-fns/parse/index.js")



/**

 * @category Common Helpers

 * @summary Compare the two dates reverse chronologically and return -1, 0 or 1.

 *

 * @description

 * Compare the two dates and return -1 if the first date is after the second,

 * 1 if the first date is before the second or 0 if dates are equal.

 *

 * @param {Date|String|Number} dateLeft - the first date to compare

 * @param {Date|String|Number} dateRight - the second date to compare

 * @returns {Number} the result of the comparison

 *

 * @example

 * // Compare 11 February 1987 and 10 July 1989 reverse chronologically:

 * var result = compareDesc(

 *   new Date(1987, 1, 11),

 *   new Date(1989, 6, 10)

 * )

 * //=> 1

 *

 * @example

 * // Sort the array of dates in reverse chronological order:

 * var result = [

 *   new Date(1995, 6, 2),

 *   new Date(1987, 1, 11),

 *   new Date(1989, 6, 10)

 * ].sort(compareDesc)

 * //=> [

 * //   Sun Jul 02 1995 00:00:00,

 * //   Mon Jul 10 1989 00:00:00,

 * //   Wed Feb 11 1987 00:00:00

 * // ]

 */

function compareDesc (dirtyDateLeft, dirtyDateRight) {

  var dateLeft = parse(dirtyDateLeft)

  var timeLeft = dateLeft.getTime()

  var dateRight = parse(dirtyDateRight)

  var timeRight = dateRight.getTime()



  if (timeLeft > timeRight) {

    return -1

  } else if (timeLeft < timeRight) {

    return 1

  } else {

    return 0

  }

}



module.exports = compareDesc





/***/ }),



/***/ "./node_modules/date-fns/difference_in_calendar_months/index.js":

/*!**********************************************************************!*\

  !*** ./node_modules/date-fns/difference_in_calendar_months/index.js ***!

  \**********************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



var parse = __webpack_require__(/*! ../parse/index.js */ "./node_modules/date-fns/parse/index.js")



/**

 * @category Month Helpers

 * @summary Get the number of calendar months between the given dates.

 *

 * @description

 * Get the number of calendar months between the given dates.

 *

 * @param {Date|String|Number} dateLeft - the later date

 * @param {Date|String|Number} dateRight - the earlier date

 * @returns {Number} the number of calendar months

 *

 * @example

 * // How many calendar months are between 31 January 2014 and 1 September 2014?

 * var result = differenceInCalendarMonths(

 *   new Date(2014, 8, 1),

 *   new Date(2014, 0, 31)

 * )

 * //=> 8

 */

function differenceInCalendarMonths (dirtyDateLeft, dirtyDateRight) {

  var dateLeft = parse(dirtyDateLeft)

  var dateRight = parse(dirtyDateRight)



  var yearDiff = dateLeft.getFullYear() - dateRight.getFullYear()

  var monthDiff = dateLeft.getMonth() - dateRight.getMonth()



  return yearDiff * 12 + monthDiff

}



module.exports = differenceInCalendarMonths





/***/ }),



/***/ "./node_modules/date-fns/difference_in_milliseconds/index.js":

/*!*******************************************************************!*\

  !*** ./node_modules/date-fns/difference_in_milliseconds/index.js ***!

  \*******************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



var parse = __webpack_require__(/*! ../parse/index.js */ "./node_modules/date-fns/parse/index.js")



/**

 * @category Millisecond Helpers

 * @summary Get the number of milliseconds between the given dates.

 *

 * @description

 * Get the number of milliseconds between the given dates.

 *

 * @param {Date|String|Number} dateLeft - the later date

 * @param {Date|String|Number} dateRight - the earlier date

 * @returns {Number} the number of milliseconds

 *

 * @example

 * // How many milliseconds are between

 * // 2 July 2014 12:30:20.600 and 2 July 2014 12:30:21.700?

 * var result = differenceInMilliseconds(

 *   new Date(2014, 6, 2, 12, 30, 21, 700),

 *   new Date(2014, 6, 2, 12, 30, 20, 600)

 * )

 * //=> 1100

 */

function differenceInMilliseconds (dirtyDateLeft, dirtyDateRight) {

  var dateLeft = parse(dirtyDateLeft)

  var dateRight = parse(dirtyDateRight)

  return dateLeft.getTime() - dateRight.getTime()

}



module.exports = differenceInMilliseconds





/***/ }),



/***/ "./node_modules/date-fns/difference_in_months/index.js":

/*!*************************************************************!*\

  !*** ./node_modules/date-fns/difference_in_months/index.js ***!

  \*************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



var parse = __webpack_require__(/*! ../parse/index.js */ "./node_modules/date-fns/parse/index.js")

var differenceInCalendarMonths = __webpack_require__(/*! ../difference_in_calendar_months/index.js */ "./node_modules/date-fns/difference_in_calendar_months/index.js")

var compareAsc = __webpack_require__(/*! ../compare_asc/index.js */ "./node_modules/date-fns/compare_asc/index.js")



/**

 * @category Month Helpers

 * @summary Get the number of full months between the given dates.

 *

 * @description

 * Get the number of full months between the given dates.

 *

 * @param {Date|String|Number} dateLeft - the later date

 * @param {Date|String|Number} dateRight - the earlier date

 * @returns {Number} the number of full months

 *

 * @example

 * // How many full months are between 31 January 2014 and 1 September 2014?

 * var result = differenceInMonths(

 *   new Date(2014, 8, 1),

 *   new Date(2014, 0, 31)

 * )

 * //=> 7

 */

function differenceInMonths (dirtyDateLeft, dirtyDateRight) {

  var dateLeft = parse(dirtyDateLeft)

  var dateRight = parse(dirtyDateRight)



  var sign = compareAsc(dateLeft, dateRight)

  var difference = Math.abs(differenceInCalendarMonths(dateLeft, dateRight))

  dateLeft.setMonth(dateLeft.getMonth() - sign * difference)



  // Math.abs(diff in full months - diff in calendar months) === 1 if last calendar month is not full

  // If so, result must be decreased by 1 in absolute value

  var isLastMonthNotFull = compareAsc(dateLeft, dateRight) === -sign

  return sign * (difference - isLastMonthNotFull)

}



module.exports = differenceInMonths





/***/ }),



/***/ "./node_modules/date-fns/difference_in_seconds/index.js":

/*!**************************************************************!*\

  !*** ./node_modules/date-fns/difference_in_seconds/index.js ***!

  \**************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



var differenceInMilliseconds = __webpack_require__(/*! ../difference_in_milliseconds/index.js */ "./node_modules/date-fns/difference_in_milliseconds/index.js")



/**

 * @category Second Helpers

 * @summary Get the number of seconds between the given dates.

 *

 * @description

 * Get the number of seconds between the given dates.

 *

 * @param {Date|String|Number} dateLeft - the later date

 * @param {Date|String|Number} dateRight - the earlier date

 * @returns {Number} the number of seconds

 *

 * @example

 * // How many seconds are between

 * // 2 July 2014 12:30:07.999 and 2 July 2014 12:30:20.000?

 * var result = differenceInSeconds(

 *   new Date(2014, 6, 2, 12, 30, 20, 0),

 *   new Date(2014, 6, 2, 12, 30, 7, 999)

 * )

 * //=> 12

 */

function differenceInSeconds (dirtyDateLeft, dirtyDateRight) {

  var diff = differenceInMilliseconds(dirtyDateLeft, dirtyDateRight) / 1000

  return diff > 0 ? Math.floor(diff) : Math.ceil(diff)

}



module.exports = differenceInSeconds





/***/ }),



/***/ "./node_modules/date-fns/distance_in_words/index.js":

/*!**********************************************************!*\

  !*** ./node_modules/date-fns/distance_in_words/index.js ***!

  \**********************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



var compareDesc = __webpack_require__(/*! ../compare_desc/index.js */ "./node_modules/date-fns/compare_desc/index.js")

var parse = __webpack_require__(/*! ../parse/index.js */ "./node_modules/date-fns/parse/index.js")

var differenceInSeconds = __webpack_require__(/*! ../difference_in_seconds/index.js */ "./node_modules/date-fns/difference_in_seconds/index.js")

var differenceInMonths = __webpack_require__(/*! ../difference_in_months/index.js */ "./node_modules/date-fns/difference_in_months/index.js")

var enLocale = __webpack_require__(/*! ../locale/en/index.js */ "./node_modules/date-fns/locale/en/index.js")



var MINUTES_IN_DAY = 1440

var MINUTES_IN_ALMOST_TWO_DAYS = 2520

var MINUTES_IN_MONTH = 43200

var MINUTES_IN_TWO_MONTHS = 86400



/**

 * @category Common Helpers

 * @summary Return the distance between the given dates in words.

 *

 * @description

 * Return the distance between the given dates in words.

 *

 * | Distance between dates                                            | Result              |

 * |-------------------------------------------------------------------|---------------------|

 * | 0 ... 30 secs                                                     | less than a minute  |

 * | 30 secs ... 1 min 30 secs                                         | 1 minute            |

 * | 1 min 30 secs ... 44 mins 30 secs                                 | [2..44] minutes     |

 * | 44 mins ... 30 secs ... 89 mins 30 secs                           | about 1 hour        |

 * | 89 mins 30 secs ... 23 hrs 59 mins 30 secs                        | about [2..24] hours |

 * | 23 hrs 59 mins 30 secs ... 41 hrs 59 mins 30 secs                 | 1 day               |

 * | 41 hrs 59 mins 30 secs ... 29 days 23 hrs 59 mins 30 secs         | [2..30] days        |

 * | 29 days 23 hrs 59 mins 30 secs ... 44 days 23 hrs 59 mins 30 secs | about 1 month       |

 * | 44 days 23 hrs 59 mins 30 secs ... 59 days 23 hrs 59 mins 30 secs | about 2 months      |

 * | 59 days 23 hrs 59 mins 30 secs ... 1 yr                           | [2..12] months      |

 * | 1 yr ... 1 yr 3 months                                            | about 1 year        |

 * | 1 yr 3 months ... 1 yr 9 month s                                  | over 1 year         |

 * | 1 yr 9 months ... 2 yrs                                           | almost 2 years      |

 * | N yrs ... N yrs 3 months                                          | about N years       |

 * | N yrs 3 months ... N yrs 9 months                                 | over N years        |

 * | N yrs 9 months ... N+1 yrs                                        | almost N+1 years    |

 *

 * With `options.includeSeconds == true`:

 * | Distance between dates | Result               |

 * |------------------------|----------------------|

 * | 0 secs ... 5 secs      | less than 5 seconds  |

 * | 5 secs ... 10 secs     | less than 10 seconds |

 * | 10 secs ... 20 secs    | less than 20 seconds |

 * | 20 secs ... 40 secs    | half a minute        |

 * | 40 secs ... 60 secs    | less than a minute   |

 * | 60 secs ... 90 secs    | 1 minute             |

 *

 * @param {Date|String|Number} dateToCompare - the date to compare with

 * @param {Date|String|Number} date - the other date

 * @param {Object} [options] - the object with options

 * @param {Boolean} [options.includeSeconds=false] - distances less than a minute are more detailed

 * @param {Boolean} [options.addSuffix=false] - result indicates if the second date is earlier or later than the first

 * @param {Object} [options.locale=enLocale] - the locale object

 * @returns {String} the distance in words

 *

 * @example

 * // What is the distance between 2 July 2014 and 1 January 2015?

 * var result = distanceInWords(

 *   new Date(2014, 6, 2),

 *   new Date(2015, 0, 1)

 * )

 * //=> '6 months'

 *

 * @example

 * // What is the distance between 1 January 2015 00:00:15

 * // and 1 January 2015 00:00:00, including seconds?

 * var result = distanceInWords(

 *   new Date(2015, 0, 1, 0, 0, 15),

 *   new Date(2015, 0, 1, 0, 0, 0),

 *   {includeSeconds: true}

 * )

 * //=> 'less than 20 seconds'

 *

 * @example

 * // What is the distance from 1 January 2016

 * // to 1 January 2015, with a suffix?

 * var result = distanceInWords(

 *   new Date(2016, 0, 1),

 *   new Date(2015, 0, 1),

 *   {addSuffix: true}

 * )

 * //=> 'about 1 year ago'

 *

 * @example

 * // What is the distance between 1 August 2016 and 1 January 2015 in Esperanto?

 * var eoLocale = require('date-fns/locale/eo')

 * var result = distanceInWords(

 *   new Date(2016, 7, 1),

 *   new Date(2015, 0, 1),

 *   {locale: eoLocale}

 * )

 * //=> 'pli ol 1 jaro'

 */

function distanceInWords (dirtyDateToCompare, dirtyDate, dirtyOptions) {

  var options = dirtyOptions || {}



  var comparison = compareDesc(dirtyDateToCompare, dirtyDate)



  var locale = options.locale

  var localize = enLocale.distanceInWords.localize

  if (locale && locale.distanceInWords && locale.distanceInWords.localize) {

    localize = locale.distanceInWords.localize

  }



  var localizeOptions = {

    addSuffix: Boolean(options.addSuffix),

    comparison: comparison

  }



  var dateLeft, dateRight

  if (comparison > 0) {

    dateLeft = parse(dirtyDateToCompare)

    dateRight = parse(dirtyDate)

  } else {

    dateLeft = parse(dirtyDate)

    dateRight = parse(dirtyDateToCompare)

  }



  var seconds = differenceInSeconds(dateRight, dateLeft)

  var offset = dateRight.getTimezoneOffset() - dateLeft.getTimezoneOffset()

  var minutes = Math.round(seconds / 60) - offset

  var months



  // 0 up to 2 mins

  if (minutes < 2) {

    if (options.includeSeconds) {

      if (seconds < 5) {

        return localize('lessThanXSeconds', 5, localizeOptions)

      } else if (seconds < 10) {

        return localize('lessThanXSeconds', 10, localizeOptions)

      } else if (seconds < 20) {

        return localize('lessThanXSeconds', 20, localizeOptions)

      } else if (seconds < 40) {

        return localize('halfAMinute', null, localizeOptions)

      } else if (seconds < 60) {

        return localize('lessThanXMinutes', 1, localizeOptions)

      } else {

        return localize('xMinutes', 1, localizeOptions)

      }

    } else {

      if (minutes === 0) {

        return localize('lessThanXMinutes', 1, localizeOptions)

      } else {

        return localize('xMinutes', minutes, localizeOptions)

      }

    }



  // 2 mins up to 0.75 hrs

  } else if (minutes < 45) {

    return localize('xMinutes', minutes, localizeOptions)



  // 0.75 hrs up to 1.5 hrs

  } else if (minutes < 90) {

    return localize('aboutXHours', 1, localizeOptions)



  // 1.5 hrs up to 24 hrs

  } else if (minutes < MINUTES_IN_DAY) {

    var hours = Math.round(minutes / 60)

    return localize('aboutXHours', hours, localizeOptions)



  // 1 day up to 1.75 days

  } else if (minutes < MINUTES_IN_ALMOST_TWO_DAYS) {

    return localize('xDays', 1, localizeOptions)



  // 1.75 days up to 30 days

  } else if (minutes < MINUTES_IN_MONTH) {

    var days = Math.round(minutes / MINUTES_IN_DAY)

    return localize('xDays', days, localizeOptions)



  // 1 month up to 2 months

  } else if (minutes < MINUTES_IN_TWO_MONTHS) {

    months = Math.round(minutes / MINUTES_IN_MONTH)

    return localize('aboutXMonths', months, localizeOptions)

  }



  months = differenceInMonths(dateRight, dateLeft)



  // 2 months up to 12 months

  if (months < 12) {

    var nearestMonth = Math.round(minutes / MINUTES_IN_MONTH)

    return localize('xMonths', nearestMonth, localizeOptions)



  // 1 year up to max Date

  } else {

    var monthsSinceStartOfYear = months % 12

    var years = Math.floor(months / 12)



    // N years up to 1 years 3 months

    if (monthsSinceStartOfYear < 3) {

      return localize('aboutXYears', years, localizeOptions)



    // N years 3 months up to N years 9 months

    } else if (monthsSinceStartOfYear < 9) {

      return localize('overXYears', years, localizeOptions)



    // N years 9 months up to N year 12 months

    } else {

      return localize('almostXYears', years + 1, localizeOptions)

    }

  }

}



module.exports = distanceInWords





/***/ }),



/***/ "./node_modules/date-fns/distance_in_words_strict/index.js":

/*!*****************************************************************!*\

  !*** ./node_modules/date-fns/distance_in_words_strict/index.js ***!

  \*****************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



var compareDesc = __webpack_require__(/*! ../compare_desc/index.js */ "./node_modules/date-fns/compare_desc/index.js")

var parse = __webpack_require__(/*! ../parse/index.js */ "./node_modules/date-fns/parse/index.js")

var differenceInSeconds = __webpack_require__(/*! ../difference_in_seconds/index.js */ "./node_modules/date-fns/difference_in_seconds/index.js")

var enLocale = __webpack_require__(/*! ../locale/en/index.js */ "./node_modules/date-fns/locale/en/index.js")



var MINUTES_IN_DAY = 1440

var MINUTES_IN_MONTH = 43200

var MINUTES_IN_YEAR = 525600



/**

 * @category Common Helpers

 * @summary Return the distance between the given dates in words.

 *

 * @description

 * Return the distance between the given dates in words, using strict units.

 * This is like `distanceInWords`, but does not use helpers like 'almost', 'over',

 * 'less than' and the like.

 *

 * | Distance between dates | Result              |

 * |------------------------|---------------------|

 * | 0 ... 59 secs          | [0..59] seconds     |

 * | 1 ... 59 mins          | [1..59] minutes     |

 * | 1 ... 23 hrs           | [1..23] hours       |

 * | 1 ... 29 days          | [1..29] days        |

 * | 1 ... 11 months        | [1..11] months      |

 * | 1 ... N years          | [1..N]  years       |

 *

 * @param {Date|String|Number} dateToCompare - the date to compare with

 * @param {Date|String|Number} date - the other date

 * @param {Object} [options] - the object with options

 * @param {Boolean} [options.addSuffix=false] - result indicates if the second date is earlier or later than the first

 * @param {'s'|'m'|'h'|'d'|'M'|'Y'} [options.unit] - if specified, will force a unit

 * @param {'floor'|'ceil'|'round'} [options.partialMethod='floor'] - which way to round partial units

 * @param {Object} [options.locale=enLocale] - the locale object

 * @returns {String} the distance in words

 *

 * @example

 * // What is the distance between 2 July 2014 and 1 January 2015?

 * var result = distanceInWordsStrict(

 *   new Date(2014, 6, 2),

 *   new Date(2015, 0, 2)

 * )

 * //=> '6 months'

 *

 * @example

 * // What is the distance between 1 January 2015 00:00:15

 * // and 1 January 2015 00:00:00?

 * var result = distanceInWordsStrict(

 *   new Date(2015, 0, 1, 0, 0, 15),

 *   new Date(2015, 0, 1, 0, 0, 0),

 * )

 * //=> '15 seconds'

 *

 * @example

 * // What is the distance from 1 January 2016

 * // to 1 January 2015, with a suffix?

 * var result = distanceInWordsStrict(

 *   new Date(2016, 0, 1),

 *   new Date(2015, 0, 1),

 *   {addSuffix: true}

 * )

 * //=> '1 year ago'

 *

 * @example

 * // What is the distance from 1 January 2016

 * // to 1 January 2015, in minutes?

 * var result = distanceInWordsStrict(

 *   new Date(2016, 0, 1),

 *   new Date(2015, 0, 1),

 *   {unit: 'm'}

 * )

 * //=> '525600 minutes'

 *

 * @example

 * // What is the distance from 1 January 2016

 * // to 28 January 2015, in months, rounded up?

 * var result = distanceInWordsStrict(

 *   new Date(2015, 0, 28),

 *   new Date(2015, 0, 1),

 *   {unit: 'M', partialMethod: 'ceil'}

 * )

 * //=> '1 month'

 *

 * @example

 * // What is the distance between 1 August 2016 and 1 January 2015 in Esperanto?

 * var eoLocale = require('date-fns/locale/eo')

 * var result = distanceInWordsStrict(

 *   new Date(2016, 7, 1),

 *   new Date(2015, 0, 1),

 *   {locale: eoLocale}

 * )

 * //=> '1 jaro'

 */

function distanceInWordsStrict (dirtyDateToCompare, dirtyDate, dirtyOptions) {

  var options = dirtyOptions || {}



  var comparison = compareDesc(dirtyDateToCompare, dirtyDate)



  var locale = options.locale

  var localize = enLocale.distanceInWords.localize

  if (locale && locale.distanceInWords && locale.distanceInWords.localize) {

    localize = locale.distanceInWords.localize

  }



  var localizeOptions = {

    addSuffix: Boolean(options.addSuffix),

    comparison: comparison

  }



  var dateLeft, dateRight

  if (comparison > 0) {

    dateLeft = parse(dirtyDateToCompare)

    dateRight = parse(dirtyDate)

  } else {

    dateLeft = parse(dirtyDate)

    dateRight = parse(dirtyDateToCompare)

  }



  var unit

  var mathPartial = Math[options.partialMethod ? String(options.partialMethod) : 'floor']

  var seconds = differenceInSeconds(dateRight, dateLeft)

  var offset = dateRight.getTimezoneOffset() - dateLeft.getTimezoneOffset()

  var minutes = mathPartial(seconds / 60) - offset

  var hours, days, months, years



  if (options.unit) {

    unit = String(options.unit)

  } else {

    if (minutes < 1) {

      unit = 's'

    } else if (minutes < 60) {

      unit = 'm'

    } else if (minutes < MINUTES_IN_DAY) {

      unit = 'h'

    } else if (minutes < MINUTES_IN_MONTH) {

      unit = 'd'

    } else if (minutes < MINUTES_IN_YEAR) {

      unit = 'M'

    } else {

      unit = 'Y'

    }

  }



  // 0 up to 60 seconds

  if (unit === 's') {

    return localize('xSeconds', seconds, localizeOptions)



  // 1 up to 60 mins

  } else if (unit === 'm') {

    return localize('xMinutes', minutes, localizeOptions)



  // 1 up to 24 hours

  } else if (unit === 'h') {

    hours = mathPartial(minutes / 60)

    return localize('xHours', hours, localizeOptions)



  // 1 up to 30 days

  } else if (unit === 'd') {

    days = mathPartial(minutes / MINUTES_IN_DAY)

    return localize('xDays', days, localizeOptions)



  // 1 up to 12 months

  } else if (unit === 'M') {

    months = mathPartial(minutes / MINUTES_IN_MONTH)

    return localize('xMonths', months, localizeOptions)



  // 1 year up to max Date

  } else if (unit === 'Y') {

    years = mathPartial(minutes / MINUTES_IN_YEAR)

    return localize('xYears', years, localizeOptions)

  }



  throw new Error('Unknown unit: ' + unit)

}



module.exports = distanceInWordsStrict





/***/ }),



/***/ "./node_modules/date-fns/distance_in_words_to_now/index.js":

/*!*****************************************************************!*\

  !*** ./node_modules/date-fns/distance_in_words_to_now/index.js ***!

  \*****************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



var distanceInWords = __webpack_require__(/*! ../distance_in_words/index.js */ "./node_modules/date-fns/distance_in_words/index.js")



/**

 * @category Common Helpers

 * @summary Return the distance between the given date and now in words.

 *

 * @description

 * Return the distance between the given date and now in words.

 *

 * | Distance to now                                                   | Result              |

 * |-------------------------------------------------------------------|---------------------|

 * | 0 ... 30 secs                                                     | less than a minute  |

 * | 30 secs ... 1 min 30 secs                                         | 1 minute            |

 * | 1 min 30 secs ... 44 mins 30 secs                                 | [2..44] minutes     |

 * | 44 mins ... 30 secs ... 89 mins 30 secs                           | about 1 hour        |

 * | 89 mins 30 secs ... 23 hrs 59 mins 30 secs                        | about [2..24] hours |

 * | 23 hrs 59 mins 30 secs ... 41 hrs 59 mins 30 secs                 | 1 day               |

 * | 41 hrs 59 mins 30 secs ... 29 days 23 hrs 59 mins 30 secs         | [2..30] days        |

 * | 29 days 23 hrs 59 mins 30 secs ... 44 days 23 hrs 59 mins 30 secs | about 1 month       |

 * | 44 days 23 hrs 59 mins 30 secs ... 59 days 23 hrs 59 mins 30 secs | about 2 months      |

 * | 59 days 23 hrs 59 mins 30 secs ... 1 yr                           | [2..12] months      |

 * | 1 yr ... 1 yr 3 months                                            | about 1 year        |

 * | 1 yr 3 months ... 1 yr 9 month s                                  | over 1 year         |

 * | 1 yr 9 months ... 2 yrs                                           | almost 2 years      |

 * | N yrs ... N yrs 3 months                                          | about N years       |

 * | N yrs 3 months ... N yrs 9 months                                 | over N years        |

 * | N yrs 9 months ... N+1 yrs                                        | almost N+1 years    |

 *

 * With `options.includeSeconds == true`:

 * | Distance to now     | Result               |

 * |---------------------|----------------------|

 * | 0 secs ... 5 secs   | less than 5 seconds  |

 * | 5 secs ... 10 secs  | less than 10 seconds |

 * | 10 secs ... 20 secs | less than 20 seconds |

 * | 20 secs ... 40 secs | half a minute        |

 * | 40 secs ... 60 secs | less than a minute   |

 * | 60 secs ... 90 secs | 1 minute             |

 *

 * @param {Date|String|Number} date - the given date

 * @param {Object} [options] - the object with options

 * @param {Boolean} [options.includeSeconds=false] - distances less than a minute are more detailed

 * @param {Boolean} [options.addSuffix=false] - result specifies if the second date is earlier or later than the first

 * @param {Object} [options.locale=enLocale] - the locale object

 * @returns {String} the distance in words

 *

 * @example

 * // If today is 1 January 2015, what is the distance to 2 July 2014?

 * var result = distanceInWordsToNow(

 *   new Date(2014, 6, 2)

 * )

 * //=> '6 months'

 *

 * @example

 * // If now is 1 January 2015 00:00:00,

 * // what is the distance to 1 January 2015 00:00:15, including seconds?

 * var result = distanceInWordsToNow(

 *   new Date(2015, 0, 1, 0, 0, 15),

 *   {includeSeconds: true}

 * )

 * //=> 'less than 20 seconds'

 *

 * @example

 * // If today is 1 January 2015,

 * // what is the distance to 1 January 2016, with a suffix?

 * var result = distanceInWordsToNow(

 *   new Date(2016, 0, 1),

 *   {addSuffix: true}

 * )

 * //=> 'in about 1 year'

 *

 * @example

 * // If today is 1 January 2015,

 * // what is the distance to 1 August 2016 in Esperanto?

 * var eoLocale = require('date-fns/locale/eo')

 * var result = distanceInWordsToNow(

 *   new Date(2016, 7, 1),

 *   {locale: eoLocale}

 * )

 * //=> 'pli ol 1 jaro'

 */

function distanceInWordsToNow (dirtyDate, dirtyOptions) {

  return distanceInWords(Date.now(), dirtyDate, dirtyOptions)

}



module.exports = distanceInWordsToNow





/***/ }),



/***/ "./node_modules/date-fns/is_date/index.js":

/*!************************************************!*\

  !*** ./node_modules/date-fns/is_date/index.js ***!

  \************************************************/

/*! no static exports found */

/***/ (function(module, exports) {



/**

 * @category Common Helpers

 * @summary Is the given argument an instance of Date?

 *

 * @description

 * Is the given argument an instance of Date?

 *

 * @param {*} argument - the argument to check

 * @returns {Boolean} the given argument is an instance of Date

 *

 * @example

 * // Is 'mayonnaise' a Date?

 * var result = isDate('mayonnaise')

 * //=> false

 */

function isDate (argument) {

  return argument instanceof Date

}



module.exports = isDate





/***/ }),



/***/ "./node_modules/date-fns/locale/_lib/build_formatting_tokens_reg_exp/index.js":

/*!************************************************************************************!*\

  !*** ./node_modules/date-fns/locale/_lib/build_formatting_tokens_reg_exp/index.js ***!

  \************************************************************************************/

/*! no static exports found */

/***/ (function(module, exports) {



var commonFormatterKeys = [

  'M', 'MM', 'Q', 'D', 'DD', 'DDD', 'DDDD', 'd',

  'E', 'W', 'WW', 'YY', 'YYYY', 'GG', 'GGGG',

  'H', 'HH', 'h', 'hh', 'm', 'mm',

  's', 'ss', 'S', 'SS', 'SSS',

  'Z', 'ZZ', 'X', 'x'

]



function buildFormattingTokensRegExp (formatters) {

  var formatterKeys = []

  for (var key in formatters) {

    if (formatters.hasOwnProperty(key)) {

      formatterKeys.push(key)

    }

  }



  var formattingTokens = commonFormatterKeys

    .concat(formatterKeys)

    .sort()

    .reverse()

  var formattingTokensRegExp = new RegExp(

    '(\\[[^\\[]*\\])|(\\\\)?' + '(' + formattingTokens.join('|') + '|.)', 'g'

  )



  return formattingTokensRegExp

}



module.exports = buildFormattingTokensRegExp





/***/ }),



/***/ "./node_modules/date-fns/locale/en/build_distance_in_words_locale/index.js":

/*!*********************************************************************************!*\

  !*** ./node_modules/date-fns/locale/en/build_distance_in_words_locale/index.js ***!

  \*********************************************************************************/

/*! no static exports found */

/***/ (function(module, exports) {



function buildDistanceInWordsLocale () {

  var distanceInWordsLocale = {

    lessThanXSeconds: {

      one: 'less than a second',

      other: 'less than {{count}} seconds'

    },



    xSeconds: {

      one: '1 second',

      other: '{{count}} seconds'

    },



    halfAMinute: 'half a minute',



    lessThanXMinutes: {

      one: 'less than a minute',

      other: 'less than {{count}} minutes'

    },



    xMinutes: {

      one: '1 minute',

      other: '{{count}} minutes'

    },



    aboutXHours: {

      one: 'about 1 hour',

      other: 'about {{count}} hours'

    },



    xHours: {

      one: '1 hour',

      other: '{{count}} hours'

    },



    xDays: {

      one: '1 day',

      other: '{{count}} days'

    },



    aboutXMonths: {

      one: 'about 1 month',

      other: 'about {{count}} months'

    },



    xMonths: {

      one: '1 month',

      other: '{{count}} months'

    },



    aboutXYears: {

      one: 'about 1 year',

      other: 'about {{count}} years'

    },



    xYears: {

      one: '1 year',

      other: '{{count}} years'

    },



    overXYears: {

      one: 'over 1 year',

      other: 'over {{count}} years'

    },



    almostXYears: {

      one: 'almost 1 year',

      other: 'almost {{count}} years'

    }

  }



  function localize (token, count, options) {

    options = options || {}



    var result

    if (typeof distanceInWordsLocale[token] === 'string') {

      result = distanceInWordsLocale[token]

    } else if (count === 1) {

      result = distanceInWordsLocale[token].one

    } else {

      result = distanceInWordsLocale[token].other.replace('{{count}}', count)

    }



    if (options.addSuffix) {

      if (options.comparison > 0) {

        return 'in ' + result

      } else {

        return result + ' ago'

      }

    }



    return result

  }



  return {

    localize: localize

  }

}



module.exports = buildDistanceInWordsLocale





/***/ }),



/***/ "./node_modules/date-fns/locale/en/build_format_locale/index.js":

/*!**********************************************************************!*\

  !*** ./node_modules/date-fns/locale/en/build_format_locale/index.js ***!

  \**********************************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



var buildFormattingTokensRegExp = __webpack_require__(/*! ../../_lib/build_formatting_tokens_reg_exp/index.js */ "./node_modules/date-fns/locale/_lib/build_formatting_tokens_reg_exp/index.js")



function buildFormatLocale () {

  // Note: in English, the names of days of the week and months are capitalized.

  // If you are making a new locale based on this one, check if the same is true for the language you're working on.

  // Generally, formatted dates should look like they are in the middle of a sentence,

  // e.g. in Spanish language the weekdays and months should be in the lowercase.

  var months3char = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']

  var monthsFull = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December']

  var weekdays2char = ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa']

  var weekdays3char = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat']

  var weekdaysFull = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday']

  var meridiemUppercase = ['AM', 'PM']

  var meridiemLowercase = ['am', 'pm']

  var meridiemFull = ['a.m.', 'p.m.']



  var formatters = {

    // Month: Jan, Feb, ..., Dec

    'MMM': function (date) {

      return months3char[date.getMonth()]

    },



    // Month: January, February, ..., December

    'MMMM': function (date) {

      return monthsFull[date.getMonth()]

    },



    // Day of week: Su, Mo, ..., Sa

    'dd': function (date) {

      return weekdays2char[date.getDay()]

    },



    // Day of week: Sun, Mon, ..., Sat

    'ddd': function (date) {

      return weekdays3char[date.getDay()]

    },



    // Day of week: Sunday, Monday, ..., Saturday

    'dddd': function (date) {

      return weekdaysFull[date.getDay()]

    },



    // AM, PM

    'A': function (date) {

      return (date.getHours() / 12) >= 1 ? meridiemUppercase[1] : meridiemUppercase[0]

    },



    // am, pm

    'a': function (date) {

      return (date.getHours() / 12) >= 1 ? meridiemLowercase[1] : meridiemLowercase[0]

    },



    // a.m., p.m.

    'aa': function (date) {

      return (date.getHours() / 12) >= 1 ? meridiemFull[1] : meridiemFull[0]

    }

  }



  // Generate ordinal version of formatters: M -> Mo, D -> Do, etc.

  var ordinalFormatters = ['M', 'D', 'DDD', 'd', 'Q', 'W']

  ordinalFormatters.forEach(function (formatterToken) {

    formatters[formatterToken + 'o'] = function (date, formatters) {

      return ordinal(formatters[formatterToken](date))

    }

  })



  return {

    formatters: formatters,

    formattingTokensRegExp: buildFormattingTokensRegExp(formatters)

  }

}



function ordinal (number) {

  var rem100 = number % 100

  if (rem100 > 20 || rem100 < 10) {

    switch (rem100 % 10) {

      case 1:

        return number + 'st'

      case 2:

        return number + 'nd'

      case 3:

        return number + 'rd'

    }

  }

  return number + 'th'

}



module.exports = buildFormatLocale





/***/ }),



/***/ "./node_modules/date-fns/locale/en/index.js":

/*!**************************************************!*\

  !*** ./node_modules/date-fns/locale/en/index.js ***!

  \**************************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



var buildDistanceInWordsLocale = __webpack_require__(/*! ./build_distance_in_words_locale/index.js */ "./node_modules/date-fns/locale/en/build_distance_in_words_locale/index.js")

var buildFormatLocale = __webpack_require__(/*! ./build_format_locale/index.js */ "./node_modules/date-fns/locale/en/build_format_locale/index.js")



/**

 * @category Locales

 * @summary English locale.

 */

module.exports = {

  distanceInWords: buildDistanceInWordsLocale(),

  format: buildFormatLocale()

}





/***/ }),



/***/ "./node_modules/date-fns/parse/index.js":

/*!**********************************************!*\

  !*** ./node_modules/date-fns/parse/index.js ***!

  \**********************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



var getTimezoneOffsetInMilliseconds = __webpack_require__(/*! ../_lib/getTimezoneOffsetInMilliseconds/index.js */ "./node_modules/date-fns/_lib/getTimezoneOffsetInMilliseconds/index.js")

var isDate = __webpack_require__(/*! ../is_date/index.js */ "./node_modules/date-fns/is_date/index.js")



var MILLISECONDS_IN_HOUR = 3600000

var MILLISECONDS_IN_MINUTE = 60000

var DEFAULT_ADDITIONAL_DIGITS = 2



var parseTokenDateTimeDelimeter = /[T ]/

var parseTokenPlainTime = /:/



// year tokens

var parseTokenYY = /^(\d{2})$/

var parseTokensYYY = [

  /^([+-]\d{2})$/, // 0 additional digits

  /^([+-]\d{3})$/, // 1 additional digit

  /^([+-]\d{4})$/ // 2 additional digits

]



var parseTokenYYYY = /^(\d{4})/

var parseTokensYYYYY = [

  /^([+-]\d{4})/, // 0 additional digits

  /^([+-]\d{5})/, // 1 additional digit

  /^([+-]\d{6})/ // 2 additional digits

]



// date tokens

var parseTokenMM = /^-(\d{2})$/

var parseTokenDDD = /^-?(\d{3})$/

var parseTokenMMDD = /^-?(\d{2})-?(\d{2})$/

var parseTokenWww = /^-?W(\d{2})$/

var parseTokenWwwD = /^-?W(\d{2})-?(\d{1})$/



// time tokens

var parseTokenHH = /^(\d{2}([.,]\d*)?)$/

var parseTokenHHMM = /^(\d{2}):?(\d{2}([.,]\d*)?)$/

var parseTokenHHMMSS = /^(\d{2}):?(\d{2}):?(\d{2}([.,]\d*)?)$/



// timezone tokens

var parseTokenTimezone = /([Z+-].*)$/

var parseTokenTimezoneZ = /^(Z)$/

var parseTokenTimezoneHH = /^([+-])(\d{2})$/

var parseTokenTimezoneHHMM = /^([+-])(\d{2}):?(\d{2})$/



/**

 * @category Common Helpers

 * @summary Convert the given argument to an instance of Date.

 *

 * @description

 * Convert the given argument to an instance of Date.

 *

 * If the argument is an instance of Date, the function returns its clone.

 *

 * If the argument is a number, it is treated as a timestamp.

 *

 * If an argument is a string, the function tries to parse it.

 * Function accepts complete ISO 8601 formats as well as partial implementations.

 * ISO 8601: http://en.wikipedia.org/wiki/ISO_8601

 *

 * If all above fails, the function passes the given argument to Date constructor.

 *

 * @param {Date|String|Number} argument - the value to convert

 * @param {Object} [options] - the object with options

 * @param {0 | 1 | 2} [options.additionalDigits=2] - the additional number of digits in the extended year format

 * @returns {Date} the parsed date in the local time zone

 *

 * @example

 * // Convert string '2014-02-11T11:30:30' to date:

 * var result = parse('2014-02-11T11:30:30')

 * //=> Tue Feb 11 2014 11:30:30

 *

 * @example

 * // Parse string '+02014101',

 * // if the additional number of digits in the extended year format is 1:

 * var result = parse('+02014101', {additionalDigits: 1})

 * //=> Fri Apr 11 2014 00:00:00

 */

function parse (argument, dirtyOptions) {

  if (isDate(argument)) {

    // Prevent the date to lose the milliseconds when passed to new Date() in IE10

    return new Date(argument.getTime())

  } else if (typeof argument !== 'string') {

    return new Date(argument)

  }



  var options = dirtyOptions || {}

  var additionalDigits = options.additionalDigits

  if (additionalDigits == null) {

    additionalDigits = DEFAULT_ADDITIONAL_DIGITS

  } else {

    additionalDigits = Number(additionalDigits)

  }



  var dateStrings = splitDateString(argument)



  var parseYearResult = parseYear(dateStrings.date, additionalDigits)

  var year = parseYearResult.year

  var restDateString = parseYearResult.restDateString



  var date = parseDate(restDateString, year)



  if (date) {

    var timestamp = date.getTime()

    var time = 0

    var offset



    if (dateStrings.time) {

      time = parseTime(dateStrings.time)

    }



    if (dateStrings.timezone) {

      offset = parseTimezone(dateStrings.timezone) * MILLISECONDS_IN_MINUTE

    } else {

      var fullTime = timestamp + time

      var fullTimeDate = new Date(fullTime)



      offset = getTimezoneOffsetInMilliseconds(fullTimeDate)



      // Adjust time when it's coming from DST

      var fullTimeDateNextDay = new Date(fullTime)

      fullTimeDateNextDay.setDate(fullTimeDate.getDate() + 1)

      var offsetDiff =

        getTimezoneOffsetInMilliseconds(fullTimeDateNextDay) -

        getTimezoneOffsetInMilliseconds(fullTimeDate)

      if (offsetDiff > 0) {

        offset += offsetDiff

      }

    }



    return new Date(timestamp + time + offset)

  } else {

    return new Date(argument)

  }

}



function splitDateString (dateString) {

  var dateStrings = {}

  var array = dateString.split(parseTokenDateTimeDelimeter)

  var timeString



  if (parseTokenPlainTime.test(array[0])) {

    dateStrings.date = null

    timeString = array[0]

  } else {

    dateStrings.date = array[0]

    timeString = array[1]

  }



  if (timeString) {

    var token = parseTokenTimezone.exec(timeString)

    if (token) {

      dateStrings.time = timeString.replace(token[1], '')

      dateStrings.timezone = token[1]

    } else {

      dateStrings.time = timeString

    }

  }



  return dateStrings

}



function parseYear (dateString, additionalDigits) {

  var parseTokenYYY = parseTokensYYY[additionalDigits]

  var parseTokenYYYYY = parseTokensYYYYY[additionalDigits]



  var token



  // YYYY or ±YYYYY

  token = parseTokenYYYY.exec(dateString) || parseTokenYYYYY.exec(dateString)

  if (token) {

    var yearString = token[1]

    return {

      year: parseInt(yearString, 10),

      restDateString: dateString.slice(yearString.length)

    }

  }



  // YY or ±YYY

  token = parseTokenYY.exec(dateString) || parseTokenYYY.exec(dateString)

  if (token) {

    var centuryString = token[1]

    return {

      year: parseInt(centuryString, 10) * 100,

      restDateString: dateString.slice(centuryString.length)

    }

  }



  // Invalid ISO-formatted year

  return {

    year: null

  }

}



function parseDate (dateString, year) {

  // Invalid ISO-formatted year

  if (year === null) {

    return null

  }



  var token

  var date

  var month

  var week



  // YYYY

  if (dateString.length === 0) {

    date = new Date(0)

    date.setUTCFullYear(year)

    return date

  }



  // YYYY-MM

  token = parseTokenMM.exec(dateString)

  if (token) {

    date = new Date(0)

    month = parseInt(token[1], 10) - 1

    date.setUTCFullYear(year, month)

    return date

  }



  // YYYY-DDD or YYYYDDD

  token = parseTokenDDD.exec(dateString)

  if (token) {

    date = new Date(0)

    var dayOfYear = parseInt(token[1], 10)

    date.setUTCFullYear(year, 0, dayOfYear)

    return date

  }



  // YYYY-MM-DD or YYYYMMDD

  token = parseTokenMMDD.exec(dateString)

  if (token) {

    date = new Date(0)

    month = parseInt(token[1], 10) - 1

    var day = parseInt(token[2], 10)

    date.setUTCFullYear(year, month, day)

    return date

  }



  // YYYY-Www or YYYYWww

  token = parseTokenWww.exec(dateString)

  if (token) {

    week = parseInt(token[1], 10) - 1

    return dayOfISOYear(year, week)

  }



  // YYYY-Www-D or YYYYWwwD

  token = parseTokenWwwD.exec(dateString)

  if (token) {

    week = parseInt(token[1], 10) - 1

    var dayOfWeek = parseInt(token[2], 10) - 1

    return dayOfISOYear(year, week, dayOfWeek)

  }



  // Invalid ISO-formatted date

  return null

}



function parseTime (timeString) {

  var token

  var hours

  var minutes



  // hh

  token = parseTokenHH.exec(timeString)

  if (token) {

    hours = parseFloat(token[1].replace(',', '.'))

    return (hours % 24) * MILLISECONDS_IN_HOUR

  }



  // hh:mm or hhmm

  token = parseTokenHHMM.exec(timeString)

  if (token) {

    hours = parseInt(token[1], 10)

    minutes = parseFloat(token[2].replace(',', '.'))

    return (hours % 24) * MILLISECONDS_IN_HOUR +

      minutes * MILLISECONDS_IN_MINUTE

  }



  // hh:mm:ss or hhmmss

  token = parseTokenHHMMSS.exec(timeString)

  if (token) {

    hours = parseInt(token[1], 10)

    minutes = parseInt(token[2], 10)

    var seconds = parseFloat(token[3].replace(',', '.'))

    return (hours % 24) * MILLISECONDS_IN_HOUR +

      minutes * MILLISECONDS_IN_MINUTE +

      seconds * 1000

  }



  // Invalid ISO-formatted time

  return null

}



function parseTimezone (timezoneString) {

  var token

  var absoluteOffset



  // Z

  token = parseTokenTimezoneZ.exec(timezoneString)

  if (token) {

    return 0

  }



  // ±hh

  token = parseTokenTimezoneHH.exec(timezoneString)

  if (token) {

    absoluteOffset = parseInt(token[2], 10) * 60

    return (token[1] === '+') ? -absoluteOffset : absoluteOffset

  }



  // ±hh:mm or ±hhmm

  token = parseTokenTimezoneHHMM.exec(timezoneString)

  if (token) {

    absoluteOffset = parseInt(token[2], 10) * 60 + parseInt(token[3], 10)

    return (token[1] === '+') ? -absoluteOffset : absoluteOffset

  }



  return 0

}



function dayOfISOYear (isoYear, week, day) {

  week = week || 0

  day = day || 0

  var date = new Date(0)

  date.setUTCFullYear(isoYear, 0, 4)

  var fourthOfJanuaryDay = date.getUTCDay() || 7

  var diff = week * 7 + day + 1 - fourthOfJanuaryDay

  date.setUTCDate(date.getUTCDate() + diff)

  return date

}



module.exports = parse





/***/ }),



/***/ "./node_modules/emoji-js/lib/emoji.js":

/*!********************************************!*\

  !*** ./node_modules/emoji-js/lib/emoji.js ***!

  \********************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";

/* WEBPACK VAR INJECTION */(function(global) {



;(function() {



	var root = this;

	var previous_emoji = root.EmojiConvertor;





	/**

	 * @global

	 * @namespace

	 */



	var emoji = function(){



		var self = this;



		/**

		 * The set of images to use for graphical emoji.

		 *

		 * @memberof emoji

		 * @type {string}

		 */

		self.img_set = 'apple';



		/**

		 * Configuration details for different image sets. This includes a path to a directory containing the

		 * individual images (`path`) and a URL to sprite sheets (`sheet`). All of these images can be found

		 * in the [emoji-data repository]{@link https://github.com/iamcal/emoji-data}. Using a CDN for these

		 * is not a bad idea.

		 *

		 * @memberof emoji

		 * @type {object}

		 */

		self.img_sets = {

			'apple' : {'path' : '/emoji-data/img-apple-64/', 'sheet' : '/emoji-data/sheet_apple_64.png', 'sheet_size' : 64, 'mask' : 1},

			'google' : {'path' : '/emoji-data/img-google-64/', 'sheet' : '/emoji-data/sheet_google_64.png', 'sheet_size' : 64, 'mask' : 2},

			'twitter' : {'path' : '/emoji-data/img-twitter-64/', 'sheet' : '/emoji-data/sheet_twitter_64.png', 'sheet_size' : 64, 'mask' : 4},

			'facebook' : {'path' : '/emoji-data/img-facebook-64/', 'sheet' : '/emoji-data/sheet_facebook_64.png', 'sheet_size' : 64, 'mask' : 8},

			'messenger' : {'path' : '/emoji-data/img-messenger-64/', 'sheet' : '/emoji-data/sheet_messenger_64.png', 'sheet_size' : 64, 'mask' : 16},

		};



		/**

		 * Use a CSS class instead of specifying a sprite or background image for

		 * the span representing the emoticon. This requires a CSS sheet with

		 * emoticon data-uris.

		 *

		 * @memberof emoji

		 * @type bool

		 * @todo document how to build the CSS stylesheet self requires.

		 */

		self.use_css_imgs = false;



		/**

		 * Instead of replacing emoticons with the appropriate representations,

		 * replace them with their colon string representation.

		 * @memberof emoji

		 * @type bool

		 */

		self.colons_mode = false;

		self.text_mode = false;



		/**

		 * If true, sets the "title" property on the span or image that gets

		 * inserted for the emoticon.

		 * @memberof emoji

		 * @type bool

		 */

		self.include_title = false;



		/**

		 * If true, sets the text of the span or image that gets inserted for the

		 * emoticon.

		 * @memberof emoji

		 * @type bool

		 */

		self.include_text = false;



		/**

		 * If the platform supports native emoticons, use those instead

		 * of the fallbacks.

		 * @memberof emoji

		 * @type bool

		 */

		self.allow_native = true;



		/**

		 * Wrap native with a <span class="emoji-native"></span> to allow styling

		 * @memberof emoji

		 * @type bool

		 */

		self.wrap_native = false;



		/**

		 * Set to true to use CSS sprites instead of individual images on

		 * platforms that support it.

		 *

		 * @memberof emoji

		 * @type bool

		 */

		self.use_sheet = false;



		/**

		 *

		 * Set to true to avoid black & white native Windows emoji being used.

		 *

		 * @memberof emoji

		 * @type bool

		 */

		self.avoid_ms_emoji = true;



		/**

		 *

		 * Set to true to allow :CAPITALIZATION:

		 *

		 * @memberof emoji

		 * @type bool

		 */

		self.allow_caps = false;





		/**

		 *

		 * Suffix to allow for individual image cache busting

		 *

		 * @memberof emoji

		 * @type string

		 */

		self.img_suffix = '';





		// Keeps track of what has been initialized.

		/** @private */

		self.inits = {};

		self.map = {};



		// discover the environment settings

		self.init_env();



		return self;

	}



	emoji.prototype.noConflict = function(){

		root.EmojiConvertor = previous_emoji;

		return emoji;

	}





	/**

	 * @memberof emoji

	 * @param {string} str A string potentially containing ascii emoticons

	 * (ie. `:)`)

	 *

	 * @returns {string} A new string with all emoticons in `str`

	 * replaced by a representatation that's supported by the current

	 * environtment.

	 */

	emoji.prototype.replace_emoticons = function(str){

		var self = this;

		var colonized = self.replace_emoticons_with_colons(str);

		return self.replace_colons(colonized);

	};



	/**

	 * @memberof emoji

	 * @param {string} str A string potentially containing ascii emoticons

	 * (ie. `:)`)

	 *

	 * @returns {string} A new string with all emoticons in `str`

	 * replaced by their colon string representations (ie. `:smile:`)

	 */

	emoji.prototype.replace_emoticons_with_colons = function(str){

		var self = this;

		self.init_emoticons();

		var _prev_offset = 0;

		var emoticons_with_parens = [];

		var str_replaced = str.replace(self.rx_emoticons, function(m, $1, emoticon, offset){

			var prev_offset = _prev_offset;

			_prev_offset = offset + m.length;



			var has_open_paren = emoticon.indexOf('(') !== -1;

			var has_close_paren = emoticon.indexOf(')') !== -1;



			/*

			 * Track paren-having emoticons for fixing later

			 */

			if ((has_open_paren || has_close_paren) && emoticons_with_parens.indexOf(emoticon) == -1) {

				emoticons_with_parens.push(emoticon);

			}



			/*

			 * Look for preceding open paren for emoticons that contain a close paren

			 * This prevents matching "8)" inside "(around 7 - 8)"

			 */

			if (has_close_paren && !has_open_paren) {

				var piece = str.substring(prev_offset, offset);

				if (piece.indexOf('(') !== -1 && piece.indexOf(')') === -1) return m;

			}



			/*

			 * See if we're in a numbered list

			 * This prevents matching "8)" inside "7) foo\n8) bar"

			 */

			if (m === '\n8)') {

				var before_match = str.substring(0, offset);

				if (/\n?(6\)|7\))/.test(before_match)) return m;

			}



			var val = self.data[self.map.emoticons[emoticon]][3][0];

			return val ? $1+':'+val+':' : m;

		});



		/*

		 * Come back and fix emoticons we ignored because they were inside parens.

		 * It's useful to do self at the end so we don't get tripped up by other,

		 * normal emoticons

		 */

		if (emoticons_with_parens.length) {

			var escaped_emoticons = emoticons_with_parens.map(self.escape_rx);

			var parenthetical_rx = new RegExp('(\\(.+)('+escaped_emoticons.join('|')+')(.+\\))', 'g');



			str_replaced = str_replaced.replace(parenthetical_rx, function(m, $1, emoticon, $2) {

				var val = self.data[self.map.emoticons[emoticon]][3][0];

				return val ? $1+':'+val+':'+$2 : m;

			});

		}



		return str_replaced;

	};



	/**

	 * @memberof emoji

	 * @param {string} str A string potentially containing colon string

	 * representations of emoticons (ie. `:smile:`)

	 *

	 * @returns {string} A new string with all colon string emoticons replaced

	 * with the appropriate representation.

	 */

	emoji.prototype.replace_colons = function(str){

		var self = this;

		self.init_colons();



		return str.replace(self.rx_colons, function(m){

			var idx = m.substr(1, m.length-2);

			if (self.allow_caps) idx = idx.toLowerCase();



			// special case - an emoji with a skintone modified

			if (idx.indexOf('::skin-tone-') > -1){



				var skin_tone = idx.substr(-1, 1);

				var skin_idx = 'skin-tone-'+skin_tone;

				var skin_val = self.map.colons[skin_idx];



				idx = idx.substr(0, idx.length - 13);



				var val = self.map.colons[idx];

				if (val){

					return self.replacement(val, idx, ':', {

						'idx'		: skin_val,

						'actual'	: skin_idx,

						'wrapper'	: ':'

					});

				}else{

					return ':' + idx + ':' + self.replacement(skin_val, skin_idx, ':');

				}

			}else{

				var val = self.map.colons[idx];

				return val ? self.replacement(val, idx, ':') : m;

			}

		});

	};



	/**

	 * @memberof emoji

	 * @param {string} str A string potentially containing unified unicode

	 * emoticons. (ie. 😄)

	 *

	 * @returns {string} A new string with all unicode emoticons replaced with

	 * the appropriate representation for the current environment.

	 */

	emoji.prototype.replace_unified = function(str){

		var self = this;

		self.init_unified();

		return str.replace(self.rx_unified, function(m, p1, p2){



			var val = self.map.unified[p1];

			if (val){

				var idx = null;

				if (p2 == '\uD83C\uDFFB') idx = '1f3fb';

				if (p2 == '\uD83C\uDFFC') idx = '1f3fc';

				if (p2 == '\uD83C\uDFFD') idx = '1f3fd';

				if (p2 == '\uD83C\uDFFE') idx = '1f3fe';

				if (p2 == '\uD83C\uDFFF') idx = '1f3ff';

				if (idx){

					return self.replacement(val, null, null, {

						idx	: idx,

						actual	: p2,

						wrapper	: ''

					});

					}

				return self.replacement(val);

			}



			val = self.map.unified_vars[p1];

			if (val){

				return self.replacement(val[0], null, null, {

					'idx'		: val[1],

					'actual'	: '',

					'wrapper'	: '',

				});

			}



			return m;

		});

	};



	emoji.prototype.addAliases = function(map){

		var self = this;



		self.init_colons();

		for (var i in map){

			self.map.colons[i] = map[i];

		}

	};



	emoji.prototype.removeAliases = function(list){

		var self = this;



		for (var i=0; i<list.length; i++){

			var alias = list[i];



			// first, delete the alias mapping

			delete self.map.colons[alias];



			// now reset it to the default, if one exists

			finder_block: {

				for (var j in self.data){

					for (var k=0; k<self.data[j][3].length; k++){

						if (alias == self.data[j][3][k]){

							self.map.colons[alias] = j;

							break finder_block;

						}

					}

				}

			}

		}

	};





	// Does the actual replacement of a character with the appropriate

	/** @private */

	emoji.prototype.replacement = function(idx, actual, wrapper, variation, is_extra){

		var self = this;



		var full_idx = idx;



		// for emoji with variation modifiers, set `extra` to the standalone output for the

		// modifier (used if we can't combine the glyph) and set variation_idx to key of the

		// variation modifier (used below)

		var extra = '';

		var var_idx = null;

		if (typeof variation === 'object'){

			extra = self.replacement(variation.idx, variation.actual, variation.wrapper, undefined, true);

			var_idx = variation.idx;

		}



		// deal with simple modes (colons and text) first

		wrapper = wrapper || '';

		if (self.colons_mode) return ':'+self.data[idx][3][0]+':'+extra;

		var text_name = (actual) ? wrapper+actual+wrapper : self.data[idx][8] || wrapper+self.data[idx][3][0]+wrapper;

		if (self.text_mode) return text_name + extra;



		// figure out which images and code points to use, based on the skin variations. this information is also used for

		// unified native output mode

		var img = self.find_image(idx, var_idx);



		// native modes next.

		// for variations selectors, we just need to output them raw, which `extra` will contain. since softbank and google don't

		// support skin variations, we'll keep `extra` around, every if we have a valid variation selector

		self.init_env();

		if (self.replace_mode == 'softbank' && self.allow_native && self.data[idx][1]) return self.format_native(self.data[idx][1] + extra, !is_extra);

		if (self.replace_mode == 'google'   && self.allow_native && self.data[idx][2]) return self.format_native(self.data[idx][2] + extra, !is_extra);



		// for unified (and images, below), we can use the variation info and throw away the `extra` contents

		if (img.is_var){

			extra = '';

		}

		if (self.replace_mode == 'unified' && self.allow_native) return self.format_native(img.unified + extra, !is_extra);





		// finally deal with image modes.

		// the call to .find_image() earlier checked if the image set and particular emoji supports variations,

		// otherwise we can return it as a separate image (already calculated in `extra`).

		// first we set up the params we'll use if we can't use a variation.

		var title = self.include_title ? ' title="'+(actual || self.data[idx][3][0])+'"' : '';

		var text  = self.include_text  ? wrapper+(actual || self.data[idx][3][0])+wrapper : '';



		// custom image for this glyph?

		if (self.data[idx][7]){

			img.path = self.data[idx][7];

			img.px = null;

			img.py = null;

			img.is_var = false;

		}



		// if we're displaying a variation, include it in the text

		if (img.is_var && self.include_text && variation && variation.actual && variation.wrapper) {

			text += variation.wrapper+variation.actual+variation.wrapper;

		}



		// output

		if (self.supports_css) {

			if (self.use_sheet && img.px != null && img.py != null){

				var sheet_size = self.sheet_size * (img.sheet_size+2); // size of image in pixels

				var sheet_x = 100 * (((img.px * (img.sheet_size+2)) + 1) / (sheet_size - img.sheet_size));

				var sheet_y = 100 * (((img.py * (img.sheet_size+2)) + 1) / (sheet_size - img.sheet_size));

				var sheet_sz = 100 * (sheet_size / img.sheet_size);



				var style = 'background: url('+img.sheet+');background-position:'+(sheet_x)+'% '+(sheet_y)+'%;background-size:'+sheet_sz+'% '+sheet_sz+'%';

				return '<span class="emoji-outer emoji-sizer"><span class="emoji-inner" style="'+style+'"'+title+' data-codepoints="'+img.full_idx+'">'+text+'</span></span>'+extra;

			}else if (self.use_css_imgs){

				return '<span class="emoji emoji-'+idx+'"'+title+' data-codepoints="'+img.full_idx+'">'+text+'</span>'+extra;

			}else{

				return '<span class="emoji emoji-sizer" style="background-image:url('+img.path+')"'+title+' data-codepoints="'+img.full_idx+'">'+text+'</span>'+extra;

			}

		}

		return '<img src="'+img.path+'" class="emoji" data-codepoints="'+img.full_idx+'" '+title+'/>'+extra;

	};



	// Wraps the output of a native endpoint, if configured

	/** @private */

	emoji.prototype.format_native = function(native, allow_wrap){

		var self = this;



		if (self.wrap_native && allow_wrap){

			return '<span class="emoji-native">'+ native + '</span>';

		}

		return native;

	};



	// Finds the best image to display, taking into account image set precedence and obsoletes

	/** @private */

	emoji.prototype.find_image = function(idx, var_idx){

		var self = this;



		// set up some initial state

		var out = {

			'path'		: '',

			'sheet'		: '',

			'sheet_size'	: 0,

			'px'		: self.data[idx][4],

			'py'		: self.data[idx][5],

			'full_idx'	: idx,

			'is_var'	: false,

			'unified'	: self.data[idx][0][0]

		};

		var use_mask = self.data[idx][6];



		// can we use a variation?

		if (var_idx && self.variations_data[idx] && self.variations_data[idx][var_idx]){

			var var_data = self.variations_data[idx][var_idx];



			out.px = var_data[1];

			out.py = var_data[2];

			out.full_idx = var_data[0];

			out.is_var = true;

			out.unified = var_data[4];

			use_mask = var_data[3];

		}



		// this matches `build/build_image.php` `in emoji-data`, so that sheet and images modes always

		// agree about the image to use.

		var try_order = [self.img_set, 'apple', 'google', 'twitter', 'facebook', 'messenger'];



		// for each image set, see if we have the image we need. otherwise check for an obsolete in

		// that image set

		for (var j=0; j<try_order.length; j++){

			if (use_mask & self.img_sets[try_order[j]].mask){

				out.path = self.img_sets[try_order[j]].path+out.full_idx+'.png' + self.img_suffix;

				// if we're not changing glyph, use our base set for sheets - it has every glyph

				out.sheet = self.img_sets[self.img_set].sheet;

				out.sheet_size = self.img_sets[self.img_set].sheet_size;

				return out;

			}

			if (self.obsoletes_data[out.full_idx]){

				var ob_data = self.obsoletes_data[out.full_idx];



				if (ob_data[3] & self.img_sets[try_order[j]].mask){

					out.path = self.img_sets[try_order[j]].path+ob_data[0]+'.png' + self.img_suffix;

					out.sheet = self.img_sets[try_order[j]].sheet;

					out.sheet_size = self.img_sets[try_order[j]].sheet_size;

					out.px = ob_data[1];

					out.py = ob_data[2];

					return out;

				}

			}

		}



		return out;

	};



	// Initializes the text emoticon data

	/** @private */

	emoji.prototype.init_emoticons = function(){

		var self = this;

		if (self.inits.emoticons) return;

		self.init_colons(); // we require this for the emoticons map

		self.inits.emoticons = 1;



		var a = [];

		self.map.emoticons = {};

		for (var i in self.emoticons_data){

			// because we never see some characters in our text except as entities, we must do some replacing

			var emoticon = i.replace(/\&/g, '&amp;').replace(/\</g, '&lt;').replace(/\>/g, '&gt;');



			if (!self.map.colons[self.emoticons_data[i]]) continue;



			self.map.emoticons[emoticon] = self.map.colons[self.emoticons_data[i]];

			a.push(self.escape_rx(emoticon));

		}

		self.rx_emoticons = new RegExp(('(^|\\s)('+a.join('|')+')(?=$|[\\s|\\?\\.,!])'), 'g');

	};



	// Initializes the colon string data

	/** @private */

	emoji.prototype.init_colons = function(){

		var self = this;

		if (self.inits.colons) return;

		self.inits.colons = 1;

		self.rx_colons = new RegExp('\:[a-zA-Z0-9-_+]+\:(\:skin-tone-[2-6]\:)?', 'g');

		self.map.colons = {};

		for (var i in self.data){

			for (var j=0; j<self.data[i][3].length; j++){

				self.map.colons[self.data[i][3][j]] = i;

			}

		}

	};



	// initializes the unified unicode emoticon data

	/** @private */

	emoji.prototype.init_unified = function(){

		var self = this;

		if (self.inits.unified) return;

		self.inits.unified = 1;



		var a = [];

		self.map.unified = {};

		self.map.unified_vars = {};



		for (var i in self.data){

			for (var j=0; j<self.data[i][0].length; j++){

				a.push(self.data[i][0][j].replace('*', '\\*'));

				self.map.unified[self.data[i][0][j]] = i;

			}

		}

		for (var i in self.variations_data){

			// skip simple append-style skin tones

			if (self.variations_data[i]['1f3fb'][0] == i+'-1f3fb') continue;



			for (var k in self.variations_data[i]){

				for (var j=0; j<self.variations_data[i][k][4].length; j++){

					a.push(self.variations_data[i][k][4][j].replace('*', '\\*'));

					self.map.unified_vars[self.variations_data[i][k][4][j]] = [i, k];

				}

			}

		}



		a = a.sort(function(a,b){

			 return b.length - a.length;

		});



		self.rx_unified = new RegExp('('+a.join('|')+')(\uD83C[\uDFFB-\uDFFF])?', "g");

	};



	// initializes the environment, figuring out what representation

	// of emoticons is best.

	/** @private */

	emoji.prototype.init_env = function(){

		var self = this;

		if (self.inits.env) return;

		self.inits.env = 1;

		self.replace_mode = 'img';

		self.supports_css = false;

		if (typeof(navigator) !== 'undefined') {

			var ua = navigator.userAgent;

			if (typeof window !== 'undefined' && window.getComputedStyle){

				try {

					var st = window.getComputedStyle(document.body);

					if (st['background-size'] || st['backgroundSize']){

						self.supports_css = true;

					}

				} catch(e){

					// Swallow an exception caused by hidden iFrames on Firefox

					// https://github.com/iamcal/js-emoji/issues/73

					if (ua.match(/Firefox/i)){

						self.supports_css = true;

					}

				}

			}

			if (navigator.product.match(/ReactNative/i)){

				self.replace_mode = 'unified';

				return;

			}

			if (ua.match(/(iPhone|iPod|iPad|iPhone\s+Simulator)/i)){

				if (ua.match(/OS\s+[12345]/i)){

					self.replace_mode = 'softbank';

					return;

				}

				if (ua.match(/OS\s+[6789]/i)){

					self.replace_mode = 'unified';

					return;

				}

			}

			if (ua.match(/Mac OS X 10[._ ](?:[789]|1\d)/i)){

				self.replace_mode = 'unified';

				return;

			}

			if (!self.avoid_ms_emoji){

				if (ua.match(/Windows NT 6.[1-9]/i) || ua.match(/Windows NT 10.[0-9]/i)){

					if (!ua.match(/Chrome/i) && !ua.match(/MSIE 8/i)){

						self.replace_mode = 'unified';

						return;

					}

				}

			}

		}



		// Need a better way to detect android devices that actually

		// support emoji.

		if (false){}

		if (self.supports_css){

			self.replace_mode = 'css';

		}

		// nothing fancy detected - use images

	};

	/** @private */

	emoji.prototype.escape_rx = function(text){

		return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");

	};

	emoji.prototype.sheet_size = 52;

	/** @private */

	emoji.prototype.data = {

		"0023-fe0f-20e3":[["\u0023\uFE0F\u20E3","\u0023\u20E3"],"\uE210","\uDBBA\uDC2C",["hash"],0,0,7,0],

		"002a-fe0f-20e3":[["\u002A\uFE0F\u20E3","\u002A\u20E3"],"","",["keycap_star"],0,1,7,0],

		"0030-fe0f-20e3":[["\u0030\uFE0F\u20E3","\u0030\u20E3"],"\uE225","\uDBBA\uDC37",["zero"],0,2,7,0],

		"0031-fe0f-20e3":[["\u0031\uFE0F\u20E3","\u0031\u20E3"],"\uE21C","\uDBBA\uDC2E",["one"],0,3,7,0],

		"0032-fe0f-20e3":[["\u0032\uFE0F\u20E3","\u0032\u20E3"],"\uE21D","\uDBBA\uDC2F",["two"],0,4,7,0],

		"0033-fe0f-20e3":[["\u0033\uFE0F\u20E3","\u0033\u20E3"],"\uE21E","\uDBBA\uDC30",["three"],0,5,7,0],

		"0034-fe0f-20e3":[["\u0034\uFE0F\u20E3","\u0034\u20E3"],"\uE21F","\uDBBA\uDC31",["four"],0,6,7,0],

		"0035-fe0f-20e3":[["\u0035\uFE0F\u20E3","\u0035\u20E3"],"\uE220","\uDBBA\uDC32",["five"],0,7,7,0],

		"0036-fe0f-20e3":[["\u0036\uFE0F\u20E3","\u0036\u20E3"],"\uE221","\uDBBA\uDC33",["six"],0,8,7,0],

		"0037-fe0f-20e3":[["\u0037\uFE0F\u20E3","\u0037\u20E3"],"\uE222","\uDBBA\uDC34",["seven"],0,9,7,0],

		"0038-fe0f-20e3":[["\u0038\uFE0F\u20E3","\u0038\u20E3"],"\uE223","\uDBBA\uDC35",["eight"],0,10,7,0],

		"0039-fe0f-20e3":[["\u0039\uFE0F\u20E3","\u0039\u20E3"],"\uE224","\uDBBA\uDC36",["nine"],0,11,7,0],

		"00a9-fe0f":[["\u00A9\uFE0F","\u00A9"],"\uE24E","\uDBBA\uDF29",["copyright"],0,12,3,0],

		"00ae-fe0f":[["\u00AE\uFE0F","\u00AE"],"\uE24F","\uDBBA\uDF2D",["registered"],0,13,3,0],

		"1f004":[["\uD83C\uDC04"],"\uE12D","\uDBBA\uDC0B",["mahjong"],0,14,31,0],

		"1f0cf":[["\uD83C\uDCCF"],"","\uDBBA\uDC12",["black_joker"],0,15,31,0],

		"1f170-fe0f":[["\uD83C\uDD70\uFE0F","\uD83C\uDD70"],"\uE532","\uDBB9\uDD0B",["a"],0,16,31,0],

		"1f171-fe0f":[["\uD83C\uDD71\uFE0F","\uD83C\uDD71"],"\uE533","\uDBB9\uDD0C",["b"],0,17,31,0],

		"1f17e-fe0f":[["\uD83C\uDD7E\uFE0F","\uD83C\uDD7E"],"\uE535","\uDBB9\uDD0E",["o2"],0,18,31,0],

		"1f17f-fe0f":[["\uD83C\uDD7F\uFE0F","\uD83C\uDD7F"],"\uE14F","\uDBB9\uDFF6",["parking"],0,19,31,0],

		"1f18e":[["\uD83C\uDD8E"],"\uE534","\uDBB9\uDD0D",["ab"],0,20,31,0],

		"1f191":[["\uD83C\uDD91"],"","\uDBBA\uDF84",["cl"],0,21,31,0],

		"1f192":[["\uD83C\uDD92"],"\uE214","\uDBBA\uDF38",["cool"],0,22,31,0],

		"1f193":[["\uD83C\uDD93"],"","\uDBBA\uDF21",["free"],0,23,31,0],

		"1f194":[["\uD83C\uDD94"],"\uE229","\uDBBA\uDF81",["id"],0,24,31,0],

		"1f195":[["\uD83C\uDD95"],"\uE212","\uDBBA\uDF36",["new"],0,25,31,0],

		"1f196":[["\uD83C\uDD96"],"","\uDBBA\uDF28",["ng"],0,26,31,0],

		"1f197":[["\uD83C\uDD97"],"\uE24D","\uDBBA\uDF27",["ok"],0,27,31,0],

		"1f198":[["\uD83C\uDD98"],"","\uDBBA\uDF4F",["sos"],0,28,31,0],

		"1f199":[["\uD83C\uDD99"],"\uE213","\uDBBA\uDF37",["up"],0,29,31,0],

		"1f19a":[["\uD83C\uDD9A"],"\uE12E","\uDBBA\uDF32",["vs"],0,30,31,0],

		"1f1e6-1f1e8":[["\uD83C\uDDE6\uD83C\uDDE8"],"","",["flag-ac"],0,31,31,0],

		"1f1e6-1f1e9":[["\uD83C\uDDE6\uD83C\uDDE9"],"","",["flag-ad"],0,32,31,0],

		"1f1e6-1f1ea":[["\uD83C\uDDE6\uD83C\uDDEA"],"","",["flag-ae"],0,33,31,0],

		"1f1e6-1f1eb":[["\uD83C\uDDE6\uD83C\uDDEB"],"","",["flag-af"],0,34,31,0],

		"1f1e6-1f1ec":[["\uD83C\uDDE6\uD83C\uDDEC"],"","",["flag-ag"],0,35,31,0],

		"1f1e6-1f1ee":[["\uD83C\uDDE6\uD83C\uDDEE"],"","",["flag-ai"],0,36,31,0],

		"1f1e6-1f1f1":[["\uD83C\uDDE6\uD83C\uDDF1"],"","",["flag-al"],0,37,31,0],

		"1f1e6-1f1f2":[["\uD83C\uDDE6\uD83C\uDDF2"],"","",["flag-am"],0,38,31,0],

		"1f1e6-1f1f4":[["\uD83C\uDDE6\uD83C\uDDF4"],"","",["flag-ao"],0,39,31,0],

		"1f1e6-1f1f6":[["\uD83C\uDDE6\uD83C\uDDF6"],"","",["flag-aq"],0,40,31,0],

		"1f1e6-1f1f7":[["\uD83C\uDDE6\uD83C\uDDF7"],"","",["flag-ar"],0,41,31,0],

		"1f1e6-1f1f8":[["\uD83C\uDDE6\uD83C\uDDF8"],"","",["flag-as"],0,42,31,0],

		"1f1e6-1f1f9":[["\uD83C\uDDE6\uD83C\uDDF9"],"","",["flag-at"],0,43,31,0],

		"1f1e6-1f1fa":[["\uD83C\uDDE6\uD83C\uDDFA"],"","",["flag-au"],0,44,31,0],

		"1f1e6-1f1fc":[["\uD83C\uDDE6\uD83C\uDDFC"],"","",["flag-aw"],0,45,31,0],

		"1f1e6-1f1fd":[["\uD83C\uDDE6\uD83C\uDDFD"],"","",["flag-ax"],0,46,31,0],

		"1f1e6-1f1ff":[["\uD83C\uDDE6\uD83C\uDDFF"],"","",["flag-az"],0,47,31,0],

		"1f1e7-1f1e6":[["\uD83C\uDDE7\uD83C\uDDE6"],"","",["flag-ba"],0,48,15,0],

		"1f1e7-1f1e7":[["\uD83C\uDDE7\uD83C\uDDE7"],"","",["flag-bb"],0,49,31,0],

		"1f1e7-1f1e9":[["\uD83C\uDDE7\uD83C\uDDE9"],"","",["flag-bd"],0,50,31,0],

		"1f1e7-1f1ea":[["\uD83C\uDDE7\uD83C\uDDEA"],"","",["flag-be"],0,51,31,0],

		"1f1e7-1f1eb":[["\uD83C\uDDE7\uD83C\uDDEB"],"","",["flag-bf"],1,0,31,0],

		"1f1e7-1f1ec":[["\uD83C\uDDE7\uD83C\uDDEC"],"","",["flag-bg"],1,1,31,0],

		"1f1e7-1f1ed":[["\uD83C\uDDE7\uD83C\uDDED"],"","",["flag-bh"],1,2,31,0],

		"1f1e7-1f1ee":[["\uD83C\uDDE7\uD83C\uDDEE"],"","",["flag-bi"],1,3,31,0],

		"1f1e7-1f1ef":[["\uD83C\uDDE7\uD83C\uDDEF"],"","",["flag-bj"],1,4,31,0],

		"1f1e7-1f1f1":[["\uD83C\uDDE7\uD83C\uDDF1"],"","",["flag-bl"],1,5,29,0],

		"1f1e7-1f1f2":[["\uD83C\uDDE7\uD83C\uDDF2"],"","",["flag-bm"],1,6,31,0],

		"1f1e7-1f1f3":[["\uD83C\uDDE7\uD83C\uDDF3"],"","",["flag-bn"],1,7,15,0],

		"1f1e7-1f1f4":[["\uD83C\uDDE7\uD83C\uDDF4"],"","",["flag-bo"],1,8,31,0],

		"1f1e7-1f1f6":[["\uD83C\uDDE7\uD83C\uDDF6"],"","",["flag-bq"],1,9,29,0],

		"1f1e7-1f1f7":[["\uD83C\uDDE7\uD83C\uDDF7"],"","",["flag-br"],1,10,31,0],

		"1f1e7-1f1f8":[["\uD83C\uDDE7\uD83C\uDDF8"],"","",["flag-bs"],1,11,31,0],

		"1f1e7-1f1f9":[["\uD83C\uDDE7\uD83C\uDDF9"],"","",["flag-bt"],1,12,31,0],

		"1f1e7-1f1fb":[["\uD83C\uDDE7\uD83C\uDDFB"],"","",["flag-bv"],1,13,31,0],

		"1f1e7-1f1fc":[["\uD83C\uDDE7\uD83C\uDDFC"],"","",["flag-bw"],1,14,31,0],

		"1f1e7-1f1fe":[["\uD83C\uDDE7\uD83C\uDDFE"],"","",["flag-by"],1,15,31,0],

		"1f1e7-1f1ff":[["\uD83C\uDDE7\uD83C\uDDFF"],"","",["flag-bz"],1,16,31,0],

		"1f1e8-1f1e6":[["\uD83C\uDDE8\uD83C\uDDE6"],"","",["flag-ca"],1,17,31,0],

		"1f1e8-1f1e8":[["\uD83C\uDDE8\uD83C\uDDE8"],"","",["flag-cc"],1,18,31,0],

		"1f1e8-1f1e9":[["\uD83C\uDDE8\uD83C\uDDE9"],"","",["flag-cd"],1,19,31,0],

		"1f1e8-1f1eb":[["\uD83C\uDDE8\uD83C\uDDEB"],"","",["flag-cf"],1,20,31,0],

		"1f1e8-1f1ec":[["\uD83C\uDDE8\uD83C\uDDEC"],"","",["flag-cg"],1,21,31,0],

		"1f1e8-1f1ed":[["\uD83C\uDDE8\uD83C\uDDED"],"","",["flag-ch"],1,22,31,0],

		"1f1e8-1f1ee":[["\uD83C\uDDE8\uD83C\uDDEE"],"","",["flag-ci"],1,23,31,0],

		"1f1e8-1f1f0":[["\uD83C\uDDE8\uD83C\uDDF0"],"","",["flag-ck"],1,24,31,0],

		"1f1e8-1f1f1":[["\uD83C\uDDE8\uD83C\uDDF1"],"","",["flag-cl"],1,25,31,0],

		"1f1e8-1f1f2":[["\uD83C\uDDE8\uD83C\uDDF2"],"","",["flag-cm"],1,26,31,0],

		"1f1e8-1f1f3":[["\uD83C\uDDE8\uD83C\uDDF3"],"\uE513","\uDBB9\uDCED",["cn","flag-cn"],1,27,31,0],

		"1f1e8-1f1f4":[["\uD83C\uDDE8\uD83C\uDDF4"],"","",["flag-co"],1,28,31,0],

		"1f1e8-1f1f5":[["\uD83C\uDDE8\uD83C\uDDF5"],"","",["flag-cp"],1,29,15,0],

		"1f1e8-1f1f7":[["\uD83C\uDDE8\uD83C\uDDF7"],"","",["flag-cr"],1,30,31,0],

		"1f1e8-1f1fa":[["\uD83C\uDDE8\uD83C\uDDFA"],"","",["flag-cu"],1,31,31,0],

		"1f1e8-1f1fb":[["\uD83C\uDDE8\uD83C\uDDFB"],"","",["flag-cv"],1,32,31,0],

		"1f1e8-1f1fc":[["\uD83C\uDDE8\uD83C\uDDFC"],"","",["flag-cw"],1,33,31,0],

		"1f1e8-1f1fd":[["\uD83C\uDDE8\uD83C\uDDFD"],"","",["flag-cx"],1,34,31,0],

		"1f1e8-1f1fe":[["\uD83C\uDDE8\uD83C\uDDFE"],"","",["flag-cy"],1,35,31,0],

		"1f1e8-1f1ff":[["\uD83C\uDDE8\uD83C\uDDFF"],"","",["flag-cz"],1,36,31,0],

		"1f1e9-1f1ea":[["\uD83C\uDDE9\uD83C\uDDEA"],"\uE50E","\uDBB9\uDCE8",["de","flag-de"],1,37,31,0],

		"1f1e9-1f1ec":[["\uD83C\uDDE9\uD83C\uDDEC"],"","",["flag-dg"],1,38,29,0],

		"1f1e9-1f1ef":[["\uD83C\uDDE9\uD83C\uDDEF"],"","",["flag-dj"],1,39,31,0],

		"1f1e9-1f1f0":[["\uD83C\uDDE9\uD83C\uDDF0"],"","",["flag-dk"],1,40,31,0],

		"1f1e9-1f1f2":[["\uD83C\uDDE9\uD83C\uDDF2"],"","",["flag-dm"],1,41,31,0],

		"1f1e9-1f1f4":[["\uD83C\uDDE9\uD83C\uDDF4"],"","",["flag-do"],1,42,31,0],

		"1f1e9-1f1ff":[["\uD83C\uDDE9\uD83C\uDDFF"],"","",["flag-dz"],1,43,31,0],

		"1f1ea-1f1e6":[["\uD83C\uDDEA\uD83C\uDDE6"],"","",["flag-ea"],1,44,29,0],

		"1f1ea-1f1e8":[["\uD83C\uDDEA\uD83C\uDDE8"],"","",["flag-ec"],1,45,31,0],

		"1f1ea-1f1ea":[["\uD83C\uDDEA\uD83C\uDDEA"],"","",["flag-ee"],1,46,31,0],

		"1f1ea-1f1ec":[["\uD83C\uDDEA\uD83C\uDDEC"],"","",["flag-eg"],1,47,31,0],

		"1f1ea-1f1ed":[["\uD83C\uDDEA\uD83C\uDDED"],"","",["flag-eh"],1,48,29,0],

		"1f1ea-1f1f7":[["\uD83C\uDDEA\uD83C\uDDF7"],"","",["flag-er"],1,49,31,0],

		"1f1ea-1f1f8":[["\uD83C\uDDEA\uD83C\uDDF8"],"\uE511","\uDBB9\uDCEB",["es","flag-es"],1,50,31,0],

		"1f1ea-1f1f9":[["\uD83C\uDDEA\uD83C\uDDF9"],"","",["flag-et"],1,51,31,0],

		"1f1ea-1f1fa":[["\uD83C\uDDEA\uD83C\uDDFA"],"","",["flag-eu"],2,0,31,0],

		"1f1eb-1f1ee":[["\uD83C\uDDEB\uD83C\uDDEE"],"","",["flag-fi"],2,1,31,0],

		"1f1eb-1f1ef":[["\uD83C\uDDEB\uD83C\uDDEF"],"","",["flag-fj"],2,2,31,0],

		"1f1eb-1f1f0":[["\uD83C\uDDEB\uD83C\uDDF0"],"","",["flag-fk"],2,3,29,0],

		"1f1eb-1f1f2":[["\uD83C\uDDEB\uD83C\uDDF2"],"","",["flag-fm"],2,4,31,0],

		"1f1eb-1f1f4":[["\uD83C\uDDEB\uD83C\uDDF4"],"","",["flag-fo"],2,5,31,0],

		"1f1eb-1f1f7":[["\uD83C\uDDEB\uD83C\uDDF7"],"\uE50D","\uDBB9\uDCE7",["fr","flag-fr"],2,6,31,0],

		"1f1ec-1f1e6":[["\uD83C\uDDEC\uD83C\uDDE6"],"","",["flag-ga"],2,7,31,0],

		"1f1ec-1f1e7":[["\uD83C\uDDEC\uD83C\uDDE7"],"\uE510","\uDBB9\uDCEA",["gb","uk","flag-gb"],2,8,31,0],

		"1f1ec-1f1e9":[["\uD83C\uDDEC\uD83C\uDDE9"],"","",["flag-gd"],2,9,31,0],

		"1f1ec-1f1ea":[["\uD83C\uDDEC\uD83C\uDDEA"],"","",["flag-ge"],2,10,31,0],

		"1f1ec-1f1eb":[["\uD83C\uDDEC\uD83C\uDDEB"],"","",["flag-gf"],2,11,29,0],

		"1f1ec-1f1ec":[["\uD83C\uDDEC\uD83C\uDDEC"],"","",["flag-gg"],2,12,31,0],

		"1f1ec-1f1ed":[["\uD83C\uDDEC\uD83C\uDDED"],"","",["flag-gh"],2,13,31,0],

		"1f1ec-1f1ee":[["\uD83C\uDDEC\uD83C\uDDEE"],"","",["flag-gi"],2,14,31,0],

		"1f1ec-1f1f1":[["\uD83C\uDDEC\uD83C\uDDF1"],"","",["flag-gl"],2,15,31,0],

		"1f1ec-1f1f2":[["\uD83C\uDDEC\uD83C\uDDF2"],"","",["flag-gm"],2,16,31,0],

		"1f1ec-1f1f3":[["\uD83C\uDDEC\uD83C\uDDF3"],"","",["flag-gn"],2,17,31,0],

		"1f1ec-1f1f5":[["\uD83C\uDDEC\uD83C\uDDF5"],"","",["flag-gp"],2,18,29,0],

		"1f1ec-1f1f6":[["\uD83C\uDDEC\uD83C\uDDF6"],"","",["flag-gq"],2,19,31,0],

		"1f1ec-1f1f7":[["\uD83C\uDDEC\uD83C\uDDF7"],"","",["flag-gr"],2,20,31,0],

		"1f1ec-1f1f8":[["\uD83C\uDDEC\uD83C\uDDF8"],"","",["flag-gs"],2,21,29,0],

		"1f1ec-1f1f9":[["\uD83C\uDDEC\uD83C\uDDF9"],"","",["flag-gt"],2,22,31,0],

		"1f1ec-1f1fa":[["\uD83C\uDDEC\uD83C\uDDFA"],"","",["flag-gu"],2,23,31,0],

		"1f1ec-1f1fc":[["\uD83C\uDDEC\uD83C\uDDFC"],"","",["flag-gw"],2,24,31,0],

		"1f1ec-1f1fe":[["\uD83C\uDDEC\uD83C\uDDFE"],"","",["flag-gy"],2,25,31,0],

		"1f1ed-1f1f0":[["\uD83C\uDDED\uD83C\uDDF0"],"","",["flag-hk"],2,26,31,0],

		"1f1ed-1f1f2":[["\uD83C\uDDED\uD83C\uDDF2"],"","",["flag-hm"],2,27,31,0],

		"1f1ed-1f1f3":[["\uD83C\uDDED\uD83C\uDDF3"],"","",["flag-hn"],2,28,31,0],

		"1f1ed-1f1f7":[["\uD83C\uDDED\uD83C\uDDF7"],"","",["flag-hr"],2,29,31,0],

		"1f1ed-1f1f9":[["\uD83C\uDDED\uD83C\uDDF9"],"","",["flag-ht"],2,30,31,0],

		"1f1ed-1f1fa":[["\uD83C\uDDED\uD83C\uDDFA"],"","",["flag-hu"],2,31,31,0],

		"1f1ee-1f1e8":[["\uD83C\uDDEE\uD83C\uDDE8"],"","",["flag-ic"],2,32,31,0],

		"1f1ee-1f1e9":[["\uD83C\uDDEE\uD83C\uDDE9"],"","",["flag-id"],2,33,31,0],

		"1f1ee-1f1ea":[["\uD83C\uDDEE\uD83C\uDDEA"],"","",["flag-ie"],2,34,31,0],

		"1f1ee-1f1f1":[["\uD83C\uDDEE\uD83C\uDDF1"],"","",["flag-il"],2,35,31,0],

		"1f1ee-1f1f2":[["\uD83C\uDDEE\uD83C\uDDF2"],"","",["flag-im"],2,36,31,0],

		"1f1ee-1f1f3":[["\uD83C\uDDEE\uD83C\uDDF3"],"","",["flag-in"],2,37,31,0],

		"1f1ee-1f1f4":[["\uD83C\uDDEE\uD83C\uDDF4"],"","",["flag-io"],2,38,31,0],

		"1f1ee-1f1f6":[["\uD83C\uDDEE\uD83C\uDDF6"],"","",["flag-iq"],2,39,31,0],

		"1f1ee-1f1f7":[["\uD83C\uDDEE\uD83C\uDDF7"],"","",["flag-ir"],2,40,31,0],

		"1f1ee-1f1f8":[["\uD83C\uDDEE\uD83C\uDDF8"],"","",["flag-is"],2,41,31,0],

		"1f1ee-1f1f9":[["\uD83C\uDDEE\uD83C\uDDF9"],"\uE50F","\uDBB9\uDCE9",["it","flag-it"],2,42,31,0],

		"1f1ef-1f1ea":[["\uD83C\uDDEF\uD83C\uDDEA"],"","",["flag-je"],2,43,31,0],

		"1f1ef-1f1f2":[["\uD83C\uDDEF\uD83C\uDDF2"],"","",["flag-jm"],2,44,31,0],

		"1f1ef-1f1f4":[["\uD83C\uDDEF\uD83C\uDDF4"],"","",["flag-jo"],2,45,31,0],

		"1f1ef-1f1f5":[["\uD83C\uDDEF\uD83C\uDDF5"],"\uE50B","\uDBB9\uDCE5",["jp","flag-jp"],2,46,31,0],

		"1f1f0-1f1ea":[["\uD83C\uDDF0\uD83C\uDDEA"],"","",["flag-ke"],2,47,31,0],

		"1f1f0-1f1ec":[["\uD83C\uDDF0\uD83C\uDDEC"],"","",["flag-kg"],2,48,31,0],

		"1f1f0-1f1ed":[["\uD83C\uDDF0\uD83C\uDDED"],"","",["flag-kh"],2,49,31,0],

		"1f1f0-1f1ee":[["\uD83C\uDDF0\uD83C\uDDEE"],"","",["flag-ki"],2,50,31,0],

		"1f1f0-1f1f2":[["\uD83C\uDDF0\uD83C\uDDF2"],"","",["flag-km"],2,51,31,0],

		"1f1f0-1f1f3":[["\uD83C\uDDF0\uD83C\uDDF3"],"","",["flag-kn"],3,0,31,0],

		"1f1f0-1f1f5":[["\uD83C\uDDF0\uD83C\uDDF5"],"","",["flag-kp"],3,1,31,0],

		"1f1f0-1f1f7":[["\uD83C\uDDF0\uD83C\uDDF7"],"\uE514","\uDBB9\uDCEE",["kr","flag-kr"],3,2,31,0],

		"1f1f0-1f1fc":[["\uD83C\uDDF0\uD83C\uDDFC"],"","",["flag-kw"],3,3,31,0],

		"1f1f0-1f1fe":[["\uD83C\uDDF0\uD83C\uDDFE"],"","",["flag-ky"],3,4,31,0],

		"1f1f0-1f1ff":[["\uD83C\uDDF0\uD83C\uDDFF"],"","",["flag-kz"],3,5,31,0],

		"1f1f1-1f1e6":[["\uD83C\uDDF1\uD83C\uDDE6"],"","",["flag-la"],3,6,31,0],

		"1f1f1-1f1e7":[["\uD83C\uDDF1\uD83C\uDDE7"],"","",["flag-lb"],3,7,31,0],

		"1f1f1-1f1e8":[["\uD83C\uDDF1\uD83C\uDDE8"],"","",["flag-lc"],3,8,31,0],

		"1f1f1-1f1ee":[["\uD83C\uDDF1\uD83C\uDDEE"],"","",["flag-li"],3,9,31,0],

		"1f1f1-1f1f0":[["\uD83C\uDDF1\uD83C\uDDF0"],"","",["flag-lk"],3,10,31,0],

		"1f1f1-1f1f7":[["\uD83C\uDDF1\uD83C\uDDF7"],"","",["flag-lr"],3,11,31,0],

		"1f1f1-1f1f8":[["\uD83C\uDDF1\uD83C\uDDF8"],"","",["flag-ls"],3,12,31,0],

		"1f1f1-1f1f9":[["\uD83C\uDDF1\uD83C\uDDF9"],"","",["flag-lt"],3,13,31,0],

		"1f1f1-1f1fa":[["\uD83C\uDDF1\uD83C\uDDFA"],"","",["flag-lu"],3,14,31,0],

		"1f1f1-1f1fb":[["\uD83C\uDDF1\uD83C\uDDFB"],"","",["flag-lv"],3,15,31,0],

		"1f1f1-1f1fe":[["\uD83C\uDDF1\uD83C\uDDFE"],"","",["flag-ly"],3,16,31,0],

		"1f1f2-1f1e6":[["\uD83C\uDDF2\uD83C\uDDE6"],"","",["flag-ma"],3,17,31,0],

		"1f1f2-1f1e8":[["\uD83C\uDDF2\uD83C\uDDE8"],"","",["flag-mc"],3,18,31,0],

		"1f1f2-1f1e9":[["\uD83C\uDDF2\uD83C\uDDE9"],"","",["flag-md"],3,19,31,0],

		"1f1f2-1f1ea":[["\uD83C\uDDF2\uD83C\uDDEA"],"","",["flag-me"],3,20,31,0],

		"1f1f2-1f1eb":[["\uD83C\uDDF2\uD83C\uDDEB"],"","",["flag-mf"],3,21,29,0],

		"1f1f2-1f1ec":[["\uD83C\uDDF2\uD83C\uDDEC"],"","",["flag-mg"],3,22,31,0],

		"1f1f2-1f1ed":[["\uD83C\uDDF2\uD83C\uDDED"],"","",["flag-mh"],3,23,31,0],

		"1f1f2-1f1f0":[["\uD83C\uDDF2\uD83C\uDDF0"],"","",["flag-mk"],3,24,31,0],

		"1f1f2-1f1f1":[["\uD83C\uDDF2\uD83C\uDDF1"],"","",["flag-ml"],3,25,31,0],

		"1f1f2-1f1f2":[["\uD83C\uDDF2\uD83C\uDDF2"],"","",["flag-mm"],3,26,31,0],

		"1f1f2-1f1f3":[["\uD83C\uDDF2\uD83C\uDDF3"],"","",["flag-mn"],3,27,31,0],

		"1f1f2-1f1f4":[["\uD83C\uDDF2\uD83C\uDDF4"],"","",["flag-mo"],3,28,31,0],

		"1f1f2-1f1f5":[["\uD83C\uDDF2\uD83C\uDDF5"],"","",["flag-mp"],3,29,31,0],

		"1f1f2-1f1f6":[["\uD83C\uDDF2\uD83C\uDDF6"],"","",["flag-mq"],3,30,29,0],

		"1f1f2-1f1f7":[["\uD83C\uDDF2\uD83C\uDDF7"],"","",["flag-mr"],3,31,31,0],

		"1f1f2-1f1f8":[["\uD83C\uDDF2\uD83C\uDDF8"],"","",["flag-ms"],3,32,31,0],

		"1f1f2-1f1f9":[["\uD83C\uDDF2\uD83C\uDDF9"],"","",["flag-mt"],3,33,31,0],

		"1f1f2-1f1fa":[["\uD83C\uDDF2\uD83C\uDDFA"],"","",["flag-mu"],3,34,31,0],

		"1f1f2-1f1fb":[["\uD83C\uDDF2\uD83C\uDDFB"],"","",["flag-mv"],3,35,31,0],

		"1f1f2-1f1fc":[["\uD83C\uDDF2\uD83C\uDDFC"],"","",["flag-mw"],3,36,31,0],

		"1f1f2-1f1fd":[["\uD83C\uDDF2\uD83C\uDDFD"],"","",["flag-mx"],3,37,31,0],

		"1f1f2-1f1fe":[["\uD83C\uDDF2\uD83C\uDDFE"],"","",["flag-my"],3,38,31,0],

		"1f1f2-1f1ff":[["\uD83C\uDDF2\uD83C\uDDFF"],"","",["flag-mz"],3,39,31,0],

		"1f1f3-1f1e6":[["\uD83C\uDDF3\uD83C\uDDE6"],"","",["flag-na"],3,40,31,0],

		"1f1f3-1f1e8":[["\uD83C\uDDF3\uD83C\uDDE8"],"","",["flag-nc"],3,41,29,0],

		"1f1f3-1f1ea":[["\uD83C\uDDF3\uD83C\uDDEA"],"","",["flag-ne"],3,42,31,0],

		"1f1f3-1f1eb":[["\uD83C\uDDF3\uD83C\uDDEB"],"","",["flag-nf"],3,43,31,0],

		"1f1f3-1f1ec":[["\uD83C\uDDF3\uD83C\uDDEC"],"","",["flag-ng"],3,44,31,0],

		"1f1f3-1f1ee":[["\uD83C\uDDF3\uD83C\uDDEE"],"","",["flag-ni"],3,45,31,0],

		"1f1f3-1f1f1":[["\uD83C\uDDF3\uD83C\uDDF1"],"","",["flag-nl"],3,46,31,0],

		"1f1f3-1f1f4":[["\uD83C\uDDF3\uD83C\uDDF4"],"","",["flag-no"],3,47,31,0],

		"1f1f3-1f1f5":[["\uD83C\uDDF3\uD83C\uDDF5"],"","",["flag-np"],3,48,31,0],

		"1f1f3-1f1f7":[["\uD83C\uDDF3\uD83C\uDDF7"],"","",["flag-nr"],3,49,31,0],

		"1f1f3-1f1fa":[["\uD83C\uDDF3\uD83C\uDDFA"],"","",["flag-nu"],3,50,31,0],

		"1f1f3-1f1ff":[["\uD83C\uDDF3\uD83C\uDDFF"],"","",["flag-nz"],3,51,31,0],

		"1f1f4-1f1f2":[["\uD83C\uDDF4\uD83C\uDDF2"],"","",["flag-om"],4,0,31,0],

		"1f1f5-1f1e6":[["\uD83C\uDDF5\uD83C\uDDE6"],"","",["flag-pa"],4,1,31,0],

		"1f1f5-1f1ea":[["\uD83C\uDDF5\uD83C\uDDEA"],"","",["flag-pe"],4,2,31,0],

		"1f1f5-1f1eb":[["\uD83C\uDDF5\uD83C\uDDEB"],"","",["flag-pf"],4,3,31,0],

		"1f1f5-1f1ec":[["\uD83C\uDDF5\uD83C\uDDEC"],"","",["flag-pg"],4,4,31,0],

		"1f1f5-1f1ed":[["\uD83C\uDDF5\uD83C\uDDED"],"","",["flag-ph"],4,5,31,0],

		"1f1f5-1f1f0":[["\uD83C\uDDF5\uD83C\uDDF0"],"","",["flag-pk"],4,6,31,0],

		"1f1f5-1f1f1":[["\uD83C\uDDF5\uD83C\uDDF1"],"","",["flag-pl"],4,7,31,0],

		"1f1f5-1f1f2":[["\uD83C\uDDF5\uD83C\uDDF2"],"","",["flag-pm"],4,8,29,0],

		"1f1f5-1f1f3":[["\uD83C\uDDF5\uD83C\uDDF3"],"","",["flag-pn"],4,9,31,0],

		"1f1f5-1f1f7":[["\uD83C\uDDF5\uD83C\uDDF7"],"","",["flag-pr"],4,10,31,0],

		"1f1f5-1f1f8":[["\uD83C\uDDF5\uD83C\uDDF8"],"","",["flag-ps"],4,11,31,0],

		"1f1f5-1f1f9":[["\uD83C\uDDF5\uD83C\uDDF9"],"","",["flag-pt"],4,12,31,0],

		"1f1f5-1f1fc":[["\uD83C\uDDF5\uD83C\uDDFC"],"","",["flag-pw"],4,13,31,0],

		"1f1f5-1f1fe":[["\uD83C\uDDF5\uD83C\uDDFE"],"","",["flag-py"],4,14,31,0],

		"1f1f6-1f1e6":[["\uD83C\uDDF6\uD83C\uDDE6"],"","",["flag-qa"],4,15,31,0],

		"1f1f7-1f1ea":[["\uD83C\uDDF7\uD83C\uDDEA"],"","",["flag-re"],4,16,29,0],

		"1f1f7-1f1f4":[["\uD83C\uDDF7\uD83C\uDDF4"],"","",["flag-ro"],4,17,31,0],

		"1f1f7-1f1f8":[["\uD83C\uDDF7\uD83C\uDDF8"],"","",["flag-rs"],4,18,31,0],

		"1f1f7-1f1fa":[["\uD83C\uDDF7\uD83C\uDDFA"],"\uE512","\uDBB9\uDCEC",["ru","flag-ru"],4,19,31,0],

		"1f1f7-1f1fc":[["\uD83C\uDDF7\uD83C\uDDFC"],"","",["flag-rw"],4,20,31,0],

		"1f1f8-1f1e6":[["\uD83C\uDDF8\uD83C\uDDE6"],"","",["flag-sa"],4,21,31,0],

		"1f1f8-1f1e7":[["\uD83C\uDDF8\uD83C\uDDE7"],"","",["flag-sb"],4,22,31,0],

		"1f1f8-1f1e8":[["\uD83C\uDDF8\uD83C\uDDE8"],"","",["flag-sc"],4,23,31,0],

		"1f1f8-1f1e9":[["\uD83C\uDDF8\uD83C\uDDE9"],"","",["flag-sd"],4,24,31,0],

		"1f1f8-1f1ea":[["\uD83C\uDDF8\uD83C\uDDEA"],"","",["flag-se"],4,25,31,0],

		"1f1f8-1f1ec":[["\uD83C\uDDF8\uD83C\uDDEC"],"","",["flag-sg"],4,26,31,0],

		"1f1f8-1f1ed":[["\uD83C\uDDF8\uD83C\uDDED"],"","",["flag-sh"],4,27,31,0],

		"1f1f8-1f1ee":[["\uD83C\uDDF8\uD83C\uDDEE"],"","",["flag-si"],4,28,31,0],

		"1f1f8-1f1ef":[["\uD83C\uDDF8\uD83C\uDDEF"],"","",["flag-sj"],4,29,31,0],

		"1f1f8-1f1f0":[["\uD83C\uDDF8\uD83C\uDDF0"],"","",["flag-sk"],4,30,31,0],

		"1f1f8-1f1f1":[["\uD83C\uDDF8\uD83C\uDDF1"],"","",["flag-sl"],4,31,31,0],

		"1f1f8-1f1f2":[["\uD83C\uDDF8\uD83C\uDDF2"],"","",["flag-sm"],4,32,31,0],

		"1f1f8-1f1f3":[["\uD83C\uDDF8\uD83C\uDDF3"],"","",["flag-sn"],4,33,31,0],

		"1f1f8-1f1f4":[["\uD83C\uDDF8\uD83C\uDDF4"],"","",["flag-so"],4,34,31,0],

		"1f1f8-1f1f7":[["\uD83C\uDDF8\uD83C\uDDF7"],"","",["flag-sr"],4,35,31,0],

		"1f1f8-1f1f8":[["\uD83C\uDDF8\uD83C\uDDF8"],"","",["flag-ss"],4,36,31,0],

		"1f1f8-1f1f9":[["\uD83C\uDDF8\uD83C\uDDF9"],"","",["flag-st"],4,37,31,0],

		"1f1f8-1f1fb":[["\uD83C\uDDF8\uD83C\uDDFB"],"","",["flag-sv"],4,38,31,0],

		"1f1f8-1f1fd":[["\uD83C\uDDF8\uD83C\uDDFD"],"","",["flag-sx"],4,39,31,0],

		"1f1f8-1f1fe":[["\uD83C\uDDF8\uD83C\uDDFE"],"","",["flag-sy"],4,40,31,0],

		"1f1f8-1f1ff":[["\uD83C\uDDF8\uD83C\uDDFF"],"","",["flag-sz"],4,41,31,0],

		"1f1f9-1f1e6":[["\uD83C\uDDF9\uD83C\uDDE6"],"","",["flag-ta"],4,42,31,0],

		"1f1f9-1f1e8":[["\uD83C\uDDF9\uD83C\uDDE8"],"","",["flag-tc"],4,43,31,0],

		"1f1f9-1f1e9":[["\uD83C\uDDF9\uD83C\uDDE9"],"","",["flag-td"],4,44,31,0],

		"1f1f9-1f1eb":[["\uD83C\uDDF9\uD83C\uDDEB"],"","",["flag-tf"],4,45,29,0],

		"1f1f9-1f1ec":[["\uD83C\uDDF9\uD83C\uDDEC"],"","",["flag-tg"],4,46,31,0],

		"1f1f9-1f1ed":[["\uD83C\uDDF9\uD83C\uDDED"],"","",["flag-th"],4,47,31,0],

		"1f1f9-1f1ef":[["\uD83C\uDDF9\uD83C\uDDEF"],"","",["flag-tj"],4,48,31,0],

		"1f1f9-1f1f0":[["\uD83C\uDDF9\uD83C\uDDF0"],"","",["flag-tk"],4,49,31,0],

		"1f1f9-1f1f1":[["\uD83C\uDDF9\uD83C\uDDF1"],"","",["flag-tl"],4,50,31,0],

		"1f1f9-1f1f2":[["\uD83C\uDDF9\uD83C\uDDF2"],"","",["flag-tm"],4,51,31,0],

		"1f1f9-1f1f3":[["\uD83C\uDDF9\uD83C\uDDF3"],"","",["flag-tn"],5,0,31,0],

		"1f1f9-1f1f4":[["\uD83C\uDDF9\uD83C\uDDF4"],"","",["flag-to"],5,1,31,0],

		"1f1f9-1f1f7":[["\uD83C\uDDF9\uD83C\uDDF7"],"","",["flag-tr"],5,2,31,0],

		"1f1f9-1f1f9":[["\uD83C\uDDF9\uD83C\uDDF9"],"","",["flag-tt"],5,3,31,0],

		"1f1f9-1f1fb":[["\uD83C\uDDF9\uD83C\uDDFB"],"","",["flag-tv"],5,4,31,0],

		"1f1f9-1f1fc":[["\uD83C\uDDF9\uD83C\uDDFC"],"","",["flag-tw"],5,5,31,0],

		"1f1f9-1f1ff":[["\uD83C\uDDF9\uD83C\uDDFF"],"","",["flag-tz"],5,6,31,0],

		"1f1fa-1f1e6":[["\uD83C\uDDFA\uD83C\uDDE6"],"","",["flag-ua"],5,7,31,0],

		"1f1fa-1f1ec":[["\uD83C\uDDFA\uD83C\uDDEC"],"","",["flag-ug"],5,8,31,0],

		"1f1fa-1f1f2":[["\uD83C\uDDFA\uD83C\uDDF2"],"","",["flag-um"],5,9,31,0],

		"1f1fa-1f1f3":[["\uD83C\uDDFA\uD83C\uDDF3"],"","",["flag-un"],5,10,14,0],

		"1f1fa-1f1f8":[["\uD83C\uDDFA\uD83C\uDDF8"],"\uE50C","\uDBB9\uDCE6",["us","flag-us"],5,11,31,0],

		"1f1fa-1f1fe":[["\uD83C\uDDFA\uD83C\uDDFE"],"","",["flag-uy"],5,12,31,0],

		"1f1fa-1f1ff":[["\uD83C\uDDFA\uD83C\uDDFF"],"","",["flag-uz"],5,13,31,0],

		"1f1fb-1f1e6":[["\uD83C\uDDFB\uD83C\uDDE6"],"","",["flag-va"],5,14,31,0],

		"1f1fb-1f1e8":[["\uD83C\uDDFB\uD83C\uDDE8"],"","",["flag-vc"],5,15,31,0],

		"1f1fb-1f1ea":[["\uD83C\uDDFB\uD83C\uDDEA"],"","",["flag-ve"],5,16,31,0],

		"1f1fb-1f1ec":[["\uD83C\uDDFB\uD83C\uDDEC"],"","",["flag-vg"],5,17,31,0],

		"1f1fb-1f1ee":[["\uD83C\uDDFB\uD83C\uDDEE"],"","",["flag-vi"],5,18,31,0],

		"1f1fb-1f1f3":[["\uD83C\uDDFB\uD83C\uDDF3"],"","",["flag-vn"],5,19,31,0],

		"1f1fb-1f1fa":[["\uD83C\uDDFB\uD83C\uDDFA"],"","",["flag-vu"],5,20,31,0],

		"1f1fc-1f1eb":[["\uD83C\uDDFC\uD83C\uDDEB"],"","",["flag-wf"],5,21,29,0],

		"1f1fc-1f1f8":[["\uD83C\uDDFC\uD83C\uDDF8"],"","",["flag-ws"],5,22,31,0],

		"1f1fd-1f1f0":[["\uD83C\uDDFD\uD83C\uDDF0"],"","",["flag-xk"],5,23,29,0],

		"1f1fe-1f1ea":[["\uD83C\uDDFE\uD83C\uDDEA"],"","",["flag-ye"],5,24,31,0],

		"1f1fe-1f1f9":[["\uD83C\uDDFE\uD83C\uDDF9"],"","",["flag-yt"],5,25,29,0],

		"1f1ff-1f1e6":[["\uD83C\uDDFF\uD83C\uDDE6"],"","",["flag-za"],5,26,31,0],

		"1f1ff-1f1f2":[["\uD83C\uDDFF\uD83C\uDDF2"],"","",["flag-zm"],5,27,31,0],

		"1f1ff-1f1fc":[["\uD83C\uDDFF\uD83C\uDDFC"],"","",["flag-zw"],5,28,31,0],

		"1f201":[["\uD83C\uDE01"],"\uE203","\uDBBA\uDF24",["koko"],5,29,31,0],

		"1f202-fe0f":[["\uD83C\uDE02\uFE0F","\uD83C\uDE02"],"\uE228","\uDBBA\uDF3F",["sa"],5,30,31,0],

		"1f21a":[["\uD83C\uDE1A"],"\uE216","\uDBBA\uDF3A",["u7121"],5,31,31,0],

		"1f22f":[["\uD83C\uDE2F"],"\uE22C","\uDBBA\uDF40",["u6307"],5,32,31,0],

		"1f232":[["\uD83C\uDE32"],"","\uDBBA\uDF2E",["u7981"],5,33,31,0],

		"1f233":[["\uD83C\uDE33"],"\uE22B","\uDBBA\uDF2F",["u7a7a"],5,34,31,0],

		"1f234":[["\uD83C\uDE34"],"","\uDBBA\uDF30",["u5408"],5,35,31,0],

		"1f235":[["\uD83C\uDE35"],"\uE22A","\uDBBA\uDF31",["u6e80"],5,36,31,0],

		"1f236":[["\uD83C\uDE36"],"\uE215","\uDBBA\uDF39",["u6709"],5,37,31,0],

		"1f237-fe0f":[["\uD83C\uDE37\uFE0F","\uD83C\uDE37"],"\uE217","\uDBBA\uDF3B",["u6708"],5,38,31,0],

		"1f238":[["\uD83C\uDE38"],"\uE218","\uDBBA\uDF3C",["u7533"],5,39,31,0],

		"1f239":[["\uD83C\uDE39"],"\uE227","\uDBBA\uDF3E",["u5272"],5,40,31,0],

		"1f23a":[["\uD83C\uDE3A"],"\uE22D","\uDBBA\uDF41",["u55b6"],5,41,31,0],

		"1f250":[["\uD83C\uDE50"],"\uE226","\uDBBA\uDF3D",["ideograph_advantage"],5,42,31,0],

		"1f251":[["\uD83C\uDE51"],"","\uDBBA\uDF50",["accept"],5,43,31,0],

		"1f300":[["\uD83C\uDF00"],"\uE443","\uDBB8\uDC05",["cyclone"],5,44,31,0],

		"1f301":[["\uD83C\uDF01"],"","\uDBB8\uDC06",["foggy"],5,45,31,0],

		"1f302":[["\uD83C\uDF02"],"\uE43C","\uDBB8\uDC07",["closed_umbrella"],5,46,31,0],

		"1f303":[["\uD83C\uDF03"],"\uE44B","\uDBB8\uDC08",["night_with_stars"],5,47,31,0],

		"1f304":[["\uD83C\uDF04"],"\uE04D","\uDBB8\uDC09",["sunrise_over_mountains"],5,48,31,0],

		"1f305":[["\uD83C\uDF05"],"\uE449","\uDBB8\uDC0A",["sunrise"],5,49,31,0],

		"1f306":[["\uD83C\uDF06"],"\uE146","\uDBB8\uDC0B",["city_sunset"],5,50,31,0],

		"1f307":[["\uD83C\uDF07"],"\uE44A","\uDBB8\uDC0C",["city_sunrise"],5,51,31,0],

		"1f308":[["\uD83C\uDF08"],"\uE44C","\uDBB8\uDC0D",["rainbow"],6,0,31,0],

		"1f309":[["\uD83C\uDF09"],"","\uDBB8\uDC10",["bridge_at_night"],6,1,31,0],

		"1f30a":[["\uD83C\uDF0A"],"\uE43E","\uDBB8\uDC38",["ocean"],6,2,31,0],

		"1f30b":[["\uD83C\uDF0B"],"","\uDBB8\uDC3A",["volcano"],6,3,31,0],

		"1f30c":[["\uD83C\uDF0C"],"","\uDBB8\uDC3B",["milky_way"],6,4,31,0],

		"1f30d":[["\uD83C\uDF0D"],"","",["earth_africa"],6,5,31,0],

		"1f30e":[["\uD83C\uDF0E"],"","",["earth_americas"],6,6,31,0],

		"1f30f":[["\uD83C\uDF0F"],"","\uDBB8\uDC39",["earth_asia"],6,7,31,0],

		"1f310":[["\uD83C\uDF10"],"","",["globe_with_meridians"],6,8,31,0],

		"1f311":[["\uD83C\uDF11"],"","\uDBB8\uDC11",["new_moon"],6,9,31,0],

		"1f312":[["\uD83C\uDF12"],"","",["waxing_crescent_moon"],6,10,31,0],

		"1f313":[["\uD83C\uDF13"],"","\uDBB8\uDC13",["first_quarter_moon"],6,11,31,0],

		"1f314":[["\uD83C\uDF14"],"","\uDBB8\uDC12",["moon","waxing_gibbous_moon"],6,12,31,0],

		"1f315":[["\uD83C\uDF15"],"","\uDBB8\uDC15",["full_moon"],6,13,31,0],

		"1f316":[["\uD83C\uDF16"],"","",["waning_gibbous_moon"],6,14,31,0],

		"1f317":[["\uD83C\uDF17"],"","",["last_quarter_moon"],6,15,31,0],

		"1f318":[["\uD83C\uDF18"],"","",["waning_crescent_moon"],6,16,31,0],

		"1f319":[["\uD83C\uDF19"],"\uE04C","\uDBB8\uDC14",["crescent_moon"],6,17,31,0],

		"1f31a":[["\uD83C\uDF1A"],"","",["new_moon_with_face"],6,18,31,0],

		"1f31b":[["\uD83C\uDF1B"],"","\uDBB8\uDC16",["first_quarter_moon_with_face"],6,19,31,0],

		"1f31c":[["\uD83C\uDF1C"],"","",["last_quarter_moon_with_face"],6,20,31,0],

		"1f31d":[["\uD83C\uDF1D"],"","",["full_moon_with_face"],6,21,31,0],

		"1f31e":[["\uD83C\uDF1E"],"","",["sun_with_face"],6,22,31,0],

		"1f31f":[["\uD83C\uDF1F"],"\uE335","\uDBBA\uDF69",["star2"],6,23,31,0],

		"1f320":[["\uD83C\uDF20"],"","\uDBBA\uDF6A",["stars"],6,24,31,0],

		"1f321-fe0f":[["\uD83C\uDF21\uFE0F","\uD83C\uDF21"],"","",["thermometer"],6,25,15,0],

		"1f324-fe0f":[["\uD83C\uDF24\uFE0F","\uD83C\uDF24"],"","",["mostly_sunny","sun_small_cloud"],6,26,15,0],

		"1f325-fe0f":[["\uD83C\uDF25\uFE0F","\uD83C\uDF25"],"","",["barely_sunny","sun_behind_cloud"],6,27,15,0],

		"1f326-fe0f":[["\uD83C\uDF26\uFE0F","\uD83C\uDF26"],"","",["partly_sunny_rain","sun_behind_rain_cloud"],6,28,15,0],

		"1f327-fe0f":[["\uD83C\uDF27\uFE0F","\uD83C\uDF27"],"","",["rain_cloud"],6,29,15,0],

		"1f328-fe0f":[["\uD83C\uDF28\uFE0F","\uD83C\uDF28"],"","",["snow_cloud"],6,30,15,0],

		"1f329-fe0f":[["\uD83C\uDF29\uFE0F","\uD83C\uDF29"],"","",["lightning","lightning_cloud"],6,31,15,0],

		"1f32a-fe0f":[["\uD83C\uDF2A\uFE0F","\uD83C\uDF2A"],"","",["tornado","tornado_cloud"],6,32,15,0],

		"1f32b-fe0f":[["\uD83C\uDF2B\uFE0F","\uD83C\uDF2B"],"","",["fog"],6,33,15,0],

		"1f32c-fe0f":[["\uD83C\uDF2C\uFE0F","\uD83C\uDF2C"],"","",["wind_blowing_face"],6,34,15,0],

		"1f32d":[["\uD83C\uDF2D"],"","",["hotdog"],6,35,15,0],

		"1f32e":[["\uD83C\uDF2E"],"","",["taco"],6,36,15,0],

		"1f32f":[["\uD83C\uDF2F"],"","",["burrito"],6,37,15,0],

		"1f330":[["\uD83C\uDF30"],"","\uDBB8\uDC4C",["chestnut"],6,38,31,0],

		"1f331":[["\uD83C\uDF31"],"","\uDBB8\uDC3E",["seedling"],6,39,31,0],

		"1f332":[["\uD83C\uDF32"],"","",["evergreen_tree"],6,40,31,0],

		"1f333":[["\uD83C\uDF33"],"","",["deciduous_tree"],6,41,31,0],

		"1f334":[["\uD83C\uDF34"],"\uE307","\uDBB8\uDC47",["palm_tree"],6,42,31,0],

		"1f335":[["\uD83C\uDF35"],"\uE308","\uDBB8\uDC48",["cactus"],6,43,31,0],

		"1f336-fe0f":[["\uD83C\uDF36\uFE0F","\uD83C\uDF36"],"","",["hot_pepper"],6,44,15,0],

		"1f337":[["\uD83C\uDF37"],"\uE304","\uDBB8\uDC3D",["tulip"],6,45,31,0],

		"1f338":[["\uD83C\uDF38"],"\uE030","\uDBB8\uDC40",["cherry_blossom"],6,46,31,0],

		"1f339":[["\uD83C\uDF39"],"\uE032","\uDBB8\uDC41",["rose"],6,47,31,0],

		"1f33a":[["\uD83C\uDF3A"],"\uE303","\uDBB8\uDC45",["hibiscus"],6,48,31,0],

		"1f33b":[["\uD83C\uDF3B"],"\uE305","\uDBB8\uDC46",["sunflower"],6,49,31,0],

		"1f33c":[["\uD83C\uDF3C"],"","\uDBB8\uDC4D",["blossom"],6,50,31,0],

		"1f33d":[["\uD83C\uDF3D"],"","\uDBB8\uDC4A",["corn"],6,51,31,0],

		"1f33e":[["\uD83C\uDF3E"],"\uE444","\uDBB8\uDC49",["ear_of_rice"],7,0,31,0],

		"1f33f":[["\uD83C\uDF3F"],"","\uDBB8\uDC4E",["herb"],7,1,31,0],

		"1f340":[["\uD83C\uDF40"],"\uE110","\uDBB8\uDC3C",["four_leaf_clover"],7,2,31,0],

		"1f341":[["\uD83C\uDF41"],"\uE118","\uDBB8\uDC3F",["maple_leaf"],7,3,31,0],

		"1f342":[["\uD83C\uDF42"],"\uE119","\uDBB8\uDC42",["fallen_leaf"],7,4,31,0],

		"1f343":[["\uD83C\uDF43"],"\uE447","\uDBB8\uDC43",["leaves"],7,5,31,0],

		"1f344":[["\uD83C\uDF44"],"","\uDBB8\uDC4B",["mushroom"],7,6,31,0],

		"1f345":[["\uD83C\uDF45"],"\uE349","\uDBB8\uDC55",["tomato"],7,7,31,0],

		"1f346":[["\uD83C\uDF46"],"\uE34A","\uDBB8\uDC56",["eggplant"],7,8,31,0],

		"1f347":[["\uD83C\uDF47"],"","\uDBB8\uDC59",["grapes"],7,9,31,0],

		"1f348":[["\uD83C\uDF48"],"","\uDBB8\uDC57",["melon"],7,10,31,0],

		"1f349":[["\uD83C\uDF49"],"\uE348","\uDBB8\uDC54",["watermelon"],7,11,31,0],

		"1f34a":[["\uD83C\uDF4A"],"\uE346","\uDBB8\uDC52",["tangerine"],7,12,31,0],

		"1f34b":[["\uD83C\uDF4B"],"","",["lemon"],7,13,31,0],

		"1f34c":[["\uD83C\uDF4C"],"","\uDBB8\uDC50",["banana"],7,14,31,0],

		"1f34d":[["\uD83C\uDF4D"],"","\uDBB8\uDC58",["pineapple"],7,15,31,0],

		"1f34e":[["\uD83C\uDF4E"],"\uE345","\uDBB8\uDC51",["apple"],7,16,31,0],

		"1f34f":[["\uD83C\uDF4F"],"","\uDBB8\uDC5B",["green_apple"],7,17,31,0],

		"1f350":[["\uD83C\uDF50"],"","",["pear"],7,18,31,0],

		"1f351":[["\uD83C\uDF51"],"","\uDBB8\uDC5A",["peach"],7,19,31,0],

		"1f352":[["\uD83C\uDF52"],"","\uDBB8\uDC4F",["cherries"],7,20,31,0],

		"1f353":[["\uD83C\uDF53"],"\uE347","\uDBB8\uDC53",["strawberry"],7,21,31,0],

		"1f354":[["\uD83C\uDF54"],"\uE120","\uDBBA\uDD60",["hamburger"],7,22,31,0],

		"1f355":[["\uD83C\uDF55"],"","\uDBBA\uDD75",["pizza"],7,23,31,0],

		"1f356":[["\uD83C\uDF56"],"","\uDBBA\uDD72",["meat_on_bone"],7,24,31,0],

		"1f357":[["\uD83C\uDF57"],"","\uDBBA\uDD76",["poultry_leg"],7,25,31,0],

		"1f358":[["\uD83C\uDF58"],"\uE33D","\uDBBA\uDD69",["rice_cracker"],7,26,31,0],

		"1f359":[["\uD83C\uDF59"],"\uE342","\uDBBA\uDD61",["rice_ball"],7,27,31,0],

		"1f35a":[["\uD83C\uDF5A"],"\uE33E","\uDBBA\uDD6A",["rice"],7,28,31,0],

		"1f35b":[["\uD83C\uDF5B"],"\uE341","\uDBBA\uDD6C",["curry"],7,29,31,0],

		"1f35c":[["\uD83C\uDF5C"],"\uE340","\uDBBA\uDD63",["ramen"],7,30,31,0],

		"1f35d":[["\uD83C\uDF5D"],"\uE33F","\uDBBA\uDD6B",["spaghetti"],7,31,31,0],

		"1f35e":[["\uD83C\uDF5E"],"\uE339","\uDBBA\uDD64",["bread"],7,32,31,0],

		"1f35f":[["\uD83C\uDF5F"],"\uE33B","\uDBBA\uDD67",["fries"],7,33,31,0],

		"1f360":[["\uD83C\uDF60"],"","\uDBBA\uDD74",["sweet_potato"],7,34,31,0],

		"1f361":[["\uD83C\uDF61"],"\uE33C","\uDBBA\uDD68",["dango"],7,35,31,0],

		"1f362":[["\uD83C\uDF62"],"\uE343","\uDBBA\uDD6D",["oden"],7,36,31,0],

		"1f363":[["\uD83C\uDF63"],"\uE344","\uDBBA\uDD6E",["sushi"],7,37,31,0],

		"1f364":[["\uD83C\uDF64"],"","\uDBBA\uDD7F",["fried_shrimp"],7,38,31,0],

		"1f365":[["\uD83C\uDF65"],"","\uDBBA\uDD73",["fish_cake"],7,39,31,0],

		"1f366":[["\uD83C\uDF66"],"\uE33A","\uDBBA\uDD66",["icecream"],7,40,31,0],

		"1f367":[["\uD83C\uDF67"],"\uE43F","\uDBBA\uDD71",["shaved_ice"],7,41,31,0],

		"1f368":[["\uD83C\uDF68"],"","\uDBBA\uDD77",["ice_cream"],7,42,31,0],

		"1f369":[["\uD83C\uDF69"],"","\uDBBA\uDD78",["doughnut"],7,43,31,0],

		"1f36a":[["\uD83C\uDF6A"],"","\uDBBA\uDD79",["cookie"],7,44,31,0],

		"1f36b":[["\uD83C\uDF6B"],"","\uDBBA\uDD7A",["chocolate_bar"],7,45,31,0],

		"1f36c":[["\uD83C\uDF6C"],"","\uDBBA\uDD7B",["candy"],7,46,31,0],

		"1f36d":[["\uD83C\uDF6D"],"","\uDBBA\uDD7C",["lollipop"],7,47,31,0],

		"1f36e":[["\uD83C\uDF6E"],"","\uDBBA\uDD7D",["custard"],7,48,31,0],

		"1f36f":[["\uD83C\uDF6F"],"","\uDBBA\uDD7E",["honey_pot"],7,49,31,0],

		"1f370":[["\uD83C\uDF70"],"\uE046","\uDBBA\uDD62",["cake"],7,50,31,0],

		"1f371":[["\uD83C\uDF71"],"\uE34C","\uDBBA\uDD6F",["bento"],7,51,31,0],

		"1f372":[["\uD83C\uDF72"],"\uE34D","\uDBBA\uDD70",["stew"],8,0,31,0],

		"1f373":[["\uD83C\uDF73"],"\uE147","\uDBBA\uDD65",["fried_egg","cooking"],8,1,31,0],

		"1f374":[["\uD83C\uDF74"],"\uE043","\uDBBA\uDD80",["fork_and_knife"],8,2,31,0],

		"1f375":[["\uD83C\uDF75"],"\uE338","\uDBBA\uDD84",["tea"],8,3,31,0],

		"1f376":[["\uD83C\uDF76"],"\uE30B","\uDBBA\uDD85",["sake"],8,4,31,0],

		"1f377":[["\uD83C\uDF77"],"","\uDBBA\uDD86",["wine_glass"],8,5,31,0],

		"1f378":[["\uD83C\uDF78"],"\uE044","\uDBBA\uDD82",["cocktail"],8,6,31,0],

		"1f379":[["\uD83C\uDF79"],"","\uDBBA\uDD88",["tropical_drink"],8,7,31,0],

		"1f37a":[["\uD83C\uDF7A"],"\uE047","\uDBBA\uDD83",["beer"],8,8,31,0],

		"1f37b":[["\uD83C\uDF7B"],"\uE30C","\uDBBA\uDD87",["beers"],8,9,31,0],

		"1f37c":[["\uD83C\uDF7C"],"","",["baby_bottle"],8,10,31,0],

		"1f37d-fe0f":[["\uD83C\uDF7D\uFE0F","\uD83C\uDF7D"],"","",["knife_fork_plate"],8,11,15,0],

		"1f37e":[["\uD83C\uDF7E"],"","",["champagne"],8,12,15,0],

		"1f37f":[["\uD83C\uDF7F"],"","",["popcorn"],8,13,15,0],

		"1f380":[["\uD83C\uDF80"],"\uE314","\uDBB9\uDD0F",["ribbon"],8,14,31,0],

		"1f381":[["\uD83C\uDF81"],"\uE112","\uDBB9\uDD10",["gift"],8,15,31,0],

		"1f382":[["\uD83C\uDF82"],"\uE34B","\uDBB9\uDD11",["birthday"],8,16,31,0],

		"1f383":[["\uD83C\uDF83"],"\uE445","\uDBB9\uDD1F",["jack_o_lantern"],8,17,31,0],

		"1f384":[["\uD83C\uDF84"],"\uE033","\uDBB9\uDD12",["christmas_tree"],8,18,31,0],

		"1f385":[["\uD83C\uDF85"],"\uE448","\uDBB9\uDD13",["santa"],8,19,31,0],

		"1f386":[["\uD83C\uDF86"],"\uE117","\uDBB9\uDD15",["fireworks"],8,25,31,0],

		"1f387":[["\uD83C\uDF87"],"\uE440","\uDBB9\uDD1D",["sparkler"],8,26,31,0],

		"1f388":[["\uD83C\uDF88"],"\uE310","\uDBB9\uDD16",["balloon"],8,27,31,0],

		"1f389":[["\uD83C\uDF89"],"\uE312","\uDBB9\uDD17",["tada"],8,28,31,0],

		"1f38a":[["\uD83C\uDF8A"],"","\uDBB9\uDD20",["confetti_ball"],8,29,31,0],

		"1f38b":[["\uD83C\uDF8B"],"","\uDBB9\uDD21",["tanabata_tree"],8,30,31,0],

		"1f38c":[["\uD83C\uDF8C"],"\uE143","\uDBB9\uDD14",["crossed_flags"],8,31,31,0],

		"1f38d":[["\uD83C\uDF8D"],"\uE436","\uDBB9\uDD18",["bamboo"],8,32,31,0],

		"1f38e":[["\uD83C\uDF8E"],"\uE438","\uDBB9\uDD19",["dolls"],8,33,31,0],

		"1f38f":[["\uD83C\uDF8F"],"\uE43B","\uDBB9\uDD1C",["flags"],8,34,31,0],

		"1f390":[["\uD83C\uDF90"],"\uE442","\uDBB9\uDD1E",["wind_chime"],8,35,31,0],

		"1f391":[["\uD83C\uDF91"],"\uE446","\uDBB8\uDC17",["rice_scene"],8,36,31,0],

		"1f392":[["\uD83C\uDF92"],"\uE43A","\uDBB9\uDD1B",["school_satchel"],8,37,31,0],

		"1f393":[["\uD83C\uDF93"],"\uE439","\uDBB9\uDD1A",["mortar_board"],8,38,31,0],

		"1f396-fe0f":[["\uD83C\uDF96\uFE0F","\uD83C\uDF96"],"","",["medal"],8,39,15,0],

		"1f397-fe0f":[["\uD83C\uDF97\uFE0F","\uD83C\uDF97"],"","",["reminder_ribbon"],8,40,15,0],

		"1f399-fe0f":[["\uD83C\uDF99\uFE0F","\uD83C\uDF99"],"","",["studio_microphone"],8,41,15,0],

		"1f39a-fe0f":[["\uD83C\uDF9A\uFE0F","\uD83C\uDF9A"],"","",["level_slider"],8,42,15,0],

		"1f39b-fe0f":[["\uD83C\uDF9B\uFE0F","\uD83C\uDF9B"],"","",["control_knobs"],8,43,15,0],

		"1f39e-fe0f":[["\uD83C\uDF9E\uFE0F","\uD83C\uDF9E"],"","",["film_frames"],8,44,15,0],

		"1f39f-fe0f":[["\uD83C\uDF9F\uFE0F","\uD83C\uDF9F"],"","",["admission_tickets"],8,45,15,0],

		"1f3a0":[["\uD83C\uDFA0"],"","\uDBB9\uDFFC",["carousel_horse"],8,46,31,0],

		"1f3a1":[["\uD83C\uDFA1"],"\uE124","\uDBB9\uDFFD",["ferris_wheel"],8,47,31,0],

		"1f3a2":[["\uD83C\uDFA2"],"\uE433","\uDBB9\uDFFE",["roller_coaster"],8,48,31,0],

		"1f3a3":[["\uD83C\uDFA3"],"","\uDBB9\uDFFF",["fishing_pole_and_fish"],8,49,31,0],

		"1f3a4":[["\uD83C\uDFA4"],"\uE03C","\uDBBA\uDC00",["microphone"],8,50,31,0],

		"1f3a5":[["\uD83C\uDFA5"],"\uE03D","\uDBBA\uDC01",["movie_camera"],8,51,31,0],

		"1f3a6":[["\uD83C\uDFA6"],"\uE507","\uDBBA\uDC02",["cinema"],9,0,31,0],

		"1f3a7":[["\uD83C\uDFA7"],"\uE30A","\uDBBA\uDC03",["headphones"],9,1,31,0],

		"1f3a8":[["\uD83C\uDFA8"],"\uE502","\uDBBA\uDC04",["art"],9,2,31,0],

		"1f3a9":[["\uD83C\uDFA9"],"\uE503","\uDBBA\uDC05",["tophat"],9,3,31,0],

		"1f3aa":[["\uD83C\uDFAA"],"","\uDBBA\uDC06",["circus_tent"],9,4,31,0],

		"1f3ab":[["\uD83C\uDFAB"],"\uE125","\uDBBA\uDC07",["ticket"],9,5,31,0],

		"1f3ac":[["\uD83C\uDFAC"],"\uE324","\uDBBA\uDC08",["clapper"],9,6,31,0],

		"1f3ad":[["\uD83C\uDFAD"],"","\uDBBA\uDC09",["performing_arts"],9,7,31,0],

		"1f3ae":[["\uD83C\uDFAE"],"","\uDBBA\uDC0A",["video_game"],9,8,31,0],

		"1f3af":[["\uD83C\uDFAF"],"\uE130","\uDBBA\uDC0C",["dart"],9,9,31,0],

		"1f3b0":[["\uD83C\uDFB0"],"\uE133","\uDBBA\uDC0D",["slot_machine"],9,10,31,0],

		"1f3b1":[["\uD83C\uDFB1"],"\uE42C","\uDBBA\uDC0E",["8ball"],9,11,31,0],

		"1f3b2":[["\uD83C\uDFB2"],"","\uDBBA\uDC0F",["game_die"],9,12,31,0],

		"1f3b3":[["\uD83C\uDFB3"],"","\uDBBA\uDC10",["bowling"],9,13,31,0],

		"1f3b4":[["\uD83C\uDFB4"],"","\uDBBA\uDC11",["flower_playing_cards"],9,14,31,0],

		"1f3b5":[["\uD83C\uDFB5"],"\uE03E","\uDBBA\uDC13",["musical_note"],9,15,31,0],

		"1f3b6":[["\uD83C\uDFB6"],"\uE326","\uDBBA\uDC14",["notes"],9,16,31,0],

		"1f3b7":[["\uD83C\uDFB7"],"\uE040","\uDBBA\uDC15",["saxophone"],9,17,31,0],

		"1f3b8":[["\uD83C\uDFB8"],"\uE041","\uDBBA\uDC16",["guitar"],9,18,31,0],

		"1f3b9":[["\uD83C\uDFB9"],"","\uDBBA\uDC17",["musical_keyboard"],9,19,31,0],

		"1f3ba":[["\uD83C\uDFBA"],"\uE042","\uDBBA\uDC18",["trumpet"],9,20,31,0],

		"1f3bb":[["\uD83C\uDFBB"],"","\uDBBA\uDC19",["violin"],9,21,31,0],

		"1f3bc":[["\uD83C\uDFBC"],"","\uDBBA\uDC1A",["musical_score"],9,22,31,0],

		"1f3bd":[["\uD83C\uDFBD"],"","\uDBB9\uDFD0",["running_shirt_with_sash"],9,23,31,0],

		"1f3be":[["\uD83C\uDFBE"],"\uE015","\uDBB9\uDFD3",["tennis"],9,24,31,0],

		"1f3bf":[["\uD83C\uDFBF"],"\uE013","\uDBB9\uDFD5",["ski"],9,25,31,0],

		"1f3c0":[["\uD83C\uDFC0"],"\uE42A","\uDBB9\uDFD6",["basketball"],9,26,31,0],

		"1f3c1":[["\uD83C\uDFC1"],"\uE132","\uDBB9\uDFD7",["checkered_flag"],9,27,31,0],

		"1f3c2":[["\uD83C\uDFC2"],"","\uDBB9\uDFD8",["snowboarder"],9,28,31,0],

		"1f3c3-200d-2640-fe0f":[["\uD83C\uDFC3\u200D\u2640\uFE0F","\uD83C\uDFC3\u200D\u2640"],"","",["woman-running"],9,34,15,0],

		"1f3c3-200d-2642-fe0f":[["\uD83C\uDFC3\u200D\u2642\uFE0F","\uD83C\uDFC3\u200D\u2642","\uD83C\uDFC3"],"","",["man-running","runner","running"],9,40,15,0],

		"1f3c4-200d-2640-fe0f":[["\uD83C\uDFC4\u200D\u2640\uFE0F","\uD83C\uDFC4\u200D\u2640"],"","",["woman-surfing"],10,0,15,0],

		"1f3c4-200d-2642-fe0f":[["\uD83C\uDFC4\u200D\u2642\uFE0F","\uD83C\uDFC4\u200D\u2642","\uD83C\uDFC4"],"","",["man-surfing","surfer"],10,6,15,0],

		"1f3c5":[["\uD83C\uDFC5"],"","",["sports_medal"],10,18,15,0],

		"1f3c6":[["\uD83C\uDFC6"],"\uE131","\uDBB9\uDFDB",["trophy"],10,19,31,0],

		"1f3c7":[["\uD83C\uDFC7"],"","",["horse_racing"],10,20,31,0],

		"1f3c8":[["\uD83C\uDFC8"],"\uE42B","\uDBB9\uDFDD",["football"],10,26,31,0],

		"1f3c9":[["\uD83C\uDFC9"],"","",["rugby_football"],10,27,31,0],

		"1f3ca-200d-2640-fe0f":[["\uD83C\uDFCA\u200D\u2640\uFE0F","\uD83C\uDFCA\u200D\u2640"],"","",["woman-swimming"],10,28,15,0],

		"1f3ca-200d-2642-fe0f":[["\uD83C\uDFCA\u200D\u2642\uFE0F","\uD83C\uDFCA\u200D\u2642","\uD83C\uDFCA"],"","",["man-swimming","swimmer"],10,34,15,0],

		"1f3cb-fe0f-200d-2640-fe0f":[["\uD83C\uDFCB\uFE0F\u200D\u2640\uFE0F"],"","",["woman-lifting-weights"],10,46,7,0],

		"1f3cb-fe0f-200d-2642-fe0f":[["\uD83C\uDFCB\uFE0F\u200D\u2642\uFE0F","\uD83C\uDFCB\uFE0F","\uD83C\uDFCB"],"","",["man-lifting-weights","weight_lifter"],11,0,7,0],

		"1f3cc-fe0f-200d-2640-fe0f":[["\uD83C\uDFCC\uFE0F\u200D\u2640\uFE0F"],"","",["woman-golfing"],11,12,7,0],

		"1f3cc-fe0f-200d-2642-fe0f":[["\uD83C\uDFCC\uFE0F\u200D\u2642\uFE0F","\uD83C\uDFCC\uFE0F","\uD83C\uDFCC"],"","",["man-golfing","golfer"],11,18,7,0],

		"1f3cd-fe0f":[["\uD83C\uDFCD\uFE0F","\uD83C\uDFCD"],"","",["racing_motorcycle"],11,30,15,0],

		"1f3ce-fe0f":[["\uD83C\uDFCE\uFE0F","\uD83C\uDFCE"],"","",["racing_car"],11,31,15,0],

		"1f3cf":[["\uD83C\uDFCF"],"","",["cricket_bat_and_ball"],11,32,15,0],

		"1f3d0":[["\uD83C\uDFD0"],"","",["volleyball"],11,33,15,0],

		"1f3d1":[["\uD83C\uDFD1"],"","",["field_hockey_stick_and_ball"],11,34,15,0],

		"1f3d2":[["\uD83C\uDFD2"],"","",["ice_hockey_stick_and_puck"],11,35,15,0],

		"1f3d3":[["\uD83C\uDFD3"],"","",["table_tennis_paddle_and_ball"],11,36,15,0],

		"1f3d4-fe0f":[["\uD83C\uDFD4\uFE0F","\uD83C\uDFD4"],"","",["snow_capped_mountain"],11,37,15,0],

		"1f3d5-fe0f":[["\uD83C\uDFD5\uFE0F","\uD83C\uDFD5"],"","",["camping"],11,38,15,0],

		"1f3d6-fe0f":[["\uD83C\uDFD6\uFE0F","\uD83C\uDFD6"],"","",["beach_with_umbrella"],11,39,15,0],

		"1f3d7-fe0f":[["\uD83C\uDFD7\uFE0F","\uD83C\uDFD7"],"","",["building_construction"],11,40,15,0],

		"1f3d8-fe0f":[["\uD83C\uDFD8\uFE0F","\uD83C\uDFD8"],"","",["house_buildings"],11,41,15,0],

		"1f3d9-fe0f":[["\uD83C\uDFD9\uFE0F","\uD83C\uDFD9"],"","",["cityscape"],11,42,15,0],

		"1f3da-fe0f":[["\uD83C\uDFDA\uFE0F","\uD83C\uDFDA"],"","",["derelict_house_building"],11,43,15,0],

		"1f3db-fe0f":[["\uD83C\uDFDB\uFE0F","\uD83C\uDFDB"],"","",["classical_building"],11,44,15,0],

		"1f3dc-fe0f":[["\uD83C\uDFDC\uFE0F","\uD83C\uDFDC"],"","",["desert"],11,45,15,0],

		"1f3dd-fe0f":[["\uD83C\uDFDD\uFE0F","\uD83C\uDFDD"],"","",["desert_island"],11,46,15,0],

		"1f3de-fe0f":[["\uD83C\uDFDE\uFE0F","\uD83C\uDFDE"],"","",["national_park"],11,47,15,0],

		"1f3df-fe0f":[["\uD83C\uDFDF\uFE0F","\uD83C\uDFDF"],"","",["stadium"],11,48,15,0],

		"1f3e0":[["\uD83C\uDFE0"],"\uE036","\uDBB9\uDCB0",["house"],11,49,31,0],

		"1f3e1":[["\uD83C\uDFE1"],"","\uDBB9\uDCB1",["house_with_garden"],11,50,31,0],

		"1f3e2":[["\uD83C\uDFE2"],"\uE038","\uDBB9\uDCB2",["office"],11,51,31,0],

		"1f3e3":[["\uD83C\uDFE3"],"\uE153","\uDBB9\uDCB3",["post_office"],12,0,31,0],

		"1f3e4":[["\uD83C\uDFE4"],"","",["european_post_office"],12,1,31,0],

		"1f3e5":[["\uD83C\uDFE5"],"\uE155","\uDBB9\uDCB4",["hospital"],12,2,31,0],

		"1f3e6":[["\uD83C\uDFE6"],"\uE14D","\uDBB9\uDCB5",["bank"],12,3,31,0],

		"1f3e7":[["\uD83C\uDFE7"],"\uE154","\uDBB9\uDCB6",["atm"],12,4,31,0],

		"1f3e8":[["\uD83C\uDFE8"],"\uE158","\uDBB9\uDCB7",["hotel"],12,5,31,0],

		"1f3e9":[["\uD83C\uDFE9"],"\uE501","\uDBB9\uDCB8",["love_hotel"],12,6,31,0],

		"1f3ea":[["\uD83C\uDFEA"],"\uE156","\uDBB9\uDCB9",["convenience_store"],12,7,31,0],

		"1f3eb":[["\uD83C\uDFEB"],"\uE157","\uDBB9\uDCBA",["school"],12,8,31,0],

		"1f3ec":[["\uD83C\uDFEC"],"\uE504","\uDBB9\uDCBD",["department_store"],12,9,31,0],

		"1f3ed":[["\uD83C\uDFED"],"\uE508","\uDBB9\uDCC0",["factory"],12,10,31,0],

		"1f3ee":[["\uD83C\uDFEE"],"","\uDBB9\uDCC2",["izakaya_lantern","lantern"],12,11,31,0],

		"1f3ef":[["\uD83C\uDFEF"],"\uE505","\uDBB9\uDCBE",["japanese_castle"],12,12,31,0],

		"1f3f0":[["\uD83C\uDFF0"],"\uE506","\uDBB9\uDCBF",["european_castle"],12,13,31,0],

		"1f3f3-fe0f-200d-1f308":[["\uD83C\uDFF3\uFE0F\u200D\uD83C\uDF08","\uD83C\uDFF3\u200D\uD83C\uDF08"],"","",["rainbow-flag"],12,14,31,0],

		"1f3f3-fe0f":[["\uD83C\uDFF3\uFE0F","\uD83C\uDFF3"],"","",["waving_white_flag"],12,15,15,0],

		"1f3f4-e0067-e0062-e0065-e006e-e0067-e007f":[["\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62\uDB40\uDC65\uDB40\uDC6E\uDB40\uDC67\uDB40\uDC7F"],"","",["flag-england"],12,16,15,0],

		"1f3f4-e0067-e0062-e0073-e0063-e0074-e007f":[["\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62\uDB40\uDC73\uDB40\uDC63\uDB40\uDC74\uDB40\uDC7F"],"","",["flag-scotland"],12,17,15,0],

		"1f3f4-e0067-e0062-e0077-e006c-e0073-e007f":[["\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62\uDB40\uDC77\uDB40\uDC6C\uDB40\uDC73\uDB40\uDC7F"],"","",["flag-wales"],12,18,15,0],

		"1f3f4":[["\uD83C\uDFF4"],"","",["waving_black_flag"],12,19,15,0],

		"1f3f5-fe0f":[["\uD83C\uDFF5\uFE0F","\uD83C\uDFF5"],"","",["rosette"],12,20,15,0],

		"1f3f7-fe0f":[["\uD83C\uDFF7\uFE0F","\uD83C\uDFF7"],"","",["label"],12,21,15,0],

		"1f3f8":[["\uD83C\uDFF8"],"","",["badminton_racquet_and_shuttlecock"],12,22,15,0],

		"1f3f9":[["\uD83C\uDFF9"],"","",["bow_and_arrow"],12,23,15,0],

		"1f3fa":[["\uD83C\uDFFA"],"","",["amphora"],12,24,15,0],

		"1f3fb":[["\uD83C\uDFFB"],"","",["skin-tone-2"],12,25,15,0],

		"1f3fc":[["\uD83C\uDFFC"],"","",["skin-tone-3"],12,26,15,0],

		"1f3fd":[["\uD83C\uDFFD"],"","",["skin-tone-4"],12,27,15,0],

		"1f3fe":[["\uD83C\uDFFE"],"","",["skin-tone-5"],12,28,15,0],

		"1f3ff":[["\uD83C\uDFFF"],"","",["skin-tone-6"],12,29,15,0],

		"1f400":[["\uD83D\uDC00"],"","",["rat"],12,30,31,0],

		"1f401":[["\uD83D\uDC01"],"","",["mouse2"],12,31,31,0],

		"1f402":[["\uD83D\uDC02"],"","",["ox"],12,32,31,0],

		"1f403":[["\uD83D\uDC03"],"","",["water_buffalo"],12,33,31,0],

		"1f404":[["\uD83D\uDC04"],"","",["cow2"],12,34,31,0],

		"1f405":[["\uD83D\uDC05"],"","",["tiger2"],12,35,31,0],

		"1f406":[["\uD83D\uDC06"],"","",["leopard"],12,36,31,0],

		"1f407":[["\uD83D\uDC07"],"","",["rabbit2"],12,37,31,0],

		"1f408":[["\uD83D\uDC08"],"","",["cat2"],12,38,31,0],

		"1f409":[["\uD83D\uDC09"],"","",["dragon"],12,39,31,0],

		"1f40a":[["\uD83D\uDC0A"],"","",["crocodile"],12,40,31,0],

		"1f40b":[["\uD83D\uDC0B"],"","",["whale2"],12,41,31,0],

		"1f40c":[["\uD83D\uDC0C"],"","\uDBB8\uDDB9",["snail"],12,42,31,0],

		"1f40d":[["\uD83D\uDC0D"],"\uE52D","\uDBB8\uDDD3",["snake"],12,43,31,0],

		"1f40e":[["\uD83D\uDC0E"],"\uE134","\uDBB9\uDFDC",["racehorse"],12,44,31,0],

		"1f40f":[["\uD83D\uDC0F"],"","",["ram"],12,45,31,0],

		"1f410":[["\uD83D\uDC10"],"","",["goat"],12,46,31,0],

		"1f411":[["\uD83D\uDC11"],"\uE529","\uDBB8\uDDCF",["sheep"],12,47,31,0],

		"1f412":[["\uD83D\uDC12"],"\uE528","\uDBB8\uDDCE",["monkey"],12,48,31,0],

		"1f413":[["\uD83D\uDC13"],"","",["rooster"],12,49,31,0],

		"1f414":[["\uD83D\uDC14"],"\uE52E","\uDBB8\uDDD4",["chicken"],12,50,31,0],

		"1f415":[["\uD83D\uDC15"],"","",["dog2"],12,51,31,0],

		"1f416":[["\uD83D\uDC16"],"","",["pig2"],13,0,31,0],

		"1f417":[["\uD83D\uDC17"],"\uE52F","\uDBB8\uDDD5",["boar"],13,1,31,0],

		"1f418":[["\uD83D\uDC18"],"\uE526","\uDBB8\uDDCC",["elephant"],13,2,31,0],

		"1f419":[["\uD83D\uDC19"],"\uE10A","\uDBB8\uDDC5",["octopus"],13,3,31,0],

		"1f41a":[["\uD83D\uDC1A"],"\uE441","\uDBB8\uDDC6",["shell"],13,4,31,0],

		"1f41b":[["\uD83D\uDC1B"],"\uE525","\uDBB8\uDDCB",["bug"],13,5,31,0],

		"1f41c":[["\uD83D\uDC1C"],"","\uDBB8\uDDDA",["ant"],13,6,31,0],

		"1f41d":[["\uD83D\uDC1D"],"","\uDBB8\uDDE1",["bee","honeybee"],13,7,31,0],

		"1f41e":[["\uD83D\uDC1E"],"","\uDBB8\uDDE2",["beetle"],13,8,31,0],

		"1f41f":[["\uD83D\uDC1F"],"\uE019","\uDBB8\uDDBD",["fish"],13,9,31,0],

		"1f420":[["\uD83D\uDC20"],"\uE522","\uDBB8\uDDC9",["tropical_fish"],13,10,31,0],

		"1f421":[["\uD83D\uDC21"],"","\uDBB8\uDDD9",["blowfish"],13,11,31,0],

		"1f422":[["\uD83D\uDC22"],"","\uDBB8\uDDDC",["turtle"],13,12,31,0],

		"1f423":[["\uD83D\uDC23"],"","\uDBB8\uDDDD",["hatching_chick"],13,13,31,0],

		"1f424":[["\uD83D\uDC24"],"\uE523","\uDBB8\uDDBA",["baby_chick"],13,14,31,0],

		"1f425":[["\uD83D\uDC25"],"","\uDBB8\uDDBB",["hatched_chick"],13,15,31,0],

		"1f426":[["\uD83D\uDC26"],"\uE521","\uDBB8\uDDC8",["bird"],13,16,31,0],

		"1f427":[["\uD83D\uDC27"],"\uE055","\uDBB8\uDDBC",["penguin"],13,17,31,0],

		"1f428":[["\uD83D\uDC28"],"\uE527","\uDBB8\uDDCD",["koala"],13,18,31,0],

		"1f429":[["\uD83D\uDC29"],"","\uDBB8\uDDD8",["poodle"],13,19,31,0],

		"1f42a":[["\uD83D\uDC2A"],"","",["dromedary_camel"],13,20,31,0],

		"1f42b":[["\uD83D\uDC2B"],"\uE530","\uDBB8\uDDD6",["camel"],13,21,31,0],

		"1f42c":[["\uD83D\uDC2C"],"\uE520","\uDBB8\uDDC7",["dolphin","flipper"],13,22,31,0],

		"1f42d":[["\uD83D\uDC2D"],"\uE053","\uDBB8\uDDC2",["mouse"],13,23,31,0],

		"1f42e":[["\uD83D\uDC2E"],"\uE52B","\uDBB8\uDDD1",["cow"],13,24,31,0],

		"1f42f":[["\uD83D\uDC2F"],"\uE050","\uDBB8\uDDC0",["tiger"],13,25,31,0],

		"1f430":[["\uD83D\uDC30"],"\uE52C","\uDBB8\uDDD2",["rabbit"],13,26,31,0],

		"1f431":[["\uD83D\uDC31"],"\uE04F","\uDBB8\uDDB8",["cat"],13,27,31,0],

		"1f432":[["\uD83D\uDC32"],"","\uDBB8\uDDDE",["dragon_face"],13,28,31,0],

		"1f433":[["\uD83D\uDC33"],"\uE054","\uDBB8\uDDC3",["whale"],13,29,31,0],

		"1f434":[["\uD83D\uDC34"],"\uE01A","\uDBB8\uDDBE",["horse"],13,30,31,0],

		"1f435":[["\uD83D\uDC35"],"\uE109","\uDBB8\uDDC4",["monkey_face"],13,31,31,0],

		"1f436":[["\uD83D\uDC36"],"\uE052","\uDBB8\uDDB7",["dog"],13,32,31,0],

		"1f437":[["\uD83D\uDC37"],"\uE10B","\uDBB8\uDDBF",["pig"],13,33,31,0],

		"1f438":[["\uD83D\uDC38"],"\uE531","\uDBB8\uDDD7",["frog"],13,34,31,0],

		"1f439":[["\uD83D\uDC39"],"\uE524","\uDBB8\uDDCA",["hamster"],13,35,31,0],

		"1f43a":[["\uD83D\uDC3A"],"\uE52A","\uDBB8\uDDD0",["wolf"],13,36,31,0],

		"1f43b":[["\uD83D\uDC3B"],"\uE051","\uDBB8\uDDC1",["bear"],13,37,31,0],

		"1f43c":[["\uD83D\uDC3C"],"","\uDBB8\uDDDF",["panda_face"],13,38,31,0],

		"1f43d":[["\uD83D\uDC3D"],"","\uDBB8\uDDE0",["pig_nose"],13,39,31,0],

		"1f43e":[["\uD83D\uDC3E"],"","\uDBB8\uDDDB",["feet","paw_prints"],13,40,31,0],

		"1f43f-fe0f":[["\uD83D\uDC3F\uFE0F","\uD83D\uDC3F"],"","",["chipmunk"],13,41,15,0],

		"1f440":[["\uD83D\uDC40"],"\uE419","\uDBB8\uDD90",["eyes"],13,42,31,0],

		"1f441-fe0f-200d-1f5e8-fe0f":[["\uD83D\uDC41\uFE0F\u200D\uD83D\uDDE8\uFE0F"],"","",["eye-in-speech-bubble"],13,43,3,0],

		"1f441-fe0f":[["\uD83D\uDC41\uFE0F","\uD83D\uDC41"],"","",["eye"],13,44,15,0],

		"1f442":[["\uD83D\uDC42"],"\uE41B","\uDBB8\uDD91",["ear"],13,45,31,0],

		"1f443":[["\uD83D\uDC43"],"\uE41A","\uDBB8\uDD92",["nose"],13,51,31,0],

		"1f444":[["\uD83D\uDC44"],"\uE41C","\uDBB8\uDD93",["lips"],14,5,31,0],

		"1f445":[["\uD83D\uDC45"],"","\uDBB8\uDD94",["tongue"],14,6,31,0],

		"1f446":[["\uD83D\uDC46"],"\uE22E","\uDBBA\uDF99",["point_up_2"],14,7,31,0],

		"1f447":[["\uD83D\uDC47"],"\uE22F","\uDBBA\uDF9A",["point_down"],14,13,31,0],

		"1f448":[["\uD83D\uDC48"],"\uE230","\uDBBA\uDF9B",["point_left"],14,19,31,0],

		"1f449":[["\uD83D\uDC49"],"\uE231","\uDBBA\uDF9C",["point_right"],14,25,31,0],

		"1f44a":[["\uD83D\uDC4A"],"\uE00D","\uDBBA\uDF96",["facepunch","punch"],14,31,31,0],

		"1f44b":[["\uD83D\uDC4B"],"\uE41E","\uDBBA\uDF9D",["wave"],14,37,31,0],

		"1f44c":[["\uD83D\uDC4C"],"\uE420","\uDBBA\uDF9F",["ok_hand"],14,43,31,0],

		"1f44d":[["\uD83D\uDC4D"],"\uE00E","\uDBBA\uDF97",["+1","thumbsup"],14,49,31,0],

		"1f44e":[["\uD83D\uDC4E"],"\uE421","\uDBBA\uDFA0",["-1","thumbsdown"],15,3,31,0],

		"1f44f":[["\uD83D\uDC4F"],"\uE41F","\uDBBA\uDF9E",["clap"],15,9,31,0],

		"1f450":[["\uD83D\uDC50"],"\uE422","\uDBBA\uDFA1",["open_hands"],15,15,31,0],

		"1f451":[["\uD83D\uDC51"],"\uE10E","\uDBB9\uDCD1",["crown"],15,21,31,0],

		"1f452":[["\uD83D\uDC52"],"\uE318","\uDBB9\uDCD4",["womans_hat"],15,22,31,0],

		"1f453":[["\uD83D\uDC53"],"","\uDBB9\uDCCE",["eyeglasses"],15,23,31,0],

		"1f454":[["\uD83D\uDC54"],"\uE302","\uDBB9\uDCD3",["necktie"],15,24,31,0],

		"1f455":[["\uD83D\uDC55"],"\uE006","\uDBB9\uDCCF",["shirt","tshirt"],15,25,31,0],

		"1f456":[["\uD83D\uDC56"],"","\uDBB9\uDCD0",["jeans"],15,26,31,0],

		"1f457":[["\uD83D\uDC57"],"\uE319","\uDBB9\uDCD5",["dress"],15,27,31,0],

		"1f458":[["\uD83D\uDC58"],"\uE321","\uDBB9\uDCD9",["kimono"],15,28,31,0],

		"1f459":[["\uD83D\uDC59"],"\uE322","\uDBB9\uDCDA",["bikini"],15,29,31,0],

		"1f45a":[["\uD83D\uDC5A"],"","\uDBB9\uDCDB",["womans_clothes"],15,30,31,0],

		"1f45b":[["\uD83D\uDC5B"],"","\uDBB9\uDCDC",["purse"],15,31,31,0],

		"1f45c":[["\uD83D\uDC5C"],"\uE323","\uDBB9\uDCF0",["handbag"],15,32,31,0],

		"1f45d":[["\uD83D\uDC5D"],"","\uDBB9\uDCF1",["pouch"],15,33,31,0],

		"1f45e":[["\uD83D\uDC5E"],"","\uDBB9\uDCCC",["mans_shoe","shoe"],15,34,31,0],

		"1f45f":[["\uD83D\uDC5F"],"\uE007","\uDBB9\uDCCD",["athletic_shoe"],15,35,31,0],

		"1f460":[["\uD83D\uDC60"],"\uE13E","\uDBB9\uDCD6",["high_heel"],15,36,31,0],

		"1f461":[["\uD83D\uDC61"],"\uE31A","\uDBB9\uDCD7",["sandal"],15,37,31,0],

		"1f462":[["\uD83D\uDC62"],"\uE31B","\uDBB9\uDCD8",["boot"],15,38,31,0],

		"1f463":[["\uD83D\uDC63"],"\uE536","\uDBB9\uDD53",["footprints"],15,39,31,0],

		"1f464":[["\uD83D\uDC64"],"","\uDBB8\uDD9A",["bust_in_silhouette"],15,40,31,0],

		"1f465":[["\uD83D\uDC65"],"","",["busts_in_silhouette"],15,41,31,0],

		"1f466":[["\uD83D\uDC66"],"\uE001","\uDBB8\uDD9B",["boy"],15,42,31,0],

		"1f467":[["\uD83D\uDC67"],"\uE002","\uDBB8\uDD9C",["girl"],15,48,31,0],

		"1f468-200d-1f33e":[["\uD83D\uDC68\u200D\uD83C\uDF3E"],"","",["male-farmer"],16,2,15,0],

		"1f468-200d-1f373":[["\uD83D\uDC68\u200D\uD83C\uDF73"],"","",["male-cook"],16,8,15,0],

		"1f468-200d-1f393":[["\uD83D\uDC68\u200D\uD83C\uDF93"],"","",["male-student"],16,14,15,0],

		"1f468-200d-1f3a4":[["\uD83D\uDC68\u200D\uD83C\uDFA4"],"","",["male-singer"],16,20,15,0],

		"1f468-200d-1f3a8":[["\uD83D\uDC68\u200D\uD83C\uDFA8"],"","",["male-artist"],16,26,15,0],

		"1f468-200d-1f3eb":[["\uD83D\uDC68\u200D\uD83C\uDFEB"],"","",["male-teacher"],16,32,15,0],

		"1f468-200d-1f3ed":[["\uD83D\uDC68\u200D\uD83C\uDFED"],"","",["male-factory-worker"],16,38,15,0],

		"1f468-200d-1f466-200d-1f466":[["\uD83D\uDC68\u200D\uD83D\uDC66\u200D\uD83D\uDC66"],"","",["man-boy-boy"],16,44,15,0],

		"1f468-200d-1f466":[["\uD83D\uDC68\u200D\uD83D\uDC66"],"","",["man-boy"],16,45,15,0],

		"1f468-200d-1f467-200d-1f466":[["\uD83D\uDC68\u200D\uD83D\uDC67\u200D\uD83D\uDC66"],"","",["man-girl-boy"],16,46,15,0],

		"1f468-200d-1f467-200d-1f467":[["\uD83D\uDC68\u200D\uD83D\uDC67\u200D\uD83D\uDC67"],"","",["man-girl-girl"],16,47,15,0],

		"1f468-200d-1f467":[["\uD83D\uDC68\u200D\uD83D\uDC67"],"","",["man-girl"],16,48,15,0],

		"1f468-200d-1f468-200d-1f466":[["\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC66"],"","",["man-man-boy"],16,49,31,0],

		"1f468-200d-1f468-200d-1f466-200d-1f466":[["\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC66\u200D\uD83D\uDC66"],"","",["man-man-boy-boy"],16,50,31,0],

		"1f468-200d-1f468-200d-1f467":[["\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC67"],"","",["man-man-girl"],16,51,31,0],

		"1f468-200d-1f468-200d-1f467-200d-1f466":[["\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC67\u200D\uD83D\uDC66"],"","",["man-man-girl-boy"],17,0,31,0],

		"1f468-200d-1f468-200d-1f467-200d-1f467":[["\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC67\u200D\uD83D\uDC67"],"","",["man-man-girl-girl"],17,1,31,0],

		"1f468-200d-1f469-200d-1f466":[["\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC66","\uD83D\uDC6A"],"","",["man-woman-boy","family"],17,2,31,0],

		"1f468-200d-1f469-200d-1f466-200d-1f466":[["\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66"],"","",["man-woman-boy-boy"],17,3,31,0],

		"1f468-200d-1f469-200d-1f467":[["\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC67"],"","",["man-woman-girl"],17,4,31,0],

		"1f468-200d-1f469-200d-1f467-200d-1f466":[["\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC66"],"","",["man-woman-girl-boy"],17,5,31,0],

		"1f468-200d-1f469-200d-1f467-200d-1f467":[["\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC67"],"","",["man-woman-girl-girl"],17,6,31,0],

		"1f468-200d-1f4bb":[["\uD83D\uDC68\u200D\uD83D\uDCBB"],"","",["male-technologist"],17,7,15,0],

		"1f468-200d-1f4bc":[["\uD83D\uDC68\u200D\uD83D\uDCBC"],"","",["male-office-worker"],17,13,15,0],

		"1f468-200d-1f527":[["\uD83D\uDC68\u200D\uD83D\uDD27"],"","",["male-mechanic"],17,19,15,0],

		"1f468-200d-1f52c":[["\uD83D\uDC68\u200D\uD83D\uDD2C"],"","",["male-scientist"],17,25,15,0],

		"1f468-200d-1f680":[["\uD83D\uDC68\u200D\uD83D\uDE80"],"","",["male-astronaut"],17,31,15,0],

		"1f468-200d-1f692":[["\uD83D\uDC68\u200D\uD83D\uDE92"],"","",["male-firefighter"],17,37,15,0],

		"1f468-200d-2695-fe0f":[["\uD83D\uDC68\u200D\u2695\uFE0F","\uD83D\uDC68\u200D\u2695"],"","",["male-doctor"],17,43,15,0],

		"1f468-200d-2696-fe0f":[["\uD83D\uDC68\u200D\u2696\uFE0F","\uD83D\uDC68\u200D\u2696"],"","",["male-judge"],17,49,15,0],

		"1f468-200d-2708-fe0f":[["\uD83D\uDC68\u200D\u2708\uFE0F","\uD83D\uDC68\u200D\u2708"],"","",["male-pilot"],18,3,15,0],

		"1f468-200d-2764-fe0f-200d-1f468":[["\uD83D\uDC68\u200D\u2764\uFE0F\u200D\uD83D\uDC68","\uD83D\uDC68\u200D\u2764\u200D\uD83D\uDC68"],"","",["man-heart-man"],18,9,31,0],

		"1f468-200d-2764-fe0f-200d-1f48b-200d-1f468":[["\uD83D\uDC68\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68","\uD83D\uDC68\u200D\u2764\u200D\uD83D\uDC8B\u200D\uD83D\uDC68"],"","",["man-kiss-man"],18,10,31,0],

		"1f468":[["\uD83D\uDC68"],"\uE004","\uDBB8\uDD9D",["man"],18,11,31,0],

		"1f469-200d-1f33e":[["\uD83D\uDC69\u200D\uD83C\uDF3E"],"","",["female-farmer"],18,17,15,0],

		"1f469-200d-1f373":[["\uD83D\uDC69\u200D\uD83C\uDF73"],"","",["female-cook"],18,23,15,0],

		"1f469-200d-1f393":[["\uD83D\uDC69\u200D\uD83C\uDF93"],"","",["female-student"],18,29,15,0],

		"1f469-200d-1f3a4":[["\uD83D\uDC69\u200D\uD83C\uDFA4"],"","",["female-singer"],18,35,15,0],

		"1f469-200d-1f3a8":[["\uD83D\uDC69\u200D\uD83C\uDFA8"],"","",["female-artist"],18,41,15,0],

		"1f469-200d-1f3eb":[["\uD83D\uDC69\u200D\uD83C\uDFEB"],"","",["female-teacher"],18,47,15,0],

		"1f469-200d-1f3ed":[["\uD83D\uDC69\u200D\uD83C\uDFED"],"","",["female-factory-worker"],19,1,15,0],

		"1f469-200d-1f466-200d-1f466":[["\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66"],"","",["woman-boy-boy"],19,7,15,0],

		"1f469-200d-1f466":[["\uD83D\uDC69\u200D\uD83D\uDC66"],"","",["woman-boy"],19,8,15,0],

		"1f469-200d-1f467-200d-1f466":[["\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC66"],"","",["woman-girl-boy"],19,9,15,0],

		"1f469-200d-1f467-200d-1f467":[["\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC67"],"","",["woman-girl-girl"],19,10,15,0],

		"1f469-200d-1f467":[["\uD83D\uDC69\u200D\uD83D\uDC67"],"","",["woman-girl"],19,11,15,0],

		"1f469-200d-1f469-200d-1f466":[["\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC66"],"","",["woman-woman-boy"],19,12,31,0],

		"1f469-200d-1f469-200d-1f466-200d-1f466":[["\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66"],"","",["woman-woman-boy-boy"],19,13,31,0],

		"1f469-200d-1f469-200d-1f467":[["\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC67"],"","",["woman-woman-girl"],19,14,31,0],

		"1f469-200d-1f469-200d-1f467-200d-1f466":[["\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC66"],"","",["woman-woman-girl-boy"],19,15,31,0],

		"1f469-200d-1f469-200d-1f467-200d-1f467":[["\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC67"],"","",["woman-woman-girl-girl"],19,16,31,0],

		"1f469-200d-1f4bb":[["\uD83D\uDC69\u200D\uD83D\uDCBB"],"","",["female-technologist"],19,17,15,0],

		"1f469-200d-1f4bc":[["\uD83D\uDC69\u200D\uD83D\uDCBC"],"","",["female-office-worker"],19,23,15,0],

		"1f469-200d-1f527":[["\uD83D\uDC69\u200D\uD83D\uDD27"],"","",["female-mechanic"],19,29,15,0],

		"1f469-200d-1f52c":[["\uD83D\uDC69\u200D\uD83D\uDD2C"],"","",["female-scientist"],19,35,15,0],

		"1f469-200d-1f680":[["\uD83D\uDC69\u200D\uD83D\uDE80"],"","",["female-astronaut"],19,41,15,0],

		"1f469-200d-1f692":[["\uD83D\uDC69\u200D\uD83D\uDE92"],"","",["female-firefighter"],19,47,15,0],

		"1f469-200d-2695-fe0f":[["\uD83D\uDC69\u200D\u2695\uFE0F","\uD83D\uDC69\u200D\u2695"],"","",["female-doctor"],20,1,15,0],

		"1f469-200d-2696-fe0f":[["\uD83D\uDC69\u200D\u2696\uFE0F","\uD83D\uDC69\u200D\u2696"],"","",["female-judge"],20,7,15,0],

		"1f469-200d-2708-fe0f":[["\uD83D\uDC69\u200D\u2708\uFE0F","\uD83D\uDC69\u200D\u2708"],"","",["female-pilot"],20,13,15,0],

		"1f469-200d-2764-fe0f-200d-1f468":[["\uD83D\uDC69\u200D\u2764\uFE0F\u200D\uD83D\uDC68","\uD83D\uDC69\u200D\u2764\u200D\uD83D\uDC68","\uD83D\uDC91"],"","",["woman-heart-man","couple_with_heart"],20,19,15,0],

		"1f469-200d-2764-fe0f-200d-1f469":[["\uD83D\uDC69\u200D\u2764\uFE0F\u200D\uD83D\uDC69","\uD83D\uDC69\u200D\u2764\u200D\uD83D\uDC69"],"","",["woman-heart-woman"],20,20,31,0],

		"1f469-200d-2764-fe0f-200d-1f48b-200d-1f468":[["\uD83D\uDC69\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68","\uD83D\uDC69\u200D\u2764\u200D\uD83D\uDC8B\u200D\uD83D\uDC68","\uD83D\uDC8F"],"","",["woman-kiss-man","couplekiss"],20,21,15,0],

		"1f469-200d-2764-fe0f-200d-1f48b-200d-1f469":[["\uD83D\uDC69\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69","\uD83D\uDC69\u200D\u2764\u200D\uD83D\uDC8B\u200D\uD83D\uDC69"],"","",["woman-kiss-woman"],20,22,31,0],

		"1f469":[["\uD83D\uDC69"],"\uE005","\uDBB8\uDD9E",["woman"],20,23,31,0],

		"1f46b":[["\uD83D\uDC6B"],"\uE428","\uDBB8\uDDA0",["couple","man_and_woman_holding_hands"],20,30,31,0],

		"1f46c":[["\uD83D\uDC6C"],"","",["two_men_holding_hands"],20,31,31,0],

		"1f46d":[["\uD83D\uDC6D"],"","",["two_women_holding_hands"],20,32,31,0],

		"1f46e-200d-2640-fe0f":[["\uD83D\uDC6E\u200D\u2640\uFE0F","\uD83D\uDC6E\u200D\u2640"],"","",["female-police-officer"],20,33,15,0],

		"1f46e-200d-2642-fe0f":[["\uD83D\uDC6E\u200D\u2642\uFE0F","\uD83D\uDC6E\u200D\u2642","\uD83D\uDC6E"],"","",["male-police-officer","cop"],20,39,15,0],

		"1f46f-200d-2640-fe0f":[["\uD83D\uDC6F\u200D\u2640\uFE0F","\uD83D\uDC6F\u200D\u2640","\uD83D\uDC6F"],"","",["woman-with-bunny-ears-partying","dancers"],20,51,15,0],

		"1f46f-200d-2642-fe0f":[["\uD83D\uDC6F\u200D\u2642\uFE0F","\uD83D\uDC6F\u200D\u2642"],"","",["man-with-bunny-ears-partying"],21,0,15,0],

		"1f470":[["\uD83D\uDC70"],"","\uDBB8\uDDA3",["bride_with_veil"],21,2,31,0],

		"1f471-200d-2640-fe0f":[["\uD83D\uDC71\u200D\u2640\uFE0F","\uD83D\uDC71\u200D\u2640"],"","",["blond-haired-woman"],21,8,15,0],

		"1f471-200d-2642-fe0f":[["\uD83D\uDC71\u200D\u2642\uFE0F","\uD83D\uDC71\u200D\u2642","\uD83D\uDC71"],"","",["blond-haired-man","person_with_blond_hair"],21,14,15,0],

		"1f472":[["\uD83D\uDC72"],"\uE516","\uDBB8\uDDA5",["man_with_gua_pi_mao"],21,26,31,0],

		"1f473-200d-2640-fe0f":[["\uD83D\uDC73\u200D\u2640\uFE0F","\uD83D\uDC73\u200D\u2640"],"","",["woman-wearing-turban"],21,32,15,0],

		"1f473-200d-2642-fe0f":[["\uD83D\uDC73\u200D\u2642\uFE0F","\uD83D\uDC73\u200D\u2642","\uD83D\uDC73"],"","",["man-wearing-turban","man_with_turban"],21,38,15,0],

		"1f474":[["\uD83D\uDC74"],"\uE518","\uDBB8\uDDA7",["older_man"],21,50,31,0],

		"1f475":[["\uD83D\uDC75"],"\uE519","\uDBB8\uDDA8",["older_woman"],22,4,31,0],

		"1f476":[["\uD83D\uDC76"],"\uE51A","\uDBB8\uDDA9",["baby"],22,10,31,0],

		"1f477-200d-2640-fe0f":[["\uD83D\uDC77\u200D\u2640\uFE0F","\uD83D\uDC77\u200D\u2640"],"","",["female-construction-worker"],22,16,15,0],

		"1f477-200d-2642-fe0f":[["\uD83D\uDC77\u200D\u2642\uFE0F","\uD83D\uDC77\u200D\u2642","\uD83D\uDC77"],"","",["male-construction-worker","construction_worker"],22,22,15,0],

		"1f478":[["\uD83D\uDC78"],"\uE51C","\uDBB8\uDDAB",["princess"],22,34,31,0],

		"1f479":[["\uD83D\uDC79"],"","\uDBB8\uDDAC",["japanese_ogre"],22,40,31,0],

		"1f47a":[["\uD83D\uDC7A"],"","\uDBB8\uDDAD",["japanese_goblin"],22,41,31,0],

		"1f47b":[["\uD83D\uDC7B"],"\uE11B","\uDBB8\uDDAE",["ghost"],22,42,31,0],

		"1f47c":[["\uD83D\uDC7C"],"\uE04E","\uDBB8\uDDAF",["angel"],22,43,31,0],

		"1f47d":[["\uD83D\uDC7D"],"\uE10C","\uDBB8\uDDB0",["alien"],22,49,31,0],

		"1f47e":[["\uD83D\uDC7E"],"\uE12B","\uDBB8\uDDB1",["space_invader"],22,50,31,0],

		"1f47f":[["\uD83D\uDC7F"],"\uE11A","\uDBB8\uDDB2",["imp"],22,51,31,0],

		"1f480":[["\uD83D\uDC80"],"\uE11C","\uDBB8\uDDB3",["skull"],23,0,31,0],

		"1f481-200d-2640-fe0f":[["\uD83D\uDC81\u200D\u2640\uFE0F","\uD83D\uDC81\u200D\u2640","\uD83D\uDC81"],"","",["woman-tipping-hand","information_desk_person"],23,1,15,0],

		"1f481-200d-2642-fe0f":[["\uD83D\uDC81\u200D\u2642\uFE0F","\uD83D\uDC81\u200D\u2642"],"","",["man-tipping-hand"],23,7,15,0],

		"1f482-200d-2640-fe0f":[["\uD83D\uDC82\u200D\u2640\uFE0F","\uD83D\uDC82\u200D\u2640"],"","",["female-guard"],23,19,15,0],

		"1f482-200d-2642-fe0f":[["\uD83D\uDC82\u200D\u2642\uFE0F","\uD83D\uDC82\u200D\u2642","\uD83D\uDC82"],"","",["male-guard","guardsman"],23,25,15,0],

		"1f483":[["\uD83D\uDC83"],"\uE51F","\uDBB8\uDDB6",["dancer"],23,37,31,0],

		"1f484":[["\uD83D\uDC84"],"\uE31C","\uDBB8\uDD95",["lipstick"],23,43,31,0],

		"1f485":[["\uD83D\uDC85"],"\uE31D","\uDBB8\uDD96",["nail_care"],23,44,31,0],

		"1f486-200d-2640-fe0f":[["\uD83D\uDC86\u200D\u2640\uFE0F","\uD83D\uDC86\u200D\u2640","\uD83D\uDC86"],"","",["woman-getting-massage","massage"],23,50,15,0],

		"1f486-200d-2642-fe0f":[["\uD83D\uDC86\u200D\u2642\uFE0F","\uD83D\uDC86\u200D\u2642"],"","",["man-getting-massage"],24,4,15,0],

		"1f487-200d-2640-fe0f":[["\uD83D\uDC87\u200D\u2640\uFE0F","\uD83D\uDC87\u200D\u2640","\uD83D\uDC87"],"","",["woman-getting-haircut","haircut"],24,16,15,0],

		"1f487-200d-2642-fe0f":[["\uD83D\uDC87\u200D\u2642\uFE0F","\uD83D\uDC87\u200D\u2642"],"","",["man-getting-haircut"],24,22,15,0],

		"1f488":[["\uD83D\uDC88"],"\uE320","\uDBB8\uDD99",["barber"],24,34,31,0],

		"1f489":[["\uD83D\uDC89"],"\uE13B","\uDBB9\uDD09",["syringe"],24,35,31,0],

		"1f48a":[["\uD83D\uDC8A"],"\uE30F","\uDBB9\uDD0A",["pill"],24,36,31,0],

		"1f48b":[["\uD83D\uDC8B"],"\uE003","\uDBBA\uDC23",["kiss"],24,37,31,0],

		"1f48c":[["\uD83D\uDC8C"],"","\uDBBA\uDC24",["love_letter"],24,38,31,0],

		"1f48d":[["\uD83D\uDC8D"],"\uE034","\uDBBA\uDC25",["ring"],24,39,31,0],

		"1f48e":[["\uD83D\uDC8E"],"\uE035","\uDBBA\uDC26",["gem"],24,40,31,0],

		"1f490":[["\uD83D\uDC90"],"\uE306","\uDBBA\uDC28",["bouquet"],24,42,31,0],

		"1f492":[["\uD83D\uDC92"],"\uE43D","\uDBBA\uDC2A",["wedding"],24,44,31,0],

		"1f493":[["\uD83D\uDC93"],"\uE327","\uDBBA\uDF0D",["heartbeat"],24,45,31,0],

		"1f494":[["\uD83D\uDC94"],"\uE023","\uDBBA\uDF0E",["broken_heart"],24,46,31,0,"<\/3"],

		"1f495":[["\uD83D\uDC95"],"","\uDBBA\uDF0F",["two_hearts"],24,47,31,0],

		"1f496":[["\uD83D\uDC96"],"","\uDBBA\uDF10",["sparkling_heart"],24,48,31,0],

		"1f497":[["\uD83D\uDC97"],"\uE328","\uDBBA\uDF11",["heartpulse"],24,49,31,0],

		"1f498":[["\uD83D\uDC98"],"\uE329","\uDBBA\uDF12",["cupid"],24,50,31,0],

		"1f499":[["\uD83D\uDC99"],"\uE32A","\uDBBA\uDF13",["blue_heart"],24,51,31,0,"<3"],

		"1f49a":[["\uD83D\uDC9A"],"\uE32B","\uDBBA\uDF14",["green_heart"],25,0,31,0,"<3"],

		"1f49b":[["\uD83D\uDC9B"],"\uE32C","\uDBBA\uDF15",["yellow_heart"],25,1,31,0,"<3"],

		"1f49c":[["\uD83D\uDC9C"],"\uE32D","\uDBBA\uDF16",["purple_heart"],25,2,31,0,"<3"],

		"1f49d":[["\uD83D\uDC9D"],"\uE437","\uDBBA\uDF17",["gift_heart"],25,3,31,0],

		"1f49e":[["\uD83D\uDC9E"],"","\uDBBA\uDF18",["revolving_hearts"],25,4,31,0],

		"1f49f":[["\uD83D\uDC9F"],"\uE204","\uDBBA\uDF19",["heart_decoration"],25,5,31,0],

		"1f4a0":[["\uD83D\uDCA0"],"","\uDBBA\uDF55",["diamond_shape_with_a_dot_inside"],25,6,31,0],

		"1f4a1":[["\uD83D\uDCA1"],"\uE10F","\uDBBA\uDF56",["bulb"],25,7,31,0],

		"1f4a2":[["\uD83D\uDCA2"],"\uE334","\uDBBA\uDF57",["anger"],25,8,31,0],

		"1f4a3":[["\uD83D\uDCA3"],"\uE311","\uDBBA\uDF58",["bomb"],25,9,31,0],

		"1f4a4":[["\uD83D\uDCA4"],"\uE13C","\uDBBA\uDF59",["zzz"],25,10,31,0],

		"1f4a5":[["\uD83D\uDCA5"],"","\uDBBA\uDF5A",["boom","collision"],25,11,31,0],

		"1f4a6":[["\uD83D\uDCA6"],"\uE331","\uDBBA\uDF5B",["sweat_drops"],25,12,31,0],

		"1f4a7":[["\uD83D\uDCA7"],"","\uDBBA\uDF5C",["droplet"],25,13,31,0],

		"1f4a8":[["\uD83D\uDCA8"],"\uE330","\uDBBA\uDF5D",["dash"],25,14,31,0],

		"1f4a9":[["\uD83D\uDCA9"],"\uE05A","\uDBB9\uDCF4",["hankey","poop","shit"],25,15,31,0],

		"1f4aa":[["\uD83D\uDCAA"],"\uE14C","\uDBBA\uDF5E",["muscle"],25,16,31,0],

		"1f4ab":[["\uD83D\uDCAB"],"","\uDBBA\uDF5F",["dizzy"],25,22,31,0],

		"1f4ac":[["\uD83D\uDCAC"],"","\uDBB9\uDD32",["speech_balloon"],25,23,31,0],

		"1f4ad":[["\uD83D\uDCAD"],"","",["thought_balloon"],25,24,31,0],

		"1f4ae":[["\uD83D\uDCAE"],"","\uDBBA\uDF7A",["white_flower"],25,25,31,0],

		"1f4af":[["\uD83D\uDCAF"],"","\uDBBA\uDF7B",["100"],25,26,31,0],

		"1f4b0":[["\uD83D\uDCB0"],"\uE12F","\uDBB9\uDCDD",["moneybag"],25,27,31,0],

		"1f4b1":[["\uD83D\uDCB1"],"\uE149","\uDBB9\uDCDE",["currency_exchange"],25,28,31,0],

		"1f4b2":[["\uD83D\uDCB2"],"","\uDBB9\uDCE0",["heavy_dollar_sign"],25,29,31,0],

		"1f4b3":[["\uD83D\uDCB3"],"","\uDBB9\uDCE1",["credit_card"],25,30,31,0],

		"1f4b4":[["\uD83D\uDCB4"],"","\uDBB9\uDCE2",["yen"],25,31,31,0],

		"1f4b5":[["\uD83D\uDCB5"],"","\uDBB9\uDCE3",["dollar"],25,32,31,0],

		"1f4b6":[["\uD83D\uDCB6"],"","",["euro"],25,33,31,0],

		"1f4b7":[["\uD83D\uDCB7"],"","",["pound"],25,34,31,0],

		"1f4b8":[["\uD83D\uDCB8"],"","\uDBB9\uDCE4",["money_with_wings"],25,35,31,0],

		"1f4b9":[["\uD83D\uDCB9"],"\uE14A","\uDBB9\uDCDF",["chart"],25,36,31,0],

		"1f4ba":[["\uD83D\uDCBA"],"\uE11F","\uDBB9\uDD37",["seat"],25,37,31,0],

		"1f4bb":[["\uD83D\uDCBB"],"\uE00C","\uDBB9\uDD38",["computer"],25,38,31,0],

		"1f4bc":[["\uD83D\uDCBC"],"\uE11E","\uDBB9\uDD3B",["briefcase"],25,39,31,0],

		"1f4bd":[["\uD83D\uDCBD"],"\uE316","\uDBB9\uDD3C",["minidisc"],25,40,31,0],

		"1f4be":[["\uD83D\uDCBE"],"","\uDBB9\uDD3D",["floppy_disk"],25,41,31,0],

		"1f4bf":[["\uD83D\uDCBF"],"\uE126","\uDBBA\uDC1D",["cd"],25,42,31,0],

		"1f4c0":[["\uD83D\uDCC0"],"\uE127","\uDBBA\uDC1E",["dvd"],25,43,31,0],

		"1f4c1":[["\uD83D\uDCC1"],"","\uDBB9\uDD43",["file_folder"],25,44,31,0],

		"1f4c2":[["\uD83D\uDCC2"],"","\uDBB9\uDD44",["open_file_folder"],25,45,31,0],

		"1f4c3":[["\uD83D\uDCC3"],"","\uDBB9\uDD40",["page_with_curl"],25,46,31,0],

		"1f4c4":[["\uD83D\uDCC4"],"","\uDBB9\uDD41",["page_facing_up"],25,47,31,0],

		"1f4c5":[["\uD83D\uDCC5"],"","\uDBB9\uDD42",["date"],25,48,31,0],

		"1f4c6":[["\uD83D\uDCC6"],"","\uDBB9\uDD49",["calendar"],25,49,31,0],

		"1f4c7":[["\uD83D\uDCC7"],"","\uDBB9\uDD4D",["card_index"],25,50,31,0],

		"1f4c8":[["\uD83D\uDCC8"],"","\uDBB9\uDD4B",["chart_with_upwards_trend"],25,51,31,0],

		"1f4c9":[["\uD83D\uDCC9"],"","\uDBB9\uDD4C",["chart_with_downwards_trend"],26,0,31,0],

		"1f4ca":[["\uD83D\uDCCA"],"","\uDBB9\uDD4A",["bar_chart"],26,1,31,0],

		"1f4cb":[["\uD83D\uDCCB"],"","\uDBB9\uDD48",["clipboard"],26,2,31,0],

		"1f4cc":[["\uD83D\uDCCC"],"","\uDBB9\uDD4E",["pushpin"],26,3,31,0],

		"1f4cd":[["\uD83D\uDCCD"],"","\uDBB9\uDD3F",["round_pushpin"],26,4,31,0],

		"1f4ce":[["\uD83D\uDCCE"],"","\uDBB9\uDD3A",["paperclip"],26,5,31,0],

		"1f4cf":[["\uD83D\uDCCF"],"","\uDBB9\uDD50",["straight_ruler"],26,6,31,0],

		"1f4d0":[["\uD83D\uDCD0"],"","\uDBB9\uDD51",["triangular_ruler"],26,7,31,0],

		"1f4d1":[["\uD83D\uDCD1"],"","\uDBB9\uDD52",["bookmark_tabs"],26,8,31,0],

		"1f4d2":[["\uD83D\uDCD2"],"","\uDBB9\uDD4F",["ledger"],26,9,31,0],

		"1f4d3":[["\uD83D\uDCD3"],"","\uDBB9\uDD45",["notebook"],26,10,31,0],

		"1f4d4":[["\uD83D\uDCD4"],"","\uDBB9\uDD47",["notebook_with_decorative_cover"],26,11,31,0],

		"1f4d5":[["\uD83D\uDCD5"],"","\uDBB9\uDD02",["closed_book"],26,12,31,0],

		"1f4d6":[["\uD83D\uDCD6"],"\uE148","\uDBB9\uDD46",["book","open_book"],26,13,31,0],

		"1f4d7":[["\uD83D\uDCD7"],"","\uDBB9\uDCFF",["green_book"],26,14,31,0],

		"1f4d8":[["\uD83D\uDCD8"],"","\uDBB9\uDD00",["blue_book"],26,15,31,0],

		"1f4d9":[["\uD83D\uDCD9"],"","\uDBB9\uDD01",["orange_book"],26,16,31,0],

		"1f4da":[["\uD83D\uDCDA"],"","\uDBB9\uDD03",["books"],26,17,31,0],

		"1f4db":[["\uD83D\uDCDB"],"","\uDBB9\uDD04",["name_badge"],26,18,31,0],

		"1f4dc":[["\uD83D\uDCDC"],"","\uDBB9\uDCFD",["scroll"],26,19,31,0],

		"1f4dd":[["\uD83D\uDCDD"],"\uE301","\uDBB9\uDD27",["memo","pencil"],26,20,31,0],

		"1f4de":[["\uD83D\uDCDE"],"","\uDBB9\uDD24",["telephone_receiver"],26,21,31,0],

		"1f4df":[["\uD83D\uDCDF"],"","\uDBB9\uDD22",["pager"],26,22,31,0],

		"1f4e0":[["\uD83D\uDCE0"],"\uE00B","\uDBB9\uDD28",["fax"],26,23,31,0],

		"1f4e1":[["\uD83D\uDCE1"],"\uE14B","\uDBB9\uDD31",["satellite_antenna"],26,24,31,0],

		"1f4e2":[["\uD83D\uDCE2"],"\uE142","\uDBB9\uDD2F",["loudspeaker"],26,25,31,0],

		"1f4e3":[["\uD83D\uDCE3"],"\uE317","\uDBB9\uDD30",["mega"],26,26,31,0],

		"1f4e4":[["\uD83D\uDCE4"],"","\uDBB9\uDD33",["outbox_tray"],26,27,31,0],

		"1f4e5":[["\uD83D\uDCE5"],"","\uDBB9\uDD34",["inbox_tray"],26,28,31,0],

		"1f4e6":[["\uD83D\uDCE6"],"","\uDBB9\uDD35",["package"],26,29,31,0],

		"1f4e7":[["\uD83D\uDCE7"],"","\uDBBA\uDF92",["e-mail"],26,30,31,0],

		"1f4e8":[["\uD83D\uDCE8"],"","\uDBB9\uDD2A",["incoming_envelope"],26,31,31,0],

		"1f4e9":[["\uD83D\uDCE9"],"\uE103","\uDBB9\uDD2B",["envelope_with_arrow"],26,32,31,0],

		"1f4ea":[["\uD83D\uDCEA"],"","\uDBB9\uDD2C",["mailbox_closed"],26,33,31,0],

		"1f4eb":[["\uD83D\uDCEB"],"\uE101","\uDBB9\uDD2D",["mailbox"],26,34,31,0],

		"1f4ec":[["\uD83D\uDCEC"],"","",["mailbox_with_mail"],26,35,31,0],

		"1f4ed":[["\uD83D\uDCED"],"","",["mailbox_with_no_mail"],26,36,31,0],

		"1f4ee":[["\uD83D\uDCEE"],"\uE102","\uDBB9\uDD2E",["postbox"],26,37,31,0],

		"1f4ef":[["\uD83D\uDCEF"],"","",["postal_horn"],26,38,31,0],

		"1f4f0":[["\uD83D\uDCF0"],"","\uDBBA\uDC22",["newspaper"],26,39,31,0],

		"1f4f1":[["\uD83D\uDCF1"],"\uE00A","\uDBB9\uDD25",["iphone"],26,40,31,0],

		"1f4f2":[["\uD83D\uDCF2"],"\uE104","\uDBB9\uDD26",["calling"],26,41,31,0],

		"1f4f3":[["\uD83D\uDCF3"],"\uE250","\uDBBA\uDC39",["vibration_mode"],26,42,31,0],

		"1f4f4":[["\uD83D\uDCF4"],"\uE251","\uDBBA\uDC3A",["mobile_phone_off"],26,43,31,0],

		"1f4f5":[["\uD83D\uDCF5"],"","",["no_mobile_phones"],26,44,31,0],

		"1f4f6":[["\uD83D\uDCF6"],"\uE20B","\uDBBA\uDC38",["signal_strength"],26,45,31,0],

		"1f4f7":[["\uD83D\uDCF7"],"\uE008","\uDBB9\uDCEF",["camera"],26,46,31,0],

		"1f4f8":[["\uD83D\uDCF8"],"","",["camera_with_flash"],26,47,15,0],

		"1f4f9":[["\uD83D\uDCF9"],"","\uDBB9\uDCF9",["video_camera"],26,48,31,0],

		"1f4fa":[["\uD83D\uDCFA"],"\uE12A","\uDBBA\uDC1C",["tv"],26,49,31,0],

		"1f4fb":[["\uD83D\uDCFB"],"\uE128","\uDBBA\uDC1F",["radio"],26,50,31,0],

		"1f4fc":[["\uD83D\uDCFC"],"\uE129","\uDBBA\uDC20",["vhs"],26,51,31,0],

		"1f4fd-fe0f":[["\uD83D\uDCFD\uFE0F","\uD83D\uDCFD"],"","",["film_projector"],27,0,15,0],

		"1f4ff":[["\uD83D\uDCFF"],"","",["prayer_beads"],27,1,15,0],

		"1f500":[["\uD83D\uDD00"],"","",["twisted_rightwards_arrows"],27,2,31,0],

		"1f501":[["\uD83D\uDD01"],"","",["repeat"],27,3,31,0],

		"1f502":[["\uD83D\uDD02"],"","",["repeat_one"],27,4,31,0],

		"1f503":[["\uD83D\uDD03"],"","\uDBBA\uDF91",["arrows_clockwise"],27,5,31,0],

		"1f504":[["\uD83D\uDD04"],"","",["arrows_counterclockwise"],27,6,31,0],

		"1f505":[["\uD83D\uDD05"],"","",["low_brightness"],27,7,31,0],

		"1f506":[["\uD83D\uDD06"],"","",["high_brightness"],27,8,31,0],

		"1f507":[["\uD83D\uDD07"],"","",["mute"],27,9,31,0],

		"1f508":[["\uD83D\uDD08"],"","",["speaker"],27,10,31,0],

		"1f509":[["\uD83D\uDD09"],"","",["sound"],27,11,31,0],

		"1f50a":[["\uD83D\uDD0A"],"\uE141","\uDBBA\uDC21",["loud_sound"],27,12,31,0],

		"1f50b":[["\uD83D\uDD0B"],"","\uDBB9\uDCFC",["battery"],27,13,31,0],

		"1f50c":[["\uD83D\uDD0C"],"","\uDBB9\uDCFE",["electric_plug"],27,14,31,0],

		"1f50d":[["\uD83D\uDD0D"],"\uE114","\uDBBA\uDF85",["mag"],27,15,31,0],

		"1f50e":[["\uD83D\uDD0E"],"","\uDBBA\uDF8D",["mag_right"],27,16,31,0],

		"1f50f":[["\uD83D\uDD0F"],"","\uDBBA\uDF90",["lock_with_ink_pen"],27,17,31,0],

		"1f510":[["\uD83D\uDD10"],"","\uDBBA\uDF8A",["closed_lock_with_key"],27,18,31,0],

		"1f511":[["\uD83D\uDD11"],"\uE03F","\uDBBA\uDF82",["key"],27,19,31,0],

		"1f512":[["\uD83D\uDD12"],"\uE144","\uDBBA\uDF86",["lock"],27,20,31,0],

		"1f513":[["\uD83D\uDD13"],"\uE145","\uDBBA\uDF87",["unlock"],27,21,31,0],

		"1f514":[["\uD83D\uDD14"],"\uE325","\uDBB9\uDCF2",["bell"],27,22,31,0],

		"1f515":[["\uD83D\uDD15"],"","",["no_bell"],27,23,31,0],

		"1f516":[["\uD83D\uDD16"],"","\uDBBA\uDF8F",["bookmark"],27,24,31,0],

		"1f517":[["\uD83D\uDD17"],"","\uDBBA\uDF4B",["link"],27,25,31,0],

		"1f518":[["\uD83D\uDD18"],"","\uDBBA\uDF8C",["radio_button"],27,26,31,0],

		"1f519":[["\uD83D\uDD19"],"","\uDBBA\uDF8E",["back"],27,27,31,0],

		"1f51a":[["\uD83D\uDD1A"],"","\uDBB8\uDC1A",["end"],27,28,31,0],

		"1f51b":[["\uD83D\uDD1B"],"","\uDBB8\uDC19",["on"],27,29,31,0],

		"1f51c":[["\uD83D\uDD1C"],"","\uDBB8\uDC18",["soon"],27,30,31,0],

		"1f51d":[["\uD83D\uDD1D"],"\uE24C","\uDBBA\uDF42",["top"],27,31,31,0],

		"1f51e":[["\uD83D\uDD1E"],"\uE207","\uDBBA\uDF25",["underage"],27,32,31,0],

		"1f51f":[["\uD83D\uDD1F"],"","\uDBBA\uDC3B",["keycap_ten"],27,33,31,0],

		"1f520":[["\uD83D\uDD20"],"","\uDBBA\uDF7C",["capital_abcd"],27,34,31,0],

		"1f521":[["\uD83D\uDD21"],"","\uDBBA\uDF7D",["abcd"],27,35,31,0],

		"1f522":[["\uD83D\uDD22"],"","\uDBBA\uDF7E",["1234"],27,36,31,0],

		"1f523":[["\uD83D\uDD23"],"","\uDBBA\uDF7F",["symbols"],27,37,31,0],

		"1f524":[["\uD83D\uDD24"],"","\uDBBA\uDF80",["abc"],27,38,31,0],

		"1f525":[["\uD83D\uDD25"],"\uE11D","\uDBB9\uDCF6",["fire"],27,39,31,0],

		"1f526":[["\uD83D\uDD26"],"","\uDBB9\uDCFB",["flashlight"],27,40,31,0],

		"1f527":[["\uD83D\uDD27"],"","\uDBB9\uDCC9",["wrench"],27,41,31,0],

		"1f528":[["\uD83D\uDD28"],"\uE116","\uDBB9\uDCCA",["hammer"],27,42,31,0],

		"1f529":[["\uD83D\uDD29"],"","\uDBB9\uDCCB",["nut_and_bolt"],27,43,31,0],

		"1f52a":[["\uD83D\uDD2A"],"","\uDBB9\uDCFA",["hocho","knife"],27,44,31,0],

		"1f52b":[["\uD83D\uDD2B"],"\uE113","\uDBB9\uDCF5",["gun"],27,45,31,0],

		"1f52c":[["\uD83D\uDD2C"],"","",["microscope"],27,46,31,0],

		"1f52d":[["\uD83D\uDD2D"],"","",["telescope"],27,47,31,0],

		"1f52e":[["\uD83D\uDD2E"],"","\uDBB9\uDCF7",["crystal_ball"],27,48,31,0],

		"1f52f":[["\uD83D\uDD2F"],"\uE23E","\uDBB9\uDCF8",["six_pointed_star"],27,49,31,0],

		"1f530":[["\uD83D\uDD30"],"\uE209","\uDBB8\uDC44",["beginner"],27,50,31,0],

		"1f531":[["\uD83D\uDD31"],"\uE031","\uDBB9\uDCD2",["trident"],27,51,31,0],

		"1f532":[["\uD83D\uDD32"],"\uE21A","\uDBBA\uDF64",["black_square_button"],28,0,31,0],

		"1f533":[["\uD83D\uDD33"],"\uE21B","\uDBBA\uDF67",["white_square_button"],28,1,31,0],

		"1f534":[["\uD83D\uDD34"],"\uE219","\uDBBA\uDF63",["red_circle"],28,2,31,0],

		"1f535":[["\uD83D\uDD35"],"","\uDBBA\uDF64",["large_blue_circle"],28,3,31,0],

		"1f536":[["\uD83D\uDD36"],"","\uDBBA\uDF73",["large_orange_diamond"],28,4,31,0],

		"1f537":[["\uD83D\uDD37"],"","\uDBBA\uDF74",["large_blue_diamond"],28,5,31,0],

		"1f538":[["\uD83D\uDD38"],"","\uDBBA\uDF75",["small_orange_diamond"],28,6,31,0],

		"1f539":[["\uD83D\uDD39"],"","\uDBBA\uDF76",["small_blue_diamond"],28,7,31,0],

		"1f53a":[["\uD83D\uDD3A"],"","\uDBBA\uDF78",["small_red_triangle"],28,8,31,0],

		"1f53b":[["\uD83D\uDD3B"],"","\uDBBA\uDF79",["small_red_triangle_down"],28,9,31,0],

		"1f53c":[["\uD83D\uDD3C"],"","\uDBBA\uDF01",["arrow_up_small"],28,10,31,0],

		"1f53d":[["\uD83D\uDD3D"],"","\uDBBA\uDF00",["arrow_down_small"],28,11,31,0],

		"1f549-fe0f":[["\uD83D\uDD49\uFE0F","\uD83D\uDD49"],"","",["om_symbol"],28,12,15,0],

		"1f54a-fe0f":[["\uD83D\uDD4A\uFE0F","\uD83D\uDD4A"],"","",["dove_of_peace"],28,13,15,0],

		"1f54b":[["\uD83D\uDD4B"],"","",["kaaba"],28,14,15,0],

		"1f54c":[["\uD83D\uDD4C"],"","",["mosque"],28,15,15,0],

		"1f54d":[["\uD83D\uDD4D"],"","",["synagogue"],28,16,15,0],

		"1f54e":[["\uD83D\uDD4E"],"","",["menorah_with_nine_branches"],28,17,15,0],

		"1f550":[["\uD83D\uDD50"],"\uE024","\uDBB8\uDC1E",["clock1"],28,18,31,0],

		"1f551":[["\uD83D\uDD51"],"\uE025","\uDBB8\uDC1F",["clock2"],28,19,31,0],

		"1f552":[["\uD83D\uDD52"],"\uE026","\uDBB8\uDC20",["clock3"],28,20,31,0],

		"1f553":[["\uD83D\uDD53"],"\uE027","\uDBB8\uDC21",["clock4"],28,21,31,0],

		"1f554":[["\uD83D\uDD54"],"\uE028","\uDBB8\uDC22",["clock5"],28,22,31,0],

		"1f555":[["\uD83D\uDD55"],"\uE029","\uDBB8\uDC23",["clock6"],28,23,31,0],

		"1f556":[["\uD83D\uDD56"],"\uE02A","\uDBB8\uDC24",["clock7"],28,24,31,0],

		"1f557":[["\uD83D\uDD57"],"\uE02B","\uDBB8\uDC25",["clock8"],28,25,31,0],

		"1f558":[["\uD83D\uDD58"],"\uE02C","\uDBB8\uDC26",["clock9"],28,26,31,0],

		"1f559":[["\uD83D\uDD59"],"\uE02D","\uDBB8\uDC27",["clock10"],28,27,31,0],

		"1f55a":[["\uD83D\uDD5A"],"\uE02E","\uDBB8\uDC28",["clock11"],28,28,31,0],

		"1f55b":[["\uD83D\uDD5B"],"\uE02F","\uDBB8\uDC29",["clock12"],28,29,31,0],

		"1f55c":[["\uD83D\uDD5C"],"","",["clock130"],28,30,31,0],

		"1f55d":[["\uD83D\uDD5D"],"","",["clock230"],28,31,31,0],

		"1f55e":[["\uD83D\uDD5E"],"","",["clock330"],28,32,31,0],

		"1f55f":[["\uD83D\uDD5F"],"","",["clock430"],28,33,31,0],

		"1f560":[["\uD83D\uDD60"],"","",["clock530"],28,34,31,0],

		"1f561":[["\uD83D\uDD61"],"","",["clock630"],28,35,31,0],

		"1f562":[["\uD83D\uDD62"],"","",["clock730"],28,36,31,0],

		"1f563":[["\uD83D\uDD63"],"","",["clock830"],28,37,31,0],

		"1f564":[["\uD83D\uDD64"],"","",["clock930"],28,38,31,0],

		"1f565":[["\uD83D\uDD65"],"","",["clock1030"],28,39,31,0],

		"1f566":[["\uD83D\uDD66"],"","",["clock1130"],28,40,31,0],

		"1f567":[["\uD83D\uDD67"],"","",["clock1230"],28,41,31,0],

		"1f56f-fe0f":[["\uD83D\uDD6F\uFE0F","\uD83D\uDD6F"],"","",["candle"],28,42,15,0],

		"1f570-fe0f":[["\uD83D\uDD70\uFE0F","\uD83D\uDD70"],"","",["mantelpiece_clock"],28,43,15,0],

		"1f573-fe0f":[["\uD83D\uDD73\uFE0F","\uD83D\uDD73"],"","",["hole"],28,44,15,0],

		"1f574-fe0f":[["\uD83D\uDD74\uFE0F","\uD83D\uDD74"],"","",["man_in_business_suit_levitating"],28,45,15,0],

		"1f575-fe0f-200d-2640-fe0f":[["\uD83D\uDD75\uFE0F\u200D\u2640\uFE0F"],"","",["female-detective"],28,51,7,0],

		"1f575-fe0f-200d-2642-fe0f":[["\uD83D\uDD75\uFE0F\u200D\u2642\uFE0F","\uD83D\uDD75\uFE0F","\uD83D\uDD75"],"","",["male-detective","sleuth_or_spy"],29,5,7,0],

		"1f576-fe0f":[["\uD83D\uDD76\uFE0F","\uD83D\uDD76"],"","",["dark_sunglasses"],29,17,15,0],

		"1f577-fe0f":[["\uD83D\uDD77\uFE0F","\uD83D\uDD77"],"","",["spider"],29,18,15,0],

		"1f578-fe0f":[["\uD83D\uDD78\uFE0F","\uD83D\uDD78"],"","",["spider_web"],29,19,15,0],

		"1f579-fe0f":[["\uD83D\uDD79\uFE0F","\uD83D\uDD79"],"","",["joystick"],29,20,15,0],

		"1f57a":[["\uD83D\uDD7A"],"","",["man_dancing"],29,21,15,0],

		"1f587-fe0f":[["\uD83D\uDD87\uFE0F","\uD83D\uDD87"],"","",["linked_paperclips"],29,27,15,0],

		"1f58a-fe0f":[["\uD83D\uDD8A\uFE0F","\uD83D\uDD8A"],"","",["lower_left_ballpoint_pen"],29,28,15,0],

		"1f58b-fe0f":[["\uD83D\uDD8B\uFE0F","\uD83D\uDD8B"],"","",["lower_left_fountain_pen"],29,29,15,0],

		"1f58c-fe0f":[["\uD83D\uDD8C\uFE0F","\uD83D\uDD8C"],"","",["lower_left_paintbrush"],29,30,15,0],

		"1f58d-fe0f":[["\uD83D\uDD8D\uFE0F","\uD83D\uDD8D"],"","",["lower_left_crayon"],29,31,15,0],

		"1f590-fe0f":[["\uD83D\uDD90\uFE0F","\uD83D\uDD90"],"","",["raised_hand_with_fingers_splayed"],29,32,15,0],

		"1f595":[["\uD83D\uDD95"],"","",["middle_finger","reversed_hand_with_middle_finger_extended"],29,38,15,0],

		"1f596":[["\uD83D\uDD96"],"","",["spock-hand"],29,44,15,0],

		"1f5a4":[["\uD83D\uDDA4"],"","",["black_heart"],29,50,15,0],

		"1f5a5-fe0f":[["\uD83D\uDDA5\uFE0F","\uD83D\uDDA5"],"","",["desktop_computer"],29,51,15,0],

		"1f5a8-fe0f":[["\uD83D\uDDA8\uFE0F","\uD83D\uDDA8"],"","",["printer"],30,0,15,0],

		"1f5b1-fe0f":[["\uD83D\uDDB1\uFE0F","\uD83D\uDDB1"],"","",["three_button_mouse"],30,1,15,0],

		"1f5b2-fe0f":[["\uD83D\uDDB2\uFE0F","\uD83D\uDDB2"],"","",["trackball"],30,2,15,0],

		"1f5bc-fe0f":[["\uD83D\uDDBC\uFE0F","\uD83D\uDDBC"],"","",["frame_with_picture"],30,3,15,0],

		"1f5c2-fe0f":[["\uD83D\uDDC2\uFE0F","\uD83D\uDDC2"],"","",["card_index_dividers"],30,4,15,0],

		"1f5c3-fe0f":[["\uD83D\uDDC3\uFE0F","\uD83D\uDDC3"],"","",["card_file_box"],30,5,15,0],

		"1f5c4-fe0f":[["\uD83D\uDDC4\uFE0F","\uD83D\uDDC4"],"","",["file_cabinet"],30,6,15,0],

		"1f5d1-fe0f":[["\uD83D\uDDD1\uFE0F","\uD83D\uDDD1"],"","",["wastebasket"],30,7,15,0],

		"1f5d2-fe0f":[["\uD83D\uDDD2\uFE0F","\uD83D\uDDD2"],"","",["spiral_note_pad"],30,8,15,0],

		"1f5d3-fe0f":[["\uD83D\uDDD3\uFE0F","\uD83D\uDDD3"],"","",["spiral_calendar_pad"],30,9,15,0],

		"1f5dc-fe0f":[["\uD83D\uDDDC\uFE0F","\uD83D\uDDDC"],"","",["compression"],30,10,15,0],

		"1f5dd-fe0f":[["\uD83D\uDDDD\uFE0F","\uD83D\uDDDD"],"","",["old_key"],30,11,15,0],

		"1f5de-fe0f":[["\uD83D\uDDDE\uFE0F","\uD83D\uDDDE"],"","",["rolled_up_newspaper"],30,12,15,0],

		"1f5e1-fe0f":[["\uD83D\uDDE1\uFE0F","\uD83D\uDDE1"],"","",["dagger_knife"],30,13,15,0],

		"1f5e3-fe0f":[["\uD83D\uDDE3\uFE0F","\uD83D\uDDE3"],"","",["speaking_head_in_silhouette"],30,14,15,0],

		"1f5e8-fe0f":[["\uD83D\uDDE8\uFE0F","\uD83D\uDDE8"],"","",["left_speech_bubble"],30,15,15,0],

		"1f5ef-fe0f":[["\uD83D\uDDEF\uFE0F","\uD83D\uDDEF"],"","",["right_anger_bubble"],30,16,15,0],

		"1f5f3-fe0f":[["\uD83D\uDDF3\uFE0F","\uD83D\uDDF3"],"","",["ballot_box_with_ballot"],30,17,15,0],

		"1f5fa-fe0f":[["\uD83D\uDDFA\uFE0F","\uD83D\uDDFA"],"","",["world_map"],30,18,15,0],

		"1f5fb":[["\uD83D\uDDFB"],"\uE03B","\uDBB9\uDCC3",["mount_fuji"],30,19,31,0],

		"1f5fc":[["\uD83D\uDDFC"],"\uE509","\uDBB9\uDCC4",["tokyo_tower"],30,20,31,0],

		"1f5fd":[["\uD83D\uDDFD"],"\uE51D","\uDBB9\uDCC6",["statue_of_liberty"],30,21,31,0],

		"1f5fe":[["\uD83D\uDDFE"],"","\uDBB9\uDCC7",["japan"],30,22,31,0],

		"1f5ff":[["\uD83D\uDDFF"],"","\uDBB9\uDCC8",["moyai"],30,23,31,0],

		"1f600":[["\uD83D\uDE00"],"","",["grinning"],30,24,31,0,":D"],

		"1f601":[["\uD83D\uDE01"],"\uE404","\uDBB8\uDF33",["grin"],30,25,31,0],

		"1f602":[["\uD83D\uDE02"],"\uE412","\uDBB8\uDF34",["joy"],30,26,31,0],

		"1f603":[["\uD83D\uDE03"],"\uE057","\uDBB8\uDF30",["smiley"],30,27,31,0,":)"],

		"1f604":[["\uD83D\uDE04"],"\uE415","\uDBB8\uDF38",["smile"],30,28,31,0,":)"],

		"1f605":[["\uD83D\uDE05"],"","\uDBB8\uDF31",["sweat_smile"],30,29,31,0],

		"1f606":[["\uD83D\uDE06"],"","\uDBB8\uDF32",["laughing","satisfied"],30,30,31,0],

		"1f607":[["\uD83D\uDE07"],"","",["innocent"],30,31,31,0],

		"1f608":[["\uD83D\uDE08"],"","",["smiling_imp"],30,32,31,0],

		"1f609":[["\uD83D\uDE09"],"\uE405","\uDBB8\uDF47",["wink"],30,33,31,0,";)"],

		"1f60a":[["\uD83D\uDE0A"],"\uE056","\uDBB8\uDF35",["blush"],30,34,31,0,":)"],

		"1f60b":[["\uD83D\uDE0B"],"","\uDBB8\uDF2B",["yum"],30,35,31,0],

		"1f60c":[["\uD83D\uDE0C"],"\uE40A","\uDBB8\uDF3E",["relieved"],30,36,31,0],

		"1f60d":[["\uD83D\uDE0D"],"\uE106","\uDBB8\uDF27",["heart_eyes"],30,37,31,0],

		"1f60e":[["\uD83D\uDE0E"],"","",["sunglasses"],30,38,31,0],

		"1f60f":[["\uD83D\uDE0F"],"\uE402","\uDBB8\uDF43",["smirk"],30,39,31,0],

		"1f610":[["\uD83D\uDE10"],"","",["neutral_face"],30,40,31,0],

		"1f611":[["\uD83D\uDE11"],"","",["expressionless"],30,41,31,0],

		"1f612":[["\uD83D\uDE12"],"\uE40E","\uDBB8\uDF26",["unamused"],30,42,31,0,":("],

		"1f613":[["\uD83D\uDE13"],"\uE108","\uDBB8\uDF44",["sweat"],30,43,31,0],

		"1f614":[["\uD83D\uDE14"],"\uE403","\uDBB8\uDF40",["pensive"],30,44,31,0],

		"1f615":[["\uD83D\uDE15"],"","",["confused"],30,45,31,0],

		"1f616":[["\uD83D\uDE16"],"\uE407","\uDBB8\uDF3F",["confounded"],30,46,31,0],

		"1f617":[["\uD83D\uDE17"],"","",["kissing"],30,47,31,0],

		"1f618":[["\uD83D\uDE18"],"\uE418","\uDBB8\uDF2C",["kissing_heart"],30,48,31,0],

		"1f619":[["\uD83D\uDE19"],"","",["kissing_smiling_eyes"],30,49,31,0],

		"1f61a":[["\uD83D\uDE1A"],"\uE417","\uDBB8\uDF2D",["kissing_closed_eyes"],30,50,31,0],

		"1f61b":[["\uD83D\uDE1B"],"","",["stuck_out_tongue"],30,51,31,0,":p"],

		"1f61c":[["\uD83D\uDE1C"],"\uE105","\uDBB8\uDF29",["stuck_out_tongue_winking_eye"],31,0,31,0,";p"],

		"1f61d":[["\uD83D\uDE1D"],"\uE409","\uDBB8\uDF2A",["stuck_out_tongue_closed_eyes"],31,1,31,0],

		"1f61e":[["\uD83D\uDE1E"],"\uE058","\uDBB8\uDF23",["disappointed"],31,2,31,0,":("],

		"1f61f":[["\uD83D\uDE1F"],"","",["worried"],31,3,31,0],

		"1f620":[["\uD83D\uDE20"],"\uE059","\uDBB8\uDF20",["angry"],31,4,31,0],

		"1f621":[["\uD83D\uDE21"],"\uE416","\uDBB8\uDF3D",["rage"],31,5,31,0],

		"1f622":[["\uD83D\uDE22"],"\uE413","\uDBB8\uDF39",["cry"],31,6,31,0,":'("],

		"1f623":[["\uD83D\uDE23"],"\uE406","\uDBB8\uDF3C",["persevere"],31,7,31,0],

		"1f624":[["\uD83D\uDE24"],"","\uDBB8\uDF28",["triumph"],31,8,31,0],

		"1f625":[["\uD83D\uDE25"],"\uE401","\uDBB8\uDF45",["disappointed_relieved"],31,9,31,0],

		"1f626":[["\uD83D\uDE26"],"","",["frowning"],31,10,31,0],

		"1f627":[["\uD83D\uDE27"],"","",["anguished"],31,11,31,0],

		"1f628":[["\uD83D\uDE28"],"\uE40B","\uDBB8\uDF3B",["fearful"],31,12,31,0],

		"1f629":[["\uD83D\uDE29"],"","\uDBB8\uDF21",["weary"],31,13,31,0],

		"1f62a":[["\uD83D\uDE2A"],"\uE408","\uDBB8\uDF42",["sleepy"],31,14,31,0],

		"1f62b":[["\uD83D\uDE2B"],"","\uDBB8\uDF46",["tired_face"],31,15,31,0],

		"1f62c":[["\uD83D\uDE2C"],"","",["grimacing"],31,16,31,0],

		"1f62d":[["\uD83D\uDE2D"],"\uE411","\uDBB8\uDF3A",["sob"],31,17,31,0,":'("],

		"1f62e":[["\uD83D\uDE2E"],"","",["open_mouth"],31,18,31,0],

		"1f62f":[["\uD83D\uDE2F"],"","",["hushed"],31,19,31,0],

		"1f630":[["\uD83D\uDE30"],"\uE40F","\uDBB8\uDF25",["cold_sweat"],31,20,31,0],

		"1f631":[["\uD83D\uDE31"],"\uE107","\uDBB8\uDF41",["scream"],31,21,31,0],

		"1f632":[["\uD83D\uDE32"],"\uE410","\uDBB8\uDF22",["astonished"],31,22,31,0],

		"1f633":[["\uD83D\uDE33"],"\uE40D","\uDBB8\uDF2F",["flushed"],31,23,31,0],

		"1f634":[["\uD83D\uDE34"],"","",["sleeping"],31,24,31,0],

		"1f635":[["\uD83D\uDE35"],"","\uDBB8\uDF24",["dizzy_face"],31,25,31,0],

		"1f636":[["\uD83D\uDE36"],"","",["no_mouth"],31,26,31,0],

		"1f637":[["\uD83D\uDE37"],"\uE40C","\uDBB8\uDF2E",["mask"],31,27,31,0],

		"1f638":[["\uD83D\uDE38"],"","\uDBB8\uDF49",["smile_cat"],31,28,31,0],

		"1f639":[["\uD83D\uDE39"],"","\uDBB8\uDF4A",["joy_cat"],31,29,31,0],

		"1f63a":[["\uD83D\uDE3A"],"","\uDBB8\uDF48",["smiley_cat"],31,30,31,0],

		"1f63b":[["\uD83D\uDE3B"],"","\uDBB8\uDF4C",["heart_eyes_cat"],31,31,31,0],

		"1f63c":[["\uD83D\uDE3C"],"","\uDBB8\uDF4F",["smirk_cat"],31,32,31,0],

		"1f63d":[["\uD83D\uDE3D"],"","\uDBB8\uDF4B",["kissing_cat"],31,33,31,0],

		"1f63e":[["\uD83D\uDE3E"],"","\uDBB8\uDF4E",["pouting_cat"],31,34,31,0],

		"1f63f":[["\uD83D\uDE3F"],"","\uDBB8\uDF4D",["crying_cat_face"],31,35,31,0],

		"1f640":[["\uD83D\uDE40"],"","\uDBB8\uDF50",["scream_cat"],31,36,31,0],

		"1f641":[["\uD83D\uDE41"],"","",["slightly_frowning_face"],31,37,15,0],

		"1f642":[["\uD83D\uDE42"],"","",["slightly_smiling_face"],31,38,31,0],

		"1f643":[["\uD83D\uDE43"],"","",["upside_down_face"],31,39,15,0],

		"1f644":[["\uD83D\uDE44"],"","",["face_with_rolling_eyes"],31,40,15,0],

		"1f645-200d-2640-fe0f":[["\uD83D\uDE45\u200D\u2640\uFE0F","\uD83D\uDE45\u200D\u2640","\uD83D\uDE45"],"","",["woman-gesturing-no","no_good"],31,41,15,0],

		"1f645-200d-2642-fe0f":[["\uD83D\uDE45\u200D\u2642\uFE0F","\uD83D\uDE45\u200D\u2642"],"","",["man-gesturing-no"],31,47,15,0],

		"1f646-200d-2640-fe0f":[["\uD83D\uDE46\u200D\u2640\uFE0F","\uD83D\uDE46\u200D\u2640","\uD83D\uDE46"],"","",["woman-gesturing-ok","ok_woman"],32,7,15,0],

		"1f646-200d-2642-fe0f":[["\uD83D\uDE46\u200D\u2642\uFE0F","\uD83D\uDE46\u200D\u2642"],"","",["man-gesturing-ok"],32,13,15,0],

		"1f647-200d-2640-fe0f":[["\uD83D\uDE47\u200D\u2640\uFE0F","\uD83D\uDE47\u200D\u2640"],"","",["woman-bowing"],32,25,15,0],

		"1f647-200d-2642-fe0f":[["\uD83D\uDE47\u200D\u2642\uFE0F","\uD83D\uDE47\u200D\u2642","\uD83D\uDE47"],"","",["man-bowing","bow"],32,31,15,0],

		"1f648":[["\uD83D\uDE48"],"","\uDBB8\uDF54",["see_no_evil"],32,43,31,0],

		"1f649":[["\uD83D\uDE49"],"","\uDBB8\uDF56",["hear_no_evil"],32,44,31,0],

		"1f64a":[["\uD83D\uDE4A"],"","\uDBB8\uDF55",["speak_no_evil"],32,45,31,0],

		"1f64b-200d-2640-fe0f":[["\uD83D\uDE4B\u200D\u2640\uFE0F","\uD83D\uDE4B\u200D\u2640","\uD83D\uDE4B"],"","",["woman-raising-hand","raising_hand"],32,46,15,0],

		"1f64b-200d-2642-fe0f":[["\uD83D\uDE4B\u200D\u2642\uFE0F","\uD83D\uDE4B\u200D\u2642"],"","",["man-raising-hand"],33,0,15,0],

		"1f64c":[["\uD83D\uDE4C"],"\uE427","\uDBB8\uDF58",["raised_hands"],33,12,31,0],

		"1f64d-200d-2640-fe0f":[["\uD83D\uDE4D\u200D\u2640\uFE0F","\uD83D\uDE4D\u200D\u2640","\uD83D\uDE4D"],"","",["woman-frowning","person_frowning"],33,18,15,0],

		"1f64d-200d-2642-fe0f":[["\uD83D\uDE4D\u200D\u2642\uFE0F","\uD83D\uDE4D\u200D\u2642"],"","",["man-frowning"],33,24,15,0],

		"1f64e-200d-2640-fe0f":[["\uD83D\uDE4E\u200D\u2640\uFE0F","\uD83D\uDE4E\u200D\u2640","\uD83D\uDE4E"],"","",["woman-pouting","person_with_pouting_face"],33,36,15,0],

		"1f64e-200d-2642-fe0f":[["\uD83D\uDE4E\u200D\u2642\uFE0F","\uD83D\uDE4E\u200D\u2642"],"","",["man-pouting"],33,42,15,0],

		"1f64f":[["\uD83D\uDE4F"],"\uE41D","\uDBB8\uDF5B",["pray"],34,2,31,0],

		"1f680":[["\uD83D\uDE80"],"\uE10D","\uDBB9\uDFED",["rocket"],34,8,31,0],

		"1f681":[["\uD83D\uDE81"],"","",["helicopter"],34,9,31,0],

		"1f682":[["\uD83D\uDE82"],"","",["steam_locomotive"],34,10,31,0],

		"1f683":[["\uD83D\uDE83"],"\uE01E","\uDBB9\uDFDF",["railway_car"],34,11,31,0],

		"1f684":[["\uD83D\uDE84"],"\uE435","\uDBB9\uDFE2",["bullettrain_side"],34,12,31,0],

		"1f685":[["\uD83D\uDE85"],"\uE01F","\uDBB9\uDFE3",["bullettrain_front"],34,13,31,0],

		"1f686":[["\uD83D\uDE86"],"","",["train2"],34,14,31,0],

		"1f687":[["\uD83D\uDE87"],"\uE434","\uDBB9\uDFE0",["metro"],34,15,31,0],

		"1f688":[["\uD83D\uDE88"],"","",["light_rail"],34,16,31,0],

		"1f689":[["\uD83D\uDE89"],"\uE039","\uDBB9\uDFEC",["station"],34,17,31,0],

		"1f68a":[["\uD83D\uDE8A"],"","",["tram"],34,18,31,0],

		"1f68b":[["\uD83D\uDE8B"],"","",["train"],34,19,31,0],

		"1f68c":[["\uD83D\uDE8C"],"\uE159","\uDBB9\uDFE6",["bus"],34,20,31,0],

		"1f68d":[["\uD83D\uDE8D"],"","",["oncoming_bus"],34,21,31,0],

		"1f68e":[["\uD83D\uDE8E"],"","",["trolleybus"],34,22,31,0],

		"1f68f":[["\uD83D\uDE8F"],"\uE150","\uDBB9\uDFE7",["busstop"],34,23,31,0],

		"1f690":[["\uD83D\uDE90"],"","",["minibus"],34,24,31,0],

		"1f691":[["\uD83D\uDE91"],"\uE431","\uDBB9\uDFF3",["ambulance"],34,25,31,0],

		"1f692":[["\uD83D\uDE92"],"\uE430","\uDBB9\uDFF2",["fire_engine"],34,26,31,0],

		"1f693":[["\uD83D\uDE93"],"\uE432","\uDBB9\uDFF4",["police_car"],34,27,31,0],

		"1f694":[["\uD83D\uDE94"],"","",["oncoming_police_car"],34,28,31,0],

		"1f695":[["\uD83D\uDE95"],"\uE15A","\uDBB9\uDFEF",["taxi"],34,29,31,0],

		"1f696":[["\uD83D\uDE96"],"","",["oncoming_taxi"],34,30,31,0],

		"1f697":[["\uD83D\uDE97"],"\uE01B","\uDBB9\uDFE4",["car","red_car"],34,31,31,0],

		"1f698":[["\uD83D\uDE98"],"","",["oncoming_automobile"],34,32,31,0],

		"1f699":[["\uD83D\uDE99"],"\uE42E","\uDBB9\uDFE5",["blue_car"],34,33,31,0],

		"1f69a":[["\uD83D\uDE9A"],"\uE42F","\uDBB9\uDFF1",["truck"],34,34,31,0],

		"1f69b":[["\uD83D\uDE9B"],"","",["articulated_lorry"],34,35,31,0],

		"1f69c":[["\uD83D\uDE9C"],"","",["tractor"],34,36,31,0],

		"1f69d":[["\uD83D\uDE9D"],"","",["monorail"],34,37,31,0],

		"1f69e":[["\uD83D\uDE9E"],"","",["mountain_railway"],34,38,31,0],

		"1f69f":[["\uD83D\uDE9F"],"","",["suspension_railway"],34,39,31,0],

		"1f6a0":[["\uD83D\uDEA0"],"","",["mountain_cableway"],34,40,31,0],

		"1f6a1":[["\uD83D\uDEA1"],"","",["aerial_tramway"],34,41,31,0],

		"1f6a2":[["\uD83D\uDEA2"],"\uE202","\uDBB9\uDFE8",["ship"],34,42,31,0],

		"1f6a3-200d-2640-fe0f":[["\uD83D\uDEA3\u200D\u2640\uFE0F","\uD83D\uDEA3\u200D\u2640"],"","",["woman-rowing-boat"],34,43,15,0],

		"1f6a3-200d-2642-fe0f":[["\uD83D\uDEA3\u200D\u2642\uFE0F","\uD83D\uDEA3\u200D\u2642","\uD83D\uDEA3"],"","",["man-rowing-boat","rowboat"],34,49,15,0],

		"1f6a4":[["\uD83D\uDEA4"],"\uE135","\uDBB9\uDFEE",["speedboat"],35,9,31,0],

		"1f6a5":[["\uD83D\uDEA5"],"\uE14E","\uDBB9\uDFF7",["traffic_light"],35,10,31,0],

		"1f6a6":[["\uD83D\uDEA6"],"","",["vertical_traffic_light"],35,11,31,0],

		"1f6a7":[["\uD83D\uDEA7"],"\uE137","\uDBB9\uDFF8",["construction"],35,12,31,0],

		"1f6a8":[["\uD83D\uDEA8"],"","\uDBB9\uDFF9",["rotating_light"],35,13,31,0],

		"1f6a9":[["\uD83D\uDEA9"],"","\uDBBA\uDF22",["triangular_flag_on_post"],35,14,31,0],

		"1f6aa":[["\uD83D\uDEAA"],"","\uDBB9\uDCF3",["door"],35,15,31,0],

		"1f6ab":[["\uD83D\uDEAB"],"","\uDBBA\uDF48",["no_entry_sign"],35,16,31,0],

		"1f6ac":[["\uD83D\uDEAC"],"\uE30E","\uDBBA\uDF1E",["smoking"],35,17,31,0],

		"1f6ad":[["\uD83D\uDEAD"],"\uE208","\uDBBA\uDF1F",["no_smoking"],35,18,31,0],

		"1f6ae":[["\uD83D\uDEAE"],"","",["put_litter_in_its_place"],35,19,31,0],

		"1f6af":[["\uD83D\uDEAF"],"","",["do_not_litter"],35,20,31,0],

		"1f6b0":[["\uD83D\uDEB0"],"","",["potable_water"],35,21,31,0],

		"1f6b1":[["\uD83D\uDEB1"],"","",["non-potable_water"],35,22,31,0],

		"1f6b2":[["\uD83D\uDEB2"],"\uE136","\uDBB9\uDFEB",["bike"],35,23,31,0],

		"1f6b3":[["\uD83D\uDEB3"],"","",["no_bicycles"],35,24,31,0],

		"1f6b4-200d-2640-fe0f":[["\uD83D\uDEB4\u200D\u2640\uFE0F","\uD83D\uDEB4\u200D\u2640"],"","",["woman-biking"],35,25,15,0],

		"1f6b4-200d-2642-fe0f":[["\uD83D\uDEB4\u200D\u2642\uFE0F","\uD83D\uDEB4\u200D\u2642","\uD83D\uDEB4"],"","",["man-biking","bicyclist"],35,31,15,0],

		"1f6b5-200d-2640-fe0f":[["\uD83D\uDEB5\u200D\u2640\uFE0F","\uD83D\uDEB5\u200D\u2640"],"","",["woman-mountain-biking"],35,43,15,0],

		"1f6b5-200d-2642-fe0f":[["\uD83D\uDEB5\u200D\u2642\uFE0F","\uD83D\uDEB5\u200D\u2642","\uD83D\uDEB5"],"","",["man-mountain-biking","mountain_bicyclist"],35,49,15,0],

		"1f6b6-200d-2640-fe0f":[["\uD83D\uDEB6\u200D\u2640\uFE0F","\uD83D\uDEB6\u200D\u2640"],"","",["woman-walking"],36,9,15,0],

		"1f6b6-200d-2642-fe0f":[["\uD83D\uDEB6\u200D\u2642\uFE0F","\uD83D\uDEB6\u200D\u2642","\uD83D\uDEB6"],"","",["man-walking","walking"],36,15,15,0],

		"1f6b7":[["\uD83D\uDEB7"],"","",["no_pedestrians"],36,27,31,0],

		"1f6b8":[["\uD83D\uDEB8"],"","",["children_crossing"],36,28,31,0],

		"1f6b9":[["\uD83D\uDEB9"],"\uE138","\uDBBA\uDF33",["mens"],36,29,31,0],

		"1f6ba":[["\uD83D\uDEBA"],"\uE139","\uDBBA\uDF34",["womens"],36,30,31,0],

		"1f6bb":[["\uD83D\uDEBB"],"\uE151","\uDBB9\uDD06",["restroom"],36,31,31,0],

		"1f6bc":[["\uD83D\uDEBC"],"\uE13A","\uDBBA\uDF35",["baby_symbol"],36,32,31,0],

		"1f6bd":[["\uD83D\uDEBD"],"\uE140","\uDBB9\uDD07",["toilet"],36,33,31,0],

		"1f6be":[["\uD83D\uDEBE"],"\uE309","\uDBB9\uDD08",["wc"],36,34,31,0],

		"1f6bf":[["\uD83D\uDEBF"],"","",["shower"],36,35,31,0],

		"1f6c0":[["\uD83D\uDEC0"],"\uE13F","\uDBB9\uDD05",["bath"],36,36,31,0],

		"1f6c1":[["\uD83D\uDEC1"],"","",["bathtub"],36,42,31,0],

		"1f6c2":[["\uD83D\uDEC2"],"","",["passport_control"],36,43,31,0],

		"1f6c3":[["\uD83D\uDEC3"],"","",["customs"],36,44,31,0],

		"1f6c4":[["\uD83D\uDEC4"],"","",["baggage_claim"],36,45,31,0],

		"1f6c5":[["\uD83D\uDEC5"],"","",["left_luggage"],36,46,31,0],

		"1f6cb-fe0f":[["\uD83D\uDECB\uFE0F","\uD83D\uDECB"],"","",["couch_and_lamp"],36,47,15,0],

		"1f6cc":[["\uD83D\uDECC"],"","",["sleeping_accommodation"],36,48,15,0],

		"1f6cd-fe0f":[["\uD83D\uDECD\uFE0F","\uD83D\uDECD"],"","",["shopping_bags"],37,2,15,0],

		"1f6ce-fe0f":[["\uD83D\uDECE\uFE0F","\uD83D\uDECE"],"","",["bellhop_bell"],37,3,15,0],

		"1f6cf-fe0f":[["\uD83D\uDECF\uFE0F","\uD83D\uDECF"],"","",["bed"],37,4,15,0],

		"1f6d0":[["\uD83D\uDED0"],"","",["place_of_worship"],37,5,15,0],

		"1f6d1":[["\uD83D\uDED1"],"","",["octagonal_sign"],37,6,15,0],

		"1f6d2":[["\uD83D\uDED2"],"","",["shopping_trolley"],37,7,15,0],

		"1f6e0-fe0f":[["\uD83D\uDEE0\uFE0F","\uD83D\uDEE0"],"","",["hammer_and_wrench"],37,8,15,0],

		"1f6e1-fe0f":[["\uD83D\uDEE1\uFE0F","\uD83D\uDEE1"],"","",["shield"],37,9,15,0],

		"1f6e2-fe0f":[["\uD83D\uDEE2\uFE0F","\uD83D\uDEE2"],"","",["oil_drum"],37,10,15,0],

		"1f6e3-fe0f":[["\uD83D\uDEE3\uFE0F","\uD83D\uDEE3"],"","",["motorway"],37,11,15,0],

		"1f6e4-fe0f":[["\uD83D\uDEE4\uFE0F","\uD83D\uDEE4"],"","",["railway_track"],37,12,15,0],

		"1f6e5-fe0f":[["\uD83D\uDEE5\uFE0F","\uD83D\uDEE5"],"","",["motor_boat"],37,13,15,0],

		"1f6e9-fe0f":[["\uD83D\uDEE9\uFE0F","\uD83D\uDEE9"],"","",["small_airplane"],37,14,15,0],

		"1f6eb":[["\uD83D\uDEEB"],"","",["airplane_departure"],37,15,15,0],

		"1f6ec":[["\uD83D\uDEEC"],"","",["airplane_arriving"],37,16,15,0],

		"1f6f0-fe0f":[["\uD83D\uDEF0\uFE0F","\uD83D\uDEF0"],"","",["satellite"],37,17,15,0],

		"1f6f3-fe0f":[["\uD83D\uDEF3\uFE0F","\uD83D\uDEF3"],"","",["passenger_ship"],37,18,15,0],

		"1f6f4":[["\uD83D\uDEF4"],"","",["scooter"],37,19,15,0],

		"1f6f5":[["\uD83D\uDEF5"],"","",["motor_scooter"],37,20,15,0],

		"1f6f6":[["\uD83D\uDEF6"],"","",["canoe"],37,21,15,0],

		"1f6f7":[["\uD83D\uDEF7"],"","",["sled"],37,22,15,0],

		"1f6f8":[["\uD83D\uDEF8"],"","",["flying_saucer"],37,23,15,0],

		"1f910":[["\uD83E\uDD10"],"","",["zipper_mouth_face"],37,24,15,0],

		"1f911":[["\uD83E\uDD11"],"","",["money_mouth_face"],37,25,15,0],

		"1f912":[["\uD83E\uDD12"],"","",["face_with_thermometer"],37,26,15,0],

		"1f913":[["\uD83E\uDD13"],"","",["nerd_face"],37,27,15,0],

		"1f914":[["\uD83E\uDD14"],"","",["thinking_face"],37,28,15,0],

		"1f915":[["\uD83E\uDD15"],"","",["face_with_head_bandage"],37,29,15,0],

		"1f916":[["\uD83E\uDD16"],"","",["robot_face"],37,30,15,0],

		"1f917":[["\uD83E\uDD17"],"","",["hugging_face"],37,31,15,0],

		"1f918":[["\uD83E\uDD18"],"","",["the_horns","sign_of_the_horns"],37,32,15,0],

		"1f919":[["\uD83E\uDD19"],"","",["call_me_hand"],37,38,15,0],

		"1f91a":[["\uD83E\uDD1A"],"","",["raised_back_of_hand"],37,44,15,0],

		"1f91b":[["\uD83E\uDD1B"],"","",["left-facing_fist"],37,50,15,0],

		"1f91c":[["\uD83E\uDD1C"],"","",["right-facing_fist"],38,4,15,0],

		"1f91d":[["\uD83E\uDD1D"],"","",["handshake"],38,10,15,0],

		"1f91e":[["\uD83E\uDD1E"],"","",["crossed_fingers","hand_with_index_and_middle_fingers_crossed"],38,11,15,0],

		"1f91f":[["\uD83E\uDD1F"],"","",["i_love_you_hand_sign"],38,17,15,0],

		"1f920":[["\uD83E\uDD20"],"","",["face_with_cowboy_hat"],38,23,15,0],

		"1f921":[["\uD83E\uDD21"],"","",["clown_face"],38,24,15,0],

		"1f922":[["\uD83E\uDD22"],"","",["nauseated_face"],38,25,15,0],

		"1f923":[["\uD83E\uDD23"],"","",["rolling_on_the_floor_laughing"],38,26,15,0],

		"1f924":[["\uD83E\uDD24"],"","",["drooling_face"],38,27,15,0],

		"1f925":[["\uD83E\uDD25"],"","",["lying_face"],38,28,15,0],

		"1f926-200d-2640-fe0f":[["\uD83E\uDD26\u200D\u2640\uFE0F","\uD83E\uDD26\u200D\u2640"],"","",["woman-facepalming"],38,29,15,0],

		"1f926-200d-2642-fe0f":[["\uD83E\uDD26\u200D\u2642\uFE0F","\uD83E\uDD26\u200D\u2642"],"","",["man-facepalming"],38,35,15,0],

		"1f926":[["\uD83E\uDD26"],"","",["face_palm"],38,41,7,0],

		"1f927":[["\uD83E\uDD27"],"","",["sneezing_face"],38,47,15,0],

		"1f928":[["\uD83E\uDD28"],"","",["face_with_raised_eyebrow","face_with_one_eyebrow_raised"],38,48,15,0],

		"1f929":[["\uD83E\uDD29"],"","",["star-struck","grinning_face_with_star_eyes"],38,49,15,0],

		"1f92a":[["\uD83E\uDD2A"],"","",["zany_face","grinning_face_with_one_large_and_one_small_eye"],38,50,15,0],

		"1f92b":[["\uD83E\uDD2B"],"","",["shushing_face","face_with_finger_covering_closed_lips"],38,51,15,0],

		"1f92c":[["\uD83E\uDD2C"],"","",["face_with_symbols_on_mouth","serious_face_with_symbols_covering_mouth"],39,0,15,0],

		"1f92d":[["\uD83E\uDD2D"],"","",["face_with_hand_over_mouth","smiling_face_with_smiling_eyes_and_hand_covering_mouth"],39,1,15,0],

		"1f92e":[["\uD83E\uDD2E"],"","",["face_vomiting","face_with_open_mouth_vomiting"],39,2,15,0],

		"1f92f":[["\uD83E\uDD2F"],"","",["exploding_head","shocked_face_with_exploding_head"],39,3,15,0],

		"1f930":[["\uD83E\uDD30"],"","",["pregnant_woman"],39,4,15,0],

		"1f931":[["\uD83E\uDD31"],"","",["breast-feeding"],39,10,15,0],

		"1f932":[["\uD83E\uDD32"],"","",["palms_up_together"],39,16,15,0],

		"1f933":[["\uD83E\uDD33"],"","",["selfie"],39,22,15,0],

		"1f934":[["\uD83E\uDD34"],"","",["prince"],39,28,15,0],

		"1f935":[["\uD83E\uDD35"],"","",["man_in_tuxedo"],39,34,15,0],

		"1f936":[["\uD83E\uDD36"],"","",["mrs_claus","mother_christmas"],39,40,15,0],

		"1f937-200d-2640-fe0f":[["\uD83E\uDD37\u200D\u2640\uFE0F","\uD83E\uDD37\u200D\u2640"],"","",["woman-shrugging"],39,46,15,0],

		"1f937-200d-2642-fe0f":[["\uD83E\uDD37\u200D\u2642\uFE0F","\uD83E\uDD37\u200D\u2642"],"","",["man-shrugging"],40,0,15,0],

		"1f937":[["\uD83E\uDD37"],"","",["shrug"],40,6,7,0],

		"1f938-200d-2640-fe0f":[["\uD83E\uDD38\u200D\u2640\uFE0F","\uD83E\uDD38\u200D\u2640"],"","",["woman-cartwheeling"],40,12,15,0],

		"1f938-200d-2642-fe0f":[["\uD83E\uDD38\u200D\u2642\uFE0F","\uD83E\uDD38\u200D\u2642"],"","",["man-cartwheeling"],40,18,15,0],

		"1f938":[["\uD83E\uDD38"],"","",["person_doing_cartwheel"],40,24,7,0],

		"1f939-200d-2640-fe0f":[["\uD83E\uDD39\u200D\u2640\uFE0F","\uD83E\uDD39\u200D\u2640"],"","",["woman-juggling"],40,30,7,0],

		"1f939-200d-2642-fe0f":[["\uD83E\uDD39\u200D\u2642\uFE0F","\uD83E\uDD39\u200D\u2642"],"","",["man-juggling"],40,36,7,0],

		"1f939":[["\uD83E\uDD39"],"","",["juggling"],40,42,15,0],

		"1f93a":[["\uD83E\uDD3A"],"","",["fencer"],40,48,15,0],

		"1f93c-200d-2640-fe0f":[["\uD83E\uDD3C\u200D\u2640\uFE0F","\uD83E\uDD3C\u200D\u2640"],"","",["woman-wrestling"],40,49,15,0],

		"1f93c-200d-2642-fe0f":[["\uD83E\uDD3C\u200D\u2642\uFE0F","\uD83E\uDD3C\u200D\u2642"],"","",["man-wrestling"],40,50,15,0],

		"1f93c":[["\uD83E\uDD3C"],"","",["wrestlers"],40,51,7,0],

		"1f93d-200d-2640-fe0f":[["\uD83E\uDD3D\u200D\u2640\uFE0F","\uD83E\uDD3D\u200D\u2640"],"","",["woman-playing-water-polo"],41,0,15,0],

		"1f93d-200d-2642-fe0f":[["\uD83E\uDD3D\u200D\u2642\uFE0F","\uD83E\uDD3D\u200D\u2642"],"","",["man-playing-water-polo"],41,6,15,0],

		"1f93d":[["\uD83E\uDD3D"],"","",["water_polo"],41,12,7,0],

		"1f93e-200d-2640-fe0f":[["\uD83E\uDD3E\u200D\u2640\uFE0F","\uD83E\uDD3E\u200D\u2640"],"","",["woman-playing-handball"],41,18,15,0],

		"1f93e-200d-2642-fe0f":[["\uD83E\uDD3E\u200D\u2642\uFE0F","\uD83E\uDD3E\u200D\u2642"],"","",["man-playing-handball"],41,24,15,0],

		"1f93e":[["\uD83E\uDD3E"],"","",["handball"],41,30,7,0],

		"1f940":[["\uD83E\uDD40"],"","",["wilted_flower"],41,36,15,0],

		"1f941":[["\uD83E\uDD41"],"","",["drum_with_drumsticks"],41,37,15,0],

		"1f942":[["\uD83E\uDD42"],"","",["clinking_glasses"],41,38,15,0],

		"1f943":[["\uD83E\uDD43"],"","",["tumbler_glass"],41,39,15,0],

		"1f944":[["\uD83E\uDD44"],"","",["spoon"],41,40,15,0],

		"1f945":[["\uD83E\uDD45"],"","",["goal_net"],41,41,15,0],

		"1f947":[["\uD83E\uDD47"],"","",["first_place_medal"],41,42,15,0],

		"1f948":[["\uD83E\uDD48"],"","",["second_place_medal"],41,43,15,0],

		"1f949":[["\uD83E\uDD49"],"","",["third_place_medal"],41,44,15,0],

		"1f94a":[["\uD83E\uDD4A"],"","",["boxing_glove"],41,45,15,0],

		"1f94b":[["\uD83E\uDD4B"],"","",["martial_arts_uniform"],41,46,15,0],

		"1f94c":[["\uD83E\uDD4C"],"","",["curling_stone"],41,47,15,0],

		"1f950":[["\uD83E\uDD50"],"","",["croissant"],41,48,15,0],

		"1f951":[["\uD83E\uDD51"],"","",["avocado"],41,49,15,0],

		"1f952":[["\uD83E\uDD52"],"","",["cucumber"],41,50,15,0],

		"1f953":[["\uD83E\uDD53"],"","",["bacon"],41,51,15,0],

		"1f954":[["\uD83E\uDD54"],"","",["potato"],42,0,15,0],

		"1f955":[["\uD83E\uDD55"],"","",["carrot"],42,1,15,0],

		"1f956":[["\uD83E\uDD56"],"","",["baguette_bread"],42,2,15,0],

		"1f957":[["\uD83E\uDD57"],"","",["green_salad"],42,3,15,0],

		"1f958":[["\uD83E\uDD58"],"","",["shallow_pan_of_food"],42,4,15,0],

		"1f959":[["\uD83E\uDD59"],"","",["stuffed_flatbread"],42,5,15,0],

		"1f95a":[["\uD83E\uDD5A"],"","",["egg"],42,6,15,0],

		"1f95b":[["\uD83E\uDD5B"],"","",["glass_of_milk"],42,7,15,0],

		"1f95c":[["\uD83E\uDD5C"],"","",["peanuts"],42,8,15,0],

		"1f95d":[["\uD83E\uDD5D"],"","",["kiwifruit"],42,9,15,0],

		"1f95e":[["\uD83E\uDD5E"],"","",["pancakes"],42,10,15,0],

		"1f95f":[["\uD83E\uDD5F"],"","",["dumpling"],42,11,15,0],

		"1f960":[["\uD83E\uDD60"],"","",["fortune_cookie"],42,12,15,0],

		"1f961":[["\uD83E\uDD61"],"","",["takeout_box"],42,13,15,0],

		"1f962":[["\uD83E\uDD62"],"","",["chopsticks"],42,14,15,0],

		"1f963":[["\uD83E\uDD63"],"","",["bowl_with_spoon"],42,15,15,0],

		"1f964":[["\uD83E\uDD64"],"","",["cup_with_straw"],42,16,15,0],

		"1f965":[["\uD83E\uDD65"],"","",["coconut"],42,17,15,0],

		"1f966":[["\uD83E\uDD66"],"","",["broccoli"],42,18,15,0],

		"1f967":[["\uD83E\uDD67"],"","",["pie"],42,19,15,0],

		"1f968":[["\uD83E\uDD68"],"","",["pretzel"],42,20,15,0],

		"1f969":[["\uD83E\uDD69"],"","",["cut_of_meat"],42,21,15,0],

		"1f96a":[["\uD83E\uDD6A"],"","",["sandwich"],42,22,15,0],

		"1f96b":[["\uD83E\uDD6B"],"","",["canned_food"],42,23,15,0],

		"1f980":[["\uD83E\uDD80"],"","",["crab"],42,24,15,0],

		"1f981":[["\uD83E\uDD81"],"","",["lion_face"],42,25,15,0],

		"1f982":[["\uD83E\uDD82"],"","",["scorpion"],42,26,15,0],

		"1f983":[["\uD83E\uDD83"],"","",["turkey"],42,27,15,0],

		"1f984":[["\uD83E\uDD84"],"","",["unicorn_face"],42,28,15,0],

		"1f985":[["\uD83E\uDD85"],"","",["eagle"],42,29,15,0],

		"1f986":[["\uD83E\uDD86"],"","",["duck"],42,30,15,0],

		"1f987":[["\uD83E\uDD87"],"","",["bat"],42,31,15,0],

		"1f988":[["\uD83E\uDD88"],"","",["shark"],42,32,15,0],

		"1f989":[["\uD83E\uDD89"],"","",["owl"],42,33,15,0],

		"1f98a":[["\uD83E\uDD8A"],"","",["fox_face"],42,34,15,0],

		"1f98b":[["\uD83E\uDD8B"],"","",["butterfly"],42,35,15,0],

		"1f98c":[["\uD83E\uDD8C"],"","",["deer"],42,36,15,0],

		"1f98d":[["\uD83E\uDD8D"],"","",["gorilla"],42,37,15,0],

		"1f98e":[["\uD83E\uDD8E"],"","",["lizard"],42,38,15,0],

		"1f98f":[["\uD83E\uDD8F"],"","",["rhinoceros"],42,39,15,0],

		"1f990":[["\uD83E\uDD90"],"","",["shrimp"],42,40,15,0],

		"1f991":[["\uD83E\uDD91"],"","",["squid"],42,41,15,0],

		"1f992":[["\uD83E\uDD92"],"","",["giraffe_face"],42,42,15,0],

		"1f993":[["\uD83E\uDD93"],"","",["zebra_face"],42,43,15,0],

		"1f994":[["\uD83E\uDD94"],"","",["hedgehog"],42,44,15,0],

		"1f995":[["\uD83E\uDD95"],"","",["sauropod"],42,45,15,0],

		"1f996":[["\uD83E\uDD96"],"","",["t-rex"],42,46,15,0],

		"1f997":[["\uD83E\uDD97"],"","",["cricket"],42,47,15,0],

		"1f9c0":[["\uD83E\uDDC0"],"","",["cheese_wedge"],42,48,15,0],

		"1f9d0":[["\uD83E\uDDD0"],"","",["face_with_monocle"],42,49,15,0],

		"1f9d1":[["\uD83E\uDDD1"],"","",["adult"],42,50,15,0],

		"1f9d2":[["\uD83E\uDDD2"],"","",["child"],43,4,15,0],

		"1f9d3":[["\uD83E\uDDD3"],"","",["older_adult"],43,10,15,0],

		"1f9d4":[["\uD83E\uDDD4"],"","",["bearded_person"],43,16,15,0],

		"1f9d5":[["\uD83E\uDDD5"],"","",["person_with_headscarf"],43,22,15,0],

		"1f9d6-200d-2640-fe0f":[["\uD83E\uDDD6\u200D\u2640\uFE0F","\uD83E\uDDD6\u200D\u2640"],"","",["woman_in_steamy_room"],43,28,15,0],

		"1f9d6-200d-2642-fe0f":[["\uD83E\uDDD6\u200D\u2642\uFE0F","\uD83E\uDDD6\u200D\u2642","\uD83E\uDDD6"],"","",["man_in_steamy_room","person_in_steamy_room"],43,34,15,0],

		"1f9d7-200d-2640-fe0f":[["\uD83E\uDDD7\u200D\u2640\uFE0F","\uD83E\uDDD7\u200D\u2640","\uD83E\uDDD7"],"","",["woman_climbing","person_climbing"],43,46,15,0],

		"1f9d7-200d-2642-fe0f":[["\uD83E\uDDD7\u200D\u2642\uFE0F","\uD83E\uDDD7\u200D\u2642"],"","",["man_climbing"],44,0,15,0],

		"1f9d8-200d-2640-fe0f":[["\uD83E\uDDD8\u200D\u2640\uFE0F","\uD83E\uDDD8\u200D\u2640","\uD83E\uDDD8"],"","",["woman_in_lotus_position","person_in_lotus_position"],44,12,15,0],

		"1f9d8-200d-2642-fe0f":[["\uD83E\uDDD8\u200D\u2642\uFE0F","\uD83E\uDDD8\u200D\u2642"],"","",["man_in_lotus_position"],44,18,15,0],

		"1f9d9-200d-2640-fe0f":[["\uD83E\uDDD9\u200D\u2640\uFE0F","\uD83E\uDDD9\u200D\u2640","\uD83E\uDDD9"],"","",["female_mage","mage"],44,30,15,0],

		"1f9d9-200d-2642-fe0f":[["\uD83E\uDDD9\u200D\u2642\uFE0F","\uD83E\uDDD9\u200D\u2642"],"","",["male_mage"],44,36,15,0],

		"1f9da-200d-2640-fe0f":[["\uD83E\uDDDA\u200D\u2640\uFE0F","\uD83E\uDDDA\u200D\u2640","\uD83E\uDDDA"],"","",["female_fairy","fairy"],44,48,15,0],

		"1f9da-200d-2642-fe0f":[["\uD83E\uDDDA\u200D\u2642\uFE0F","\uD83E\uDDDA\u200D\u2642"],"","",["male_fairy"],45,2,15,0],

		"1f9db-200d-2640-fe0f":[["\uD83E\uDDDB\u200D\u2640\uFE0F","\uD83E\uDDDB\u200D\u2640","\uD83E\uDDDB"],"","",["female_vampire","vampire"],45,14,15,0],

		"1f9db-200d-2642-fe0f":[["\uD83E\uDDDB\u200D\u2642\uFE0F","\uD83E\uDDDB\u200D\u2642"],"","",["male_vampire"],45,20,15,0],

		"1f9dc-200d-2640-fe0f":[["\uD83E\uDDDC\u200D\u2640\uFE0F","\uD83E\uDDDC\u200D\u2640"],"","",["mermaid"],45,32,15,0],

		"1f9dc-200d-2642-fe0f":[["\uD83E\uDDDC\u200D\u2642\uFE0F","\uD83E\uDDDC\u200D\u2642","\uD83E\uDDDC"],"","",["merman","merperson"],45,38,15,0],

		"1f9dd-200d-2640-fe0f":[["\uD83E\uDDDD\u200D\u2640\uFE0F","\uD83E\uDDDD\u200D\u2640"],"","",["female_elf"],45,50,15,0],

		"1f9dd-200d-2642-fe0f":[["\uD83E\uDDDD\u200D\u2642\uFE0F","\uD83E\uDDDD\u200D\u2642","\uD83E\uDDDD"],"","",["male_elf","elf"],46,4,15,0],

		"1f9de-200d-2640-fe0f":[["\uD83E\uDDDE\u200D\u2640\uFE0F","\uD83E\uDDDE\u200D\u2640"],"","",["female_genie"],46,16,15,0],

		"1f9de-200d-2642-fe0f":[["\uD83E\uDDDE\u200D\u2642\uFE0F","\uD83E\uDDDE\u200D\u2642","\uD83E\uDDDE"],"","",["male_genie","genie"],46,17,15,0],

		"1f9df-200d-2640-fe0f":[["\uD83E\uDDDF\u200D\u2640\uFE0F","\uD83E\uDDDF\u200D\u2640"],"","",["female_zombie"],46,19,15,0],

		"1f9df-200d-2642-fe0f":[["\uD83E\uDDDF\u200D\u2642\uFE0F","\uD83E\uDDDF\u200D\u2642","\uD83E\uDDDF"],"","",["male_zombie","zombie"],46,20,15,0],

		"1f9e0":[["\uD83E\uDDE0"],"","",["brain"],46,22,15,0],

		"1f9e1":[["\uD83E\uDDE1"],"","",["orange_heart"],46,23,15,0],

		"1f9e2":[["\uD83E\uDDE2"],"","",["billed_cap"],46,24,15,0],

		"1f9e3":[["\uD83E\uDDE3"],"","",["scarf"],46,25,15,0],

		"1f9e4":[["\uD83E\uDDE4"],"","",["gloves"],46,26,15,0],

		"1f9e5":[["\uD83E\uDDE5"],"","",["coat"],46,27,15,0],

		"1f9e6":[["\uD83E\uDDE6"],"","",["socks"],46,28,15,0],

		"203c-fe0f":[["\u203C\uFE0F","\u203C"],"","\uDBBA\uDF06",["bangbang"],46,29,31,0],

		"2049-fe0f":[["\u2049\uFE0F","\u2049"],"","\uDBBA\uDF05",["interrobang"],46,30,31,0],

		"2122-fe0f":[["\u2122\uFE0F","\u2122"],"\uE537","\uDBBA\uDF2A",["tm"],46,31,31,0],

		"2139-fe0f":[["\u2139\uFE0F","\u2139"],"","\uDBBA\uDF47",["information_source"],46,32,31,0],

		"2194-fe0f":[["\u2194\uFE0F","\u2194"],"","\uDBBA\uDEF6",["left_right_arrow"],46,33,31,0],

		"2195-fe0f":[["\u2195\uFE0F","\u2195"],"","\uDBBA\uDEF7",["arrow_up_down"],46,34,31,0],

		"2196-fe0f":[["\u2196\uFE0F","\u2196"],"\uE237","\uDBBA\uDEF2",["arrow_upper_left"],46,35,31,0],

		"2197-fe0f":[["\u2197\uFE0F","\u2197"],"\uE236","\uDBBA\uDEF0",["arrow_upper_right"],46,36,31,0],

		"2198-fe0f":[["\u2198\uFE0F","\u2198"],"\uE238","\uDBBA\uDEF1",["arrow_lower_right"],46,37,31,0],

		"2199-fe0f":[["\u2199\uFE0F","\u2199"],"\uE239","\uDBBA\uDEF3",["arrow_lower_left"],46,38,31,0],

		"21a9-fe0f":[["\u21A9\uFE0F","\u21A9"],"","\uDBBA\uDF83",["leftwards_arrow_with_hook"],46,39,31,0],

		"21aa-fe0f":[["\u21AA\uFE0F","\u21AA"],"","\uDBBA\uDF88",["arrow_right_hook"],46,40,31,0],

		"231a":[["\u231A"],"","\uDBB8\uDC1D",["watch"],46,41,31,0],

		"231b":[["\u231B"],"","\uDBB8\uDC1C",["hourglass"],46,42,31,0],

		"2328-fe0f":[["\u2328\uFE0F","\u2328"],"","",["keyboard"],46,43,15,0],

		"23cf-fe0f":[["\u23CF\uFE0F","\u23CF"],"","",["eject"],46,44,15,0],

		"23e9":[["\u23E9"],"\uE23C","\uDBBA\uDEFE",["fast_forward"],46,45,31,0],

		"23ea":[["\u23EA"],"\uE23D","\uDBBA\uDEFF",["rewind"],46,46,31,0],

		"23eb":[["\u23EB"],"","\uDBBA\uDF03",["arrow_double_up"],46,47,31,0],

		"23ec":[["\u23EC"],"","\uDBBA\uDF02",["arrow_double_down"],46,48,31,0],

		"23ed-fe0f":[["\u23ED\uFE0F","\u23ED"],"","",["black_right_pointing_double_triangle_with_vertical_bar"],46,49,15,0],

		"23ee-fe0f":[["\u23EE\uFE0F","\u23EE"],"","",["black_left_pointing_double_triangle_with_vertical_bar"],46,50,15,0],

		"23ef-fe0f":[["\u23EF\uFE0F","\u23EF"],"","",["black_right_pointing_triangle_with_double_vertical_bar"],46,51,15,0],

		"23f0":[["\u23F0"],"","\uDBB8\uDC2A",["alarm_clock"],47,0,31,0],

		"23f1-fe0f":[["\u23F1\uFE0F","\u23F1"],"","",["stopwatch"],47,1,15,0],

		"23f2-fe0f":[["\u23F2\uFE0F","\u23F2"],"","",["timer_clock"],47,2,15,0],

		"23f3":[["\u23F3"],"","\uDBB8\uDC1B",["hourglass_flowing_sand"],47,3,31,0],

		"23f8-fe0f":[["\u23F8\uFE0F","\u23F8"],"","",["double_vertical_bar"],47,4,15,0],

		"23f9-fe0f":[["\u23F9\uFE0F","\u23F9"],"","",["black_square_for_stop"],47,5,15,0],

		"23fa-fe0f":[["\u23FA\uFE0F","\u23FA"],"","",["black_circle_for_record"],47,6,15,0],

		"24c2-fe0f":[["\u24C2\uFE0F","\u24C2"],"","\uDBB9\uDFE1",["m"],47,7,31,0],

		"25aa-fe0f":[["\u25AA\uFE0F","\u25AA"],"","\uDBBA\uDF6E",["black_small_square"],47,8,31,0],

		"25ab-fe0f":[["\u25AB\uFE0F","\u25AB"],"","\uDBBA\uDF6D",["white_small_square"],47,9,31,0],

		"25b6-fe0f":[["\u25B6\uFE0F","\u25B6"],"\uE23A","\uDBBA\uDEFC",["arrow_forward"],47,10,31,0],

		"25c0-fe0f":[["\u25C0\uFE0F","\u25C0"],"\uE23B","\uDBBA\uDEFD",["arrow_backward"],47,11,31,0],

		"25fb-fe0f":[["\u25FB\uFE0F","\u25FB"],"","\uDBBA\uDF71",["white_medium_square"],47,12,31,0],

		"25fc-fe0f":[["\u25FC\uFE0F","\u25FC"],"","\uDBBA\uDF72",["black_medium_square"],47,13,31,0],

		"25fd":[["\u25FD"],"","\uDBBA\uDF6F",["white_medium_small_square"],47,14,31,0],

		"25fe":[["\u25FE"],"","\uDBBA\uDF70",["black_medium_small_square"],47,15,31,0],

		"2600-fe0f":[["\u2600\uFE0F","\u2600"],"\uE04A","\uDBB8\uDC00",["sunny"],47,16,31,0],

		"2601-fe0f":[["\u2601\uFE0F","\u2601"],"\uE049","\uDBB8\uDC01",["cloud"],47,17,31,0],

		"2602-fe0f":[["\u2602\uFE0F","\u2602"],"","",["umbrella"],47,18,15,0],

		"2603-fe0f":[["\u2603\uFE0F","\u2603"],"","",["snowman"],47,19,15,0],

		"2604-fe0f":[["\u2604\uFE0F","\u2604"],"","",["comet"],47,20,15,0],

		"260e-fe0f":[["\u260E\uFE0F","\u260E"],"\uE009","\uDBB9\uDD23",["phone","telephone"],47,21,31,0],

		"2611-fe0f":[["\u2611\uFE0F","\u2611"],"","\uDBBA\uDF8B",["ballot_box_with_check"],47,22,31,0],

		"2614":[["\u2614"],"\uE04B","\uDBB8\uDC02",["umbrella_with_rain_drops"],47,23,31,0],

		"2615":[["\u2615"],"\uE045","\uDBBA\uDD81",["coffee"],47,24,31,0],

		"2618-fe0f":[["\u2618\uFE0F","\u2618"],"","",["shamrock"],47,25,15,0],

		"261d-fe0f":[["\u261D\uFE0F","\u261D"],"\uE00F","\uDBBA\uDF98",["point_up"],47,26,31,0],

		"2620-fe0f":[["\u2620\uFE0F","\u2620"],"","",["skull_and_crossbones"],47,32,15,0],

		"2622-fe0f":[["\u2622\uFE0F","\u2622"],"","",["radioactive_sign"],47,33,15,0],

		"2623-fe0f":[["\u2623\uFE0F","\u2623"],"","",["biohazard_sign"],47,34,15,0],

		"2626-fe0f":[["\u2626\uFE0F","\u2626"],"","",["orthodox_cross"],47,35,15,0],

		"262a-fe0f":[["\u262A\uFE0F","\u262A"],"","",["star_and_crescent"],47,36,15,0],

		"262e-fe0f":[["\u262E\uFE0F","\u262E"],"","",["peace_symbol"],47,37,15,0],

		"262f-fe0f":[["\u262F\uFE0F","\u262F"],"","",["yin_yang"],47,38,15,0],

		"2638-fe0f":[["\u2638\uFE0F","\u2638"],"","",["wheel_of_dharma"],47,39,15,0],

		"2639-fe0f":[["\u2639\uFE0F","\u2639"],"","",["white_frowning_face"],47,40,15,0],

		"263a-fe0f":[["\u263A\uFE0F","\u263A"],"\uE414","\uDBB8\uDF36",["relaxed"],47,41,31,0],

		"2640-fe0f":[["\u2640\uFE0F","\u2640"],"","",["female_sign"],47,42,14,0],

		"2642-fe0f":[["\u2642\uFE0F","\u2642"],"","",["male_sign"],47,43,14,0],

		"2648":[["\u2648"],"\uE23F","\uDBB8\uDC2B",["aries"],47,44,31,0],

		"2649":[["\u2649"],"\uE240","\uDBB8\uDC2C",["taurus"],47,45,31,0],

		"264a":[["\u264A"],"\uE241","\uDBB8\uDC2D",["gemini"],47,46,31,0],

		"264b":[["\u264B"],"\uE242","\uDBB8\uDC2E",["cancer"],47,47,31,0],

		"264c":[["\u264C"],"\uE243","\uDBB8\uDC2F",["leo"],47,48,31,0],

		"264d":[["\u264D"],"\uE244","\uDBB8\uDC30",["virgo"],47,49,31,0],

		"264e":[["\u264E"],"\uE245","\uDBB8\uDC31",["libra"],47,50,31,0],

		"264f":[["\u264F"],"\uE246","\uDBB8\uDC32",["scorpius"],47,51,31,0],

		"2650":[["\u2650"],"\uE247","\uDBB8\uDC33",["sagittarius"],48,0,31,0],

		"2651":[["\u2651"],"\uE248","\uDBB8\uDC34",["capricorn"],48,1,31,0],

		"2652":[["\u2652"],"\uE249","\uDBB8\uDC35",["aquarius"],48,2,31,0],

		"2653":[["\u2653"],"\uE24A","\uDBB8\uDC36",["pisces"],48,3,31,0],

		"2660-fe0f":[["\u2660\uFE0F","\u2660"],"\uE20E","\uDBBA\uDF1B",["spades"],48,4,31,0],

		"2663-fe0f":[["\u2663\uFE0F","\u2663"],"\uE20F","\uDBBA\uDF1D",["clubs"],48,5,31,0],

		"2665-fe0f":[["\u2665\uFE0F","\u2665"],"\uE20C","\uDBBA\uDF1A",["hearts"],48,6,31,0],

		"2666-fe0f":[["\u2666\uFE0F","\u2666"],"\uE20D","\uDBBA\uDF1C",["diamonds"],48,7,31,0],

		"2668-fe0f":[["\u2668\uFE0F","\u2668"],"\uE123","\uDBB9\uDFFA",["hotsprings"],48,8,31,0],

		"267b-fe0f":[["\u267B\uFE0F","\u267B"],"","\uDBBA\uDF2C",["recycle"],48,9,31,0],

		"267f":[["\u267F"],"\uE20A","\uDBBA\uDF20",["wheelchair"],48,10,31,0],

		"2692-fe0f":[["\u2692\uFE0F","\u2692"],"","",["hammer_and_pick"],48,11,15,0],

		"2693":[["\u2693"],"","\uDBB9\uDCC1",["anchor"],48,12,31,0],

		"2694-fe0f":[["\u2694\uFE0F","\u2694"],"","",["crossed_swords"],48,13,15,0],

		"2695-fe0f":[["\u2695\uFE0F","\u2695"],"","",["medical_symbol","staff_of_aesculapius"],48,14,14,0],

		"2696-fe0f":[["\u2696\uFE0F","\u2696"],"","",["scales"],48,15,15,0],

		"2697-fe0f":[["\u2697\uFE0F","\u2697"],"","",["alembic"],48,16,15,0],

		"2699-fe0f":[["\u2699\uFE0F","\u2699"],"","",["gear"],48,17,15,0],

		"269b-fe0f":[["\u269B\uFE0F","\u269B"],"","",["atom_symbol"],48,18,15,0],

		"269c-fe0f":[["\u269C\uFE0F","\u269C"],"","",["fleur_de_lis"],48,19,15,0],

		"26a0-fe0f":[["\u26A0\uFE0F","\u26A0"],"\uE252","\uDBBA\uDF23",["warning"],48,20,31,0],

		"26a1":[["\u26A1"],"\uE13D","\uDBB8\uDC04",["zap"],48,21,31,0],

		"26aa":[["\u26AA"],"","\uDBBA\uDF65",["white_circle"],48,22,31,0],

		"26ab":[["\u26AB"],"","\uDBBA\uDF66",["black_circle"],48,23,31,0],

		"26b0-fe0f":[["\u26B0\uFE0F","\u26B0"],"","",["coffin"],48,24,15,0],

		"26b1-fe0f":[["\u26B1\uFE0F","\u26B1"],"","",["funeral_urn"],48,25,15,0],

		"26bd":[["\u26BD"],"\uE018","\uDBB9\uDFD4",["soccer"],48,26,31,0],

		"26be":[["\u26BE"],"\uE016","\uDBB9\uDFD1",["baseball"],48,27,31,0],

		"26c4":[["\u26C4"],"\uE048","\uDBB8\uDC03",["snowman_without_snow"],48,28,31,0],

		"26c5":[["\u26C5"],"","\uDBB8\uDC0F",["partly_sunny"],48,29,31,0],

		"26c8-fe0f":[["\u26C8\uFE0F","\u26C8"],"","",["thunder_cloud_and_rain"],48,30,15,0],

		"26ce":[["\u26CE"],"\uE24B","\uDBB8\uDC37",["ophiuchus"],48,31,31,0],

		"26cf-fe0f":[["\u26CF\uFE0F","\u26CF"],"","",["pick"],48,32,15,0],

		"26d1-fe0f":[["\u26D1\uFE0F","\u26D1"],"","",["helmet_with_white_cross"],48,33,15,0],

		"26d3-fe0f":[["\u26D3\uFE0F","\u26D3"],"","",["chains"],48,34,15,0],

		"26d4":[["\u26D4"],"","\uDBBA\uDF26",["no_entry"],48,35,31,0],

		"26e9-fe0f":[["\u26E9\uFE0F","\u26E9"],"","",["shinto_shrine"],48,36,15,0],

		"26ea":[["\u26EA"],"\uE037","\uDBB9\uDCBB",["church"],48,37,31,0],

		"26f0-fe0f":[["\u26F0\uFE0F","\u26F0"],"","",["mountain"],48,38,15,0],

		"26f1-fe0f":[["\u26F1\uFE0F","\u26F1"],"","",["umbrella_on_ground"],48,39,15,0],

		"26f2":[["\u26F2"],"\uE121","\uDBB9\uDCBC",["fountain"],48,40,31,0],

		"26f3":[["\u26F3"],"\uE014","\uDBB9\uDFD2",["golf"],48,41,31,0],

		"26f4-fe0f":[["\u26F4\uFE0F","\u26F4"],"","",["ferry"],48,42,15,0],

		"26f5":[["\u26F5"],"\uE01C","\uDBB9\uDFEA",["boat","sailboat"],48,43,31,0],

		"26f7-fe0f":[["\u26F7\uFE0F","\u26F7"],"","",["skier"],48,44,15,0],

		"26f8-fe0f":[["\u26F8\uFE0F","\u26F8"],"","",["ice_skate"],48,45,15,0],

		"26f9-fe0f-200d-2640-fe0f":[["\u26F9\uFE0F\u200D\u2640\uFE0F"],"","",["woman-bouncing-ball"],48,46,7,0],

		"26f9-fe0f-200d-2642-fe0f":[["\u26F9\uFE0F\u200D\u2642\uFE0F","\u26F9\uFE0F","\u26F9"],"","",["man-bouncing-ball","person_with_ball"],49,0,7,0],

		"26fa":[["\u26FA"],"\uE122","\uDBB9\uDFFB",["tent"],49,12,31,0],

		"26fd":[["\u26FD"],"\uE03A","\uDBB9\uDFF5",["fuelpump"],49,13,31,0],

		"2702-fe0f":[["\u2702\uFE0F","\u2702"],"\uE313","\uDBB9\uDD3E",["scissors"],49,14,31,0],

		"2705":[["\u2705"],"","\uDBBA\uDF4A",["white_check_mark"],49,15,31,0],

		"2708-fe0f":[["\u2708\uFE0F","\u2708"],"\uE01D","\uDBB9\uDFE9",["airplane"],49,16,31,0],

		"2709-fe0f":[["\u2709\uFE0F","\u2709"],"","\uDBB9\uDD29",["email","envelope"],49,17,31,0],

		"270a":[["\u270A"],"\uE010","\uDBBA\uDF93",["fist"],49,18,31,0],

		"270b":[["\u270B"],"\uE012","\uDBBA\uDF95",["hand","raised_hand"],49,24,31,0],

		"270c-fe0f":[["\u270C\uFE0F","\u270C"],"\uE011","\uDBBA\uDF94",["v"],49,30,31,0],

		"270d-fe0f":[["\u270D\uFE0F","\u270D"],"","",["writing_hand"],49,36,15,0],

		"270f-fe0f":[["\u270F\uFE0F","\u270F"],"","\uDBB9\uDD39",["pencil2"],49,42,31,0],

		"2712-fe0f":[["\u2712\uFE0F","\u2712"],"","\uDBB9\uDD36",["black_nib"],49,43,31,0],

		"2714-fe0f":[["\u2714\uFE0F","\u2714"],"","\uDBBA\uDF49",["heavy_check_mark"],49,44,31,0],

		"2716-fe0f":[["\u2716\uFE0F","\u2716"],"","\uDBBA\uDF53",["heavy_multiplication_x"],49,45,31,0],

		"271d-fe0f":[["\u271D\uFE0F","\u271D"],"","",["latin_cross"],49,46,15,0],

		"2721-fe0f":[["\u2721\uFE0F","\u2721"],"","",["star_of_david"],49,47,15,0],

		"2728":[["\u2728"],"\uE32E","\uDBBA\uDF60",["sparkles"],49,48,31,0],

		"2733-fe0f":[["\u2733\uFE0F","\u2733"],"\uE206","\uDBBA\uDF62",["eight_spoked_asterisk"],49,49,31,0],

		"2734-fe0f":[["\u2734\uFE0F","\u2734"],"\uE205","\uDBBA\uDF61",["eight_pointed_black_star"],49,50,31,0],

		"2744-fe0f":[["\u2744\uFE0F","\u2744"],"","\uDBB8\uDC0E",["snowflake"],49,51,31,0],

		"2747-fe0f":[["\u2747\uFE0F","\u2747"],"","\uDBBA\uDF77",["sparkle"],50,0,31,0],

		"274c":[["\u274C"],"\uE333","\uDBBA\uDF45",["x"],50,1,31,0],

		"274e":[["\u274E"],"","\uDBBA\uDF46",["negative_squared_cross_mark"],50,2,31,0],

		"2753":[["\u2753"],"\uE020","\uDBBA\uDF09",["question"],50,3,31,0],

		"2754":[["\u2754"],"\uE336","\uDBBA\uDF0A",["grey_question"],50,4,31,0],

		"2755":[["\u2755"],"\uE337","\uDBBA\uDF0B",["grey_exclamation"],50,5,31,0],

		"2757":[["\u2757"],"\uE021","\uDBBA\uDF04",["exclamation","heavy_exclamation_mark"],50,6,31,0],

		"2763-fe0f":[["\u2763\uFE0F","\u2763"],"","",["heavy_heart_exclamation_mark_ornament"],50,7,15,0],

		"2764-fe0f":[["\u2764\uFE0F","\u2764"],"\uE022","\uDBBA\uDF0C",["heart"],50,8,31,0,"<3"],

		"2795":[["\u2795"],"","\uDBBA\uDF51",["heavy_plus_sign"],50,9,31,0],

		"2796":[["\u2796"],"","\uDBBA\uDF52",["heavy_minus_sign"],50,10,31,0],

		"2797":[["\u2797"],"","\uDBBA\uDF54",["heavy_division_sign"],50,11,31,0],

		"27a1-fe0f":[["\u27A1\uFE0F","\u27A1"],"\uE234","\uDBBA\uDEFA",["arrow_right"],50,12,31,0],

		"27b0":[["\u27B0"],"","\uDBBA\uDF08",["curly_loop"],50,13,31,0],

		"27bf":[["\u27BF"],"\uE211","\uDBBA\uDC2B",["loop"],50,14,31,0],

		"2934-fe0f":[["\u2934\uFE0F","\u2934"],"","\uDBBA\uDEF4",["arrow_heading_up"],50,15,31,0],

		"2935-fe0f":[["\u2935\uFE0F","\u2935"],"","\uDBBA\uDEF5",["arrow_heading_down"],50,16,31,0],

		"2b05-fe0f":[["\u2B05\uFE0F","\u2B05"],"\uE235","\uDBBA\uDEFB",["arrow_left"],50,17,31,0],

		"2b06-fe0f":[["\u2B06\uFE0F","\u2B06"],"\uE232","\uDBBA\uDEF8",["arrow_up"],50,18,31,0],

		"2b07-fe0f":[["\u2B07\uFE0F","\u2B07"],"\uE233","\uDBBA\uDEF9",["arrow_down"],50,19,31,0],

		"2b1b":[["\u2B1B"],"","\uDBBA\uDF6C",["black_large_square"],50,20,31,0],

		"2b1c":[["\u2B1C"],"","\uDBBA\uDF6B",["white_large_square"],50,21,31,0],

		"2b50":[["\u2B50"],"\uE32F","\uDBBA\uDF68",["star"],50,22,31,0],

		"2b55":[["\u2B55"],"\uE332","\uDBBA\uDF44",["o"],50,23,31,0],

		"3030-fe0f":[["\u3030\uFE0F","\u3030"],"","\uDBBA\uDF07",["wavy_dash"],50,24,31,0],

		"303d-fe0f":[["\u303D\uFE0F","\u303D"],"\uE12C","\uDBBA\uDC1B",["part_alternation_mark"],50,25,31,0],

		"3297-fe0f":[["\u3297\uFE0F","\u3297"],"\uE30D","\uDBBA\uDF43",["congratulations"],50,26,31,0],

		"3299-fe0f":[["\u3299\uFE0F","\u3299"],"\uE315","\uDBBA\uDF2B",["secret"],50,27,31,0]

	};

	/** @private */

	emoji.prototype.emoticons_data = {

		":o)":"monkey_face",

		"<\/3":"broken_heart",

		"=)":"smiley",

		"=-)":"smiley",

		"C:":"smile",

		"c:":"smile",

		":D":"smile",

		":-D":"smile",

		":>":"laughing",

		":->":"laughing",

		";)":"wink",

		";-)":"wink",

		"8)":"sunglasses",

		":|":"neutral_face",

		":-|":"neutral_face",

		":\\":"confused",

		":-\\":"confused",

		":\/":"confused",

		":-\/":"confused",

		":*":"kissing_heart",

		":-*":"kissing_heart",

		":p":"stuck_out_tongue",

		":-p":"stuck_out_tongue",

		":P":"stuck_out_tongue",

		":-P":"stuck_out_tongue",

		":b":"stuck_out_tongue",

		":-b":"stuck_out_tongue",

		";p":"stuck_out_tongue_winking_eye",

		";-p":"stuck_out_tongue_winking_eye",

		";b":"stuck_out_tongue_winking_eye",

		";-b":"stuck_out_tongue_winking_eye",

		";P":"stuck_out_tongue_winking_eye",

		";-P":"stuck_out_tongue_winking_eye",

		"):":"disappointed",

		":(":"disappointed",

		":-(":"disappointed",

		">:(":"angry",

		">:-(":"angry",

		":'(":"cry",

		"D:":"anguished",

		":o":"open_mouth",

		":-o":"open_mouth",

		":O":"open_mouth",

		":-O":"open_mouth",

		":)":"slightly_smiling_face",

		"(:":"slightly_smiling_face",

		":-)":"slightly_smiling_face",

		"<3":"heart"

	};

	/** @private */

	emoji.prototype.variations_data = {

		"1f385":{"1f3fb":["1f385-1f3fb",8,20,31,["\uD83C\uDF85\uD83C\uDFFB"]],"1f3fc":["1f385-1f3fc",8,21,31,["\uD83C\uDF85\uD83C\uDFFC"]],"1f3fd":["1f385-1f3fd",8,22,31,["\uD83C\uDF85\uD83C\uDFFD"]],"1f3fe":["1f385-1f3fe",8,23,31,["\uD83C\uDF85\uD83C\uDFFE"]],"1f3ff":["1f385-1f3ff",8,24,31,["\uD83C\uDF85\uD83C\uDFFF"]]},

		"1f3c2":{"1f3fb":["1f3c2-1f3fb",9,29,31,["\uD83C\uDFC2\uD83C\uDFFB"]],"1f3fc":["1f3c2-1f3fc",9,30,31,["\uD83C\uDFC2\uD83C\uDFFC"]],"1f3fd":["1f3c2-1f3fd",9,31,31,["\uD83C\uDFC2\uD83C\uDFFD"]],"1f3fe":["1f3c2-1f3fe",9,32,31,["\uD83C\uDFC2\uD83C\uDFFE"]],"1f3ff":["1f3c2-1f3ff",9,33,31,["\uD83C\uDFC2\uD83C\uDFFF"]]},

		"1f3c3-200d-2640-fe0f":{"1f3fb":["1f3c3-1f3fb-200d-2640-fe0f",9,35,7,["\uD83C\uDFC3\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f3c3-1f3fc-200d-2640-fe0f",9,36,7,["\uD83C\uDFC3\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f3c3-1f3fd-200d-2640-fe0f",9,37,7,["\uD83C\uDFC3\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f3c3-1f3fe-200d-2640-fe0f",9,38,7,["\uD83C\uDFC3\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f3c3-1f3ff-200d-2640-fe0f",9,39,7,["\uD83C\uDFC3\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f3c3-200d-2642-fe0f":{"1f3fb":["1f3c3-1f3fb-200d-2642-fe0f",9,41,7,["\uD83C\uDFC3\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83C\uDFC3\uD83C\uDFFB"]],"1f3fc":["1f3c3-1f3fc-200d-2642-fe0f",9,42,7,["\uD83C\uDFC3\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83C\uDFC3\uD83C\uDFFC"]],"1f3fd":["1f3c3-1f3fd-200d-2642-fe0f",9,43,7,["\uD83C\uDFC3\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83C\uDFC3\uD83C\uDFFD"]],"1f3fe":["1f3c3-1f3fe-200d-2642-fe0f",9,44,7,["\uD83C\uDFC3\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83C\uDFC3\uD83C\uDFFE"]],"1f3ff":["1f3c3-1f3ff-200d-2642-fe0f",9,45,7,["\uD83C\uDFC3\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83C\uDFC3\uD83C\uDFFF"]]},

		"1f3c4-200d-2640-fe0f":{"1f3fb":["1f3c4-1f3fb-200d-2640-fe0f",10,1,7,["\uD83C\uDFC4\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f3c4-1f3fc-200d-2640-fe0f",10,2,7,["\uD83C\uDFC4\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f3c4-1f3fd-200d-2640-fe0f",10,3,7,["\uD83C\uDFC4\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f3c4-1f3fe-200d-2640-fe0f",10,4,7,["\uD83C\uDFC4\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f3c4-1f3ff-200d-2640-fe0f",10,5,7,["\uD83C\uDFC4\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f3c4-200d-2642-fe0f":{"1f3fb":["1f3c4-1f3fb-200d-2642-fe0f",10,7,7,["\uD83C\uDFC4\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83C\uDFC4\uD83C\uDFFB"]],"1f3fc":["1f3c4-1f3fc-200d-2642-fe0f",10,8,7,["\uD83C\uDFC4\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83C\uDFC4\uD83C\uDFFC"]],"1f3fd":["1f3c4-1f3fd-200d-2642-fe0f",10,9,7,["\uD83C\uDFC4\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83C\uDFC4\uD83C\uDFFD"]],"1f3fe":["1f3c4-1f3fe-200d-2642-fe0f",10,10,7,["\uD83C\uDFC4\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83C\uDFC4\uD83C\uDFFE"]],"1f3ff":["1f3c4-1f3ff-200d-2642-fe0f",10,11,7,["\uD83C\uDFC4\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83C\uDFC4\uD83C\uDFFF"]]},

		"1f3c7":{"1f3fb":["1f3c7-1f3fb",10,21,31,["\uD83C\uDFC7\uD83C\uDFFB"]],"1f3fc":["1f3c7-1f3fc",10,22,31,["\uD83C\uDFC7\uD83C\uDFFC"]],"1f3fd":["1f3c7-1f3fd",10,23,31,["\uD83C\uDFC7\uD83C\uDFFD"]],"1f3fe":["1f3c7-1f3fe",10,24,31,["\uD83C\uDFC7\uD83C\uDFFE"]],"1f3ff":["1f3c7-1f3ff",10,25,31,["\uD83C\uDFC7\uD83C\uDFFF"]]},

		"1f3ca-200d-2640-fe0f":{"1f3fb":["1f3ca-1f3fb-200d-2640-fe0f",10,29,7,["\uD83C\uDFCA\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f3ca-1f3fc-200d-2640-fe0f",10,30,7,["\uD83C\uDFCA\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f3ca-1f3fd-200d-2640-fe0f",10,31,7,["\uD83C\uDFCA\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f3ca-1f3fe-200d-2640-fe0f",10,32,7,["\uD83C\uDFCA\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f3ca-1f3ff-200d-2640-fe0f",10,33,7,["\uD83C\uDFCA\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f3ca-200d-2642-fe0f":{"1f3fb":["1f3ca-1f3fb-200d-2642-fe0f",10,35,7,["\uD83C\uDFCA\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83C\uDFCA\uD83C\uDFFB"]],"1f3fc":["1f3ca-1f3fc-200d-2642-fe0f",10,36,7,["\uD83C\uDFCA\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83C\uDFCA\uD83C\uDFFC"]],"1f3fd":["1f3ca-1f3fd-200d-2642-fe0f",10,37,7,["\uD83C\uDFCA\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83C\uDFCA\uD83C\uDFFD"]],"1f3fe":["1f3ca-1f3fe-200d-2642-fe0f",10,38,7,["\uD83C\uDFCA\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83C\uDFCA\uD83C\uDFFE"]],"1f3ff":["1f3ca-1f3ff-200d-2642-fe0f",10,39,7,["\uD83C\uDFCA\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83C\uDFCA\uD83C\uDFFF"]]},

		"1f3cb-fe0f-200d-2640-fe0f":{"1f3fb":["1f3cb-1f3fb-200d-2640-fe0f",10,47,7,["\uD83C\uDFCB\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f3cb-1f3fc-200d-2640-fe0f",10,48,7,["\uD83C\uDFCB\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f3cb-1f3fd-200d-2640-fe0f",10,49,7,["\uD83C\uDFCB\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f3cb-1f3fe-200d-2640-fe0f",10,50,7,["\uD83C\uDFCB\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f3cb-1f3ff-200d-2640-fe0f",10,51,7,["\uD83C\uDFCB\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f3cb-fe0f-200d-2642-fe0f":{"1f3fb":["1f3cb-1f3fb-200d-2642-fe0f",11,1,7,["\uD83C\uDFCB\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83C\uDFCB\uD83C\uDFFB"]],"1f3fc":["1f3cb-1f3fc-200d-2642-fe0f",11,2,7,["\uD83C\uDFCB\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83C\uDFCB\uD83C\uDFFC"]],"1f3fd":["1f3cb-1f3fd-200d-2642-fe0f",11,3,7,["\uD83C\uDFCB\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83C\uDFCB\uD83C\uDFFD"]],"1f3fe":["1f3cb-1f3fe-200d-2642-fe0f",11,4,7,["\uD83C\uDFCB\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83C\uDFCB\uD83C\uDFFE"]],"1f3ff":["1f3cb-1f3ff-200d-2642-fe0f",11,5,7,["\uD83C\uDFCB\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83C\uDFCB\uD83C\uDFFF"]]},

		"1f3cc-fe0f-200d-2640-fe0f":{"1f3fb":["1f3cc-1f3fb-200d-2640-fe0f",11,13,7,["\uD83C\uDFCC\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f3cc-1f3fc-200d-2640-fe0f",11,14,7,["\uD83C\uDFCC\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f3cc-1f3fd-200d-2640-fe0f",11,15,7,["\uD83C\uDFCC\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f3cc-1f3fe-200d-2640-fe0f",11,16,7,["\uD83C\uDFCC\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f3cc-1f3ff-200d-2640-fe0f",11,17,7,["\uD83C\uDFCC\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f3cc-fe0f-200d-2642-fe0f":{"1f3fb":["1f3cc-1f3fb-200d-2642-fe0f",11,19,7,["\uD83C\uDFCC\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83C\uDFCC\uD83C\uDFFB"]],"1f3fc":["1f3cc-1f3fc-200d-2642-fe0f",11,20,7,["\uD83C\uDFCC\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83C\uDFCC\uD83C\uDFFC"]],"1f3fd":["1f3cc-1f3fd-200d-2642-fe0f",11,21,7,["\uD83C\uDFCC\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83C\uDFCC\uD83C\uDFFD"]],"1f3fe":["1f3cc-1f3fe-200d-2642-fe0f",11,22,7,["\uD83C\uDFCC\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83C\uDFCC\uD83C\uDFFE"]],"1f3ff":["1f3cc-1f3ff-200d-2642-fe0f",11,23,7,["\uD83C\uDFCC\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83C\uDFCC\uD83C\uDFFF"]]},

		"1f442":{"1f3fb":["1f442-1f3fb",13,46,31,["\uD83D\uDC42\uD83C\uDFFB"]],"1f3fc":["1f442-1f3fc",13,47,31,["\uD83D\uDC42\uD83C\uDFFC"]],"1f3fd":["1f442-1f3fd",13,48,31,["\uD83D\uDC42\uD83C\uDFFD"]],"1f3fe":["1f442-1f3fe",13,49,31,["\uD83D\uDC42\uD83C\uDFFE"]],"1f3ff":["1f442-1f3ff",13,50,31,["\uD83D\uDC42\uD83C\uDFFF"]]},

		"1f443":{"1f3fb":["1f443-1f3fb",14,0,31,["\uD83D\uDC43\uD83C\uDFFB"]],"1f3fc":["1f443-1f3fc",14,1,31,["\uD83D\uDC43\uD83C\uDFFC"]],"1f3fd":["1f443-1f3fd",14,2,31,["\uD83D\uDC43\uD83C\uDFFD"]],"1f3fe":["1f443-1f3fe",14,3,31,["\uD83D\uDC43\uD83C\uDFFE"]],"1f3ff":["1f443-1f3ff",14,4,31,["\uD83D\uDC43\uD83C\uDFFF"]]},

		"1f446":{"1f3fb":["1f446-1f3fb",14,8,31,["\uD83D\uDC46\uD83C\uDFFB"]],"1f3fc":["1f446-1f3fc",14,9,31,["\uD83D\uDC46\uD83C\uDFFC"]],"1f3fd":["1f446-1f3fd",14,10,31,["\uD83D\uDC46\uD83C\uDFFD"]],"1f3fe":["1f446-1f3fe",14,11,31,["\uD83D\uDC46\uD83C\uDFFE"]],"1f3ff":["1f446-1f3ff",14,12,31,["\uD83D\uDC46\uD83C\uDFFF"]]},

		"1f447":{"1f3fb":["1f447-1f3fb",14,14,31,["\uD83D\uDC47\uD83C\uDFFB"]],"1f3fc":["1f447-1f3fc",14,15,31,["\uD83D\uDC47\uD83C\uDFFC"]],"1f3fd":["1f447-1f3fd",14,16,31,["\uD83D\uDC47\uD83C\uDFFD"]],"1f3fe":["1f447-1f3fe",14,17,31,["\uD83D\uDC47\uD83C\uDFFE"]],"1f3ff":["1f447-1f3ff",14,18,31,["\uD83D\uDC47\uD83C\uDFFF"]]},

		"1f448":{"1f3fb":["1f448-1f3fb",14,20,31,["\uD83D\uDC48\uD83C\uDFFB"]],"1f3fc":["1f448-1f3fc",14,21,31,["\uD83D\uDC48\uD83C\uDFFC"]],"1f3fd":["1f448-1f3fd",14,22,31,["\uD83D\uDC48\uD83C\uDFFD"]],"1f3fe":["1f448-1f3fe",14,23,31,["\uD83D\uDC48\uD83C\uDFFE"]],"1f3ff":["1f448-1f3ff",14,24,31,["\uD83D\uDC48\uD83C\uDFFF"]]},

		"1f449":{"1f3fb":["1f449-1f3fb",14,26,31,["\uD83D\uDC49\uD83C\uDFFB"]],"1f3fc":["1f449-1f3fc",14,27,31,["\uD83D\uDC49\uD83C\uDFFC"]],"1f3fd":["1f449-1f3fd",14,28,31,["\uD83D\uDC49\uD83C\uDFFD"]],"1f3fe":["1f449-1f3fe",14,29,31,["\uD83D\uDC49\uD83C\uDFFE"]],"1f3ff":["1f449-1f3ff",14,30,31,["\uD83D\uDC49\uD83C\uDFFF"]]},

		"1f44a":{"1f3fb":["1f44a-1f3fb",14,32,31,["\uD83D\uDC4A\uD83C\uDFFB"]],"1f3fc":["1f44a-1f3fc",14,33,31,["\uD83D\uDC4A\uD83C\uDFFC"]],"1f3fd":["1f44a-1f3fd",14,34,31,["\uD83D\uDC4A\uD83C\uDFFD"]],"1f3fe":["1f44a-1f3fe",14,35,31,["\uD83D\uDC4A\uD83C\uDFFE"]],"1f3ff":["1f44a-1f3ff",14,36,31,["\uD83D\uDC4A\uD83C\uDFFF"]]},

		"1f44b":{"1f3fb":["1f44b-1f3fb",14,38,31,["\uD83D\uDC4B\uD83C\uDFFB"]],"1f3fc":["1f44b-1f3fc",14,39,31,["\uD83D\uDC4B\uD83C\uDFFC"]],"1f3fd":["1f44b-1f3fd",14,40,31,["\uD83D\uDC4B\uD83C\uDFFD"]],"1f3fe":["1f44b-1f3fe",14,41,31,["\uD83D\uDC4B\uD83C\uDFFE"]],"1f3ff":["1f44b-1f3ff",14,42,31,["\uD83D\uDC4B\uD83C\uDFFF"]]},

		"1f44c":{"1f3fb":["1f44c-1f3fb",14,44,31,["\uD83D\uDC4C\uD83C\uDFFB"]],"1f3fc":["1f44c-1f3fc",14,45,31,["\uD83D\uDC4C\uD83C\uDFFC"]],"1f3fd":["1f44c-1f3fd",14,46,31,["\uD83D\uDC4C\uD83C\uDFFD"]],"1f3fe":["1f44c-1f3fe",14,47,31,["\uD83D\uDC4C\uD83C\uDFFE"]],"1f3ff":["1f44c-1f3ff",14,48,31,["\uD83D\uDC4C\uD83C\uDFFF"]]},

		"1f44d":{"1f3fb":["1f44d-1f3fb",14,50,31,["\uD83D\uDC4D\uD83C\uDFFB"]],"1f3fc":["1f44d-1f3fc",14,51,31,["\uD83D\uDC4D\uD83C\uDFFC"]],"1f3fd":["1f44d-1f3fd",15,0,31,["\uD83D\uDC4D\uD83C\uDFFD"]],"1f3fe":["1f44d-1f3fe",15,1,31,["\uD83D\uDC4D\uD83C\uDFFE"]],"1f3ff":["1f44d-1f3ff",15,2,31,["\uD83D\uDC4D\uD83C\uDFFF"]]},

		"1f44e":{"1f3fb":["1f44e-1f3fb",15,4,31,["\uD83D\uDC4E\uD83C\uDFFB"]],"1f3fc":["1f44e-1f3fc",15,5,31,["\uD83D\uDC4E\uD83C\uDFFC"]],"1f3fd":["1f44e-1f3fd",15,6,31,["\uD83D\uDC4E\uD83C\uDFFD"]],"1f3fe":["1f44e-1f3fe",15,7,31,["\uD83D\uDC4E\uD83C\uDFFE"]],"1f3ff":["1f44e-1f3ff",15,8,31,["\uD83D\uDC4E\uD83C\uDFFF"]]},

		"1f44f":{"1f3fb":["1f44f-1f3fb",15,10,31,["\uD83D\uDC4F\uD83C\uDFFB"]],"1f3fc":["1f44f-1f3fc",15,11,31,["\uD83D\uDC4F\uD83C\uDFFC"]],"1f3fd":["1f44f-1f3fd",15,12,31,["\uD83D\uDC4F\uD83C\uDFFD"]],"1f3fe":["1f44f-1f3fe",15,13,31,["\uD83D\uDC4F\uD83C\uDFFE"]],"1f3ff":["1f44f-1f3ff",15,14,31,["\uD83D\uDC4F\uD83C\uDFFF"]]},

		"1f450":{"1f3fb":["1f450-1f3fb",15,16,31,["\uD83D\uDC50\uD83C\uDFFB"]],"1f3fc":["1f450-1f3fc",15,17,31,["\uD83D\uDC50\uD83C\uDFFC"]],"1f3fd":["1f450-1f3fd",15,18,31,["\uD83D\uDC50\uD83C\uDFFD"]],"1f3fe":["1f450-1f3fe",15,19,31,["\uD83D\uDC50\uD83C\uDFFE"]],"1f3ff":["1f450-1f3ff",15,20,31,["\uD83D\uDC50\uD83C\uDFFF"]]},

		"1f466":{"1f3fb":["1f466-1f3fb",15,43,31,["\uD83D\uDC66\uD83C\uDFFB"]],"1f3fc":["1f466-1f3fc",15,44,31,["\uD83D\uDC66\uD83C\uDFFC"]],"1f3fd":["1f466-1f3fd",15,45,31,["\uD83D\uDC66\uD83C\uDFFD"]],"1f3fe":["1f466-1f3fe",15,46,31,["\uD83D\uDC66\uD83C\uDFFE"]],"1f3ff":["1f466-1f3ff",15,47,31,["\uD83D\uDC66\uD83C\uDFFF"]]},

		"1f467":{"1f3fb":["1f467-1f3fb",15,49,31,["\uD83D\uDC67\uD83C\uDFFB"]],"1f3fc":["1f467-1f3fc",15,50,31,["\uD83D\uDC67\uD83C\uDFFC"]],"1f3fd":["1f467-1f3fd",15,51,31,["\uD83D\uDC67\uD83C\uDFFD"]],"1f3fe":["1f467-1f3fe",16,0,31,["\uD83D\uDC67\uD83C\uDFFE"]],"1f3ff":["1f467-1f3ff",16,1,31,["\uD83D\uDC67\uD83C\uDFFF"]]},

		"1f468-200d-1f33e":{"1f3fb":["1f468-1f3fb-200d-1f33e",16,3,15,["\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF3E"]],"1f3fc":["1f468-1f3fc-200d-1f33e",16,4,15,["\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF3E"]],"1f3fd":["1f468-1f3fd-200d-1f33e",16,5,15,["\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF3E"]],"1f3fe":["1f468-1f3fe-200d-1f33e",16,6,15,["\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF3E"]],"1f3ff":["1f468-1f3ff-200d-1f33e",16,7,15,["\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF3E"]]},

		"1f468-200d-1f373":{"1f3fb":["1f468-1f3fb-200d-1f373",16,9,15,["\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF73"]],"1f3fc":["1f468-1f3fc-200d-1f373",16,10,15,["\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF73"]],"1f3fd":["1f468-1f3fd-200d-1f373",16,11,15,["\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF73"]],"1f3fe":["1f468-1f3fe-200d-1f373",16,12,15,["\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF73"]],"1f3ff":["1f468-1f3ff-200d-1f373",16,13,15,["\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF73"]]},

		"1f468-200d-1f393":{"1f3fb":["1f468-1f3fb-200d-1f393",16,15,15,["\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF93"]],"1f3fc":["1f468-1f3fc-200d-1f393",16,16,15,["\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF93"]],"1f3fd":["1f468-1f3fd-200d-1f393",16,17,15,["\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF93"]],"1f3fe":["1f468-1f3fe-200d-1f393",16,18,15,["\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF93"]],"1f3ff":["1f468-1f3ff-200d-1f393",16,19,15,["\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF93"]]},

		"1f468-200d-1f3a4":{"1f3fb":["1f468-1f3fb-200d-1f3a4",16,21,15,["\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFA4"]],"1f3fc":["1f468-1f3fc-200d-1f3a4",16,22,15,["\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFA4"]],"1f3fd":["1f468-1f3fd-200d-1f3a4",16,23,15,["\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFA4"]],"1f3fe":["1f468-1f3fe-200d-1f3a4",16,24,15,["\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFA4"]],"1f3ff":["1f468-1f3ff-200d-1f3a4",16,25,15,["\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFA4"]]},

		"1f468-200d-1f3a8":{"1f3fb":["1f468-1f3fb-200d-1f3a8",16,27,15,["\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFA8"]],"1f3fc":["1f468-1f3fc-200d-1f3a8",16,28,15,["\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFA8"]],"1f3fd":["1f468-1f3fd-200d-1f3a8",16,29,15,["\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFA8"]],"1f3fe":["1f468-1f3fe-200d-1f3a8",16,30,15,["\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFA8"]],"1f3ff":["1f468-1f3ff-200d-1f3a8",16,31,15,["\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFA8"]]},

		"1f468-200d-1f3eb":{"1f3fb":["1f468-1f3fb-200d-1f3eb",16,33,15,["\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFEB"]],"1f3fc":["1f468-1f3fc-200d-1f3eb",16,34,15,["\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFEB"]],"1f3fd":["1f468-1f3fd-200d-1f3eb",16,35,15,["\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFEB"]],"1f3fe":["1f468-1f3fe-200d-1f3eb",16,36,15,["\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFEB"]],"1f3ff":["1f468-1f3ff-200d-1f3eb",16,37,15,["\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFEB"]]},

		"1f468-200d-1f3ed":{"1f3fb":["1f468-1f3fb-200d-1f3ed",16,39,15,["\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFED"]],"1f3fc":["1f468-1f3fc-200d-1f3ed",16,40,15,["\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFED"]],"1f3fd":["1f468-1f3fd-200d-1f3ed",16,41,15,["\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFED"]],"1f3fe":["1f468-1f3fe-200d-1f3ed",16,42,15,["\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFED"]],"1f3ff":["1f468-1f3ff-200d-1f3ed",16,43,15,["\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFED"]]},

		"1f468-200d-1f4bb":{"1f3fb":["1f468-1f3fb-200d-1f4bb",17,8,15,["\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDCBB"]],"1f3fc":["1f468-1f3fc-200d-1f4bb",17,9,15,["\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDCBB"]],"1f3fd":["1f468-1f3fd-200d-1f4bb",17,10,15,["\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDCBB"]],"1f3fe":["1f468-1f3fe-200d-1f4bb",17,11,15,["\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDCBB"]],"1f3ff":["1f468-1f3ff-200d-1f4bb",17,12,15,["\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDCBB"]]},

		"1f468-200d-1f4bc":{"1f3fb":["1f468-1f3fb-200d-1f4bc",17,14,15,["\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDCBC"]],"1f3fc":["1f468-1f3fc-200d-1f4bc",17,15,15,["\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDCBC"]],"1f3fd":["1f468-1f3fd-200d-1f4bc",17,16,15,["\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDCBC"]],"1f3fe":["1f468-1f3fe-200d-1f4bc",17,17,15,["\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDCBC"]],"1f3ff":["1f468-1f3ff-200d-1f4bc",17,18,15,["\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDCBC"]]},

		"1f468-200d-1f527":{"1f3fb":["1f468-1f3fb-200d-1f527",17,20,15,["\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDD27"]],"1f3fc":["1f468-1f3fc-200d-1f527",17,21,15,["\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDD27"]],"1f3fd":["1f468-1f3fd-200d-1f527",17,22,15,["\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDD27"]],"1f3fe":["1f468-1f3fe-200d-1f527",17,23,15,["\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDD27"]],"1f3ff":["1f468-1f3ff-200d-1f527",17,24,15,["\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDD27"]]},

		"1f468-200d-1f52c":{"1f3fb":["1f468-1f3fb-200d-1f52c",17,26,15,["\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDD2C"]],"1f3fc":["1f468-1f3fc-200d-1f52c",17,27,15,["\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDD2C"]],"1f3fd":["1f468-1f3fd-200d-1f52c",17,28,15,["\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDD2C"]],"1f3fe":["1f468-1f3fe-200d-1f52c",17,29,15,["\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDD2C"]],"1f3ff":["1f468-1f3ff-200d-1f52c",17,30,15,["\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDD2C"]]},

		"1f468-200d-1f680":{"1f3fb":["1f468-1f3fb-200d-1f680",17,32,15,["\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDE80"]],"1f3fc":["1f468-1f3fc-200d-1f680",17,33,15,["\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDE80"]],"1f3fd":["1f468-1f3fd-200d-1f680",17,34,15,["\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDE80"]],"1f3fe":["1f468-1f3fe-200d-1f680",17,35,15,["\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDE80"]],"1f3ff":["1f468-1f3ff-200d-1f680",17,36,15,["\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDE80"]]},

		"1f468-200d-1f692":{"1f3fb":["1f468-1f3fb-200d-1f692",17,38,15,["\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDE92"]],"1f3fc":["1f468-1f3fc-200d-1f692",17,39,15,["\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDE92"]],"1f3fd":["1f468-1f3fd-200d-1f692",17,40,15,["\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDE92"]],"1f3fe":["1f468-1f3fe-200d-1f692",17,41,15,["\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDE92"]],"1f3ff":["1f468-1f3ff-200d-1f692",17,42,15,["\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDE92"]]},

		"1f468-200d-2695-fe0f":{"1f3fb":["1f468-1f3fb-200d-2695-fe0f",17,44,7,["\uD83D\uDC68\uD83C\uDFFB\u200D\u2695\uFE0F"]],"1f3fc":["1f468-1f3fc-200d-2695-fe0f",17,45,7,["\uD83D\uDC68\uD83C\uDFFC\u200D\u2695\uFE0F"]],"1f3fd":["1f468-1f3fd-200d-2695-fe0f",17,46,7,["\uD83D\uDC68\uD83C\uDFFD\u200D\u2695\uFE0F"]],"1f3fe":["1f468-1f3fe-200d-2695-fe0f",17,47,7,["\uD83D\uDC68\uD83C\uDFFE\u200D\u2695\uFE0F"]],"1f3ff":["1f468-1f3ff-200d-2695-fe0f",17,48,7,["\uD83D\uDC68\uD83C\uDFFF\u200D\u2695\uFE0F"]]},

		"1f468-200d-2696-fe0f":{"1f3fb":["1f468-1f3fb-200d-2696-fe0f",17,50,7,["\uD83D\uDC68\uD83C\uDFFB\u200D\u2696\uFE0F"]],"1f3fc":["1f468-1f3fc-200d-2696-fe0f",17,51,7,["\uD83D\uDC68\uD83C\uDFFC\u200D\u2696\uFE0F"]],"1f3fd":["1f468-1f3fd-200d-2696-fe0f",18,0,7,["\uD83D\uDC68\uD83C\uDFFD\u200D\u2696\uFE0F"]],"1f3fe":["1f468-1f3fe-200d-2696-fe0f",18,1,7,["\uD83D\uDC68\uD83C\uDFFE\u200D\u2696\uFE0F"]],"1f3ff":["1f468-1f3ff-200d-2696-fe0f",18,2,7,["\uD83D\uDC68\uD83C\uDFFF\u200D\u2696\uFE0F"]]},

		"1f468-200d-2708-fe0f":{"1f3fb":["1f468-1f3fb-200d-2708-fe0f",18,4,7,["\uD83D\uDC68\uD83C\uDFFB\u200D\u2708\uFE0F"]],"1f3fc":["1f468-1f3fc-200d-2708-fe0f",18,5,7,["\uD83D\uDC68\uD83C\uDFFC\u200D\u2708\uFE0F"]],"1f3fd":["1f468-1f3fd-200d-2708-fe0f",18,6,7,["\uD83D\uDC68\uD83C\uDFFD\u200D\u2708\uFE0F"]],"1f3fe":["1f468-1f3fe-200d-2708-fe0f",18,7,7,["\uD83D\uDC68\uD83C\uDFFE\u200D\u2708\uFE0F"]],"1f3ff":["1f468-1f3ff-200d-2708-fe0f",18,8,7,["\uD83D\uDC68\uD83C\uDFFF\u200D\u2708\uFE0F"]]},

		"1f468":{"1f3fb":["1f468-1f3fb",18,12,31,["\uD83D\uDC68\uD83C\uDFFB"]],"1f3fc":["1f468-1f3fc",18,13,31,["\uD83D\uDC68\uD83C\uDFFC"]],"1f3fd":["1f468-1f3fd",18,14,31,["\uD83D\uDC68\uD83C\uDFFD"]],"1f3fe":["1f468-1f3fe",18,15,31,["\uD83D\uDC68\uD83C\uDFFE"]],"1f3ff":["1f468-1f3ff",18,16,31,["\uD83D\uDC68\uD83C\uDFFF"]]},

		"1f469-200d-1f33e":{"1f3fb":["1f469-1f3fb-200d-1f33e",18,18,15,["\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF3E"]],"1f3fc":["1f469-1f3fc-200d-1f33e",18,19,15,["\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF3E"]],"1f3fd":["1f469-1f3fd-200d-1f33e",18,20,15,["\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF3E"]],"1f3fe":["1f469-1f3fe-200d-1f33e",18,21,15,["\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF3E"]],"1f3ff":["1f469-1f3ff-200d-1f33e",18,22,15,["\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF3E"]]},

		"1f469-200d-1f373":{"1f3fb":["1f469-1f3fb-200d-1f373",18,24,15,["\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF73"]],"1f3fc":["1f469-1f3fc-200d-1f373",18,25,15,["\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF73"]],"1f3fd":["1f469-1f3fd-200d-1f373",18,26,15,["\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF73"]],"1f3fe":["1f469-1f3fe-200d-1f373",18,27,15,["\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF73"]],"1f3ff":["1f469-1f3ff-200d-1f373",18,28,15,["\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF73"]]},

		"1f469-200d-1f393":{"1f3fb":["1f469-1f3fb-200d-1f393",18,30,15,["\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF93"]],"1f3fc":["1f469-1f3fc-200d-1f393",18,31,15,["\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF93"]],"1f3fd":["1f469-1f3fd-200d-1f393",18,32,15,["\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF93"]],"1f3fe":["1f469-1f3fe-200d-1f393",18,33,15,["\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF93"]],"1f3ff":["1f469-1f3ff-200d-1f393",18,34,15,["\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF93"]]},

		"1f469-200d-1f3a4":{"1f3fb":["1f469-1f3fb-200d-1f3a4",18,36,15,["\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFA4"]],"1f3fc":["1f469-1f3fc-200d-1f3a4",18,37,15,["\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFA4"]],"1f3fd":["1f469-1f3fd-200d-1f3a4",18,38,15,["\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFA4"]],"1f3fe":["1f469-1f3fe-200d-1f3a4",18,39,15,["\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFA4"]],"1f3ff":["1f469-1f3ff-200d-1f3a4",18,40,15,["\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFA4"]]},

		"1f469-200d-1f3a8":{"1f3fb":["1f469-1f3fb-200d-1f3a8",18,42,15,["\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFA8"]],"1f3fc":["1f469-1f3fc-200d-1f3a8",18,43,15,["\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFA8"]],"1f3fd":["1f469-1f3fd-200d-1f3a8",18,44,15,["\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFA8"]],"1f3fe":["1f469-1f3fe-200d-1f3a8",18,45,15,["\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFA8"]],"1f3ff":["1f469-1f3ff-200d-1f3a8",18,46,15,["\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFA8"]]},

		"1f469-200d-1f3eb":{"1f3fb":["1f469-1f3fb-200d-1f3eb",18,48,15,["\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFEB"]],"1f3fc":["1f469-1f3fc-200d-1f3eb",18,49,15,["\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFEB"]],"1f3fd":["1f469-1f3fd-200d-1f3eb",18,50,15,["\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFEB"]],"1f3fe":["1f469-1f3fe-200d-1f3eb",18,51,15,["\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFEB"]],"1f3ff":["1f469-1f3ff-200d-1f3eb",19,0,15,["\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFEB"]]},

		"1f469-200d-1f3ed":{"1f3fb":["1f469-1f3fb-200d-1f3ed",19,2,15,["\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFED"]],"1f3fc":["1f469-1f3fc-200d-1f3ed",19,3,15,["\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFED"]],"1f3fd":["1f469-1f3fd-200d-1f3ed",19,4,15,["\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFED"]],"1f3fe":["1f469-1f3fe-200d-1f3ed",19,5,15,["\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFED"]],"1f3ff":["1f469-1f3ff-200d-1f3ed",19,6,15,["\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFED"]]},

		"1f469-200d-1f4bb":{"1f3fb":["1f469-1f3fb-200d-1f4bb",19,18,15,["\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDCBB"]],"1f3fc":["1f469-1f3fc-200d-1f4bb",19,19,15,["\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDCBB"]],"1f3fd":["1f469-1f3fd-200d-1f4bb",19,20,15,["\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDCBB"]],"1f3fe":["1f469-1f3fe-200d-1f4bb",19,21,15,["\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDCBB"]],"1f3ff":["1f469-1f3ff-200d-1f4bb",19,22,15,["\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDCBB"]]},

		"1f469-200d-1f4bc":{"1f3fb":["1f469-1f3fb-200d-1f4bc",19,24,15,["\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDCBC"]],"1f3fc":["1f469-1f3fc-200d-1f4bc",19,25,15,["\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDCBC"]],"1f3fd":["1f469-1f3fd-200d-1f4bc",19,26,15,["\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDCBC"]],"1f3fe":["1f469-1f3fe-200d-1f4bc",19,27,15,["\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDCBC"]],"1f3ff":["1f469-1f3ff-200d-1f4bc",19,28,15,["\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDCBC"]]},

		"1f469-200d-1f527":{"1f3fb":["1f469-1f3fb-200d-1f527",19,30,15,["\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDD27"]],"1f3fc":["1f469-1f3fc-200d-1f527",19,31,15,["\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDD27"]],"1f3fd":["1f469-1f3fd-200d-1f527",19,32,15,["\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDD27"]],"1f3fe":["1f469-1f3fe-200d-1f527",19,33,15,["\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDD27"]],"1f3ff":["1f469-1f3ff-200d-1f527",19,34,15,["\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDD27"]]},

		"1f469-200d-1f52c":{"1f3fb":["1f469-1f3fb-200d-1f52c",19,36,15,["\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDD2C"]],"1f3fc":["1f469-1f3fc-200d-1f52c",19,37,15,["\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDD2C"]],"1f3fd":["1f469-1f3fd-200d-1f52c",19,38,15,["\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDD2C"]],"1f3fe":["1f469-1f3fe-200d-1f52c",19,39,15,["\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDD2C"]],"1f3ff":["1f469-1f3ff-200d-1f52c",19,40,15,["\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDD2C"]]},

		"1f469-200d-1f680":{"1f3fb":["1f469-1f3fb-200d-1f680",19,42,15,["\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDE80"]],"1f3fc":["1f469-1f3fc-200d-1f680",19,43,15,["\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDE80"]],"1f3fd":["1f469-1f3fd-200d-1f680",19,44,15,["\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDE80"]],"1f3fe":["1f469-1f3fe-200d-1f680",19,45,15,["\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDE80"]],"1f3ff":["1f469-1f3ff-200d-1f680",19,46,15,["\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDE80"]]},

		"1f469-200d-1f692":{"1f3fb":["1f469-1f3fb-200d-1f692",19,48,15,["\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDE92"]],"1f3fc":["1f469-1f3fc-200d-1f692",19,49,15,["\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDE92"]],"1f3fd":["1f469-1f3fd-200d-1f692",19,50,15,["\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDE92"]],"1f3fe":["1f469-1f3fe-200d-1f692",19,51,15,["\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDE92"]],"1f3ff":["1f469-1f3ff-200d-1f692",20,0,15,["\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDE92"]]},

		"1f469-200d-2695-fe0f":{"1f3fb":["1f469-1f3fb-200d-2695-fe0f",20,2,7,["\uD83D\uDC69\uD83C\uDFFB\u200D\u2695\uFE0F"]],"1f3fc":["1f469-1f3fc-200d-2695-fe0f",20,3,7,["\uD83D\uDC69\uD83C\uDFFC\u200D\u2695\uFE0F"]],"1f3fd":["1f469-1f3fd-200d-2695-fe0f",20,4,7,["\uD83D\uDC69\uD83C\uDFFD\u200D\u2695\uFE0F"]],"1f3fe":["1f469-1f3fe-200d-2695-fe0f",20,5,7,["\uD83D\uDC69\uD83C\uDFFE\u200D\u2695\uFE0F"]],"1f3ff":["1f469-1f3ff-200d-2695-fe0f",20,6,7,["\uD83D\uDC69\uD83C\uDFFF\u200D\u2695\uFE0F"]]},

		"1f469-200d-2696-fe0f":{"1f3fb":["1f469-1f3fb-200d-2696-fe0f",20,8,7,["\uD83D\uDC69\uD83C\uDFFB\u200D\u2696\uFE0F"]],"1f3fc":["1f469-1f3fc-200d-2696-fe0f",20,9,7,["\uD83D\uDC69\uD83C\uDFFC\u200D\u2696\uFE0F"]],"1f3fd":["1f469-1f3fd-200d-2696-fe0f",20,10,7,["\uD83D\uDC69\uD83C\uDFFD\u200D\u2696\uFE0F"]],"1f3fe":["1f469-1f3fe-200d-2696-fe0f",20,11,7,["\uD83D\uDC69\uD83C\uDFFE\u200D\u2696\uFE0F"]],"1f3ff":["1f469-1f3ff-200d-2696-fe0f",20,12,7,["\uD83D\uDC69\uD83C\uDFFF\u200D\u2696\uFE0F"]]},

		"1f469-200d-2708-fe0f":{"1f3fb":["1f469-1f3fb-200d-2708-fe0f",20,14,7,["\uD83D\uDC69\uD83C\uDFFB\u200D\u2708\uFE0F"]],"1f3fc":["1f469-1f3fc-200d-2708-fe0f",20,15,7,["\uD83D\uDC69\uD83C\uDFFC\u200D\u2708\uFE0F"]],"1f3fd":["1f469-1f3fd-200d-2708-fe0f",20,16,7,["\uD83D\uDC69\uD83C\uDFFD\u200D\u2708\uFE0F"]],"1f3fe":["1f469-1f3fe-200d-2708-fe0f",20,17,7,["\uD83D\uDC69\uD83C\uDFFE\u200D\u2708\uFE0F"]],"1f3ff":["1f469-1f3ff-200d-2708-fe0f",20,18,7,["\uD83D\uDC69\uD83C\uDFFF\u200D\u2708\uFE0F"]]},

		"1f469":{"1f3fb":["1f469-1f3fb",20,24,31,["\uD83D\uDC69\uD83C\uDFFB"]],"1f3fc":["1f469-1f3fc",20,25,31,["\uD83D\uDC69\uD83C\uDFFC"]],"1f3fd":["1f469-1f3fd",20,26,31,["\uD83D\uDC69\uD83C\uDFFD"]],"1f3fe":["1f469-1f3fe",20,27,31,["\uD83D\uDC69\uD83C\uDFFE"]],"1f3ff":["1f469-1f3ff",20,28,31,["\uD83D\uDC69\uD83C\uDFFF"]]},

		"1f46e-200d-2640-fe0f":{"1f3fb":["1f46e-1f3fb-200d-2640-fe0f",20,34,7,["\uD83D\uDC6E\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f46e-1f3fc-200d-2640-fe0f",20,35,7,["\uD83D\uDC6E\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f46e-1f3fd-200d-2640-fe0f",20,36,7,["\uD83D\uDC6E\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f46e-1f3fe-200d-2640-fe0f",20,37,7,["\uD83D\uDC6E\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f46e-1f3ff-200d-2640-fe0f",20,38,7,["\uD83D\uDC6E\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f46e-200d-2642-fe0f":{"1f3fb":["1f46e-1f3fb-200d-2642-fe0f",20,40,7,["\uD83D\uDC6E\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83D\uDC6E\uD83C\uDFFB"]],"1f3fc":["1f46e-1f3fc-200d-2642-fe0f",20,41,7,["\uD83D\uDC6E\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83D\uDC6E\uD83C\uDFFC"]],"1f3fd":["1f46e-1f3fd-200d-2642-fe0f",20,42,7,["\uD83D\uDC6E\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83D\uDC6E\uD83C\uDFFD"]],"1f3fe":["1f46e-1f3fe-200d-2642-fe0f",20,43,7,["\uD83D\uDC6E\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83D\uDC6E\uD83C\uDFFE"]],"1f3ff":["1f46e-1f3ff-200d-2642-fe0f",20,44,7,["\uD83D\uDC6E\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83D\uDC6E\uD83C\uDFFF"]]},

		"1f470":{"1f3fb":["1f470-1f3fb",21,3,31,["\uD83D\uDC70\uD83C\uDFFB"]],"1f3fc":["1f470-1f3fc",21,4,31,["\uD83D\uDC70\uD83C\uDFFC"]],"1f3fd":["1f470-1f3fd",21,5,31,["\uD83D\uDC70\uD83C\uDFFD"]],"1f3fe":["1f470-1f3fe",21,6,31,["\uD83D\uDC70\uD83C\uDFFE"]],"1f3ff":["1f470-1f3ff",21,7,31,["\uD83D\uDC70\uD83C\uDFFF"]]},

		"1f471-200d-2640-fe0f":{"1f3fb":["1f471-1f3fb-200d-2640-fe0f",21,9,7,["\uD83D\uDC71\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f471-1f3fc-200d-2640-fe0f",21,10,7,["\uD83D\uDC71\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f471-1f3fd-200d-2640-fe0f",21,11,7,["\uD83D\uDC71\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f471-1f3fe-200d-2640-fe0f",21,12,7,["\uD83D\uDC71\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f471-1f3ff-200d-2640-fe0f",21,13,7,["\uD83D\uDC71\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f471-200d-2642-fe0f":{"1f3fb":["1f471-1f3fb-200d-2642-fe0f",21,15,7,["\uD83D\uDC71\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83D\uDC71\uD83C\uDFFB"]],"1f3fc":["1f471-1f3fc-200d-2642-fe0f",21,16,7,["\uD83D\uDC71\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83D\uDC71\uD83C\uDFFC"]],"1f3fd":["1f471-1f3fd-200d-2642-fe0f",21,17,7,["\uD83D\uDC71\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83D\uDC71\uD83C\uDFFD"]],"1f3fe":["1f471-1f3fe-200d-2642-fe0f",21,18,7,["\uD83D\uDC71\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83D\uDC71\uD83C\uDFFE"]],"1f3ff":["1f471-1f3ff-200d-2642-fe0f",21,19,7,["\uD83D\uDC71\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83D\uDC71\uD83C\uDFFF"]]},

		"1f472":{"1f3fb":["1f472-1f3fb",21,27,31,["\uD83D\uDC72\uD83C\uDFFB"]],"1f3fc":["1f472-1f3fc",21,28,31,["\uD83D\uDC72\uD83C\uDFFC"]],"1f3fd":["1f472-1f3fd",21,29,31,["\uD83D\uDC72\uD83C\uDFFD"]],"1f3fe":["1f472-1f3fe",21,30,31,["\uD83D\uDC72\uD83C\uDFFE"]],"1f3ff":["1f472-1f3ff",21,31,31,["\uD83D\uDC72\uD83C\uDFFF"]]},

		"1f473-200d-2640-fe0f":{"1f3fb":["1f473-1f3fb-200d-2640-fe0f",21,33,7,["\uD83D\uDC73\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f473-1f3fc-200d-2640-fe0f",21,34,7,["\uD83D\uDC73\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f473-1f3fd-200d-2640-fe0f",21,35,7,["\uD83D\uDC73\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f473-1f3fe-200d-2640-fe0f",21,36,7,["\uD83D\uDC73\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f473-1f3ff-200d-2640-fe0f",21,37,7,["\uD83D\uDC73\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f473-200d-2642-fe0f":{"1f3fb":["1f473-1f3fb-200d-2642-fe0f",21,39,7,["\uD83D\uDC73\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83D\uDC73\uD83C\uDFFB"]],"1f3fc":["1f473-1f3fc-200d-2642-fe0f",21,40,7,["\uD83D\uDC73\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83D\uDC73\uD83C\uDFFC"]],"1f3fd":["1f473-1f3fd-200d-2642-fe0f",21,41,7,["\uD83D\uDC73\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83D\uDC73\uD83C\uDFFD"]],"1f3fe":["1f473-1f3fe-200d-2642-fe0f",21,42,7,["\uD83D\uDC73\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83D\uDC73\uD83C\uDFFE"]],"1f3ff":["1f473-1f3ff-200d-2642-fe0f",21,43,7,["\uD83D\uDC73\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83D\uDC73\uD83C\uDFFF"]]},

		"1f474":{"1f3fb":["1f474-1f3fb",21,51,31,["\uD83D\uDC74\uD83C\uDFFB"]],"1f3fc":["1f474-1f3fc",22,0,31,["\uD83D\uDC74\uD83C\uDFFC"]],"1f3fd":["1f474-1f3fd",22,1,31,["\uD83D\uDC74\uD83C\uDFFD"]],"1f3fe":["1f474-1f3fe",22,2,31,["\uD83D\uDC74\uD83C\uDFFE"]],"1f3ff":["1f474-1f3ff",22,3,31,["\uD83D\uDC74\uD83C\uDFFF"]]},

		"1f475":{"1f3fb":["1f475-1f3fb",22,5,31,["\uD83D\uDC75\uD83C\uDFFB"]],"1f3fc":["1f475-1f3fc",22,6,31,["\uD83D\uDC75\uD83C\uDFFC"]],"1f3fd":["1f475-1f3fd",22,7,31,["\uD83D\uDC75\uD83C\uDFFD"]],"1f3fe":["1f475-1f3fe",22,8,31,["\uD83D\uDC75\uD83C\uDFFE"]],"1f3ff":["1f475-1f3ff",22,9,31,["\uD83D\uDC75\uD83C\uDFFF"]]},

		"1f476":{"1f3fb":["1f476-1f3fb",22,11,31,["\uD83D\uDC76\uD83C\uDFFB"]],"1f3fc":["1f476-1f3fc",22,12,31,["\uD83D\uDC76\uD83C\uDFFC"]],"1f3fd":["1f476-1f3fd",22,13,31,["\uD83D\uDC76\uD83C\uDFFD"]],"1f3fe":["1f476-1f3fe",22,14,31,["\uD83D\uDC76\uD83C\uDFFE"]],"1f3ff":["1f476-1f3ff",22,15,31,["\uD83D\uDC76\uD83C\uDFFF"]]},

		"1f477-200d-2640-fe0f":{"1f3fb":["1f477-1f3fb-200d-2640-fe0f",22,17,7,["\uD83D\uDC77\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f477-1f3fc-200d-2640-fe0f",22,18,7,["\uD83D\uDC77\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f477-1f3fd-200d-2640-fe0f",22,19,7,["\uD83D\uDC77\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f477-1f3fe-200d-2640-fe0f",22,20,7,["\uD83D\uDC77\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f477-1f3ff-200d-2640-fe0f",22,21,7,["\uD83D\uDC77\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f477-200d-2642-fe0f":{"1f3fb":["1f477-1f3fb-200d-2642-fe0f",22,23,7,["\uD83D\uDC77\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83D\uDC77\uD83C\uDFFB"]],"1f3fc":["1f477-1f3fc-200d-2642-fe0f",22,24,7,["\uD83D\uDC77\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83D\uDC77\uD83C\uDFFC"]],"1f3fd":["1f477-1f3fd-200d-2642-fe0f",22,25,7,["\uD83D\uDC77\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83D\uDC77\uD83C\uDFFD"]],"1f3fe":["1f477-1f3fe-200d-2642-fe0f",22,26,7,["\uD83D\uDC77\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83D\uDC77\uD83C\uDFFE"]],"1f3ff":["1f477-1f3ff-200d-2642-fe0f",22,27,7,["\uD83D\uDC77\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83D\uDC77\uD83C\uDFFF"]]},

		"1f478":{"1f3fb":["1f478-1f3fb",22,35,31,["\uD83D\uDC78\uD83C\uDFFB"]],"1f3fc":["1f478-1f3fc",22,36,31,["\uD83D\uDC78\uD83C\uDFFC"]],"1f3fd":["1f478-1f3fd",22,37,31,["\uD83D\uDC78\uD83C\uDFFD"]],"1f3fe":["1f478-1f3fe",22,38,31,["\uD83D\uDC78\uD83C\uDFFE"]],"1f3ff":["1f478-1f3ff",22,39,31,["\uD83D\uDC78\uD83C\uDFFF"]]},

		"1f47c":{"1f3fb":["1f47c-1f3fb",22,44,31,["\uD83D\uDC7C\uD83C\uDFFB"]],"1f3fc":["1f47c-1f3fc",22,45,31,["\uD83D\uDC7C\uD83C\uDFFC"]],"1f3fd":["1f47c-1f3fd",22,46,31,["\uD83D\uDC7C\uD83C\uDFFD"]],"1f3fe":["1f47c-1f3fe",22,47,31,["\uD83D\uDC7C\uD83C\uDFFE"]],"1f3ff":["1f47c-1f3ff",22,48,31,["\uD83D\uDC7C\uD83C\uDFFF"]]},

		"1f481-200d-2640-fe0f":{"1f3fb":["1f481-1f3fb-200d-2640-fe0f",23,2,7,["\uD83D\uDC81\uD83C\uDFFB\u200D\u2640\uFE0F","\uD83D\uDC81\uD83C\uDFFB"]],"1f3fc":["1f481-1f3fc-200d-2640-fe0f",23,3,7,["\uD83D\uDC81\uD83C\uDFFC\u200D\u2640\uFE0F","\uD83D\uDC81\uD83C\uDFFC"]],"1f3fd":["1f481-1f3fd-200d-2640-fe0f",23,4,7,["\uD83D\uDC81\uD83C\uDFFD\u200D\u2640\uFE0F","\uD83D\uDC81\uD83C\uDFFD"]],"1f3fe":["1f481-1f3fe-200d-2640-fe0f",23,5,7,["\uD83D\uDC81\uD83C\uDFFE\u200D\u2640\uFE0F","\uD83D\uDC81\uD83C\uDFFE"]],"1f3ff":["1f481-1f3ff-200d-2640-fe0f",23,6,7,["\uD83D\uDC81\uD83C\uDFFF\u200D\u2640\uFE0F","\uD83D\uDC81\uD83C\uDFFF"]]},

		"1f481-200d-2642-fe0f":{"1f3fb":["1f481-1f3fb-200d-2642-fe0f",23,8,7,["\uD83D\uDC81\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f481-1f3fc-200d-2642-fe0f",23,9,7,["\uD83D\uDC81\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f481-1f3fd-200d-2642-fe0f",23,10,7,["\uD83D\uDC81\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f481-1f3fe-200d-2642-fe0f",23,11,7,["\uD83D\uDC81\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f481-1f3ff-200d-2642-fe0f",23,12,7,["\uD83D\uDC81\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f482-200d-2640-fe0f":{"1f3fb":["1f482-1f3fb-200d-2640-fe0f",23,20,7,["\uD83D\uDC82\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f482-1f3fc-200d-2640-fe0f",23,21,7,["\uD83D\uDC82\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f482-1f3fd-200d-2640-fe0f",23,22,7,["\uD83D\uDC82\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f482-1f3fe-200d-2640-fe0f",23,23,7,["\uD83D\uDC82\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f482-1f3ff-200d-2640-fe0f",23,24,7,["\uD83D\uDC82\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f482-200d-2642-fe0f":{"1f3fb":["1f482-1f3fb-200d-2642-fe0f",23,26,7,["\uD83D\uDC82\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83D\uDC82\uD83C\uDFFB"]],"1f3fc":["1f482-1f3fc-200d-2642-fe0f",23,27,7,["\uD83D\uDC82\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83D\uDC82\uD83C\uDFFC"]],"1f3fd":["1f482-1f3fd-200d-2642-fe0f",23,28,7,["\uD83D\uDC82\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83D\uDC82\uD83C\uDFFD"]],"1f3fe":["1f482-1f3fe-200d-2642-fe0f",23,29,7,["\uD83D\uDC82\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83D\uDC82\uD83C\uDFFE"]],"1f3ff":["1f482-1f3ff-200d-2642-fe0f",23,30,7,["\uD83D\uDC82\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83D\uDC82\uD83C\uDFFF"]]},

		"1f483":{"1f3fb":["1f483-1f3fb",23,38,31,["\uD83D\uDC83\uD83C\uDFFB"]],"1f3fc":["1f483-1f3fc",23,39,31,["\uD83D\uDC83\uD83C\uDFFC"]],"1f3fd":["1f483-1f3fd",23,40,31,["\uD83D\uDC83\uD83C\uDFFD"]],"1f3fe":["1f483-1f3fe",23,41,31,["\uD83D\uDC83\uD83C\uDFFE"]],"1f3ff":["1f483-1f3ff",23,42,31,["\uD83D\uDC83\uD83C\uDFFF"]]},

		"1f485":{"1f3fb":["1f485-1f3fb",23,45,31,["\uD83D\uDC85\uD83C\uDFFB"]],"1f3fc":["1f485-1f3fc",23,46,31,["\uD83D\uDC85\uD83C\uDFFC"]],"1f3fd":["1f485-1f3fd",23,47,31,["\uD83D\uDC85\uD83C\uDFFD"]],"1f3fe":["1f485-1f3fe",23,48,31,["\uD83D\uDC85\uD83C\uDFFE"]],"1f3ff":["1f485-1f3ff",23,49,31,["\uD83D\uDC85\uD83C\uDFFF"]]},

		"1f486-200d-2640-fe0f":{"1f3fb":["1f486-1f3fb-200d-2640-fe0f",23,51,7,["\uD83D\uDC86\uD83C\uDFFB\u200D\u2640\uFE0F","\uD83D\uDC86\uD83C\uDFFB"]],"1f3fc":["1f486-1f3fc-200d-2640-fe0f",24,0,7,["\uD83D\uDC86\uD83C\uDFFC\u200D\u2640\uFE0F","\uD83D\uDC86\uD83C\uDFFC"]],"1f3fd":["1f486-1f3fd-200d-2640-fe0f",24,1,7,["\uD83D\uDC86\uD83C\uDFFD\u200D\u2640\uFE0F","\uD83D\uDC86\uD83C\uDFFD"]],"1f3fe":["1f486-1f3fe-200d-2640-fe0f",24,2,7,["\uD83D\uDC86\uD83C\uDFFE\u200D\u2640\uFE0F","\uD83D\uDC86\uD83C\uDFFE"]],"1f3ff":["1f486-1f3ff-200d-2640-fe0f",24,3,7,["\uD83D\uDC86\uD83C\uDFFF\u200D\u2640\uFE0F","\uD83D\uDC86\uD83C\uDFFF"]]},

		"1f486-200d-2642-fe0f":{"1f3fb":["1f486-1f3fb-200d-2642-fe0f",24,5,7,["\uD83D\uDC86\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f486-1f3fc-200d-2642-fe0f",24,6,7,["\uD83D\uDC86\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f486-1f3fd-200d-2642-fe0f",24,7,7,["\uD83D\uDC86\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f486-1f3fe-200d-2642-fe0f",24,8,7,["\uD83D\uDC86\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f486-1f3ff-200d-2642-fe0f",24,9,7,["\uD83D\uDC86\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f487-200d-2640-fe0f":{"1f3fb":["1f487-1f3fb-200d-2640-fe0f",24,17,7,["\uD83D\uDC87\uD83C\uDFFB\u200D\u2640\uFE0F","\uD83D\uDC87\uD83C\uDFFB"]],"1f3fc":["1f487-1f3fc-200d-2640-fe0f",24,18,7,["\uD83D\uDC87\uD83C\uDFFC\u200D\u2640\uFE0F","\uD83D\uDC87\uD83C\uDFFC"]],"1f3fd":["1f487-1f3fd-200d-2640-fe0f",24,19,7,["\uD83D\uDC87\uD83C\uDFFD\u200D\u2640\uFE0F","\uD83D\uDC87\uD83C\uDFFD"]],"1f3fe":["1f487-1f3fe-200d-2640-fe0f",24,20,7,["\uD83D\uDC87\uD83C\uDFFE\u200D\u2640\uFE0F","\uD83D\uDC87\uD83C\uDFFE"]],"1f3ff":["1f487-1f3ff-200d-2640-fe0f",24,21,7,["\uD83D\uDC87\uD83C\uDFFF\u200D\u2640\uFE0F","\uD83D\uDC87\uD83C\uDFFF"]]},

		"1f487-200d-2642-fe0f":{"1f3fb":["1f487-1f3fb-200d-2642-fe0f",24,23,7,["\uD83D\uDC87\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f487-1f3fc-200d-2642-fe0f",24,24,7,["\uD83D\uDC87\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f487-1f3fd-200d-2642-fe0f",24,25,7,["\uD83D\uDC87\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f487-1f3fe-200d-2642-fe0f",24,26,7,["\uD83D\uDC87\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f487-1f3ff-200d-2642-fe0f",24,27,7,["\uD83D\uDC87\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f4aa":{"1f3fb":["1f4aa-1f3fb",25,17,31,["\uD83D\uDCAA\uD83C\uDFFB"]],"1f3fc":["1f4aa-1f3fc",25,18,31,["\uD83D\uDCAA\uD83C\uDFFC"]],"1f3fd":["1f4aa-1f3fd",25,19,31,["\uD83D\uDCAA\uD83C\uDFFD"]],"1f3fe":["1f4aa-1f3fe",25,20,31,["\uD83D\uDCAA\uD83C\uDFFE"]],"1f3ff":["1f4aa-1f3ff",25,21,31,["\uD83D\uDCAA\uD83C\uDFFF"]]},

		"1f574-fe0f":{"1f3fb":["1f574-1f3fb",28,46,15,["\uD83D\uDD74\uD83C\uDFFB"]],"1f3fc":["1f574-1f3fc",28,47,15,["\uD83D\uDD74\uD83C\uDFFC"]],"1f3fd":["1f574-1f3fd",28,48,15,["\uD83D\uDD74\uD83C\uDFFD"]],"1f3fe":["1f574-1f3fe",28,49,15,["\uD83D\uDD74\uD83C\uDFFE"]],"1f3ff":["1f574-1f3ff",28,50,15,["\uD83D\uDD74\uD83C\uDFFF"]]},

		"1f575-fe0f-200d-2640-fe0f":{"1f3fb":["1f575-1f3fb-200d-2640-fe0f",29,0,7,["\uD83D\uDD75\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f575-1f3fc-200d-2640-fe0f",29,1,7,["\uD83D\uDD75\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f575-1f3fd-200d-2640-fe0f",29,2,7,["\uD83D\uDD75\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f575-1f3fe-200d-2640-fe0f",29,3,7,["\uD83D\uDD75\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f575-1f3ff-200d-2640-fe0f",29,4,7,["\uD83D\uDD75\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f575-fe0f-200d-2642-fe0f":{"1f3fb":["1f575-1f3fb-200d-2642-fe0f",29,6,7,["\uD83D\uDD75\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83D\uDD75\uD83C\uDFFB"]],"1f3fc":["1f575-1f3fc-200d-2642-fe0f",29,7,7,["\uD83D\uDD75\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83D\uDD75\uD83C\uDFFC"]],"1f3fd":["1f575-1f3fd-200d-2642-fe0f",29,8,7,["\uD83D\uDD75\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83D\uDD75\uD83C\uDFFD"]],"1f3fe":["1f575-1f3fe-200d-2642-fe0f",29,9,7,["\uD83D\uDD75\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83D\uDD75\uD83C\uDFFE"]],"1f3ff":["1f575-1f3ff-200d-2642-fe0f",29,10,7,["\uD83D\uDD75\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83D\uDD75\uD83C\uDFFF"]]},

		"1f57a":{"1f3fb":["1f57a-1f3fb",29,22,15,["\uD83D\uDD7A\uD83C\uDFFB"]],"1f3fc":["1f57a-1f3fc",29,23,15,["\uD83D\uDD7A\uD83C\uDFFC"]],"1f3fd":["1f57a-1f3fd",29,24,15,["\uD83D\uDD7A\uD83C\uDFFD"]],"1f3fe":["1f57a-1f3fe",29,25,15,["\uD83D\uDD7A\uD83C\uDFFE"]],"1f3ff":["1f57a-1f3ff",29,26,15,["\uD83D\uDD7A\uD83C\uDFFF"]]},

		"1f590-fe0f":{"1f3fb":["1f590-1f3fb",29,33,15,["\uD83D\uDD90\uD83C\uDFFB"]],"1f3fc":["1f590-1f3fc",29,34,15,["\uD83D\uDD90\uD83C\uDFFC"]],"1f3fd":["1f590-1f3fd",29,35,15,["\uD83D\uDD90\uD83C\uDFFD"]],"1f3fe":["1f590-1f3fe",29,36,15,["\uD83D\uDD90\uD83C\uDFFE"]],"1f3ff":["1f590-1f3ff",29,37,15,["\uD83D\uDD90\uD83C\uDFFF"]]},

		"1f595":{"1f3fb":["1f595-1f3fb",29,39,15,["\uD83D\uDD95\uD83C\uDFFB"]],"1f3fc":["1f595-1f3fc",29,40,15,["\uD83D\uDD95\uD83C\uDFFC"]],"1f3fd":["1f595-1f3fd",29,41,15,["\uD83D\uDD95\uD83C\uDFFD"]],"1f3fe":["1f595-1f3fe",29,42,15,["\uD83D\uDD95\uD83C\uDFFE"]],"1f3ff":["1f595-1f3ff",29,43,15,["\uD83D\uDD95\uD83C\uDFFF"]]},

		"1f596":{"1f3fb":["1f596-1f3fb",29,45,15,["\uD83D\uDD96\uD83C\uDFFB"]],"1f3fc":["1f596-1f3fc",29,46,15,["\uD83D\uDD96\uD83C\uDFFC"]],"1f3fd":["1f596-1f3fd",29,47,15,["\uD83D\uDD96\uD83C\uDFFD"]],"1f3fe":["1f596-1f3fe",29,48,15,["\uD83D\uDD96\uD83C\uDFFE"]],"1f3ff":["1f596-1f3ff",29,49,15,["\uD83D\uDD96\uD83C\uDFFF"]]},

		"1f645-200d-2640-fe0f":{"1f3fb":["1f645-1f3fb-200d-2640-fe0f",31,42,7,["\uD83D\uDE45\uD83C\uDFFB\u200D\u2640\uFE0F","\uD83D\uDE45\uD83C\uDFFB"]],"1f3fc":["1f645-1f3fc-200d-2640-fe0f",31,43,7,["\uD83D\uDE45\uD83C\uDFFC\u200D\u2640\uFE0F","\uD83D\uDE45\uD83C\uDFFC"]],"1f3fd":["1f645-1f3fd-200d-2640-fe0f",31,44,7,["\uD83D\uDE45\uD83C\uDFFD\u200D\u2640\uFE0F","\uD83D\uDE45\uD83C\uDFFD"]],"1f3fe":["1f645-1f3fe-200d-2640-fe0f",31,45,7,["\uD83D\uDE45\uD83C\uDFFE\u200D\u2640\uFE0F","\uD83D\uDE45\uD83C\uDFFE"]],"1f3ff":["1f645-1f3ff-200d-2640-fe0f",31,46,7,["\uD83D\uDE45\uD83C\uDFFF\u200D\u2640\uFE0F","\uD83D\uDE45\uD83C\uDFFF"]]},

		"1f645-200d-2642-fe0f":{"1f3fb":["1f645-1f3fb-200d-2642-fe0f",31,48,7,["\uD83D\uDE45\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f645-1f3fc-200d-2642-fe0f",31,49,7,["\uD83D\uDE45\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f645-1f3fd-200d-2642-fe0f",31,50,7,["\uD83D\uDE45\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f645-1f3fe-200d-2642-fe0f",31,51,7,["\uD83D\uDE45\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f645-1f3ff-200d-2642-fe0f",32,0,7,["\uD83D\uDE45\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f646-200d-2640-fe0f":{"1f3fb":["1f646-1f3fb-200d-2640-fe0f",32,8,7,["\uD83D\uDE46\uD83C\uDFFB\u200D\u2640\uFE0F","\uD83D\uDE46\uD83C\uDFFB"]],"1f3fc":["1f646-1f3fc-200d-2640-fe0f",32,9,7,["\uD83D\uDE46\uD83C\uDFFC\u200D\u2640\uFE0F","\uD83D\uDE46\uD83C\uDFFC"]],"1f3fd":["1f646-1f3fd-200d-2640-fe0f",32,10,7,["\uD83D\uDE46\uD83C\uDFFD\u200D\u2640\uFE0F","\uD83D\uDE46\uD83C\uDFFD"]],"1f3fe":["1f646-1f3fe-200d-2640-fe0f",32,11,7,["\uD83D\uDE46\uD83C\uDFFE\u200D\u2640\uFE0F","\uD83D\uDE46\uD83C\uDFFE"]],"1f3ff":["1f646-1f3ff-200d-2640-fe0f",32,12,7,["\uD83D\uDE46\uD83C\uDFFF\u200D\u2640\uFE0F","\uD83D\uDE46\uD83C\uDFFF"]]},

		"1f646-200d-2642-fe0f":{"1f3fb":["1f646-1f3fb-200d-2642-fe0f",32,14,7,["\uD83D\uDE46\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f646-1f3fc-200d-2642-fe0f",32,15,7,["\uD83D\uDE46\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f646-1f3fd-200d-2642-fe0f",32,16,7,["\uD83D\uDE46\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f646-1f3fe-200d-2642-fe0f",32,17,7,["\uD83D\uDE46\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f646-1f3ff-200d-2642-fe0f",32,18,7,["\uD83D\uDE46\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f647-200d-2640-fe0f":{"1f3fb":["1f647-1f3fb-200d-2640-fe0f",32,26,7,["\uD83D\uDE47\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f647-1f3fc-200d-2640-fe0f",32,27,7,["\uD83D\uDE47\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f647-1f3fd-200d-2640-fe0f",32,28,7,["\uD83D\uDE47\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f647-1f3fe-200d-2640-fe0f",32,29,7,["\uD83D\uDE47\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f647-1f3ff-200d-2640-fe0f",32,30,7,["\uD83D\uDE47\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f647-200d-2642-fe0f":{"1f3fb":["1f647-1f3fb-200d-2642-fe0f",32,32,7,["\uD83D\uDE47\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83D\uDE47\uD83C\uDFFB"]],"1f3fc":["1f647-1f3fc-200d-2642-fe0f",32,33,7,["\uD83D\uDE47\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83D\uDE47\uD83C\uDFFC"]],"1f3fd":["1f647-1f3fd-200d-2642-fe0f",32,34,7,["\uD83D\uDE47\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83D\uDE47\uD83C\uDFFD"]],"1f3fe":["1f647-1f3fe-200d-2642-fe0f",32,35,7,["\uD83D\uDE47\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83D\uDE47\uD83C\uDFFE"]],"1f3ff":["1f647-1f3ff-200d-2642-fe0f",32,36,7,["\uD83D\uDE47\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83D\uDE47\uD83C\uDFFF"]]},

		"1f64b-200d-2640-fe0f":{"1f3fb":["1f64b-1f3fb-200d-2640-fe0f",32,47,7,["\uD83D\uDE4B\uD83C\uDFFB\u200D\u2640\uFE0F","\uD83D\uDE4B\uD83C\uDFFB"]],"1f3fc":["1f64b-1f3fc-200d-2640-fe0f",32,48,7,["\uD83D\uDE4B\uD83C\uDFFC\u200D\u2640\uFE0F","\uD83D\uDE4B\uD83C\uDFFC"]],"1f3fd":["1f64b-1f3fd-200d-2640-fe0f",32,49,7,["\uD83D\uDE4B\uD83C\uDFFD\u200D\u2640\uFE0F","\uD83D\uDE4B\uD83C\uDFFD"]],"1f3fe":["1f64b-1f3fe-200d-2640-fe0f",32,50,7,["\uD83D\uDE4B\uD83C\uDFFE\u200D\u2640\uFE0F","\uD83D\uDE4B\uD83C\uDFFE"]],"1f3ff":["1f64b-1f3ff-200d-2640-fe0f",32,51,7,["\uD83D\uDE4B\uD83C\uDFFF\u200D\u2640\uFE0F","\uD83D\uDE4B\uD83C\uDFFF"]]},

		"1f64b-200d-2642-fe0f":{"1f3fb":["1f64b-1f3fb-200d-2642-fe0f",33,1,7,["\uD83D\uDE4B\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f64b-1f3fc-200d-2642-fe0f",33,2,7,["\uD83D\uDE4B\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f64b-1f3fd-200d-2642-fe0f",33,3,7,["\uD83D\uDE4B\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f64b-1f3fe-200d-2642-fe0f",33,4,7,["\uD83D\uDE4B\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f64b-1f3ff-200d-2642-fe0f",33,5,7,["\uD83D\uDE4B\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f64c":{"1f3fb":["1f64c-1f3fb",33,13,31,["\uD83D\uDE4C\uD83C\uDFFB"]],"1f3fc":["1f64c-1f3fc",33,14,31,["\uD83D\uDE4C\uD83C\uDFFC"]],"1f3fd":["1f64c-1f3fd",33,15,31,["\uD83D\uDE4C\uD83C\uDFFD"]],"1f3fe":["1f64c-1f3fe",33,16,31,["\uD83D\uDE4C\uD83C\uDFFE"]],"1f3ff":["1f64c-1f3ff",33,17,31,["\uD83D\uDE4C\uD83C\uDFFF"]]},

		"1f64d-200d-2640-fe0f":{"1f3fb":["1f64d-1f3fb-200d-2640-fe0f",33,19,7,["\uD83D\uDE4D\uD83C\uDFFB\u200D\u2640\uFE0F","\uD83D\uDE4D\uD83C\uDFFB"]],"1f3fc":["1f64d-1f3fc-200d-2640-fe0f",33,20,7,["\uD83D\uDE4D\uD83C\uDFFC\u200D\u2640\uFE0F","\uD83D\uDE4D\uD83C\uDFFC"]],"1f3fd":["1f64d-1f3fd-200d-2640-fe0f",33,21,7,["\uD83D\uDE4D\uD83C\uDFFD\u200D\u2640\uFE0F","\uD83D\uDE4D\uD83C\uDFFD"]],"1f3fe":["1f64d-1f3fe-200d-2640-fe0f",33,22,7,["\uD83D\uDE4D\uD83C\uDFFE\u200D\u2640\uFE0F","\uD83D\uDE4D\uD83C\uDFFE"]],"1f3ff":["1f64d-1f3ff-200d-2640-fe0f",33,23,7,["\uD83D\uDE4D\uD83C\uDFFF\u200D\u2640\uFE0F","\uD83D\uDE4D\uD83C\uDFFF"]]},

		"1f64d-200d-2642-fe0f":{"1f3fb":["1f64d-1f3fb-200d-2642-fe0f",33,25,7,["\uD83D\uDE4D\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f64d-1f3fc-200d-2642-fe0f",33,26,7,["\uD83D\uDE4D\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f64d-1f3fd-200d-2642-fe0f",33,27,7,["\uD83D\uDE4D\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f64d-1f3fe-200d-2642-fe0f",33,28,7,["\uD83D\uDE4D\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f64d-1f3ff-200d-2642-fe0f",33,29,7,["\uD83D\uDE4D\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f64e-200d-2640-fe0f":{"1f3fb":["1f64e-1f3fb-200d-2640-fe0f",33,37,7,["\uD83D\uDE4E\uD83C\uDFFB\u200D\u2640\uFE0F","\uD83D\uDE4E\uD83C\uDFFB"]],"1f3fc":["1f64e-1f3fc-200d-2640-fe0f",33,38,7,["\uD83D\uDE4E\uD83C\uDFFC\u200D\u2640\uFE0F","\uD83D\uDE4E\uD83C\uDFFC"]],"1f3fd":["1f64e-1f3fd-200d-2640-fe0f",33,39,7,["\uD83D\uDE4E\uD83C\uDFFD\u200D\u2640\uFE0F","\uD83D\uDE4E\uD83C\uDFFD"]],"1f3fe":["1f64e-1f3fe-200d-2640-fe0f",33,40,7,["\uD83D\uDE4E\uD83C\uDFFE\u200D\u2640\uFE0F","\uD83D\uDE4E\uD83C\uDFFE"]],"1f3ff":["1f64e-1f3ff-200d-2640-fe0f",33,41,7,["\uD83D\uDE4E\uD83C\uDFFF\u200D\u2640\uFE0F","\uD83D\uDE4E\uD83C\uDFFF"]]},

		"1f64e-200d-2642-fe0f":{"1f3fb":["1f64e-1f3fb-200d-2642-fe0f",33,43,7,["\uD83D\uDE4E\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f64e-1f3fc-200d-2642-fe0f",33,44,7,["\uD83D\uDE4E\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f64e-1f3fd-200d-2642-fe0f",33,45,7,["\uD83D\uDE4E\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f64e-1f3fe-200d-2642-fe0f",33,46,7,["\uD83D\uDE4E\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f64e-1f3ff-200d-2642-fe0f",33,47,7,["\uD83D\uDE4E\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f64f":{"1f3fb":["1f64f-1f3fb",34,3,31,["\uD83D\uDE4F\uD83C\uDFFB"]],"1f3fc":["1f64f-1f3fc",34,4,31,["\uD83D\uDE4F\uD83C\uDFFC"]],"1f3fd":["1f64f-1f3fd",34,5,31,["\uD83D\uDE4F\uD83C\uDFFD"]],"1f3fe":["1f64f-1f3fe",34,6,31,["\uD83D\uDE4F\uD83C\uDFFE"]],"1f3ff":["1f64f-1f3ff",34,7,31,["\uD83D\uDE4F\uD83C\uDFFF"]]},

		"1f6a3-200d-2640-fe0f":{"1f3fb":["1f6a3-1f3fb-200d-2640-fe0f",34,44,7,["\uD83D\uDEA3\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f6a3-1f3fc-200d-2640-fe0f",34,45,7,["\uD83D\uDEA3\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f6a3-1f3fd-200d-2640-fe0f",34,46,7,["\uD83D\uDEA3\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f6a3-1f3fe-200d-2640-fe0f",34,47,7,["\uD83D\uDEA3\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f6a3-1f3ff-200d-2640-fe0f",34,48,7,["\uD83D\uDEA3\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f6a3-200d-2642-fe0f":{"1f3fb":["1f6a3-1f3fb-200d-2642-fe0f",34,50,7,["\uD83D\uDEA3\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83D\uDEA3\uD83C\uDFFB"]],"1f3fc":["1f6a3-1f3fc-200d-2642-fe0f",34,51,7,["\uD83D\uDEA3\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83D\uDEA3\uD83C\uDFFC"]],"1f3fd":["1f6a3-1f3fd-200d-2642-fe0f",35,0,7,["\uD83D\uDEA3\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83D\uDEA3\uD83C\uDFFD"]],"1f3fe":["1f6a3-1f3fe-200d-2642-fe0f",35,1,7,["\uD83D\uDEA3\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83D\uDEA3\uD83C\uDFFE"]],"1f3ff":["1f6a3-1f3ff-200d-2642-fe0f",35,2,7,["\uD83D\uDEA3\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83D\uDEA3\uD83C\uDFFF"]]},

		"1f6b4-200d-2640-fe0f":{"1f3fb":["1f6b4-1f3fb-200d-2640-fe0f",35,26,7,["\uD83D\uDEB4\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f6b4-1f3fc-200d-2640-fe0f",35,27,7,["\uD83D\uDEB4\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f6b4-1f3fd-200d-2640-fe0f",35,28,7,["\uD83D\uDEB4\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f6b4-1f3fe-200d-2640-fe0f",35,29,7,["\uD83D\uDEB4\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f6b4-1f3ff-200d-2640-fe0f",35,30,7,["\uD83D\uDEB4\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f6b4-200d-2642-fe0f":{"1f3fb":["1f6b4-1f3fb-200d-2642-fe0f",35,32,7,["\uD83D\uDEB4\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83D\uDEB4\uD83C\uDFFB"]],"1f3fc":["1f6b4-1f3fc-200d-2642-fe0f",35,33,7,["\uD83D\uDEB4\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83D\uDEB4\uD83C\uDFFC"]],"1f3fd":["1f6b4-1f3fd-200d-2642-fe0f",35,34,7,["\uD83D\uDEB4\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83D\uDEB4\uD83C\uDFFD"]],"1f3fe":["1f6b4-1f3fe-200d-2642-fe0f",35,35,7,["\uD83D\uDEB4\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83D\uDEB4\uD83C\uDFFE"]],"1f3ff":["1f6b4-1f3ff-200d-2642-fe0f",35,36,7,["\uD83D\uDEB4\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83D\uDEB4\uD83C\uDFFF"]]},

		"1f6b5-200d-2640-fe0f":{"1f3fb":["1f6b5-1f3fb-200d-2640-fe0f",35,44,7,["\uD83D\uDEB5\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f6b5-1f3fc-200d-2640-fe0f",35,45,7,["\uD83D\uDEB5\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f6b5-1f3fd-200d-2640-fe0f",35,46,7,["\uD83D\uDEB5\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f6b5-1f3fe-200d-2640-fe0f",35,47,7,["\uD83D\uDEB5\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f6b5-1f3ff-200d-2640-fe0f",35,48,7,["\uD83D\uDEB5\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f6b5-200d-2642-fe0f":{"1f3fb":["1f6b5-1f3fb-200d-2642-fe0f",35,50,7,["\uD83D\uDEB5\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83D\uDEB5\uD83C\uDFFB"]],"1f3fc":["1f6b5-1f3fc-200d-2642-fe0f",35,51,7,["\uD83D\uDEB5\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83D\uDEB5\uD83C\uDFFC"]],"1f3fd":["1f6b5-1f3fd-200d-2642-fe0f",36,0,7,["\uD83D\uDEB5\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83D\uDEB5\uD83C\uDFFD"]],"1f3fe":["1f6b5-1f3fe-200d-2642-fe0f",36,1,7,["\uD83D\uDEB5\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83D\uDEB5\uD83C\uDFFE"]],"1f3ff":["1f6b5-1f3ff-200d-2642-fe0f",36,2,7,["\uD83D\uDEB5\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83D\uDEB5\uD83C\uDFFF"]]},

		"1f6b6-200d-2640-fe0f":{"1f3fb":["1f6b6-1f3fb-200d-2640-fe0f",36,10,7,["\uD83D\uDEB6\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f6b6-1f3fc-200d-2640-fe0f",36,11,7,["\uD83D\uDEB6\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f6b6-1f3fd-200d-2640-fe0f",36,12,7,["\uD83D\uDEB6\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f6b6-1f3fe-200d-2640-fe0f",36,13,7,["\uD83D\uDEB6\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f6b6-1f3ff-200d-2640-fe0f",36,14,7,["\uD83D\uDEB6\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f6b6-200d-2642-fe0f":{"1f3fb":["1f6b6-1f3fb-200d-2642-fe0f",36,16,7,["\uD83D\uDEB6\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83D\uDEB6\uD83C\uDFFB"]],"1f3fc":["1f6b6-1f3fc-200d-2642-fe0f",36,17,7,["\uD83D\uDEB6\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83D\uDEB6\uD83C\uDFFC"]],"1f3fd":["1f6b6-1f3fd-200d-2642-fe0f",36,18,7,["\uD83D\uDEB6\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83D\uDEB6\uD83C\uDFFD"]],"1f3fe":["1f6b6-1f3fe-200d-2642-fe0f",36,19,7,["\uD83D\uDEB6\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83D\uDEB6\uD83C\uDFFE"]],"1f3ff":["1f6b6-1f3ff-200d-2642-fe0f",36,20,7,["\uD83D\uDEB6\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83D\uDEB6\uD83C\uDFFF"]]},

		"1f6c0":{"1f3fb":["1f6c0-1f3fb",36,37,31,["\uD83D\uDEC0\uD83C\uDFFB"]],"1f3fc":["1f6c0-1f3fc",36,38,31,["\uD83D\uDEC0\uD83C\uDFFC"]],"1f3fd":["1f6c0-1f3fd",36,39,31,["\uD83D\uDEC0\uD83C\uDFFD"]],"1f3fe":["1f6c0-1f3fe",36,40,31,["\uD83D\uDEC0\uD83C\uDFFE"]],"1f3ff":["1f6c0-1f3ff",36,41,31,["\uD83D\uDEC0\uD83C\uDFFF"]]},

		"1f6cc":{"1f3fb":["1f6cc-1f3fb",36,49,15,["\uD83D\uDECC\uD83C\uDFFB"]],"1f3fc":["1f6cc-1f3fc",36,50,15,["\uD83D\uDECC\uD83C\uDFFC"]],"1f3fd":["1f6cc-1f3fd",36,51,15,["\uD83D\uDECC\uD83C\uDFFD"]],"1f3fe":["1f6cc-1f3fe",37,0,15,["\uD83D\uDECC\uD83C\uDFFE"]],"1f3ff":["1f6cc-1f3ff",37,1,15,["\uD83D\uDECC\uD83C\uDFFF"]]},

		"1f918":{"1f3fb":["1f918-1f3fb",37,33,15,["\uD83E\uDD18\uD83C\uDFFB"]],"1f3fc":["1f918-1f3fc",37,34,15,["\uD83E\uDD18\uD83C\uDFFC"]],"1f3fd":["1f918-1f3fd",37,35,15,["\uD83E\uDD18\uD83C\uDFFD"]],"1f3fe":["1f918-1f3fe",37,36,15,["\uD83E\uDD18\uD83C\uDFFE"]],"1f3ff":["1f918-1f3ff",37,37,15,["\uD83E\uDD18\uD83C\uDFFF"]]},

		"1f919":{"1f3fb":["1f919-1f3fb",37,39,15,["\uD83E\uDD19\uD83C\uDFFB"]],"1f3fc":["1f919-1f3fc",37,40,15,["\uD83E\uDD19\uD83C\uDFFC"]],"1f3fd":["1f919-1f3fd",37,41,15,["\uD83E\uDD19\uD83C\uDFFD"]],"1f3fe":["1f919-1f3fe",37,42,15,["\uD83E\uDD19\uD83C\uDFFE"]],"1f3ff":["1f919-1f3ff",37,43,15,["\uD83E\uDD19\uD83C\uDFFF"]]},

		"1f91a":{"1f3fb":["1f91a-1f3fb",37,45,15,["\uD83E\uDD1A\uD83C\uDFFB"]],"1f3fc":["1f91a-1f3fc",37,46,15,["\uD83E\uDD1A\uD83C\uDFFC"]],"1f3fd":["1f91a-1f3fd",37,47,15,["\uD83E\uDD1A\uD83C\uDFFD"]],"1f3fe":["1f91a-1f3fe",37,48,15,["\uD83E\uDD1A\uD83C\uDFFE"]],"1f3ff":["1f91a-1f3ff",37,49,15,["\uD83E\uDD1A\uD83C\uDFFF"]]},

		"1f91b":{"1f3fb":["1f91b-1f3fb",37,51,15,["\uD83E\uDD1B\uD83C\uDFFB"]],"1f3fc":["1f91b-1f3fc",38,0,15,["\uD83E\uDD1B\uD83C\uDFFC"]],"1f3fd":["1f91b-1f3fd",38,1,15,["\uD83E\uDD1B\uD83C\uDFFD"]],"1f3fe":["1f91b-1f3fe",38,2,15,["\uD83E\uDD1B\uD83C\uDFFE"]],"1f3ff":["1f91b-1f3ff",38,3,15,["\uD83E\uDD1B\uD83C\uDFFF"]]},

		"1f91c":{"1f3fb":["1f91c-1f3fb",38,5,15,["\uD83E\uDD1C\uD83C\uDFFB"]],"1f3fc":["1f91c-1f3fc",38,6,15,["\uD83E\uDD1C\uD83C\uDFFC"]],"1f3fd":["1f91c-1f3fd",38,7,15,["\uD83E\uDD1C\uD83C\uDFFD"]],"1f3fe":["1f91c-1f3fe",38,8,15,["\uD83E\uDD1C\uD83C\uDFFE"]],"1f3ff":["1f91c-1f3ff",38,9,15,["\uD83E\uDD1C\uD83C\uDFFF"]]},

		"1f91e":{"1f3fb":["1f91e-1f3fb",38,12,15,["\uD83E\uDD1E\uD83C\uDFFB"]],"1f3fc":["1f91e-1f3fc",38,13,15,["\uD83E\uDD1E\uD83C\uDFFC"]],"1f3fd":["1f91e-1f3fd",38,14,15,["\uD83E\uDD1E\uD83C\uDFFD"]],"1f3fe":["1f91e-1f3fe",38,15,15,["\uD83E\uDD1E\uD83C\uDFFE"]],"1f3ff":["1f91e-1f3ff",38,16,15,["\uD83E\uDD1E\uD83C\uDFFF"]]},

		"1f91f":{"1f3fb":["1f91f-1f3fb",38,18,15,["\uD83E\uDD1F\uD83C\uDFFB"]],"1f3fc":["1f91f-1f3fc",38,19,15,["\uD83E\uDD1F\uD83C\uDFFC"]],"1f3fd":["1f91f-1f3fd",38,20,15,["\uD83E\uDD1F\uD83C\uDFFD"]],"1f3fe":["1f91f-1f3fe",38,21,15,["\uD83E\uDD1F\uD83C\uDFFE"]],"1f3ff":["1f91f-1f3ff",38,22,15,["\uD83E\uDD1F\uD83C\uDFFF"]]},

		"1f926-200d-2640-fe0f":{"1f3fb":["1f926-1f3fb-200d-2640-fe0f",38,30,7,["\uD83E\uDD26\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f926-1f3fc-200d-2640-fe0f",38,31,7,["\uD83E\uDD26\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f926-1f3fd-200d-2640-fe0f",38,32,7,["\uD83E\uDD26\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f926-1f3fe-200d-2640-fe0f",38,33,7,["\uD83E\uDD26\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f926-1f3ff-200d-2640-fe0f",38,34,7,["\uD83E\uDD26\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f926-200d-2642-fe0f":{"1f3fb":["1f926-1f3fb-200d-2642-fe0f",38,36,7,["\uD83E\uDD26\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f926-1f3fc-200d-2642-fe0f",38,37,7,["\uD83E\uDD26\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f926-1f3fd-200d-2642-fe0f",38,38,7,["\uD83E\uDD26\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f926-1f3fe-200d-2642-fe0f",38,39,7,["\uD83E\uDD26\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f926-1f3ff-200d-2642-fe0f",38,40,7,["\uD83E\uDD26\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f926":{"1f3fb":["1f926-1f3fb",38,42,7,["\uD83E\uDD26\uD83C\uDFFB"]],"1f3fc":["1f926-1f3fc",38,43,7,["\uD83E\uDD26\uD83C\uDFFC"]],"1f3fd":["1f926-1f3fd",38,44,7,["\uD83E\uDD26\uD83C\uDFFD"]],"1f3fe":["1f926-1f3fe",38,45,7,["\uD83E\uDD26\uD83C\uDFFE"]],"1f3ff":["1f926-1f3ff",38,46,7,["\uD83E\uDD26\uD83C\uDFFF"]]},

		"1f930":{"1f3fb":["1f930-1f3fb",39,5,15,["\uD83E\uDD30\uD83C\uDFFB"]],"1f3fc":["1f930-1f3fc",39,6,15,["\uD83E\uDD30\uD83C\uDFFC"]],"1f3fd":["1f930-1f3fd",39,7,15,["\uD83E\uDD30\uD83C\uDFFD"]],"1f3fe":["1f930-1f3fe",39,8,15,["\uD83E\uDD30\uD83C\uDFFE"]],"1f3ff":["1f930-1f3ff",39,9,15,["\uD83E\uDD30\uD83C\uDFFF"]]},

		"1f931":{"1f3fb":["1f931-1f3fb",39,11,15,["\uD83E\uDD31\uD83C\uDFFB"]],"1f3fc":["1f931-1f3fc",39,12,15,["\uD83E\uDD31\uD83C\uDFFC"]],"1f3fd":["1f931-1f3fd",39,13,15,["\uD83E\uDD31\uD83C\uDFFD"]],"1f3fe":["1f931-1f3fe",39,14,15,["\uD83E\uDD31\uD83C\uDFFE"]],"1f3ff":["1f931-1f3ff",39,15,15,["\uD83E\uDD31\uD83C\uDFFF"]]},

		"1f932":{"1f3fb":["1f932-1f3fb",39,17,15,["\uD83E\uDD32\uD83C\uDFFB"]],"1f3fc":["1f932-1f3fc",39,18,15,["\uD83E\uDD32\uD83C\uDFFC"]],"1f3fd":["1f932-1f3fd",39,19,15,["\uD83E\uDD32\uD83C\uDFFD"]],"1f3fe":["1f932-1f3fe",39,20,15,["\uD83E\uDD32\uD83C\uDFFE"]],"1f3ff":["1f932-1f3ff",39,21,15,["\uD83E\uDD32\uD83C\uDFFF"]]},

		"1f933":{"1f3fb":["1f933-1f3fb",39,23,15,["\uD83E\uDD33\uD83C\uDFFB"]],"1f3fc":["1f933-1f3fc",39,24,15,["\uD83E\uDD33\uD83C\uDFFC"]],"1f3fd":["1f933-1f3fd",39,25,15,["\uD83E\uDD33\uD83C\uDFFD"]],"1f3fe":["1f933-1f3fe",39,26,15,["\uD83E\uDD33\uD83C\uDFFE"]],"1f3ff":["1f933-1f3ff",39,27,15,["\uD83E\uDD33\uD83C\uDFFF"]]},

		"1f934":{"1f3fb":["1f934-1f3fb",39,29,15,["\uD83E\uDD34\uD83C\uDFFB"]],"1f3fc":["1f934-1f3fc",39,30,15,["\uD83E\uDD34\uD83C\uDFFC"]],"1f3fd":["1f934-1f3fd",39,31,15,["\uD83E\uDD34\uD83C\uDFFD"]],"1f3fe":["1f934-1f3fe",39,32,15,["\uD83E\uDD34\uD83C\uDFFE"]],"1f3ff":["1f934-1f3ff",39,33,15,["\uD83E\uDD34\uD83C\uDFFF"]]},

		"1f935":{"1f3fb":["1f935-1f3fb",39,35,15,["\uD83E\uDD35\uD83C\uDFFB"]],"1f3fc":["1f935-1f3fc",39,36,15,["\uD83E\uDD35\uD83C\uDFFC"]],"1f3fd":["1f935-1f3fd",39,37,15,["\uD83E\uDD35\uD83C\uDFFD"]],"1f3fe":["1f935-1f3fe",39,38,15,["\uD83E\uDD35\uD83C\uDFFE"]],"1f3ff":["1f935-1f3ff",39,39,15,["\uD83E\uDD35\uD83C\uDFFF"]]},

		"1f936":{"1f3fb":["1f936-1f3fb",39,41,15,["\uD83E\uDD36\uD83C\uDFFB"]],"1f3fc":["1f936-1f3fc",39,42,15,["\uD83E\uDD36\uD83C\uDFFC"]],"1f3fd":["1f936-1f3fd",39,43,15,["\uD83E\uDD36\uD83C\uDFFD"]],"1f3fe":["1f936-1f3fe",39,44,15,["\uD83E\uDD36\uD83C\uDFFE"]],"1f3ff":["1f936-1f3ff",39,45,15,["\uD83E\uDD36\uD83C\uDFFF"]]},

		"1f937-200d-2640-fe0f":{"1f3fb":["1f937-1f3fb-200d-2640-fe0f",39,47,7,["\uD83E\uDD37\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f937-1f3fc-200d-2640-fe0f",39,48,7,["\uD83E\uDD37\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f937-1f3fd-200d-2640-fe0f",39,49,7,["\uD83E\uDD37\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f937-1f3fe-200d-2640-fe0f",39,50,7,["\uD83E\uDD37\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f937-1f3ff-200d-2640-fe0f",39,51,7,["\uD83E\uDD37\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f937-200d-2642-fe0f":{"1f3fb":["1f937-1f3fb-200d-2642-fe0f",40,1,7,["\uD83E\uDD37\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f937-1f3fc-200d-2642-fe0f",40,2,7,["\uD83E\uDD37\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f937-1f3fd-200d-2642-fe0f",40,3,7,["\uD83E\uDD37\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f937-1f3fe-200d-2642-fe0f",40,4,7,["\uD83E\uDD37\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f937-1f3ff-200d-2642-fe0f",40,5,7,["\uD83E\uDD37\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f937":{"1f3fb":["1f937-1f3fb",40,7,7,["\uD83E\uDD37\uD83C\uDFFB"]],"1f3fc":["1f937-1f3fc",40,8,7,["\uD83E\uDD37\uD83C\uDFFC"]],"1f3fd":["1f937-1f3fd",40,9,7,["\uD83E\uDD37\uD83C\uDFFD"]],"1f3fe":["1f937-1f3fe",40,10,7,["\uD83E\uDD37\uD83C\uDFFE"]],"1f3ff":["1f937-1f3ff",40,11,7,["\uD83E\uDD37\uD83C\uDFFF"]]},

		"1f938-200d-2640-fe0f":{"1f3fb":["1f938-1f3fb-200d-2640-fe0f",40,13,7,["\uD83E\uDD38\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f938-1f3fc-200d-2640-fe0f",40,14,7,["\uD83E\uDD38\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f938-1f3fd-200d-2640-fe0f",40,15,7,["\uD83E\uDD38\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f938-1f3fe-200d-2640-fe0f",40,16,7,["\uD83E\uDD38\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f938-1f3ff-200d-2640-fe0f",40,17,7,["\uD83E\uDD38\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f938-200d-2642-fe0f":{"1f3fb":["1f938-1f3fb-200d-2642-fe0f",40,19,7,["\uD83E\uDD38\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f938-1f3fc-200d-2642-fe0f",40,20,7,["\uD83E\uDD38\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f938-1f3fd-200d-2642-fe0f",40,21,7,["\uD83E\uDD38\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f938-1f3fe-200d-2642-fe0f",40,22,7,["\uD83E\uDD38\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f938-1f3ff-200d-2642-fe0f",40,23,7,["\uD83E\uDD38\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f938":{"1f3fb":["1f938-1f3fb",40,25,7,["\uD83E\uDD38\uD83C\uDFFB"]],"1f3fc":["1f938-1f3fc",40,26,7,["\uD83E\uDD38\uD83C\uDFFC"]],"1f3fd":["1f938-1f3fd",40,27,7,["\uD83E\uDD38\uD83C\uDFFD"]],"1f3fe":["1f938-1f3fe",40,28,7,["\uD83E\uDD38\uD83C\uDFFE"]],"1f3ff":["1f938-1f3ff",40,29,7,["\uD83E\uDD38\uD83C\uDFFF"]]},

		"1f939-200d-2640-fe0f":{"1f3fb":["1f939-1f3fb-200d-2640-fe0f",40,31,7,["\uD83E\uDD39\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f939-1f3fc-200d-2640-fe0f",40,32,7,["\uD83E\uDD39\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f939-1f3fd-200d-2640-fe0f",40,33,7,["\uD83E\uDD39\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f939-1f3fe-200d-2640-fe0f",40,34,7,["\uD83E\uDD39\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f939-1f3ff-200d-2640-fe0f",40,35,7,["\uD83E\uDD39\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f939-200d-2642-fe0f":{"1f3fb":["1f939-1f3fb-200d-2642-fe0f",40,37,7,["\uD83E\uDD39\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f939-1f3fc-200d-2642-fe0f",40,38,7,["\uD83E\uDD39\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f939-1f3fd-200d-2642-fe0f",40,39,7,["\uD83E\uDD39\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f939-1f3fe-200d-2642-fe0f",40,40,7,["\uD83E\uDD39\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f939-1f3ff-200d-2642-fe0f",40,41,7,["\uD83E\uDD39\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f939":{"1f3fb":["1f939-1f3fb",40,43,15,["\uD83E\uDD39\uD83C\uDFFB"]],"1f3fc":["1f939-1f3fc",40,44,15,["\uD83E\uDD39\uD83C\uDFFC"]],"1f3fd":["1f939-1f3fd",40,45,15,["\uD83E\uDD39\uD83C\uDFFD"]],"1f3fe":["1f939-1f3fe",40,46,15,["\uD83E\uDD39\uD83C\uDFFE"]],"1f3ff":["1f939-1f3ff",40,47,15,["\uD83E\uDD39\uD83C\uDFFF"]]},

		"1f93d-200d-2640-fe0f":{"1f3fb":["1f93d-1f3fb-200d-2640-fe0f",41,1,7,["\uD83E\uDD3D\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f93d-1f3fc-200d-2640-fe0f",41,2,7,["\uD83E\uDD3D\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f93d-1f3fd-200d-2640-fe0f",41,3,7,["\uD83E\uDD3D\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f93d-1f3fe-200d-2640-fe0f",41,4,7,["\uD83E\uDD3D\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f93d-1f3ff-200d-2640-fe0f",41,5,7,["\uD83E\uDD3D\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f93d-200d-2642-fe0f":{"1f3fb":["1f93d-1f3fb-200d-2642-fe0f",41,7,7,["\uD83E\uDD3D\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f93d-1f3fc-200d-2642-fe0f",41,8,7,["\uD83E\uDD3D\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f93d-1f3fd-200d-2642-fe0f",41,9,7,["\uD83E\uDD3D\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f93d-1f3fe-200d-2642-fe0f",41,10,7,["\uD83E\uDD3D\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f93d-1f3ff-200d-2642-fe0f",41,11,7,["\uD83E\uDD3D\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f93d":{"1f3fb":["1f93d-1f3fb",41,13,7,["\uD83E\uDD3D\uD83C\uDFFB"]],"1f3fc":["1f93d-1f3fc",41,14,7,["\uD83E\uDD3D\uD83C\uDFFC"]],"1f3fd":["1f93d-1f3fd",41,15,7,["\uD83E\uDD3D\uD83C\uDFFD"]],"1f3fe":["1f93d-1f3fe",41,16,7,["\uD83E\uDD3D\uD83C\uDFFE"]],"1f3ff":["1f93d-1f3ff",41,17,7,["\uD83E\uDD3D\uD83C\uDFFF"]]},

		"1f93e-200d-2640-fe0f":{"1f3fb":["1f93e-1f3fb-200d-2640-fe0f",41,19,7,["\uD83E\uDD3E\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f93e-1f3fc-200d-2640-fe0f",41,20,7,["\uD83E\uDD3E\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f93e-1f3fd-200d-2640-fe0f",41,21,7,["\uD83E\uDD3E\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f93e-1f3fe-200d-2640-fe0f",41,22,7,["\uD83E\uDD3E\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f93e-1f3ff-200d-2640-fe0f",41,23,7,["\uD83E\uDD3E\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f93e-200d-2642-fe0f":{"1f3fb":["1f93e-1f3fb-200d-2642-fe0f",41,25,7,["\uD83E\uDD3E\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f93e-1f3fc-200d-2642-fe0f",41,26,7,["\uD83E\uDD3E\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f93e-1f3fd-200d-2642-fe0f",41,27,7,["\uD83E\uDD3E\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f93e-1f3fe-200d-2642-fe0f",41,28,7,["\uD83E\uDD3E\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f93e-1f3ff-200d-2642-fe0f",41,29,7,["\uD83E\uDD3E\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f93e":{"1f3fb":["1f93e-1f3fb",41,31,7,["\uD83E\uDD3E\uD83C\uDFFB"]],"1f3fc":["1f93e-1f3fc",41,32,7,["\uD83E\uDD3E\uD83C\uDFFC"]],"1f3fd":["1f93e-1f3fd",41,33,7,["\uD83E\uDD3E\uD83C\uDFFD"]],"1f3fe":["1f93e-1f3fe",41,34,7,["\uD83E\uDD3E\uD83C\uDFFE"]],"1f3ff":["1f93e-1f3ff",41,35,7,["\uD83E\uDD3E\uD83C\uDFFF"]]},

		"1f9d1":{"1f3fb":["1f9d1-1f3fb",42,51,15,["\uD83E\uDDD1\uD83C\uDFFB"]],"1f3fc":["1f9d1-1f3fc",43,0,15,["\uD83E\uDDD1\uD83C\uDFFC"]],"1f3fd":["1f9d1-1f3fd",43,1,15,["\uD83E\uDDD1\uD83C\uDFFD"]],"1f3fe":["1f9d1-1f3fe",43,2,15,["\uD83E\uDDD1\uD83C\uDFFE"]],"1f3ff":["1f9d1-1f3ff",43,3,15,["\uD83E\uDDD1\uD83C\uDFFF"]]},

		"1f9d2":{"1f3fb":["1f9d2-1f3fb",43,5,15,["\uD83E\uDDD2\uD83C\uDFFB"]],"1f3fc":["1f9d2-1f3fc",43,6,15,["\uD83E\uDDD2\uD83C\uDFFC"]],"1f3fd":["1f9d2-1f3fd",43,7,15,["\uD83E\uDDD2\uD83C\uDFFD"]],"1f3fe":["1f9d2-1f3fe",43,8,15,["\uD83E\uDDD2\uD83C\uDFFE"]],"1f3ff":["1f9d2-1f3ff",43,9,15,["\uD83E\uDDD2\uD83C\uDFFF"]]},

		"1f9d3":{"1f3fb":["1f9d3-1f3fb",43,11,15,["\uD83E\uDDD3\uD83C\uDFFB"]],"1f3fc":["1f9d3-1f3fc",43,12,15,["\uD83E\uDDD3\uD83C\uDFFC"]],"1f3fd":["1f9d3-1f3fd",43,13,15,["\uD83E\uDDD3\uD83C\uDFFD"]],"1f3fe":["1f9d3-1f3fe",43,14,15,["\uD83E\uDDD3\uD83C\uDFFE"]],"1f3ff":["1f9d3-1f3ff",43,15,15,["\uD83E\uDDD3\uD83C\uDFFF"]]},

		"1f9d4":{"1f3fb":["1f9d4-1f3fb",43,17,15,["\uD83E\uDDD4\uD83C\uDFFB"]],"1f3fc":["1f9d4-1f3fc",43,18,15,["\uD83E\uDDD4\uD83C\uDFFC"]],"1f3fd":["1f9d4-1f3fd",43,19,15,["\uD83E\uDDD4\uD83C\uDFFD"]],"1f3fe":["1f9d4-1f3fe",43,20,15,["\uD83E\uDDD4\uD83C\uDFFE"]],"1f3ff":["1f9d4-1f3ff",43,21,15,["\uD83E\uDDD4\uD83C\uDFFF"]]},

		"1f9d5":{"1f3fb":["1f9d5-1f3fb",43,23,15,["\uD83E\uDDD5\uD83C\uDFFB"]],"1f3fc":["1f9d5-1f3fc",43,24,15,["\uD83E\uDDD5\uD83C\uDFFC"]],"1f3fd":["1f9d5-1f3fd",43,25,15,["\uD83E\uDDD5\uD83C\uDFFD"]],"1f3fe":["1f9d5-1f3fe",43,26,15,["\uD83E\uDDD5\uD83C\uDFFE"]],"1f3ff":["1f9d5-1f3ff",43,27,15,["\uD83E\uDDD5\uD83C\uDFFF"]]},

		"1f9d6-200d-2640-fe0f":{"1f3fb":["1f9d6-1f3fb-200d-2640-fe0f",43,29,7,["\uD83E\uDDD6\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f9d6-1f3fc-200d-2640-fe0f",43,30,7,["\uD83E\uDDD6\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f9d6-1f3fd-200d-2640-fe0f",43,31,7,["\uD83E\uDDD6\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f9d6-1f3fe-200d-2640-fe0f",43,32,7,["\uD83E\uDDD6\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f9d6-1f3ff-200d-2640-fe0f",43,33,7,["\uD83E\uDDD6\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f9d6-200d-2642-fe0f":{"1f3fb":["1f9d6-1f3fb-200d-2642-fe0f",43,35,7,["\uD83E\uDDD6\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83E\uDDD6\uD83C\uDFFB"]],"1f3fc":["1f9d6-1f3fc-200d-2642-fe0f",43,36,7,["\uD83E\uDDD6\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83E\uDDD6\uD83C\uDFFC"]],"1f3fd":["1f9d6-1f3fd-200d-2642-fe0f",43,37,7,["\uD83E\uDDD6\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83E\uDDD6\uD83C\uDFFD"]],"1f3fe":["1f9d6-1f3fe-200d-2642-fe0f",43,38,7,["\uD83E\uDDD6\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83E\uDDD6\uD83C\uDFFE"]],"1f3ff":["1f9d6-1f3ff-200d-2642-fe0f",43,39,7,["\uD83E\uDDD6\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83E\uDDD6\uD83C\uDFFF"]]},

		"1f9d7-200d-2640-fe0f":{"1f3fb":["1f9d7-1f3fb-200d-2640-fe0f",43,47,7,["\uD83E\uDDD7\uD83C\uDFFB\u200D\u2640\uFE0F","\uD83E\uDDD7\uD83C\uDFFB"]],"1f3fc":["1f9d7-1f3fc-200d-2640-fe0f",43,48,7,["\uD83E\uDDD7\uD83C\uDFFC\u200D\u2640\uFE0F","\uD83E\uDDD7\uD83C\uDFFC"]],"1f3fd":["1f9d7-1f3fd-200d-2640-fe0f",43,49,7,["\uD83E\uDDD7\uD83C\uDFFD\u200D\u2640\uFE0F","\uD83E\uDDD7\uD83C\uDFFD"]],"1f3fe":["1f9d7-1f3fe-200d-2640-fe0f",43,50,7,["\uD83E\uDDD7\uD83C\uDFFE\u200D\u2640\uFE0F","\uD83E\uDDD7\uD83C\uDFFE"]],"1f3ff":["1f9d7-1f3ff-200d-2640-fe0f",43,51,7,["\uD83E\uDDD7\uD83C\uDFFF\u200D\u2640\uFE0F","\uD83E\uDDD7\uD83C\uDFFF"]]},

		"1f9d7-200d-2642-fe0f":{"1f3fb":["1f9d7-1f3fb-200d-2642-fe0f",44,1,7,["\uD83E\uDDD7\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f9d7-1f3fc-200d-2642-fe0f",44,2,7,["\uD83E\uDDD7\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f9d7-1f3fd-200d-2642-fe0f",44,3,7,["\uD83E\uDDD7\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f9d7-1f3fe-200d-2642-fe0f",44,4,7,["\uD83E\uDDD7\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f9d7-1f3ff-200d-2642-fe0f",44,5,7,["\uD83E\uDDD7\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f9d8-200d-2640-fe0f":{"1f3fb":["1f9d8-1f3fb-200d-2640-fe0f",44,13,7,["\uD83E\uDDD8\uD83C\uDFFB\u200D\u2640\uFE0F","\uD83E\uDDD8\uD83C\uDFFB"]],"1f3fc":["1f9d8-1f3fc-200d-2640-fe0f",44,14,7,["\uD83E\uDDD8\uD83C\uDFFC\u200D\u2640\uFE0F","\uD83E\uDDD8\uD83C\uDFFC"]],"1f3fd":["1f9d8-1f3fd-200d-2640-fe0f",44,15,7,["\uD83E\uDDD8\uD83C\uDFFD\u200D\u2640\uFE0F","\uD83E\uDDD8\uD83C\uDFFD"]],"1f3fe":["1f9d8-1f3fe-200d-2640-fe0f",44,16,7,["\uD83E\uDDD8\uD83C\uDFFE\u200D\u2640\uFE0F","\uD83E\uDDD8\uD83C\uDFFE"]],"1f3ff":["1f9d8-1f3ff-200d-2640-fe0f",44,17,7,["\uD83E\uDDD8\uD83C\uDFFF\u200D\u2640\uFE0F","\uD83E\uDDD8\uD83C\uDFFF"]]},

		"1f9d8-200d-2642-fe0f":{"1f3fb":["1f9d8-1f3fb-200d-2642-fe0f",44,19,7,["\uD83E\uDDD8\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f9d8-1f3fc-200d-2642-fe0f",44,20,7,["\uD83E\uDDD8\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f9d8-1f3fd-200d-2642-fe0f",44,21,7,["\uD83E\uDDD8\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f9d8-1f3fe-200d-2642-fe0f",44,22,7,["\uD83E\uDDD8\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f9d8-1f3ff-200d-2642-fe0f",44,23,7,["\uD83E\uDDD8\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f9d9-200d-2640-fe0f":{"1f3fb":["1f9d9-1f3fb-200d-2640-fe0f",44,31,7,["\uD83E\uDDD9\uD83C\uDFFB\u200D\u2640\uFE0F","\uD83E\uDDD9\uD83C\uDFFB"]],"1f3fc":["1f9d9-1f3fc-200d-2640-fe0f",44,32,7,["\uD83E\uDDD9\uD83C\uDFFC\u200D\u2640\uFE0F","\uD83E\uDDD9\uD83C\uDFFC"]],"1f3fd":["1f9d9-1f3fd-200d-2640-fe0f",44,33,7,["\uD83E\uDDD9\uD83C\uDFFD\u200D\u2640\uFE0F","\uD83E\uDDD9\uD83C\uDFFD"]],"1f3fe":["1f9d9-1f3fe-200d-2640-fe0f",44,34,7,["\uD83E\uDDD9\uD83C\uDFFE\u200D\u2640\uFE0F","\uD83E\uDDD9\uD83C\uDFFE"]],"1f3ff":["1f9d9-1f3ff-200d-2640-fe0f",44,35,7,["\uD83E\uDDD9\uD83C\uDFFF\u200D\u2640\uFE0F","\uD83E\uDDD9\uD83C\uDFFF"]]},

		"1f9d9-200d-2642-fe0f":{"1f3fb":["1f9d9-1f3fb-200d-2642-fe0f",44,37,7,["\uD83E\uDDD9\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f9d9-1f3fc-200d-2642-fe0f",44,38,7,["\uD83E\uDDD9\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f9d9-1f3fd-200d-2642-fe0f",44,39,7,["\uD83E\uDDD9\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f9d9-1f3fe-200d-2642-fe0f",44,40,7,["\uD83E\uDDD9\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f9d9-1f3ff-200d-2642-fe0f",44,41,7,["\uD83E\uDDD9\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f9da-200d-2640-fe0f":{"1f3fb":["1f9da-1f3fb-200d-2640-fe0f",44,49,7,["\uD83E\uDDDA\uD83C\uDFFB\u200D\u2640\uFE0F","\uD83E\uDDDA\uD83C\uDFFB"]],"1f3fc":["1f9da-1f3fc-200d-2640-fe0f",44,50,7,["\uD83E\uDDDA\uD83C\uDFFC\u200D\u2640\uFE0F","\uD83E\uDDDA\uD83C\uDFFC"]],"1f3fd":["1f9da-1f3fd-200d-2640-fe0f",44,51,7,["\uD83E\uDDDA\uD83C\uDFFD\u200D\u2640\uFE0F","\uD83E\uDDDA\uD83C\uDFFD"]],"1f3fe":["1f9da-1f3fe-200d-2640-fe0f",45,0,7,["\uD83E\uDDDA\uD83C\uDFFE\u200D\u2640\uFE0F","\uD83E\uDDDA\uD83C\uDFFE"]],"1f3ff":["1f9da-1f3ff-200d-2640-fe0f",45,1,7,["\uD83E\uDDDA\uD83C\uDFFF\u200D\u2640\uFE0F","\uD83E\uDDDA\uD83C\uDFFF"]]},

		"1f9da-200d-2642-fe0f":{"1f3fb":["1f9da-1f3fb-200d-2642-fe0f",45,3,7,["\uD83E\uDDDA\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f9da-1f3fc-200d-2642-fe0f",45,4,7,["\uD83E\uDDDA\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f9da-1f3fd-200d-2642-fe0f",45,5,7,["\uD83E\uDDDA\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f9da-1f3fe-200d-2642-fe0f",45,6,7,["\uD83E\uDDDA\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f9da-1f3ff-200d-2642-fe0f",45,7,7,["\uD83E\uDDDA\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f9db-200d-2640-fe0f":{"1f3fb":["1f9db-1f3fb-200d-2640-fe0f",45,15,7,["\uD83E\uDDDB\uD83C\uDFFB\u200D\u2640\uFE0F","\uD83E\uDDDB\uD83C\uDFFB"]],"1f3fc":["1f9db-1f3fc-200d-2640-fe0f",45,16,7,["\uD83E\uDDDB\uD83C\uDFFC\u200D\u2640\uFE0F","\uD83E\uDDDB\uD83C\uDFFC"]],"1f3fd":["1f9db-1f3fd-200d-2640-fe0f",45,17,7,["\uD83E\uDDDB\uD83C\uDFFD\u200D\u2640\uFE0F","\uD83E\uDDDB\uD83C\uDFFD"]],"1f3fe":["1f9db-1f3fe-200d-2640-fe0f",45,18,7,["\uD83E\uDDDB\uD83C\uDFFE\u200D\u2640\uFE0F","\uD83E\uDDDB\uD83C\uDFFE"]],"1f3ff":["1f9db-1f3ff-200d-2640-fe0f",45,19,7,["\uD83E\uDDDB\uD83C\uDFFF\u200D\u2640\uFE0F","\uD83E\uDDDB\uD83C\uDFFF"]]},

		"1f9db-200d-2642-fe0f":{"1f3fb":["1f9db-1f3fb-200d-2642-fe0f",45,21,7,["\uD83E\uDDDB\uD83C\uDFFB\u200D\u2642\uFE0F"]],"1f3fc":["1f9db-1f3fc-200d-2642-fe0f",45,22,7,["\uD83E\uDDDB\uD83C\uDFFC\u200D\u2642\uFE0F"]],"1f3fd":["1f9db-1f3fd-200d-2642-fe0f",45,23,7,["\uD83E\uDDDB\uD83C\uDFFD\u200D\u2642\uFE0F"]],"1f3fe":["1f9db-1f3fe-200d-2642-fe0f",45,24,7,["\uD83E\uDDDB\uD83C\uDFFE\u200D\u2642\uFE0F"]],"1f3ff":["1f9db-1f3ff-200d-2642-fe0f",45,25,7,["\uD83E\uDDDB\uD83C\uDFFF\u200D\u2642\uFE0F"]]},

		"1f9dc-200d-2640-fe0f":{"1f3fb":["1f9dc-1f3fb-200d-2640-fe0f",45,33,7,["\uD83E\uDDDC\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f9dc-1f3fc-200d-2640-fe0f",45,34,7,["\uD83E\uDDDC\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f9dc-1f3fd-200d-2640-fe0f",45,35,7,["\uD83E\uDDDC\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f9dc-1f3fe-200d-2640-fe0f",45,36,7,["\uD83E\uDDDC\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f9dc-1f3ff-200d-2640-fe0f",45,37,7,["\uD83E\uDDDC\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f9dc-200d-2642-fe0f":{"1f3fb":["1f9dc-1f3fb-200d-2642-fe0f",45,39,7,["\uD83E\uDDDC\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83E\uDDDC\uD83C\uDFFB"]],"1f3fc":["1f9dc-1f3fc-200d-2642-fe0f",45,40,7,["\uD83E\uDDDC\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83E\uDDDC\uD83C\uDFFC"]],"1f3fd":["1f9dc-1f3fd-200d-2642-fe0f",45,41,7,["\uD83E\uDDDC\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83E\uDDDC\uD83C\uDFFD"]],"1f3fe":["1f9dc-1f3fe-200d-2642-fe0f",45,42,7,["\uD83E\uDDDC\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83E\uDDDC\uD83C\uDFFE"]],"1f3ff":["1f9dc-1f3ff-200d-2642-fe0f",45,43,7,["\uD83E\uDDDC\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83E\uDDDC\uD83C\uDFFF"]]},

		"1f9dd-200d-2640-fe0f":{"1f3fb":["1f9dd-1f3fb-200d-2640-fe0f",45,51,7,["\uD83E\uDDDD\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["1f9dd-1f3fc-200d-2640-fe0f",46,0,7,["\uD83E\uDDDD\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["1f9dd-1f3fd-200d-2640-fe0f",46,1,7,["\uD83E\uDDDD\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["1f9dd-1f3fe-200d-2640-fe0f",46,2,7,["\uD83E\uDDDD\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["1f9dd-1f3ff-200d-2640-fe0f",46,3,7,["\uD83E\uDDDD\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"1f9dd-200d-2642-fe0f":{"1f3fb":["1f9dd-1f3fb-200d-2642-fe0f",46,5,7,["\uD83E\uDDDD\uD83C\uDFFB\u200D\u2642\uFE0F","\uD83E\uDDDD\uD83C\uDFFB"]],"1f3fc":["1f9dd-1f3fc-200d-2642-fe0f",46,6,7,["\uD83E\uDDDD\uD83C\uDFFC\u200D\u2642\uFE0F","\uD83E\uDDDD\uD83C\uDFFC"]],"1f3fd":["1f9dd-1f3fd-200d-2642-fe0f",46,7,7,["\uD83E\uDDDD\uD83C\uDFFD\u200D\u2642\uFE0F","\uD83E\uDDDD\uD83C\uDFFD"]],"1f3fe":["1f9dd-1f3fe-200d-2642-fe0f",46,8,7,["\uD83E\uDDDD\uD83C\uDFFE\u200D\u2642\uFE0F","\uD83E\uDDDD\uD83C\uDFFE"]],"1f3ff":["1f9dd-1f3ff-200d-2642-fe0f",46,9,7,["\uD83E\uDDDD\uD83C\uDFFF\u200D\u2642\uFE0F","\uD83E\uDDDD\uD83C\uDFFF"]]},

		"261d-fe0f":{"1f3fb":["261d-1f3fb",47,27,31,["\u261D\uD83C\uDFFB"]],"1f3fc":["261d-1f3fc",47,28,31,["\u261D\uD83C\uDFFC"]],"1f3fd":["261d-1f3fd",47,29,31,["\u261D\uD83C\uDFFD"]],"1f3fe":["261d-1f3fe",47,30,31,["\u261D\uD83C\uDFFE"]],"1f3ff":["261d-1f3ff",47,31,31,["\u261D\uD83C\uDFFF"]]},

		"26f9-fe0f-200d-2640-fe0f":{"1f3fb":["26f9-1f3fb-200d-2640-fe0f",48,47,7,["\u26F9\uD83C\uDFFB\u200D\u2640\uFE0F"]],"1f3fc":["26f9-1f3fc-200d-2640-fe0f",48,48,7,["\u26F9\uD83C\uDFFC\u200D\u2640\uFE0F"]],"1f3fd":["26f9-1f3fd-200d-2640-fe0f",48,49,7,["\u26F9\uD83C\uDFFD\u200D\u2640\uFE0F"]],"1f3fe":["26f9-1f3fe-200d-2640-fe0f",48,50,7,["\u26F9\uD83C\uDFFE\u200D\u2640\uFE0F"]],"1f3ff":["26f9-1f3ff-200d-2640-fe0f",48,51,7,["\u26F9\uD83C\uDFFF\u200D\u2640\uFE0F"]]},

		"26f9-fe0f-200d-2642-fe0f":{"1f3fb":["26f9-1f3fb-200d-2642-fe0f",49,1,7,["\u26F9\uD83C\uDFFB\u200D\u2642\uFE0F","\u26F9\uD83C\uDFFB"]],"1f3fc":["26f9-1f3fc-200d-2642-fe0f",49,2,7,["\u26F9\uD83C\uDFFC\u200D\u2642\uFE0F","\u26F9\uD83C\uDFFC"]],"1f3fd":["26f9-1f3fd-200d-2642-fe0f",49,3,7,["\u26F9\uD83C\uDFFD\u200D\u2642\uFE0F","\u26F9\uD83C\uDFFD"]],"1f3fe":["26f9-1f3fe-200d-2642-fe0f",49,4,7,["\u26F9\uD83C\uDFFE\u200D\u2642\uFE0F","\u26F9\uD83C\uDFFE"]],"1f3ff":["26f9-1f3ff-200d-2642-fe0f",49,5,7,["\u26F9\uD83C\uDFFF\u200D\u2642\uFE0F","\u26F9\uD83C\uDFFF"]]},

		"270a":{"1f3fb":["270a-1f3fb",49,19,31,["\u270A\uD83C\uDFFB"]],"1f3fc":["270a-1f3fc",49,20,31,["\u270A\uD83C\uDFFC"]],"1f3fd":["270a-1f3fd",49,21,31,["\u270A\uD83C\uDFFD"]],"1f3fe":["270a-1f3fe",49,22,31,["\u270A\uD83C\uDFFE"]],"1f3ff":["270a-1f3ff",49,23,31,["\u270A\uD83C\uDFFF"]]},

		"270b":{"1f3fb":["270b-1f3fb",49,25,31,["\u270B\uD83C\uDFFB"]],"1f3fc":["270b-1f3fc",49,26,31,["\u270B\uD83C\uDFFC"]],"1f3fd":["270b-1f3fd",49,27,31,["\u270B\uD83C\uDFFD"]],"1f3fe":["270b-1f3fe",49,28,31,["\u270B\uD83C\uDFFE"]],"1f3ff":["270b-1f3ff",49,29,31,["\u270B\uD83C\uDFFF"]]},

		"270c-fe0f":{"1f3fb":["270c-1f3fb",49,31,31,["\u270C\uD83C\uDFFB"]],"1f3fc":["270c-1f3fc",49,32,31,["\u270C\uD83C\uDFFC"]],"1f3fd":["270c-1f3fd",49,33,31,["\u270C\uD83C\uDFFD"]],"1f3fe":["270c-1f3fe",49,34,31,["\u270C\uD83C\uDFFE"]],"1f3ff":["270c-1f3ff",49,35,31,["\u270C\uD83C\uDFFF"]]},

		"270d-fe0f":{"1f3fb":["270d-1f3fb",49,37,15,["\u270D\uD83C\uDFFB"]],"1f3fc":["270d-1f3fc",49,38,15,["\u270D\uD83C\uDFFC"]],"1f3fd":["270d-1f3fd",49,39,15,["\u270D\uD83C\uDFFD"]],"1f3fe":["270d-1f3fe",49,40,15,["\u270D\uD83C\uDFFE"]],"1f3ff":["270d-1f3ff",49,41,15,["\u270D\uD83C\uDFFF"]]}

	};

	/** @private */

	emoji.prototype.obsoletes_data = {

		"1f3c3-200d-2642-fe0f":["1f3c3",9,46,23],

		"1f3c3-1f3fb-200d-2642-fe0f":["1f3c3-1f3fb",9,47,23],

		"1f3c3-1f3fc-200d-2642-fe0f":["1f3c3-1f3fc",9,48,23],

		"1f3c3-1f3fd-200d-2642-fe0f":["1f3c3-1f3fd",9,49,23],

		"1f3c3-1f3fe-200d-2642-fe0f":["1f3c3-1f3fe",9,50,23],

		"1f3c3-1f3ff-200d-2642-fe0f":["1f3c3-1f3ff",9,51,23],

		"1f3c4-200d-2642-fe0f":["1f3c4",10,12,23],

		"1f3c4-1f3fb-200d-2642-fe0f":["1f3c4-1f3fb",10,13,23],

		"1f3c4-1f3fc-200d-2642-fe0f":["1f3c4-1f3fc",10,14,23],

		"1f3c4-1f3fd-200d-2642-fe0f":["1f3c4-1f3fd",10,15,23],

		"1f3c4-1f3fe-200d-2642-fe0f":["1f3c4-1f3fe",10,16,23],

		"1f3c4-1f3ff-200d-2642-fe0f":["1f3c4-1f3ff",10,17,23],

		"1f3ca-200d-2642-fe0f":["1f3ca",10,40,23],

		"1f3ca-1f3fb-200d-2642-fe0f":["1f3ca-1f3fb",10,41,23],

		"1f3ca-1f3fc-200d-2642-fe0f":["1f3ca-1f3fc",10,42,23],

		"1f3ca-1f3fd-200d-2642-fe0f":["1f3ca-1f3fd",10,43,23],

		"1f3ca-1f3fe-200d-2642-fe0f":["1f3ca-1f3fe",10,44,23],

		"1f3ca-1f3ff-200d-2642-fe0f":["1f3ca-1f3ff",10,45,23],

		"1f3cb-fe0f-200d-2642-fe0f":["1f3cb-fe0f",11,6,7],

		"1f3cb-1f3fb-200d-2642-fe0f":["1f3cb-1f3fb",11,7,7],

		"1f3cb-1f3fc-200d-2642-fe0f":["1f3cb-1f3fc",11,8,7],

		"1f3cb-1f3fd-200d-2642-fe0f":["1f3cb-1f3fd",11,9,7],

		"1f3cb-1f3fe-200d-2642-fe0f":["1f3cb-1f3fe",11,10,7],

		"1f3cb-1f3ff-200d-2642-fe0f":["1f3cb-1f3ff",11,11,7],

		"1f3cc-fe0f-200d-2642-fe0f":["1f3cc-fe0f",11,24,7],

		"1f3cc-1f3fb-200d-2642-fe0f":["1f3cc-1f3fb",11,25,7],

		"1f3cc-1f3fc-200d-2642-fe0f":["1f3cc-1f3fc",11,26,7],

		"1f3cc-1f3fd-200d-2642-fe0f":["1f3cc-1f3fd",11,27,7],

		"1f3cc-1f3fe-200d-2642-fe0f":["1f3cc-1f3fe",11,28,7],

		"1f3cc-1f3ff-200d-2642-fe0f":["1f3cc-1f3ff",11,29,7],

		"1f468-200d-1f469-200d-1f466":["1f46a",20,29,23],

		"1f46e-200d-2642-fe0f":["1f46e",20,45,23],

		"1f46e-1f3fb-200d-2642-fe0f":["1f46e-1f3fb",20,46,23],

		"1f46e-1f3fc-200d-2642-fe0f":["1f46e-1f3fc",20,47,23],

		"1f46e-1f3fd-200d-2642-fe0f":["1f46e-1f3fd",20,48,23],

		"1f46e-1f3fe-200d-2642-fe0f":["1f46e-1f3fe",20,49,23],

		"1f46e-1f3ff-200d-2642-fe0f":["1f46e-1f3ff",20,50,23],

		"1f46f-200d-2640-fe0f":["1f46f",21,1,23],

		"1f471-200d-2642-fe0f":["1f471",21,20,23],

		"1f471-1f3fb-200d-2642-fe0f":["1f471-1f3fb",21,21,23],

		"1f471-1f3fc-200d-2642-fe0f":["1f471-1f3fc",21,22,23],

		"1f471-1f3fd-200d-2642-fe0f":["1f471-1f3fd",21,23,23],

		"1f471-1f3fe-200d-2642-fe0f":["1f471-1f3fe",21,24,23],

		"1f471-1f3ff-200d-2642-fe0f":["1f471-1f3ff",21,25,23],

		"1f473-200d-2642-fe0f":["1f473",21,44,23],

		"1f473-1f3fb-200d-2642-fe0f":["1f473-1f3fb",21,45,23],

		"1f473-1f3fc-200d-2642-fe0f":["1f473-1f3fc",21,46,23],

		"1f473-1f3fd-200d-2642-fe0f":["1f473-1f3fd",21,47,23],

		"1f473-1f3fe-200d-2642-fe0f":["1f473-1f3fe",21,48,23],

		"1f473-1f3ff-200d-2642-fe0f":["1f473-1f3ff",21,49,23],

		"1f477-200d-2642-fe0f":["1f477",22,28,23],

		"1f477-1f3fb-200d-2642-fe0f":["1f477-1f3fb",22,29,23],

		"1f477-1f3fc-200d-2642-fe0f":["1f477-1f3fc",22,30,23],

		"1f477-1f3fd-200d-2642-fe0f":["1f477-1f3fd",22,31,23],

		"1f477-1f3fe-200d-2642-fe0f":["1f477-1f3fe",22,32,23],

		"1f477-1f3ff-200d-2642-fe0f":["1f477-1f3ff",22,33,23],

		"1f481-200d-2640-fe0f":["1f481",23,13,23],

		"1f481-1f3fb-200d-2640-fe0f":["1f481-1f3fb",23,14,23],

		"1f481-1f3fc-200d-2640-fe0f":["1f481-1f3fc",23,15,23],

		"1f481-1f3fd-200d-2640-fe0f":["1f481-1f3fd",23,16,23],

		"1f481-1f3fe-200d-2640-fe0f":["1f481-1f3fe",23,17,23],

		"1f481-1f3ff-200d-2640-fe0f":["1f481-1f3ff",23,18,23],

		"1f482-200d-2642-fe0f":["1f482",23,31,23],

		"1f482-1f3fb-200d-2642-fe0f":["1f482-1f3fb",23,32,23],

		"1f482-1f3fc-200d-2642-fe0f":["1f482-1f3fc",23,33,23],

		"1f482-1f3fd-200d-2642-fe0f":["1f482-1f3fd",23,34,23],

		"1f482-1f3fe-200d-2642-fe0f":["1f482-1f3fe",23,35,23],

		"1f482-1f3ff-200d-2642-fe0f":["1f482-1f3ff",23,36,23],

		"1f486-200d-2640-fe0f":["1f486",24,10,23],

		"1f486-1f3fb-200d-2640-fe0f":["1f486-1f3fb",24,11,23],

		"1f486-1f3fc-200d-2640-fe0f":["1f486-1f3fc",24,12,23],

		"1f486-1f3fd-200d-2640-fe0f":["1f486-1f3fd",24,13,23],

		"1f486-1f3fe-200d-2640-fe0f":["1f486-1f3fe",24,14,23],

		"1f486-1f3ff-200d-2640-fe0f":["1f486-1f3ff",24,15,23],

		"1f487-200d-2640-fe0f":["1f487",24,28,23],

		"1f487-1f3fb-200d-2640-fe0f":["1f487-1f3fb",24,29,23],

		"1f487-1f3fc-200d-2640-fe0f":["1f487-1f3fc",24,30,23],

		"1f487-1f3fd-200d-2640-fe0f":["1f487-1f3fd",24,31,23],

		"1f487-1f3fe-200d-2640-fe0f":["1f487-1f3fe",24,32,23],

		"1f487-1f3ff-200d-2640-fe0f":["1f487-1f3ff",24,33,23],

		"1f469-200d-2764-fe0f-200d-1f48b-200d-1f468":["1f48f",24,41,23],

		"1f469-200d-2764-fe0f-200d-1f468":["1f491",24,43,23],

		"1f575-fe0f-200d-2642-fe0f":["1f575-fe0f",29,11,7],

		"1f575-1f3fb-200d-2642-fe0f":["1f575-1f3fb",29,12,7],

		"1f575-1f3fc-200d-2642-fe0f":["1f575-1f3fc",29,13,7],

		"1f575-1f3fd-200d-2642-fe0f":["1f575-1f3fd",29,14,7],

		"1f575-1f3fe-200d-2642-fe0f":["1f575-1f3fe",29,15,7],

		"1f575-1f3ff-200d-2642-fe0f":["1f575-1f3ff",29,16,7],

		"1f645-200d-2640-fe0f":["1f645",32,1,23],

		"1f645-1f3fb-200d-2640-fe0f":["1f645-1f3fb",32,2,23],

		"1f645-1f3fc-200d-2640-fe0f":["1f645-1f3fc",32,3,23],

		"1f645-1f3fd-200d-2640-fe0f":["1f645-1f3fd",32,4,23],

		"1f645-1f3fe-200d-2640-fe0f":["1f645-1f3fe",32,5,23],

		"1f645-1f3ff-200d-2640-fe0f":["1f645-1f3ff",32,6,23],

		"1f646-200d-2640-fe0f":["1f646",32,19,23],

		"1f646-1f3fb-200d-2640-fe0f":["1f646-1f3fb",32,20,23],

		"1f646-1f3fc-200d-2640-fe0f":["1f646-1f3fc",32,21,23],

		"1f646-1f3fd-200d-2640-fe0f":["1f646-1f3fd",32,22,23],

		"1f646-1f3fe-200d-2640-fe0f":["1f646-1f3fe",32,23,23],

		"1f646-1f3ff-200d-2640-fe0f":["1f646-1f3ff",32,24,23],

		"1f647-200d-2642-fe0f":["1f647",32,37,23],

		"1f647-1f3fb-200d-2642-fe0f":["1f647-1f3fb",32,38,23],

		"1f647-1f3fc-200d-2642-fe0f":["1f647-1f3fc",32,39,23],

		"1f647-1f3fd-200d-2642-fe0f":["1f647-1f3fd",32,40,23],

		"1f647-1f3fe-200d-2642-fe0f":["1f647-1f3fe",32,41,23],

		"1f647-1f3ff-200d-2642-fe0f":["1f647-1f3ff",32,42,23],

		"1f64b-200d-2640-fe0f":["1f64b",33,6,23],

		"1f64b-1f3fb-200d-2640-fe0f":["1f64b-1f3fb",33,7,23],

		"1f64b-1f3fc-200d-2640-fe0f":["1f64b-1f3fc",33,8,23],

		"1f64b-1f3fd-200d-2640-fe0f":["1f64b-1f3fd",33,9,23],

		"1f64b-1f3fe-200d-2640-fe0f":["1f64b-1f3fe",33,10,23],

		"1f64b-1f3ff-200d-2640-fe0f":["1f64b-1f3ff",33,11,23],

		"1f64d-200d-2640-fe0f":["1f64d",33,30,23],

		"1f64d-1f3fb-200d-2640-fe0f":["1f64d-1f3fb",33,31,23],

		"1f64d-1f3fc-200d-2640-fe0f":["1f64d-1f3fc",33,32,23],

		"1f64d-1f3fd-200d-2640-fe0f":["1f64d-1f3fd",33,33,23],

		"1f64d-1f3fe-200d-2640-fe0f":["1f64d-1f3fe",33,34,23],

		"1f64d-1f3ff-200d-2640-fe0f":["1f64d-1f3ff",33,35,23],

		"1f64e-200d-2640-fe0f":["1f64e",33,48,23],

		"1f64e-1f3fb-200d-2640-fe0f":["1f64e-1f3fb",33,49,23],

		"1f64e-1f3fc-200d-2640-fe0f":["1f64e-1f3fc",33,50,23],

		"1f64e-1f3fd-200d-2640-fe0f":["1f64e-1f3fd",33,51,23],

		"1f64e-1f3fe-200d-2640-fe0f":["1f64e-1f3fe",34,0,23],

		"1f64e-1f3ff-200d-2640-fe0f":["1f64e-1f3ff",34,1,23],

		"1f6a3-200d-2642-fe0f":["1f6a3",35,3,23],

		"1f6a3-1f3fb-200d-2642-fe0f":["1f6a3-1f3fb",35,4,7],

		"1f6a3-1f3fc-200d-2642-fe0f":["1f6a3-1f3fc",35,5,7],

		"1f6a3-1f3fd-200d-2642-fe0f":["1f6a3-1f3fd",35,6,7],

		"1f6a3-1f3fe-200d-2642-fe0f":["1f6a3-1f3fe",35,7,7],

		"1f6a3-1f3ff-200d-2642-fe0f":["1f6a3-1f3ff",35,8,7],

		"1f6b4-200d-2642-fe0f":["1f6b4",35,37,23],

		"1f6b4-1f3fb-200d-2642-fe0f":["1f6b4-1f3fb",35,38,23],

		"1f6b4-1f3fc-200d-2642-fe0f":["1f6b4-1f3fc",35,39,23],

		"1f6b4-1f3fd-200d-2642-fe0f":["1f6b4-1f3fd",35,40,23],

		"1f6b4-1f3fe-200d-2642-fe0f":["1f6b4-1f3fe",35,41,23],

		"1f6b4-1f3ff-200d-2642-fe0f":["1f6b4-1f3ff",35,42,23],

		"1f6b5-200d-2642-fe0f":["1f6b5",36,3,23],

		"1f6b5-1f3fb-200d-2642-fe0f":["1f6b5-1f3fb",36,4,23],

		"1f6b5-1f3fc-200d-2642-fe0f":["1f6b5-1f3fc",36,5,23],

		"1f6b5-1f3fd-200d-2642-fe0f":["1f6b5-1f3fd",36,6,23],

		"1f6b5-1f3fe-200d-2642-fe0f":["1f6b5-1f3fe",36,7,23],

		"1f6b5-1f3ff-200d-2642-fe0f":["1f6b5-1f3ff",36,8,23],

		"1f6b6-200d-2642-fe0f":["1f6b6",36,21,23],

		"1f6b6-1f3fb-200d-2642-fe0f":["1f6b6-1f3fb",36,22,23],

		"1f6b6-1f3fc-200d-2642-fe0f":["1f6b6-1f3fc",36,23,23],

		"1f6b6-1f3fd-200d-2642-fe0f":["1f6b6-1f3fd",36,24,23],

		"1f6b6-1f3fe-200d-2642-fe0f":["1f6b6-1f3fe",36,25,23],

		"1f6b6-1f3ff-200d-2642-fe0f":["1f6b6-1f3ff",36,26,23],

		"1f9d6-200d-2642-fe0f":["1f9d6",43,40,15],

		"1f9d6-1f3fb-200d-2642-fe0f":["1f9d6-1f3fb",43,41,15],

		"1f9d6-1f3fc-200d-2642-fe0f":["1f9d6-1f3fc",43,42,15],

		"1f9d6-1f3fd-200d-2642-fe0f":["1f9d6-1f3fd",43,43,15],

		"1f9d6-1f3fe-200d-2642-fe0f":["1f9d6-1f3fe",43,44,15],

		"1f9d6-1f3ff-200d-2642-fe0f":["1f9d6-1f3ff",43,45,15],

		"1f9d7-200d-2640-fe0f":["1f9d7",44,6,15],

		"1f9d7-1f3fb-200d-2640-fe0f":["1f9d7-1f3fb",44,7,15],

		"1f9d7-1f3fc-200d-2640-fe0f":["1f9d7-1f3fc",44,8,15],

		"1f9d7-1f3fd-200d-2640-fe0f":["1f9d7-1f3fd",44,9,15],

		"1f9d7-1f3fe-200d-2640-fe0f":["1f9d7-1f3fe",44,10,15],

		"1f9d7-1f3ff-200d-2640-fe0f":["1f9d7-1f3ff",44,11,15],

		"1f9d8-200d-2640-fe0f":["1f9d8",44,24,15],

		"1f9d8-1f3fb-200d-2640-fe0f":["1f9d8-1f3fb",44,25,15],

		"1f9d8-1f3fc-200d-2640-fe0f":["1f9d8-1f3fc",44,26,15],

		"1f9d8-1f3fd-200d-2640-fe0f":["1f9d8-1f3fd",44,27,15],

		"1f9d8-1f3fe-200d-2640-fe0f":["1f9d8-1f3fe",44,28,15],

		"1f9d8-1f3ff-200d-2640-fe0f":["1f9d8-1f3ff",44,29,15],

		"1f9d9-200d-2640-fe0f":["1f9d9",44,42,15],

		"1f9d9-1f3fb-200d-2640-fe0f":["1f9d9-1f3fb",44,43,15],

		"1f9d9-1f3fc-200d-2640-fe0f":["1f9d9-1f3fc",44,44,15],

		"1f9d9-1f3fd-200d-2640-fe0f":["1f9d9-1f3fd",44,45,15],

		"1f9d9-1f3fe-200d-2640-fe0f":["1f9d9-1f3fe",44,46,15],

		"1f9d9-1f3ff-200d-2640-fe0f":["1f9d9-1f3ff",44,47,15],

		"1f9da-200d-2640-fe0f":["1f9da",45,8,15],

		"1f9da-1f3fb-200d-2640-fe0f":["1f9da-1f3fb",45,9,7],

		"1f9da-1f3fc-200d-2640-fe0f":["1f9da-1f3fc",45,10,7],

		"1f9da-1f3fd-200d-2640-fe0f":["1f9da-1f3fd",45,11,7],

		"1f9da-1f3fe-200d-2640-fe0f":["1f9da-1f3fe",45,12,7],

		"1f9da-1f3ff-200d-2640-fe0f":["1f9da-1f3ff",45,13,7],

		"1f9db-200d-2640-fe0f":["1f9db",45,26,15],

		"1f9db-1f3fb-200d-2640-fe0f":["1f9db-1f3fb",45,27,7],

		"1f9db-1f3fc-200d-2640-fe0f":["1f9db-1f3fc",45,28,7],

		"1f9db-1f3fd-200d-2640-fe0f":["1f9db-1f3fd",45,29,7],

		"1f9db-1f3fe-200d-2640-fe0f":["1f9db-1f3fe",45,30,7],

		"1f9db-1f3ff-200d-2640-fe0f":["1f9db-1f3ff",45,31,7],

		"1f9dc-200d-2642-fe0f":["1f9dc",45,44,15],

		"1f9dc-1f3fb-200d-2642-fe0f":["1f9dc-1f3fb",45,45,15],

		"1f9dc-1f3fc-200d-2642-fe0f":["1f9dc-1f3fc",45,46,15],

		"1f9dc-1f3fd-200d-2642-fe0f":["1f9dc-1f3fd",45,47,15],

		"1f9dc-1f3fe-200d-2642-fe0f":["1f9dc-1f3fe",45,48,15],

		"1f9dc-1f3ff-200d-2642-fe0f":["1f9dc-1f3ff",45,49,15],

		"1f9dd-200d-2642-fe0f":["1f9dd",46,10,15],

		"1f9dd-1f3fb-200d-2642-fe0f":["1f9dd-1f3fb",46,11,15],

		"1f9dd-1f3fc-200d-2642-fe0f":["1f9dd-1f3fc",46,12,15],

		"1f9dd-1f3fd-200d-2642-fe0f":["1f9dd-1f3fd",46,13,15],

		"1f9dd-1f3fe-200d-2642-fe0f":["1f9dd-1f3fe",46,14,15],

		"1f9dd-1f3ff-200d-2642-fe0f":["1f9dd-1f3ff",46,15,15],

		"1f9de-200d-2642-fe0f":["1f9de",46,18,15],

		"1f9df-200d-2642-fe0f":["1f9df",46,21,15],

		"26f9-fe0f-200d-2642-fe0f":["26f9-fe0f",49,6,7],

		"26f9-1f3fb-200d-2642-fe0f":["26f9-1f3fb",49,7,7],

		"26f9-1f3fc-200d-2642-fe0f":["26f9-1f3fc",49,8,7],

		"26f9-1f3fd-200d-2642-fe0f":["26f9-1f3fd",49,9,7],

		"26f9-1f3fe-200d-2642-fe0f":["26f9-1f3fe",49,10,7],

		"26f9-1f3ff-200d-2642-fe0f":["26f9-1f3ff",49,11,7]

	};





	// export

	if (true){

		if ( true && module.exports){

			exports = module.exports = emoji;

		}

		exports.EmojiConvertor = emoji;

	}else {}



}).call(function(){

	return this || (typeof window !== 'undefined' ? window : global);

}());



/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../webpack/buildin/global.js */ "./node_modules/webpack/buildin/global.js")))



/***/ }),



/***/ "./node_modules/escape-goat/index.js":

/*!*******************************************!*\

  !*** ./node_modules/escape-goat/index.js ***!

  \*******************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



"use strict";





exports.escape = input => input

	.replace(/&/g, '&amp;')

	.replace(/"/g, '&quot;')

	.replace(/'/g, '&#39;')

	.replace(/</g, '&lt;')

	.replace(/>/g, '&gt;');



exports.unescape = input => input

	.replace(/&gt;/g, '>')

	.replace(/&lt;/g, '<')

	.replace(/&#39;/g, '\'')

	.replace(/&quot;/g, '"')

	.replace(/&amp;/g, '&');



exports.escapeTag = function (input) {

	let output = input[0];

	for (let i = 1; i < arguments.length; i++) {

		output = output + exports.escape(arguments[i]) + input[i];

	}

	return output;

};



exports.unescapeTag = function (input) {

	let output = input[0];

	for (let i = 1; i < arguments.length; i++) {

		output = output + exports.unescape(arguments[i]) + input[i];

	}

	return output;

};





/***/ }),



/***/ "./node_modules/jquery/dist/jquery.js":

/*!********************************************!*\

  !*** ./node_modules/jquery/dist/jquery.js ***!

  \********************************************/

/*! no static exports found */

/***/ (function(module, exports, __webpack_require__) {



var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!

 * jQuery JavaScript Library v3.5.1

 * https://jquery.com/

 *

 * Includes Sizzle.js

 * https://sizzlejs.com/

 *

 * Copyright JS Foundation and other contributors

 * Released under the MIT license

 * https://jquery.org/license

 *

 * Date: 2020-05-04T22:49Z

 */

( function( global, factory ) {



	"use strict";



	if (  true && typeof module.exports === "object" ) {



		// For CommonJS and CommonJS-like environments where a proper `window`

		// is present, execute the factory and get jQuery.

		// For environments that do not have a `window` with a `document`

		// (such as Node.js), expose a factory as module.exports.

		// This accentuates the need for the creation of a real `window`.

		// e.g. var jQuery = require("jquery")(window);

		// See ticket #14549 for more info.

		module.exports = global.document ?

			factory( global, true ) :

			function( w ) {

				if ( !w.document ) {

					throw new Error( "jQuery requires a window with a document" );

				}

				return factory( w );

			};

	} else {

		factory( global );

	}



// Pass this if window is not defined yet

} )( typeof window !== "undefined" ? window : this, function( window, noGlobal ) {



// Edge <= 12 - 13+, Firefox <=18 - 45+, IE 10 - 11, Safari 5.1 - 9+, iOS 6 - 9.1

// throw exceptions when non-strict code (e.g., ASP.NET 4.5) accesses strict mode

// arguments.callee.caller (trac-13335). But as of jQuery 3.0 (2016), strict mode should be common

// enough that all such attempts are guarded in a try block.

"use strict";



var arr = [];



var getProto = Object.getPrototypeOf;



var slice = arr.slice;



var flat = arr.flat ? function( array ) {

	return arr.flat.call( array );

} : function( array ) {

	return arr.concat.apply( [], array );

};





var push = arr.push;



var indexOf = arr.indexOf;



var class2type = {};



var toString = class2type.toString;



var hasOwn = class2type.hasOwnProperty;



var fnToString = hasOwn.toString;



var ObjectFunctionString = fnToString.call( Object );



var support = {};



var isFunction = function isFunction( obj ) {



      // Support: Chrome <=57, Firefox <=52

      // In some browsers, typeof returns "function" for HTML <object> elements

      // (i.e., `typeof document.createElement( "object" ) === "function"`).

      // We don't want to classify *any* DOM node as a function.

      return typeof obj === "function" && typeof obj.nodeType !== "number";

  };





var isWindow = function isWindow( obj ) {

		return obj != null && obj === obj.window;

	};





var document = window.document;







	var preservedScriptAttributes = {

		type: true,

		src: true,

		nonce: true,

		noModule: true

	};



	function DOMEval( code, node, doc ) {

		doc = doc || document;



		var i, val,

			script = doc.createElement( "script" );



		script.text = code;

		if ( node ) {

			for ( i in preservedScriptAttributes ) {



				// Support: Firefox 64+, Edge 18+

				// Some browsers don't support the "nonce" property on scripts.

				// On the other hand, just using `getAttribute` is not enough as

				// the `nonce` attribute is reset to an empty string whenever it

				// becomes browsing-context connected.

				// See https://github.com/whatwg/html/issues/2369

				// See https://html.spec.whatwg.org/#nonce-attributes

				// The `node.getAttribute` check was added for the sake of

				// `jQuery.globalEval` so that it can fake a nonce-containing node

				// via an object.

				val = node[ i ] || node.getAttribute && node.getAttribute( i );

				if ( val ) {

					script.setAttribute( i, val );

				}

			}

		}

		doc.head.appendChild( script ).parentNode.removeChild( script );

	}





function toType( obj ) {

	if ( obj == null ) {

		return obj + "";

	}



	// Support: Android <=2.3 only (functionish RegExp)

	return typeof obj === "object" || typeof obj === "function" ?

		class2type[ toString.call( obj ) ] || "object" :

		typeof obj;

}

/* global Symbol */

// Defining this global in .eslintrc.json would create a danger of using the global

// unguarded in another place, it seems safer to define global only for this module







var

	version = "3.5.1",



	// Define a local copy of jQuery

	jQuery = function( selector, context ) {



		// The jQuery object is actually just the init constructor 'enhanced'

		// Need init if jQuery is called (just allow error to be thrown if not included)

		return new jQuery.fn.init( selector, context );

	};



jQuery.fn = jQuery.prototype = {



	// The current version of jQuery being used

	jquery: version,



	constructor: jQuery,



	// The default length of a jQuery object is 0

	length: 0,



	toArray: function() {

		return slice.call( this );

	},



	// Get the Nth element in the matched element set OR

	// Get the whole matched element set as a clean array

	get: function( num ) {



		// Return all the elements in a clean array

		if ( num == null ) {

			return slice.call( this );

		}



		// Return just the one element from the set

		return num < 0 ? this[ num + this.length ] : this[ num ];

	},



	// Take an array of elements and push it onto the stack

	// (returning the new matched element set)

	pushStack: function( elems ) {



		// Build a new jQuery matched element set

		var ret = jQuery.merge( this.constructor(), elems );



		// Add the old object onto the stack (as a reference)

		ret.prevObject = this;



		// Return the newly-formed element set

		return ret;

	},



	// Execute a callback for every element in the matched set.

	each: function( callback ) {

		return jQuery.each( this, callback );

	},



	map: function( callback ) {

		return this.pushStack( jQuery.map( this, function( elem, i ) {

			return callback.call( elem, i, elem );

		} ) );

	},



	slice: function() {

		return this.pushStack( slice.apply( this, arguments ) );

	},



	first: function() {

		return this.eq( 0 );

	},



	last: function() {

		return this.eq( -1 );

	},



	even: function() {

		return this.pushStack( jQuery.grep( this, function( _elem, i ) {

			return ( i + 1 ) % 2;

		} ) );

	},



	odd: function() {

		return this.pushStack( jQuery.grep( this, function( _elem, i ) {

			return i % 2;

		} ) );

	},



	eq: function( i ) {

		var len = this.length,

			j = +i + ( i < 0 ? len : 0 );

		return this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );

	},



	end: function() {

		return this.prevObject || this.constructor();

	},



	// For internal use only.

	// Behaves like an Array's method, not like a jQuery method.

	push: push,

	sort: arr.sort,

	splice: arr.splice

};



jQuery.extend = jQuery.fn.extend = function() {

	var options, name, src, copy, copyIsArray, clone,

		target = arguments[ 0 ] || {},

		i = 1,

		length = arguments.length,

		deep = false;



	// Handle a deep copy situation

	if ( typeof target === "boolean" ) {

		deep = target;



		// Skip the boolean and the target

		target = arguments[ i ] || {};

		i++;

	}



	// Handle case when target is a string or something (possible in deep copy)

	if ( typeof target !== "object" && !isFunction( target ) ) {

		target = {};

	}



	// Extend jQuery itself if only one argument is passed

	if ( i === length ) {

		target = this;

		i--;

	}



	for ( ; i < length; i++ ) {



		// Only deal with non-null/undefined values

		if ( ( options = arguments[ i ] ) != null ) {



			// Extend the base object

			for ( name in options ) {

				copy = options[ name ];



				// Prevent Object.prototype pollution

				// Prevent never-ending loop

				if ( name === "__proto__" || target === copy ) {

					continue;

				}



				// Recurse if we're merging plain objects or arrays

				if ( deep && copy && ( jQuery.isPlainObject( copy ) ||

					( copyIsArray = Array.isArray( copy ) ) ) ) {

					src = target[ name ];



					// Ensure proper type for the source value

					if ( copyIsArray && !Array.isArray( src ) ) {

						clone = [];

					} else if ( !copyIsArray && !jQuery.isPlainObject( src ) ) {

						clone = {};

					} else {

						clone = src;

					}

					copyIsArray = false;



					// Never move original objects, clone them

					target[ name ] = jQuery.extend( deep, clone, copy );



				// Don't bring in undefined values

				} else if ( copy !== undefined ) {

					target[ name ] = copy;

				}

			}

		}

	}



	// Return the modified object

	return target;

};



jQuery.extend( {



	// Unique for each copy of jQuery on the page

	expando: "jQuery" + ( version + Math.random() ).replace( /\D/g, "" ),



	// Assume jQuery is ready without the ready module

	isReady: true,



	error: function( msg ) {

		throw new Error( msg );

	},



	noop: function() {},



	isPlainObject: function( obj ) {

		var proto, Ctor;



		// Detect obvious negatives

		// Use toString instead of jQuery.type to catch host objects

		if ( !obj || toString.call( obj ) !== "[object Object]" ) {

			return false;

		}



		proto = getProto( obj );



		// Objects with no prototype (e.g., `Object.create( null )`) are plain

		if ( !proto ) {

			return true;

		}



		// Objects with prototype are plain iff they were constructed by a global Object function

		Ctor = hasOwn.call( proto, "constructor" ) && proto.constructor;

		return typeof Ctor === "function" && fnToString.call( Ctor ) === ObjectFunctionString;

	},



	isEmptyObject: function( obj ) {

		var name;



		for ( name in obj ) {

			return false;

		}

		return true;

	},



	// Evaluates a script in a provided context; falls back to the global one

	// if not specified.

	globalEval: function( code, options, doc ) {

		DOMEval( code, { nonce: options && options.nonce }, doc );

	},



	each: function( obj, callback ) {

		var length, i = 0;



		if ( isArrayLike( obj ) ) {

			length = obj.length;

			for ( ; i < length; i++ ) {

				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {

					break;

				}

			}

		} else {

			for ( i in obj ) {

				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {

					break;

				}

			}

		}



		return obj;

	},



	// results is for internal usage only

	makeArray: function( arr, results ) {

		var ret = results || [];



		if ( arr != null ) {

			if ( isArrayLike( Object( arr ) ) ) {

				jQuery.merge( ret,

					typeof arr === "string" ?

					[ arr ] : arr

				);

			} else {

				push.call( ret, arr );

			}

		}



		return ret;

	},



	inArray: function( elem, arr, i ) {

		return arr == null ? -1 : indexOf.call( arr, elem, i );

	},



	// Support: Android <=4.0 only, PhantomJS 1 only

	// push.apply(_, arraylike) throws on ancient WebKit

	merge: function( first, second ) {

		var len = +second.length,

			j = 0,

			i = first.length;



		for ( ; j < len; j++ ) {

			first[ i++ ] = second[ j ];

		}



		first.length = i;



		return first;

	},



	grep: function( elems, callback, invert ) {

		var callbackInverse,

			matches = [],

			i = 0,

			length = elems.length,

			callbackExpect = !invert;



		// Go through the array, only saving the items

		// that pass the validator function

		for ( ; i < length; i++ ) {

			callbackInverse = !callback( elems[ i ], i );

			if ( callbackInverse !== callbackExpect ) {

				matches.push( elems[ i ] );

			}

		}



		return matches;

	},



	// arg is for internal usage only

	map: function( elems, callback, arg ) {

		var length, value,

			i = 0,

			ret = [];



		// Go through the array, translating each of the items to their new values

		if ( isArrayLike( elems ) ) {

			length = elems.length;

			for ( ; i < length; i++ ) {

				value = callback( elems[ i ], i, arg );



				if ( value != null ) {

					ret.push( value );

				}

			}



		// Go through every key on the object,

		} else {

			for ( i in elems ) {

				value = callback( elems[ i ], i, arg );



				if ( value != null ) {

					ret.push( value );

				}

			}

		}



		// Flatten any nested arrays

		return flat( ret );

	},



	// A global GUID counter for objects

	guid: 1,



	// jQuery.support is not used in Core but other projects attach their

	// properties to it so it needs to exist.

	support: support

} );



if ( typeof Symbol === "function" ) {

	jQuery.fn[ Symbol.iterator ] = arr[ Symbol.iterator ];

}



// Populate the class2type map

jQuery.each( "Boolean Number String Function Array Date RegExp Object Error Symbol".split( " " ),

function( _i, name ) {

	class2type[ "[object " + name + "]" ] = name.toLowerCase();

} );



function isArrayLike( obj ) {



	// Support: real iOS 8.2 only (not reproducible in simulator)

	// `in` check used to prevent JIT error (gh-2145)

	// hasOwn isn't used here due to false negatives

	// regarding Nodelist length in IE

	var length = !!obj && "length" in obj && obj.length,

		type = toType( obj );



	if ( isFunction( obj ) || isWindow( obj ) ) {

		return false;

	}



	return type === "array" || length === 0 ||

		typeof length === "number" && length > 0 && ( length - 1 ) in obj;

}

var Sizzle =

/*!

 * Sizzle CSS Selector Engine v2.3.5

 * https://sizzlejs.com/

 *

 * Copyright JS Foundation and other contributors

 * Released under the MIT license

 * https://js.foundation/

 *

 * Date: 2020-03-14

 */

( function( window ) {

var i,

	support,

	Expr,

	getText,

	isXML,

	tokenize,

	compile,

	select,

	outermostContext,

	sortInput,

	hasDuplicate,



	// Local document vars

	setDocument,

	document,

	docElem,

	documentIsHTML,

	rbuggyQSA,

	rbuggyMatches,

	matches,

	contains,



	// Instance-specific data

	expando = "sizzle" + 1 * new Date(),

	preferredDoc = window.document,

	dirruns = 0,

	done = 0,

	classCache = createCache(),

	tokenCache = createCache(),

	compilerCache = createCache(),

	nonnativeSelectorCache = createCache(),

	sortOrder = function( a, b ) {

		if ( a === b ) {

			hasDuplicate = true;

		}

		return 0;

	},



	// Instance methods

	hasOwn = ( {} ).hasOwnProperty,

	arr = [],

	pop = arr.pop,

	pushNative = arr.push,

	push = arr.push,

	slice = arr.slice,



	// Use a stripped-down indexOf as it's faster than native

	// https://jsperf.com/thor-indexof-vs-for/5

	indexOf = function( list, elem ) {

		var i = 0,

			len = list.length;

		for ( ; i < len; i++ ) {

			if ( list[ i ] === elem ) {

				return i;

			}

		}

		return -1;

	},



	booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|" +

		"ismap|loop|multiple|open|readonly|required|scoped",



	// Regular expressions



	// http://www.w3.org/TR/css3-selectors/#whitespace

	whitespace = "[\\x20\\t\\r\\n\\f]",



	// https://www.w3.org/TR/css-syntax-3/#ident-token-diagram

	identifier = "(?:\\\\[\\da-fA-F]{1,6}" + whitespace +

		"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",



	// Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors

	attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace +



		// Operator (capture 2)

		"*([*^$|!~]?=)" + whitespace +



		// "Attribute values must be CSS identifiers [capture 5]

		// or strings [capture 3 or capture 4]"

		"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" +

		whitespace + "*\\]",



	pseudos = ":(" + identifier + ")(?:\\((" +



		// To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:

		// 1. quoted (capture 3; capture 4 or capture 5)

		"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" +



		// 2. simple (capture 6)

		"((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" +



		// 3. anything else (capture 2)

		".*" +

		")\\)|)",



	// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter

	rwhitespace = new RegExp( whitespace + "+", "g" ),

	rtrim = new RegExp( "^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" +

		whitespace + "+$", "g" ),



	rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),

	rcombinators = new RegExp( "^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace +

		"*" ),

	rdescend = new RegExp( whitespace + "|>" ),



	rpseudo = new RegExp( pseudos ),

	ridentifier = new RegExp( "^" + identifier + "$" ),



	matchExpr = {

		"ID": new RegExp( "^#(" + identifier + ")" ),

		"CLASS": new RegExp( "^\\.(" + identifier + ")" ),

		"TAG": new RegExp( "^(" + identifier + "|[*])" ),

		"ATTR": new RegExp( "^" + attributes ),

		"PSEUDO": new RegExp( "^" + pseudos ),

		"CHILD": new RegExp( "^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" +

			whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" +

			whitespace + "*(\\d+)|))" + whitespace + "*\\)|)", "i" ),

		"bool": new RegExp( "^(?:" + booleans + ")$", "i" ),



		// For use in libraries implementing .is()

		// We use this for POS matching in `select`

		"needsContext": new RegExp( "^" + whitespace +

			"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace +

			"*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i" )

	},



	rhtml = /HTML$/i,

	rinputs = /^(?:input|select|textarea|button)$/i,

	rheader = /^h\d$/i,



	rnative = /^[^{]+\{\s*\[native \w/,



	// Easily-parseable/retrievable ID or TAG or CLASS selectors

	rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,



	rsibling = /[+~]/,



	// CSS escapes

	// http://www.w3.org/TR/CSS21/syndata.html#escaped-characters

	runescape = new RegExp( "\\\\[\\da-fA-F]{1,6}" + whitespace + "?|\\\\([^\\r\\n\\f])", "g" ),

	funescape = function( escape, nonHex ) {

		var high = "0x" + escape.slice( 1 ) - 0x10000;



		return nonHex ?



			// Strip the backslash prefix from a non-hex escape sequence

			nonHex :



			// Replace a hexadecimal escape sequence with the encoded Unicode code point

			// Support: IE <=11+

			// For values outside the Basic Multilingual Plane (BMP), manually construct a

			// surrogate pair

			high < 0 ?

				String.fromCharCode( high + 0x10000 ) :

				String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );

	},



	// CSS string/identifier serialization

	// https://drafts.csswg.org/cssom/#common-serializing-idioms

	rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,

	fcssescape = function( ch, asCodePoint ) {

		if ( asCodePoint ) {



			// U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER

			if ( ch === "\0" ) {

				return "\uFFFD";

			}



			// Control characters and (dependent upon position) numbers get escaped as code points

			return ch.slice( 0, -1 ) + "\\" +

				ch.charCodeAt( ch.length - 1 ).toString( 16 ) + " ";

		}



		// Other potentially-special ASCII characters get backslash-escaped

		return "\\" + ch;

	},



	// Used for iframes

	// See setDocument()

	// Removing the function wrapper causes a "Permission Denied"

	// error in IE

	unloadHandler = function() {

		setDocument();

	},



	inDisabledFieldset = addCombinator(

		function( elem ) {

			return elem.disabled === true && elem.nodeName.toLowerCase() === "fieldset";

		},

		{ dir: "parentNode", next: "legend" }

	);



// Optimize for push.apply( _, NodeList )

try {

	push.apply(

		( arr = slice.call( preferredDoc.childNodes ) ),

		preferredDoc.childNodes

	);



	// Support: Android<4.0

	// Detect silently failing push.apply

	// eslint-disable-next-line no-unused-expressions

	arr[ preferredDoc.childNodes.length ].nodeType;

} catch ( e ) {

	push = { apply: arr.length ?



		// Leverage slice if possible

		function( target, els ) {

			pushNative.apply( target, slice.call( els ) );

		} :



		// Support: IE<9

		// Otherwise append directly

		function( target, els ) {

			var j = target.length,

				i = 0;



			// Can't trust NodeList.length

			while ( ( target[ j++ ] = els[ i++ ] ) ) {}

			target.length = j - 1;

		}

	};

}



function Sizzle( selector, context, results, seed ) {

	var m, i, elem, nid, match, groups, newSelector,

		newContext = context && context.ownerDocument,



		// nodeType defaults to 9, since context defaults to document

		nodeType = context ? context.nodeType : 9;



	results = results || [];



	// Return early from calls with invalid selector or context

	if ( typeof selector !== "string" || !selector ||

		nodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {



		return results;

	}



	// Try to shortcut find operations (as opposed to filters) in HTML documents

	if ( !seed ) {

		setDocument( context );

		context = context || document;



		if ( documentIsHTML ) {



			// If the selector is sufficiently simple, try using a "get*By*" DOM method

			// (excepting DocumentFragment context, where the methods don't exist)

			if ( nodeType !== 11 && ( match = rquickExpr.exec( selector ) ) ) {



				// ID selector

				if ( ( m = match[ 1 ] ) ) {



					// Document context

					if ( nodeType === 9 ) {

						if ( ( elem = context.getElementById( m ) ) ) {



							// Support: IE, Opera, Webkit

							// TODO: identify versions

							// getElementById can match elements by name instead of ID

							if ( elem.id === m ) {

								results.push( elem );

								return results;

							}

						} else {

							return results;

						}



					// Element context

					} else {



						// Support: IE, Opera, Webkit

						// TODO: identify versions

						// getElementById can match elements by name instead of ID

						if ( newContext && ( elem = newContext.getElementById( m ) ) &&

							contains( context, elem ) &&

							elem.id === m ) {



							results.push( elem );

							return results;

						}

					}



				// Type selector

				} else if ( match[ 2 ] ) {

					push.apply( results, context.getElementsByTagName( selector ) );

					return results;



				// Class selector

				} else if ( ( m = match[ 3 ] ) && support.getElementsByClassName &&

					context.getElementsByClassName ) {



					push.apply( results, context.getElementsByClassName( m ) );

					return results;

				}

			}



			// Take advantage of querySelectorAll

			if ( support.qsa &&

				!nonnativeSelectorCache[ selector + " " ] &&

				( !rbuggyQSA || !rbuggyQSA.test( selector ) ) &&



				// Support: IE 8 only

				// Exclude object elements

				( nodeType !== 1 || context.nodeName.toLowerCase() !== "object" ) ) {



				newSelector = selector;

				newContext = context;



				// qSA considers elements outside a scoping root when evaluating child or

				// descendant combinators, which is not what we want.

				// In such cases, we work around the behavior by prefixing every selector in the

				// list with an ID selector referencing the scope context.

				// The technique has to be used as well when a leading combinator is used

				// as such selectors are not recognized by querySelectorAll.

				// Thanks to Andrew Dupont for this technique.

				if ( nodeType === 1 &&

					( rdescend.test( selector ) || rcombinators.test( selector ) ) ) {



					// Expand context for sibling selectors

					newContext = rsibling.test( selector ) && testContext( context.parentNode ) ||

						context;



					// We can use :scope instead of the ID hack if the browser

					// supports it & if we're not changing the context.

					if ( newContext !== context || !support.scope ) {



						// Capture the context ID, setting it first if necessary

						if ( ( nid = context.getAttribute( "id" ) ) ) {

							nid = nid.replace( rcssescape, fcssescape );

						} else {

							context.setAttribute( "id", ( nid = expando ) );

						}

					}



					// Prefix every selector in the list

					groups = tokenize( selector );

					i = groups.length;

					while ( i-- ) {

						groups[ i ] = ( nid ? "#" + nid : ":scope" ) + " " +

							toSelector( groups[ i ] );

					}

					newSelector = groups.join( "," );

				}



				try {

					push.apply( results,

						newContext.querySelectorAll( newSelector )

					);

					return results;

				} catch ( qsaError ) {

					nonnativeSelectorCache( selector, true );

				} finally {

					if ( nid === expando ) {

						context.removeAttribute( "id" );

					}

				}

			}

		}

	}



	// All others

	return select( selector.replace( rtrim, "$1" ), context, results, seed );

}



/**

 * Create key-value caches of limited size

 * @returns {function(string, object)} Returns the Object data after storing it on itself with

 *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)

 *	deleting the oldest entry

 */

function createCache() {

	var keys = [];



	function cache( key, value ) {



		// Use (key + " ") to avoid collision with native prototype properties (see Issue #157)

		if ( keys.push( key + " " ) > Expr.cacheLength ) {



			// Only keep the most recent entries

			delete cache[ keys.shift() ];

		}

		return ( cache[ key + " " ] = value );

	}

	return cache;

}



/**

 * Mark a function for special use by Sizzle

 * @param {Function} fn The function to mark

 */

function markFunction( fn ) {

	fn[ expando ] = true;

	return fn;

}



/**

 * Support testing using an element

 * @param {Function} fn Passed the created element and returns a boolean result

 */

function assert( fn ) {

	var el = document.createElement( "fieldset" );



	try {

		return !!fn( el );

	} catch ( e ) {

		return false;

	} finally {



		// Remove from its parent by default

		if ( el.parentNode ) {

			el.parentNode.removeChild( el );

		}



		// release memory in IE

		el = null;

	}

}



/**

 * Adds the same handler for all of the specified attrs

 * @param {String} attrs Pipe-separated list of attributes

 * @param {Function} handler The method that will be applied

 */

function addHandle( attrs, handler ) {

	var arr = attrs.split( "|" ),

		i = arr.length;



	while ( i-- ) {

		Expr.attrHandle[ arr[ i ] ] = handler;

	}

}



/**

 * Checks document order of two siblings

 * @param {Element} a

 * @param {Element} b

 * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b

 */

function siblingCheck( a, b ) {

	var cur = b && a,

		diff = cur && a.nodeType === 1 && b.nodeType === 1 &&

			a.sourceIndex - b.sourceIndex;



	// Use IE sourceIndex if available on both nodes

	if ( diff ) {

		return diff;

	}



	// Check if b follows a

	if ( cur ) {

		while ( ( cur = cur.nextSibling ) ) {

			if ( cur === b ) {

				return -1;

			}

		}

	}



	return a ? 1 : -1;

}



/**

 * Returns a function to use in pseudos for input types

 * @param {String} type

 */

function createInputPseudo( type ) {

	return function( elem ) {

		var name = elem.nodeName.toLowerCase();

		return name === "input" && elem.type === type;

	};

}



/**

 * Returns a function to use in pseudos for buttons

 * @param {String} type

 */

function createButtonPseudo( type ) {

	return function( elem ) {

		var name = elem.nodeName.toLowerCase();

		return ( name === "input" || name === "button" ) && elem.type === type;

	};

}



/**

 * Returns a function to use in pseudos for :enabled/:disabled

 * @param {Boolean} disabled true for :disabled; false for :enabled

 */

function createDisabledPseudo( disabled ) {



	// Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable

	return function( elem ) {



		// Only certain elements can match :enabled or :disabled

		// https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled

		// https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled

		if ( "form" in elem ) {



			// Check for inherited disabledness on relevant non-disabled elements:

			// * listed form-associated elements in a disabled fieldset

			//   https://html.spec.whatwg.org/multipage/forms.html#category-listed

			//   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled

			// * option elements in a disabled optgroup

			//   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled

			// All such elements have a "form" property.

			if ( elem.parentNode && elem.disabled === false ) {



				// Option elements defer to a parent optgroup if present

				if ( "label" in elem ) {

					if ( "label" in elem.parentNode ) {

						return elem.parentNode.disabled === disabled;

					} else {

						return elem.disabled === disabled;

					}

				}



				// Support: IE 6 - 11

				// Use the isDisabled shortcut property to check for disabled fieldset ancestors

				return elem.isDisabled === disabled ||



					// Where there is no isDisabled, check manually

					/* jshint -W018 */

					elem.isDisabled !== !disabled &&

					inDisabledFieldset( elem ) === disabled;

			}



			return elem.disabled === disabled;



		// Try to winnow out elements that can't be disabled before trusting the disabled property.

		// Some victims get caught in our net (label, legend, menu, track), but it shouldn't

		// even exist on them, let alone have a boolean value.

		} else if ( "label" in elem ) {

			return elem.disabled === disabled;

		}



		// Remaining elements are neither :enabled nor :disabled

		return false;

	};

}



/**

 * Returns a function to use in pseudos for positionals

 * @param {Function} fn

 */

function createPositionalPseudo( fn ) {

	return markFunction( function( argument ) {

		argument = +argument;

		return markFunction( function( seed, matches ) {

			var j,

				matchIndexes = fn( [], seed.length, argument ),

				i = matchIndexes.length;



			// Match elements found at the specified indexes

			while ( i-- ) {

				if ( seed[ ( j = matchIndexes[ i ] ) ] ) {

					seed[ j ] = !( matches[ j ] = seed[ j ] );

				}

			}

		} );

	} );

}



/**

 * Checks a node for validity as a Sizzle context

 * @param {Element|Object=} context

 * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value

 */

function testContext( context ) {

	return context && typeof context.getElementsByTagName !== "undefined" && context;

}



// Expose support vars for convenience

support = Sizzle.support = {};



/**

 * Detects XML nodes

 * @param {Element|Object} elem An element or a document

 * @returns {Boolean} True iff elem is a non-HTML XML node

 */

isXML = Sizzle.isXML = function( elem ) {

	var namespace = elem.namespaceURI,

		docElem = ( elem.ownerDocument || elem ).documentElement;



	// Support: IE <=8

	// Assume HTML when documentElement doesn't yet exist, such as inside loading iframes

	// https://bugs.jquery.com/ticket/4833

	return !rhtml.test( namespace || docElem && docElem.nodeName || "HTML" );

};



/**

 * Sets document-related variables once based on the current document

 * @param {Element|Object} [doc] An element or document object to use to set the document

 * @returns {Object} Returns the current document

 */

setDocument = Sizzle.setDocument = function( node ) {

	var hasCompare, subWindow,

		doc = node ? node.ownerDocument || node : preferredDoc;



	// Return early if doc is invalid or already selected

	// Support: IE 11+, Edge 17 - 18+

	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing

	// two documents; shallow comparisons work.

	// eslint-disable-next-line eqeqeq

	if ( doc == document || doc.nodeType !== 9 || !doc.documentElement ) {

		return document;

	}



	// Update global variables

	document = doc;

	docElem = document.documentElement;

	documentIsHTML = !isXML( document );



	// Support: IE 9 - 11+, Edge 12 - 18+

	// Accessing iframe documents after unload throws "permission denied" errors (jQuery #13936)

	// Support: IE 11+, Edge 17 - 18+

	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing

	// two documents; shallow comparisons work.

	// eslint-disable-next-line eqeqeq

	if ( preferredDoc != document &&

		( subWindow = document.defaultView ) && subWindow.top !== subWindow ) {



		// Support: IE 11, Edge

		if ( subWindow.addEventListener ) {

			subWindow.addEventListener( "unload", unloadHandler, false );



		// Support: IE 9 - 10 only

		} else if ( subWindow.attachEvent ) {

			subWindow.attachEvent( "onunload", unloadHandler );

		}

	}



	// Support: IE 8 - 11+, Edge 12 - 18+, Chrome <=16 - 25 only, Firefox <=3.6 - 31 only,

	// Safari 4 - 5 only, Opera <=11.6 - 12.x only

	// IE/Edge & older browsers don't support the :scope pseudo-class.

	// Support: Safari 6.0 only

	// Safari 6.0 supports :scope but it's an alias of :root there.

	support.scope = assert( function( el ) {

		docElem.appendChild( el ).appendChild( document.createElement( "div" ) );

		return typeof el.querySelectorAll !== "undefined" &&

			!el.querySelectorAll( ":scope fieldset div" ).length;

	} );



	/* Attributes

	---------------------------------------------------------------------- */



	// Support: IE<8

	// Verify that getAttribute really returns attributes and not properties

	// (excepting IE8 booleans)

	support.attributes = assert( function( el ) {

		el.className = "i";

		return !el.getAttribute( "className" );

	} );



	/* getElement(s)By*

	---------------------------------------------------------------------- */



	// Check if getElementsByTagName("*") returns only elements

	support.getElementsByTagName = assert( function( el ) {

		el.appendChild( document.createComment( "" ) );

		return !el.getElementsByTagName( "*" ).length;

	} );



	// Support: IE<9

	support.getElementsByClassName = rnative.test( document.getElementsByClassName );



	// Support: IE<10

	// Check if getElementById returns elements by name

	// The broken getElementById methods don't pick up programmatically-set names,

	// so use a roundabout getElementsByName test

	support.getById = assert( function( el ) {

		docElem.appendChild( el ).id = expando;

		return !document.getElementsByName || !document.getElementsByName( expando ).length;

	} );



	// ID filter and find

	if ( support.getById ) {

		Expr.filter[ "ID" ] = function( id ) {

			var attrId = id.replace( runescape, funescape );

			return function( elem ) {

				return elem.getAttribute( "id" ) === attrId;

			};

		};

		Expr.find[ "ID" ] = function( id, context ) {

			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {

				var elem = context.getElementById( id );

				return elem ? [ elem ] : [];

			}

		};

	} else {

		Expr.filter[ "ID" ] =  function( id ) {

			var attrId = id.replace( runescape, funescape );

			return function( elem ) {

				var node = typeof elem.getAttributeNode !== "undefined" &&

					elem.getAttributeNode( "id" );

				return node && node.value === attrId;

			};

		};



		// Support: IE 6 - 7 only

		// getElementById is not reliable as a find shortcut

		Expr.find[ "ID" ] = function( id, context ) {

			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {

				var node, i, elems,

					elem = context.getElementById( id );



				if ( elem ) {



					// Verify the id attribute

					node = elem.getAttributeNode( "id" );

					if ( node && node.value === id ) {

						return [ elem ];

					}



					// Fall back on getElementsByName

					elems = context.getElementsByName( id );

					i = 0;

					while ( ( elem = elems[ i++ ] ) ) {

						node = elem.getAttributeNode( "id" );

						if ( node && node.value === id ) {

							return [ elem ];

						}

					}

				}



				return [];

			}

		};

	}



	// Tag

	Expr.find[ "TAG" ] = support.getElementsByTagName ?

		function( tag, context ) {

			if ( typeof context.getElementsByTagName !== "undefined" ) {

				return context.getElementsByTagName( tag );



			// DocumentFragment nodes don't have gEBTN

			} else if ( support.qsa ) {

				return context.querySelectorAll( tag );

			}

		} :



		function( tag, context ) {

			var elem,

				tmp = [],

				i = 0,



				// By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too

				results = context.getElementsByTagName( tag );



			// Filter out possible comments

			if ( tag === "*" ) {

				while ( ( elem = results[ i++ ] ) ) {

					if ( elem.nodeType === 1 ) {

						tmp.push( elem );

					}

				}



				return tmp;

			}

			return results;

		};



	// Class

	Expr.find[ "CLASS" ] = support.getElementsByClassName && function( className, context ) {

		if ( typeof context.getElementsByClassName !== "undefined" && documentIsHTML ) {

			return context.getElementsByClassName( className );

		}

	};



	/* QSA/matchesSelector

	---------------------------------------------------------------------- */



	// QSA and matchesSelector support



	// matchesSelector(:active) reports false when true (IE9/Opera 11.5)

	rbuggyMatches = [];



	// qSa(:focus) reports false when true (Chrome 21)

	// We allow this because of a bug in IE8/9 that throws an error

	// whenever `document.activeElement` is accessed on an iframe

	// So, we allow :focus to pass through QSA all the time to avoid the IE error

	// See https://bugs.jquery.com/ticket/13378

	rbuggyQSA = [];



	if ( ( support.qsa = rnative.test( document.querySelectorAll ) ) ) {



		// Build QSA regex

		// Regex strategy adopted from Diego Perini

		assert( function( el ) {



			var input;



			// Select is set to empty string on purpose

			// This is to test IE's treatment of not explicitly

			// setting a boolean content attribute,

			// since its presence should be enough

			// https://bugs.jquery.com/ticket/12359

			docElem.appendChild( el ).innerHTML = "<a id='" + expando + "'></a>" +

				"<select id='" + expando + "-\r\\' msallowcapture=''>" +

				"<option selected=''></option></select>";



			// Support: IE8, Opera 11-12.16

			// Nothing should be selected when empty strings follow ^= or $= or *=

			// The test attribute must be unknown in Opera but "safe" for WinRT

			// https://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section

			if ( el.querySelectorAll( "[msallowcapture^='']" ).length ) {

				rbuggyQSA.push( "[*^$]=" + whitespace + "*(?:''|\"\")" );

			}



			// Support: IE8

			// Boolean attributes and "value" are not treated correctly

			if ( !el.querySelectorAll( "[selected]" ).length ) {

				rbuggyQSA.push( "\\[" + whitespace + "*(?:value|" + booleans + ")" );

			}



			// Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+

			if ( !el.querySelectorAll( "[id~=" + expando + "-]" ).length ) {

				rbuggyQSA.push( "~=" );

			}



			// Support: IE 11+, Edge 15 - 18+

			// IE 11/Edge don't find elements on a `[name='']` query in some cases.

			// Adding a temporary attribute to the document before the selection works

			// around the issue.

			// Interestingly, IE 10 & older don't seem to have the issue.

			input = document.createElement( "input" );

			input.setAttribute( "name", "" );

			el.appendChild( input );

			if ( !el.querySelectorAll( "[name='']" ).length ) {

				rbuggyQSA.push( "\\[" + whitespace + "*name" + whitespace + "*=" +

					whitespace + "*(?:''|\"\")" );

			}



			// Webkit/Opera - :checked should return selected option elements

			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked

			// IE8 throws error here and will not see later tests

			if ( !el.querySelectorAll( ":checked" ).length ) {

				rbuggyQSA.push( ":checked" );

			}



			// Support: Safari 8+, iOS 8+

			// https://bugs.webkit.org/show_bug.cgi?id=136851

			// In-page `selector#id sibling-combinator selector` fails

			if ( !el.querySelectorAll( "a#" + expando + "+*" ).length ) {

				rbuggyQSA.push( ".#.+[+~]" );

			}



			// Support: Firefox <=3.6 - 5 only

			// Old Firefox doesn't throw on a badly-escaped identifier.

			el.querySelectorAll( "\\\f" );

			rbuggyQSA.push( "[\\r\\n\\f]" );

		} );



		assert( function( el ) {

			el.innerHTML = "<a href='' disabled='disabled'></a>" +

				"<select disabled='disabled'><option/></select>";



			// Support: Windows 8 Native Apps

			// The type and name attributes are restricted during .innerHTML assignment

			var input = document.createElement( "input" );

			input.setAttribute( "type", "hidden" );

			el.appendChild( input ).setAttribute( "name", "D" );



			// Support: IE8

			// Enforce case-sensitivity of name attribute

			if ( el.querySelectorAll( "[name=d]" ).length ) {

				rbuggyQSA.push( "name" + whitespace + "*[*^$|!~]?=" );

			}



			// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)

			// IE8 throws error here and will not see later tests

			if ( el.querySelectorAll( ":enabled" ).length !== 2 ) {

				rbuggyQSA.push( ":enabled", ":disabled" );

			}



			// Support: IE9-11+

			// IE's :disabled selector does not pick up the children of disabled fieldsets

			docElem.appendChild( el ).disabled = true;

			if ( el.querySelectorAll( ":disabled" ).length !== 2 ) {

				rbuggyQSA.push( ":enabled", ":disabled" );

			}



			// Support: Opera 10 - 11 only

			// Opera 10-11 does not throw on post-comma invalid pseudos

			el.querySelectorAll( "*,:x" );

			rbuggyQSA.push( ",.*:" );

		} );

	}



	if ( ( support.matchesSelector = rnative.test( ( matches = docElem.matches ||

		docElem.webkitMatchesSelector ||

		docElem.mozMatchesSelector ||

		docElem.oMatchesSelector ||

		docElem.msMatchesSelector ) ) ) ) {



		assert( function( el ) {



			// Check to see if it's possible to do matchesSelector

			// on a disconnected node (IE 9)

			support.disconnectedMatch = matches.call( el, "*" );



			// This should fail with an exception

			// Gecko does not error, returns false instead

			matches.call( el, "[s!='']:x" );

			rbuggyMatches.push( "!=", pseudos );

		} );

	}



	rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join( "|" ) );

	rbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join( "|" ) );



	/* Contains

	---------------------------------------------------------------------- */

	hasCompare = rnative.test( docElem.compareDocumentPosition );



	// Element contains another

	// Purposefully self-exclusive

	// As in, an element does not contain itself

	contains = hasCompare || rnative.test( docElem.contains ) ?

		function( a, b ) {

			var adown = a.nodeType === 9 ? a.documentElement : a,

				bup = b && b.parentNode;

			return a === bup || !!( bup && bup.nodeType === 1 && (

				adown.contains ?

					adown.contains( bup ) :

					a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16

			) );

		} :

		function( a, b ) {

			if ( b ) {

				while ( ( b = b.parentNode ) ) {

					if ( b === a ) {

						return true;

					}

				}

			}

			return false;

		};



	/* Sorting

	---------------------------------------------------------------------- */



	// Document order sorting

	sortOrder = hasCompare ?

	function( a, b ) {



		// Flag for duplicate removal

		if ( a === b ) {

			hasDuplicate = true;

			return 0;

		}



		// Sort on method existence if only one input has compareDocumentPosition

		var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;

		if ( compare ) {

			return compare;

		}



		// Calculate position if both inputs belong to the same document

		// Support: IE 11+, Edge 17 - 18+

		// IE/Edge sometimes throw a "Permission denied" error when strict-comparing

		// two documents; shallow comparisons work.

		// eslint-disable-next-line eqeqeq

		compare = ( a.ownerDocument || a ) == ( b.ownerDocument || b ) ?

			a.compareDocumentPosition( b ) :



			// Otherwise we know they are disconnected

			1;



		// Disconnected nodes

		if ( compare & 1 ||

			( !support.sortDetached && b.compareDocumentPosition( a ) === compare ) ) {



			// Choose the first element that is related to our preferred document

			// Support: IE 11+, Edge 17 - 18+

			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing

			// two documents; shallow comparisons work.

			// eslint-disable-next-line eqeqeq

			if ( a == document || a.ownerDocument == preferredDoc &&

				contains( preferredDoc, a ) ) {

				return -1;

			}



			// Support: IE 11+, Edge 17 - 18+

			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing

			// two documents; shallow comparisons work.

			// eslint-disable-next-line eqeqeq

			if ( b == document || b.ownerDocument == preferredDoc &&

				contains( preferredDoc, b ) ) {

				return 1;

			}



			// Maintain original order

			return sortInput ?

				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :

				0;

		}



		return compare & 4 ? -1 : 1;

	} :

	function( a, b ) {



		// Exit early if the nodes are identical

		if ( a === b ) {

			hasDuplicate = true;

			return 0;

		}



		var cur,

			i = 0,

			aup = a.parentNode,

			bup = b.parentNode,

			ap = [ a ],

			bp = [ b ];



		// Parentless nodes are either documents or disconnected

		if ( !aup || !bup ) {



			// Support: IE 11+, Edge 17 - 18+

			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing

			// two documents; shallow comparisons work.

			/* eslint-disable eqeqeq */

			return a == document ? -1 :

				b == document ? 1 :

				/* eslint-enable eqeqeq */

				aup ? -1 :

				bup ? 1 :

				sortInput ?

				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :

				0;



		// If the nodes are siblings, we can do a quick check

		} else if ( aup === bup ) {

			return siblingCheck( a, b );

		}



		// Otherwise we need full lists of their ancestors for comparison

		cur = a;

		while ( ( cur = cur.parentNode ) ) {

			ap.unshift( cur );

		}

		cur = b;

		while ( ( cur = cur.parentNode ) ) {

			bp.unshift( cur );

		}



		// Walk down the tree looking for a discrepancy

		while ( ap[ i ] === bp[ i ] ) {

			i++;

		}



		return i ?



			// Do a sibling check if the nodes have a common ancestor

			siblingCheck( ap[ i ], bp[ i ] ) :



			// Otherwise nodes in our document sort first

			// Support: IE 11+, Edge 17 - 18+

			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing

			// two documents; shallow comparisons work.

			/* eslint-disable eqeqeq */

			ap[ i ] == preferredDoc ? -1 :

			bp[ i ] == preferredDoc ? 1 :

			/* eslint-enable eqeqeq */

			0;

	};



	return document;

};



Sizzle.matches = function( expr, elements ) {

	return Sizzle( expr, null, null, elements );

};



Sizzle.matchesSelector = function( elem, expr ) {

	setDocument( elem );



	if ( support.matchesSelector && documentIsHTML &&

		!nonnativeSelectorCache[ expr + " " ] &&

		( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&

		( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {



		try {

			var ret = matches.call( elem, expr );



			// IE 9's matchesSelector returns false on disconnected nodes

			if ( ret || support.disconnectedMatch ||



				// As well, disconnected nodes are said to be in a document

				// fragment in IE 9

				elem.document && elem.document.nodeType !== 11 ) {

				return ret;

			}

		} catch ( e ) {

			nonnativeSelectorCache( expr, true );

		}

	}



	return Sizzle( expr, document, null, [ elem ] ).length > 0;

};



Sizzle.contains = function( context, elem ) {



	// Set document vars if needed

	// Support: IE 11+, Edge 17 - 18+

	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing

	// two documents; shallow comparisons work.

	// eslint-disable-next-line eqeqeq

	if ( ( context.ownerDocument || context ) != document ) {

		setDocument( context );

	}

	return contains( context, elem );

};



Sizzle.attr = function( elem, name ) {



	// Set document vars if needed

	// Support: IE 11+, Edge 17 - 18+

	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing

	// two documents; shallow comparisons work.

	// eslint-disable-next-line eqeqeq

	if ( ( elem.ownerDocument || elem ) != document ) {

		setDocument( elem );

	}



	var fn = Expr.attrHandle[ name.toLowerCase() ],



		// Don't get fooled by Object.prototype properties (jQuery #13807)

		val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?

			fn( elem, name, !documentIsHTML ) :

			undefined;



	return val !== undefined ?

		val :

		support.attributes || !documentIsHTML ?

			elem.getAttribute( name ) :

			( val = elem.getAttributeNode( name ) ) && val.specified ?

				val.value :

				null;

};



Sizzle.escape = function( sel ) {

	return ( sel + "" ).replace( rcssescape, fcssescape );

};



Sizzle.error = function( msg ) {

	throw new Error( "Syntax error, unrecognized expression: " + msg );

};



/**

 * Document sorting and removing duplicates

 * @param {ArrayLike} results

 */

Sizzle.uniqueSort = function( results ) {

	var elem,

		duplicates = [],

		j = 0,

		i = 0;



	// Unless we *know* we can detect duplicates, assume their presence

	hasDuplicate = !support.detectDuplicates;

	sortInput = !support.sortStable && results.slice( 0 );

	results.sort( sortOrder );



	if ( hasDuplicate ) {

		while ( ( elem = results[ i++ ] ) ) {

			if ( elem === results[ i ] ) {

				j = duplicates.push( i );

			}

		}

		while ( j-- ) {

			results.splice( duplicates[ j ], 1 );

		}

	}



	// Clear input after sorting to release objects

	// See https://github.com/jquery/sizzle/pull/225

	sortInput = null;



	return results;

};



/**

 * Utility function for retrieving the text value of an array of DOM nodes

 * @param {Array|Element} elem

 */

getText = Sizzle.getText = function( elem ) {

	var node,

		ret = "",

		i = 0,

		nodeType = elem.nodeType;



	if ( !nodeType ) {



		// If no nodeType, this is expected to be an array

		while ( ( node = elem[ i++ ] ) ) {



			// Do not traverse comment nodes

			ret += getText( node );

		}

	} else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {



		// Use textContent for elements

		// innerText usage removed for consistency of new lines (jQuery #11153)

		if ( typeof elem.textContent === "string" ) {

			return elem.textContent;

		} else {



			// Traverse its children

			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {

				ret += getText( elem );

			}

		}

	} else if ( nodeType === 3 || nodeType === 4 ) {

		return elem.nodeValue;

	}



	// Do not include comment or processing instruction nodes



	return ret;

};



Expr = Sizzle.selectors = {



	// Can be adjusted by the user

	cacheLength: 50,



	createPseudo: markFunction,



	match: matchExpr,



	attrHandle: {},



	find: {},



	relative: {

		">": { dir: "parentNode", first: true },

		" ": { dir: "parentNode" },

		"+": { dir: "previousSibling", first: true },

		"~": { dir: "previousSibling" }

	},



	preFilter: {

		"ATTR": function( match ) {

			match[ 1 ] = match[ 1 ].replace( runescape, funescape );



			// Move the given value to match[3] whether quoted or unquoted

			match[ 3 ] = ( match[ 3 ] || match[ 4 ] ||

				match[ 5 ] || "" ).replace( runescape, funescape );



			if ( match[ 2 ] === "~=" ) {

				match[ 3 ] = " " + match[ 3 ] + " ";

			}



			return match.slice( 0, 4 );

		},



		"CHILD": function( match ) {



			/* matches from matchExpr["CHILD"]

				1 type (only|nth|...)

				2 what (child|of-type)

				3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)

				4 xn-component of xn+y argument ([+-]?\d*n|)

				5 sign of xn-component

				6 x of xn-component

				7 sign of y-component

				8 y of y-component

			*/

			match[ 1 ] = match[ 1 ].toLowerCase();



			if ( match[ 1 ].slice( 0, 3 ) === "nth" ) {



				// nth-* requires argument

				if ( !match[ 3 ] ) {

					Sizzle.error( match[ 0 ] );

				}



				// numeric x and y parameters for Expr.filter.CHILD

				// remember that false/true cast respectively to 0/1

				match[ 4 ] = +( match[ 4 ] ?

					match[ 5 ] + ( match[ 6 ] || 1 ) :

					2 * ( match[ 3 ] === "even" || match[ 3 ] === "odd" ) );

				match[ 5 ] = +( ( match[ 7 ] + match[ 8 ] ) || match[ 3 ] === "odd" );



				// other types prohibit arguments

			} else if ( match[ 3 ] ) {

				Sizzle.error( match[ 0 ] );

			}



			return match;

		},



		"PSEUDO": function( match ) {

			var excess,

				unquoted = !match[ 6 ] && match[ 2 ];



			if ( matchExpr[ "CHILD" ].test( match[ 0 ] ) ) {

				return null;

			}



			// Accept quoted arguments as-is

			if ( match[ 3 ] ) {

				match[ 2 ] = match[ 4 ] || match[ 5 ] || "";



			// Strip excess characters from unquoted arguments

			} else if ( unquoted && rpseudo.test( unquoted ) &&



				// Get excess from tokenize (recursively)

				( excess = tokenize( unquoted, true ) ) &&



				// advance to the next closing parenthesis

				( excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length ) ) {



				// excess is a negative index

				match[ 0 ] = match[ 0 ].slice( 0, excess );

				match[ 2 ] = unquoted.slice( 0, excess );

			}



			// Return only captures needed by the pseudo filter method (type and argument)

			return match.slice( 0, 3 );

		}

	},



	filter: {



		"TAG": function( nodeNameSelector ) {

			var nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();

			return nodeNameSelector === "*" ?

				function() {

					return true;

				} :

				function( elem ) {

					return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;

				};

		},



		"CLASS": function( className ) {

			var pattern = classCache[ className + " " ];



			return pattern ||

				( pattern = new RegExp( "(^|" + whitespace +

					")" + className + "(" + whitespace + "|$)" ) ) && classCache(

						className, function( elem ) {

							return pattern.test(

								typeof elem.className === "string" && elem.className ||

								typeof elem.getAttribute !== "undefined" &&

									elem.getAttribute( "class" ) ||

								""

							);

				} );

		},



		"ATTR": function( name, operator, check ) {

			return function( elem ) {

				var result = Sizzle.attr( elem, name );



				if ( result == null ) {

					return operator === "!=";

				}

				if ( !operator ) {

					return true;

				}



				result += "";



				/* eslint-disable max-len */



				return operator === "=" ? result === check :

					operator === "!=" ? result !== check :

					operator === "^=" ? check && result.indexOf( check ) === 0 :

					operator === "*=" ? check && result.indexOf( check ) > -1 :

					operator === "$=" ? check && result.slice( -check.length ) === check :

					operator === "~=" ? ( " " + result.replace( rwhitespace, " " ) + " " ).indexOf( check ) > -1 :

					operator === "|=" ? result === check || result.slice( 0, check.length + 1 ) === check + "-" :

					false;

				/* eslint-enable max-len */



			};

		},



		"CHILD": function( type, what, _argument, first, last ) {

			var simple = type.slice( 0, 3 ) !== "nth",

				forward = type.slice( -4 ) !== "last",

				ofType = what === "of-type";



			return first === 1 && last === 0 ?



				// Shortcut for :nth-*(n)

				function( elem ) {

					return !!elem.parentNode;

				} :



				function( elem, _context, xml ) {

					var cache, uniqueCache, outerCache, node, nodeIndex, start,

						dir = simple !== forward ? "nextSibling" : "previousSibling",

						parent = elem.parentNode,

						name = ofType && elem.nodeName.toLowerCase(),

						useCache = !xml && !ofType,

						diff = false;



					if ( parent ) {



						// :(first|last|only)-(child|of-type)

						if ( simple ) {

							while ( dir ) {

								node = elem;

								while ( ( node = node[ dir ] ) ) {

									if ( ofType ?

										node.nodeName.toLowerCase() === name :

										node.nodeType === 1 ) {



										return false;

									}

								}



								// Reverse direction for :only-* (if we haven't yet done so)

								start = dir = type === "only" && !start && "nextSibling";

							}

							return true;

						}



						start = [ forward ? parent.firstChild : parent.lastChild ];



						// non-xml :nth-child(...) stores cache data on `parent`

						if ( forward && useCache ) {



							// Seek `elem` from a previously-cached index



							// ...in a gzip-friendly way

							node = parent;

							outerCache = node[ expando ] || ( node[ expando ] = {} );



							// Support: IE <9 only

							// Defend against cloned attroperties (jQuery gh-1709)

							uniqueCache = outerCache[ node.uniqueID ] ||

								( outerCache[ node.uniqueID ] = {} );



							cache = uniqueCache[ type ] || [];

							nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];

							diff = nodeIndex && cache[ 2 ];

							node = nodeIndex && parent.childNodes[ nodeIndex ];



							while ( ( node = ++nodeIndex && node && node[ dir ] ||



								// Fallback to seeking `elem` from the start

								( diff = nodeIndex = 0 ) || start.pop() ) ) {



								// When found, cache indexes on `parent` and break

								if ( node.nodeType === 1 && ++diff && node === elem ) {

									uniqueCache[ type ] = [ dirruns, nodeIndex, diff ];

									break;

								}

							}



						} else {



							// Use previously-cached element index if available

							if ( useCache ) {



								// ...in a gzip-friendly way

								node = elem;

								outerCache = node[ expando ] || ( node[ expando ] = {} );



								// Support: IE <9 only

								// Defend against cloned attroperties (jQuery gh-1709)

								uniqueCache = outerCache[ node.uniqueID ] ||

									( outerCache[ node.uniqueID ] = {} );



								cache = uniqueCache[ type ] || [];

								nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];

								diff = nodeIndex;

							}



							// xml :nth-child(...)

							// or :nth-last-child(...) or :nth(-last)?-of-type(...)

							if ( diff === false ) {



								// Use the same loop as above to seek `elem` from the start

								while ( ( node = ++nodeIndex && node && node[ dir ] ||

									( diff = nodeIndex = 0 ) || start.pop() ) ) {



									if ( ( ofType ?

										node.nodeName.toLowerCase() === name :

										node.nodeType === 1 ) &&

										++diff ) {



										// Cache the index of each encountered element

										if ( useCache ) {

											outerCache = node[ expando ] ||

												( node[ expando ] = {} );



											// Support: IE <9 only

											// Defend against cloned attroperties (jQuery gh-1709)

											uniqueCache = outerCache[ node.uniqueID ] ||

												( outerCache[ node.uniqueID ] = {} );



											uniqueCache[ type ] = [ dirruns, diff ];

										}



										if ( node === elem ) {

											break;

										}

									}

								}

							}

						}



						// Incorporate the offset, then check against cycle size

						diff -= last;

						return diff === first || ( diff % first === 0 && diff / first >= 0 );

					}

				};

		},



		"PSEUDO": function( pseudo, argument ) {



			// pseudo-class names are case-insensitive

			// http://www.w3.org/TR/selectors/#pseudo-classes

			// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters

			// Remember that setFilters inherits from pseudos

			var args,

				fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||

					Sizzle.error( "unsupported pseudo: " + pseudo );



			// The user may use createPseudo to indicate that

			// arguments are needed to create the filter function

			// just as Sizzle does

			if ( fn[ expando ] ) {

				return fn( argument );

			}



			// But maintain support for old signatures

			if ( fn.length > 1 ) {

				args = [ pseudo, pseudo, "", argument ];

				return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?

					markFunction( function( seed, matches ) {

						var idx,

							matched = fn( seed, argument ),

							i = matched.length;

						while ( i-- ) {

							idx = indexOf( seed, matched[ i ] );

							seed[ idx ] = !( matches[ idx ] = matched[ i ] );

						}

					} ) :

					function( elem ) {

						return fn( elem, 0, args );

					};

			}



			return fn;

		}

	},



	pseudos: {



		// Potentially complex pseudos

		"not": markFunction( function( selector ) {



			// Trim the selector passed to compile

			// to avoid treating leading and trailing

			// spaces as combinators

			var input = [],

				results = [],

				matcher = compile( selector.replace( rtrim, "$1" ) );



			return matcher[ expando ] ?

				markFunction( function( seed, matches, _context, xml ) {

					var elem,

						unmatched = matcher( seed, null, xml, [] ),

						i = seed.length;



					// Match elements unmatched by `matcher`

					while ( i-- ) {

						if ( ( elem = unmatched[ i ] ) ) {

							seed[ i ] = !( matches[ i ] = elem );

						}

					}

				} ) :

				function( elem, _context, xml ) {

					input[ 0 ] = elem;

					matcher( input, null, xml, results );



					// Don't keep the element (issue #299)

					input[ 0 ] = null;

					return !results.pop();

				};

		} ),



		"has": markFunction( function( selector ) {

			return function( elem ) {

				return Sizzle( selector, elem ).length > 0;

			};

		} ),



		"contains": markFunction( function( text ) {

			text = text.replace( runescape, funescape );

			return function( elem ) {

				return ( elem.textContent || getText( elem ) ).indexOf( text ) > -1;

			};

		} ),



		// "Whether an element is represented by a :lang() selector

		// is based solely on the element's language value

		// being equal to the identifier C,

		// or beginning with the identifier C immediately followed by "-".

		// The matching of C against the element's language value is performed case-insensitively.

		// The identifier C does not have to be a valid language name."

		// http://www.w3.org/TR/selectors/#lang-pseudo

		"lang": markFunction( function( lang ) {



			// lang value must be a valid identifier

			if ( !ridentifier.test( lang || "" ) ) {

				Sizzle.error( "unsupported lang: " + lang );

			}

			lang = lang.replace( runescape, funescape ).toLowerCase();

			return function( elem ) {

				var elemLang;

				do {

					if ( ( elemLang = documentIsHTML ?

						elem.lang :

						elem.getAttribute( "xml:lang" ) || elem.getAttribute( "lang" ) ) ) {



						elemLang = elemLang.toLowerCase();

						return elemLang === lang || elemLang.indexOf( lang + "-" ) === 0;

					}

				} while ( ( elem = elem.parentNode ) && elem.nodeType === 1 );

				return false;

			};

		} ),



		// Miscellaneous

		"target": function( elem ) {

			var hash = window.location && window.location.hash;

			return hash && hash.slice( 1 ) === elem.id;

		},



		"root": function( elem ) {

			return elem === docElem;

		},



		"focus": function( elem ) {

			return elem === document.activeElement &&

				( !document.hasFocus || document.hasFocus() ) &&

				!!( elem.type || elem.href || ~elem.tabIndex );

		},



		// Boolean properties

		"enabled": createDisabledPseudo( false ),

		"disabled": createDisabledPseudo( true ),



		"checked": function( elem ) {



			// In CSS3, :checked should return both checked and selected elements

			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked

			var nodeName = elem.nodeName.toLowerCase();

			return ( nodeName === "input" && !!elem.checked ) ||

				( nodeName === "option" && !!elem.selected );

		},



		"selected": function( elem ) {



			// Accessing this property makes selected-by-default

			// options in Safari work properly

			if ( elem.parentNode ) {

				// eslint-disable-next-line no-unused-expressions

				elem.parentNode.selectedIndex;

			}



			return elem.selected === true;

		},



		// Contents

		"empty": function( elem ) {



			// http://www.w3.org/TR/selectors/#empty-pseudo

			// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),

			//   but not by others (comment: 8; processing instruction: 7; etc.)

			// nodeType < 6 works because attributes (2) do not appear as children

			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {

				if ( elem.nodeType < 6 ) {

					return false;

				}

			}

			return true;

		},



		"parent": function( elem ) {

			return !Expr.pseudos[ "empty" ]( elem );

		},



		// Element/input types

		"header": function( elem ) {

			return rheader.test( elem.nodeName );

		},



		"input": function( elem ) {

			return rinputs.test( elem.nodeName );

		},



		"button": function( elem ) {

			var name = elem.nodeName.toLowerCase();

			return name === "input" && elem.type === "button" || name === "button";

		},



		"text": function( elem ) {

			var attr;

			return elem.nodeName.toLowerCase() === "input" &&

				elem.type === "text" &&



				// Support: IE<8

				// New HTML5 attribute values (e.g., "search") appear with elem.type === "text"

				( ( attr = elem.getAttribute( "type" ) ) == null ||

					attr.toLowerCase() === "text" );

		},



		// Position-in-collection

		"first": createPositionalPseudo( function() {

			return [ 0 ];

		} ),



		"last": createPositionalPseudo( function( _matchIndexes, length ) {

			return [ length - 1 ];

		} ),



		"eq": createPositionalPseudo( function( _matchIndexes, length, argument ) {

			return [ argument < 0 ? argument + length : argument ];

		} ),



		"even": createPositionalPseudo( function( matchIndexes, length ) {

			var i = 0;

			for ( ; i < length; i += 2 ) {

				matchIndexes.push( i );

			}

			return matchIndexes;

		} ),



		"odd": createPositionalPseudo( function( matchIndexes, length ) {

			var i = 1;

			for ( ; i < length; i += 2 ) {

				matchIndexes.push( i );

			}

			return matchIndexes;

		} ),



		"lt": createPositionalPseudo( function( matchIndexes, length, argument ) {

			var i = argument < 0 ?

				argument + length :

				argument > length ?

					length :

					argument;

			for ( ; --i >= 0; ) {

				matchIndexes.push( i );

			}

			return matchIndexes;

		} ),



		"gt": createPositionalPseudo( function( matchIndexes, length, argument ) {

			var i = argument < 0 ? argument + length : argument;

			for ( ; ++i < length; ) {

				matchIndexes.push( i );

			}

			return matchIndexes;

		} )

	}

};



Expr.pseudos[ "nth" ] = Expr.pseudos[ "eq" ];



// Add button/input type pseudos

for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {

	Expr.pseudos[ i ] = createInputPseudo( i );

}

for ( i in { submit: true, reset: true } ) {

	Expr.pseudos[ i ] = createButtonPseudo( i );

}



// Easy API for creating new setFilters

function setFilters() {}

setFilters.prototype = Expr.filters = Expr.pseudos;

Expr.setFilters = new setFilters();



tokenize = Sizzle.tokenize = function( selector, parseOnly ) {

	var matched, match, tokens, type,

		soFar, groups, preFilters,

		cached = tokenCache[ selector + " " ];



	if ( cached ) {

		return parseOnly ? 0 : cached.slice( 0 );

	}



	soFar = selector;

	groups = [];

	preFilters = Expr.preFilter;



	while ( soFar ) {



		// Comma and first run

		if ( !matched || ( match = rcomma.exec( soFar ) ) ) {

			if ( match ) {



				// Don't consume trailing commas as valid

				soFar = soFar.slice( match[ 0 ].length ) || soFar;

			}

			groups.push( ( tokens = [] ) );

		}



		matched = false;



		// Combinators

		if ( ( match = rcombinators.exec( soFar ) ) ) {

			matched = match.shift();

			tokens.push( {

				value: matched,



				// Cast descendant combinators to space

				type: match[ 0 ].replace( rtrim, " " )

			} );

			soFar = soFar.slice( matched.length );

		}



		// Filters

		for ( type in Expr.filter ) {

			if ( ( match = matchExpr[ type ].exec( soFar ) ) && ( !preFilters[ type ] ||

				( match = preFilters[ type ]( match ) ) ) ) {

				matched = match.shift();

				tokens.push( {

					value: matched,

					type: type,

					matches: match

				} );

				soFar = soFar.slice( matched.length );

			}

		}



		if ( !matched ) {

			break;

		}

	}



	// Return the length of the invalid excess

	// if we're just parsing

	// Otherwise, throw an error or return tokens

	return parseOnly ?

		soFar.length :

		soFar ?

			Sizzle.error( selector ) :



			// Cache the tokens

			tokenCache( selector, groups ).slice( 0 );

};



function toSelector( tokens ) {

	var i = 0,

		len = tokens.length,

		selector = "";

	for ( ; i < len; i++ ) {

		selector += tokens[ i ].value;

	}

	return selector;

}



function addCombinator( matcher, combinator, base ) {

	var dir = combinator.dir,

		skip = combinator.next,

		key = skip || dir,

		checkNonElements = base && key === "parentNode",

		doneName = done++;



	return combinator.first ?



		// Check against closest ancestor/preceding element

		function( elem, context, xml ) {

			while ( ( elem = elem[ dir ] ) ) {

				if ( elem.nodeType === 1 || checkNonElements ) {

					return matcher( elem, context, xml );

				}

			}

			return false;

		} :



		// Check against all ancestor/preceding elements

		function( elem, context, xml ) {

			var oldCache, uniqueCache, outerCache,

				newCache = [ dirruns, doneName ];



			// We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching

			if ( xml ) {

				while ( ( elem = elem[ dir ] ) ) {

					if ( elem.nodeType === 1 || checkNonElements ) {

						if ( matcher( elem, context, xml ) ) {

							return true;

						}

					}

				}

			} else {

				while ( ( elem = elem[ dir ] ) ) {

					if ( elem.nodeType === 1 || checkNonElements ) {

						outerCache = elem[ expando ] || ( elem[ expando ] = {} );



						// Support: IE <9 only

						// Defend against cloned attroperties (jQuery gh-1709)

						uniqueCache = outerCache[ elem.uniqueID ] ||

							( outerCache[ elem.uniqueID ] = {} );



						if ( skip && skip === elem.nodeName.toLowerCase() ) {

							elem = elem[ dir ] || elem;

						} else if ( ( oldCache = uniqueCache[ key ] ) &&

							oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {



							// Assign to newCache so results back-propagate to previous elements

							return ( newCache[ 2 ] = oldCache[ 2 ] );

						} else {



							// Reuse newcache so results back-propagate to previous elements

							uniqueCache[ key ] = newCache;



							// A match means we're done; a fail means we have to keep checking

							if ( ( newCache[ 2 ] = matcher( elem, context, xml ) ) ) {

								return true;

							}

						}

					}

				}

			}

			return false;

		};

}



function elementMatcher( matchers ) {

	return matchers.length > 1 ?

		function( elem, context, xml ) {

			var i = matchers.length;

			while ( i-- ) {

				if ( !matchers[ i ]( elem, context, xml ) ) {

					return false;

				}

			}

			return true;

		} :

		matchers[ 0 ];

}



function multipleContexts( selector, contexts, results ) {

	var i = 0,

		len = contexts.length;

	for ( ; i < len; i++ ) {

		Sizzle( selector, contexts[ i ], results );

	}

	return results;

}



function condense( unmatched, map, filter, context, xml ) {

	var elem,

		newUnmatched = [],

		i = 0,

		len = unmatched.length,

		mapped = map != null;



	for ( ; i < len; i++ ) {

		if ( ( elem = unmatched[ i ] ) ) {

			if ( !filter || filter( elem, context, xml ) ) {

				newUnmatched.push( elem );

				if ( mapped ) {

					map.push( i );

				}

			}

		}

	}



	return newUnmatched;

}



function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {

	if ( postFilter && !postFilter[ expando ] ) {

		postFilter = setMatcher( postFilter );

	}

	if ( postFinder && !postFinder[ expando ] ) {

		postFinder = setMatcher( postFinder, postSelector );

	}

	return markFunction( function( seed, results, context, xml ) {

		var temp, i, elem,

			preMap = [],

			postMap = [],

			preexisting = results.length,



			// Get initial elements from seed or context

			elems = seed || multipleContexts(

				selector || "*",

				context.nodeType ? [ context ] : context,

				[]

			),



			// Prefilter to get matcher input, preserving a map for seed-results synchronization

			matcherIn = preFilter && ( seed || !selector ) ?

				condense( elems, preMap, preFilter, context, xml ) :

				elems,



			matcherOut = matcher ?



				// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,

				postFinder || ( seed ? preFilter : preexisting || postFilter ) ?



					// ...intermediate processing is necessary

					[] :



					// ...otherwise use results directly

					results :

				matcherIn;



		// Find primary matches

		if ( matcher ) {

			matcher( matcherIn, matcherOut, context, xml );

		}



		// Apply postFilter

		if ( postFilter ) {

			temp = condense( matcherOut, postMap );

			postFilter( temp, [], context, xml );



			// Un-match failing elements by moving them back to matcherIn

			i = temp.length;

			while ( i-- ) {

				if ( ( elem = temp[ i ] ) ) {

					matcherOut[ postMap[ i ] ] = !( matcherIn[ postMap[ i ] ] = elem );

				}

			}

		}



		if ( seed ) {

			if ( postFinder || preFilter ) {

				if ( postFinder ) {



					// Get the final matcherOut by condensing this intermediate into postFinder contexts

					temp = [];

					i = matcherOut.length;

					while ( i-- ) {

						if ( ( elem = matcherOut[ i ] ) ) {



							// Restore matcherIn since elem is not yet a final match

							temp.push( ( matcherIn[ i ] = elem ) );

						}

					}

					postFinder( null, ( matcherOut = [] ), temp, xml );

				}



				// Move matched elements from seed to results to keep them synchronized

				i = matcherOut.length;

				while ( i-- ) {

					if ( ( elem = matcherOut[ i ] ) &&

						( temp = postFinder ? indexOf( seed, elem ) : preMap[ i ] ) > -1 ) {



						seed[ temp ] = !( results[ temp ] = elem );

					}

				}

			}



		// Add elements to results, through postFinder if defined

		} else {

			matcherOut = condense(

				matcherOut === results ?

					matcherOut.splice( preexisting, matcherOut.length ) :

					matcherOut

			);

			if ( postFinder ) {

				postFinder( null, results, matcherOut, xml );

			} else {

				push.apply( results, matcherOut );

			}

		}

	} );

}



function matcherFromTokens( tokens ) {

	var checkContext, matcher, j,

		len = tokens.length,

		leadingRelative = Expr.relative[ tokens[ 0 ].type ],

		implicitRelative = leadingRelative || Expr.relative[ " " ],

		i = leadingRelative ? 1 : 0,



		// The foundational matcher ensures that elements are reachable from top-level context(s)

		matchContext = addCombinator( function( elem ) {

			return elem === checkContext;

		}, implicitRelative, true ),

		matchAnyContext = addCombinator( function( elem ) {

			return indexOf( checkContext, elem ) > -1;

		}, implicitRelative, true ),

		matchers = [ function( elem, context, xml ) {

			var ret = ( !leadingRelative && ( xml || context !== outermostContext ) ) || (

				( checkContext = context ).nodeType ?

					matchContext( elem, context, xml ) :

					matchAnyContext( elem, context, xml ) );



			// Avoid hanging onto element (issue #299)

			checkContext = null;

			return ret;

		} ];



	for ( ; i < len; i++ ) {

		if ( ( matcher = Expr.relative[ tokens[ i ].type ] ) ) {

			matchers = [ addCombinator( elementMatcher( matchers ), matcher ) ];

		} else {

			matcher = Expr.filter[ tokens[ i ].type ].apply( null, tokens[ i ].matches );



			// Return special upon seeing a positional matcher

			if ( matcher[ expando ] ) {



				// Find the next relative operator (if any) for proper handling

				j = ++i;

				for ( ; j < len; j++ ) {

					if ( Expr.relative[ tokens[ j ].type ] ) {

						break;

					}

				}

				return setMatcher(

					i > 1 && elementMatcher( matchers ),

					i > 1 && toSelector(



					// If the preceding token was a descendant combinator, insert an implicit any-element `*`

					tokens

						.slice( 0, i - 1 )

						.concat( { value: tokens[ i - 2 ].type === " " ? "*" : "" } )

					).replace( rtrim, "$1" ),

					matcher,

					i < j && matcherFromTokens( tokens.slice( i, j ) ),

					j < len && matcherFromTokens( ( tokens = tokens.slice( j ) ) ),

					j < len && toSelector( tokens )

				);

			}

			matchers.push( matcher );

		}

	}



	return elementMatcher( matchers );

}



function matcherFromGroupMatchers( elementMatchers, setMatchers ) {

	var bySet = setMatchers.length > 0,

		byElement = elementMatchers.length > 0,

		superMatcher = function( seed, context, xml, results, outermost ) {

			var elem, j, matcher,

				matchedCount = 0,

				i = "0",

				unmatched = seed && [],

				setMatched = [],

				contextBackup = outermostContext,



				// We must always have either seed elements or outermost context

				elems = seed || byElement && Expr.find[ "TAG" ]( "*", outermost ),



				// Use integer dirruns iff this is the outermost matcher

				dirrunsUnique = ( dirruns += contextBackup == null ? 1 : Math.random() || 0.1 ),

				len = elems.length;



			if ( outermost ) {



				// Support: IE 11+, Edge 17 - 18+

				// IE/Edge sometimes throw a "Permission denied" error when strict-comparing

				// two documents; shallow comparisons work.

				// eslint-disable-next-line eqeqeq

				outermostContext = context == document || context || outermost;

			}



			// Add elements passing elementMatchers directly to results

			// Support: IE<9, Safari

			// Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id

			for ( ; i !== len && ( elem = elems[ i ] ) != null; i++ ) {

				if ( byElement && elem ) {

					j = 0;



					// Support: IE 11+, Edge 17 - 18+

					// IE/Edge sometimes throw a "Permission denied" error when strict-comparing

					// two documents; shallow comparisons work.

					// eslint-disable-next-line eqeqeq

					if ( !context && elem.ownerDocument != document ) {

						setDocument( elem );

						xml = !documentIsHTML;

					}

					while ( ( matcher = elementMatchers[ j++ ] ) ) {

						if ( matcher( elem, context || document, xml ) ) {

							results.push( elem );

							break;

						}

					}

					if ( outermost ) {

						dirruns = dirrunsUnique;

					}

				}



				// Track unmatched elements for set filters

				if ( bySet ) {



					// They will have gone through all possible matchers

					if ( ( elem = !matcher && elem ) ) {

						matchedCount--;

					}



					// Lengthen the array for every element, matched or not

					if ( seed ) {

						unmatched.push( elem );

					}

				}

			}



			// `i` is now the count of elements visited above, and adding it to `matchedCount`

			// makes the latter nonnegative.

			matchedCount += i;



			// Apply set filters to unmatched elements

			// NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`

			// equals `i`), unless we didn't visit _any_ elements in the above loop because we have

			// no element matchers and no seed.

			// Incrementing an initially-string "0" `i` allows `i` to remain a string only in that

			// case, which will result in a "00" `matchedCount` that differs from `i` but is also

			// numerically zero.

			if ( bySet && i !== matchedCount ) {

				j = 0;

				while ( ( matcher = setMatchers[ j++ ] ) ) {

					matcher( unmatched, setMatched, context, xml );

				}



				if ( seed ) {



					// Reintegrate element matches to eliminate the need for sorting

					if ( matchedCount > 0 ) {

						while ( i-- ) {

							if ( !( unmatched[ i ] || setMatched[ i ] ) ) {

								setMatched[ i ] = pop.call( results );

							}

						}

					}



					// Discard index placeholder values to get only actual matches

					setMatched = condense( setMatched );

				}



				// Add matches to results

				push.apply( results, setMatched );



				// Seedless set matches succeeding multiple successful matchers stipulate sorting

				if ( outermost && !seed && setMatched.length > 0 &&

					( matchedCount + setMatchers.length ) > 1 ) {



					Sizzle.uniqueSort( results );

				}

			}



			// Override manipulation of globals by nested matchers

			if ( outermost ) {

				dirruns = dirrunsUnique;

				outermostContext = contextBackup;

			}



			return unmatched;

		};



	return bySet ?

		markFunction( superMatcher ) :

		superMatcher;

}



compile = Sizzle.compile = function( selector, match /* Internal Use Only */ ) {

	var i,

		setMatchers = [],

		elementMatchers = [],

		cached = compilerCache[ selector + " " ];



	if ( !cached ) {



		// Generate a function of recursive functions that can be used to check each element

		if ( !match ) {

			match = tokenize( selector );

		}

		i = match.length;

		while ( i-- ) {

			cached = matcherFromTokens( match[ i ] );

			if ( cached[ expando ] ) {

				setMatchers.push( cached );

			} else {

				elementMatchers.push( cached );

			}

		}



		// Cache the compiled function

		cached = compilerCache(

			selector,

			matcherFromGroupMatchers( elementMatchers, setMatchers )

		);



		// Save selector and tokenization

		cached.selector = selector;

	}

	return cached;

};



/**

 * A low-level selection function that works with Sizzle's compiled

 *  selector functions

 * @param {String|Function} selector A selector or a pre-compiled

 *  selector function built with Sizzle.compile

 * @param {Element} context

 * @param {Array} [results]

 * @param {Array} [seed] A set of elements to match against

 */

select = Sizzle.select = function( selector, context, results, seed ) {

	var i, tokens, token, type, find,

		compiled = typeof selector === "function" && selector,

		match = !seed && tokenize( ( selector = compiled.selector || selector ) );



	results = results || [];



	// Try to minimize operations if there is only one selector in the list and no seed

	// (the latter of which guarantees us context)

	if ( match.length === 1 ) {



		// Reduce context if the leading compound selector is an ID

		tokens = match[ 0 ] = match[ 0 ].slice( 0 );

		if ( tokens.length > 2 && ( token = tokens[ 0 ] ).type === "ID" &&

			context.nodeType === 9 && documentIsHTML && Expr.relative[ tokens[ 1 ].type ] ) {



			context = ( Expr.find[ "ID" ]( token.matches[ 0 ]

				.replace( runescape, funescape ), context ) || [] )[ 0 ];

			if ( !context ) {

				return results;



			// Precompiled matchers will still verify ancestry, so step up a level

			} else if ( compiled ) {

				context = context.parentNode;

			}



			selector = selector.slice( tokens.shift().value.length );

		}



		// Fetch a seed set for right-to-left matching

		i = matchExpr[ "needsContext" ].test( selector ) ? 0 : tokens.length;

		while ( i-- ) {

			token = tokens[ i ];



			// Abort if we hit a combinator

			if ( Expr.relative[ ( type = token.type ) ] ) {

				break;

			}

			if ( ( find = Expr.find[ type ] ) ) {



				// Search, expanding context for leading sibling combinators

				if ( ( seed = find(

					token.matches[ 0 ].replace( runescape, funescape ),

					rsibling.test( tokens[ 0 ].type ) && testContext( context.parentNode ) ||

						context

				) ) ) {



					// If seed is empty or no tokens remain, we can return early

					tokens.splice( i, 1 );

					selector = seed.length && toSelector( tokens );

					if ( !selector ) {

						push.apply( results, seed );

						return results;

					}



					break;

				}

			}

		}

	}



	// Compile and execute a filtering function if one is not provided

	// Provide `match` to avoid retokenization if we modified the selector above

	( compiled || compile( selector, match ) )(

		seed,

		context,

		!documentIsHTML,

		results,

		!context || rsibling.test( selector ) && testContext( context.parentNode ) || context

	);

	return results;

};



// One-time assignments



// Sort stability

support.sortStable = expando.split( "" ).sort( sortOrder ).join( "" ) === expando;



// Support: Chrome 14-35+

// Always assume duplicates if they aren't passed to the comparison function

support.detectDuplicates = !!hasDuplicate;



// Initialize against the default document

setDocument();



// Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)

// Detached nodes confoundingly follow *each other*

support.sortDetached = assert( function( el ) {



	// Should return 1, but returns 4 (following)

	return el.compareDocumentPosition( document.createElement( "fieldset" ) ) & 1;

} );



// Support: IE<8

// Prevent attribute/property "interpolation"

// https://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx

if ( !assert( function( el ) {

	el.innerHTML = "<a href='#'></a>";

	return el.firstChild.getAttribute( "href" ) === "#";

} ) ) {

	addHandle( "type|href|height|width", function( elem, name, isXML ) {

		if ( !isXML ) {

			return elem.getAttribute( name, name.toLowerCase() === "type" ? 1 : 2 );

		}

	} );

}



// Support: IE<9

// Use defaultValue in place of getAttribute("value")

if ( !support.attributes || !assert( function( el ) {

	el.innerHTML = "<input/>";

	el.firstChild.setAttribute( "value", "" );

	return el.firstChild.getAttribute( "value" ) === "";

} ) ) {

	addHandle( "value", function( elem, _name, isXML ) {

		if ( !isXML && elem.nodeName.toLowerCase() === "input" ) {

			return elem.defaultValue;

		}

	} );

}



// Support: IE<9

// Use getAttributeNode to fetch booleans when getAttribute lies

if ( !assert( function( el ) {

	return el.getAttribute( "disabled" ) == null;

} ) ) {

	addHandle( booleans, function( elem, name, isXML ) {

		var val;

		if ( !isXML ) {

			return elem[ name ] === true ? name.toLowerCase() :

				( val = elem.getAttributeNode( name ) ) && val.specified ?

					val.value :

					null;

		}

	} );

}



return Sizzle;



} )( window );







jQuery.find = Sizzle;

jQuery.expr = Sizzle.selectors;



// Deprecated

jQuery.expr[ ":" ] = jQuery.expr.pseudos;

jQuery.uniqueSort = jQuery.unique = Sizzle.uniqueSort;

jQuery.text = Sizzle.getText;

jQuery.isXMLDoc = Sizzle.isXML;

jQuery.contains = Sizzle.contains;

jQuery.escapeSelector = Sizzle.escape;









var dir = function( elem, dir, until ) {

	var matched = [],

		truncate = until !== undefined;



	while ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {

		if ( elem.nodeType === 1 ) {

			if ( truncate && jQuery( elem ).is( until ) ) {

				break;

			}

			matched.push( elem );

		}

	}

	return matched;

};





var siblings = function( n, elem ) {

	var matched = [];



	for ( ; n; n = n.nextSibling ) {

		if ( n.nodeType === 1 && n !== elem ) {

			matched.push( n );

		}

	}



	return matched;

};





var rneedsContext = jQuery.expr.match.needsContext;







function nodeName( elem, name ) {



  return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();



};

var rsingleTag = ( /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i );







// Implement the identical functionality for filter and not

function winnow( elements, qualifier, not ) {

	if ( isFunction( qualifier ) ) {

		return jQuery.grep( elements, function( elem, i ) {

			return !!qualifier.call( elem, i, elem ) !== not;

		} );

	}



	// Single element

	if ( qualifier.nodeType ) {

		return jQuery.grep( elements, function( elem ) {

			return ( elem === qualifier ) !== not;

		} );

	}



	// Arraylike of elements (jQuery, arguments, Array)

	if ( typeof qualifier !== "string" ) {

		return jQuery.grep( elements, function( elem ) {

			return ( indexOf.call( qualifier, elem ) > -1 ) !== not;

		} );

	}



	// Filtered directly for both simple and complex selectors

	return jQuery.filter( qualifier, elements, not );

}



jQuery.filter = function( expr, elems, not ) {

	var elem = elems[ 0 ];



	if ( not ) {

		expr = ":not(" + expr + ")";

	}



	if ( elems.length === 1 && elem.nodeType === 1 ) {

		return jQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [];

	}



	return jQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {

		return elem.nodeType === 1;

	} ) );

};



jQuery.fn.extend( {

	find: function( selector ) {

		var i, ret,

			len = this.length,

			self = this;



		if ( typeof selector !== "string" ) {

			return this.pushStack( jQuery( selector ).filter( function() {

				for ( i = 0; i < len; i++ ) {

					if ( jQuery.contains( self[ i ], this ) ) {

						return true;

					}

				}

			} ) );

		}



		ret = this.pushStack( [] );



		for ( i = 0; i < len; i++ ) {

			jQuery.find( selector, self[ i ], ret );

		}



		return len > 1 ? jQuery.uniqueSort( ret ) : ret;

	},

	filter: function( selector ) {

		return this.pushStack( winnow( this, selector || [], false ) );

	},

	not: function( selector ) {

		return this.pushStack( winnow( this, selector || [], true ) );

	},

	is: function( selector ) {

		return !!winnow(

			this,



			// If this is a positional/relative selector, check membership in the returned set

			// so $("p:first").is("p:last") won't return true for a doc with two "p".

			typeof selector === "string" && rneedsContext.test( selector ) ?

				jQuery( selector ) :

				selector || [],

			false

		).length;

	}

} );





// Initialize a jQuery object





// A central reference to the root jQuery(document)

var rootjQuery,



	// A simple way to check for HTML strings

	// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)

	// Strict HTML recognition (#11290: must start with <)

	// Shortcut simple #id case for speed

	rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,



	init = jQuery.fn.init = function( selector, context, root ) {

		var match, elem;



		// HANDLE: $(""), $(null), $(undefined), $(false)

		if ( !selector ) {

			return this;

		}



		// Method init() accepts an alternate rootjQuery

		// so migrate can support jQuery.sub (gh-2101)

		root = root || rootjQuery;



		// Handle HTML strings

		if ( typeof selector === "string" ) {

			if ( selector[ 0 ] === "<" &&

				selector[ selector.length - 1 ] === ">" &&

				selector.length >= 3 ) {



				// Assume that strings that start and end with <> are HTML and skip the regex check

				match = [ null, selector, null ];



			} else {

				match = rquickExpr.exec( selector );

			}



			// Match html or make sure no context is specified for #id

			if ( match && ( match[ 1 ] || !context ) ) {



				// HANDLE: $(html) -> $(array)

				if ( match[ 1 ] ) {

					context = context instanceof jQuery ? context[ 0 ] : context;



					// Option to run scripts is true for back-compat

					// Intentionally let the error be thrown if parseHTML is not present

					jQuery.merge( this, jQuery.parseHTML(

						match[ 1 ],

						context && context.nodeType ? context.ownerDocument || context : document,

						true

					) );



					// HANDLE: $(html, props)

					if ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {

						for ( match in context ) {



							// Properties of context are called as methods if possible

							if ( isFunction( this[ match ] ) ) {

								this[ match ]( context[ match ] );



							// ...and otherwise set as attributes

							} else {

								this.attr( match, context[ match ] );

							}

						}

					}



					return this;



				// HANDLE: $(#id)

				} else {

					elem = document.getElementById( match[ 2 ] );



					if ( elem ) {



						// Inject the element directly into the jQuery object

						this[ 0 ] = elem;

						this.length = 1;

					}

					return this;

				}



			// HANDLE: $(expr, $(...))

			} else if ( !context || context.jquery ) {

				return ( context || root ).find( selector );



			// HANDLE: $(expr, context)

			// (which is just equivalent to: $(context).find(expr)

			} else {

				return this.constructor( context ).find( selector );

			}



		// HANDLE: $(DOMElement)

		} else if ( selector.nodeType ) {

			this[ 0 ] = selector;

			this.length = 1;

			return this;



		// HANDLE: $(function)

		// Shortcut for document ready

		} else if ( isFunction( selector ) ) {

			return root.ready !== undefined ?

				root.ready( selector ) :



				// Execute immediately if ready is not present

				selector( jQuery );

		}



		return jQuery.makeArray( selector, this );

	};



// Give the init function the jQuery prototype for later instantiation

init.prototype = jQuery.fn;



// Initialize central reference

rootjQuery = jQuery( document );





var rparentsprev = /^(?:parents|prev(?:Until|All))/,



	// Methods guaranteed to produce a unique set when starting from a unique set

	guaranteedUnique = {

		children: true,

		contents: true,

		next: true,

		prev: true

	};



jQuery.fn.extend( {

	has: function( target ) {

		var targets = jQuery( target, this ),

			l = targets.length;



		return this.filter( function() {

			var i = 0;

			for ( ; i < l; i++ ) {

				if ( jQuery.contains( this, targets[ i ] ) ) {

					return true;

				}

			}

		} );

	},



	closest: function( selectors, context ) {

		var cur,

			i = 0,

			l = this.length,

			matched = [],

			targets = typeof selectors !== "string" && jQuery( selectors );



		// Positional selectors never match, since there's no _selection_ context

		if ( !rneedsContext.test( selectors ) ) {

			for ( ; i < l; i++ ) {

				for ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {



					// Always skip document fragments

					if ( cur.nodeType < 11 && ( targets ?

						targets.index( cur ) > -1 :



						// Don't pass non-elements to Sizzle

						cur.nodeType === 1 &&

							jQuery.find.matchesSelector( cur, selectors ) ) ) {



						matched.push( cur );

						break;

					}

				}

			}

		}



		return this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );

	},



	// Determine the position of an element within the set

	index: function( elem ) {



		// No argument, return index in parent

		if ( !elem ) {

			return ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;

		}



		// Index in selector

		if ( typeof elem === "string" ) {

			return indexOf.call( jQuery( elem ), this[ 0 ] );

		}



		// Locate the position of the desired element

		return indexOf.call( this,



			// If it receives a jQuery object, the first element is used

			elem.jquery ? elem[ 0 ] : elem

		);

	},



	add: function( selector, context ) {

		return this.pushStack(

			jQuery.uniqueSort(

				jQuery.merge( this.get(), jQuery( selector, context ) )

			)

		);

	},



	addBack: function( selector ) {

		return this.add( selector == null ?

			this.prevObject : this.prevObject.filter( selector )

		);

	}

} );



function sibling( cur, dir ) {

	while ( ( cur = cur[ dir ] ) && cur.nodeType !== 1 ) {}

	return cur;

}



jQuery.each( {

	parent: function( elem ) {

		var parent = elem.parentNode;

		return parent && parent.nodeType !== 11 ? parent : null;

	},

	parents: function( elem ) {

		return dir( elem, "parentNode" );

	},

	parentsUntil: function( elem, _i, until ) {

		return dir( elem, "parentNode", until );

	},

	next: function( elem ) {

		return sibling( elem, "nextSibling" );

	},

	prev: function( elem ) {

		return sibling( elem, "previousSibling" );

	},

	nextAll: function( elem ) {

		return dir( elem, "nextSibling" );

	},

	prevAll: function( elem ) {

		return dir( elem, "previousSibling" );

	},

	nextUntil: function( elem, _i, until ) {

		return dir( elem, "nextSibling", until );

	},

	prevUntil: function( elem, _i, until ) {

		return dir( elem, "previousSibling", until );

	},

	siblings: function( elem ) {

		return siblings( ( elem.parentNode || {} ).firstChild, elem );

	},

	children: function( elem ) {

		return siblings( elem.firstChild );

	},

	contents: function( elem ) {

		if ( elem.contentDocument != null &&



			// Support: IE 11+

			// <object> elements with no `data` attribute has an object

			// `contentDocument` with a `null` prototype.

			getProto( elem.contentDocument ) ) {



			return elem.contentDocument;

		}



		// Support: IE 9 - 11 only, iOS 7 only, Android Browser <=4.3 only

		// Treat the template element as a regular one in browsers that

		// don't support it.

		if ( nodeName( elem, "template" ) ) {

			elem = elem.content || elem;

		}



		return jQuery.merge( [], elem.childNodes );

	}

}, function( name, fn ) {

	jQuery.fn[ name ] = function( until, selector ) {

		var matched = jQuery.map( this, fn, until );



		if ( name.slice( -5 ) !== "Until" ) {

			selector = until;

		}



		if ( selector && typeof selector === "string" ) {

			matched = jQuery.filter( selector, matched );

		}



		if ( this.length > 1 ) {



			// Remove duplicates

			if ( !guaranteedUnique[ name ] ) {

				jQuery.uniqueSort( matched );

			}



			// Reverse order for parents* and prev-derivatives

			if ( rparentsprev.test( name ) ) {

				matched.reverse();

			}

		}



		return this.pushStack( matched );

	};

} );

var rnothtmlwhite = ( /[^\x20\t\r\n\f]+/g );







// Convert String-formatted options into Object-formatted ones

function createOptions( options ) {

	var object = {};

	jQuery.each( options.match( rnothtmlwhite ) || [], function( _, flag ) {

		object[ flag ] = true;

	} );

	return object;

}



/*

 * Create a callback list using the following parameters:

 *

 *	options: an optional list of space-separated options that will change how

 *			the callback list behaves or a more traditional option object

 *

 * By default a callback list will act like an event callback list and can be

 * "fired" multiple times.

 *

 * Possible options:

 *

 *	once:			will ensure the callback list can only be fired once (like a Deferred)

 *

 *	memory:			will keep track of previous values and will call any callback added

 *					after the list has been fired right away with the latest "memorized"

 *					values (like a Deferred)

 *

 *	unique:			will ensure a callback can only be added once (no duplicate in the list)

 *

 *	stopOnFalse:	interrupt callings when a callback returns false

 *

 */

jQuery.Callbacks = function( options ) {



	// Convert options from String-formatted to Object-formatted if needed

	// (we check in cache first)

	options = typeof options === "string" ?

		createOptions( options ) :

		jQuery.extend( {}, options );



	var // Flag to know if list is currently firing

		firing,



		// Last fire value for non-forgettable lists

		memory,



		// Flag to know if list was already fired

		fired,



		// Flag to prevent firing

		locked,



		// Actual callback list

		list = [],



		// Queue of execution data for repeatable lists

		queue = [],



		// Index of currently firing callback (modified by add/remove as needed)

		firingIndex = -1,



		// Fire callbacks

		fire = function() {



			// Enforce single-firing

			locked = locked || options.once;



			// Execute callbacks for all pending executions,

			// respecting firingIndex overrides and runtime changes

			fired = firing = true;

			for ( ; queue.length; firingIndex = -1 ) {

				memory = queue.shift();

				while ( ++firingIndex < list.length ) {



					// Run callback and check for early termination

					if ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&

						options.stopOnFalse ) {



						// Jump to end and forget the data so .add doesn't re-fire

						firingIndex = list.length;

						memory = false;

					}

				}

			}



			// Forget the data if we're done with it

			if ( !options.memory ) {

				memory = false;

			}



			firing = false;



			// Clean up if we're done firing for good

			if ( locked ) {



				// Keep an empty list if we have data for future add calls

				if ( memory ) {

					list = [];



				// Otherwise, this object is spent

				} else {

					list = "";

				}

			}

		},



		// Actual Callbacks object

		self = {



			// Add a callback or a collection of callbacks to the list

			add: function() {

				if ( list ) {



					// If we have memory from a past run, we should fire after adding

					if ( memory && !firing ) {

						firingIndex = list.length - 1;

						queue.push( memory );

					}



					( function add( args ) {

						jQuery.each( args, function( _, arg ) {

							if ( isFunction( arg ) ) {

								if ( !options.unique || !self.has( arg ) ) {

									list.push( arg );

								}

							} else if ( arg && arg.length && toType( arg ) !== "string" ) {



								// Inspect recursively

								add( arg );

							}

						} );

					} )( arguments );



					if ( memory && !firing ) {

						fire();

					}

				}

				return this;

			},



			// Remove a callback from the list

			remove: function() {

				jQuery.each( arguments, function( _, arg ) {

					var index;

					while ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {

						list.splice( index, 1 );



						// Handle firing indexes

						if ( index <= firingIndex ) {

							firingIndex--;

						}

					}

				} );

				return this;

			},



			// Check if a given callback is in the list.

			// If no argument is given, return whether or not list has callbacks attached.

			has: function( fn ) {

				return fn ?

					jQuery.inArray( fn, list ) > -1 :

					list.length > 0;

			},



			// Remove all callbacks from the list

			empty: function() {

				if ( list ) {

					list = [];

				}

				return this;

			},



			// Disable .fire and .add

			// Abort any current/pending executions

			// Clear all callbacks and values

			disable: function() {

				locked = queue = [];

				list = memory = "";

				return this;

			},

			disabled: function() {

				return !list;

			},



			// Disable .fire

			// Also disable .add unless we have memory (since it would have no effect)

			// Abort any pending executions

			lock: function() {

				locked = queue = [];

				if ( !memory && !firing ) {

					list = memory = "";

				}

				return this;

			},

			locked: function() {

				return !!locked;

			},



			// Call all callbacks with the given context and arguments

			fireWith: function( context, args ) {

				if ( !locked ) {

					args = args || [];

					args = [ context, args.slice ? args.slice() : args ];

					queue.push( args );

					if ( !firing ) {

						fire();

					}

				}

				return this;

			},



			// Call all the callbacks with the given arguments

			fire: function() {

				self.fireWith( this, arguments );

				return this;

			},



			// To know if the callbacks have already been called at least once

			fired: function() {

				return !!fired;

			}

		};



	return self;

};





function Identity( v ) {

	return v;

}

function Thrower( ex ) {

	throw ex;

}



function adoptValue( value, resolve, reject, noValue ) {

	var method;



	try {



		// Check for promise aspect first to privilege synchronous behavior

		if ( value && isFunction( ( method = value.promise ) ) ) {

			method.call( value ).done( resolve ).fail( reject );



		// Other thenables

		} else if ( value && isFunction( ( method = value.then ) ) ) {

			method.call( value, resolve, reject );



		// Other non-thenables

		} else {



			// Control `resolve` arguments by letting Array#slice cast boolean `noValue` to integer:

			// * false: [ value ].slice( 0 ) => resolve( value )

			// * true: [ value ].slice( 1 ) => resolve()

			resolve.apply( undefined, [ value ].slice( noValue ) );

		}



	// For Promises/A+, convert exceptions into rejections

	// Since jQuery.when doesn't unwrap thenables, we can skip the extra checks appearing in

	// Deferred#then to conditionally suppress rejection.

	} catch ( value ) {



		// Support: Android 4.0 only

		// Strict mode functions invoked without .call/.apply get global-object context

		reject.apply( undefined, [ value ] );

	}

}



jQuery.extend( {



	Deferred: function( func ) {

		var tuples = [



				// action, add listener, callbacks,

				// ... .then handlers, argument index, [final state]

				[ "notify", "progress", jQuery.Callbacks( "memory" ),

					jQuery.Callbacks( "memory" ), 2 ],

				[ "resolve", "done", jQuery.Callbacks( "once memory" ),

					jQuery.Callbacks( "once memory" ), 0, "resolved" ],

				[ "reject", "fail", jQuery.Callbacks( "once memory" ),

					jQuery.Callbacks( "once memory" ), 1, "rejected" ]

			],

			state = "pending",

			promise = {

				state: function() {

					return state;

				},

				always: function() {

					deferred.done( arguments ).fail( arguments );

					return this;

				},

				"catch": function( fn ) {

					return promise.then( null, fn );

				},



				// Keep pipe for back-compat

				pipe: function( /* fnDone, fnFail, fnProgress */ ) {

					var fns = arguments;



					return jQuery.Deferred( function( newDefer ) {

						jQuery.each( tuples, function( _i, tuple ) {



							// Map tuples (progress, done, fail) to arguments (done, fail, progress)

							var fn = isFunction( fns[ tuple[ 4 ] ] ) && fns[ tuple[ 4 ] ];



							// deferred.progress(function() { bind to newDefer or newDefer.notify })

							// deferred.done(function() { bind to newDefer or newDefer.resolve })

							// deferred.fail(function() { bind to newDefer or newDefer.reject })

							deferred[ tuple[ 1 ] ]( function() {

								var returned = fn && fn.apply( this, arguments );

								if ( returned && isFunction( returned.promise ) ) {

									returned.promise()

										.progress( newDefer.notify )

										.done( newDefer.resolve )

										.fail( newDefer.reject );

								} else {

									newDefer[ tuple[ 0 ] + "With" ](

										this,

										fn ? [ returned ] : arguments

									);

								}

							} );

						} );

						fns = null;

					} ).promise();

				},

				then: function( onFulfilled, onRejected, onProgress ) {

					var maxDepth = 0;

					function resolve( depth, deferred, handler, special ) {

						return function() {

							var that = this,

								args = arguments,

								mightThrow = function() {

									var returned, then;



									// Support: Promises/A+ section 2.3.3.3.3

									// https://promisesaplus.com/#point-59

									// Ignore double-resolution attempts

									if ( depth < maxDepth ) {

										return;

									}



									returned = handler.apply( that, args );



									// Support: Promises/A+ section 2.3.1

									// https://promisesaplus.com/#point-48

									if ( returned === deferred.promise() ) {

										throw new TypeError( "Thenable self-resolution" );

									}



									// Support: Promises/A+ sections 2.3.3.1, 3.5

									// https://promisesaplus.com/#point-54

									// https://promisesaplus.com/#point-75

									// Retrieve `then` only once

									then = returned &&



										// Support: Promises/A+ section 2.3.4

										// https://promisesaplus.com/#point-64

										// Only check objects and functions for thenability

										( typeof returned === "object" ||

											typeof returned === "function" ) &&

										returned.then;



									// Handle a returned thenable

									if ( isFunction( then ) ) {



										// Special processors (notify) just wait for resolution

										if ( special ) {

											then.call(

												returned,

												resolve( maxDepth, deferred, Identity, special ),

												resolve( maxDepth, deferred, Thrower, special )

											);



										// Normal processors (resolve) also hook into progress

										} else {



											// ...and disregard older resolution values

											maxDepth++;



											then.call(

												returned,

												resolve( maxDepth, deferred, Identity, special ),

												resolve( maxDepth, deferred, Thrower, special ),

												resolve( maxDepth, deferred, Identity,

													deferred.notifyWith )

											);

										}



									// Handle all other returned values

									} else {



										// Only substitute handlers pass on context

										// and multiple values (non-spec behavior)

										if ( handler !== Identity ) {

											that = undefined;

											args = [ returned ];

										}



										// Process the value(s)

										// Default process is resolve

										( special || deferred.resolveWith )( that, args );

									}

								},



								// Only normal processors (resolve) catch and reject exceptions

								process = special ?

									mightThrow :

									function() {

										try {

											mightThrow();

										} catch ( e ) {



											if ( jQuery.Deferred.exceptionHook ) {

												jQuery.Deferred.exceptionHook( e,

													process.stackTrace );

											}



											// Support: Promises/A+ section 2.3.3.3.4.1

											// https://promisesaplus.com/#point-61

											// Ignore post-resolution exceptions

											if ( depth + 1 >= maxDepth ) {



												// Only substitute handlers pass on context

												// and multiple values (non-spec behavior)

												if ( handler !== Thrower ) {

													that = undefined;

													args = [ e ];

												}



												deferred.rejectWith( that, args );

											}

										}

									};



							// Support: Promises/A+ section 2.3.3.3.1

							// https://promisesaplus.com/#point-57

							// Re-resolve promises immediately to dodge false rejection from

							// subsequent errors

							if ( depth ) {

								process();

							} else {



								// Call an optional hook to record the stack, in case of exception

								// since it's otherwise lost when execution goes async

								if ( jQuery.Deferred.getStackHook ) {

									process.stackTrace = jQuery.Deferred.getStackHook();

								}

								window.setTimeout( process );

							}

						};

					}



					return jQuery.Deferred( function( newDefer ) {



						// progress_handlers.add( ... )

						tuples[ 0 ][ 3 ].add(

							resolve(

								0,

								newDefer,

								isFunction( onProgress ) ?

									onProgress :

									Identity,

								newDefer.notifyWith

							)

						);



						// fulfilled_handlers.add( ... )

						tuples[ 1 ][ 3 ].add(

							resolve(

								0,

								newDefer,

								isFunction( onFulfilled ) ?

									onFulfilled :

									Identity

							)

						);



						// rejected_handlers.add( ... )

						tuples[ 2 ][ 3 ].add(

							resolve(

								0,

								newDefer,

								isFunction( onRejected ) ?

									onRejected :

									Thrower

							)

						);

					} ).promise();

				},



				// Get a promise for this deferred

				// If obj is provided, the promise aspect is added to the object

				promise: function( obj ) {

					return obj != null ? jQuery.extend( obj, promise ) : promise;

				}

			},

			deferred = {};



		// Add list-specific methods

		jQuery.each( tuples, function( i, tuple ) {

			var list = tuple[ 2 ],

				stateString = tuple[ 5 ];



			// promise.progress = list.add

			// promise.done = list.add

			// promise.fail = list.add

			promise[ tuple[ 1 ] ] = list.add;



			// Handle state

			if ( stateString ) {

				list.add(

					function() {



						// state = "resolved" (i.e., fulfilled)

						// state = "rejected"

						state = stateString;

					},



					// rejected_callbacks.disable

					// fulfilled_callbacks.disable

					tuples[ 3 - i ][ 2 ].disable,



					// rejected_handlers.disable

					// fulfilled_handlers.disable

					tuples[ 3 - i ][ 3 ].disable,



					// progress_callbacks.lock

					tuples[ 0 ][ 2 ].lock,



					// progress_handlers.lock

					tuples[ 0 ][ 3 ].lock

				);

			}



			// progress_handlers.fire

			// fulfilled_handlers.fire

			// rejected_handlers.fire

			list.add( tuple[ 3 ].fire );



			// deferred.notify = function() { deferred.notifyWith(...) }

			// deferred.resolve = function() { deferred.resolveWith(...) }

			// deferred.reject = function() { deferred.rejectWith(...) }

			deferred[ tuple[ 0 ] ] = function() {

				deferred[ tuple[ 0 ] + "With" ]( this === deferred ? undefined : this, arguments );

				return this;

			};



			// deferred.notifyWith = list.fireWith

			// deferred.resolveWith = list.fireWith

			// deferred.rejectWith = list.fireWith

			deferred[ tuple[ 0 ] + "With" ] = list.fireWith;

		} );



		// Make the deferred a promise

		promise.promise( deferred );



		// Call given func if any

		if ( func ) {

			func.call( deferred, deferred );

		}



		// All done!

		return deferred;

	},



	// Deferred helper

	when: function( singleValue ) {

		var



			// count of uncompleted subordinates

			remaining = arguments.length,



			// count of unprocessed arguments

			i = remaining,



			// subordinate fulfillment data

			resolveContexts = Array( i ),

			resolveValues = slice.call( arguments ),



			// the master Deferred

			master = jQuery.Deferred(),



			// subordinate callback factory

			updateFunc = function( i ) {

				return function( value ) {

					resolveContexts[ i ] = this;

					resolveValues[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;

					if ( !( --remaining ) ) {

						master.resolveWith( resolveContexts, resolveValues );

					}

				};

			};



		// Single- and empty arguments are adopted like Promise.resolve

		if ( remaining <= 1 ) {

			adoptValue( singleValue, master.done( updateFunc( i ) ).resolve, master.reject,

				!remaining );



			// Use .then() to unwrap secondary thenables (cf. gh-3000)

			if ( master.state() === "pending" ||

				isFunction( resolveValues[ i ] && resolveValues[ i ].then ) ) {



				return master.then();

			}

		}



		// Multiple arguments are aggregated like Promise.all array elements

		while ( i-- ) {

			adoptValue( resolveValues[ i ], updateFunc( i ), master.reject );

		}



		return master.promise();

	}

} );





// These usually indicate a programmer mistake during development,

// warn about them ASAP rather than swallowing them by default.

var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;



jQuery.Deferred.exceptionHook = function( error, stack ) {



	// Support: IE 8 - 9 only

	// Console exists when dev tools are open, which can happen at any time

	if ( window.console && window.console.warn && error && rerrorNames.test( error.name ) ) {

		window.console.warn( "jQuery.Deferred exception: " + error.message, error.stack, stack );

	}

};









jQuery.readyException = function( error ) {

	window.setTimeout( function() {

		throw error;

	} );

};









// The deferred used on DOM ready

var readyList = jQuery.Deferred();



jQuery.fn.ready = function( fn ) {



	readyList

		.then( fn )



		// Wrap jQuery.readyException in a function so that the lookup

		// happens at the time of error handling instead of callback

		// registration.

		.catch( function( error ) {

			jQuery.readyException( error );

		} );



	return this;

};



jQuery.extend( {



	// Is the DOM ready to be used? Set to true once it occurs.

	isReady: false,



	// A counter to track how many items to wait for before

	// the ready event fires. See #6781

	readyWait: 1,



	// Handle when the DOM is ready

	ready: function( wait ) {



		// Abort if there are pending holds or we're already ready

		if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {

			return;

		}



		// Remember that the DOM is ready

		jQuery.isReady = true;



		// If a normal DOM Ready event fired, decrement, and wait if need be

		if ( wait !== true && --jQuery.readyWait > 0 ) {

			return;

		}



		// If there are functions bound, to execute

		readyList.resolveWith( document, [ jQuery ] );

	}

} );



jQuery.ready.then = readyList.then;



// The ready event handler and self cleanup method

function completed() {

	document.removeEventListener( "DOMContentLoaded", completed );

	window.removeEventListener( "load", completed );

	jQuery.ready();

}



// Catch cases where $(document).ready() is called

// after the browser event has already occurred.

// Support: IE <=9 - 10 only

// Older IE sometimes signals "interactive" too soon

if ( document.readyState === "complete" ||

	( document.readyState !== "loading" && !document.documentElement.doScroll ) ) {



	// Handle it asynchronously to allow scripts the opportunity to delay ready

	window.setTimeout( jQuery.ready );



} else {



	// Use the handy event callback

	document.addEventListener( "DOMContentLoaded", completed );



	// A fallback to window.onload, that will always work

	window.addEventListener( "load", completed );

}









// Multifunctional method to get and set values of a collection

// The value/s can optionally be executed if it's a function

var access = function( elems, fn, key, value, chainable, emptyGet, raw ) {

	var i = 0,

		len = elems.length,

		bulk = key == null;



	// Sets many values

	if ( toType( key ) === "object" ) {

		chainable = true;

		for ( i in key ) {

			access( elems, fn, i, key[ i ], true, emptyGet, raw );

		}



	// Sets one value

	} else if ( value !== undefined ) {

		chainable = true;



		if ( !isFunction( value ) ) {

			raw = true;

		}



		if ( bulk ) {



			// Bulk operations run against the entire set

			if ( raw ) {

				fn.call( elems, value );

				fn = null;



			// ...except when executing function values

			} else {

				bulk = fn;

				fn = function( elem, _key, value ) {

					return bulk.call( jQuery( elem ), value );

				};

			}

		}



		if ( fn ) {

			for ( ; i < len; i++ ) {

				fn(

					elems[ i ], key, raw ?

					value :

					value.call( elems[ i ], i, fn( elems[ i ], key ) )

				);

			}

		}

	}



	if ( chainable ) {

		return elems;

	}



	// Gets

	if ( bulk ) {

		return fn.call( elems );

	}



	return len ? fn( elems[ 0 ], key ) : emptyGet;

};





// Matches dashed string for camelizing

var rmsPrefix = /^-ms-/,

	rdashAlpha = /-([a-z])/g;



// Used by camelCase as callback to replace()

function fcamelCase( _all, letter ) {

	return letter.toUpperCase();

}



// Convert dashed to camelCase; used by the css and data modules

// Support: IE <=9 - 11, Edge 12 - 15

// Microsoft forgot to hump their vendor prefix (#9572)

function camelCase( string ) {

	return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );

}

var acceptData = function( owner ) {



	// Accepts only:

	//  - Node

	//    - Node.ELEMENT_NODE

	//    - Node.DOCUMENT_NODE

	//  - Object

	//    - Any

	return owner.nodeType === 1 || owner.nodeType === 9 || !( +owner.nodeType );

};









function Data() {

	this.expando = jQuery.expando + Data.uid++;

}



Data.uid = 1;



Data.prototype = {



	cache: function( owner ) {



		// Check if the owner object already has a cache

		var value = owner[ this.expando ];



		// If not, create one

		if ( !value ) {

			value = {};



			// We can accept data for non-element nodes in modern browsers,

			// but we should not, see #8335.

			// Always return an empty object.

			if ( acceptData( owner ) ) {



				// If it is a node unlikely to be stringify-ed or looped over

				// use plain assignment

				if ( owner.nodeType ) {

					owner[ this.expando ] = value;



				// Otherwise secure it in a non-enumerable property

				// configurable must be true to allow the property to be

				// deleted when data is removed

				} else {

					Object.defineProperty( owner, this.expando, {

						value: value,

						configurable: true

					} );

				}

			}

		}



		return value;

	},

	set: function( owner, data, value ) {

		var prop,

			cache = this.cache( owner );



		// Handle: [ owner, key, value ] args

		// Always use camelCase key (gh-2257)

		if ( typeof data === "string" ) {

			cache[ camelCase( data ) ] = value;



		// Handle: [ owner, { properties } ] args

		} else {



			// Copy the properties one-by-one to the cache object

			for ( prop in data ) {

				cache[ camelCase( prop ) ] = data[ prop ];

			}

		}

		return cache;

	},

	get: function( owner, key ) {

		return key === undefined ?

			this.cache( owner ) :



			// Always use camelCase key (gh-2257)

			owner[ this.expando ] && owner[ this.expando ][ camelCase( key ) ];

	},

	access: function( owner, key, value ) {



		// In cases where either:

		//

		//   1. No key was specified

		//   2. A string key was specified, but no value provided

		//

		// Take the "read" path and allow the get method to determine

		// which value to return, respectively either:

		//

		//   1. The entire cache object

		//   2. The data stored at the key

		//

		if ( key === undefined ||

				( ( key && typeof key === "string" ) && value === undefined ) ) {



			return this.get( owner, key );

		}



		// When the key is not a string, or both a key and value

		// are specified, set or extend (existing objects) with either:

		//

		//   1. An object of properties

		//   2. A key and value

		//

		this.set( owner, key, value );



		// Since the "set" path can have two possible entry points

		// return the expected data based on which path was taken[*]

		return value !== undefined ? value : key;

	},

	remove: function( owner, key ) {

		var i,

			cache = owner[ this.expando ];



		if ( cache === undefined ) {

			return;

		}



		if ( key !== undefined ) {



			// Support array or space separated string of keys

			if ( Array.isArray( key ) ) {



				// If key is an array of keys...

				// We always set camelCase keys, so remove that.

				key = key.map( camelCase );

			} else {

				key = camelCase( key );



				// If a key with the spaces exists, use it.

				// Otherwise, create an array by matching non-whitespace

				key = key in cache ?

					[ key ] :

					( key.match( rnothtmlwhite ) || [] );

			}



			i = key.length;



			while ( i-- ) {

				delete cache[ key[ i ] ];

			}

		}



		// Remove the expando if there's no more data

		if ( key === undefined || jQuery.isEmptyObject( cache ) ) {



			// Support: Chrome <=35 - 45

			// Webkit & Blink performance suffers when deleting properties

			// from DOM nodes, so set to undefined instead

			// https://bugs.chromium.org/p/chromium/issues/detail?id=378607 (bug restricted)

			if ( owner.nodeType ) {

				owner[ this.expando ] = undefined;

			} else {

				delete owner[ this.expando ];

			}

		}

	},

	hasData: function( owner ) {

		var cache = owner[ this.expando ];

		return cache !== undefined && !jQuery.isEmptyObject( cache );

	}

};

var dataPriv = new Data();



var dataUser = new Data();







//	Implementation Summary

//

//	1. Enforce API surface and semantic compatibility with 1.9.x branch

//	2. Improve the module's maintainability by reducing the storage

//		paths to a single mechanism.

//	3. Use the same single mechanism to support "private" and "user" data.

//	4. _Never_ expose "private" data to user code (TODO: Drop _data, _removeData)

//	5. Avoid exposing implementation details on user objects (eg. expando properties)

//	6. Provide a clear path for implementation upgrade to WeakMap in 2014



var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,

	rmultiDash = /[A-Z]/g;



function getData( data ) {

	if ( data === "true" ) {

		return true;

	}



	if ( data === "false" ) {

		return false;

	}



	if ( data === "null" ) {

		return null;

	}



	// Only convert to a number if it doesn't change the string

	if ( data === +data + "" ) {

		return +data;

	}



	if ( rbrace.test( data ) ) {

		return JSON.parse( data );

	}



	return data;

}



function dataAttr( elem, key, data ) {

	var name;



	// If nothing was found internally, try to fetch any

	// data from the HTML5 data-* attribute

	if ( data === undefined && elem.nodeType === 1 ) {

		name = "data-" + key.replace( rmultiDash, "-$&" ).toLowerCase();

		data = elem.getAttribute( name );



		if ( typeof data === "string" ) {

			try {

				data = getData( data );

			} catch ( e ) {}



			// Make sure we set the data so it isn't changed later

			dataUser.set( elem, key, data );

		} else {

			data = undefined;

		}

	}

	return data;

}



jQuery.extend( {

	hasData: function( elem ) {

		return dataUser.hasData( elem ) || dataPriv.hasData( elem );

	},



	data: function( elem, name, data ) {

		return dataUser.access( elem, name, data );

	},



	removeData: function( elem, name ) {

		dataUser.remove( elem, name );

	},



	// TODO: Now that all calls to _data and _removeData have been replaced

	// with direct calls to dataPriv methods, these can be deprecated.

	_data: function( elem, name, data ) {

		return dataPriv.access( elem, name, data );

	},



	_removeData: function( elem, name ) {

		dataPriv.remove( elem, name );

	}

} );



jQuery.fn.extend( {

	data: function( key, value ) {

		var i, name, data,

			elem = this[ 0 ],

			attrs = elem && elem.attributes;



		// Gets all values

		if ( key === undefined ) {

			if ( this.length ) {

				data = dataUser.get( elem );



				if ( elem.nodeType === 1 && !dataPriv.get( elem, "hasDataAttrs" ) ) {

					i = attrs.length;

					while ( i-- ) {



						// Support: IE 11 only

						// The attrs elements can be null (#14894)

						if ( attrs[ i ] ) {

							name = attrs[ i ].name;

							if ( name.indexOf( "data-" ) === 0 ) {

								name = camelCase( name.slice( 5 ) );

								dataAttr( elem, name, data[ name ] );

							}

						}

					}

					dataPriv.set( elem, "hasDataAttrs", true );

				}

			}



			return data;

		}



		// Sets multiple values

		if ( typeof key === "object" ) {

			return this.each( function() {

				dataUser.set( this, key );

			} );

		}



		return access( this, function( value ) {

			var data;



			// The calling jQuery object (element matches) is not empty

			// (and therefore has an element appears at this[ 0 ]) and the

			// `value` parameter was not undefined. An empty jQuery object

			// will result in `undefined` for elem = this[ 0 ] which will

			// throw an exception if an attempt to read a data cache is made.

			if ( elem && value === undefined ) {



				// Attempt to get data from the cache

				// The key will always be camelCased in Data

				data = dataUser.get( elem, key );

				if ( data !== undefined ) {

					return data;

				}



				// Attempt to "discover" the data in

				// HTML5 custom data-* attrs

				data = dataAttr( elem, key );

				if ( data !== undefined ) {

					return data;

				}



				// We tried really hard, but the data doesn't exist.

				return;

			}



			// Set the data...

			this.each( function() {



				// We always store the camelCased key

				dataUser.set( this, key, value );

			} );

		}, null, value, arguments.length > 1, null, true );

	},



	removeData: function( key ) {

		return this.each( function() {

			dataUser.remove( this, key );

		} );

	}

} );





jQuery.extend( {

	queue: function( elem, type, data ) {

		var queue;



		if ( elem ) {

			type = ( type || "fx" ) + "queue";

			queue = dataPriv.get( elem, type );



			// Speed up dequeue by getting out quickly if this is just a lookup

			if ( data ) {

				if ( !queue || Array.isArray( data ) ) {

					queue = dataPriv.access( elem, type, jQuery.makeArray( data ) );

				} else {

					queue.push( data );

				}

			}

			return queue || [];

		}

	},



	dequeue: function( elem, type ) {

		type = type || "fx";



		var queue = jQuery.queue( elem, type ),

			startLength = queue.length,

			fn = queue.shift(),

			hooks = jQuery._queueHooks( elem, type ),

			next = function() {

				jQuery.dequeue( elem, type );

			};



		// If the fx queue is dequeued, always remove the progress sentinel

		if ( fn === "inprogress" ) {

			fn = queue.shift();

			startLength--;

		}



		if ( fn ) {



			// Add a progress sentinel to prevent the fx queue from being

			// automatically dequeued

			if ( type === "fx" ) {

				queue.unshift( "inprogress" );

			}



			// Clear up the last queue stop function

			delete hooks.stop;

			fn.call( elem, next, hooks );

		}



		if ( !startLength && hooks ) {

			hooks.empty.fire();

		}

	},



	// Not public - generate a queueHooks object, or return the current one

	_queueHooks: function( elem, type ) {

		var key = type + "queueHooks";

		return dataPriv.get( elem, key ) || dataPriv.access( elem, key, {

			empty: jQuery.Callbacks( "once memory" ).add( function() {

				dataPriv.remove( elem, [ type + "queue", key ] );

			} )

		} );

	}

} );



jQuery.fn.extend( {

	queue: function( type, data ) {

		var setter = 2;



		if ( typeof type !== "string" ) {

			data = type;

			type = "fx";

			setter--;

		}



		if ( arguments.length < setter ) {

			return jQuery.queue( this[ 0 ], type );

		}



		return data === undefined ?

			this :

			this.each( function() {

				var queue = jQuery.queue( this, type, data );



				// Ensure a hooks for this queue

				jQuery._queueHooks( this, type );



				if ( type === "fx" && queue[ 0 ] !== "inprogress" ) {

					jQuery.dequeue( this, type );

				}

			} );

	},

	dequeue: function( type ) {

		return this.each( function() {

			jQuery.dequeue( this, type );

		} );

	},

	clearQueue: function( type ) {

		return this.queue( type || "fx", [] );

	},



	// Get a promise resolved when queues of a certain type

	// are emptied (fx is the type by default)

	promise: function( type, obj ) {

		var tmp,

			count = 1,

			defer = jQuery.Deferred(),

			elements = this,

			i = this.length,

			resolve = function() {

				if ( !( --count ) ) {

					defer.resolveWith( elements, [ elements ] );

				}

			};



		if ( typeof type !== "string" ) {

			obj = type;

			type = undefined;

		}

		type = type || "fx";



		while ( i-- ) {

			tmp = dataPriv.get( elements[ i ], type + "queueHooks" );

			if ( tmp && tmp.empty ) {

				count++;

				tmp.empty.add( resolve );

			}

		}

		resolve();

		return defer.promise( obj );

	}

} );

var pnum = ( /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/ ).source;



var rcssNum = new RegExp( "^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i" );





var cssExpand = [ "Top", "Right", "Bottom", "Left" ];



var documentElement = document.documentElement;







	var isAttached = function( elem ) {

			return jQuery.contains( elem.ownerDocument, elem );

		},

		composed = { composed: true };



	// Support: IE 9 - 11+, Edge 12 - 18+, iOS 10.0 - 10.2 only

	// Check attachment across shadow DOM boundaries when possible (gh-3504)

	// Support: iOS 10.0-10.2 only

	// Early iOS 10 versions support `attachShadow` but not `getRootNode`,

	// leading to errors. We need to check for `getRootNode`.

	if ( documentElement.getRootNode ) {

		isAttached = function( elem ) {

			return jQuery.contains( elem.ownerDocument, elem ) ||

				elem.getRootNode( composed ) === elem.ownerDocument;

		};

	}

var isHiddenWithinTree = function( elem, el ) {



		// isHiddenWithinTree might be called from jQuery#filter function;

		// in that case, element will be second argument

		elem = el || elem;



		// Inline style trumps all

		return elem.style.display === "none" ||

			elem.style.display === "" &&



			// Otherwise, check computed style

			// Support: Firefox <=43 - 45

			// Disconnected elements can have computed display: none, so first confirm that elem is

			// in the document.

			isAttached( elem ) &&



			jQuery.css( elem, "display" ) === "none";

	};







function adjustCSS( elem, prop, valueParts, tween ) {

	var adjusted, scale,

		maxIterations = 20,

		currentValue = tween ?

			function() {

				return tween.cur();

			} :

			function() {

				return jQuery.css( elem, prop, "" );

			},

		initial = currentValue(),

		unit = valueParts && valueParts[ 3 ] || ( jQuery.cssNumber[ prop ] ? "" : "px" ),



		// Starting value computation is required for potential unit mismatches

		initialInUnit = elem.nodeType &&

			( jQuery.cssNumber[ prop ] || unit !== "px" && +initial ) &&

			rcssNum.exec( jQuery.css( elem, prop ) );



	if ( initialInUnit && initialInUnit[ 3 ] !== unit ) {



		// Support: Firefox <=54

		// Halve the iteration target value to prevent interference from CSS upper bounds (gh-2144)

		initial = initial / 2;



		// Trust units reported by jQuery.css

		unit = unit || initialInUnit[ 3 ];



		// Iteratively approximate from a nonzero starting point

		initialInUnit = +initial || 1;



		while ( maxIterations-- ) {



			// Evaluate and update our best guess (doubling guesses that zero out).

			// Finish if the scale equals or crosses 1 (making the old*new product non-positive).

			jQuery.style( elem, prop, initialInUnit + unit );

			if ( ( 1 - scale ) * ( 1 - ( scale = currentValue() / initial || 0.5 ) ) <= 0 ) {

				maxIterations = 0;

			}

			initialInUnit = initialInUnit / scale;



		}



		initialInUnit = initialInUnit * 2;

		jQuery.style( elem, prop, initialInUnit + unit );



		// Make sure we update the tween properties later on

		valueParts = valueParts || [];

	}



	if ( valueParts ) {

		initialInUnit = +initialInUnit || +initial || 0;



		// Apply relative offset (+=/-=) if specified

		adjusted = valueParts[ 1 ] ?

			initialInUnit + ( valueParts[ 1 ] + 1 ) * valueParts[ 2 ] :

			+valueParts[ 2 ];

		if ( tween ) {

			tween.unit = unit;

			tween.start = initialInUnit;

			tween.end = adjusted;

		}

	}

	return adjusted;

}





var defaultDisplayMap = {};



function getDefaultDisplay( elem ) {

	var temp,

		doc = elem.ownerDocument,

		nodeName = elem.nodeName,

		display = defaultDisplayMap[ nodeName ];



	if ( display ) {

		return display;

	}



	temp = doc.body.appendChild( doc.createElement( nodeName ) );

	display = jQuery.css( temp, "display" );



	temp.parentNode.removeChild( temp );



	if ( display === "none" ) {

		display = "block";

	}

	defaultDisplayMap[ nodeName ] = display;



	return display;

}



function showHide( elements, show ) {

	var display, elem,

		values = [],

		index = 0,

		length = elements.length;



	// Determine new display value for elements that need to change

	for ( ; index < length; index++ ) {

		elem = elements[ index ];

		if ( !elem.style ) {

			continue;

		}



		display = elem.style.display;

		if ( show ) {



			// Since we force visibility upon cascade-hidden elements, an immediate (and slow)

			// check is required in this first loop unless we have a nonempty display value (either

			// inline or about-to-be-restored)

			if ( display === "none" ) {

				values[ index ] = dataPriv.get( elem, "display" ) || null;

				if ( !values[ index ] ) {

					elem.style.display = "";

				}

			}

			if ( elem.style.display === "" && isHiddenWithinTree( elem ) ) {

				values[ index ] = getDefaultDisplay( elem );

			}

		} else {

			if ( display !== "none" ) {

				values[ index ] = "none";



				// Remember what we're overwriting

				dataPriv.set( elem, "display", display );

			}

		}

	}



	// Set the display of the elements in a second loop to avoid constant reflow

	for ( index = 0; index < length; index++ ) {

		if ( values[ index ] != null ) {

			elements[ index ].style.display = values[ index ];

		}

	}



	return elements;

}



jQuery.fn.extend( {

	show: function() {

		return showHide( this, true );

	},

	hide: function() {

		return showHide( this );

	},

	toggle: function( state ) {

		if ( typeof state === "boolean" ) {

			return state ? this.show() : this.hide();

		}



		return this.each( function() {

			if ( isHiddenWithinTree( this ) ) {

				jQuery( this ).show();

			} else {

				jQuery( this ).hide();

			}

		} );

	}

} );

var rcheckableType = ( /^(?:checkbox|radio)$/i );



var rtagName = ( /<([a-z][^\/\0>\x20\t\r\n\f]*)/i );



var rscriptType = ( /^$|^module$|\/(?:java|ecma)script/i );







( function() {

	var fragment = document.createDocumentFragment(),

		div = fragment.appendChild( document.createElement( "div" ) ),

		input = document.createElement( "input" );



	// Support: Android 4.0 - 4.3 only

	// Check state lost if the name is set (#11217)

	// Support: Windows Web Apps (WWA)

	// `name` and `type` must use .setAttribute for WWA (#14901)

	input.setAttribute( "type", "radio" );

	input.setAttribute( "checked", "checked" );

	input.setAttribute( "name", "t" );



	div.appendChild( input );



	// Support: Android <=4.1 only

	// Older WebKit doesn't clone checked state correctly in fragments

	support.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;



	// Support: IE <=11 only

	// Make sure textarea (and checkbox) defaultValue is properly cloned

	div.innerHTML = "<textarea>x</textarea>";

	support.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;



	// Support: IE <=9 only

	// IE <=9 replaces <option> tags with their contents when inserted outside of

	// the select element.

	div.innerHTML = "<option></option>";

	support.option = !!div.lastChild;

} )();





// We have to close these tags to support XHTML (#13200)

var wrapMap = {



	// XHTML parsers do not magically insert elements in the

	// same way that tag soup parsers do. So we cannot shorten

	// this by omitting <tbody> or other required elements.

	thead: [ 1, "<table>", "</table>" ],

	col: [ 2, "<table><colgroup>", "</colgroup></table>" ],

	tr: [ 2, "<table><tbody>", "</tbody></table>" ],

	td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],



	_default: [ 0, "", "" ]

};



wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;

wrapMap.th = wrapMap.td;



// Support: IE <=9 only

if ( !support.option ) {

	wrapMap.optgroup = wrapMap.option = [ 1, "<select multiple='multiple'>", "</select>" ];

}





function getAll( context, tag ) {



	// Support: IE <=9 - 11 only

	// Use typeof to avoid zero-argument method invocation on host objects (#15151)

	var ret;



	if ( typeof context.getElementsByTagName !== "undefined" ) {

		ret = context.getElementsByTagName( tag || "*" );



	} else if ( typeof context.querySelectorAll !== "undefined" ) {

		ret = context.querySelectorAll( tag || "*" );



	} else {

		ret = [];

	}



	if ( tag === undefined || tag && nodeName( context, tag ) ) {

		return jQuery.merge( [ context ], ret );

	}



	return ret;

}





// Mark scripts as having already been evaluated

function setGlobalEval( elems, refElements ) {

	var i = 0,

		l = elems.length;



	for ( ; i < l; i++ ) {

		dataPriv.set(

			elems[ i ],

			"globalEval",

			!refElements || dataPriv.get( refElements[ i ], "globalEval" )

		);

	}

}





var rhtml = /<|&#?\w+;/;



function buildFragment( elems, context, scripts, selection, ignored ) {

	var elem, tmp, tag, wrap, attached, j,

		fragment = context.createDocumentFragment(),

		nodes = [],

		i = 0,

		l = elems.length;



	for ( ; i < l; i++ ) {

		elem = elems[ i ];



		if ( elem || elem === 0 ) {



			// Add nodes directly

			if ( toType( elem ) === "object" ) {



				// Support: Android <=4.0 only, PhantomJS 1 only

				// push.apply(_, arraylike) throws on ancient WebKit

				jQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );



			// Convert non-html into a text node

			} else if ( !rhtml.test( elem ) ) {

				nodes.push( context.createTextNode( elem ) );



			// Convert html into DOM nodes

			} else {

				tmp = tmp || fragment.appendChild( context.createElement( "div" ) );



				// Deserialize a standard representation

				tag = ( rtagName.exec( elem ) || [ "", "" ] )[ 1 ].toLowerCase();

				wrap = wrapMap[ tag ] || wrapMap._default;

				tmp.innerHTML = wrap[ 1 ] + jQuery.htmlPrefilter( elem ) + wrap[ 2 ];



				// Descend through wrappers to the right content

				j = wrap[ 0 ];

				while ( j-- ) {

					tmp = tmp.lastChild;

				}



				// Support: Android <=4.0 only, PhantomJS 1 only

				// push.apply(_, arraylike) throws on ancient WebKit

				jQuery.merge( nodes, tmp.childNodes );



				// Remember the top-level container

				tmp = fragment.firstChild;



				// Ensure the created nodes are orphaned (#12392)

				tmp.textContent = "";

			}

		}

	}



	// Remove wrapper from fragment

	fragment.textContent = "";



	i = 0;

	while ( ( elem = nodes[ i++ ] ) ) {



		// Skip elements already in the context collection (trac-4087)

		if ( selection && jQuery.inArray( elem, selection ) > -1 ) {

			if ( ignored ) {

				ignored.push( elem );

			}

			continue;

		}



		attached = isAttached( elem );



		// Append to fragment

		tmp = getAll( fragment.appendChild( elem ), "script" );



		// Preserve script evaluation history

		if ( attached ) {

			setGlobalEval( tmp );

		}



		// Capture executables

		if ( scripts ) {

			j = 0;

			while ( ( elem = tmp[ j++ ] ) ) {

				if ( rscriptType.test( elem.type || "" ) ) {

					scripts.push( elem );

				}

			}

		}

	}



	return fragment;

}





var

	rkeyEvent = /^key/,

	rmouseEvent = /^(?:mouse|pointer|contextmenu|drag|drop)|click/,

	rtypenamespace = /^([^.]*)(?:\.(.+)|)/;



function returnTrue() {

	return true;

}



function returnFalse() {

	return false;

}



// Support: IE <=9 - 11+

// focus() and blur() are asynchronous, except when they are no-op.

// So expect focus to be synchronous when the element is already active,

// and blur to be synchronous when the element is not already active.

// (focus and blur are always synchronous in other supported browsers,

// this just defines when we can count on it).

function expectSync( elem, type ) {

	return ( elem === safeActiveElement() ) === ( type === "focus" );

}



// Support: IE <=9 only

// Accessing document.activeElement can throw unexpectedly

// https://bugs.jquery.com/ticket/13393

function safeActiveElement() {

	try {

		return document.activeElement;

	} catch ( err ) { }

}



function on( elem, types, selector, data, fn, one ) {

	var origFn, type;



	// Types can be a map of types/handlers

	if ( typeof types === "object" ) {



		// ( types-Object, selector, data )

		if ( typeof selector !== "string" ) {



			// ( types-Object, data )

			data = data || selector;

			selector = undefined;

		}

		for ( type in types ) {

			on( elem, type, selector, data, types[ type ], one );

		}

		return elem;

	}



	if ( data == null && fn == null ) {



		// ( types, fn )

		fn = selector;

		data = selector = undefined;

	} else if ( fn == null ) {

		if ( typeof selector === "string" ) {



			// ( types, selector, fn )

			fn = data;

			data = undefined;

		} else {



			// ( types, data, fn )

			fn = data;

			data = selector;

			selector = undefined;

		}

	}

	if ( fn === false ) {

		fn = returnFalse;

	} else if ( !fn ) {

		return elem;

	}



	if ( one === 1 ) {

		origFn = fn;

		fn = function( event ) {



			// Can use an empty set, since event contains the info

			jQuery().off( event );

			return origFn.apply( this, arguments );

		};



		// Use same guid so caller can remove using origFn

		fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );

	}

	return elem.each( function() {

		jQuery.event.add( this, types, fn, data, selector );

	} );

}



/*

 * Helper functions for managing events -- not part of the public interface.

 * Props to Dean Edwards' addEvent library for many of the ideas.

 */

jQuery.event = {



	global: {},



	add: function( elem, types, handler, data, selector ) {



		var handleObjIn, eventHandle, tmp,

			events, t, handleObj,

			special, handlers, type, namespaces, origType,

			elemData = dataPriv.get( elem );



		// Only attach events to objects that accept data

		if ( !acceptData( elem ) ) {

			return;

		}



		// Caller can pass in an object of custom data in lieu of the handler

		if ( handler.handler ) {

			handleObjIn = handler;

			handler = handleObjIn.handler;

			selector = handleObjIn.selector;

		}



		// Ensure that invalid selectors throw exceptions at attach time

		// Evaluate against documentElement in case elem is a non-element node (e.g., document)

		if ( selector ) {

			jQuery.find.matchesSelector( documentElement, selector );

		}



		// Make sure that the handler has a unique ID, used to find/remove it later

		if ( !handler.guid ) {

			handler.guid = jQuery.guid++;

		}



		// Init the element's event structure and main handler, if this is the first

		if ( !( events = elemData.events ) ) {

			events = elemData.events = Object.create( null );

		}

		if ( !( eventHandle = elemData.handle ) ) {

			eventHandle = elemData.handle = function( e ) {



				// Discard the second event of a jQuery.event.trigger() and

				// when an event is called after a page has unloaded

				return typeof jQuery !== "undefined" && jQuery.event.triggered !== e.type ?

					jQuery.event.dispatch.apply( elem, arguments ) : undefined;

			};

		}



		// Handle multiple events separated by a space

		types = ( types || "" ).match( rnothtmlwhite ) || [ "" ];

		t = types.length;

		while ( t-- ) {

			tmp = rtypenamespace.exec( types[ t ] ) || [];

			type = origType = tmp[ 1 ];

			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();



			// There *must* be a type, no attaching namespace-only handlers

			if ( !type ) {

				continue;

			}



			// If event changes its type, use the special event handlers for the changed type

			special = jQuery.event.special[ type ] || {};



			// If selector defined, determine special event api type, otherwise given type

			type = ( selector ? special.delegateType : special.bindType ) || type;



			// Update special based on newly reset type

			special = jQuery.event.special[ type ] || {};



			// handleObj is passed to all event handlers

			handleObj = jQuery.extend( {

				type: type,

				origType: origType,

				data: data,

				handler: handler,

				guid: handler.guid,

				selector: selector,

				needsContext: selector && jQuery.expr.match.needsContext.test( selector ),

				namespace: namespaces.join( "." )

			}, handleObjIn );



			// Init the event handler queue if we're the first

			if ( !( handlers = events[ type ] ) ) {

				handlers = events[ type ] = [];

				handlers.delegateCount = 0;



				// Only use addEventListener if the special events handler returns false

				if ( !special.setup ||

					special.setup.call( elem, data, namespaces, eventHandle ) === false ) {



					if ( elem.addEventListener ) {

						elem.addEventListener( type, eventHandle );

					}

				}

			}



			if ( special.add ) {

				special.add.call( elem, handleObj );



				if ( !handleObj.handler.guid ) {

					handleObj.handler.guid = handler.guid;

				}

			}



			// Add to the element's handler list, delegates in front

			if ( selector ) {

				handlers.splice( handlers.delegateCount++, 0, handleObj );

			} else {

				handlers.push( handleObj );

			}



			// Keep track of which events have ever been used, for event optimization

			jQuery.event.global[ type ] = true;

		}



	},



	// Detach an event or set of events from an element

	remove: function( elem, types, handler, selector, mappedTypes ) {



		var j, origCount, tmp,

			events, t, handleObj,

			special, handlers, type, namespaces, origType,

			elemData = dataPriv.hasData( elem ) && dataPriv.get( elem );



		if ( !elemData || !( events = elemData.events ) ) {

			return;

		}



		// Once for each type.namespace in types; type may be omitted

		types = ( types || "" ).match( rnothtmlwhite ) || [ "" ];

		t = types.length;

		while ( t-- ) {

			tmp = rtypenamespace.exec( types[ t ] ) || [];

			type = origType = tmp[ 1 ];

			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();



			// Unbind all events (on this namespace, if provided) for the element

			if ( !type ) {

				for ( type in events ) {

					jQuery.event.remove( elem, type + types[ t ], handler, selector, true );

				}

				continue;

			}



			special = jQuery.event.special[ type ] || {};

			type = ( selector ? special.delegateType : special.bindType ) || type;

			handlers = events[ type ] || [];

			tmp = tmp[ 2 ] &&

				new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" );



			// Remove matching events

			origCount = j = handlers.length;

			while ( j-- ) {

				handleObj = handlers[ j ];



				if ( ( mappedTypes || origType === handleObj.origType ) &&

					( !handler || handler.guid === handleObj.guid ) &&

					( !tmp || tmp.test( handleObj.namespace ) ) &&

					( !selector || selector === handleObj.selector ||

						selector === "**" && handleObj.selector ) ) {

					handlers.splice( j, 1 );



					if ( handleObj.selector ) {

						handlers.delegateCount--;

					}

					if ( special.remove ) {

						special.remove.call( elem, handleObj );

					}

				}

			}



			// Remove generic event handler if we removed something and no more handlers exist

			// (avoids potential for endless recursion during removal of special event handlers)

			if ( origCount && !handlers.length ) {

				if ( !special.teardown ||

					special.teardown.call( elem, namespaces, elemData.handle ) === false ) {



					jQuery.removeEvent( elem, type, elemData.handle );

				}



				delete events[ type ];

			}

		}



		// Remove data and the expando if it's no longer used

		if ( jQuery.isEmptyObject( events ) ) {

			dataPriv.remove( elem, "handle events" );

		}

	},



	dispatch: function( nativeEvent ) {



		var i, j, ret, matched, handleObj, handlerQueue,

			args = new Array( arguments.length ),



			// Make a writable jQuery.Event from the native event object

			event = jQuery.event.fix( nativeEvent ),



			handlers = (

					dataPriv.get( this, "events" ) || Object.create( null )

				)[ event.type ] || [],

			special = jQuery.event.special[ event.type ] || {};



		// Use the fix-ed jQuery.Event rather than the (read-only) native event

		args[ 0 ] = event;



		for ( i = 1; i < arguments.length; i++ ) {

			args[ i ] = arguments[ i ];

		}



		event.delegateTarget = this;



		// Call the preDispatch hook for the mapped type, and let it bail if desired

		if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {

			return;

		}



		// Determine handlers

		handlerQueue = jQuery.event.handlers.call( this, event, handlers );



		// Run delegates first; they may want to stop propagation beneath us

		i = 0;

		while ( ( matched = handlerQueue[ i++ ] ) && !event.isPropagationStopped() ) {

			event.currentTarget = matched.elem;



			j = 0;

			while ( ( handleObj = matched.handlers[ j++ ] ) &&

				!event.isImmediatePropagationStopped() ) {



				// If the event is namespaced, then each handler is only invoked if it is

				// specially universal or its namespaces are a superset of the event's.

				if ( !event.rnamespace || handleObj.namespace === false ||

					event.rnamespace.test( handleObj.namespace ) ) {



					event.handleObj = handleObj;

					event.data = handleObj.data;



					ret = ( ( jQuery.event.special[ handleObj.origType ] || {} ).handle ||

						handleObj.handler ).apply( matched.elem, args );



					if ( ret !== undefined ) {

						if ( ( event.result = ret ) === false ) {

							event.preventDefault();

							event.stopPropagation();

						}

					}

				}

			}

		}



		// Call the postDispatch hook for the mapped type

		if ( special.postDispatch ) {

			special.postDispatch.call( this, event );

		}



		return event.result;

	},



	handlers: function( event, handlers ) {

		var i, handleObj, sel, matchedHandlers, matchedSelectors,

			handlerQueue = [],

			delegateCount = handlers.delegateCount,

			cur = event.target;



		// Find delegate handlers

		if ( delegateCount &&



			// Support: IE <=9

			// Black-hole SVG <use> instance trees (trac-13180)

			cur.nodeType &&



			// Support: Firefox <=42

			// Suppress spec-violating clicks indicating a non-primary pointer button (trac-3861)

			// https://www.w3.org/TR/DOM-Level-3-Events/#event-type-click

			// Support: IE 11 only

			// ...but not arrow key "clicks" of radio inputs, which can have `button` -1 (gh-2343)

			!( event.type === "click" && event.button >= 1 ) ) {



			for ( ; cur !== this; cur = cur.parentNode || this ) {



				// Don't check non-elements (#13208)

				// Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)

				if ( cur.nodeType === 1 && !( event.type === "click" && cur.disabled === true ) ) {

					matchedHandlers = [];

					matchedSelectors = {};

					for ( i = 0; i < delegateCount; i++ ) {

						handleObj = handlers[ i ];



						// Don't conflict with Object.prototype properties (#13203)

						sel = handleObj.selector + " ";



						if ( matchedSelectors[ sel ] === undefined ) {

							matchedSelectors[ sel ] = handleObj.needsContext ?

								jQuery( sel, this ).index( cur ) > -1 :

								jQuery.find( sel, this, null, [ cur ] ).length;

						}

						if ( matchedSelectors[ sel ] ) {

							matchedHandlers.push( handleObj );

						}

					}

					if ( matchedHandlers.length ) {

						handlerQueue.push( { elem: cur, handlers: matchedHandlers } );

					}

				}

			}

		}



		// Add the remaining (directly-bound) handlers

		cur = this;

		if ( delegateCount < handlers.length ) {

			handlerQueue.push( { elem: cur, handlers: handlers.slice( delegateCount ) } );

		}



		return handlerQueue;

	},



	addProp: function( name, hook ) {

		Object.defineProperty( jQuery.Event.prototype, name, {

			enumerable: true,

			configurable: true,



			get: isFunction( hook ) ?

				function() {

					if ( this.originalEvent ) {

							return hook( this.originalEvent );

					}

				} :

				function() {

					if ( this.originalEvent ) {

							return this.originalEvent[ name ];

					}

				},



			set: function( value ) {

				Object.defineProperty( this, name, {

					enumerable: true,

					configurable: true,

					writable: true,

					value: value

				} );

			}

		} );

	},



	fix: function( originalEvent ) {

		return originalEvent[ jQuery.expando ] ?

			originalEvent :

			new jQuery.Event( originalEvent );

	},



	special: {

		load: {



			// Prevent triggered image.load events from bubbling to window.load

			noBubble: true

		},

		click: {



			// Utilize native event to ensure correct state for checkable inputs

			setup: function( data ) {



				// For mutual compressibility with _default, replace `this` access with a local var.

				// `|| data` is dead code meant only to preserve the variable through minification.

				var el = this || data;



				// Claim the first handler

				if ( rcheckableType.test( el.type ) &&

					el.click && nodeName( el, "input" ) ) {



					// dataPriv.set( el, "click", ... )

					leverageNative( el, "click", returnTrue );

				}



				// Return false to allow normal processing in the caller

				return false;

			},

			trigger: function( data ) {



				// For mutual compressibility with _default, replace `this` access with a local var.

				// `|| data` is dead code meant only to preserve the variable through minification.

				var el = this || data;



				// Force setup before triggering a click

				if ( rcheckableType.test( el.type ) &&

					el.click && nodeName( el, "input" ) ) {



					leverageNative( el, "click" );

				}



				// Return non-false to allow normal event-path propagation

				return true;

			},



			// For cross-browser consistency, suppress native .click() on links

			// Also prevent it if we're currently inside a leveraged native-event stack

			_default: function( event ) {

				var target = event.target;

				return rcheckableType.test( target.type ) &&

					target.click && nodeName( target, "input" ) &&

					dataPriv.get( target, "click" ) ||

					nodeName( target, "a" );

			}

		},



		beforeunload: {

			postDispatch: function( event ) {



				// Support: Firefox 20+

				// Firefox doesn't alert if the returnValue field is not set.

				if ( event.result !== undefined && event.originalEvent ) {

					event.originalEvent.returnValue = event.result;

				}

			}

		}

	}

};



// Ensure the presence of an event listener that handles manually-triggered

// synthetic events by interrupting progress until reinvoked in response to

// *native* events that it fires directly, ensuring that state changes have

// already occurred before other listeners are invoked.

function leverageNative( el, type, expectSync ) {



	// Missing expectSync indicates a trigger call, which must force setup through jQuery.event.add

	if ( !expectSync ) {

		if ( dataPriv.get( el, type ) === undefined ) {

			jQuery.event.add( el, type, returnTrue );

		}

		return;

	}



	// Register the controller as a special universal handler for all event namespaces

	dataPriv.set( el, type, false );

	jQuery.event.add( el, type, {

		namespace: false,

		handler: function( event ) {

			var notAsync, result,

				saved = dataPriv.get( this, type );



			if ( ( event.isTrigger & 1 ) && this[ type ] ) {



				// Interrupt processing of the outer synthetic .trigger()ed event

				// Saved data should be false in such cases, but might be a leftover capture object

				// from an async native handler (gh-4350)

				if ( !saved.length ) {



					// Store arguments for use when handling the inner native event

					// There will always be at least one argument (an event object), so this array

					// will not be confused with a leftover capture object.

					saved = slice.call( arguments );

					dataPriv.set( this, type, saved );



					// Trigger the native event and capture its result

					// Support: IE <=9 - 11+

					// focus() and blur() are asynchronous

					notAsync = expectSync( this, type );

					this[ type ]();

					result = dataPriv.get( this, type );

					if ( saved !== result || notAsync ) {

						dataPriv.set( this, type, false );

					} else {

						result = {};

					}

					if ( saved !== result ) {



						// Cancel the outer synthetic event

						event.stopImmediatePropagation();

						event.preventDefault();

						return result.value;

					}



				// If this is an inner synthetic event for an event with a bubbling surrogate

				// (focus or blur), assume that the surrogate already propagated from triggering the

				// native event and prevent that from happening again here.

				// This technically gets the ordering wrong w.r.t. to `.trigger()` (in which the

				// bubbling surrogate propagates *after* the non-bubbling base), but that seems

				// less bad than duplication.

				} else if ( ( jQuery.event.special[ type ] || {} ).delegateType ) {

					event.stopPropagation();

				}



			// If this is a native event triggered above, everything is now in order

			// Fire an inner synthetic event with the original arguments

			} else if ( saved.length ) {



				// ...and capture the result

				dataPriv.set( this, type, {

					value: jQuery.event.trigger(



						// Support: IE <=9 - 11+

						// Extend with the prototype to reset the above stopImmediatePropagation()

						jQuery.extend( saved[ 0 ], jQuery.Event.prototype ),

						saved.slice( 1 ),

						this

					)

				} );



				// Abort handling of the native event

				event.stopImmediatePropagation();

			}

		}

	} );

}



jQuery.removeEvent = function( elem, type, handle ) {



	// This "if" is needed for plain objects

	if ( elem.removeEventListener ) {

		elem.removeEventListener( type, handle );

	}

};



jQuery.Event = function( src, props ) {



	// Allow instantiation without the 'new' keyword

	if ( !( this instanceof jQuery.Event ) ) {

		return new jQuery.Event( src, props );

	}



	// Event object

	if ( src && src.type ) {

		this.originalEvent = src;

		this.type = src.type;



		// Events bubbling up the document may have been marked as prevented

		// by a handler lower down the tree; reflect the correct value.

		this.isDefaultPrevented = src.defaultPrevented ||

				src.defaultPrevented === undefined &&



				// Support: Android <=2.3 only

				src.returnValue === false ?

			returnTrue :

			returnFalse;



		// Create target properties

		// Support: Safari <=6 - 7 only

		// Target should not be a text node (#504, #13143)

		this.target = ( src.target && src.target.nodeType === 3 ) ?

			src.target.parentNode :

			src.target;



		this.currentTarget = src.currentTarget;

		this.relatedTarget = src.relatedTarget;



	// Event type

	} else {

		this.type = src;

	}



	// Put explicitly provided properties onto the event object

	if ( props ) {

		jQuery.extend( this, props );

	}



	// Create a timestamp if incoming event doesn't have one

	this.timeStamp = src && src.timeStamp || Date.now();



	// Mark it as fixed

	this[ jQuery.expando ] = true;

};



// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding

// https://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html

jQuery.Event.prototype = {

	constructor: jQuery.Event,

	isDefaultPrevented: returnFalse,

	isPropagationStopped: returnFalse,

	isImmediatePropagationStopped: returnFalse,

	isSimulated: false,



	preventDefault: function() {

		var e = this.originalEvent;



		this.isDefaultPrevented = returnTrue;



		if ( e && !this.isSimulated ) {

			e.preventDefault();

		}

	},

	stopPropagation: function() {

		var e = this.originalEvent;



		this.isPropagationStopped = returnTrue;



		if ( e && !this.isSimulated ) {

			e.stopPropagation();

		}

	},

	stopImmediatePropagation: function() {

		var e = this.originalEvent;



		this.isImmediatePropagationStopped = returnTrue;



		if ( e && !this.isSimulated ) {

			e.stopImmediatePropagation();

		}



		this.stopPropagation();

	}

};



// Includes all common event props including KeyEvent and MouseEvent specific props

jQuery.each( {

	altKey: true,

	bubbles: true,

	cancelable: true,

	changedTouches: true,

	ctrlKey: true,

	detail: true,

	eventPhase: true,

	metaKey: true,

	pageX: true,

	pageY: true,

	shiftKey: true,

	view: true,

	"char": true,

	code: true,

	charCode: true,

	key: true,

	keyCode: true,

	button: true,

	buttons: true,

	clientX: true,

	clientY: true,

	offsetX: true,

	offsetY: true,

	pointerId: true,

	pointerType: true,

	screenX: true,

	screenY: true,

	targetTouches: true,

	toElement: true,

	touches: true,



	which: function( event ) {

		var button = event.button;



		// Add which for key events

		if ( event.which == null && rkeyEvent.test( event.type ) ) {

			return event.charCode != null ? event.charCode : event.keyCode;

		}



		// Add which for click: 1 === left; 2 === middle; 3 === right

		if ( !event.which && button !== undefined && rmouseEvent.test( event.type ) ) {

			if ( button & 1 ) {

				return 1;

			}



			if ( button & 2 ) {

				return 3;

			}



			if ( button & 4 ) {

				return 2;

			}



			return 0;

		}



		return event.which;

	}

}, jQuery.event.addProp );



jQuery.each( { focus: "focusin", blur: "focusout" }, function( type, delegateType ) {

	jQuery.event.special[ type ] = {



		// Utilize native event if possible so blur/focus sequence is correct

		setup: function() {



			// Claim the first handler

			// dataPriv.set( this, "focus", ... )

			// dataPriv.set( this, "blur", ... )

			leverageNative( this, type, expectSync );



			// Return false to allow normal processing in the caller

			return false;

		},

		trigger: function() {



			// Force setup before trigger

			leverageNative( this, type );



			// Return non-false to allow normal event-path propagation

			return true;

		},



		delegateType: delegateType

	};

} );



// Create mouseenter/leave events using mouseover/out and event-time checks

// so that event delegation works in jQuery.

// Do the same for pointerenter/pointerleave and pointerover/pointerout

//

// Support: Safari 7 only

// Safari sends mouseenter too often; see:

// https://bugs.chromium.org/p/chromium/issues/detail?id=470258

// for the description of the bug (it existed in older Chrome versions as well).

jQuery.each( {

	mouseenter: "mouseover",

	mouseleave: "mouseout",

	pointerenter: "pointerover",

	pointerleave: "pointerout"

}, function( orig, fix ) {

	jQuery.event.special[ orig ] = {

		delegateType: fix,

		bindType: fix,



		handle: function( event ) {

			var ret,

				target = this,

				related = event.relatedTarget,

				handleObj = event.handleObj;



			// For mouseenter/leave call the handler if related is outside the target.

			// NB: No relatedTarget if the mouse left/entered the browser window

			if ( !related || ( related !== target && !jQuery.contains( target, related ) ) ) {

				event.type = handleObj.origType;

				ret = handleObj.handler.apply( this, arguments );

				event.type = fix;

			}

			return ret;

		}

	};

} );



jQuery.fn.extend( {



	on: function( types, selector, data, fn ) {

		return on( this, types, selector, data, fn );

	},

	one: function( types, selector, data, fn ) {

		return on( this, types, selector, data, fn, 1 );

	},

	off: function( types, selector, fn ) {

		var handleObj, type;

		if ( types && types.preventDefault && types.handleObj ) {



			// ( event )  dispatched jQuery.Event

			handleObj = types.handleObj;

			jQuery( types.delegateTarget ).off(

				handleObj.namespace ?

					handleObj.origType + "." + handleObj.namespace :

					handleObj.origType,

				handleObj.selector,

				handleObj.handler

			);

			return this;

		}

		if ( typeof types === "object" ) {



			// ( types-object [, selector] )

			for ( type in types ) {

				this.off( type, selector, types[ type ] );

			}

			return this;

		}

		if ( selector === false || typeof selector === "function" ) {



			// ( types [, fn] )

			fn = selector;

			selector = undefined;

		}

		if ( fn === false ) {

			fn = returnFalse;

		}

		return this.each( function() {

			jQuery.event.remove( this, types, fn, selector );

		} );

	}

} );





var



	// Support: IE <=10 - 11, Edge 12 - 13 only

	// In IE/Edge using regex groups here causes severe slowdowns.

	// See https://connect.microsoft.com/IE/feedback/details/1736512/

	rnoInnerhtml = /<script|<style|<link/i,



	// checked="checked" or checked

	rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,

	rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;



// Prefer a tbody over its parent table for containing new rows

function manipulationTarget( elem, content ) {

	if ( nodeName( elem, "table" ) &&

		nodeName( content.nodeType !== 11 ? content : content.firstChild, "tr" ) ) {



		return jQuery( elem ).children( "tbody" )[ 0 ] || elem;

	}



	return elem;

}



// Replace/restore the type attribute of script elements for safe DOM manipulation

function disableScript( elem ) {

	elem.type = ( elem.getAttribute( "type" ) !== null ) + "/" + elem.type;

	return elem;

}

function restoreScript( elem ) {

	if ( ( elem.type || "" ).slice( 0, 5 ) === "true/" ) {

		elem.type = elem.type.slice( 5 );

	} else {

		elem.removeAttribute( "type" );

	}



	return elem;

}



function cloneCopyEvent( src, dest ) {

	var i, l, type, pdataOld, udataOld, udataCur, events;



	if ( dest.nodeType !== 1 ) {

		return;

	}



	// 1. Copy private data: events, handlers, etc.

	if ( dataPriv.hasData( src ) ) {

		pdataOld = dataPriv.get( src );

		events = pdataOld.events;



		if ( events ) {

			dataPriv.remove( dest, "handle events" );



			for ( type in events ) {

				for ( i = 0, l = events[ type ].length; i < l; i++ ) {

					jQuery.event.add( dest, type, events[ type ][ i ] );

				}

			}

		}

	}



	// 2. Copy user data

	if ( dataUser.hasData( src ) ) {

		udataOld = dataUser.access( src );

		udataCur = jQuery.extend( {}, udataOld );



		dataUser.set( dest, udataCur );

	}

}



// Fix IE bugs, see support tests

function fixInput( src, dest ) {

	var nodeName = dest.nodeName.toLowerCase();



	// Fails to persist the checked state of a cloned checkbox or radio button.

	if ( nodeName === "input" && rcheckableType.test( src.type ) ) {

		dest.checked = src.checked;



	// Fails to return the selected option to the default selected state when cloning options

	} else if ( nodeName === "input" || nodeName === "textarea" ) {

		dest.defaultValue = src.defaultValue;

	}

}



function domManip( collection, args, callback, ignored ) {



	// Flatten any nested arrays

	args = flat( args );



	var fragment, first, scripts, hasScripts, node, doc,

		i = 0,

		l = collection.length,

		iNoClone = l - 1,

		value = args[ 0 ],

		valueIsFunction = isFunction( value );



	// We can't cloneNode fragments that contain checked, in WebKit

	if ( valueIsFunction ||

			( l > 1 && typeof value === "string" &&

				!support.checkClone && rchecked.test( value ) ) ) {

		return collection.each( function( index ) {

			var self = collection.eq( index );

			if ( valueIsFunction ) {

				args[ 0 ] = value.call( this, index, self.html() );

			}

			domManip( self, args, callback, ignored );

		} );

	}



	if ( l ) {

		fragment = buildFragment( args, collection[ 0 ].ownerDocument, false, collection, ignored );

		first = fragment.firstChild;



		if ( fragment.childNodes.length === 1 ) {

			fragment = first;

		}



		// Require either new content or an interest in ignored elements to invoke the callback

		if ( first || ignored ) {

			scripts = jQuery.map( getAll( fragment, "script" ), disableScript );

			hasScripts = scripts.length;



			// Use the original fragment for the last item

			// instead of the first because it can end up

			// being emptied incorrectly in certain situations (#8070).

			for ( ; i < l; i++ ) {

				node = fragment;



				if ( i !== iNoClone ) {

					node = jQuery.clone( node, true, true );



					// Keep references to cloned scripts for later restoration

					if ( hasScripts ) {



						// Support: Android <=4.0 only, PhantomJS 1 only

						// push.apply(_, arraylike) throws on ancient WebKit

						jQuery.merge( scripts, getAll( node, "script" ) );

					}

				}



				callback.call( collection[ i ], node, i );

			}



			if ( hasScripts ) {

				doc = scripts[ scripts.length - 1 ].ownerDocument;



				// Reenable scripts

				jQuery.map( scripts, restoreScript );



				// Evaluate executable scripts on first document insertion

				for ( i = 0; i < hasScripts; i++ ) {

					node = scripts[ i ];

					if ( rscriptType.test( node.type || "" ) &&

						!dataPriv.access( node, "globalEval" ) &&

						jQuery.contains( doc, node ) ) {



						if ( node.src && ( node.type || "" ).toLowerCase()  !== "module" ) {



							// Optional AJAX dependency, but won't run scripts if not present

							if ( jQuery._evalUrl && !node.noModule ) {

								jQuery._evalUrl( node.src, {

									nonce: node.nonce || node.getAttribute( "nonce" )

								}, doc );

							}

						} else {

							DOMEval( node.textContent.replace( rcleanScript, "" ), node, doc );

						}

					}

				}

			}

		}

	}



	return collection;

}



function remove( elem, selector, keepData ) {

	var node,

		nodes = selector ? jQuery.filter( selector, elem ) : elem,

		i = 0;



	for ( ; ( node = nodes[ i ] ) != null; i++ ) {

		if ( !keepData && node.nodeType === 1 ) {

			jQuery.cleanData( getAll( node ) );

		}



		if ( node.parentNode ) {

			if ( keepData && isAttached( node ) ) {

				setGlobalEval( getAll( node, "script" ) );

			}

			node.parentNode.removeChild( node );

		}

	}



	return elem;

}



jQuery.extend( {

	htmlPrefilter: function( html ) {

		return html;

	},



	clone: function( elem, dataAndEvents, deepDataAndEvents ) {

		var i, l, srcElements, destElements,

			clone = elem.cloneNode( true ),

			inPage = isAttached( elem );



		// Fix IE cloning issues

		if ( !support.noCloneChecked && ( elem.nodeType === 1 || elem.nodeType === 11 ) &&

				!jQuery.isXMLDoc( elem ) ) {



			// We eschew Sizzle here for performance reasons: https://jsperf.com/getall-vs-sizzle/2

			destElements = getAll( clone );

			srcElements = getAll( elem );



			for ( i = 0, l = srcElements.length; i < l; i++ ) {

				fixInput( srcElements[ i ], destElements[ i ] );

			}

		}



		// Copy the events from the original to the clone

		if ( dataAndEvents ) {

			if ( deepDataAndEvents ) {

				srcElements = srcElements || getAll( elem );

				destElements = destElements || getAll( clone );



				for ( i = 0, l = srcElements.length; i < l; i++ ) {

					cloneCopyEvent( srcElements[ i ], destElements[ i ] );

				}

			} else {

				cloneCopyEvent( elem, clone );

			}

		}



		// Preserve script evaluation history

		destElements = getAll( clone, "script" );

		if ( destElements.length > 0 ) {

			setGlobalEval( destElements, !inPage && getAll( elem, "script" ) );

		}



		// Return the cloned set

		return clone;

	},



	cleanData: function( elems ) {

		var data, elem, type,

			special = jQuery.event.special,

			i = 0;



		for ( ; ( elem = elems[ i ] ) !== undefined; i++ ) {

			if ( acceptData( elem ) ) {

				if ( ( data = elem[ dataPriv.expando ] ) ) {

					if ( data.events ) {

						for ( type in data.events ) {

							if ( special[ type ] ) {

								jQuery.event.remove( elem, type );



							// This is a shortcut to avoid jQuery.event.remove's overhead

							} else {

								jQuery.removeEvent( elem, type, data.handle );

							}

						}

					}



					// Support: Chrome <=35 - 45+

					// Assign undefined instead of using delete, see Data#remove

					elem[ dataPriv.expando ] = undefined;

				}

				if ( elem[ dataUser.expando ] ) {



					// Support: Chrome <=35 - 45+

					// Assign undefined instead of using delete, see Data#remove

					elem[ dataUser.expando ] = undefined;

				}

			}

		}

	}

} );



jQuery.fn.extend( {

	detach: function( selector ) {

		return remove( this, selector, true );

	},



	remove: function( selector ) {

		return remove( this, selector );

	},



	text: function( value ) {

		return access( this, function( value ) {

			return value === undefined ?

				jQuery.text( this ) :

				this.empty().each( function() {

					if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {

						this.textContent = value;

					}

				} );

		}, null, value, arguments.length );

	},



	append: function() {

		return domManip( this, arguments, function( elem ) {

			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {

				var target = manipulationTarget( this, elem );

				target.appendChild( elem );

			}

		} );

	},



	prepend: function() {

		return domManip( this, arguments, function( elem ) {

			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {

				var target = manipulationTarget( this, elem );

				target.insertBefore( elem, target.firstChild );

			}

		} );

	},



	before: function() {

		return domManip( this, arguments, function( elem ) {

			if ( this.parentNode ) {

				this.parentNode.insertBefore( elem, this );

			}

		} );

	},



	after: function() {

		return domManip( this, arguments, function( elem ) {

			if ( this.parentNode ) {

				this.parentNode.insertBefore( elem, this.nextSibling );

			}

		} );

	},



	empty: function() {

		var elem,

			i = 0;



		for ( ; ( elem = this[ i ] ) != null; i++ ) {

			if ( elem.nodeType === 1 ) {



				// Prevent memory leaks

				jQuery.cleanData( getAll( elem, false ) );



				// Remove any remaining nodes

				elem.textContent = "";

			}

		}



		return this;

	},



	clone: function( dataAndEvents, deepDataAndEvents ) {

		dataAndEvents = dataAndEvents == null ? false : dataAndEvents;

		deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;



		return this.map( function() {

			return jQuery.clone( this, dataAndEvents, deepDataAndEvents );

		} );

	},



	html: function( value ) {

		return access( this, function( value ) {

			var elem = this[ 0 ] || {},

				i = 0,

				l = this.length;



			if ( value === undefined && elem.nodeType === 1 ) {

				return elem.innerHTML;

			}



			// See if we can take a shortcut and just use innerHTML

			if ( typeof value === "string" && !rnoInnerhtml.test( value ) &&

				!wrapMap[ ( rtagName.exec( value ) || [ "", "" ] )[ 1 ].toLowerCase() ] ) {



				value = jQuery.htmlPrefilter( value );



				try {

					for ( ; i < l; i++ ) {

						elem = this[ i ] || {};



						// Remove element nodes and prevent memory leaks

						if ( elem.nodeType === 1 ) {

							jQuery.cleanData( getAll( elem, false ) );

							elem.innerHTML = value;

						}

					}



					elem = 0;



				// If using innerHTML throws an exception, use the fallback method

				} catch ( e ) {}

			}



			if ( elem ) {

				this.empty().append( value );

			}

		}, null, value, arguments.length );

	},



	replaceWith: function() {

		var ignored = [];



		// Make the changes, replacing each non-ignored context element with the new content

		return domManip( this, arguments, function( elem ) {

			var parent = this.parentNode;



			if ( jQuery.inArray( this, ignored ) < 0 ) {

				jQuery.cleanData( getAll( this ) );

				if ( parent ) {

					parent.replaceChild( elem, this );

				}

			}



		// Force callback invocation

		}, ignored );

	}

} );



jQuery.each( {

	appendTo: "append",

	prependTo: "prepend",

	insertBefore: "before",

	insertAfter: "after",

	replaceAll: "replaceWith"

}, function( name, original ) {

	jQuery.fn[ name ] = function( selector ) {

		var elems,

			ret = [],

			insert = jQuery( selector ),

			last = insert.length - 1,

			i = 0;



		for ( ; i <= last; i++ ) {

			elems = i === last ? this : this.clone( true );

			jQuery( insert[ i ] )[ original ]( elems );



			// Support: Android <=4.0 only, PhantomJS 1 only

			// .get() because push.apply(_, arraylike) throws on ancient WebKit

			push.apply( ret, elems.get() );

		}



		return this.pushStack( ret );

	};

} );

var rnumnonpx = new RegExp( "^(" + pnum + ")(?!px)[a-z%]+$", "i" );



var getStyles = function( elem ) {



		// Support: IE <=11 only, Firefox <=30 (#15098, #14150)

		// IE throws on elements created in popups

		// FF meanwhile throws on frame elements through "defaultView.getComputedStyle"

		var view = elem.ownerDocument.defaultView;



		if ( !view || !view.opener ) {

			view = window;

		}



		return view.getComputedStyle( elem );

	};



var swap = function( elem, options, callback ) {

	var ret, name,

		old = {};



	// Remember the old values, and insert the new ones

	for ( name in options ) {

		old[ name ] = elem.style[ name ];

		elem.style[ name ] = options[ name ];

	}



	ret = callback.call( elem );



	// Revert the old values

	for ( name in options ) {

		elem.style[ name ] = old[ name ];

	}



	return ret;

};





var rboxStyle = new RegExp( cssExpand.join( "|" ), "i" );







( function() {



	// Executing both pixelPosition & boxSizingReliable tests require only one layout

	// so they're executed at the same time to save the second computation.

	function computeStyleTests() {



		// This is a singleton, we need to execute it only once

		if ( !div ) {

			return;

		}



		container.style.cssText = "position:absolute;left:-11111px;width:60px;" +

			"margin-top:1px;padding:0;border:0";

		div.style.cssText =

			"position:relative;display:block;box-sizing:border-box;overflow:scroll;" +

			"margin:auto;border:1px;padding:1px;" +

			"width:60%;top:1%";

		documentElement.appendChild( container ).appendChild( div );



		var divStyle = window.getComputedStyle( div );

		pixelPositionVal = divStyle.top !== "1%";



		// Support: Android 4.0 - 4.3 only, Firefox <=3 - 44

		reliableMarginLeftVal = roundPixelMeasures( divStyle.marginLeft ) === 12;



		// Support: Android 4.0 - 4.3 only, Safari <=9.1 - 10.1, iOS <=7.0 - 9.3

		// Some styles come back with percentage values, even though they shouldn't

		div.style.right = "60%";

		pixelBoxStylesVal = roundPixelMeasures( divStyle.right ) === 36;



		// Support: IE 9 - 11 only

		// Detect misreporting of content dimensions for box-sizing:border-box elements

		boxSizingReliableVal = roundPixelMeasures( divStyle.width ) === 36;



		// Support: IE 9 only

		// Detect overflow:scroll screwiness (gh-3699)

		// Support: Chrome <=64

		// Don't get tricked when zoom affects offsetWidth (gh-4029)

		div.style.position = "absolute";

		scrollboxSizeVal = roundPixelMeasures( div.offsetWidth / 3 ) === 12;



		documentElement.removeChild( container );



		// Nullify the div so it wouldn't be stored in the memory and

		// it will also be a sign that checks already performed

		div = null;

	}



	function roundPixelMeasures( measure ) {

		return Math.round( parseFloat( measure ) );

	}



	var pixelPositionVal, boxSizingReliableVal, scrollboxSizeVal, pixelBoxStylesVal,

		reliableTrDimensionsVal, reliableMarginLeftVal,

		container = document.createElement( "div" ),

		div = document.createElement( "div" );



	// Finish early in limited (non-browser) environments

	if ( !div.style ) {

		return;

	}



	// Support: IE <=9 - 11 only

	// Style of cloned element affects source element cloned (#8908)

	div.style.backgroundClip = "content-box";

	div.cloneNode( true ).style.backgroundClip = "";

	support.clearCloneStyle = div.style.backgroundClip === "content-box";



	jQuery.extend( support, {

		boxSizingReliable: function() {

			computeStyleTests();

			return boxSizingReliableVal;

		},

		pixelBoxStyles: function() {

			computeStyleTests();

			return pixelBoxStylesVal;

		},

		pixelPosition: function() {

			computeStyleTests();

			return pixelPositionVal;

		},

		reliableMarginLeft: function() {

			computeStyleTests();

			return reliableMarginLeftVal;

		},

		scrollboxSize: function() {

			computeStyleTests();

			return scrollboxSizeVal;

		},



		// Support: IE 9 - 11+, Edge 15 - 18+

		// IE/Edge misreport `getComputedStyle` of table rows with width/height

		// set in CSS while `offset*` properties report correct values.

		// Behavior in IE 9 is more subtle than in newer versions & it passes

		// some versions of this test; make sure not to make it pass there!

		reliableTrDimensions: function() {

			var table, tr, trChild, trStyle;

			if ( reliableTrDimensionsVal == null ) {

				table = document.createElement( "table" );

				tr = document.createElement( "tr" );

				trChild = document.createElement( "div" );



				table.style.cssText = "position:absolute;left:-11111px";

				tr.style.height = "1px";

				trChild.style.height = "9px";



				documentElement

					.appendChild( table )

					.appendChild( tr )

					.appendChild( trChild );



				trStyle = window.getComputedStyle( tr );

				reliableTrDimensionsVal = parseInt( trStyle.height ) > 3;



				documentElement.removeChild( table );

			}

			return reliableTrDimensionsVal;

		}

	} );

} )();





function curCSS( elem, name, computed ) {

	var width, minWidth, maxWidth, ret,



		// Support: Firefox 51+

		// Retrieving style before computed somehow

		// fixes an issue with getting wrong values

		// on detached elements

		style = elem.style;



	computed = computed || getStyles( elem );



	// getPropertyValue is needed for:

	//   .css('filter') (IE 9 only, #12537)

	//   .css('--customProperty) (#3144)

	if ( computed ) {

		ret = computed.getPropertyValue( name ) || computed[ name ];



		if ( ret === "" && !isAttached( elem ) ) {

			ret = jQuery.style( elem, name );

		}



		// A tribute to the "awesome hack by Dean Edwards"

		// Android Browser returns percentage for some values,

		// but width seems to be reliably pixels.

		// This is against the CSSOM draft spec:

		// https://drafts.csswg.org/cssom/#resolved-values

		if ( !support.pixelBoxStyles() && rnumnonpx.test( ret ) && rboxStyle.test( name ) ) {



			// Remember the original values

			width = style.width;

			minWidth = style.minWidth;

			maxWidth = style.maxWidth;



			// Put in the new values to get a computed value out

			style.minWidth = style.maxWidth = style.width = ret;

			ret = computed.width;



			// Revert the changed values

			style.width = width;

			style.minWidth = minWidth;

			style.maxWidth = maxWidth;

		}

	}



	return ret !== undefined ?



		// Support: IE <=9 - 11 only

		// IE returns zIndex value as an integer.

		ret + "" :

		ret;

}





function addGetHookIf( conditionFn, hookFn ) {



	// Define the hook, we'll check on the first run if it's really needed.

	return {

		get: function() {

			if ( conditionFn() ) {



				// Hook not needed (or it's not possible to use it due

				// to missing dependency), remove it.

				delete this.get;

				return;

			}



			// Hook needed; redefine it so that the support test is not executed again.

			return ( this.get = hookFn ).apply( this, arguments );

		}

	};

}





var cssPrefixes = [ "Webkit", "Moz", "ms" ],

	emptyStyle = document.createElement( "div" ).style,

	vendorProps = {};



// Return a vendor-prefixed property or undefined

function vendorPropName( name ) {



	// Check for vendor prefixed names

	var capName = name[ 0 ].toUpperCase() + name.slice( 1 ),

		i = cssPrefixes.length;



	while ( i-- ) {

		name = cssPrefixes[ i ] + capName;

		if ( name in emptyStyle ) {

			return name;

		}

	}

}



// Return a potentially-mapped jQuery.cssProps or vendor prefixed property

function finalPropName( name ) {

	var final = jQuery.cssProps[ name ] || vendorProps[ name ];



	if ( final ) {

		return final;

	}

	if ( name in emptyStyle ) {

		return name;

	}

	return vendorProps[ name ] = vendorPropName( name ) || name;

}





var



	// Swappable if display is none or starts with table

	// except "table", "table-cell", or "table-caption"

	// See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display

	rdisplayswap = /^(none|table(?!-c[ea]).+)/,

	rcustomProp = /^--/,

	cssShow = { position: "absolute", visibility: "hidden", display: "block" },

	cssNormalTransform = {

		letterSpacing: "0",

		fontWeight: "400"

	};



function setPositiveNumber( _elem, value, subtract ) {



	// Any relative (+/-) values have already been

	// normalized at this point

	var matches = rcssNum.exec( value );

	return matches ?



		// Guard against undefined "subtract", e.g., when used as in cssHooks

		Math.max( 0, matches[ 2 ] - ( subtract || 0 ) ) + ( matches[ 3 ] || "px" ) :

		value;

}



function boxModelAdjustment( elem, dimension, box, isBorderBox, styles, computedVal ) {

	var i = dimension === "width" ? 1 : 0,

		extra = 0,

		delta = 0;



	// Adjustment may not be necessary

	if ( box === ( isBorderBox ? "border" : "content" ) ) {

		return 0;

	}



	for ( ; i < 4; i += 2 ) {



		// Both box models exclude margin

		if ( box === "margin" ) {

			delta += jQuery.css( elem, box + cssExpand[ i ], true, styles );

		}



		// If we get here with a content-box, we're seeking "padding" or "border" or "margin"

		if ( !isBorderBox ) {



			// Add padding

			delta += jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );



			// For "border" or "margin", add border

			if ( box !== "padding" ) {

				delta += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );



			// But still keep track of it otherwise

			} else {

				extra += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );

			}



		// If we get here with a border-box (content + padding + border), we're seeking "content" or

		// "padding" or "margin"

		} else {



			// For "content", subtract padding

			if ( box === "content" ) {

				delta -= jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );

			}



			// For "content" or "padding", subtract border

			if ( box !== "margin" ) {

				delta -= jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );

			}

		}

	}



	// Account for positive content-box scroll gutter when requested by providing computedVal

	if ( !isBorderBox && computedVal >= 0 ) {



		// offsetWidth/offsetHeight is a rounded sum of content, padding, scroll gutter, and border

		// Assuming integer scroll gutter, subtract the rest and round down

		delta += Math.max( 0, Math.ceil(

			elem[ "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -

			computedVal -

			delta -

			extra -

			0.5



		// If offsetWidth/offsetHeight is unknown, then we can't determine content-box scroll gutter

		// Use an explicit zero to avoid NaN (gh-3964)

		) ) || 0;

	}



	return delta;

}



function getWidthOrHeight( elem, dimension, extra ) {



	// Start with computed style

	var styles = getStyles( elem ),



		// To avoid forcing a reflow, only fetch boxSizing if we need it (gh-4322).

		// Fake content-box until we know it's needed to know the true value.

		boxSizingNeeded = !support.boxSizingReliable() || extra,

		isBorderBox = boxSizingNeeded &&

			jQuery.css( elem, "boxSizing", false, styles ) === "border-box",

		valueIsBorderBox = isBorderBox,



		val = curCSS( elem, dimension, styles ),

		offsetProp = "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 );



	// Support: Firefox <=54

	// Return a confounding non-pixel value or feign ignorance, as appropriate.

	if ( rnumnonpx.test( val ) ) {

		if ( !extra ) {

			return val;

		}

		val = "auto";

	}





	// Support: IE 9 - 11 only

	// Use offsetWidth/offsetHeight for when box sizing is unreliable.

	// In those cases, the computed value can be trusted to be border-box.

	if ( ( !support.boxSizingReliable() && isBorderBox ||



		// Support: IE 10 - 11+, Edge 15 - 18+

		// IE/Edge misreport `getComputedStyle` of table rows with width/height

		// set in CSS while `offset*` properties report correct values.

		// Interestingly, in some cases IE 9 doesn't suffer from this issue.

		!support.reliableTrDimensions() && nodeName( elem, "tr" ) ||



		// Fall back to offsetWidth/offsetHeight when value is "auto"

		// This happens for inline elements with no explicit setting (gh-3571)

		val === "auto" ||



		// Support: Android <=4.1 - 4.3 only

		// Also use offsetWidth/offsetHeight for misreported inline dimensions (gh-3602)

		!parseFloat( val ) && jQuery.css( elem, "display", false, styles ) === "inline" ) &&



		// Make sure the element is visible & connected

		elem.getClientRects().length ) {



		isBorderBox = jQuery.css( elem, "boxSizing", false, styles ) === "border-box";



		// Where available, offsetWidth/offsetHeight approximate border box dimensions.

		// Where not available (e.g., SVG), assume unreliable box-sizing and interpret the

		// retrieved value as a content box dimension.

		valueIsBorderBox = offsetProp in elem;

		if ( valueIsBorderBox ) {

			val = elem[ offsetProp ];

		}

	}



	// Normalize "" and auto

	val = parseFloat( val ) || 0;



	// Adjust for the element's box model

	return ( val +

		boxModelAdjustment(

			elem,

			dimension,

			extra || ( isBorderBox ? "border" : "content" ),

			valueIsBorderBox,

			styles,



			// Provide the current computed size to request scroll gutter calculation (gh-3589)

			val

		)

	) + "px";

}



jQuery.extend( {



	// Add in style property hooks for overriding the default

	// behavior of getting and setting a style property

	cssHooks: {

		opacity: {

			get: function( elem, computed ) {

				if ( computed ) {



					// We should always get a number back from opacity

					var ret = curCSS( elem, "opacity" );

					return ret === "" ? "1" : ret;

				}

			}

		}

	},



	// Don't automatically add "px" to these possibly-unitless properties

	cssNumber: {

		"animationIterationCount": true,

		"columnCount": true,

		"fillOpacity": true,

		"flexGrow": true,

		"flexShrink": true,

		"fontWeight": true,

		"gridArea": true,

		"gridColumn": true,

		"gridColumnEnd": true,

		"gridColumnStart": true,

		"gridRow": true,

		"gridRowEnd": true,

		"gridRowStart": true,

		"lineHeight": true,

		"opacity": true,

		"order": true,

		"orphans": true,

		"widows": true,

		"zIndex": true,

		"zoom": true

	},



	// Add in properties whose names you wish to fix before

	// setting or getting the value

	cssProps: {},



	// Get and set the style property on a DOM Node

	style: function( elem, name, value, extra ) {



		// Don't set styles on text and comment nodes

		if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {

			return;

		}



		// Make sure that we're working with the right name

		var ret, type, hooks,

			origName = camelCase( name ),

			isCustomProp = rcustomProp.test( name ),

			style = elem.style;



		// Make sure that we're working with the right name. We don't

		// want to query the value if it is a CSS custom property

		// since they are user-defined.

		if ( !isCustomProp ) {

			name = finalPropName( origName );

		}



		// Gets hook for the prefixed version, then unprefixed version

		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];



		// Check if we're setting a value

		if ( value !== undefined ) {

			type = typeof value;



			// Convert "+=" or "-=" to relative numbers (#7345)

			if ( type === "string" && ( ret = rcssNum.exec( value ) ) && ret[ 1 ] ) {

				value = adjustCSS( elem, name, ret );



				// Fixes bug #9237

				type = "number";

			}



			// Make sure that null and NaN values aren't set (#7116)

			if ( value == null || value !== value ) {

				return;

			}



			// If a number was passed in, add the unit (except for certain CSS properties)

			// The isCustomProp check can be removed in jQuery 4.0 when we only auto-append

			// "px" to a few hardcoded values.

			if ( type === "number" && !isCustomProp ) {

				value += ret && ret[ 3 ] || ( jQuery.cssNumber[ origName ] ? "" : "px" );

			}



			// background-* props affect original clone's values

			if ( !support.clearCloneStyle && value === "" && name.indexOf( "background" ) === 0 ) {

				style[ name ] = "inherit";

			}



			// If a hook was provided, use that value, otherwise just set the specified value

			if ( !hooks || !( "set" in hooks ) ||

				( value = hooks.set( elem, value, extra ) ) !== undefined ) {



				if ( isCustomProp ) {

					style.setProperty( name, value );

				} else {

					style[ name ] = value;

				}

			}



		} else {



			// If a hook was provided get the non-computed value from there

			if ( hooks && "get" in hooks &&

				( ret = hooks.get( elem, false, extra ) ) !== undefined ) {



				return ret;

			}



			// Otherwise just get the value from the style object

			return style[ name ];

		}

	},



	css: function( elem, name, extra, styles ) {

		var val, num, hooks,

			origName = camelCase( name ),

			isCustomProp = rcustomProp.test( name );



		// Make sure that we're working with the right name. We don't

		// want to modify the value if it is a CSS custom property

		// since they are user-defined.

		if ( !isCustomProp ) {

			name = finalPropName( origName );

		}



		// Try prefixed name followed by the unprefixed name

		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];



		// If a hook was provided get the computed value from there

		if ( hooks && "get" in hooks ) {

			val = hooks.get( elem, true, extra );

		}



		// Otherwise, if a way to get the computed value exists, use that

		if ( val === undefined ) {

			val = curCSS( elem, name, styles );

		}



		// Convert "normal" to computed value

		if ( val === "normal" && name in cssNormalTransform ) {

			val = cssNormalTransform[ name ];

		}



		// Make numeric if forced or a qualifier was provided and val looks numeric

		if ( extra === "" || extra ) {

			num = parseFloat( val );

			return extra === true || isFinite( num ) ? num || 0 : val;

		}



		return val;

	}

} );



jQuery.each( [ "height", "width" ], function( _i, dimension ) {

	jQuery.cssHooks[ dimension ] = {

		get: function( elem, computed, extra ) {

			if ( computed ) {



				// Certain elements can have dimension info if we invisibly show them

				// but it must have a current display style that would benefit

				return rdisplayswap.test( jQuery.css( elem, "display" ) ) &&



					// Support: Safari 8+

					// Table columns in Safari have non-zero offsetWidth & zero

					// getBoundingClientRect().width unless display is changed.

					// Support: IE <=11 only

					// Running getBoundingClientRect on a disconnected node

					// in IE throws an error.

					( !elem.getClientRects().length || !elem.getBoundingClientRect().width ) ?

						swap( elem, cssShow, function() {

							return getWidthOrHeight( elem, dimension, extra );

						} ) :

						getWidthOrHeight( elem, dimension, extra );

			}

		},



		set: function( elem, value, extra ) {

			var matches,

				styles = getStyles( elem ),



				// Only read styles.position if the test has a chance to fail

				// to avoid forcing a reflow.

				scrollboxSizeBuggy = !support.scrollboxSize() &&

					styles.position === "absolute",



				// To avoid forcing a reflow, only fetch boxSizing if we need it (gh-3991)

				boxSizingNeeded = scrollboxSizeBuggy || extra,

				isBorderBox = boxSizingNeeded &&

					jQuery.css( elem, "boxSizing", false, styles ) === "border-box",

				subtract = extra ?

					boxModelAdjustment(

						elem,

						dimension,

						extra,

						isBorderBox,

						styles

					) :

					0;



			// Account for unreliable border-box dimensions by comparing offset* to computed and

			// faking a content-box to get border and padding (gh-3699)

			if ( isBorderBox && scrollboxSizeBuggy ) {

				subtract -= Math.ceil(

					elem[ "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -

					parseFloat( styles[ dimension ] ) -

					boxModelAdjustment( elem, dimension, "border", false, styles ) -

					0.5

				);

			}



			// Convert to pixels if value adjustment is needed

			if ( subtract && ( matches = rcssNum.exec( value ) ) &&

				( matches[ 3 ] || "px" ) !== "px" ) {



				elem.style[ dimension ] = value;

				value = jQuery.css( elem, dimension );

			}



			return setPositiveNumber( elem, value, subtract );

		}

	};

} );



jQuery.cssHooks.marginLeft = addGetHookIf( support.reliableMarginLeft,

	function( elem, computed ) {

		if ( computed ) {

			return ( parseFloat( curCSS( elem, "marginLeft" ) ) ||

				elem.getBoundingClientRect().left -

					swap( elem, { marginLeft: 0 }, function() {

						return elem.getBoundingClientRect().left;

					} )

				) + "px";

		}

	}

);



// These hooks are used by animate to expand properties

jQuery.each( {

	margin: "",

	padding: "",

	border: "Width"

}, function( prefix, suffix ) {

	jQuery.cssHooks[ prefix + suffix ] = {

		expand: function( value ) {

			var i = 0,

				expanded = {},



				// Assumes a single number if not a string

				parts = typeof value === "string" ? value.split( " " ) : [ value ];



			for ( ; i < 4; i++ ) {

				expanded[ prefix + cssExpand[ i ] + suffix ] =

					parts[ i ] || parts[ i - 2 ] || parts[ 0 ];

			}



			return expanded;

		}

	};



	if ( prefix !== "margin" ) {

		jQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;

	}

} );



jQuery.fn.extend( {

	css: function( name, value ) {

		return access( this, function( elem, name, value ) {

			var styles, len,

				map = {},

				i = 0;



			if ( Array.isArray( name ) ) {

				styles = getStyles( elem );

				len = name.length;



				for ( ; i < len; i++ ) {

					map[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );

				}



				return map;

			}



			return value !== undefined ?

				jQuery.style( elem, name, value ) :

				jQuery.css( elem, name );

		}, name, value, arguments.length > 1 );

	}

} );





function Tween( elem, options, prop, end, easing ) {

	return new Tween.prototype.init( elem, options, prop, end, easing );

}

jQuery.Tween = Tween;



Tween.prototype = {

	constructor: Tween,

	init: function( elem, options, prop, end, easing, unit ) {

		this.elem = elem;

		this.prop = prop;

		this.easing = easing || jQuery.easing._default;

		this.options = options;

		this.start = this.now = this.cur();

		this.end = end;

		this.unit = unit || ( jQuery.cssNumber[ prop ] ? "" : "px" );

	},

	cur: function() {

		var hooks = Tween.propHooks[ this.prop ];



		return hooks && hooks.get ?

			hooks.get( this ) :

			Tween.propHooks._default.get( this );

	},

	run: function( percent ) {

		var eased,

			hooks = Tween.propHooks[ this.prop ];



		if ( this.options.duration ) {

			this.pos = eased = jQuery.easing[ this.easing ](

				percent, this.options.duration * percent, 0, 1, this.options.duration

			);

		} else {

			this.pos = eased = percent;

		}

		this.now = ( this.end - this.start ) * eased + this.start;



		if ( this.options.step ) {

			this.options.step.call( this.elem, this.now, this );

		}



		if ( hooks && hooks.set ) {

			hooks.set( this );

		} else {

			Tween.propHooks._default.set( this );

		}

		return this;

	}

};



Tween.prototype.init.prototype = Tween.prototype;



Tween.propHooks = {

	_default: {

		get: function( tween ) {

			var result;



			// Use a property on the element directly when it is not a DOM element,

			// or when there is no matching style property that exists.

			if ( tween.elem.nodeType !== 1 ||

				tween.elem[ tween.prop ] != null && tween.elem.style[ tween.prop ] == null ) {

				return tween.elem[ tween.prop ];

			}



			// Passing an empty string as a 3rd parameter to .css will automatically

			// attempt a parseFloat and fallback to a string if the parse fails.

			// Simple values such as "10px" are parsed to Float;

			// complex values such as "rotate(1rad)" are returned as-is.

			result = jQuery.css( tween.elem, tween.prop, "" );



			// Empty strings, null, undefined and "auto" are converted to 0.

			return !result || result === "auto" ? 0 : result;

		},

		set: function( tween ) {



			// Use step hook for back compat.

			// Use cssHook if its there.

			// Use .style if available and use plain properties where available.

			if ( jQuery.fx.step[ tween.prop ] ) {

				jQuery.fx.step[ tween.prop ]( tween );

			} else if ( tween.elem.nodeType === 1 && (

					jQuery.cssHooks[ tween.prop ] ||

					tween.elem.style[ finalPropName( tween.prop ) ] != null ) ) {

				jQuery.style( tween.elem, tween.prop, tween.now + tween.unit );

			} else {

				tween.elem[ tween.prop ] = tween.now;

			}

		}

	}

};



// Support: IE <=9 only

// Panic based approach to setting things on disconnected nodes

Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {

	set: function( tween ) {

		if ( tween.elem.nodeType && tween.elem.parentNode ) {

			tween.elem[ tween.prop ] = tween.now;

		}

	}

};



jQuery.easing = {

	linear: function( p ) {

		return p;

	},

	swing: function( p ) {

		return 0.5 - Math.cos( p * Math.PI ) / 2;

	},

	_default: "swing"

};



jQuery.fx = Tween.prototype.init;



// Back compat <1.8 extension point

jQuery.fx.step = {};









var

	fxNow, inProgress,

	rfxtypes = /^(?:toggle|show|hide)$/,

	rrun = /queueHooks$/;



function schedule() {

	if ( inProgress ) {

		if ( document.hidden === false && window.requestAnimationFrame ) {

			window.requestAnimationFrame( schedule );

		} else {

			window.setTimeout( schedule, jQuery.fx.interval );

		}



		jQuery.fx.tick();

	}

}



// Animations created synchronously will run synchronously

function createFxNow() {

	window.setTimeout( function() {

		fxNow = undefined;

	} );

	return ( fxNow = Date.now() );

}



// Generate parameters to create a standard animation

function genFx( type, includeWidth ) {

	var which,

		i = 0,

		attrs = { height: type };



	// If we include width, step value is 1 to do all cssExpand values,

	// otherwise step value is 2 to skip over Left and Right

	includeWidth = includeWidth ? 1 : 0;

	for ( ; i < 4; i += 2 - includeWidth ) {

		which = cssExpand[ i ];

		attrs[ "margin" + which ] = attrs[ "padding" + which ] = type;

	}



	if ( includeWidth ) {

		attrs.opacity = attrs.width = type;

	}



	return attrs;

}



function createTween( value, prop, animation ) {

	var tween,

		collection = ( Animation.tweeners[ prop ] || [] ).concat( Animation.tweeners[ "*" ] ),

		index = 0,

		length = collection.length;

	for ( ; index < length; index++ ) {

		if ( ( tween = collection[ index ].call( animation, prop, value ) ) ) {



			// We're done with this property

			return tween;

		}

	}

}



function defaultPrefilter( elem, props, opts ) {

	var prop, value, toggle, hooks, oldfire, propTween, restoreDisplay, display,

		isBox = "width" in props || "height" in props,

		anim = this,

		orig = {},

		style = elem.style,

		hidden = elem.nodeType && isHiddenWithinTree( elem ),

		dataShow = dataPriv.get( elem, "fxshow" );



	// Queue-skipping animations hijack the fx hooks

	if ( !opts.queue ) {

		hooks = jQuery._queueHooks( elem, "fx" );

		if ( hooks.unqueued == null ) {

			hooks.unqueued = 0;

			oldfire = hooks.empty.fire;

			hooks.empty.fire = function() {

				if ( !hooks.unqueued ) {

					oldfire();

				}

			};

		}

		hooks.unqueued++;



		anim.always( function() {



			// Ensure the complete handler is called before this completes

			anim.always( function() {

				hooks.unqueued--;

				if ( !jQuery.queue( elem, "fx" ).length ) {

					hooks.empty.fire();

				}

			} );

		} );

	}



	// Detect show/hide animations

	for ( prop in props ) {

		value = props[ prop ];

		if ( rfxtypes.test( value ) ) {

			delete props[ prop ];

			toggle = toggle || value === "toggle";

			if ( value === ( hidden ? "hide" : "show" ) ) {



				// Pretend to be hidden if this is a "show" and

				// there is still data from a stopped show/hide

				if ( value === "show" && dataShow && dataShow[ prop ] !== undefined ) {

					hidden = true;



				// Ignore all other no-op show/hide data

				} else {

					continue;

				}

			}

			orig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );

		}

	}



	// Bail out if this is a no-op like .hide().hide()

	propTween = !jQuery.isEmptyObject( props );

	if ( !propTween && jQuery.isEmptyObject( orig ) ) {

		return;

	}



	// Restrict "overflow" and "display" styles during box animations

	if ( isBox && elem.nodeType === 1 ) {



		// Support: IE <=9 - 11, Edge 12 - 15

		// Record all 3 overflow attributes because IE does not infer the shorthand

		// from identically-valued overflowX and overflowY and Edge just mirrors

		// the overflowX value there.

		opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];



		// Identify a display type, preferring old show/hide data over the CSS cascade

		restoreDisplay = dataShow && dataShow.display;

		if ( restoreDisplay == null ) {

			restoreDisplay = dataPriv.get( elem, "display" );

		}

		display = jQuery.css( elem, "display" );

		if ( display === "none" ) {

			if ( restoreDisplay ) {

				display = restoreDisplay;

			} else {



				// Get nonempty value(s) by temporarily forcing visibility

				showHide( [ elem ], true );

				restoreDisplay = elem.style.display || restoreDisplay;

				display = jQuery.css( elem, "display" );

				showHide( [ elem ] );

			}

		}



		// Animate inline elements as inline-block

		if ( display === "inline" || display === "inline-block" && restoreDisplay != null ) {

			if ( jQuery.css( elem, "float" ) === "none" ) {



				// Restore the original display value at the end of pure show/hide animations

				if ( !propTween ) {

					anim.done( function() {

						style.display = restoreDisplay;

					} );

					if ( restoreDisplay == null ) {

						display = style.display;

						restoreDisplay = display === "none" ? "" : display;

					}

				}

				style.display = "inline-block";

			}

		}

	}



	if ( opts.overflow ) {

		style.overflow = "hidden";

		anim.always( function() {

			style.overflow = opts.overflow[ 0 ];

			style.overflowX = opts.overflow[ 1 ];

			style.overflowY = opts.overflow[ 2 ];

		} );

	}



	// Implement show/hide animations

	propTween = false;

	for ( prop in orig ) {



		// General show/hide setup for this element animation

		if ( !propTween ) {

			if ( dataShow ) {

				if ( "hidden" in dataShow ) {

					hidden = dataShow.hidden;

				}

			} else {

				dataShow = dataPriv.access( elem, "fxshow", { display: restoreDisplay } );

			}



			// Store hidden/visible for toggle so `.stop().toggle()` "reverses"

			if ( toggle ) {

				dataShow.hidden = !hidden;

			}



			// Show elements before animating them

			if ( hidden ) {

				showHide( [ elem ], true );

			}



			/* eslint-disable no-loop-func */



			anim.done( function() {



			/* eslint-enable no-loop-func */



				// The final step of a "hide" animation is actually hiding the element

				if ( !hidden ) {

					showHide( [ elem ] );

				}

				dataPriv.remove( elem, "fxshow" );

				for ( prop in orig ) {

					jQuery.style( elem, prop, orig[ prop ] );

				}

			} );

		}



		// Per-property setup

		propTween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );

		if ( !( prop in dataShow ) ) {

			dataShow[ prop ] = propTween.start;

			if ( hidden ) {

				propTween.end = propTween.start;

				propTween.start = 0;

			}

		}

	}

}



function propFilter( props, specialEasing ) {

	var index, name, easing, value, hooks;



	// camelCase, specialEasing and expand cssHook pass

	for ( index in props ) {

		name = camelCase( index );

		easing = specialEasing[ name ];

		value = props[ index ];

		if ( Array.isArray( value ) ) {

			easing = value[ 1 ];

			value = props[ index ] = value[ 0 ];

		}



		if ( index !== name ) {

			props[ name ] = value;

			delete props[ index ];

		}



		hooks = jQuery.cssHooks[ name ];

		if ( hooks && "expand" in hooks ) {

			value = hooks.expand( value );

			delete props[ name ];



			// Not quite $.extend, this won't overwrite existing keys.

			// Reusing 'index' because we have the correct "name"

			for ( index in value ) {

				if ( !( index in props ) ) {

					props[ index ] = value[ index ];

					specialEasing[ index ] = easing;

				}

			}

		} else {

			specialEasing[ name ] = easing;

		}

	}

}



function Animation( elem, properties, options ) {

	var result,

		stopped,

		index = 0,

		length = Animation.prefilters.length,

		deferred = jQuery.Deferred().always( function() {



			// Don't match elem in the :animated selector

			delete tick.elem;

		} ),

		tick = function() {

			if ( stopped ) {

				return false;

			}

			var currentTime = fxNow || createFxNow(),

				remaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),



				// Support: Android 2.3 only

				// Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (#12497)

				temp = remaining / animation.duration || 0,

				percent = 1 - temp,

				index = 0,

				length = animation.tweens.length;



			for ( ; index < length; index++ ) {

				animation.tweens[ index ].run( percent );

			}



			deferred.notifyWith( elem, [ animation, percent, remaining ] );



			// If there's more to do, yield

			if ( percent < 1 && length ) {

				return remaining;

			}



			// If this was an empty animation, synthesize a final progress notification

			if ( !length ) {

				deferred.notifyWith( elem, [ animation, 1, 0 ] );

			}



			// Resolve the animation and report its conclusion

			deferred.resolveWith( elem, [ animation ] );

			return false;

		},

		animation = deferred.promise( {

			elem: elem,

			props: jQuery.extend( {}, properties ),

			opts: jQuery.extend( true, {

				specialEasing: {},

				easing: jQuery.easing._default

			}, options ),

			originalProperties: properties,

			originalOptions: options,

			startTime: fxNow || createFxNow(),

			duration: options.duration,

			tweens: [],

			createTween: function( prop, end ) {

				var tween = jQuery.Tween( elem, animation.opts, prop, end,

						animation.opts.specialEasing[ prop ] || animation.opts.easing );

				animation.tweens.push( tween );

				return tween;

			},

			stop: function( gotoEnd ) {

				var index = 0,



					// If we are going to the end, we want to run all the tweens

					// otherwise we skip this part

					length = gotoEnd ? animation.tweens.length : 0;

				if ( stopped ) {

					return this;

				}

				stopped = true;

				for ( ; index < length; index++ ) {

					animation.tweens[ index ].run( 1 );

				}



				// Resolve when we played the last frame; otherwise, reject

				if ( gotoEnd ) {

					deferred.notifyWith( elem, [ animation, 1, 0 ] );

					deferred.resolveWith( elem, [ animation, gotoEnd ] );

				} else {

					deferred.rejectWith( elem, [ animation, gotoEnd ] );

				}

				return this;

			}

		} ),

		props = animation.props;



	propFilter( props, animation.opts.specialEasing );



	for ( ; index < length; index++ ) {

		result = Animation.prefilters[ index ].call( animation, elem, props, animation.opts );

		if ( result ) {

			if ( isFunction( result.stop ) ) {

				jQuery._queueHooks( animation.elem, animation.opts.queue ).stop =

					result.stop.bind( result );

			}

			return result;

		}

	}



	jQuery.map( props, createTween, animation );



	if ( isFunction( animation.opts.start ) ) {

		animation.opts.start.call( elem, animation );

	}



	// Attach callbacks from options

	animation

		.progress( animation.opts.progress )

		.done( animation.opts.done, animation.opts.complete )

		.fail( animation.opts.fail )

		.always( animation.opts.always );



	jQuery.fx.timer(

		jQuery.extend( tick, {

			elem: elem,

			anim: animation,

			queue: animation.opts.queue

		} )

	);



	return animation;

}



jQuery.Animation = jQuery.extend( Animation, {



	tweeners: {

		"*": [ function( prop, value ) {

			var tween = this.createTween( prop, value );

			adjustCSS( tween.elem, prop, rcssNum.exec( value ), tween );

			return tween;

		} ]

	},



	tweener: function( props, callback ) {

		if ( isFunction( props ) ) {

			callback = props;

			props = [ "*" ];

		} else {

			props = props.match( rnothtmlwhite );

		}



		var prop,

			index = 0,

			length = props.length;



		for ( ; index < length; index++ ) {

			prop = props[ index ];

			Animation.tweeners[ prop ] = Animation.tweeners[ prop ] || [];

			Animation.tweeners[ prop ].unshift( callback );

		}

	},



	prefilters: [ defaultPrefilter ],



	prefilter: function( callback, prepend ) {

		if ( prepend ) {

			Animation.prefilters.unshift( callback );

		} else {

			Animation.prefilters.push( callback );

		}

	}

} );



jQuery.speed = function( speed, easing, fn ) {

	var opt = speed && typeof speed === "object" ? jQuery.extend( {}, speed ) : {

		complete: fn || !fn && easing ||

			isFunction( speed ) && speed,

		duration: speed,

		easing: fn && easing || easing && !isFunction( easing ) && easing

	};



	// Go to the end state if fx are off

	if ( jQuery.fx.off ) {

		opt.duration = 0;



	} else {

		if ( typeof opt.duration !== "number" ) {

			if ( opt.duration in jQuery.fx.speeds ) {

				opt.duration = jQuery.fx.speeds[ opt.duration ];



			} else {

				opt.duration = jQuery.fx.speeds._default;

			}

		}

	}



	// Normalize opt.queue - true/undefined/null -> "fx"

	if ( opt.queue == null || opt.queue === true ) {

		opt.queue = "fx";

	}



	// Queueing

	opt.old = opt.complete;



	opt.complete = function() {

		if ( isFunction( opt.old ) ) {

			opt.old.call( this );

		}



		if ( opt.queue ) {

			jQuery.dequeue( this, opt.queue );

		}

	};



	return opt;

};



jQuery.fn.extend( {

	fadeTo: function( speed, to, easing, callback ) {



		// Show any hidden elements after setting opacity to 0

		return this.filter( isHiddenWithinTree ).css( "opacity", 0 ).show()



			// Animate to the value specified

			.end().animate( { opacity: to }, speed, easing, callback );

	},

	animate: function( prop, speed, easing, callback ) {

		var empty = jQuery.isEmptyObject( prop ),

			optall = jQuery.speed( speed, easing, callback ),

			doAnimation = function() {



				// Operate on a copy of prop so per-property easing won't be lost

				var anim = Animation( this, jQuery.extend( {}, prop ), optall );



				// Empty animations, or finishing resolves immediately

				if ( empty || dataPriv.get( this, "finish" ) ) {

					anim.stop( true );

				}

			};

			doAnimation.finish = doAnimation;



		return empty || optall.queue === false ?

			this.each( doAnimation ) :

			this.queue( optall.queue, doAnimation );

	},

	stop: function( type, clearQueue, gotoEnd ) {

		var stopQueue = function( hooks ) {

			var stop = hooks.stop;

			delete hooks.stop;

			stop( gotoEnd );

		};



		if ( typeof type !== "string" ) {

			gotoEnd = clearQueue;

			clearQueue = type;

			type = undefined;

		}

		if ( clearQueue ) {

			this.queue( type || "fx", [] );

		}



		return this.each( function() {

			var dequeue = true,

				index = type != null && type + "queueHooks",

				timers = jQuery.timers,

				data = dataPriv.get( this );



			if ( index ) {

				if ( data[ index ] && data[ index ].stop ) {

					stopQueue( data[ index ] );

				}

			} else {

				for ( index in data ) {

					if ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {

						stopQueue( data[ index ] );

					}

				}

			}



			for ( index = timers.length; index--; ) {

				if ( timers[ index ].elem === this &&

					( type == null || timers[ index ].queue === type ) ) {



					timers[ index ].anim.stop( gotoEnd );

					dequeue = false;

					timers.splice( index, 1 );

				}

			}



			// Start the next in the queue if the last step wasn't forced.

			// Timers currently will call their complete callbacks, which

			// will dequeue but only if they were gotoEnd.

			if ( dequeue || !gotoEnd ) {

				jQuery.dequeue( this, type );

			}

		} );

	},

	finish: function( type ) {

		if ( type !== false ) {

			type = type || "fx";

		}

		return this.each( function() {

			var index,

				data = dataPriv.get( this ),

				queue = data[ type + "queue" ],

				hooks = data[ type + "queueHooks" ],

				timers = jQuery.timers,

				length = queue ? queue.length : 0;



			// Enable finishing flag on private data

			data.finish = true;



			// Empty the queue first

			jQuery.queue( this, type, [] );



			if ( hooks && hooks.stop ) {

				hooks.stop.call( this, true );

			}



			// Look for any active animations, and finish them

			for ( index = timers.length; index--; ) {

				if ( timers[ index ].elem === this && timers[ index ].queue === type ) {

					timers[ index ].anim.stop( true );

					timers.splice( index, 1 );

				}

			}



			// Look for any animations in the old queue and finish them

			for ( index = 0; index < length; index++ ) {

				if ( queue[ index ] && queue[ index ].finish ) {

					queue[ index ].finish.call( this );

				}

			}



			// Turn off finishing flag

			delete data.finish;

		} );

	}

} );



jQuery.each( [ "toggle", "show", "hide" ], function( _i, name ) {

	var cssFn = jQuery.fn[ name ];

	jQuery.fn[ name ] = function( speed, easing, callback ) {

		return speed == null || typeof speed === "boolean" ?

			cssFn.apply( this, arguments ) :

			this.animate( genFx( name, true ), speed, easing, callback );

	};

} );



// Generate shortcuts for custom animations

jQuery.each( {

	slideDown: genFx( "show" ),

	slideUp: genFx( "hide" ),

	slideToggle: genFx( "toggle" ),

	fadeIn: { opacity: "show" },

	fadeOut: { opacity: "hide" },

	fadeToggle: { opacity: "toggle" }

}, function( name, props ) {

	jQuery.fn[ name ] = function( speed, easing, callback ) {

		return this.animate( props, speed, easing, callback );

	};

} );



jQuery.timers = [];

jQuery.fx.tick = function() {

	var timer,

		i = 0,

		timers = jQuery.timers;



	fxNow = Date.now();



	for ( ; i < timers.length; i++ ) {

		timer = timers[ i ];



		// Run the timer and safely remove it when done (allowing for external removal)

		if ( !timer() && timers[ i ] === timer ) {

			timers.splice( i--, 1 );

		}

	}



	if ( !timers.length ) {

		jQuery.fx.stop();

	}

	fxNow = undefined;

};



jQuery.fx.timer = function( timer ) {

	jQuery.timers.push( timer );

	jQuery.fx.start();

};



jQuery.fx.interval = 13;

jQuery.fx.start = function() {

	if ( inProgress ) {

		return;

	}



	inProgress = true;

	schedule();

};



jQuery.fx.stop = function() {

	inProgress = null;

};



jQuery.fx.speeds = {

	slow: 600,

	fast: 200,



	// Default speed

	_default: 400

};





// Based off of the plugin by Clint Helfers, with permission.

// https://web.archive.org/web/20100324014747/http://blindsignals.com/index.php/2009/07/jquery-delay/

jQuery.fn.delay = function( time, type ) {

	time = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;

	type = type || "fx";



	return this.queue( type, function( next, hooks ) {

		var timeout = window.setTimeout( next, time );

		hooks.stop = function() {

			window.clearTimeout( timeout );

		};

	} );

};





( function() {

	var input = document.createElement( "input" ),

		select = document.createElement( "select" ),

		opt = select.appendChild( document.createElement( "option" ) );



	input.type = "checkbox";



	// Support: Android <=4.3 only

	// Default value for a checkbox should be "on"

	support.checkOn = input.value !== "";



	// Support: IE <=11 only

	// Must access selectedIndex to make default options select

	support.optSelected = opt.selected;



	// Support: IE <=11 only

	// An input loses its value after becoming a radio

	input = document.createElement( "input" );

	input.value = "t";

	input.type = "radio";

	support.radioValue = input.value === "t";

} )();





var boolHook,

	attrHandle = jQuery.expr.attrHandle;



jQuery.fn.extend( {

	attr: function( name, value ) {

		return access( this, jQuery.attr, name, value, arguments.length > 1 );

	},



	removeAttr: function( name ) {

		return this.each( function() {

			jQuery.removeAttr( this, name );

		} );

	}

} );



jQuery.extend( {

	attr: function( elem, name, value ) {

		var ret, hooks,

			nType = elem.nodeType;



		// Don't get/set attributes on text, comment and attribute nodes

		if ( nType === 3 || nType === 8 || nType === 2 ) {

			return;

		}



		// Fallback to prop when attributes are not supported

		if ( typeof elem.getAttribute === "undefined" ) {

			return jQuery.prop( elem, name, value );

		}



		// Attribute hooks are determined by the lowercase version

		// Grab necessary hook if one is defined

		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {

			hooks = jQuery.attrHooks[ name.toLowerCase() ] ||

				( jQuery.expr.match.bool.test( name ) ? boolHook : undefined );

		}



		if ( value !== undefined ) {

			if ( value === null ) {

				jQuery.removeAttr( elem, name );

				return;

			}



			if ( hooks && "set" in hooks &&

				( ret = hooks.set( elem, value, name ) ) !== undefined ) {

				return ret;

			}



			elem.setAttribute( name, value + "" );

			return value;

		}



		if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {

			return ret;

		}



		ret = jQuery.find.attr( elem, name );



		// Non-existent attributes return null, we normalize to undefined

		return ret == null ? undefined : ret;

	},



	attrHooks: {

		type: {

			set: function( elem, value ) {

				if ( !support.radioValue && value === "radio" &&

					nodeName( elem, "input" ) ) {

					var val = elem.value;

					elem.setAttribute( "type", value );

					if ( val ) {

						elem.value = val;

					}

					return value;

				}

			}

		}

	},



	removeAttr: function( elem, value ) {

		var name,

			i = 0,



			// Attribute names can contain non-HTML whitespace characters

			// https://html.spec.whatwg.org/multipage/syntax.html#attributes-2

			attrNames = value && value.match( rnothtmlwhite );



		if ( attrNames && elem.nodeType === 1 ) {

			while ( ( name = attrNames[ i++ ] ) ) {

				elem.removeAttribute( name );

			}

		}

	}

} );



// Hooks for boolean attributes

boolHook = {

	set: function( elem, value, name ) {

		if ( value === false ) {



			// Remove boolean attributes when set to false

			jQuery.removeAttr( elem, name );

		} else {

			elem.setAttribute( name, name );

		}

		return name;

	}

};



jQuery.each( jQuery.expr.match.bool.source.match( /\w+/g ), function( _i, name ) {

	var getter = attrHandle[ name ] || jQuery.find.attr;



	attrHandle[ name ] = function( elem, name, isXML ) {

		var ret, handle,

			lowercaseName = name.toLowerCase();



		if ( !isXML ) {



			// Avoid an infinite loop by temporarily removing this function from the getter

			handle = attrHandle[ lowercaseName ];

			attrHandle[ lowercaseName ] = ret;

			ret = getter( elem, name, isXML ) != null ?

				lowercaseName :

				null;

			attrHandle[ lowercaseName ] = handle;

		}

		return ret;

	};

} );









var rfocusable = /^(?:input|select|textarea|button)$/i,

	rclickable = /^(?:a|area)$/i;



jQuery.fn.extend( {

	prop: function( name, value ) {

		return access( this, jQuery.prop, name, value, arguments.length > 1 );

	},



	removeProp: function( name ) {

		return this.each( function() {

			delete this[ jQuery.propFix[ name ] || name ];

		} );

	}

} );



jQuery.extend( {

	prop: function( elem, name, value ) {

		var ret, hooks,

			nType = elem.nodeType;



		// Don't get/set properties on text, comment and attribute nodes

		if ( nType === 3 || nType === 8 || nType === 2 ) {

			return;

		}



		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {



			// Fix name and attach hooks

			name = jQuery.propFix[ name ] || name;

			hooks = jQuery.propHooks[ name ];

		}



		if ( value !== undefined ) {

			if ( hooks && "set" in hooks &&

				( ret = hooks.set( elem, value, name ) ) !== undefined ) {

				return ret;

			}



			return ( elem[ name ] = value );

		}



		if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {

			return ret;

		}



		return elem[ name ];

	},



	propHooks: {

		tabIndex: {

			get: function( elem ) {



				// Support: IE <=9 - 11 only

				// elem.tabIndex doesn't always return the

				// correct value when it hasn't been explicitly set

				// https://web.archive.org/web/20141116233347/http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/

				// Use proper attribute retrieval(#12072)

				var tabindex = jQuery.find.attr( elem, "tabindex" );



				if ( tabindex ) {

					return parseInt( tabindex, 10 );

				}



				if (

					rfocusable.test( elem.nodeName ) ||

					rclickable.test( elem.nodeName ) &&

					elem.href

				) {

					return 0;

				}



				return -1;

			}

		}

	},



	propFix: {

		"for": "htmlFor",

		"class": "className"

	}

} );



// Support: IE <=11 only

// Accessing the selectedIndex property

// forces the browser to respect setting selected

// on the option

// The getter ensures a default option is selected

// when in an optgroup

// eslint rule "no-unused-expressions" is disabled for this code

// since it considers such accessions noop

if ( !support.optSelected ) {

	jQuery.propHooks.selected = {

		get: function( elem ) {



			/* eslint no-unused-expressions: "off" */



			var parent = elem.parentNode;

			if ( parent && parent.parentNode ) {

				parent.parentNode.selectedIndex;

			}

			return null;

		},

		set: function( elem ) {



			/* eslint no-unused-expressions: "off" */



			var parent = elem.parentNode;

			if ( parent ) {

				parent.selectedIndex;



				if ( parent.parentNode ) {

					parent.parentNode.selectedIndex;

				}

			}

		}

	};

}



jQuery.each( [

	"tabIndex",

	"readOnly",

	"maxLength",

	"cellSpacing",

	"cellPadding",

	"rowSpan",

	"colSpan",

	"useMap",

	"frameBorder",

	"contentEditable"

], function() {

	jQuery.propFix[ this.toLowerCase() ] = this;

} );









	// Strip and collapse whitespace according to HTML spec

	// https://infra.spec.whatwg.org/#strip-and-collapse-ascii-whitespace

	function stripAndCollapse( value ) {

		var tokens = value.match( rnothtmlwhite ) || [];

		return tokens.join( " " );

	}





function getClass( elem ) {

	return elem.getAttribute && elem.getAttribute( "class" ) || "";

}



function classesToArray( value ) {

	if ( Array.isArray( value ) ) {

		return value;

	}

	if ( typeof value === "string" ) {

		return value.match( rnothtmlwhite ) || [];

	}

	return [];

}



jQuery.fn.extend( {

	addClass: function( value ) {

		var classes, elem, cur, curValue, clazz, j, finalValue,

			i = 0;



		if ( isFunction( value ) ) {

			return this.each( function( j ) {

				jQuery( this ).addClass( value.call( this, j, getClass( this ) ) );

			} );

		}



		classes = classesToArray( value );



		if ( classes.length ) {

			while ( ( elem = this[ i++ ] ) ) {

				curValue = getClass( elem );

				cur = elem.nodeType === 1 && ( " " + stripAndCollapse( curValue ) + " " );



				if ( cur ) {

					j = 0;

					while ( ( clazz = classes[ j++ ] ) ) {

						if ( cur.indexOf( " " + clazz + " " ) < 0 ) {

							cur += clazz + " ";

						}

					}



					// Only assign if different to avoid unneeded rendering.

					finalValue = stripAndCollapse( cur );

					if ( curValue !== finalValue ) {

						elem.setAttribute( "class", finalValue );

					}

				}

			}

		}



		return this;

	},



	removeClass: function( value ) {

		var classes, elem, cur, curValue, clazz, j, finalValue,

			i = 0;



		if ( isFunction( value ) ) {

			return this.each( function( j ) {

				jQuery( this ).removeClass( value.call( this, j, getClass( this ) ) );

			} );

		}



		if ( !arguments.length ) {

			return this.attr( "class", "" );

		}



		classes = classesToArray( value );



		if ( classes.length ) {

			while ( ( elem = this[ i++ ] ) ) {

				curValue = getClass( elem );



				// This expression is here for better compressibility (see addClass)

				cur = elem.nodeType === 1 && ( " " + stripAndCollapse( curValue ) + " " );



				if ( cur ) {

					j = 0;

					while ( ( clazz = classes[ j++ ] ) ) {



						// Remove *all* instances

						while ( cur.indexOf( " " + clazz + " " ) > -1 ) {

							cur = cur.replace( " " + clazz + " ", " " );

						}

					}



					// Only assign if different to avoid unneeded rendering.

					finalValue = stripAndCollapse( cur );

					if ( curValue !== finalValue ) {

						elem.setAttribute( "class", finalValue );

					}

				}

			}

		}



		return this;

	},



	toggleClass: function( value, stateVal ) {

		var type = typeof value,

			isValidValue = type === "string" || Array.isArray( value );



		if ( typeof stateVal === "boolean" && isValidValue ) {

			return stateVal ? this.addClass( value ) : this.removeClass( value );

		}



		if ( isFunction( value ) ) {

			return this.each( function( i ) {

				jQuery( this ).toggleClass(

					value.call( this, i, getClass( this ), stateVal ),

					stateVal

				);

			} );

		}



		return this.each( function() {

			var className, i, self, classNames;



			if ( isValidValue ) {



				// Toggle individual class names

				i = 0;

				self = jQuery( this );

				classNames = classesToArray( value );



				while ( ( className = classNames[ i++ ] ) ) {



					// Check each className given, space separated list

					if ( self.hasClass( className ) ) {

						self.removeClass( className );

					} else {

						self.addClass( className );

					}

				}



			// Toggle whole class name

			} else if ( value === undefined || type === "boolean" ) {

				className = getClass( this );

				if ( className ) {



					// Store className if set

					dataPriv.set( this, "__className__", className );

				}



				// If the element has a class name or if we're passed `false`,

				// then remove the whole classname (if there was one, the above saved it).

				// Otherwise bring back whatever was previously saved (if anything),

				// falling back to the empty string if nothing was stored.

				if ( this.setAttribute ) {

					this.setAttribute( "class",

						className || value === false ?

						"" :

						dataPriv.get( this, "__className__" ) || ""

					);

				}

			}

		} );

	},



	hasClass: function( selector ) {

		var className, elem,

			i = 0;



		className = " " + selector + " ";

		while ( ( elem = this[ i++ ] ) ) {

			if ( elem.nodeType === 1 &&

				( " " + stripAndCollapse( getClass( elem ) ) + " " ).indexOf( className ) > -1 ) {

					return true;

			}

		}



		return false;

	}

} );









var rreturn = /\r/g;



jQuery.fn.extend( {

	val: function( value ) {

		var hooks, ret, valueIsFunction,

			elem = this[ 0 ];



		if ( !arguments.length ) {

			if ( elem ) {

				hooks = jQuery.valHooks[ elem.type ] ||

					jQuery.valHooks[ elem.nodeName.toLowerCase() ];



				if ( hooks &&

					"get" in hooks &&

					( ret = hooks.get( elem, "value" ) ) !== undefined

				) {

					return ret;

				}



				ret = elem.value;



				// Handle most common string cases

				if ( typeof ret === "string" ) {

					return ret.replace( rreturn, "" );

				}



				// Handle cases where value is null/undef or number

				return ret == null ? "" : ret;

			}



			return;

		}



		valueIsFunction = isFunction( value );



		return this.each( function( i ) {

			var val;



			if ( this.nodeType !== 1 ) {

				return;

			}



			if ( valueIsFunction ) {

				val = value.call( this, i, jQuery( this ).val() );

			} else {

				val = value;

			}



			// Treat null/undefined as ""; convert numbers to string

			if ( val == null ) {

				val = "";



			} else if ( typeof val === "number" ) {

				val += "";



			} else if ( Array.isArray( val ) ) {

				val = jQuery.map( val, function( value ) {

					return value == null ? "" : value + "";

				} );

			}



			hooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];



			// If set returns undefined, fall back to normal setting

			if ( !hooks || !( "set" in hooks ) || hooks.set( this, val, "value" ) === undefined ) {

				this.value = val;

			}

		} );

	}

} );



jQuery.extend( {

	valHooks: {

		option: {

			get: function( elem ) {



				var val = jQuery.find.attr( elem, "value" );

				return val != null ?

					val :



					// Support: IE <=10 - 11 only

					// option.text throws exceptions (#14686, #14858)

					// Strip and collapse whitespace

					// https://html.spec.whatwg.org/#strip-and-collapse-whitespace

					stripAndCollapse( jQuery.text( elem ) );

			}

		},

		select: {

			get: function( elem ) {

				var value, option, i,

					options = elem.options,

					index = elem.selectedIndex,

					one = elem.type === "select-one",

					values = one ? null : [],

					max = one ? index + 1 : options.length;



				if ( index < 0 ) {

					i = max;



				} else {

					i = one ? index : 0;

				}



				// Loop through all the selected options

				for ( ; i < max; i++ ) {

					option = options[ i ];



					// Support: IE <=9 only

					// IE8-9 doesn't update selected after form reset (#2551)

					if ( ( option.selected || i === index ) &&



							// Don't return options that are disabled or in a disabled optgroup

							!option.disabled &&

							( !option.parentNode.disabled ||

								!nodeName( option.parentNode, "optgroup" ) ) ) {



						// Get the specific value for the option

						value = jQuery( option ).val();



						// We don't need an array for one selects

						if ( one ) {

							return value;

						}



						// Multi-Selects return an array

						values.push( value );

					}

				}



				return values;

			},



			set: function( elem, value ) {

				var optionSet, option,

					options = elem.options,

					values = jQuery.makeArray( value ),

					i = options.length;



				while ( i-- ) {

					option = options[ i ];



					/* eslint-disable no-cond-assign */



					if ( option.selected =

						jQuery.inArray( jQuery.valHooks.option.get( option ), values ) > -1

					) {

						optionSet = true;

					}



					/* eslint-enable no-cond-assign */

				}



				// Force browsers to behave consistently when non-matching value is set

				if ( !optionSet ) {

					elem.selectedIndex = -1;

				}

				return values;

			}

		}

	}

} );



// Radios and checkboxes getter/setter

jQuery.each( [ "radio", "checkbox" ], function() {

	jQuery.valHooks[ this ] = {

		set: function( elem, value ) {

			if ( Array.isArray( value ) ) {

				return ( elem.checked = jQuery.inArray( jQuery( elem ).val(), value ) > -1 );

			}

		}

	};

	if ( !support.checkOn ) {

		jQuery.valHooks[ this ].get = function( elem ) {

			return elem.getAttribute( "value" ) === null ? "on" : elem.value;

		};

	}

} );









// Return jQuery for attributes-only inclusion





support.focusin = "onfocusin" in window;





var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,

	stopPropagationCallback = function( e ) {

		e.stopPropagation();

	};



jQuery.extend( jQuery.event, {



	trigger: function( event, data, elem, onlyHandlers ) {



		var i, cur, tmp, bubbleType, ontype, handle, special, lastElement,

			eventPath = [ elem || document ],

			type = hasOwn.call( event, "type" ) ? event.type : event,

			namespaces = hasOwn.call( event, "namespace" ) ? event.namespace.split( "." ) : [];



		cur = lastElement = tmp = elem = elem || document;



		// Don't do events on text and comment nodes

		if ( elem.nodeType === 3 || elem.nodeType === 8 ) {

			return;

		}



		// focus/blur morphs to focusin/out; ensure we're not firing them right now

		if ( rfocusMorph.test( type + jQuery.event.triggered ) ) {

			return;

		}



		if ( type.indexOf( "." ) > -1 ) {



			// Namespaced trigger; create a regexp to match event type in handle()

			namespaces = type.split( "." );

			type = namespaces.shift();

			namespaces.sort();

		}

		ontype = type.indexOf( ":" ) < 0 && "on" + type;



		// Caller can pass in a jQuery.Event object, Object, or just an event type string

		event = event[ jQuery.expando ] ?

			event :

			new jQuery.Event( type, typeof event === "object" && event );



		// Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)

		event.isTrigger = onlyHandlers ? 2 : 3;

		event.namespace = namespaces.join( "." );

		event.rnamespace = event.namespace ?

			new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" ) :

			null;



		// Clean up the event in case it is being reused

		event.result = undefined;

		if ( !event.target ) {

			event.target = elem;

		}



		// Clone any incoming data and prepend the event, creating the handler arg list

		data = data == null ?

			[ event ] :

			jQuery.makeArray( data, [ event ] );



		// Allow special events to draw outside the lines

		special = jQuery.event.special[ type ] || {};

		if ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {

			return;

		}



		// Determine event propagation path in advance, per W3C events spec (#9951)

		// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)

		if ( !onlyHandlers && !special.noBubble && !isWindow( elem ) ) {



			bubbleType = special.delegateType || type;

			if ( !rfocusMorph.test( bubbleType + type ) ) {

				cur = cur.parentNode;

			}

			for ( ; cur; cur = cur.parentNode ) {

				eventPath.push( cur );

				tmp = cur;

			}



			// Only add window if we got to document (e.g., not plain obj or detached DOM)

			if ( tmp === ( elem.ownerDocument || document ) ) {

				eventPath.push( tmp.defaultView || tmp.parentWindow || window );

			}

		}



		// Fire handlers on the event path

		i = 0;

		while ( ( cur = eventPath[ i++ ] ) && !event.isPropagationStopped() ) {

			lastElement = cur;

			event.type = i > 1 ?

				bubbleType :

				special.bindType || type;



			// jQuery handler

			handle = (

					dataPriv.get( cur, "events" ) || Object.create( null )

				)[ event.type ] &&

				dataPriv.get( cur, "handle" );

			if ( handle ) {

				handle.apply( cur, data );

			}



			// Native handler

			handle = ontype && cur[ ontype ];

			if ( handle && handle.apply && acceptData( cur ) ) {

				event.result = handle.apply( cur, data );

				if ( event.result === false ) {

					event.preventDefault();

				}

			}

		}

		event.type = type;



		// If nobody prevented the default action, do it now

		if ( !onlyHandlers && !event.isDefaultPrevented() ) {



			if ( ( !special._default ||

				special._default.apply( eventPath.pop(), data ) === false ) &&

				acceptData( elem ) ) {



				// Call a native DOM method on the target with the same name as the event.

				// Don't do default actions on window, that's where global variables be (#6170)

				if ( ontype && isFunction( elem[ type ] ) && !isWindow( elem ) ) {



					// Don't re-trigger an onFOO event when we call its FOO() method

					tmp = elem[ ontype ];



					if ( tmp ) {

						elem[ ontype ] = null;

					}



					// Prevent re-triggering of the same event, since we already bubbled it above

					jQuery.event.triggered = type;



					if ( event.isPropagationStopped() ) {

						lastElement.addEventListener( type, stopPropagationCallback );

					}



					elem[ type ]();



					if ( event.isPropagationStopped() ) {

						lastElement.removeEventListener( type, stopPropagationCallback );

					}



					jQuery.event.triggered = 