<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Events\DiscussChatEvent;

use App\Http\Controllers\Controller;

use App\User;
use App\Exports\PostsExport;
use Auth;
use DB;

//use App\Events\ChatEvent;


class ChatController extends Controller
{
    public function index()
    {
        return view('chat');
    }


    public function sendchat(Request $request)
    {
		
		$user_info = $this->userdetails();
		$datetime = date('Y-m-d-H:i:s');
		$resdata = array();
		$msg = "Error";
		$code = 0;
        $fromusr = ($request->has('fromusr'))? (int)$request->fromusr : 0;
		if($fromusr && $request->meet_id && $request->author && $request->c_typ && $request->meet_id > 0 && $request->author!="" && $request->c_typ > 0 && $fromusr > 0)
		{
		
		 	$c_message = "";
			$c_emoji = "";
			$c_file_name = "";
			$c_file_path = "";
			
		    $usr_type = $user_info->user_type;
			$c_from = ($request->has('fromusr'))? (int)$request->fromusr : 0;
			$c_to = ($request->has('tousr'))? (int)$request->tousr : 0;
		    $c_meet_id = ($request->has('meet_id'))? (int)$request->meet_id : 0;
			$c_typ = ($request->has('c_typ'))? $request->c_typ : 0;
			$mdetaildata = $request->data;
		    $c_message = (isset($mdetaildata['text']))? $mdetaildata['text'] : "";
		    $c_emoji = (isset($mdetaildata['emoji']))? $mdetaildata['emoji'] : "";
			
			$c_file_name = "";
			$c_file_path ="";
			if(isset($mdetaildata['file']))
			{
				$fileupload = $mdetaildata['file'];
				$file_name_pre=$fileupload->getClientOriginalName();
				$c_file_name = $file_name_pre;
				
				$file_name_pre_arr = explode(".",$file_name_pre);
				$file_name_pre =$file_name_pre_arr[0];
				$file_name_pre = preg_replace("/[^a-zA-Z0-9]+/", "", $file_name_pre);
				$file_name_pre = substr($file_name_pre, 0, 30);
				$fileName = $file_name_pre."_".$c_meet_id."_".time().'.'.$request->fileup->getClientOriginalExtension();
				$fileupload->move(public_path('chatdoc'), $fileName);
				$c_file_path = url('public/chatdoc/')."/".$fileName;
				
			}
			
		    $c_view_status = 0;
			$c_created_at = ($request->has('time'))? date('Y-m-d-H:i:s',strtotime($request->time)) : $datetime;
			$c_updated_at = $c_created_at;

				
				
				if($user_info && $user_info->user_id && $user_info->user_id == $fromusr)
				{
					$check_access12 = DB::table('boards')->where('meeting_id',$c_meet_id)->first();
					
					$check_access = 0;
				if($check_access12->meeting_by == $fromusr)
				{
					$check_access = 1;
				
				}else if($usr_type==1 || $usr_type==2)
				{
					DB::enableQueryLog();
					
					
					$check_access = DB::table('attendees_request')->join('siteusers as A' ,'attendees_request.remailid','=','A.user_emailid')->where('rboardid',$c_meet_id)->where('attendees_request.ronlinestatus','1')->where('attendees_request.removedstatus','0')->where('A.user_id',$fromusr)->groupBy('A.user_id')->count();
					
					
					
				}
				else if($usr_type==3)
				{
				$check_access = DB::table('guest_request')->where('gboardid',$c_meet_id)->where('guserid',$fromusr)->where('gremovedstatus','0')->count();
				}
				
		//echo $check_access;
			if($check_access > 0)
			{
					$insdata = array();
					$insdata['usr_type'] = $usr_type;
					$insdata['c_from'] = $fromusr;
					$insdata['c_to'] = $c_to;
					$insdata['c_meet_id'] = $c_meet_id;
					$insdata['c_typ'] = $c_typ;
					$insdata['c_message'] = $c_message;
					$insdata['c_emoji'] = $c_emoji;
					$insdata['c_file_name'] = $c_file_name;
					$insdata['c_file_path'] = $c_file_path;
					$insdata['c_view_status'] = $c_view_status;
					$insdata['c_created_at'] = $c_created_at;
					$insdata['c_updated_at'] = $c_updated_at;
					
					$eventdata = array();
					
					

					$insid = DB::table('chat_message')->insertGetId($insdata);
					if($insid > 0)
					{
						

						$sendmsgrow = $this->getSinglechatArrayResp($insid);
						$resdata = $sendmsgrow;
						//$sendmsgrow_json= json_encode($sendmsgrow);
						
	try {
	
        event(new DiscussChatEvent($c_meet_id,$sendmsgrow));
    } catch (Throwable $e) {
        report($e);
        return false;
    }
 						
						
						$msg = "Success";
						$code = 1;
					}else
					{
						$msg = "Access Denied";
						$code = 0;
					}
			}else
			{
				$msg = "Access Denied for this meeting";
				$code = 0;
			}
			
			}else
			{
				$msg = "Access Denied a";
				$code = 0;
			}
			
		}
		
		$ourresponse = array("msg"=>$msg,"code"=>$code,"message"=>$resdata);
       // event(new ChatEvent($type,$author->id,$data));
	    return response()->json($ourresponse);
    }


    public function getchatdetail(Request $request)
    {
		$meet_id = $request->id;
		$touserid =$request->req;
        /*$usersqry = DB::table('users')->select('id','name');
        $usersqry->addSelect(DB::raw("'' as 'imageUrl'"));
        $users = $usersqry->get()->toArray();*/

		$user_info = $this->userdetails();
		
		$usersList = array();
		$useridarr = array();
		$usernameAssoc = array();
		
		$bar_info = DB::table('boards')->join('siteusers as A' ,'boards.meeting_by','=','A.user_id')->where('boards.meeting_id',$request->id)->first();
		
		$usersList[] = array("email"=>$bar_info->user_emailid,"id"=>$bar_info->user_id,"name"=>$bar_info->user_name." (Host)","imageUrl"=>"","user_type"=>$bar_info->user_type,"user_online"=>$bar_info->user_online);
		
		$useridarr[] = $bar_info->user_id;
		
		$participants_info_lcb = DB::table('attendees_request')->join('siteusers as A' ,'attendees_request.remailid','=','A.user_emailid')->where('rboardid',$meet_id)->where('attendees_request.ronlinestatus','1')->where('attendees_request.removedstatus','0')->where('A.user_online','1')->groupBy('A.user_id')->get();

		foreach($participants_info_lcb as $part_row)
		{
			$usersList[] = array("email"=>$part_row->user_emailid,"id"=>$part_row->user_id,"name"=>$part_row->user_name,"imageUrl"=>"","user_type"=>$part_row->user_type,"user_online"=>$part_row->user_online);
			$useridarr[] = $part_row->user_id;
		}
		// list of attendees
		// if any guest joined
			
			//$guestinfos = DB::table('siteusers')->where('user_emailid','like','%'.$rr_no.'%')->where('user_online','1')->get();
			$guestinfos = DB::table('guest_request')->join('siteusers as A' ,'guest_request.guserid','=','A.user_id')->where('gboardid',$meet_id)->where('guest_request.gonlinestatus','1')->where('guest_request.gremovedstatus','0')->where('A.user_online','1')->groupBy('A.user_id')->get();
		
		
		foreach($guestinfos as $guest_row)
		{
			$usersList[] = array("email"=>$guest_row->user_emailid,"id"=>$guest_row->user_id,"name"=>$guest_row->user_name,"imageUrl"=>"","user_type"=>$guest_row->user_type,"user_online"=>$guest_row->user_online);
			$useridarr[] = $guest_row->user_id;
		}

		if(count($useridarr) > 0)
		{
			$usernameAssoc = DB::table('siteusers')->whereIn('user_id',$useridarr)->pluck('user_name','user_id')->toArray();
		}else
		{
		
		}
		
	    $data['users'] = $usersList;
		$messageListQry = DB::table('chat_message')->where('c_meet_id',$meet_id);
		if($touserid==0)
		{
			
			
			$messageListQry->where(function($query) use ($touserid,$user_info){
				
			$query->orWhere(function($query) use ($touserid,$user_info){
				//$query->where('c_to',$touserid);
				$query->where('c_from',$user_info->user_id);
			});
			
			$query->orWhere(function($query) use ($touserid,$user_info){
				$query->where('c_to',$user_info->user_id);
				//$query->where('c_from',$touserid);
			});
			
			$query->orWhere(function($query) use ($touserid,$user_info){
				$query->where('c_to',0);
				//$query->where('c_from',$touserid);
			});
			
		});
			
			
		}else
		{
		
		$messageListQry->where(function($query) use ($touserid,$user_info){
				
			$query->orWhere(function($query) use ($touserid,$user_info){
				$query->where('c_to',$touserid);
				$query->where('c_from',$user_info->user_id);
			});
			
			$query->orWhere(function($query) use ($touserid,$user_info){
				$query->where('c_to',$user_info->user_id);
				$query->where('c_from',$touserid);
			});
			
		});
			
		}
		
		$messageList = $messageListQry->orderBy('id','asc')->get()->toArray();
		
		$messageArr = array();
		foreach($messageList as $msgRow)
		{
			$messageArr[] = $this->getSinglechatArrayResp($msgRow->id,$usernameAssoc);
		}
		$data['messages'] = $messageArr;
        return response()->json($data);
    }
	
	
	
	
	public function getSinglechatArrayResp($msgid,$usernameAssoc=array())
	{
			$user_info = $this->userdetails();
			$msgRow = DB::table('chat_message')->where('id',$msgid)->first();

			$fromusr = $msgRow->c_from;
			$tousr = $msgRow->c_to;
			$togroup = ($tousr==0)? 1 : 0;
			
			$msgdata = array();
			$filedetail = array();
			$msgid = $msgRow->id;
			$type = "";
			switch($msgRow->c_typ)
			{
			case 1:
				$type = "text";
				break;
				
			case 2:
				$type = "file";
				break;
				
			case 3:
				$type = "emoji";
				break;
				
			default:
				$type = "text";
			}

				if(array_key_exists($msgRow->c_from,$usernameAssoc))
				{
					$author = $usernameAssoc[$msgRow->c_from];
				}else
				{
					$authorRow = DB::table('siteusers')->where('user_id',$msgRow->c_from)->first();
					$author = $authorRow->user_name;
				}
				
				$toname ="";
				if($msgRow->c_to > 0)
				{
					if(array_key_exists($msgRow->c_to,$usernameAssoc))
					{
						$toname = $usernameAssoc[$msgRow->c_to];
					}else
					{
						$authorRow2 = DB::table('siteusers')->where('user_id',$msgRow->c_to)->first();
						$toname = $authorRow2->user_name;
					}
				}
				
			/*if($user_info->user_id == $msgRow->c_from)
			{
				$author = 'me';
			}else
			{
			
				if(array_key_exists($msgRow->c_from,$usernameAssoc))
				{
					$author = $usernameAssoc[$msgRow->c_from];
				}else
				{
					$authorRow = DB::table('siteusers')->where('user_id',$msgRow->c_from)->first();
					$author = $authorRow->user_name;
				}
			
			
			}*/
			
			if($msgRow->c_message!=""){	$msgdata['text'] = $msgRow->c_message; }
			if($type == "emoji"){	
			if($msgRow->c_message!=""){ 
			$msgdata['text'] = $msgRow->c_message; }
			$msgdata['emoji'] = $msgRow->c_emoji; }
			if($type == "file"){	
				if($msgRow->c_message!=""){ $filedetail['text'] = $msgRow->c_message; }
				if($msgRow->c_file_name!=""){ $filedetail['name'] = $msgRow->c_file_name; }
				if($msgRow->c_file_path!=""){ $filedetail['url'] = $msgRow->c_file_path; }
				 $msgdata['file'] = $filedetail;
			 }
			/*$msgdata['meta'] = $msgRow->c_updated_at;*/
			
			$time = $msgRow->c_updated_at;
			
			
			$singlerowresult = array('id'=>$msgid,'type'=>$type,'author'=>$author, 'toname'=>$toname, 'data'=>$msgdata,'time'=>$time,'fromusr'=>$fromusr,'tousr'=>$tousr,'togroup'=>$togroup);
			
			return $singlerowresult;
		
	}
}
