<?php $__env->startSection('style1'); ?>
<style>
.pagination {
    margin: 0;
}

.page-item .page-link {
    font-size: 14px;
    padding: 6px 12px;
    line-height: 1.5;
}

.page-item.active .page-link {
    background-color: #0d6efd;
    border-color: #0d6efd;
}
.table td,
.table thead th {
    padding: 6px 8px;   /* reduce height */
    font-size: 13px;    /* smaller text */
    white-space: nowrap;
}
.whatsapp-icon {
    font-size: 26px;
    color: #25D366;
    cursor: pointer;
    margin-left: 6px;
}

.whatsapp-icon:hover {
    color: #1ebe5d;
    transform: scale(1.1);
}

</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contentarea'); ?>
<div class="container">

    
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4>Order Management</h4>

        <div class="d-flex gap-2 align-items-center">

            
            <form method="GET"
                  action="<?php echo e(route('admin.OrderManagement-index')); ?>"
                  class="d-flex gap-2">

                <input type="text"
                       name="search"
                       value="<?php echo e(request('search')); ?>"
                       class="form-control form-control-sm"
                       placeholder="Search order / customer / phone">

                <button class="btn btn-sm btn-primary">
                    Search
                </button>

                <a href="<?php echo e(route('admin.OrderManagement-index')); ?>"
                   class="btn btn-sm btn-secondary">
                    Reset
                </a>
            </form>

            
            <a href="<?php echo e(route('admin.OrderManagement-create')); ?>"
               class="btn btn-primary">
                + New Order
            </a>
        </div>
    </div>

    
    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    
    <table class="table table-bordered table-sm">
        <thead class="table-light">
            <tr>
                <th>#</th>
                <th>Customer</th>
                <th>Phone</th>
                <th>Advance</th>
                <th>Total Amount</th>
                <th>Order Date</th>
                <th>Delivery Date</th>
                <th width="220">Action</th>
            </tr>
        </thead>

        <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><strong>Order #<?php echo e($order->order_no); ?></strong></td>

                <td><?php echo e($order->customer->name); ?></td>

                <td><?php echo e($order->customer->phone); ?></td>

                <td>₹ <?php echo e(number_format($order->advance_amount, 2)); ?></td>

                <td>
                    ₹ <?php echo e(number_format($order->items->sum('total_amount'), 2)); ?>

                </td>

                <td><?php echo e($order->created_at->format('d-m-Y')); ?></td>

                <td><?php echo e(\Carbon\Carbon::parse($order->delivery_date)->format('d-m-Y')); ?></td>

                <td>
                    <a href="<?php echo e(route('admin.OrderManagement-show', $order->id)); ?>"
                       class="btn btn-sm btn-info">
                        View
                    </a>

                    <a href="<?php echo e(route('admin.OrderManagement-edit', $order->id)); ?>"
                       class="btn btn-sm btn-warning">
                        Edit
                    </a>

                    <a href="<?php echo e(route('admin.OrderManagement-print', $order->id)); ?>"
                       target="_blank"
                       class="btn btn-sm btn-secondary">
                        Print
                    </a>

                    <form action="<?php echo e(route('admin.OrderManagement-destroy', $order->id)); ?>"
                          method="POST"
                          class="d-inline"
                          onsubmit="return confirm('Delete this order?');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>

                        <button type="submit"
                                class="btn btn-sm btn-danger">
                            Delete
                        </button>
                    </form>
                <i class="fab fa-whatsapp whatsapp-icon"
                data-phone="<?php echo e($order->customer->phone); ?>"
                data-orderno="<?php echo e($order->order_no); ?>"
                data-customer="<?php echo e($order->customer->name); ?>"
                data-orderdate="<?php echo e($order->created_at->format('d-m-Y')); ?>"
                data-delivery="<?php echo e(\Carbon\Carbon::parse($order->delivery_date)->format('d-m-Y')); ?>"
                data-total="<?php echo e(number_format($order->items->sum('total_amount'), 2)); ?>"
                data-advance="<?php echo e(number_format($order->advance_amount, 2)); ?>"
                data-balance="<?php echo e(number_format($order->items->sum('total_amount') - $order->advance_amount, 2)); ?>"
                data-cloths='<?php echo json_encode($order->items->groupBy("garment_type")->map(fn($g) => $g->sum("quantity")), 15, 512) ?>'
                data-url="<?php echo e(route('admin.OrderManagement-receiptPdf', $order->id)); ?>">
            </i>


                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="8" class="text-center text-muted">
                    No orders found
                </td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>

    
    <div class="mt-4 d-flex justify-content-center">
        <?php echo e($orders->links('pagination::bootstrap-4')); ?>

    </div>

</div>


<script>
document.addEventListener('click', function (e) {

    const icon = e.target.closest('.whatsapp-icon');
    if (!icon) return;

    let phone = icon.dataset.phone.replace(/\D/g, '');
    if (phone.length === 10) phone = '91' + phone;

    if (phone.length !== 12) {
        alert('Invalid phone number');
        return;
    }

    const orderNo   = icon.dataset.orderno;
    const customer  = icon.dataset.customer;
    const orderDate = icon.dataset.orderdate;
    const delivery  = icon.dataset.delivery;
    const total     = icon.dataset.total;
    const advance   = icon.dataset.advance;
    const balance   = icon.dataset.balance;

    const cloths = JSON.parse(icon.dataset.cloths || '{}');
    let clothText = '';
    Object.entries(cloths).forEach(([type, qty]) => {
        clothText += `${type}: ${qty}\n`;
    });

    const receiptUrl = icon.dataset.url; // 👈 PDF URL

    const message =
`Order No: ${orderNo}
Customer: ${customer}
Order Date: ${orderDate}
Delivery Date: ${delivery}
Cloths:
${clothText}
Total: ₹${total}
Advance: ₹${advance}
Balance: ₹${balance}

Receipt PDF:
${receiptUrl}`;

    const waUrl = `https://wa.me/${phone}?text=${encodeURIComponent(message)}`;

    window.open(waUrl, '_blank');
});
</script>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/cyberbahntas/tailor/resources/views/admin/order_management/list.blade.php ENDPATH**/ ?>