 

<?php $__env->startSection('contentarea'); ?>

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h4 class="mb-0">User Management</h4>
        <a href="<?php echo e(route('admin.UserManagement-create')); ?>" class="btn btn-primary">
            + Add User
        </a>
    </div>

    <div class="card-body">

        
        <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
                    <th>#ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Role</th>
                    <th>Status</th>
                    <th width="18%">Actions</th>
                </tr>
            </thead>

            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($u->id); ?></td>
                    <td><?php echo e($u->name); ?></td>
                    <td><?php echo e($u->email); ?></td>
                    <td><?php echo e($u->phone); ?></td>
                    <td>
                        <span class="badge bg-info">
                            <?php echo e(ucfirst($u->role)); ?>

                        </span>
                    </td>

                    
                    <td>
                        <button
                            class="btn btn-sm <?php echo e($u->status ? 'btn-success' : 'btn-danger'); ?>"
                            onclick="toggleStatus(<?php echo e($u->id); ?>)">
                            <?php echo e($u->status ? 'Active' : 'Inactive'); ?>

                        </button>
                    </td>

                    
                    <td>
                        <a href="<?php echo e(route('admin.UserManagement-edit', $u->id)); ?>"
                           class="btn btn-sm btn-warning">
                            Edit
                        </a>

                        <button
                            type="button"
                            class="btn btn-sm btn-danger"
                            onclick="deleteUser(<?php echo e($u->id); ?>)">
                            Delete
                        </button>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="text-center text-muted">
                        No users found
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>

    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script1'); ?>
<script>
/* 🗑 DELETE USER */
function deleteUser(id) {

    if (!confirm("Are you sure you want to delete this user?")) return;

    fetch("<?php echo e(url('/admin/UserManagement')); ?>/" + id, {
        method: "DELETE",
        headers: {
            "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>"
        }
    })
    .then(res => res.json())
    .then(res => {
        if (res.success) {
            location.reload();
        } else {
            alert("Delete failed");
        }
    })
    .catch(() => alert("Server error"));
}

/* 🔄 TOGGLE STATUS */
function toggleStatus(id) {

    fetch("<?php echo e(url('/admin/users/status')); ?>/" + id, {
        method: "POST",
        headers: {
            "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>"
        }
    })
    .then(res => res.json())
    .then(res => {
        location.reload();
    })
    .catch(() => alert("Server error"));
}
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/cyberbahntas/tailor/resources/views/admin/user_management/list.blade.php ENDPATH**/ ?>