  <!DOCTYPE html>
<html>
<head>
    <title>Order #<?php echo e($order->order_no); ?></title>

    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10.5px;
            line-height: 1.25;
        }

        h3 {
            font-size: 12px;
            margin: 4px 0;
        }

        .line {
            border-bottom: 1px dashed #000;
            margin: 4px 0;
        }

        .tear {
            border-top: 2px dashed #000;
            margin: 10px 0;
            text-align: center;
            font-size: 9px;
            color: #555;
        }

        .measure {
            font-size: 10px;
        }

        /* ================= ROW-WISE INFO TABLE ================= */
        .info-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 10.5px;
            margin-bottom: 4px;
        }

        .info-table td {
            width: 33%;
            padding: 2px 4px;
            white-space: nowrap;
            vertical-align: top;
        }

        /* ================= IMAGES ================= */
        .images {
            display: flex;
            gap: 6px;
            margin: 6px 0;
            flex-wrap: wrap;
        }

        .images img {
            width: 80px;
            height: 80px;
            object-fit: cover;
            border: 1px solid #000;
            padding: 2px;
        }

        @media print {
            body { margin: 5mm; }
        }
        /* ===== TWO COLUMN PRINT LAYOUT ===== */
.two-col {
    display: grid;
    grid-template-columns: 1fr 1fr; /* ONLY 2 columns */
    gap: 6px 12px;
    width: 100%;
    font-size: 10.5px;
}

.col-block {
    display: block;
}

.row-item {
    display: flex;
    gap: 4px;
    white-space: nowrap;
}

.row-item b {
    min-width: 80px;
}
/* ===== INLINE MEASUREMENTS ===== */
.measure-row {
    display: flex;
    flex-wrap: wrap;     /* wraps only if page ends */
    gap: 8px;
    font-size: 10px;
    margin-top: 4px;
}

.measure-row span {
    white-space: nowrap;
}

    </style>
</head>

<body onload="window.print()">
<?php
    // Shirt type saved from form (adjust key if needed)
    $shirtType = $measurements['shirt_type'] ?? null;

    // Sleeve-specific keys
    $halfSleeveKeys = [
        'half_kai_uyaram',
        'half_kai_munda',
        'half_kai_munaikai',
    ];

    $fullSleeveKeys = [
        'full_kai_uyaram',
        'full_kai_munaikai',
        'full_kai_munda',
        'full_kai_kappu',
    ];
?>

<?php
if (!function_exists('formatFraction')) {
    function formatFraction($value) {
        if (!$value) return '-';

        if (is_array($value)) {
            $value = implode(', ', $value);
        }

        return str_replace(
            [' 1/4', ' 1/2', ' 3/4'],
            ['¼', '½', '¾'],
            $value
        );
    }
}
?>



<?php
$labels = [

    /* ===== BASIC ===== */
    'height' => 'Height / உயரம்',
    'body' => 'Body / உடல்',

    /* ===== SHOULDER & SLEEVE ===== */
    'thol_pattai' => 'Shoulder Strap / தோள் பட்டை',
    'kai_height' => 'Sleeve Height / கை உயரம்',

    /* ===== HALF SLEEVE ===== */
    'half_kai_uyaram' => 'Half Sleeve Length / அரை கை உயரம்',
    'half_kai_munda' => 'Half Sleeve Munda / அரை கை முன்டா',
    'half_kai_munaikai' => 'Half Sleeve Munaikai / அரை கை முனைக்கை',

    /* ===== FULL SLEEVE ===== */
    'full_kai_uyaram' => 'Full Sleeve Length / முழு கை உயரம்',
    'full_kai_munaikai' => 'Full Sleeve Munaikai / முழு கை முனைக்கை',
    'full_kai_munda' => 'Full Sleeve Munda / முழு கை முன்டா',
    'full_kai_kappu' => 'Full Sleeve Cuff / முழு கை கப்பு',

    /* ===== SIDE LOOSE ===== */
    'side_loose_1' => 'Side Loose 1 / பக்கம் லூஸ் 1',
    'side_loose_2' => 'Side Loose 2 / பக்கம் லூஸ் 2',
    'side_loose_3' => 'Side Loose 3 / பக்கம் லூஸ் 3',

    /* ===== COLLAR & CUFF ===== */
    'collar' => 'Collar / காலர்',
    'kappu' => 'Cuff / கப்பு',

    /* ===== STYLE ===== */
    'front_9' => 'Front Style / முன் வடிவம்',
    'model' => 'Model / மாடல்',

    /* ===== POCKET ===== */
    'pocket' => 'Pocket / பாக்கெட்',
];
?>



<h3>🧾 CUSTOMER COPY</h3>

<?php
    $item = $order->items->first();

    $images = [];
    if ($item && $item->reference_image) {
        $images = is_string($item->reference_image)
            ? json_decode($item->reference_image, true)
            : $item->reference_image;
    }
    if (!is_array($images)) $images = [];
?>

<div class="single-row">
    <span><b>Order No</b> : <?php echo e($order->order_no); ?></span>
    <span>| <b>Customer</b> : <?php echo e($order->customer->name); ?></span>
    <span>| <b>Phone</b> : <?php echo e($order->customer->phone); ?></span>
    <span>| <b>Order Date</b> : <?php echo e($order->created_at->format('d-m-Y')); ?></span>
    <span>| <b>Delivery</b> : <?php echo e(\Carbon\Carbon::parse($order->delivery_date)->format('d-m-Y')); ?></span>
    <span>| <b>Item</b> : <?php echo e($item->garment_type); ?></span>
    <span>| <b>Qty</b> : <?php echo e($item->quantity); ?></span>
    <span>|<b>Total</b> : ₹ <?php echo e(number_format($order->items->sum('total_amount'), 2)); ?></span>
    <span>|<b>Advance</b> : ₹ <?php echo e(number_format($order->advance_amount, 2)); ?></span>
    <?php if(count($images)): ?>
        <div class="images">
            <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <img src="<?php echo e(asset('storage/app/public/'.$img)); ?>">
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>
</div>

<div class="tear">✂ Tear Here</div>


<h3>👨‍🔧 TAILOR COPY</h3>

<?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

<?php
    $images = [];
    if ($item->reference_image) {
        $images = is_string($item->reference_image)
            ? json_decode($item->reference_image, true)
            : $item->reference_image;
    }
    if (!is_array($images)) $images = [];
?>

<div class="single-row">
    <span><b>Order No</b> : <?php echo e($order->order_no); ?></span>
    <span>| <b>Customer</b> : <?php echo e($order->customer->name); ?></span>
    <span>| <b>Delivery</b> : <?php echo e(\Carbon\Carbon::parse($order->delivery_date)->format('d-m-Y')); ?></span>
    <span>| <b>Item</b> : <?php echo e($item->garment_type); ?></span>
    <span>| <b>Profile</b> : <?php echo e($item->profile->profile_name ?? '-'); ?></span>
    <span>| <b>Qty</b> : <?php echo e($item->quantity); ?></span>
    <span>|</span>
 <?php
    $measurements = $item->measurement->measurements ?? [];
    if (is_string($measurements)) {
        $measurements = json_decode($measurements, true);
    }
?>

<div class="measure-row">
<?php $__currentLoopData = $measurements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php if(!$value): ?>
        <?php continue; ?>
    <?php endif; ?>

    
    <?php if($shirtType === 'Full / முழு கை' && in_array($key, $halfSleeveKeys)): ?>
        <?php continue; ?>
    <?php endif; ?>

    
    <?php if($shirtType === 'Half / அரை கை' && in_array($key, $fullSleeveKeys)): ?>
        <?php continue; ?>
    <?php endif; ?>

    <span>
        <b><?php echo e($labels[$key] ?? ucfirst(str_replace('_',' ', $key))); ?></b>
        : <?php echo e(formatFraction($value)); ?>

    </span>

    <?php if(!$loop->last): ?>
        <span>|</span>
    <?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>


    <?php if(count($images)): ?>
        <div class="images">
            <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <img src="<?php echo e(asset('storage/app/public/'.$img)); ?>">
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>
</div>




<div class="line"></div>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



</body>
</html>
<?php /**PATH /home/bwjqfxmy/public_html/cyberbahntas/tailor/resources/views/admin/order_management/print.blade.php ENDPATH**/ ?>