 
<?php $__env->startSection('contentarea'); ?>
<div class="container">
    <h3>Customer Management</h3>

    <a href="<?php echo e(route('admin.CustomerManagement-create')); ?>" class="btn btn-primary mb-3">
        + Add Customer
    </a>

<form method="GET"
      action="<?php echo e(route('admin.CustomerManagement-index')); ?>"
      class="row mb-3">

    <div class="col-md-4">
        <input type="text"
               name="search"
               value="<?php echo e($search); ?>"
               class="form-control"
               placeholder="Search by name or phone">
    </div>

    <div class="col-md-2">
        <button class="btn btn-primary">
            Search
        </button>

        <a href="<?php echo e(route('admin.CustomerManagement-index')); ?>"
           class="btn btn-secondary">
            Reset
        </a>
    </div>
</form>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>SNo</th>
                <th>Name</th>
                <th>Phone</th>
                 <th>Email</th>
                <th>Address</th>
                <th>VIP</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($loop->iteration); ?></td>
                <td><?php echo e($customer->name); ?></td>
                <td><?php echo e($customer->phone); ?></td>
                <td><?php echo e($customer->email); ?></td>
                <td><?php echo e($customer->address); ?></td>
                <td>
                    <?php if($customer->is_vip): ?>
                        <span class="badge bg-success">VIP</span>s
                    <?php else: ?>
                        <span class="badge bg-secondary">Regular</span>
                    <?php endif; ?>
                </td>
                <td>
                    <a href="<?php echo e(route('admin.CustomerManagement-edit', $customer)); ?>" class="btn btn-sm btn-warning">Edit</a>
                        <a href="<?php echo e(route('admin.CustomerManagement-show', $customer)); ?>" class="btn btn-sm btn-warning">show</a>

                <form action="<?php echo e(route('admin.CustomerManagement-destroy', $customer->id)); ?>"
                    method="POST"
                    class="d-inline"
                    onsubmit="return confirm('Are you sure?')">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>

                    <button type="submit" class="btn btn-danger btn-sm">
                        Delete
                    </button>
                </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>


</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/cyberbahntas/tailor/resources/views/admin/customer_management/list.blade.php ENDPATH**/ ?>