<?php $__env->startSection('style1'); ?>
<style>
.form-control,
.form-select {
    font-size: 13px;
    padding: 6px 8px;
}

.table-sm td,
.table-sm th {
    padding: 6px 8px;
    font-size: 13px;
}

.measure-label {
    width: 45%;
    font-weight: 500;
    background: #f8f9fa;
}

.garment-box {
    border: 1px solid #dee2e6;
    border-radius: 6px;
    padding: 12px;
    margin-bottom: 14px;
    background: #fff;
}

.garment-title {
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 8px;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contentarea'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-10 col-xl-9">

<h4 class="mb-3">Edit Order #<?php echo e($order->order_no ?? $order->id); ?></h4>

<form method="POST" action="<?php echo e(route('admin.OrderManagement-update', $order->id)); ?>">
<?php echo csrf_field(); ?>
<?php echo method_field('PUT'); ?>

<div class="row g-2 mb-3">
    <div class="col-md-6">
        <label class="form-label mb-1">Customer</label>
        <select class="form-select" name="customer_id">
            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($customer->id); ?>"
                    <?php echo e($order->customer_id == $customer->id ? 'selected' : ''); ?>>
                    <?php echo e($customer->name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <div class="col-md-3">
        <label class="form-label mb-1">Advance</label>
        <input type="number"
               class="form-control"
               name="advance_amount"
               value="<?php echo e($order->advance_amount); ?>">
    </div>

    <div class="col-md-3">
        <label class="form-label mb-1">Delivery Date</label>
        <input type="date"
               class="form-control"
               name="delivery_date"
               value="<?php echo e($order->delivery_date); ?>">
    </div>
</div>

<?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="garment-box">
    <div class="garment-title">
        <?php echo e(ucfirst($item->garment_type)); ?>

        <span class="text-muted fw-normal">
            (Profile: <?php echo e($item->profile->profile_name ?? '-'); ?>)
        </span>
    </div>

    <table class="table table-sm table-bordered">
        <?php $__currentLoopData = $item->measurement->measurements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td class="measure-label">
                <?php echo e($measurementLabels[$key] ?? ucfirst(str_replace('_',' ',$key))); ?>

            </td>
            <td>
                <input type="text"
                       class="form-control form-control-sm"
                       name="items[<?php echo e($item->id); ?>][measurements][<?php echo e($key); ?>]"
                       value="<?php echo e($value); ?>">
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<div class="text-end mt-3">
    <button class="btn btn-primary">
        Update Order
    </button>
</div>

</form>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/cyberbahntas/tailor/resources/views/admin/order_management/edit.blade.php ENDPATH**/ ?>