<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>Log In | Siva Tailor Madurai</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description" />
    <meta content="Coderthemes" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="{{ asset('public/admin_assets/images/siva-logo.png') }}">


    <!-- Theme Config Js -->
    <script src="{{ asset('public/admin_assets/js/hyper-config.js') }}"></script>

    <!-- Vendor css -->
    <link href="{{ asset('public/admin_assets/css/vendor.min.css') }}" rel="stylesheet" type="text/css" />

    <!-- App css -->
    <link href="{{ asset('public/admin_assets/css/app-saas.min.css') }}" rel="stylesheet" type="text/css" id="app-style" />

    <!-- Icons css -->
    <link href="{{ asset('public/admin_assets/css/icons.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('public/admin_assets/our_plugin/toastr/toastr.css') }}" rel="stylesheet">

    <style>

        .error {
                color:red;
                font-size: larger;
                font-weight: 400;

            }
            </style>
</head>

<body class="authentication-bg position-relative">
    <div class="position-absolute start-0 end-0 start-0 bottom-0 w-100 h-100">
        <svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%' viewBox='0 0 800 800'>
            <g fill-opacity='0.22'>
                <circle style="fill: rgba(var(--ct-primary-rgb), 0.1);" cx='400' cy='400' r='600' />
                <circle style="fill: rgba(var(--ct-primary-rgb), 0.2);" cx='400' cy='400' r='500' />
                <circle style="fill: rgba(var(--ct-primary-rgb), 0.3);" cx='400' cy='400' r='300' />
                <circle style="fill: rgba(var(--ct-primary-rgb), 0.4);" cx='400' cy='400' r='200' />
                <circle style="fill: rgba(var(--ct-primary-rgb), 0.5);" cx='400' cy='400' r='100' />
            </g>
        </svg>
    </div>
    <div class="account-pages pt-2 pt-sm-5 pb-4 pb-sm-5 position-relative">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-4 col-lg-5">
                    <div class="card">

                        <!-- Logo -->
                        <div class="card-header py-4 text-center bg-primary">
                            <a href="index.html">
                                <span><img src="{{ asset('public/admin_assets/images/siva-logo.png') }}" alt="logo" height="100px"></span>
                            </a>
                        </div>

                        <div class="card-body p-4">

                            <div class="text-center w-75 m-auto">
                                <h4 class="text-dark-50 text-center pb-0 fw-bold">Sign In</h4>
                                <p class="text-muted mb-4">Enter your Mobile Number and password to access admin panel.</p>
                            </div>

                            <form action="{{ route('login') }}" method="POST" name="login_form" id="login_form">
                                @csrf

                                <div class="mb-3">
                                    <label for="phone" class="form-label">Mobile Number</label>
                                    <input class="form-control" type="text" name="phone" id="phone" required="" placeholder="Enter your Mobile Number">
                                </div>

                                <div class="mb-3">
                                    <a href="pages-recoverpw.html" class="text-muted float-end"><small>Forgot your password?</small></a>
                                    <label for="password" class="form-label">Password</label>
                                    <div class="input-group input-group-merge">
                                        <input type="password" name="password" id="password"class="form-control" placeholder="Enter your password">

                                    </div>
                                </div>

                                <div class="mb-3 mb-0 text-center">
                                    <button class="btn btn-warning" type="submit"> Log In </button>
                                </div>

                            </form>
                        </div> <!-- end card-body -->
                    </div>
                    <!-- end card -->

                </div> <!-- end col -->
            </div>
            <!-- end row -->
        </div>
        <!-- end container -->
    </div>
    <!-- end page -->

    <footer class="footer footer-alt">

        <script>document.write(new Date().getFullYear())</script> © SivaTailorMadurai
    </footer>
    <!-- Vendor js -->

    <script src="{{ asset('public/admin_assets/js/vendor.min.js') }}"></script>

    <!-- App js -->

    <script src="{{ asset('public/admin_assets/js/app.min.js') }}"></script>

    <!-- Validate js -->

    <script src="{{ asset('public/admin_assets/our_plugin/validate/jquery.validate.js') }}"></script>

    <script src="{{ asset('public/admin_assets/our_plugin/validate/additional-methods.js') }}"></script>

    <script src="{{ asset('public/admin_assets/our_plugin/validate/my_validator.js') }}"></script>

        <!-- toastr js -->

    <script src="{{ asset('public/admin_assets/our_plugin/toastr/toastr.min.js') }}"></script>

        <script>
            $(document).ready(function() {


                $('#login_form').validate({

                    rules: {
                        phone: {
                            required: true,
                            number:true,
                            nohtml: true,
                        },
                        password: {
                            required: true,
                            nohtml: true,
                        },

                    },
                    messages: {
                        phone: {
                            required: "Please enter mobile number",
                            number:"Please enter correct mobile number"
                        },
                        password: {
                            required: "Please enter password"
                        }
                    },

                   ignore: [],

                   errorPlacement: function(error, element) {
        if (element.attr("name") === "password") {
            error.insertAfter(element.closest('.input-group'));
        } else {
            error.insertAfter(element);
        }
    },
    success: function(label, element) {
        $(element).removeClass('error').addClass('valid');
        $(label).remove();
    },

                });





            });
        </script>

</body>


</html>
