
@extends('admin.layout.adminmaster')

@section('style1')


<style>

    .error {
            color:red;
            font-size: 20px;
            font-weight: 400;
    
        }
   
    </style>

@endsection

@section('contentarea')

<div id="selectPicker" class="mb-5">
    <h4>New Vehicle</h4>
    <div class="card">
    <div class="card-body pb-2">
    <form action="{{ route('admin.VehicleManagement-store') }}"method="POST" enctype="multipart/form-data" name="vehicle_form" id="vehicle_form">
    @csrf

    
    <div class="row g-2">
        <div class="mb-3 col-md-4">
    <label for="car_brand" class="form-label">Car Brand</label>
    <select class="form-select" id="car_brand" name="car_brand">
        <option value="">--Select CarBrand--</option>

        @foreach($get_carbrand as $carbrand)
        <option value={{ $carbrand->id}}>{{ $carbrand->brand_name}}</option>
        @endforeach
        
    </select>
   </div>
   <div class="mb-3 col-md-4">
    <label for="car_model" class="form-label">Car Model</label>
        <input type="text" id="car_model" name="car_model" class="form-control">
   </div>

   <div class="mb-3 col-md-4">
    <label for="car_type" class="form-label">Car Type</label>
    <select class="form-select" id="car_type" name="car_type">
        <option value="">--Select CarType--</option>

        @foreach($get_cartype as $cartype)
        <option value={{$cartype->id}}>{{$cartype->car_type}}</option>
        @endforeach
        
    </select>
   </div>
</div>

    <div class="row g-2">


        <div class="mb-3 col-md-6">
            <label for="fuel_type" class="form-label">Fuel Type</label>
            <select class="form-select" id="fuel_type" name="fuel_type">
                <option value="">--Select FuelType--</option>             
                <option value="petrol">Petrol</option>
                <option value="diesel">Diesel</option>
                <option value="electric">Electric</option>
                <option value="CNG">CNG</option>            
            </select>
        </div>

        <div class="mb-3 col-md-6">
            <label for="seat_capacity" class="form-label">Seat Capacity</label>
            <input class="form-control" type="text" id="seat_capacity"  name="seat_capacity">
        </div>
                 
    </div>

    <div class="row g-2">
        <div class="mb-3 col-md-6">
            <label for="inputState" class="form-label">Status</label>
            <select id="inputState" class="form-select" name="status">
              <option value="">---Select Status--</option>
                    <option value="1">Enable</option>
                    <option value="0">Disable</option>
            </select>        
           </div>
    </div>

                
              
                
    <a href="{{ route('admin.VehicleManagement-index') }}" class="btn btn-dark mb-1">BACK</a>
    {{-- <button type="submit" style="float:right"class="btn btn-outline-theme">SAVE</button> --}}

    <input type="submit" style="float:right"class="btn btn-warning" value="SAVE">
        
    </div>
                
    </form>

    
    </div>
    
   
    </div>
    </div>

@endsection

@section('script1')
<script src="{{ asset('public/admin_assets/js/jquery.min.js') }}"></script>
<script>
    $(document).ready(function() {


    $("#vehicle_form").validate({
        rules: {
            car_brand: {
                required: true,
            },
           
            car_model: {
                required: true,
            },

            fuel_type: {
                required: true,
                
            },
            seat_capacity: {
                required: true,
                digits: true,
                maxlength: 2,
            },
           
        },
        messages: {
            car_brand: {
                required: "Please select a car brand"
            },
            car_model: {
                required: "Car model is required"
            },
           
            fuel_type: {
                required: "Please select a fuel type",
                
            },
            seat_capacity: {
                required: "Seat capacity is required",
                digits: "Only digits are allowed",
                maxlength: "Seat capacity must be 2 digits"
            },
            
        },
        errorElement: 'div',
        errorClass: 'invalid-feedback',
        highlight: function(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function(element) {
            $(element).removeClass('is-invalid');
        },
        errorPlacement: function(error, element) {
            if (element.parent('.input-group').length) {
                error.insertAfter(element.parent());
            } else {
                error.insertAfter(element);
            }
        }
    });

       
        
      
});


            //     phone: {
            //         required: true,
            //         nohtml: true,
            //         minlength: 10,
            //         maxlength: 10,
            //         number:true,
            //         remote: {
			// 					url: "{{ route('admin.check-phone') }}",
			// 					type: "post",
			// 					data: {
			// 							 _token: '{{ csrf_token() }}',										
			// 							 phone: function() {
			// 								return $("#user #phone").val();
			// 								},
			// 						 },
			// 				}
			// 		},

          
            // messages: {
                
            //     phone : {
			// 		  remote:'This Mobile number is already registered',
			// 		},
            //         'user_roles[]':{
            //         required: 'select the user type. ', 
            //     },
            // },

           





   
</script>


@endsection



@section('script2')
              

@endsection