 @extends('admin.layout.adminmaster')

@section('style1')
<style>
.containerbutton {
    display: flex;
    margin-bottom: 10px;
}
.prodName {
    font-size: 16px;
}
</style>
@endsection

@section('contentarea')

<div id="borderedTable" class="mb-5">

    <div class="containerbutton">
        <h4>User Details</h4>
    </div>

    <div class="card">
        <div class="card-body">

            <a href="{{ route('admin.UserManagement-index') }}"
               class="btn btn-dark mb-2 float-end">
                BACK
            </a>

            <table class="table table-bordered" style="width:100%;">
                <tbody>

                    <tr>
                        <td width="30%">User Name</td>
                        <th>{{ $getRow->name }}</th>
                    </tr>

                    <tr>
                        <td>User Email</td>
                        <th>{{ $getRow->email }}</th>
                    </tr>

                    <tr>
                        <td>Phone</td>
                        <th>{{ $getRow->phone }}</th>
                    </tr>

                    <tr>
                        <td>Role</td>
                        <th>
                            <span class="badge bg-info">
                                {{ ucfirst($getRow->role) }}
                            </span>
                        </th>
                    </tr>

                    {{-- 🔐 MANAGEMENT ACCESS --}}
                    <tr>
                        <td>Management Access</td>
                        <th>
                            @if(!empty($getRow->permissions))
                                <ul class="mb-0">
                                    @foreach($getRow->permissions as $perm)
                                        <li>{{ ucwords(str_replace('_',' ', $perm)) }}</li>
                                    @endforeach
                                </ul>
                            @else
                                <span class="text-muted">No permissions assigned</span>
                            @endif
                        </th>
                    </tr>

                    <tr>
                        <td>Status</td>
                        <th>
                            @if($getRow->status)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-danger">Inactive</span>
                            @endif
                        </th>
                    </tr>

                </tbody>
            </table>

        </div>
    </div>

</div>

@endsection
