 @extends('admin.layout.adminmaster')

@section('contentarea')

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h4 class="mb-0">User Management</h4>
        <a href="{{ route('admin.UserManagement-create') }}" class="btn btn-primary">
            + Add User
        </a>
    </div>

    <div class="card-body">

        {{-- SUCCESS MESSAGE --}}
        @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif

        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
                    <th>#ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Role</th>
                    <th>Status</th>
                    <th width="18%">Actions</th>
                </tr>
            </thead>

            <tbody>
                @forelse ($users as $u)
                <tr>
                    <td>{{ $u->id }}</td>
                    <td>{{ $u->name }}</td>
                    <td>{{ $u->email }}</td>
                    <td>{{ $u->phone }}</td>
                    <td>
                        <span class="badge bg-info">
                            {{ ucfirst($u->role) }}
                        </span>
                    </td>

                    {{-- STATUS --}}
                    <td>
                        <button
                            class="btn btn-sm {{ $u->status ? 'btn-success' : 'btn-danger' }}"
                            onclick="toggleStatus({{ $u->id }})">
                            {{ $u->status ? 'Active' : 'Inactive' }}
                        </button>
                    </td>

                    {{-- ACTIONS --}}
                    <td>
                        <a href="{{ route('admin.UserManagement-edit', $u->id) }}"
                           class="btn btn-sm btn-warning">
                            Edit
                        </a>

                        <button
                            type="button"
                            class="btn btn-sm btn-danger"
                            onclick="deleteUser({{ $u->id }})">
                            Delete
                        </button>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="text-center text-muted">
                        No users found
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>

    </div>
</div>

@endsection

@section('script1')
<script>
/* 🗑 DELETE USER */
function deleteUser(id) {

    if (!confirm("Are you sure you want to delete this user?")) return;

    fetch("{{ url('/admin/UserManagement') }}/" + id, {
        method: "DELETE",
        headers: {
            "X-CSRF-TOKEN": "{{ csrf_token() }}"
        }
    })
    .then(res => res.json())
    .then(res => {
        if (res.success) {
            location.reload();
        } else {
            alert("Delete failed");
        }
    })
    .catch(() => alert("Server error"));
}

/* 🔄 TOGGLE STATUS */
function toggleStatus(id) {

    fetch("{{ url('/admin/users/status') }}/" + id, {
        method: "POST",
        headers: {
            "X-CSRF-TOKEN": "{{ csrf_token() }}"
        }
    })
    .then(res => res.json())
    .then(res => {
        location.reload();
    })
    .catch(() => alert("Server error"));
}
</script>
@endsection

